<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($g30EA) { return ModelUtil::get('member_user', array('id' => $g30EA)); } public static function getCached($g30EA) { return Cache::remember('MemberUser:' . $g30EA, 60, function () use($g30EA) { return self::get($g30EA); }); } public static function processDefault(&$NqfF9) { goto nBPEN; LmPjA: if (empty($NqfF9['nickname'])) { $NqfF9['nickname'] = $NqfF9['username']; } goto rGhtx; rGhtx: if (empty($NqfF9['avatar'])) { $NqfF9['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto ObviK; ObviK: if (empty($NqfF9['avatarMedium'])) { $NqfF9['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto a5J6C; nBPEN: if (empty($NqfF9)) { return; } goto LmPjA; a5J6C: if (empty($NqfF9['avatarBig'])) { $NqfF9['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto t2Eoc; t2Eoc: } private static function processBasicFields($wL0zT) { goto Wsxmp; Wsxmp: $mi460 = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto Wc_gB; xxKBb: return $wL0zT; goto iC2sn; Wc_gB: if (null === $wL0zT) { $wL0zT = $mi460; } else { goto gI9pU; tSFqa: foreach ($wL0zT as $yHNo7) { if ('<basic>' == $yHNo7) { $pH2w_ = array_merge($pH2w_, $mi460); } else { $pH2w_[] = $yHNo7; } } goto SrUxH; SrUxH: $wL0zT = $pH2w_; goto r9m9C; gI9pU: $pH2w_ = array(); goto tSFqa; r9m9C: } goto xxKBb; iC2sn: } public static function fixAvatar($qCM9P) { return AssetsUtil::fixFullOrDefault($qCM9P, 'asset/image/avatar.svg'); } public static function getBasic($g30EA, $wL0zT = null) { goto d578N; PMtDf: $VBrBE = self::get($g30EA); goto e91T_; IYT3_: $VBrBE['avatar'] = self::fixAvatar($VBrBE['avatar']); goto SntXO; d578N: $wL0zT = self::processBasicFields($wL0zT); goto PMtDf; SntXO: $SFOuH = array(); goto t0kEf; e91T_: if (empty($VBrBE)) { return null; } goto pAi5c; pAi5c: if (empty($VBrBE['nickname'])) { $VBrBE['nickname'] = $VBrBE['username']; } goto IYT3_; t0kEf: foreach ($wL0zT as $S9Yo_) { if (isset($VBrBE[$S9Yo_])) { $SFOuH[$S9Yo_] = $VBrBE[$S9Yo_]; } else { $SFOuH[$S9Yo_] = null; } } goto UAWUE; UAWUE: return $SFOuH; goto sfWfu; sfWfu: } public static function listViewName($mXTYA) { goto u1JHG; u1JHG: $dGPVB = array(); goto WCLXB; VH3Mb: return $dGPVB; goto P22wS; eqiDg: foreach ($w9RZE as $NqfF9) { $dGPVB[] = self::viewName($NqfF9); } goto VH3Mb; WCLXB: $w9RZE = ModelUtil::allIn('member_user', 'id', $mXTYA); goto eqiDg; P22wS: } public static function listUsers($mXTYA) { return ModelUtil::allIn('member_user', 'id', $mXTYA); } public static function convertOneToBasic($NqfF9) { return array('id' => $NqfF9['id'], 'username' => $NqfF9['username'], 'nickname' => empty($NqfF9['nickname']) ? $NqfF9['username'] : $NqfF9['nickname'], 'created_at' => $NqfF9['created_at'], 'signature' => isset($NqfF9['signature']) ? $NqfF9['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($NqfF9['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($w9RZE) { return array_map(function ($VBrBE) { return array('id' => $VBrBE['id'], 'username' => $VBrBE['username'], 'nickname' => empty($VBrBE['nickname']) ? $VBrBE['username'] : $VBrBE['nickname'], 'created_at' => $VBrBE['created_at'], 'signature' => isset($VBrBE['signature']) ? $VBrBE['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($VBrBE['avatar'], 'asset/image/avatar.svg')); }, $w9RZE); } public static function listUsersBasic($mXTYA) { return self::convertToBasic(self::listUsers($mXTYA)); } public static function getViewName($g30EA) { return self::viewName(self::get($g30EA)); } public static function viewName($NqfF9) { goto Iq1BY; bvoFm: return "ID-{$NqfF9['id']}"; goto Y8xCn; Iq1BY: if ($NqfF9 && is_numeric($NqfF9)) { return self::getViewName($NqfF9); } goto FioOj; gZX25: if (!empty($NqfF9['nickname'])) { return $NqfF9['nickname']; } goto ReKIX; ReKIX: if (!empty($NqfF9['username'])) { return $NqfF9['username']; } goto bvoFm; FioOj: if (empty($NqfF9)) { return '-'; } goto gZX25; Y8xCn: } public static function update($g30EA, $rZTKT) { return ModelUtil::update('member_user', array('id' => $g30EA), $rZTKT); } public static function updateBasicWithUniqueCheck($g30EA, $rZTKT) { goto AJPom; dhmCX: self::update($g30EA, $rZTKT); goto R3Bte; pa88i: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $qUCtR => $hA0e1) { if (isset($rZTKT[$qUCtR])) { goto PuyL1; knUyr: if (count($HGZDE) == 1) { if ($HGZDE[0]['id'] != $g30EA) { return Response::generate(-1, $hA0e1 . '重复'); } } goto U7XF6; eCe6d: $HGZDE = ModelUtil::all('member_user', array($qUCtR => $rZTKT[$qUCtR])); goto mPSf3; PuyL1: if (empty($rZTKT[$qUCtR])) { $rZTKT[$qUCtR] = null; continue; } goto eCe6d; mPSf3: if (count($HGZDE) > 1) { return Response::generate(-1, $hA0e1 . '重复'); } goto knUyr; U7XF6: } } goto dhmCX; R3Bte: return Response::generate(0, 'ok'); goto EPXK2; AJPom: if (empty($rZTKT)) { return Response::generate(0, 'ok'); } goto pa88i; EPXK2: } public static function login($oiaRD = '', $fvVxv = '', $XqlmS = '', $JZ06B = '') { goto ya5s_; zluT4: if (!$JZ06B) { return Response::generate(-2, '密码为空'); } goto Bz7sd; hbSvy: if (empty($NqfF9)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto rhMPs; SVcOt: if (!($XqlmS || $fvVxv || $oiaRD)) { return Response::generate(-1, '所有登录字段均为空'); } goto zluT4; me24Z: $NqfF9 = ModelUtil::get('member_user', $IhSeg); goto hbSvy; ya5s_: $XqlmS = trim($XqlmS); goto C1uV_; FK7h2: switch ($NqfF9['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto mOW0Q; mOW0Q: return Response::generateSuccessData($NqfF9); goto pCVgL; ZSwLv: if ($NqfF9['password'] != EncodeUtil::md5WithSalt($JZ06B, $NqfF9['passwordSalt'])) { MemberUserLoginFailedEvent::fire($NqfF9['id'], $NqfF9['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto FK7h2; C1uV_: $fvVxv = trim($fvVxv); goto ckDy5; rhMPs: MemberUserLoginAttemptEvent::fire($NqfF9['id'], Request::ip(), AgentUtil::getUserAgent()); goto ZSwLv; Bz7sd: if ($XqlmS) { if (!FormatUtil::isEmail($XqlmS)) { return Response::generate(-3, '邮箱格式不正确'); } $IhSeg = array('email' => $XqlmS); } else { if ($fvVxv) { if (!preg_match('/(^1[0-9]{10}$)/', $fvVxv)) { return Response::generate(-4, '手机格式不正确'); } $IhSeg = array('phone' => $fvVxv); } else { if ($oiaRD) { if (strpos($oiaRD, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $IhSeg = array('username' => $oiaRD); } } } goto me24Z; ckDy5: $oiaRD = trim($oiaRD); goto SVcOt; pCVgL: } public static function autoSetUsernameNickname($id94O, $QVF7n) { goto CgdE2; pRiPW: self::suggestUsernameNickname($id94O, $QVF7n, $LtjNz); goto jND6x; CgdE2: $LtjNz = 6; goto ZP3Rl; ZP3Rl: if (preg_match('/\\{.*\\}/', $QVF7n)) { goto TwDFQ; TwDFQ: $NqfF9 = self::get($id94O); goto dwPAQ; dwPAQ: $jor2k = array('{Phone}' => $NqfF9['phone'], '{Phone4}' => substr($NqfF9['phone'], 7), '{Uid}' => $NqfF9['id']); goto kHrY0; kHrY0: $QVF7n = str_replace(array_keys($jor2k), array_values($jor2k), $QVF7n); goto aguFc; aguFc: $LtjNz = 0; goto BSD5a; BSD5a: } goto pRiPW; jND6x: } public static function getSuggestUsernameNickname($l8ixd) { goto fzqFA; dS3Ba: for ($ED43L = 0; $ED43L < 20; $ED43L++) { $J6U4y = ModelUtil::model('member_user')->where(array('username' => $QVF7n))->orWhere(array('nickname' => $QVF7n))->first(); if (empty($J6U4y)) { return $QVF7n; } $QVF7n = $QVF7n . Str::random(1); } goto SCF04; fzqFA: $QVF7n = $l8ixd . Str::random(1); goto dS3Ba; SCF04: return $QVF7n . Str::random(10); goto UPP_3; UPP_3: } private static function suggestUsernameNickname($id94O, $q0a2s = '用户', $LtjNz = 6) { goto JAdka; JAdka: if ($LtjNz > 0) { $QVF7n = $q0a2s . RandomUtil::string($LtjNz); } else { $QVF7n = $q0a2s; } goto mk5TC; mk5TC: for ($ED43L = 0; $ED43L < 20; $ED43L++) { $J6U4y = ModelUtil::model('member_user')->where(array('username' => $QVF7n))->orWhere(array('nickname' => $QVF7n))->first(); if (empty($J6U4y)) { break; } $QVF7n = $QVF7n . Str::random(1); } goto VFX4G; VFX4G: ModelUtil::update('member_user', $id94O, array('username' => $QVF7n, 'nickname' => $QVF7n)); goto NvZhX; NvZhX: } public static function registerId($g30EA, $rZTKT = array()) { $NqfF9 = ModelUtil::insert('member_user', array_merge(array('id' => $g30EA, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $rZTKT)); return Response::generate(0, 'ok', $NqfF9); } public static function registerUsername($oiaRD) { return self::register($oiaRD, '', '', '', true); } public static function registerUsernameQuick($oiaRD) { goto W58rR; t8kqg: return Response::generateError('注册失败'); goto EE533; W58rR: $Lxmgu = $oiaRD; goto tQvys; tQvys: for ($ED43L = 0; $ED43L < 10; $ED43L++) { $O2HCC = self::register($Lxmgu, '', '', '', true); if ($O2HCC['code']) { $Lxmgu = $Lxmgu . Str::random(1); } else { return $O2HCC; } } goto t8kqg; EE533: } public static function register($oiaRD = '', $fvVxv = '', $XqlmS = '', $JZ06B = '', $h6FHg = false) { goto jjHeu; mAShE: if (!($XqlmS || $fvVxv || $oiaRD)) { return Response::generate(-1, '所有注册字段均为空'); } goto sRy9Y; ldzO9: if (!$h6FHg) { if (empty($JZ06B) || strlen($JZ06B) < 6) { return Response::generate(-3, '密码不合法'); } } goto hZwKs; ti3RA: $fvVxv = trim($fvVxv); goto UEZ1b; J5Zjf: $NqfF9 = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $oiaRD, 'email' => $XqlmS, 'phone' => $fvVxv, 'password' => $h6FHg ? null : EncodeUtil::md5WithSalt($JZ06B, $Ot1xv), 'passwordSalt' => $h6FHg ? null : $Ot1xv, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto tR2Iw; PTGLD: if ($fvVxv) { $O2HCC = self::uniqueCheck('phone', $fvVxv); if ($O2HCC['code']) { return $O2HCC; } } else { $fvVxv = null; } goto eKpTb; UEZ1b: $oiaRD = trim($oiaRD); goto mAShE; jjHeu: $XqlmS = trim($XqlmS); goto ti3RA; tR2Iw: return Response::generate(0, 'ok', $NqfF9); goto oDtCp; sRy9Y: if ($XqlmS) { $O2HCC = self::uniqueCheck('email', $XqlmS); if ($O2HCC['code']) { return $O2HCC; } } else { $XqlmS = null; } goto PTGLD; hZwKs: $Ot1xv = Str::random(16); goto J5Zjf; eKpTb: if ($oiaRD) { goto pzqud; aNC_r: if (strlen($oiaRD) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto SftT4; pzqud: $O2HCC = self::uniqueCheck('username', $oiaRD); goto ndgjU; Fw3NP: if (preg_match('/^[0-9]{11}$/', $oiaRD)) { return Response::generate(-1, '用户名不能为纯数字'); } goto pjHIX; ndgjU: if ($O2HCC['code']) { return $O2HCC; } goto aNC_r; SftT4: if (Str::contains($oiaRD, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto Fw3NP; pjHIX: } else { $oiaRD = null; } goto ldzO9; oDtCp: } public static function uniqueCheck($PHNQB, $nRHgX, $Xy8lK = 0) { goto wHWun; AmO1U: if ($Xy8lK == $NqfF9['id']) { return Response::generate(0, 'ok'); } goto ILh2f; wHWun: $nRHgX = trim($nRHgX); goto ZHRmh; aEJCK: if (empty($NqfF9)) { return Response::generate(0, 'ok'); } goto B6XOz; B6XOz: $bKM27 = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto AmO1U; ILh2f: return Response::generate(-2, $bKM27[$PHNQB] . '已经被占用'); goto Dd2Sr; BJNNt: $NqfF9 = ModelUtil::get('member_user', array($PHNQB => $nRHgX)); goto aEJCK; ZHRmh: switch ($PHNQB) { case 'email': if (!FormatUtil::isEmail($nRHgX)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $nRHgX)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($nRHgX, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $PHNQB); } goto BJNNt; Dd2Sr: } public static function getByUsername($oiaRD) { return ModelUtil::get('member_user', array('username' => $oiaRD)); } public static function getByEmail($XqlmS) { return ModelUtil::get('member_user', array('email' => $XqlmS)); } public static function getByPhone($fvVxv) { return ModelUtil::get('member_user', array('phone' => $fvVxv)); } public static function changeNickname($id94O, $EueDr) { goto o7rT3; xPYvk: if (Response::isError($O2HCC)) { return $O2HCC; } goto Jxikx; Jxikx: ModelUtil::update('member_user', $id94O, array('nickname' => $EueDr)); goto qtxvA; o7rT3: $O2HCC = self::uniqueCheck('nickname', $EueDr, $id94O); goto xPYvk; qtxvA: return Response::generate(0, 'ok'); goto Nhnze; Nhnze: } public static function changePassword($id94O, $rly0Y, $Z8KEk = null, $Eelzc = false) { goto Zu7bz; cRvRm: return Response::generate(0, 'ok'); goto XjohP; SvXTg: ModelUtil::update('member_user', array('id' => $NqfF9['id']), array('passwordSalt' => $Ot1xv, 'password' => EncodeUtil::md5WithSalt($rly0Y, $Ot1xv))); goto cRvRm; CXQZO: if (empty($NqfF9)) { return Response::generate(-1, '用户不存在'); } goto IY03u; Zu7bz: if (!$Eelzc && empty($Z8KEk)) { return Response::generate(-1, '旧密码不能为空'); } goto U4njq; IY03u: if (empty($rly0Y)) { return Response::generate(-1, '新密码为空'); } goto yXvxp; VKFzK: $Ot1xv = Str::random(16); goto SvXTg; U4njq: $NqfF9 = ModelUtil::get('member_user', array('id' => $id94O)); goto CXQZO; yXvxp: if (!$Eelzc && EncodeUtil::md5WithSalt($Z8KEk, $NqfF9['passwordSalt']) != $NqfF9['password']) { return Response::generate(-1, '旧密码不正确'); } goto VKFzK; XjohP: } public static function setAvatar($UGF3W, $pGhWv, $ebdqm = 'jpg') { goto EK46m; qDtdE: return Response::generateSuccess(); goto rOAPL; y_jk8: if ($O2HCC['code']) { goto Qo3Gy; Qo3Gy: DataManager::deleteById($wih3U['data']['id']); goto mLS4d; heIsU: if ($wih3U['code']) { return Response::generate(-1, '头像存储失败（' . $O2HCC['msg'] . '）'); } goto Ti4fJ; mLS4d: DataManager::deleteById($mjyaj['data']['id']); goto heIsU; Ti4fJ: } goto wFHAl; EK46m: if (!in_array($ebdqm, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto tAjAQ; cFqj4: if ($mjyaj['code']) { DataManager::deleteById($wih3U['data']['id']); if ($wih3U['code']) { return Response::generate(-1, '头像存储失败（' . $mjyaj['msg'] . '）'); } } goto doyKT; IKk4O: $iCxgY = (string) Image::make($pGhWv)->resize(400, 400)->encode($ebdqm, 75); goto Tq_1v; Tq_1v: $meEqU = (string) Image::make($pGhWv)->resize(200, 200)->encode($ebdqm, 75); goto bISFF; hrfhR: if ($wih3U['code']) { return Response::generate(-1, '头像存储失败（' . $wih3U['msg'] . '）'); } goto JyRvJ; JwlYo: if (empty($NqfF9)) { return Response::generate(-1, '用户不存在'); } goto KcJnP; KcJnP: if (empty($pGhWv)) { return Response::generate(-1, '图片数据为空'); } goto IKk4O; eSw07: $wih3U = DataManager::upload('image', 'U' . $UGF3W . '_AvatarBig.' . $ebdqm, $iCxgY, null, $KlCn0); goto hrfhR; bISFF: $dnBy2 = (string) Image::make($pGhWv)->resize(50, 50)->encode($ebdqm, 75); goto WEs9E; JyRvJ: $mjyaj = DataManager::upload('image', 'U' . $UGF3W . '_AvatarMiddle.' . $ebdqm, $meEqU, null, $KlCn0); goto cFqj4; tAjAQ: $NqfF9 = self::get($UGF3W); goto JwlYo; doyKT: $O2HCC = DataManager::upload('image', 'U_' . $UGF3W . '_Avatar.' . $ebdqm, $dnBy2, null, $KlCn0); goto y_jk8; WEs9E: $KlCn0 = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto eSw07; wFHAl: self::update($NqfF9['id'], array('avatarBig' => $wih3U['data']['fullPath'], 'avatarMedium' => $mjyaj['data']['fullPath'], 'avatar' => $O2HCC['data']['fullPath'])); goto qDtdE; rOAPL: } public static function findUsers($t8igG) { goto svlNp; svlNp: if (empty($t8igG)) { return array(); } goto rDHny; OmLd7: return $Ocj8a; goto QoRKk; noNSw: foreach ($w9RZE as &$b4lB5) { $Ocj8a[$b4lB5->id] = $b4lB5->toArray(); } goto OmLd7; IgiHc: $w9RZE = ModelUtil::model('member_user')->whereIn('id', $t8igG)->get(); goto noNSw; rDHny: $Ocj8a = array(); goto IgiHc; QoRKk: } public static function filterUserIds($t8igG) { goto uyT6Z; qK6cS: $jor2k = array(); goto z1ZHi; HxOu1: foreach ($w9RZE as &$b4lB5) { $jor2k[$b4lB5->id] = true; } goto z1l0t; uyT6Z: if (empty($t8igG)) { return array(); } goto qK6cS; z1ZHi: $w9RZE = ModelUtil::model('member_user')->whereIn('id', $t8igG)->get(array('id')); goto HxOu1; z1l0t: return array_keys($jor2k); goto nVa6B; nVa6B: } public static function mergeMemberUsers(&$jfXj_, $aKaMp = 'memberUserId', $xCkKc = '_memberUser') { ModelUtil::join($jfXj_, $aKaMp, $xCkKc, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$jfXj_, $aKaMp = 'memberUserId', $xCkKc = '_memberUser', $wL0zT = null) { $wL0zT = self::processBasicFields($wL0zT); if (is_array($jfXj_)) { ModelUtil::join($jfXj_, $aKaMp, $xCkKc, 'member_user', 'id'); foreach ($jfXj_ as $yHNo7 => $I7oOV) { goto nvUgq; zX2Hq: if (empty($NqfF9['nickname'])) { $NqfF9['nickname'] = $NqfF9['username']; } goto b8tu4; y1w_Z: $NqfF9 = ArrayUtil::keepKeys($I7oOV[$xCkKc], $wL0zT); goto zX2Hq; nvUgq: if (empty($I7oOV[$xCkKc])) { continue; } goto y1w_Z; guSHa: $jfXj_[$yHNo7][$xCkKc] = $NqfF9; goto Ie9Ko; b8tu4: if (empty($NqfF9['avatar'])) { $NqfF9['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $NqfF9['avatar'] = AssetsUtil::fixFull($NqfF9['avatar']); } goto guSHa; Ie9Ko: } } else { ModelUtil::joinItems($jfXj_, $aKaMp, $xCkKc, 'member_user', 'id'); foreach ($jfXj_ as $VBrBE) { goto ZTPjv; Km78s: if (empty($NqfF9['avatar'])) { $NqfF9['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $NqfF9['avatar'] = AssetsUtil::fixFull($NqfF9['avatar']); } goto b9vtJ; a9Nkl: $NqfF9 = ArrayUtil::keepKeys($VBrBE->{$xCkKc}, $wL0zT); goto CBtr7; b9vtJ: $VBrBE->{$xCkKc} = $NqfF9; goto Ao2U5; CBtr7: if (empty($NqfF9['nickname'])) { $NqfF9['nickname'] = $NqfF9['username']; } goto Km78s; ZTPjv: if (empty($VBrBE->{$xCkKc})) { continue; } goto a9Nkl; Ao2U5: } } } public static function insert($rZTKT) { return ModelUtil::insert('member_user', $rZTKT); } public static function getIdByOauth($B3RVP, $KF_MP) { goto q1Ki4; q1Ki4: $XYknV = ModelUtil::get('member_oauth', array('type' => $B3RVP, 'openId' => $KF_MP)); goto Euigg; qGHt2: return intval($XYknV['memberUserId']); goto r84fa; Euigg: if (empty($XYknV)) { return 0; } goto qGHt2; r84fa: } public static function getIdByOauthAndCheck($B3RVP, $KF_MP) { goto wQ8oc; BvA27: if (self::get($id94O)) { return $id94O; } goto Ti7Tb; wQ8oc: $id94O = self::getIdByOauth($B3RVP, $KF_MP); goto BvA27; bdELZ: return 0; goto SflOO; Ti7Tb: MemberUtil::forgetOauth($B3RVP, $KF_MP); goto bdELZ; SflOO: } public static function getOauthOpenId($id94O, $B3RVP) { goto IF_os; Krqo8: return $XYknV['openId']; goto pl6sO; vYdeo: if (empty($XYknV)) { return null; } goto Krqo8; FAjrG: $XYknV = ModelUtil::get('member_oauth', $IhSeg); goto vYdeo; IF_os: $IhSeg = array('memberUserId' => $id94O, 'type' => $B3RVP); goto FAjrG; pl6sO: } public static function getOauth($id94O, $B3RVP) { $IhSeg = array('memberUserId' => $id94O, 'type' => $B3RVP); return ModelUtil::get('member_oauth', $IhSeg); } public static function listOauths($id94O) { return ModelUtil::all('member_oauth', array('memberUserId' => $id94O), array('*'), array('type', 'asc')); } public static function putOauth($id94O, $B3RVP, $KF_MP, $UlC3P = array()) { goto CBszd; CBszd: $IhSeg = array('memberUserId' => $id94O, 'type' => $B3RVP); goto aZK82; nkCtt: $XYknV = ModelUtil::get('member_oauth', $IhSeg); goto zVn43; zVn43: $RVZb8 = array_merge(array('openId' => $KF_MP), $UlC3P); goto TOCyy; TOCyy: if (empty($XYknV)) { ModelUtil::delete('member_oauth', array('type' => $B3RVP, 'openId' => $KF_MP)); ModelUtil::insert('member_oauth', array_merge($IhSeg, $RVZb8)); } else { if ($XYknV['openId'] != $KF_MP) { ModelUtil::update('member_oauth', $XYknV['id'], $RVZb8); } } goto nsqn7; aZK82: $lYv6Z = "MemberOauth:{$id94O}"; goto BVQ85; BVQ85: if (!LockUtil::acquire($lYv6Z)) { BizException::throws('正在处理中，请稍后再试'); } goto nkCtt; nsqn7: LockUtil::release($lYv6Z); goto T4SpA; T4SpA: } public static function forgetOauth($B3RVP, $KF_MP) { ModelUtil::delete('member_oauth', array('type' => $B3RVP, 'openId' => $KF_MP)); } public static function updateNewMessageStatus($id94O) { ModelUtil::update('member_user', array('id' => $id94O), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $id94O, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($id94O) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $id94O), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $id94O)))); } } public static function paginate($E2yS6, $GA5mT, $QJqee = array()) { return ModelUtil::paginate('member_user', $E2yS6, $GA5mT, $QJqee); } public static function updateStatus($CCuh2, $zXf8M) { goto YV91V; YV91V: if (!is_array($CCuh2)) { $CCuh2 = array($CCuh2); } goto udG2o; udG2o: if (empty($CCuh2)) { return; } goto wEfMD; wEfMD: ModelUtil::model('member_user')->whereIn('id', $CCuh2)->update(array('status' => $zXf8M)); goto klcHt; klcHt: } public static function delete($id94O) { goto IpSBG; IpSBG: $NqfF9 = self::get($id94O); goto FUfKT; pTumc: $BHi03 = array(); goto itwBm; dX0G6: ModelUtil::transactionCommit(); goto RCWau; aR9LM: ModelUtil::update('member_user', $id94O, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto dX0G6; FUfKT: BizException::throwsIfEmpty('用户不存在', $NqfF9); goto wIXrs; JWODc: ModelUtil::insert('member_deleted', array('id' => $NqfF9['id'], 'username' => $NqfF9['username'], 'phone' => $NqfF9['phone'], 'email' => $NqfF9['email'], 'content' => json_encode($BHi03, JSON_UNESCAPED_UNICODE))); goto aR9LM; xd_k4: $BHi03['oauth'] = ArrayUtil::keepItemsKeys($n6f1a, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto JWODc; wIXrs: ModelUtil::transactionBegin(); goto pTumc; itwBm: $n6f1a = ModelUtil::all('member_oauth', array('memberUserId' => $NqfF9['id'])); goto xd_k4; RCWau: } public static function fireLogin($id94O) { goto Zi49K; Zi49K: $e6R2A = Request::ip(); goto v0OEK; v0OEK: ModelUtil::update('member_user', $id94O, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($e6R2A, 20))); goto sN2UO; sN2UO: ModelUtil::insert('member_login_log', array('memberUserId' => $id94O, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($e6R2A, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto DfQYD; DfQYD: } }