<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $Rbzjz) { $Rbzjz->init('member_user')->field(function ($Rbzjz) { $Rbzjz->id('id', 'ID'); MemberAdminList::callGridField($Rbzjz); $Rbzjz->display('avatar', '头像')->hookRendering(function (AbstractField $qUCtR, $VBrBE, $doMHk) { $Pz3I9 = AssetsUtil::fixOrDefault($VBrBE->avatar, 'asset/image/avatar.svg'); $Di4LM = AssetsUtil::fixOrDefault($VBrBE->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$Di4LM}' class='tw-inline-block' data-image-preview>\n                        <img src='{$Pz3I9}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $Rbzjz->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $qUCtR, $VBrBE, $doMHk) { switch ($qUCtR->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($VBrBE->username), modstart_admin_url('member/show', array('_id' => $VBrBE->id)))->width('90%')->height('90%')->render()); break; } }); $Rbzjz->text('email', '邮箱'); $Rbzjz->text('phone', '手机'); $Rbzjz->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $Rbzjz->display('_oauth', '授权')->hookRendering(function (AbstractField $qUCtR, $VBrBE, $doMHk) { $yXgX4 = array(); $xVOXP = MemberUtil::listOauths($VBrBE->id); foreach ($xVOXP as $rTKU7) { goto TZmIe; usH7A: $rcnpI = MemberOauth::getByOauthKey($rTKU7['type']); goto bwkVy; mt9Y3: if (empty($cXvv6)) { $cXvv6 = ColorUtil::pick($rTKU7['type']); } goto TmEiE; mvhNc: $L2Vae = $rTKU7['type']; goto usH7A; TmEiE: $yXgX4[] = '<a style="color:' . $cXvv6 . ';" href="javascript:;" data-tip-popover="' . $L2Vae . '"><i class="iconfont icon-dot"></i></a>'; goto CqAaO; TZmIe: $cXvv6 = null; goto mvhNc; bwkVy: if ($rcnpI) { $cXvv6 = $rcnpI->color(); $L2Vae = $rcnpI->title(); } goto mt9Y3; CqAaO: } return join('', $yXgX4); }); } $Rbzjz->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $p2mEP = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($p2mEP) { $Rbzjz->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $n07sQ = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($n07sQ) { $Rbzjz->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $Rbzjz->date('vipExpire', 'VIP过期'); } $Rbzjz->display('registerIp', '注册IP'); $Rbzjz->display('created_at', '注册时间'); $Rbzjz->canBatchSelect(true); $Rbzjz->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $Y2vrA) { $Y2vrA->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $Y2vrA) { $Y2vrA->eq('id', L('ID')); $Y2vrA->like('username', '用户名'); $Y2vrA->like('email', '邮箱')->autoHide(true); $Y2vrA->like('phone', '手机')->autoHide(true); $Y2vrA->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $Y2vrA->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $Y2vrA->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $F28q5) { $VBrBE = $F28q5->item(); $F28q5->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $VBrBE->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $E2yS6) { goto nJQ7_; hEeVX: $sfVug->showSubmit(false)->showReset(false); goto VJAdQ; VJAdQ: return $E2yS6->pageTitle('创建用户')->body($sfVug)->handleForm($sfVug, function (Form $sfVug) { AdminPermission::demoCheck(); $rZTKT = $sfVug->dataForming(); $oiaRD = !empty($rZTKT['username']) ? $rZTKT['username'] : null; $fvVxv = !empty($rZTKT['phone']) ? $rZTKT['phone'] : null; $XqlmS = !empty($rZTKT['email']) ? $rZTKT['email'] : null; $Faiq1 = ArrayUtil::keepKeys($rZTKT, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $O2HCC = MemberUtil::register($oiaRD, $fvVxv, $XqlmS, $rZTKT['password']); BizException::throwsIfResponseError($O2HCC); if (!empty($Faiq1)) { if (isset($Faiq1['vipExpire']) && TimeUtil::isDateEmpty($Faiq1['vipExpire'])) { $Faiq1['vipExpire'] = null; } MemberUtil::update($O2HCC['data']['id'], $Faiq1); } EventUtil::fire(new MemberUserRegisteredEvent($O2HCC['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto s_o8E; nJQ7_: $sfVug = Form::make(''); goto L4AaY; VBY9O: $sfVug->layoutPanel('高级', function (Form $sfVug) { $sfVug->text('nickname', '昵称'); $sfVug->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $sfVug->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $sfVug->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $sfVug->date('vipExpire', 'VIP过期'); } }); goto hEeVX; L4AaY: $sfVug->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $sfVug) { $sfVug->text('username', '用户名'); $sfVug->text('phone', '手机'); $sfVug->text('email', '邮箱'); $sfVug->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto VBY9O; s_o8E: } public function edit(AdminDialogPage $E2yS6) { goto e4Trh; l1RJ8: if (Request::isPost()) { goto tZ8k0; tZ8k0: AdminPermission::demoCheck(); goto wFACL; ibcuU: switch ($TW8tK->getTrimString('_action')) { case 'itemCellEdit': goto QrAGj; e60A9: return Response::generateSuccess(); goto WczNE; LCrIM: if (!empty($RVZb8)) { MemberUtil::update($NqfF9['id'], $RVZb8); } goto e60A9; QrAGj: $RVZb8 = array(); goto zJ116; zJ116: switch ($TW8tK->getTrimString('column')) { case 'status': $RVZb8['status'] = $TW8tK->getInteger('value'); break; } goto LCrIM; WczNE: } goto U0hp9; wFACL: $TW8tK = InputPackage::buildFromInput(); goto ibcuU; U0hp9: } goto biGmQ; hXqoj: $sfVug->layoutPanel('高级', function (Form $sfVug) { $sfVug->text('nickname', '昵称'); $sfVug->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $sfVug->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $sfVug->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $sfVug->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto Ugp6s; FXiMm: $sfVug->layoutPanel('基础', function (Form $sfVug) { $sfVug->display('id', '用户ID')->addable(true); $sfVug->text('username', '用户名'); $sfVug->text('phone', '手机'); $sfVug->text('email', '邮箱'); }); goto hXqoj; dhPhT: BizException::throwsIfEmpty('用户不存在', $NqfF9); goto l1RJ8; PGHRC: $sfVug->showSubmit(false)->showReset(false); goto QIoNK; biGmQ: $sfVug = Form::make(''); goto FXiMm; QIoNK: return $E2yS6->pageTitle('修改信息')->body($sfVug)->handleForm($sfVug, function (Form $sfVug) use($NqfF9) { AdminPermission::demoCheck(); $rZTKT = $sfVug->dataForming(); $EDJb_ = ArrayUtil::keepKeys($rZTKT, array('username', 'phone', 'email')); $Faiq1 = ArrayUtil::keepKeys($rZTKT, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $O2HCC = MemberUtil::updateBasicWithUniqueCheck($NqfF9['id'], $EDJb_); BizException::throwsIfResponseError($O2HCC); if (isset($Faiq1['vipExpire']) && TimeUtil::isDateEmpty($Faiq1['vipExpire'])) { $Faiq1['vipExpire'] = null; } MemberUtil::update($NqfF9['id'], $Faiq1); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto LLlT7; Ugp6s: $sfVug->item($NqfF9)->fillFields(); goto PGHRC; e4Trh: $NqfF9 = ModelUtil::get('member_user', CRUDUtil::id()); goto dhPhT; LLlT7: } public function select(AdminDialogPage $E2yS6) { goto sKEud; U6Qva: CRUDUtil::registerGridResource($G_ae0, '\\' . __CLASS__); goto OvPgk; rx8E1: $G_ae0->canSingleSelectItem(true); goto U6Qva; OvPgk: if (Request::isPost()) { return $G_ae0->request(); } goto S9ZBq; sKEud: $G_ae0 = $this->grid(); goto ESC7N; S9ZBq: return $E2yS6->pageTitle('选择用户')->body($G_ae0); goto iViVT; ESC7N: $G_ae0->disableCUD(); goto rx8E1; iViVT: } public function search() { goto kZhX8; xj2I6: $QJqee = array(); goto Uhgwx; Z3wqI: return Response::jsonSuccessData($jfXj_); goto fI2xq; xNVzR: $jfXj_ = array_map(function ($VBrBE) { return array('value' => intval($VBrBE['id']), 'name' => htmlspecialchars(MemberUtil::viewName($VBrBE)), 'avatar' => AssetsUtil::fixOrDefault($VBrBE['avatar'], 'asset/image/avatar.svg')); }, $Qn8kG['records']); goto Z3wqI; BYEw1: $Qn8kG = MemberUtil::paginate(1, 10, $QJqee); goto xNVzR; kZhX8: $TW8tK = InputPackage::buildFromInput(); goto G1Cfi; G1Cfi: $f9WWy = $TW8tK->getTrimString('keywords'); goto xj2I6; Uhgwx: $QJqee['whereOperate'] = array('username', 'like', "%{$f9WWy}%"); goto BYEw1; fI2xq: } public function resetPassword(AdminConfigBuilder $Rbzjz) { goto Koaxq; c1hYm: $Rbzjz->pageTitle('重置密码'); goto meq4X; llSSJ: $Rbzjz->useDialog(); goto c1hYm; ceF3w: $NqfF9 = MemberUtil::get($g30EA); goto vfPEh; Koaxq: $g30EA = CRUDUtil::id(); goto ceF3w; D9XHM: return $Rbzjz; goto QvDyY; vfPEh: BizException::throwsIfEmpty('用户不存在', $NqfF9); goto llSSJ; of6K0: if (Request::isPost()) { return $Rbzjz->formRequest(function (Form $sfVug) use($NqfF9) { AdminPermission::demoCheck(); $rZTKT = $sfVug->dataForming(); $O2HCC = MemberUtil::changePassword($NqfF9['id'], $rZTKT['passwordNew'], null, true); BizException::throwsIfResponseError($O2HCC); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto D9XHM; meq4X: $Rbzjz->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto of6K0; QvDyY: } public function sendMessage(AdminConfigBuilder $Rbzjz) { goto CIITh; w2J6U: BizException::throwsIfEmpty('用户不存在', $NqfF9); goto C6kOm; C6kOm: $Rbzjz->useDialog(); goto bBdoP; bv2dV: return $Rbzjz; goto hn4fv; bBdoP: $Rbzjz->pageTitle('发送消息'); goto RnssZ; sxY6m: $NqfF9 = MemberUtil::get($g30EA); goto w2J6U; CIITh: $g30EA = CRUDUtil::id(); goto sxY6m; RnssZ: $Rbzjz->richHtml('content', '消息内容')->required(); goto Qv5x1; Qv5x1: if (Request::isPost()) { return $Rbzjz->formRequest(function (Form $sfVug) use($NqfF9) { AdminPermission::demoCheck(); $rZTKT = $sfVug->dataForming(); $O2HCC = MemberMessageUtil::send($NqfF9['id'], $rZTKT['content']); BizException::throwsIfResponseError($O2HCC); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto bv2dV; hn4fv: } public function show() { goto AalQi; sBnQV: $nAiIx = MemberAdminShowPanelProvider::listAll(); goto eh8Tz; AalQi: $POM2f = MemberUtil::get(CRUDUtil::id()); goto sBnQV; eh8Tz: return view('module::Member.View.admin.memberUser.show', array('record' => $POM2f, 'showPanelProviders' => $nAiIx)); goto U6irv; U6irv: } public function delete() { goto JbdJR; BSnjt: return Response::redirect(CRUDUtil::jsGridRefresh()); goto N1yjd; JbdJR: AdminPermission::demoCheck(); goto tuP8L; tuP8L: MemberUtil::delete(CRUDUtil::id()); goto BSnjt; N1yjd: } public function statusForbidden() { goto Zovz6; p91BO: return Response::redirect(CRUDUtil::jsGridRefresh()); goto laZ4H; Zovz6: AdminPermission::demoCheck(); goto sArGe; sArGe: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto p91BO; laZ4H: } public function export(ExportHandle $vCfWl) { $obwyS = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $vCfWl->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($obwyS)->handleFetch(function ($E2yS6, $GA5mT, $NrK6H, $hpjZO) { $KF1bZ = ModelUtil::model('member_user'); $KF1bZ = $KF1bZ->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($NrK6H as $Kb26X) { if (!empty($Kb26X['id']['eq'])) { $KF1bZ = $KF1bZ->where('id', $Kb26X['id']['eq']); } elseif (!empty($Kb26X['status']['eq'])) { $KF1bZ = $KF1bZ->where('status', $Kb26X['status']['eq']); } elseif (!empty($Kb26X['groupId']['eq'])) { $KF1bZ = $KF1bZ->where('groupId', $Kb26X['groupId']['eq']); } elseif (!empty($Kb26X['vipId']['eq'])) { $KF1bZ = $KF1bZ->where('vipId', $Kb26X['vipId']['eq']); } elseif (!empty($Kb26X['username']['like'])) { $KF1bZ = $KF1bZ->where('username', 'like', '%' . $Kb26X['username']['like'] . '%'); } elseif (!empty($Kb26X['email']['like'])) { $KF1bZ = $KF1bZ->where('email', 'like', '%' . $Kb26X['email']['like'] . '%'); } elseif (!empty($Kb26X['phone']['like'])) { $KF1bZ = $KF1bZ->where('phone', 'like', '%' . $Kb26X['phone']['like'] . '%'); } } $SFOuH = $KF1bZ->paginate($GA5mT, array('*'), 'page', $E2yS6)->toArray(); $V57tb = array(); foreach ($SFOuH['data'] as $VBrBE) { goto tBG9z; IzZy_: $rlDjo[] = $VBrBE['id']; goto J5gJz; tBG9z: $rlDjo = array(); goto IzZy_; vit4B: $V57tb[] = $rlDjo; goto VXqc4; J5gJz: $rlDjo[] = $VBrBE['username']; goto snk96; AJxW8: $rlDjo[] = $VBrBE['realname']; goto dDHz8; snk96: $rlDjo[] = $VBrBE['email']; goto NC7mf; cGVry: $rlDjo[] = $VBrBE['created_at']; goto SaBeE; dDHz8: $rlDjo[] = $VBrBE['signature']; goto vit4B; SaBeE: $rlDjo[] = TypeUtil::name(Gender::class, $VBrBE['gender']); goto AJxW8; NC7mf: $rlDjo[] = $VBrBE['phone']; goto cGVry; VXqc4: } return array('list' => $V57tb, 'total' => $SFOuH['total']); })->performCommon(); } }