@extends($_viewFrame)

@section('pageTitle'){{$record['title']}}|{{$site['title'].'|'.modstart_config('siteName')}}@endsection
@section('pageKeywords'){{$record['title']}}@endsection
@section('pageDescription'){{$record['summary']}}@endsection

{!! \ModStart\ModStart::css('vendor/Links/style/style.css') !!}
{!! \ModStart\ModStart::js('asset/common/qrcode.js') !!}

@section('bodyContent')

    <div class="ub-container" style="max-width:50rem;">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url($site['url']?$site['url']:'links')}}">{{$site['title']}}</a>
            <a class="active" href="{{modstart_web_url('links/'.$record['id'])}}">{{$record['title']}}</a>
        </div>
        <div class="tw-bg-white tw-p-4 tw-rounded lg:tw-flex tw-text-center lg:tw-text-left margin-bottom">
            <div class="lg:tw-pr-4 tw-w-36 lg:tw-w-40 tw-mx-auto">
                <div class="ub-cover-1-1 tw-rounded-2xl contain tw-bg-gray-100"
                     style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($record['cover'])}})"></div>
            </div>
            <div class="lg:tw-flex-grow">
                <div class="tw-text-2xl">
                    {{$record['title']}}
                </div>
                <div class="tw-mt-4">
                    <a href="{{$record['_jump']}}" class="ub-text-default" target="_blank">{{$record['url']}}</a>
                </div>
                <div class="tw-mt-2 tw-text-gray-400">
                    {{$record['summary']}}
                </div>
                <div class="tw-mt-4">
                    <a href="{{$record['_jump']}}"
                       class="btn btn-primary btn-lg btn-round" target="_blank">
                        立即访问
                        <i class="iconfont icon-angle-right"></i>
                    </a>
                    <a href="javascript:;"
                       data-qrcode-content="{{$record['_jump']}}"
                       class="btn btn-warning btn-lg btn-round">
                        <i class="iconfont icon-qr-code"></i>
                        手机访问
                    </a>
                </div>
            </div>
        </div>
        <div class="ub-panel margin-bottom">
            <div class="head">
                <div class="title">
                    详细介绍
                </div>
            </div>
            <div class="body">
                <div class="ub-html lg">
                    {!! $record['content'] !!}
                </div>
            </div>
        </div>

        @if(modstart_module_enabled('MemberRate'))
            {!! \Module\MemberRate\View\MemberRateView::render(\Module\Links\Core\LinksMemberRateBiz::NAME,$record['id']) !!}
        @endif

    </div>

@endsection
