@extends($_viewFrame)

@section('pageTitle'){{$site['title'].'|'.modstart_config('siteName')}}@endsection
@section('pageKeywords'){{$site['keywords']?$site['keywords']:modstart_config('siteKeywords')}}@endsection
@section('pageDescription'){{$site['description']?$site['description']:modstart_config('siteDescription')}}@endsection

{!! \ModStart\ModStart::css('vendor/Links/style/style.css') !!}

<?php $engines = modstart_config('Links_SearchEngines', []); ?>

@section('headAppend')
    @parent
    <style>
        header .ub-container{
            max-width:100%;
        }
    </style>
@endsection

@section('bodyAppend')
    @parent
    <script>
        // 滚动底部
        $(window).on('scroll', function () {
            var $footer = $('footer');
            if ($(window).scrollTop() + $(window).height() > $footer.offset().top) {
                $('.pb-page-links .side').addClass('abs');
            } else {
                $('.pb-page-links .side').removeClass('abs');
            }
        });
        // 搜索
        $(function () {
            var $form = $('[data-search-form]');
            var engines = {!! json_encode($engines) !!};
            $('[data-search-form-tab]').on('click', '.tab-item', function () {
                $(this).parent().find('.tab-item').removeClass('active');
                $(this).addClass('active');
                var i = $(this).index();
                $form.attr('action', engines[i].url);
                $form.find('input').attr('name', engines[i].field);
                return false;
            });
            $('[data-search-form-tab] .tab-item:first').click();
        });
        // 点击切换
        $(function () {
            var $menu = $('[data-category-menu-list]');
            var $content = $('[data-category-content-list]');
            $menu.on('click', '[data-category-id]', function () {
                var id = $(this).attr('data-category-id');
                MS.util.scrollTo('[data-category-content-list] [data-category-id=' + id + ']', null, {
                    offset: -40
                });
                return false;
            });
            $(window).on('scroll', function () {
                var top = $(window).scrollTop();
                var $items = $content.find('[data-category-id]');
                var $activeItem = null;
                for (var i = 0; i < $items.length; i++) {
                    var $item = $($items[i]);
                    var offset = $item.offset();
                    if(top + 200 > offset.top ){
                        $activeItem = $item;
                    }
                }
                $menu.find('[data-category-id]').removeClass('active');
                if($activeItem){
                    var id = $activeItem.attr('data-category-id');
                    $menu.find('[data-category-id=' + id + ']').addClass('active');
                }
            });
        });
    </script>
@endsection

@section('bodyContent')

    <div class="pb-page-links">
        <div class="container">
            <div class="main">

                <div class="ub-search-block margin-top tw-rounded-xl"
                     style="background-image: url({{$site['banner']}});background-repeat:no-repeat;background-size:cover;background-position:center;"
                >
                    <div class="title">
                        {{$site['slogan']?$site['slogan']:'[标语]'}}
                    </div>
                    <div class="form">
                        <div class="tab" data-search-form-tab>
                            @foreach($engines as $e)
                                <a class="tab-item" href="javascript:;">
                                    {{$e['name']}}
                                </a>
                            @endforeach
                        </div>
                        <form action="?" data-search-form method="get" target="_blank">
                            <div class="box rect">
                                <input type="text" name="keyword" class="form form-lg" placeholder="输入关键词搜索"/>
                                <button type="submit" class="btn btn-lg"><i class="iconfont icon-search"></i> 搜索
                                </button>
                            </div>
                        </form>
                        @if(0)
                            <div class="keywords">
                            <span class="keywords-label">
                                热搜词：
                            </span>
                                <a class="keywords-item" href="#">
                                    关键词A
                                </a>
                                <a class="keywords-item" href="#">
                                    关键词B
                                </a>
                                <a class="keywords-item" href="#">
                                    关键词C
                                </a>
                            </div>
                        @endif
                    </div>
                </div>

                <div data-category-content-list>
                    @foreach($categoryTree as $ct)
                        <div class="group" data-category-id="{{$ct['id']}}">
                            <h2 class="group-title">
                                {{$ct['title']}}
                            </h2>
                            <div class="items">
                                <div class="row">
                                    @foreach($records as $r)
                                        @if($r['categoryId']===$ct['id'])
                                            <div class="col-md-3 col-6">
                                                <div class="item">
                                                    <div class="top">
                                                        <div class="cover">
                                                            <div class="ub-cover-1-1 tw-rounded-full"
                                                                 style="background-image:url({{$r['cover']}});"></div>
                                                        </div>
                                                        <a class="title" target="_blank" href="{{modstart_web_url('links/'.$r['id'])}}">
                                                            {{$r['title']}}
                                                        </a>
                                                        <a class="jump" target="_blank" href="{{$r['_jump']}}">
                                                            <i class="iconfont icon-angle-right"></i>
                                                        </a>
                                                    </div>
                                                    <div class="summary">
                                                        {{$r['summary']}}
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

            </div>
            <div class="side">
                <div class="side-nav">
                    <h2 class="nav">
                        <i class="iconfont icon-category"></i>
                        旗下导航网址
                    </h2>
                    <div class="others">
                        @foreach($sites as $s)
                            <div class="item">
                                <a class="@if($s['id']===$site['id']) active @endif" href="{{$s['url']}}">
                                    <div class="cover">
                                        <div class="ub-cover-1-1 tw-rounded-lg"
                                             style="background-image:url({{$s['cover']}});"></div>
                                    </div>
                                    <div class="title">{{$s['title']}}</div>
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="side-menu">
                    <div class="menu" data-category-menu-list>
                        @foreach($categoryTree as $ct)
                            <a class="item" data-category-id="{{$ct['id']}}" href="javascript:;">
                                <i class="{{$ct['icon']}}"></i>
                                {{$ct['title']}}
                            </a>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
