<div dir="RTL" align="right" style="direction:rtl;text-align:right;">

# Gentelella RTL / قالب راست چین شده مدیریت

Gentelella یک قالب مدیریت راست چین شده می‌باشد که از روی قالب اصلی که در آدرس [Gentelella](https://github.com/puikinsh/gentelella) می‌توانید آن را مشاهده نمایید بوجود آمده است.

## دموی قالب
![Gentelella Bootstrap Admin Template](./documentation/images/demo-template.png "Gentelella RTL Theme Browser Preview")

**[اینجا می‌توانید مشاهده نمایید](https://mortezakarimi.github.io/gentelella-rtl/public/index.html)**


## تغییر فونت

با استفاده از افزودن یکی از کلاس‌های زیر به تگ `body` می‌توانید از میان ۴ حالت زیر فونت خود رو انتخاب نمایید.

<div dir="LTR" align="left" style="direction:ltr;text-align:left;">

**IRanSans (Default Font)**

```
body.iransans
```

**IRanSans Persian Number**

```
body.iransans.persian_num
```

**Vazir Font**

```
body.vazir
```

**Yekan Font**

```
body.yekan
```

</div>

## نصب با استفاده از مدیریت بسته ها

هدف من این است که این پکیج با استفاده از تمام مدیرت بسته های مختلف قابل نصب باشد. در صورتی که مدیریت بسته مورد نظر شما در زیر وجود ندارد کافیست Pull Request دهید

چند روش نصب این بسته در زیر آمده است:

**دانلود آخرین نسخه از گیت هاب**

همچنین برای دانلود آخرین نسخه میتوانید از این پیوند اقدام نمایید.

[دانلود](https://github.com/mortezakarimi/gentelella-rtl/releases/latest)


**نصب با استفاده از گیت هاب**

<div dir="LTR" align="left" style="direction:ltr;text-align:left;">

```
git clone https://github.com/mortezakarimi/gentelella-rtl.git -b 'gh-pages'
```


**Bower**

```
bower install gentelella-rtl --save
```

**npm**

```
npm install gentelella-rtl --save
```

</div>

## چگونه همکاری کنید
برای همکاری مطمئن شوید آخرین نسخه پایدار [Node.js](https://nodejs.org/) و [npm](https://npmjs.com) نصب باشد.

چک کنید Gulp CLI نصب باشد با استفاده از  `gulp --version`.  اگر وجود نداشت با استفاده از  این دستور نصب نمایید `npm install -g gulp`.  برای اطلاعات بیشتر در رابطه با نصب  Gulp, Gulp را مشاهده نمایید [شروع به کار](https://github.com/gulpjs/gulp/blob/master/docs/getting-started.md).

اگر `gulp`  نصب بود به کار‌های زیر بپردازید.

1. چنگ زدن و کپی برداری از این رپوزیتوری.
2. اجرای `gulp`, این کار باعث باز شده gentelella در مرورگر پیشفرض شما می‌شود.
3. و حالا شما می‌توانید کد بزنید و کد بزنید و کد...!
4. ارسال یک pull Request

## اسکریپت های استفاده شده:
<div dir="LTR" align="left" style="direction:ltr;text-align:left;">

* Bootstrap
* Bootstrap-rtl
* Font Awesome
* jQuery-Autocomplete
* FullCalendar
* Charts.js
* Bootstrap Colorpicker
* Cropper
* dataTables
* Date Range Picker for Bootstrap
* Dropzone
* easyPieChart
* ECharts
* bootstrap-wysiwyg
* Flot - Javascript plotting library for jQuery.
* gauge.js
* iCheck
* jquery.inputmask plugin
* Ion.RangeSlider
* jQuery
* jVectorMap
* moment.js
* Morris.js - pretty time-series line graphs
* PNotify - Awesome JavaScript notifications
* NProgress
* Pace
* Parsley
* bootstrap-progressbar
* select2
* Sidebar Transitions - simple off-canvas navigations
* Skycons - canvas based wather icons
* jQuery Sparklines plugin
* switchery - Turns HTML checkbox inputs into beautiful iOS style switches
* jQuery Tags Input Plugin
* Autosize - resizes text area to fit text
* validator - HTML from validator using jQuery
* jQuery Smart Wizard
* moment-jalaali

</div>

## قالب Gentelella برای دیگر فریمورک ها

<div dir="LTR" align="left" style="direction:ltr;text-align:left;">
  
* [Gentelella-rtl on Yii framework 2](https://github.com/mortezakarimi/yii2-gentelella-rtl) with an asset bundle, a layout template and some widgets. inspired from [Gentelella on Yii framework 2](https://github.com/yiister/yii2-gentelella)
* [Gentelella on Ruby on Rails 4](https://github.com/iogbole/gentelella_on_rails) thanks to Israel Ogbole.
* [Gentelella on Smarty 3](https://github.com/microvb/otp-thing) with one time password generator, validator, and QR code generator that has no web dependencies (self-contained) in PHP thanks to MicroVB INC
* [Gentelella integrated into Symfony 3](https://github.com/krzysiekpiasecki/Gentelella) full stack PHP framework thanks to Krzysztof Piasecki.
* [Gentelella on Yii framework 2](https://github.com/yiister/yii2-gentelella) with an asset bundle, a layout template and some widgets.
* [Gentelella on Angular 2](https://github.com/kmkatsma/angular2-webpack-starter-gentelella) Angular Webpack Starter modified to utilize the Gentelella.
* [Gentelella on Aurelia](https://github.com/kmkatsma/aurelia-gentelella) Typescript webpack skeleton modified to utilize the Gentelella.
</div>

به ما اطلاع دهید اگر ادغام را برای این قالب مدیریت در سایر سیستم عامل ها و چارچوب ها انجام داده اید و خوشحال خواهیم شد که کار خود را به اشتراک بگذارید.

## قالب های و موارد مفید دیگر

<div dir="LTR" align="left" style="direction:ltr;text-align:left;">

* [Free Bootstrap Admin Templates](https://colorlib.com/wp/free-bootstrap-admin-dashboard-templates/ "Bootstrap Admin Templates on Colorlib") - List of the best Free Bootstrap admin dashboard templates that are available for free for personal and commercial use.
* [Free Admin Templates](https://colorlib.com/wp/free-html5-admin-dashboard-templates/ "List of free HTML based admin templates by Colorlib") - Long list of the best free HTML5 powered admin dashboard templates. Available for personal and commercial use.
* [Angular Templates](https://colorlib.com/wp/angularjs-admin-templates/ "Angular Admin Templates on Colorlib") - List of the most popular admin templates based on AngularJS.
* [HTML Admin Templates](https://colorlib.com/wp/html-admin-templates/ "Material Design Admin Templates on Colorlib") - Most of these templates are based on AngularJS and uses a stunning Material design.
* [Bootstrap Admin Templates](https://colorlib.com/wp/bootstrap-admin-templates/ "List of Premium Bootstrap Admin Templates by Colorlib") - List of premium Bootstrap admin templates that uses a minimal flat or material design. Majority of these themes uses AngularJS but HTML5 versions are also available.
* [WordPress Admin Templates](https://colorlib.com/wp/wordpress-admin-dashboard-themes-plugins/ "List of WordPress Admin Dashboard Templates and Plugins by Colorlib") - List of the best WordPress admin dashboard templates and plugins that will add a personal touch to your WordPress dashboard.
* [WordPress Themes](https://colorlib.com/wp/free-wordpress-themes/ "List of Free WordPress themes by Colorlib") - A huge selection of the best free WordPress themes that are all licensed under GPL and are available for personal and commercial use without restrictions.

</div>

<div dir="LTR" align="left" style="direction:ltr;text-align:left;">

## Contributors

### Code Contributors

This project exists thanks to all the people who contribute. [[Contribute](CONTRIBUTING.md)].
<a href="https://github.com/mortezakarimi/gentelella-rtl/graphs/contributors"><img src="https://opencollective.com/gentelella-rtl/contributors.svg?width=890&button=false" /></a>

### Financial Contributors

Become a financial contributor and help us sustain our community. [[Contribute](https://opencollective.com/gentelella-rtl/contribute)]

#### Individuals

<a href="https://opencollective.com/gentelella-rtl"><img src="https://opencollective.com/gentelella-rtl/individuals.svg?width=890"></a>

#### Organizations

Support this project with your organization. Your logo will show up here with a link to your website. [[Contribute](https://opencollective.com/gentelella-rtl/contribute)]

<a href="https://opencollective.com/gentelella-rtl/organization/0/website"><img src="https://opencollective.com/gentelella-rtl/organization/0/avatar.svg"></a>
<a href="https://opencollective.com/gentelella-rtl/organization/1/website"><img src="https://opencollective.com/gentelella-rtl/organization/1/avatar.svg"></a>
<a href="https://opencollective.com/gentelella-rtl/organization/2/website"><img src="https://opencollective.com/gentelella-rtl/organization/2/avatar.svg"></a>
<a href="https://opencollective.com/gentelella-rtl/organization/3/website"><img src="https://opencollective.com/gentelella-rtl/organization/3/avatar.svg"></a>
<a href="https://opencollective.com/gentelella-rtl/organization/4/website"><img src="https://opencollective.com/gentelella-rtl/organization/4/avatar.svg"></a>
<a href="https://opencollective.com/gentelella-rtl/organization/5/website"><img src="https://opencollective.com/gentelella-rtl/organization/5/avatar.svg"></a>
<a href="https://opencollective.com/gentelella-rtl/organization/6/website"><img src="https://opencollective.com/gentelella-rtl/organization/6/avatar.svg"></a>
<a href="https://opencollective.com/gentelella-rtl/organization/7/website"><img src="https://opencollective.com/gentelella-rtl/organization/7/avatar.svg"></a>
<a href="https://opencollective.com/gentelella-rtl/organization/8/website"><img src="https://opencollective.com/gentelella-rtl/organization/8/avatar.svg"></a>
<a href="https://opencollective.com/gentelella-rtl/organization/9/website"><img src="https://opencollective.com/gentelella-rtl/organization/9/avatar.svg"></a>

## License information


Gentelella RTL is licensed under The MIT License (MIT). Which means that you can use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software. But you always need to state that Colorlib is the original author of this template.

Project is developed and maintained by [Morteza Karimi](https://morteza-karimi.ir/ "Morteza Karimi - Web Developer")
</div>
</div>
