//! \file       YkTables.cs
//! \date       2023 Sep 10
//! \brief      Koei data archives specifics.
//

using System.Collections.Generic;

namespace GameRes.Formats.Koei
{
  public partial class YkOpener
  {
    internal static readonly HashSet<string> IsAudio = new HashSet<string> {
      "DATA05", "DATA06", "DATA07", "DATA08", "DATA09", "DATA10", "DATA11", "DATA12", "DATA13", "DATA14", "DATA15",
    };
    internal static readonly Dictionary<int, ImageMetaData> Data02Images = new Dictionary<int, ImageMetaData>
    {
      {  0, new ImageMetaData { Width = 0x168, Height = 0x90, BPP = 8 } },
      {  1, new ImageMetaData { Width = 0x510, Height = 0x3C0, BPP = 8 } },
      {  2, new ImageMetaData { Width = 0x240, Height = 0x3C0, BPP = 8 } },
      {  3, new ImageMetaData { Width = 0x280, Height = 0x286, BPP = 8 } },
      {  4, null },
      {  9, null },
      { 10, null },
      { 11, new ImageMetaData { Width = 888, Height = 480, BPP = 8 } },
      { 12, new ImageMetaData { Width = 888, Height = 480, BPP = 8 } },
      { 13, new ImageMetaData { Width = 888, Height = 480, BPP = 8 } },
      { 14, new ImageMetaData { Width = 908, Height = 480, BPP = 8 } },
      { 15, new ImageMetaData { Width = 544, Height = 480, BPP = 8 } },
      { 16, new ImageMetaData { Width = 544, Height = 480, BPP = 8 } },
      { 17, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 18, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 19, new ImageMetaData { Width = 312, Height = 480, BPP = 8 } },
      { 20, new ImageMetaData { Width = 312, Height = 480, BPP = 8 } },
      { 21, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 22, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 23, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 24, new ImageMetaData { Width = 888, Height = 480, BPP = 8 } },
      { 25, new ImageMetaData { Width = 236, Height = 480, BPP = 8 } },
      { 26, new ImageMetaData { Width = 900, Height = 480, BPP = 8 } },
      { 27, new ImageMetaData { Width = 860, Height = 480, BPP = 8 } },
      { 28, new ImageMetaData { Width = 860, Height = 480, BPP = 8 } },
      { 29, new ImageMetaData { Width = 860, Height = 480, BPP = 8 } },
      { 30, new ImageMetaData { Width = 332, Height = 480, BPP = 8 } },
      { 31, new ImageMetaData { Width = 204, Height = 480, BPP = 8 } },
      { 32, new ImageMetaData { Width = 392, Height = 480, BPP = 8 } },
      { 33, new ImageMetaData { Width = 880, Height = 480, BPP = 8 } },
      { 34, new ImageMetaData { Width = 880, Height = 480, BPP = 8 } },
      { 35, new ImageMetaData { Width = 332, Height = 480, BPP = 8 } },
      { 36, new ImageMetaData { Width = 224, Height = 480, BPP = 8 } },
      { 37, new ImageMetaData { Width = 356, Height = 480, BPP = 8 } },
      { 38, new ImageMetaData { Width = 252, Height = 480, BPP = 8 } },
      { 39, new ImageMetaData { Width = 292, Height = 480, BPP = 8 } },
      { 40, new ImageMetaData { Width = 936, Height = 480, BPP = 8 } },
      { 41, new ImageMetaData { Width = 960, Height = 480, BPP = 8 } },
      { 42, new ImageMetaData { Width = 596, Height = 480, BPP = 8 } },
      { 43, new ImageMetaData { Width = 940, Height = 480, BPP = 8 } },
      { 44, new ImageMetaData { Width = 996, Height = 480, BPP = 8 } },
      { 45, new ImageMetaData { Width = 936, Height = 480, BPP = 8 } },
      { 46, new ImageMetaData { Width = 332, Height = 480, BPP = 8 } },
      { 47, new ImageMetaData { Width = 372, Height = 480, BPP = 8 } },
      { 48, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 49, new ImageMetaData { Width = 452, Height = 480, BPP = 8 } },
      { 50, new ImageMetaData { Width = 344, Height = 480, BPP = 8 } },
      { 51, new ImageMetaData { Width = 936, Height = 480, BPP = 8 } },
      { 52, new ImageMetaData { Width = 292, Height = 480, BPP = 8 } },
      { 53, new ImageMetaData { Width = 252, Height = 480, BPP = 8 } },
      { 54, new ImageMetaData { Width = 996, Height = 480, BPP = 8 } },
      { 55, new ImageMetaData { Width = 908, Height = 480, BPP = 8 } },
      { 56, new ImageMetaData { Width = 232, Height = 480, BPP = 8 } },
      { 57, new ImageMetaData { Width = 232, Height = 480, BPP = 8 } },
      { 58, new ImageMetaData { Width = 244, Height = 480, BPP = 8 } },
      { 59, new ImageMetaData { Width = 372, Height = 480, BPP = 8 } },
      { 60, new ImageMetaData { Width = 392, Height = 480, BPP = 8 } },
      { 61, new ImageMetaData { Width = 948, Height = 480, BPP = 8 } },
      { 62, new ImageMetaData { Width = 212, Height = 480, BPP = 8 } },
      { 63, new ImageMetaData { Width = 908, Height = 480, BPP = 8 } },
      { 64, new ImageMetaData { Width = 908, Height = 480, BPP = 8 } },
      { 65, new ImageMetaData { Width = 352, Height = 480, BPP = 8 } },
      { 66, new ImageMetaData { Width = 352, Height = 480, BPP = 8 } },
      { 67, new ImageMetaData { Width = 312, Height = 480, BPP = 8 } },
      { 68, new ImageMetaData { Width = 944, Height = 480, BPP = 8 } },
      { 69, new ImageMetaData { Width = 944, Height = 480, BPP = 8 } },
      { 70, new ImageMetaData { Width = 336, Height = 480, BPP = 8 } },
      { 71, new ImageMetaData { Width = 944, Height = 480, BPP = 8 } },
      { 72, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 73, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 74, new ImageMetaData { Width = 372, Height = 480, BPP = 8 } },
      { 75, new ImageMetaData { Width = 284, Height = 480, BPP = 8 } },
      { 76, new ImageMetaData { Width = 332, Height = 480, BPP = 8 } },
      { 77, new ImageMetaData { Width = 284, Height = 480, BPP = 8 } },
      { 78, new ImageMetaData { Width = 944, Height = 480, BPP = 8 } },
      { 79, new ImageMetaData { Width = 264, Height = 480, BPP = 8 } },
      { 80, new ImageMetaData { Width = 284, Height = 480, BPP = 8 } },
      { 81, new ImageMetaData { Width = 312, Height = 480, BPP = 8 } },
      { 82, new ImageMetaData { Width = 1008, Height = 480, BPP = 8 } },
      { 83, new ImageMetaData { Width = 968, Height = 480, BPP = 8 } },
      { 84, new ImageMetaData { Width = 608, Height = 480, BPP = 8 } },
      { 85, new ImageMetaData { Width = 264, Height = 480, BPP = 8 } },
      { 86, new ImageMetaData { Width = 272, Height = 480, BPP = 8 } },
      { 87, new ImageMetaData { Width = 392, Height = 480, BPP = 8 } },
      { 88, new ImageMetaData { Width = 372, Height = 480, BPP = 8 } },
      { 89, new ImageMetaData { Width = 552, Height = 480, BPP = 8 } },
      { 90, new ImageMetaData { Width = 324, Height = 480, BPP = 8 } },
      { 91, new ImageMetaData { Width = 524, Height = 480, BPP = 8 } },
      { 92, new ImageMetaData { Width = 968, Height = 480, BPP = 8 } },
      { 93, new ImageMetaData { Width = 344, Height = 480, BPP = 8 } },
      { 94, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 95, new ImageMetaData { Width = 968, Height = 480, BPP = 8 } },
      { 96, new ImageMetaData { Width = 272, Height = 480, BPP = 8 } },
      { 97, new ImageMetaData { Width = 304, Height = 480, BPP = 8 } },
      { 98, new ImageMetaData { Width = 968, Height = 480, BPP = 8 } },
      { 99, new ImageMetaData { Width = 968, Height = 480, BPP = 8 } },
      {100, new ImageMetaData { Width = 344, Height = 480, BPP = 8 } },
      {101, new ImageMetaData { Width = 368, Height = 480, BPP = 8 } },
      {102, new ImageMetaData { Width = 476, Height = 480, BPP = 8 } },
      {103, new ImageMetaData { Width = 476, Height = 480, BPP = 8 } },
      {104, new ImageMetaData { Width = 512, Height = 480, BPP = 8 } },
      {105, new ImageMetaData { Width = 512, Height = 480, BPP = 8 } },
      {106, new ImageMetaData { Width = 324, Height = 480, BPP = 8 } },
      {107, new ImageMetaData { Width = 324, Height = 480, BPP = 8 } },
      {108, new ImageMetaData { Width = 392, Height = 480, BPP = 8 } },
      {109, new ImageMetaData { Width = 968, Height = 480, BPP = 8 } },
      {110, new ImageMetaData { Width = 1196, Height = 480, BPP = 8 } },
      {111, new ImageMetaData { Width = 968, Height = 480, BPP = 8 } },
      {112, new ImageMetaData { Width = 968, Height = 480, BPP = 8 } },
      {113, new ImageMetaData { Width = 404, Height = 480, BPP = 8 } },
      {114, new ImageMetaData { Width = 324, Height = 480, BPP = 8 } },
      {115, new ImageMetaData { Width = 976, Height = 480, BPP = 8 } },
      {116, new ImageMetaData { Width = 976, Height = 480, BPP = 8 } },
      {117, new ImageMetaData { Width = 224, Height = 480, BPP = 8 } },
      {118, new ImageMetaData { Width = 384, Height = 480, BPP = 8 } },
      {119, new ImageMetaData { Width = 392, Height = 480, BPP = 8 } },
      {120, new ImageMetaData { Width = 976, Height = 480, BPP = 8 } },
      {121, new ImageMetaData { Width = 384, Height = 480, BPP = 8 } },
      {122, new ImageMetaData { Width = 296, Height = 480, BPP = 8 } },
      {123, new ImageMetaData { Width = 976, Height = 480, BPP = 8 } },
      {124, new ImageMetaData { Width = 976, Height = 480, BPP = 8 } },
      {125, new ImageMetaData { Width = 976, Height = 480, BPP = 8 } },
      {126, new ImageMetaData { Width = 324, Height = 480, BPP = 8 } },
      {127, new ImageMetaData { Width = 324, Height = 480, BPP = 8 } },
      {128, new ImageMetaData { Width = 332, Height = 480, BPP = 8 } },
      {129, new ImageMetaData { Width = 992, Height = 480, BPP = 8 } },
      {130, new ImageMetaData { Width = 992, Height = 480, BPP = 8 } },
      {131, new ImageMetaData { Width = 272, Height = 480, BPP = 8 } },
      {132, new ImageMetaData { Width = 284, Height = 480, BPP = 8 } },
      {133, new ImageMetaData { Width = 384, Height = 480, BPP = 8 } },
      {134, new ImageMetaData { Width = 184, Height = 480, BPP = 8 } },
      {135, new ImageMetaData { Width = 984, Height = 480, BPP = 8 } },
      {136, new ImageMetaData { Width = 992, Height = 480, BPP = 8 } },
      {137, new ImageMetaData { Width = 656, Height = 480, BPP = 8 } },
      {138, new ImageMetaData { Width = 544, Height = 480, BPP = 8 } },
      {139, new ImageMetaData { Width = 480, Height = 480, BPP = 8 } },
      {140, new ImageMetaData { Width = 404, Height = 480, BPP = 8 } },
      {141, new ImageMetaData { Width = 524, Height = 480, BPP = 8 } },
      {142, new ImageMetaData { Width = 404, Height = 480, BPP = 8 } },
      {143, new ImageMetaData { Width = 312, Height = 480, BPP = 8 } },
      {144, new ImageMetaData { Width = 444, Height = 480, BPP = 8 } },
      {145, new ImageMetaData { Width = 640, Height = 480, BPP = 8 } },
      {146, new ImageMetaData { Width = 392, Height = 480, BPP = 8 } },
      {147, new ImageMetaData { Width = 324, Height = 480, BPP = 8 } },
      {148, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {149, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {150, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {151, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {152, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {153, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {154, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {155, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {156, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {157, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {158, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {159, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {160, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {161, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {162, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {163, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {164, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {165, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {166, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {167, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {168, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {169, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {170, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {171, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {172, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {173, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {174, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {175, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {176, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {177, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {178, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {179, new ImageMetaData { Width = 96, Height = 96, BPP = 8 } },
      {180, new ImageMetaData { Width = 256, Height = 128, BPP = 8 } },
      {181, new ImageMetaData { Width = 256, Height = 128, BPP = 8 } },
      {182, new ImageMetaData { Width = 256, Height = 128, BPP = 8 } },
      {183, new ImageMetaData { Width = 256, Height = 128, BPP = 8 } },
      {184, new ImageMetaData { Width = 256, Height = 128, BPP = 8 } },
      {185, new ImageMetaData { Width = 256, Height = 128, BPP = 8 } },
      {186, new ImageMetaData { Width = 256, Height = 128, BPP = 8 } },
      {187, new ImageMetaData { Width = 256, Height = 128, BPP = 8 } },
      {188, new ImageMetaData { Width = 256, Height = 128, BPP = 8 } },
    };

    internal static readonly Dictionary<string, uint[]> OffsetTable = new Dictionary<string, uint[]>
    {
      { "DATA02", new uint[] {
        0x0CE84, 0x13CE84, 0x1C4284, 0x229584, 0x30A5BC, 0x30B8B8, 0x30BCA8, 0x30BFA8, 0x30C548, 0x3A9D80,
        0x40FF38, 0x478438, 0x4E0938, 0x548E38, 0x5B38B8, 0x5F38B8, 0x6338B8, 0x6576B8, 0x67B4B8, 0x6A01B8,
        0x6C4EB8, 0x6E8CB8, 0x70CAB8, 0x7308B8, 0x798DB8, 0x7B4C38, 0x81E7B8, 0x883838, 0x8E88B8, 0x94D938,
        0x974BB8, 0x98CE38, 0x9BB138, 0x0A22738, 0x0A89D38, 0x0AB0FB8, 0x0ACB7B8, 0x0AF5738, 0x0B133B8,
        0x0B35B38, 0x0BA3A38, 0x0C14638, 0x0C5A7B8, 0x0CC8E38, 0x0D3DDB8, 0x0DABCB8, 0x0DD2F38, 0x0DFECB8,
        0x0E22AB8, 0x0E57E38, 0x0E80738, 0x0EEE638, 0x0F10DB8, 0x0F2EA38, 0x0FA39B8, 0x100E438, 0x1029B38,
        0x1045238, 0x1061FB8, 0x108DD38, 0x10BC038, 0x112B5B8, 0x1144738, 0x11AF1B8, 0x1219C38, 0x1243438,
        0x126CC38, 0x1291938, 0x1300738, 0x136F538, 0x1396F38, 0x1405D38, 0x1429B38, 0x144D938, 0x14796B8,
        0x149AF38, 0x14C21B8, 0x14E3A38, 0x1552838, 0x1571B38, 0x15933B8, 0x15B80B8, 0x162E6B8, 0x16A01B8,
        0x16E79B8, 0x1706CB8, 0x1726EB8, 0x17551B8, 0x1780F38, 0x17C1E38, 0x17E81B8, 0x1825C38, 0x1897738,
        0x18C0038, 0x18E3E38, 0x1955938, 0x1975B38, 0x1999938, 0x1A0B438, 0x1A7CF38, 0x1AA5838, 0x1AD0E38,
        0x1B08EB8, 0x1B40F38, 0x1B7D338, 0x1BB9738, 0x1BDFAB8, 0x1C05E38, 0x1C34138, 0x1CA5C38, 0x1D322B8,
        0x1DA3DB8, 0x1E158B8, 0x1E45238, 0x1E6B5B8, 0x1EDDFB8, 0x1F509B8, 0x1F6B1B8, 0x1F985B8, 0x1FC68B8,
        0x20392B8, 0x20666B8, 0x20895B8, 0x20FBFB8, 0x216E9B8, 0x21E13B8, 0x2207738, 0x222DAB8, 0x2254D38,
        0x22C9538, 0x233DD38, 0x235DF38, 0x237F7B8, 0x23ACBB8, 0x23C28B8, 0x24361B8, 0x24AA9B8, 0x24F7BB8,
        0x2537BB8, 0x25703B8, 0x259FD38, 0x25DD7B8, 0x260D138, 0x2631E38, 0x26662B8, 0x26B16B8, 0x26DF9B8,
        0x2705D38, 0x2708538, 0x270AD38, 0x270D538, 0x270FD38, 0x2712538, 0x2714D38, 0x2717538, 0x2719D38,
        0x271C538, 0x271ED38, 0x2721538, 0x2723D38, 0x2726538, 0x2728D38, 0x272B538, 0x272DD38, 0x2730538,
        0x2732D38, 0x2735538, 0x2737D38, 0x273A538, 0x273CD38, 0x273F538, 0x2741D38, 0x2744538, 0x2746D38,
        0x2749538, 0x274BD38, 0x274E538, 0x2750D38, 0x2753538, 0x2755D38, 0x275E138, 0x2766538, 0x276E938,
        0x2776D38, 0x277F138, 0x2787538, 0x278F938, 0x2797D38, 0x27A0138, 0x27A6538, 0x27AC938, 0x27B2D38,
        0x27B9138, 0x27BF538, 0x27C5938, 0x27CBD38, 0x27D2138, 0x27D8538, 0x27DE938, 0x27E4D38, 0x27EB138,
        0x27F1538, 0x27F7938, 0x27FDD38, 0x2804138, 0x280A538, 0x2810938, 0x2816D38, 0x281D138, 0x2823538,
        0x2829938, 0x282FD38, 0x2836138, 0x283C538, 0x2842938, 0x2848D38, 0x284F138, 0x2855538, 0x285B938,
        0x2861D38, 0x2868138, 0x286E538, 0x2874938, 0x287AD38, 0x2881138, 0x2887538, 0x288D938, 0x2893D38,
        0x289A138, 0x28A0538, 0x28A6938, 0x28ACD38, 0x28B3138, 0x28B9538, 0x28BF938, 0x28C5D38, 0x28CC138,
        0x28D2538, 0x28D8938, 0x28DED38, 0x28E5138, 0x28EB538, 0x28F1938, 0x28F7D38, 0x28FE138, 0x2904538,
        0x290A938, 0x2910D38, 0x2917138, 0x291D538, 0x2923938, 0x2929D38, 0x2930138, 0x2936538, 0x293C938,
        0x2942D38, 0x2949138, 0x294F538, 0x2955938, 0x295BD38, 0x2962138, 0x2968538, 0x296E938, 0x2974D38,
        0x297B138, 0x2981538, 0x2987938, 0x298DD38, 0x2994138, 0x299A538, 0x29A0938, 0x29A6D38, 0x29AD138,
        0x29B3538, 0x29B9938, 0x29BFD38, 0x29C6138, 0x29CC538, 0x29D2938, 0x29D8D38, 0x29DF138, 0x29E5538,
        0x29EB938, 0x29F1D38, 0x29F8138, 0x29FE538, 0x2A04938, 0x2A0AD38, 0x2A11138, 0x2A17538, 0x2A1D938,
        0x2A23D38, 0x2A2A138, 0x2A30538, 0x2A36938, 0x2A3CD38, 0x2A43138, 0x2A49538, 0x2A4F938, 0x2A55D38,
        0x2A5C138, 0x2A62538, 0x2A68938, 0x2A6ED38, 0x2A75138, 0x2A7B538, 0x2A81938, 0x2A87D38, 0x2A8E138,
        0x2A94538, 0x2A9A938, 0x2AA0D38, 0x2AA7138, 0x2AAD538, 0x2AB3938, 0x2AB9D38, 0x2AC0138, 0x2AC6538,
        0x2ACC938, 0x2AD2D38, 0x2AD9138, 0x2ADF538, 0x2AE5938, 0x2AEBD38, 0x2AF2138, 0x2AF8538, 0x2AFE938,
        0x2B04D38, 0x2B0B138, 0x2B11538, 0x2B17938, 0x2B1DD38, 0x2B24138, 0x2B2A538, 0x2B30938, 0x2B36D38,
        0x2B3D138, 0x2B43538, 0x2B49938, 0x2B4FD38, 0x2B56138, 0x2B5C538, 0x2B62938, 0x2B68D38, 0x2B6F138,
        0x2B75538, 0x2B7B938, 0x2B81D38, 0x2B88138, 0x2B8E538, 0x2B94938, 0x2B9AD38, 0x2BA1138, 0x2BA7538,
        0x2BAD938, 0x2BB3D38, 0x2BBA138, 0x2BC0538, 0x2BC6938, 0x2BCCD38, 0x2BD3138, 0x2BD9538, 0x2BDF938,
        0x2BE5D38, 0x2BEC138, 0x2BF2538, 0x2BF8938, 0x2BFED38, 0x2C05138, 0x2C0B538, 0x2C11938, 0x2C17D38,
      } },
      { "DATA03", new uint[] {
        0x6BC, 0x7D30, 0x0F284, 0x162E4, 0x1DBA8, 0x2475C, 0x2ADAC, 0x31B7C, 0x37D38, 0x3E290, 0x4288C,
        0x47BA4, 0x4CB34, 0x5393C, 0x59610, 0x5EDC0, 0x64B64, 0x6C30C, 0x73130, 0x79C28, 0x809AC, 0x87438,
        0x8E0DC, 0x956BC, 0x9A220, 0x0A0CC8, 0x0A716C, 0x0AA9A8, 0x0B1E08, 0x0B5AE8, 0x0B9900, 0x0BD3E4,
        0x0C0870, 0x0C4144, 0x0C7E68, 0x0CBDB8, 0x0CEEE4, 0x0D43E0,
      } },
      { "DATA04", new uint[] {
        0x3A88, 0x0C3AC, 0x14F38, 0x1DA30, 0x255AC, 0x2C970, 0x36DE4, 0x41010, 0x48E8C, 0x4CDE8,
      } },
      { "DATA05", new uint[] {
        0x4200, 0x8420, 0x0CC40, 0x10CD0, 0x159B4, 0x1A0F8, 0x1E150, 0x427F0, 0x474B0, 0x4BAC8,
        0x4FFFC, 0x554D8, 0x5A6FC, 0x5EA48, 0x6355C, 0x69010, 0x6E0AC, 0x739AC, 0x790A8, 0x7DE6C,
        0x83260, 0x8972C, 0x8F510, 0x93790, 0x98AB0, 0x9D454, 0x0A202C, 0x0A706C, 0x0AB9FC, 0x0B0004,
        0x0B5064, 0x0BA36C, 0x0BFA24, 0x0C34F0, 0x0C75D0, 0x0CC518, 0x0D0C0C, 0x0D58DC, 0x0DA2BC,
        0x0DE650, 0x0E2BE8, 0x0E7FAC, 0x0ED424, 0x0F1818, 0x0F5E24, 0x0FAC18, 0x0FF058, 0x103A98,
        0x108390, 0x10C6A0, 0x110964, 0x115E28, 0x11AEB8, 0x11FB6C, 0x124584, 0x129DA0, 0x12EA04,
        0x1339F8, 0x138F00, 0x13DB0C, 0x142F98, 0x149154, 0x14F6A4
      } },
      { "DATA06", new uint[] {
        0x3334, 0x89C4, 0x1EB24, 0x27760, 0x362D8, 0x37D50, 0x41388, 0x4456C, 0x4B108, 0x5FE54, 0x6ADD4,
        0x759E8, 0x993E0, 0x0ACD08, 0x0B0900, 0x0B4744, 0x0BA3F0, 0x0BB4D0, 0x0CFBB0, 0x0D6520, 0x0DAABC,
        0x0E6B5C, 0x0EAF48, 0x0FA0B0, 0x100788, 0x11472C, 0x11E2B8, 0x124320, 0x12C174, 0x12F5F0, 0x135558,
        0x145AB4, 0x157E18, 0x169D60, 0x171884, 0x17F6E4, 0x187DAC, 0x19056C, 0x19CAD8, 0x1B5C68, 0x1C09EC,
        0x1CC478, 0x1CF4E8, 0x1DBB04, 0x1E47C8, 0x1FB670, 0x201C08, 0x202F8C, 0x213CA0, 0x2255B8, 0x22C7CC,
        0x22D4CC, 0x2322D0, 0x234FCC, 0x23ECBC, 0x240524, 0x24523C, 0x2475C0, 0x2494B8, 0x2572CC, 0x25A134,
        0x277488, 0x2812B4, 0x2829F0, 0x290168, 0x2959A8, 0x29D960, 0x29F5A0, 0x29FFF8, 0x2A8604, 0x2CAB20,
        0x2E3FBC, 0x300EB0, 0x323810, 0x33DC20, 0x34B414, 0x353BA4, 0x3675BC, 0x379C80, 0x37E748, 0x38261C,
        0x393F9C, 0x39E7E0, 0x39FB90, 0x3ADA84, 0x3B626C, 0x3C4B44, 0x3C5970, 0x3C7860, 0x3CA370, 0x3D31F8,
        0x3D7ABC, 0x3EAD10, 0x3F2198, 0x3F3D34, 0x3FE2E8, 0x407E20, 0x40F118, 0x40FB8C, 0x4168E4, 0x420D6C,
        0x427AF4, 0x42B574, 0x42FBC0, 0x43C6BC, 0x4440F0, 0x448DBC, 0x455074, 0x45DB50, 0x473ED8, 0x48A2FC,
        0x4A73D4, 0x4B6940, 0x4D38B4, 0x4DF6E8, 0x4ECAC8, 0x504DF4, 0x51C77C, 0x53079C, 0x55EE34, 0x56FF58,
        0x5944AC, 0x5B7B2C, 0x5D4C4C, 0x5D73EC, 0x5E5F98, 0x5E6C04, 0x5F3228, 0x600F0C, 0x60F9C0, 0x621D50,
        0x62EA84, 0x648A24, 0x64FE20, 0x6575A4, 0x6617D8, 0x66744C, 0x680F88, 0x6892EC, 0x6994B4, 0x6A2384,
        0x6B6C00, 0x6C3C20, 0x6CE964, 0x6D646C, 0x6E3458, 0x6F6894, 0x707604, 0x717630, 0x71BA08, 0x7226CC,
        0x7276FC, 0x72DB00, 0x747A8C, 0x75333C, 0x76CC18, 0x774FA0, 0x77A068, 0x782BB0, 0x795ADC, 0x7A3938,
        0x7B3C48, 0x7BFDE8, 0x7CDFC8, 0x7D3604, 0x7D9FCC, 0x7DE2D0, 0x7EFC14, 0x7F0748, 0x7F89AC, 0x7FBD68,
        0x7FF3EC, 0x800EE8, 0x80929C, 0x80E508, 0x8151BC, 0x81C2CC, 0x82B0E4, 0x8329B0, 0x836FB4, 0x838AC4,
        0x83A67C, 0x842110, 0x84CC88, 0x85A488, 0x865A94, 0x8706B0, 0x885124, 0x8908D0, 0x8B3594, 0x8C02AC,
        0x8C59AC, 0x8C9C68, 0x8CC1AC, 0x8D2CE0, 0x8E1EC4, 0x8E49A0, 0x8F7D40, 0x8FE08C, 0x90CA60, 0x91683C,
        0x924B64, 0x928C58, 0x92D1F0, 0x938D10, 0x9452A8, 0x9517D8, 0x9534B0, 0x96097C, 0x963B90, 0x96E4F0,
        0x98F5D0, 0x995C5C, 0x9A9160, 0x9AFEE4, 0x9B6BA4, 0x9BC9E4, 0x9CB074, 0x9D78A0, 0x9DF9E0, 0x9EC1B8,
        0x9F13A8, 0x9F6688, 0x9F98B0, 0x0A01204, 0x0A07D14, 0x0A0EE3C, 0x0A15B48, 0x0A1A7F4, 0x0A27EF4,
        0x0A40100, 0x0A50714, 0x0A52044, 0x0A6A20C, 0x0A71854, 0x0A842E8, 0x0A870EC, 0x0A940CC, 0x0A9A21C,
        0x0AB0630, 0x0AB8F5C, 0x0ABD7B0, 0x0AE1FF4, 0x0AF2BD0, 0x0AFFA30, 0x0B00D3C, 0x0B0A8E4, 0x0B10EC8,
        0x0B194B4, 0x0B1A7E8, 0x0B255CC, 0x0B2A0A4, 0x0B2DF10, 0x0B2FE00, 0x0B32A3C, 0x0B44600, 0x0B46D20,
        0x0B47D60, 0x0B4F074, 0x0B67AB4, 0x0B69AA0, 0x0B6D6C4, 0x0B7519C, 0x0B7ABA4, 0x0B88D34, 0x0B96BB8,
        0x0B9AD8C, 0x0BA49CC, 0x0BA6E24, 0x0BAD108, 0x0BBA7CC, 0x0BCCA70, 0x0BEF68C, 0x0C061C4, 0x0C08F60,
        0x0C15BD4, 0x0C17A14, 0x0C2F7CC, 0x0C36374, 0x0C472C4, 0x0C51F5C, 0x0C56B74, 0x0C60464, 0x0C708C0,
        0x0C79584, 0x0C7F8D8, 0x0C893F8, 0x0C8ADF8, 0x0C8EFD0, 0x0C92B9C, 0x0C978C4, 0x0C99FF8, 0x0C9BA90,
        0x0CA4214, 0x0CACB7C, 0x0CBD21C, 0x0CBE5F4, 0x0CC581C, 0x0CCF618, 0x0CE3D2C, 0x0CE6E74, 0x0CF2A18,
        0x0CF6C24, 0x0CFC384, 0x0D09080, 0x0D145D0, 0x0D19C28, 0x0D218F4, 0x0D2E164, 0x0D3DC10, 0x0D48DCC,
        0x0D4FE98, 0x0D601D8, 0x0D638DC, 0x0D67568, 0x0D721F8, 0x0D7F2D8, 0x0D82F44, 0x0D87208, 0x0D88D04,
        0x0D95EB4, 0x0D97B80, 0x0D9D008, 0x0DA3CB4, 0x0DB90D8, 0x0DC0990, 0x0DCA378, 0x0DDA048, 0x0DE0F00,
        0x0DE4D3C, 0x0DE6C08, 0x0DFE818, 0x0E07C0C, 0x0E0C198, 0x0E0CCDC, 0x0E142BC, 0x0E17DBC, 0x0E1E4C0,
        0x0E2257C, 0x0E2E54C, 0x0E3E7E4, 0x0E445F0, 0x0E5EFD8, 0x0E65C84, 0x0E692E4, 0x0E706F8, 0x0E72270,
        0x0E773D0, 0x0E96DA0, 0x0E9FCEC, 0x0EAF170, 0x0EBC4D4, 0x0EBD028, 0x0ECB698, 0x0EDACD4, 0x0EE8B40,
        0x0EEA230, 0x0EF2144, 0x0F0B50C, 0x0F14924, 0x0F1537C, 0x0F16338, 0x0F18880, 0x0F19BF4, 0x0F1ACCC,
        0x0F1B9C8, 0x0F26D4C, 0x0F2F8F8, 0x0F34FF0, 0x0F3D598, 0x0F418C4, 0x0F46B00, 0x0F4C640, 0x0F53B04,
        0x0F61B70, 0x0F74644, 0x0F8FA5C, 0x0F9FC9C, 0x0FADD7C, 0x0FD0654, 0x0FDB9E4, 0x0FF2C3C, 0x100646C,
        0x100713C, 0x10174E8, 0x1026A1C, 0x1031A60, 0x103E358, 0x104A13C, 0x1053F6C, 0x105894C, 0x105FC70,
        0x106A49C, 0x10708E0, 0x1079D44, 0x1097AA4, 0x10A730C, 0x10BA544, 0x10BB114, 0x10BCD58, 0x10D4904,
        0x10E1C24, 0x10E46EC, 0x10E82F8, 0x10F3174, 0x10FC4CC, 0x1103BC4, 0x111593C, 0x111DEB0, 0x11403D0,
        0x1141434, 0x1149764, 0x115405C, 0x1163CC8, 0x1178500, 0x1184D48, 0x1191CD0, 0x119B698, 0x11A34FC,
        0x11BCE94, 0x11C1344, 0x11CC588, 0x11CDB90, 0x11DC41C, 0x11F273C, 0x11FB664, 0x1203444, 0x1209178,
        0x1210AE0, 0x121162C, 0x121DA3C, 0x122A844, 0x122DFA8, 0x1233800, 0x1238724, 0x123BE60, 0x124A684,
        0x124B1F0, 0x1251F7C, 0x1266424, 0x1276BAC, 0x127A9B4, 0x127B4C4, 0x1290F68, 0x1293FF8, 0x1294E28,
        0x12A609C, 0x12B687C, 0x12C0400, 0x12CFECC, 0x12D11E4, 0x12D272C, 0x12D8888, 0x12F0C74, 0x12F3998,
        0x12F781C, 0x12F8554, 0x12F9040, 0x12FCA10, 0x1310E7C, 0x131CEB0, 0x131EFF4, 0x131FB30, 0x1328854,
        0x13324EC, 0x134474C, 0x134E220, 0x134FDA8, 0x13538E8, 0x1357720, 0x135E47C, 0x136E934, 0x137022C,
        0x1377D8C, 0x137DCBC, 0x1382428, 0x13908A0, 0x1396EA8, 0x1397878, 0x13A4FE4, 0x13ABF94, 0x13B2724,
        0x13BD230, 0x13BF38C, 0x13C45A4, 0x13D3C68, 0x13D7390, 0x13EF6BC, 0x1400AB8, 0x14109AC, 0x1424024,
        0x143BFCC, 0x144C140, 0x146F748, 0x148576C, 0x14A9544, 0x14AEB2C, 0x14BB224, 0x14C1998, 0x14CD7C8,
        0x14D23EC, 0x14DAF5C, 0x14EC448, 0x14EE89C, 0x14FE514, 0x1504534, 0x150ECB8, 0x151852C,
      } },
      { "DATA07", new uint[] {
        0x6E44, 0x10A80, 0x17408, 0x20C78, 0x35274, 0x4DD44, 0x6836C, 0x7D8A8, 0x8CF64, 0x0A12A8, 0x0A712C,
        0x0B37DC, 0x0C77B0, 0x0CE758, 0x0D6AB0, 0x0FF0B8, 0x125694, 0x12ADE8, 0x1302C0, 0x13E80C, 0x14BBE0,
        0x1606FC, 0x167240, 0x1761D4, 0x1770F0, 0x183A94, 0x19218C, 0x1A73E0, 0x1B9044, 0x1D8D88, 0x1E2E34,
        0x1F6BC4, 0x201F60, 0x20C850, 0x215A08, 0x21EF2C, 0x22F85C, 0x23BB10, 0x2436F4, 0x245ADC, 0x24DCDC,
        0x250BB0, 0x25E924, 0x273630, 0x2868D8, 0x29B914, 0x2A0B04, 0x2AED68, 0x2B1108, 0x2BB328, 0x2C3C9C,
        0x2C7370, 0x2CCF10, 0x2D5784, 0x2E671C, 0x2FAE6C, 0x308C40, 0x315E54, 0x323CF8, 0x326A38, 0x32F768,
        0x3340B8, 0x33C728, 0x343850, 0x34C6C0, 0x3573F4, 0x36341C, 0x36556C, 0x375B90, 0x381EEC, 0x385958,
        0x38C074, 0x399880, 0x39C298, 0x3A9308, 0x3B5F40, 0x3BB600, 0x3C7A6C, 0x3D026C, 0x3D3E18, 0x3DC3F4,
        0x3F6A1C, 0x3FA1E4, 0x3FE6DC, 0x41628C, 0x41EA00, 0x422190, 0x424ADC, 0x440320, 0x45095C, 0x4567B4,
        0x45CA6C, 0x469ACC, 0x47A2D0, 0x47C4D8, 0x4834CC, 0x493934, 0x4AA068, 0x4B9C60, 0x4BFEC4, 0x4C2AF8,
        0x4CC418, 0x4E485C, 0x4E824C, 0x4EA7F8, 0x4FC810, 0x5124C0, 0x518E34, 0x519DF4, 0x52B2E0, 0x53B18C,
        0x53BEB0, 0x53DD98, 0x53FED8, 0x549FC0, 0x561460, 0x56FF4C, 0x58F2F8, 0x596E24, 0x5AB058, 0x5B4FDC,
        0x5B5EF8, 0x5C4730, 0x5CA11C, 0x5D8FB4, 0x5E2EFC, 0x5EC350, 0x5F90BC, 0x612FB8, 0x618FB0, 0x625B80,
        0x632A28, 0x635B94, 0x643E4C, 0x647034, 0x64E1F0, 0x6532B0, 0x658810, 0x669394, 0x6739A4, 0x67BA9C,
        0x682A9C, 0x690A54, 0x6A0A70, 0x6A608C, 0x6AD4A0, 0x6B1720, 0x6C1D18, 0x6C760C, 0x6CE948, 0x6D14F0,
        0x6D3080, 0x6DB3C4, 0x6DFC2C, 0x6E7E14, 0x6F34EC, 0x703C8C, 0x720C40, 0x726BA0, 0x72EB2C, 0x7334DC,
        0x7373E8, 0x73FAC8, 0x741E9C, 0x7477C4, 0x74E970, 0x75CEB0, 0x7739D4, 0x775D7C, 0x778D8C, 0x77DB4C,
        0x780210, 0x7830D8, 0x795E54, 0x7A43B0, 0x7A6A68, 0x7A7CD8, 0x7AAF08, 0x7AC26C, 0x7B8C7C, 0x7C4B60,
        0x7E07E4, 0x7FB7C8, 0x80E01C, 0x80EEFC, 0x8110FC, 0x826A3C, 0x836A84, 0x83D26C, 0x83FFA4, 0x84D9BC,
        0x85A314, 0x86C5F0, 0x88450C, 0x89266C, 0x8A6034, 0x8AB804, 0x8B0A84, 0x8C41A4, 0x8C6754, 0x8D7B60,
        0x8DFE18, 0x8E3CB0, 0x8EC00C, 0x8F1320, 0x8FB6B4, 0x908744, 0x9152A8, 0x91E7D8, 0x9202A4, 0x92C19C,
        0x94B9DC, 0x94CF88, 0x959E2C, 0x961998, 0x962910, 0x965858, 0x969CF4, 0x96B73C, 0x9713C0, 0x97451C,
        0x97FAB4, 0x986080, 0x98B878, 0x99DCB0, 0x9B23A0, 0x9C6CC8, 0x9C8B8C, 0x9D367C, 0x9D4A4C, 0x9DC794,
        0x9E9538, 0x9F8608, 0x0A03624, 0x0A0D4B4, 0x0A1AF4C, 0x0A261FC, 0x0A3BC3C, 0x0A43420, 0x0A4597C,
        0x0A50EE8, 0x0A600C0, 0x0A63888, 0x0A6AAC8, 0x0A6D260, 0x0A71BB4, 0x0A7E038, 0x0A88340, 0x0A9B490,
        0x0AA7ED4, 0x0AB3E08, 0x0AB6A34, 0x0ABC6C0, 0x0ABFC20, 0x0AC6A9C, 0x0AD24B0, 0x0AEC388, 0x0AFAF34,
        0x0B03074, 0x0B0E99C, 0x0B16314, 0x0B20258, 0x0B21268, 0x0B27BE0, 0x0B3111C, 0x0B365DC, 0x0B406CC,
        0x0B43764, 0x0B465FC, 0x0B4AD48, 0x0B559F8, 0x0B66698, 0x0B6AB5C, 0x0B77758, 0x0B80B68, 0x0B89EDC,
        0x0B91CFC, 0x0B97EB4, 0x0B9A8E4, 0x0BA0EB8, 0x0BAF038, 0x0BB79A0, 0x0BBD208, 0x0BC84D8, 0x0BCE5F8,
        0x0BD3F00, 0x0BDA47C, 0x0BDE398, 0x0BF36C8, 0x0BFC390, 0x0C07DB8, 0x0C0D504, 0x0C153A4, 0x0C1AC04,
        0x0C1D41C, 0x0C23C94, 0x0C325D4, 0x0C336A8, 0x0C35938, 0x0C45CA4, 0x0C4DBE4, 0x0C4F480, 0x0C5063C,
        0x0C6A2A8, 0x0C6B704, 0x0C764B8, 0x0C77EC4, 0x0C80CE8, 0x0C894F0, 0x0C8EFC0, 0x0C9730C, 0x0C9EB3C,
        0x0CA66F8, 0x0CADE4C, 0x0CB2BC8, 0x0CB4EF8, 0x0CB8F1C, 0x0CC70D8, 0x0CCBB60, 0x0CCE0E4, 0x0CECA4C,
        0x0D02630, 0x0D07B6C, 0x0D09A74, 0x0D1CCD4, 0x0D2B708, 0x0D2CD4C, 0x0D3F11C, 0x0D47D18, 0x0D4D690,
        0x0D596B8, 0x0D6653C, 0x0D6EFC4, 0x0D79818, 0x0D8C314, 0x0D98C2C, 0x0DA54D0, 0x0DB217C, 0x0DBBFB4,
        0x0DC5050, 0x0DC693C, 0x0DC84D8, 0x0DCED1C, 0x0DD16E8, 0x0DD8DAC, 0x0DDBC00, 0x0DEB68C, 0x0DEDFE4,
        0x0DF0CC4, 0x0DFC16C, 0x0E02568, 0x0E09C54, 0x0E0C834, 0x0E0DFA4, 0x0E0F778, 0x0E10B90, 0x0E1D518,
        0x0E3B35C, 0x0E41A80, 0x0E4ABAC, 0x0E5AB84, 0x0E6B890, 0x0E6D4D4, 0x0E7A7E0, 0x0E7CD0C, 0x0E84600,
        0x0E855B8, 0x0E8686C, 0x0E881B4, 0x0E91D94, 0x0E932F4, 0x0E954F8, 0x0EAD2AC, 0x0EB2E2C, 0x0EC4A78,
        0x0ECE9C0, 0x0EE051C, 0x0EE11E8, 0x0EF6150, 0x0F1A7F0, 0x0F38EF0, 0x0F53310, 0x0F5D9F8, 0x0F5F9E0,
        0x0F6BA74, 0x0F7E584, 0x0F876E8, 0x0F898C8, 0x0F9B1F0, 0x0FA8AA0, 0x0FC45CC, 0x0FE6BEC, 0x0FEFF58,
        0x0FFFA44, 0x100AF28, 0x1012834, 0x101AA4C, 0x101FCC0, 0x1039790, 0x1047BB4, 0x105AC7C, 0x1064A7C,
        0x1071628, 0x108AAC4, 0x108D4B0, 0x109877C, 0x10A5C48, 0x10B1030, 0x10BF594, 0x10C7E24, 0x10D2FD0,
        0x10DB050, 0x10DC4CC, 0x10E0D40, 0x10E3770, 0x10E6C10, 0x10FF68C, 0x1119034, 0x1128BE8, 0x112E4A0,
        0x1132F6C, 0x1143A70, 0x11474A0, 0x115C9F4, 0x116931C, 0x117E660, 0x11842C4, 0x119065C, 0x1196310,
        0x119C548, 0x11A6944, 0x11B43C8, 0x11BBBC4, 0x11C40AC, 0x11CCAC4, 0x11D2F50, 0x11D7E68, 0x11E1F60,
        0x11E92B8, 0x11FA0FC, 0x120B81C, 0x12167D4, 0x1219E90, 0x1222734, 0x122C6F0, 0x1237C5C, 0x1238C14,
        0x1241C84, 0x124DA50, 0x125351C, 0x125F5F0, 0x126D218, 0x127753C, 0x127C308, 0x1286EA8, 0x129B24C,
        0x12AC224, 0x12B1DDC, 0x12B7DF0, 0x12C4A2C, 0x12C726C, 0x12CD668, 0x12DF65C, 0x12F1134, 0x12F45C4,
        0x12FD5CC, 0x13020A8, 0x130C918, 0x1325DA8, 0x133759C, 0x13386DC, 0x13395A4, 0x134DC28, 0x13595B4,
        0x1364680, 0x136E0F0, 0x1374350, 0x137AB80, 0x1384D88, 0x138A4C8, 0x139EDCC, 0x13A84F8, 0x13BAF8C,
        0x13BF90C, 0x13D1E20, 0x13D6CE4, 0x13E344C, 0x13F054C, 0x13FA61C, 0x14018F0, 0x1413444, 0x14293D4,
        0x142FC0C, 0x1432170, 0x143D648, 0x1441AE0, 0x1469DC4, 0x147D92C, 0x1482DB4, 0x1489B54, 0x1497110,
        0x14AD5E8, 0x14B9C58, 0x14C4360, 0x14C620C, 0x14D38D0, 0x14D9684, 0x14E401C, 0x14E80AC, 0x14F9564,
        0x15151C0, 0x153B090, 0x153E848, 0x1546A70, 0x1557260, 0x155FFA0, 0x156865C, 0x1569DE8, 0x1571468,
        0x157CB04, 0x15A30F0, 0x15AEB5C, 0x15B86E8, 0x15C45F0, 0x15D3294, 0x15D9E74, 0x15E4370, 0x15F4A1C,
        0x1601104, 0x1611074, 0x161545C, 0x161BD40, 0x161CBC8, 0x16242F8, 0x16396DC, 0x1642E40, 0x164D8AC,
        0x1658734, 0x16632B4, 0x166DB1C, 0x167CDC8, 0x1681904, 0x168FDFC, 0x1696504, 0x169EDE8, 0x16AF530,
        0x16B3EE0, 0x16B694C, 0x16CB4C0, 0x16D0A20, 0x16D4A38, 0x16D9674, 0x16E4EF4, 0x16EACF4, 0x16EECE4,
        0x16F2404, 0x16F6E34, 0x17021C4, 0x1707FDC, 0x170F96C, 0x171A214, 0x171E168, 0x172AE2C, 0x1734798,
        0x1749704, 0x175684C, 0x1759FEC, 0x17654E0, 0x177295C, 0x1774D34, 0x177BC0C, 0x1780408, 0x1785AFC,
        0x178FCCC, 0x1799734, 0x17A1920, 0x17AC288, 0x17C3EBC, 0x17D0C94, 0x17D4CDC, 0x17DAE30, 0x17E48A4,
        0x17E57DC, 0x17EF5B0, 0x180ACEC, 0x180B9B0, 0x181414C, 0x18269AC, 0x1828850, 0x182F0A8, 0x18395F4,
        0x183E1C8, 0x18400A4, 0x184D5DC, 0x1852D44, 0x185D8CC, 0x1868F8C, 0x186AD48, 0x187BC4C, 0x187DCF4,
        0x1887200, 0x188DBF8, 0x18A434C, 0x18A948C, 0x18C218C, 0x18C3ABC, 0x18DE7D4, 0x18E3EE0, 0x18ED20C,
        0x18F1CC8, 0x18F5958, 0x1909CDC, 0x19109E0, 0x191BA40, 0x1920110, 0x192D8B0, 0x1932E98, 0x1939088,
        0x193B1E8, 0x1944CF4, 0x19498D8, 0x195A2B0, 0x1960A20, 0x1968398, 0x196B3F4, 0x1971408, 0x19751F0,
        0x1989528, 0x19983AC, 0x1999DC4, 0x19A027C, 0x19A64E4, 0x19B18C4, 0x19BF864, 0x19CA384, 0x19CEAD0,
        0x19D009C, 0x19D5FD4, 0x19D7B88, 0x19DD2B8, 0x19F4F14, 0x1A0527C, 0x1A0FF4C, 0x1A19948, 0x1A36888,
        0x1A3E930, 0x1A3FC3C, 0x1A4334C, 0x1A46C50, 0x1A4B6E0, 0x1A5F6B8, 0x1A61590, 0x1A66330, 0x1A6D424,
        0x1A782B8, 0x1A83C90, 0x1A93F18, 0x1A99C1C, 0x1AA1ABC, 0x1AA731C, 0x1AAA274, 0x1AB0AB8, 0x1ABF4AC,
        0x1AC06D0, 0x1AC2610, 0x1AD39F8, 0x1ADB294, 0x1ADDF80, 0x1ADF038, 0x1AFBA04, 0x1B08870, 0x1B0A198,
        0x1B0B5C8, 0x1B1B604, 0x1B2AAC8, 0x1B32654, 0x1B38D1C, 0x1B47A60, 0x1B54198, 0x1B66800, 0x1B74514,
        0x1B7536C, 0x1B898F8, 0x1B96B7C, 0x1B9A774, 0x1B9DD98, 0x1BA6990, 0x1BA9498, 0x1BB4C90, 0x1BBB1D0,
        0x1BC0800, 0x1BC4554, 0x1BCFB10, 0x1BE5A68, 0x1BEC460, 0x1BF6244, 0x1C05240, 0x1C0B80C, 0x1C0ED08,
        0x1C10854, 0x1C14528, 0x1C16B30, 0x1C19048, 0x1C3BC8C, 0x1C50714, 0x1C70EAC, 0x1C8B6F0, 0x1CB3A0C,
        0x1CD41DC, 0x1CE6A04, 0x1CFBA40, 0x1D14DC0, 0x1D1ABA4, 0x1D2F4B0, 0x1D47208, 0x1D57950, 0x1D600E4,
        0x1D72D28, 0x1D83D2C,
      } },
      { "DATA08", new uint[] {
        0x4A78, 0x0C2AC, 0x10B68, 0x17714, 0x214E0, 0x2C7D4, 0x3C880, 0x3D920, 0x49EEC, 0x535D4, 0x5F694,
        0x6632C, 0x6B080, 0x74D60, 0x7FACC, 0x889E0, 0x9D8B8, 0x0AD8E8, 0x0B3AE8, 0x0B92CC, 0x0BC484,
        0x0C22DC, 0x0CA9AC, 0x0D7488, 0x0DDB28, 0x0E974C, 0x0EBE00, 0x102698, 0x10A8C8, 0x10ECE4, 0x11B998,
        0x1285D4, 0x139EDC, 0x13C604, 0x145F38, 0x1505C4, 0x155984, 0x166274, 0x16AC8C, 0x17F1BC, 0x1892C0,
        0x191148, 0x1A0A20, 0x1A95FC, 0x1ADFA0, 0x1BBB80, 0x1C9D58, 0x1D2004, 0x1DC778, 0x1EE00C, 0x1FBB00,
        0x206DF4, 0x20E348, 0x21606C, 0x217ED8, 0x22327C, 0x22B708, 0x232948, 0x24004C, 0x247FA0, 0x24D8B4,
        0x25B194, 0x27122C, 0x27CC40, 0x28D004, 0x298B80, 0x2A8A9C, 0x2B5A9C, 0x2C67B8, 0x2D0D48, 0x2D87F4,
        0x2E0C6C, 0x2EF078, 0x2F6A30, 0x2FC7EC, 0x306C14, 0x30E7AC, 0x3162CC, 0x322190, 0x332824, 0x339CC0,
        0x345B84, 0x35DEA0, 0x371F0C, 0x38A838, 0x3A2FFC, 0x3B72BC, 0x3BE234, 0x3C8570, 0x3CA13C, 0x3DECF8,
        0x3F483C, 0x3F899C, 0x40D5D0, 0x42A4D8, 0x433984, 0x44D348, 0x45B68C, 0x45D608, 0x46F85C, 0x47439C,
        0x47E168, 0x490954, 0x496548, 0x4A2FF0, 0x4AF634, 0x4BF3D4, 0x4D7678, 0x4E4F3C, 0x4F9288, 0x50D764,
        0x51252C, 0x513CB0, 0x525E1C, 0x53B62C, 0x541DB8, 0x556F80, 0x562628, 0x5685E0, 0x571730, 0x5824C0,
        0x590754, 0x595EEC, 0x59B65C, 0x5B1F98, 0x5B5574, 0x5B9A80, 0x5BD8A4, 0x5C73B0, 0x5C88E8, 0x5C9F84,
        0x5CBB3C, 0x5D51F4, 0x5D98F8, 0x5E6174, 0x5F980C, 0x609C6C, 0x622928, 0x63CB14, 0x64E8C8, 0x651F38,
        0x65BF24, 0x672B28, 0x6777B4, 0x678A34, 0x68C318, 0x690CDC, 0x69EB74, 0x6A3538, 0x6A7374, 0x6AEE10,
        0x6B8D88, 0x6B9AF4, 0x6C01C0, 0x6C6D28, 0x6D0CA0, 0x6D73E0, 0x6DE790, 0x6E6E9C, 0x6ED82C, 0x6FB0C8,
        0x70D7B4, 0x719B90, 0x722050, 0x735420, 0x73DBA0, 0x73EF08, 0x7421C4, 0x74C13C, 0x755778, 0x75B498,
        0x763FC8, 0x766608, 0x76FB34, 0x782514, 0x787F20, 0x7890EC, 0x78C574, 0x7945FC, 0x79A0FC, 0x7A6FDC,
        0x7AA190, 0x7B61E8, 0x7BCB70, 0x7CFC60, 0x7DFB1C, 0x7EB0A4, 0x7F157C, 0x804B18, 0x808810, 0x809F08,
        0x80FD4C, 0x81A2E0, 0x82B370, 0x83D120, 0x842424, 0x84438C, 0x857404, 0x85F410, 0x86723C, 0x870498,
        0x872130, 0x87C7B8, 0x87F69C, 0x8923C8, 0x8A5878, 0x8AAEC0, 0x8B7DA0, 0x8BC5D8, 0x8CC328, 0x8DFD74,
        0x8E7FDC, 0x8F91D0, 0x90EED8, 0x9221B4, 0x92A1C0, 0x93C244, 0x94C264, 0x952DCC, 0x95F874, 0x96D474,
        0x980EC0, 0x996F88, 0x9AB1CC, 0x9B8C68, 0x9C6C28, 0x9CE07C, 0x9EB86C, 0x9FC71C, 0x0A0923C, 0x0A182E4,
        0x0A2C004, 0x0A3EB50, 0x0A51624, 0x0A59904, 0x0A5F220, 0x0A6B890, 0x0A70ED8, 0x0A858A0, 0x0A8769C,
        0x0A88704, 0x0A8A414, 0x0A99170, 0x0AAA094, 0x0ABFFF4, 0x0AC5A7C, 0x0AD6F84, 0x0AE6C9C, 0x0AF55C0,
        0x0B0A878, 0x0B0D9B8, 0x0B151E8, 0x0B21400, 0x0B22E2C, 0x0B28078, 0x0B2932C, 0x0B34A0C, 0x0B3D9A0,
        0x0B42920, 0x0B52F08, 0x0B53FDC, 0x0B6AB44, 0x0B7434C, 0x0B7B310, 0x0B7E158, 0x0B89EC4, 0x0B98B70,
        0x0BA2A74, 0x0BAFB84, 0x0BB0B68, 0x0BC28B4, 0x0BD5BFC, 0x0BE36F8, 0x0BE4B10, 0x0C00060, 0x0C10FF4,
        0x0C1240C, 0x0C215D8, 0x0C345D8, 0x0C48980, 0x0C54E68, 0x0C56BDC, 0x0C634F8, 0x0C6CED4, 0x0C765E4,
        0x0C854E4, 0x0C95F80, 0x0CAE250, 0x0CC25F8, 0x0CD7CD0, 0x0CD8C3C, 0x0CD9C20, 0x0CE72D0, 0x0CECB38,
        0x0CFD0AC, 0x0D027A8, 0x0D0AA9C, 0x0D11884, 0x0D1DC70, 0x0D2996C, 0x0D2EF00, 0x0D3C96C, 0x0D3D8D8,
        0x0D52130, 0x0D624C4, 0x0D7CFCC, 0x0D8E0F0, 0x0D9A5D8, 0x0DA668C, 0x0DB56F4, 0x0DC4DD0, 0x0DD9724,
        0x0DE4D34, 0x0DF77E0, 0x0E0A054, 0x0E2218C, 0x0E30B54, 0x0E3489C, 0x0E51654, 0x0E5CF50, 0x0E65B2C,
        0x0E77BD0, 0x0E82900, 0x0E859E8, 0x0E9DEF4, 0x0EABA94, 0x0EB6D14, 0x0EC3BC0, 0x0ECC3C8, 0x0ED3FDC,
        0x0EDD924, 0x0EE22A8, 0x0EF5860, 0x0EFD6AC, 0x0EFE980, 0x0F01AD8, 0x0F03530, 0x0F0A9C4, 0x0F17344,
        0x0F1BE44, 0x0F31C3C, 0x0F3EC5C, 0x0F4B7EC, 0x0F4D55C, 0x0F6C2F0, 0x0F86130, 0x0F9DB74, 0x0FA910C,
        0x0FC584C, 0x0FC6B90, 0x0FCD97C, 0x0FDA450, 0x0FE81B8, 0x0FFAC18, 0x1006850, 0x100BB3C, 0x100FB48,
        0x1014978, 0x10274BC, 0x1028714, 0x1037E80, 0x103923C, 0x103DBB8, 0x1042000, 0x1047F2C, 0x105B544,
        0x105C904, 0x1065224, 0x1075648, 0x1083CBC, 0x10860F8, 0x1093F68, 0x1099F80, 0x109F358, 0x10AAD3C,
        0x10C4E1C, 0x10D91A8, 0x10DC9EC, 0x10F4C68, 0x110F3A4, 0x1110894, 0x1115830, 0x11242A8, 0x112858C,
        0x1136F48, 0x114CF18, 0x115A184, 0x1165094, 0x116827C, 0x1171FE0, 0x1175280, 0x117ED10, 0x1180588,
        0x1181F68, 0x1187838, 0x118B574, 0x11965F0, 0x11A4FB0, 0x11A64A0, 0x11A809C, 0x11A9C98, 0x11ABD8C,
        0x11B1F88, 0x11C110C, 0x11CF580, 0x11D09C0, 0x11E1490, 0x11ED798, 0x11F6B08, 0x11FF390, 0x1200500,
        0x1204684, 0x120699C, 0x121EC90, 0x1222FA4, 0x12331DC, 0x12430F8, 0x12455A0, 0x1248718, 0x124F5E0,
        0x1258068, 0x12646AC, 0x126F5C8, 0x1274FA8, 0x127FF3C, 0x12844C0, 0x129126C, 0x12A5F7C, 0x12AE560,
        0x12C7E64, 0x12C91E0, 0x12D1148, 0x12E1EE0, 0x12E688C, 0x12F6FAC, 0x1303754, 0x1304D20, 0x1308620,
        0x1315268, 0x1333338, 0x133ABB0, 0x134A310, 0x134B77C, 0x13531D0, 0x1355498, 0x135C780, 0x135DAFC,
        0x1364514, 0x136E5D8, 0x13831F8, 0x139010C, 0x13971A4, 0x13A19CC, 0x13AC7F8, 0x13BBA3C, 0x13C43D4,
        0x13D4C58, 0x13E3AEC, 0x13EDA48, 0x13FDB60, 0x14093C4, 0x1418594, 0x1429848, 0x143DA38, 0x144C764,
        0x145A61C, 0x146C2A8, 0x147A070, 0x1482A10, 0x149E2D4, 0x14A8EDC, 0x14AEAEC, 0x14B9FCC, 0x14BD810,
        0x14C29E4, 0x14D5894, 0x14D6AB8, 0x14D8C34, 0x14E0A34, 0x14EC0F0, 0x14ED6CC, 0x14F5C3C, 0x14F9D6C,
        0x1504114, 0x1505FC8, 0x15114A8, 0x152188C, 0x15249D8, 0x152DF90, 0x153FF4C, 0x154B3B4, 0x154E500,
        0x1553FB0, 0x155D314, 0x156AB44, 0x15716AC, 0x157C8BC, 0x15822F0, 0x15838CC, 0x15A103C, 0x15AB5C0,
        0x15AF574, 0x15B7DAC, 0x15C2B90, 0x15D199C, 0x15E457C, 0x15ECDB4, 0x15EF450, 0x15F6AE4, 0x1603864,
        0x16054C8, 0x1608438, 0x160B240, 0x1619864, 0x1624988, 0x162C358, 0x163FA64, 0x164B260, 0x166470C,
        0x167CC0C, 0x1685484, 0x168DD00, 0x1694E28, 0x169FF6C, 0x16A6D70, 0x16B477C, 0x16C0380, 0x16C5900,
        0x16D2274, 0x16D61C8, 0x16DE32C, 0x16F9148, 0x16FD09C, 0x1701D58, 0x170BD3C, 0x17169A8, 0x1727D68,
        0x173C194, 0x1746BB8, 0x1758824, 0x175B428, 0x1761738, 0x176D268, 0x1773088, 0x1778224, 0x177DB5C,
        0x1786D70, 0x1794BA8, 0x17A46A0, 0x17ADC30, 0x17B6A58, 0x17C00CC, 0x17C1214, 0x17C9334, 0x17CCB34,
        0x17D651C, 0x17DA794, 0x17DB94C, 0x17DE440, 0x17E4C94, 0x17EE374, 0x17F3138, 0x18032B4, 0x180E64C,
        0x1811608, 0x181D3A0, 0x18273A0, 0x1833834, 0x1839920, 0x1846EA8, 0x1849C58, 0x184D6C4, 0x1851968,
        0x1865E3C, 0x187B560, 0x1895020, 0x189EC3C, 0x18C1100, 0x18CA5CC, 0x18D511C, 0x18D8968, 0x18E4AC8,
        0x18E5A3C, 0x18E8564, 0x18F7630, 0x18FB330, 0x1913588, 0x192C66C, 0x1938C08, 0x1954818, 0x196B7A4,
        0x197D19C, 0x198BBD4, 0x1998DA4, 0x19ADB64, 0x19BCE14, 0x19C74B8, 0x19D0188, 0x19DEA5C, 0x19E564C,
        0x19F1CDC, 0x19FE200, 0x1A10F1C, 0x1A2B378, 0x1A42CF4, 0x1A44558, 0x1A479E8, 0x1A4F02C, 0x1A598B0,
        0x1A6CC9C, 0x1A7B8B4, 0x1A83240, 0x1A85B88, 0x1A8CF74, 0x1A9A39C, 0x1AA8380, 0x1AB7A68, 0x1AC5250,
        0x1ACC6B8, 0x1ADBBC0, 0x1AE6E60, 0x1AF1CBC, 0x1B01348, 0x1B0E070, 0x1B192EC, 0x1B219B8, 0x1B2EBEC,
        0x1B38B18, 0x1B44054, 0x1B49C6C, 0x1B4F628, 0x1B61DE4, 0x1B6A43C, 0x1B7C250, 0x1B8BA40, 0x1B96470,
        0x1B99D14, 0x1BA94FC, 0x1BBE868, 0x1BC1F34, 0x1BC4F90, 0x1BE41A0, 0x1BEA064, 0x1BFCD30, 0x1C0A9FC,
        0x1C1ED50, 0x1C25B44, 0x1C385C4, 0x1C485F4, 0x1C5F148, 0x1C682A8, 0x1C6A8AC, 0x1C73DA0, 0x1C89D98,
        0x1CA6A24, 0x1CBD3EC, 0x1CC2080, 0x1CC4CA0, 0x1CCD55C, 0x1CD9060, 0x1CDB40C, 0x1CE1A78, 0x1CE5710,
        0x1CEC398, 0x1CF80F4, 0x1D031A4, 0x1D09C4C, 0x1D21874, 0x1D277D0, 0x1D3A508, 0x1D4AA6C, 0x1D4DE14,
        0x1D535EC, 0x1D5D6A0, 0x1D75D9C, 0x1D8C3F0, 0x1D97950, 0x1DAD9C4, 0x1DC024C, 0x1DC45F0, 0x1DD9408,
        0x1DE1010, 0x1DE3C30, 0x1DEE288, 0x1E0391C, 0x1E18E30, 0x1E23AA4, 0x1E32AC0, 0x1E44D2C, 0x1E46FEC,
        0x1E4F82C,
      } },
      { "DATA09", new uint[] {
        0x7ED8, 0x17218, 0x25544, 0x362E4, 0x3F1BC, 0x40550, 0x4DBB0, 0x5CE38, 0x749D4, 0x7F278, 0x935CC,
        0x9DF3C, 0x9F834, 0x0A1B6C, 0x0ABF30, 0x0AFF88, 0x0B6388, 0x0B9C38, 0x0C2A48, 0x0C3A30, 0x0CBB18,
        0x0D2F6C, 0x0E25EC, 0x0E5630, 0x0E9768, 0x0FDE28, 0x106690, 0x10D720, 0x11751C, 0x129BAC, 0x13037C,
        0x13151C, 0x13F2F0, 0x150A58, 0x16AB58, 0x182940, 0x191B70, 0x19ECC0, 0x1B7AEC, 0x1C5A70, 0x1E1118,
        0x1E2528, 0x1E5DF8, 0x1EC6A8, 0x1FDE3C, 0x2071B0, 0x224614, 0x22F848, 0x23EB18, 0x24ADAC, 0x257C64,
        0x263B2C, 0x26DAE4, 0x278D14, 0x284C6C, 0x28F9B0, 0x29B148, 0x2A5938, 0x2B0898, 0x2BBB8C, 0x2C58B8,
        0x2C74D8, 0x2CDE20, 0x2E5A9C, 0x2ED75C, 0x2FA9C0, 0x30CF40, 0x32EB7C, 0x334464, 0x339998, 0x341858,
        0x350938, 0x361394, 0x36FFD8, 0x37A27C, 0x383878, 0x38D610, 0x3976D4, 0x3A1CF0, 0x3BB3A8, 0x3CFEBC,
        0x3D64A0, 0x3DF8AC, 0x3E27A4, 0x3ECD30, 0x3F0490, 0x3F7218, 0x40C018, 0x425E38, 0x43E6C0, 0x455800,
        0x458AB0, 0x469AF0, 0x47D170, 0x48DD70, 0x495470, 0x496408, 0x4A0798, 0x4AD354, 0x4B5CE4, 0x4C8E44,
        0x4DA0B8, 0x4EBC80, 0x4F1530, 0x4FAF48, 0x5026A8, 0x50E484, 0x51D620, 0x52585C, 0x52C3BC, 0x536BB4,
        0x53BFC8, 0x53F9A8, 0x54B0C4, 0x565540, 0x57D2C8, 0x592748, 0x59B9C8, 0x5B7B90, 0x5C817C, 0x5DADD0,
        0x5E79CC, 0x5EE3B0, 0x5F0460, 0x5F8F9C, 0x601558, 0x6137E4, 0x61FED4, 0x62D520, 0x6461CC, 0x647224,
        0x64C924, 0x65089C, 0x65B0F4, 0x6655C0, 0x666AC0, 0x66B4C0, 0x671FB8, 0x67C900, 0x68A2B8, 0x68EC30,
        0x692150, 0x6949DC, 0x6A7000, 0x6A850C, 0x6AC9EC, 0x6B03D0, 0x6B192C, 0x6C9618, 0x6E8D34, 0x6F0F74,
        0x7172C8, 0x71E888, 0x7218F4, 0x7328AC, 0x73CE90, 0x73F494, 0x7415E4, 0x74D248, 0x7517FC, 0x759F70,
        0x75C394, 0x768A58, 0x76D670, 0x76F800, 0x771EF8, 0x779880, 0x7904F4, 0x79986C, 0x7A25C8, 0x7AD5F8,
        0x7C3F70, 0x7C5DF4, 0x7D180C, 0x7DDC30, 0x7E0070, 0x7E82EC, 0x7EF8D8, 0x7FAC00, 0x7FDE10, 0x807E30,
        0x81F4B8, 0x832D80, 0x83A9BC, 0x84F684, 0x862270, 0x876D54, 0x879138, 0x87D9D0, 0x88A524, 0x88EE0C,
        0x893B50, 0x896B8C, 0x89D33C, 0x8A3AF4, 0x8ACF90, 0x8B0924, 0x8D9438, 0x8EC124, 0x8F97AC, 0x8FF8D0,
        0x90337C, 0x9177E4, 0x91A83C, 0x922F3C, 0x927130, 0x92A6EC, 0x930418, 0x94B96C, 0x952680, 0x95F8C8,
        0x96883C, 0x974204, 0x98C598, 0x99A898, 0x9B2D64, 0x9BDBA4, 0x9C73B0, 0x9CB2C8, 0x9D651C, 0x9D9D84,
        0x9DB214, 0x9E54A0, 0x9EB728, 0x9F1F1C, 0x9FE3D8, 0x0A08E20, 0x0A0B200, 0x0A0DEC4, 0x0A130C4,
        0x0A15F94, 0x0A2B540, 0x0A371E8, 0x0A47110, 0x0A58730, 0x0A671C0, 0x0A76E60, 0x0A7E740, 0x0A8C150,
        0x0A97ECC, 0x0A99F40, 0x0A9E740, 0x0AAAE90, 0x0AB4CE8, 0x0AC1518, 0x0AC5DA0, 0x0AC6E74, 0x0AD4C14,
        0x0ADB9E8, 0x0AF4290, 0x0B00204, 0x0B0A780, 0x0B164E4, 0x0B1B108, 0x0B1C0FC, 0x0B1EFE4, 0x0B26C74,
        0x0B2E8D0, 0x0B30224, 0x0B44698, 0x0B5806C, 0x0B6DACC, 0x0B87464, 0x0B9B944, 0x0BA0278, 0x0BA7940,
        0x0BB1A0C, 0x0BB74D4, 0x0BBED7C, 0x0BC8694, 0x0BCF720, 0x0BD1A64, 0x0BD75A0, 0x0BE60AC, 0x0BEA0C4,
        0x0BED4E8, 0x0BF1954, 0x0BF3D48, 0x0BF6258, 0x0BF8D0C, 0x0C09824, 0x0C0F3F4, 0x0C17E54, 0x0C350D0,
        0x0C3F10C, 0x0C3FF8C, 0x0C4432C, 0x0C5F344, 0x0C655B8, 0x0C66CD8, 0x0C6897C, 0x0C83304, 0x0C8D440,
        0x0C987A8, 0x0C9DC7C, 0x0C9EC74, 0x0CA2344, 0x0CAE020, 0x0CB97A8, 0x0CC4E40, 0x0CD1A2C, 0x0CD32A8,
        0x0CDF6CC, 0x0CE2D80, 0x0CEFF80, 0x0CF0FE0, 0x0CF8104, 0x0D0D4E4, 0x0D0FEDC, 0x0D20ED8, 0x0D328A4,
        0x0D3D9F0, 0x0D4F664, 0x0D67250, 0x0D77A90, 0x0D7E510, 0x0D8A0F8, 0x0D96FEC, 0x0DA0F44, 0x0DA998C,
        0x0DB77F8, 0x0DBB29C, 0x0DC018C, 0x0DC8DE8, 0x0DD2E64, 0x0DE87E4, 0x0E051F4, 0x0E0B4F0, 0x0E0C578,
        0x0E178A0, 0x0E280D8, 0x0E37BC4, 0x0E3B2B0, 0x0E44260, 0x0E504BC, 0x0E5F710, 0x0E6FF64, 0x0E81E98,
        0x0E8FDF8, 0x0EA9BA4, 0x0ECA6D4, 0x0ED29A0, 0x0ED4AE8, 0x0ED6090, 0x0EE694C, 0x0F04638, 0x0F0CA24,
        0x0F0E40C, 0x0F0F5F4, 0x0F15AE0, 0x0F2F8F4, 0x0F38FC8, 0x0F3BF60, 0x0F400E4, 0x0F4687C, 0x0F476C0,
        0x0F48CDC, 0x0F56D30, 0x0F59AF0, 0x0F6949C, 0x0F6CE80, 0x0F837B8, 0x0F8D4B0, 0x0F908E8, 0x0F95B50,
        0x0F9C468, 0x0FAED24, 0x0FBEBE8, 0x0FC8324, 0x0FCC1E4, 0x0FE4E9C, 0x0FE77A4, 0x0FE8B98, 0x0FEB774,
        0x1009D4C, 0x1011B88, 0x10209B8, 0x102B088, 0x102EEF4, 0x1034484, 0x1036C34, 0x1039AE4, 0x103B974,
        0x103F040, 0x1055920, 0x1063CE4, 0x106D3D4, 0x1084714, 0x108DCB0, 0x1092F24, 0x1097130, 0x109B548,
        0x10A4B38, 0x10A8530, 0x10B1EB4, 0x10B37B4, 0x10B511C, 0x10D7500, 0x10EA9DC, 0x10FAEA0, 0x1106224,
        0x110797C, 0x111CE9C, 0x1128F84, 0x113D200, 0x1148F6C, 0x114C790, 0x11549F8, 0x115CB04, 0x1169690,
        0x11767E0, 0x118B720, 0x11916FC, 0x11A27DC, 0x11A8AA0, 0x11ABBF8, 0x11B4490, 0x11C1BEC, 0x11D47B4,
        0x11DA060, 0x11EA540, 0x11F3E48, 0x1202FF4, 0x120ED08, 0x12126D8, 0x1220174, 0x1229974, 0x1238DDC,
        0x123B624, 0x123CF3C, 0x1242350, 0x1243150, 0x1245A70, 0x124719C, 0x1249634, 0x124B3E8, 0x124D3B8,
        0x125FDC8, 0x126EF60, 0x127680C, 0x127EC0C, 0x12863EC, 0x129BF38, 0x12A6078, 0x12A92DC, 0x12AE370,
        0x12B9330, 0x12C8604, 0x12DB7B8, 0x12E87E8, 0x12F73AC, 0x13092B4, 0x1310EF0, 0x13196A0, 0x132FEE0,
        0x133CA3C, 0x134AD6C, 0x13576E0, 0x135FFB4, 0x136282C, 0x13682A0, 0x136CDB4, 0x136DF84, 0x13734FC,
        0x1379CFC, 0x13829B4, 0x1387858, 0x13969D4, 0x139ADA4, 0x13A048C, 0x13AA334, 0x13B9374, 0x13C1940,
        0x13D4240, 0x13E0F94, 0x13F9124, 0x1408DD8, 0x140D910, 0x141833C, 0x141B43C, 0x14212C0, 0x142955C,
        0x1435C0C, 0x144B1C0, 0x145B720, 0x14805D4, 0x1494004, 0x14A08A8, 0x14B3B9C, 0x14D2FB0, 0x14D3FA4,
        0x14D51F8, 0x14E1B70, 0x14EEE20, 0x14F4860, 0x14FA334, 0x150309C, 0x150F998, 0x1528468, 0x152CBD8,
        0x153D3A0, 0x1541B30,
      } },
      { "DATA10", new uint[] {
        0x2550, 0x0C368, 0x15670, 0x1C950, 0x2572C, 0x26C84, 0x2F638, 0x3AF00, 0x3DF5C, 0x3F4C0, 0x47C74,
        0x50F18, 0x584E0, 0x5D264, 0x6C20C, 0x788B0, 0x816B4, 0x83EE0, 0x85DF0, 0x9F6E8, 0x0A4AA0, 0x0B74F4,
        0x0C76FC, 0x0C8C8C, 0x0CDE1C, 0x0DE8D0, 0x0F5284, 0x10971C, 0x10E9F8, 0x10FE5C, 0x1312D4, 0x13EA54,
        0x1476E8, 0x16C614, 0x1838CC, 0x199158, 0x1A3D98, 0x1A96B4, 0x1BFBC8, 0x1D92A4, 0x1E41A0, 0x202880,
        0x2074C4, 0x21CC14, 0x21EFA0, 0x2277F8, 0x2341F8, 0x23AA90, 0x243DB4, 0x257BD4, 0x25E508, 0x25FBB4,
        0x265338, 0x26A0D0, 0x26DF74, 0x27D224, 0x286EF4, 0x28CCE4, 0x293A6C, 0x29E0A4, 0x2BD488, 0x2D021C,
        0x2DB9DC, 0x2FDA14, 0x304FB4, 0x324FE8, 0x33A7F8, 0x34F8E0, 0x3513E8, 0x353730, 0x35F748, 0x37275C,
        0x38614C, 0x3A2F00, 0x3AD230, 0x3C7EEC, 0x3E330C, 0x3F2D0C, 0x4091F0, 0x4122E4, 0x43109C, 0x440CB4,
        0x446404, 0x447E58, 0x465574, 0x466E34, 0x46FE94, 0x47707C, 0x487570, 0x49B9F4, 0x4A6750, 0x4C7488,
        0x4D866C, 0x4E62A0, 0x509278, 0x5235DC, 0x539CEC, 0x5545BC, 0x5591EC, 0x563098, 0x567F20, 0x570FDC,
        0x580CD0, 0x591B5C, 0x5A0760, 0x5AFF60, 0x5BC7D8, 0x5C9A94, 0x5CB818, 0x5CCCC4, 0x5D65F0, 0x5DB4E0,
        0x5DE568, 0x5E1674, 0x5EA2DC, 0x5EEA4C, 0x5F0710, 0x5F23E4, 0x5F6B98, 0x5F99D8, 0x604044, 0x60C5FC,
        0x61BFBC, 0x6335D4, 0x63DF70, 0x644A7C, 0x64C690, 0x64E87C, 0x65771C, 0x662B08, 0x6645C0, 0x673CDC,
        0x6755B8, 0x684C98, 0x6860AC, 0x6916E8, 0x695A5C, 0x69E524, 0x6A70C4, 0x6B91C0, 0x6BC83C, 0x6C4308,
        0x6D68DC, 0x6DBEF4, 0x6E61A8, 0x6FEC58, 0x708194, 0x711554, 0x716C3C, 0x727908, 0x730944, 0x7475C4,
        0x75BB2C, 0x75DDC0, 0x767A84, 0x76ED60, 0x7789C8, 0x77E838, 0x785170, 0x789434, 0x795CDC, 0x79ECF0,
        0x7A5D80, 0x7AFF28, 0x7B74D4, 0x7BE820, 0x7DD560, 0x7EA710, 0x7FDBEC, 0x7FEDEC, 0x810BE0, 0x8126C8,
        0x8267BC, 0x835DD0, 0x8526F4, 0x8576C4, 0x859428, 0x85AB9C, 0x85B9B0, 0x864148, 0x87CE90, 0x8886FC,
        0x88AE0C, 0x890520, 0x8A4630, 0x8B9B34, 0x8D83D0, 0x8D9014, 0x8E43C8, 0x8F8040, 0x90CE50, 0x91DE40,
        0x925F30, 0x939698, 0x9434BC, 0x94D6B0, 0x9557B0, 0x95E774, 0x96AE78, 0x986FE8, 0x989CEC, 0x9B6D24,
        0x9BA948, 0x9C4964, 0x9D2C80, 0x9F30EC, 0x0A03668, 0x0A043C0, 0x0A1093C, 0x0A2B01C, 0x0A36DE8,
        0x0A42C0C, 0x0A4B2E4, 0x0A4DC34, 0x0A4FEA8, 0x0A58E64, 0x0A5B084, 0x0A65008, 0x0A6B8B0, 0x0A744CC,
        0x0A77FF4, 0x0A81D9C, 0x0A86A3C, 0x0A8BB2C, 0x0A93E60, 0x0A974E4, 0x0A9A830, 0x0A9C6D4, 0x0A9F398,
        0x0AAA90C, 0x0AB7A9C, 0x0AC2B74, 0x0AD761C, 0x0AF2188, 0x0AF6DA8, 0x0AFF084, 0x0B17AF8, 0x0B193D8,
        0x0B1A538, 0x0B1BA74, 0x0B20E3C, 0x0B2D850, 0x0B31438, 0x0B3FF00, 0x0B44614, 0x0B5E3CC, 0x0B6A4D0,
        0x0B6B2D4, 0x0B724CC, 0x0B740A0, 0x0B7D670, 0x0B82508, 0x0B84204, 0x0B861D8, 0x0B9EFE4, 0x0BA7400,
        0x0BA81F8, 0x0BBA3E0, 0x0BBBF2C, 0x0BC7EB8, 0x0BCD0A4, 0x0BD4A90, 0x0BD6C30, 0x0BDEC7C, 0x0BFFEB4,
        0x0C07B30, 0x0C09660, 0x0C0B760, 0x0C11C8C, 0x0C272B0, 0x0C31F50, 0x0C3766C, 0x0C583D0, 0x0C78B0C,
        0x0C8406C, 0x0CA5F40, 0x0CA6DB4, 0x0CB8EEC, 0x0CB9BFC, 0x0CBC8C8, 0x0CC4550, 0x0CE6F48, 0x0CEB918,
        0x0D05FC0, 0x0D0918C, 0x0D17AE8, 0x0D37A20, 0x0D43A08, 0x0D5746C, 0x0D8089C, 0x0D945B0, 0x0DB5A68,
        0x0DCD2BC, 0x0DDA4C0, 0x0DF3C38, 0x0DFE468, 0x0E188A0, 0x0E43E2C, 0x0E62D54, 0x0E69428, 0x0E728D8,
        0x0E76EC0, 0x0E7ACCC, 0x0E7FF84, 0x0E84FDC, 0x0E8C0D8, 0x0E8F608, 0x0E9121C, 0x0E92ED8, 0x0E952A4,
        0x0EA073C, 0x0EAF4F4, 0x0EB8A20, 0x0EC9B98, 0x0ED61C4, 0x0EE2560, 0x0EEABD4, 0x0EEC404, 0x0EFE038,
        0x0F06080, 0x0F26F38, 0x0F3A6B8, 0x0F5B040, 0x0F5FCEC, 0x0F61CCC, 0x0F6E2D0, 0x0F6F294, 0x0F83AA8,
        0x0F90880, 0x0F9B598, 0x0F9D20C, 0x0FA871C, 0x0FA9924, 0x0FB32E0, 0x0FCB5B0, 0x0FCD744, 0x0FDADD4,
        0x0FE88F8, 0x0FE9FF0, 0x0FEB264, 0x0FFD95C, 0x1009324, 0x10150F8, 0x101B798, 0x1025E60, 0x102F4BC,
        0x1031BEC, 0x1033278, 0x1036788, 0x103D660, 0x1040288, 0x1056058, 0x10645F0, 0x1068728, 0x10760F4,
        0x108C340, 0x1092580, 0x109F6F0, 0x10AFB28, 0x10C0878, 0x10C1544, 0x10CD9C8, 0x10DC6DC, 0x10ECB80,
        0x10F6584, 0x1100DA8, 0x11063E0, 0x11082C8, 0x110B5C8, 0x1113FCC, 0x113365C, 0x11487A0, 0x115F7CC,
        0x116F024, 0x119432C, 0x11AF454, 0x11D4228, 0x11F8C48, 0x121C904, 0x1233064, 0x1244268, 0x1245CD4,
        0x124CEF8, 0x124F878, 0x12585F0, 0x1273074, 0x1273C94, 0x12798F0, 0x1285E64, 0x12958E8, 0x12A0570,
        0x12A7CA4, 0x12AA1F4, 0x12AD4E8, 0x12B08DC, 0x12B7738, 0x12BD974, 0x12BF7D8, 0x12C0914, 0x12CA2A4,
        0x12D4898, 0x12DEF18, 0x12E9258, 0x12EBF58, 0x12F03A0, 0x1306CF8, 0x130CDB8, 0x131FFF0, 0x13227A8,
        0x13355B0, 0x1336BAC, 0x1340A5C, 0x1343D3C, 0x134F388, 0x13645CC, 0x1370338, 0x13777EC, 0x137CDCC,
        0x1386690, 0x139BAE8, 0x13A793C, 0x13B1318, 0x13CE438, 0x13E0E0C, 0x13EC668, 0x13ED634, 0x13FC150,
        0x13FD44C, 0x141D6F8, 0x1429868, 0x14420C0, 0x144A7D4, 0x1460468, 0x146DE64, 0x1471BD4, 0x1478200,
        0x1479770, 0x14879EC, 0x1490994, 0x149FA88, 0x14AA8EC, 0x14B52A0, 0x14B9C48, 0x14C5590, 0x14D28E4,
        0x14E1D60, 0x14E6574, 0x14E8290, 0x14EDDDC, 0x14FA104, 0x1501728, 0x1508C18, 0x150C2E8, 0x151047C,
        0x151CE4C, 0x151F66C, 0x1540238, 0x154957C, 0x155A214, 0x155BF04, 0x1567378, 0x157C8E0, 0x1585408,
        0x158F81C, 0x15914A8, 0x159DCE0, 0x15B2614, 0x15C7970, 0x15D36C4, 0x15E0E20, 0x15E4DE4, 0x15EE6DC,
        0x16073B8, 0x161B994, 0x1621CA8, 0x1629324, 0x162C23C, 0x1632B70, 0x163B230, 0x163DCE4, 0x164558C,
        0x16463CC, 0x1650548, 0x165EE8C, 0x1668E0C, 0x167F1F4, 0x1693AF0, 0x16AC0AC, 0x16B45DC, 0x16C4FB8,
        0x16D5E14, 0x16E3DA4, 0x1700634, 0x1708AA4, 0x1717078, 0x1717E3C, 0x17274A0, 0x1733854, 0x173E470,
        0x1744264, 0x1746AF4, 0x174AE90, 0x1756E48, 0x175EE24, 0x1769E34, 0x176B6B0, 0x17756A0, 0x177ED54,
        0x1792668, 0x17A9EA4, 0x17B5768, 0x17B8B00, 0x17C4B8C, 0x17CDA48, 0x17D321C, 0x17DC244, 0x17E4D08,
        0x17E68B4, 0x17E7568, 0x17F1D88, 0x1807E4C, 0x180B1FC, 0x1818A88, 0x1823E00, 0x1833920, 0x183D818,
        0x184AA78, 0x1853054, 0x186726C, 0x186858C, 0x18773EC, 0x1880F88, 0x18825F0, 0x188F1D8, 0x1897CFC,
        0x18A5AC8, 0x18CD434, 0x18ED1CC, 0x18FDDD8, 0x1921440, 0x192B444, 0x19367C8, 0x193F178, 0x1947BA0,
        0x195B294, 0x1967FF4, 0x19742BC, 0x1982898, 0x19842B0, 0x198DCB4, 0x1991DD4, 0x19983E0, 0x19A13CC,
        0x19B6788, 0x19D0504, 0x19DA788, 0x19DC440, 0x19DEA00, 0x19E9070, 0x19EB004, 0x19FF030, 0x1A043E4,
        0x1A17990, 0x1A18D58, 0x1A1CF58, 0x1A1F598, 0x1A2601C, 0x1A289F4, 0x1A33EF0, 0x1A3EBC0, 0x1A41068,
        0x1A44E0C, 0x1A49980, 0x1A5BD64, 0x1A5DEAC, 0x1A68818, 0x1A6C058, 0x1A76D0C, 0x1A79B70, 0x1A7EB4C,
        0x1A81CCC, 0x1A83D64, 0x1A87380, 0x1A881F8, 0x1A8A1B4, 0x1A9D5DC, 0x1AA8564, 0x1AC113C, 0x1AD2974,
        0x1AEA384, 0x1AFDED8, 0x1B16BF0, 0x1B23F3C, 0x1B3ECBC, 0x1B5B168, 0x1B6259C, 0x1B796D4, 0x1B8706C,
        0x1B999DC, 0x1B9ACB0, 0x1B9DE90, 0x1BA7A3C, 0x1BBED48, 0x1BCA510, 0x1BE3640, 0x1BF2E58, 0x1C06580,
        0x1C18CE0, 0x1C3FA30, 0x1C4F87C, 0x1C58424, 0x1C6C5D0, 0x1C7C108, 0x1C8A5C4, 0x1CA0768, 0x1CB67F4,
        0x1CB7E18, 0x1CB9EA4,
      } },
      { "DATA11", new uint[] {
        0x43BC, 0x0E140, 0x22164, 0x283C4, 0x378A4, 0x395B8, 0x3B598, 0x492D4, 0x5100C, 0x5B638, 0x5C7D8,
        0x60418, 0x6A2A0, 0x790CC, 0x94970, 0x0A2E34, 0x0AAE5C, 0x0ACF8C, 0x0BA8E0, 0x0C1034, 0x0C8608,
        0x0CA6E8, 0x0D3990, 0x0D5150, 0x0DAD50, 0x0E6F28, 0x0F74D4, 0x0FBA14, 0x104988, 0x108648, 0x10A794,
        0x10F570, 0x11010C, 0x111FEC, 0x11869C, 0x11C480, 0x1208E4, 0x124728, 0x133650, 0x1347F0, 0x13B6CC,
        0x13F684, 0x14A45C, 0x153CD8, 0x169870, 0x186CA4, 0x199320, 0x1A54F4, 0x1ACC54, 0x1B4764, 0x1BBD54,
        0x1C9F68, 0x1D0C60, 0x1E7D64, 0x1F0A80, 0x1FB908, 0x1FD3F0, 0x2090F4, 0x20A3F8, 0x21074C, 0x2154EC,
        0x217BAC, 0x221358, 0x223E20, 0x23C304, 0x241DE0, 0x250548, 0x251930, 0x254308, 0x26443C, 0x26EE88,
        0x272B78, 0x276A68, 0x27F9AC, 0x28BBD4, 0x296EC8, 0x297C84, 0x2A0CFC, 0x2A4CBC, 0x2AFF40, 0x2BEA94,
        0x2D0FC0, 0x2D2928, 0x2E73B8, 0x2EBB28, 0x3077F0, 0x3110FC, 0x31CE34, 0x324BAC, 0x327A54, 0x337C1C,
        0x3401A0, 0x3521B8, 0x359D88, 0x36F084, 0x3742D8, 0x37CA48, 0x393CB0, 0x396A2C, 0x39A720, 0x39F580,
        0x3A6ECC, 0x3B210C, 0x3BC2BC, 0x3C3024, 0x3C74E0, 0x3CD368, 0x3E877C, 0x3FC000, 0x410480, 0x4269BC,
        0x429E58, 0x42D69C, 0x436764, 0x446C00, 0x4487D4, 0x45FF70, 0x46E49C, 0x4769A0, 0x4893D8, 0x498760,
        0x4ADADC, 0x4AEF78, 0x4B6050, 0x4BF1E0, 0x4D9D6C, 0x4E0A08, 0x4F582C, 0x50397C, 0x5064BC, 0x509030,
        0x50EFEC, 0x51FD70, 0x52763C, 0x534B20, 0x53B0D4, 0x554884, 0x559DD8, 0x55B414, 0x56C054, 0x57D124,
        0x58DD88, 0x5957AC, 0x59BD88, 0x5A72E4, 0x5B3DCC, 0x5BD3CC, 0x5C8BA8, 0x5D3884, 0x5DED08, 0x5EE6C4,
        0x5F8E34, 0x6022E0, 0x60DCC0, 0x61089C, 0x61A9AC, 0x62C600, 0x63A25C, 0x63D070, 0x64F0AC, 0x651D8C,
        0x658C10, 0x663A3C, 0x66ADC8, 0x679B58, 0x683708, 0x69039C, 0x6954C4, 0x696980, 0x6AC4A0, 0x6B048C,
        0x6B441C, 0x6C31B0, 0x6C615C, 0x6D0AD4, 0x6D5ACC, 0x6D8694, 0x6E3FD8, 0x6EB4A4, 0x6FF3DC, 0x70D0D0,
        0x71E404, 0x733E4C, 0x746AA0, 0x75A8B8, 0x75C098, 0x75CC6C, 0x763F28, 0x76D6D4, 0x77B1E4, 0x77E304,
        0x79BBF8, 0x79E9F8, 0x7AB538, 0x7AC6BC, 0x7AE9F8, 0x7C2A60, 0x7C3574, 0x7C7B2C, 0x7C8F48, 0x7CB950,
        0x7CFAD4, 0x7D5E74, 0x7DCBDC, 0x7E7400, 0x809544, 0x820228, 0x836F78, 0x83AD78, 0x83BE98, 0x83CF48,
        0x844E7C, 0x84DE78, 0x867778, 0x868738, 0x87D0F8, 0x881130, 0x886BFC, 0x89A2F0, 0x89B88C, 0x8A5D28,
        0x8A983C, 0x8AFB80, 0x8B7038, 0x8BC194, 0x8C6C88, 0x8C804C, 0x8CE680, 0x8D2B10, 0x8DBA2C, 0x8F91D4,
        0x8FE450, 0x908C68, 0x90A2E4, 0x91B168, 0x92978C, 0x92B500, 0x93667C, 0x946808, 0x9477A8, 0x953DFC,
        0x9658B8, 0x96D5B8, 0x973A80, 0x979EA0, 0x985DDC, 0x987500, 0x98E2D4, 0x98F824, 0x99C618, 0x9A9FCC,
        0x9B1574, 0x9BAD44, 0x9BEEEC, 0x9C59B0, 0x9C9E38, 0x9CBD94, 0x9D1794, 0x9DAD3C, 0x9E5CCC, 0x9E8284,
        0x9E9720, 0x9F1000, 0x9F9C04, 0x0A09EE0, 0x0A0E7B4, 0x0A133DC, 0x0A13D24, 0x0A1CCCC, 0x0A1EC4C,
        0x0A23450, 0x0A2DC90, 0x0A301BC, 0x0A32D90, 0x0A3535C, 0x0A5BA88, 0x0A70F60, 0x0A8D45C, 0x0A9E138,
        0x0AAD518, 0x0ACDBD8, 0x0AE9A74, 0x0AFAFB0, 0x0AFE760, 0x0B16668, 0x0B1BAEC, 0x0B1DC2C, 0x0B24CD8,
        0x0B36B0C, 0x0B37C4C, 0x0B47108, 0x0B52848, 0x0B57370, 0x0B5F3E8, 0x0B60DE0, 0x0B6C124, 0x0B84280,
        0x0B9371C, 0x0B99C50, 0x0BA67A4, 0x0BAFB98, 0x0BB0C48, 0x0BB5334, 0x0BB9CAC, 0x0BCA7BC, 0x0BDD124,
        0x0BEC11C, 0x0BF420C, 0x0BF9AA8, 0x0C09EEC, 0x0C1C244, 0x0C2C698, 0x0C34A28, 0x0C39E08, 0x0C4B9BC,
        0x0C4E9C4, 0x0C68218, 0x0C75A48, 0x0C76D60, 0x0C7A950, 0x0C7F5C0, 0x0C8605C, 0x0C8A080, 0x0C97EBC,
        0x0C9B744, 0x0CA5B78, 0x0CA9704, 0x0CB2000, 0x0CB55E8, 0x0CBB984, 0x0CBE2BC, 0x0CC4538, 0x0CD2238,
        0x0CEE140, 0x0CF1604, 0x0CF6168, 0x0D012D0, 0x0D06B90, 0x0D0C0C4, 0x0D10BA0, 0x0D1C07C, 0x0D20E08,
        0x0D2FDDC, 0x0D3DE94, 0x0D5014C, 0x0D60F20, 0x0D62DF4, 0x0D640A0, 0x0D6A6D0, 0x0D6C554, 0x0D74874,
        0x0D82C58, 0x0D87428, 0x0D94B3C, 0x0D9B5D0, 0x0DA5B4C, 0x0DA91CC, 0x0DAC020, 0x0DB1230, 0x0DBBBCC,
        0x0DCCF58, 0x0DD3354, 0x0DDE6D4, 0x0DE0EA4, 0x0DF2E08, 0x0DF7144, 0x0E01C84, 0x0E0B3A4, 0x0E1E398,
        0x0E22F74, 0x0E44E9C, 0x0E5AF4C, 0x0E5C418, 0x0E5D5B8, 0x0E655A4, 0x0E75F2C, 0x0E80F60, 0x0E8882C,
        0x0E9AA04, 0x0E9BE18, 0x0E9F5B0, 0x0EA5F68, 0x0EAB4D4, 0x0EB045C, 0x0EB6764, 0x0EBE8A8, 0x0EC2898,
        0x0EC8294, 0x0ECD1AC, 0x0ED6450, 0x0EE5994, 0x0EF0158, 0x0EF5AC4, 0x0EF7194, 0x0F05780, 0x0F13E18,
        0x0F18850, 0x0F3B358, 0x0F483A0, 0x0F53D3C, 0x0F6AB20, 0x0F8C2BC, 0x0F958CC, 0x0FB6B8C, 0x0FC7A6C,
        0x0FD7DF0, 0x0FE79EC, 0x0FF85A0, 0x10183BC, 0x1027E30, 0x1042230, 0x104FD80, 0x1064460, 0x10687E4,
        0x107ADEC, 0x107F324, 0x108764C, 0x108EF14, 0x109392C, 0x10952C0, 0x109BDBC, 0x10A3950, 0x10AC844,
        0x10C4518, 0x10C7F28, 0x10CA3C0, 0x10D56E8, 0x10DB840, 0x10E4664, 0x10ECBA8, 0x10F6440, 0x10FC9CC,
        0x1112ABC, 0x1114924, 0x1123FEC, 0x112AAC4, 0x112F090, 0x113D528, 0x1149A9C, 0x1154ED0, 0x1161424,
        0x117F148, 0x1194440, 0x119EDA0, 0x11AD2B4, 0x11C9E54, 0x11D5760, 0x11F76CC, 0x1201BA8, 0x1215EAC,
        0x12183B0, 0x1219774, 0x122F0B0, 0x123750C, 0x124BE7C, 0x124C948, 0x124DF2C, 0x1259DB0, 0x125CF8C,
        0x125EEE0, 0x126278C, 0x126AF60, 0x126FF80, 0x1271918, 0x127B3B8, 0x12881D4, 0x1297C18, 0x129E6DC,
        0x12A1664, 0x12AB23C, 0x12AF778, 0x12B0304, 0x12BBF30, 0x12CC3E8, 0x12D4468, 0x12DD79C, 0x12E7344,
        0x12F1C04, 0x1301330, 0x130ABD8, 0x1316B28, 0x13206B0, 0x1323088, 0x1323B84, 0x1325AB8, 0x13294CC,
        0x132F8F8, 0x1334F58, 0x1340440, 0x134E648, 0x13590A0, 0x1362084, 0x1377460, 0x13803BC, 0x13818C8,
        0x13836B4, 0x138F044, 0x1396014, 0x13A11C0, 0x13A7CA8, 0x13AEC74, 0x13AFF08, 0x13B538C, 0x13B8328,
        0x13C5B08, 0x13C7510, 0x13D1810, 0x13D3E58, 0x13D8BF4, 0x13DDBAC, 0x13DFAB4, 0x13E7CC4, 0x13EC948,
        0x13F5BE4, 0x13F7C84, 0x14098C4, 0x140AC68, 0x140C36C, 0x1413B30, 0x1416F00, 0x141BC8C, 0x14239C8,
        0x14271E0, 0x1438878, 0x1443AD4, 0x144D11C, 0x144E5C0, 0x14513E8, 0x14576A8, 0x145C098, 0x1465690,
        0x1475B50, 0x147A964, 0x1484BDC, 0x148A73C, 0x14957C0, 0x14A1838, 0x14A2DC0, 0x14B32F8, 0x14BCB60,
        0x14C60FC, 0x14CC3FC, 0x14DC074, 0x14E4518, 0x14ED2E0, 0x14FE514, 0x1506E18, 0x1510780, 0x151471C,
        0x151B194, 0x154BB34, 0x1555060, 0x155AAB8, 0x155B804, 0x15668C4, 0x156A30C, 0x157E6D8, 0x15918C8,
        0x1599070, 0x15A22CC, 0x15AA6CC, 0x15B7D34, 0x15CBAC8, 0x15CDBD0, 0x15D6388, 0x15E198C, 0x15E8E64,
        0x15F3044, 0x15F8404, 0x16049F0, 0x160C798, 0x160F9F0, 0x1620948, 0x16308E0, 0x163204C, 0x1642934,
        0x165DEB0, 0x166A3C8, 0x1676AB0, 0x1679560, 0x167ACB8, 0x168478C, 0x1693580, 0x1698460, 0x16A4F3C,
        0x16B7AD8, 0x16C5B94, 0x16DAE5C, 0x16F35B4, 0x1702D34, 0x171310C, 0x1727490, 0x172B3D0, 0x173F6D4,
        0x174C008, 0x1759A88, 0x175F1FC, 0x1761B18, 0x176C8BC, 0x1779EB0, 0x1780D94, 0x1785FF8, 0x17887A0,
        0x178D50C, 0x179DDDC, 0x17A8E94, 0x17B2130, 0x17C49FC, 0x17CB09C, 0x17D12A8, 0x17D90C4, 0x17DFD3C,
        0x17E0930, 0x17E5AA0, 0x17E6CD0, 0x17F20E4, 0x17F7A74, 0x1807EE4, 0x181D1E0, 0x182DB80, 0x183D740,
        0x183E910, 0x18400A4, 0x1844100, 0x1847670, 0x1852C40, 0x18536EC, 0x185A9D4, 0x1862474, 0x1871D60,
        0x1874A54, 0x188667C, 0x189A0E8, 0x189DD1C, 0x18A4D34, 0x18ABEBC, 0x18B3D98, 0x18B7CFC, 0x18CC160,
        0x18D7460, 0x18E5270, 0x18F5520, 0x18F6854, 0x18FA668, 0x190C234, 0x191B4F0, 0x191C4B8, 0x19228A4,
        0x192A328, 0x1934A24, 0x193DAB8, 0x19436C4, 0x1945674, 0x194762C, 0x195C010, 0x19635E0, 0x19708F4,
        0x1972534, 0x1976618, 0x19853B8, 0x198DAA0, 0x199ED5C, 0x19A3080, 0x19A9704, 0x19AADB4, 0x19B9608,
        0x19C59AC, 0x19C8F90, 0x19D5258, 0x19E9DBC, 0x19F16A8, 0x19F248C, 0x19FB968, 0x1A0583C, 0x1A172F0,
        0x1A1C8AC, 0x1A1E6CC, 0x1A272B8, 0x1A40C78, 0x1A5D948, 0x1A75730, 0x1A8C4AC, 0x1A8D150, 0x1A9238C,
        0x1A9A22C, 0x1AA7E28, 0x1ABA918, 0x1AC1238, 0x1ACD3F8, 0x1ADA93C, 0x1AE06D0, 0x1AE1B14, 0x1AF15D0,
        0x1B05434, 0x1B102FC, 0x1B1BF98, 0x1B24BBC, 0x1B365C4, 0x1B449E0, 0x1B4DD10, 0x1B6074C, 0x1B660C8,
        0x1B67460, 0x1B6B0F8, 0x1B72400, 0x1B7ABD0, 0x1B829C0, 0x1B87FC4, 0x1B8CB3C, 0x1B99314, 0x1B9C7C8,
        0x1BAA5EC, 0x1BAE828, 0x1BAF8A8, 0x1BB92F0, 0x1BBDBB0, 0x1BC99E8, 0x1BD50B8, 0x1BDBA54, 0x1BDC9E8,
        0x1BE6E04, 0x1BEB62C, 0x1BF343C, 0x1BFE2E0, 0x1C05658, 0x1C0F204, 0x1C14588, 0x1C1A834, 0x1C1CEC8,
        0x1C22E28, 0x1C357B8, 0x1C43D0C, 0x1C491DC, 0x1C4B368, 0x1C66690, 0x1C69BB0, 0x1C72790, 0x1C76E5C,
        0x1C77FF8, 0x1C88A34, 0x1C90580, 0x1C92630, 0x1C99D20, 0x1CB4C8C, 0x1CBAF40, 0x1CCB1F0, 0x1CD74FC,
        0x1CDFF54, 0x1CF1190, 0x1CFFF44, 0x1D12558, 0x1D1389C, 0x1D1B814, 0x1D284E4, 0x1D2DC30, 0x1D3C0B4,
        0x1D3E024, 0x1D4AF94, 0x1D55830, 0x1D71798, 0x1D7BBBC, 0x1D90480, 0x1D9B978, 0x1DB0D14, 0x1DB7BC8,
        0x1DC4E50, 0x1DC6234, 0x1DCE774, 0x1DDD970, 0x1DE5278, 0x1DE9EE0, 0x1DEB0FC, 0x1DF7758, 0x1DFB450,
        0x1E0BA34, 0x1E160BC, 0x1E20204, 0x1E3A3B8, 0x1E4897C, 0x1E4DC48, 0x1E4FA04, 0x1E512BC, 0x1E548F4,
        0x1E6D22C, 0x1E6F004, 0x1E73368, 0x1E79518, 0x1E7BBE0, 0x1E8E624, 0x1EA7368, 0x1EC288C, 0x1ECAFE4,
        0x1EE22B8, 0x1EF5CC0, 0x1F04C98, 0x1F1A1F8, 0x1F280F0, 0x1F445C8, 0x1F4F100, 0x1F5E98C, 0x1F6E228,
        0x1F6FA94, 0x1F78C6C, 0x1F81A90, 0x1F875B0, 0x1F8D158, 0x1FC0534, 0x1FC89DC, 0x1FD9A1C, 0x1FEFE80,
        0x1FFF280, 0x2007FCC, 0x2011630, 0x201E764, 0x2024F78, 0x2029178, 0x202F4A0, 0x203DCC8, 0x204B410,
        0x2050160, 0x205E1DC, 0x2066870, 0x208085C, 0x208B12C, 0x20958D8, 0x209B48C, 0x20AB91C, 0x20AD7C0,
        0x20B2DA4, 0x20B738C, 0x20BD088, 0x20C0514, 0x20CAA2C, 0x20CC528, 0x20D7A3C, 0x20D9468, 0x20DA3E4,
        0x20E591C, 0x21012D0, 0x2126064, 0x2132F7C, 0x2140730, 0x214DE94, 0x214FE30, 0x2151658, 0x21528F4,
        0x2158690, 0x215EFEC, 0x216A17C, 0x2172404, 0x217CBC4, 0x21824C8, 0x2183CF8, 0x218A0B4, 0x218E500,
        0x21AB168, 0x21B4954, 0x21BD1EC, 0x21C7750, 0x21CBE24, 0x21CDADC, 0x21D3B9C, 0x21DE2C8, 0x21E2F98,
        0x21E9D64, 0x21F6414, 0x22045C8, 0x2209560, 0x2217C28, 0x2227970, 0x2238DB0, 0x223C45C, 0x223D5A8,
        0x2240F10, 0x22464EC, 0x22509C0, 0x225B1F8, 0x226152C, 0x226BC78, 0x22808AC, 0x22872B8, 0x22922A4,
        0x229CA40, 0x229FD30, 0x22A0B50, 0x22A3EE0, 0x22B5754, 0x22B6774, 0x22CA390, 0x22D85D0, 0x22DB5D0,
        0x22E9FF0, 0x22FBA50, 0x2302A5C, 0x230403C, 0x23069D0, 0x230C328, 0x230DD30, 0x23175E0, 0x231E810,
        0x2329684, 0x2337A38, 0x2340FA8, 0x23537C8, 0x2354D08, 0x2361C34, 0x2362A68, 0x2375920, 0x237F4B0,
        0x2388894, 0x239627C, 0x23A3884, 0x23B5280, 0x23C03EC, 0x23D07A8, 0x23D49D8, 0x23E0444, 0x23EEE20,
        0x23F81CC, 0x2410A64, 0x2417928, 0x2424E24, 0x2427498, 0x24355AC, 0x2443DCC, 0x2449A6C, 0x245676C,
        0x245930C, 0x2464A64, 0x246FF04, 0x2474B04, 0x248AFF4, 0x249D75C, 0x24ABD40, 0x24B70B4, 0x24BE174,
        0x24CE8D4, 0x24DB3B0, 0x24E1E74, 0x24EE984, 0x24FB76C, 0x25087F8, 0x251AE28, 0x252A970, 0x2530984,
        0x253CC74, 0x255FE64, 0x2565BCC, 0x25692FC, 0x2570758, 0x257FFF0, 0x2580DDC, 0x258C260, 0x259CA58,
        0x25A9E1C, 0x25BF480, 0x25DE7AC, 0x25E7584, 0x25F58A8, 0x25FA8B8, 0x2606B10, 0x26098B0, 0x2610EB8,
        0x2622B38, 0x2624BA8, 0x26376F4, 0x264ABB4, 0x26549B8, 0x2681934, 0x2696BD0, 0x26A65EC, 0x26C06D8,
        0x26E1340, 0x26ED184, 0x26FDB64, 0x2705834, 0x2717538, 0x27245AC, 0x273A074, 0x2740708, 0x2755C84,
        0x27635D8,
      } },
      { "DATA12", new uint[] {
        0x3434, 0x12194, 0x1AB9C, 0x2AA4C, 0x37DE0, 0x3C074, 0x48FE8, 0x61F7C, 0x701BC, 0x7AD84, 0x7FE4C,
        0x9E2E4, 0x9FD30, 0x0B8384, 0x0D0158, 0x0D57C8, 0x0DA478, 0x0F359C, 0x10A51C, 0x1184C8, 0x123A30,
        0x1398A4, 0x14449C, 0x15E298, 0x166540, 0x1736A4, 0x1840F8, 0x18D2DC, 0x19569C, 0x1A2D18, 0x1AE5E8,
        0x1BB158, 0x1C843C, 0x1D217C, 0x1E4730, 0x1EC75C, 0x1FC0FC, 0x210DC4, 0x221640, 0x2254B4, 0x231D18,
        0x24053C, 0x250018, 0x261DE4, 0x26EB00, 0x289C88, 0x296810, 0x2A8588, 0x2BD00C, 0x2C0E30, 0x2D87D4,
        0x2E8384, 0x2F1D7C, 0x2F947C, 0x2FA784, 0x301578, 0x3208F4, 0x33B018, 0x3512A4, 0x35E1A4, 0x37879C,
        0x39BE78, 0x3A02CC, 0x3A234C, 0x3A4448, 0x3B9824, 0x3BDFA4, 0x3C41B8, 0x3CD320, 0x3D0420, 0x3D8634,
        0x3E7F94, 0x3EBE44, 0x4043D4, 0x40D5E0, 0x414044, 0x422EF0, 0x43AEE0, 0x43C17C, 0x44159C, 0x443B9C,
        0x44B81C, 0x45433C, 0x458044, 0x4663F8, 0x46D588, 0x478144, 0x4843C8, 0x48F464, 0x4A0364, 0x4B2D54,
        0x4C4B4C, 0x4C662C, 0x4D07FC, 0x4D1E84, 0x4D7F3C, 0x4DD920, 0x4DF27C, 0x4E429C, 0x4E60A8, 0x4F1744,
        0x4F92F0, 0x500B44, 0x508838, 0x50C7D4, 0x5136C0, 0x5256CC, 0x5340FC, 0x5363D8, 0x5456EC, 0x5615D0,
        0x568B94, 0x5726AC, 0x575B68, 0x57C108, 0x58201C, 0x586C50, 0x590338, 0x593054, 0x5A104C, 0x5A5D04,
        0x5AA64C, 0x5BF960, 0x5C7A88, 0x5CCEA0, 0x5DACAC, 0x5E4344, 0x5EC7A0, 0x5FCB0C, 0x603EF4, 0x6143EC,
        0x6212E0, 0x62DAFC, 0x63DDA8, 0x64B624, 0x64E434, 0x65AA1C, 0x6696E0, 0x671D60, 0x672A7C, 0x68FBC8,
        0x6A8314, 0x6BC3E0, 0x6CBDBC, 0x6D8670, 0x6F71F8, 0x703288, 0x712C04, 0x7296E4, 0x72EB18, 0x73EEBC,
        0x74ED24, 0x75CCA0, 0x76581C, 0x773600, 0x787368, 0x79A8B4, 0x7A235C, 0x7A37B0, 0x7B248C, 0x7B3E3C,
        0x7C560C, 0x7C7704, 0x7D9238, 0x7E94E0, 0x7EB658, 0x7FEB7C, 0x8038E0, 0x80CE44, 0x811C28, 0x818B54,
        0x834464, 0x837660, 0x83CA14, 0x83EDC8, 0x846D4C, 0x856AF0, 0x857CBC, 0x85AA38, 0x8656EC, 0x877710,
        0x88B1D0, 0x890AB8, 0x895B88, 0x89AD4C, 0x89FA18, 0x8AE294, 0x8B3770, 0x8BB8B4, 0x8CD080, 0x8CE698,
        0x8D0830, 0x8DB948, 0x8E1F6C, 0x8FA1F0, 0x8FAF88, 0x91A4E0, 0x926340, 0x929500, 0x92B47C, 0x9345A4,
        0x938568, 0x93C728, 0x93EE78, 0x947824, 0x94F454, 0x952224, 0x953830, 0x956188, 0x957364, 0x95B05C,
        0x95DEDC, 0x96668C, 0x96C7A8, 0x97AF78, 0x981794, 0x98806C, 0x98AE24, 0x9917C0, 0x9A9980, 0x9B7AD4,
        0x9BE6F4, 0x9BF414, 0x9C4790, 0x9D1680, 0x9DDEBC, 0x9E6C4C, 0x9ECE40, 0x9FF1B0, 0x0A14224, 0x0A2CED4,
        0x0A36988, 0x0A3E1C0, 0x0A4FC74, 0x0A66A58, 0x0A73E54, 0x0A8B6F0, 0x0A9432C, 0x0AA2840, 0x0AAB7B0,
        0x0AB0A88, 0x0ABA1E8, 0x0ACEB34, 0x0AE5460, 0x0AEE54C, 0x0AFC878, 0x0B05134, 0x0B11EA0, 0x0B25960,
        0x0B270A0, 0x0B33BF4, 0x0B42004, 0x0B56CEC, 0x0B62624, 0x0B6EAF0, 0x0B7B9BC, 0x0B93C38, 0x0B9B1CC,
        0x0B9EB74, 0x0BA5CC0, 0x0BB82A4, 0x0BC27F8, 0x0BD7074, 0x0BE87F4, 0x0BF0998, 0x0C01A7C, 0x0C08604,
        0x0C193B0, 0x0C312A4, 0x0C365A4, 0x0C3EDC4, 0x0C4691C, 0x0C5508C, 0x0C687D8, 0x0C721F8, 0x0C8B0B8,
        0x0C924EC, 0x0C9EC94, 0x0CABD94, 0x0CB2ED8, 0x0CBDA14, 0x0CBFD1C, 0x0CC5898, 0x0CD307C, 0x0CDB2C4,
        0x0CE8760, 0x0CF6D94, 0x0CFCD00, 0x0D00DB0, 0x0D037CC, 0x0D0AF54, 0x0D13684, 0x0D2C6E8, 0x0D32740,
        0x0D3BB7C, 0x0D40F94, 0x0D4CFAC, 0x0D5370C, 0x0D72AE8, 0x0D82C00, 0x0D9C75C, 0x0DB87EC, 0x0DC6DF8,
        0x0DCEE18, 0x0DD28CC, 0x0DD41D8, 0x0DE0664, 0x0DE8520, 0x0DEBBF8, 0x0DF9DA0, 0x0DFBB88, 0x0E0A96C,
        0x0E18474, 0x0E22724, 0x0E390BC, 0x0E3F324, 0x0E419A4, 0x0E4872C, 0x0E50CF8, 0x0E6108C, 0x0E74094,
        0x0E8B1E4, 0x0E8CAB4, 0x0E8F5F0, 0x0E9D4B8, 0x0EA75D4, 0x0EB0C98, 0x0EB56A0, 0x0EBD738, 0x0EC0874,
        0x0EC5768, 0x0ED1E24, 0x0ED778C, 0x0EE98B4, 0x0EFEB6C, 0x0F1B12C, 0x0F2FAA0, 0x0F3F89C, 0x0F54720,
        0x0F654EC, 0x0F76094, 0x0F7CE74, 0x0F87A54, 0x0F967C0, 0x0FA897C, 0x0FB2BC4, 0x0FB86A8, 0x0FBDD18,
        0x0FC9B74, 0x0FDB15C, 0x0FF2F3C, 0x1003144, 0x101124C, 0x1025750, 0x1030C44, 0x103F0C4, 0x104CD00,
        0x104E784, 0x10596D0, 0x1061F04, 0x106A740, 0x107C5F0, 0x1092518, 0x109C6D4, 0x10A2014, 0x10B00B0,
        0x10BDA98, 0x10CC970, 0x10E0CA0, 0x10EB140, 0x10F1A24, 0x110BB54, 0x11269C0, 0x112A178, 0x112B9A0,
        0x112CD5C, 0x1133AEC, 0x113D1BC, 0x1158104, 0x115984C, 0x116C7E4, 0x116E284, 0x11711F4, 0x1175E7C,
        0x117E068, 0x1188E50, 0x1198688, 0x11B0E30, 0x11D7368, 0x11EF7A8, 0x11FEF4C, 0x1207DC4, 0x12186F0,
        0x1225BE8, 0x1234214, 0x1243E6C, 0x125239C, 0x125D39C, 0x12664F8, 0x1276BA8, 0x128006C, 0x128DFF0,
        0x128FC20, 0x1296D14, 0x129D780, 0x12A79B4, 0x12B7F08, 0x12C8DD4, 0x12E0EA8, 0x12F0034, 0x12FF4AC,
        0x130DCDC, 0x1316108, 0x13173A8, 0x1326C04, 0x13329D8, 0x133AECC, 0x1345828, 0x134F730, 0x135BF3C,
        0x135D804, 0x135ED60, 0x1374CD0, 0x137DB84, 0x1383408, 0x138D428, 0x139B388, 0x13B24C0, 0x13C78FC,
        0x13C9600, 0x13D0344, 0x13E6F9C, 0x13FCDF0, 0x140E98C, 0x1417190, 0x142DD00, 0x1435CD8, 0x1437D7C,
        0x1439AB0, 0x143C4B0, 0x144D0C0, 0x144F86C, 0x145ACC8, 0x1467A50, 0x1479568, 0x148F29C, 0x1495904,
        0x149C860, 0x149D8A8, 0x14A8EE0, 0x14B0CE4, 0x14BC864, 0x14C1B38, 0x14D2C28, 0x14D8FB4, 0x14EF094,
        0x150859C, 0x1509AA0, 0x15223D4, 0x152462C, 0x1527E98, 0x153167C, 0x1533A74, 0x153A14C, 0x1549A64,
        0x155C054, 0x155F75C, 0x156A594, 0x15730B8, 0x1577D94, 0x157E668, 0x15873E4, 0x1589334, 0x1589EEC,
        0x158B240, 0x1597B50, 0x159D5D8, 0x159F0DC, 0x15A3418, 0x15AA53C, 0x15AFD90, 0x15CE35C, 0x15CFE08,
        0x15D6044, 0x15E4EAC, 0x15F8874, 0x15FAF70, 0x15FF838, 0x160C014, 0x161C47C, 0x162D400, 0x1640CDC,
        0x1651730, 0x16657C0, 0x166D10C, 0x166FB04, 0x167A49C, 0x168AA2C, 0x16A38F8, 0x16B3394, 0x16BF294,
        0x16CA4F4, 0x16D26BC, 0x16D81D0, 0x16E97E0, 0x16FC088, 0x16FD950, 0x170A1F0, 0x171CF20, 0x17291B8,
        0x172CAB4, 0x17368C4, 0x1739DA0, 0x1745E8C, 0x174F79C, 0x1760388, 0x176283C, 0x176DB2C, 0x1774BF8,
        0x17849F0, 0x17885C0, 0x178CB20, 0x179EAAC, 0x17A4F58, 0x17B0384, 0x17C14A4, 0x17CB2FC, 0x17D20C0,
        0x17DE4C0, 0x17F06C8, 0x17FD69C, 0x1802F74, 0x180AE00, 0x1812C6C, 0x1823084, 0x182B540, 0x1833710,
        0x183F454, 0x184BEFC, 0x1850700, 0x185D1F0, 0x1867A78, 0x186886C, 0x1869B14, 0x186DB60, 0x187C2C4,
        0x187D160, 0x1885FDC, 0x189E844, 0x18AB10C, 0x18C87CC, 0x18CD094, 0x18E3BA4, 0x18FBEDC, 0x1906ED8,
        0x192159C, 0x192D738, 0x193D090, 0x19472C0, 0x195DC08, 0x1978C68, 0x19989AC, 0x19B1B6C, 0x19CC6DC,
        0x19CD7DC, 0x19CE89C, 0x19DC9CC, 0x19F4CC4, 0x19FB750, 0x1A078F8, 0x1A16B18, 0x1A2469C, 0x1A2648C,
        0x1A2D400, 0x1A35E68, 0x1A42DF4, 0x1A57838, 0x1A63678, 0x1A65DD8, 0x1A67E7C, 0x1A721CC, 0x1A82F54,
        0x1A9FBF0, 0x1AA72CC, 0x1AB2194, 0x1AC90BC, 0x1AD9F2C, 0x1AE131C, 0x1AE9E30, 0x1AF4A40, 0x1B00270,
        0x1B0AA78, 0x1B0C104, 0x1B1A658, 0x1B21728, 0x1B23924, 0x1B27F84, 0x1B2FE78, 0x1B4457C, 0x1B4D3F0,
        0x1B59590, 0x1B6CC68, 0x1B6E904, 0x1B72E08, 0x1B76BA4, 0x1B7BA18, 0x1B858B4, 0x1BA1FB4, 0x1BA825C,
        0x1BACD38, 0x1BB0B7C, 0x1BBDF84, 0x1BC7964, 0x1BE5138, 0x1BF7720, 0x1BFC534, 0x1C0C678, 0x1C1B278,
        0x1C2D484, 0x1C2FC48, 0x1C39D48, 0x1C3FEA4, 0x1C46224, 0x1C4D04C, 0x1C5647C, 0x1C66C38, 0x1C68D98,
        0x1C6E264, 0x1C7A6F4, 0x1C8BDA4, 0x1C93364, 0x1C98864, 0x1CA5EB8, 0x1CAE29C, 0x1CB462C, 0x1CBBF24,
        0x1CC72D8, 0x1CCD6DC, 0x1CCF620, 0x1CD14F0, 0x1CD81A0, 0x1CDF108, 0x1CE6070, 0x1CF9414, 0x1D005C0,
        0x1D02578, 0x1D0A714, 0x1D1BD98, 0x1D27ADC, 0x1D2F534, 0x1D3F650, 0x1D45880, 0x1D5083C, 0x1D59948,
        0x1D5EE90, 0x1D63130, 0x1D6C1C8, 0x1D6FCEC, 0x1D72474, 0x1D78D5C, 0x1D82924, 0x1D94F24, 0x1DA7F68,
        0x1DAF294, 0x1DC200C, 0x1DC99C0, 0x1DD9110, 0x1DDFF94, 0x1DE7948, 0x1DEA324, 0x1DF9284, 0x1E01D80,
        0x1E0F854, 0x1E144C0, 0x1E190B0, 0x1E1E23C, 0x1E27004, 0x1E29FF0, 0x1E2FD28, 0x1E39A58, 0x1E47A4C,
        0x1E517F4, 0x1E63E70, 0x1E6FD40, 0x1E72BCC, 0x1E7B3F8, 0x1E8405C, 0x1E8ED70, 0x1E982B0, 0x1E9FA10,
        0x1EAA544, 0x1EABBFC, 0x1EB0164, 0x1EB48AC, 0x1EC34C4, 0x1EC7D74, 0x1EDB3D0, 0x1EE2F7C, 0x1EEF72C,
        0x1EFCFAC, 0x1F0C1D8, 0x1F17CEC, 0x1F27D94, 0x1F2A860, 0x1F30610, 0x1F35DB0, 0x1F4B2DC, 0x1F524A0,
        0x1F572E4, 0x1F5EEEC, 0x1F695EC, 0x1F6ED14, 0x1F73CC4, 0x1F7B678, 0x1F88D90, 0x1FA5ABC, 0x1FA6D44,
        0x1FC7FD0, 0x1FC91B4, 0x1FDCE20, 0x1FEE9CC, 0x1FFDEBC, 0x200CFFC, 0x2011F34, 0x201D0B4, 0x2028364,
        0x203271C, 0x203463C, 0x203557C, 0x203E344, 0x2043978, 0x205CE24, 0x2069990, 0x207C440, 0x20896B0,
        0x2091D04, 0x2096488, 0x2097A10, 0x209FD8C, 0x20B2750, 0x20BE83C, 0x20CA838, 0x20E26FC, 0x20F2A24,
        0x20FF3D4, 0x210BC28, 0x211898C, 0x211F9A0, 0x212F2E4, 0x214CCA4, 0x215AB20, 0x21694B0, 0x217F658,
        0x2191A1C, 0x2194C4C, 0x21992D4, 0x21A69EC, 0x21AEF40, 0x21BD00C, 0x21C9520, 0x21CFCE4, 0x21DB41C,
        0x21EB3D8, 0x21F769C, 0x2201C44, 0x22189EC, 0x2227908, 0x2236A44, 0x2238820, 0x223E208, 0x22429EC,
        0x224EFE8, 0x2260DA8, 0x2270C54, 0x227E9E0, 0x2282514, 0x22850AC, 0x2289468, 0x2295AEC, 0x22A64F4,
        0x22B51B0, 0x22C288C, 0x22C5D74, 0x22C87A4, 0x22D0438, 0x22D4874, 0x22F2DAC, 0x22F6EAC, 0x22F9E70,
        0x23022EC, 0x230C2D8, 0x23178A4, 0x231C2F0, 0x2321B30, 0x2329050, 0x232C1F4, 0x233317C, 0x23361B8,
        0x233F0E8, 0x234DC3C, 0x235CAD4, 0x2363BC4, 0x236B5FC, 0x2379104, 0x2398F64, 0x23A8504, 0x23B3BC0,
        0x23BCEA8, 0x23DB638, 0x23EACB8, 0x23F4100, 0x23F9768, 0x240E6C8, 0x241FCB8, 0x2424B38, 0x2433778,
        0x243F780, 0x2447EC4, 0x244A270, 0x244D6E0, 0x245EBA0, 0x246D67C, 0x248A040, 0x24950A8, 0x24B0214,
        0x24B7AAC, 0x24BD670, 0x24C9E24, 0x24D85DC, 0x24DF3EC, 0x24E8780, 0x24ED874, 0x24F7A84, 0x24FF408,
        0x250CB90, 0x252113C, 0x252E6C0, 0x25388A4, 0x2543A60, 0x25498B8, 0x25564B8, 0x25606C8, 0x2563530,
        0x256DC54, 0x2575050, 0x258AC1C, 0x25A120C, 0x25B32C8, 0x25C2494, 0x25CD568, 0x25E0AF4, 0x25E6E58,
        0x260B3E4, 0x2615204, 0x261CA28, 0x262BE38, 0x264C370, 0x2664428, 0x26788BC, 0x267AC50, 0x267CF70,
        0x268105C, 0x268D184, 0x26ACDC8, 0x26B50D4, 0x26C7B38, 0x26CDD1C, 0x26DD64C, 0x26F2CE0, 0x26FF2B0,
        0x2704690, 0x270804C, 0x270F0B0, 0x271BC94, 0x27317D4, 0x273F8BC, 0x2742A10, 0x274B498, 0x2757814,
        0x2762708, 0x276D7D8, 0x2771A78, 0x2781850, 0x278DF14, 0x279BF0C, 0x27A9804, 0x27AE038, 0x27B1908,
        0x27BD674, 0x27D47A4, 0x27E671C, 0x27FAF34, 0x281C2E4, 0x2839D9C, 0x2850094, 0x285E098, 0x2863718,
        0x286E2DC, 0x2878BE0, 0x288D0C4, 0x28930E0, 0x2899DD8, 0x289C08C, 0x289D754, 0x28AD17C, 0x28B3FD4,
        0x28BBC64,
      } },
      { "DATA13", new uint[] {
        0x66D4, 0x7544, 0x97B8, 0x0A6A0, 0x0B6E8, 0x0CAE8, 0x0F368, 0x101D8, 0x158D8, 0x25250, 0x27700,
        0x2889C, 0x2ABEC, 0x330A8, 0x349C0, 0x3CD70, 0x3E2F4, 0x4086C, 0x481D0, 0x4DBE8, 0x4FB44, 0x51798,
        0x544B0, 0x55C6C, 0x5D200, 0x63F30, 0x69C58, 0x6C170, 0x78228, 0x80D18, 0x8E14C, 0x9422C, 0x0B002C,
        0x0C943C, 0x0E0BB0, 0x0EC5AC, 0x0ED444, 0x0F4534, 0x0F643C, 0x0F8CD0, 0x0FAE14, 0x0FC780, 0x0FECB4,
        0x1035D0, 0x1047F0, 0x1076B0, 0x10BA2C, 0x12B724, 0x12DB34, 0x12FEBC, 0x136BF8, 0x1390B8, 0x13CDC0,
        0x15F948, 0x1730F4, 0x1924FC, 0x1A901C, 0x1AA288, 0x1B5224, 0x1B6DB8, 0x1BE6CC, 0x1C0524, 0x1C1D84,
        0x1C55FC, 0x1C6CFC, 0x1C990C, 0x1CBB84, 0x1CCC1C, 0x1CEBD0, 0x1E01A0, 0x1EBBC4, 0x1F1DE8, 0x1F3B50,
        0x1FF500, 0x203C20, 0x20632C, 0x20BC04, 0x2154B8, 0x237A4C, 0x2627A8, 0x27CB0C, 0x29E3D4, 0x2ADDAC,
        0x2AF018, 0x2B1E78, 0x2B3D44, 0x2B5774, 0x2B813C, 0x2B9248, 0x2CA29C, 0x2CFDB4, 0x2D5EA4, 0x2DF7D8,
        0x2E1304, 0x2EBA2C, 0x2F7CCC, 0x2F9FA0, 0x2FF380, 0x3022EC, 0x30F464, 0x31115C, 0x315258, 0x317680,
        0x31962C, 0x31C528, 0x3202FC, 0x3220D8, 0x326D10, 0x32CD04, 0x32FFDC, 0x3314D8, 0x333138, 0x33A1A0,
        0x33C110, 0x33D834, 0x348628, 0x35C1B4, 0x37ED0C, 0x39D9E8, 0x3B7758, 0x3B927C, 0x3BB1A0, 0x3C6038,
        0x3CB538, 0x3CC7C0, 0x3D433C, 0x3D539C, 0x3D9B10, 0x3DF288, 0x3E086C, 0x3E2478, 0x3E77A0, 0x3EDBB4,
        0x3EECB0, 0x3F6078, 0x3F8928, 0x3FA624, 0x401010, 0x407EA0, 0x40D308, 0x41500C, 0x41801C, 0x41A340,
        0x41EB50, 0x42E2D8, 0x42F384, 0x434F98, 0x436E6C, 0x43AFB8, 0x43C0B4, 0x43D114, 0x4477A8, 0x44DF04,
        0x455B4C, 0x460104, 0x467F48, 0x468F78, 0x46BFB4, 0x46CF78, 0x47CC5C, 0x489664, 0x48F314, 0x49F318,
        0x4A1538, 0x4A27FC, 0x4A939C, 0x4AB8C0, 0x4AD410, 0x4AF9A0, 0x4C7644, 0x4C90BC, 0x4CB2DC, 0x4D076C,
        0x4D1954, 0x4D3F2C, 0x4DB27C, 0x4DF364, 0x4FA070, 0x513DD0, 0x53AB44, 0x544458, 0x546534, 0x551E94,
        0x555F10, 0x55FE3C, 0x561EAC, 0x563CF4, 0x565090, 0x567F1C, 0x56E1C4, 0x5717FC, 0x578774, 0x57A630,
        0x57C114, 0x57DDAC, 0x57FED0, 0x58104C, 0x5835DC, 0x585948, 0x586BA0, 0x5879B8, 0x589320, 0x58E1A4,
        0x59072C, 0x592AE4, 0x593B44, 0x598374, 0x59DB68, 0x59FE40, 0x5A24A0, 0x5A4B10, 0x5AD168, 0x5B1DA8,
        0x5B4160, 0x5B6844, 0x5BEE24, 0x5C0B20, 0x5C35A0, 0x5E5370, 0x6097FC, 0x615CC4, 0x6195A8, 0x62E134,
        0x650388, 0x6513E8, 0x6583B8, 0x65948C, 0x65F1B0, 0x663120, 0x66531C, 0x674374, 0x676920, 0x678DE4,
        0x67B060, 0x67D598, 0x682DB4, 0x6855AC, 0x686554, 0x687328, 0x68D408, 0x68F2D8, 0x690370, 0x693AC4,
        0x69B658, 0x6A2670, 0x6A39F8, 0x6A50E0, 0x6B0D58, 0x6B306C, 0x6B6610, 0x6D0384, 0x6F5C6C, 0x719634,
        0x72975C, 0x739EEC, 0x753488, 0x755728, 0x757D88, 0x759464, 0x7615F0, 0x76CC68, 0x76E6DC, 0x772580,
        0x774310, 0x77865C, 0x77D23C, 0x7804D4, 0x782648, 0x7860B8, 0x79191C, 0x792DA0, 0x7971DC, 0x7A02A8,
        0x7AC3B0, 0x7AD738, 0x7AEB00, 0x7B2C9C, 0x7B4798, 0x7BEE14, 0x7C01FC, 0x7CCD40, 0x7D62D8, 0x7DCCC0,
        0x7E5658, 0x7EBB00, 0x7F1FA8, 0x7F3C90, 0x7F5DD8, 0x7FCD84, 0x80D5B8, 0x80E5E4, 0x810810, 0x817358,
        0x81840C, 0x8286A8, 0x82FFF4, 0x8324BC, 0x834B5C, 0x83E98C, 0x8430D0, 0x85BCFC, 0x86BAAC, 0x87E32C,
        0x8845E0, 0x89A7F8, 0x89D360, 0x8BC014, 0x8BD3F8, 0x8C9154, 0x8DA67C, 0x8E71B0, 0x8E8E94, 0x8EE04C,
        0x8FE300, 0x908644, 0x9153A0, 0x919874, 0x92AC50, 0x92E70C,
      } },
      { "DATA14", new uint[] {
        0x2CE8, 0x6670, 0x0DDBC, 0x107D0, 0x191D0, 0x1C458, 0x21DB4, 0x2D3B0, 0x4CB20, 0x5EF88, 0x68E9C,
        0x6AD7C, 0x6DE98, 0x71988, 0x78B34, 0x812E0, 0x82F28, 0x861B0, 0x89778, 0x8BA14, 0x925AC, 0x9D250,
        0x0A1698, 0x0A285C, 0x0AAAE4, 0x0B5CAC, 0x0BDEB8, 0x0C1754, 0x0C3A68, 0x0E13F4, 0x0E4F5C, 0x0E7108,
        0x0EDC2C, 0x0F098C, 0x0F7618, 0x110AD0, 0x11A444, 0x11D30C, 0x12B418, 0x12CCE4, 0x134164, 0x140BFC,
        0x14C978, 0x157CA8, 0x167C1C, 0x175AD0, 0x17F624, 0x19D360, 0x1A63F4, 0x1AE948, 0x1B3584, 0x1B4DD8,
        0x1B7E04, 0x1B95DC, 0x1BB9A4, 0x1C8200, 0x1D4190, 0x1DB96C, 0x1E0F0C, 0x1EF2B0, 0x2066AC, 0x21263C,
        0x215D54, 0x224614, 0x22DCF0, 0x231830, 0x2337B0, 0x239ABC, 0x23D514, 0x24A978, 0x2526E0, 0x2573B8,
        0x25A880, 0x25E610, 0x260ED0, 0x2622BC, 0x266C54, 0x26C268, 0x26DAF8, 0x26EF60, 0x27CD78, 0x2A966C,
        0x2B6E0C, 0x2D1EA8, 0x2D5120, 0x2D8A14, 0x2DEAF4, 0x300668, 0x30E658, 0x316E48, 0x322BFC, 0x326A7C,
        0x32B6DC, 0x3346C4, 0x33A5A4, 0x34E0BC, 0x3540F4, 0x36CC6C, 0x3757B4, 0x37B2E0, 0x3864D0, 0x391A34,
        0x39CF24, 0x39E410, 0x3A7130, 0x3AA744, 0x3B47E8, 0x3C0DD4, 0x3D4488, 0x3D6BA8, 0x3DF858, 0x3E3FA8,
        0x3E5AFC, 0x3E8FB8, 0x3EBD30, 0x3EDF00, 0x3F15B4, 0x3F7CB4, 0x4010F4, 0x4085BC, 0x411C18, 0x4165CC,
        0x417CBC, 0x41AE38, 0x41CC90, 0x4229FC, 0x427440, 0x433018, 0x4462BC, 0x45162C, 0x455E68, 0x45724C,
        0x45BBB4, 0x45D700, 0x45FFC8, 0x463D04, 0x4798B0, 0x484508, 0x488D20, 0x48AE80, 0x48D210, 0x49B278,
        0x4A8E14, 0x4AB908, 0x4ADFA4, 0x4B4940, 0x4B8E50, 0x4BC038, 0x4BF50C, 0x4C6AD8, 0x4CA554, 0x4D280C,
        0x4DF798, 0x4E1754, 0x4E7314, 0x4F2DEC, 0x4F6044, 0x4F84F4, 0x50A1B8, 0x50BE64, 0x50DD6C, 0x517A24,
        0x519748, 0x51B214, 0x523030, 0x538C84, 0x5585F8, 0x571410, 0x58CE88, 0x5AA62C, 0x5BC5C0, 0x5CDBE8,
        0x5E7CF4, 0x5F966C, 0x5FB754, 0x5FE388, 0x6070B8, 0x60892C, 0x625678, 0x635F00, 0x63FF7C, 0x642BF4,
        0x64783C, 0x64C8C0, 0x654274, 0x656498, 0x663B00, 0x66F81C, 0x67CCA4, 0x685300, 0x6877F8, 0x68C620,
        0x68E144, 0x6913D0, 0x6937D4, 0x698584, 0x699BFC, 0x6B54F8, 0x6C3A58, 0x6CB840, 0x6CDF90, 0x6D6318,
        0x6D8810, 0x6DA6F4, 0x6DE78C, 0x6E3E24, 0x6EAF6C, 0x6F085C, 0x6F506C, 0x6FAD90, 0x705BB0, 0x706CFC,
        0x70D8A4, 0x71DD50, 0x71F850, 0x7267F8, 0x72AA84, 0x7334B0, 0x736B3C, 0x73A3B0, 0x73FA34, 0x742438,
        0x74D250, 0x751EA4, 0x75BA34, 0x763AE4, 0x765A40, 0x768960, 0x76AA98, 0x772E84, 0x77BBB8, 0x77E6AC,
        0x784D68, 0x790024, 0x791124, 0x796E24, 0x7A1030, 0x7A2AEC, 0x7A4460, 0x7A5B90, 0x7A954C,
      } },
      { "DATA15", new uint[] {
        0x5710, 0x0CC54, 0x13110, 0x1512C, 0x200BC, 0x30630, 0x34618, 0x46348, 0x53F24, 0x69F5C, 0x727E8,
        0x80CF8, 0x90054, 0x97340, 0x9C018, 0x0A44A8, 0x0ADAC0, 0x0B658C, 0x0C0058, 0x0C86E0, 0x0D2F4C,
        0x0D865C, 0x0DFECC, 0x0E4D88, 0x0E6E48, 0x0F6830, 0x0FAFDC, 0x1053A8, 0x10BAF0, 0x119F08, 0x1231C8,
        0x12D364, 0x135C5C, 0x144F7C, 0x14BB08, 0x150D88, 0x15A6AC, 0x164DB4, 0x1764E4, 0x17E918, 0x18C890,
        0x193AB0, 0x19C20C, 0x1AE1C4, 0x1BA284, 0x1BDE2C, 0x1C78C8, 0x1D3C4C, 0x1E4874, 0x1EE1CC, 0x1F2538,
        0x1FFC58, 0x2081D8, 0x20C780, 0x21FDC8, 0x231E58, 0x239B5C, 0x251560, 0x253E14, 0x259EC8, 0x26C304,
        0x277F2C, 0x27B6A8, 0x280658, 0x298F8C, 0x2B9C04, 0x2BBED8, 0x2D2A3C, 0x2EAE68, 0x2F3B3C, 0x30B0B0,
        0x313D04, 0x332EA4, 0x337FA4, 0x3406C0, 0x345900, 0x346580, 0x34B530, 0x35F3E0, 0x363654, 0x373BB4,
        0x377F28, 0x37D67C, 0x37E170, 0x37FDA4, 0x39B224, 0x3B313C, 0x3C0240, 0x3C7C74, 0x3D0A18, 0x3D4E10,
        0x3D9524, 0x3E7330, 0x3F4514, 0x3F7920, 0x3F8FDC, 0x405210, 0x40E844, 0x427688, 0x43505C, 0x44BD00,
        0x45E854, 0x4727E4, 0x475E54, 0x47C8EC, 0x481A04, 0x49B530, 0x4A3D9C, 0x4A8564, 0x4B12C0, 0x4BBF8C,
        0x4C1B04, 0x4D0B90, 0x4DBCCC, 0x4E7464, 0x4FC8C0, 0x516954, 0x51FA18, 0x526168, 0x52DC24, 0x545664,
        0x54AAD0, 0x55934C, 0x562100, 0x56A798, 0x573650, 0x58F800, 0x5A4694, 0x5BD00C, 0x5BF9F0, 0x5CBFF0,
        0x5CD344, 0x5D87D4, 0x5DDA78, 0x5F16FC, 0x6011D8, 0x60FC94, 0x62E964, 0x63F680, 0x648F38, 0x64E4F4,
        0x664160, 0x66DCAC, 0x67BBB4, 0x68A82C, 0x691B00, 0x69924C, 0x69E4C8, 0x6AA0E4, 0x6AF018, 0x6B08EC,
        0x6C1D9C, 0x6CBB20, 0x6D4ED4, 0x6DEC7C, 0x6EF1A8, 0x6FC3CC, 0x710D1C, 0x71495C, 0x720EA8, 0x735CCC,
        0x73DC4C, 0x750598, 0x75E660, 0x76877C, 0x77312C, 0x779670, 0x77D858, 0x786BE4, 0x78DD34, 0x79AB20,
        0x7A2BEC, 0x7A5AB0, 0x7B174C, 0x7C85C8, 0x7DFE5C, 0x7E9C58, 0x7EB644, 0x8035E0, 0x80DEB4, 0x81B284,
        0x82CF38, 0x83700C, 0x84C10C, 0x854EBC, 0x85C564, 0x861B74, 0x86625C, 0x8711B4, 0x886230, 0x88F5D8,
        0x897DA0, 0x89D6A4, 0x8AF344, 0x8C57B0, 0x8D3078, 0x8E0BB0, 0x8F2904, 0x90DF00, 0x91B0F0, 0x927AC4,
        0x9287F8, 0x92BD0C, 0x93A5D4, 0x93E8DC, 0x951DF0, 0x95B054, 0x96467C, 0x96D3A0, 0x9714BC, 0x975ED0,
        0x9898B8, 0x98CDB0, 0x9B75A0, 0x9C5A0C, 0x9D4C40, 0x9E9678, 0x9EAB00, 0x0A00AC4, 0x0A06CD8, 0x0A10878,
        0x0A1241C, 0x0A296D4, 0x0A2D4C0, 0x0A3F784, 0x0A4ACFC, 0x0A6AD5C, 0x0A78DA8, 0x0A99998, 0x0AA9590,
        0x0ABC5D8, 0x0AD0D80, 0x0ADE424, 0x0AEA2E0, 0x0AFD9C8, 0x0B08DC8, 0x0B0C1DC, 0x0B138D8, 0x0B156A0,
        0x0B1BED4, 0x0B23224, 0x0B33624, 0x0B3A1A8, 0x0B46F7C, 0x0B5A270, 0x0B5DE28, 0x0B7A8F4, 0x0B84C40,
        0x0B93C9C, 0x0BA7C78, 0x0BB5F10, 0x0BC5DCC, 0x0BEBC94, 0x0C044A4, 0x0C202B8, 0x0C286FC, 0x0C2CF7C,
        0x0C38E64, 0x0C4DEE8, 0x0C6096C, 0x0C68C20, 0x0C71894, 0x0C76BDC, 0x0C88DFC, 0x0C951A0, 0x0C9A71C,
        0x0C9E6D0, 0x0CA1F98, 0x0CADCB8, 0x0CB28F4, 0x0CB7510, 0x0CBFBB0, 0x0CC7430, 0x0CCE838, 0x0CD76F4,
        0x0CD9BA0, 0x0CDD32C, 0x0CE7600, 0x0CF04E8, 0x0CFC648, 0x0D09910, 0x0D0CC80, 0x0D1825C, 0x0D27230,
        0x0D2B3A0, 0x0D32248, 0x0D34980, 0x0D4D3FC, 0x0D545F0, 0x0D56478, 0x0D63AF8, 0x0D69704, 0x0D72D7C,
        0x0D78F50, 0x0D7D348, 0x0D86D78, 0x0D8E0B8, 0x0D9B344, 0x0DA47E8, 0x0DA77AC, 0x0DB29E4, 0x0DCA05C,
        0x0DE0EE0, 0x0DE9A7C, 0x0DEBA3C, 0x0E04770, 0x0E0E0C4, 0x0E20E60, 0x0E2B2D0, 0x0E3B70C, 0x0E49520,
        0x0E55D74, 0x0E62C30, 0x0E7BC28, 0x0E89398, 0x0E8D81C, 0x0EAB05C, 0x0ECC3F0, 0x0ED5A5C, 0x0EDF898,
        0x0EE3B0C, 0x0EECCC4, 0x0EF5358, 0x0F06CF0, 0x0F0DC68, 0x0F1DCBC, 0x0F254A0, 0x0F2F07C, 0x0F3C018,
        0x0F44D44, 0x0F4BFD4, 0x0F5C574, 0x0F67764, 0x0F81558, 0x0F8BECC, 0x0FA6714, 0x0FB83C8, 0x0FC2F64,
        0x0FC66C0, 0x0FC752C, 0x0FD3B60, 0x0FED48C, 0x0FF36C8, 0x0FFE7C8, 0x1003FA8, 0x100556C, 0x100F208,
        0x102490C, 0x1033314, 0x103AB98, 0x1040360, 0x104D994, 0x104F258, 0x105957C, 0x105DFB0, 0x106D014,
        0x1073B94, 0x108D5A4, 0x10AB13C, 0x10B1B04, 0x10BFBC4, 0x10C1E84, 0x10C5570, 0x10D17E4, 0x10E2358,
        0x10E673C, 0x10ECD68, 0x1102224, 0x11099F8, 0x1128D70, 0x113AE7C, 0x114E4F4, 0x1159118, 0x1174B20,
        0x1181078, 0x1187D5C, 0x118F1C8, 0x1198334, 0x119E014, 0x11A5B58, 0x11AED1C, 0x11BD9AC, 0x11CED2C,
        0x11D7B64, 0x11E7630, 0x11E8B08, 0x11F02C0, 0x11F4028, 0x11F4BF8, 0x12006DC, 0x120A008, 0x12141D0,
        0x1216B98, 0x1223CF0, 0x1226F60, 0x1228460, 0x122C3FC, 0x122D41C, 0x123912C, 0x12456C8, 0x124B98C,
        0x1255A0C, 0x125F798, 0x126589C,
      } },
    };
  }
}
// vim: sw=2
