//! \file       Palettes.cs
//! \date       2023 Aug 21
//! \brief      Standard palettes used in 8bpp bitmaps.
//
// Copyright (C) 2023 by morkt
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//

using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace GameRes.Formats.Macromedia
{
    internal static class Palettes
    {
        public static readonly BitmapPalette SystemMac = new BitmapPalette (new Color[] {
			Color.FromRgb (0xFF, 0xFF, 0xFF),
			Color.FromRgb (0xFF, 0xFF, 0xCC),
			Color.FromRgb (0xFF, 0xFF, 0x99),
			Color.FromRgb (0xFF, 0xFF, 0x66),
			Color.FromRgb (0xFF, 0xFF, 0x33),
			Color.FromRgb (0xFF, 0xFF, 0x00),
			Color.FromRgb (0xFF, 0xCC, 0xFF),
			Color.FromRgb (0xFF, 0xCC, 0xCC),
			Color.FromRgb (0xFF, 0xCC, 0x99),
			Color.FromRgb (0xFF, 0xCC, 0x66),
			Color.FromRgb (0xFF, 0xCC, 0x33),
			Color.FromRgb (0xFF, 0xCC, 0x00),
			Color.FromRgb (0xFF, 0x99, 0xFF),
			Color.FromRgb (0xFF, 0x99, 0xCC),
			Color.FromRgb (0xFF, 0x99, 0x99),
			Color.FromRgb (0xFF, 0x99, 0x66),
			Color.FromRgb (0xFF, 0x99, 0x33),
			Color.FromRgb (0xFF, 0x99, 0x00),
			Color.FromRgb (0xFF, 0x66, 0xFF),
			Color.FromRgb (0xFF, 0x66, 0xCC),
			Color.FromRgb (0xFF, 0x66, 0x99),
			Color.FromRgb (0xFF, 0x66, 0x66),
			Color.FromRgb (0xFF, 0x66, 0x33),
			Color.FromRgb (0xFF, 0x66, 0x00),
			Color.FromRgb (0xFF, 0x33, 0xFF),
			Color.FromRgb (0xFF, 0x33, 0xCC),
			Color.FromRgb (0xFF, 0x33, 0x99),
			Color.FromRgb (0xFF, 0x33, 0x66),
			Color.FromRgb (0xFF, 0x33, 0x33),
			Color.FromRgb (0xFF, 0x33, 0x00),
			Color.FromRgb (0xFF, 0x00, 0xFF),
			Color.FromRgb (0xFF, 0x00, 0xCC),
			Color.FromRgb (0xFF, 0x00, 0x99),
			Color.FromRgb (0xFF, 0x00, 0x66),
			Color.FromRgb (0xFF, 0x00, 0x33),
			Color.FromRgb (0xFF, 0x00, 0x00),
			Color.FromRgb (0xCC, 0xFF, 0xFF),
			Color.FromRgb (0xCC, 0xFF, 0xCC),
			Color.FromRgb (0xCC, 0xFF, 0x99),
			Color.FromRgb (0xCC, 0xFF, 0x66),
			Color.FromRgb (0xCC, 0xFF, 0x33),
			Color.FromRgb (0xCC, 0xFF, 0x00),
			Color.FromRgb (0xCC, 0xCC, 0xFF),
			Color.FromRgb (0xCC, 0xCC, 0xCC),
			Color.FromRgb (0xCC, 0xCC, 0x99),
			Color.FromRgb (0xCC, 0xCC, 0x66),
			Color.FromRgb (0xCC, 0xCC, 0x33),
			Color.FromRgb (0xCC, 0xCC, 0x00),
			Color.FromRgb (0xCC, 0x99, 0xFF),
			Color.FromRgb (0xCC, 0x99, 0xCC),
			Color.FromRgb (0xCC, 0x99, 0x99),
			Color.FromRgb (0xCC, 0x99, 0x66),
			Color.FromRgb (0xCC, 0x99, 0x33),
			Color.FromRgb (0xCC, 0x99, 0x00),
			Color.FromRgb (0xCC, 0x66, 0xFF),
			Color.FromRgb (0xCC, 0x66, 0xCC),
			Color.FromRgb (0xCC, 0x66, 0x99),
			Color.FromRgb (0xCC, 0x66, 0x66),
			Color.FromRgb (0xCC, 0x66, 0x33),
			Color.FromRgb (0xCC, 0x66, 0x00),
			Color.FromRgb (0xCC, 0x33, 0xFF),
			Color.FromRgb (0xCC, 0x33, 0xCC),
			Color.FromRgb (0xCC, 0x33, 0x99),
			Color.FromRgb (0xCC, 0x33, 0x66),
			Color.FromRgb (0xCC, 0x33, 0x33),
			Color.FromRgb (0xCC, 0x33, 0x00),
			Color.FromRgb (0xCC, 0x00, 0xFF),
			Color.FromRgb (0xCC, 0x00, 0xCC),
			Color.FromRgb (0xCC, 0x00, 0x99),
			Color.FromRgb (0xCC, 0x00, 0x66),
			Color.FromRgb (0xCC, 0x00, 0x33),
			Color.FromRgb (0xCC, 0x00, 0x00),
			Color.FromRgb (0x99, 0xFF, 0xFF),
			Color.FromRgb (0x99, 0xFF, 0xCC),
			Color.FromRgb (0x99, 0xFF, 0x99),
			Color.FromRgb (0x99, 0xFF, 0x66),
			Color.FromRgb (0x99, 0xFF, 0x33),
			Color.FromRgb (0x99, 0xFF, 0x00),
			Color.FromRgb (0x99, 0xCC, 0xFF),
			Color.FromRgb (0x99, 0xCC, 0xCC),
			Color.FromRgb (0x99, 0xCC, 0x99),
			Color.FromRgb (0x99, 0xCC, 0x66),
			Color.FromRgb (0x99, 0xCC, 0x33),
			Color.FromRgb (0x99, 0xCC, 0x00),
			Color.FromRgb (0x99, 0x99, 0xFF),
			Color.FromRgb (0x99, 0x99, 0xCC),
			Color.FromRgb (0x99, 0x99, 0x99),
			Color.FromRgb (0x99, 0x99, 0x66),
			Color.FromRgb (0x99, 0x99, 0x33),
			Color.FromRgb (0x99, 0x99, 0x00),
			Color.FromRgb (0x99, 0x66, 0xFF),
			Color.FromRgb (0x99, 0x66, 0xCC),
			Color.FromRgb (0x99, 0x66, 0x99),
			Color.FromRgb (0x99, 0x66, 0x66),
			Color.FromRgb (0x99, 0x66, 0x33),
			Color.FromRgb (0x99, 0x66, 0x00),
			Color.FromRgb (0x99, 0x33, 0xFF),
			Color.FromRgb (0x99, 0x33, 0xCC),
			Color.FromRgb (0x99, 0x33, 0x99),
			Color.FromRgb (0x99, 0x33, 0x66),
			Color.FromRgb (0x99, 0x33, 0x33),
			Color.FromRgb (0x99, 0x33, 0x00),
			Color.FromRgb (0x99, 0x00, 0xFF),
			Color.FromRgb (0x99, 0x00, 0xCC),
			Color.FromRgb (0x99, 0x00, 0x99),
			Color.FromRgb (0x99, 0x00, 0x66),
			Color.FromRgb (0x99, 0x00, 0x33),
			Color.FromRgb (0x99, 0x00, 0x00),
			Color.FromRgb (0x66, 0xFF, 0xFF),
			Color.FromRgb (0x66, 0xFF, 0xCC),
			Color.FromRgb (0x66, 0xFF, 0x99),
			Color.FromRgb (0x66, 0xFF, 0x66),
			Color.FromRgb (0x66, 0xFF, 0x33),
			Color.FromRgb (0x66, 0xFF, 0x00),
			Color.FromRgb (0x66, 0xCC, 0xFF),
			Color.FromRgb (0x66, 0xCC, 0xCC),
			Color.FromRgb (0x66, 0xCC, 0x99),
			Color.FromRgb (0x66, 0xCC, 0x66),
			Color.FromRgb (0x66, 0xCC, 0x33),
			Color.FromRgb (0x66, 0xCC, 0x00),
			Color.FromRgb (0x66, 0x99, 0xFF),
			Color.FromRgb (0x66, 0x99, 0xCC),
			Color.FromRgb (0x66, 0x99, 0x99),
			Color.FromRgb (0x66, 0x99, 0x66),
			Color.FromRgb (0x66, 0x99, 0x33),
			Color.FromRgb (0x66, 0x99, 0x00),
			Color.FromRgb (0x66, 0x66, 0xFF),
			Color.FromRgb (0x66, 0x66, 0xCC),
			Color.FromRgb (0x66, 0x66, 0x99),
			Color.FromRgb (0x66, 0x66, 0x66),
			Color.FromRgb (0x66, 0x66, 0x33),
			Color.FromRgb (0x66, 0x66, 0x00),
			Color.FromRgb (0x66, 0x33, 0xFF),
			Color.FromRgb (0x66, 0x33, 0xCC),
			Color.FromRgb (0x66, 0x33, 0x99),
			Color.FromRgb (0x66, 0x33, 0x66),
			Color.FromRgb (0x66, 0x33, 0x33),
			Color.FromRgb (0x66, 0x33, 0x00),
			Color.FromRgb (0x66, 0x00, 0xFF),
			Color.FromRgb (0x66, 0x00, 0xCC),
			Color.FromRgb (0x66, 0x00, 0x99),
			Color.FromRgb (0x66, 0x00, 0x66),
			Color.FromRgb (0x66, 0x00, 0x33),
			Color.FromRgb (0x66, 0x00, 0x00),
			Color.FromRgb (0x33, 0xFF, 0xFF),
			Color.FromRgb (0x33, 0xFF, 0xCC),
			Color.FromRgb (0x33, 0xFF, 0x99),
			Color.FromRgb (0x33, 0xFF, 0x66),
			Color.FromRgb (0x33, 0xFF, 0x33),
			Color.FromRgb (0x33, 0xFF, 0x00),
			Color.FromRgb (0x33, 0xCC, 0xFF),
			Color.FromRgb (0x33, 0xCC, 0xCC),
			Color.FromRgb (0x33, 0xCC, 0x99),
			Color.FromRgb (0x33, 0xCC, 0x66),
			Color.FromRgb (0x33, 0xCC, 0x33),
			Color.FromRgb (0x33, 0xCC, 0x00),
			Color.FromRgb (0x33, 0x99, 0xFF),
			Color.FromRgb (0x33, 0x99, 0xCC),
			Color.FromRgb (0x33, 0x99, 0x99),
			Color.FromRgb (0x33, 0x99, 0x66),
			Color.FromRgb (0x33, 0x99, 0x33),
			Color.FromRgb (0x33, 0x99, 0x00),
			Color.FromRgb (0x33, 0x66, 0xFF),
			Color.FromRgb (0x33, 0x66, 0xCC),
			Color.FromRgb (0x33, 0x66, 0x99),
			Color.FromRgb (0x33, 0x66, 0x66),
			Color.FromRgb (0x33, 0x66, 0x33),
			Color.FromRgb (0x33, 0x66, 0x00),
			Color.FromRgb (0x33, 0x33, 0xFF),
			Color.FromRgb (0x33, 0x33, 0xCC),
			Color.FromRgb (0x33, 0x33, 0x99),
			Color.FromRgb (0x33, 0x33, 0x66),
			Color.FromRgb (0x33, 0x33, 0x33),
			Color.FromRgb (0x33, 0x33, 0x00),
			Color.FromRgb (0x33, 0x00, 0xFF),
			Color.FromRgb (0x33, 0x00, 0xCC),
			Color.FromRgb (0x33, 0x00, 0x99),
			Color.FromRgb (0x33, 0x00, 0x66),
			Color.FromRgb (0x33, 0x00, 0x33),
			Color.FromRgb (0x33, 0x00, 0x00),
			Color.FromRgb (0x00, 0xFF, 0xFF),
			Color.FromRgb (0x00, 0xFF, 0xCC),
			Color.FromRgb (0x00, 0xFF, 0x99),
			Color.FromRgb (0x00, 0xFF, 0x66),
			Color.FromRgb (0x00, 0xFF, 0x33),
			Color.FromRgb (0x00, 0xFF, 0x00),
			Color.FromRgb (0x00, 0xCC, 0xFF),
			Color.FromRgb (0x00, 0xCC, 0xCC),
			Color.FromRgb (0x00, 0xCC, 0x99),
			Color.FromRgb (0x00, 0xCC, 0x66),
			Color.FromRgb (0x00, 0xCC, 0x33),
			Color.FromRgb (0x00, 0xCC, 0x00),
			Color.FromRgb (0x00, 0x99, 0xFF),
			Color.FromRgb (0x00, 0x99, 0xCC),
			Color.FromRgb (0x00, 0x99, 0x99),
			Color.FromRgb (0x00, 0x99, 0x66),
			Color.FromRgb (0x00, 0x99, 0x33),
			Color.FromRgb (0x00, 0x99, 0x00),
			Color.FromRgb (0x00, 0x66, 0xFF),
			Color.FromRgb (0x00, 0x66, 0xCC),
			Color.FromRgb (0x00, 0x66, 0x99),
			Color.FromRgb (0x00, 0x66, 0x66),
			Color.FromRgb (0x00, 0x66, 0x33),
			Color.FromRgb (0x00, 0x66, 0x00),
			Color.FromRgb (0x00, 0x33, 0xFF),
			Color.FromRgb (0x00, 0x33, 0xCC),
			Color.FromRgb (0x00, 0x33, 0x99),
			Color.FromRgb (0x00, 0x33, 0x66),
			Color.FromRgb (0x00, 0x33, 0x33),
			Color.FromRgb (0x00, 0x33, 0x00),
			Color.FromRgb (0x00, 0x00, 0xFF),
			Color.FromRgb (0x00, 0x00, 0xCC),
			Color.FromRgb (0x00, 0x00, 0x99),
			Color.FromRgb (0x00, 0x00, 0x66),
			Color.FromRgb (0x00, 0x00, 0x33),
			Color.FromRgb (0xEE, 0x00, 0x00),
			Color.FromRgb (0xDD, 0x00, 0x00),
			Color.FromRgb (0xBB, 0x00, 0x00),
			Color.FromRgb (0xAA, 0x00, 0x00),
			Color.FromRgb (0x88, 0x00, 0x00),
			Color.FromRgb (0x77, 0x00, 0x00),
			Color.FromRgb (0x55, 0x00, 0x00),
			Color.FromRgb (0x44, 0x00, 0x00),
			Color.FromRgb (0x22, 0x00, 0x00),
			Color.FromRgb (0x11, 0x00, 0x00),
			Color.FromRgb (0x00, 0xEE, 0x00),
			Color.FromRgb (0x00, 0xDD, 0x00),
			Color.FromRgb (0x00, 0xBB, 0x00),
			Color.FromRgb (0x00, 0xAA, 0x00),
			Color.FromRgb (0x00, 0x88, 0x00),
			Color.FromRgb (0x00, 0x77, 0x00),
			Color.FromRgb (0x00, 0x55, 0x00),
			Color.FromRgb (0x00, 0x44, 0x00),
			Color.FromRgb (0x00, 0x22, 0x00),
			Color.FromRgb (0x00, 0x11, 0x00),
			Color.FromRgb (0x00, 0x00, 0xEE),
			Color.FromRgb (0x00, 0x00, 0xDD),
			Color.FromRgb (0x00, 0x00, 0xBB),
			Color.FromRgb (0x00, 0x00, 0xAA),
			Color.FromRgb (0x00, 0x00, 0x88),
			Color.FromRgb (0x00, 0x00, 0x77),
			Color.FromRgb (0x00, 0x00, 0x55),
			Color.FromRgb (0x00, 0x00, 0x44),
			Color.FromRgb (0x00, 0x00, 0x22),
			Color.FromRgb (0x00, 0x00, 0x11),
			Color.FromRgb (0xEE, 0xEE, 0xEE),
			Color.FromRgb (0xDD, 0xDD, 0xDD),
			Color.FromRgb (0xBB, 0xBB, 0xBB),
			Color.FromRgb (0xAA, 0xAA, 0xAA),
			Color.FromRgb (0x88, 0x88, 0x88),
			Color.FromRgb (0x77, 0x77, 0x77),
			Color.FromRgb (0x55, 0x55, 0x55),
			Color.FromRgb (0x44, 0x44, 0x44),
			Color.FromRgb (0x22, 0x22, 0x22),
			Color.FromRgb (0x11, 0x11, 0x11),
			Color.FromRgb (0x00, 0x00, 0x00),
        });
        public static readonly BitmapPalette SystemWindows = new BitmapPalette (new Color[] {
			Color.FromRgb (0xFF, 0xFF, 0xFF),
			Color.FromRgb (0x00, 0xFF, 0xFF),
			Color.FromRgb (0xFF, 0x00, 0xFF),
			Color.FromRgb (0x00, 0x00, 0xFF),
			Color.FromRgb (0xFF, 0xFF, 0x00),
			Color.FromRgb (0x00, 0xFF, 0x00),
			Color.FromRgb (0xFF, 0x00, 0x00),
			Color.FromRgb (0x80, 0x80, 0x80),
			Color.FromRgb (0xA0, 0xA0, 0xA4),
			Color.FromRgb (0xFF, 0xFB, 0xF0),
			Color.FromRgb (0x33, 0x33, 0x33), 
			Color.FromRgb (0x99, 0x66, 0x00),
			Color.FromRgb (0x33, 0x66, 0x33),
			Color.FromRgb (0x00, 0x33, 0x99),
			Color.FromRgb (0xCC, 0x00, 0xFF),
			Color.FromRgb (0x88, 0x00, 0x00), 
			Color.FromRgb (0xFF, 0xCC, 0x66),
			Color.FromRgb (0xFF, 0x99, 0xCC),
			Color.FromRgb (0xDD, 0xDD, 0xDD),
			Color.FromRgb (0xFF, 0x99, 0x00),
			Color.FromRgb (0xFF, 0x66, 0xFF),
			Color.FromRgb (0xFF, 0x66, 0xCC),
			Color.FromRgb (0xFF, 0x66, 0x99),
			Color.FromRgb (0xFF, 0x66, 0x66),
			Color.FromRgb (0xFF, 0x66, 0x33),
			Color.FromRgb (0xFF, 0x66, 0x00),
			Color.FromRgb (0xFF, 0x33, 0xFF),
			Color.FromRgb (0xFF, 0x33, 0xCC),
			Color.FromRgb (0xFF, 0x33, 0x99),
			Color.FromRgb (0xFF, 0x33, 0x66),
			Color.FromRgb (0xFF, 0x33, 0x33),
			Color.FromRgb (0xFF, 0x33, 0x00),
			Color.FromRgb (0xFF, 0x00, 0xCC),
			Color.FromRgb (0xFF, 0x00, 0x99),
			Color.FromRgb (0xFF, 0x00, 0x66),
			Color.FromRgb (0xFF, 0x00, 0x33),
			Color.FromRgb (0xCC, 0xFF, 0xFF),
			Color.FromRgb (0xCC, 0xFF, 0xCC),
			Color.FromRgb (0xCC, 0xFF, 0x99),
			Color.FromRgb (0xCC, 0xFF, 0x66),
			Color.FromRgb (0xCC, 0xFF, 0x33),
			Color.FromRgb (0xCC, 0xFF, 0x00),
			Color.FromRgb (0xCC, 0xCC, 0xFF),
			Color.FromRgb (0xCC, 0xCC, 0xCC),
			Color.FromRgb (0xCC, 0xCC, 0x99),
			Color.FromRgb (0xCC, 0xCC, 0x66),
			Color.FromRgb (0xCC, 0xCC, 0x33),
			Color.FromRgb (0xCC, 0xCC, 0x00),
			Color.FromRgb (0xCC, 0x99, 0xFF),
			Color.FromRgb (0xCC, 0x99, 0xCC),
			Color.FromRgb (0xCC, 0x99, 0x99),
			Color.FromRgb (0xCC, 0x99, 0x66),
			Color.FromRgb (0xCC, 0x99, 0x33),
			Color.FromRgb (0xCC, 0x99, 0x00),
			Color.FromRgb (0xCC, 0x66, 0xFF),
			Color.FromRgb (0xCC, 0x66, 0xCC),
			Color.FromRgb (0xCC, 0x66, 0x99),
			Color.FromRgb (0xCC, 0x66, 0x66),
			Color.FromRgb (0xCC, 0x66, 0x33),
			Color.FromRgb (0xCC, 0x66, 0x00),
			Color.FromRgb (0xCC, 0x33, 0xFF),
			Color.FromRgb (0xCC, 0x33, 0xCC),
			Color.FromRgb (0xCC, 0x33, 0x99),
			Color.FromRgb (0xCC, 0x33, 0x66),
			Color.FromRgb (0xCC, 0x33, 0x33),
			Color.FromRgb (0xCC, 0x33, 0x00),
			Color.FromRgb (0xD4, 0x08, 0xFF),
			Color.FromRgb (0xCC, 0x00, 0xCC),
			Color.FromRgb (0xCC, 0x00, 0x99),
			Color.FromRgb (0xCC, 0x00, 0x66),
			Color.FromRgb (0xCC, 0x00, 0x33),
			Color.FromRgb (0xCC, 0x00, 0x00),
			Color.FromRgb (0x99, 0xFF, 0xFF),
			Color.FromRgb (0x99, 0xFF, 0xCC),
			Color.FromRgb (0x99, 0xFF, 0x99),
			Color.FromRgb (0x99, 0xFF, 0x66),
			Color.FromRgb (0x99, 0xFF, 0x33),
			Color.FromRgb (0x99, 0xFF, 0x00),
			Color.FromRgb (0x99, 0xCC, 0xFF),
			Color.FromRgb (0x99, 0xCC, 0xCC),
			Color.FromRgb (0x99, 0xCC, 0x99),
			Color.FromRgb (0x99, 0xCC, 0x66),
			Color.FromRgb (0x99, 0xCC, 0x33),
			Color.FromRgb (0x99, 0xCC, 0x00),
			Color.FromRgb (0x99, 0x99, 0xFF),
			Color.FromRgb (0x99, 0x99, 0xCC),
			Color.FromRgb (0x99, 0x99, 0x99),
			Color.FromRgb (0x99, 0x99, 0x66),
			Color.FromRgb (0x99, 0x99, 0x33),
			Color.FromRgb (0x99, 0x99, 0x00),
			Color.FromRgb (0x99, 0x66, 0xFF),
			Color.FromRgb (0x99, 0x66, 0xCC),
			Color.FromRgb (0x99, 0x66, 0x99),
			Color.FromRgb (0x99, 0x66, 0x66),
			Color.FromRgb (0x99, 0x66, 0x33),
			Color.FromRgb (0xA1, 0x66, 0x00),
			Color.FromRgb (0x99, 0x33, 0xFF),
			Color.FromRgb (0x99, 0x33, 0xCC),
			Color.FromRgb (0x99, 0x33, 0x99),
			Color.FromRgb (0x99, 0x33, 0x66),
			Color.FromRgb (0x99, 0x33, 0x33),
			Color.FromRgb (0x99, 0x33, 0x00),
			Color.FromRgb (0x99, 0x00, 0xFF),
			Color.FromRgb (0x99, 0x00, 0xCC),
			Color.FromRgb (0x99, 0x00, 0x99),
			Color.FromRgb (0x99, 0x00, 0x66),
			Color.FromRgb (0x99, 0x00, 0x33),
			Color.FromRgb (0x99, 0x00, 0x00),
			Color.FromRgb (0x66, 0xFF, 0xFF),
			Color.FromRgb (0x66, 0xFF, 0xCC),
			Color.FromRgb (0x66, 0xFF, 0x99),
			Color.FromRgb (0x66, 0xFF, 0x66),
			Color.FromRgb (0x66, 0xFF, 0x33),
			Color.FromRgb (0x66, 0xFF, 0x00),
			Color.FromRgb (0x66, 0xCC, 0xFF),
			Color.FromRgb (0x66, 0xCC, 0xCC),
			Color.FromRgb (0x66, 0xCC, 0x99),
			Color.FromRgb (0x66, 0xCC, 0x66),
			Color.FromRgb (0x66, 0xCC, 0x33),
			Color.FromRgb (0x66, 0xCC, 0x00),
			Color.FromRgb (0x66, 0x99, 0xFF),
			Color.FromRgb (0x66, 0x99, 0xCC),
			Color.FromRgb (0x66, 0x99, 0x99),
			Color.FromRgb (0x66, 0x99, 0x66),
			Color.FromRgb (0x66, 0x99, 0x33),
			Color.FromRgb (0x66, 0x99, 0x00),
			Color.FromRgb (0x66, 0x66, 0xFF),
			Color.FromRgb (0x66, 0x66, 0xCC),
			Color.FromRgb (0x66, 0x66, 0x99),
			Color.FromRgb (0x66, 0x66, 0x66),
			Color.FromRgb (0x66, 0x66, 0x33),
			Color.FromRgb (0x66, 0x66, 0x00),
			Color.FromRgb (0x66, 0x33, 0xFF),
			Color.FromRgb (0x66, 0x33, 0xCC),
			Color.FromRgb (0x66, 0x33, 0x99),
			Color.FromRgb (0x66, 0x33, 0x66),
			Color.FromRgb (0x66, 0x33, 0x33),
			Color.FromRgb (0x66, 0x33, 0x00),
			Color.FromRgb (0x66, 0x00, 0xFF),
			Color.FromRgb (0x66, 0x00, 0xCC),
			Color.FromRgb (0x66, 0x00, 0x99),
			Color.FromRgb (0x66, 0x00, 0x66),
			Color.FromRgb (0x66, 0x00, 0x33),
			Color.FromRgb (0x66, 0x00, 0x00),
			Color.FromRgb (0x33, 0xFF, 0xFF),
			Color.FromRgb (0x33, 0xFF, 0xCC),
			Color.FromRgb (0x33, 0xFF, 0x99),
			Color.FromRgb (0x33, 0xFF, 0x66),
			Color.FromRgb (0x33, 0xFF, 0x33),
			Color.FromRgb (0x33, 0xFF, 0x00),
			Color.FromRgb (0x33, 0xCC, 0xFF),
			Color.FromRgb (0x33, 0xCC, 0xCC),
			Color.FromRgb (0x33, 0xCC, 0x99),
			Color.FromRgb (0x33, 0xCC, 0x66),
			Color.FromRgb (0x33, 0xCC, 0x33),
			Color.FromRgb (0x33, 0xCC, 0x00),
			Color.FromRgb (0x33, 0x99, 0xFF),
			Color.FromRgb (0x33, 0x99, 0xCC),
			Color.FromRgb (0x33, 0x99, 0x99),
			Color.FromRgb (0x33, 0x99, 0x66),
			Color.FromRgb (0x33, 0x99, 0x33),
			Color.FromRgb (0x33, 0x99, 0x00),
			Color.FromRgb (0x33, 0x66, 0xFF),
			Color.FromRgb (0x33, 0x66, 0xCC),
			Color.FromRgb (0x33, 0x66, 0x99),
			Color.FromRgb (0x33, 0x66, 0x66),
			Color.FromRgb (0x33, 0x6E, 0x33),
			Color.FromRgb (0x33, 0x66, 0x00),
			Color.FromRgb (0x33, 0x33, 0xFF),
			Color.FromRgb (0x33, 0x33, 0xCC),
			Color.FromRgb (0x33, 0x33, 0x99),
			Color.FromRgb (0x33, 0x33, 0x66),
			Color.FromRgb (0x33, 0x33, 0x3B),
			Color.FromRgb (0x33, 0x33, 0x00),
			Color.FromRgb (0x33, 0x00, 0xFF),
			Color.FromRgb (0x33, 0x00, 0xCC),
			Color.FromRgb (0x33, 0x00, 0x99),
			Color.FromRgb (0x33, 0x00, 0x66),
			Color.FromRgb (0x33, 0x00, 0x33),
			Color.FromRgb (0x33, 0x00, 0x00),
			Color.FromRgb (0x00, 0xFF, 0xCC),
			Color.FromRgb (0x00, 0xFF, 0x99),
			Color.FromRgb (0x00, 0xFF, 0x66),
			Color.FromRgb (0x00, 0xFF, 0x33),
			Color.FromRgb (0x00, 0xCC, 0xFF),
			Color.FromRgb (0x00, 0xCC, 0xCC),
			Color.FromRgb (0x00, 0xCC, 0x99),
			Color.FromRgb (0x00, 0xCC, 0x66),
			Color.FromRgb (0x00, 0xCC, 0x33),
			Color.FromRgb (0x00, 0xCC, 0x00),
			Color.FromRgb (0x00, 0x99, 0xFF),
			Color.FromRgb (0x00, 0x99, 0xCC),
			Color.FromRgb (0x00, 0x99, 0x99),
			Color.FromRgb (0x00, 0x99, 0x66),
			Color.FromRgb (0x00, 0x99, 0x33),
			Color.FromRgb (0x00, 0x99, 0x00),
			Color.FromRgb (0x00, 0x66, 0xFF),
			Color.FromRgb (0x00, 0x66, 0xCC),
			Color.FromRgb (0x00, 0x66, 0x99),
			Color.FromRgb (0x00, 0x66, 0x66),
			Color.FromRgb (0x00, 0x66, 0x33),
			Color.FromRgb (0x00, 0x66, 0x00),
			Color.FromRgb (0x00, 0x33, 0xFF),
			Color.FromRgb (0x00, 0x33, 0xCC),
			Color.FromRgb (0x00, 0x33, 0xA1),
			Color.FromRgb (0x00, 0x33, 0x66),
			Color.FromRgb (0x00, 0x33, 0x33),
			Color.FromRgb (0x00, 0x33, 0x00),
			Color.FromRgb (0x00, 0x00, 0xCC),
			Color.FromRgb (0x00, 0x00, 0x99),
			Color.FromRgb (0x00, 0x00, 0x66),
			Color.FromRgb (0x00, 0x00, 0x33),
			Color.FromRgb (0xEE, 0x00, 0x00),
			Color.FromRgb (0xDD, 0x00, 0x00),
			Color.FromRgb (0xAA, 0x00, 0x00),
			Color.FromRgb (0x90, 0x00, 0x00),
			Color.FromRgb (0x77, 0x00, 0x00),
			Color.FromRgb (0x55, 0x00, 0x00),
			Color.FromRgb (0x44, 0x00, 0x00),
			Color.FromRgb (0x22, 0x00, 0x00),
			Color.FromRgb (0x11, 0x00, 0x00),
			Color.FromRgb (0x00, 0xEE, 0x00),
			Color.FromRgb (0x00, 0xDD, 0x00),
			Color.FromRgb (0x00, 0xAA, 0x00),
			Color.FromRgb (0x00, 0x88, 0x00),
			Color.FromRgb (0x00, 0x77, 0x00),
			Color.FromRgb (0x00, 0x55, 0x00),
			Color.FromRgb (0x00, 0x44, 0x00),
			Color.FromRgb (0x00, 0x22, 0x00),
			Color.FromRgb (0x00, 0x11, 0x00),
			Color.FromRgb (0x00, 0x00, 0xEE),
			Color.FromRgb (0x00, 0x00, 0xDD),
			Color.FromRgb (0x00, 0x00, 0xAA),
			Color.FromRgb (0x00, 0x00, 0x88),
			Color.FromRgb (0x00, 0x00, 0x77),
			Color.FromRgb (0x00, 0x00, 0x55),
			Color.FromRgb (0x00, 0x00, 0x44),
			Color.FromRgb (0x00, 0x00, 0x22),
			Color.FromRgb (0x00, 0x00, 0x11),
			Color.FromRgb (0x22, 0x22, 0x30),
			Color.FromRgb (0xFF, 0x99, 0x99),
			Color.FromRgb (0xFF, 0xCC, 0xFF),
			Color.FromRgb (0x99, 0xD4, 0xFF),
			Color.FromRgb (0x99, 0xD4, 0x99),
			Color.FromRgb (0xFF, 0xFF, 0x99),
			Color.FromRgb (0xF0, 0xF0, 0xF0),
			Color.FromRgb (0xA4, 0xC8, 0xF0),
			Color.FromRgb (0xC0, 0xDC, 0xC0),
			Color.FromRgb (0xC0, 0xC0, 0xC0),
			Color.FromRgb (0x00, 0x80, 0x80),
			Color.FromRgb (0x80, 0x00, 0x80),
			Color.FromRgb (0x00, 0x00, 0x80),
			Color.FromRgb (0x80, 0x80, 0x00),
			Color.FromRgb (0x00, 0x80, 0x00),
			Color.FromRgb (0x80, 0x00, 0x00),
			Color.FromRgb (0x00, 0x00, 0x00),
        });

        public static readonly BitmapPalette WindowsDirector4 = new BitmapPalette (new Color[] {
			Color.FromRgb (0xFF, 0xFF, 0xFF),
			Color.FromRgb (0x00, 0xFF, 0xFF),
			Color.FromRgb (0xFF, 0x00, 0xFF),
			Color.FromRgb (0x00, 0x00, 0xFF),
			Color.FromRgb (0xFF, 0xFF, 0x00),
			Color.FromRgb (0x00, 0xFF, 0x00),
			Color.FromRgb (0xFF, 0x00, 0x00),
			Color.FromRgb (0x80, 0x80, 0x80),
			Color.FromRgb (0xA0, 0xA0, 0xA4),
			Color.FromRgb (0xFF, 0xFB, 0xF0),
			Color.FromRgb (0x33, 0x33, 0x33),
			Color.FromRgb (0x99, 0x66, 0x00),
			Color.FromRgb (0x33, 0x66, 0x33),
			Color.FromRgb (0x00, 0x33, 0x99),
			Color.FromRgb (0xCC, 0x00, 0xFF),
			Color.FromRgb (0x88, 0x00, 0x00),
			Color.FromRgb (0xFF, 0xCC, 0x66),
			Color.FromRgb (0xFF, 0x99, 0xCC),
			Color.FromRgb (0xDD, 0xDD, 0xDD),
			Color.FromRgb (0xFF, 0x99, 0x00),
			Color.FromRgb (0xFF, 0x66, 0xFF),
			Color.FromRgb (0xFF, 0x66, 0xCC),
			Color.FromRgb (0xFF, 0x66, 0x99),
			Color.FromRgb (0xFF, 0x66, 0x66),
			Color.FromRgb (0xFF, 0x66, 0x33),
			Color.FromRgb (0xFF, 0x66, 0x00),
			Color.FromRgb (0xFF, 0x33, 0xFF),
			Color.FromRgb (0xFF, 0x33, 0xCC),
			Color.FromRgb (0xFF, 0x33, 0x99),
			Color.FromRgb (0xFF, 0x33, 0x66),
			Color.FromRgb (0xFF, 0x33, 0x33),
			Color.FromRgb (0xFF, 0x33, 0x00),
			Color.FromRgb (0xFF, 0x00, 0xCC),
			Color.FromRgb (0xFF, 0x00, 0x99),
			Color.FromRgb (0xFF, 0x00, 0x66),
			Color.FromRgb (0xFF, 0x00, 0x33),
			Color.FromRgb (0xCC, 0xFF, 0xFF),
			Color.FromRgb (0xCC, 0xFF, 0xCC),
			Color.FromRgb (0xCC, 0xFF, 0x99),
			Color.FromRgb (0xCC, 0xFF, 0x66),
			Color.FromRgb (0xCC, 0xFF, 0x33),
			Color.FromRgb (0xCC, 0xFF, 0x00),
			Color.FromRgb (0xCC, 0xCC, 0xFF),
			Color.FromRgb (0xCC, 0xCC, 0xCC),
			Color.FromRgb (0xCC, 0xCC, 0x99),
			Color.FromRgb (0xCC, 0xCC, 0x66),
			Color.FromRgb (0xCC, 0xCC, 0x33),
			Color.FromRgb (0xCC, 0xCC, 0x00),
			Color.FromRgb (0xCC, 0x99, 0xFF),
			Color.FromRgb (0xCC, 0x99, 0xCC),
			Color.FromRgb (0xCC, 0x99, 0x99),
			Color.FromRgb (0xCC, 0x99, 0x66),
			Color.FromRgb (0xCC, 0x99, 0x33),
			Color.FromRgb (0xCC, 0x99, 0x00),
			Color.FromRgb (0xCC, 0x66, 0xFF),
			Color.FromRgb (0xCC, 0x66, 0xCC),
			Color.FromRgb (0xCC, 0x66, 0x99),
			Color.FromRgb (0xCC, 0x66, 0x66),
			Color.FromRgb (0xCC, 0x66, 0x33),
			Color.FromRgb (0xCC, 0x66, 0x00),
			Color.FromRgb (0xCC, 0x33, 0xFF),
			Color.FromRgb (0xCC, 0x33, 0xCC),
			Color.FromRgb (0xCC, 0x33, 0x99),
			Color.FromRgb (0xCC, 0x33, 0x66),
			Color.FromRgb (0xCC, 0x33, 0x33),
			Color.FromRgb (0xCC, 0x33, 0x00),
			Color.FromRgb (0xD4, 0x08, 0xFF),
			Color.FromRgb (0xCC, 0x00, 0xCC),
			Color.FromRgb (0xCC, 0x00, 0x99),
			Color.FromRgb (0xCC, 0x00, 0x66),
			Color.FromRgb (0xCC, 0x00, 0x33),
			Color.FromRgb (0xCC, 0x00, 0x00),
			Color.FromRgb (0x99, 0xFF, 0xFF),
			Color.FromRgb (0x99, 0xFF, 0xCC),
			Color.FromRgb (0x99, 0xFF, 0x99),
			Color.FromRgb (0x99, 0xFF, 0x66),
			Color.FromRgb (0x99, 0xFF, 0x33),
			Color.FromRgb (0x99, 0xFF, 0x00),
			Color.FromRgb (0x99, 0xCC, 0xFF),
			Color.FromRgb (0x99, 0xCC, 0xCC),
			Color.FromRgb (0x99, 0xCC, 0x99),
			Color.FromRgb (0x99, 0xCC, 0x66),
			Color.FromRgb (0x99, 0xCC, 0x33),
			Color.FromRgb (0x99, 0xCC, 0x00),
			Color.FromRgb (0x99, 0x99, 0xFF),
			Color.FromRgb (0x99, 0x99, 0xCC),
			Color.FromRgb (0x99, 0x99, 0x99),
			Color.FromRgb (0x99, 0x99, 0x66),
			Color.FromRgb (0x99, 0x99, 0x33),
			Color.FromRgb (0x99, 0x99, 0x00),
			Color.FromRgb (0x99, 0x66, 0xFF),
			Color.FromRgb (0x99, 0x66, 0xCC),
			Color.FromRgb (0x99, 0x66, 0x99),
			Color.FromRgb (0x99, 0x66, 0x66),
			Color.FromRgb (0x99, 0x66, 0x33),
			Color.FromRgb (0xA1, 0x66, 0x00),
			Color.FromRgb (0x99, 0x33, 0xFF),
			Color.FromRgb (0x99, 0x33, 0xCC),
			Color.FromRgb (0x99, 0x33, 0x99),
			Color.FromRgb (0x99, 0x33, 0x66),
			Color.FromRgb (0x99, 0x33, 0x33),
			Color.FromRgb (0x99, 0x33, 0x00),
			Color.FromRgb (0x99, 0x00, 0xFF),
			Color.FromRgb (0x99, 0x00, 0xCC),
			Color.FromRgb (0x99, 0x00, 0x99),
			Color.FromRgb (0x99, 0x00, 0x66),
			Color.FromRgb (0x99, 0x00, 0x33),
			Color.FromRgb (0x99, 0x00, 0x00),
			Color.FromRgb (0x66, 0xFF, 0xFF),
			Color.FromRgb (0x66, 0xFF, 0xCC),
			Color.FromRgb (0x66, 0xFF, 0x99),
			Color.FromRgb (0x66, 0xFF, 0x66),
			Color.FromRgb (0x66, 0xFF, 0x33),
			Color.FromRgb (0x66, 0xFF, 0x00),
			Color.FromRgb (0x66, 0xCC, 0xFF),
			Color.FromRgb (0x66, 0xCC, 0xCC),
			Color.FromRgb (0x66, 0xCC, 0x99),
			Color.FromRgb (0x66, 0xCC, 0x66),
			Color.FromRgb (0x66, 0xCC, 0x33),
			Color.FromRgb (0x66, 0xCC, 0x00),
			Color.FromRgb (0x66, 0x99, 0xFF),
			Color.FromRgb (0x66, 0x99, 0xCC),
			Color.FromRgb (0x66, 0x99, 0x99),
			Color.FromRgb (0x66, 0x99, 0x66),
			Color.FromRgb (0x66, 0x99, 0x33),
			Color.FromRgb (0x66, 0x99, 0x00),
			Color.FromRgb (0x66, 0x66, 0xFF),
			Color.FromRgb (0x66, 0x66, 0xCC),
			Color.FromRgb (0x66, 0x66, 0x99),
			Color.FromRgb (0x66, 0x66, 0x66),
			Color.FromRgb (0x66, 0x66, 0x33),
			Color.FromRgb (0x66, 0x66, 0x00),
			Color.FromRgb (0x66, 0x33, 0xFF),
			Color.FromRgb (0x66, 0x33, 0xCC),
			Color.FromRgb (0x66, 0x33, 0x99),
			Color.FromRgb (0x66, 0x33, 0x66),
			Color.FromRgb (0x66, 0x33, 0x33),
			Color.FromRgb (0x66, 0x33, 0x00),
			Color.FromRgb (0x66, 0x00, 0xFF),
			Color.FromRgb (0x66, 0x00, 0xCC),
			Color.FromRgb (0x66, 0x00, 0x99),
			Color.FromRgb (0x66, 0x00, 0x66),
			Color.FromRgb (0x66, 0x00, 0x33),
			Color.FromRgb (0x66, 0x00, 0x00),
			Color.FromRgb (0x33, 0xFF, 0xFF),
			Color.FromRgb (0x33, 0xFF, 0xCC),
			Color.FromRgb (0x33, 0xFF, 0x99),
			Color.FromRgb (0x33, 0xFF, 0x66),
			Color.FromRgb (0x33, 0xFF, 0x33),
			Color.FromRgb (0x33, 0xFF, 0x00),
			Color.FromRgb (0x33, 0xCC, 0xFF),
			Color.FromRgb (0x33, 0xCC, 0xCC),
			Color.FromRgb (0x33, 0xCC, 0x99),
			Color.FromRgb (0x33, 0xCC, 0x66),
			Color.FromRgb (0x33, 0xCC, 0x33),
			Color.FromRgb (0x33, 0xCC, 0x00),
			Color.FromRgb (0x33, 0x99, 0xFF),
			Color.FromRgb (0x33, 0x99, 0xCC),
			Color.FromRgb (0x33, 0x99, 0x99),
			Color.FromRgb (0x33, 0x99, 0x66),
			Color.FromRgb (0x33, 0x99, 0x33),
			Color.FromRgb (0x33, 0x99, 0x00),
			Color.FromRgb (0x33, 0x66, 0xFF),
			Color.FromRgb (0x33, 0x66, 0xCC),
			Color.FromRgb (0x33, 0x66, 0x99),
			Color.FromRgb (0x33, 0x66, 0x66),
			Color.FromRgb (0x33, 0x6E, 0x33),
			Color.FromRgb (0x33, 0x66, 0x00),
			Color.FromRgb (0x33, 0x33, 0xFF),
			Color.FromRgb (0x33, 0x33, 0xCC),
			Color.FromRgb (0x33, 0x33, 0x99),
			Color.FromRgb (0x33, 0x33, 0x66),
			Color.FromRgb (0x33, 0x33, 0x3B),
			Color.FromRgb (0x33, 0x33, 0x00),
			Color.FromRgb (0x33, 0x00, 0xFF),
			Color.FromRgb (0x33, 0x00, 0xCC),
			Color.FromRgb (0x33, 0x00, 0x99),
			Color.FromRgb (0x33, 0x00, 0x66),
			Color.FromRgb (0x33, 0x00, 0x33),
			Color.FromRgb (0x33, 0x00, 0x00),
			Color.FromRgb (0x00, 0xFF, 0xCC),
			Color.FromRgb (0x00, 0xFF, 0x99),
			Color.FromRgb (0x00, 0xFF, 0x66),
			Color.FromRgb (0x00, 0xFF, 0x33),
			Color.FromRgb (0x00, 0xCC, 0xFF),
			Color.FromRgb (0x00, 0xCC, 0xCC),
			Color.FromRgb (0x00, 0xCC, 0x99),
			Color.FromRgb (0x00, 0xCC, 0x66),
			Color.FromRgb (0x00, 0xCC, 0x33),
			Color.FromRgb (0x00, 0xCC, 0x00),
			Color.FromRgb (0x00, 0x99, 0xFF),
			Color.FromRgb (0x00, 0x99, 0xCC),
			Color.FromRgb (0x00, 0x99, 0x99),
			Color.FromRgb (0x00, 0x99, 0x66),
			Color.FromRgb (0x00, 0x99, 0x33),
			Color.FromRgb (0x00, 0x99, 0x00),
			Color.FromRgb (0x00, 0x66, 0xFF),
			Color.FromRgb (0x00, 0x66, 0xCC),
			Color.FromRgb (0x00, 0x66, 0x99),
			Color.FromRgb (0x00, 0x66, 0x66),
			Color.FromRgb (0x00, 0x66, 0x33),
			Color.FromRgb (0x00, 0x66, 0x00),
			Color.FromRgb (0x00, 0x33, 0xFF),
			Color.FromRgb (0x00, 0x33, 0xCC),
			Color.FromRgb (0x00, 0x33, 0xA1),
			Color.FromRgb (0x00, 0x33, 0x66),
			Color.FromRgb (0x00, 0x33, 0x33),
			Color.FromRgb (0x00, 0x33, 0x00),
			Color.FromRgb (0x00, 0x00, 0xCC),
			Color.FromRgb (0x00, 0x00, 0x99),
			Color.FromRgb (0x00, 0x00, 0x66),
			Color.FromRgb (0x00, 0x00, 0x33),
			Color.FromRgb (0xEE, 0x00, 0x00),
			Color.FromRgb (0xDD, 0x00, 0x00),
			Color.FromRgb (0xAA, 0x00, 0x00),
			Color.FromRgb (0x90, 0x00, 0x00),
			Color.FromRgb (0x77, 0x00, 0x00),
			Color.FromRgb (0x55, 0x00, 0x00),
			Color.FromRgb (0x44, 0x00, 0x00),
			Color.FromRgb (0x22, 0x00, 0x00),
			Color.FromRgb (0x11, 0x00, 0x00),
			Color.FromRgb (0x00, 0xEE, 0x00),
			Color.FromRgb (0x00, 0xDD, 0x00),
			Color.FromRgb (0x00, 0xAA, 0x00),
			Color.FromRgb (0x00, 0x88, 0x00),
			Color.FromRgb (0x00, 0x77, 0x00),
			Color.FromRgb (0x00, 0x55, 0x00),
			Color.FromRgb (0x00, 0x44, 0x00),
			Color.FromRgb (0x00, 0x22, 0x00),
			Color.FromRgb (0x00, 0x11, 0x00),
			Color.FromRgb (0x00, 0x00, 0xEE),
			Color.FromRgb (0x00, 0x00, 0xDD),
			Color.FromRgb (0x00, 0x00, 0xAA),
			Color.FromRgb (0x00, 0x00, 0x88),
			Color.FromRgb (0x00, 0x00, 0x77),
			Color.FromRgb (0x00, 0x00, 0x55),
			Color.FromRgb (0x00, 0x00, 0x44),
			Color.FromRgb (0x00, 0x00, 0x22),
			Color.FromRgb (0x00, 0x00, 0x11),
			Color.FromRgb (0x22, 0x22, 0x30),
			Color.FromRgb (0xFF, 0x99, 0x99),
			Color.FromRgb (0xFF, 0xCC, 0xFF),
			Color.FromRgb (0x99, 0xD4, 0xFF),
			Color.FromRgb (0x99, 0xD4, 0x99),
			Color.FromRgb (0xFF, 0xFF, 0x99),
			Color.FromRgb (0xF0, 0xF0, 0xF0),
			Color.FromRgb (0xA4, 0xC8, 0xF0),
			Color.FromRgb (0xC0, 0xDC, 0xC0),
			Color.FromRgb (0xC0, 0xC0, 0xC0),
			Color.FromRgb (0x00, 0xBF, 0xBF),
			Color.FromRgb (0xBF, 0x00, 0xBF),
			Color.FromRgb (0x00, 0x00, 0xBF),
			Color.FromRgb (0xBF, 0xBF, 0x00),
			Color.FromRgb (0x00, 0xBF, 0x00),
			Color.FromRgb (0xBF, 0x00, 0x00),
			Color.FromRgb (0x00, 0x00, 0x00),
        });

        public static readonly BitmapPalette Rainbow = new BitmapPalette (new Color[] {
			Color.FromRgb (0xFF, 0xFF, 0xFF),
			Color.FromRgb (0x00, 0x69, 0xFF),
			Color.FromRgb (0x00, 0x63, 0xFF),
			Color.FromRgb (0x00, 0x5D, 0xFF),
			Color.FromRgb (0x00, 0x56, 0xFF),
			Color.FromRgb (0x00, 0x50, 0xFF),
			Color.FromRgb (0x00, 0x4A, 0xFF),
			Color.FromRgb (0x00, 0x43, 0xFF),
			Color.FromRgb (0x00, 0x3D, 0xFF),
			Color.FromRgb (0x00, 0x36, 0xFF),
			Color.FromRgb (0x00, 0x30, 0xFF),
			Color.FromRgb (0x00, 0x2A, 0xFF),
			Color.FromRgb (0x00, 0x23, 0xFF),
			Color.FromRgb (0x00, 0x1D, 0xFF),
			Color.FromRgb (0x00, 0x16, 0xFF),
			Color.FromRgb (0x00, 0x10, 0xFF),
			Color.FromRgb (0x00, 0x0A, 0xFF),
			Color.FromRgb (0x00, 0x03, 0xFF),
			Color.FromRgb (0x06, 0x00, 0xFF),
			Color.FromRgb (0x0C, 0x00, 0xFF),
			Color.FromRgb (0x13, 0x00, 0xFF),
			Color.FromRgb (0x19, 0x00, 0xFF),
			Color.FromRgb (0x1F, 0x00, 0xFF),
			Color.FromRgb (0x26, 0x00, 0xFF),
			Color.FromRgb (0x2C, 0x00, 0xFF),
			Color.FromRgb (0x33, 0x00, 0xFF),
			Color.FromRgb (0x39, 0x00, 0xFF),
			Color.FromRgb (0x3F, 0x00, 0xFF),
			Color.FromRgb (0x46, 0x00, 0xFF),
			Color.FromRgb (0x4C, 0x00, 0xFF),
			Color.FromRgb (0x53, 0x00, 0xFF),
			Color.FromRgb (0x59, 0x00, 0xFF),
			Color.FromRgb (0x5F, 0x00, 0xFF),
			Color.FromRgb (0x66, 0x00, 0xFF),
			Color.FromRgb (0x6C, 0x00, 0xFF),
			Color.FromRgb (0x72, 0x00, 0xFF),
			Color.FromRgb (0x79, 0x00, 0xFF),
			Color.FromRgb (0x7F, 0x00, 0xFF),
			Color.FromRgb (0x86, 0x00, 0xFF),
			Color.FromRgb (0x8C, 0x00, 0xFF),
			Color.FromRgb (0x92, 0x00, 0xFF),
			Color.FromRgb (0x99, 0x00, 0xFF),
			Color.FromRgb (0x9F, 0x00, 0xFF),
			Color.FromRgb (0xA5, 0x00, 0xFF),
			Color.FromRgb (0xAC, 0x00, 0xFF),
			Color.FromRgb (0xB2, 0x00, 0xFF),
			Color.FromRgb (0xB9, 0x00, 0xFF),
			Color.FromRgb (0xBF, 0x00, 0xFF),
			Color.FromRgb (0xC6, 0x00, 0xFF),
			Color.FromRgb (0xCC, 0x00, 0xFF),
			Color.FromRgb (0xD2, 0x00, 0xFF),
			Color.FromRgb (0xD9, 0x00, 0xFF),
			Color.FromRgb (0xDF, 0x00, 0xFF),
			Color.FromRgb (0xE5, 0x00, 0xFF),
			Color.FromRgb (0xEC, 0x00, 0xFF),
			Color.FromRgb (0xF2, 0x00, 0xFF),
			Color.FromRgb (0xF8, 0x00, 0xFF),
			Color.FromRgb (0xFF, 0x00, 0xFF),
			Color.FromRgb (0xFF, 0x00, 0xF8),
			Color.FromRgb (0xFF, 0x00, 0xF2),
			Color.FromRgb (0xFF, 0x00, 0xEB),
			Color.FromRgb (0xFF, 0x00, 0xE5),
			Color.FromRgb (0xFF, 0x00, 0xDF),
			Color.FromRgb (0xFF, 0x00, 0xD8),
			Color.FromRgb (0xFF, 0x00, 0xD2),
			Color.FromRgb (0xFF, 0x00, 0xCB),
			Color.FromRgb (0xFF, 0x00, 0xC5),
			Color.FromRgb (0xFF, 0x00, 0xBF),
			Color.FromRgb (0xFF, 0x00, 0xB8),
			Color.FromRgb (0xFF, 0x00, 0xB2),
			Color.FromRgb (0xFF, 0x00, 0xAB),
			Color.FromRgb (0xFF, 0x00, 0xA5),
			Color.FromRgb (0xFF, 0x00, 0x9F),
			Color.FromRgb (0xFF, 0x00, 0x98),
			Color.FromRgb (0xFF, 0x00, 0x92),
			Color.FromRgb (0xFF, 0x00, 0x8B),
			Color.FromRgb (0xFF, 0x00, 0x85),
			Color.FromRgb (0xFF, 0x00, 0x7F),
			Color.FromRgb (0xFF, 0x00, 0x78),
			Color.FromRgb (0xFF, 0x00, 0x72),
			Color.FromRgb (0xFF, 0x00, 0x6B),
			Color.FromRgb (0xFF, 0x00, 0x65),
			Color.FromRgb (0xFF, 0x00, 0x5F),
			Color.FromRgb (0xFF, 0x00, 0x58),
			Color.FromRgb (0xFF, 0x00, 0x52),
			Color.FromRgb (0xFF, 0x00, 0x4B),
			Color.FromRgb (0xFF, 0x00, 0x45),
			Color.FromRgb (0xFF, 0x00, 0x3F),
			Color.FromRgb (0xFF, 0x00, 0x38),
			Color.FromRgb (0xFF, 0x00, 0x32),
			Color.FromRgb (0xFF, 0x00, 0x2B),
			Color.FromRgb (0xFF, 0x00, 0x25),
			Color.FromRgb (0xFF, 0x00, 0x1F),
			Color.FromRgb (0xFF, 0x00, 0x18),
			Color.FromRgb (0xFF, 0x00, 0x12),
			Color.FromRgb (0xFF, 0x00, 0x0B),
			Color.FromRgb (0xFF, 0x00, 0x06),
			Color.FromRgb (0xFF, 0x00, 0x00),
			Color.FromRgb (0xFF, 0x06, 0x00),
			Color.FromRgb (0xFF, 0x0C, 0x00),
			Color.FromRgb (0xFF, 0x13, 0x00),
			Color.FromRgb (0xFF, 0x19, 0x00),
			Color.FromRgb (0xFF, 0x1F, 0x00),
			Color.FromRgb (0xFF, 0x26, 0x00),
			Color.FromRgb (0xFF, 0x2C, 0x00),
			Color.FromRgb (0xFF, 0x33, 0x00),
			Color.FromRgb (0xFF, 0x39, 0x00),
			Color.FromRgb (0xFF, 0x3F, 0x00),
			Color.FromRgb (0xFF, 0x46, 0x00),
			Color.FromRgb (0xFF, 0x4C, 0x00),
			Color.FromRgb (0xFF, 0x53, 0x00),
			Color.FromRgb (0xFF, 0x59, 0x00),
			Color.FromRgb (0xFF, 0x5F, 0x00),
			Color.FromRgb (0xFF, 0x66, 0x00),
			Color.FromRgb (0xFF, 0x6C, 0x00),
			Color.FromRgb (0xFF, 0x73, 0x00),
			Color.FromRgb (0xFF, 0x79, 0x00),
			Color.FromRgb (0xFF, 0x7F, 0x00),
			Color.FromRgb (0xFF, 0x86, 0x00),
			Color.FromRgb (0xFF, 0x8C, 0x00),
			Color.FromRgb (0xFF, 0x93, 0x00),
			Color.FromRgb (0xFF, 0x99, 0x00),
			Color.FromRgb (0xFF, 0x9F, 0x00),
			Color.FromRgb (0xFF, 0xA6, 0x00),
			Color.FromRgb (0xFF, 0xAC, 0x00),
			Color.FromRgb (0xFF, 0xB3, 0x00),
			Color.FromRgb (0xFF, 0xB9, 0x00),
			Color.FromRgb (0xFF, 0xBF, 0x00),
			Color.FromRgb (0xFF, 0xC6, 0x00),
			Color.FromRgb (0xFF, 0xCC, 0x00),
			Color.FromRgb (0xFF, 0xD3, 0x00),
			Color.FromRgb (0xFF, 0xD9, 0x00),
			Color.FromRgb (0xFF, 0xDF, 0x00),
			Color.FromRgb (0xFF, 0xE6, 0x00),
			Color.FromRgb (0xFF, 0xEC, 0x00),
			Color.FromRgb (0xFF, 0xF3, 0x00),
			Color.FromRgb (0xFF, 0xF8, 0x00),
			Color.FromRgb (0xFF, 0xFF, 0x00),
			Color.FromRgb (0xF8, 0xFF, 0x00),
			Color.FromRgb (0xF2, 0xFF, 0x00),
			Color.FromRgb (0xEB, 0xFF, 0x00),
			Color.FromRgb (0xE5, 0xFF, 0x00),
			Color.FromRgb (0xDF, 0xFF, 0x00),
			Color.FromRgb (0xD8, 0xFF, 0x00),
			Color.FromRgb (0xD2, 0xFF, 0x00),
			Color.FromRgb (0xCC, 0xFF, 0x00),
			Color.FromRgb (0xC5, 0xFF, 0x00),
			Color.FromRgb (0xBF, 0xFF, 0x00),
			Color.FromRgb (0xB8, 0xFF, 0x00),
			Color.FromRgb (0xB2, 0xFF, 0x00),
			Color.FromRgb (0xAC, 0xFF, 0x00),
			Color.FromRgb (0xA5, 0xFF, 0x00),
			Color.FromRgb (0x9F, 0xFF, 0x00),
			Color.FromRgb (0x99, 0xFF, 0x00),
			Color.FromRgb (0x92, 0xFF, 0x00),
			Color.FromRgb (0x8C, 0xFF, 0x00),
			Color.FromRgb (0x85, 0xFF, 0x00),
			Color.FromRgb (0x7F, 0xFF, 0x00),
			Color.FromRgb (0x79, 0xFF, 0x00),
			Color.FromRgb (0x72, 0xFF, 0x00),
			Color.FromRgb (0x6C, 0xFF, 0x00),
			Color.FromRgb (0x66, 0xFF, 0x00),
			Color.FromRgb (0x5F, 0xFF, 0x00),
			Color.FromRgb (0x59, 0xFF, 0x00),
			Color.FromRgb (0x52, 0xFF, 0x00),
			Color.FromRgb (0x4C, 0xFF, 0x00),
			Color.FromRgb (0x46, 0xFF, 0x00),
			Color.FromRgb (0x3F, 0xFF, 0x00),
			Color.FromRgb (0x39, 0xFF, 0x00),
			Color.FromRgb (0x33, 0xFF, 0x00),
			Color.FromRgb (0x2C, 0xFF, 0x00),
			Color.FromRgb (0x26, 0xFF, 0x00),
			Color.FromRgb (0x1F, 0xFF, 0x00),
			Color.FromRgb (0x19, 0xFF, 0x00),
			Color.FromRgb (0x13, 0xFF, 0x00),
			Color.FromRgb (0x0C, 0xFF, 0x00),
			Color.FromRgb (0x0C, 0xFF, 0x00),
			Color.FromRgb (0x00, 0xFF, 0x00),
			Color.FromRgb (0x00, 0xFF, 0x06),
			Color.FromRgb (0x00, 0xFF, 0x0C),
			Color.FromRgb (0x00, 0xFF, 0x13),
			Color.FromRgb (0x00, 0xFF, 0x19),
			Color.FromRgb (0x00, 0xFF, 0x1F),
			Color.FromRgb (0x00, 0xFF, 0x26),
			Color.FromRgb (0x00, 0xFF, 0x2C),
			Color.FromRgb (0x00, 0xFF, 0x33),
			Color.FromRgb (0x00, 0xFF, 0x39),
			Color.FromRgb (0x00, 0xFF, 0x3F),
			Color.FromRgb (0x00, 0xFF, 0x46),
			Color.FromRgb (0x00, 0xFF, 0x4C),
			Color.FromRgb (0x00, 0xFF, 0x52),
			Color.FromRgb (0x00, 0xFF, 0x59),
			Color.FromRgb (0x00, 0xFF, 0x5F),
			Color.FromRgb (0x00, 0xFF, 0x66),
			Color.FromRgb (0x00, 0xFF, 0x6C),
			Color.FromRgb (0x00, 0xFF, 0x72),
			Color.FromRgb (0x00, 0xFF, 0x79),
			Color.FromRgb (0x00, 0xFF, 0x7F),
			Color.FromRgb (0x00, 0xFF, 0x85),
			Color.FromRgb (0x00, 0xFF, 0x8C),
			Color.FromRgb (0x00, 0xFF, 0x92),
			Color.FromRgb (0x00, 0xFF, 0x99),
			Color.FromRgb (0x00, 0xFF, 0x9F),
			Color.FromRgb (0x00, 0xFF, 0xA5),
			Color.FromRgb (0x00, 0xFF, 0xAC),
			Color.FromRgb (0x00, 0xFF, 0xB2),
			Color.FromRgb (0x00, 0xFF, 0xB8),
			Color.FromRgb (0x00, 0xFF, 0xBF),
			Color.FromRgb (0x00, 0xFF, 0xC5),
			Color.FromRgb (0x00, 0xFF, 0xCC),
			Color.FromRgb (0x00, 0xFF, 0xD2),
			Color.FromRgb (0x00, 0xFF, 0xD8),
			Color.FromRgb (0x00, 0xFF, 0xDF),
			Color.FromRgb (0x00, 0xFF, 0xE5),
			Color.FromRgb (0x00, 0xFF, 0xEB),
			Color.FromRgb (0x00, 0xFF, 0xF2),
			Color.FromRgb (0x00, 0xFF, 0xF8),
			Color.FromRgb (0x00, 0xFF, 0xFF),
			Color.FromRgb (0x00, 0xF8, 0xFF),
			Color.FromRgb (0x00, 0xF2, 0xFF),
			Color.FromRgb (0x00, 0xEB, 0xFF),
			Color.FromRgb (0x00, 0xE5, 0xFF),
			Color.FromRgb (0x00, 0xDF, 0xFF),
			Color.FromRgb (0x00, 0xD8, 0xFF),
			Color.FromRgb (0x00, 0xD2, 0xFF),
			Color.FromRgb (0x00, 0xCC, 0xFF),
			Color.FromRgb (0x00, 0xC5, 0xFF),
			Color.FromRgb (0x00, 0xBF, 0xFF),
			Color.FromRgb (0x00, 0xB8, 0xFF),
			Color.FromRgb (0x00, 0xB2, 0xFF),
			Color.FromRgb (0x00, 0xAC, 0xFF),
			Color.FromRgb (0x00, 0xA5, 0xFF),
			Color.FromRgb (0x00, 0x9F, 0xFF),
			Color.FromRgb (0x00, 0x99, 0xFF),
			Color.FromRgb (0x00, 0x92, 0xFF),
			Color.FromRgb (0x00, 0x8C, 0xFF),
			Color.FromRgb (0x00, 0x85, 0xFF),
			Color.FromRgb (0x00, 0x7F, 0xFF),
			Color.FromRgb (0x00, 0x79, 0xFF),
			Color.FromRgb (0x00, 0x72, 0xFF),
			Color.FromRgb (0xF0, 0xF0, 0xF0),
			Color.FromRgb (0xE0, 0xE0, 0xE0),
			Color.FromRgb (0xD0, 0xD0, 0xD0),
			Color.FromRgb (0xC0, 0xC0, 0xC0),
			Color.FromRgb (0xB0, 0xB0, 0xB0),
			Color.FromRgb (0xA0, 0xA0, 0xA0),
			Color.FromRgb (0x90, 0x90, 0x90),
			Color.FromRgb (0x80, 0x80, 0x80),
			Color.FromRgb (0x70, 0x70, 0x70),
			Color.FromRgb (0x60, 0x60, 0x60),
			Color.FromRgb (0x50, 0x50, 0x50),
			Color.FromRgb (0x40, 0x40, 0x40),
			Color.FromRgb (0x30, 0x30, 0x30),
			Color.FromRgb (0x20, 0x20, 0x20),
			Color.FromRgb (0x10, 0x10, 0x10),
			Color.FromRgb (0x00, 0x00, 0x00),
        });

        public static readonly BitmapPalette Grayscale = new BitmapPalette (new Color[] {
			Color.FromRgb (0xFF, 0xFF, 0xFF),
			Color.FromRgb (0xFE, 0xFE, 0xFE),
			Color.FromRgb (0xFD, 0xFD, 0xFD),
			Color.FromRgb (0xFC, 0xFC, 0xFC),
			Color.FromRgb (0xFB, 0xFB, 0xFB),
			Color.FromRgb (0xFA, 0xFA, 0xFA),
			Color.FromRgb (0xF9, 0xF9, 0xF9),
			Color.FromRgb (0xF8, 0xF8, 0xF8),
			Color.FromRgb (0xF7, 0xF7, 0xF7),
			Color.FromRgb (0xF6, 0xF6, 0xF6),
			Color.FromRgb (0xF5, 0xF5, 0xF5),
			Color.FromRgb (0xF4, 0xF4, 0xF4),
			Color.FromRgb (0xF3, 0xF3, 0xF3),
			Color.FromRgb (0xF2, 0xF2, 0xF2),
			Color.FromRgb (0xF1, 0xF1, 0xF1),
			Color.FromRgb (0xF0, 0xF0, 0xF0),
			Color.FromRgb (0xEF, 0xEF, 0xEF),
			Color.FromRgb (0xEE, 0xEE, 0xEE),
			Color.FromRgb (0xED, 0xED, 0xED),
			Color.FromRgb (0xEC, 0xEC, 0xEC),
			Color.FromRgb (0xEB, 0xEB, 0xEB),
			Color.FromRgb (0xEA, 0xEA, 0xEA),
			Color.FromRgb (0xE9, 0xE9, 0xE9),
			Color.FromRgb (0xE8, 0xE8, 0xE8),
			Color.FromRgb (0xE7, 0xE7, 0xE7),
			Color.FromRgb (0xE6, 0xE6, 0xE6),
			Color.FromRgb (0xE5, 0xE5, 0xE5),
			Color.FromRgb (0xE4, 0xE4, 0xE4),
			Color.FromRgb (0xE3, 0xE3, 0xE3),
			Color.FromRgb (0xE2, 0xE2, 0xE2),
			Color.FromRgb (0xE1, 0xE1, 0xE1),
			Color.FromRgb (0xE0, 0xE0, 0xE0),
			Color.FromRgb (0xDF, 0xDF, 0xDF),
			Color.FromRgb (0xDE, 0xDE, 0xDE),
			Color.FromRgb (0xDD, 0xDD, 0xDD),
			Color.FromRgb (0xDC, 0xDC, 0xDC),
			Color.FromRgb (0xDB, 0xDB, 0xDB),
			Color.FromRgb (0xDA, 0xDA, 0xDA),
			Color.FromRgb (0xD9, 0xD9, 0xD9),
			Color.FromRgb (0xD8, 0xD8, 0xD8),
			Color.FromRgb (0xD7, 0xD7, 0xD7),
			Color.FromRgb (0xD6, 0xD6, 0xD6),
			Color.FromRgb (0xD5, 0xD5, 0xD5),
			Color.FromRgb (0xD4, 0xD4, 0xD4),
			Color.FromRgb (0xD3, 0xD3, 0xD3),
			Color.FromRgb (0xD2, 0xD2, 0xD2),
			Color.FromRgb (0xD1, 0xD1, 0xD1),
			Color.FromRgb (0xD0, 0xD0, 0xD0),
			Color.FromRgb (0xCF, 0xCF, 0xCF),
			Color.FromRgb (0xCE, 0xCE, 0xCE),
			Color.FromRgb (0xCD, 0xCD, 0xCD),
			Color.FromRgb (0xCC, 0xCC, 0xCC),
			Color.FromRgb (0xCB, 0xCB, 0xCB),
			Color.FromRgb (0xCA, 0xCA, 0xCA),
			Color.FromRgb (0xC9, 0xC9, 0xC9),
			Color.FromRgb (0xC8, 0xC8, 0xC8),
			Color.FromRgb (0xC7, 0xC7, 0xC7),
			Color.FromRgb (0xC6, 0xC6, 0xC6),
			Color.FromRgb (0xC5, 0xC5, 0xC5),
			Color.FromRgb (0xC4, 0xC4, 0xC4),
			Color.FromRgb (0xC3, 0xC3, 0xC3),
			Color.FromRgb (0xC2, 0xC2, 0xC2),
			Color.FromRgb (0xC1, 0xC1, 0xC1),
			Color.FromRgb (0xC0, 0xC0, 0xC0),
			Color.FromRgb (0xBF, 0xBF, 0xBF),
			Color.FromRgb (0xBE, 0xBE, 0xBE),
			Color.FromRgb (0xBD, 0xBD, 0xBD),
			Color.FromRgb (0xBC, 0xBC, 0xBC),
			Color.FromRgb (0xBB, 0xBB, 0xBB),
			Color.FromRgb (0xBA, 0xBA, 0xBA),
			Color.FromRgb (0xB9, 0xB9, 0xB9),
			Color.FromRgb (0xB8, 0xB8, 0xB8),
			Color.FromRgb (0xB7, 0xB7, 0xB7),
			Color.FromRgb (0xB6, 0xB6, 0xB6),
			Color.FromRgb (0xB5, 0xB5, 0xB5),
			Color.FromRgb (0xB4, 0xB4, 0xB4),
			Color.FromRgb (0xB3, 0xB3, 0xB3),
			Color.FromRgb (0xB2, 0xB2, 0xB2),
			Color.FromRgb (0xB1, 0xB1, 0xB1),
			Color.FromRgb (0xB0, 0xB0, 0xB0),
			Color.FromRgb (0xAF, 0xAF, 0xAF),
			Color.FromRgb (0xAE, 0xAE, 0xAE),
			Color.FromRgb (0xAD, 0xAD, 0xAD),
			Color.FromRgb (0xAC, 0xAC, 0xAC),
			Color.FromRgb (0xAB, 0xAB, 0xAB),
			Color.FromRgb (0xAA, 0xAA, 0xAA),
			Color.FromRgb (0xA9, 0xA9, 0xA9),
			Color.FromRgb (0xA8, 0xA8, 0xA8),
			Color.FromRgb (0xA7, 0xA7, 0xA7),
			Color.FromRgb (0xA6, 0xA6, 0xA6),
			Color.FromRgb (0xA5, 0xA5, 0xA5),
			Color.FromRgb (0xA4, 0xA4, 0xA4),
			Color.FromRgb (0xA3, 0xA3, 0xA3),
			Color.FromRgb (0xA2, 0xA2, 0xA2),
			Color.FromRgb (0xA1, 0xA1, 0xA1),
			Color.FromRgb (0xA0, 0xA0, 0xA0),
			Color.FromRgb (0x9F, 0x9F, 0x9F),
			Color.FromRgb (0x9E, 0x9E, 0x9E),
			Color.FromRgb (0x9D, 0x9D, 0x9D),
			Color.FromRgb (0x9C, 0x9C, 0x9C),
			Color.FromRgb (0x9B, 0x9B, 0x9B),
			Color.FromRgb (0x9A, 0x9A, 0x9A),
			Color.FromRgb (0x99, 0x99, 0x99),
			Color.FromRgb (0x98, 0x98, 0x98),
			Color.FromRgb (0x97, 0x97, 0x97),
			Color.FromRgb (0x96, 0x96, 0x96),
			Color.FromRgb (0x95, 0x95, 0x95),
			Color.FromRgb (0x94, 0x94, 0x94),
			Color.FromRgb (0x93, 0x93, 0x93),
			Color.FromRgb (0x92, 0x92, 0x92),
			Color.FromRgb (0x91, 0x91, 0x91),
			Color.FromRgb (0x90, 0x90, 0x90),
			Color.FromRgb (0x8F, 0x8F, 0x8F),
			Color.FromRgb (0x8E, 0x8E, 0x8E),
			Color.FromRgb (0x8D, 0x8D, 0x8D),
			Color.FromRgb (0x8C, 0x8C, 0x8C),
			Color.FromRgb (0x8B, 0x8B, 0x8B),
			Color.FromRgb (0x8A, 0x8A, 0x8A),
			Color.FromRgb (0x89, 0x89, 0x89),
			Color.FromRgb (0x88, 0x88, 0x88),
			Color.FromRgb (0x87, 0x87, 0x87),
			Color.FromRgb (0x86, 0x86, 0x86),
			Color.FromRgb (0x85, 0x85, 0x85),
			Color.FromRgb (0x84, 0x84, 0x84),
			Color.FromRgb (0x83, 0x83, 0x83),
			Color.FromRgb (0x82, 0x82, 0x82),
			Color.FromRgb (0x81, 0x81, 0x81),
			Color.FromRgb (0x80, 0x80, 0x80),
			Color.FromRgb (0x7F, 0x7F, 0x7F),
			Color.FromRgb (0x7E, 0x7E, 0x7E),
			Color.FromRgb (0x7D, 0x7D, 0x7D),
			Color.FromRgb (0x7C, 0x7C, 0x7C),
			Color.FromRgb (0x7B, 0x7B, 0x7B),
			Color.FromRgb (0x7A, 0x7A, 0x7A),
			Color.FromRgb (0x79, 0x79, 0x79),
			Color.FromRgb (0x78, 0x78, 0x78),
			Color.FromRgb (0x77, 0x77, 0x77),
			Color.FromRgb (0x76, 0x76, 0x76),
			Color.FromRgb (0x75, 0x75, 0x75),
			Color.FromRgb (0x74, 0x74, 0x74),
			Color.FromRgb (0x73, 0x73, 0x73),
			Color.FromRgb (0x72, 0x72, 0x72),
			Color.FromRgb (0x71, 0x71, 0x71),
			Color.FromRgb (0x70, 0x70, 0x70),
			Color.FromRgb (0x6F, 0x6F, 0x6F),
			Color.FromRgb (0x6E, 0x6E, 0x6E),
			Color.FromRgb (0x6D, 0x6D, 0x6D),
			Color.FromRgb (0x6C, 0x6C, 0x6C),
			Color.FromRgb (0x6B, 0x6B, 0x6B),
			Color.FromRgb (0x6A, 0x6A, 0x6A),
			Color.FromRgb (0x69, 0x69, 0x69),
			Color.FromRgb (0x68, 0x68, 0x68),
			Color.FromRgb (0x67, 0x67, 0x67),
			Color.FromRgb (0x66, 0x66, 0x66),
			Color.FromRgb (0x65, 0x65, 0x65),
			Color.FromRgb (0x64, 0x64, 0x64),
			Color.FromRgb (0x63, 0x63, 0x63),
			Color.FromRgb (0x62, 0x62, 0x62),
			Color.FromRgb (0x61, 0x61, 0x61),
			Color.FromRgb (0x60, 0x60, 0x60),
			Color.FromRgb (0x5F, 0x5F, 0x5F),
			Color.FromRgb (0x5E, 0x5E, 0x5E),
			Color.FromRgb (0x5D, 0x5D, 0x5D),
			Color.FromRgb (0x5C, 0x5C, 0x5C),
			Color.FromRgb (0x5B, 0x5B, 0x5B),
			Color.FromRgb (0x5A, 0x5A, 0x5A),
			Color.FromRgb (0x59, 0x59, 0x59),
			Color.FromRgb (0x58, 0x58, 0x58),
			Color.FromRgb (0x57, 0x57, 0x57),
			Color.FromRgb (0x56, 0x56, 0x56),
			Color.FromRgb (0x55, 0x55, 0x55),
			Color.FromRgb (0x54, 0x54, 0x54),
			Color.FromRgb (0x53, 0x53, 0x53),
			Color.FromRgb (0x52, 0x52, 0x52),
			Color.FromRgb (0x51, 0x51, 0x51),
			Color.FromRgb (0x50, 0x50, 0x50),
			Color.FromRgb (0x4F, 0x4F, 0x4F),
			Color.FromRgb (0x4E, 0x4E, 0x4E),
			Color.FromRgb (0x4D, 0x4D, 0x4D),
			Color.FromRgb (0x4C, 0x4C, 0x4C),
			Color.FromRgb (0x4B, 0x4B, 0x4B),
			Color.FromRgb (0x4A, 0x4A, 0x4A),
			Color.FromRgb (0x49, 0x49, 0x49),
			Color.FromRgb (0x48, 0x48, 0x48),
			Color.FromRgb (0x47, 0x47, 0x47),
			Color.FromRgb (0x46, 0x46, 0x46),
			Color.FromRgb (0x45, 0x45, 0x45),
			Color.FromRgb (0x44, 0x44, 0x44),
			Color.FromRgb (0x43, 0x43, 0x43),
			Color.FromRgb (0x42, 0x42, 0x42),
			Color.FromRgb (0x41, 0x41, 0x41),
			Color.FromRgb (0x40, 0x40, 0x40),
			Color.FromRgb (0x3F, 0x3F, 0x3F),
			Color.FromRgb (0x3E, 0x3E, 0x3E),
			Color.FromRgb (0x3D, 0x3D, 0x3D),
			Color.FromRgb (0x3C, 0x3C, 0x3C),
			Color.FromRgb (0x3B, 0x3B, 0x3B),
			Color.FromRgb (0x3A, 0x3A, 0x3A),
			Color.FromRgb (0x39, 0x39, 0x39),
			Color.FromRgb (0x38, 0x38, 0x38),
			Color.FromRgb (0x37, 0x37, 0x37),
			Color.FromRgb (0x36, 0x36, 0x36),
			Color.FromRgb (0x35, 0x35, 0x35),
			Color.FromRgb (0x34, 0x34, 0x34),
			Color.FromRgb (0x33, 0x33, 0x33),
			Color.FromRgb (0x32, 0x32, 0x32),
			Color.FromRgb (0x31, 0x31, 0x31),
			Color.FromRgb (0x30, 0x30, 0x30),
			Color.FromRgb (0x2F, 0x2F, 0x2F),
			Color.FromRgb (0x2E, 0x2E, 0x2E),
			Color.FromRgb (0x2D, 0x2D, 0x2D),
			Color.FromRgb (0x2C, 0x2C, 0x2C),
			Color.FromRgb (0x2B, 0x2B, 0x2B),
			Color.FromRgb (0x2A, 0x2A, 0x2A),
			Color.FromRgb (0x29, 0x29, 0x29),
			Color.FromRgb (0x28, 0x28, 0x28),
			Color.FromRgb (0x27, 0x27, 0x27),
			Color.FromRgb (0x26, 0x26, 0x26),
			Color.FromRgb (0x25, 0x25, 0x25),
			Color.FromRgb (0x24, 0x24, 0x24),
			Color.FromRgb (0x23, 0x23, 0x23),
			Color.FromRgb (0x22, 0x22, 0x22),
			Color.FromRgb (0x21, 0x21, 0x21),
			Color.FromRgb (0x20, 0x20, 0x20),
			Color.FromRgb (0x1F, 0x1F, 0x1F),
			Color.FromRgb (0x1E, 0x1E, 0x1E),
			Color.FromRgb (0x1D, 0x1D, 0x1D),
			Color.FromRgb (0x1C, 0x1C, 0x1C),
			Color.FromRgb (0x1B, 0x1B, 0x1B),
			Color.FromRgb (0x1A, 0x1A, 0x1A),
			Color.FromRgb (0x19, 0x19, 0x19),
			Color.FromRgb (0x18, 0x18, 0x18),
			Color.FromRgb (0x17, 0x17, 0x17),
			Color.FromRgb (0x16, 0x16, 0x16),
			Color.FromRgb (0x15, 0x15, 0x15),
			Color.FromRgb (0x14, 0x14, 0x14),
			Color.FromRgb (0x13, 0x13, 0x13),
			Color.FromRgb (0x12, 0x12, 0x12),
			Color.FromRgb (0x11, 0x11, 0x11),
			Color.FromRgb (0x10, 0x10, 0x10),
			Color.FromRgb (0x0F, 0x0F, 0x0F),
			Color.FromRgb (0x0E, 0x0E, 0x0E),
			Color.FromRgb (0x0D, 0x0D, 0x0D),
			Color.FromRgb (0x0C, 0x0C, 0x0C),
			Color.FromRgb (0x0B, 0x0B, 0x0B),
			Color.FromRgb (0x0A, 0x0A, 0x0A),
			Color.FromRgb (0x09, 0x09, 0x09),
			Color.FromRgb (0x08, 0x08, 0x08),
			Color.FromRgb (0x07, 0x07, 0x07),
			Color.FromRgb (0x06, 0x06, 0x06),
			Color.FromRgb (0x05, 0x05, 0x05),
			Color.FromRgb (0x04, 0x04, 0x04),
			Color.FromRgb (0x03, 0x03, 0x03),
			Color.FromRgb (0x02, 0x02, 0x02),
			Color.FromRgb (0x01, 0x01, 0x01),
			Color.FromRgb (0x00, 0x00, 0x00),
        });
    }
}
