//! \file       BdtTables.cs
//! \date       2023 Sep 10
//! \brief      BDT archives key tables.
//

namespace GameRes.Formats.FC01
{
    public partial class BdtOpener
    {
        internal static readonly ushort[] KeyOffsetTable = new ushort[] { // dword_4C7D80
            0x029, 0x0E3, 0x05E, 0x104, 0x261, 0x16C, 0x256, 0x22E, 0x08A, 0x023, 0x1B4, 0x01D, 0x115, 0x0D5,
            0x178, 0x1EB, 0x07F, 0x1D6, 0x02F, 0x14C, 0x238, 0x04A, 0x099, 0x124, 0x1C9, 0x0F9, 0x071, 0x260,
            0x094, 0x15F, 0x044, 0x078, 0x072, 0x1B9, 0x18C, 0x0E3, 0x0DF, 0x1F3, 0x162, 0x053, 0x03D, 0x1BF,
            0x198, 0x210, 0x0DB, 0x218, 0x05B, 0x139, 0x0E8, 0x1A9, 0x098, 0x148, 0x1A7, 0x17F, 0x0B3, 0x1E1,
            0x119, 0x05F, 0x131, 0x121, 0x1F7, 0x023, 0x240, 0x120, 0x172, 0x048, 0x1BE, 0x130, 0x10E, 0x1A5,
            0x05A, 0x199, 0x15D, 0x116, 0x195, 0x0B6, 0x19F, 0x189, 0x003, 0x06A, 0x0D6, 0x1AA, 0x05A, 0x22C,
            0x1BE, 0x047, 0x1DE, 0x234, 0x04E, 0x0EE, 0x043, 0x1F9, 0x098, 0x0C3, 0x11D, 0x0BB, 0x099, 0x1AB,
            0x0AE, 0x060, 0x1FE, 0x0A1, 0x1A6, 0x111, 0x1B5, 0x15F, 0x102, 0x24E, 0x106, 0x000, 0x0BA, 0x1BB,
            0x0C3, 0x0CA, 0x0DC, 0x090, 0x18D, 0x1E2, 0x1BD, 0x161, 0x0E5, 0x137, 0x17C, 0x20D, 0x042, 0x1DA,
            0x0D8, 0x131, 0x013, 0x01F, 0x177, 0x069, 0x1AF, 0x129, 0x18F, 0x251, 0x070, 0x106, 0x091, 0x209,
            0x0C0, 0x01A, 0x05E, 0x23A, 0x0F3, 0x03E, 0x1B6, 0x0F7, 0x066, 0x19B, 0x268, 0x08B, 0x0FD, 0x156,
            0x01D, 0x10F, 0x13B, 0x1F1, 0x083, 0x163, 0x010, 0x1B8, 0x1C8, 0x1CD, 0x103, 0x1C0, 0x0DD, 0x18A,
            0x035, 0x0A3, 0x0FF, 0x0B0, 0x1D3, 0x00E, 0x025, 0x1FB, 0x193, 0x083, 0x0CD, 0x235, 0x0F4, 0x05F,
            0x0C8, 0x18B, 0x055, 0x0DE, 0x017, 0x24A, 0x046, 0x036, 0x207, 0x123, 0x0E9, 0x18D, 0x146, 0x073,
            0x09D, 0x00D, 0x0AF, 0x153, 0x0C2, 0x0A8, 0x0AF, 0x21F, 0x1D4, 0x074, 0x026, 0x20C, 0x170, 0x13B,
            0x173, 0x0D2, 0x122, 0x076, 0x00C, 0x200, 0x0AA, 0x046, 0x0D4, 0x25A, 0x03D, 0x0C7, 0x0CF, 0x1DD,
            0x17E, 0x176, 0x13C, 0x1D7, 0x084, 0x002, 0x02E, 0x203, 0x014, 0x067, 0x12A, 0x00F, 0x0C2, 0x1F0,
            0x0E2, 0x222, 0x0C9, 0x079, 0x12B, 0x1A0, 0x1BA, 0x257, 0x156, 0x0A0, 0x109, 0x17A, 0x15E, 0x048,
            0x02D, 0x01E, 0x24D, 0x082, 0x1AD, 0x0D0, 0x042, 0x029, 0x068, 0x214, 0x14A, 0x0B9, 0x0CB, 0x134,
            0x027, 0x223, 0x0A3, 0x0B4, 0x0EC, 0x197, 0x107, 0x136, 0x0B9, 0x12F, 0x20B, 0x220, 0x145, 0x07F,
            0x052, 0x11E, 0x02C, 0x0C1, 0x0CD, 0x110, 0x1C3, 0x1C8, 0x044, 0x162, 0x09D, 0x087, 0x15E, 0x0B7,
            0x055, 0x17D, 0x076, 0x01A, 0x0B0, 0x017, 0x05C, 0x012, 0x247, 0x081, 0x088, 0x0A6, 0x14C, 0x075,
            0x248, 0x151, 0x0E8, 0x004, 0x032, 0x111, 0x1A4, 0x1A9, 0x0BF, 0x137, 0x21A, 0x0D7, 0x189, 0x04A,
            0x12E, 0x170, 0x0DA, 0x019, 0x04D, 0x0D6, 0x16A, 0x168, 0x19C, 0x19C, 0x188, 0x1C4, 0x204, 0x12B,
            0x125, 0x128, 0x00B, 0x114, 0x0E7, 0x070, 0x06C, 0x1FD, 0x0C6, 0x1B0, 0x003, 0x15D, 0x085, 0x07A,
            0x1C2, 0x237, 0x041, 0x07D, 0x183, 0x08E, 0x216, 0x126, 0x224, 0x010, 0x0E4, 0x059, 0x019, 0x0EB,
            0x1E8, 0x04C, 0x1F6, 0x091, 0x18E, 0x08C, 0x0F0, 0x13F, 0x0F0, 0x065, 0x157, 0x1B8, 0x08E, 0x142,
            0x033, 0x20F, 0x03B, 0x242, 0x1AC, 0x0E0, 0x005, 0x1A3, 0x17B, 0x03C, 0x175, 0x22D, 0x239, 0x10A,
            0x022, 0x006, 0x07B, 0x16D, 0x014, 0x052, 0x241, 0x1B1, 0x12C, 0x074, 0x0F1, 0x1FF, 0x0B1, 0x118,
            0x0AE, 0x062, 0x139, 0x0DD, 0x103, 0x193, 0x11A, 0x02B, 0x06E, 0x077, 0x0A7, 0x158, 0x15C, 0x21D,
            0x230, 0x009, 0x194, 0x215, 0x171, 0x09F, 0x0DB, 0x174, 0x04F, 0x17E, 0x022, 0x1FC, 0x196, 0x06C,
            0x04F, 0x16A, 0x1C6, 0x142, 0x1D1, 0x1A1, 0x045, 0x024, 0x092, 0x16F, 0x0A7, 0x1B0, 0x231, 0x1D6,
            0x129, 0x181, 0x145, 0x0AC, 0x050, 0x0E6, 0x024, 0x154, 0x002, 0x152, 0x016, 0x23B, 0x1B2, 0x14F,
            0x132, 0x17C, 0x11C, 0x00D, 0x085, 0x208, 0x229, 0x1D9, 0x158, 0x13E, 0x135, 0x018, 0x0E2, 0x12C,
            0x1D5, 0x1C5, 0x168, 0x054, 0x108, 0x17F, 0x09C, 0x1ED, 0x021, 0x127, 0x160, 0x03A, 0x0BF, 0x0B3,
            0x10B, 0x140, 0x008, 0x13A, 0x232, 0x186, 0x051, 0x061, 0x056, 0x09B, 0x059, 0x19A, 0x0B5, 0x169,
            0x066, 0x16E, 0x07C, 0x072, 0x0A4, 0x144, 0x196, 0x133, 0x0F7, 0x16B, 0x118, 0x1E0, 0x16E, 0x17B,
            0x034, 0x11B, 0x06F, 0x08F, 0x0C0, 0x0EE, 0x213, 0x03F, 0x181, 0x141, 0x0A5, 0x09E, 0x120, 0x0F9,
            0x0F8, 0x030, 0x187, 0x155, 0x050, 0x069, 0x151, 0x03E, 0x164, 0x032, 0x0E9, 0x0D4, 0x000, 0x0AD,
            0x178, 0x19E, 0x1C1, 0x21C, 0x10C, 0x21E, 0x0AB, 0x0FC, 0x026, 0x1AA, 0x01C, 0x177, 0x058, 0x04B,
            0x10D, 0x0DF, 0x081, 0x079, 0x08C, 0x1D2, 0x21B, 0x0B2, 0x049, 0x025, 0x14D, 0x18C, 0x018, 0x19D,
            0x202, 0x125, 0x073, 0x0D9, 0x191, 0x198, 0x1AB, 0x07B, 0x005, 0x1C9, 0x114, 0x065, 0x0F6, 0x02A,
            0x0C4, 0x0DC, 0x056, 0x108, 0x009, 0x07E, 0x180, 0x07E, 0x0A5, 0x1A8, 0x09F, 0x1C7, 0x094, 0x0BD,
            0x028, 0x11E, 0x107, 0x0AB, 0x0EF, 0x05D, 0x0C8, 0x096, 0x037, 0x1BF, 0x1EE, 0x06F, 0x201, 0x219,
            0x147, 0x0FA, 0x060, 0x0D9, 0x185, 0x09C, 0x1CB, 0x1DF, 0x087, 0x021, 0x0B1, 0x15A, 0x0E5, 0x040,
            0x063, 0x167, 0x04B, 0x10C, 0x0EA, 0x04E, 0x028, 0x1F4, 0x016, 0x0CA, 0x10F, 0x127, 0x04C, 0x166,
            0x0CE, 0x190, 0x1E9, 0x15B, 0x14B, 0x159, 0x11B, 0x1B9, 0x013, 0x0DE, 0x0F1, 0x0F6, 0x00A, 0x06D,
            0x140, 0x0BD, 0x226, 0x1EA, 0x088, 0x0ED, 0x16F, 0x153, 0x0A2, 0x1EF, 0x0CC, 0x020, 0x00B, 0x1DB,
            0x06E, 0x0CF, 0x090, 0x031, 0x1B5, 0x0FC, 0x080, 0x001, 0x14F, 0x01E, 0x113, 0x0A2, 0x221, 0x22A,
            0x1CA, 0x0AA, 0x110, 0x0B6, 0x0D5, 0x1D0, 0x228, 0x07C, 0x18E, 0x1B6, 0x064, 0x063, 0x05C, 0x011,
            0x1E7, 0x105, 0x1E4, 0x146, 0x12F, 0x0BC, 0x011, 0x195, 0x183, 0x1CC, 0x0FF, 0x17A, 0x114, 0x065,
            0x0F6, 0x02A, 0x0C4, 0x0DC, 0x056, 0x108, 0x009, 0x07E, 0x180, 0x07E, 0x0A5, 0x1A8, 0x09F, 0x1C7,
            0x094, 0x0BD, 0x028, 0x11E, 0x107, 0x0AB, 0x0EF, 0x05D, 0x0C8, 0x096, 0x037, 0x1BF, 0x1EE, 0x06F,
            0x201, 0x219, 0x147, 0x0FA, 0x060, 0x0D9, 0x185, 0x09C, 0x1CB, 0x1DF, 0x087, 0x021, 0x0B1, 0x15A,
            0x0E5, 0x040, 0x063, 0x167, 0x04B, 0x10C, 0x0EA, 0x04E, 0x028, 0x1F4, 0x016, 0x0CA, 0x114, 0x065,
            0x0F6, 0x02A, 0x0C4, 0x0DC, 0x056, 0x108, 0x009, 0x07E, 0x180, 0x07E, 0x0A5, 0x1A8, 0x09F, 0x1C7,
            0x094, 0x0BD, 0x028, 0x11E, 0x107, 0x0AB, 0x0EF, 0x05D, 0x0C8, 0x096, 0x037, 0x1BF, 0x1EE, 0x06F,
            0x201, 0x219, 0x147, 0x0FA, 0x060, 0x0D9, 0x185, 0x09C, 0x1CB, 0x1DF, 0x087, 0x021, 0x0B1, 0x15A,
            0x0E5, 0x040, 0x063, 0x167, 0x04B, 0x10C, 0x0EA, 0x04E, 0x028, 0x1F4, 0x016, 0x0CA, 0x002, 0x152,
            0x016, 0x23B, 0x1B2, 0x14F, 0x132, 0x17C, 0x11C, 0x00D, 0x085, 0x208, 0x229, 0x1D9, 0x158, 0x13E,
            0x135, 0x018, 0x0E2, 0x12C, 0x1D5, 0x1C5, 0x168, 0x054, 0x108, 0x17F, 0x09C, 0x1ED, 0x021, 0x127,
            0x160, 0x03A, 0x0BF, 0x0B3, 0x10B, 0x140, 0x008, 0x13A, 0x232, 0x186, 0x051, 0x061, 0x056, 0x09B,
            0x059, 0x19A, 0x0B5, 0x169, 0x066, 0x16E, 0x07C, 0x072, 0x0A4, 0x144, 0x196, 0x133, 0x0F7, 0x16B,
            0x118, 0x1E0, 0x16E, 0x17B, 0x034, 0x11B, 0x06F, 0x08F, 0x0C0, 0x0EE, 0x213, 0x03F, 0x181, 0x141,
            0x0A5, 0x09E, 0x120, 0x0F9, 0x0F8, 0x030, 0x187, 0x155, 0x050, 0x069, 0x151, 0x03E, 0x164, 0x032,
            0x0E9, 0x0D4, 0x000, 0x0AD, 0x178, 0x19E, 0x1C1, 0x21C, 0x10C, 0x21E, 0x0AB, 0x0FC, 0x026, 0x1AA,
            0x01C, 0x177, 0x058, 0x04B, 0x10D, 0x0DF, 0x081, 0x079, 0x08C, 0x1D2, 0x21B, 0x0B2, 0x049, 0x025,
            0x14D, 0x18C, 0x018, 0x19D, 0x202, 0x125, 0x073, 0x0D9, 0x191, 0x198, 0x1AB, 0x07B, 0x005, 0x1C9,
            0x114, 0x065, 0x0F6, 0x02A, 0x0C4, 0x0DC, 0x056, 0x108, 0x009, 0x07E, 0x180, 0x07E, 0x0A5, 0x1A8,
            0x09F, 0x1C7, 0x094, 0x0BD, 0x028, 0x11E, 0x107, 0x0AB, 0x0EF, 0x05D, 0x0C8, 0x096, 0x037, 0x1BF,
            0x1EE, 0x06F, 0x201, 0x219, 0x147, 0x0FA, 0x060, 0x0D9, 0x185, 0x09C, 0x1CB, 0x1DF, 0x087, 0x021,
            0x0B1, 0x15A, 0x0E5, 0x040, 0x063, 0x167, 0x04B, 0x10C, 0x0EA, 0x04E, 0x028, 0x1F4, 0x016, 0x0CA,
            0x10F, 0x127, 0x04C, 0x166, 0x0CE, 0x190, 0x1E9, 0x15B, 0x14B, 0x159, 0x11B, 0x1B9, 0x013, 0x0DE,
            0x0F1, 0x0F6,
        };
        internal static readonly byte[] KeySource = new byte[] { // byte_4C7920
            0x5A, 0x4F, 0xC6, 0xCD, 0x58, 0xD3, 0xA1, 0x3F, 0x74, 0xC5, 0xA2, 0xD8, 0x47, 0x6A, 0xEF, 0x42,
            0x4A, 0x65, 0x54, 0x75, 0xD9, 0x2E, 0xB1, 0x76, 0x48, 0x41, 0x30, 0xDF, 0xBE, 0xD9, 0x5F, 0xD9,
            0x39, 0xA8, 0xAD, 0xB3, 0xBD, 0xAC, 0xB0, 0xCB, 0xC6, 0x29, 0xB6, 0xE6, 0xD0, 0x0C, 0x67, 0xDE,
            0x1C, 0x1B, 0x72, 0xAF, 0x74, 0x24, 0x5C, 0xA9, 0xFE, 0x77, 0x9D, 0x6B, 0x6E, 0x45, 0x64, 0x93,
            0x48, 0xB0, 0x39, 0xDC, 0x4D, 0x79, 0xBF, 0xA7, 0x3B, 0xD2, 0x53, 0x2B, 0xB0, 0x44, 0x7E, 0x6D,
            0x76, 0x4E, 0xBE, 0xB3, 0x3E, 0x27, 0x3C, 0x02, 0xB8, 0xAD, 0x53, 0x04, 0x42, 0x87, 0xBE, 0x40,
            0x5D, 0x60, 0xB6, 0x6A, 0x59, 0x5D, 0xBB, 0x71, 0x30, 0x4B, 0x22, 0xDD, 0x6C, 0x37, 0x57, 0x2C,
            0x50, 0x7D, 0xBE, 0x33, 0x32, 0xE4, 0x2B, 0x56, 0xDD, 0xA9, 0x61, 0xBE, 0x2F, 0x5A, 0x3A, 0xB7,
            0x7B, 0x5C, 0x6E, 0xD8, 0x3D, 0x50, 0x8C, 0xD7, 0x68, 0x5C, 0xBB, 0xE7, 0x4C, 0xC4, 0x40, 0x2E,
            0x6C, 0x61, 0xB8, 0x67, 0xD5, 0xBC, 0x21, 0x2F, 0x32, 0x61, 0xF2, 0xFF, 0xCF, 0xBE, 0xAF, 0x74,
            0xC9, 0xCC, 0x26, 0x79, 0x0F, 0x74, 0xCA, 0x54, 0x3B, 0x13, 0x54, 0xAF, 0x90, 0x72, 0xD1, 0x6A,
            0x70, 0x59, 0xA9, 0x27, 0x24, 0x11, 0xC8, 0x1E, 0xAD, 0xC5, 0x4B, 0x41, 0xB2, 0xA4, 0xE5, 0xBD,
            0xDC, 0x92, 0xB1, 0xD5, 0x28, 0x3F, 0x7C, 0x62, 0x2A, 0x46, 0xD4, 0x28, 0xF5, 0x28, 0xB8, 0xB6,
            0xBF, 0xAE, 0xFD, 0xA9, 0xD9, 0xBC, 0xC9, 0x49, 0x2B, 0xB9, 0x31, 0x4F, 0xD4, 0xA6, 0x59, 0x5B,
            0x51, 0xCA, 0x31, 0x23, 0xB1, 0x32, 0x80, 0xEC, 0x36, 0x68, 0xB8, 0x2E, 0x45, 0x1A, 0x2D, 0x39,
            0xD1, 0x34, 0x35, 0xDA, 0xAA, 0xBE, 0x5A, 0xD3, 0x1C, 0x5A, 0xCF, 0x65, 0xBF, 0x6A, 0xCE, 0x52,
            0x77, 0xBD, 0x2C, 0xD8, 0x57, 0xB3, 0xD4, 0x61, 0x43, 0xB1, 0xD3, 0x28, 0x37, 0xDA, 0xC9, 0x3C,
            0x61, 0x7B, 0x17, 0x40, 0x32, 0x0A, 0x72, 0x4E, 0x50, 0x44, 0x16, 0x32, 0x2F, 0x32, 0x71, 0xF6,
            0xB5, 0x0F, 0x86, 0x10, 0x13, 0xCA, 0xD2, 0x36, 0x27, 0x62, 0xA5, 0x79, 0x69, 0x2D, 0x33, 0x30,
            0x84, 0x66, 0xB7, 0x26, 0xA1, 0xA1, 0xC9, 0x22, 0xB6, 0xC8, 0xA2, 0xC1, 0x6C, 0x78, 0xD8, 0x02,
            0x53, 0xD1, 0x43, 0xEE, 0xAF, 0x5C, 0x49, 0xCA, 0x13, 0x21, 0xBA, 0xA3, 0xBE, 0xA9, 0x59, 0x3A,
            0x29, 0x6B, 0xC3, 0xCC, 0xDE, 0xC6, 0x73, 0xA6, 0xD0, 0xB9, 0x2A, 0x65, 0x71, 0xB9, 0xDF, 0x39,
            0xCF, 0xF4, 0xD0, 0x47, 0x36, 0x21, 0xEB, 0xDD, 0xB4, 0x4B, 0x73, 0xBE, 0xA2, 0x6A, 0xB8, 0x46,
            0x2F, 0xDB, 0x32, 0xC0, 0x99, 0xA8, 0xD9, 0x2A, 0x71, 0x12, 0x26, 0xCE, 0xCC, 0xC0, 0xD1, 0xCD,
            0x6C, 0x27, 0xE0, 0x4E, 0x34, 0x91, 0x20, 0x6E, 0xC7, 0x66, 0x62, 0x4F, 0x2F, 0xD4, 0x26, 0x3D,
            0x84, 0x35, 0xEE, 0xD3, 0xA0, 0x49, 0xDF, 0xA8, 0xDB, 0x69, 0x0C, 0x22, 0x31, 0xD0, 0x24, 0x7F,
            0x18, 0x3F, 0x28, 0xA1, 0xCD, 0xC0, 0xA9, 0xCB, 0x01, 0x49, 0xCC, 0xCD, 0xFF, 0x34, 0xD9, 0xBD,
            0xC1, 0xE4, 0x64, 0xB8, 0xA6, 0xD7, 0x54, 0x33, 0xD0, 0xCE, 0x8B, 0x9A, 0xD9, 0xC3, 0xA1, 0x3B,
            0x40, 0x8E, 0x06, 0x61, 0x37, 0x74, 0x32, 0x83, 0x57, 0xA6, 0x20, 0x0C, 0xAF, 0x83, 0xFD, 0x23,
            0xA2, 0x44, 0x31, 0x5C, 0xB3, 0x18, 0x47, 0xDA, 0x30, 0x09, 0xE1, 0x61, 0x34, 0x75, 0x77, 0x50,
            0xC9, 0xDF, 0x5E, 0xD5, 0x68, 0xD5, 0x9A, 0xED, 0x5F, 0x29, 0x4A, 0x55, 0xC2, 0x25, 0x43, 0xB4,
            0xDE, 0xC4, 0x32, 0x2D, 0xA6, 0x63, 0x4E, 0xA7, 0x23, 0x5E, 0x3B, 0xFB, 0x75, 0xDB, 0x6D, 0x3D,
            0xD8, 0xC7, 0xB0, 0xC4, 0x61, 0x3C, 0xD6, 0x49, 0x7A, 0xA6, 0xDC, 0x6B, 0xE1, 0x29, 0x4E, 0x54,
            0x5E, 0x6E, 0x21, 0xF9, 0x21, 0x02, 0xC2, 0x2C, 0x4E, 0xB6, 0xBF, 0xCA, 0x5A, 0xD1, 0x36, 0x3D,
            0x55, 0x0A, 0xD3, 0x97, 0xD4, 0xC2, 0xD0, 0xD6, 0xDA, 0x79, 0xC8, 0x46, 0xA5, 0x4C, 0xD5, 0xB8,
            0x3B, 0x9F, 0xB4, 0x61, 0xA3, 0x46, 0xB5, 0x79, 0x58, 0x42, 0xB0, 0x40, 0x54, 0xD6, 0x33, 0x60,
            0x72, 0x7C, 0xDB, 0x4E, 0x70, 0xB3, 0xB1, 0x8C, 0x3F, 0xC0, 0xB2, 0x80, 0x59, 0x3F, 0x68, 0xBB,
            0x27, 0xE0, 0x73, 0x6A, 0xC1, 0x7D, 0xA7, 0x62, 0xCB, 0xCB, 0xB8, 0x2A, 0x4A, 0x4D, 0x57, 0xA8,
            0x3A, 0x5B, 0x62, 0xD4, 0x66, 0x64, 0x47, 0xBE, 0x37, 0x0A, 0x5F, 0x46, 0x36, 0x74, 0x2D, 0x2A,
            0xA4, 0x42, 0x9A, 0x43, 0x25, 0x4B, 0x59, 0x30, 0x57, 0x43, 0x5A, 0xDE, 0x45, 0x79, 0xBB, 0xB2,
            0x63, 0x4F, 0xDD, 0x3F, 0x51, 0xDF, 0x2B, 0x6E, 0x94, 0xDC, 0xA6, 0x5F, 0x4A, 0x6C, 0xC6, 0x61,
            0xDB, 0x4D, 0x55, 0xAD, 0x41, 0x2B, 0x2C, 0xC2, 0xB5, 0x6C, 0x33, 0x69, 0x5A, 0xB5, 0x9D, 0x44,
            0x7B, 0x3B, 0x47, 0x49, 0x77, 0x2E, 0x9C, 0x55, 0x59, 0x64, 0x21, 0x87, 0x7A, 0x75, 0xBF, 0x38,
            0x98, 0x27, 0x7E, 0xA8, 0x7D, 0x3E, 0x4C, 0xA6, 0x48, 0xD6, 0xA1, 0x32, 0x5D, 0xAD, 0x2C, 0xDB,
            0xCF, 0x48, 0x38, 0x68, 0xEE, 0x26, 0x32, 0x79, 0x4F, 0xDB, 0x98, 0x67, 0x65, 0x72, 0xBC, 0xC3,
            0x2F, 0x74, 0x33, 0x48, 0xC5, 0x48, 0x43, 0xCE, 0xD5, 0xA4, 0xBD, 0x6E, 0xB0, 0xDE, 0xF1, 0x3D,
            0xC2, 0xA1, 0xC3, 0x76, 0x6C, 0xBE, 0xCB, 0x77, 0x69, 0x0E, 0x2A, 0x49, 0xD9, 0xB5, 0x22, 0x2F,
            0x7E, 0x77, 0xC7, 0x80, 0x4D, 0x3C, 0xBC, 0x3E, 0x56, 0xC2, 0x61, 0x2B, 0x0B, 0x61, 0xBC, 0xE2,
            0xB7, 0xD0, 0xA8, 0xCD, 0xBB, 0xA3, 0xB1, 0x50, 0xB9, 0x78, 0xCE, 0xB0, 0x6C, 0xB7, 0xB1, 0x2C,
            0x22, 0xD3, 0x75, 0xD8, 0x11, 0xB3, 0x76, 0x3A, 0x64, 0x78, 0xB9, 0x67, 0x69, 0xA3, 0x47, 0x21,
            0x5D, 0x31, 0x43, 0x08, 0x7E, 0xDC, 0xDB, 0xCD, 0x7D, 0x15, 0x6D, 0x28, 0xB3, 0x1C, 0xEB, 0x4A,
            0xE9, 0xB8, 0x5A, 0x40, 0x40, 0x40, 0xC2, 0x73, 0x28, 0xB8, 0xCC, 0x66, 0xBF, 0x23, 0xDB, 0x5D,
            0x59, 0xCF, 0x2D, 0x4A, 0xB1, 0xB7, 0x7D, 0xD9, 0xDE, 0xB6, 0x74, 0x55, 0xAE, 0x65, 0xD6, 0x60,
            0xCB, 0xDA, 0x5C, 0x13, 0x37, 0xBE, 0xEA, 0xDC, 0x24, 0x60, 0x4A, 0x43, 0x6F, 0x41, 0xB5, 0xDC,
            0x3E, 0x6D, 0x59, 0x51, 0x95, 0x2F, 0x34, 0x6A, 0xAD, 0xC5, 0xAE, 0x3D, 0x26, 0x59, 0x77, 0x44,
            0xB1, 0x25, 0xDC, 0x38, 0x29, 0x22, 0x7D, 0x28, 0x68, 0xCA, 0xB2, 0x3E, 0xAA, 0x40, 0xA8, 0x7E,
            0x7A, 0xA5, 0xF2, 0xAF, 0x6D, 0xDA, 0x4A, 0x49, 0x68, 0xD3, 0x74, 0xAD, 0xD5, 0x80, 0xD2, 0x2B,
            0x3C, 0xC0, 0x30, 0xE5, 0x83, 0x3F, 0xC3, 0x57, 0x53, 0xB9, 0x76, 0x74, 0x45, 0x35, 0x67, 0xD4,
            0xBB, 0xB8, 0xA6, 0x78, 0xCF, 0xA4, 0xD9, 0xA2, 0x73, 0xB2, 0xC0, 0x53, 0x3C, 0x68, 0xE9, 0xA0,
            0x78, 0x65, 0x49, 0x25, 0x28, 0xCD, 0x5B, 0xA1, 0xC4, 0x29, 0x2D, 0xCA, 0xEC, 0x28, 0xBF, 0x29,
            0x6B, 0x4F, 0x7E, 0x67, 0xC3, 0x0F, 0xFA, 0x71, 0x41, 0xC6, 0x3E, 0x5E, 0x02, 0x57, 0xAE, 0x7E,
            0x65, 0x68, 0x3B, 0xCE, 0x5C, 0x8F, 0xD5, 0x6B, 0xCA, 0x66, 0xE4, 0x45, 0x57, 0x42, 0x72, 0x2C,
            0xB5, 0x73, 0x5B, 0x30, 0xD5, 0xE1, 0xF9, 0xC9, 0xC8, 0xBE, 0xB9, 0x46, 0xA9, 0xCF, 0xD1, 0x7E,
            0xAE, 0x2D, 0x22, 0xCA, 0x5E, 0x72, 0x3D, 0x56, 0x50, 0x60, 0xB4, 0x74, 0x5E, 0x48, 0x4E, 0xA5,
            0x36, 0xBA, 0x2A, 0xC2, 0x60, 0xEE, 0x37, 0x3C, 0x2B, 0x43, 0xB9, 0x03, 0xBF, 0x65, 0x49, 0xCB,
            0x78, 0x7B, 0x49, 0x8D, 0xD6, 0xCE, 0xAA, 0x4C, 0x4D, 0x27, 0x70, 0xA7, 0x17, 0xB1, 0xAE, 0x05,
            0x30, 0xC9, 0x6F, 0x05, 0x29, 0xC6, 0x82, 0xAA, 0x41, 0x7F, 0x2D, 0x28, 0xC0, 0x3E, 0x53, 0xEF,
            0x6A, 0x5F, 0x12, 0x42, 0xE9, 0x3F, 0x52, 0x78, 0x8B, 0x31, 0x23, 0x4F, 0xB1, 0x8A, 0x77, 0xF7,
            0x38, 0xD6, 0x90, 0xAE, 0x04, 0x9F, 0xED, 0xD6, 0x69, 0x12, 0x26, 0x7F, 0xEC, 0xAE, 0xFC, 0x45,
            0x01, 0x74, 0xD7, 0x6D, 0x9F, 0x9A, 0xA7, 0x75, 0x5A, 0x30, 0xCD, 0x90, 0xA9, 0xA5, 0x87, 0x4B,
        };
    }
}
