# mangareader-api

Python-based web scraping tool built with FastAPI that provides easy access to manga content from the [mangareader.to](https://mangareader.to) website. This API allows users to retrieve up-to-date information. Enabling developers to create their own manga-related applications and services.

**API URL**: https://mangareader-api.vercel.app/

## Setup Project

> [!IMPORTANT]
> CMake rules and Bash scripts are based on [poetry](https://python-poetry.org/)\
> So please make sure you've already installed it.

### Bash Script
```bash
bash setup.sh
```
### CMake
```bash
make install
make dev # run development server
```
### Poetry
```bash
poetry install
poetry run dev # run development server
```

> You can also create a python virtual environment and active it and install all the dependencies from `requirements.txt` file `pip install -r requirements.txt` and finally run `python3 main.py`

And server will be running on [0.0.0.0:8000](http://0.0.0.0:8000)

## Contribution

Contributions are welcome!\
If you encounter issues or want to add new features, feel free to open pull requests.\
Give a ⭐️ if you find this project interesting and useful!

## Disclaimer

This project is developed for educational purposes and convenience in accessing manga content.\
Respect the website's terms of use and consider the legality of web scraping in your jurisdiction.
