# Contributing to HackBrowserData

We appreciate your interest in contributing to the HackBrowserData! This document provides some basic guidelines for contributors.

## Getting Started

- Always base your work from the `dev` branch, which is the development branch with the latest code.
- Before creating a Pull Request (PR), make sure there is a corresponding issue for your contribution. If there isn't one already, please create one.
- Include the problem description in the issue.

## Pull Requests

When creating a PR, please follow these guidelines:

- Link your PR to the corresponding issue.
- Provide context in the PR description to help reviewers understand the changes. The more information you provide, the faster the review process will be.
- Include an example of running the tool with the changed code, if applicable. Provide 'before' and 'after' examples if possible.
- Include steps for functional testing or replication.
- If you're adding a new feature, make sure to include unit tests.

## Code Style

Please adhere to the existing coding style for consistency.

## Questions

If you have any questions or need further guidance, please feel free to ask in the issue or PR, or [reach out to the maintainers](mailto:i@moond4rk.com). We will reply to you as soon as possible.

Thank you for your contribution!

