/*
 * Mono Embeddinator-4000 Java support code.
 *
 * Author:
 *   Joao Matos (joao.matos@xamarin.com)
 *
 * (C) 2017 Microsoft, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package mono.embeddinator;

import com.sun.jna.*;
import com.sun.jna.ptr.*;

public class Decimal extends Runtime.RuntimeLibrary.MonoDecimal {
	public static class ByValue extends Decimal implements Structure.ByValue { }
	public static class ByReference  extends Decimal implements Structure.ByReference { }

	public Decimal () {
	}

	public Decimal (java.math.BigDecimal decimal) {
	}

	/**
	* Gets the native decimal as a Java BigDecimal.
	* This is named getValue() for uniformity with com.sun.jna.ptr.*ByReference set of types.
	*/
	public java.math.BigDecimal getValue() {
		return new java.math.BigDecimal((long) 0);
	}
}
