# Contributing

There are many ways to contribute to Embeddinator-4000: logging bugs, submitting pull requests, reporting issues, and creating suggestions.

## Work Branches

Even if you have push rights on the mono/Embeddinator-4000 repository, you should create a personal fork and create feature branches there when you need them. This keeps the main repository clean and your personal workflow cruft out of sight.

## Pull Requests

To enable us to quickly review and accept your pull requests, always create one pull request per issue and link the issue in the pull request. Never merge multiple requests in one unless they have the same root cause. Be sure to follow our [Coding Guidelines](http://www.mono-project.com/community/contributing/coding-guidelines/) and keep code changes as small as possible. Avoid pure formatting changes to code that has not been modified otherwise. Pull requests should contain tests whenever possible.

**Where to Contribute**
Check out the [full issues list](https://github.com/mono/Embeddinator-4000/issues) for a list of all potential areas for contributions. Note that just because an issue exists in the repository does not mean we will accept a contribution to it. There are several reasons we may not accept a pull request like:

- Some `enhancement` describe a real issue but the proposed way to solve it might not be the best one. Discussions on how to best solve the root issue should happen on the GitHub issue (and before a pull-request);
- Negative impact on build time or build size. E.g. ideally the cost of fixing something should not have a huge impact on people that do not require that feature;
- Incomplete support of all platforms. If a feature **can** exists across all platforms then it should be implemented for all of them. This helps to create cross-platform applications;

To improve the chances to get a pull request merged you should select an issue that is labeled with the <a href="https://github.com/mono/Embeddinator-4000/labels/help%20wanted"><code>help wanted</code><a> or <a href="https://github.com/mono/Embeddinator-4000/labels/bug"><code>bug</code></a> labels. If the issue you want to work on is not labeled with `help-wanted` or `bug`, you can start a conversation with the issue owner asking whether an external contribution will be considered. 

To discuss this project, and participate in the design or development, we use [Gitter](https://gitter.im/managed-interop).

[![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/managed-interop?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

## Suggestions

We're also interested in your feedback for the future of Embeddinator-4000. You can submit a suggestion or feature request through the issue tracker. To make this process more effective, we may ask that these include more information to help define them more clearly.

## Coding Guidelines

We use [Mono's Coding Guidelines](http://www.mono-project.com/community/contributing/coding-guidelines/).

## Discussion Etiquette

In order to keep the conversation clear and transparent, please limit the discussion to English and keep things on topic with the issue. Be considerate of others and try to be courteous and professional at all times.
