/*
 Navicat Premium Data Transfer

 Source Server         : 51wangshi.com
 Source Server Type    : MySQL
 Source Server Version : 50719
 Source Host           : 51wangshi.com:3306
 Source Schema         : mojin

 Target Server Type    : MySQL
 Target Server Version : 50719
 File Encoding         : 65001

 Date: 18/11/2020 13:52:25
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for cms_article
-- ----------------------------
DROP TABLE IF EXISTS `cms_article`;
CREATE TABLE `cms_article`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `title` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '文章标题',
  `author` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '作者',
  `column_id` bigint(20) DEFAULT NULL COMMENT '文章所属栏目id',
  `sort` int(11) DEFAULT NULL COMMENT '排序 数值越小 排序越前',
  `is_release` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否发布 0 发布 1 不发布  默认0 ',
  `seo_keywords` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'seo关键字',
  `seo_desc` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'see描述',
  `desc` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '文章描述',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除标记 0 未删除 1 删除',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '生成时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '文章信息' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cms_article_column
-- ----------------------------
DROP TABLE IF EXISTS `cms_article_column`;
CREATE TABLE `cms_article_column`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '栏目名称',
  `parentId` bigint(20) NOT NULL COMMENT '上级分类id   0 表示无上级 ',
  `sort` int(11) NOT NULL COMMENT '排序 数值越小排序越前',
  `is_show` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '前端是否显示  0 显示 1 不显示 默认0 ',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记  0 未删除 1 删除  默认0 ',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '文章栏目表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cms_help
-- ----------------------------
DROP TABLE IF EXISTS `cms_help`;
CREATE TABLE `cms_help`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '帮助名称',
  `sort` int(11) DEFAULT NULL COMMENT '排序 数组',
  `help_cate_id` bigint(20) DEFAULT NULL COMMENT '帮助分类id',
  `is_show` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否显示 0 显示 1 不显示 默认0 ',
  `desc` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '帮助内容',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记 0 未删除 1 删除 默认0 ',
  `crete_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '帮助表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for cms_help_cate
-- ----------------------------
DROP TABLE IF EXISTS `cms_help_cate`;
CREATE TABLE `cms_help_cate`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '帮助分类名称',
  `sort` int(11) NOT NULL COMMENT '排序 数值越小 排序越前',
  `is_show` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '是否显示  0 显示 1 不显示 默认0 ',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记 0未删除 1 删除  默认0 ',
  `crete_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '帮助分类' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table`  (
  `table_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '表描述',
  `class_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '生成功能作者',
  `options` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 99 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '代码生成业务表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table
-- ----------------------------
INSERT INTO `gen_table` VALUES (57, 't_store_billing_records', '门店账单收入支出表', 'TStoreBillingRecords', 'crud', 'com.ruoyi.store', 'store', 'TStoreBillingRecords', '门店账单收入支出', 'test', '{}', 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38', 'test-测试用例');
INSERT INTO `gen_table` VALUES (58, 't_store_category', '店铺分类', 'TStoreCategory', 'crud', 'com.ruoyi.store', 'store', 'TStoreCategory', '店铺分类', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05', NULL);
INSERT INTO `gen_table` VALUES (59, 't_store_comment', '店铺评论表', 'TStoreComment', 'crud', 'com.ruoyi.store', 'store', 'TStoreComment', '店铺评论', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:30:59', NULL);
INSERT INTO `gen_table` VALUES (60, 't_store_customize_brand', '店铺自定义品牌列表', 'TStoreCustomizeBrand', 'crud', 'com.ruoyi.store', 'store', 'TStoreCustomizeBrand', '店铺自定义品牌列', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:25', '', '2020-07-27 19:57:47', NULL);
INSERT INTO `gen_table` VALUES (61, 't_store_evaluation', '门店评价表', 'TStoreEvaluation', 'crud', 'com.ruoyi.store', 'store', 'TStoreEvaluation', '门店评价', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:25', NULL);
INSERT INTO `gen_table` VALUES (62, 't_store_info', '店铺信息表', 'TStoreInfo', 'crud', 'com.ruoyi.store', 'store', 'TStoreInfo', '店铺信息', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00', NULL);
INSERT INTO `gen_table` VALUES (63, 't_store_order', '门店订单', 'TStoreOrder', 'crud', 'com.ruoyi.store', 'store', 'TStoreOrder', '门店订单', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45', NULL);
INSERT INTO `gen_table` VALUES (64, 't_store_order_attr', '门店订单附属信息表', 'TStoreOrderAttr', 'crud', 'com.ruoyi.store', 'store', 'TStoreOrderAttr', '门店订单附属信息', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00', NULL);
INSERT INTO `gen_table` VALUES (65, 't_store_order_operation_log', '门店订单操作日志', 'TStoreOrderOperationLog', 'crud', 'com.ruoyi.store', 'store', 'TStoreOrderOperationLog', '门店订单操作日志', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:21', NULL);
INSERT INTO `gen_table` VALUES (66, 't_store_order_sku', '门店订单单品信息表', 'TStoreOrderSku', 'crud', 'com.ruoyi.store', 'store', 'TStoreOrderSku', '门店订单单品信息', 'é­éåå', NULL, 'admin', '2020-07-27 19:42:26', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (67, 't_store_paytype', '门店支付类型', 'TStorePaytype', 'crud', 'com.ruoyi.store', 'store', 'TStorePaytype', '门店支付类型', 'é­éåå', NULL, 'admin', '2020-07-27 19:42:27', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (68, 't_store_red_envelope', '门店红包', 'TStoreRedEnvelope', 'crud', 'com.ruoyi.store', 'store', 'TStoreRedEnvelope', '门店红包', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18', NULL);
INSERT INTO `gen_table` VALUES (69, 't_store_red_envelope_code', '门店红包卷吗表', 'TStoreRedEnvelopeCode', 'crud', 'com.ruoyi.store', 'store', 'TStoreRedEnvelopeCode', '门店红包卷吗', 'é­éåå', '{}', 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:26:40', NULL);
INSERT INTO `gen_table` VALUES (70, 't_store_reservation', '门店预约表', 'TStoreReservation', 'crud', 'com.ruoyi.store', 'store', 'TStoreReservation', '门店预约', 'é­éåå', NULL, 'admin', '2020-07-27 19:42:27', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (73, 't_store_shopping_cart', '门店购物车', 'TStoreShoppingCart', 'crud', 'com.ruoyi.store', 'store', 'TStoreShoppingCart', '门店购物车', 'é­éåå', NULL, 'admin', '2020-07-27 19:42:27', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (74, 't_store_signed_category', '店铺的签约分类', 'TStoreSignedCategory', 'crud', 'com.ruoyi.store', 'store', 'TStoreSignedCategory', '店铺的签约分类', 'é­éåå', NULL, 'admin', '2020-07-27 19:42:27', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (75, 't_store_sku', '门店单品表', 'TStoreSku', 'crud', 'com.ruoyi.store', 'store', 'TStoreSku', '门店单品', 'é­éåå', NULL, 'admin', '2020-07-27 19:42:27', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (77, 'ls_email_setting', '邮箱设置表', 'LsEmailSetting', 'crud', 'com.ruoyi.setting', 'setting', 'LsEmailSetting', '邮箱设置', 'é­éåå', NULL, 'admin', '2020-07-28 14:41:53', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (78, 'ls_pay_setting', '支付设置', 'LsPaySetting', 'crud', 'com.ruoyi.setting', 'setting', 'LsPaySetting', '支付设置', 'é­éåå', NULL, 'admin', '2020-07-28 14:41:53', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (79, 'ls_sms_setting', '短信接口设置', 'LsSmsSetting', 'crud', 'com.ruoyi.setting', 'setting', 'LsSmsSetting', '短信接口设置', 'é­éåå', NULL, 'admin', '2020-07-28 14:41:53', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (80, 'oms_order_setting', '订单设置', 'OmsOrderSetting', 'crud', 'com.ruoyi.setting', 'setting', 'OmsOrderSetting', '订单设置', 'é­éåå', NULL, 'admin', '2020-07-28 14:41:53', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (81, 's_community_buy_setting', '社区团购设置', 'SCommunityBuySetting', 'crud', 'com.ruoyi.setting', 'setting', 'SCommunityBuySetting', '社区团购设置', 'é­éåå', NULL, 'admin', '2020-07-28 14:41:54', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (82, 'ls_city', '区域市表', 'LsCity', 'crud', 'com.ruoyi.setting', 'setting', 'LsCity', '区域市', 'é­éåå', NULL, 'admin', '2020-07-29 10:35:11', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (83, 'ls_district', '区域区表', 'LsDistrict', 'crud', 'com.ruoyi.setting', 'setting', 'LsDistrict', '区域区', 'é­éåå', NULL, 'admin', '2020-07-29 10:35:11', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (84, 'ls_province', '区域省表', 'LsProvince', 'crud', 'com.ruoyi.setting', 'setting', 'LsProvince', '区域省', 'é­éåå', NULL, 'admin', '2020-07-29 10:35:11', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (85, 'ls_station_letter', '站内信', 'LsStationLetter', 'crud', 'com.ruoyi.setting', 'setting', 'LsStationLetter', '站内信', 'é­éåå', NULL, 'admin', '2020-07-29 10:35:11', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (86, 'ls_system_seo', '系统seo设置', 'LsSystemSeo', 'crud', 'com.ruoyi.setting', 'setting', 'LsSystemSeo', '系统seo设置', 'é­éåå', NULL, 'admin', '2020-07-29 10:35:11', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (87, 'ls_wx_customer_link', '微信登录和商城用户的关联表', 'LsWxCustomerLink', 'crud', 'com.ruoyi.setting', 'setting', 'LsWxCustomerLink', '微信登录和商城用户的关联', 'é­éåå', NULL, 'admin', '2020-07-29 10:35:11', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (88, 'sms_home_advertise', '首页轮播广告表', 'SmsHomeAdvertise', 'crud', 'com.ruoyi.sms', 'sms', 'SmsHomeAdvertise', '首页轮播广告', 'é­éåå', '{}', 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09', NULL);
INSERT INTO `gen_table` VALUES (89, 'sms_home_brand', '首页推荐品牌表', 'SmsHomeBrand', 'crud', 'com.ruoyi.sms', 'sms', 'SmsHomeBrand', '首页推荐品牌', 'é­éåå', '{}', 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:52', NULL);
INSERT INTO `gen_table` VALUES (90, 'sms_home_new_product', '新鲜好物表', 'SmsHomeNewProduct', 'crud', 'com.ruoyi.sms', 'sms', 'SmsHomeNewProduct', '新鲜好物', 'é­éåå', '{}', 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:07', NULL);
INSERT INTO `gen_table` VALUES (91, 'sms_home_recommend_product', '人气推荐商品表', 'SmsHomeRecommendProduct', 'crud', 'com.ruoyi.sms', 'sms', 'SmsHomeRecommendProduct', '人气推荐商品', 'é­éåå', '{}', 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:07:11', NULL);
INSERT INTO `gen_table` VALUES (92, 'sms_home_recommend_subject', '首页推荐专题表', 'SmsHomeRecommendSubject', 'crud', 'com.ruoyi.sms', 'sms', 'SmsHomeRecommendSubject', '首页推荐专题', 'é­éåå', '{}', 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:12', NULL);
INSERT INTO `gen_table` VALUES (93, 'cms_article', '文章信息', 'CmsArticle', 'crud', 'com.ruoyi.sms', 'sms', 'CmsArticle', '文章信息', 'é­éåå', NULL, 'admin', '2020-08-21 15:50:48', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (94, 'cms_article_column', '文章栏目表', 'CmsArticleColumn', 'crud', 'com.ruoyi.sms', 'sms', 'CmsArticleColumn', '文章栏目', 'é­éåå', NULL, 'admin', '2020-08-21 15:50:48', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (95, 'cms_help', '帮助表', 'CmsHelp', 'crud', 'com.ruoyi.sms', 'sms', 'CmsHelp', '帮助', 'é­éåå', NULL, 'admin', '2020-08-21 15:50:48', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (96, 'cms_help_cate', '帮助分类', 'CmsHelpCate', 'crud', 'com.ruoyi.sms', 'sms', 'CmsHelpCate', '帮助分类', 'é­éåå', NULL, 'admin', '2020-08-21 15:50:48', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (97, 't_step_data', '', 'TStepData', 'crud', 'com.ruoyi.sms', 'sms', 'TStepData', NULL, 'é­éåå', NULL, 'admin', '2020-10-19 14:16:23', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (98, 't_live_info', '直播数据', 'TLiveInfo', 'crud', 'com.ruoyi.sms', 'sms', 'TLiveInfo', '直播数据', '魔金', '{}', 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45', NULL);

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column`  (
  `column_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '字典类型',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`column_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 961 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '代码生成业务表字段' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------
INSERT INTO `gen_table_column` VALUES (16, '2', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (17, '2', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (18, '2', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (19, '2', 'sku_id', '单品id', 'varchar(20)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (20, '2', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (21, '2', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (22, '2', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (23, '3', 'id', '主键id', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (24, '3', 'type_id', '商品属性关联的类型id 对应ls_type表中的id', 'bigint(20)', 'Long', 'typeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (25, '3', 'name', '属性名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (26, '3', 'sort', '排序 数值越小 排序越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (27, '3', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (28, '4', 'id', '主键id', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (29, '4', 'attribute_id', '属性id', 'varchar(64)', 'String', 'attributeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (30, '4', 'type_id', '类型id', 'varchar(45)', 'String', 'typeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (31, '4', 'value', '属性值', 'varchar(45)', 'String', 'value', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (32, '4', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'bigint(20)', 'Long', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (33, '5', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (34, '5', 'name', '品牌名称', 'varchar(128)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (35, '5', 'nick_name', '品牌别名', 'varchar(128)', 'String', 'nickName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (36, '5', 'url', '品牌的图片地址', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (37, '5', 'certificat_url', '证书图片', 'varchar(128)', 'String', 'certificatUrl', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (38, '5', 'store_id', '店铺id 平台的为0 ', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (39, '5', 'status', '状态  0 申请中  1通过 2 拒绝', 'varchar(45)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'audit_thress', 7, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (40, '5', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (41, '5', 'reason', '拒绝原因', 'varchar(45)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (42, '5', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 10, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (43, '5', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 11, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (44, '5', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 12, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (45, '5', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'datetime', '', 13, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (46, '5', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 14, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (47, '5', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 15, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (48, '6', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (49, '6', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (50, '6', 'brand_id', '申请的品牌id', 'bigint(20)', 'Long', 'brandId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (51, '6', 'status', '申请状态 ', 'char(1)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'audit_thress', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (52, '6', 'reason', '拒绝原因', 'varchar(1024)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (53, '6', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (54, '7', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (55, '7', 'name', '分类名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (56, '7', 'parent_id', '父级分类id   没有父级 则为0', 'bigint(20)', 'Long', 'parentId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (57, '7', 'type_id', '类型id，只有分类是三级分类的时候才有 一级和二级分类没有', 'bigint(20)', 'Long', 'typeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (58, '7', 'grade', '分类的层级 1 一级 2 二级 3 三级', 'char(1)', 'String', 'grade', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (59, '7', 'rate', '分类扣率 三级分类的时候才有，主要是和店铺对账使用', 'decimal(3,2)', 'BigDecimal', 'rate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (60, '7', 'sort', '排序  数值越低  排序越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (61, '7', 'del_flag', '删除标记  0未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (62, '7', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 9, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (63, '7', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 10, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (64, '7', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 11, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (65, '7', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 12, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (66, '7', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 13, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (67, '7', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 14, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (68, '8', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (69, '8', 'cate_id', '分类id  对应pms_category表中的id', 'bigint(20)', 'Long', 'cateId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (70, '8', 'spec_id', '规格id 对应pms_goods_spec 表中的id', 'bigint(20)', 'Long', 'specId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (71, '8', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (72, '9', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (73, '9', 'name', '商品组合名称', 'varchar(128)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (74, '9', 'store_id', '店铺id 平台的为0', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (75, '9', 'del_flag', '删除标记 0 未删除 1 已删除', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (76, '9', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (77, '9', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (78, '9', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (79, '10', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (80, '10', 'combination_id', '商品组合id', 'bigint(20)', 'Long', 'combinationId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (81, '10', 'sku_id', '单品id', 'varchar(20)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (82, '11', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (83, '11', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (84, '11', 'sku_id', '单品id', 'varchar(128)', 'String', 'skuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (85, '11', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (86, '11', 'order_id', '订单号', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (87, '11', 'is_anonymous', '是否匿名  0 否 1是  默认0 ', 'char(1)', 'String', 'isAnonymous', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', 'ye_no01', 6, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (88, '11', 'comment', '评论', 'varchar(2048)', 'String', 'comment', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 7, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (89, '11', 'score', '商品满意度评分1到5分', 'int(11)', 'Long', 'score', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (90, '11', 'has_pic', '是否有图片  0 没有 1 有 默认0 ', 'char(1)', 'String', 'hasPic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (91, '11', 'create_time', '评论创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (92, '11', 'is_show', '是否可见 0 可见 1 不可见 默认0 ', 'char(1)', 'String', 'isShow', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (93, '11', 'del_flag', '是否删除 0 未删除1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (94, '12', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:34', '', NULL);
INSERT INTO `gen_table_column` VALUES (95, '12', 'comment_id', '评论id', 'bigint(20)', 'Long', 'commentId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:34', '', NULL);
INSERT INTO `gen_table_column` VALUES (96, '12', 'url', '图片地址', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:34', '', NULL);
INSERT INTO `gen_table_column` VALUES (97, '13', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (98, '13', 'comment_id', '评论id  对应ls_comment 表中的id', 'bigint(20)', 'Long', 'commentId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (99, '13', 'reply', '回复内容', 'varchar(2048)', 'String', 'reply', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 3, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (100, '13', 'is_show', '是否显示 0 显示 1 不显示 默认0 ', 'char(1)', 'String', 'isShow', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (101, '13', 'store_id', '店铺id 平台为0', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (102, '13', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (103, '14', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (104, '14', 'name', '商品名称', 'varchar(256)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (105, '14', 'subtitle', '商品副标题', 'varchar(256)', 'String', 'subtitle', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (106, '14', 'price', '销售价', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (107, '14', 'pc_desc', 'PC版详情', 'text', 'String', 'pcDesc', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (108, '14', 'mobile_desc', '手机版详情', 'text', 'String', 'mobileDesc', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (109, '14', 'seo_title', 'seo标题', 'varchar(1024)', 'String', 'seoTitle', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 7, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (110, '14', 'seo_keywords', 'seo关键字', 'varchar(128)', 'String', 'seoKeywords', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (111, '14', 'seo_desc', 'see描述', 'varchar(1024)', 'String', 'seoDesc', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 9, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (112, '14', 'store_id', '商品的店铺id 如果是平台的则为0 ', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (113, '14', 'first_cate_id', '一级分类id', 'bigint(20)', 'Long', 'firstCateId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (114, '14', 'second_cate_id', '二级分类id', 'bigint(20)', 'Long', 'secondCateId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (115, '14', 'third_cate_id', '三级分类id', 'bigint(20)', 'Long', 'thirdCateId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 13, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (116, '14', 'type_id', '类型id', 'bigint(20)', 'Long', 'typeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (117, '14', 'brand_id', '品牌id', 'bigint(20)', 'Long', 'brandId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 15, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (118, '14', 'store_fcate_id', '店铺一级分类', 'bigint(20)', 'Long', 'storeFcateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (119, '14', 'store_scate_id', '店铺二级分类', 'bigint(20)', 'Long', 'storeScateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (120, '14', 'store_tcate_id', '店铺三级分类', 'bigint(20)', 'Long', 'storeTcateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (121, '14', 'url', '商品图片', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 19, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (122, '14', 'del_flag', '删除标记   0未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 20, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (123, '14', 'create_name', '创建人的名称', 'varchar(64)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 21, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (124, '14', 'modify_name', '修改人的名称', 'varchar(64)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 22, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (125, '14', 'del_name', '删除人的名字', 'varchar(64)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 23, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (126, '14', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 24, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (127, '14', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 25, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (128, '14', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 26, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (129, '14', 'commission_rate', '佣金比例', 'decimal(3,2)', 'BigDecimal', 'commissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 27, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (130, '14', 's_commission_rate', '二级佣金比例', 'decimal(3,2)', 'BigDecimal', 'sCommissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 28, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (131, '14', 'status', '审核状态  0 审核通过 1 审核未通过 2 审核中', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'audit_thress', 29, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (132, '14', 'shelves_status', '商品上架状态 0 下架  1上架 2违规下架 默认0', 'char(1)', 'String', 'shelvesStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', 'goods_publish', 30, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (133, '14', 'is_virtual', '是否是虚拟商品 0 否 1 是默认0', 'char(1)', 'String', 'isVirtual', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'ye_no01', 31, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (134, '14', 'video', '商品视频地址', 'varchar(256)', 'String', 'video', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 32, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (135, '14', 'video_pic', '商品视频封面地址', 'varchar(256)', 'String', 'videoPic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 33, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (136, '14', 'logistics_template_id', '物流模版id 对应oms_logistics_template表的id', 'bigint(20)', 'Long', 'logisticsTemplateId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 34, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (137, '15', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (138, '15', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (139, '15', 'attribute_id', '属性id', 'varchar(126)', 'String', 'attributeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (140, '15', 'attribute_name', '属性名称', 'varchar(126)', 'String', 'attributeName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (141, '15', 'attribute_value_id', '属性值id', 'varchar(126)', 'String', 'attributeValueId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (142, '15', 'attribute_value', '属性值', 'varchar(126)', 'String', 'attributeValue', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (143, '15', 'del_flag', '删除标记 0 未删除 1删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (144, '16', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (145, '16', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (146, '16', 'url', '图片地址', 'varchar(256)', 'String', 'url', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (147, '16', 'del_flag', '删除标记  0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (148, '17', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (149, '17', 'name', '商品名称', 'varchar(128)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (150, '17', 'sub_title', '商品副标题', 'varchar(128)', 'String', 'subTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (151, '17', 'price', '商品价格', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (152, '17', 'seo_title', 'see标题', 'varchar(1024)', 'String', 'seoTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 5, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (153, '17', 'seo_keywords', 'seo关键字', 'varchar(512)', 'String', 'seoKeywords', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 6, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (154, '17', 'seo_desc', 'see描述', 'varchar(1024)', 'String', 'seoDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 7, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (155, '17', 'is_release', '是否发布 0 未发布 1 发布 默认0 ', 'char(1)', 'String', 'isRelease', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (156, '17', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (157, '18', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:45:19');
INSERT INTO `gen_table_column` VALUES (158, '18', 'spu_id', '商品id 对应pms_goods表中的id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:45:19');
INSERT INTO `gen_table_column` VALUES (159, '18', 'service_support_id', '服务支持id  对应ls_service_support中的id', 'bigint(20)', 'Long', 'serviceSupportId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:45:19');
INSERT INTO `gen_table_column` VALUES (160, '18', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:45:19');
INSERT INTO `gen_table_column` VALUES (161, '19', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (162, '19', 'spu_id', '商品id 对应pms_goods表中的id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (163, '19', 'spec_id', '规格id  对应pms_spec表中的id', 'bigint(20)', 'Long', 'specId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (164, '19', 'spec_value_id', '规格值id  对应pms_spec_value表中的id', 'varchar(64)', 'String', 'specValueId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (165, '19', 'url', '规格值的图片地址', 'varchar(256)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (166, '19', 'value_remark', '规格值', 'varchar(128)', 'String', 'valueRemark', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (167, '19', 'del_flag', '删除标记  0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (168, '20', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (169, '20', 'name', '服务支持的名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (170, '20', 'url', '服务支持的图片地址', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (171, '20', 'del_flag', '删除标记  0 未删除 1删除  默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (172, '20', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 5, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (173, '20', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 6, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (174, '20', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 7, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (175, '20', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (176, '20', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (177, '20', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (178, '21', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (179, '21', 'template_id', '运费模版id', 'bigint(20)', 'Long', 'templateId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (180, '21', 'first', '首件 或者 首重', 'int(11)', 'Long', 'first', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (181, '21', 'money', '首件或者首重的价格', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (182, '21', 'first_plu', '增加几件或者几克', 'int(11)', 'Long', 'firstPlu', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (183, '21', 'moeny_plu', '增加的钱', 'decimal(20,2)', 'BigDecimal', 'moenyPlu', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (184, '21', 'is_default', '是否默认  0 否 1 是 默认 0 ', 'char(1)', 'String', 'isDefault', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (185, '22', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (186, '22', 'shipping_method_id', '运费方式id', 'bigint(20)', 'Long', 'shippingMethodId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (187, '22', 'template_id', '模版id', 'bigint(20)', 'Long', 'templateId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (188, '22', 'city_id', '市id', 'bigint(20)', 'Long', 'cityId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (189, '23', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (190, '23', 'template_id', '运费模版id', 'bigint(20)', 'Long', 'templateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (191, '23', 'type', '包邮类型 0 件数  1 金额', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (192, '23', 'num', '包邮件数', 'int(11)', 'Long', 'num', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (193, '23', 'money', '包邮的金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (194, '24', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (195, '24', 'shipping_method_freeship_id', '运费模版包邮id', 'bigint(20)', 'Long', 'shippingMethodFreeshipId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (196, '24', 'template_id', '运费模版id', 'bigint(20)', 'Long', 'templateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (197, '24', 'city_id', '市id', 'bigint(20)', 'Long', 'cityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (198, '25', 'id', '主键id', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (199, '25', 'spu_id', '商品id ，对应pms_goods中的id', 'bigint(20)', 'Long', 'spuId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (200, '25', 'sku_no', '单品的编号', 'varchar(45)', 'String', 'skuNo', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (201, '25', 'name', '单品的名称', 'varchar(256)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (202, '25', 'subtitle', '单品的副标题', 'varchar(256)', 'String', 'subtitle', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (203, '25', 'stock', '单品库存', 'int(11)', 'Long', 'stock', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (204, '25', 'warning_stock', '预警库存', 'int(11)', 'Long', 'warningStock', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (205, '25', 'price', '单品价格', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (206, '25', 'weight', '单品的重量', 'decimal(20,2)', 'BigDecimal', 'weight', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (207, '25', 'store_id', '店铺id  如果是平台  则是0', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (208, '25', 'shelves_status', '单品上架状态 0 下架  1上架 2 违规下架 默认0', 'char(1)', 'String', 'shelvesStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', 'goods_publish', 11, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (209, '25', 'url', '默认图片的url', 'varchar(124)', 'String', 'url', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (210, '25', 'status', '审核状态  0 审核通过 1 审核未通过 2 审核中', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'audit_thress', 13, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (211, '25', 'reason', '拒绝原因', 'varchar(1024)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 14, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (212, '25', 'del_flag', '删除标记  0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'select', '', 15, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (213, '25', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 16, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (214, '25', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 17, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (215, '25', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 18, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (216, '25', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 19, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (217, '25', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 20, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (218, '25', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 21, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (219, '25', 'up_time', '单品上架时间', 'timestamp', 'Date', 'upTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 22, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (220, '25', 'commission_rate', '佣金比例  该字段是冗余字段，和商品表中的佣金比例是一个字断', 'decimal(3,2)', 'BigDecimal', 'commissionRate', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 23, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (221, '25', 's_commission_rate', '二级佣金比例  该字段是冗余字段，和商品表中的佣金比例是一个字断', 'decimal(3,2)', 'BigDecimal', 'sCommissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 24, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (222, '25', 'is_virtual', '是否是虚拟商品 0 否 1 是  默认0  该字段是商品冗余字段 和商品表保持一致', 'char(1)', 'String', 'isVirtual', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (223, '25', 'is_batch_sku', '是否批发商品 0否 1是 默认0', 'char(1)', 'String', 'isBatchSku', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 26, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (224, '25', 'logistics_template_id', '物流模版id  该字段是冗余字段和pms_goods表中的保持一致', 'bigint(20)', 'Long', 'logisticsTemplateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 27, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (225, '26', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (226, '26', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (227, '26', 'sku_id', '单品id', 'bigint(20)', 'Long', 'skuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (228, '26', 'batch_num', '起批量（前闭后开）', 'int(11)', 'Long', 'batchNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (229, '26', 'batch_price', '起批价格', 'decimal(20,2)', 'BigDecimal', 'batchPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (230, '26', 'del_flag', '删除标记 0未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (231, '27', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (232, '27', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (233, '27', 'sku_id', '单品id  对应pms_sku表中的id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (234, '27', 'url', '图片地址', 'varchar(256)', 'String', 'url', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (235, '27', 'default_flag', '默认图片标记  0 不是默认 1默认    默认为0', 'char(1)', 'String', 'defaultFlag', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (236, '27', 'del_flag', '删除标记  0未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (237, '28', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (238, '28', 'skuid', '单品id', 'varchar(64)', 'String', 'skuid', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (239, '28', 'marketing_id', '营销id', 'bigint(20)', 'Long', 'marketingId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (240, '28', 'price', '促销价格 （在众筹的时候使用，众筹价格）', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (241, '29', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (242, '29', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (243, '29', 'sku_id', '单品id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (244, '29', 'member_level_id', '会员等级id', 'bigint(20)', 'Long', 'memberLevelId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (245, '29', 'price', '会员价格', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (246, '29', 'del_flag', '删除标记 0未删除1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (247, '30', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (248, '30', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (249, '30', 'sku_id', '单品id   对应pms_sku表中的id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (250, '30', 'spec_id', '规格id 对应pms_spec表中的id', 'bigint(20)', 'Long', 'specId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (251, '30', 'spec_value_id', '规格值id  对应pms_spec_value 表中的id', 'varchar(64)', 'String', 'specValueId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (252, '30', 'value_remark', '规格值', 'varchar(45)', 'String', 'valueRemark', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (253, '30', 'del_flag', '删除标记 0 未删除 1 删除  默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (254, '31', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (255, '31', 'name', '规格名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (256, '31', 'nick_name', '规格别名', 'varchar(45)', 'String', 'nickName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (257, '31', 'del_flag', '删除标记 0 未删除  1 删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (258, '31', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (259, '31', 'modify_name', '修改人', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (260, '31', 'del_name', '删除人名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (261, '31', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (262, '31', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (263, '31', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (264, '32', 'id', '主键id', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:08');
INSERT INTO `gen_table_column` VALUES (265, '32', 'spec_id', '规格id 对应pms_goods_spec表中的id', 'bigint(20)', 'Long', 'specId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (266, '32', 'name', '规格值的名称', 'varchar(128)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (267, '32', 'sort', '排序  数值越小排序越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (268, '32', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (269, '32', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (270, '32', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 7, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (271, '32', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 8, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (272, '32', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (273, '32', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (274, '32', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 11, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (275, '33', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (276, '33', 'name', '类型名称', 'varchar(128)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (277, '33', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (278, '33', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (279, '33', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (280, '33', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (281, '33', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (282, '33', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (283, '33', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (284, '34', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (285, '34', 'back_code', '退单号', 'varchar(128)', 'String', 'backCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (286, '34', 'order_id', '订单id 对应订单表 oms_order中的id', 'bigint(20)', 'Long', 'orderId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (287, '34', 'order_code', '订单号 对应oms_order 表中的order_code\n', 'varchar(128)', 'String', 'orderCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (288, '34', 'store_id', '店铺id 平台的为0 ', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (289, '34', 'customer_id', '用户id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (290, '34', 'skuId_nums', '退货的单品ID多个用,分开  退款的时候不需要，因为退款只能整单退\n1001-1,1002-3 表示单品id为1001 的单品退货1件 单品id为1002的单品退货3件 ', 'varchar(512)', 'String', 'skuidNums', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 7, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (291, '34', 'type', '1 退款 2 退货', 'char(1)', 'String', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'after_type', 8, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (292, '34', 'reason', '退款／退货原因\n1:不想买了\n2:收货人信息有误\n3:未按指定时间发货\n4:其他\n5:不想买了\n6:商品质量问题\n7:收到商品与描述不符\n8:其他\n9:系统自动申请\n', 'char(1)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (293, '34', 'desc', '问题说明', 'varchar(2048)', 'String', 'desc', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 10, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (294, '34', 'credential', '申请凭据 0 没有任何凭据 1 有发票 2有质检报告', 'char(1)', 'String', 'credential', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (295, '34', 'back_type', '返回方式 1 快递返回 目前只有快递返回 （退货的时候用户给商城寄送商品）', 'char(1)', 'String', 'backType', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 12, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (296, '34', 'back_price', '退款／退货金额', 'decimal(20,2)', 'BigDecimal', 'backPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 13, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (297, '34', 'real_back_price', '退货时候实际退款金额', 'decimal(20,2)', 'BigDecimal', 'realBackPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (298, '34', 'pics', '上传的退款凭证或者质检发票 多个图片 用, 隔开', 'varchar(2048)', 'String', 'pics', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 15, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (299, '34', 'status', '退款／退货状态  \n1:退款申请 （用户发送退款请求）\n2:退款成功（商家同意退款）\n3:退款拒绝 （商家拒绝退款）\n4:退货申请 （用户发起退货请求）\n5:退货拒绝   （商家拒绝退货）\n6:退货审核通过等待用户填写物流（商家审核通过，等待用户寄回商品）\n7: 待收货  （用户已经寄回商品，等待商家收货确认）\n8：退货完成（商家收货并且同意退款给用户）\n9:退货失败（商家不同意退款）', 'char(1)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'afterSaleStatus', 16, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (300, '34', 'predeposit_pay', '是否预存款支付  0 否 1 是  默认0', 'char(1)', 'String', 'predepositPay', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 17, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (301, '34', 'logis_company_name', '物流公司名称', 'varchar(45)', 'String', 'logisCompanyName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 18, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (302, '34', 'waybill_code', '物流单号', 'varchar(128)', 'String', 'waybillCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (303, '34', 'create_time', '生成时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 20, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:24');
INSERT INTO `gen_table_column` VALUES (304, '35', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (305, '35', 'back_order_id', '退单id 对应oms_back_order表中的id', 'bigint(20)', 'Long', 'backOrderId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (306, '35', 'operation_type', '操作人类型 1 用户  2 商家\n', 'char(1)', 'String', 'operationType', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'operate_type', 3, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (307, '35', 'message', '留言', 'varchar(1024)', 'String', 'message', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 4, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (308, '35', 'status', '1:退款申请 （用户发送退款请求）\n2:退款成功（商家同意退款）\n3:退款拒绝 （商家拒绝退款）\n4:退货申请 （用户发起退货请求）\n5:退货拒绝   （商家拒绝退货）\n6:退货审核通过等待用户填写物流（商家审核通过，等待用户寄回商品）\n7: 待收货  （用户已经寄回商品，等待商家收货确认）\n8：退货完成（商家收货并且同意退款给用户）\n9:退货失败（商家不同意退款）', 'char(1)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'afterSaleStatus', 5, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (309, '35', 'create_time', '生成时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (310, '36', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (311, '36', 'order_code', '订单或者退单的code', 'varchar(45)', 'String', 'orderCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (312, '36', 'type', '账单进出类型 0 进 1 出', 'char(1)', 'String', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'bill_type', 3, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (313, '36', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (314, '36', 'store_name', '店铺名称', 'varchar(45)', 'String', 'storeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (315, '36', 'record_type', '账单记录类型 1 确认收货 2 退款订单 3 退货订单佣金  4 订单关闭（只支付定金） 5 推广订单提成 6 退货订单', 'char(1)', 'String', 'recordType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'bill_records_type', 6, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (316, '36', 'order_price', '订单实付金额', 'decimal(20,2)', 'BigDecimal', 'orderPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (317, '36', 'order_back_price', '订单实退金额', 'decimal(20,2)', 'BigDecimal', 'orderBackPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (318, '36', 'order_commission', '订单佣金', 'decimal(20,2)', 'BigDecimal', 'orderCommission', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (319, '36', 'order_actual_price', '订单实际进出金额', 'decimal(20,2)', 'BigDecimal', 'orderActualPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (320, '36', 'create_time', '记录生成时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (321, '36', 'status', '结算状态 0 未结算 1 已结算 默认0 ', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'jiesuan_type', 12, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (322, '37', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (323, '37', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (324, '37', 'money', '金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (325, '37', 'type', '类型  0 收入 1 支出', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (326, '37', 'remark', '备注', 'varchar(256)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (327, '37', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (328, '38', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (329, '38', 'name', '物流公司名称', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (330, '38', 'code', '物流公司代码', 'varchar(45)', 'String', 'code', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (331, '38', 'del_flag', '删除标记  0未删除 1 删除  默认0	', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (332, '38', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (333, '38', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (334, '38', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (335, '39', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', NULL);
INSERT INTO `gen_table_column` VALUES (336, '39', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', NULL);
INSERT INTO `gen_table_column` VALUES (337, '39', 'company_id', '店铺使用的物流公司 id ', 'bigint(20)', 'Long', 'companyId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', NULL);
INSERT INTO `gen_table_column` VALUES (338, '40', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (339, '40', 'name', '物流模版名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (340, '40', 'is_default', '是否默认模版 0 是 1 否 默认1 ', 'char(1)', 'String', 'isDefault', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (341, '40', 'freight_bear', '谁承担运费 0 买家 1 商家 默认 0 买家', 'char(1)', 'String', 'freightBear', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'fright_price', 4, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (342, '40', 'pricint_method', '计价方式 0 按件  1 按重量  默认0 ', 'char(1)', 'String', 'pricintMethod', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'fright_ways', 5, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (343, '40', 'store_id', '店铺id  平台的为 0 ', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (344, '40', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (345, '40', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:47');
INSERT INTO `gen_table_column` VALUES (346, '40', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:47');
INSERT INTO `gen_table_column` VALUES (347, '40', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:47');
INSERT INTO `gen_table_column` VALUES (348, '41', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (349, '41', 'order_code', '订单code', 'varchar(45)', 'String', 'orderCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (350, '41', 'master_order_code', '主订单code  下单可能会同时下多个订单 ，一个master_order_code 可以对应多个order_code 即多个订单', 'varchar(45)', 'String', 'masterOrderCode', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (351, '41', 'customer_id', '订单所属的会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (352, '41', 'price', '订单的最终价格(订单的最终成交价格)', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (353, '41', 'presale_price', '预售需要支付的金额 （预售订单使用）', 'decimal(20,2)', 'BigDecimal', 'presalePrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (354, '41', 'original_price', '订单原始金额（每个单品详情页面的总价）', 'decimal(20,2)', 'BigDecimal', 'originalPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (355, '41', 'freight_price', '运费', 'decimal(20,2)', 'BigDecimal', 'freightPrice', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (356, '41', 'modify_price', '订单修改的金额（后端管理员修改）', 'decimal(20,2)', 'BigDecimal', 'modifyPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (357, '41', 'point_price', '积分抵消的金额', 'decimal(20,2)', 'BigDecimal', 'pointPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (358, '41', 'coupon_price', '优惠卷抵消的价格', 'decimal(20,2)', 'BigDecimal', 'couponPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (359, '41', 'red_envelope_price', '使用红包减去的价格', 'decimal(20,2)', 'BigDecimal', 'redEnvelopePrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (360, '41', 'concessional_rate', '总的优惠价（包含订单使用的优惠卷 积分 红包 ,满减满折的价格）', 'decimal(20,2)', 'BigDecimal', 'concessionalRate', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 13, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (361, '41', 'status', '1:待付款  （用户刚下单）\r2:代发货  （用户付完款 等待商城发货）\r3:代收货  （商城已经发货 等待用户确认收货）\r4:已完成  （用户已经确认收货 订单结束）\r5:取消订单 （用户未付款前取消订单）\r6:退款通过  （用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款）\r7:退货通过   （用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品）\r\n', 'char(2)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'order_status', 14, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (362, '41', 'presale_status', '预售订单状态   普通订单 该状态没作用\n0 第一阶段未支付\n1 第一阶段已支付第二阶段未支付\n2 第二阶段已支付   默认0 ', 'char(1)', 'String', 'presaleStatus', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'pre_sale_status', 15, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (363, '41', 'evaluation_status', '评价状态  0 未评价 1 已评价  默认为0 未评价', 'char(1)', 'String', 'evaluationStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', '', 16, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (364, '41', 'red_envelope_code', '使用红包的code', 'varchar(64)', 'String', 'redEnvelopeCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 17, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (365, '41', 'coupon_no', '使用的优惠卷的卷码', 'varchar(64)', 'String', 'couponNo', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 18, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (366, '41', 'use_point', '使用的积分数量', 'int(11)', 'Long', 'usePoint', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 19, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (367, '41', 'pay_type', '支付类型  0在线支付  1货到付款 ', 'char(1)', 'String', 'payType', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'select', 'pay_type', 20, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (368, '41', 'store_id', '订单店铺id  平台的订单id为0', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 21, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (369, '41', 'cancel_reson', '订单取消原因\n1:现在不想买\n2:商品价格较贵\n3:价格波动\n4:商品缺货\n5:重复下单\n6:收货人信息有误\n7:发票信息有误/发票未开\n8:送货时间过长\n9:其他原因\n0:系统取消', 'char(1)', 'String', 'cancelReson', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 22, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (370, '41', 'predeposit_pay', '是否预存款支付  0 否 1 是  默认0', 'char(1)', 'String', 'predepositPay', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 23, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (371, '41', 'source', '订单来源 1pc  2 h5   3 app', 'char(1)', 'String', 'source', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'order_source', 24, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (372, '41', 'waybill_code', '运单号', 'varchar(45)', 'String', 'waybillCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (373, '41', 'order_type', '订单类型 0 普通订单 1 定金预售订单 2全款预售订单 3 拼团订单 4 众筹全款 5 众筹1元 6 众筹无回报 7 虚拟商品订单 8 社区团购订单 默认0 普通订单', 'char(1)', 'String', 'orderType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'order_type', 26, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (374, '41', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 27, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (375, '41', 'pay_time', '支付时间', 'timestamp', 'Date', 'payTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 28, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (376, '41', 'delivery_time', '发货时间', 'timestamp', 'Date', 'deliveryTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 29, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (377, '41', 'receiving_time', '确认收货时间', 'timestamp', 'Date', 'receivingTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 30, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (378, '41', 'cancel_time', '订单取消时间', 'timestamp', 'Date', 'cancelTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 31, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (379, '41', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 32, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (380, '41', 'evaluation_time', '订单评价时间', 'timestamp', 'Date', 'evaluationTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 33, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (381, '41', 'presale_time', '预售订单的时间\n对于定金预售 则是第二阶段付款时间 和发货时间 对于全款预售 则是发货时间', 'timestamp', 'Date', 'presaleTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 34, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (382, '41', 'group_head', '是否团长  0 是 1 否  当订单为拼团订单的时候有用', 'char(1)', 'String', 'groupHead', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 35, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (383, '41', 'group_id', '拼团订单的id  拼团订单的时候有用', 'varchar(45)', 'String', 'groupId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 36, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (384, '41', 'group_marketing_id', '拼团订单的促销id 拼团订单的时候有用', 'bigint(20)', 'Long', 'groupMarketingId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 37, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (385, '41', 'group_sku_id', '拼团的单品id （拼团订单时候有效）', 'varchar(64)', 'String', 'groupSkuId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 38, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (386, '41', 'group_status', '拼团状态 -1无状态 0未成团 1已成团 默认-1 ', 'char(2)', 'String', 'groupStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', '', 39, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (387, '41', 'group_num', '成团的数量', 'int(11)', 'Long', 'groupNum', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 40, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (388, '41', 'open_group_time', '开团时间', 'datetime', 'Date', 'openGroupTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 41, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (389, '41', 'auto_handle_status', '拼团订单定时任务处理状态 \'0\'未处理 \'1\'已处理 默认\'0\'', 'char(1)', 'String', 'autoHandleStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', '', 42, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (390, '41', 'recommended', '订单推广人的会员id(订单会员的推广人 ，也就是订单会员的上级的id) 如果为-1 则说明该订单会员没有推荐人或者不是推广订单', 'bigint(20)', 'Long', 'recommended', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 43, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (391, '41', 's_recommended', '订单二级推广人的会员id(订单会员的二级推广人 ，也就是订单会员的上级的上级会员id) 如果为-1 则说明该订单会员没有推荐人或者不是推广订单', 'bigint(20)', 'Long', 'sRecommended', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 44, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (392, '41', 'crowdfunding_id', '众筹id  对应ls_markeing 表中的id', 'bigint(20)', 'Long', 'crowdfundingId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 45, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (393, '41', 'lottery_status', '抽奖状态  0 待抽奖 1 抽中 默认0', 'char(1)', 'String', 'lotteryStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', '', 46, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (394, '41', 'write_off_code', '虚拟订单的核销码', 'varchar(10)', 'String', 'writeOffCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 47, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (395, '41', 'community_buy_customer_id', '社区团购的团长会员id  社区团购的时候使用 对应ums_member表中的id', 'int(11)', 'Long', 'communityBuyCustomerId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 48, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (396, '41', 'community_buy_id', '社区团购的团购id  对应s_community_buy 表中的id ', 'int(11)', 'Long', 'communityBuyId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 49, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (397, '41', 'profit', '社区团购的利润，社区团购的时候使用', 'decimal(20,2)', 'BigDecimal', 'profit', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 50, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (398, '41', 'community_name', '小区名称 社区团购使用', 'varchar(64)', 'String', 'communityName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 51, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:16');
INSERT INTO `gen_table_column` VALUES (399, '41', 'community_buy_name', '社区团购名称', 'varchar(64)', 'String', 'communityBuyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 52, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:16');
INSERT INTO `gen_table_column` VALUES (400, '41', 'logistics_company', '物流公司名称', 'varchar(64)', 'String', 'logisticsCompany', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 53, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:16');
INSERT INTO `gen_table_column` VALUES (401, '41', 'logistics_code', '物流公司code', 'varchar(64)', 'String', 'logisticsCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 54, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:16');
INSERT INTO `gen_table_column` VALUES (402, '42', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (403, '42', 'order_id', '订单id  对应oms_order 表中的order_code', 'bigint(20)', 'Long', 'orderId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (404, '42', 'receipt_name', '收货人姓名', 'varchar(45)', 'String', 'receiptName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (405, '42', 'receipt_address', '收货人的地址 （省＋市＋区）', 'varchar(128)', 'String', 'receiptAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (406, '42', 'receipt_detail_address', '收货人的详细地址', 'varchar(128)', 'String', 'receiptDetailAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (407, '42', 'receipt_mobile', '收货人的手机号码', 'varchar(11)', 'String', 'receiptMobile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (408, '42', 'receipt_phone', '收货人的固定电话', 'varchar(20)', 'String', 'receiptPhone', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (409, '42', 'receipt_zip_code', '收货人的邮编', 'varchar(10)', 'String', 'receiptZipCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (410, '42', 'invoice_type', '发票类型  0 不需要发票 1增值税普票 2增值税专票 默认0', 'char(1)', 'String', 'invoiceType', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 9, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (411, '42', 'invoice_title', '发票抬头', 'varchar(45)', 'String', 'invoiceTitle', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (412, '42', 'invoice_content', '发票内容 \n1:非图书商品\n2:明细\n3:耗材\n4:办公用品', 'char(1)', 'String', 'invoiceContent', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (413, '42', 'invoice_taxid', '税号', 'varchar(45)', 'String', 'invoiceTaxid', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (414, '42', 'remark', '订单备注', 'varchar(2048)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 13, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (415, '42', 'gift_infos', '订单的赠品信息格式为\n[\n    {\n        \"num\": 1,\n        \"skuId\": \"15096899899251410\",\n        \"skuName\": \"平台商品(规格5)\",\n        \"skuNo\": \"201711031419380\",\n        \"specs\": \"版本:规格5|\",\n        \"url\": \"http://lecshop.b0.upaiyun.com/1509689972311.jpg\"\n    }\n]', 'varchar(2048)', 'String', 'giftInfos', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 14, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (416, '42', 'donation_message', '捐赠寄语', 'varchar(2048)', 'String', 'donationMessage', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 15, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (417, '42', 'invoice_company_name', '单位名称', 'varchar(64)', 'String', 'invoiceCompanyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 16, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (418, '42', 'invoice_register_address', '注册地址', 'varchar(128)', 'String', 'invoiceRegisterAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 17, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (419, '42', 'invoice_register_mobile', '注册电话', 'varchar(15)', 'String', 'invoiceRegisterMobile', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 18, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (420, '42', 'invoice_open_bank', '开户银行', 'varchar(64)', 'String', 'invoiceOpenBank', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 19, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (421, '42', 'invoice_bank_account', '银行账户', 'varchar(64)', 'String', 'invoiceBankAccount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 20, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (422, '42', 'invoice_title_type', '抬头类型  1 企业  2 个人 ', 'char(1)', 'String', 'invoiceTitleType', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 21, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (423, '42', 'delivery_time', '送达时间 社区团购使用', 'timestamp', 'Date', 'deliveryTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 22, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (424, '42', 'address', '所在地区 省+市+区 社区团购使用', 'varchar(32)', 'String', 'address', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 23, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (425, '42', 'detail_address', '详细信息 取货小区 社区团购使用', 'varchar(32)', 'String', 'detailAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 24, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (426, '42', 'pick_up_address', '提货点 社区团购使用', 'varchar(32)', 'String', 'pickUpAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 25, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (427, '42', 'delivery_type', '提货方式 1 团长送货上门 2 自提', 'char(1)', 'String', 'deliveryType', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 26, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (428, '42', 'house_number', '门牌号 社区团购使用', 'varchar(16)', 'String', 'houseNumber', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 27, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (429, '43', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (430, '43', 'order_id', '订单id 对应oms_order 表中的id', 'bigint(20)', 'Long', 'orderId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (431, '43', 'type', '操作类型 1 确认付款 2 修改金额 3 发货  4取消订单 5修改物流单号 6 核销虚拟商品订单', 'char(1)', 'String', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'order_operate_type', 3, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (432, '43', 'remark', '说明', 'varchar(1024)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 4, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (433, '43', 'operation_name', '操作人', 'varchar(128)', 'String', 'operationName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (434, '43', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (435, '44', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (436, '44', 'allow_back', '是否可以退款和退货  0 可以 1 不可以 默认0 ', 'char(1)', 'String', 'allowBack', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (437, '44', 'aotu_confirm', '订单自定收货几天前的订单 默认1', 'int(11)', 'Long', 'aotuConfirm', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (438, '44', 'refunds_desc', '退款说明', 'text', 'String', 'refundsDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (439, '44', 'return_desc', '退货说明', 'text', 'String', 'returnDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (440, '44', 'cashon_delivery', '是否支持货到付款  0 支付 1 不支持 默认0 ', 'char(1)', 'String', 'cashonDelivery', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (441, '45', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (442, '45', 'order_id', '订单id  对应oms_order表中的order_code', 'bigint(20)', 'Long', 'orderId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (443, '45', 'sku_id', '单品id 对应pms_sku 表中的id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (444, '45', 'num', '购买的数量', 'int(11)', 'Long', 'num', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (445, '45', 'price', '单品的最终价格（原价－优惠价）', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (446, '45', 'sku_price', '单品的价格(详情页的价格)', 'decimal(20,2)', 'BigDecimal', 'skuPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (447, '45', 'sku_name', '单品的名称', 'varchar(128)', 'String', 'skuName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (448, '45', 'sku_no', '单品的编号', 'varchar(45)', 'String', 'skuNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (449, '45', 'sku_image', '单品的图片', 'varchar(128)', 'String', 'skuImage', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (450, '45', 'sku_specs', '单品的规格', 'varchar(256)', 'String', 'skuSpecs', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (451, '45', 'price_detail', '使用各个优惠减去的价格（这个字段为了方便扩展使用的是json格式）', 'varchar(1024)', 'String', 'priceDetail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 11, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (452, '45', 'commission_rate', '单品的分拥比例 0 表示不分佣金', 'decimal(3,2)', 'BigDecimal', 'commissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (453, '45', 's_commission_rate', '单品的分拥比例 0 表示不分佣金', 'decimal(3,2)', 'BigDecimal', 'sCommissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (454, '45', 'cate_rate', '分类扣率', 'decimal(3,2)', 'BigDecimal', 'cateRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (455, '45', 'old_price', '单品的原价格（社区团购的时候使用）', 'decimal(20,2)', 'BigDecimal', 'oldPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (456, '45', 'supply_price', '供货价格（社区团购使用）', 'decimal(20,2)', 'BigDecimal', 'supplyPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (457, '46', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (458, '46', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (459, '46', 'sku_id', '单品id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (460, '46', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (461, '46', 'num', '单品数量', 'int(11)', 'Long', 'num', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (462, '46', 'marketing_id', '默认的营销id(满减或者满折)', 'bigint(20)', 'Long', 'marketingId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (463, '46', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (464, '46', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (465, '47', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (466, '47', 'ls_trans_code', '系统内部订单id', 'varchar(64)', 'String', 'lsTransCode', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (467, '47', 'trans_code', '外部系统交易流水号', 'varchar(64)', 'String', 'transCode', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (468, '47', 'type', '类型 1 门店订单 2 订单 3 预存款', 'char(50)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'pay_trans_type', 4, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (469, '47', 'money', '交易金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (470, '47', 'order_id', '订单id', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (471, '47', 'channel', '支付方式', 'varchar(32)', 'String', 'channel', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (472, '47', 'create_time', '订单创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (473, '47', 'pay_time', '支付时间', 'timestamp', 'Date', 'payTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (474, '48', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (475, '48', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (476, '48', 'sku_id', '单品id', 'varchar(20)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (477, '48', 'del_flag', '删除标记  0 未删除 1 删除', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (478, '48', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (479, '49', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (480, '49', 'username', '用户名', 'varchar(45)', 'String', 'username', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (481, '49', 'password', '用户密码', 'varchar(256)', 'String', 'password', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (482, '49', 'nickname', '昵称', 'varchar(45)', 'String', 'nickname', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 4, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (483, '49', 'image', '头像地址', 'varchar(128)', 'String', 'image', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (484, '49', 'relename', '真实姓名', 'varchar(45)', 'String', 'relename', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 6, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (485, '49', 'cardid', '身份证', 'varchar(32)', 'String', 'cardid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (486, '49', 'gender', '性别  0 保密 1男 2女 默认0', 'char(1)', 'String', 'gender', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (487, '49', 'birthday', '生日', 'date', 'Date', 'birthday', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (488, '49', 'monthly_income', '月收入  0 无收入 1 2000以下 2 2000-3999 3 4000-5999\n4 6000－7999  5 8000以上', 'char(1)', 'String', 'monthlyIncome', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (489, '49', 'marriage_status', '婚姻状况  0 保密 1未婚 2 已婚 默认0 保姆', 'char(1)', 'String', 'marriageStatus', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'radio', '', 11, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (490, '49', 'mobile', '手机号码', 'varchar(45)', 'String', 'mobile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (491, '49', 'email', '邮箱地址', 'varchar(32)', 'String', 'email', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (492, '49', 'modified_email', '更改中的邮箱（绑定新邮箱使用）', 'varchar(255)', 'String', 'modifiedEmail', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (493, '49', 'check_code', '校验码（绑定新邮箱时使用）', 'varchar(255)', 'String', 'checkCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 15, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (494, '49', 'province', '省', 'bigint(20)', 'Long', 'province', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 16, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (495, '49', 'city', '市', 'bigint(20)', 'Long', 'city', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 17, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (496, '49', 'county', '区', 'bigint(20)', 'Long', 'county', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 18, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (497, '49', 'detailaddress', '详细地址', 'varchar(128)', 'String', 'detailaddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 19, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (498, '49', 'interest', '兴趣爱好', 'varchar(2048)', 'String', 'interest', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 20, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (499, '49', 'store_id', '店铺id  平台的为0  默认为平台', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 21, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (500, '49', 'type', '1 普通用户 2 商家店铺用户 3 店铺员工', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 22, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (501, '49', 'consumption_amount', '总的消费金额', 'decimal(20,2)', 'BigDecimal', 'consumptionAmount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 23, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (502, '49', 'paypassword', '预存款支付密码', 'varchar(256)', 'String', 'paypassword', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 24, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (503, '49', 'source', '用户注册来源 1 pc  2app  3 手机h5 4 管理员后台新增\n', 'char(1)', 'String', 'source', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 25, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (504, '49', 'status', '用户状态 1 正常 2 冻结  3 未启用 默认1 ', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 26, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (505, '49', 'sign_num', '会员签到次数', 'int(11)', 'Long', 'signNum', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 27, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (506, '49', 'is_mobile_verification', '手机是否验证  0 否 1 验证 默认0 ', 'char(1)', 'String', 'isMobileVerification', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 28, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (507, '49', 'is_email_verification', '邮箱是否验证   0 否 1 验证  默认0  ', 'char(1)', 'String', 'isEmailVerification', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 29, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (508, '49', 'login_error_count', '错误登录的次数', 'int(11)', 'Long', 'loginErrorCount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 30, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (509, '49', 'del_flag', '删除标记 0 未删除 1删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 31, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (510, '49', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 32, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (511, '49', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 33, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (512, '49', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 34, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (513, '49', 'lock_time', '锁定时间', 'timestamp', 'Date', 'lockTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 35, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (514, '49', 'last_login_time', '最近登陆时间', 'timestamp', 'Date', 'lastLoginTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 36, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (515, '49', 'recommended', '推荐人的会员id  如果没有 则为-1  默认为-1', 'bigint(20)', 'Long', 'recommended', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 37, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (516, '49', 's_recommended', '二级推荐人的会员id （上级的上级） 如果没有 则为-1  默认为-1', 'bigint(20)', 'Long', 'sRecommended', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 38, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (517, '49', 'self_recommend_code', '会员自己的推荐码', 'varchar(45)', 'String', 'selfRecommendCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 39, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (518, '49', 'commission', '会员的佣金', 'decimal(20,2)', 'BigDecimal', 'commission', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 40, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (519, '49', 'belone_store_id', '会员所属的店铺id', 'bigint(20)', 'Long', 'beloneStoreId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 41, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (520, '50', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (521, '50', 'customer_id', '用户id  对应ums_member表中的id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (522, '50', 'name', '收货人姓名', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (523, '50', 'mobile', '手机号码', 'varchar(12)', 'String', 'mobile', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (524, '50', 'phone', '收货人固定电话', 'varchar(12)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (525, '50', 'zip_code', '邮编', 'varchar(45)', 'String', 'zipCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (526, '50', 'address', '收货人地址（省＋市＋区）', 'varchar(124)', 'String', 'address', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (527, '50', 'detail_address', '收货人详细地址', 'varchar(64)', 'String', 'detailAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (528, '50', 'province_id', '省id', 'bigint(20)', 'Long', 'provinceId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (529, '50', 'city_id', '市id', 'bigint(20)', 'Long', 'cityId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (530, '50', 'country_id', '区id', 'bigint(20)', 'Long', 'countryId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (531, '50', 'is_default', '是否默认收货地址  0 否 1 是  默认0 ', 'char(1)', 'String', 'isDefault', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (532, '50', 'del_flag', '删除标记  0 未删除 1 删除', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 13, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (533, '50', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 14, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (534, '50', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 15, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (535, '50', 'update_time', '更新时间', 'timestamp', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 16, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (536, '51', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (537, '51', 'name', '会员等级名称', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (538, '51', 'min_money', '消费小值（包含该值）', 'int(11)', 'Long', 'minMoney', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (539, '51', 'max_money', '消费金额最大值 不包含该值', 'int(11)', 'Long', 'maxMoney', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (540, '51', 'discount', '会员折扣', 'decimal(10,2)', 'BigDecimal', 'discount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (541, '51', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (542, '51', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (543, '51', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (544, '51', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (545, '52', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (546, '52', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (547, '52', 'marketing_id', '抢购id 注意是对应sms_marketing_panicbuy表中的id', 'bigint(20)', 'Long', 'marketingId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (548, '52', 'use_num', '用户已经购买抢购的数量', 'int(11)', 'Long', 'useNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (549, '52', 'panic_num', '该抢购的会员限购数量', 'int(11)', 'Long', 'panicNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (550, '52', 'order_id', '订单id', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (551, '53', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (552, '53', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (553, '53', 'detail', '积分详细', 'varchar(45)', 'String', 'detail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (554, '53', 'type', '积分类型 1 收入 2支出', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (555, '53', 'source_type', '积分纪录来源类型\n1 订单使用\n2 订单取消\n3 操作员修改\n4 签到\n5 积分商城使用\n6 邮箱验证 \n7 评论\n', 'char(1)', 'String', 'sourceType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (556, '53', 'point', '积分数量 正数表示增加，负数表示减少', 'int(11)', 'Long', 'point', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (557, '53', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (558, '53', 'sign_data', '签到时间，用于防止重复签到', 'date', 'Date', 'signData', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (559, '54', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (560, '54', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (561, '54', 'trans_type', '交易类型  1:在线充值  2:订单消费  3:订单退款 4:管理员增加 5:管理员减少', 'char(1)', 'String', 'transType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (562, '54', 'money', '金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (563, '54', 'current_money', '当前总金额', 'decimal(20,2)', 'BigDecimal', 'currentMoney', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (564, '54', 'remark', '备注', 'varchar(256)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (565, '54', 'status', '充值支付状态 0 未支付 1 支付成功', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (566, '54', 'transcode', '交易号', 'varchar(45)', 'String', 'transcode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (567, '54', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (568, '55', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (569, '55', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (570, '55', 'money', '提现金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (571, '55', 'status', '状态 0 申请  1 审核通过 2 拒绝 3 已打款', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'withdraw_status', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (572, '55', 'trade_no', '流水号', 'varchar(45)', 'String', 'tradeNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (573, '55', 'account', '支付宝账号', 'varchar(64)', 'String', 'account', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (574, '55', 'name', '支付宝姓名', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (575, '55', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (576, '55', 'paying_time', '打款时间', 'timestamp', 'Date', 'payingTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-07-25 08:31:58', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (577, '56', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (578, '56', 'name', '权限的名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (579, '56', 'url', '权限对应的访问地址', 'varchar(256)', 'String', 'url', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (580, '56', 'parentId', '父级id 如果是第一级  则为0', 'bigint(20)', 'Long', 'parentid', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (581, '56', 'grade', '级别 1 表示第一级 2表示第二级', 'int(11)', 'Long', 'grade', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (582, '56', 'sort', '排序 数字越低 排序越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (583, '56', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (584, '56', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (585, '56', 'image', '图片地址', 'varchar(128)', 'String', 'image', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (586, '56', 'component', '前端页面对于的组件地址', 'varchar(256)', 'String', 'component', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (587, '56', 'redirect', '重定向地址', 'varchar(256)', 'String', 'redirect', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (588, '56', 'type', '类型 0 菜单 1 接口', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 12, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (589, '56', 'active_menu', '当前节点激活的菜单（一般这个节点是一个详情页面，自己本身没有左侧菜单）', 'varchar(512)', 'String', 'activeMenu', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 13, 'admin', '2020-07-27 19:42:25', '', NULL);
INSERT INTO `gen_table_column` VALUES (590, '57', 'id', '主键id', 'bigint(20)', 'BigDecimal', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38');
INSERT INTO `gen_table_column` VALUES (591, '57', 'order_code', '订单code', 'varchar(64)', 'String', 'orderCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38');
INSERT INTO `gen_table_column` VALUES (592, '57', 'type', '账单进出类型 0 进 1 出', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'bill_type', 3, 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38');
INSERT INTO `gen_table_column` VALUES (593, '57', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38');
INSERT INTO `gen_table_column` VALUES (594, '57', 'store_name', '店铺名称', 'varchar(45)', 'String', 'storeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38');
INSERT INTO `gen_table_column` VALUES (595, '57', 'record_type', '账单记录类型 1 提货完成 2 代客下单完成', 'char(1)', 'String', 'recordType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'bill_records_type', 6, 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38');
INSERT INTO `gen_table_column` VALUES (596, '57', 'order_price', '订单价格', 'decimal(20,2)', 'BigDecimal', 'orderPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38');
INSERT INTO `gen_table_column` VALUES (597, '57', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'checkbox', 'sys_yes_no', 8, 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38');
INSERT INTO `gen_table_column` VALUES (598, '57', 'status', '结算状态 0 未结算 1 已结算 默认0 ', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'jiesuan_type', 9, 'admin', '2020-07-27 19:42:25', '', '2020-10-17 20:20:38');
INSERT INTO `gen_table_column` VALUES (599, '58', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (600, '58', 'name', '分类名称', 'varchar(32)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (601, '58', 'parent_id', '上级分类id 0 表示没有上级', 'bigint(20)', 'Long', 'parentId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (602, '58', 'grade', '1 一级分类 2 二级分类 3 三级分类', 'int(11)', 'Long', 'grade', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (603, '58', 'sort', '排序  数值越小 越靠前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (604, '58', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (605, '58', 'del_flag', '删除标记  0 未删除 1 删除', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (606, '58', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (607, '58', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (608, '58', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:25:05');
INSERT INTO `gen_table_column` VALUES (609, '59', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:30:59');
INSERT INTO `gen_table_column` VALUES (610, '59', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:30:59');
INSERT INTO `gen_table_column` VALUES (611, '59', 'order_id', '订单号', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:30:59');
INSERT INTO `gen_table_column` VALUES (612, '59', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:30:59');
INSERT INTO `gen_table_column` VALUES (613, '59', 'desc_score', '描述相符 评分1到5分', 'int(11)', 'Long', 'descScore', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'descScop', 5, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:30:59');
INSERT INTO `gen_table_column` VALUES (614, '59', 'seller_score', '卖家服务评分 1到5分', 'int(11)', 'Long', 'sellerScore', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'descScop', 6, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:30:59');
INSERT INTO `gen_table_column` VALUES (615, '59', 'logistics_score', '物流评分 1到5分', 'int(11)', 'Long', 'logisticsScore', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'descScop', 7, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:30:59');
INSERT INTO `gen_table_column` VALUES (616, '59', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-27 19:42:25', '', '2020-07-28 08:30:59');
INSERT INTO `gen_table_column` VALUES (617, '60', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:25', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (618, '60', 'name', '品牌名称', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-27 19:42:25', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (619, '60', 'url', '品牌的图片', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:25', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (620, '60', 'certificat_url', '证书图片', 'varchar(128)', 'String', 'certificatUrl', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:26', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (621, '60', 'store_id', '店铺id', 'char(1)', 'String', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:26', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (622, '60', 'brand_id', '对应品牌表中的id', 'bigint(20)', 'Long', 'brandId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:26', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (623, '60', 'status', '状态  0 申请中  1通过 2 拒绝', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-07-27 19:42:26', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (624, '60', 'reason', '拒绝原因', 'varchar(1024)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 8, 'admin', '2020-07-27 19:42:26', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (625, '60', 'del_flag', '删除标记  0 未删除 1 删除默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-27 19:42:26', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (626, '60', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-07-27 19:42:26', '', '2020-07-27 19:57:47');
INSERT INTO `gen_table_column` VALUES (627, '61', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:25');
INSERT INTO `gen_table_column` VALUES (628, '61', 'score', '门店评分', 'int(11)', 'Long', 'score', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'descScop', 2, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:25');
INSERT INTO `gen_table_column` VALUES (629, '61', 'desc', '评价', 'varchar(2048)', 'String', 'desc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:25');
INSERT INTO `gen_table_column` VALUES (630, '61', 'order_code', '订单code', 'varchar(64)', 'String', 'orderCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:25');
INSERT INTO `gen_table_column` VALUES (631, '61', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:25');
INSERT INTO `gen_table_column` VALUES (632, '61', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:25');
INSERT INTO `gen_table_column` VALUES (633, '61', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:25');
INSERT INTO `gen_table_column` VALUES (634, '62', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (635, '62', 'store_name', '店铺名称', 'varchar(128)', 'String', 'storeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (636, '62', 'status', '店铺状态\n0 填写资料中 \n1 店铺审核中\n2 审核通过\n3 审核不通过\n4 店铺关闭', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'storeStatus', 3, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (637, '62', 'company_name', '公司名称', 'varchar(128)', 'String', 'companyName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (638, '62', 'company_address', '公司地址', 'varchar(128)', 'String', 'companyAddress', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (639, '62', 'company_phone', '公司电话', 'varchar(45)', 'String', 'companyPhone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (640, '62', 'company_email', '公司邮箱', 'varchar(128)', 'String', 'companyEmail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (641, '62', 'contact_person', '联系人', 'varchar(128)', 'String', 'contactPerson', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (642, '62', 'contact_phone', '联系人电话', 'varchar(16)', 'String', 'contactPhone', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (643, '62', 'legal_person', '法定代表人', 'varchar(128)', 'String', 'legalPerson', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (644, '62', 'card_no', '身份证号码', 'varchar(24)', 'String', 'cardNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (645, '62', 'card_pic', '身份证照片', 'varchar(256)', 'String', 'cardPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (646, '62', 'bus_licenec', '营业执照号', 'varchar(64)', 'String', 'busLicenec', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (647, '62', 'bus_licenec_pic', '营业执照图片', 'varchar(256)', 'String', 'busLicenecPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (648, '62', 'business_scope', '经营范围', 'varchar(1024)', 'String', 'businessScope', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 15, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (649, '62', 'org_pic', '组织机构代码图片', 'varchar(256)', 'String', 'orgPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (650, '62', 'tax_pic', '税务登记图片', 'varchar(256)', 'String', 'taxPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (651, '62', 'bank_user_name', '银行开户名', 'varchar(126)', 'String', 'bankUserName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 18, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (652, '62', 'bank_account', '公司银行账号', 'varchar(126)', 'String', 'bankAccount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (653, '62', 'bank_name', '开户银行支行名称', 'varchar(128)', 'String', 'bankName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 20, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (654, '62', 'bank_number', '支行银行号', 'varchar(128)', 'String', 'bankNumber', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (655, '62', 'bank_address', '开户银行所在地', 'varchar(128)', 'String', 'bankAddress', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 22, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (656, '62', 'bank_pic', '开户银行许可证电子版', 'varchar(128)', 'String', 'bankPic', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 23, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (657, '62', 'billing_cycle', '结算周期', 'varchar(45)', 'String', 'billingCycle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 24, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (658, '62', 'ismerge', '0三证合一 1 三证不合一', 'char(1)', 'String', 'ismerge', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (659, '62', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 26, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (660, '62', 'service_qq', '客服QQ', 'varchar(255)', 'String', 'serviceQq', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 27, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (661, '62', 'reason', '拒绝原因', 'varchar(1024)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 28, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (662, '62', 'ave_score', '店铺评分', 'decimal(10,2)', 'BigDecimal', 'aveScore', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 29, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (663, '62', 'effective_time', '店铺有效期', 'timestamp', 'Date', 'effectiveTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 30, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (664, '62', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 31, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (665, '62', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 32, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (666, '62', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 33, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (667, '62', 'type', '店铺类型 0 普通店铺 1 加盟 2连锁', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'storeType', 34, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (668, '62', 'longitude', '经度', 'decimal(15,10)', 'BigDecimal', 'longitude', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 35, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (669, '62', 'latitude', '纬度', 'decimal(15,10)', 'BigDecimal', 'latitude', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 36, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (670, '62', 'business_time', '营业时间', 'varchar(256)', 'String', 'businessTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 37, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (671, '62', 'bus_routes', '公交线路', 'varchar(256)', 'String', 'busRoutes', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 38, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (672, '62', 'avatar_picture', '店铺头像', 'varchar(256)', 'String', 'avatarPicture', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 39, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (673, '62', 'province_id', '省id', 'bigint(20)', 'Long', 'provinceId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 40, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (674, '62', 'city_id', '市id', 'bigint(20)', 'Long', 'cityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 41, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (675, '62', 'district_id', '区域id', 'bigint(20)', 'Long', 'districtId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 42, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (676, '62', 'company_detail_address', '公司详细地址', 'varchar(256)', 'String', 'companyDetailAddress', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 43, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:00');
INSERT INTO `gen_table_column` VALUES (677, '63', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (678, '63', 'order_code', '订单编号', 'varchar(45)', 'String', 'orderCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (679, '63', 'master_order_code', '主订单code  下单可能会同时下多个订单 ，一个master_order_code 可以对应多个order_code 即多个订单', 'varchar(45)', 'String', 'masterOrderCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (680, '63', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (681, '63', 'original_price', '订单的原始价格', 'decimal(20,2)', 'BigDecimal', 'originalPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (682, '63', 'price', '订单的最终价格(订单的最终成交价格)（原始价格-红包的价格）', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (683, '63', 'status', '订单状态 1 待付款（刚下单） 2 待取货（已经付款） 3 交易完成  4 取消订单', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 7, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (684, '63', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (685, '63', 'evaluation_status', '评价状态  0 未评价 1 已评价  默认为0 未评价', 'char(1)', 'String', 'evaluationStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 9, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (686, '63', 'red_envelope_price', '使用红包减去的金额', 'decimal(20,2)', 'BigDecimal', 'redEnvelopePrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (687, '63', 'red_envelope_code', '红包的卷码', 'varchar(64)', 'String', 'redEnvelopeCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (688, '63', 'write_off_code', '核销码', 'varchar(255)', 'String', 'writeOffCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (689, '63', 'source', '订单来源 1pc  2 h5   3 app 4 代客下单', 'char(1)', 'String', 'source', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (690, '63', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 14, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:45');
INSERT INTO `gen_table_column` VALUES (691, '63', 'pay_time', '支付时间', 'timestamp', 'Date', 'payTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 15, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:46');
INSERT INTO `gen_table_column` VALUES (692, '63', 'cancel_time', '取消时间', 'timestamp', 'Date', 'cancelTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 16, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:46');
INSERT INTO `gen_table_column` VALUES (693, '63', 'cancel_reason', '订单取消原因 1 现在不想买 2商品价格较贵 3价格波动 4商品缺货 5 重复下单 6发票信息有误 7 其他原因 8 无法备齐货物 9不是有效订单 10 买家主动要求', 'char(2)', 'String', 'cancelReason', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:46');
INSERT INTO `gen_table_column` VALUES (694, '63', 'pick_up_time', '取货时间', 'varchar(32)', 'String', 'pickUpTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:46');
INSERT INTO `gen_table_column` VALUES (695, '63', 'real_pick_up_time', '实际取货时间', 'timestamp', 'Date', 'realPickUpTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 19, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:46');
INSERT INTO `gen_table_column` VALUES (696, '63', 'pay_type', '支付类型', 'varchar(16)', 'String', 'payType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 20, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:46');
INSERT INTO `gen_table_column` VALUES (697, '63', 'predeposit_pay', '是否是预存款支付  0否1 是 默认0 ', 'char(1)', 'String', 'predepositPay', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 21, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:23:46');
INSERT INTO `gen_table_column` VALUES (698, '64', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (699, '64', 'order_id', '订单id', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (700, '64', 'invoice_type', '发票类型  0 不需要发票 1普通发票 2增值税发票 默认0', 'char(1)', 'String', 'invoiceType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'invoceType', 3, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (701, '64', 'invoice_title', '发票抬头', 'varchar(45)', 'String', 'invoiceTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (702, '64', 'invoice_content', '发票内容 \\n1:非图书商品\\n2:明细\\n3:耗材\\n4:办公用品', 'char(1)', 'String', 'invoiceContent', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (703, '64', 'invoice_taxid', '税号', 'varchar(32)', 'String', 'invoiceTaxid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (704, '64', 'remark', '订单备注', 'varchar(2048)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 7, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (705, '64', 'invoice_title_type', '抬头类型  1 企业  2 个人', 'char(1)', 'String', 'invoiceTitleType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'invoice_head', 8, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (706, '64', 'invoice_company_name', '单位名称', 'varchar(64)', 'String', 'invoiceCompanyName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 9, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (707, '64', 'invoice_register_address', '注册地址', 'varchar(128)', 'String', 'invoiceRegisterAddress', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (708, '64', 'invoice_register_mobile', '注册电话', 'varchar(15)', 'String', 'invoiceRegisterMobile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (709, '64', 'invoice_open_bank', '开户银行', 'varchar(64)', 'String', 'invoiceOpenBank', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (710, '64', 'invoice_bank_account', '银行账户', 'varchar(64)', 'String', 'invoiceBankAccount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:27:00');
INSERT INTO `gen_table_column` VALUES (711, '65', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:21');
INSERT INTO `gen_table_column` VALUES (712, '65', 'order_id', '门店订单id 对应t_store_order 表中的id', 'bigint(20)', 'Long', 'orderId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:21');
INSERT INTO `gen_table_column` VALUES (713, '65', 'type', '操作类型 1 确认付款 2 核销（提货） 3 取消订单 ', 'char(1)', 'String', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'storeOperateType', 3, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:21');
INSERT INTO `gen_table_column` VALUES (714, '65', 'remark', '说明', 'varchar(1024)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 4, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:21');
INSERT INTO `gen_table_column` VALUES (715, '65', 'operation_name', '操作人', 'varchar(128)', 'String', 'operationName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:21');
INSERT INTO `gen_table_column` VALUES (716, '65', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-27 19:42:26', '', '2020-07-28 08:26:21');
INSERT INTO `gen_table_column` VALUES (717, '66', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:26', '', NULL);
INSERT INTO `gen_table_column` VALUES (718, '66', 'order_id', '订单id', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:26', '', NULL);
INSERT INTO `gen_table_column` VALUES (719, '66', 'sku_id', '单品id', 'varchar(32)', 'String', 'skuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:26', '', NULL);
INSERT INTO `gen_table_column` VALUES (720, '66', 'num', '购买的数量', 'int(11)', 'Long', 'num', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (721, '66', 'price', '单品的最终价格（原价－优惠价）', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (722, '66', 'sku_price', '单品的价格', 'decimal(20,2)', 'BigDecimal', 'skuPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (723, '66', 'sku_name', '单品的名称', 'varchar(128)', 'String', 'skuName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (724, '66', 'sku_no', '单品的id', 'varchar(32)', 'String', 'skuNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (725, '66', 'sku_image', '单品的图片', 'varchar(128)', 'String', 'skuImage', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (726, '66', 'sku_specs', '单品的规格', 'varchar(256)', 'String', 'skuSpecs', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (727, '66', 'red_envelope_price', '红包减去的价格', 'decimal(20,2)', 'BigDecimal', 'redEnvelopePrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (728, '67', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (729, '67', 'name', '支付名称', 'varchar(32)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (730, '67', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 3, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (731, '68', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18');
INSERT INTO `gen_table_column` VALUES (732, '68', 'name', '红包名称', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18');
INSERT INTO `gen_table_column` VALUES (733, '68', 'num', '红包生成的个数', 'int(11)', 'Long', 'num', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18');
INSERT INTO `gen_table_column` VALUES (734, '68', 'desc', '描述', 'varchar(1024)', 'String', 'desc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18');
INSERT INTO `gen_table_column` VALUES (735, '68', 'full_price', '满多少钱', 'decimal(20,2)', 'BigDecimal', 'fullPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18');
INSERT INTO `gen_table_column` VALUES (736, '68', 'price', '减多少钱', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18');
INSERT INTO `gen_table_column` VALUES (737, '68', 'starttime', '开始时间', 'timestamp', 'Date', 'starttime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18');
INSERT INTO `gen_table_column` VALUES (738, '68', 'endtime', '结束时间', 'timestamp', 'Date', 'endtime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18');
INSERT INTO `gen_table_column` VALUES (739, '68', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:16:18');
INSERT INTO `gen_table_column` VALUES (740, '69', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:26:40');
INSERT INTO `gen_table_column` VALUES (741, '69', 'red_envelope_id', '门店红包id', 'bigint(20)', 'Long', 'redEnvelopeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:26:40');
INSERT INTO `gen_table_column` VALUES (742, '69', 'code', '红包的卷码', 'varchar(64)', 'String', 'code', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:26:40');
INSERT INTO `gen_table_column` VALUES (743, '69', 'customer_id', '领取红包的会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:26:40');
INSERT INTO `gen_table_column` VALUES (744, '69', 'status', '红包卷状态  0 未领取 1已领取未使用 2 已使用 3已失效', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'redStatus', 5, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:26:40');
INSERT INTO `gen_table_column` VALUES (745, '69', 'receive_time', '领取红包', 'timestamp', 'Date', 'receiveTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-07-27 19:42:27', '', '2020-07-28 08:26:40');
INSERT INTO `gen_table_column` VALUES (746, '70', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (747, '70', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (748, '70', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (749, '70', 'sku_id', '单品id', 'varchar(32)', 'String', 'skuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (750, '70', 'num', '预约数量', 'int(11)', 'Long', 'num', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (751, '70', 'del_flag', '删除标记 0 未删除 1 已删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (752, '70', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (753, '71', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (754, '71', 'name', '角色名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (755, '71', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (756, '71', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (757, '71', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 5, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (758, '72', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (759, '72', 'role_id', '角色id', 'bigint(20)', 'Long', 'roleId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (760, '72', 'authority_id', '权限id', 'bigint(20)', 'Long', 'authorityId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (761, '72', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 4, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (762, '73', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (763, '73', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (764, '73', 'sku_id', '单品id', 'varchar(32)', 'String', 'skuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (765, '73', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (766, '73', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (767, '73', 'num', '数量', 'int(11)', 'Long', 'num', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (768, '73', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (769, '74', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (770, '74', 'store_id', '店铺id  对应ls_store 表中的id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (771, '74', 'cate_id', '签约分类id   三级分类id  ', 'bigint(20)', 'Long', 'cateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (772, '75', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (773, '75', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (774, '75', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (775, '75', 'sku_id', '单品id', 'varchar(32)', 'String', 'skuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (776, '75', 'price', '价格', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (777, '75', 'stock', '库存', 'int(11)', 'Long', 'stock', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (778, '76', 'id', '主键', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (779, '76', 'name', '模板名称', 'varchar(64)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (780, '76', 'template', '编辑模版的json数据', 'longtext', 'String', 'template', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (781, '76', 'release_template', '发布模版的json数据', 'longtext', 'String', 'releaseTemplate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (782, '76', 'is_use', '是否使用  \'1\'使用 默认\'0\' ', 'char(1)', 'String', 'isUse', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (783, '76', 'del_flag', '删除标记 \'1\' 删除  默认 \'0\'', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (784, '76', 'update_time', '更新时间', 'datetime', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (785, '76', 'release_time', '发布时间', 'datetime', 'Date', 'releaseTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (786, '76', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-07-27 19:42:27', '', NULL);
INSERT INTO `gen_table_column` VALUES (787, '77', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (788, '77', 'sender_mail', '发信邮箱', 'varchar(128)', 'String', 'senderMail', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (789, '77', 'sender_name', '发信人', 'varchar(45)', 'String', 'senderName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (790, '77', 'smtp_server', 'SMTP的服务器地址', 'varchar(128)', 'String', 'smtpServer', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (791, '77', 'smtp_port', 'SMTP 的端口', 'int(11)', 'Long', 'smtpPort', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (792, '77', 'username', '邮箱帐号', 'varchar(64)', 'String', 'username', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 6, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (793, '77', 'password', '邮箱密码', 'varchar(64)', 'String', 'password', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (794, '78', 'id', '主键id	', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (795, '78', 'codeType', '支付方式 1:支付宝 2:微信 3:银联 4:预存款 5:微信APP支付 6:微信小程序支付', 'char(1)', 'String', 'codetype', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', '', 2, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (796, '78', 'column_name', '字段名称', 'varchar(128)', 'String', 'columnName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (797, '78', 'column_value', '字段值', 'varchar(2048)', 'String', 'columnValue', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (798, '79', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (799, '79', 'secret', 'AppSecret', 'varchar(128)', 'String', 'secret', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (800, '79', 'url', '短信接口地址', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (801, '79', 'sign', '短信签名', 'varchar(45)', 'String', 'sign', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (802, '79', 'template_id', '模板id', 'varchar(45)', 'String', 'templateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (803, '79', 'writeoff_template_id', '核销门店订单的模版id', 'varchar(45)', 'String', 'writeoffTemplateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (804, '79', 'virtual_order_template_id', '虚拟订单核销的模版id', 'varchar(45)', 'String', 'virtualOrderTemplateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (805, '79', 'key', 'AppKey', 'varchar(128)', 'String', 'key', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (806, '79', 'audit_template_id', '社区团购审核结果通知模版id', 'varchar(64)', 'String', 'auditTemplateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (807, '79', 'settlement_template_id', '社区团购佣金结算模版id', 'varchar(64)', 'String', 'settlementTemplateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (808, '79', 'withdraw_template_id', '社区团购提现打款模版id', 'varchar(64)', 'String', 'withdrawTemplateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 11, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (809, '80', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-28 14:41:53', '', NULL);
INSERT INTO `gen_table_column` VALUES (810, '80', 'allow_back', '是否可以退款和退货  0 可以 1 不可以 默认0 ', 'char(1)', 'String', 'allowBack', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (811, '80', 'aotu_confirm', '订单自定收货几天前的订单 默认1', 'int(11)', 'Long', 'aotuConfirm', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (812, '80', 'refunds_desc', '退款说明', 'text', 'String', 'refundsDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (813, '80', 'return_desc', '退货说明', 'text', 'String', 'returnDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (814, '80', 'cashon_delivery', '是否支持货到付款  0 支付 1 不支持 默认0 ', 'char(1)', 'String', 'cashonDelivery', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (815, '81', 'id', NULL, 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (816, '81', 'name', '团长名称', 'varchar(16)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (817, '81', 'audit', '是否开启审核  0 开启 1 关闭 默认0', 'char(1)', 'String', 'audit', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (818, '81', 'sms_audit_notice', '审核结果通知  0 通知 1 不通知 默认0 ', 'char(1)', 'String', 'smsAuditNotice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (819, '81', 'sms_pay_notice', '打款通知 0 通知 1 不通知默认0 ', 'char(1)', 'String', 'smsPayNotice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (820, '81', 'sms_commission_notice', '佣金结算通知 0 通知 1 不通知默认0 ', 'char(1)', 'String', 'smsCommissionNotice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-28 14:41:54', '', NULL);
INSERT INTO `gen_table_column` VALUES (821, '82', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (822, '82', 'name', '市的名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (823, '82', 'province_id', '该市所属的省份id  对应ls_province 中的id', 'bigint(20)', 'Long', 'provinceId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (824, '82', 'sort', '排序  数值越小 排序越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (825, '82', 'del_flag', '删除标记 0未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (826, '82', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (827, '82', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (828, '82', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (829, '83', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (830, '83', 'name', '区名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (831, '83', 'city_id', '对应ls_city表中的id', 'bigint(20)', 'Long', 'cityId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (832, '83', 'sort', '排序 数值越小 越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (833, '83', 'del_flag', '删除标记  0 未删除 1删除  默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (834, '83', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (835, '83', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (836, '83', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (837, '84', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (838, '84', 'name', '省份的名称', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (839, '84', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (840, '84', 'del_flag', '删除标记 0 未删除 1删除	', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (841, '84', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (842, '84', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (843, '84', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (844, '85', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (845, '85', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (846, '85', 'title', '站内信标题', 'varchar(1024)', 'String', 'title', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'textarea', '', 3, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (847, '85', 'content', '站内信内容', 'varchar(2048)', 'String', 'content', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'textarea', '', 4, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (848, '85', 'is_read', '是否已读  0 未读  1 已读 默认0 ', 'char(1)', 'String', 'isRead', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (849, '85', 'del_flag', '删除标记  0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (850, '85', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (851, '86', 'id', ' 主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (852, '86', 'title', 'seo标题', 'varchar(128)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (853, '86', 'key_word', 'seo关键字', 'varchar(128)', 'String', 'keyWord', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (854, '86', 'seo_desc', 'seo描述', 'varchar(128)', 'String', 'seoDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (855, '86', 'is_open', '是否开启  0 未开启 1 开启 ', 'char(1)', 'String', 'isOpen', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (856, '87', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (857, '87', 'wx_union_id', '微信的联合登录id', 'varchar(64)', 'String', 'wxUnionId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (858, '87', 'customer_id', '用户id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (859, '87', 'wx_open_id', '微信的openid', 'varchar(64)', 'String', 'wxOpenId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (860, '87', 'wx_applet_open_id', '小程序的openid', 'varchar(64)', 'String', 'wxAppletOpenId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-29 10:35:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (861, '88', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (862, '88', 'name', '名称', 'varchar(100)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (863, '88', 'type', '轮播位置', 'int(11)', 'Long', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'banner_type', 3, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (864, '88', 'pic', '图片', 'varchar(500)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 4, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (865, '88', 'start_time', '开始时间', 'datetime', 'Date', 'startTime', '0', '0', NULL, '1', '1', '1', '1', 'GTE', 'datetime', '', 5, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (866, '88', 'end_time', '结束时间', 'datetime', 'Date', 'endTime', '0', '0', NULL, '1', '1', '1', '1', 'LTE', 'datetime', '', 6, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (867, '88', 'status', '上下线状态', 'int(11)', 'Long', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'sys_show_hide', 7, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (868, '88', 'click_count', '点击数', 'int(11)', 'Long', 'clickCount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (869, '88', 'order_count', '位置', 'int(11)', 'Long', 'orderCount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'bannerLocation', 9, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (870, '88', 'url', '链接地址', 'varchar(500)', 'String', 'url', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 10, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (871, '88', 'note', '备注', 'varchar(500)', 'String', 'note', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 11, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (872, '88', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (873, '88', 'store_id', '广告所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:04:09');
INSERT INTO `gen_table_column` VALUES (874, '89', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:52');
INSERT INTO `gen_table_column` VALUES (875, '89', 'brand_id', '品牌', 'bigint(20)', 'Long', 'brandId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:52');
INSERT INTO `gen_table_column` VALUES (876, '89', 'brand_name', '名称', 'varchar(64)', 'String', 'brandName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:52');
INSERT INTO `gen_table_column` VALUES (877, '89', 'recommend_status', '状态', 'int(11)', 'Long', 'recommendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'sys_show_hide', 4, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:52');
INSERT INTO `gen_table_column` VALUES (878, '89', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:52');
INSERT INTO `gen_table_column` VALUES (879, '89', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:52');
INSERT INTO `gen_table_column` VALUES (880, '89', 'logo', '图片', 'varchar(127)', 'String', 'logo', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:52');
INSERT INTO `gen_table_column` VALUES (881, '90', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:07');
INSERT INTO `gen_table_column` VALUES (882, '90', 'product_id', '商品', 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:07');
INSERT INTO `gen_table_column` VALUES (883, '90', 'product_name', '名称', 'varchar(128)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:07');
INSERT INTO `gen_table_column` VALUES (884, '90', 'recommend_status', '状态', 'int(11)', 'Long', 'recommendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'sys_show_hide', 4, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:07');
INSERT INTO `gen_table_column` VALUES (885, '90', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:07');
INSERT INTO `gen_table_column` VALUES (886, '90', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:07');
INSERT INTO `gen_table_column` VALUES (887, '90', 'price', '价格', 'decimal(10,0)', 'Long', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:07');
INSERT INTO `gen_table_column` VALUES (888, '90', 'pic', '图片', 'varchar(127)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:08:07');
INSERT INTO `gen_table_column` VALUES (889, '91', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-08-06 19:11:25', '', '2020-08-08 16:07:11');
INSERT INTO `gen_table_column` VALUES (890, '91', 'product_id', '商品', 'bigint(20)', 'Long', 'productId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:07:11');
INSERT INTO `gen_table_column` VALUES (891, '91', 'product_name', '名称', 'varchar(128)', 'String', 'productName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:07:11');
INSERT INTO `gen_table_column` VALUES (892, '91', 'recommend_status', '状态', 'int(11)', 'Long', 'recommendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'sys_show_hide', 4, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:07:11');
INSERT INTO `gen_table_column` VALUES (893, '91', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:07:11');
INSERT INTO `gen_table_column` VALUES (894, '91', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:07:11');
INSERT INTO `gen_table_column` VALUES (895, '91', 'price', '价格', 'decimal(10,0)', 'Long', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:07:11');
INSERT INTO `gen_table_column` VALUES (896, '91', 'pic', '图片', 'varchar(127)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:07:11');
INSERT INTO `gen_table_column` VALUES (897, '92', 'id', '编号', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:12');
INSERT INTO `gen_table_column` VALUES (898, '92', 'subject_id', '文章', 'bigint(20)', 'Long', 'subjectId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:12');
INSERT INTO `gen_table_column` VALUES (899, '92', 'subject_name', '名称', 'varchar(64)', 'String', 'subjectName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:13');
INSERT INTO `gen_table_column` VALUES (900, '92', 'recommend_status', '状态', 'int(11)', 'Long', 'recommendStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'sys_show_hide', 4, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:13');
INSERT INTO `gen_table_column` VALUES (901, '92', 'sort', '排序', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:13');
INSERT INTO `gen_table_column` VALUES (902, '92', 'store_id', '所属店铺', 'int(11)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:13');
INSERT INTO `gen_table_column` VALUES (903, '92', 'pic', '图片', 'varchar(127)', 'String', 'pic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:13');
INSERT INTO `gen_table_column` VALUES (904, '92', 'read_count', '阅读量', 'int(11)', 'Long', 'readCount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:13');
INSERT INTO `gen_table_column` VALUES (905, '92', 'description', '描述', 'varchar(127)', 'String', 'description', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-08-06 19:11:26', '', '2020-08-08 16:06:13');
INSERT INTO `gen_table_column` VALUES (906, '93', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (907, '93', 'title', '文章标题', 'varchar(128)', 'String', 'title', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (908, '93', 'author', '作者', 'varchar(45)', 'String', 'author', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (909, '93', 'column_id', '文章所属栏目id', 'bigint(20)', 'Long', 'columnId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (910, '93', 'sort', '排序 数值越小 排序越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (911, '93', 'is_release', '是否发布 0 发布 1 不发布  默认0 ', 'char(1)', 'String', 'isRelease', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (912, '93', 'seo_keywords', 'seo关键字', 'varchar(128)', 'String', 'seoKeywords', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (913, '93', 'seo_desc', 'see描述', 'varchar(256)', 'String', 'seoDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (914, '93', 'desc', '文章描述', 'text', 'String', 'desc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (915, '93', 'del_flag', '删除标记 0 未删除 1 删除', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 10, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (916, '93', 'create_time', '生成时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (917, '93', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 12, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (918, '93', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 13, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (919, '94', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (920, '94', 'name', '栏目名称', 'varchar(128)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (921, '94', 'parentId', '上级分类id   0 表示无上级 ', 'bigint(20)', 'Long', 'parentid', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (922, '94', 'sort', '排序 数值越小排序越前', 'int(11)', 'Long', 'sort', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (923, '94', 'is_show', '前端是否显示  0 显示 1 不显示 默认0 ', 'char(1)', 'String', 'isShow', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (924, '94', 'del_flag', '删除标记  0 未删除 1 删除  默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (925, '94', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (926, '94', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (927, '94', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (928, '95', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (929, '95', 'name', '帮助名称', 'varchar(128)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (930, '95', 'sort', '排序 数组', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (931, '95', 'help_cate_id', '帮助分类id', 'bigint(20)', 'Long', 'helpCateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (932, '95', 'is_show', '是否显示 0 显示 1 不显示 默认0 ', 'char(1)', 'String', 'isShow', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (933, '95', 'desc', '帮助内容', 'text', 'String', 'desc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (934, '95', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (935, '95', 'crete_time', '创建时间', 'timestamp', 'Date', 'creteTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (936, '95', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (937, '95', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (938, '96', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (939, '96', 'name', '帮助分类名称', 'varchar(128)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (940, '96', 'sort', '排序 数值越小 排序越前', 'int(11)', 'Long', 'sort', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (941, '96', 'is_show', '是否显示  0 显示 1 不显示 默认0 ', 'char(1)', 'String', 'isShow', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (942, '96', 'del_flag', '删除标记 0未删除 1 删除  默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (943, '96', 'crete_time', '创建时间', 'timestamp', 'Date', 'creteTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (944, '96', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (945, '96', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-08-21 15:50:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (946, '97', 'id', '编号', 'int(11)', 'Long', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-10-19 14:16:23', '', NULL);
INSERT INTO `gen_table_column` VALUES (947, '97', 'user_id', '用户编号', 'int(11)', 'Long', 'userId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-10-19 14:16:23', '', NULL);
INSERT INTO `gen_table_column` VALUES (948, '97', 'user_name', '昵称', 'varchar(255)', 'String', 'userName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-10-19 14:16:23', '', NULL);
INSERT INTO `gen_table_column` VALUES (949, '97', 'step', '步数', 'varchar(255)', 'String', 'step', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-10-19 14:16:23', '', NULL);
INSERT INTO `gen_table_column` VALUES (950, '97', 'create_date', '创建时间', 'datetime', 'Date', 'createDate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 5, 'admin', '2020-10-19 14:16:23', '', NULL);
INSERT INTO `gen_table_column` VALUES (951, '97', 'data', '日期', 'varchar(255)', 'String', 'data', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-10-19 14:16:23', '', NULL);
INSERT INTO `gen_table_column` VALUES (952, '98', 'roomid', '编号', 'int(11)', 'Long', 'roomid', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45');
INSERT INTO `gen_table_column` VALUES (953, '98', 'name', '名称', 'varchar(255)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45');
INSERT INTO `gen_table_column` VALUES (954, '98', 'cover_img', '背景图', 'varchar(255)', 'String', 'coverImg', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45');
INSERT INTO `gen_table_column` VALUES (955, '98', 'share_img', '分享图', 'varchar(255)', 'String', 'shareImg', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45');
INSERT INTO `gen_table_column` VALUES (956, '98', 'live_status', '直播间状态。101：直播中，102：未开始，103已结束，104禁播，105：暂停，106：异常，107：已过期', 'int(10)', 'Integer', 'liveStatus', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 5, 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45');
INSERT INTO `gen_table_column` VALUES (957, '98', 'start_time', '直播间开始时间', 'bigint(20)', 'Long', 'startTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45');
INSERT INTO `gen_table_column` VALUES (958, '98', 'end_time', '直播计划结束时间', 'bigint(20)', 'Long', 'endTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45');
INSERT INTO `gen_table_column` VALUES (959, '98', 'anchor_name', '主播名', 'varchar(255)', 'String', 'anchorName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 8, 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45');
INSERT INTO `gen_table_column` VALUES (960, '98', 'create_time', '创建时间', 'datetime', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-11-01 13:15:52', '', '2020-11-01 13:17:45');

-- ----------------------------
-- Table structure for ls_aliyun_oss_setting
-- ----------------------------
DROP TABLE IF EXISTS `ls_aliyun_oss_setting`;
CREATE TABLE `ls_aliyun_oss_setting`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `access_key_id` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '授权ID',
  `access_key_secret` varchar(60) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '授权密钥',
  `bucket_name` varchar(44) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '桶名',
  `end_point` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '节点名',
  `style_name` varchar(0) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '样式',
  `prefix` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '前缀',
  `address` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '域名地址',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `modify_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '阿里云oss的设置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ls_brand
-- ----------------------------
DROP TABLE IF EXISTS `ls_brand`;
CREATE TABLE `ls_brand`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '品牌名称',
  `nick_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '品牌别名',
  `url` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '品牌的图片地址',
  `certificat_url` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '证书图片',
  `store_id` bigint(20) DEFAULT NULL COMMENT '店铺id 平台的为0 ',
  `status` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '状态  0 申请中  1通过 2 拒绝',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '删除标记 0 未删除 1删除 默认0',
  `reason` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '拒绝原因',
  `create_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者名称',
  `modify_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者名称',
  `del_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除者名称',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '品牌表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ls_city
-- ----------------------------
DROP TABLE IF EXISTS `ls_city`;
CREATE TABLE `ls_city`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '市的名称',
  `province_id` bigint(20) NOT NULL COMMENT '该市所属的省份id  对应ls_province 中的id',
  `sort` int(11) DEFAULT NULL COMMENT '排序  数值越小 排序越前',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记 0未删除 1删除 默认0',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 344 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '区域市表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ls_city
-- ----------------------------
INSERT INTO `ls_city` VALUES (1, '北京市', 1, 1, '0', '2017-05-15 15:27:17', '2017-05-16 01:27:28', NULL);
INSERT INTO `ls_city` VALUES (2, '天津市', 2, 1, '0', '2017-05-15 15:31:30', '2017-11-02 17:28:55', NULL);
INSERT INTO `ls_city` VALUES (3, '石家庄市', 3, 2, '0', '2017-05-15 15:31:40', NULL, NULL);
INSERT INTO `ls_city` VALUES (4, '唐山市', 3, 3, '0', '2017-05-15 15:31:59', NULL, NULL);
INSERT INTO `ls_city` VALUES (5, '秦皇岛市', 3, 231, '0', '2017-05-15 16:18:28', NULL, '0000-00-00 00:00:00');
INSERT INTO `ls_city` VALUES (6, '邯郸市', 3, 4, '0', '2017-06-01 09:43:06', NULL, NULL);
INSERT INTO `ls_city` VALUES (7, '邢台市', 3, 5, '0', '2017-06-01 09:43:13', NULL, NULL);
INSERT INTO `ls_city` VALUES (8, '保定市', 3, 1, '0', '2017-06-01 09:43:34', NULL, NULL);
INSERT INTO `ls_city` VALUES (9, '张家口市', 3, 2, '0', '2017-06-01 09:43:52', NULL, NULL);
INSERT INTO `ls_city` VALUES (10, '承德市', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (11, '沧州市', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (12, '廊坊市', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (13, '衡水市', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (14, '太原市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (15, '大同市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (16, '阳泉市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (17, '长治市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (18, '晋城市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (19, '朔州市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (20, '晋中市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (21, '运城市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (22, '忻州市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (23, '临汾市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (24, '吕梁市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (25, '呼和浩特市', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (26, '包头市', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (27, '乌海市', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (28, '赤峰市', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (29, '通辽市', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (30, '鄂尔多斯市', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (31, '呼伦贝尔市', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (32, '巴彦淖尔市', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (33, '乌兰察布市', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (34, '兴安盟', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (35, '锡林郭勒盟', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (36, '阿拉善盟', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (37, '沈阳市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (38, '大连市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (39, '鞍山市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (40, '抚顺市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (41, '本溪市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (42, '丹东市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (43, '锦州市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (44, '营口市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (45, '阜新市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (46, '辽阳市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (47, '盘锦市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (48, '铁岭市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (49, '朝阳市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (50, '葫芦岛市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (51, '长春市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (52, '吉林市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (53, '四平市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (54, '辽源市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (55, '通化市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (56, '白山市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (57, '松原市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (58, '白城市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (59, '延边朝鲜族自治州', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (60, '哈尔滨市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (61, '齐齐哈尔市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (62, '鸡西市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (63, '鹤岗市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (64, '双鸭山市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (65, '大庆市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (66, '伊春市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (67, '佳木斯市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (68, '七台河市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (69, '牡丹江市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (70, '黑河市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (71, '绥化市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (72, '大兴安岭地区', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (73, '上海市', 9, 1, '0', NULL, '2017-11-02 17:28:46', NULL);
INSERT INTO `ls_city` VALUES (74, '南京市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (75, '无锡市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (76, '徐州市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (77, '常州市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (78, '苏州市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (79, '南通市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (80, '连云港市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (81, '淮安市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (82, '盐城市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (83, '扬州市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (84, '镇江市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (85, '泰州市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (86, '宿迁市', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (87, '杭州市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (88, '宁波市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (89, '温州市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (90, '嘉兴市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (91, '湖州市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (92, '绍兴市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (93, '金华市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (94, '衢州市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (95, '舟山市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (96, '台州市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (97, '丽水市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (98, '合肥市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (99, '芜湖市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (100, '蚌埠市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (101, '淮南市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (102, '马鞍山市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (103, '淮北市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (104, '铜陵市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (105, '安庆市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (106, '黄山市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (107, '滁州市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (108, '阜阳市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (109, '宿州市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (110, '巢湖市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (111, '六安市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (112, '亳州市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (113, '池州市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (114, '宣城市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (115, '福州市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (116, '厦门市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (117, '莆田市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (118, '三明市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (119, '泉州市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (120, '漳州市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (121, '南平市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (122, '龙岩市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (123, '宁德市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (124, '南昌市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (125, '景德镇市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (126, '萍乡市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (127, '九江市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (128, '新余市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (129, '鹰潭市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (130, '赣州市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (131, '吉安市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (132, '宜春市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (133, '抚州市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (134, '上饶市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (135, '济南市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (136, '青岛市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (137, '淄博市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (138, '枣庄市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (139, '东营市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (140, '烟台市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (141, '潍坊市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (142, '济宁市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (143, '泰安市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (144, '威海市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (145, '日照市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (146, '莱芜市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (147, '临沂市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (148, '德州市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (149, '聊城市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (150, '滨州市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (151, '菏泽市', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (152, '郑州市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (153, '开封市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (154, '洛阳市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (155, '平顶山市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (156, '安阳市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (157, '鹤壁市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (158, '新乡市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (159, '焦作市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (160, '濮阳市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (161, '许昌市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (162, '漯河市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (163, '三门峡市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (164, '南阳市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (165, '商丘市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (166, '信阳市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (167, '周口市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (168, '驻马店市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (169, '济源市', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (170, '武汉市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (171, '黄石市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (172, '十堰市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (173, '宜昌市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (174, '襄樊市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (175, '鄂州市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (176, '荆门市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (177, '孝感市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (178, '荆州市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (179, '黄冈市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (180, '咸宁市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (181, '随州市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (182, '恩施土家族苗族自治州', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (183, '省直辖县级行政单位', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (184, '长沙市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (185, '株洲市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (186, '湘潭市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (187, '衡阳市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (188, '邵阳市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (189, '岳阳市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (190, '常德市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (191, '张家界市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (192, '益阳市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (193, '郴州市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (194, '永州市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (195, '怀化市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (196, '娄底市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (197, '湘西土家族苗族自治州', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (198, '广州市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (199, '韶关市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (200, '深圳市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (201, '珠海市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (202, '汕头市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (203, '佛山市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (204, '江门市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (205, '湛江市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (206, '茂名市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (207, '肇庆市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (208, '惠州市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (209, '梅州市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (210, '汕尾市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (211, '河源市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (212, '阳江市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (213, '清远市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (214, '东莞市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (215, '中山市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (216, '潮州市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (217, '揭阳市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (218, '云浮市', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (219, '南宁市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (220, '柳州市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (221, '桂林市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (222, '梧州市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (223, '北海市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (224, '防城港市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (225, '钦州市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (226, '贵港市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (227, '玉林市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (228, '百色市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (229, '贺州市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (230, '河池市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (231, '来宾市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (232, '崇左市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (233, '海口市', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (234, '三亚市', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (235, '省直辖县级行政单位', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (236, '重庆市', 22, 1, '0', NULL, '2017-11-02 17:28:30', NULL);
INSERT INTO `ls_city` VALUES (237, '成都市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (238, '自贡市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (239, '攀枝花市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (240, '泸州市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (241, '德阳市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (242, '绵阳市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (243, '广元市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (244, '遂宁市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (245, '内江市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (246, '乐山市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (247, '南充市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (248, '眉山市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (249, '宜宾市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (250, '广安市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (251, '达州市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (252, '雅安市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (253, '巴中市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (254, '资阳市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (255, '阿坝藏族羌族自治州', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (256, '甘孜藏族自治州', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (257, '凉山彝族自治州', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (258, '贵阳市', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (259, '六盘水市', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (260, '遵义市', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (261, '安顺市', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (262, '铜仁地区', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (263, '黔西南布依族苗族自治州', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (264, '毕节地区', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (265, '黔东南苗族侗族自治州', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (266, '黔南布依族苗族自治州', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (267, '昆明市', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (268, '曲靖市', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (269, '玉溪市', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (270, '保山市', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (271, '昭通市', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (272, '丽江市', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (273, '普洱市', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (274, '临沧市', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (275, '楚雄彝族自治州', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (276, '红河哈尼族彝族自治州', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (277, '文山壮族苗族自治州', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (278, '西双版纳傣族自治州', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (279, '大理白族自治州', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (280, '德宏傣族景颇族自治州', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (281, '怒江傈僳族自治州', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (282, '迪庆藏族自治州', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (283, '拉萨市', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (284, '昌都地区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (285, '山南地区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (286, '日喀则地区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (287, '那曲地区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (288, '阿里地区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (289, '林芝地区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (290, '西安市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (291, '铜川市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (292, '宝鸡市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (293, '咸阳市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (294, '渭南市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (295, '延安市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (296, '汉中市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (297, '榆林市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (298, '安康市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (299, '商洛市', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (300, '兰州市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (301, '嘉峪关市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (302, '金昌市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (303, '白银市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (304, '天水市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (305, '武威市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (306, '张掖市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (307, '平凉市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (308, '酒泉市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (309, '庆阳市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (310, '定西市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (311, '陇南市', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (312, '临夏回族自治州', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (313, '甘南藏族自治州', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (314, '西宁市', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (315, '海东地区', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (316, '海北藏族自治州', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (317, '黄南藏族自治州', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (318, '海南藏族自治州', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (319, '果洛藏族自治州', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (320, '玉树藏族自治州', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (321, '海西蒙古族藏族自治州', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (322, '银川市', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (323, '石嘴山市', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (324, '吴忠市', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (325, '固原市', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (326, '中卫市', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (327, '乌鲁木齐市', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (328, '克拉玛依市', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (329, '吐鲁番地区', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (330, '哈密地区', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (331, '昌吉回族自治州', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (332, '博尔塔拉蒙古自治州', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (333, '巴音郭楞蒙古自治州', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (334, '阿克苏地区', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (335, '克孜勒苏柯尔克孜自治州', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (336, '喀什地区', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (337, '和田地区', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (338, '伊犁哈萨克自治州', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (339, '塔城地区', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (340, '阿勒泰地区', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_city` VALUES (341, '自治区直辖县级行政单位', 31, 0, '0', NULL, '2017-11-22 09:10:25', NULL);
INSERT INTO `ls_city` VALUES (342, '香港', 32, 1, '0', NULL, '2017-11-02 17:27:39', NULL);
INSERT INTO `ls_city` VALUES (343, '澳门', 33, 1, '0', NULL, '2017-11-02 17:23:08', NULL);

-- ----------------------------
-- Table structure for ls_district
-- ----------------------------
DROP TABLE IF EXISTS `ls_district`;
CREATE TABLE `ls_district`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '区名称',
  `city_id` bigint(20) NOT NULL COMMENT '对应ls_city表中的id',
  `sort` int(11) DEFAULT NULL COMMENT '排序 数值越小 越前',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记  0 未删除 1删除  默认0',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3106 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '区域区表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ls_district
-- ----------------------------
INSERT INTO `ls_district` VALUES (1, '东城区', 1, 1, '0', '2017-05-15 15:38:14', '2017-05-16 01:27:36', '2019-06-04 14:48:16');
INSERT INTO `ls_district` VALUES (2, '西城区', 1, 2, '0', '2017-05-15 15:38:24', NULL, NULL);
INSERT INTO `ls_district` VALUES (3, '崇文区', 1, 1, '0', '2017-05-15 16:14:34', NULL, '2019-06-04 14:48:19');
INSERT INTO `ls_district` VALUES (4, '宣武区', 1, 1, '0', '2017-05-26 14:05:23', NULL, NULL);
INSERT INTO `ls_district` VALUES (5, '朝阳区', 1, 2, '0', '2017-05-26 14:05:31', NULL, NULL);
INSERT INTO `ls_district` VALUES (6, '丰台区', 1, 1, '0', '2017-05-27 10:36:50', NULL, NULL);
INSERT INTO `ls_district` VALUES (7, '石景山区', 1, 2, '0', '2017-05-27 10:37:01', NULL, NULL);
INSERT INTO `ls_district` VALUES (8, '海淀区', 1, 2, '0', '2017-06-01 09:42:16', NULL, NULL);
INSERT INTO `ls_district` VALUES (9, '门头沟区', 1, 3, '0', '2017-06-01 09:42:32', NULL, NULL);
INSERT INTO `ls_district` VALUES (10, '房山区', 1, 1, '0', '2017-06-01 09:44:13', NULL, NULL);
INSERT INTO `ls_district` VALUES (11, '通州区', 1, 2, '0', '2017-06-01 09:44:32', NULL, NULL);
INSERT INTO `ls_district` VALUES (12, '顺义区', 1, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (13, '昌平区', 1, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (14, '大兴区', 1, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (15, '怀柔区', 1, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (16, '平谷区', 1, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (17, '密云县', 1, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (18, '延庆县', 1, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (19, '和平区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (20, '河东区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (21, '河西区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (22, '南开区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (23, '河北区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (24, '红桥区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (25, '塘沽区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (26, '汉沽区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (27, '大港区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (28, '东丽区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (29, '西青区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (30, '津南区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (31, '北辰区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (32, '武清区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (33, '宝坻区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (34, '宁河县', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (35, '静海县', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (36, '蓟县', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (37, '保税区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (38, '经济技术开发区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (39, '高新区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (40, '滨海新区', 2, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (41, '长安区', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (42, '桥东区', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (43, '桥西区', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (44, '新华区', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (45, '井陉矿区', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (46, '裕华区', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (47, '井陉县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (48, '正定县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (49, '栾城县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (50, '行唐县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (51, '灵寿县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (52, '高邑县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (53, '深泽县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (54, '赞皇县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (55, '无极县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (56, '平山县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (57, '元氏县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (58, '赵县', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (59, '辛集市', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (60, '藁城市', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (61, '晋州市', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (62, '新乐市', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (63, '鹿泉市', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (64, '高新技术开发区', 3, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (65, '路南区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (66, '路北区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (67, '古冶区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (68, '开平区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (69, '丰南区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (70, '丰润区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (71, '滦县', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (72, '滦南县', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (73, '乐亭县', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (74, '迁西县', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (75, '玉田县', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (76, '唐海县', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (77, '遵化市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (78, '迁安市', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (79, '高新区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (80, '汉沽管理区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (81, '海港开发区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (82, '芦台开发区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (83, '南堡开发区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (84, '曹妃甸工业区', 4, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (85, '海港区', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (86, '山海关区', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (87, '北戴河区', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (88, '青龙满族自治县', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (89, '昌黎县', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (90, '抚宁县', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (91, '卢龙县', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (92, '经济技术开发区', 5, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (93, '邯山区', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (94, '丛台区', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (95, '复兴区', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (96, '峰峰矿区', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (97, '邯郸县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (98, '临漳县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (99, '成安县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (100, '大名县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (101, '涉县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (102, '磁县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (103, '肥乡县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (104, '永年县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (105, '邱县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (106, '鸡泽县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (107, '广平县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (108, '馆陶县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (109, '魏县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (110, '曲周县', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (111, '武安市', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (112, '经济开发区', 6, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (113, '桥东区', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (114, '桥西区', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (115, '邢台县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (116, '临城县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (117, '内丘县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (118, '柏乡县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (119, '隆尧县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (120, '任县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (121, '南和县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (122, '宁晋县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (123, '巨鹿县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (124, '新河县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (125, '广宗县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (126, '平乡县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (127, '威县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (128, '清河县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (129, '临西县', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (130, '南宫市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (131, '沙河市', 7, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (132, '新市区', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (133, '南市区', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (134, '北市区', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (135, '满城县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (136, '清苑县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (137, '涞水县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (138, '阜平县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (139, '徐水县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (140, '定兴县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (141, '唐县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (142, '高阳县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (143, '容城县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (144, '涞源县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (145, '望都县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (146, '安新县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (147, '易县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (148, '曲阳县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (149, '蠡县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (150, '顺平县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (151, '博野县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (152, '雄县', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (153, '涿州市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (154, '定州市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (155, '安国市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (156, '高碑店市', 8, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (157, '桥东区', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (158, '桥西区', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (159, '宣化区', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (160, '下花园区', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (161, '宣化县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (162, '张北县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (163, '康保县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (164, '沽源县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (165, '尚义县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (166, '蔚县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (167, '阳原县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (168, '怀安县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (169, '万全县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (170, '怀来县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (171, '涿鹿县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (172, '赤城县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (173, '崇礼县', 9, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (174, '双桥区', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (175, '双滦区', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (176, '鹰手营子矿区', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (177, '承德县', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (178, '兴隆县', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (179, '平泉县', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (180, '滦平县', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (181, '隆化县', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (182, '丰宁满族自治县', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (183, '宽城满族自治县', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (184, '围场满族蒙古族自治县', 10, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (185, '新华区', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (186, '运河区', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (187, '沧县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (188, '青县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (189, '东光县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (190, '海兴县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (191, '盐山县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (192, '肃宁县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (193, '南皮县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (194, '吴桥县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (195, '献县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (196, '孟村回族自治县', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (197, '泊头市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (198, '任丘市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (199, '黄骅市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (200, '河间市', 11, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (201, '安次区', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (202, '广阳区', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (203, '固安县', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (204, '永清县', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (205, '香河县', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (206, '大城县', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (207, '文安县', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (208, '大厂回族自治县', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (209, '霸州市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (210, '三河市', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (211, '开发区', 12, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (212, '桃城区', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (213, '枣强县', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (214, '武邑县', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (215, '武强县', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (216, '饶阳县', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (217, '安平县', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (218, '故城县', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (219, '景县', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (220, '阜城县', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (221, '冀州市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (222, '深州市', 13, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (223, '小店区', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (224, '迎泽区', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (225, '杏花岭区', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (226, '尖草坪区', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (227, '万柏林区', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (228, '晋源区', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (229, '清徐县', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (230, '阳曲县', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (231, '娄烦县', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (232, '古交市', 14, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (233, '城区', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (234, '矿区', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (235, '南郊区', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (236, '新荣区', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (237, '阳高县', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (238, '天镇县', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (239, '广灵县', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (240, '灵丘县', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (241, '浑源县', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (242, '左云县', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (243, '大同县', 15, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (244, '城区', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (245, '矿区', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (246, '郊区', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (247, '平定县', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (248, '盂县', 16, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (249, '城区', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (250, '郊区', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (251, '长治县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (252, '襄垣县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (253, '屯留县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (254, '平顺县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (255, '黎城县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (256, '壶关县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (257, '长子县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (258, '武乡县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (259, '沁县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (260, '沁源县', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (261, '潞城市', 17, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (262, '城区', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (263, '沁水县', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (264, '阳城县', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (265, '陵川县', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (266, '泽州县', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (267, '高平市', 18, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (268, '朔城区', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (269, '平鲁区', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (270, '山阴县', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (271, '应县', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (272, '右玉县', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (273, '怀仁县', 19, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (274, '榆次区', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (275, '榆社县', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (276, '左权县', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (277, '和顺县', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (278, '昔阳县', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (279, '寿阳县', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (280, '太谷县', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (281, '祁县', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (282, '平遥县', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (283, '灵石县', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (284, '介休市', 20, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (285, '盐湖区', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (286, '临猗县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (287, '万荣县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (288, '闻喜县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (289, '稷山县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (290, '新绛县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (291, '绛县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (292, '垣曲县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (293, '夏县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (294, '平陆县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (295, '芮城县', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (296, '永济市', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (297, '河津市', 21, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (298, '忻府区', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (299, '定襄县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (300, '五台县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (301, '代县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (302, '繁峙县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (303, '宁武县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (304, '静乐县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (305, '神池县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (306, '五寨县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (307, '岢岚县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (308, '河曲县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (309, '保德县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (310, '偏关县', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (311, '原平市', 22, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (312, '尧都区', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (313, '曲沃县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (314, '翼城县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (315, '襄汾县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (316, '洪洞县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (317, '古县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (318, '安泽县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (319, '浮山县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (320, '吉县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (321, '乡宁县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (322, '大宁县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (323, '隰县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (324, '永和县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (325, '蒲县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (326, '汾西县', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (327, '侯马市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (328, '霍州市', 23, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (329, '离石区', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (330, '文水县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (331, '交城县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (332, '兴县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (333, '临县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (334, '柳林县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (335, '石楼县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (336, '岚县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (337, '方山县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (338, '中阳县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (339, '交口县', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (340, '孝义市', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (341, '汾阳市', 24, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (342, '回民区', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (343, '玉泉区', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (344, '新城区', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (345, '赛罕区', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (346, '土默特左旗', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (347, '托克托县', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (348, '和林格尔县', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (349, '清水河县', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (350, '武川县', 25, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (351, '东河区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (352, '昆都仑区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (353, '青山区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (354, '石拐区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (355, '白云矿区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (356, '九原区', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (357, '土默特右旗', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (358, '固阳县', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (359, '达尔罕茂明安联合旗', 26, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (360, '海勃湾区', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (361, '海南区', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (362, '乌达区', 27, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (363, '红山区', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (364, '元宝山区', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (365, '松山区', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (366, '阿鲁科尔沁旗', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (367, '巴林左旗', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (368, '巴林右旗', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (369, '林西县', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (370, '克什克腾旗', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (371, '翁牛特旗', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (372, '喀喇沁旗', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (373, '宁城县', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (374, '敖汉旗', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (375, '新城区', 28, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (376, '科尔沁区', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (377, '科尔沁左翼中旗', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (378, '科尔沁左翼后旗', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (379, '开鲁县', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (380, '库伦旗', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (381, '奈曼旗', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (382, '扎鲁特旗', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (383, '霍林郭勒市', 29, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (384, '东胜区', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (385, '达拉特旗', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (386, '准格尔旗', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (387, '鄂托克前旗', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (388, '鄂托克旗', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (389, '杭锦旗', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (390, '乌审旗', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (391, '伊金霍洛旗', 30, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (392, '海拉尔区', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (393, '阿荣旗', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (394, '莫力达瓦达斡尔族自治旗', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (395, '鄂伦春自治旗', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (396, '鄂温克族自治旗', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (397, '陈巴尔虎旗', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (398, '新巴尔虎左旗', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (399, '新巴尔虎右旗', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (400, '满洲里市', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (401, '牙克石市', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (402, '扎兰屯市', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (403, '额尔古纳市', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (404, '根河市', 31, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (405, '临河区', 32, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (406, '五原县', 32, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (407, '磴口县', 32, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (408, '乌拉特前旗', 32, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (409, '乌拉特中旗', 32, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (410, '乌拉特后旗', 32, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (411, '杭锦后旗', 32, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (412, '集宁区', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (413, '卓资县', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (414, '化德县', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (415, '商都县', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (416, '兴和县', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (417, '凉城县', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (418, '察哈尔右翼前旗', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (419, '察哈尔右翼中旗', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (420, '察哈尔右翼后旗', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (421, '四子王旗', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (422, '丰镇市', 33, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (423, '乌兰浩特市', 34, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (424, '阿尔山市', 34, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (425, '科尔沁右翼前旗', 34, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (426, '科尔沁右翼中旗', 34, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (427, '扎赉特旗', 34, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (428, '突泉县', 34, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (429, '二连浩特市', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (430, '锡林浩特市', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (431, '阿巴嘎旗', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (432, '苏尼特左旗', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (433, '苏尼特右旗', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (434, '东乌珠穆沁旗', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (435, '西乌珠穆沁旗', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (436, '太仆寺旗', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (437, '镶黄旗', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (438, '正镶白旗', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (439, '正蓝旗', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (440, '多伦县', 35, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (441, '阿拉善左旗', 36, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (442, '阿拉善右旗', 36, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (443, '额济纳旗', 36, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (444, '和平区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (445, '沈河区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (446, '大东区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (447, '皇姑区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (448, '铁西区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (449, '苏家屯区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (450, '东陵区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (451, '沈北新区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (452, '于洪区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (453, '辽中县', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (454, '康平县', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (455, '法库县', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (456, '新民市', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (457, '经济技术开发区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (458, '浑南新区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (459, '新城子经济技术开发区', 37, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (460, '中山区', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (461, '西岗区', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (462, '沙河口区', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (463, '甘井子区', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (464, '旅顺口区', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (465, '金州区', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (466, '长海县', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (467, '瓦房店市', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (468, '普兰店市', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (469, '庄河市', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (470, '开发区', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (471, '保税区', 38, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (472, '铁东区', 39, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (473, '铁西区', 39, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (474, '立山区', 39, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (475, '千山区', 39, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (476, '台安县', 39, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (477, '岫岩满族自治县', 39, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (478, '海城市', 39, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (479, '新抚区', 40, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (480, '东洲区', 40, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (481, '望花区', 40, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (482, '顺城区', 40, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (483, '抚顺县', 40, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (484, '新宾满族自治县', 40, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (485, '清原满族自治县', 40, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (486, '平山区', 41, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (487, '明山区', 41, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (488, '溪湖区', 41, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (489, '南芬区', 41, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (490, '本溪满族自治县', 41, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (491, '桓仁满族自治县', 41, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (492, '元宝区', 42, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (493, '振兴区', 42, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (494, '振安区', 42, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (495, '宽甸满族自治县', 42, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (496, '东港市', 42, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (497, '凤城市', 42, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (498, '古塔区', 43, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (499, '凌河区', 43, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (500, '太和区', 43, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (501, '黑山县', 43, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (502, '义县', 43, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (503, '凌海市', 43, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (504, '北宁市', 43, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (505, '松山新区', 43, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (506, '经济技术开发区', 43, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (507, '站前区', 44, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (508, '西市区', 44, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (509, '鲅鱼圈区', 44, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (510, '老边区', 44, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (511, '盖州市', 44, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (512, '大石桥市', 44, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (513, '海州区', 45, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (514, '新邱区', 45, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (515, '太平区', 45, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (516, '清河门区', 45, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (517, '细河区', 45, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (518, '阜新蒙古族自治县', 45, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (519, '彰武县', 45, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (520, '白塔区', 46, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (521, '文圣区', 46, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (522, '宏伟区', 46, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (523, '弓长岭区', 46, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (524, '太子河区', 46, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (525, '辽阳县', 46, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (526, '灯塔市', 46, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (527, '双台子区', 47, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (528, '兴隆台区', 47, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (529, '大洼县', 47, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (530, '盘山县', 47, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (531, '银州区', 48, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (532, '清河区', 48, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (533, '铁岭县', 48, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (534, '西丰县', 48, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (535, '昌图县', 48, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (536, '调兵山市', 48, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (537, '开原市', 48, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (538, '双塔区', 49, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (539, '龙城区', 49, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (540, '朝阳县', 49, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (541, '建平县', 49, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (542, '喀喇沁左翼蒙古族自治县', 49, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (543, '北票市', 49, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (544, '凌源市', 49, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (545, '连山区', 50, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (546, '龙港区', 50, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (547, '南票区', 50, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (548, '绥中县', 50, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (549, '建昌县', 50, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (550, '兴城市', 50, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (551, '南关区', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (552, '宽城区', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (553, '朝阳区', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (554, '二道区', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (555, '绿园区', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (556, '双阳区', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (557, '农安县', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (558, '九台市', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (559, '榆树市', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (560, '德惠市', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (561, '净月经济开发区', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (562, '高新技术产业开发区', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (563, '经济技术开发区', 51, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (564, '昌邑区', 52, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (565, '龙潭区', 52, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (566, '船营区', 52, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (567, '丰满区', 52, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (568, '永吉县', 52, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (569, '蛟河市', 52, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (570, '桦甸市', 52, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (571, '舒兰市', 52, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (572, '磐石市', 52, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (573, '铁西区', 53, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (574, '铁东区', 53, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (575, '梨树县', 53, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (576, '伊通满族自治县', 53, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (577, '公主岭市', 53, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (578, '双辽市', 53, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (579, '龙山区', 54, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (580, '西安区', 54, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (581, '东丰县', 54, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (582, '东辽县', 54, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (583, '东昌区', 55, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (584, '二道江区', 55, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (585, '通化县', 55, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (586, '辉南县', 55, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (587, '柳河县', 55, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (588, '梅河口市', 55, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (589, '集安市', 55, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (590, '八道江区', 56, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (591, '抚松县', 56, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (592, '靖宇县', 56, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (593, '长白朝鲜族自治县', 56, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (594, '江源县', 56, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (595, '临江市', 56, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (596, '宁江区', 57, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (597, '前郭尔罗斯蒙古族自治县', 57, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (598, '长岭县', 57, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (599, '乾安县', 57, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (600, '扶余县', 57, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (601, '洮北区', 58, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (602, '镇赉县', 58, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (603, '通榆县', 58, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (604, '洮南市', 58, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (605, '大安市', 58, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (606, '延吉市', 59, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (607, '图们市', 59, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (608, '敦化市', 59, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (609, '珲春市', 59, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (610, '龙井市', 59, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (611, '和龙市', 59, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (612, '汪清县', 59, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (613, '安图县', 59, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (614, '道里区', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (615, '南岗区', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (616, '道外区', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (617, '香坊区', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (618, '动力区', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (619, '平房区', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (620, '松北区', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (621, '呼兰区', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (622, '依兰县', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (623, '方正县', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (624, '宾县', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (625, '巴彦县', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (626, '木兰县', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (627, '通河县', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (628, '延寿县', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (629, '阿城市', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (630, '双城市', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (631, '尚志市', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (632, '五常市', 60, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (633, '龙沙区', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (634, '建华区', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (635, '铁锋区', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (636, '昂昂溪区', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (637, '富拉尔基区', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (638, '碾子山区', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (639, '梅里斯达斡尔族区', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (640, '龙江县', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (641, '依安县', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (642, '泰来县', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (643, '甘南县', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (644, '富裕县', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (645, '克山县', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (646, '克东县', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (647, '拜泉县', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (648, '讷河市', 61, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (649, '鸡冠区', 62, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (650, '恒山区', 62, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (651, '滴道区', 62, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (652, '梨树区', 62, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (653, '城子河区', 62, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (654, '麻山区', 62, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (655, '鸡东县', 62, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (656, '虎林市', 62, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (657, '密山市', 62, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (658, '向阳区', 63, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (659, '工农区', 63, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (660, '南山区', 63, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (661, '兴安区', 63, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (662, '东山区', 63, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (663, '兴山区', 63, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (664, '萝北县', 63, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (665, '绥滨县', 63, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (666, '尖山区', 64, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (667, '岭东区', 64, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (668, '四方台区', 64, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (669, '宝山区', 64, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (670, '集贤县', 64, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (671, '友谊县', 64, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (672, '宝清县', 64, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (673, '饶河县', 64, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (674, '萨尔图区', 65, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (675, '龙凤区', 65, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (676, '让胡路区', 65, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (677, '红岗区', 65, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (678, '大同区', 65, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (679, '肇州县', 65, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (680, '肇源县', 65, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (681, '林甸县', 65, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (682, '杜尔伯特蒙古族自治县', 65, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (683, '伊春区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (684, '南岔区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (685, '友好区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (686, '西林区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (687, '翠峦区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (688, '新青区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (689, '美溪区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (690, '金山屯区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (691, '五营区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (692, '乌马河区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (693, '汤旺河区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (694, '带岭区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (695, '乌伊岭区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (696, '红星区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (697, '上甘岭区', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (698, '嘉荫县', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (699, '铁力市', 66, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (700, '向阳区', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (701, '前进区', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (702, '东风区', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (703, '郊区', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (704, '桦南县', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (705, '桦川县', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (706, '汤原县', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (707, '抚远县', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (708, '同江市', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (709, '富锦市', 67, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (710, '新兴区', 68, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (711, '桃山区', 68, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (712, '茄子河区', 68, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (713, '勃利县', 68, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (714, '东安区', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (715, '爱民区', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (716, '阳明区', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (717, '西安区', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (718, '东宁县', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (719, '林口县', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (720, '绥芬河市', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (721, '海林市', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (722, '宁安市', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (723, '穆棱市', 69, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (724, '爱辉区', 70, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (725, '嫩江县', 70, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (726, '逊克县', 70, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (727, '孙吴县', 70, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (728, '北安市', 70, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (729, '五大连池市', 70, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (730, '北林区', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (731, '望奎县', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (732, '兰西县', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (733, '青冈县', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (734, '庆安县', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (735, '明水县', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (736, '绥棱县', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (737, '安达市', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (738, '肇东市', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (739, '海伦市', 71, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (740, '呼玛县', 72, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (741, '塔河县', 72, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (742, '漠河县', 72, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (743, '加格达奇区', 72, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (744, '松岭区', 72, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (745, '新林区', 72, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (746, '呼中区', 72, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (747, '黄浦区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (748, '卢湾区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (749, '徐汇区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (750, '长宁区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (751, '静安区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (752, '普陀区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (753, '闸北区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (754, '虹口区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (755, '杨浦区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (756, '闵行区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (757, '宝山区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (758, '嘉定区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (759, '浦东新区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (760, '金山区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (761, '松江区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (762, '青浦区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (763, '南汇区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (764, '奉贤区', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (765, '崇明县', 73, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (766, '玄武区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (767, '白下区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (768, '秦淮区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (769, '建邺区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (770, '鼓楼区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (771, '下关区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (772, '浦口区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (773, '栖霞区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (774, '雨花台区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (775, '江宁区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (776, '六合区', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (777, '溧水县', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (778, '高淳县', 74, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (779, '崇安区', 75, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (780, '南长区', 75, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (781, '北塘区', 75, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (782, '锡山区', 75, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (783, '惠山区', 75, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (784, '滨湖区', 75, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (785, '江阴市', 75, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (786, '宜兴市', 75, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (787, '新区', 75, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (788, '云龙区', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (789, '鼓楼区', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (790, '九里区', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (791, '泉山区', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (792, '铜山县', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (793, '贾汪区', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (794, '丰县', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (795, '沛县', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (796, '睢宁县', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (797, '新沂市', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (798, '邳州市', 76, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (799, '天宁区', 77, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (800, '钟楼区', 77, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (801, '戚墅堰区', 77, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (802, '新北区', 77, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (803, '武进区', 77, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (804, '溧阳市', 77, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (805, '金坛市', 77, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (806, '沧浪区', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (807, '平江区', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (808, '金阊区', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (809, '虎丘区', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (810, '吴中区', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (811, '相城区', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (812, '常熟市', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (813, '张家港市', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (814, '昆山市', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (815, '吴江市', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (816, '太仓市', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (817, '工业园区', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (818, '高新区', 78, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (819, '崇川区', 79, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (820, '港闸区', 79, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (821, '海安县', 79, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (822, '如东县', 79, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (823, '启东市', 79, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (824, '如皋市', 79, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (825, '通州市', 79, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (826, '海门市', 79, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (827, '经济技术开发区', 79, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (828, '连云区', 80, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (829, '新浦区', 80, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (830, '海州区', 80, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (831, '赣榆县', 80, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (832, '东海县', 80, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (833, '灌云县', 80, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (834, '灌南县', 80, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (835, '清河区', 81, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (836, '楚州区', 81, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (837, '淮阴区', 81, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (838, '清浦区', 81, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (839, '涟水县', 81, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (840, '洪泽县', 81, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (841, '盱眙县', 81, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (842, '金湖县', 81, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (843, '亭湖区', 82, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (844, '盐都区', 82, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (845, '响水县', 82, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (846, '滨海县', 82, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (847, '阜宁县', 82, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (848, '射阳县', 82, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (849, '建湖县', 82, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (850, '东台市', 82, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (851, '大丰市', 82, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (852, '广陵区', 83, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (853, '邗江区', 83, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (854, '宝应县', 83, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (855, '仪征市', 83, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (856, '高邮市', 83, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (857, '江都市', 83, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (858, '维扬区', 83, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (859, '经济开发区', 83, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (860, '京口区', 84, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (861, '润州区', 84, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (862, '丹徒区', 84, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (863, '丹阳市', 84, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (864, '扬中市', 84, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (865, '句容市', 84, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (866, '新区', 84, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (867, '海陵区', 85, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (868, '高港区', 85, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (869, '兴化市', 85, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (870, '靖江市', 85, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (871, '泰兴市', 85, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (872, '姜堰市', 85, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (873, '宿城区', 86, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (874, '宿豫区', 86, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (875, '沭阳县', 86, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (876, '泗阳县', 86, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (877, '泗洪县', 86, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (878, '上城区', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (879, '下城区', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (880, '江干区', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (881, '拱墅区', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (882, '西湖区', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (883, '滨江区', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (884, '萧山区', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (885, '余杭区', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (886, '桐庐县', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (887, '淳安县', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (888, '建德市', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (889, '富阳市', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (890, '临安市', 87, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (891, '海曙区', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (892, '江东区', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (893, '江北区', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (894, '北仑区', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (895, '镇海区', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (896, '鄞州区', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (897, '象山县', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (898, '宁海县', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (899, '余姚市', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (900, '慈溪市', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (901, '奉化市', 88, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (902, '鹿城区', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (903, '龙湾区', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (904, '瓯海区', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (905, '洞头县', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (906, '永嘉县', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (907, '平阳县', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (908, '苍南县', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (909, '文成县', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (910, '泰顺县', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (911, '瑞安市', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (912, '乐清市', 89, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (913, '秀洲区', 90, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (914, '嘉善县', 90, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (915, '海盐县', 90, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (916, '海宁市', 90, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (917, '平湖市', 90, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (918, '桐乡市', 90, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (919, '南湖区', 90, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (920, '吴兴区', 91, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (921, '南浔区', 91, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (922, '德清县', 91, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (923, '长兴县', 91, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (924, '安吉县', 91, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (925, '越城区', 92, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (926, '绍兴县', 92, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (927, '新昌县', 92, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (928, '诸暨市', 92, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (929, '上虞市', 92, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (930, '嵊州市', 92, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (931, '婺城区', 93, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (932, '金东区', 93, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (933, '武义县', 93, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (934, '浦江县', 93, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (935, '磐安县', 93, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (936, '兰溪市', 93, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (937, '义乌市', 93, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (938, '东阳市', 93, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (939, '永康市', 93, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (940, '柯城区', 94, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (941, '衢江区', 94, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (942, '常山县', 94, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (943, '开化县', 94, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (944, '龙游县', 94, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (945, '江山市', 94, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (946, '定海区', 95, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (947, '普陀区', 95, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (948, '岱山县', 95, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (949, '嵊泗县', 95, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (950, '椒江区', 96, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (951, '路桥区', 96, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (952, '黄岩区', 96, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (953, '玉环县', 96, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (954, '三门县', 96, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (955, '天台县', 96, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (956, '仙居县', 96, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (957, '温岭市', 96, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (958, '临海市', 96, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (959, '莲都区', 97, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (960, '青田县', 97, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (961, '缙云县', 97, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (962, '遂昌县', 97, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (963, '松阳县', 97, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (964, '云和县', 97, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (965, '庆元县', 97, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (966, '景宁畲族自治县', 97, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (967, '龙泉市', 97, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (968, '瑶海区', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (969, '庐阳区', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (970, '蜀山区', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (971, '包河区', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (972, '长丰县', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (973, '肥东县', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (974, '肥西县', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (975, '经济技术开发区', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (976, '新站试验区', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (977, '政务文化新区', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (978, '高新技术产业开发区', 98, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (979, '镜湖区', 99, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (980, '鸠江区', 99, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (981, '芜湖县', 99, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (982, '繁昌县', 99, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (983, '南陵县', 99, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (984, '弋江区', 99, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (985, '三山区', 99, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (986, '龙子湖区', 100, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (987, '蚌山区', 100, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (988, '禹会区', 100, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (989, '淮上区', 100, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (990, '怀远县', 100, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (991, '五河县', 100, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (992, '固镇县', 100, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (993, '大通区', 101, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (994, '田家庵区', 101, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (995, '谢家集区', 101, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (996, '八公山区', 101, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (997, '潘集区', 101, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (998, '凤台县', 101, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (999, '雨山区', 102, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1000, '花山区', 102, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1001, '金家庄区', 102, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1002, '当涂县', 102, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1003, '经济技术开发区', 102, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1004, '杜集区', 103, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1005, '相山区', 103, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1006, '烈山区', 103, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1007, '濉溪县', 103, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1008, '铜官山区', 104, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1009, '狮子山区', 104, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1010, '郊区', 104, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1011, '铜陵县', 104, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1012, '迎江区', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1013, '大观区', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1014, '怀宁县', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1015, '枞阳县', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1016, '潜山县', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1017, '太湖县', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1018, '宿松县', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1019, '望江县', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1020, '岳西县', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1021, '桐城市', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1022, '宜秀区', 105, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1023, '屯溪区', 106, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1024, '黄山区', 106, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1025, '徽州区', 106, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1026, '歙县', 106, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1027, '休宁县', 106, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1028, '黟县', 106, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1029, '祁门县', 106, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1030, '琅琊区', 107, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1031, '南谯区', 107, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1032, '来安县', 107, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1033, '全椒县', 107, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1034, '定远县', 107, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1035, '凤阳县', 107, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1036, '天长市', 107, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1037, '明光市', 107, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1038, '颍州区', 108, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1039, '颍东区', 108, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1040, '颍泉区', 108, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1041, '临泉县', 108, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1042, '太和县', 108, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1043, '阜南县', 108, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1044, '颍上县', 108, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1045, '界首市', 108, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1046, '经济开发区', 108, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1047, '埇桥区', 109, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1048, '砀山县', 109, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1049, '萧县', 109, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1050, '灵璧县', 109, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1051, '泗县', 109, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1052, '居巢区', 110, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1053, '庐江县', 110, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1054, '无为县', 110, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1055, '含山县', 110, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1056, '和县', 110, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1057, '金安区', 111, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1058, '裕安区', 111, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1059, '寿县', 111, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1060, '霍邱县', 111, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1061, '舒城县', 111, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1062, '金寨县', 111, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1063, '霍山县', 111, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1064, '谯城区', 112, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1065, '涡阳县', 112, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1066, '蒙城县', 112, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1067, '利辛县', 112, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1068, '贵池区', 113, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1069, '东至县', 113, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1070, '石台县', 113, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1071, '青阳县', 113, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1072, '宣州区', 114, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1073, '郎溪县', 114, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1074, '广德县', 114, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1075, '泾县', 114, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1076, '绩溪县', 114, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1077, '旌德县', 114, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1078, '宁国市', 114, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1079, '鼓楼区', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1080, '台江区', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1081, '仓山区', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1082, '马尾区', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1083, '晋安区', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1084, '闽侯县', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1085, '连江县', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1086, '罗源县', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1087, '闽清县', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1088, '永泰县', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1089, '平潭县', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1090, '福清市', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1091, '长乐市', 115, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1092, '思明区', 116, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1093, '海沧区', 116, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1094, '湖里区', 116, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1095, '集美区', 116, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1096, '同安区', 116, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1097, '翔安区', 116, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1098, '鼓浪屿区', 116, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1099, '象屿保税区', 116, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1100, '火炬高新区', 116, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1101, '城厢区', 117, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1102, '涵江区', 117, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1103, '荔城区', 117, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1104, '秀屿区', 117, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1105, '仙游县', 117, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1106, '梅列区', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1107, '三元区', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1108, '明溪县', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1109, '清流县', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1110, '宁化县', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1111, '大田县', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1112, '尤溪县', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1113, '沙县', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1114, '将乐县', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1115, '泰宁县', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1116, '建宁县', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1117, '永安市', 118, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1118, '鲤城区', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1119, '丰泽区', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1120, '洛江区', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1121, '泉港区', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1122, '惠安县', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1123, '安溪县', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1124, '永春县', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1125, '德化县', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1126, '金门县', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1127, '石狮市', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1128, '晋江市', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1129, '南安市', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1130, '经济技术开发区', 119, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1131, '芗城区', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1132, '龙文区', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1133, '云霄县', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1134, '漳浦县', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1135, '诏安县', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1136, '长泰县', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1137, '东山县', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1138, '南靖县', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1139, '平和县', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1140, '华安县', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1141, '龙海市', 120, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1142, '延平区', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1143, '顺昌县', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1144, '浦城县', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1145, '光泽县', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1146, '松溪县', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1147, '政和县', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1148, '邵武市', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1149, '武夷山市', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1150, '建瓯市', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1151, '建阳市', 121, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1152, '新罗区', 122, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1153, '长汀县', 122, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1154, '永定县', 122, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1155, '上杭县', 122, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1156, '武平县', 122, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1157, '连城县', 122, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1158, '漳平市', 122, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1159, '蕉城区', 123, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1160, '霞浦县', 123, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1161, '古田县', 123, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1162, '屏南县', 123, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1163, '寿宁县', 123, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1164, '周宁县', 123, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1165, '柘荣县', 123, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1166, '福安市', 123, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1167, '福鼎市', 123, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1168, '东湖区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1169, '西湖区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1170, '青云谱区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1171, '湾里区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1172, '青山湖区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1173, '南昌县', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1174, '新建县', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1175, '安义县', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1176, '进贤县', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1177, '经济技术开发区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1178, '红谷滩新区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1179, '高新技术产业开发区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1180, '桑海经济技术开发区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1181, '英雄经济开发区', 124, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1182, '昌江区', 125, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1183, '珠山区', 125, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1184, '浮梁县', 125, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1185, '乐平市', 125, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1186, '安源区', 126, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1187, '湘东区', 126, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1188, '莲花县', 126, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1189, '上栗县', 126, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1190, '芦溪县', 126, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1191, '庐山区', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1192, '浔阳区', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1193, '九江县', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1194, '武宁县', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1195, '修水县', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1196, '永修县', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1197, '德安县', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1198, '星子县', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1199, '都昌县', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1200, '湖口县', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1201, '彭泽县', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1202, '瑞昌市', 127, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1203, '渝水区', 128, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1204, '分宜县', 128, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1205, '月湖区', 129, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1206, '余江县', 129, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1207, '贵溪市', 129, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1208, '章贡区', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1209, '赣县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1210, '信丰县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1211, '大余县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1212, '上犹县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1213, '崇义县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1214, '安远县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1215, '龙南县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1216, '定南县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1217, '全南县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1218, '宁都县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1219, '于都县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1220, '兴国县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1221, '会昌县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1222, '寻乌县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1223, '石城县', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1224, '瑞金市', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1225, '南康市', 130, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1226, '吉州区', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1227, '青原区', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1228, '吉安县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1229, '吉水县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1230, '峡江县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1231, '新干县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1232, '永丰县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1233, '泰和县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1234, '遂川县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1235, '万安县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1236, '安福县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1237, '永新县', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1238, '井冈山市', 131, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1239, '袁州区', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1240, '奉新县', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1241, '万载县', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1242, '上高县', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1243, '宜丰县', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1244, '靖安县', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1245, '铜鼓县', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1246, '丰城市', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1247, '樟树市', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1248, '高安市', 132, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1249, '临川区', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1250, '南城县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1251, '黎川县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1252, '南丰县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1253, '崇仁县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1254, '乐安县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1255, '宜黄县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1256, '金溪县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1257, '资溪县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1258, '东乡县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1259, '广昌县', 133, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1260, '信州区', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1261, '上饶县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1262, '广丰县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1263, '玉山县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1264, '铅山县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1265, '横峰县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1266, '弋阳县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1267, '余干县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1268, '鄱阳县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1269, '万年县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1270, '婺源县', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1271, '德兴市', 134, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1272, '历下区', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1273, '市中区', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1274, '槐荫区', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1275, '天桥区', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1276, '历城区', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1277, '长清区', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1278, '平阴县', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1279, '济阳县', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1280, '商河县', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1281, '章丘市', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1282, '高新区', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1283, '经济开发区', 135, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1284, '市南区', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1285, '市北区', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1286, '四方区', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1287, '黄岛区', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1288, '崂山区', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1289, '李沧区', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1290, '城阳区', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1291, '胶州市', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1292, '即墨市', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1293, '平度市', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1294, '胶南市', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1295, '莱西市', 136, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1296, '淄川区', 137, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1297, '张店区', 137, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1298, '博山区', 137, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1299, '临淄区', 137, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1300, '周村区', 137, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1301, '桓台县', 137, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1302, '高青县', 137, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1303, '沂源县', 137, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1304, '高新区', 137, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1305, '市中区', 138, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1306, '薛城区', 138, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1307, '峄城区', 138, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1308, '台儿庄区', 138, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1309, '山亭区', 138, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1310, '滕州市', 138, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1311, '东营区', 139, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1312, '河口区', 139, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1313, '垦利县', 139, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1314, '利津县', 139, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1315, '广饶县', 139, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1316, '芝罘区', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1317, '福山区', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1318, '牟平区', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1319, '莱山区', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1320, '长岛县', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1321, '龙口市', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1322, '莱阳市', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1323, '莱州市', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1324, '蓬莱市', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1325, '招远市', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1326, '栖霞市', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1327, '海阳市', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1328, '开发区', 140, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1329, '潍城区', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1330, '寒亭区', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1331, '坊子区', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1332, '奎文区', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1333, '临朐县', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1334, '昌乐县', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1335, '青州市', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1336, '诸城市', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1337, '寿光市', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1338, '安丘市', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1339, '高密市', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1340, '昌邑市', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1341, '经济开发区', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1342, '滨海经济开发区', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1343, '高新技术开发区', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1344, '出口加工区', 141, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1345, '市中区', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1346, '任城区', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1347, '微山县', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1348, '鱼台县', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1349, '金乡县', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1350, '嘉祥县', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1351, '汶上县', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1352, '泗水县', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1353, '梁山县', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1354, '曲阜市', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1355, '兖州市', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1356, '邹城市', 142, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1357, '泰山区', 143, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1358, '岱岳区', 143, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1359, '宁阳县', 143, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1360, '东平县', 143, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1361, '新泰市', 143, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1362, '肥城市', 143, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1363, '环翠区', 144, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1364, '文登市', 144, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1365, '荣成市', 144, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1366, '乳山市', 144, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1367, '经济技术开发区', 144, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1368, '高技术开发区', 144, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1369, '东港区', 145, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1370, '岚山区', 145, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1371, '五莲县', 145, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1372, '莒县', 145, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1373, '莱城区', 146, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1374, '钢城区', 146, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1375, '兰山区', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1376, '罗庄区', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1377, '河东区', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1378, '沂南县', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1379, '郯城县', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1380, '沂水县', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1381, '苍山县', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1382, '费县', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1383, '平邑县', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1384, '莒南县', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1385, '蒙阴县', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1386, '临沭县', 147, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1387, '德城区', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1388, '陵县', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1389, '宁津县', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1390, '庆云县', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1391, '临邑县', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1392, '齐河县', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1393, '平原县', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1394, '夏津县', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1395, '武城县', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1396, '乐陵市', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1397, '禹城市', 148, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1398, '东昌府区', 149, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1399, '阳谷县', 149, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1400, '莘县', 149, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1401, '茌平县', 149, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1402, '东阿县', 149, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1403, '冠县', 149, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1404, '高唐县', 149, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1405, '临清市', 149, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1406, '滨城区', 150, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1407, '惠民县', 150, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1408, '阳信县', 150, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1409, '无棣县', 150, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1410, '沾化县', 150, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1411, '博兴县', 150, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1412, '邹平县', 150, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1413, '牡丹区', 151, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1414, '曹县', 151, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1415, '单县', 151, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1416, '成武县', 151, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1417, '巨野县', 151, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1418, '郓城县', 151, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1419, '鄄城县', 151, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1420, '定陶县', 151, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1421, '东明县', 151, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1422, '中原区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1423, '二七区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1424, '管城回族区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1425, '金水区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1426, '上街区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1427, '中牟县', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1428, '巩义市', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1429, '荥阳市', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1430, '新密市', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1431, '新郑市', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1432, '登封市', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1433, '高新技术开发区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1434, '惠济区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1435, '经济技术开发区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1436, '郑东新区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1437, '出口加工区', 152, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1438, '龙亭区', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1439, '顺河回族区', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1440, '鼓楼区', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1441, '杞县', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1442, '通许县', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1443, '尉氏县', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1444, '开封县', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1445, '兰考县', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1446, '金明区', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1447, '禹王台区', 153, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1448, '老城区', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1449, '西工区', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1450, '瀍河回族区', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1451, '涧西区', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1452, '吉利区', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1453, '洛龙区', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1454, '孟津县', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1455, '新安县', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1456, '栾川县', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1457, '嵩县', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1458, '汝阳县', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1459, '宜阳县', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1460, '洛宁县', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1461, '伊川县', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1462, '偃师市', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1463, '高新技术开发区', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1464, '经济技术开发区', 154, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1465, '新华区', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1466, '卫东区', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1467, '石龙区', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1468, '湛河区', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1469, '宝丰县', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1470, '叶县', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1471, '鲁山县', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1472, '郏县', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1473, '舞钢市', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1474, '汝州市', 155, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1475, '文峰区', 156, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1476, '北关区', 156, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1477, '殷都区', 156, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1478, '龙安区', 156, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1479, '安阳县', 156, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1480, '汤阴县', 156, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1481, '滑县', 156, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1482, '内黄县', 156, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1483, '林州市', 156, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1484, '鹤山区', 157, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1485, '山城区', 157, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1486, '淇滨区', 157, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1487, '浚县', 157, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1488, '淇县', 157, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1489, '红旗区', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1490, '卫滨区', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1491, '凤泉区', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1492, '牧野区', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1493, '新乡县', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1494, '获嘉县', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1495, '原阳县', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1496, '延津县', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1497, '封丘县', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1498, '长垣县', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1499, '卫辉市', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1500, '辉县市', 158, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1501, '解放区', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1502, '中站区', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1503, '马村区', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1504, '山阳区', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1505, '修武县', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1506, '博爱县', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1507, '武陟县', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1508, '温县', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1509, '沁阳市', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1510, '孟州市', 159, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1511, '华龙区', 160, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1512, '清丰县', 160, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1513, '南乐县', 160, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1514, '范县', 160, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1515, '台前县', 160, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1516, '濮阳县', 160, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1517, '魏都区', 161, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1518, '许昌县', 161, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1519, '鄢陵县', 161, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1520, '襄城县', 161, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1521, '禹州市', 161, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1522, '长葛市', 161, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1523, '源汇区', 162, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1524, '郾城区', 162, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1525, '召陵区', 162, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1526, '舞阳县', 162, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1527, '临颍县', 162, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1528, '湖滨区', 163, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1529, '渑池县', 163, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1530, '陕县', 163, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1531, '卢氏县', 163, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1532, '义马市', 163, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1533, '灵宝市', 163, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1534, '宛城区', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1535, '卧龙区', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1536, '南召县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1537, '方城县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1538, '西峡县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1539, '镇平县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1540, '内乡县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1541, '淅川县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1542, '社旗县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1543, '唐河县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1544, '新野县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1545, '桐柏县', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1546, '邓州市', 164, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1547, '梁园区', 165, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1548, '睢阳区', 165, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1549, '民权县', 165, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1550, '睢县', 165, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1551, '宁陵县', 165, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1552, '柘城县', 165, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1553, '虞城县', 165, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1554, '夏邑县', 165, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1555, '永城市', 165, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1556, '浉河区', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1557, '平桥区', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1558, '罗山县', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1559, '光山县', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1560, '新县', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1561, '商城县', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1562, '固始县', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1563, '潢川县', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1564, '淮滨县', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1565, '息县', 166, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1566, '川汇区', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1567, '扶沟县', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1568, '西华县', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1569, '商水县', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1570, '沈丘县', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1571, '郸城县', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1572, '淮阳县', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1573, '太康县', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1574, '鹿邑县', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1575, '项城市', 167, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1576, '驿城区', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1577, '西平县', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1578, '上蔡县', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1579, '平舆县', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1580, '正阳县', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1581, '确山县', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1582, '泌阳县', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1583, '汝南县', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1584, '遂平县', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1585, '新蔡县', 168, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1586, '济源市', 169, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1587, '江岸区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1588, '江汉区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1589, '硚口区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1590, '汉阳区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1591, '武昌区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1592, '青山区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1593, '洪山区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1594, '东西湖区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1595, '汉南区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1596, '蔡甸区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1597, '江夏区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1598, '黄陂区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1599, '新洲区', 170, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1600, '黄石港区', 171, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1601, '西塞山区', 171, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1602, '下陆区', 171, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1603, '铁山区', 171, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1604, '阳新县', 171, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1605, '大冶市', 171, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1606, '茅箭区', 172, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1607, '张湾区', 172, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1608, '郧县', 172, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1609, '郧西县', 172, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1610, '竹山县', 172, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1611, '竹溪县', 172, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1612, '房县', 172, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1613, '丹江口市', 172, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1614, '西陵区', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1615, '伍家岗区', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1616, '点军区', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1617, '虢亭区', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1618, '夷陵区', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1619, '远安县', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1620, '兴山县', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1621, '秭归县', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1622, '长阳土家族自治县', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1623, '五峰土家族自治县', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1624, '宜都市', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1625, '当阳市', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1626, '枝江市', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1627, '经济技术开发区', 173, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1628, '襄城区', 174, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1629, '樊城区', 174, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1630, '襄阳区', 174, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1631, '南漳县', 174, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1632, '谷城县', 174, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1633, '保康县', 174, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1634, '老河口市', 174, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1635, '枣阳市', 174, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1636, '宜城市', 174, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1637, '梁子湖区', 175, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1638, '华容区', 175, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1639, '鄂城区', 175, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1640, '东宝区', 176, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1641, '掇刀区', 176, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1642, '京山县', 176, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1643, '沙洋县', 176, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1644, '钟祥市', 176, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1645, '孝南区', 177, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1646, '孝昌县', 177, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1647, '大悟县', 177, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1648, '云梦县', 177, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1649, '应城市', 177, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1650, '安陆市', 177, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1651, '汉川市', 177, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1652, '沙市区', 178, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1653, '荆州区', 178, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1654, '公安县', 178, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1655, '监利县', 178, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1656, '江陵县', 178, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1657, '石首市', 178, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1658, '洪湖市', 178, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1659, '松滋市', 178, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1660, '黄州区', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1661, '团风县', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1662, '红安县', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1663, '罗田县', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1664, '英山县', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1665, '浠水县', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1666, '蕲春县', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1667, '黄梅县', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1668, '麻城市', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1669, '武穴市', 179, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1670, '咸安区', 180, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1671, '嘉鱼县', 180, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1672, '通城县', 180, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1673, '崇阳县', 180, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1674, '通山县', 180, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1675, '赤壁市', 180, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1676, '曾都区', 181, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1677, '广水市', 181, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1678, '恩施市', 182, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1679, '利川市', 182, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1680, '建始县', 182, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1681, '巴东县', 182, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1682, '宣恩县', 182, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1683, '咸丰县', 182, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1684, '来凤县', 182, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1685, '鹤峰县', 182, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1686, '仙桃市', 183, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1687, '潜江市', 183, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1688, '天门市', 183, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1689, '神农架林区', 183, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1690, '芙蓉区', 184, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1691, '天心区', 184, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1692, '岳麓区', 184, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1693, '开福区', 184, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1694, '雨花区', 184, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1695, '长沙县', 184, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1696, '望城县', 184, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1697, '宁乡县', 184, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1698, '浏阳市', 184, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1699, '荷塘区', 185, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1700, '芦淞区', 185, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1701, '石峰区', 185, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1702, '天元区', 185, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1703, '株洲县', 185, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1704, '攸县', 185, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1705, '茶陵县', 185, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1706, '炎陵县', 185, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1707, '醴陵市', 185, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1708, '雨湖区', 186, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1709, '岳塘区', 186, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1710, '湘潭县', 186, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1711, '湘乡市', 186, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1712, '韶山市', 186, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1713, '珠晖区', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1714, '雁峰区', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1715, '石鼓区', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1716, '蒸湘区', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1717, '南岳区', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1718, '衡阳县', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1719, '衡南县', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1720, '衡山县', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1721, '衡东县', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1722, '祁东县', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1723, '耒阳市', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1724, '常宁市', 187, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1725, '双清区', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1726, '大祥区', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1727, '北塔区', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1728, '邵东县', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1729, '新邵县', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1730, '邵阳县', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1731, '隆回县', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1732, '洞口县', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1733, '绥宁县', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1734, '新宁县', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1735, '城步苗族自治县', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1736, '武冈市', 188, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1737, '岳阳楼区', 189, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1738, '云溪区', 189, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1739, '君山区', 189, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1740, '岳阳县', 189, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1741, '华容县', 189, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1742, '湘阴县', 189, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1743, '平江县', 189, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1744, '汨罗市', 189, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1745, '临湘市', 189, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1746, '武陵区', 190, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1747, '鼎城区', 190, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1748, '安乡县', 190, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1749, '汉寿县', 190, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1750, '澧县', 190, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1751, '临澧县', 190, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1752, '桃源县', 190, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1753, '石门县', 190, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1754, '津市市', 190, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1755, '永定区', 191, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1756, '武陵源区', 191, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1757, '慈利县', 191, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1758, '桑植县', 191, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1759, '资阳区', 192, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1760, '赫山区', 192, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1761, '南县', 192, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1762, '桃江县', 192, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1763, '安化县', 192, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1764, '沅江市', 192, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1765, '北湖区', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1766, '苏仙区', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1767, '桂阳县', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1768, '宜章县', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1769, '永兴县', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1770, '嘉禾县', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1771, '临武县', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1772, '汝城县', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1773, '桂东县', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1774, '安仁县', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1775, '资兴市', 193, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1776, '冷水滩区', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1777, '祁阳县', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1778, '东安县', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1779, '双牌县', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1780, '道县', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1781, '江永县', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1782, '宁远县', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1783, '蓝山县', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1784, '新田县', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1785, '江华瑶族自治县', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1786, '零陵区', 194, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1787, '鹤城区', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1788, '中方县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1789, '沅陵县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1790, '辰溪县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1791, '溆浦县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1792, '会同县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1793, '麻阳苗族自治县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1794, '新晃侗族自治县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1795, '芷江侗族自治县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1796, '靖州苗族侗族自治县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1797, '通道侗族自治县', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1798, '洪江市', 195, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1799, '娄星区', 196, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1800, '双峰县', 196, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1801, '新化县', 196, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1802, '冷水江市', 196, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1803, '涟源市', 196, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1804, '吉首市', 197, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1805, '泸溪县', 197, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1806, '凤凰县', 197, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1807, '花垣县', 197, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1808, '保靖县', 197, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1809, '古丈县', 197, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1810, '永顺县', 197, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1811, '龙山县', 197, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1812, '荔湾区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1813, '越秀区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1814, '海珠区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1815, '天河区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1816, '白云区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1817, '黄埔区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1818, '番禺区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1819, '花都区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1820, '增城市', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1821, '从化市', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1822, '南沙区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1823, '萝岗区', 198, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1824, '武江区', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1825, '浈江区', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1826, '曲江区', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1827, '始兴县', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1828, '仁化县', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1829, '翁源县', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1830, '乳源瑶族自治县', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1831, '新丰县', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1832, '乐昌市', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1833, '南雄市', 199, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1834, '罗湖区', 200, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1835, '福田区', 200, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1836, '南山区', 200, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1837, '宝安区', 200, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1838, '龙岗区', 200, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1839, '盐田区', 200, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1840, '光明新区', 200, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1841, '坪山新区', 200, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1842, '香洲区', 201, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1843, '斗门区', 201, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1844, '金湾区', 201, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1845, '龙湖区', 202, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1846, '金平区', 202, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1847, '濠江区', 202, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1848, '潮阳区', 202, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1849, '潮南区', 202, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1850, '澄海区', 202, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1851, '南澳县', 202, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1852, '禅城区', 203, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1853, '南海区', 203, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1854, '顺德区', 203, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1855, '三水区', 203, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1856, '高明区', 203, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1857, '蓬江区', 204, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1858, '江海区', 204, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1859, '新会区', 204, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1860, '台山市', 204, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1861, '开平市', 204, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1862, '鹤山市', 204, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1863, '恩平市', 204, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1864, '赤坎区', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1865, '霞山区', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1866, '坡头区', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1867, '麻章区', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1868, '遂溪县', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1869, '徐闻县', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1870, '廉江市', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1871, '雷州市', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1872, '吴川市', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1873, '开发区', 205, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1874, '茂南区', 206, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1875, '茂港区', 206, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1876, '电白县', 206, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1877, '高州市', 206, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1878, '化州市', 206, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1879, '信宜市', 206, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1880, '端州区', 207, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1881, '鼎湖区', 207, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1882, '广宁县', 207, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1883, '怀集县', 207, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1884, '封开县', 207, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1885, '德庆县', 207, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1886, '高要市', 207, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1887, '四会市', 207, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1888, '高新技术产业开发区', 207, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1889, '惠城区', 208, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1890, '惠阳区', 208, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1891, '博罗县', 208, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1892, '惠东县', 208, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1893, '龙门县', 208, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1894, '大亚湾区', 208, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1895, '仲恺高新区', 208, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1896, '梅江区', 209, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1897, '梅县', 209, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1898, '大埔县', 209, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1899, '丰顺县', 209, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1900, '五华县', 209, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1901, '平远县', 209, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1902, '蕉岭县', 209, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1903, '兴宁市', 209, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1904, '城区', 210, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1905, '陆丰市', 210, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1906, '海丰县', 210, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1907, '陆河县', 210, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1908, '源城区', 211, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1909, '紫金县', 211, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1910, '龙川县', 211, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1911, '连平县', 211, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1912, '和平县', 211, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1913, '东源县', 211, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1914, '江城区', 212, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1915, '阳西县', 212, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1916, '阳东县', 212, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1917, '阳春市', 212, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1918, '清城区', 213, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1919, '佛冈县', 213, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1920, '阳山县', 213, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1921, '连山壮族瑶族自治县', 213, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1922, '连南瑶族自治县', 213, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1923, '清新县', 213, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1924, '英德市', 213, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1925, '连州市', 213, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1926, '南城区', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1927, '石龙镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1928, '长安镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1929, '虎门镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1930, '横沥镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1931, '寮步镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1932, '黄江镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1933, '清溪镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1934, '莞城区', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1935, '万江区', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1936, '东城区', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1937, '石碣镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1938, '茶山镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1939, '石排镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1940, '企石镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1941, '桥头镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1942, '谢岗镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1943, '东坑镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1944, '常平镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1945, '大朗镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1946, '塘厦镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1947, '凤岗镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1948, '厚街镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1949, '沙田镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1950, '道滘镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1951, '洪梅镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1952, '麻涌镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1953, '中堂镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1954, '高埗镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1955, '樟木头镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1956, '大岭山镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1957, '望牛墩镇', 214, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1958, '中山市', 215, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1959, '湘桥区', 216, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1960, '潮安县', 216, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1961, '饶平县', 216, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1962, '榕城区', 217, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1963, '揭东县', 217, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1964, '揭西县', 217, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1965, '惠来县', 217, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1966, '普宁市', 217, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1967, '东山区', 217, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1968, '普侨区', 217, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1969, '大南山侨区', 217, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1970, '云城区', 218, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1971, '新兴县', 218, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1972, '郁南县', 218, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1973, '云安县', 218, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1974, '罗定市', 218, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1975, '兴宁区', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1976, '青秀区', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1977, '江南区', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1978, '西乡塘区', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1979, '良庆区', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1980, '邕宁区', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1981, '武鸣县', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1982, '隆安县', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1983, '马山县', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1984, '上林县', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1985, '宾阳县', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1986, '横县', 219, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1987, '城中区', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1988, '鱼峰区', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1989, '柳南区', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1990, '柳北区', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1991, '柳江县', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1992, '柳城县', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1993, '鹿寨县', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1994, '融安县', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1995, '融水苗族自治县', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1996, '三江侗族自治县', 220, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1997, '秀峰区', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1998, '叠彩区', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (1999, '象山区', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2000, '七星区', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2001, '雁山区', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2002, '阳朔县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2003, '临桂县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2004, '灵川县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2005, '全州县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2006, '兴安县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2007, '永福县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2008, '灌阳县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2009, '龙胜各族自治县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2010, '资源县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2011, '平乐县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2012, '荔浦县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2013, '恭城瑶族自治县', 221, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2014, '万秀区', 222, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2015, '蝶山区', 222, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2016, '长洲区', 222, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2017, '苍梧县', 222, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2018, '藤县', 222, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2019, '蒙山县', 222, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2020, '岑溪市', 222, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2021, '海城区', 223, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2022, '银海区', 223, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2023, '铁山港区', 223, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2024, '合浦县', 223, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2025, '港口区', 224, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2026, '防城区', 224, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2027, '上思县', 224, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2028, '东兴市', 224, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2029, '钦南区', 225, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2030, '钦北区', 225, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2031, '灵山县', 225, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2032, '浦北县', 225, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2033, '钦州港经济开发区', 225, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2034, '港北区', 226, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2035, '港南区', 226, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2036, '覃塘区', 226, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2037, '平南县', 226, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2038, '桂平市', 226, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2039, '玉州区', 227, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2040, '容县', 227, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2041, '陆川县', 227, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2042, '博白县', 227, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2043, '兴业县', 227, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2044, '北流市', 227, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2045, '右江区', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2046, '田阳县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2047, '田东县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2048, '平果县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2049, '德保县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2050, '靖西县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2051, '那坡县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2052, '凌云县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2053, '乐业县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2054, '田林县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2055, '西林县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2056, '隆林各族自治县', 228, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2057, '八步区', 229, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2058, '昭平县', 229, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2059, '钟山县', 229, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2060, '富川瑶族自治县', 229, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2061, '金城江区', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2062, '南丹县', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2063, '天峨县', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2064, '凤山县', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2065, '东兰县', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2066, '罗城仫佬族自治县', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2067, '环江毛南族自治县', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2068, '巴马瑶族自治县', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2069, '都安瑶族自治县', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2070, '大化瑶族自治县', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2071, '宜州市', 230, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2072, '兴宾区', 231, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2073, '忻城县', 231, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2074, '象州县', 231, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2075, '武宣县', 231, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2076, '金秀瑶族自治县', 231, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2077, '合山市', 231, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2078, '江洲区', 232, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2079, '扶绥县', 232, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2080, '宁明县', 232, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2081, '龙州县', 232, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2082, '大新县', 232, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2083, '天等县', 232, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2084, '凭祥市', 232, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2085, '秀英区', 233, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2086, '龙华区', 233, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2087, '琼山区', 233, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2088, '美兰区', 233, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2089, '河西区', 234, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2090, '河东区', 234, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2091, '田独镇', 234, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2092, '凤凰镇', 234, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2093, '三亚市', 234, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2094, '崖城镇', 234, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2095, '天涯镇', 234, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2096, '育才乡', 234, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2097, '海棠湾镇', 234, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2098, '五指山市', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2099, '琼海市', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2100, '儋州市', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2101, '文昌市', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2102, '万宁市', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2103, '东方市', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2104, '定安县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2105, '屯昌县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2106, '澄迈县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2107, '临高县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2108, '白沙黎族自治县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2109, '昌江黎族自治县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2110, '乐东黎族自治县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2111, '陵水黎族自治县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2112, '保亭黎族苗族自治县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2113, '琼中黎族苗族自治县', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2114, '西、南、中沙群岛办事处', 235, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2115, '万州区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2116, '涪陵区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2117, '渝中区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2118, '大渡口区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2119, '江北区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2120, '沙坪坝区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2121, '九龙坡区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2122, '南岸区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2123, '北碚区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2124, '万盛区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2125, '双桥区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2126, '渝北区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2127, '巴南区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2128, '黔江区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2129, '长寿区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2130, '綦江县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2131, '潼南县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2132, '铜梁县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2133, '大足县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2134, '荣昌县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2135, '璧山县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2136, '梁平县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2137, '城口县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2138, '丰都县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2139, '垫江县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2140, '武隆县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2141, '忠县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2142, '开县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2143, '云阳县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2144, '奉节县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2145, '巫山县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2146, '巫溪县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2147, '石柱土家族自治县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2148, '秀山土家族苗族自治县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2149, '酉阳土家族苗族自治县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2150, '彭水苗族土家族自治县', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2151, '高新区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2152, '江津区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2153, '合川区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2154, '永川区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2155, '南川区', 236, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2156, '锦江区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2157, '青羊区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2158, '金牛区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2159, '武侯区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2160, '成华区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2161, '龙泉驿区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2162, '青白江区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2163, '新都区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2164, '温江区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2165, '金堂县', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2166, '双流县', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2167, '郫县', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2168, '大邑县', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2169, '蒲江县', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2170, '新津县', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2171, '都江堰市', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2172, '彭州市', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2173, '邛崃市', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2174, '崇州市', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2175, '高新区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2176, '高新西区', 237, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2177, '自流井区', 238, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2178, '贡井区', 238, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2179, '大安区', 238, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2180, '沿滩区', 238, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2181, '荣县', 238, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2182, '富顺县', 238, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2183, '东区', 239, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2184, '西区', 239, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2185, '仁和区', 239, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2186, '米易县', 239, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2187, '盐边县', 239, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2188, '江阳区', 240, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2189, '纳溪区', 240, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2190, '龙马潭区', 240, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2191, '泸县', 240, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2192, '合江县', 240, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2193, '叙永县', 240, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2194, '古蔺县', 240, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2195, '旌阳区', 241, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2196, '中江县', 241, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2197, '罗江县', 241, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2198, '广汉市', 241, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2199, '什邡市', 241, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2200, '绵竹市', 241, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2201, '涪城区', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2202, '游仙区', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2203, '三台县', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2204, '盐亭县', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2205, '安县', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2206, '梓潼县', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2207, '北川羌族自治县', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2208, '平武县', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2209, '江油市', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2210, '农科区', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2211, '经济技术开发区', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2212, '高新区', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2213, '仙海区', 242, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2214, '利州区', 243, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2215, '元坝区', 243, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2216, '朝天区', 243, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2217, '旺苍县', 243, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2218, '青川县', 243, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2219, '剑阁县', 243, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2220, '苍溪县', 243, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2221, '船山区', 244, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2222, '安居区', 244, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2223, '蓬溪县', 244, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2224, '射洪县', 244, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2225, '大英县', 244, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2226, '市中区', 245, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2227, '东兴区', 245, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2228, '威远县', 245, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2229, '资中县', 245, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2230, '隆昌县', 245, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2231, '市中区', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2232, '沙湾区', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2233, '五通桥区', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2234, '金口河区', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2235, '犍为县', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2236, '井研县', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2237, '夹江县', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2238, '沐川县', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2239, '峨边彝族自治县', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2240, '马边彝族自治县', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2241, '峨眉山市', 246, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2242, '顺庆区', 247, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2243, '高坪区', 247, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2244, '嘉陵区', 247, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2245, '南部县', 247, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2246, '营山县', 247, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2247, '蓬安县', 247, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2248, '仪陇县', 247, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2249, '西充县', 247, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2250, '阆中市', 247, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2251, '东坡区', 248, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2252, '仁寿县', 248, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2253, '彭山县', 248, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2254, '洪雅县', 248, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2255, '丹棱县', 248, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2256, '青神县', 248, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2257, '翠屏区', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2258, '宜宾县', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2259, '南溪县', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2260, '江安县', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2261, '长宁县', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2262, '高县', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2263, '珙县', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2264, '筠连县', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2265, '兴文县', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2266, '屏山县', 249, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2267, '广安区', 250, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2268, '岳池县', 250, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2269, '武胜县', 250, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2270, '邻水县', 250, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2271, '华蓥市', 250, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2272, '通川区', 251, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2273, '达县', 251, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2274, '宣汉县', 251, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2275, '开江县', 251, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2276, '大竹县', 251, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2277, '渠县', 251, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2278, '万源市', 251, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2279, '雨城区', 252, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2280, '名山县', 252, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2281, '荥经县', 252, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2282, '汉源县', 252, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2283, '石棉县', 252, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2284, '天全县', 252, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2285, '芦山县', 252, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2286, '宝兴县', 252, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2287, '巴州区', 253, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2288, '通江县', 253, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2289, '南江县', 253, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2290, '平昌县', 253, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2291, '雁江区', 254, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2292, '安岳县', 254, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2293, '乐至县', 254, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2294, '简阳市', 254, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2295, '汶川县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2296, '理县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2297, '茂县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2298, '松潘县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2299, '九寨沟县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2300, '金川县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2301, '小金县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2302, '黑水县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2303, '马尔康县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2304, '壤塘县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2305, '阿坝县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2306, '若尔盖县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2307, '红原县', 255, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2308, '康定县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2309, '泸定县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2310, '丹巴县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2311, '九龙县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2312, '雅江县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2313, '道孚县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2314, '炉霍县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2315, '甘孜县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2316, '新龙县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2317, '德格县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2318, '白玉县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2319, '石渠县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2320, '色达县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2321, '理塘县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2322, '巴塘县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2323, '乡城县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2324, '稻城县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2325, '得荣县', 256, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2326, '西昌市', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2327, '木里藏族自治县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2328, '盐源县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2329, '德昌县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2330, '会理县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2331, '会东县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2332, '宁南县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2333, '普格县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2334, '布拖县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2335, '金阳县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2336, '昭觉县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2337, '喜德县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2338, '冕宁县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2339, '越西县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2340, '甘洛县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2341, '美姑县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2342, '雷波县', 257, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2343, '南明区', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2344, '云岩区', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2345, '花溪区', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2346, '乌当区', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2347, '白云区', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2348, '小河区', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2349, '开阳县', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2350, '息烽县', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2351, '修文县', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2352, '清镇市', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2353, '金阳新区', 258, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2354, '钟山区', 259, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2355, '六枝特区', 259, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2356, '水城县', 259, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2357, '盘县', 259, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2358, '红花岗区', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2359, '汇川区', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2360, '遵义县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2361, '桐梓县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2362, '绥阳县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2363, '正安县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2364, '道真仡佬族苗族自治县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2365, '务川仡佬族苗族自治县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2366, '凤冈县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2367, '湄潭县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2368, '余庆县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2369, '习水县', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2370, '赤水市', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2371, '仁怀市', 260, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2372, '西秀区', 261, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2373, '平坝县', 261, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2374, '普定县', 261, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2375, '镇宁布依族苗族自治县', 261, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2376, '关岭布依族苗族自治县', 261, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2377, '紫云苗族布依族自治县', 261, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2378, '铜仁市', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2379, '江口县', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2380, '玉屏侗族自治县', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2381, '石阡县', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2382, '思南县', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2383, '印江土家族苗族自治县', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2384, '德江县', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2385, '沿河土家族自治县', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2386, '松桃苗族自治县', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2387, '万山特区', 262, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2388, '兴义市', 263, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2389, '兴仁县', 263, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2390, '普安县', 263, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2391, '晴隆县', 263, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2392, '贞丰县', 263, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2393, '望谟县', 263, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2394, '册亨县', 263, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2395, '安龙县', 263, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2396, '毕节市', 264, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2397, '大方县', 264, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2398, '黔西县', 264, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2399, '金沙县', 264, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2400, '织金县', 264, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2401, '纳雍县', 264, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2402, '威宁彝族回族苗族自治县', 264, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2403, '赫章县', 264, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2404, '凯里市', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2405, '黄平县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2406, '施秉县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2407, '三穗县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2408, '镇远县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2409, '岑巩县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2410, '天柱县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2411, '锦屏县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2412, '剑河县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2413, '台江县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2414, '黎平县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2415, '榕江县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2416, '从江县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2417, '雷山县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2418, '麻江县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2419, '丹寨县', 265, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2420, '都匀市', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2421, '福泉市', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2422, '荔波县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2423, '贵定县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2424, '瓮安县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2425, '独山县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2426, '平塘县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2427, '罗甸县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2428, '长顺县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2429, '龙里县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2430, '惠水县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2431, '三都水族自治县', 266, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2432, '五华区', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2433, '盘龙区', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2434, '官渡区', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2435, '西山区', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2436, '东川区', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2437, '呈贡县', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2438, '晋宁县', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2439, '富民县', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2440, '宜良县', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2441, '石林彝族自治县', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2442, '嵩明县', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2443, '禄劝彝族苗族自治县', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2444, '寻甸回族彝族自治县', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2445, '安宁市', 267, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2446, '麒麟区', 268, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2447, '马龙县', 268, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2448, '陆良县', 268, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2449, '师宗县', 268, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2450, '罗平县', 268, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2451, '富源县', 268, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2452, '会泽县', 268, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2453, '沾益县', 268, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2454, '宣威市', 268, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2455, '红塔区', 269, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2456, '江川县', 269, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2457, '澄江县', 269, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2458, '通海县', 269, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2459, '华宁县', 269, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2460, '易门县', 269, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2461, '峨山彝族自治县', 269, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2462, '新平彝族傣族自治县', 269, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2463, '元江哈尼族彝族傣族自治县', 269, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2464, '隆阳区', 270, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2465, '施甸县', 270, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2466, '腾冲县', 270, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2467, '龙陵县', 270, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2468, '昌宁县', 270, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2469, '昭阳区', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2470, '鲁甸县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2471, '巧家县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2472, '盐津县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2473, '大关县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2474, '永善县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2475, '绥江县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2476, '镇雄县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2477, '彝良县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2478, '威信县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2479, '水富县', 271, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2480, '古城区', 272, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2481, '玉龙纳西族自治县', 272, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2482, '永胜县', 272, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2483, '华坪县', 272, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2484, '宁蒗彝族自治县', 272, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2485, '思茅区', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2486, '宁洱哈尼族彝族自治县', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2487, '墨江哈尼族自治县', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2488, '景东彝族自治县', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2489, '景谷傣族彝族自治县', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2490, '镇沅彝族哈尼族拉祜族自治县', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2491, '江城哈尼族彝族自治县', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2492, '孟连傣族拉祜族佤族自治县', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2493, '澜沧拉祜族自治县', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2494, '西盟佤族自治县', 273, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2495, '临翔区', 274, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2496, '凤庆县', 274, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2497, '云县', 274, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2498, '永德县', 274, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2499, '镇康县', 274, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2500, '双江拉祜族佤族布朗族傣族自治县', 274, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2501, '耿马傣族佤族自治县', 274, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2502, '沧源佤族自治县', 274, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2503, '楚雄市', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2504, '双柏县', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2505, '牟定县', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2506, '南华县', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2507, '姚安县', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2508, '大姚县', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2509, '永仁县', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2510, '元谋县', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2511, '武定县', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2512, '禄丰县', 275, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2513, '个旧市', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2514, '开远市', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2515, '蒙自县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2516, '屏边苗族自治县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2517, '建水县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2518, '石屏县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2519, '弥勒县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2520, '泸西县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2521, '元阳县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2522, '红河县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2523, '金平苗族瑶族傣族自治县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2524, '绿春县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2525, '河口瑶族自治县', 276, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2526, '文山县', 277, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2527, '砚山县', 277, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2528, '西畴县', 277, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2529, '麻栗坡县', 277, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2530, '马关县', 277, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2531, '丘北县', 277, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2532, '广南县', 277, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2533, '富宁县', 277, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2534, '景洪市', 278, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2535, '勐海县', 278, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2536, '勐腊县', 278, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2537, '大理市', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2538, '漾濞彝族自治县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2539, '祥云县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2540, '宾川县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2541, '弥渡县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2542, '南涧彝族自治县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2543, '巍山彝族回族自治县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2544, '永平县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2545, '云龙县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2546, '洱源县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2547, '剑川县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2548, '鹤庆县', 279, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2549, '瑞丽市', 280, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2550, '潞西市', 280, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2551, '梁河县', 280, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2552, '盈江县', 280, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2553, '陇川县', 280, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2554, '泸水县', 281, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2555, '福贡县', 281, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2556, '贡山独龙族怒族自治县', 281, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2557, '兰坪白族普米族自治县', 281, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2558, '香格里拉县', 282, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2559, '德钦县', 282, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2560, '维西傈僳族自治县', 282, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2561, '城关区', 283, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2562, '林周县', 283, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2563, '当雄县', 283, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2564, '尼木县', 283, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2565, '曲水县', 283, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2566, '堆龙德庆县', 283, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2567, '达孜县', 283, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2568, '墨竹工卡县', 283, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2569, '昌都县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2570, '江达县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2571, '贡觉县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2572, '类乌齐县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2573, '丁青县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2574, '察雅县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2575, '八宿县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2576, '左贡县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2577, '芒康县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2578, '洛隆县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2579, '边坝县', 284, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2580, '乃东县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2581, '扎囊县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2582, '贡嘎县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2583, '桑日县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2584, '琼结县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2585, '曲松县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2586, '措美县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2587, '洛扎县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2588, '加查县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2589, '隆子县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2590, '错那县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2591, '浪卡子县', 285, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2592, '日喀则市', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2593, '南木林县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2594, '江孜县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2595, '定日县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2596, '萨迦县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2597, '拉孜县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2598, '昂仁县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2599, '谢通门县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2600, '白朗县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2601, '仁布县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2602, '康马县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2603, '定结县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2604, '仲巴县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2605, '亚东县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2606, '吉隆县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2607, '聂拉木县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2608, '萨嘎县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2609, '岗巴县', 286, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2610, '那曲县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2611, '嘉黎县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2612, '比如县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2613, '聂荣县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2614, '安多县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2615, '申扎县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2616, '索县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2617, '班戈县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2618, '巴青县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2619, '尼玛县', 287, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2620, '普兰县', 288, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2621, '札达县', 288, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2622, '噶尔县', 288, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2623, '日土县', 288, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2624, '革吉县', 288, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2625, '改则县', 288, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2626, '措勤县', 288, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2627, '林芝县', 289, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2628, '工布江达县', 289, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2629, '米林县', 289, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2630, '墨脱县', 289, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2631, '波密县', 289, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2632, '察隅县', 289, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2633, '朗县', 289, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2634, '新城区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2635, '碑林区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2636, '莲湖区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2637, '灞桥区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2638, '未央区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2639, '雁塔区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2640, '阎良区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2641, '临潼区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2642, '长安区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2643, '蓝田县', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2644, '周至县', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2645, '户县', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2646, '高陵县', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2647, '高新区', 290, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2648, '王益区', 291, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2649, '印台区', 291, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2650, '耀州区', 291, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2651, '宜君县', 291, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2652, '新区', 291, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2653, '渭滨区', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2654, '金台区', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2655, '陈仓区', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2656, '凤翔县', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2657, '岐山县', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2658, '扶风县', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2659, '眉县', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2660, '陇县', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2661, '千阳县', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2662, '麟游县', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2663, '凤县', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2664, '太白县', 292, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2665, '秦都区', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2666, '渭城区', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2667, '杨陵区', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2668, '三原县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2669, '泾阳县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2670, '兴平市', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2671, '乾县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2672, '礼泉县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2673, '永寿县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2674, '彬县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2675, '长武县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2676, '旬邑县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2677, '淳化县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2678, '武功县', 293, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2679, '临渭区', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2680, '华县', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2681, '潼关县', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2682, '大荔县', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2683, '合阳县', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2684, '澄城县', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2685, '蒲城县', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2686, '白水县', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2687, '富平县', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2688, '韩城市', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2689, '华阴市', 294, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2690, '宝塔区', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2691, '延长县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2692, '延川县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2693, '子长县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2694, '安塞县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2695, '志丹县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2696, '吴旗县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2697, '甘泉县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2698, '富县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2699, '洛川县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2700, '宜川县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2701, '黄龙县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2702, '黄陵县', 295, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2703, '汉台区', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2704, '南郑县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2705, '城固县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2706, '洋县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2707, '西乡县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2708, '勉县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2709, '宁强县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2710, '略阳县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2711, '镇巴县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2712, '留坝县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2713, '佛坪县', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2714, '经济开发区', 296, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2715, '榆阳区', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2716, '神木县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2717, '府谷县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2718, '横山县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2719, '靖边县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2720, '定边县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2721, '绥德县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2722, '米脂县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2723, '佳县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2724, '吴堡县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2725, '清涧县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2726, '子洲县', 297, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2727, '汉滨区', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2728, '汉阴县', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2729, '石泉县', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2730, '宁陕县', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2731, '紫阳县', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2732, '岚皋县', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2733, '平利县', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2734, '镇坪县', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2735, '旬阳县', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2736, '白河县', 298, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2737, '商州区', 299, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2738, '洛南县', 299, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2739, '丹凤县', 299, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2740, '商南县', 299, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2741, '山阳县', 299, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2742, '镇安县', 299, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2743, '柞水县', 299, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2744, '城关区', 300, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2745, '七里河区', 300, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2746, '西固区', 300, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2747, '安宁区', 300, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2748, '红古区', 300, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2749, '永登县', 300, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2750, '皋兰县', 300, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2751, '榆中县', 300, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2752, '嘉峪关市', 301, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2753, '金川区', 302, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2754, '永昌县', 302, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2755, '白银区', 303, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2756, '平川区', 303, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2757, '靖远县', 303, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2758, '会宁县', 303, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2759, '景泰县', 303, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2760, '秦州区', 304, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2761, '麦积区', 304, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2762, '清水县', 304, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2763, '秦安县', 304, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2764, '甘谷县', 304, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2765, '武山县', 304, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2766, '张家川回族自治县', 304, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2767, '凉州区', 305, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2768, '民勤县', 305, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2769, '古浪县', 305, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2770, '天祝藏族自治县', 305, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2771, '甘州区', 306, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2772, '肃南裕固族自治县', 306, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2773, '民乐县', 306, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2774, '临泽县', 306, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2775, '高台县', 306, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2776, '山丹县', 306, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2777, '崆峒区', 307, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2778, '泾川县', 307, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2779, '灵台县', 307, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2780, '崇信县', 307, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2781, '华亭县', 307, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2782, '庄浪县', 307, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2783, '静宁县', 307, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2784, '肃州区', 308, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2785, '金塔县', 308, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2786, '安西县', 308, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2787, '肃北蒙古族自治县', 308, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2788, '阿克塞哈萨克族自治县', 308, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2789, '玉门市', 308, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2790, '敦煌市', 308, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2791, '西峰区', 309, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2792, '庆城县', 309, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2793, '环县', 309, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2794, '华池县', 309, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2795, '合水县', 309, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2796, '正宁县', 309, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2797, '宁县', 309, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2798, '镇原县', 309, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2799, '安定区', 310, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2800, '通渭县', 310, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2801, '陇西县', 310, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2802, '渭源县', 310, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2803, '临洮县', 310, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2804, '漳县', 310, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2805, '岷县', 310, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2806, '武都区', 311, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2807, '成县', 311, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2808, '文县', 311, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2809, '宕昌县', 311, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2810, '康县', 311, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2811, '西和县', 311, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2812, '礼县', 311, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2813, '徽县', 311, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2814, '两当县', 311, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2815, '临夏市', 312, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2816, '临夏县', 312, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2817, '康乐县', 312, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2818, '永靖县', 312, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2819, '广河县', 312, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2820, '和政县', 312, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2821, '东乡族自治县', 312, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2822, '积石山保安族东乡族撒拉族自治县', 312, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2823, '合作市', 313, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2824, '临潭县', 313, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2825, '卓尼县', 313, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2826, '舟曲县', 313, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2827, '迭部县', 313, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2828, '玛曲县', 313, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2829, '碌曲县', 313, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2830, '夏河县', 313, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2831, '城东区', 314, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2832, '城中区', 314, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2833, '城西区', 314, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2834, '城北区', 314, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2835, '大通回族土族自治县', 314, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2836, '湟中县', 314, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2837, '湟源县', 314, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2838, '平安县', 315, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2839, '民和回族土族自治县', 315, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2840, '乐都县', 315, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2841, '互助土族自治县', 315, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2842, '化隆回族自治县', 315, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2843, '循化撒拉族自治县', 315, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2844, '门源回族自治县', 316, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2845, '祁连县', 316, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2846, '海晏县', 316, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2847, '刚察县', 316, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2848, '同仁县', 317, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2849, '尖扎县', 317, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2850, '泽库县', 317, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2851, '河南蒙古族自治县', 317, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2852, '共和县', 318, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2853, '同德县', 318, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2854, '贵德县', 318, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2855, '兴海县', 318, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2856, '贵南县', 318, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2857, '玛沁县', 319, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2858, '班玛县', 319, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2859, '甘德县', 319, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2860, '达日县', 319, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2861, '久治县', 319, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2862, '玛多县', 319, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2863, '玉树县', 320, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2864, '杂多县', 320, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2865, '称多县', 320, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2866, '治多县', 320, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2867, '囊谦县', 320, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2868, '曲麻莱县', 320, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2869, '格尔木市', 321, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2870, '德令哈市', 321, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2871, '乌兰县', 321, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2872, '都兰县', 321, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2873, '天峻县', 321, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2874, '大柴旦行委', 321, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2875, '兴庆区', 322, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2876, '西夏区', 322, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2877, '金凤区', 322, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2878, '永宁县', 322, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2879, '贺兰县', 322, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2880, '灵武市', 322, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2881, '大武口区', 323, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2882, '惠农区', 323, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2883, '平罗县', 323, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2884, '利通区', 324, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2885, '盐池县', 324, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2886, '同心县', 324, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2887, '青铜峡市', 324, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2888, '原州区', 325, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2889, '西吉县', 325, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2890, '隆德县', 325, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2891, '泾源县', 325, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2892, '彭阳县', 325, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2893, '沙坡头区', 326, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2894, '中宁县', 326, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2895, '海原县', 326, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2896, '天山区', 327, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2897, '沙依巴克区', 327, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2898, '新市区', 327, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2899, '水磨沟区', 327, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2900, '头屯河区', 327, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2901, '达坂城区', 327, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2902, '米东区', 327, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2903, '乌鲁木齐县', 327, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2904, '独山子区', 328, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2905, '克拉玛依区', 328, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2906, '白碱滩区', 328, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2907, '乌尔禾区', 328, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2908, '吐鲁番市', 329, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2909, '鄯善县', 329, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2910, '托克逊县', 329, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2911, '哈密市', 330, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2912, '巴里坤哈萨克自治县', 330, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2913, '伊吾县', 330, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2914, '昌吉市', 331, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2915, '阜康市', 331, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2916, '米泉市', 331, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2917, '呼图壁县', 331, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2918, '玛纳斯县', 331, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2919, '奇台县', 331, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2920, '吉木萨尔县', 331, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2921, '木垒哈萨克自治县', 331, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2922, '博乐市', 332, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2923, '精河县', 332, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2924, '温泉县', 332, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2925, '库尔勒市', 333, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2926, '轮台县', 333, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2927, '尉犁县', 333, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2928, '若羌县', 333, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2929, '且末县', 333, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2930, '焉耆回族自治县', 333, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2931, '和静县', 333, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2932, '和硕县', 333, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2933, '博湖县', 333, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2934, '阿克苏市', 334, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2935, '温宿县', 334, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2936, '库车县', 334, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2937, '沙雅县', 334, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2938, '新和县', 334, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2939, '拜城县', 334, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2940, '乌什县', 334, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2941, '阿瓦提县', 334, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2942, '柯坪县', 334, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2943, '阿图什市', 335, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2944, '阿克陶县', 335, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2945, '阿合奇县', 335, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2946, '乌恰县', 335, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2947, '喀什市', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2948, '疏附县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2949, '疏勒县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2950, '英吉沙县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2951, '泽普县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2952, '莎车县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2953, '叶城县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2954, '麦盖提县مەكىت', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2955, '岳普湖县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2956, '伽师县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2957, '巴楚县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2958, '塔什库尔干塔吉克自治县', 336, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2959, '和田市', 337, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2960, '和田县', 337, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2961, '墨玉县', 337, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2962, '皮山县', 337, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2963, '洛浦县', 337, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2964, '策勒县', 337, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2965, '于田县', 337, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2966, '民丰县', 337, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2967, '伊宁市', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2968, '奎屯市', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2969, '伊宁县', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2970, '察布查尔锡伯自治县', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2971, '霍城县', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2972, '巩留县', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2973, '新源县', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2974, '昭苏县', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2975, '特克斯县', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2976, '尼勒克县', 338, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2977, '塔城市', 339, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2978, '乌苏市', 339, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2979, '额敏县', 339, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2980, '沙湾县', 339, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2981, '托里县', 339, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2982, '裕民县', 339, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2983, '和布克赛尔蒙古自治县', 339, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2984, '阿勒泰市', 340, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2985, '布尔津县', 340, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2986, '富蕴县', 340, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2987, '福海县', 340, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2988, '哈巴河县', 340, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2989, '青河县', 340, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2990, '吉木乃县', 340, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2991, '石河子市', 341, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2992, '阿拉尔市', 341, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2993, '图木舒克市', 341, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2994, '五家渠市', 341, NULL, '0', NULL, NULL, NULL);
INSERT INTO `ls_district` VALUES (2995, '香港', 342, 1, '0', NULL, '2017-11-02 17:27:42', NULL);
INSERT INTO `ls_district` VALUES (2996, '澳门', 343, 1, '0', NULL, '2017-11-02 17:23:12', NULL);
INSERT INTO `ls_district` VALUES (3093, '北屯市', 341, 5, '0', '2017-11-22 09:12:07', NULL, NULL);
INSERT INTO `ls_district` VALUES (3094, '铁门关市', 341, 6, '0', '2017-11-22 09:12:31', NULL, NULL);
INSERT INTO `ls_district` VALUES (3095, '双河市', 341, 7, '0', '2017-11-22 09:12:50', NULL, NULL);
INSERT INTO `ls_district` VALUES (3096, '可克达拉市', 341, 8, '0', '2017-11-22 09:13:18', NULL, NULL);
INSERT INTO `ls_district` VALUES (3097, '昆玉市', 341, 9, '0', '2017-11-22 09:13:41', NULL, NULL);
INSERT INTO `ls_district` VALUES (3105, '21', 258, 1, '0', '2019-11-21 16:47:47', NULL, NULL);

-- ----------------------------
-- Table structure for ls_email_setting
-- ----------------------------
DROP TABLE IF EXISTS `ls_email_setting`;
CREATE TABLE `ls_email_setting`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `sender_mail` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '发信邮箱',
  `sender_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '发信人',
  `smtp_server` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'SMTP的服务器地址',
  `smtp_port` int(11) NOT NULL COMMENT 'SMTP 的端口',
  `username` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '邮箱帐号',
  `password` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '邮箱密码',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '邮箱设置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ls_login_setting
-- ----------------------------
DROP TABLE IF EXISTS `ls_login_setting`;
CREATE TABLE `ls_login_setting`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `codeType` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '登录类型 1 新浪 2qq  3微信',
  `column_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字段名称',
  `column_value` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字段值',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 131 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '登录设置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ls_pay_setting
-- ----------------------------
DROP TABLE IF EXISTS `ls_pay_setting`;
CREATE TABLE `ls_pay_setting`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id	',
  `codeType` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '支付方式 1:支付宝 2:微信 3:银联 4:预存款 5:微信APP支付 6:微信小程序支付',
  `column_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字段名称',
  `column_value` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '字段值',
  `store_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 562 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '支付设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ls_province
-- ----------------------------
DROP TABLE IF EXISTS `ls_province`;
CREATE TABLE `ls_province`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '省份的名称',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记 0 未删除 1删除	',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 34 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '区域省表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ls_province
-- ----------------------------
INSERT INTO `ls_province` VALUES (1, '北京', 4, '0', NULL, '2017-05-16 01:27:11', NULL);
INSERT INTO `ls_province` VALUES (2, '天津', 6, '0', '2017-05-15 15:18:50', '2019-06-04 17:54:27', NULL);
INSERT INTO `ls_province` VALUES (3, '河北', 31, '0', '2017-05-15 16:21:17', NULL, '2019-06-04 14:47:16');
INSERT INTO `ls_province` VALUES (4, '山西', 32, '0', '2017-06-01 09:42:50', NULL, NULL);
INSERT INTO `ls_province` VALUES (5, '内蒙古', 33, '0', '2017-11-02 15:46:06', NULL, NULL);
INSERT INTO `ls_province` VALUES (6, '辽宁', 9, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (7, '吉林', 10, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (8, '黑龙江', 11, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (9, '上海', 5, '0', NULL, '2019-06-05 09:18:07', NULL);
INSERT INTO `ls_province` VALUES (10, '江苏', 8, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (11, '浙江', 12, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (12, '安徽', 13, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (13, '福建', 14, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (14, '江西', 15, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (15, '山东', 16, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (16, '河南', 17, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (17, '湖北', 18, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (18, '湖南', 19, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (19, '广东', 20, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (20, '广西', 21, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (21, '海南', 22, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (22, '重庆', 3, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (23, '四川', 23, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (24, '贵州', 1, '0', NULL, '2017-11-03 15:58:08', NULL);
INSERT INTO `ls_province` VALUES (25, '云南', 24, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (26, '西藏', 25, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (27, '陕西', 26, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (28, '甘肃', 27, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (29, '青海', 28, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (30, '宁夏', 29, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (31, '新疆', 30, '0', NULL, NULL, NULL);
INSERT INTO `ls_province` VALUES (32, '香港', 1, '0', NULL, '2017-11-02 17:23:28', NULL);
INSERT INTO `ls_province` VALUES (33, '澳门', 2, '0', NULL, '2017-11-02 17:23:32', NULL);

-- ----------------------------
-- Table structure for ls_sms_setting
-- ----------------------------
DROP TABLE IF EXISTS `ls_sms_setting`;
CREATE TABLE `ls_sms_setting`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `secret` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'AppSecret',
  `url` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '短信接口地址',
  `sign` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '短信签名',
  `template_id` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '模板id',
  `writeoff_template_id` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '核销门店订单的模版id',
  `virtual_order_template_id` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '虚拟订单核销的模版id',
  `key` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'AppKey',
  `audit_template_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区团购审核结果通知模版id',
  `settlement_template_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区团购佣金结算模版id',
  `withdraw_template_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区团购提现打款模版id',
  `status` int(5) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '短信接口设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ls_station_letter
-- ----------------------------
DROP TABLE IF EXISTS `ls_station_letter`;
CREATE TABLE `ls_station_letter`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `customer_id` bigint(20) NOT NULL COMMENT '会员id',
  `title` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站内信标题',
  `content` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '站内信内容',
  `is_read` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '是否已读  0 未读  1 已读 默认0 ',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记  0 未删除 1 删除 默认0 ',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `customer_id`(`customer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1652 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '站内信' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ls_system_seo
-- ----------------------------
DROP TABLE IF EXISTS `ls_system_seo`;
CREATE TABLE `ls_system_seo`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT ' 主键id',
  `title` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'seo标题',
  `key_word` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'seo关键字',
  `seo_desc` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'seo描述',
  `is_open` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '是否开启  0 未开启 1 开启 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统seo设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ls_system_setting
-- ----------------------------
DROP TABLE IF EXISTS `ls_system_setting`;
CREATE TABLE `ls_system_setting`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `site_url` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '前端地址',
  `site_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '网站名称',
  `logo` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '网站LOGO(前端搜索页旁边和店铺登陆页)',
  `label_log` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'pc端，admin端，store端标签图片',
  `site_login` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'pc端登录背景图片',
  `site_register` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'pc端注册背景图片',
  `store_login` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '店铺端登录图片',
  `store_register` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '店铺端注册图片',
  `copyright_info` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '版权信息（pc和store底部）',
  `register_protocol` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '注册协议（pc端）',
  `store_register_protocol` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '店铺端注册协议',
  `store_open_protocol` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '店铺端开店协议',
  `phone` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '联系电话',
  `admin_logo` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'admin端登录logo',
  `admin_index_logo` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'admin端首页logo',
  `captcha_open` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否开启验证码   0 开启 1 不开启 默认0 ',
  `store_spu_audit` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '店铺商品审核开关  0 需要审核 1 不需要 默认0 ',
  `member_price_status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '会员价开关状态 0开启 1不开启 默认0',
  `crowdfunding_protocol` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '众筹协议',
  `h5_call_back_domain` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'h5域名',
  `pc_call_back_domain` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'pc域名',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 202 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '系统设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of ls_system_setting
-- ----------------------------
INSERT INTO `ls_system_setting` VALUES (201, 'https://mojin.51wangshi.com/', '魔金商城', 'http://images.lecshop.cn/20190626/1561517476715.jpg', '//images.lecshop.cn/20190626/1561517471744.jpg', 'http://images.lecshop.cn/20190626/1561517487296.jpg', NULL, '', NULL, '2018 © LecShop.', '<h4 style=\"color: #000000; font-size: 12px; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">用户注册协议</span></h4>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">本协议是您与网站(简称\"本站\"，网址：www.XXXX.com）所有者（以下简称为\"\"）之间就网站服务等相关事宜所订立的契约，请您仔细阅读本注册协议，您点击\"同意并继续\"按钮后，本协议即构成对双方有约束力的法律文件。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第1条 本站服务条款的确认和接纳</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1.1本站的各项电子服务的所有权和运作权归所有。用户同意所有注册协议条款并完成注册程序，才能成为本站的正式用户。用户确认：本协议条款是处理双方权利义务的契约，始终有效，法律另有强制性规定或双方另有特别约定的，依其规定。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1.2用户点击同意本协议的，即视为用户确认自己具有享受本站服务、下单购物等相应的权利能力和行为能力，能够独立承担法律责任。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1.3如果您在18周岁以下，您只能在父母或监护人的监护参与下才能使用本站。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">1.4保留在中华人民共和国大陆地区法施行之法律允许的范围内独自决定拒绝服务、关闭用户账户、清除或编辑内容或取消订单的权利。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第2条 本站服务</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">2.1通过互联网依法为用户提供互联网信息等服务，用户在完全同意本协议及本站规定的情况下，方有权使用本站的相关服务。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">2.2用户必须自行准备如下设备和承担如下开支：（1）上网设备，包括并不限于电脑或者其他上网终端、调制解调器及其他必备的上网装置；（2）上网开支，包括并不限于网络接入费、上网设备租用费、手机流量费等。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第3条 用户信息</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">3.1用户应自行诚信向本站提供注册资料，用户同意其提供的注册资料真实、准确、完整、合法有效，用户注册资料如有变动的，应及时更新其注册资料。如果用户提供的注册资料不合法、不真实、不准确、不详尽的，用户需承担因此引起的相应责任及后果，并且保留终止用户使用各项服务的权利。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">3.2用户在本站进行浏览、下单购物等活动时，涉及用户真实姓名/名称、通信地址、联系电话、电子邮箱等隐私信息的，本站将予以严格保密，除非得到用户的授权或法律另有规定，本站不会向外界披露用户隐私信息。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">3.3用户注册成功后，将产生用户名和密码等账户信息，您可以根据本站规定改变您的密码。用户应谨慎合理的保存、使用其用户名和密码。用户若发现任何非法使用用户账号或存在安全漏洞的情况，请立即通知本站并向公安机关报案。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">3.4用户同意，拥有通过邮件、短信电话等形式，向在本站注册、购物用户、收货人发送订单信息、促销活动等告知信息的权利。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">3.5用户不得将在本站注册获得的账户借给他人使用，否则用户应承担由此产生的全部责任，并与实际使用人承担连带责任。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">3.6用户同意，有权使用用户的注册信息、用户名、密码等信息，登录进入用户的注册账户，进行证据保全，包括但不限于公证、见证等。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第4条 用户依法言行义务</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">本协议依据国家相关法律法规规章制定，用户同意严格遵守以下义务：</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（1）不得传输或发表：煽动抗拒、破坏宪法和法律、行政法规实施的言论，煽动颠覆国家政权，推翻社会主义制度的言论，煽动分裂国家、破坏国家统一的的言论，煽动民族仇恨、民族歧视、破坏民族团结的言论；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（2）从中国大陆向境外传输资料信息时必须符合中国有关法规；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（3）不得利用本站从事洗钱、窃取商业秘密、窃取个人信息等违法犯罪活动；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（4）不得干扰本站的正常运转，不得侵入本站及国家计算机信息系统；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（5）不得传输或发表任何违法犯罪的、骚扰性的、中伤他人的、辱骂性的、恐吓性的、伤害性的、庸俗的，淫秽的、不文明的等信息资料；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（6）不得传输或发表损害国家社会公共利益和涉及国家安全的信息资料或言论；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（7）不得教唆他人从事本条所禁止的行为；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（8）不得利用在本站注册的账户进行牟利性经营活动；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（9）不得发布任何侵犯他人著作权、商标权等知识产权或合法权利的内容；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">用户应不时关注并遵守本站不时公布或修改的各类合法规则规定。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">本站保有删除站内各类不符合法律政策或不真实的信息内容而无须通知用户的权利。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">若用户未遵守以上规定的，本站有权作出独立判断并采取暂停或关闭用户帐号等措施。用户须对自己在网上的言论和行为承担法律责任。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第5条 商品信息</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">本站上的商品价格、数量、是否有货等商品信息随时都有可能发生变动，本站不作特别通知。由于网站上商品信息的数量极其庞大，虽然本站会尽最大努力保证您所浏览商品信息的准确性，但由于众所周知的互联网技术因素等客观原因存在，本站网页显示的信息可能会有一定的滞后性或差错，对此情形您知悉并理解；欢迎纠错，并会视情况给予纠错者一定的奖励。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">为表述便利，商品和服务简称为\"商品\"或\"货物\"。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第6条 订单</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">6.1在您下订单时，请您仔细确认所购商品的名称、价格、数量、型号、规格、尺寸、联系地址、电话、收货人等信息。收货人与用户本人不一致的，收货人的行为和意思表示视为用户的行为和意思表示，用户应对收货人的行为及意思表示的法律后果承担连带责任。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">6.2除法律另有强制性规定外，双方约定如下：本站上销售方展示的商品和价格等信息仅仅是要约邀请，您下单时须填写您希望购买的商品数量、价款及支付方式、收货人、联系方式、收货地址（合同履行地点）、合同履行方式等内容；系统生成的订单信息是计算机信息系统根据您填写的内容自动生成的数据，仅是您向销售方发出的合同要约；销售方收到您的订单信息后，只有在销售方将您在订单中订购的商品从仓库实际直接向您发出时（ 以商品出库为标志），方视为您与销售方之间就实际直接向您发出的商品建立了合同关系；如果您在一份订单里订购了多种商品并且销售方只给您发出了部分商品时，您与销售方之间仅就实际直接向您发出的商品建立了合同关系；只有在销售方实际直接向您发出了订单中订购的其他商品时，您和销售方之间就订单中该其他已实际直接向您发出的商品才成立合同关系。您可以随时登录您在本站注册的账户，查询您的订单状态。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">6.3由于市场变化及各种以合理商业努力难以控制的因素的影响，本站无法保证您提交的订单信息中希望购买的商品都会有货；如您拟购买的商品，发生缺货，您有权取消订单。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第7条 配送</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">7.1销售方将会把商品（货物）送到您所指定的收货地址，所有在本站上列出的送货时间为参考时间，参考时间的计算是根据库存状况、正常的处理过程和送货时间、送货地点的基础上估计得出的。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">7.2因如下情况造成订单延迟或无法配送等，销售方不承担延迟配送的责任：</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（1）用户提供的信息错误、地址不详细等原因导致的；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（2）货物送达后无人签收，导致无法配送或延迟配送的；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（3）情势变更因素导致的；</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">（4）不可抗力因素导致的，例如：自然灾害、交通戒严、突发战争等。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第8条 所有权及知识产权条款</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">8.1用户一旦接受本协议，即表明该用户主动将其在任何时间段在本站发表的任何形式的信息内容（包括但不限于客户评价、客户咨询、各类话题文章等信息内容）的财产性权利等任何可转让的权利，如著作权财产权（包括并不限于：复制权、发行权、出租权、展览权、表演权、放映权、广播权、信息网络传播权、摄制权、改编权、翻译权、汇编权以及应当由著作权人享有的其他可转让权利），全部独家且不可撤销地转让给所有，用户同意有权就任何主体侵权而单独提起诉讼。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">8.2本协议已经构成《中华人民共和国著作权法》第二十五条（条文序号依照2011年版著作权法确定）及相关法律规定的著作财产权等权利转让书面协议，其效力及于用户在网站上发布的任何受著作权法保护的作品内容，无论该等内容形成于本协议订立前还是本协议订立后。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">8.3用户同意并已充分了解本协议的条款，承诺不将已发表于本站的信息，以任何形式发布或授权其它主体以任何方式使用（包括但限于在各类网站、媒体上使用）。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">8.4是本站的制作者,拥有此网站内容及资源的著作权等合法权利,受国家法律保护,有权不时地对本协议及本站的内容进行修改，并在本站张贴，无须另行通知用户。在法律允许的最大限度范围内，对本协议及本站内容拥有解释权。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">8.5除法律另有强制性规定外，未经明确的特别书面许可,任何单位或个人不得以任何方式非法地全部或部分复制、转载、引用、链接、抓取或以其他方式使用本站的信息内容，否则，有权追究其法律责任。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">8.6本站所刊登的资料信息（诸如文字、图表、标识、按钮图标、图像、声音文件片段、数字下载、数据编辑和软件），均是或其内容提供者的财产，受中国和国际版权法的保护。本站上所有内容的汇编是的排他财产，受中国和国际版权法的保护。本站上所有软件都是或其关联公司或其软件供应商的财产，受中国和国际版权法的保护。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第9条 责任限制及不承诺担保</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">除非另有明确的书面说明,本站及其所包含的或以其它方式通过本站提供给您的全部信息、内容、材料、产品（包括软件）和服务，均是在\"按现状\"和\"按现有\"的基础上提供的。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">除非另有明确的书面说明,不对本站的运营及其包含在本网站上的信息、内容、材料、产品（包括软件）或服务作任何形式的、明示或默示的声明或担保（根据中华人民共和国法律另有规定的以外）。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">不担保本站所包含的或以其它方式通过本站提供给您的全部信息、内容、材料、产品（包括软件）和服务、其服务器或从本站发出的电子信件、信息没有病毒或其他有害成分。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">如因不可抗力或其它本站无法控制的原因使本站销售系统崩溃或无法正常使用导致网上交易无法完成或丢失有关的信息、记录等，会合理地尽力协助处理善后事宜。</span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第10条 协议更新及用户关注义务</span></h5>\n<p><span style=\"font-family: 微软雅黑, sans-serif;\"><span style=\"color: #000000; line-height: 16px;\">根据国家法律法规变化及网站运营需要，有权对本协议条款不时地进行修改，修改后的协议一旦被张贴在本站上即生效，并代替原来的协议。用户可随时登录查阅最新协议；</span><strong style=\"color: #000000; line-height: 16px;\"><em>用户有义务不时关注并阅读最新版的协议及网站公告。如用户不同意更新后的协议，可以且应立即停止接受网站依据本协议提供的服务；如用户继续使用本网站提供的服务的，即视为同意更新后的协议。建议您在使用本站之前阅读本协议及本站的公告。</em></strong><span style=\"color: #000000; line-height: 16px;\">&nbsp;</span><span style=\"color: #000000; line-height: 16px;\">如果本协议中任何一条被视为废止、无效或因任何理由不可执行，该条应视为可分的且并不影响任何其余条款的有效性和可执行性。</span></span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第11条 法律管辖和适用</span></h5>\n<p><span style=\"font-family: 微软雅黑, sans-serif;\"><span style=\"color: #000000; line-height: 16px;\">本协议的订立、执行和解释及争议的解决均应适用在中华人民共和国大陆地区适用之有效法律（但不包括其冲突法规则）。 如发生本协议与适用之法律相抵触时，则这些条款将完全按法律规定重新解释，而其它有效条款继续有效。 如缔约方就本协议内容或其执行发生任何争议，双方应尽力友好协商解决；协商不成时，任何一方均可向有管辖权的中华人民共和国大陆地区法院提起诉讼。</span></span></p>\n<h5 style=\"color: #000000;\"><span style=\"font-family: 微软雅黑, sans-serif;\">第12条 其他</span></h5>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">12.1网站所有者是指在政府部门依法许可或备案的网站经营主体。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">12.2尊重用户和消费者的合法权利，本协议及本网站上发布的各类规则、声明等其他内容，均是为了更好的、更加便利的为用户和消费者提供服务。本站欢迎用户和社会各界提出意见和建议，将虚心接受并适时修改本协议及本站上的各类规则。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">12.3本协议内容中以黑体、加粗、下划线、斜体等方式显著标识的条款，请用户着重阅读。</span></p>\n<p style=\"word-wrap: break-word; margin-top: 5px; margin-bottom: 5px; color: #000000; line-height: 16px;\"><span style=\"font-family: 微软雅黑, sans-serif;\">12.4您点击本协议下方的\"同意并继续\"按钮即视为您完全接受本协议，在点击之前请您再次确认已知悉并完全理解本协议的全部内容。</span></p>\n<div>&nbsp;</div>', NULL, '<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">本协议由缔约双方在自愿、平等、公平及诚实信用原则的基础上，根据《中华人民共和国合同法》等相关法律、法规的规定。本协议由协议正文、附件及依据本协议公示于&ldquo;魔金 mojin<span lang=\"EN-US\">.cn</span>&rdquo;开放平台（以下简称&ldquo;魔金平台&rdquo;）的各项规则所组成，协议附件及规则与本协议具有同等法律效力，如规则与本协议约定不一致的，以公布生效日期或签署日期在后的文件为准执行。本协议各条的标题仅为方便阅读而设，无意成为本协议的一部分，也不影响本协议的含义或解释。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;</span><strong><span style=\"font-family: 微软雅黑, sans-serif;\">第一条<span lang=\"EN-US\">&nbsp;</span>相关定义及解释</span></strong></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.1&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">魔金：北京魔金世纪贸易有限公司及其旗下子公司、分公司、分支机构或相关关联公司统称为&ldquo;魔金&rdquo;，本协议中提及的应由甲方或&ldquo;魔金&rdquo;行使的权利和履行的义务，由&ldquo;魔金&rdquo;内部负责相应区域及业务范围的公司分别履行。本协议由北京魔金世纪贸易有限公司代表&ldquo;魔金&rdquo;与乙方签署。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.2&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&ldquo;魔金 mojin<span lang=\"EN-US\">.cn</span>&rdquo;网站：指由&ldquo;魔金&rdquo;提供技术支持和服务的域名为<span lang=\"EN-US\">&nbsp;Lecshop.cn&nbsp;</span>的网站。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.3&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">魔金平台：指运行于&ldquo;魔金 mojin<span lang=\"EN-US\">.cn</span>&rdquo;网站的&ldquo;魔金 mojin<span lang=\"EN-US\">.cn</span>&rdquo;开放平台，是&ldquo;魔金 mojin<span lang=\"EN-US\">.cn</span>&rdquo;网站上为用户提供信息发布、交流，第三方经营者开设店铺经营，以及其他技术服务的电子商务交易服务平台。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">1.4&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&ldquo;魔金 mojin<span lang=\"EN-US\">.cn</span>&rdquo;网站用户：指所有在&ldquo;魔金 mojin<span lang=\"EN-US\">.cn</span>&rdquo;网站上注册成为&ldquo;魔金 mojin<span lang=\"EN-US\">.cn</span>&rdquo;注册会员的法人、自然人及其他组织，本协议中统称为&ldquo;用户&rdquo;，除非另有说明，否则&ldquo;用户&rdquo;均指此含义。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.5&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">商家注册及入驻：商家注册指欲成为&ldquo;魔金平台&rdquo;第三方经营者的商家（本文或称&ldquo;卖家&rdquo;），依据&ldquo;京东平台&rdquo;入驻流程和要求完成在线信息提交，经&ldquo;魔金&rdquo;审核同意后，商家可以使用其自行设定的京东平台用户名和密码登陆&ldquo;魔金平台&rdquo;，以开立店铺开展经营；商家入驻，亦称&ldquo;店铺入驻&rdquo;指第三方<span lang=\"EN-US\">&nbsp;</span>经营者完成商家注册，通过资质审核且满足本协议第四条店铺服务开通条件后成为&ldquo;魔金平台&rdquo;第三方经营者的过程；本协议中的商家指本协议缔约方中的&ldquo;乙方&rdquo;。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.6&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">魔金平台用户名：亦称&ldquo;店铺用户名&rdquo;，是指商家完成商家注册后获取的与自设密码共同使用以登陆&ldquo;京东平台&rdquo;商家管理系统，使用&ldquo;魔金平台&rdquo;店铺服务的登陆账户，每一个魔金平台用户名对应一个店铺。商家应妥善保管店铺用户名及密码信息，不得擅自转让或授权他人使用。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.7&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">店铺：商家在完成商家注册及商家入驻流程后，为进行合法经营，依据协议约定和魔金平台规则由乙方申请，&ldquo;魔金&rdquo;审核通过的具有独立且唯一性<span lang=\"EN-US\">&nbsp;ID</span>（英文<span lang=\"EN-US\">&nbsp;IDentity&nbsp;</span>的缩写，意为&ldquo;身份标识号码&rdquo;）、特定名称（可依据相关平台规则进行调整）的网络化虚拟商铺，乙方可依据经营需要，开设一个或多个店铺。乙方通过魔金平台用户名可以实现对该店铺的管理，包括但不仅限于商品信息上传、修改、删除处理，交易跟踪、取消等。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.8&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">魔金平台规则：指标示在&ldquo;魔金平台&rdquo;之上的，与商家经营有关的任何规范性文件，包括但不限于卖家手册、卖家后台公告、卖家后台帮助中心等。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.9&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">保证金：商家向&ldquo;魔金&rdquo;缴纳的用以保证本协议履行及对商品和服务质量进行担保的金额，&ldquo;魔金&rdquo;可以依照本协议的相关约定对其进行处置</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.10&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">平台使用费：商家使用&ldquo;魔金平台&rdquo;各项服务时按照本协议约定缴纳的固定技术服务费用。具体缴纳标准见本协议附件。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1.11&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">技术服务费：商家根据经营类目在达成每一单交易时按比例向&ldquo;魔金&rdquo;缴纳的技术服务费用，具体缴纳标准及方式见本协议附件。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><strong><span lang=\"EN-US\" style=\"font-family: 微软雅黑, sans-serif;\">&nbsp;</span></strong><strong><span style=\"font-family: 微软雅黑, sans-serif;\">第二条<span lang=\"EN-US\">&nbsp;</span>服务内容及乙方店铺经营方式</span></strong></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2.1&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">甲方依照本协议第四条约定为乙方开通店铺服务后，乙方可使用&ldquo;魔金平台&rdquo;发布商品信息，与愿意购买乙方商品的甲方其他用户进行在线交流，订立买卖合同，并向通过&ldquo;魔金平台&rdquo;购买其商品的用户提供售后服务，同时可参与&ldquo;魔金平台&rdquo;相关活动及使用&ldquo;魔金平台&rdquo;同意提供的其他有偿服务。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2.2&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">除上述服务内容外，乙方可使用本协议附件列明的其他甲方提供的有偿服务，具体服务内容以本协议附件约定或双方另行签署（含乙方同意相关有偿服务的电子协议等以数据电文形式签署）的文件约定为准。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2.3&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方店铺经营方式：乙方店铺内商品，均以乙方自身名义进行商品信息上传、展示、咨询答复、商品销售、发票开具、物流配送服务及售后服务提供等；乙方销售及服务出现争议、纠纷、国家机关机构调查时，由乙方以销售者身份处理。&ldquo;魔金&rdquo;不参与乙方店铺的经营中，除依据本协议相关约定外，也</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">不直接介入乙方与其他人间的争议和纠纷。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><strong><span style=\"font-family: 微软雅黑, sans-serif;\">第三条<span lang=\"EN-US\">&nbsp;</span>入驻条件及证明文件提交</span></strong></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;3.1&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">入驻条件乙方申请成为&ldquo;魔金平台&rdquo;入驻商家，在&ldquo;魔金平台&rdquo;开展经营活动，须满足以下条件：</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1)&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方已依照中华人民共和国法律注册并领取合法有效的营业执照及其他经营许可；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2)&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方申请经营的商品来源合法，资质齐全；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;3)&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方同意本协议及魔金平台相关规则。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;3.2&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">证明文件提交</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;3.2.1&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方须根据魔金平台相关规则及要求向甲方提交证明文件或其他相关证明，包括但不限于营业执照、税务登记证、授权委托书、商标注册证、质检报告、报关单、检验检疫证书、产品来源地证明等。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;3.2.2&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方保证向甲方提供的上述证明文件或其他相关证明真实、合法、准确、有效，并保证上述证明文件或其他相关证明发生任何变更或更新时，及时通知甲方，若上述文件变更或更新导致乙方不符合本协议所规定入驻条件的，甲方有权单方全部或部分限制乙方经营，直至终止本协议。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;3.2.3&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方对其提交的证明文件或其他相应证明的真实性、合法性、准确性、有效性承担全部法律责任，若因乙方提交虚假、过期文件或未及时更新或通知证明文件导致纠纷或被相关国家机关处罚的，由乙方独立承担全部法律责任，如因此造成魔金（包括&ldquo;魔金&rdquo;合作方、代理人或职员）损失的，乙方应予以赔偿。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><strong><span style=\"font-family: 微软雅黑, sans-serif;\">第四条<span lang=\"EN-US\">&nbsp;</span>店铺服务开通及停止</span></strong></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;4.1&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">对于乙方拟开展经营的特定店铺，甲方在乙方提出开店申请并满足以下条件后<span lang=\"EN-US\">&nbsp;7&nbsp;</span>个工作日内为乙方开通服务，甲方将在服务正式开通前一个工作日以邮件方式通知乙方。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;1)&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方已按照本协议附件《乙方信息确认表》或者其他补充协议（若有）中确定的金额足额缴纳保证金；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;2)&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方已按照本协议及魔金平台相关规则提交证明文件或其他相关证明并已通过甲方审核；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;3)&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方已注册成为魔金平台用户且本协议已签署生效；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;4)&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方已按照附件《店铺信息表》或相关补充协议（若有）足额缴纳特定店铺相应服务期的平台使用费。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;4.2&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">甲方为乙方开通服务后，乙方可利用魔金平台用户名及自设密码登陆商家后台，根据魔金平台相关规则及流程向乙方特定店铺上传、发布商品信息，与用户交流达成交易，使用本协议约定的其他有偿服务等。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;4.3&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方店铺服务的停止：</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">4.3.1&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方需要停止店铺服务的，应至少提前七个工作日向甲方提出申请，经甲方审核同意后由甲方停止该店铺的服务功能；为弥补甲方已投入的人力、物力和技术支持，乙方同意甲方不退还该店铺未到期部分对应的平台使用费；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;4.3.2&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">出现以下任一情形时，甲方有权随时停止乙方相关店铺的服务；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;4.3.2.1&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方不满足入驻条件的；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;4.3.2.2&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方提供虚假资质文件的；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;4.3.2.3&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方未完成承诺销售额的；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;4.3.2.4&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方产品价格、规格等信息标示错误，导致行政处罚、争议和纠纷的；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;4.3.2.5&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方产品质量、标识不合格的，或者产品涉嫌走私、假冒伪劣、旧货、返修品的；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;4.3.2.6&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">未经甲方事先审核产品品牌，而上传某品牌商品的；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;4.3.2.7&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方连续<span lang=\"EN-US\">&nbsp;30</span>（三十）日或累计<span lang=\"EN-US\">&nbsp;45</span>（四十五）日未正常经营店铺的；</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;4.3.2.8&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">其他违反本协议约定或魔金平台规则的，或者其他甲方认为侵犯魔金或消费者权益的。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;4.4&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方未经甲方同意，擅自停止店铺经营，或者乙方因为出现<span lang=\"EN-US\">&nbsp;4.3.2&nbsp;</span>情形被甲方停止店铺服务的，乙方已缴纳的相关店铺的平台使用费未到期部分，作为乙方向甲方支付的违约金，该金额不足以冲抵乙方应付违约金和赔偿金时，乙方应另行支付差额。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><strong><span style=\"font-family: 微软雅黑, sans-serif;\">第五条<span lang=\"EN-US\">&nbsp;</span>双方权利及义务</span></strong></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;5.1&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">甲方根据本协议向乙方提供电子商务交易平台及相应技术支持服务，尽力维护&ldquo;魔金平台&rdquo;的正常稳定运行，并努力提升和改进技术，对平台功能及服务进行更新、升级，不断提升平台性能和交易效率。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;5.2&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">甲方对乙方在使用&ldquo;魔金平台&rdquo;过程中遇到的问题及提出的建议和意见积极予以回复，可依乙方需求对其使用&ldquo;魔金平台&rdquo;提供合理的指导和培训。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;5.3&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方同意甲方根据乙方营业执照所载明的经营范围及乙方申请经营的经营类目，核实及调整乙方在&ldquo;京<span lang=\"EN-US\">&nbsp;</span>东平台&rdquo;经营的具体商品的种类、数量和类目范围。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;5.4&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方同意并自愿遵守甲方根据国家相关法律法规、政策及平台运营情况，对公示于&ldquo;魔金平台&rdquo;的规则、流程、收费标准等进行更新、调整。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;5.5&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方同意甲方对乙方提供的相关资质文件及各类信息资料进行审核。甲方审核为形式审核，审核通过并不代表甲方对审核内容的真实性、合法性、准确性、及时性的确认，乙方仍须对其提交的资料的真实性、合法性、准确性、及时性等承担相应的法律责任。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;5.6&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">甲方有权对乙方的注册信息、上传的相关数据信息、在&ldquo;魔金平台&rdquo;发布的其他信息及交易行为进行监督检查，对发现的违法违规信息及其相关内容，乙方同意甲方不经通知立即删除，对发现的其他问题或疑问有权向乙方发出询问及要求改正的通知，乙方应在接到通知后立即做出说明或改正。对乙方前述不当行为，甲方有权追究其违约、侵权责任并<span lang=\"EN-US\">/</span>或解除本协议。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;5.7&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">甲方有权将经国家生效法律文书或行政文书确定的乙方违法违规事件，或乙方已确认的乙方违反本协议相关约定的事项，在&ldquo;魔金平台&rdquo;上予以公示；乙方多次违规或者有严重违约、违规情形的，甲方有权对其采取暂停店铺运营、扣除保证金直至终止本协议等措施，上述措施不足以补偿甲方损失的，甲方有权继续向乙方追偿。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp; &nbsp; 5.8&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">如乙方的运营情况不能满足&ldquo;魔金平台&rdquo;要求，经限期整改调整后，仍无法满足平台运营条件的，甲方有权解除本协议，停止向乙方提供服务。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;5.9&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">甲方有权根据市场情况及&ldquo;魔金平台&rdquo;入驻商家经营情况组织相应的促销活动，乙方应根据自身经营<span lang=\"EN-US\">&nbsp;</span>情况及商品情况积极予以支持。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;5.10&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">甲方有权要求乙方提供与乙方商品、售后服务等相关的信息，以便于客户直接向&ldquo;魔金平台&rdquo;客服中心进行咨询时予以回复，对于甲方无法回答或属乙方掌握的情况，甲方有权要求乙方在指定的时限内予以回复或给出相应方案，对乙方未及时解决的客户咨询及投诉，甲方有权对乙方采取相应处理措施。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">5.11&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">如因乙方商品、发布的信息或提供的售后服务问题而引发客户对甲方及<span lang=\"EN-US\">/</span>或&ldquo;魔金平台&rdquo;的诉讼，甲方及<span lang=\"EN-US\">/</span>或&ldquo;魔金平台&rdquo;有权披露乙方为实际商品提供商，乙方应承担因客户诉讼而产生的全部法律责任，如因此而给甲方及<span lang=\"EN-US\">/</span>或&ldquo;魔金平台&rdquo;造成损失的，甲方有权要求乙方赔偿甲方及&ldquo;魔金平台&rdquo;的全部损失。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;5.12&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">乙方同意&ldquo;魔金&rdquo;根据业务调整情况将本协议项下的权利和义务部分或全部转移给甲方关联公司，但须提前<span lang=\"EN-US\">&nbsp;5&nbsp;</span>日通知乙方。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 13.95pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><strong><span style=\"font-family: 微软雅黑, sans-serif;\">第六条<span lang=\"EN-US\">&nbsp;</span>乙方声明及保证</span></strong></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 13.95pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;6.1&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">保证在&ldquo;魔金平台&rdquo;提交的注册资料真实、准确、合法、有效，对获得的与自设密码共同使用的魔金平台用户名（店铺用户名）妥善保管，不得擅自转让或授权他人使用，并对利用该用户名和密码所进行的一切活动负全部责任。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 13.95pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;6.2&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">保证符合本协议约定的入驻条件，保证向甲方提交的证明文件及其他相关证明真实、准确、合法、有效，并保证在上述资料发生变更时及时通知甲方，并在&ldquo;魔金平台&rdquo;上予以更新。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 13.95pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;6.3&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">保证其有权利订立本协议，其代理人已获得充分授权，并对代理人的行为承担法律责任，同时乙方保证对其雇员、本协议约定的联系人及其他乙方委派的履行本协议的人员的行为承担法律责任。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 13.95pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;6.4&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">保证遵守本协议及附件的相关约定和魔金平台相关规则及流程，在使用&ldquo;魔金平台&rdquo;相关服务时严格<span lang=\"EN-US\">&nbsp;</span>按照上述约定及规则和流程使用，不从事任何有损甲方利益的行为。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 13.95pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;6.5&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">保证对在&ldquo;魔金平台&rdquo;经营的商品拥有合法销售权，商品质量合格，符合国家相关质量标准，不侵犯任何第三方的合法权利，并对其商品质量及商品合法性独立承担全部法律责任。</span></p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 12.85pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\">&nbsp;</p>\n<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; line-height: 13.95pt; background-image: initial; background-attachment: initial; background-size: initial; background-origin: initial; background-clip: initial; background-position: initial; background-repeat: initial;\" align=\"left\"><span lang=\"EN-US\" style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">&nbsp;&nbsp;&nbsp;&nbsp;6.6&nbsp;</span><span style=\"font-size: 9pt; font-family: 微软雅黑, sans-serif;\">保证在&ldquo;魔金平台&rdquo;发布的商品信息真实、准确，符合魔金平台规则及国家相关法律法规的规定，与实际出售的商品一致，不含任何夸大或虚假内容，并对商品信息承担独立的完全的法律责任。若发布的上述信息变更的，乙方应及时在&ldquo;魔金平台&rdquo;予以更新。若因信息未及时变更引起法律后果的，乙方独立承担全部责任。</span></p>', '18000000001', 'http://images.lecshop.cn/20190626/1561517481852.jpg', 'http://images.lecshop.cn/20180104/1515029919503.jpg', '1', '0', '1', '<p>RYJDJYDJ</p>', NULL, NULL);

-- ----------------------------
-- Table structure for ls_upyun_setting
-- ----------------------------
DROP TABLE IF EXISTS `ls_upyun_setting`;
CREATE TABLE `ls_upyun_setting`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name_space` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '空间名',
  `username` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '用户名',
  `password` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '密码',
  `address` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '空间地址',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '又拍云的设置表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for ls_wx_customer_link
-- ----------------------------
DROP TABLE IF EXISTS `ls_wx_customer_link`;
CREATE TABLE `ls_wx_customer_link`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `wx_union_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '微信的联合登录id',
  `customer_id` bigint(20) DEFAULT NULL COMMENT '用户id',
  `wx_open_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '微信的openid',
  `wx_applet_open_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '小程序的openid',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `wx_union_id`(`wx_union_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '微信登录和商城用户的关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_back_order
-- ----------------------------
DROP TABLE IF EXISTS `oms_back_order`;
CREATE TABLE `oms_back_order`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `back_code` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '退单号',
  `order_id` bigint(20) NOT NULL COMMENT '订单id 对应订单表 oms_order中的id',
  `order_code` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '订单号 对应oms_order 表中的order_code\n',
  `store_id` bigint(20) NOT NULL COMMENT '店铺id 平台的为0 ',
  `customer_id` bigint(20) NOT NULL COMMENT '用户id',
  `skuId_nums` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '退货的单品ID多个用,分开  退款的时候不需要，因为退款只能整单退\n1001-1,1002-3 表示单品id为1001 的单品退货1件 单品id为1002的单品退货3件 ',
  `type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '1 退款 2 退货',
  `reason` varchar(40) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '退款／退货原因\n1:不想买了\n2:收货人信息有误\n3:未按指定时间发货\n4:其他\n5:不想买了\n6:商品质量问题\n7:收到商品与描述不符\n8:其他\n9:系统自动申请\n',
  `desc` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '问题说明',
  `credential` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '申请凭据 0 没有任何凭据 1 有发票 2有质检报告',
  `back_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '返回方式 1 快递返回 目前只有快递返回 （退货的时候用户给商城寄送商品）',
  `back_price` decimal(20, 2) DEFAULT NULL COMMENT '退款／退货金额',
  `real_back_price` decimal(20, 2) DEFAULT NULL COMMENT '退货时候实际退款金额',
  `pics` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '上传的退款凭证或者质检发票 多个图片 用, 隔开',
  `status` char(4) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '退款／退货状态  \n1:退款申请 （用户发送退款请求）\n2:退款成功（商家同意退款）\n3:退款拒绝 （商家拒绝退款）\n4:退货申请 （用户发起退货请求）\n5:退货拒绝   （商家拒绝退货）\n6:退货审核通过等待用户填写物流（商家审核通过，等待用户寄回商品）\n7: 待收货  （用户已经寄回商品，等待商家收货确认）\n8：退货完成（商家收货并且同意退款给用户）\n9:退货失败（商家不同意退款）',
  `predeposit_pay` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否预存款支付  0 否 1 是  默认0',
  `logis_company_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '物流公司名称',
  `waybill_code` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '物流单号',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '生成时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `store_id`(`store_id`) USING BTREE,
  INDEX `customer_id`(`customer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 49 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '退单退款表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_back_order_log
-- ----------------------------
DROP TABLE IF EXISTS `oms_back_order_log`;
CREATE TABLE `oms_back_order_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `back_order_id` bigint(20) NOT NULL COMMENT '退单id 对应oms_back_order表中的id',
  `operation_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '操作人类型 1 用户  2 商家\n',
  `message` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '留言',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '1:退款申请 （用户发送退款请求）\n2:退款成功（商家同意退款）\n3:退款拒绝 （商家拒绝退款）\n4:退货申请 （用户发起退货请求）\n5:退货拒绝   （商家拒绝退货）\n6:退货审核通过等待用户填写物流（商家审核通过，等待用户寄回商品）\n7: 待收货  （用户已经寄回商品，等待商家收货确认）\n8：退货完成（商家收货并且同意退款给用户）\n9:退货失败（商家不同意退款）',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '生成时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `back_order_id`(`back_order_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 78 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '退款退货操作日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_billing_records
-- ----------------------------
DROP TABLE IF EXISTS `oms_billing_records`;
CREATE TABLE `oms_billing_records`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_code` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '订单或者退单的code',
  `type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '账单进出类型 0 进 1 出',
  `store_id` bigint(20) NOT NULL COMMENT '店铺id',
  `store_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '店铺名称',
  `record_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '账单记录类型 1 确认收货 2 退款订单 3 退货订单佣金  4 订单关闭（只支付定金） 5 推广订单提成 6 退货订单',
  `order_price` decimal(20, 2) DEFAULT NULL COMMENT '订单实付金额',
  `order_back_price` decimal(20, 2) DEFAULT NULL COMMENT '订单实退金额',
  `order_commission` decimal(20, 2) DEFAULT NULL COMMENT '订单佣金',
  `order_actual_price` decimal(20, 2) DEFAULT NULL COMMENT '订单实际进出金额',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '记录生成时间',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '结算状态 0 未结算 1 已结算 默认0 ',
  `pay_store_id` bigint(20) DEFAULT NULL COMMENT '钱到了哪个支付平台  平台的订单id为0',
  `remark` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `order_code`(`order_code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 104 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '账单记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_commission_records
-- ----------------------------
DROP TABLE IF EXISTS `oms_commission_records`;
CREATE TABLE `oms_commission_records`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `customer_id` bigint(20) DEFAULT NULL COMMENT '会员id',
  `money` decimal(20, 2) DEFAULT NULL COMMENT '金额',
  `type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '类型  0 收入 1 支出',
  `remark` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `nickname` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `pay_store_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `customer_id`(`customer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 30 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '佣金记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_logistics_company
-- ----------------------------
DROP TABLE IF EXISTS `oms_logistics_company`;
CREATE TABLE `oms_logistics_company`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '物流公司名称',
  `code` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '物流公司代码',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记  0未删除 1 删除  默认0	',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '物流公司表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_logistics_company_use
-- ----------------------------
DROP TABLE IF EXISTS `oms_logistics_company_use`;
CREATE TABLE `oms_logistics_company_use`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `store_id` bigint(20) DEFAULT NULL COMMENT '店铺id',
  `company_id` bigint(20) DEFAULT NULL COMMENT '店铺使用的物流公司 id ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `store_id`(`store_id`) USING BTREE,
  INDEX `company_id`(`company_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '店铺使用的物流公司' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_logistics_template
-- ----------------------------
DROP TABLE IF EXISTS `oms_logistics_template`;
CREATE TABLE `oms_logistics_template`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '物流模版名称',
  `is_default` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '1' COMMENT '是否默认模版 0 是 1 否 默认1 ',
  `freight_bear` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '谁承担运费 0 买家 1 商家 默认 0 买家',
  `pricint_method` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '计价方式 0 按件  1 按重量  默认0 ',
  `store_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '店铺id  平台的为 0 ',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记 0 未删除 1 删除 默认0 ',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '物流模版表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_order
-- ----------------------------
DROP TABLE IF EXISTS `oms_order`;
CREATE TABLE `oms_order`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_code` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '订单code',
  `master_order_code` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主订单code  下单可能会同时下多个订单 ，一个master_order_code 可以对应多个order_code 即多个订单',
  `customer_id` bigint(20) NOT NULL COMMENT '订单所属的会员id',
  `price` decimal(20, 2) NOT NULL COMMENT '订单的最终价格(订单的最终成交价格)',
  `presale_price` decimal(20, 2) DEFAULT NULL COMMENT '预售需要支付的金额 （预售订单使用）',
  `original_price` decimal(20, 2) DEFAULT NULL COMMENT '订单原始金额（每个单品详情页面的总价）',
  `freight_price` decimal(20, 2) NOT NULL COMMENT '运费',
  `modify_price` decimal(20, 2) DEFAULT 0.00 COMMENT '订单修改的金额（后端管理员修改）',
  `point_price` decimal(20, 2) DEFAULT NULL COMMENT '积分抵消的金额',
  `coupon_price` decimal(20, 2) DEFAULT NULL COMMENT '优惠卷抵消的价格',
  `red_envelope_price` decimal(20, 2) DEFAULT NULL COMMENT '使用红包减去的价格',
  `concessional_rate` decimal(20, 2) DEFAULT NULL COMMENT '总的优惠价（包含订单使用的优惠卷 积分 红包 ,满减满折的价格）',
  `status` char(2) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '1:待付款  （用户刚下单）\r2:代发货  （用户付完款 等待商城发货）\r3:代收货  （商城已经发货 等待用户确认收货）\r4:已完成  （用户已经确认收货 订单结束）\r5:取消订单 （用户未付款前取消订单）\r6:退款通过  （用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款）\r7:退货通过   （用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品）\r\n',
  `presale_status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '预售订单状态   普通订单 该状态没作用\n0 第一阶段未支付\n1 第一阶段已支付第二阶段未支付\n2 第二阶段已支付   默认0 ',
  `evaluation_status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '评价状态  0 未评价 1 已评价  默认为0 未评价',
  `red_envelope_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '使用红包的code',
  `coupon_no` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '使用的优惠卷的卷码',
  `use_point` int(11) DEFAULT NULL COMMENT '使用的积分数量',
  `pay_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '支付类型  0在线支付  1货到付款 ',
  `store_id` bigint(20) NOT NULL COMMENT '订单店铺id  平台的订单id为0',
  `cancel_reson` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '订单取消原因\n1:现在不想买\n2:商品价格较贵\n3:价格波动\n4:商品缺货\n5:重复下单\n6:收货人信息有误\n7:发票信息有误/发票未开\n8:送货时间过长\n9:其他原因\n0:系统取消',
  `predeposit_pay` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否预存款支付  0 否 1 是  默认0',
  `source` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '订单来源 1pc  2 h5   3 app',
  `waybill_code` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '运单号',
  `order_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '订单类型 0 普通订单 1 定金预售订单 2全款预售订单 3 拼团订单 4 众筹全款 5 众筹1元 6 众筹无回报 7 虚拟商品订单 8 社区团购订单 默认0 普通订单',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `pay_time` timestamp(0) DEFAULT NULL COMMENT '支付时间',
  `delivery_time` timestamp(0) DEFAULT NULL COMMENT '发货时间',
  `receiving_time` timestamp(0) DEFAULT NULL COMMENT '确认收货时间',
  `cancel_time` timestamp(0) DEFAULT NULL COMMENT '订单取消时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `evaluation_time` timestamp(0) DEFAULT NULL COMMENT '订单评价时间',
  `presale_time` timestamp(0) DEFAULT NULL COMMENT '预售订单的时间\n对于定金预售 则是第二阶段付款时间 和发货时间 对于全款预售 则是发货时间',
  `group_head` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '是否团长  0 是 1 否  当订单为拼团订单的时候有用',
  `group_id` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '拼团订单的id  拼团订单的时候有用',
  `group_marketing_id` bigint(20) DEFAULT NULL COMMENT '拼团订单的促销id 拼团订单的时候有用',
  `group_sku_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '拼团的单品id （拼团订单时候有效）',
  `group_status` char(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '-1' COMMENT '拼团状态 -1无状态 0未成团 1已成团 默认-1 ',
  `group_num` int(11) DEFAULT NULL COMMENT '成团的数量',
  `open_group_time` datetime(0) DEFAULT NULL COMMENT '开团时间',
  `auto_handle_status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '拼团订单定时任务处理状态 \'0\'未处理 \'1\'已处理 默认\'0\'',
  `recommended` bigint(20) DEFAULT -1 COMMENT '订单推广人的会员id(订单会员的推广人 ，也就是订单会员的上级的id) 如果为-1 则说明该订单会员没有推荐人或者不是推广订单',
  `s_recommended` bigint(20) DEFAULT -1 COMMENT '订单二级推广人的会员id(订单会员的二级推广人 ，也就是订单会员的上级的上级会员id) 如果为-1 则说明该订单会员没有推荐人或者不是推广订单',
  `crowdfunding_id` bigint(20) DEFAULT NULL COMMENT '众筹id  对应ls_markeing 表中的id',
  `lottery_status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '抽奖状态  0 待抽奖 1 抽中 默认0',
  `write_off_code` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '虚拟订单的核销码',
  `community_buy_customer_id` int(11) DEFAULT NULL COMMENT '社区团购的团长会员id  社区团购的时候使用 对应ums_member表中的id',
  `community_buy_id` int(11) DEFAULT NULL COMMENT '社区团购的团购id  对应s_community_buy 表中的id ',
  `profit` decimal(20, 2) DEFAULT NULL COMMENT '社区团购的利润，社区团购的时候使用',
  `community_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '小区名称 社区团购使用',
  `community_buy_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '社区团购名称',
  `logistics_company` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '物流公司名称',
  `logistics_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '物流公司code',
  `pay_store_id` bigint(20) NOT NULL COMMENT '钱到了哪个支付平台  平台的订单id为0',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `customer_id`(`customer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 419 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_order_attr
-- ----------------------------
DROP TABLE IF EXISTS `oms_order_attr`;
CREATE TABLE `oms_order_attr`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` bigint(20) NOT NULL COMMENT '订单id  对应oms_order 表中的order_code',
  `receipt_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '收货人姓名',
  `receipt_address` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '收货人的地址 （省＋市＋区）',
  `receipt_detail_address` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '收货人的详细地址',
  `receipt_mobile` varchar(11) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '收货人的手机号码',
  `receipt_phone` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '收货人的固定电话',
  `receipt_zip_code` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '收货人的邮编',
  `invoice_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '发票类型  0 不需要发票 1增值税普票 2增值税专票 默认0',
  `invoice_title` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '发票抬头',
  `invoice_content` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '发票内容 \n1:非图书商品\n2:明细\n3:耗材\n4:办公用品',
  `invoice_taxid` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '税号',
  `remark` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '订单备注',
  `gift_infos` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '订单的赠品信息格式为\n[\n    {\n        \"num\": 1,\n        \"skuId\": \"15096899899251410\",\n        \"skuName\": \"平台商品(规格5)\",\n        \"skuNo\": \"201711031419380\",\n        \"specs\": \"版本:规格5|\",\n        \"url\": \"http://lecshop.b0.upaiyun.com/1509689972311.jpg\"\n    }\n]',
  `donation_message` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '捐赠寄语',
  `invoice_company_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单位名称',
  `invoice_register_address` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '注册地址',
  `invoice_register_mobile` varchar(15) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '注册电话',
  `invoice_open_bank` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '开户银行',
  `invoice_bank_account` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '银行账户',
  `invoice_title_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '抬头类型  1 企业  2 个人 ',
  `delivery_time` timestamp(0) DEFAULT NULL COMMENT '送达时间 社区团购使用',
  `address` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所在地区 省+市+区 社区团购使用',
  `detail_address` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '详细信息 取货小区 社区团购使用',
  `pick_up_address` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '提货点 社区团购使用',
  `delivery_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '提货方式 1 团长送货上门 2 自提',
  `house_number` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '门牌号 社区团购使用',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `order_id`(`order_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 396 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单属性表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_order_operation_log
-- ----------------------------
DROP TABLE IF EXISTS `oms_order_operation_log`;
CREATE TABLE `oms_order_operation_log`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` bigint(20) NOT NULL COMMENT '订单id 对应oms_order 表中的id',
  `type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '操作类型 1 确认付款 2 修改金额 3 发货  4取消订单 5修改物流单号 6 核销虚拟商品订单',
  `remark` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '说明',
  `operation_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '操作人',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `order_id`(`order_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 286 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单操作日志' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_order_setting
-- ----------------------------
DROP TABLE IF EXISTS `oms_order_setting`;
CREATE TABLE `oms_order_setting`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `allow_back` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否可以退款和退货  0 可以 1 不可以 默认0 ',
  `aotu_confirm` int(11) DEFAULT 1 COMMENT '订单自定收货几天前的订单 默认1',
  `refunds_desc` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '退款说明',
  `return_desc` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '退货说明',
  `cashon_delivery` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否支持货到付款  0 支付 1 不支持 默认0 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_order_sku
-- ----------------------------
DROP TABLE IF EXISTS `oms_order_sku`;
CREATE TABLE `oms_order_sku`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `order_id` bigint(20) NOT NULL COMMENT '订单id  对应oms_order表中的order_code',
  `sku_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品id 对应pms_sku 表中的id',
  `num` int(11) NOT NULL COMMENT '购买的数量',
  `price` decimal(20, 2) DEFAULT NULL COMMENT '单品的最终价格（原价－优惠价）',
  `sku_price` decimal(20, 2) DEFAULT NULL COMMENT '单品的价格(详情页的价格)',
  `sku_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品的名称',
  `sku_no` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品的编号',
  `sku_image` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品的图片',
  `sku_specs` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品的规格',
  `price_detail` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '使用各个优惠减去的价格（这个字段为了方便扩展使用的是json格式）',
  `commission_rate` decimal(3, 2) DEFAULT NULL COMMENT '单品的分拥比例 0 表示不分佣金',
  `s_commission_rate` decimal(3, 2) DEFAULT NULL COMMENT '单品的分拥比例 0 表示不分佣金',
  `cate_rate` decimal(3, 2) DEFAULT NULL COMMENT '分类扣率',
  `old_price` decimal(20, 2) DEFAULT NULL COMMENT '单品的原价格（社区团购的时候使用）',
  `supply_price` decimal(20, 2) DEFAULT NULL COMMENT '供货价格（社区团购使用）',
  `spu_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `order_id`(`order_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 421 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '订单单品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_shopping_cart
-- ----------------------------
DROP TABLE IF EXISTS `oms_shopping_cart`;
CREATE TABLE `oms_shopping_cart`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `customer_id` bigint(20) NOT NULL COMMENT '会员id',
  `sku_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品id',
  `store_id` bigint(20) NOT NULL COMMENT '店铺id',
  `num` int(11) NOT NULL COMMENT '单品数量',
  `marketing_id` bigint(20) DEFAULT NULL COMMENT '默认的营销id(满减或者满折)',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记 0 未删除 1删除 默认0',
  `create_time` datetime(0) DEFAULT NULL COMMENT '创建时间',
  `spu_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `customer_id`(`customer_id`, `sku_id`) USING BTREE,
  INDEX `customer_id_2`(`customer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 245 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '购物车表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for oms_trans_records
-- ----------------------------
DROP TABLE IF EXISTS `oms_trans_records`;
CREATE TABLE `oms_trans_records`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `ls_trans_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '系统内部订单id',
  `trans_code` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '外部系统交易流水号',
  `type` char(50) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '类型 1 门店订单 2 订单 3 预存款',
  `money` decimal(20, 2) DEFAULT NULL COMMENT '交易金额',
  `order_id` bigint(20) DEFAULT NULL COMMENT '订单id',
  `channel` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '支付方式',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '订单创建时间',
  `pay_time` timestamp(0) DEFAULT NULL COMMENT '支付时间',
  `pay_store_id` bigint(20) NOT NULL COMMENT '钱到了哪个支付平台  平台的订单id为0',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `trans_code`(`trans_code`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 37 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '支付流水表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for pms_attention
-- ----------------------------
DROP TABLE IF EXISTS `pms_attention`;
CREATE TABLE `pms_attention`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `customer_id` bigint(20) NOT NULL COMMENT '会员id',
  `spu_id` bigint(20) NOT NULL COMMENT '商品id',
  `sku_id` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品id',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记 0 未删除 1 删除 默认0 ',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `customerId`(`customer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 54 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品关注' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_attention
-- ----------------------------
INSERT INTO `pms_attention` VALUES (3, 10, 31, '1598270266233310', '0', '2020-08-25 12:10:39', NULL);
INSERT INTO `pms_attention` VALUES (4, 18, 31, '1598270266233310', '0', '2020-09-01 16:12:15', NULL);
INSERT INTO `pms_attention` VALUES (5, 18, 23, '1598079520317230', '0', '2020-09-13 14:09:15', NULL);
INSERT INTO `pms_attention` VALUES (6, 18, 25, '1598079663976250', '0', '2020-09-13 16:49:38', NULL);
INSERT INTO `pms_attention` VALUES (7, 27, 37, '1600066010217370', '0', '2020-09-14 15:09:18', NULL);
INSERT INTO `pms_attention` VALUES (10, 18, 28, '1598231272851280', '0', '2020-09-16 17:22:35', NULL);
INSERT INTO `pms_attention` VALUES (12, 139, 47, '1600611848935470', '0', '2020-09-26 00:39:28', NULL);
INSERT INTO `pms_attention` VALUES (13, 189, 28, '1598231272851280', '0', '2020-09-29 09:12:12', NULL);
INSERT INTO `pms_attention` VALUES (14, 506, 30, '1598257978841300', '0', '2020-10-14 14:07:18', NULL);
INSERT INTO `pms_attention` VALUES (15, 519, 31, '1598270266233310', '0', '2020-10-14 17:58:30', NULL);
INSERT INTO `pms_attention` VALUES (17, 392, 46, '1600590450193460', '0', '2020-10-14 20:42:45', NULL);
INSERT INTO `pms_attention` VALUES (18, 489, 31, '1598270266233310', '0', '2020-10-15 08:51:52', NULL);
INSERT INTO `pms_attention` VALUES (19, 573, 33, '1598445895165330', '0', '2020-10-16 18:32:21', NULL);
INSERT INTO `pms_attention` VALUES (20, 232, 30, '1598257978841300', '0', '2020-10-17 01:49:17', NULL);
INSERT INTO `pms_attention` VALUES (21, 579, 35, '1598962953451350', '0', '2020-10-17 07:36:01', NULL);
INSERT INTO `pms_attention` VALUES (22, 652, 36, '1600064586682360', '0', '2020-10-18 14:59:26', NULL);
INSERT INTO `pms_attention` VALUES (23, 652, 35, '1598962953451350', '0', '2020-10-18 14:59:33', NULL);
INSERT INTO `pms_attention` VALUES (24, 661, 30, '1598257978841300', '0', '2020-10-18 22:19:31', NULL);
INSERT INTO `pms_attention` VALUES (25, 638, 35, '1598962953451350', '0', '2020-10-19 20:43:55', NULL);
INSERT INTO `pms_attention` VALUES (26, 638, 33, '1598445895165330', '0', '2020-10-19 20:45:15', NULL);
INSERT INTO `pms_attention` VALUES (27, 18, 47, '1600611848935470', '0', '2020-10-20 14:17:10', NULL);
INSERT INTO `pms_attention` VALUES (28, 466, 47, '1600611848935470', '0', '2020-10-21 10:02:38', NULL);
INSERT INTO `pms_attention` VALUES (30, 235, 40, '1600520579652400', '0', '2020-10-21 15:38:42', NULL);
INSERT INTO `pms_attention` VALUES (31, 235, 45, '1600590342274450', '0', '2020-10-21 15:38:51', NULL);
INSERT INTO `pms_attention` VALUES (32, 466, 30, '1598257978841300', '0', '2020-10-21 16:01:51', NULL);
INSERT INTO `pms_attention` VALUES (33, 237, 25, '1598079663976250', '0', '2020-10-21 19:09:50', NULL);
INSERT INTO `pms_attention` VALUES (34, 714, 30, '1598257978841300', '0', '2020-10-21 21:32:12', NULL);
INSERT INTO `pms_attention` VALUES (35, 735, 46, '1600590450193460', '0', '2020-10-21 22:14:54', NULL);
INSERT INTO `pms_attention` VALUES (36, 18, 26, '1598230936517260', '0', '2020-10-21 22:24:08', NULL);
INSERT INTO `pms_attention` VALUES (38, 18, 45, '1600590342274450', '0', '2020-10-21 23:34:41', NULL);
INSERT INTO `pms_attention` VALUES (39, 235, 24, '1598079584422240', '0', '2020-10-22 15:35:04', NULL);
INSERT INTO `pms_attention` VALUES (40, 18, 31, '1598270266233311', '0', '2020-10-26 14:52:28', NULL);
INSERT INTO `pms_attention` VALUES (41, 232, 55, '1603783654596550', '0', '2020-10-30 15:33:09', NULL);
INSERT INTO `pms_attention` VALUES (42, 232, 53, '1603783193248530', '0', '2020-10-30 15:33:33', NULL);
INSERT INTO `pms_attention` VALUES (43, 232, 31, '1598270266233310', '0', '2020-10-30 20:09:59', NULL);
INSERT INTO `pms_attention` VALUES (44, 18, 57, '1603879892736571', '0', '2020-10-31 14:11:56', NULL);
INSERT INTO `pms_attention` VALUES (48, 934, 42, '1600520752205420', '0', '2020-11-08 18:27:40', NULL);
INSERT INTO `pms_attention` VALUES (49, 232, 37, '1600520321195370', '0', '2020-11-08 22:42:59', NULL);
INSERT INTO `pms_attention` VALUES (50, 232, 49, '1601343305032490', '0', '2020-11-09 11:39:29', NULL);
INSERT INTO `pms_attention` VALUES (51, 988, 42, '1600520752205420', '0', '2020-11-09 21:11:00', NULL);
INSERT INTO `pms_attention` VALUES (52, 18, 42, '1600520752205420', '0', '2020-11-10 17:39:41', NULL);
INSERT INTO `pms_attention` VALUES (53, 1121, 46, '1600590450193460', '0', '2020-11-17 13:47:39', NULL);

-- ----------------------------
-- Table structure for pms_attribute
-- ----------------------------
DROP TABLE IF EXISTS `pms_attribute`;
CREATE TABLE `pms_attribute`  (
  `id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `type_id` bigint(20) NOT NULL COMMENT '商品属性关联的类型id 对应ls_type表中的id',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '属性名称',
  `sort` int(11) DEFAULT NULL COMMENT '排序 数值越小 排序越前',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记 0 未删除 1 删除 默认0 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `typeId`(`type_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品属性' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_attribute
-- ----------------------------
INSERT INTO `pms_attribute` VALUES ('159807764670340', 4, '年份', 1, '0');
INSERT INTO `pms_attribute` VALUES ('160094787658150', 5, 'q', 3, '0');
INSERT INTO `pms_attribute` VALUES ('160094787658251', 5, 'w', 1, '0');
INSERT INTO `pms_attribute` VALUES ('160259996759860', 6, '颜色', 1, '0');
INSERT INTO `pms_attribute` VALUES ('160259996759861', 6, '大小', 1, '0');
INSERT INTO `pms_attribute` VALUES ('160285999774970', 7, '3', 1, '0');
INSERT INTO `pms_attribute` VALUES ('160285999774971', 7, '4', 1, '0');
INSERT INTO `pms_attribute` VALUES ('160387814725880', 8, '产地', 1, '0');
INSERT INTO `pms_attribute` VALUES ('160487952067690', 9, 'no', 1, '0');

-- ----------------------------
-- Table structure for pms_attribute_value
-- ----------------------------
DROP TABLE IF EXISTS `pms_attribute_value`;
CREATE TABLE `pms_attribute_value`  (
  `id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `attribute_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属性id',
  `type_id` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '类型id',
  `value` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属性值',
  `del_flag` bigint(20) DEFAULT 0 COMMENT '删除标记 0 未删除 1 删除 默认0 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `attribute_id`(`attribute_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '属性值表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_attribute_value
-- ----------------------------
INSERT INTO `pms_attribute_value` VALUES ('15980776467161598077646703400', '159807764670340', '4', '1999', NULL);
INSERT INTO `pms_attribute_value` VALUES ('15980776467161598077646703401', '159807764670340', '4', '2000', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16009478765911600947876581500', '160094787658150', '5', '11', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16009478765911600947876581501', '160094787658150', '5', '22', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16009478765991600947876582510', '160094787658251', '5', '111', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16009478765991600947876582511', '160094787658251', '5', '222', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16025999676051602599967598600', '160259996759860', '6', '红色', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16025999676051602599967598601', '160259996759860', '6', '蓝色', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16025999676051602599967598602', '160259996759860', '6', '白色', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16025999676121602599967598610', '160259996759861', '6', '超大', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16025999676121602599967598611', '160259996759861', '6', '中号', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16025999676121602599967598612', '160259996759861', '6', '小号', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16028599977561602859997749700', '160285999774970', '7', '3', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16028599977561602859997749701', '160285999774970', '7', '仍然', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16028599977631602859997749710', '160285999774971', '7', '44', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16038781472661603878147258800', '160387814725880', '8', '成都', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16038781472661603878147258801', '160387814725880', '8', '重庆', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16043137227591603878147258802', '160387814725880', '8', '陕西', NULL);
INSERT INTO `pms_attribute_value` VALUES ('16048795206841604879520676900', '160487952067690', '9', '1', NULL);

-- ----------------------------
-- Table structure for pms_brand
-- ----------------------------
DROP TABLE IF EXISTS `pms_brand`;
CREATE TABLE `pms_brand`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '品牌名称',
  `nick_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '品牌别名',
  `url` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '品牌的图片地址',
  `certificat_url` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '证书图片',
  `store_id` bigint(20) DEFAULT NULL COMMENT '店铺id 平台的为0 ',
  `status` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '状态  0 申请中  1通过 2 拒绝',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '删除标记 0 未删除 1删除 默认0',
  `reason` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '拒绝原因',
  `create_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者名称',
  `modify_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者名称',
  `del_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除者名称',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 13 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '品牌表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_brand
-- ----------------------------
INSERT INTO `pms_brand` VALUES (3, '七匹狼', NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-fc6c3ed029394822b399c843ff1952c2.', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-39441822fdd4456db419ecb5e5fd2ced.', 0, '3', '0', NULL, 'admin', NULL, NULL, '2020-08-22 14:51:01', NULL, NULL);
INSERT INTO `pms_brand` VALUES (4, '西博会', NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-ed49122b904e4d42809af8ad8d4e4b1d.', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-ee87352ab5894de4b9827ec5106e77c4.', 0, '3', '0', NULL, 'admin', NULL, NULL, '2020-08-22 14:54:02', NULL, NULL);
INSERT INTO `pms_brand` VALUES (5, '金龙鱼', NULL, NULL, NULL, 0, '3', '0', NULL, 'admin1', NULL, NULL, '2020-09-17 14:25:16', NULL, NULL);
INSERT INTO `pms_brand` VALUES (6, '小米手机', '小米手机', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-4da0ee3430db404495e061443ff0f745.', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ae8ffcd8c017437f8006ca332e290277.', 0, '3', '0', NULL, 'admin1', NULL, NULL, '2020-09-19 20:47:36', NULL, NULL);
INSERT INTO `pms_brand` VALUES (7, '合雨', '合雨', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-36a308eb655340cfb3433c89f0995ac4.', NULL, 0, '3', '0', NULL, 'admin1', NULL, NULL, '2020-09-20 16:19:30', NULL, NULL);
INSERT INTO `pms_brand` VALUES (8, '耐克', NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-6996af440fcf408f8e911800de6baa0b.', NULL, 0, '3', '0', NULL, 'admin2', NULL, NULL, '2020-09-21 08:24:15', NULL, NULL);
INSERT INTO `pms_brand` VALUES (9, '红尊', NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603878470012.png', NULL, 0, '3', '0', NULL, 'admin1', NULL, NULL, '2020-10-28 17:43:46', NULL, NULL);
INSERT INTO `pms_brand` VALUES (10, 'xxx', NULL, NULL, NULL, 0, '3', '0', NULL, 'admin', NULL, NULL, '2020-10-29 10:13:08', NULL, NULL);
INSERT INTO `pms_brand` VALUES (11, '洛川苹果', 'luochuanapple', '1604313868699.jpg', NULL, 0, '3', '0', NULL, 'admin', NULL, NULL, '2020-11-02 18:44:24', NULL, NULL);
INSERT INTO `pms_brand` VALUES (12, 'AIIMAII/爱衣买衣', NULL, NULL, NULL, 0, '3', '0', NULL, 'admin', NULL, NULL, '2020-11-04 10:29:08', NULL, NULL);

-- ----------------------------
-- Table structure for pms_brand_apply
-- ----------------------------
DROP TABLE IF EXISTS `pms_brand_apply`;
CREATE TABLE `pms_brand_apply`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `store_id` bigint(20) DEFAULT NULL COMMENT '店铺id',
  `brand_id` bigint(20) NOT NULL COMMENT '申请的品牌id',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '申请状态   0 申请中 1 通过 2 拒绝',
  `reason` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '拒绝原因',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 24 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '品牌申请表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_brand_apply
-- ----------------------------
INSERT INTO `pms_brand_apply` VALUES (3, 22, 3, '3', NULL, '2020-08-26 20:35:11');
INSERT INTO `pms_brand_apply` VALUES (4, 22, 4, '3', NULL, '2020-08-26 20:36:09');
INSERT INTO `pms_brand_apply` VALUES (5, 25, 3, '3', '545', '2020-09-16 08:32:46');
INSERT INTO `pms_brand_apply` VALUES (6, 25, 4, '3', NULL, '2020-09-16 08:32:53');
INSERT INTO `pms_brand_apply` VALUES (7, 26, 5, '3', NULL, '2020-09-17 14:25:22');
INSERT INTO `pms_brand_apply` VALUES (8, 26, 3, '3', NULL, '2020-09-17 14:29:35');
INSERT INTO `pms_brand_apply` VALUES (9, 26, 4, '3', NULL, '2020-09-17 14:36:10');
INSERT INTO `pms_brand_apply` VALUES (10, 23, 5, '3', NULL, '2020-09-17 14:45:06');
INSERT INTO `pms_brand_apply` VALUES (11, 25, 6, '3', NULL, '2020-09-19 20:48:04');
INSERT INTO `pms_brand_apply` VALUES (12, 22, 7, '3', NULL, '2020-09-20 16:20:55');
INSERT INTO `pms_brand_apply` VALUES (13, 30, 3, '3', NULL, '2020-09-21 08:23:34');
INSERT INTO `pms_brand_apply` VALUES (14, 30, 8, '3', NULL, '2020-09-21 08:24:21');
INSERT INTO `pms_brand_apply` VALUES (15, 30, 6, '3', NULL, '2020-10-27 12:25:58');
INSERT INTO `pms_brand_apply` VALUES (16, 25, 8, '3', NULL, '2020-10-28 15:26:56');
INSERT INTO `pms_brand_apply` VALUES (17, 46, 9, '3', NULL, '2020-10-28 17:43:55');
INSERT INTO `pms_brand_apply` VALUES (18, 30, 9, '3', NULL, '2020-10-28 17:58:06');
INSERT INTO `pms_brand_apply` VALUES (19, 30, 7, '3', NULL, '2020-10-28 18:04:36');
INSERT INTO `pms_brand_apply` VALUES (20, 48, 3, '0', NULL, '2020-10-29 10:09:56');
INSERT INTO `pms_brand_apply` VALUES (21, 48, 10, '0', NULL, '2020-10-29 10:13:16');
INSERT INTO `pms_brand_apply` VALUES (22, 25, 9, '0', NULL, '2020-11-11 21:02:38');
INSERT INTO `pms_brand_apply` VALUES (23, 54, 3, '0', NULL, '2020-11-12 11:23:40');

-- ----------------------------
-- Table structure for pms_category
-- ----------------------------
DROP TABLE IF EXISTS `pms_category`;
CREATE TABLE `pms_category`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '分类名称',
  `parent_id` bigint(20) NOT NULL DEFAULT 0 COMMENT '父级分类id   没有父级 则为0',
  `type_id` bigint(20) DEFAULT NULL COMMENT '类型id，只有分类是三级分类的时候才有 一级和二级分类没有',
  `grade` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '分类的层级 1 一级 2 二级 3 三级',
  `rate` decimal(3, 2) DEFAULT NULL COMMENT '分类扣率 三级分类的时候才有，主要是和店铺对账使用',
  `sort` int(11) DEFAULT NULL COMMENT '排序  数值越低  排序越前',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记  0未删除 1删除 默认0',
  `create_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者名称',
  `modify_name` varchar(145) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者名称',
  `del_name` varchar(145) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除者名称',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 53 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品分类表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_category
-- ----------------------------
INSERT INTO `pms_category` VALUES (19, '服装鞋包', 0, NULL, '1', NULL, 1, '0', 'admin', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-5a473c0e82434b0299ba7b28944d8a4f.', '/pages/user/coupon/list', NULL, '2020-10-26 10:09:10', NULL);
INSERT INTO `pms_category` VALUES (20, '美妆护肤', 0, NULL, '1', NULL, 2, '0', 'admin', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-e7143fd23d2b4aefa6a14400c7092409.', '/pages/marketing/preMarking', NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (21, '手机数码', 0, NULL, '1', NULL, 1, '0', 'admin', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-92a2f26440fd4ac1bdc49fbee9aad0ce.', '/pages/product/jifenList', NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (22, '男装', 19, NULL, '2', NULL, 2, '0', 'admin', NULL, NULL, NULL, '2020-10-25 12:01:25', NULL);
INSERT INTO `pms_category` VALUES (23, '女装', 19, NULL, '2', NULL, 1, '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (24, '面部护肤', 20, NULL, '2', NULL, 1, '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (25, '男生护肤', 20, NULL, '2', NULL, 1, '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (26, '手机配件', 21, NULL, '2', NULL, 1, '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (27, '摄影摄像', 21, NULL, '2', NULL, 1, '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (28, '牛仔裤', 22, 4, '3', 0.05, 1, '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (29, '西服', 22, 4, '3', 0.10, 1, '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (30, '袋子', 0, NULL, '1', NULL, 1, '0', 'admin1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-2968e54a73284e33a6faf7fd25974dcb.', NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (31, '睡袋', 30, NULL, '2', NULL, 1, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (32, '波波', 31, 4, '3', 0.01, 1, '1', 'admin1', NULL, NULL, NULL, NULL, '2020-09-16 14:58:13');
INSERT INTO `pms_category` VALUES (33, '厨房用品', 0, NULL, '1', NULL, 1, '0', '18170925665', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (34, '厨房1', 33, NULL, '2', NULL, 1, '0', '18170925665', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (36, '手机', 21, NULL, '2', NULL, 1, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (37, '小米手机', 36, 4, '3', 0.00, 1, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (38, '睡眠用品', 23, 4, '3', 0.00, 1, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (42, '数据线', 26, 7, '3', 0.00, 1, '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (45, 'shuiguo', 0, NULL, '1', NULL, 1, '0', '15882301651', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (46, 'youzi', 45, NULL, '2', NULL, 1, '0', '15882301651', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_category` VALUES (47, 'hongxinyou', 46, 8, '3', 0.01, 1, '0', '15882301651', NULL, NULL, NULL, '2020-11-08 21:23:39', NULL);
INSERT INTO `pms_category` VALUES (52, '上衣', 23, 7, '3', 1.00, 1, '0', 'admin', NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for pms_category_spec
-- ----------------------------
DROP TABLE IF EXISTS `pms_category_spec`;
CREATE TABLE `pms_category_spec`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `cate_id` bigint(20) NOT NULL COMMENT '分类id  对应pms_category表中的id',
  `spec_id` bigint(20) NOT NULL COMMENT '规格id 对应pms_goods_spec 表中的id',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记 0 未删除 1删除 默认0',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 45 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '分类和规格的关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_category_spec
-- ----------------------------
INSERT INTO `pms_category_spec` VALUES (13, 28, 4, '0');
INSERT INTO `pms_category_spec` VALUES (14, 28, 5, '0');
INSERT INTO `pms_category_spec` VALUES (15, 29, 5, '0');
INSERT INTO `pms_category_spec` VALUES (16, 29, 4, '0');
INSERT INTO `pms_category_spec` VALUES (17, 32, 4, '0');
INSERT INTO `pms_category_spec` VALUES (18, 32, 5, '0');
INSERT INTO `pms_category_spec` VALUES (19, 32, 6, '0');
INSERT INTO `pms_category_spec` VALUES (20, 35, 5, '0');
INSERT INTO `pms_category_spec` VALUES (21, 37, 4, '0');
INSERT INTO `pms_category_spec` VALUES (22, 37, 7, '0');
INSERT INTO `pms_category_spec` VALUES (23, 38, 4, '0');
INSERT INTO `pms_category_spec` VALUES (24, 38, 5, '0');
INSERT INTO `pms_category_spec` VALUES (25, 41, 4, '0');
INSERT INTO `pms_category_spec` VALUES (26, 41, 6, '0');
INSERT INTO `pms_category_spec` VALUES (27, 41, 5, '0');
INSERT INTO `pms_category_spec` VALUES (28, 41, 8, '0');
INSERT INTO `pms_category_spec` VALUES (29, 41, 7, '0');
INSERT INTO `pms_category_spec` VALUES (30, 42, 8, '0');
INSERT INTO `pms_category_spec` VALUES (38, 51, 12, '0');
INSERT INTO `pms_category_spec` VALUES (39, 51, 8, '0');
INSERT INTO `pms_category_spec` VALUES (40, 52, 4, '0');
INSERT INTO `pms_category_spec` VALUES (43, 47, 12, '0');
INSERT INTO `pms_category_spec` VALUES (44, 47, 13, '0');

-- ----------------------------
-- Table structure for pms_combination
-- ----------------------------
DROP TABLE IF EXISTS `pms_combination`;
CREATE TABLE `pms_combination`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '商品组合名称',
  `store_id` bigint(20) DEFAULT NULL COMMENT '店铺id 平台的为0',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除标记 0 未删除 1 已删除',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 11 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品组合表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_combination
-- ----------------------------
INSERT INTO `pms_combination` VALUES (1, 'qqqq', 0, '0', '2020-09-14 18:27:15', NULL, NULL);
INSERT INTO `pms_combination` VALUES (2, '123123', 0, '0', '2020-09-18 09:29:16', NULL, NULL);
INSERT INTO `pms_combination` VALUES (3, '订单', 25, '0', '2020-09-18 11:29:36', NULL, NULL);
INSERT INTO `pms_combination` VALUES (4, '礼包', 0, '0', '2020-09-19 17:49:16', NULL, NULL);
INSERT INTO `pms_combination` VALUES (5, '11', 30, '0', '2020-10-13 09:49:12', NULL, NULL);
INSERT INTO `pms_combination` VALUES (6, '测试商品组合', 0, '0', '2020-10-14 11:45:52', NULL, NULL);
INSERT INTO `pms_combination` VALUES (7, '东哥柚子', 46, '0', '2020-10-29 10:03:17', NULL, NULL);
INSERT INTO `pms_combination` VALUES (8, '7676', 0, '0', '2020-10-29 11:13:27', NULL, NULL);
INSERT INTO `pms_combination` VALUES (9, '199套餐', 0, '0', '2020-11-09 14:31:42', NULL, NULL);
INSERT INTO `pms_combination` VALUES (10, '家具', 25, '0', '2020-11-12 13:45:28', NULL, NULL);

-- ----------------------------
-- Table structure for pms_combination_sku
-- ----------------------------
DROP TABLE IF EXISTS `pms_combination_sku`;
CREATE TABLE `pms_combination_sku`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `combination_id` bigint(20) NOT NULL COMMENT '商品组合id',
  `sku_id` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品id',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 13 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品组合下的单品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_combination_sku
-- ----------------------------
INSERT INTO `pms_combination_sku` VALUES (1, 8, '1600066010217370');
INSERT INTO `pms_combination_sku` VALUES (2, 8, '1600152633570391');
INSERT INTO `pms_combination_sku` VALUES (3, 8, '1601343305035496');
INSERT INTO `pms_combination_sku` VALUES (4, 8, '1601343305035495');
INSERT INTO `pms_combination_sku` VALUES (5, 3, '1600520752205420');
INSERT INTO `pms_combination_sku` VALUES (6, 3, '1604626581053591');
INSERT INTO `pms_combination_sku` VALUES (7, 8, '1604737539693600');
INSERT INTO `pms_combination_sku` VALUES (8, 8, '1604738056157610');
INSERT INTO `pms_combination_sku` VALUES (9, 8, '1604737539693601');
INSERT INTO `pms_combination_sku` VALUES (10, 9, '1604737539693600');
INSERT INTO `pms_combination_sku` VALUES (11, 9, '1604737539693601');
INSERT INTO `pms_combination_sku` VALUES (12, 9, '1605624533499640');

-- ----------------------------
-- Table structure for pms_comment
-- ----------------------------
DROP TABLE IF EXISTS `pms_comment`;
CREATE TABLE `pms_comment`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `customer_id` bigint(20) NOT NULL COMMENT '会员id',
  `sku_id` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品id',
  `store_id` bigint(20) DEFAULT NULL COMMENT '店铺id',
  `order_id` bigint(20) DEFAULT NULL COMMENT '订单号',
  `is_anonymous` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否匿名  0 否 1是  默认0 ',
  `comment` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '评论',
  `score` int(11) DEFAULT NULL COMMENT '商品满意度评分1到5分',
  `has_pic` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否有图片  0 没有 1 有 默认0 ',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '评论创建时间',
  `is_show` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否可见 0 可见 1 不可见 默认0 ',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否删除 0 未删除1 删除 默认0 ',
  `spu_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `store_id`(`store_id`) USING BTREE,
  INDEX `sku_id`(`sku_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '单品评论表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_comment
-- ----------------------------
INSERT INTO `pms_comment` VALUES (1, 10, '11', 1, 11, '0', '223', 1, '0', '2020-08-25 10:21:45', '0', '0', 31);
INSERT INTO `pms_comment` VALUES (2, 11, '11', 1, 22, '0', 'dfgdfdg', 2, '0', '2020-08-25 10:49:31', '0', '0', 31);
INSERT INTO `pms_comment` VALUES (3, 18, '1600649194611480', 30, 312, '0', NULL, 5, '1', '2020-10-29 15:03:09', '0', '0', 48);
INSERT INTO `pms_comment` VALUES (5, 18, '1600590450193460', 0, 196, '0', NULL, 5, '1', '2020-10-29 15:13:36', '0', '0', 46);
INSERT INTO `pms_comment` VALUES (6, 18, '1600590248265440', 0, 196, '0', NULL, 5, '1', '2020-10-29 15:13:36', '0', '0', 44);
INSERT INTO `pms_comment` VALUES (7, 18, '1600649194611480', 30, 310, '0', NULL, 5, '1', '2020-10-29 17:04:19', '0', '0', 48);
INSERT INTO `pms_comment` VALUES (8, 232, '1598270266233310', 0, 273, '0', '版版们都会看到', 5, '0', '2020-10-30 15:28:59', '0', '0', 31);
INSERT INTO `pms_comment` VALUES (9, 18, '1604737539693600', 0, 373, '0', 'tinghaode ', 5, '1', '2020-11-07 17:16:03', '0', '0', 60);

-- ----------------------------
-- Table structure for pms_comment_picture
-- ----------------------------
DROP TABLE IF EXISTS `pms_comment_picture`;
CREATE TABLE `pms_comment_picture`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `comment_id` bigint(20) NOT NULL COMMENT '评论id',
  `url` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '图片地址',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `comment_id`(`comment_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '单品评论下的图片表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_comment_picture
-- ----------------------------
INSERT INTO `pms_comment_picture` VALUES (1, 3, 'https://img02.sogoucdn.com/app/a/100520024/57c51b3af9a0a143110b7660a7c30a75');
INSERT INTO `pms_comment_picture` VALUES (2, 8, 'https://img02.sogoucdn.com/app/a/100520024/57c51b3af9a0a143110b7660a7c30a75');
INSERT INTO `pms_comment_picture` VALUES (3, 8, 'https://img02.sogoucdn.com/app/a/100520024/57c51b3af9a0a143110b7660a7c30a75');
INSERT INTO `pms_comment_picture` VALUES (4, 8, 'https://img02.sogoucdn.com/app/a/100520024/57c51b3af9a0a143110b7660a7c30a75');
INSERT INTO `pms_comment_picture` VALUES (5, 6, 'https://img02.sogoucdn.com/app/a/100520024/57c51b3af9a0a143110b7660a7c30a75');
INSERT INTO `pms_comment_picture` VALUES (6, 7, 'https://img02.sogoucdn.com/app/a/100520024/57c51b3af9a0a143110b7660a7c30a75');
INSERT INTO `pms_comment_picture` VALUES (7, 2, 'https://img02.sogoucdn.com/app/a/100520024/57c51b3af9a0a143110b7660a7c30a75');
INSERT INTO `pms_comment_picture` VALUES (8, 2, 'https://img02.sogoucdn.com/app/a/100520024/57c51b3af9a0a143110b7660a7c30a75');

-- ----------------------------
-- Table structure for pms_comment_replay
-- ----------------------------
DROP TABLE IF EXISTS `pms_comment_replay`;
CREATE TABLE `pms_comment_replay`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `comment_id` bigint(20) NOT NULL COMMENT '评论id  对应ls_comment 表中的id',
  `reply` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '回复内容',
  `is_show` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否显示 0 显示 1 不显示 默认0 ',
  `store_id` bigint(20) DEFAULT NULL COMMENT '店铺id 平台为0',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `comment_id`(`comment_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '评论回复' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for pms_goods
-- ----------------------------
DROP TABLE IF EXISTS `pms_goods`;
CREATE TABLE `pms_goods`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '商品名称',
  `subtitle` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '商品副标题',
  `price` decimal(20, 2) DEFAULT NULL COMMENT '销售价',
  `pc_desc` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT 'PC版详情',
  `mobile_desc` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '手机版详情',
  `seo_title` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'seo标题',
  `seo_keywords` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'seo关键字',
  `seo_desc` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'see描述',
  `store_id` bigint(20) NOT NULL COMMENT '商品的店铺id 如果是平台的则为0 ',
  `first_cate_id` bigint(20) DEFAULT NULL COMMENT '一级分类id',
  `second_cate_id` bigint(20) DEFAULT NULL COMMENT '二级分类id',
  `third_cate_id` bigint(20) DEFAULT NULL COMMENT '三级分类id',
  `type_id` bigint(20) NOT NULL COMMENT '类型id',
  `brand_id` bigint(20) NOT NULL COMMENT '品牌id',
  `store_fcate_id` bigint(20) DEFAULT NULL COMMENT '店铺一级分类',
  `store_scate_id` bigint(20) DEFAULT NULL COMMENT '店铺二级分类',
  `store_tcate_id` bigint(20) DEFAULT NULL COMMENT '店铺三级分类',
  `url` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '商品图片',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记   0未删除 1删除 默认0',
  `create_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建人的名称',
  `modify_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人的名称',
  `del_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除人的名字',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  `commission_rate` decimal(3, 2) DEFAULT 0.00 COMMENT '佣金比例',
  `s_commission_rate` decimal(3, 2) DEFAULT 0.00 COMMENT '二级佣金比例',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '审核状态  0 审核通过 1 审核未通过 2 审核中',
  `shelves_status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '商品上架状态 0 下架  1上架 2违规下架 默认0',
  `is_virtual` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否是虚拟商品 0 否 1 是默认0',
  `video` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '商品视频地址',
  `video_pic` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '商品视频封面地址',
  `logistics_template_id` bigint(20) DEFAULT NULL COMMENT '物流模版id 对应oms_logistics_template表的id',
  `store_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '店鋪名稱',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 66 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_goods
-- ----------------------------
INSERT INTO `pms_goods` VALUES (24, '平台试用商品', NULL, 1001.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', '0', 'admin', NULL, NULL, '2020-08-22 14:59:44', '2020-11-18 13:28:04', NULL, 0.00, 0.00, '3', '0', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (25, '平台分销商品', NULL, 1100.00, '<p>32</p>', '<p>32</p>', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-733e78fcd86f498cb4393a5b4a5e7fb0.', '0', 'admin', NULL, NULL, '2020-08-22 15:01:04', '2020-10-21 19:45:37', NULL, 0.10, 0.05, '3', '1', '0', '', '', 8, '平台自营');
INSERT INTO `pms_goods` VALUES (26, '平台直降商品', NULL, 1010.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-cce03f90b1094dd682f656c33224b33c.', '0', 'admin', NULL, NULL, '2020-08-24 09:02:16', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (27, '平台赠品1', NULL, 1010.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-47b109458e264c3195c8204ce9b0c5cc.', '0', 'admin', NULL, NULL, '2020-08-24 09:07:00', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (28, '平台赠品功能', NULL, 1015.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-0a3589732c5748e5972f7dcb420cf7d1.', '0', 'admin', NULL, NULL, '2020-08-24 09:07:53', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (29, '平台满减商品', NULL, 1032.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-98bf4f772a634526ab25d36c925c66a2.', '0', 'admin', NULL, NULL, '2020-08-24 14:38:40', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (30, '平台满折测试', NULL, 1100.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-44a7b17e7cb74276b0d9fc1c8c9fb4e9.', '0', 'admin', NULL, NULL, '2020-08-24 16:32:59', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (31, '平台拼团商品', NULL, 1100.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-c0186338aaf34b0eb58b526ad4814b1c.', '0', 'admin', NULL, NULL, '2020-08-24 19:57:46', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (32, '测试支付', NULL, 1000.01, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-611d545be3c64a8f81258c2a588e900d.', '0', 'admin', NULL, NULL, '2020-08-26 19:52:14', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (33, '商户预售商品', NULL, 1010.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-91038407ea2b4826a63d629b701e1717.', '0', 'admin', NULL, NULL, '2020-08-26 20:44:55', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 9, '平台自营');
INSERT INTO `pms_goods` VALUES (34, '商户支付测试', NULL, 1000.01, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-41c216ad6a534e4f95a2caaa40c9b981.', '0', 'admin', NULL, NULL, '2020-08-26 20:45:33', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 9, '平台自营');
INSERT INTO `pms_goods` VALUES (35, '平台秒杀商品', NULL, 1010.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200901-236dc7279f154fb6b8334238d77490d1.', '0', 'admin', NULL, NULL, '2020-09-01 20:22:33', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (36, '122', NULL, 1010.00, '', '', '', '', '', 0, 19, 22, 28, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', '0', 'admin1', NULL, NULL, '2020-09-18 16:08:50', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (38, '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念', NULL, 2699.00, '', '<div id=\"attributes\" class=\"attributes\">\n<div id=\"J_AttrList\" class=\"attributes-list\">\n<div id=\"J_BrandAttr\" class=\"tm-clear tb-hidden tm_brandAttr\" data-spm-anchor-id=\"a220o.1000855.0.i0.653a11e7cW2KVO\">\n<div class=\"name\">品牌名称：<strong class=\"J_EbrandLogo\">Xiaomi/小米</strong></div>\n</div>\n<p class=\"attr-list-hd tm-clear\"><a class=\"ui-more-nbg tm-MRswitchAttrs\" href=\"https://detail.tmall.com/item.htm?spm=a220m.1000858.1000725.13.5d1e5c9cK2WwlL&amp;id=608604219796&amp;skuId=4283384984156&amp;areaId=430600&amp;standard=1&amp;user_id=1714128138&amp;cat_id=50024400&amp;is_b=1&amp;rn=f15956ab89fbe7febf1fcd7f5afad1d9#J_Attrs\">更多参数</a><em>产品参数：</em></p>\n<ul id=\"J_AttrUL\">\n<li title=\"2019011606252439\">证书编号：2019011606252439</li>\n<li title=\"有效\">证书状态：有效</li>\n<li title=\"5G数字移动电话机（仅考核2、3、4G功能）\">产品名称：5G数字移动电话机（仅考核2、3、4G功能）</li>\n<li title=\"M2001G7AC(电源适配器：MDY-11-EF 输出：5VDC,3A / 9VDC,3A / 1...\">3C规格型号：M2001G7AC(电源适配器：MDY-11-EF 输出：5VDC,3A / 9VDC,3A / 1...</li>\n<li title=\"Xiaomi/小米 Redmi K30 5G\">产品名称：Xiaomi/小米 Redmi K30 5...</li>\n<li title=\"&nbsp;Redmi K30 5G\">型号:&nbsp;Redmi K30 5G</li>\n<li title=\"&nbsp;深海微光&nbsp;紫玉幻境&nbsp;时光独白&nbsp;花影惊鸿\">机身颜色:&nbsp;深海微光&nbsp;紫玉幻境&nbsp;时光独白&nbsp;花影惊鸿</li>\n<li title=\"&nbsp;6GB,8GB\">运行内存RAM:&nbsp;6GB,8GB</li>\n<li title=\"&nbsp;6+128GB&nbsp;8+128GB&nbsp;8+256GB\">存储容量:&nbsp;6+128GB&nbsp;8+128GB&nbsp;8+256GB</li>\n<li title=\"&nbsp;双卡双待\">网络模式:&nbsp;双卡双待</li>\n<li title=\"&nbsp;骁龙765G\">CPU型号:&nbsp;骁龙765G</li>\n<li title=\"&nbsp;骁龙765G\">CPU型号:&nbsp;骁龙765G</li>\n<li title=\"&nbsp;IMX686\">摄像头传感器型号:&nbsp;IMX686</li>\n</ul>\n</div>\n</div>\n<div id=\"mall-banner\">\n<div data-spm=\"1998132255\">&nbsp;</div>\n<div id=\"J_DescTMS1\">&nbsp;</div>\n</div>\n<div id=\"J_TmpActBanner\">&nbsp;</div>\n<div id=\"J_DcTopRightWrap\">\n<div id=\"J_DcTopRight\" class=\"J_DcAsyn tb-shop\">\n<div id=\"shop22565361561\" class=\"J_TModule\" data-widgetid=\"22565361561\" data-componentid=\"5003\" data-spm=\"110.0.5003-22565361561\" data-title=\"自定义内容区\">\n<div class=\"skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined\"><s class=\"skin-box-tp\"></s>\n<div class=\"skin-box-hd\">\n<h3>自定义内容区</h3>\n</div>\n<div class=\"skin-box-bd clear-fix\">\n<p><a href=\"https://detail.tmall.com/item.htm?spm=a1z10.1-b-s.w15914064-15567552165.82.2df05f3borD6D5&amp;id=608604219796&amp;&amp;sku_properties=10004:7169121965;5919063:6536025&amp;scene=taobao_shop\" target=\"_blank\" rel=\"noopener\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i4/1714128138/O1CN01b3LoxX29zFnpcFGEj_!!1714128138.jpg\" /></a></p>\n</div>\n<s class=\"skin-box-bt\"></s></div>\n</div>\n<div id=\"shop21722342836\" class=\"J_TModule\" data-widgetid=\"21722342836\" data-componentid=\"5003\" data-spm=\"110.0.5003-21722342836\" data-title=\"自定义内容区\">\n<div class=\"skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined\"><s class=\"skin-box-tp\"></s>\n<div class=\"skin-box-bd clear-fix\">\n<div class=\"rel\" data-title=\"power by junezx 3.0\" data-rn=\"arn3i\">&nbsp;</div>\n</div>\n<s class=\"skin-box-bt\"></s></div>\n</div>\n<div id=\"shop16958869905\" class=\"J_TModule\" data-widgetid=\"16958869905\" data-componentid=\"5003\" data-spm=\"110.0.5003-16958869905\" data-title=\"自定义内容区\">\n<div class=\"skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined\"><s class=\"skin-box-tp\"></s>\n<div class=\"skin-box-bd clear-fix\">\n<div class=\"rel\" data-title=\"power by junezx 3.0\" data-rn=\"agFYr\">&nbsp;</div>\n</div>\n<s class=\"skin-box-bt\"></s></div>\n</div>\n</div>\n</div>\n<div id=\"description\" class=\"J_DetailSection tshop-psm tshop-psm-bdetaildes\">\n<div class=\"content ke-post\">\n<p><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i1/1714128138/O1CN01MM5f8M29zFnhHcPGi_!!1714128138.jpg\" align=\"absmiddle\" /></p>\n<p><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i1/1714128138/O1CN01AXtFKj29zFm1e9MWK_!!1714128138.jpg\" align=\"absmiddle\" /></p>\n</div>\n</div>', '', '', '', 25, 21, 36, 37, 4, 6, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '0', 'admin1', NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 10, '小米官方旗舰店');
INSERT INTO `pms_goods` VALUES (39, '红米note8pro 6400万正品手机10全面屏千元拍照智能机学生老人小米官方旗舰店官网xiaomi', NULL, 2299.00, '', '<div id=\"attributes\" class=\"attributes\">\n<div id=\"J_AttrList\" class=\"attributes-list\">\n<div id=\"J_BrandAttr\" class=\"tm-clear tb-hidden tm_brandAttr\" data-spm-anchor-id=\"a220o.1000855.0.i0.41201f833T7s9I\">\n<div class=\"name\">品牌名称：<strong class=\"J_EbrandLogo\">Xiaomi/小米</strong></div>\n</div>\n<p class=\"attr-list-hd tm-clear\"><a class=\"ui-more-nbg tm-MRswitchAttrs\" href=\"https://detail.tmall.com/item.htm?spm=a220m.1000858.1000725.21.5d1e5c9cK2WwlL&amp;id=598173320467&amp;skuId=4212262553188&amp;areaId=430600&amp;standard=1&amp;user_id=1714128138&amp;cat_id=50024400&amp;is_b=1&amp;rn=f15956ab89fbe7febf1fcd7f5afad1d9#J_Attrs\">更多参数</a><em>产品参数：</em></p>\n<ul id=\"J_AttrUL\">\n<li title=\"2019011606218735\">证书编号：2019011606218735</li>\n<li title=\"有效\">证书状态：有效</li>\n<li title=\"TD-LTE数字移动电话机\">产品名称：TD-LTE数字移动电话机</li>\n<li title=\"M1906G7E、M1906G7T (电源适配器：MDY-10-EC 输出：5Vdc,3A / 9V...\">3C规格型号：M1906G7E、M1906G7T (电源适配器：MDY-10-EC 输出：5Vdc,3A / 9V...</li>\n<li title=\"Xiaomi/小米 Redmi Note8 Pro\">产品名称：Xiaomi/小米 Redmi Note8...</li>\n<li title=\"&nbsp;Redmi Note8 Pro\">型号:&nbsp;Redmi Note8 Pro</li>\n<li title=\"&nbsp;冰翡翠&nbsp;贝母白&nbsp;电光灰&nbsp;暮光橙\">机身颜色:&nbsp;冰翡翠&nbsp;贝母白&nbsp;电光灰&nbsp;暮光橙</li>\n<li title=\"&nbsp;6GB&nbsp;8GB\">运行内存RAM:&nbsp;6GB&nbsp;8GB</li>\n<li title=\"&nbsp;6+64GB&nbsp;6+128GB&nbsp;8+128GB\">存储容量:&nbsp;6+64GB&nbsp;6+128GB&nbsp;8+128GB</li>\n<li title=\"&nbsp;双卡双待\">网络模式:&nbsp;双卡双待</li>\n<li title=\"&nbsp;其他\">CPU型号:&nbsp;其他</li>\n<li title=\"&nbsp;Helio G90T\">CPU型号:&nbsp;Helio G90T</li>\n</ul>\n</div>\n</div>\n<div id=\"mall-banner\">\n<div data-spm=\"1998132255\">&nbsp;</div>\n<div id=\"J_DescTMS1\">&nbsp;</div>\n</div>\n<div id=\"J_TmpActBanner\">&nbsp;</div>\n<div id=\"J_DcTopRightWrap\">\n<div id=\"J_DcTopRight\" class=\"J_DcAsyn tb-shop\">\n<div id=\"shop22565361561\" class=\"J_TModule\" data-widgetid=\"22565361561\" data-componentid=\"5003\" data-spm=\"110.0.5003-22565361561\" data-title=\"自定义内容区\">\n<div class=\"skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined\"><s class=\"skin-box-tp\"></s>\n<div class=\"skin-box-hd\">\n<h3>自定义内容区</h3>\n</div>\n<div class=\"skin-box-bd clear-fix\">\n<p><a href=\"https://detail.tmall.com/item.htm?spm=a1z10.1-b-s.w15914064-15567552165.82.2df05f3borD6D5&amp;id=608604219796&amp;&amp;sku_properties=10004:7169121965;5919063:6536025&amp;scene=taobao_shop\" target=\"_blank\" rel=\"noopener\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i4/1714128138/O1CN01b3LoxX29zFnpcFGEj_!!1714128138.jpg\" /></a></p>\n</div>\n<s class=\"skin-box-bt\"></s></div>\n</div>\n<div id=\"shop21722342836\" class=\"J_TModule\" data-widgetid=\"21722342836\" data-componentid=\"5003\" data-spm=\"110.0.5003-21722342836\" data-title=\"自定义内容区\">\n<div class=\"skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined\"><s class=\"skin-box-tp\"></s>\n<div class=\"skin-box-bd clear-fix\">\n<div class=\"rel\" data-title=\"power by junezx 3.0\" data-rn=\"arn3i\">&nbsp;</div>\n</div>\n<s class=\"skin-box-bt\"></s></div>\n</div>\n<div id=\"shop16958869905\" class=\"J_TModule\" data-widgetid=\"16958869905\" data-componentid=\"5003\" data-spm=\"110.0.5003-16958869905\" data-title=\"自定义内容区\">\n<div class=\"skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined\"><s class=\"skin-box-tp\"></s>\n<div class=\"skin-box-bd clear-fix\">\n<div class=\"rel\" data-title=\"power by junezx 3.0\" data-rn=\"agFYr\">&nbsp;</div>\n</div>\n<s class=\"skin-box-bt\"></s></div>\n</div>\n</div>\n</div>\n<div id=\"description\" class=\"J_DetailSection tshop-psm tshop-psm-bdetaildes\">\n<div class=\"content ke-post\">\n<p><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i4/1714128138/O1CN014Enwcf29zFnegXsks_!!1714128138.jpg\" align=\"absmiddle\" /></p>\n</div>\n</div>', '', '', '', 25, 21, 36, 37, 4, 6, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-bd724755fdf44ab3bc7f23ba968ddef3.', '0', 'admin1', NULL, NULL, '2020-09-19 21:01:48', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 10, '小米官方旗舰店');
INSERT INTO `pms_goods` VALUES (40, '小米105g手机骁龙8651亿像素8K相机智能游戏小米官方旗舰店小米手机官网至尊', NULL, 4999.00, '', '', '', '', '', 25, 21, 36, 37, 4, 4, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ed98d27f13be42f2b8d4950945ffaea2.', '0', 'admin1', NULL, NULL, '2020-09-19 21:03:00', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 10, '小米官方旗舰店');
INSERT INTO `pms_goods` VALUES (41, '红米K30i 双模5G4800万旗舰拍照学生老年新品智能机30pro手机小米官方旗舰店10至尊', NULL, 1149.00, '', '', '', '', '', 25, 21, 36, 37, 4, 6, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-32790a8d138b4059b9d5fed76571707d.', '0', 'admin1', NULL, NULL, '2020-09-19 21:03:57', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 10, '小米官方旗舰店');
INSERT INTO `pms_goods` VALUES (42, '红米note8 4800万四摄拍照游戏学生智能手机redmi全面屏pro小米官方旗舰店10正品xiaomi', NULL, 1000.01, '', '', '', '', '', 25, 21, 36, 37, 4, 6, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-928522e0946d45c38a6afe1fab078377.', '0', 'admin1', NULL, NULL, '2020-09-19 21:05:52', '2020-11-05 14:45:55', NULL, 0.10, 0.05, '3', '1', '0', '', '', 10, '小米官方旗舰店');
INSERT INTO `pms_goods` VALUES (43, '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯', NULL, 1059.00, '', '<div id=\"attributes\" class=\"attributes\">\n<div id=\"J_AttrList\" class=\"attributes-list\">\n<div id=\"J_BrandAttr\" class=\"tm-clear tb-hidden tm_brandAttr\" data-spm-anchor-id=\"a220o.1000855.0.i1.f52e47038O9BFP\">\n<div class=\"name\">品牌名称：<strong class=\"J_EbrandLogo\" data-spm-anchor-id=\"a220o.1000855.0.i0.f52e47038O9BFP\">合雨</strong></div>\n</div>\n<p class=\"attr-list-hd tm-clear\"><em>产品参数：</em></p>\n<ul id=\"J_AttrUL\">\n<li id=\"J_attrBrandName\" title=\"&nbsp;合雨\">品牌:&nbsp;合雨</li>\n<li title=\"&nbsp;涤纶（聚酯纤维）\">材质:&nbsp;涤纶（聚酯纤维）</li>\n<li title=\"&nbsp;纯色\">图案:&nbsp;纯色</li>\n<li title=\"&nbsp;简约现代\">风格:&nbsp;简约现代</li>\n<li title=\"&nbsp;中国大陆\">产地:&nbsp;中国大陆</li>\n<li title=\"&nbsp;上海市\">省份:&nbsp;上海市</li>\n<li title=\"&nbsp;上海市\">地市:&nbsp;上海市</li>\n<li title=\"&nbsp;100*150cm\">尺寸:&nbsp;100*150cm</li>\n<li title=\"&nbsp;办公室\">适用空间:&nbsp;办公室</li>\n<li title=\"&nbsp;驼色&nbsp;深蓝色&nbsp;金驼色&nbsp;富贵紫&nbsp;咖啡色&nbsp;秋香绿&nbsp;米黄色&nbsp;玫红色&nbsp;灰色圆点(带耳朵)&nbsp;驼色圆点(带耳朵)&nbsp;粉色圆点(带耳朵)&nbsp;小花朵(带耳朵)\">颜色分类:&nbsp;驼色&nbsp;深蓝色&nbsp;金驼色&nbsp;富贵紫&nbsp;咖啡色&nbsp;秋香绿&nbsp;米黄色&nbsp;玫红色&nbsp;灰色圆点(带耳朵)&nbsp;驼色圆点(带耳朵)&nbsp;粉色圆点(带耳朵)&nbsp;小花朵(带耳朵)</li>\n<li title=\"&nbsp;6927228409115\">商品条形码:&nbsp;6927228409115</li>\n<li title=\"&nbsp;合格品\">产品等级:&nbsp;合格品</li>\n<li title=\"&nbsp;FLRPT001\">货号:&nbsp;FLRPT001</li>\n<li title=\"&nbsp;冬季\">适用季节:&nbsp;冬季</li>\n<li title=\"&nbsp;2018年冬季\">上市年份季节:&nbsp;2018年冬季</li>\n<li title=\"&nbsp;珊瑚绒毯\">毯类型:&nbsp;珊瑚绒毯</li>\n<li title=\"&nbsp;3-4\">色牢度:&nbsp;3-4</li>\n<li title=\"&nbsp;3%-5%\">缩水率:&nbsp;3%-5%</li>\n</ul>\n</div>\n</div>\n<div id=\"mall-banner\">\n<div data-spm=\"1998132255\">&nbsp;</div>\n<div id=\"J_DescTMS1\">&nbsp;</div>\n</div>\n<div id=\"J_TmpActBanner\">&nbsp;</div>\n<div id=\"J_DcTopRightWrap\">\n<div id=\"J_DcTopRight\" class=\"J_DcAsyn tb-shop\">\n<div id=\"shop15469243798\" class=\"J_TModule\" data-widgetid=\"15469243798\" data-componentid=\"5003\" data-spm=\"110.0.5003-15469243798\" data-title=\"自定义内容区\">&nbsp;</div>\n<div id=\"shop15113882077\" class=\"J_TModule\" data-widgetid=\"15113882077\" data-componentid=\"5003\" data-spm=\"110.0.5003-15113882077\" data-title=\"自定义内容区\">\n<div class=\"skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined\"><s class=\"skin-box-tp\"></s>\n<div class=\"skin-box-bd clear-fix\">\n<table border=\"0\" width=\"790\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td colspan=\"3\"><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=599968964980&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i3/1803112320/O1CN01Y7ux221T0bTNocWyD_!!1803112320.jpg\" alt=\"\" width=\"790\" height=\"418\" border=\"0\" /></a></td>\n</tr>\n<tr>\n<td colspan=\"3\"><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=571175335686&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i1/1803112320/O1CN01HueuIc1T0bTNoZ6wF_!!1803112320.jpg\" alt=\"\" width=\"790\" height=\"434\" border=\"0\" /></a></td>\n</tr>\n<tr>\n<td><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=602216794739&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i4/1803112320/O1CN01m2mS701T0bTPScjs1_!!1803112320.jpg\" alt=\"\" width=\"264\" height=\"354\" border=\"0\" /></a></td>\n<td><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=598161428944&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i3/1803112320/O1CN01GD3EgE1T0bTL4ij97_!!1803112320.jpg\" alt=\"\" width=\"262\" height=\"354\" border=\"0\" /></a></td>\n<td><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=598091454735&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i4/1803112320/O1CN0136U2S11T0bTCgA7Oa_!!1803112320.jpg\" alt=\"\" width=\"264\" height=\"354\" border=\"0\" /></a></td>\n</tr>\n</tbody>\n</table>\n</div>\n<s class=\"skin-box-bt\"></s></div>\n</div>\n<div id=\"shop15786999061\" class=\"J_TModule\" data-widgetid=\"15786999061\" data-componentid=\"5003\" data-spm=\"110.0.5003-15786999061\" data-title=\"自定义内容区\">&nbsp;</div>\n</div>\n</div>\n<div id=\"description\" class=\"J_DetailSection tshop-psm tshop-psm-bdetaildes\">\n<div class=\"content ke-post\"><img id=\"desc-module-1\" class=\"desc_anchor img-ks-lazyload\" src=\"https://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif\" />\n<p><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i2/1803112320/TB21ADBD4WYBuNjy1zkXXXGGpXa_!!1803112320.jpg\" align=\"absmiddle\" /></p>\n</div>\n</div>', '', '', '', 0, 19, 23, 38, 4, 7, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', '13146587711', NULL, NULL, '2020-09-20 16:22:39', '2020-11-17 17:56:40', NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (44, '浴巾女可穿可裹巾吊带可爱比纯棉吸水速干不掉毛浴裙三件套ins 风', NULL, 1066.00, '', '<div id=\"attributes\" class=\"attributes\">\n<div id=\"J_AttrList\" class=\"attributes-list\">\n<div id=\"J_BrandAttr\" class=\"tm-clear tb-hidden tm_brandAttr\">\n<div class=\"name\" data-spm-anchor-id=\"a220o.1000855.0.i0.77bc6ccfqVHxiq\">品牌名称：<strong class=\"J_EbrandLogo\">合雨</strong></div>\n</div>\n<p class=\"attr-list-hd tm-clear\"><em>产品参数：</em></p>\n<ul id=\"J_AttrUL\">\n<li id=\"J_attrBrandName\" title=\"&nbsp;合雨\">品牌:&nbsp;合雨</li>\n<li title=\"&nbsp;85%聚酯纤维15%锦纶\">材质:&nbsp;85%聚酯纤维15%锦纶</li>\n<li title=\"&nbsp;80X125cm(适合80-130斤)&nbsp;80X135cm(适合130-160斤)\">尺码:&nbsp;80X125cm(适合80-130斤)&nbsp;80X135cm(适合130-160斤)</li>\n<li title=\"&nbsp;中国大陆\">产地:&nbsp;中国大陆</li>\n<li title=\"&nbsp;上海市\">省份:&nbsp;上海市</li>\n<li title=\"&nbsp;上海市\">地市:&nbsp;上海市</li>\n<li title=\"&nbsp;荷兰绿&nbsp;咖啡色&nbsp;碳灰色&nbsp;米白色&nbsp;樱花粉&nbsp;梦幻紫&nbsp;柠檬黄\">颜色分类:&nbsp;荷兰绿&nbsp;咖啡色&nbsp;碳灰色&nbsp;米白色&nbsp;樱花粉&nbsp;梦幻紫&nbsp;柠檬黄</li>\n<li title=\"&nbsp;6927228405766\">商品条形码:&nbsp;6927228405766</li>\n<li title=\"&nbsp;360\">产品重量[*克(g)/件]:&nbsp;360</li>\n<li title=\"&nbsp;DDQ001\">货号:&nbsp;DDQ001</li>\n<li title=\"&nbsp;女\">适用对象:&nbsp;女</li>\n</ul>\n</div>\n</div>\n<div id=\"mall-banner\">\n<div data-spm=\"1998132255\">&nbsp;</div>\n<div id=\"J_DescTMS1\">&nbsp;</div>\n</div>\n<div id=\"J_TmpActBanner\">&nbsp;</div>\n<div id=\"J_DcTopRightWrap\">\n<div id=\"J_DcTopRight\" class=\"J_DcAsyn tb-shop\">\n<div id=\"shop15469243798\" class=\"J_TModule\" data-widgetid=\"15469243798\" data-componentid=\"5003\" data-spm=\"110.0.5003-15469243798\" data-title=\"自定义内容区\">&nbsp;</div>\n<div id=\"shop15113882077\" class=\"J_TModule\" data-widgetid=\"15113882077\" data-componentid=\"5003\" data-spm=\"110.0.5003-15113882077\" data-title=\"自定义内容区\">\n<div class=\"skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined\"><s class=\"skin-box-tp\"></s>\n<div class=\"skin-box-bd clear-fix\">\n<table border=\"0\" width=\"790\" cellspacing=\"0\" cellpadding=\"0\">\n<tbody>\n<tr>\n<td colspan=\"3\"><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=599968964980&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i3/1803112320/O1CN01Y7ux221T0bTNocWyD_!!1803112320.jpg\" alt=\"\" width=\"790\" height=\"418\" border=\"0\" /></a></td>\n</tr>\n<tr>\n<td colspan=\"3\"><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=571175335686&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i1/1803112320/O1CN01HueuIc1T0bTNoZ6wF_!!1803112320.jpg\" alt=\"\" width=\"790\" height=\"434\" border=\"0\" /></a></td>\n</tr>\n<tr>\n<td><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=602216794739&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i4/1803112320/O1CN01m2mS701T0bTPScjs1_!!1803112320.jpg\" alt=\"\" width=\"264\" height=\"354\" border=\"0\" /></a></td>\n<td><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=598161428944&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i3/1803112320/O1CN01GD3EgE1T0bTL4ij97_!!1803112320.jpg\" alt=\"\" width=\"262\" height=\"354\" border=\"0\" /></a></td>\n<td><a href=\"https://detail.tmall.com/item.htm?spm=a212k0.12153887.0.0.4e60687dY9pDoR&amp;id=598091454735&amp;scene=taobao_shop\"><img class=\"img-ks-lazyload\" src=\"https://gdp.alicdn.com/imgextra/i4/1803112320/O1CN0136U2S11T0bTCgA7Oa_!!1803112320.jpg\" alt=\"\" width=\"264\" height=\"354\" border=\"0\" /></a></td>\n</tr>\n</tbody>\n</table>\n</div>\n<s class=\"skin-box-bt\"></s></div>\n</div>\n<div id=\"shop15786999061\" class=\"J_TModule\" data-widgetid=\"15786999061\" data-componentid=\"5003\" data-spm=\"110.0.5003-15786999061\" data-title=\"自定义内容区\">&nbsp;</div>\n</div>\n</div>\n<div id=\"description\" class=\"J_DetailSection tshop-psm tshop-psm-bdetaildes\">\n<div class=\"content ke-post\"><img id=\"desc-module-1\" class=\"desc_anchor img-ks-lazyload\" src=\"https://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif\" />\n<p><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i1/1803112320/O1CN01sbHGTV1T0bQQqrcPr_!!1803112320.jpg\" align=\"absmiddle\" /><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i4/1803112320/O1CN0117iS1U1T0bQSK2pja_!!1803112320.jpg\" align=\"absmiddle\" /></p>\n</div>\n</div>', '', '', '', 0, 19, 23, 38, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-faffce094c1f4961926a1344f5b17691.', '0', '13146587711', NULL, NULL, '2020-09-20 16:24:08', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 9, '平台自营');
INSERT INTO `pms_goods` VALUES (45, '珊瑚绒毯子加厚冬季学生宿舍铺床毛毯单人午睡夏空调毯法兰绒床单', NULL, 1080.00, '', '', '', '', '', 0, 19, 23, 38, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', '0', '13146587711', NULL, NULL, '2020-09-20 16:25:42', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 9, '平台自营');
INSERT INTO `pms_goods` VALUES (46, '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕', NULL, 1155.00, '', '', '', '', '', 0, 19, 23, 38, 4, 7, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '0', '13146587711', NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 9, '平台自营');
INSERT INTO `pms_goods` VALUES (47, 'iphone', NULL, 5000.00, '<p>1123</p>', '<p>123123</p>', '', '', '', 0, 19, 22, 28, 4, 4, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', '0', 'admin2', NULL, NULL, '2020-09-20 22:24:09', NULL, NULL, 0.00, 0.00, '3', '1', '1', '', '', 0, '平台自营');
INSERT INTO `pms_goods` VALUES (48, '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码', NULL, 1419.00, '', '', '', '', '', 30, 19, 22, 28, 4, 8, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '0', '13146581122', NULL, NULL, '2020-09-21 08:46:35', '2020-09-27 16:17:21', NULL, 0.20, 0.10, '3', '1', '0', '', '', 14, '耐克（NIKE）京东自营专区');
INSERT INTO `pms_goods` VALUES (49, '12', NULL, 1015.00, '', '', '', '', '', 0, 19, 23, 38, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '0', 'admin2', NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (50, 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41', NULL, 1588.00, '', '', '', '', '', 30, 19, 22, 29, 4, 8, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '0', 'admin1', NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 14, '耐克（NIKE）京东自营专区');
INSERT INTO `pms_goods` VALUES (51, '女士皮鞋', NULL, 1150.00, '', '<div id=\"attributes\" class=\"attributes\">\n<div id=\"J_AttrList\" class=\"attributes-list\">\n<div id=\"J_BrandAttr\" class=\"tm-clear tb-hidden tm_brandAttr\" data-spm-anchor-id=\"a220o.1000855.0.i0.78d121d6rdZv6q\">\n<div class=\"name\">品牌名称：<strong class=\"J_EbrandLogo\">Miffy/米菲</strong></div>\n</div>\n<p class=\"attr-list-hd tm-clear\"><em>产品参数：</em></p>\n<ul id=\"J_AttrUL\">\n<li id=\"J_attrBrandName\" title=\"&nbsp;Miffy/米菲\">品牌:&nbsp;Miffy/米菲</li>\n<li title=\"&nbsp;2岁&nbsp;3岁&nbsp;4岁&nbsp;5岁&nbsp;6岁&nbsp;7岁&nbsp;8岁&nbsp;9岁&nbsp;10岁&nbsp;11岁&nbsp;12岁&nbsp;13岁&nbsp;14岁&nbsp;14岁以上\">适用年龄:&nbsp;2岁&nbsp;3岁&nbsp;4岁&nbsp;5岁&nbsp;6岁&nbsp;7岁&nbsp;8岁&nbsp;9岁&nbsp;10岁&nbsp;11岁&nbsp;12岁&nbsp;13岁&nbsp;14岁&nbsp;14岁以上</li>\n<li title=\"&nbsp;毛绒\">材质:&nbsp;毛绒</li>\n<li title=\"&nbsp;中性\">适用性别:&nbsp;中性</li>\n<li title=\"&nbsp;公仔\">玩具类型:&nbsp;公仔</li>\n<li title=\"&nbsp;白色\">颜色分类:&nbsp;白色</li>\n<li title=\"&nbsp;米菲兔/Miffy\">卡通角色:&nbsp;米菲兔/Miffy</li>\n<li title=\"&nbsp;PP棉\">填充物:&nbsp;PP棉</li>\n<li title=\"&nbsp;33厘米\">高度:&nbsp;33厘米</li>\n<li title=\"&nbsp;24182201\">货号:&nbsp;24182201</li>\n<li title=\"&nbsp;原装正版\">版本类型:&nbsp;原装正版</li>\n<li title=\"&nbsp;兔兔\">玩偶种类:&nbsp;兔兔</li>\n</ul>\n</div>\n</div>\n<div id=\"mall-banner\">\n<div data-spm=\"1998132255\">&nbsp;</div>\n<div id=\"J_DescTMS1\">&nbsp;</div>\n<div class=\"tm--des\">\n<div class=\"tmhk--sevice--des\">\n<div class=\"zebra-hk-detail-fuwu-hd\"><img src=\"https://gtms04.alicdn.com/tps/i4/TB15j_uKXXXXXaLXVXX50bNJpXX-240-60.png\" alt=\"天猫国际专项服务承诺\" /></div>\n</div>\n<div class=\"tm--des\">\n<div class=\"zebra-hk-detail-fuwu-bd-item\">\n<div class=\"icon\"><img src=\"https://img.alicdn.com/tps/TB1KidEKXXXXXcnXpXXXXXXXXXX-80-80.png\" alt=\"正品保障\" /></div>\n<div>\n<div class=\"title\">正品保障</div>\n<div class=\"desc\">100%海外原装正品：所有商品均属海外生产或销售；因此，所售商品一律为100%海外原装正品。&nbsp;<a class=\"more\" href=\"https://rule.tmall.hk/rule/rule_detail.htm?spm=a220o.1000855.0.0.8zPFjb&amp;id=1573&amp;acm=lb-zebra-27913-338660.1003.8.461078&amp;tag=self&amp;scm=1003.8.lb-zebra-27913-338660.ITEM_14436605719881_461078\" target=\"_blank\" rel=\"noopener\">了解详情&gt;&gt;</a></div>\n</div>\n</div>\n</div>\n</div>\n</div>\n<div id=\"J_TmpActBanner\">&nbsp;</div>\n<div id=\"J_DcTopRightWrap\">&nbsp;</div>\n<div id=\"description\" class=\"J_DetailSection tshop-psm tshop-psm-bdetaildes\">\n<div class=\"content ke-post\"><img id=\"desc-module-1\" class=\"desc_anchor img-ks-lazyload\" src=\"https://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif\" />\n<p><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i2/2206434878500/O1CN01E0iUcC2Cf37iywWZ9_!!2206434878500.jpg\" align=\"absmiddle\" /><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i1/2206434878500/O1CN01fGQuvJ2Cf37uaRb3N_!!2206434878500.jpg\" align=\"absmiddle\" /><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i3/2206434878500/O1CN011GPehr2Cf37jh3qjy_!!2206434878500.jpg\" align=\"absmiddle\" /><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i3/2206434878500/O1CN01MK4wzX2Cf37iDfpPn_!!2206434878500.jpg\" align=\"absmiddle\" /><img class=\"img-ks-lazyload\" src=\"https://img.alicdn.com/imgextra/i1/2206434878500/O1CN01nELiea2Cf37ilrSTQ_!!2206434878500.jpg\" align=\"absmiddle\" /></p>\n</div>\n</div>', '', '', '', 30, 19, 23, 38, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '0', '13146581122', NULL, NULL, '2020-10-27 15:00:56', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 14, '耐克（NIKE）京东自营专区');
INSERT INTO `pms_goods` VALUES (52, '女孩一份', NULL, 1100.00, '', '', '', '', '', 30, 19, 23, 38, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', '0', '13146581122', NULL, NULL, '2020-10-27 15:16:28', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 14, '耐克（NIKE）京东自营专区');
INSERT INTO `pms_goods` VALUES (53, '女士用品', NULL, 1100.00, '', '', '', '', '', 30, 19, 23, 38, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', '0', '13146581122', NULL, NULL, '2020-10-27 15:19:53', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 14, '耐克（NIKE）京东自营专区');
INSERT INTO `pms_goods` VALUES (54, '手机辛苦', NULL, 1011.00, '', '', '', '', '', 30, 21, 36, 37, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783298618.png', '0', '13146581122', NULL, NULL, '2020-10-27 15:22:20', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 14, '耐克（NIKE）京东自营专区');
INSERT INTO `pms_goods` VALUES (55, '女士睡袋', NULL, 1049.00, '', '', '', '', '', 30, 30, 31, 32, 4, 3, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', '0', '13146581122', NULL, NULL, '2020-10-27 15:27:35', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 14, '耐克（NIKE）京东自营专区');
INSERT INTO `pms_goods` VALUES (56, '精选三红蜜柚', NULL, 1030.00, '<div class=\"p-parameter\">&nbsp;</div>\n<div id=\"J-detail-banner\"><a href=\"https://prodev.jd.com/mall/active/2v1S1wu5QCKwvrQibhnJaU7JUFGe/index.html?babelChannel=ttt32\" target=\"_blank\" rel=\"noopener\"><img class=\"\" src=\"https://img30.360buyimg.com/jgsq-productsoa/jfs/t1/132444/16/13727/102511/5f97ec8fE0aa64d43/bbed1770050468ca.gif\" alt=\"\" /></a></div>\n<div id=\"J-detail-pop-tpl-top-new\">&nbsp;</div>\n<div class=\"detail-content clearfix\" data-name=\"z-have-detail-nav\">\n<div class=\"detail-content-wrap\">\n<div class=\"detail-content-item\">\n<div id=\"J-detail-top\">&nbsp;</div>\n<div id=\"J-detail-content\"><br />\n<div><strong>1、生鲜&ldquo;优鲜赔&rdquo;绿色通道</strong><br />\n<p>&ldquo;优鲜赔&rdquo;服务是为魔镜等级S2及以上的京东优质客户提供的售后特色服务，符合条件的生鲜自营订单商品有破损或腐坏等问题，可以在商品签收后48小时内提交&ldquo;优鲜赔&rdquo;申请，提交申请后100分钟内审核通过后即享补偿或退款，无需返回商品，为客户节省了返回商品的物流等待时间和收货检测的处理时间（非鲜活易腐类商品除外）。</p>\n<strong>2、专业生鲜客服团队&mdash;让您售后无忧</strong><br />\n<p>微信在线客服：JD-fresh<br />京东生鲜客服电话：400-606-3311<br />服务时间：09:00-24:00</p>\n</div>\n<div id=\"zbViewModulesH\">&nbsp;</div>\n<div>&nbsp;</div>\n<div class=\"ssd-module-wrap\">\n<div class=\"ssd-module M16025789276981 animate-M16025789276981\" data-id=\"M16025789276981\">&nbsp;</div>\n</div>\n</div>\n</div>\n</div>\n</div>', '', '', '', '', 46, 45, 46, 47, 8, 9, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879288155.jpg', '0', '15882301651', NULL, NULL, '2020-10-28 18:08:26', '2020-10-29 10:09:56', NULL, 0.10, 0.05, '3', '1', '0', '', '', 17, '柚子测试店');
INSERT INTO `pms_goods` VALUES (57, '红心柚子新鲜水果送礼', NULL, 1060.00, '<p><img class=\"\" src=\"http://img30.360buyimg.com/popWareDetail/jfs/t1/131133/21/8471/179763/5f49f96cE977b716a/58fd3471ec835aad.jpg\" /></p>', '<p><img class=\"\" src=\"http://img30.360buyimg.com/popWareDetail/jfs/t1/131133/21/8471/179763/5f49f96cE977b716a/58fd3471ec835aad.jpg\" /></p>', '', '', '', 46, 45, 46, 47, 8, 9, NULL, NULL, NULL, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879829454.jpg', '0', '15882301651', NULL, NULL, '2020-10-28 18:11:33', '2020-10-29 10:09:43', NULL, 0.10, 0.10, '3', '1', '0', '', '', 17, '柚子测试店');
INSERT INTO `pms_goods` VALUES (58, '爱衣买衣2020秋季新款女装打底衫女长袖内搭高领网纱亮丝针织上衣', NULL, 1060.00, '', '<p><img class=\"wscnph\" src=\"1604457064953.jpg\" /><img class=\"wscnph\" src=\"1604457062547.jpg\" /><img class=\"wscnph\" src=\"1604457065378.jpg\" /></p>', '', '', '', 0, 19, 23, 52, 7, 12, NULL, NULL, NULL, '1604456997123.jpg', '0', 'admin', NULL, NULL, '2020-11-04 10:31:56', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (59, '睡衣睡衣', NULL, 1038.00, '', '<p><img class=\"wscnph\" src=\"1604626580610.jpg\" /><img class=\"wscnph\" src=\"1604626572969.jpg\" /></p>', '', '', '', 25, 19, 23, 38, 4, 3, NULL, NULL, NULL, '1604626654468.jpg', '0', 'admin1', NULL, NULL, '2020-11-06 09:36:21', '2020-11-06 09:37:43', NULL, 0.00, 0.00, '3', '1', '0', '', '', 10, '小米官方旗舰店');
INSERT INTO `pms_goods` VALUES (60, '黄斑一泡净', NULL, 1110.00, '', '<p>弱碱性低温黄斑一泡净，高效去除果汁、红酒、尿渍、汗渍、霉斑、药水等各种黄渍。</p>', '', '', '', 0, 30, 31, 32, 4, 10, NULL, NULL, NULL, '1604737462264.png', '0', 'admin2', NULL, NULL, '2020-11-07 16:25:40', '2020-11-07 20:48:45', NULL, 0.00, 0.00, '3', '1', '0', '1604737484632.mp4', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (61, '水洗柔顺固色剂', NULL, 1160.00, '', '<p>本产品主要针对各种水洗衣物串色，容易掉色的衣物的预防。</p>', '', '', '', 0, 30, 31, 32, 4, 10, NULL, NULL, NULL, '1604738015905.jpg', '0', 'admin2', NULL, NULL, '2020-11-07 16:34:16', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');
INSERT INTO `pms_goods` VALUES (62, '水洗柔顺固色剂', NULL, 1160.00, '', '<p>本产品主要针对各种水洗衣物串色，容易掉色的衣物的预防。</p>', '', '', '', 25, 30, 31, 32, 4, 4, NULL, NULL, NULL, '1604762960926.png', '0', 'admin1', NULL, NULL, '2020-11-07 23:30:00', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 10, '小米官方旗舰店');
INSERT INTO `pms_goods` VALUES (63, '水洗柔顺固色剂', NULL, 1160.00, '', '<p>本产品主要针对各种水洗衣物串色，容易掉色的衣物的预防。</p>', '', '', '', 25, 30, 31, 32, 4, 4, NULL, NULL, NULL, '1604762960926.png', '0', 'admin1', NULL, NULL, '2020-11-07 23:30:51', '2020-11-17 08:34:20', NULL, 0.05, 0.02, '3', '2', '0', '', '', 10, '小米官方旗舰店');
INSERT INTO `pms_goods` VALUES (64, '111111', NULL, 10.00, '', '<p>1111111</p>', '', '', '', 0, 19, 23, 52, 7, 3, NULL, NULL, NULL, '1605624498815.png', '0', 'admin', NULL, NULL, '2020-11-17 22:48:53', '2020-11-17 22:51:43', NULL, 0.00, 0.00, '3', '1', '0', '', '', 19, '平台自营');
INSERT INTO `pms_goods` VALUES (65, 'xx', NULL, 22.00, '', '<p>11</p>', '', '', '', 0, 19, 23, 38, 4, 3, NULL, NULL, NULL, '1605677196912.png', '0', 'admin1', NULL, NULL, '2020-11-18 13:27:52', NULL, NULL, 0.00, 0.00, '3', '1', '0', '', '', 7, '平台自营');

-- ----------------------------
-- Table structure for pms_goods_attribute_value
-- ----------------------------
DROP TABLE IF EXISTS `pms_goods_attribute_value`;
CREATE TABLE `pms_goods_attribute_value`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `spu_id` bigint(20) NOT NULL COMMENT '商品id',
  `attribute_id` varchar(126) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属性id',
  `attribute_name` varchar(126) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属性名称',
  `attribute_value_id` varchar(126) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属性值id',
  `attribute_value` varchar(126) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '属性值',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记 0 未删除 1删除 默认0 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `spu_id`(`spu_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 98 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品下面的属性值' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_goods_attribute_value
-- ----------------------------
INSERT INTO `pms_goods_attribute_value` VALUES (41, 25, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (42, 26, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (43, 27, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (44, 28, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (45, 29, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (46, 30, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (47, 31, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (48, 32, '159807764670340', '年份', '15980776467161598077646703401', '2000', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (49, 33, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (50, 34, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (51, 35, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (53, 36, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (54, 22, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (55, 37, '159807764670340', '年份', '15980776467161598077646703401', '2000', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (56, 38, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (57, 39, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (58, 40, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (59, 41, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (60, 42, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (62, 44, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (63, 45, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (64, 46, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (65, 47, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (67, 48, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (68, 49, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (69, 50, '159807764670340', '年份', '15980776467161598077646703401', '2000', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (70, 51, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (71, 52, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (72, 53, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (73, 54, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (74, 55, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (75, 56, '160387814725880', '产地', '16038781472661603878147258800', '成都', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (76, 57, '160387814725880', '产地', '16038781472661603878147258801', '重庆', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (79, 23, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (80, 58, '160285999774970', '3', '16028599977561602859997749701', '仍然', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (81, 58, '160285999774971', '4', '16028599977631602859997749710', '44', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (83, 59, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (85, 61, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (86, 60, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (87, 62, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (88, 63, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (91, 43, '159807764670340', '年份', '15980776467161598077646703401', '2000', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (94, 64, '160285999774970', '3', '16028599977561602859997749700', '3', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (95, 64, '160285999774971', '4', '16028599977631602859997749710', '44', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (96, 65, '159807764670340', '年份', '15980776467161598077646703401', '2000', '0');
INSERT INTO `pms_goods_attribute_value` VALUES (97, 24, '159807764670340', '年份', '15980776467161598077646703400', '1999', '0');

-- ----------------------------
-- Table structure for pms_goods_image
-- ----------------------------
DROP TABLE IF EXISTS `pms_goods_image`;
CREATE TABLE `pms_goods_image`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `spu_id` bigint(20) NOT NULL COMMENT '商品id',
  `url` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '图片地址',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记  0 未删除 1 删除 默认0 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `spu_id`(`spu_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 92 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品的图片表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_goods_image
-- ----------------------------
INSERT INTO `pms_goods_image` VALUES (27, 25, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-733e78fcd86f498cb4393a5b4a5e7fb0.', '0');
INSERT INTO `pms_goods_image` VALUES (28, 26, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-cce03f90b1094dd682f656c33224b33c.', '0');
INSERT INTO `pms_goods_image` VALUES (29, 27, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-47b109458e264c3195c8204ce9b0c5cc.', '0');
INSERT INTO `pms_goods_image` VALUES (30, 28, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-0a3589732c5748e5972f7dcb420cf7d1.', '0');
INSERT INTO `pms_goods_image` VALUES (31, 29, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-98bf4f772a634526ab25d36c925c66a2.', '0');
INSERT INTO `pms_goods_image` VALUES (32, 30, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-44a7b17e7cb74276b0d9fc1c8c9fb4e9.', '0');
INSERT INTO `pms_goods_image` VALUES (33, 31, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-c0186338aaf34b0eb58b526ad4814b1c.', '0');
INSERT INTO `pms_goods_image` VALUES (34, 32, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-611d545be3c64a8f81258c2a588e900d.', '0');
INSERT INTO `pms_goods_image` VALUES (35, 33, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-91038407ea2b4826a63d629b701e1717.', '0');
INSERT INTO `pms_goods_image` VALUES (36, 34, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-41c216ad6a534e4f95a2caaa40c9b981.', '0');
INSERT INTO `pms_goods_image` VALUES (37, 35, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200901-236dc7279f154fb6b8334238d77490d1.', '0');
INSERT INTO `pms_goods_image` VALUES (39, 36, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', '0');
INSERT INTO `pms_goods_image` VALUES (40, 22, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '0');
INSERT INTO `pms_goods_image` VALUES (41, 37, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '0');
INSERT INTO `pms_goods_image` VALUES (42, 37, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', '0');
INSERT INTO `pms_goods_image` VALUES (43, 38, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '0');
INSERT INTO `pms_goods_image` VALUES (44, 39, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-bd724755fdf44ab3bc7f23ba968ddef3.', '0');
INSERT INTO `pms_goods_image` VALUES (45, 40, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ed98d27f13be42f2b8d4950945ffaea2.', '0');
INSERT INTO `pms_goods_image` VALUES (46, 41, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-32790a8d138b4059b9d5fed76571707d.', '0');
INSERT INTO `pms_goods_image` VALUES (47, 42, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-928522e0946d45c38a6afe1fab078377.', '0');
INSERT INTO `pms_goods_image` VALUES (50, 44, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-faffce094c1f4961926a1344f5b17691.', '0');
INSERT INTO `pms_goods_image` VALUES (51, 45, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', '0');
INSERT INTO `pms_goods_image` VALUES (52, 46, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '0');
INSERT INTO `pms_goods_image` VALUES (53, 47, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', '0');
INSERT INTO `pms_goods_image` VALUES (55, 48, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '0');
INSERT INTO `pms_goods_image` VALUES (56, 49, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '0');
INSERT INTO `pms_goods_image` VALUES (57, 50, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '0');
INSERT INTO `pms_goods_image` VALUES (58, 51, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (59, 52, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (60, 53, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (61, 54, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783298618.png', '0');
INSERT INTO `pms_goods_image` VALUES (62, 55, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (63, 56, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879288155.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (64, 57, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879829454.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (69, 23, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-e3d6abfbbdb040fe9f745a48a1de0952.', '0');
INSERT INTO `pms_goods_image` VALUES (70, 23, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-12817197adc541bc88d2f2e584081dd5.', '0');
INSERT INTO `pms_goods_image` VALUES (71, 58, '1604456997123.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (72, 58, '1604457002280.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (73, 58, '1604457008825.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (74, 58, '1604457004213.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (75, 58, '1604457007723.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (77, 59, '1604626654468.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (79, 61, '1604738015905.jpg', '0');
INSERT INTO `pms_goods_image` VALUES (80, 60, '1604737462264.png', '0');
INSERT INTO `pms_goods_image` VALUES (81, 62, '1604762960926.png', '0');
INSERT INTO `pms_goods_image` VALUES (82, 63, '1604762960926.png', '0');
INSERT INTO `pms_goods_image` VALUES (86, 43, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0');
INSERT INTO `pms_goods_image` VALUES (87, 43, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', '0');
INSERT INTO `pms_goods_image` VALUES (89, 64, '1605624498815.png', '0');
INSERT INTO `pms_goods_image` VALUES (90, 65, '1605677196912.png', '0');
INSERT INTO `pms_goods_image` VALUES (91, 24, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', '0');

-- ----------------------------
-- Table structure for pms_goods_import
-- ----------------------------
DROP TABLE IF EXISTS `pms_goods_import`;
CREATE TABLE `pms_goods_import`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '商品名称',
  `sub_title` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '商品副标题',
  `price` decimal(20, 2) DEFAULT NULL COMMENT '商品价格',
  `seo_title` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'see标题',
  `seo_keywords` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'seo关键字',
  `seo_desc` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'see描述',
  `is_release` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否发布 0 未发布 1 发布 默认0 ',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记 0 未删除 1 删除 默认0 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品导入表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for pms_goods_service_support
-- ----------------------------
DROP TABLE IF EXISTS `pms_goods_service_support`;
CREATE TABLE `pms_goods_service_support`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `spu_id` bigint(20) NOT NULL COMMENT '商品id 对应pms_goods表中的id',
  `service_support_id` bigint(20) NOT NULL COMMENT '服务支持id  对应ls_service_support中的id',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记 0 未删除 1 删除 默认0 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `spu_id`(`spu_id`) USING BTREE,
  INDEX `service_support_id`(`service_support_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 47 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品和服务支持的关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_goods_service_support
-- ----------------------------
INSERT INTO `pms_goods_service_support` VALUES (15, 29, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (18, 22, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (19, 22, 4, '0');
INSERT INTO `pms_goods_service_support` VALUES (20, 37, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (21, 38, 4, '0');
INSERT INTO `pms_goods_service_support` VALUES (23, 48, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (24, 50, 4, '0');
INSERT INTO `pms_goods_service_support` VALUES (25, 56, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (26, 57, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (29, 23, 4, '0');
INSERT INTO `pms_goods_service_support` VALUES (30, 23, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (31, 58, 4, '0');
INSERT INTO `pms_goods_service_support` VALUES (32, 58, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (34, 59, 4, '0');
INSERT INTO `pms_goods_service_support` VALUES (37, 61, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (38, 61, 4, '0');
INSERT INTO `pms_goods_service_support` VALUES (39, 60, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (40, 60, 4, '0');
INSERT INTO `pms_goods_service_support` VALUES (44, 64, 3, '0');
INSERT INTO `pms_goods_service_support` VALUES (45, 64, 4, '0');
INSERT INTO `pms_goods_service_support` VALUES (46, 24, 3, '0');

-- ----------------------------
-- Table structure for pms_goods_spec_value
-- ----------------------------
DROP TABLE IF EXISTS `pms_goods_spec_value`;
CREATE TABLE `pms_goods_spec_value`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `spu_id` bigint(20) NOT NULL COMMENT '商品id 对应pms_goods表中的id',
  `spec_id` bigint(20) NOT NULL COMMENT '规格id  对应pms_spec表中的id',
  `spec_value_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '规格值id  对应pms_spec_value表中的id',
  `url` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '规格值的图片地址',
  `value_remark` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '规格值',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记  0 未删除 1 删除 默认0 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `spu_id`(`spu_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 310 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品和规格值的关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_goods_spec_value
-- ----------------------------
INSERT INTO `pms_goods_spec_value` VALUES (85, 25, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (86, 25, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (87, 25, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (88, 26, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (89, 26, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (90, 26, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (91, 27, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (92, 27, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (93, 27, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (94, 28, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (95, 28, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (96, 28, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (97, 29, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (98, 29, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (99, 29, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (100, 30, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (101, 30, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (102, 30, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (103, 31, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (104, 31, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (105, 31, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (106, 32, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (107, 32, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (108, 32, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (109, 33, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (110, 33, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (111, 33, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (112, 34, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (113, 34, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (114, 34, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (115, 35, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (116, 35, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (117, 35, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (124, 36, 4, '160024832705840', NULL, 'S', '0');
INSERT INTO `pms_goods_spec_value` VALUES (125, 36, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (126, 36, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (127, 36, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (128, 22, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (129, 22, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (130, 22, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (131, 22, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (132, 22, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (133, 22, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (134, 37, 4, '160024832705840', NULL, 'S', '0');
INSERT INTO `pms_goods_spec_value` VALUES (135, 37, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (136, 37, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (137, 37, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (138, 37, 7, '160051955944070', NULL, '4GB+128GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (139, 37, 7, '160051955944071', NULL, '8GB+256GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (140, 37, 7, '160051955944072', NULL, '16GB+512GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (141, 38, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (142, 38, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (143, 38, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (144, 38, 7, '160051955944070', NULL, '4GB+128GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (145, 38, 7, '160051955944071', NULL, '8GB+256GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (146, 38, 7, '160051955944072', NULL, '16GB+512GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (147, 39, 7, '160051955944070', NULL, '4GB+128GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (148, 39, 7, '160051955944071', NULL, '8GB+256GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (149, 39, 7, '160051955944072', NULL, '16GB+512GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (150, 40, 7, '160051955944070', NULL, '4GB+128GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (151, 40, 7, '160051955944071', NULL, '8GB+256GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (152, 40, 7, '160051955944072', NULL, '16GB+512GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (153, 41, 7, '160051955944070', NULL, '4GB+128GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (154, 41, 7, '160051955944071', NULL, '8GB+256GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (155, 41, 7, '160051955944072', NULL, '16GB+512GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (156, 42, 7, '160051955944070', NULL, '4GB+128GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (157, 42, 7, '160051955944071', NULL, '8GB+256GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (158, 42, 7, '160051955944072', NULL, '16GB+512GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (166, 44, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (167, 44, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (168, 44, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (169, 45, 5, '160024831359550', NULL, 'SSSS', '0');
INSERT INTO `pms_goods_spec_value` VALUES (170, 45, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (171, 45, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (172, 45, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (173, 46, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (174, 46, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (175, 46, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (176, 46, 5, '160024831359550', NULL, 'SSSS', '0');
INSERT INTO `pms_goods_spec_value` VALUES (177, 46, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (178, 46, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (179, 46, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (180, 47, 4, '160024832705840', NULL, 'S', '0');
INSERT INTO `pms_goods_spec_value` VALUES (181, 47, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (182, 47, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (183, 47, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (191, 48, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (192, 48, 5, '160024831359550', NULL, 'SSSS', '0');
INSERT INTO `pms_goods_spec_value` VALUES (193, 48, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (194, 48, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (195, 48, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (196, 48, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (197, 48, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (198, 49, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (199, 49, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (200, 49, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (201, 49, 5, '160024831359550', NULL, 'SSSS', '0');
INSERT INTO `pms_goods_spec_value` VALUES (202, 49, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (203, 49, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (204, 49, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (205, 49, 5, '160015227683250', NULL, '版型', '0');
INSERT INTO `pms_goods_spec_value` VALUES (206, 50, 5, '160024831359550', NULL, 'SSSS', '0');
INSERT INTO `pms_goods_spec_value` VALUES (207, 50, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (208, 50, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (209, 50, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (210, 50, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (211, 50, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (212, 50, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (213, 51, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (214, 51, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (215, 51, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (216, 51, 4, '160024832705840', NULL, 'S', '0');
INSERT INTO `pms_goods_spec_value` VALUES (217, 51, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (218, 51, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (219, 52, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (220, 52, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (221, 52, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (222, 52, 4, '160024832705840', NULL, 'S', '0');
INSERT INTO `pms_goods_spec_value` VALUES (223, 53, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (224, 53, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (225, 53, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (226, 53, 5, '160015227683250', NULL, '版型', '0');
INSERT INTO `pms_goods_spec_value` VALUES (227, 53, 5, '160024831359550', NULL, 'SSSS', '0');
INSERT INTO `pms_goods_spec_value` VALUES (228, 54, 7, '160051955944070', NULL, '4GB+128GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (229, 54, 7, '160051955944071', NULL, '8GB+256GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (230, 54, 7, '160051955944072', NULL, '16GB+512GB', '0');
INSERT INTO `pms_goods_spec_value` VALUES (231, 55, 6, '160015342229460', NULL, '青春版', '0');
INSERT INTO `pms_goods_spec_value` VALUES (232, 55, 6, '160015342229461', NULL, '荣耀版', '0');
INSERT INTO `pms_goods_spec_value` VALUES (233, 55, 6, '160015342229462', NULL, '畅享旗舰版', '0');
INSERT INTO `pms_goods_spec_value` VALUES (234, 55, 6, '160015342229463', NULL, '耀世巅峰版', '0');
INSERT INTO `pms_goods_spec_value` VALUES (235, 56, 12, '1603877857140121', NULL, '白心柚', '0');
INSERT INTO `pms_goods_spec_value` VALUES (236, 56, 12, '1603877823837120', NULL, '红心柚', '0');
INSERT INTO `pms_goods_spec_value` VALUES (237, 57, 12, '1603877823837120', NULL, '红心柚', '0');
INSERT INTO `pms_goods_spec_value` VALUES (238, 57, 12, '1603877857140121', NULL, '白心柚', '0');
INSERT INTO `pms_goods_spec_value` VALUES (245, 23, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (246, 23, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (247, 23, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (248, 58, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (249, 58, 4, '160024832705840', NULL, 'S', '0');
INSERT INTO `pms_goods_spec_value` VALUES (250, 58, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (251, 58, 4, '160378339028740', NULL, '黑色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (252, 58, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (255, 59, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (256, 59, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (259, 61, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (260, 61, 4, '160378339028740', NULL, '黑色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (261, 60, 4, '160378339028740', NULL, '黑色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (262, 60, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (263, 62, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (264, 62, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (265, 62, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (266, 62, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (267, 63, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (268, 63, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (269, 63, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (270, 63, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (282, 43, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (283, 43, 5, '160024831359550', NULL, 'SSSS', '0');
INSERT INTO `pms_goods_spec_value` VALUES (284, 43, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (285, 43, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (286, 43, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (287, 43, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (288, 43, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (294, 64, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (295, 64, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (296, 64, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (297, 64, 4, '160024832705840', NULL, 'S', '0');
INSERT INTO `pms_goods_spec_value` VALUES (298, 64, 4, '160378339028740', NULL, '黑色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (299, 65, 4, '160562477811340', NULL, '', '0');
INSERT INTO `pms_goods_spec_value` VALUES (300, 65, 4, '159807754093040', NULL, '红色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (301, 65, 4, '159807754093041', NULL, '蓝色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (302, 65, 4, '159807754093042', NULL, '白色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (303, 65, 4, '160024832705840', NULL, 'S', '0');
INSERT INTO `pms_goods_spec_value` VALUES (304, 65, 4, '160378339028740', NULL, '黑色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (305, 65, 4, '160567722418440', '', '紫色', '0');
INSERT INTO `pms_goods_spec_value` VALUES (306, 24, 5, '159807755904350', NULL, 'L', '0');
INSERT INTO `pms_goods_spec_value` VALUES (307, 24, 5, '159807755904351', NULL, 'M', '0');
INSERT INTO `pms_goods_spec_value` VALUES (308, 24, 5, '159807755904352', NULL, 'XXL', '0');
INSERT INTO `pms_goods_spec_value` VALUES (309, 24, 5, '160024831359550', '', 'SSSS', '0');

-- ----------------------------
-- Table structure for pms_service_support
-- ----------------------------
DROP TABLE IF EXISTS `pms_service_support`;
CREATE TABLE `pms_service_support`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '服务支持的名称',
  `url` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '服务支持的图片地址',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记  0 未删除 1删除  默认0',
  `create_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者名称',
  `modify_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者名称',
  `del_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除者名称',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 5 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '服务支持表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_service_support
-- ----------------------------
INSERT INTO `pms_service_support` VALUES (3, '7天包邮', NULL, '0', NULL, NULL, NULL, '2020-08-22 14:47:45', NULL, NULL);
INSERT INTO `pms_service_support` VALUES (4, '7天包退', NULL, '0', NULL, NULL, NULL, '2020-08-22 14:48:03', NULL, NULL);

-- ----------------------------
-- Table structure for pms_shipping_method
-- ----------------------------
DROP TABLE IF EXISTS `pms_shipping_method`;
CREATE TABLE `pms_shipping_method`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `template_id` bigint(20) NOT NULL COMMENT '运费模版id',
  `first` int(11) NOT NULL COMMENT '首件 或者 首重',
  `money` decimal(20, 2) DEFAULT NULL COMMENT '首件或者首重的价格',
  `first_plu` int(11) DEFAULT NULL COMMENT '增加几件或者几克',
  `moeny_plu` decimal(20, 2) DEFAULT NULL COMMENT '增加的钱',
  `is_default` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否默认  0 否 1 是 默认 0 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `template_id`(`template_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 33 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '运费方式' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_shipping_method
-- ----------------------------
INSERT INTO `pms_shipping_method` VALUES (12, 7, 1, 0.00, 1, 0.00, '1');
INSERT INTO `pms_shipping_method` VALUES (14, 9, 1, 0.00, 1, 0.00, '1');
INSERT INTO `pms_shipping_method` VALUES (16, 11, 1, 0.00, 1, 0.00, '1');
INSERT INTO `pms_shipping_method` VALUES (21, 15, 1, 0.00, 1, 0.00, '1');
INSERT INTO `pms_shipping_method` VALUES (22, 8, 1, 5.00, 1, 2.00, '1');
INSERT INTO `pms_shipping_method` VALUES (23, 8, 1, 0.00, 1, 0.00, '0');
INSERT INTO `pms_shipping_method` VALUES (24, 14, 1, 0.00, 1, 0.00, '1');
INSERT INTO `pms_shipping_method` VALUES (26, 10, 1, 0.00, 1, 0.00, '1');
INSERT INTO `pms_shipping_method` VALUES (27, 17, 1, 0.00, 1, 0.00, '1');
INSERT INTO `pms_shipping_method` VALUES (28, 18, 1, 0.00, 1, 0.00, '1');
INSERT INTO `pms_shipping_method` VALUES (29, 19, 1, 5.00, 1, 0.00, '1');
INSERT INTO `pms_shipping_method` VALUES (30, 19, 1, 0.00, 1, 0.00, '0');
INSERT INTO `pms_shipping_method` VALUES (31, 20, 1, 0.00, 1, 10.00, '1');
INSERT INTO `pms_shipping_method` VALUES (32, 20, 1, 10.00, 1, 0.00, '0');

-- ----------------------------
-- Table structure for pms_shipping_method_area
-- ----------------------------
DROP TABLE IF EXISTS `pms_shipping_method_area`;
CREATE TABLE `pms_shipping_method_area`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `shipping_method_id` bigint(20) NOT NULL COMMENT '运费方式id',
  `template_id` bigint(20) NOT NULL COMMENT '模版id',
  `city_id` bigint(20) NOT NULL COMMENT '市id',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `shipping_method_id`(`shipping_method_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 710 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '运费方式关联的区域' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_shipping_method_area
-- ----------------------------
INSERT INTO `pms_shipping_method_area` VALUES (365, 23, 8, 6);
INSERT INTO `pms_shipping_method_area` VALUES (366, 30, 19, 73);
INSERT INTO `pms_shipping_method_area` VALUES (367, 32, 20, 342);
INSERT INTO `pms_shipping_method_area` VALUES (368, 32, 20, 258);
INSERT INTO `pms_shipping_method_area` VALUES (369, 32, 20, 259);
INSERT INTO `pms_shipping_method_area` VALUES (370, 32, 20, 260);
INSERT INTO `pms_shipping_method_area` VALUES (371, 32, 20, 261);
INSERT INTO `pms_shipping_method_area` VALUES (372, 32, 20, 262);
INSERT INTO `pms_shipping_method_area` VALUES (373, 32, 20, 263);
INSERT INTO `pms_shipping_method_area` VALUES (374, 32, 20, 264);
INSERT INTO `pms_shipping_method_area` VALUES (375, 32, 20, 265);
INSERT INTO `pms_shipping_method_area` VALUES (376, 32, 20, 266);
INSERT INTO `pms_shipping_method_area` VALUES (377, 32, 20, 343);
INSERT INTO `pms_shipping_method_area` VALUES (378, 32, 20, 236);
INSERT INTO `pms_shipping_method_area` VALUES (379, 32, 20, 1);
INSERT INTO `pms_shipping_method_area` VALUES (380, 32, 20, 73);
INSERT INTO `pms_shipping_method_area` VALUES (381, 32, 20, 2);
INSERT INTO `pms_shipping_method_area` VALUES (382, 32, 20, 74);
INSERT INTO `pms_shipping_method_area` VALUES (383, 32, 20, 75);
INSERT INTO `pms_shipping_method_area` VALUES (384, 32, 20, 76);
INSERT INTO `pms_shipping_method_area` VALUES (385, 32, 20, 77);
INSERT INTO `pms_shipping_method_area` VALUES (386, 32, 20, 78);
INSERT INTO `pms_shipping_method_area` VALUES (387, 32, 20, 79);
INSERT INTO `pms_shipping_method_area` VALUES (388, 32, 20, 80);
INSERT INTO `pms_shipping_method_area` VALUES (389, 32, 20, 81);
INSERT INTO `pms_shipping_method_area` VALUES (390, 32, 20, 82);
INSERT INTO `pms_shipping_method_area` VALUES (391, 32, 20, 83);
INSERT INTO `pms_shipping_method_area` VALUES (392, 32, 20, 84);
INSERT INTO `pms_shipping_method_area` VALUES (393, 32, 20, 85);
INSERT INTO `pms_shipping_method_area` VALUES (394, 32, 20, 86);
INSERT INTO `pms_shipping_method_area` VALUES (395, 32, 20, 37);
INSERT INTO `pms_shipping_method_area` VALUES (396, 32, 20, 38);
INSERT INTO `pms_shipping_method_area` VALUES (397, 32, 20, 39);
INSERT INTO `pms_shipping_method_area` VALUES (398, 32, 20, 40);
INSERT INTO `pms_shipping_method_area` VALUES (399, 32, 20, 41);
INSERT INTO `pms_shipping_method_area` VALUES (400, 32, 20, 42);
INSERT INTO `pms_shipping_method_area` VALUES (401, 32, 20, 43);
INSERT INTO `pms_shipping_method_area` VALUES (402, 32, 20, 44);
INSERT INTO `pms_shipping_method_area` VALUES (403, 32, 20, 45);
INSERT INTO `pms_shipping_method_area` VALUES (404, 32, 20, 46);
INSERT INTO `pms_shipping_method_area` VALUES (405, 32, 20, 47);
INSERT INTO `pms_shipping_method_area` VALUES (406, 32, 20, 48);
INSERT INTO `pms_shipping_method_area` VALUES (407, 32, 20, 49);
INSERT INTO `pms_shipping_method_area` VALUES (408, 32, 20, 50);
INSERT INTO `pms_shipping_method_area` VALUES (409, 32, 20, 51);
INSERT INTO `pms_shipping_method_area` VALUES (410, 32, 20, 52);
INSERT INTO `pms_shipping_method_area` VALUES (411, 32, 20, 53);
INSERT INTO `pms_shipping_method_area` VALUES (412, 32, 20, 54);
INSERT INTO `pms_shipping_method_area` VALUES (413, 32, 20, 55);
INSERT INTO `pms_shipping_method_area` VALUES (414, 32, 20, 56);
INSERT INTO `pms_shipping_method_area` VALUES (415, 32, 20, 57);
INSERT INTO `pms_shipping_method_area` VALUES (416, 32, 20, 58);
INSERT INTO `pms_shipping_method_area` VALUES (417, 32, 20, 59);
INSERT INTO `pms_shipping_method_area` VALUES (418, 32, 20, 60);
INSERT INTO `pms_shipping_method_area` VALUES (419, 32, 20, 61);
INSERT INTO `pms_shipping_method_area` VALUES (420, 32, 20, 62);
INSERT INTO `pms_shipping_method_area` VALUES (421, 32, 20, 63);
INSERT INTO `pms_shipping_method_area` VALUES (422, 32, 20, 64);
INSERT INTO `pms_shipping_method_area` VALUES (423, 32, 20, 65);
INSERT INTO `pms_shipping_method_area` VALUES (424, 32, 20, 66);
INSERT INTO `pms_shipping_method_area` VALUES (425, 32, 20, 67);
INSERT INTO `pms_shipping_method_area` VALUES (426, 32, 20, 68);
INSERT INTO `pms_shipping_method_area` VALUES (427, 32, 20, 69);
INSERT INTO `pms_shipping_method_area` VALUES (428, 32, 20, 70);
INSERT INTO `pms_shipping_method_area` VALUES (429, 32, 20, 71);
INSERT INTO `pms_shipping_method_area` VALUES (430, 32, 20, 72);
INSERT INTO `pms_shipping_method_area` VALUES (431, 32, 20, 87);
INSERT INTO `pms_shipping_method_area` VALUES (432, 32, 20, 88);
INSERT INTO `pms_shipping_method_area` VALUES (433, 32, 20, 89);
INSERT INTO `pms_shipping_method_area` VALUES (434, 32, 20, 90);
INSERT INTO `pms_shipping_method_area` VALUES (435, 32, 20, 91);
INSERT INTO `pms_shipping_method_area` VALUES (436, 32, 20, 92);
INSERT INTO `pms_shipping_method_area` VALUES (437, 32, 20, 93);
INSERT INTO `pms_shipping_method_area` VALUES (438, 32, 20, 94);
INSERT INTO `pms_shipping_method_area` VALUES (439, 32, 20, 95);
INSERT INTO `pms_shipping_method_area` VALUES (440, 32, 20, 96);
INSERT INTO `pms_shipping_method_area` VALUES (441, 32, 20, 97);
INSERT INTO `pms_shipping_method_area` VALUES (442, 32, 20, 114);
INSERT INTO `pms_shipping_method_area` VALUES (443, 32, 20, 113);
INSERT INTO `pms_shipping_method_area` VALUES (444, 32, 20, 112);
INSERT INTO `pms_shipping_method_area` VALUES (445, 32, 20, 111);
INSERT INTO `pms_shipping_method_area` VALUES (446, 32, 20, 110);
INSERT INTO `pms_shipping_method_area` VALUES (447, 32, 20, 109);
INSERT INTO `pms_shipping_method_area` VALUES (448, 32, 20, 108);
INSERT INTO `pms_shipping_method_area` VALUES (449, 32, 20, 107);
INSERT INTO `pms_shipping_method_area` VALUES (450, 32, 20, 106);
INSERT INTO `pms_shipping_method_area` VALUES (451, 32, 20, 105);
INSERT INTO `pms_shipping_method_area` VALUES (452, 32, 20, 104);
INSERT INTO `pms_shipping_method_area` VALUES (453, 32, 20, 103);
INSERT INTO `pms_shipping_method_area` VALUES (454, 32, 20, 102);
INSERT INTO `pms_shipping_method_area` VALUES (455, 32, 20, 101);
INSERT INTO `pms_shipping_method_area` VALUES (456, 32, 20, 100);
INSERT INTO `pms_shipping_method_area` VALUES (457, 32, 20, 99);
INSERT INTO `pms_shipping_method_area` VALUES (458, 32, 20, 98);
INSERT INTO `pms_shipping_method_area` VALUES (459, 32, 20, 115);
INSERT INTO `pms_shipping_method_area` VALUES (460, 32, 20, 116);
INSERT INTO `pms_shipping_method_area` VALUES (461, 32, 20, 117);
INSERT INTO `pms_shipping_method_area` VALUES (462, 32, 20, 118);
INSERT INTO `pms_shipping_method_area` VALUES (463, 32, 20, 119);
INSERT INTO `pms_shipping_method_area` VALUES (464, 32, 20, 120);
INSERT INTO `pms_shipping_method_area` VALUES (465, 32, 20, 121);
INSERT INTO `pms_shipping_method_area` VALUES (466, 32, 20, 122);
INSERT INTO `pms_shipping_method_area` VALUES (467, 32, 20, 123);
INSERT INTO `pms_shipping_method_area` VALUES (468, 32, 20, 124);
INSERT INTO `pms_shipping_method_area` VALUES (469, 32, 20, 125);
INSERT INTO `pms_shipping_method_area` VALUES (470, 32, 20, 126);
INSERT INTO `pms_shipping_method_area` VALUES (471, 32, 20, 127);
INSERT INTO `pms_shipping_method_area` VALUES (472, 32, 20, 128);
INSERT INTO `pms_shipping_method_area` VALUES (473, 32, 20, 129);
INSERT INTO `pms_shipping_method_area` VALUES (474, 32, 20, 130);
INSERT INTO `pms_shipping_method_area` VALUES (475, 32, 20, 131);
INSERT INTO `pms_shipping_method_area` VALUES (476, 32, 20, 132);
INSERT INTO `pms_shipping_method_area` VALUES (477, 32, 20, 133);
INSERT INTO `pms_shipping_method_area` VALUES (478, 32, 20, 134);
INSERT INTO `pms_shipping_method_area` VALUES (479, 32, 20, 151);
INSERT INTO `pms_shipping_method_area` VALUES (480, 32, 20, 150);
INSERT INTO `pms_shipping_method_area` VALUES (481, 32, 20, 149);
INSERT INTO `pms_shipping_method_area` VALUES (482, 32, 20, 148);
INSERT INTO `pms_shipping_method_area` VALUES (483, 32, 20, 147);
INSERT INTO `pms_shipping_method_area` VALUES (484, 32, 20, 146);
INSERT INTO `pms_shipping_method_area` VALUES (485, 32, 20, 145);
INSERT INTO `pms_shipping_method_area` VALUES (486, 32, 20, 144);
INSERT INTO `pms_shipping_method_area` VALUES (487, 32, 20, 143);
INSERT INTO `pms_shipping_method_area` VALUES (488, 32, 20, 142);
INSERT INTO `pms_shipping_method_area` VALUES (489, 32, 20, 141);
INSERT INTO `pms_shipping_method_area` VALUES (490, 32, 20, 140);
INSERT INTO `pms_shipping_method_area` VALUES (491, 32, 20, 139);
INSERT INTO `pms_shipping_method_area` VALUES (492, 32, 20, 138);
INSERT INTO `pms_shipping_method_area` VALUES (493, 32, 20, 137);
INSERT INTO `pms_shipping_method_area` VALUES (494, 32, 20, 136);
INSERT INTO `pms_shipping_method_area` VALUES (495, 32, 20, 135);
INSERT INTO `pms_shipping_method_area` VALUES (496, 32, 20, 169);
INSERT INTO `pms_shipping_method_area` VALUES (497, 32, 20, 168);
INSERT INTO `pms_shipping_method_area` VALUES (498, 32, 20, 167);
INSERT INTO `pms_shipping_method_area` VALUES (499, 32, 20, 166);
INSERT INTO `pms_shipping_method_area` VALUES (500, 32, 20, 165);
INSERT INTO `pms_shipping_method_area` VALUES (501, 32, 20, 164);
INSERT INTO `pms_shipping_method_area` VALUES (502, 32, 20, 163);
INSERT INTO `pms_shipping_method_area` VALUES (503, 32, 20, 162);
INSERT INTO `pms_shipping_method_area` VALUES (504, 32, 20, 161);
INSERT INTO `pms_shipping_method_area` VALUES (505, 32, 20, 160);
INSERT INTO `pms_shipping_method_area` VALUES (506, 32, 20, 159);
INSERT INTO `pms_shipping_method_area` VALUES (507, 32, 20, 158);
INSERT INTO `pms_shipping_method_area` VALUES (508, 32, 20, 157);
INSERT INTO `pms_shipping_method_area` VALUES (509, 32, 20, 156);
INSERT INTO `pms_shipping_method_area` VALUES (510, 32, 20, 155);
INSERT INTO `pms_shipping_method_area` VALUES (511, 32, 20, 154);
INSERT INTO `pms_shipping_method_area` VALUES (512, 32, 20, 153);
INSERT INTO `pms_shipping_method_area` VALUES (513, 32, 20, 152);
INSERT INTO `pms_shipping_method_area` VALUES (514, 32, 20, 170);
INSERT INTO `pms_shipping_method_area` VALUES (515, 32, 20, 171);
INSERT INTO `pms_shipping_method_area` VALUES (516, 32, 20, 172);
INSERT INTO `pms_shipping_method_area` VALUES (517, 32, 20, 173);
INSERT INTO `pms_shipping_method_area` VALUES (518, 32, 20, 174);
INSERT INTO `pms_shipping_method_area` VALUES (519, 32, 20, 175);
INSERT INTO `pms_shipping_method_area` VALUES (520, 32, 20, 176);
INSERT INTO `pms_shipping_method_area` VALUES (521, 32, 20, 177);
INSERT INTO `pms_shipping_method_area` VALUES (522, 32, 20, 178);
INSERT INTO `pms_shipping_method_area` VALUES (523, 32, 20, 179);
INSERT INTO `pms_shipping_method_area` VALUES (524, 32, 20, 180);
INSERT INTO `pms_shipping_method_area` VALUES (525, 32, 20, 181);
INSERT INTO `pms_shipping_method_area` VALUES (526, 32, 20, 182);
INSERT INTO `pms_shipping_method_area` VALUES (527, 32, 20, 183);
INSERT INTO `pms_shipping_method_area` VALUES (528, 32, 20, 184);
INSERT INTO `pms_shipping_method_area` VALUES (529, 32, 20, 185);
INSERT INTO `pms_shipping_method_area` VALUES (530, 32, 20, 186);
INSERT INTO `pms_shipping_method_area` VALUES (531, 32, 20, 187);
INSERT INTO `pms_shipping_method_area` VALUES (532, 32, 20, 188);
INSERT INTO `pms_shipping_method_area` VALUES (533, 32, 20, 189);
INSERT INTO `pms_shipping_method_area` VALUES (534, 32, 20, 190);
INSERT INTO `pms_shipping_method_area` VALUES (535, 32, 20, 191);
INSERT INTO `pms_shipping_method_area` VALUES (536, 32, 20, 192);
INSERT INTO `pms_shipping_method_area` VALUES (537, 32, 20, 193);
INSERT INTO `pms_shipping_method_area` VALUES (538, 32, 20, 194);
INSERT INTO `pms_shipping_method_area` VALUES (539, 32, 20, 195);
INSERT INTO `pms_shipping_method_area` VALUES (540, 32, 20, 196);
INSERT INTO `pms_shipping_method_area` VALUES (541, 32, 20, 197);
INSERT INTO `pms_shipping_method_area` VALUES (542, 32, 20, 218);
INSERT INTO `pms_shipping_method_area` VALUES (543, 32, 20, 217);
INSERT INTO `pms_shipping_method_area` VALUES (544, 32, 20, 216);
INSERT INTO `pms_shipping_method_area` VALUES (545, 32, 20, 215);
INSERT INTO `pms_shipping_method_area` VALUES (546, 32, 20, 214);
INSERT INTO `pms_shipping_method_area` VALUES (547, 32, 20, 213);
INSERT INTO `pms_shipping_method_area` VALUES (548, 32, 20, 212);
INSERT INTO `pms_shipping_method_area` VALUES (549, 32, 20, 211);
INSERT INTO `pms_shipping_method_area` VALUES (550, 32, 20, 210);
INSERT INTO `pms_shipping_method_area` VALUES (551, 32, 20, 209);
INSERT INTO `pms_shipping_method_area` VALUES (552, 32, 20, 208);
INSERT INTO `pms_shipping_method_area` VALUES (553, 32, 20, 207);
INSERT INTO `pms_shipping_method_area` VALUES (554, 32, 20, 206);
INSERT INTO `pms_shipping_method_area` VALUES (555, 32, 20, 205);
INSERT INTO `pms_shipping_method_area` VALUES (556, 32, 20, 204);
INSERT INTO `pms_shipping_method_area` VALUES (557, 32, 20, 203);
INSERT INTO `pms_shipping_method_area` VALUES (558, 32, 20, 202);
INSERT INTO `pms_shipping_method_area` VALUES (559, 32, 20, 201);
INSERT INTO `pms_shipping_method_area` VALUES (560, 32, 20, 200);
INSERT INTO `pms_shipping_method_area` VALUES (561, 32, 20, 199);
INSERT INTO `pms_shipping_method_area` VALUES (562, 32, 20, 198);
INSERT INTO `pms_shipping_method_area` VALUES (563, 32, 20, 219);
INSERT INTO `pms_shipping_method_area` VALUES (564, 32, 20, 220);
INSERT INTO `pms_shipping_method_area` VALUES (565, 32, 20, 221);
INSERT INTO `pms_shipping_method_area` VALUES (566, 32, 20, 222);
INSERT INTO `pms_shipping_method_area` VALUES (567, 32, 20, 223);
INSERT INTO `pms_shipping_method_area` VALUES (568, 32, 20, 224);
INSERT INTO `pms_shipping_method_area` VALUES (569, 32, 20, 225);
INSERT INTO `pms_shipping_method_area` VALUES (570, 32, 20, 226);
INSERT INTO `pms_shipping_method_area` VALUES (571, 32, 20, 227);
INSERT INTO `pms_shipping_method_area` VALUES (572, 32, 20, 228);
INSERT INTO `pms_shipping_method_area` VALUES (573, 32, 20, 229);
INSERT INTO `pms_shipping_method_area` VALUES (574, 32, 20, 230);
INSERT INTO `pms_shipping_method_area` VALUES (575, 32, 20, 231);
INSERT INTO `pms_shipping_method_area` VALUES (576, 32, 20, 232);
INSERT INTO `pms_shipping_method_area` VALUES (577, 32, 20, 233);
INSERT INTO `pms_shipping_method_area` VALUES (578, 32, 20, 234);
INSERT INTO `pms_shipping_method_area` VALUES (579, 32, 20, 235);
INSERT INTO `pms_shipping_method_area` VALUES (580, 32, 20, 257);
INSERT INTO `pms_shipping_method_area` VALUES (581, 32, 20, 256);
INSERT INTO `pms_shipping_method_area` VALUES (582, 32, 20, 255);
INSERT INTO `pms_shipping_method_area` VALUES (583, 32, 20, 254);
INSERT INTO `pms_shipping_method_area` VALUES (584, 32, 20, 253);
INSERT INTO `pms_shipping_method_area` VALUES (585, 32, 20, 252);
INSERT INTO `pms_shipping_method_area` VALUES (586, 32, 20, 251);
INSERT INTO `pms_shipping_method_area` VALUES (587, 32, 20, 250);
INSERT INTO `pms_shipping_method_area` VALUES (588, 32, 20, 249);
INSERT INTO `pms_shipping_method_area` VALUES (589, 32, 20, 248);
INSERT INTO `pms_shipping_method_area` VALUES (590, 32, 20, 247);
INSERT INTO `pms_shipping_method_area` VALUES (591, 32, 20, 246);
INSERT INTO `pms_shipping_method_area` VALUES (592, 32, 20, 245);
INSERT INTO `pms_shipping_method_area` VALUES (593, 32, 20, 244);
INSERT INTO `pms_shipping_method_area` VALUES (594, 32, 20, 243);
INSERT INTO `pms_shipping_method_area` VALUES (595, 32, 20, 242);
INSERT INTO `pms_shipping_method_area` VALUES (596, 32, 20, 241);
INSERT INTO `pms_shipping_method_area` VALUES (597, 32, 20, 240);
INSERT INTO `pms_shipping_method_area` VALUES (598, 32, 20, 239);
INSERT INTO `pms_shipping_method_area` VALUES (599, 32, 20, 238);
INSERT INTO `pms_shipping_method_area` VALUES (600, 32, 20, 237);
INSERT INTO `pms_shipping_method_area` VALUES (601, 32, 20, 267);
INSERT INTO `pms_shipping_method_area` VALUES (602, 32, 20, 268);
INSERT INTO `pms_shipping_method_area` VALUES (603, 32, 20, 269);
INSERT INTO `pms_shipping_method_area` VALUES (604, 32, 20, 270);
INSERT INTO `pms_shipping_method_area` VALUES (605, 32, 20, 271);
INSERT INTO `pms_shipping_method_area` VALUES (606, 32, 20, 272);
INSERT INTO `pms_shipping_method_area` VALUES (607, 32, 20, 273);
INSERT INTO `pms_shipping_method_area` VALUES (608, 32, 20, 274);
INSERT INTO `pms_shipping_method_area` VALUES (609, 32, 20, 275);
INSERT INTO `pms_shipping_method_area` VALUES (610, 32, 20, 276);
INSERT INTO `pms_shipping_method_area` VALUES (611, 32, 20, 277);
INSERT INTO `pms_shipping_method_area` VALUES (612, 32, 20, 278);
INSERT INTO `pms_shipping_method_area` VALUES (613, 32, 20, 279);
INSERT INTO `pms_shipping_method_area` VALUES (614, 32, 20, 280);
INSERT INTO `pms_shipping_method_area` VALUES (615, 32, 20, 281);
INSERT INTO `pms_shipping_method_area` VALUES (616, 32, 20, 282);
INSERT INTO `pms_shipping_method_area` VALUES (617, 32, 20, 283);
INSERT INTO `pms_shipping_method_area` VALUES (618, 32, 20, 284);
INSERT INTO `pms_shipping_method_area` VALUES (619, 32, 20, 285);
INSERT INTO `pms_shipping_method_area` VALUES (620, 32, 20, 286);
INSERT INTO `pms_shipping_method_area` VALUES (621, 32, 20, 287);
INSERT INTO `pms_shipping_method_area` VALUES (622, 32, 20, 288);
INSERT INTO `pms_shipping_method_area` VALUES (623, 32, 20, 289);
INSERT INTO `pms_shipping_method_area` VALUES (624, 32, 20, 290);
INSERT INTO `pms_shipping_method_area` VALUES (625, 32, 20, 291);
INSERT INTO `pms_shipping_method_area` VALUES (626, 32, 20, 292);
INSERT INTO `pms_shipping_method_area` VALUES (627, 32, 20, 293);
INSERT INTO `pms_shipping_method_area` VALUES (628, 32, 20, 294);
INSERT INTO `pms_shipping_method_area` VALUES (629, 32, 20, 295);
INSERT INTO `pms_shipping_method_area` VALUES (630, 32, 20, 296);
INSERT INTO `pms_shipping_method_area` VALUES (631, 32, 20, 297);
INSERT INTO `pms_shipping_method_area` VALUES (632, 32, 20, 298);
INSERT INTO `pms_shipping_method_area` VALUES (633, 32, 20, 299);
INSERT INTO `pms_shipping_method_area` VALUES (634, 32, 20, 300);
INSERT INTO `pms_shipping_method_area` VALUES (635, 32, 20, 301);
INSERT INTO `pms_shipping_method_area` VALUES (636, 32, 20, 302);
INSERT INTO `pms_shipping_method_area` VALUES (637, 32, 20, 303);
INSERT INTO `pms_shipping_method_area` VALUES (638, 32, 20, 304);
INSERT INTO `pms_shipping_method_area` VALUES (639, 32, 20, 305);
INSERT INTO `pms_shipping_method_area` VALUES (640, 32, 20, 306);
INSERT INTO `pms_shipping_method_area` VALUES (641, 32, 20, 307);
INSERT INTO `pms_shipping_method_area` VALUES (642, 32, 20, 308);
INSERT INTO `pms_shipping_method_area` VALUES (643, 32, 20, 309);
INSERT INTO `pms_shipping_method_area` VALUES (644, 32, 20, 310);
INSERT INTO `pms_shipping_method_area` VALUES (645, 32, 20, 311);
INSERT INTO `pms_shipping_method_area` VALUES (646, 32, 20, 312);
INSERT INTO `pms_shipping_method_area` VALUES (647, 32, 20, 313);
INSERT INTO `pms_shipping_method_area` VALUES (648, 32, 20, 314);
INSERT INTO `pms_shipping_method_area` VALUES (649, 32, 20, 315);
INSERT INTO `pms_shipping_method_area` VALUES (650, 32, 20, 316);
INSERT INTO `pms_shipping_method_area` VALUES (651, 32, 20, 317);
INSERT INTO `pms_shipping_method_area` VALUES (652, 32, 20, 318);
INSERT INTO `pms_shipping_method_area` VALUES (653, 32, 20, 319);
INSERT INTO `pms_shipping_method_area` VALUES (654, 32, 20, 320);
INSERT INTO `pms_shipping_method_area` VALUES (655, 32, 20, 321);
INSERT INTO `pms_shipping_method_area` VALUES (656, 32, 20, 322);
INSERT INTO `pms_shipping_method_area` VALUES (657, 32, 20, 323);
INSERT INTO `pms_shipping_method_area` VALUES (658, 32, 20, 324);
INSERT INTO `pms_shipping_method_area` VALUES (659, 32, 20, 325);
INSERT INTO `pms_shipping_method_area` VALUES (660, 32, 20, 326);
INSERT INTO `pms_shipping_method_area` VALUES (661, 32, 20, 327);
INSERT INTO `pms_shipping_method_area` VALUES (662, 32, 20, 328);
INSERT INTO `pms_shipping_method_area` VALUES (663, 32, 20, 329);
INSERT INTO `pms_shipping_method_area` VALUES (664, 32, 20, 330);
INSERT INTO `pms_shipping_method_area` VALUES (665, 32, 20, 331);
INSERT INTO `pms_shipping_method_area` VALUES (666, 32, 20, 332);
INSERT INTO `pms_shipping_method_area` VALUES (667, 32, 20, 333);
INSERT INTO `pms_shipping_method_area` VALUES (668, 32, 20, 334);
INSERT INTO `pms_shipping_method_area` VALUES (669, 32, 20, 335);
INSERT INTO `pms_shipping_method_area` VALUES (670, 32, 20, 336);
INSERT INTO `pms_shipping_method_area` VALUES (671, 32, 20, 337);
INSERT INTO `pms_shipping_method_area` VALUES (672, 32, 20, 338);
INSERT INTO `pms_shipping_method_area` VALUES (673, 32, 20, 339);
INSERT INTO `pms_shipping_method_area` VALUES (674, 32, 20, 340);
INSERT INTO `pms_shipping_method_area` VALUES (675, 32, 20, 341);
INSERT INTO `pms_shipping_method_area` VALUES (676, 32, 20, 10);
INSERT INTO `pms_shipping_method_area` VALUES (677, 32, 20, 11);
INSERT INTO `pms_shipping_method_area` VALUES (678, 32, 20, 12);
INSERT INTO `pms_shipping_method_area` VALUES (679, 32, 20, 13);
INSERT INTO `pms_shipping_method_area` VALUES (680, 32, 20, 8);
INSERT INTO `pms_shipping_method_area` VALUES (681, 32, 20, 3);
INSERT INTO `pms_shipping_method_area` VALUES (682, 32, 20, 9);
INSERT INTO `pms_shipping_method_area` VALUES (683, 32, 20, 4);
INSERT INTO `pms_shipping_method_area` VALUES (684, 32, 20, 6);
INSERT INTO `pms_shipping_method_area` VALUES (685, 32, 20, 7);
INSERT INTO `pms_shipping_method_area` VALUES (686, 32, 20, 5);
INSERT INTO `pms_shipping_method_area` VALUES (687, 32, 20, 14);
INSERT INTO `pms_shipping_method_area` VALUES (688, 32, 20, 15);
INSERT INTO `pms_shipping_method_area` VALUES (689, 32, 20, 16);
INSERT INTO `pms_shipping_method_area` VALUES (690, 32, 20, 17);
INSERT INTO `pms_shipping_method_area` VALUES (691, 32, 20, 18);
INSERT INTO `pms_shipping_method_area` VALUES (692, 32, 20, 19);
INSERT INTO `pms_shipping_method_area` VALUES (693, 32, 20, 20);
INSERT INTO `pms_shipping_method_area` VALUES (694, 32, 20, 21);
INSERT INTO `pms_shipping_method_area` VALUES (695, 32, 20, 22);
INSERT INTO `pms_shipping_method_area` VALUES (696, 32, 20, 23);
INSERT INTO `pms_shipping_method_area` VALUES (697, 32, 20, 24);
INSERT INTO `pms_shipping_method_area` VALUES (698, 32, 20, 25);
INSERT INTO `pms_shipping_method_area` VALUES (699, 32, 20, 26);
INSERT INTO `pms_shipping_method_area` VALUES (700, 32, 20, 27);
INSERT INTO `pms_shipping_method_area` VALUES (701, 32, 20, 28);
INSERT INTO `pms_shipping_method_area` VALUES (702, 32, 20, 29);
INSERT INTO `pms_shipping_method_area` VALUES (703, 32, 20, 30);
INSERT INTO `pms_shipping_method_area` VALUES (704, 32, 20, 31);
INSERT INTO `pms_shipping_method_area` VALUES (705, 32, 20, 32);
INSERT INTO `pms_shipping_method_area` VALUES (706, 32, 20, 33);
INSERT INTO `pms_shipping_method_area` VALUES (707, 32, 20, 34);
INSERT INTO `pms_shipping_method_area` VALUES (708, 32, 20, 35);
INSERT INTO `pms_shipping_method_area` VALUES (709, 32, 20, 36);

-- ----------------------------
-- Table structure for pms_shipping_method_freeship
-- ----------------------------
DROP TABLE IF EXISTS `pms_shipping_method_freeship`;
CREATE TABLE `pms_shipping_method_freeship`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `template_id` bigint(20) DEFAULT NULL COMMENT '运费模版id',
  `type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '包邮类型 0 件数  1 金额',
  `num` int(11) DEFAULT NULL COMMENT '包邮件数',
  `money` decimal(20, 2) DEFAULT NULL COMMENT '包邮的金额',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `template_id`(`template_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '运费模版包邮' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_shipping_method_freeship
-- ----------------------------
INSERT INTO `pms_shipping_method_freeship` VALUES (6, 8, '0', 1, NULL);
INSERT INTO `pms_shipping_method_freeship` VALUES (7, 20, '0', 2, NULL);

-- ----------------------------
-- Table structure for pms_shipping_method_freeship_area
-- ----------------------------
DROP TABLE IF EXISTS `pms_shipping_method_freeship_area`;
CREATE TABLE `pms_shipping_method_freeship_area`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `shipping_method_freeship_id` bigint(20) DEFAULT NULL COMMENT '运费模版包邮id',
  `template_id` bigint(20) DEFAULT NULL COMMENT '运费模版id',
  `city_id` bigint(20) DEFAULT NULL COMMENT '市id',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `shipping_method_freeship_id`(`shipping_method_freeship_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 17 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '运费方式包邮关联的区域' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_shipping_method_freeship_area
-- ----------------------------
INSERT INTO `pms_shipping_method_freeship_area` VALUES (15, 6, 8, 6);
INSERT INTO `pms_shipping_method_freeship_area` VALUES (16, 7, 20, 73);

-- ----------------------------
-- Table structure for pms_sku
-- ----------------------------
DROP TABLE IF EXISTS `pms_sku`;
CREATE TABLE `pms_sku`  (
  `id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `spu_id` bigint(20) NOT NULL COMMENT '商品id ，对应pms_goods中的id',
  `sku_no` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品的编号',
  `name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品的名称',
  `subtitle` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品的副标题',
  `stock` int(11) NOT NULL COMMENT '单品库存',
  `warning_stock` int(11) DEFAULT NULL COMMENT '预警库存',
  `price` decimal(20, 2) NOT NULL COMMENT '单品价格',
  `weight` decimal(20, 2) NOT NULL COMMENT '单品的重量',
  `store_id` bigint(20) NOT NULL COMMENT '店铺id  如果是平台  则是0',
  `shelves_status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '单品上架状态 0 下架  1上架 2 违规下架 默认0',
  `url` varchar(124) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '默认图片的url',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '审核状态  0 审核通过 1 审核未通过 2 审核中',
  `reason` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '拒绝原因',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记  0 未删除 1删除 默认0',
  `create_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者名称',
  `modify_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者名称',
  `del_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除者名称',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  `up_time` timestamp(0) DEFAULT NULL COMMENT '单品上架时间',
  `commission_rate` decimal(3, 2) DEFAULT 0.00 COMMENT '佣金比例  该字段是冗余字段，和商品表中的佣金比例是一个字断',
  `s_commission_rate` decimal(3, 2) DEFAULT 0.00 COMMENT '二级佣金比例  该字段是冗余字段，和商品表中的佣金比例是一个字断',
  `is_virtual` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否是虚拟商品 0 否 1 是  默认0  该字段是商品冗余字段 和商品表保持一致',
  `is_batch_sku` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否批发商品 0否 1是 默认0',
  `logistics_template_id` bigint(20) DEFAULT NULL COMMENT '物流模版id  该字段是冗余字段和pms_goods表中的保持一致',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `spu_id`(`spu_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '单品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_sku
-- ----------------------------
INSERT INTO `pms_sku` VALUES ('1598079455498220', 22, '1598079424000', '平台牛仔裤(((红色-L)))', '红色-L', 92, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:10:12', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079455498221', 22, '1598079424001', '平台牛仔裤(((红色-M)))', '红色-M', 100, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:10:12', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079455498222', 22, '1598079424002', '平台牛仔裤(((红色-XXL)))', '红色-XXL', 100, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:10:12', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079455498223', 22, '1598079424003', '平台牛仔裤(((蓝色-L)))', '蓝色-L', 100, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:10:12', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079455498224', 22, '1598079424004', '平台牛仔裤(((蓝色-M)))', '蓝色-M', 100, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:10:12', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079455498225', 22, '1598079424005', '平台牛仔裤(((蓝色-XXL)))', '蓝色-XXL', 100, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:10:12', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079455498226', 22, '1598079424006', '平台牛仔裤(((白色-L)))', '白色-L', 100, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:10:12', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079455498227', 22, '1598079424007', '平台牛仔裤(((白色-M)))', '白色-M', 100, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:10:12', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079455498228', 22, '1598079424008', '平台牛仔裤(((白色-XXL)))', '白色-XXL', 100, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:10:12', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079520317230', 23, '1598079500000', '非平台预售商品((((红色))))', '红色', 94, -1, 1001.00, 22.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-e3d6abfbbdb040fe9f745a48a1de0952.', '3', NULL, '0', NULL, NULL, NULL, '2020-11-04 10:18:35', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 8);
INSERT INTO `pms_sku` VALUES ('1598079520317231', 23, '1598079500001', '非平台预售商品((((蓝色))))', '蓝色', 110, -1, 1001.00, 22.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-e3d6abfbbdb040fe9f745a48a1de0952.', '3', NULL, '0', NULL, NULL, NULL, '2020-11-04 10:18:35', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 8);
INSERT INTO `pms_sku` VALUES ('1598079520317232', 23, '1598079500002', '非平台预售商品((((白色))))', '白色', 130, -1, 1001.00, 22.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-e3d6abfbbdb040fe9f745a48a1de0952.', '3', NULL, '0', NULL, NULL, NULL, '2020-11-04 10:18:35', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 8);
INSERT INTO `pms_sku` VALUES ('1598079584422240', 24, '1598079568000', '平台试用商品(((L)))', 'L', 100, -1, 1001.00, 2.00, 0, '0', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-18 13:28:05', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079584422241', 24, '1598079568001', '平台试用商品(((M)))', 'M', 100, -1, 1001.00, 2.00, 0, '0', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-18 13:28:05', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079584422242', 24, '1598079568002', '平台试用商品(((XXL)))', 'XXL', 100, -1, 1001.00, 2.00, 0, '0', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-18 13:28:05', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598079663976250', 25, '1598079623000', '平台分销商品(((红色)))', '红色', 90, -1, 1100.00, 2.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-733e78fcd86f498cb4393a5b4a5e7fb0.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-14 10:38:15', '2020-10-21 19:45:37', NULL, '2020-10-24 16:44:03', 0.10, 0.05, '0', '0', 8);
INSERT INTO `pms_sku` VALUES ('1598079663976251', 25, '1598079623001', '平台分销商品(((蓝色)))', '蓝色', 100, -1, 1050.00, 2.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-733e78fcd86f498cb4393a5b4a5e7fb0.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-14 10:38:15', '2020-10-21 19:45:37', NULL, '2020-10-24 16:44:03', 0.10, 0.05, '0', '0', 8);
INSERT INTO `pms_sku` VALUES ('1598079663976252', 25, '1598079623002', '平台分销商品(((白色)))', '白色', 100, -1, 1080.00, 2.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-733e78fcd86f498cb4393a5b4a5e7fb0.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-14 10:38:15', '2020-10-21 19:45:37', NULL, '2020-10-24 16:44:03', 0.10, 0.05, '0', '0', 8);
INSERT INTO `pms_sku` VALUES ('1598230936517260', 26, '1598230926000', '平台直降商品(L)', 'L', 100, -1, 1040.00, 3.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-cce03f90b1094dd682f656c33224b33c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598230936517261', 26, '1598230926001', '平台直降商品(M)', 'M', 100, -1, 1040.00, 3.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-cce03f90b1094dd682f656c33224b33c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598230936517262', 26, '1598230926002', '平台直降商品(XXL)', 'XXL', 100, -1, 1040.00, 3.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-cce03f90b1094dd682f656c33224b33c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598231219999270', 27, '1598231194000', '平台赠品1((红色))', '红色', 98, -1, 1001.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-47b109458e264c3195c8204ce9b0c5cc.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-14 19:58:52', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598231219999271', 27, '1598231194001', '平台赠品1((蓝色))', '蓝色', 99, -1, 1005.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-47b109458e264c3195c8204ce9b0c5cc.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-14 19:58:52', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598231219999272', 27, '1598231194002', '平台赠品1((白色))', '白色', 100, -1, 1015.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-47b109458e264c3195c8204ce9b0c5cc.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-14 19:58:52', NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598231272851280', 28, '1598231262000', '平台赠品功能(L)', 'L', 97, -1, 1050.00, 12.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-0a3589732c5748e5972f7dcb420cf7d1.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598231272851281', 28, '1598231262001', '平台赠品功能(M)', 'M', 99, -1, 1050.00, 12.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-0a3589732c5748e5972f7dcb420cf7d1.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598231272851282', 28, '1598231262002', '平台赠品功能(XXL)', 'XXL', 100, -1, 1050.00, 12.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-0a3589732c5748e5972f7dcb420cf7d1.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598251119774290', 29, '1598251096000', '平台满减商品(L)', 'L', 98, -1, 1100.00, 12.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-98bf4f772a634526ab25d36c925c66a2.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598251119774291', 29, '1598251096001', '平台满减商品(M)', 'M', 100, -1, 1050.00, 12.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-98bf4f772a634526ab25d36c925c66a2.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598251119774292', 29, '1598251096002', '平台满减商品(XXL)', 'XXL', 100, -1, 1200.00, 12.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-98bf4f772a634526ab25d36c925c66a2.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598257978841300', 30, '1598257963000', '平台满折测试(L)', 'L', 191, -1, 1100.00, 45.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-44a7b17e7cb74276b0d9fc1c8c9fb4e9.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-14 11:27:04', NULL, '2020-10-24 16:44:03', 0.03, 0.04, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598257978841301', 30, '1598257963001', '平台满折测试(M)', 'M', 100, -1, 2000.00, 45.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-44a7b17e7cb74276b0d9fc1c8c9fb4e9.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-14 11:27:04', NULL, '2020-10-24 16:44:03', 0.03, 0.04, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598257978841302', 30, '1598257963002', '平台满折测试(XXL)', 'XXL', 100, -1, 1050.00, 45.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-44a7b17e7cb74276b0d9fc1c8c9fb4e9.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-14 11:27:04', NULL, '2020-10-24 16:44:03', 0.03, 0.04, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598270266233310', 31, '1598270245000', '平台拼团商品((红色))', '红色', 77, -1, 1050.00, 33.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-c0186338aaf34b0eb58b526ad4814b1c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598270266233311', 31, '1598270245001', '平台拼团商品((蓝色))', '蓝色', 96, -1, 1100.00, 33.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-c0186338aaf34b0eb58b526ad4814b1c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598270266233312', 31, '1598270245002', '平台拼团商品((白色))', '白色', 100, -1, 1050.00, 33.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-c0186338aaf34b0eb58b526ad4814b1c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:03', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598442734166320', 32, '1598442714000', '测试支付((红色))', '红色', 85, -1, 1000.01, 43.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-611d545be3c64a8f81258c2a588e900d.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598442734166321', 32, '1598442714001', '测试支付((蓝色))', '蓝色', 100, -1, 1000.01, 43.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-611d545be3c64a8f81258c2a588e900d.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598442734166322', 32, '1598442714002', '测试支付((白色))', '白色', 99, -1, 1000.01, 43.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-611d545be3c64a8f81258c2a588e900d.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598445895165330', 33, '1598445883000', '商户预售商品(红色)', '红色', 97, -1, 1100.00, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-91038407ea2b4826a63d629b701e1717.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-14 12:17:08', NULL, '2020-10-24 16:44:09', 0.11, 0.01, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1598445895165331', 33, '1598445883001', '商户预售商品(蓝色)', '蓝色', 100, -1, 1100.00, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-91038407ea2b4826a63d629b701e1717.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-14 12:17:08', NULL, '2020-10-24 16:44:09', 0.11, 0.01, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1598445895165332', 33, '1598445883002', '商户预售商品(白色)', '白色', 100, -1, 1100.00, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-91038407ea2b4826a63d629b701e1717.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-14 12:17:08', NULL, '2020-10-24 16:44:09', 0.11, 0.01, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1598445933547340', 34, '1598445922000', '商户支付测试(L)', 'L', 90, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-41c216ad6a534e4f95a2caaa40c9b981.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-14 12:17:08', NULL, '2020-10-24 16:44:09', 0.11, 0.01, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1598445933547341', 34, '1598445922001', '商户支付测试(M)', 'M', 100, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-41c216ad6a534e4f95a2caaa40c9b981.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-14 12:17:08', NULL, '2020-10-24 16:44:09', 0.11, 0.01, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1598445933547342', 34, '1598445922002', '商户支付测试(XXL)', 'XXL', 99, -1, 1000.01, 54.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-41c216ad6a534e4f95a2caaa40c9b981.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-14 12:17:08', NULL, '2020-10-24 16:44:09', 0.11, 0.01, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1598962953451350', 35, '1598962937000', '平台秒杀商品((红色))', '红色', 99, -1, 1010.00, 3.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200901-236dc7279f154fb6b8334238d77490d1.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-16 17:28:02', NULL, '2020-10-24 16:44:09', 0.99, 0.92, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598962953451351', 35, '1598962937001', '平台秒杀商品((蓝色))', '蓝色', 97, -1, 1020.00, 3.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200901-236dc7279f154fb6b8334238d77490d1.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-16 17:28:02', NULL, '2020-10-24 16:44:09', 0.99, 0.92, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1598962953451352', 35, '1598962937002', '平台秒杀商品((白色))', '白色', 100, -1, 1030.00, 3.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200901-236dc7279f154fb6b8334238d77490d1.', '3', NULL, '0', NULL, NULL, NULL, NULL, '2020-09-16 17:28:02', NULL, '2020-10-24 16:44:09', 0.99, 0.92, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600064586682360', 36, '1600064521000', 'TOV男装((L-红色))', '(L-红色)', 100, -1, 1000.01, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600064586682361', 36, '1600064521002', 'TOV男装((L-白色))', '(L-白色)', 100, -1, 1000.01, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600064586682362', 36, '1600064521003', 'TOV男装((M-红色))', '(M-红色)', 100, -1, 1000.01, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600064586682363', 36, '1600064521005', 'TOV男装((M-白色))', '(M-白色)', 100, -1, 1000.01, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600064586682364', 36, '1600064521006', 'TOV男装((XXL-红色))', '(XXL-红色)', 100, -1, 1000.01, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600064586682365', 36, '1600064521008', 'TOV男装((XXL-白色))', '(XXL-白色)', 100, -1, 1000.01, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600066010217370', 37, '1600066000000', 'TOV裤(红色)', '红色', 96, -1, 1000.01, 1.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-45d93d56b5cc4a7fb861ea7fe37fbc82.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600085043405380', 38, '1600085038000', 'ces (红色)', '红色', 54, -1, 1043.00, 32.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-d6648c6a55a04bd2b18d6015ded69bc4.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-14 20:04:03', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600085043405381', 38, '1600085038001', 'ces (蓝色)', '蓝色', 54, -1, 1043.00, 32.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-d6648c6a55a04bd2b18d6015ded69bc4.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-14 20:04:03', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600085043405382', 38, '1600085038002', 'ces (白色)', '白色', 54, -1, 1043.00, 32.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-d6648c6a55a04bd2b18d6015ded69bc4.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-14 20:04:03', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600152633570390', 39, '1600152304000', '休闲西装中年男士纯麻西服外套男单西秋装((L-红色))', '(L-红色)', 100, -1, 2159.00, 1350.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-09-15 15:00:10', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600152633570391', 39, '1600152304001', '休闲西装中年男士纯麻西服外套男单西秋装((L-蓝色))', '(L-蓝色)', 100, -1, 2159.00, 1350.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-09-15 15:00:10', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600152633570392', 39, '1600152304002', '休闲西装中年男士纯麻西服外套男单西秋装((M-红色))', '(M-红色)', 100, -1, 2159.00, 1350.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-09-15 15:00:10', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600152633570393', 39, '1600152304003', '休闲西装中年男士纯麻西服外套男单西秋装((M-蓝色))', '(M-蓝色)', 100, -1, 2159.00, 1350.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-09-15 15:00:10', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600152633570394', 39, '1600152304004', '休闲西装中年男士纯麻西服外套男单西秋装((XXL-红色))', '(XXL-红色)', 100, -1, 2159.00, 1350.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-09-15 15:00:10', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600152633570395', 39, '1600152304005', '休闲西装中年男士纯麻西服外套男单西秋装((XXL-蓝色))', '(XXL-蓝色)', 100, -1, 2159.00, 1350.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', '3', NULL, '0', NULL, NULL, NULL, NULL, NULL, NULL, '2020-09-15 15:00:10', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600166517987400', 40, '1600166507000', '商户测试商品(红色)', '红色', 99, -1, 1000.01, 3.00, 17, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-bac133bb9512462ab860f10693688143.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-15 18:41:58', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600166517987401', 40, '1600166507001', '商户测试商品(蓝色)', '蓝色', 100, -1, 1000.01, 3.00, 17, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-bac133bb9512462ab860f10693688143.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-15 18:41:58', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600166517987402', 40, '1600166507002', '商户测试商品(白色)', '白色', 100, -1, 1000.01, 3.00, 17, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-bac133bb9512462ab860f10693688143.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-15 18:41:58', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600416529773360', 36, '1600416500000', '122(S)', 'S', 10, -1, 1010.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:08:50', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600416529773361', 36, '1600416500001', '122(红色)', '红色', 10, -1, 1010.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:08:50', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600416529773362', 36, '1600416500002', '122(蓝色)', '蓝色', 10, -1, 1010.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:08:50', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600416529773363', 36, '1600416500003', '122(白色)', '白色', 10, -1, 1010.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-18 16:08:50', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600520321195370', 37, '1600520245000', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(S-4GB+128GB)', 'S-4GB+128GB', 96, -1, 1599.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520321195371', 37, '1600520245001', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(S-8GB+256GB)', 'S-8GB+256GB', 100, -1, 1599.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('16005203211953710', 37, '1600520245010', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(白色-8GB+256GB)', '白色-8GB+256GB', 100, -1, 1899.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('16005203211953711', 37, '1600520245011', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(白色-16GB+512GB)', '白色-16GB+512GB', 100, -1, 1899.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520321195372', 37, '1600520245002', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(S-16GB+512GB)', 'S-16GB+512GB', 100, -1, 1599.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520321195373', 37, '1600520245003', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(红色-4GB+128GB)', '红色-4GB+128GB', 100, -1, 1599.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520321195374', 37, '1600520245004', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(红色-8GB+256GB)', '红色-8GB+256GB', 100, -1, 1599.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520321195375', 37, '1600520245005', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(红色-16GB+512GB)', '红色-16GB+512GB', 100, -1, 1599.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520321195376', 37, '1600520245006', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(蓝色-4GB+128GB)', '蓝色-4GB+128GB', 100, -1, 1799.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520321195377', 37, '1600520245007', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(蓝色-8GB+256GB)', '蓝色-8GB+256GB', 100, -1, 1799.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520321195378', 37, '1600520245008', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(蓝色-16GB+512GB)', '蓝色-16GB+512GB', 100, -1, 1799.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520321195379', 37, '1600520245009', '小米10至尊纪念版5g手机120X变焦骁龙865小米官方旗舰店小米手机小米105g官网小米手机(白色-4GB+128GB)', '白色-4GB+128GB', 100, -1, 1899.00, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 20:58:41', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520416975380', 38, '1600520381000', '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念(红色-4GB+128GB)', '红色-4GB+128GB', 100, -1, 2599.00, 22.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520416975381', 38, '1600520381001', '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念(红色-8GB+256GB)', '红色-8GB+256GB', 100, -1, 2599.00, 22.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520416975382', 38, '1600520381002', '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念(红色-16GB+512GB)', '红色-16GB+512GB', 100, -1, 2599.00, 22.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520416975383', 38, '1600520381003', '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念(蓝色-4GB+128GB)', '蓝色-4GB+128GB', 100, -1, 2599.00, 22.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520416975384', 38, '1600520381004', '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念(蓝色-8GB+256GB)', '蓝色-8GB+256GB', 100, -1, 2599.00, 22.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520416975385', 38, '1600520381005', '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念(蓝色-16GB+512GB)', '蓝色-16GB+512GB', 100, -1, 2599.00, 22.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520416975386', 38, '1600520381006', '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念(白色-4GB+128GB)', '白色-4GB+128GB', 100, -1, 2599.00, 22.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520416975387', 38, '1600520381007', '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念(白色-8GB+256GB)', '白色-8GB+256GB', 100, -1, 2599.00, 22.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520416975388', 38, '1600520381008', '红米k30 5g双模手机pro索尼6400万拍照学生游戏全面屏老年人智能机小米官方旗舰店10至尊纪念(白色-16GB+512GB)', '白色-16GB+512GB', 100, -1, 2599.00, 22.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:00:17', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520508108390', 39, '1600520472000', '红米note8pro 6400万正品手机10全面屏千元拍照智能机学生老人小米官方旗舰店官网xiaomi(4GB+128GB)', '4GB+128GB', 100, -1, 2299.00, 12.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-bd724755fdf44ab3bc7f23ba968ddef3.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:01:48', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520508108391', 39, '1600520472001', '红米note8pro 6400万正品手机10全面屏千元拍照智能机学生老人小米官方旗舰店官网xiaomi(8GB+256GB)', '8GB+256GB', 98, -1, 2399.00, 12.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-bd724755fdf44ab3bc7f23ba968ddef3.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:01:48', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520508108392', 39, '1600520472002', '红米note8pro 6400万正品手机10全面屏千元拍照智能机学生老人小米官方旗舰店官网xiaomi(16GB+512GB)', '16GB+512GB', 100, -1, 2499.00, 12.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-bd724755fdf44ab3bc7f23ba968ddef3.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:01:48', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520579652400', 40, '1600520560000', '小米105g手机骁龙8651亿像素8K相机智能游戏小米官方旗舰店小米手机官网至尊(4GB+128GB)', '4GB+128GB', 99, -1, 4999.00, 13.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ed98d27f13be42f2b8d4950945ffaea2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:03:00', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520579652401', 40, '1600520560001', '小米105g手机骁龙8651亿像素8K相机智能游戏小米官方旗舰店小米手机官网至尊(8GB+256GB)', '8GB+256GB', 100, -1, 5100.00, 13.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ed98d27f13be42f2b8d4950945ffaea2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:03:00', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520579652402', 40, '1600520560002', '小米105g手机骁龙8651亿像素8K相机智能游戏小米官方旗舰店小米手机官网至尊(16GB+512GB)', '16GB+512GB', 100, -1, 5500.00, 13.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ed98d27f13be42f2b8d4950945ffaea2.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:03:00', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520637271410', 41, '1600520625000', '红米K30i 双模5G4800万旗舰拍照学生老年新品智能机30pro手机小米官方旗舰店10至尊(4GB+128GB)', '4GB+128GB', 94, -1, 2489.00, 13.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-32790a8d138b4059b9d5fed76571707d.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:03:57', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520637271411', 41, '1600520625001', '红米K30i 双模5G4800万旗舰拍照学生老年新品智能机30pro手机小米官方旗舰店10至尊(8GB+256GB)', '8GB+256GB', 100, -1, 2589.00, 13.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-32790a8d138b4059b9d5fed76571707d.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:03:57', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520637271412', 41, '1600520625002', '红米K30i 双模5G4800万旗舰拍照学生老年新品智能机30pro手机小米官方旗舰店10至尊(16GB+512GB)', '16GB+512GB', 100, -1, 2689.00, 13.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-32790a8d138b4059b9d5fed76571707d.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:03:57', NULL, NULL, '2020-10-26 10:12:02', 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520752205420', 42, '1600520734000', '红米note8 4800万四摄拍照游戏学生智能手机redmi全面屏pro小米官方旗舰店10正品xiaomi(4GB+128GB)', '4GB+128GB', 93, -1, 1000.01, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-928522e0946d45c38a6afe1fab078377.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:05:52', '2020-11-05 14:45:55', NULL, '2020-10-26 10:12:02', 0.10, 0.05, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520752205421', 42, '1600520734001', '红米note8 4800万四摄拍照游戏学生智能手机redmi全面屏pro小米官方旗舰店10正品xiaomi(8GB+256GB)', '8GB+256GB', 98, -1, 1000.02, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-928522e0946d45c38a6afe1fab078377.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:05:52', '2020-11-05 14:45:55', NULL, '2020-10-26 10:12:02', 0.10, 0.05, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600520752205422', 42, '1600520734002', '红米note8 4800万四摄拍照游戏学生智能手机redmi全面屏pro小米官方旗舰店10正品xiaomi(16GB+512GB)', '16GB+512GB', 100, -1, 1000.03, 11.00, 25, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-928522e0946d45c38a6afe1fab078377.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-19 21:05:52', '2020-11-05 14:45:55', NULL, '2020-10-26 10:12:02', 0.10, 0.05, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1600590159237430', 43, '1600590129000', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((红色-SSSS)))', '红色-SSSS', 100, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590159237431', 43, '1600590129001', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((红色-L)))', '红色-L', 100, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('16005901592374310', 43, '1600590129010', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((白色-M)))', '白色-M', 100, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('16005901592374311', 43, '1600590129011', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((白色-XXL)))', '白色-XXL', 100, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590159237432', 43, '1600590129002', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((红色-M)))', '红色-M', 100, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590159237433', 43, '1600590129003', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((红色-XXL)))', '红色-XXL', 100, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590159237434', 43, '1600590129004', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((蓝色-SSSS)))', '蓝色-SSSS', 99, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590159237435', 43, '1600590129005', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((蓝色-L)))', '蓝色-L', 99, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590159237436', 43, '1600590129006', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((蓝色-M)))', '蓝色-M', 100, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590159237437', 43, '1600590129007', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((蓝色-XXL)))', '蓝色-XXL', 100, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590159237438', 43, '1600590129008', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((白色-SSSS)))', '白色-SSSS', 99, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590159237439', 43, '1600590129009', '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯(((白色-L)))', '白色-L', 100, -1, 1059.00, 11.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 17:56:41', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1600590248265440', 44, '1600590207000', '浴巾女可穿可裹巾吊带可爱比纯棉吸水速干不掉毛浴裙三件套ins 风(红色)', '红色', 98, -1, 1056.00, 13.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-faffce094c1f4961926a1344f5b17691.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:24:08', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590248265441', 44, '1600590207001', '浴巾女可穿可裹巾吊带可爱比纯棉吸水速干不掉毛浴裙三件套ins 风(蓝色)', '蓝色', 100, -1, 1066.00, 13.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-faffce094c1f4961926a1344f5b17691.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:24:08', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590248265442', 44, '1600590207002', '浴巾女可穿可裹巾吊带可爱比纯棉吸水速干不掉毛浴裙三件套ins 风(白色)', '白色', 100, -1, 1076.00, 13.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-faffce094c1f4961926a1344f5b17691.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:24:08', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590342274450', 45, '1600590320000', '珊瑚绒毯子加厚冬季学生宿舍铺床毛毯单人午睡夏空调毯法兰绒床单(SSSS)', 'SSSS', 98, -1, 1088.00, 22.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:25:42', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590342274451', 45, '1600590320001', '珊瑚绒毯子加厚冬季学生宿舍铺床毛毯单人午睡夏空调毯法兰绒床单(L)', 'L', 100, -1, 1089.00, 22.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:25:42', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590342274452', 45, '1600590320002', '珊瑚绒毯子加厚冬季学生宿舍铺床毛毯单人午睡夏空调毯法兰绒床单(M)', 'M', 100, -1, 1091.00, 22.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:25:42', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590342274453', 45, '1600590320003', '珊瑚绒毯子加厚冬季学生宿舍铺床毛毯单人午睡夏空调毯法兰绒床单(XXL)', 'XXL', 100, -1, 1084.00, 22.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:25:42', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193460', 46, '1600590406000', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(红色-SSSS)', '红色-SSSS', 99, -1, 1155.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193461', 46, '1600590406001', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(红色-L)', '红色-L', 100, -1, 1165.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('16005904501934610', 46, '1600590406010', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(白色-M)', '白色-M', 100, -1, 1155.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('16005904501934611', 46, '1600590406011', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(白色-XXL)', '白色-XXL', 100, -1, 1155.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193462', 46, '1600590406002', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(红色-M)', '红色-M', 100, -1, 1175.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193463', 46, '1600590406003', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(红色-XXL)', '红色-XXL', 100, -1, 1185.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193464', 46, '1600590406004', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(蓝色-SSSS)', '蓝色-SSSS', 100, -1, 1151.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193465', 46, '1600590406005', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(蓝色-L)', '蓝色-L', 100, -1, 1152.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193466', 46, '1600590406006', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(蓝色-M)', '蓝色-M', 100, -1, 1153.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193467', 46, '1600590406007', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(蓝色-XXL)', '蓝色-XXL', 100, -1, 1155.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193468', 46, '1600590406008', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(白色-SSSS)', '白色-SSSS', 100, -1, 1154.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600590450193469', 46, '1600590406009', '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕(白色-L)', '白色-L', 100, -1, 1155.00, 14.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 16:27:30', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '0', '0', 9);
INSERT INTO `pms_sku` VALUES ('1600611848935470', 47, '1600611765000', 'iphone(S)', 'S', 49, -1, 5000.00, 400.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 22:24:09', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '1', '0', 0);
INSERT INTO `pms_sku` VALUES ('1600611848935471', 47, '1600611765001', 'iphone(红色)', '红色', 50, -1, 5000.00, 400.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 22:24:09', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '1', '0', 0);
INSERT INTO `pms_sku` VALUES ('1600611848935472', 47, '1600611765002', 'iphone(蓝色)', '蓝色', 50, -1, 5000.00, 400.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 22:24:09', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '1', '0', 0);
INSERT INTO `pms_sku` VALUES ('1600611848935473', 47, '1600611765003', 'iphone(白色)', '白色', 39, -1, 5000.00, 400.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-20 22:24:09', NULL, NULL, '2020-10-24 16:44:09', 0.00, 0.00, '1', '0', 0);
INSERT INTO `pms_sku` VALUES ('1600649194611480', 48, '1600649171000', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((红色-SSSS))', '红色-SSSS', 92, -1, 1419.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1600649194611481', 48, '1600649171001', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((红色-L))', '红色-L', 100, -1, 1429.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('16006491946114810', 48, '1600649171010', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((白色-M))', '白色-M', 100, -1, 1419.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('16006491946114811', 48, '1600649171011', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((白色-XXL))', '白色-XXL', 100, -1, 1419.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1600649194611482', 48, '1600649171002', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((红色-M))', '红色-M', 100, -1, 1439.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1600649194611483', 48, '1600649171003', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((红色-XXL))', '红色-XXL', 100, -1, 1449.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1600649194611484', 48, '1600649171004', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((蓝色-SSSS))', '蓝色-SSSS', 100, -1, 1459.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1600649194611485', 48, '1600649171005', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((蓝色-L))', '蓝色-L', 100, -1, 1419.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1600649194611486', 48, '1600649171006', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((蓝色-M))', '蓝色-M', 100, -1, 1419.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1600649194611487', 48, '1600649171007', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((蓝色-XXL))', '蓝色-XXL', 100, -1, 1419.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1600649194611488', 48, '1600649171008', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((白色-SSSS))', '白色-SSSS', 99, -1, 1419.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1600649194611489', 48, '1600649171009', '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码((白色-L))', '白色-L', 100, -1, 1419.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-25 12:35:51', '2020-09-27 16:17:21', NULL, '2020-10-14 18:24:33', 0.20, 0.10, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601343305032490', 49, '1601343284000', '12(红色-SSSS)', '红色-SSSS', 97, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601343305032491', 49, '1601343284001', '12(红色-L)', '红色-L', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('16013433050354910', 49, '1601343284010', '12(白色-SSSS)', '白色-SSSS', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('16013433050354911', 49, '1601343284011', '12(白色-L)', '白色-L', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('16013433050354912', 49, '1601343284012', '12(白色-M)', '白色-M', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('16013433050354913', 49, '1601343284013', '12(白色-XXL)', '白色-XXL', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('16013433050354914', 49, '1601343284014', '12(白色-版型)', '白色-版型', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601343305035492', 49, '1601343284002', '12(红色-M)', '红色-M', 99, -1, 1105.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601343305035493', 49, '1601343284003', '12(红色-XXL)', '红色-XXL', 100, -1, 2006.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601343305035494', 49, '1601343284004', '12(红色-版型)', '红色-版型', 100, -1, 2007.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601343305035495', 49, '1601343284005', '12(蓝色-SSSS)', '蓝色-SSSS', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601343305035496', 49, '1601343284006', '12(蓝色-L)', '蓝色-L', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601343305035497', 49, '1601343284007', '12(蓝色-M)', '蓝色-M', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601343305035498', 49, '1601343284008', '12(蓝色-XXL)', '蓝色-XXL', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601343305035499', 49, '1601343284009', '12(蓝色-版型)', '蓝色-版型', 100, -1, 1100.00, 10.00, 0, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 09:35:05', NULL, NULL, '2020-10-24 16:44:17', 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1601352260884500', 50, '1601352233000', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(SSSS-红色)', 'SSSS-红色', 94, -1, 1581.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601352260884501', 50, '1601352233001', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(SSSS-蓝色)', 'SSSS-蓝色', 99, -1, 1582.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('16013522608845010', 50, '1601352233010', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(XXL-蓝色)', 'XXL-蓝色', 100, -1, 1583.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('16013522608845011', 50, '1601352233011', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(XXL-白色)', 'XXL-白色', 100, -1, 1584.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601352260884502', 50, '1601352233002', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(SSSS-白色)', 'SSSS-白色', 100, -1, 1583.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601352260884503', 50, '1601352233003', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(L-红色)', 'L-红色', 100, -1, 1584.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601352260884504', 50, '1601352233004', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(L-蓝色)', 'L-蓝色', 100, -1, 1585.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601352260884505', 50, '1601352233005', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(L-白色)', 'L-白色', 100, -1, 1586.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601352260884506', 50, '1601352233006', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(M-红色)', 'M-红色', 100, -1, 1587.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601352260884507', 50, '1601352233007', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(M-蓝色)', 'M-蓝色', 100, -1, 1588.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601352260884508', 50, '1601352233008', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(M-白色)', 'M-白色', 100, -1, 1589.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1601352260884509', 50, '1601352233009', 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41(XXL-红色)', 'XXL-红色', 100, -1, 1582.00, 13.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', '3', NULL, '0', NULL, NULL, NULL, '2020-09-29 12:04:21', NULL, NULL, '2020-10-12 20:53:39', 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782056458510', 51, '1603782005000', '女士皮鞋(红色-XXL)', '红色-XXL', 97, -1, 1057.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:00:57', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782056458511', 51, '1603782006001', '女士皮鞋(红色-M)', '红色-M', 100, -1, 1056.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:00:57', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782056458512', 51, '1603782006002', '女士皮鞋(蓝色-XXL)', '蓝色-XXL', 100, -1, 1055.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:00:56', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782056458513', 51, '1603782006003', '女士皮鞋(蓝色-M)', '蓝色-M', 100, -1, 1054.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:00:57', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782056458514', 51, '1603782006004', '女士皮鞋(白色-XXL)', '白色-XXL', 100, -1, 1051.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:00:57', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782056458515', 51, '1603782006005', '女士皮鞋(白色-M)', '白色-M', 100, -1, 1054.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:00:56', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782056458516', 51, '1603782006006', '女士皮鞋(S-XXL)', 'S-XXL', 100, -1, 1058.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:00:56', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782056458517', 51, '1603782006007', '女士皮鞋(S-M)', 'S-M', 100, -1, 1057.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:00:56', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782988325520', 52, '1603782935000', '女孩一份(红色)', '红色', 99, -1, 1078.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:16:28', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782988325521', 52, '1603782935001', '女孩一份(蓝色)', '蓝色', 100, -1, 1078.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:16:28', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782988325522', 52, '1603782935002', '女孩一份(白色)', '白色', 100, -1, 1078.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:16:28', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603782988325523', 52, '1603782935003', '女孩一份(S)', 'S', 100, -1, 1078.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:16:28', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783193248530', 53, '1603783133000', '女士用品(L)', 'L', 98, -1, 1080.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:19:53', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783193248531', 53, '1603783133001', '女士用品(M)', 'M', 100, -1, 1080.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:19:53', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783193248532', 53, '1603783133002', '女士用品(XXL)', 'XXL', 100, -1, 1080.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:19:53', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783193248533', 53, '1603783133003', '女士用品(版型)', '版型', 100, -1, 1080.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:19:53', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783193248534', 53, '1603783133004', '女士用品(SSSS)', 'SSSS', 100, -1, 1080.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:19:53', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783339870540', 54, '1603783303000', '手机辛苦(4GB+128GB)', '4GB+128GB', 99, -1, 2000.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783298618.png', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:22:20', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783339870541', 54, '1603783303001', '手机辛苦(8GB+256GB)', '8GB+256GB', 100, -1, 2000.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783298618.png', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:22:20', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783339870542', 54, '1603783303002', '手机辛苦(16GB+512GB)', '16GB+512GB', 100, -1, 2000.00, 11.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783298618.png', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:22:20', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783654596550', 55, '1603783636000', '女士睡袋(青春版)', '青春版', 96, -1, 1049.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:27:35', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783654596551', 55, '1603783636001', '女士睡袋(荣耀版)', '荣耀版', 100, -1, 1049.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:27:35', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783654596552', 55, '1603783636002', '女士睡袋(畅享旗舰版)', '畅享旗舰版', 100, -1, 1049.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:27:35', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603783654596553', 55, '1603783636003', '女士睡袋(耀世巅峰版)', '耀世巅峰版', 100, -1, 1049.00, 10.00, 30, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-27 15:27:35', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 14);
INSERT INTO `pms_sku` VALUES ('1603879705753560', 56, '1603879475000', '精选三红蜜柚(白心柚)', '白心柚', 10, -1, 1030.00, 5.00, 46, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879591271.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-28 18:08:26', '2020-10-29 10:09:56', NULL, NULL, 0.10, 0.05, '0', '0', 17);
INSERT INTO `pms_sku` VALUES ('1603879705753561', 56, '1603879475001', '精选三红蜜柚(红心柚)', '红心柚', 9, -1, 1050.00, 5.00, 46, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879577526.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-28 18:08:26', '2020-10-29 10:09:56', NULL, NULL, 0.10, 0.05, '0', '0', 17);
INSERT INTO `pms_sku` VALUES ('1603879892736570', 57, '1603879836000', '红心柚子新鲜水果送礼(红心柚)', '红心柚', 0, -1, 1060.00, 10.00, 46, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879829454.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-28 18:11:33', '2020-10-29 10:09:43', NULL, NULL, 0.10, 0.10, '0', '0', 17);
INSERT INTO `pms_sku` VALUES ('1603879892736571', 57, '1603879836001', '红心柚子新鲜水果送礼(白心柚)', '白心柚', 4, -1, 1060.00, 10.00, 46, '1', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879829454.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-10-28 18:11:33', '2020-10-29 10:09:43', NULL, NULL, 0.10, 0.10, '0', '0', 17);
INSERT INTO `pms_sku` VALUES ('1604457115654580', 58, '1604457078000', '爱衣买衣2020秋季新款女装打底衫女长袖内搭高领网纱亮丝针织上衣(红色)', '红色', 99, -1, 1060.00, 1.00, 0, '1', '1604456997123.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-11-04 10:31:56', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1604457115654581', 58, '1604457078001', '爱衣买衣2020秋季新款女装打底衫女长袖内搭高领网纱亮丝针织上衣(S)', 'S', 99, -1, 1060.00, 1.00, 0, '1', '1604456997123.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-11-04 10:31:56', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1604457115654582', 58, '1604457078002', '爱衣买衣2020秋季新款女装打底衫女长袖内搭高领网纱亮丝针织上衣(蓝色)', '蓝色', 99, -1, 1060.00, 1.00, 0, '1', '1604456997123.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-11-04 10:31:56', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1604457115654583', 58, '1604457078003', '爱衣买衣2020秋季新款女装打底衫女长袖内搭高领网纱亮丝针织上衣(黑色)', '黑色', 99, -1, 1060.00, 1.00, 0, '1', '1604456997123.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-11-04 10:31:56', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1604457115654584', 58, '1604457078004', '爱衣买衣2020秋季新款女装打底衫女长袖内搭高领网纱亮丝针织上衣(白色)', '白色', 99, -1, 1060.00, 1.00, 0, '1', '1604456997123.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-11-04 10:31:56', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1604626581053590', 59, '1604626492000', '睡衣睡衣((L))', 'L', 500, -1, 1038.00, 100.00, 25, '1', '1604626654468.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-11-06 09:37:43', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1604626581053591', 59, '1604626492001', '睡衣睡衣((M))', 'M', 500, -1, 1038.00, 100.00, 25, '1', '1604626654468.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-11-06 09:37:43', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1604737539693600', 60, '1604737508000', '黄斑一泡净((黑色))', '黑色', 16, -1, 1110.00, 5000.00, 0, '1', '1604737462264.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 20:48:46', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1604737539693601', 60, '1604737508001', '黄斑一泡净((蓝色))', '蓝色', 30, -1, 1110.00, 20000.00, 0, '1', '1604737462264.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 20:48:46', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1604738056157610', 61, '1604738026000', '水洗柔顺固色剂(蓝色)', '蓝色', 20, -1, 1160.00, 100.00, 0, '1', '1604738015905.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 16:34:16', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1604738056157611', 61, '1604738026001', '水洗柔顺固色剂(黑色)', '黑色', 30, -1, 1160.00, 120.00, 0, '1', '1604738015905.jpg', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 16:34:16', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1604763000250620', 62, '1604762965000', '水洗柔顺固色剂(红色-L)', '红色-L', 14, -1, 1160.00, 12.00, 25, '1', '1604762960926.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 23:30:00', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1604763000250621', 62, '1604762965001', '水洗柔顺固色剂(红色-M)', '红色-M', 15, -1, 1160.00, 23.00, 25, '1', '1604762960926.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 23:30:00', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1604763000250622', 62, '1604762965002', '水洗柔顺固色剂(蓝色-L)', '蓝色-L', 16, -1, 1160.00, 12.00, 25, '1', '1604762960926.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 23:30:00', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1604763000250623', 62, '1604762965003', '水洗柔顺固色剂(蓝色-M)', '蓝色-M', 17, -1, 1160.00, 12.00, 25, '1', '1604762960926.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 23:30:00', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1604763051021630', 63, '1604762965000', '水洗柔顺固色剂(红色-L)', '红色-L', 14, -1, 1160.00, 12.00, 25, '2', '1604762960926.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 23:30:51', '2020-11-17 08:34:20', NULL, NULL, 0.05, 0.02, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1604763051021631', 63, '1604762965001', '水洗柔顺固色剂(红色-M)', '红色-M', 15, -1, 1160.00, 23.00, 25, '2', '1604762960926.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 23:30:51', '2020-11-17 08:34:20', NULL, NULL, 0.05, 0.02, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1604763051021632', 63, '1604762965002', '水洗柔顺固色剂(蓝色-L)', '蓝色-L', 16, -1, 1160.00, 12.00, 25, '2', '1604762960926.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 23:30:51', '2020-11-17 08:34:20', NULL, NULL, 0.05, 0.02, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1604763051021633', 63, '1604762965003', '水洗柔顺固色剂(蓝色-M)', '蓝色-M', 17, -1, 1160.00, 12.00, 25, '2', '1604762960926.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-07 23:30:51', '2020-11-17 08:34:20', NULL, NULL, 0.05, 0.02, '0', '0', 10);
INSERT INTO `pms_sku` VALUES ('1605356770768243', 24, '1605356787000', '平台试用商品((SSSS))', 'SSSS', 800, -1, 1001.00, 8.00, 0, '0', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', '0', NULL, '0', NULL, NULL, NULL, '2020-11-18 13:28:05', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);
INSERT INTO `pms_sku` VALUES ('1605624533499640', 64, '1605624516000', '111111((红色))', '红色', 111, -1, 1111.00, 1.00, 0, '1', '1605624498815.png', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 22:51:43', NULL, NULL, '2020-11-17 22:54:03', 0.00, 0.00, '0', '0', 19);
INSERT INTO `pms_sku` VALUES ('1605624533499641', 64, '1605624516001', '111111((蓝色))', '蓝色', 11, -1, 1111.00, 1.00, 0, '1', '1605624498815.png', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 22:51:43', NULL, NULL, '2020-11-17 22:54:03', 0.00, 0.00, '0', '0', 19);
INSERT INTO `pms_sku` VALUES ('1605624533499642', 64, '1605624516002', '111111((白色))', '白色', 111, -1, 1111.00, 1.00, 0, '1', '1605624498815.png', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 22:51:43', NULL, NULL, '2020-11-17 22:54:03', 0.00, 0.00, '0', '0', 19);
INSERT INTO `pms_sku` VALUES ('1605624533499643', 64, '1605624516003', '111111((S))', 'S', 11, -1, 1111.00, 1.00, 0, '1', '1605624498815.png', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 22:51:43', NULL, NULL, '2020-11-17 22:54:03', 0.00, 0.00, '0', '0', 19);
INSERT INTO `pms_sku` VALUES ('1605624533499644', 64, '1605624516004', '111111((黑色))', '黑色', 1111, -1, 1111.00, 1.00, 0, '1', '1605624498815.png', '0', NULL, '0', NULL, NULL, NULL, '2020-11-17 22:51:43', NULL, NULL, '2020-11-17 22:54:03', 0.00, 0.00, '0', '0', 19);
INSERT INTO `pms_sku` VALUES ('1605677272023650', 65, '1605677230001', 'xx(红色)', '红色', 11, -1, 22.00, 11.00, 0, '1', '1605677196912.png', '3', NULL, '0', NULL, NULL, NULL, '2020-11-18 13:27:52', NULL, NULL, NULL, 0.00, 0.00, '0', '0', 7);

-- ----------------------------
-- Table structure for pms_sku_batch
-- ----------------------------
DROP TABLE IF EXISTS `pms_sku_batch`;
CREATE TABLE `pms_sku_batch`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `spu_id` bigint(20) DEFAULT NULL COMMENT '商品id',
  `sku_id` bigint(20) DEFAULT NULL COMMENT '单品id',
  `batch_num` int(11) DEFAULT NULL COMMENT '起批量（前闭后开）',
  `batch_price` decimal(20, 2) DEFAULT NULL COMMENT '起批价格',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除标记 0未删除 1删除 默认0',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sku_id`(`sku_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '单品起批价格标' ROW_FORMAT = Compact;

-- ----------------------------
-- Table structure for pms_sku_image
-- ----------------------------
DROP TABLE IF EXISTS `pms_sku_image`;
CREATE TABLE `pms_sku_image`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `spu_id` bigint(20) NOT NULL COMMENT '商品id',
  `sku_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品id  对应pms_sku表中的id',
  `url` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '图片地址',
  `default_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '默认图片标记  0 不是默认 1默认    默认为0',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记  0未删除 1删除 默认0',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sku_id`(`sku_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 564 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '单品和图片的关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_sku_image
-- ----------------------------
INSERT INTO `pms_sku_image` VALUES (97, 26, '1598230936517262', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-cce03f90b1094dd682f656c33224b33c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (98, 26, '1598230936517260', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-cce03f90b1094dd682f656c33224b33c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (99, 26, '1598230936517261', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-cce03f90b1094dd682f656c33224b33c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (103, 28, '1598231272851280', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-0a3589732c5748e5972f7dcb420cf7d1.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (104, 28, '1598231272851281', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-0a3589732c5748e5972f7dcb420cf7d1.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (105, 28, '1598231272851282', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-0a3589732c5748e5972f7dcb420cf7d1.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (106, 29, '1598251119774292', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-98bf4f772a634526ab25d36c925c66a2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (107, 29, '1598251119774291', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-98bf4f772a634526ab25d36c925c66a2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (108, 29, '1598251119774290', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-98bf4f772a634526ab25d36c925c66a2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (109, 30, '1598257978841301', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-44a7b17e7cb74276b0d9fc1c8c9fb4e9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (110, 30, '1598257978841300', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-44a7b17e7cb74276b0d9fc1c8c9fb4e9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (111, 30, '1598257978841302', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-44a7b17e7cb74276b0d9fc1c8c9fb4e9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (118, 33, '1598445895165332', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-91038407ea2b4826a63d629b701e1717.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (119, 33, '1598445895165331', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-91038407ea2b4826a63d629b701e1717.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (120, 33, '1598445895165330', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-91038407ea2b4826a63d629b701e1717.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (121, 34, '1598445933547340', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-41c216ad6a534e4f95a2caaa40c9b981.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (122, 34, '1598445933547342', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-41c216ad6a534e4f95a2caaa40c9b981.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (123, 34, '1598445933547341', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-41c216ad6a534e4f95a2caaa40c9b981.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (133, 32, '1598442734166320', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-611d545be3c64a8f81258c2a588e900d.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (134, 32, '1598442734166321', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-611d545be3c64a8f81258c2a588e900d.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (135, 32, '1598442734166322', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200826-611d545be3c64a8f81258c2a588e900d.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (139, 35, '1598962953451350', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200901-236dc7279f154fb6b8334238d77490d1.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (140, 35, '1598962953451351', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200901-236dc7279f154fb6b8334238d77490d1.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (141, 35, '1598962953451352', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200901-236dc7279f154fb6b8334238d77490d1.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (142, 31, '1598270266233310', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-c0186338aaf34b0eb58b526ad4814b1c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (143, 31, '1598270266233311', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-c0186338aaf34b0eb58b526ad4814b1c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (144, 31, '1598270266233312', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-c0186338aaf34b0eb58b526ad4814b1c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (148, 25, '1598079663976250', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-733e78fcd86f498cb4393a5b4a5e7fb0.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (149, 25, '1598079663976251', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-733e78fcd86f498cb4393a5b4a5e7fb0.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (150, 25, '1598079663976252', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-733e78fcd86f498cb4393a5b4a5e7fb0.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (157, 36, '1600064586682360', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (158, 36, '1600064586682361', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (159, 36, '1600064586682362', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (160, 36, '1600064586682363', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (161, 36, '1600064586682364', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (162, 36, '1600064586682365', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-b365b0e62d104a5fbbf9e48fb170a49e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (163, 37, '1600066010217370', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-45d93d56b5cc4a7fb861ea7fe37fbc82.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (164, 27, '1598231219999270', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-47b109458e264c3195c8204ce9b0c5cc.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (165, 27, '1598231219999271', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-47b109458e264c3195c8204ce9b0c5cc.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (166, 27, '1598231219999272', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200824-47b109458e264c3195c8204ce9b0c5cc.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (167, 38, '1600085043405382', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-d6648c6a55a04bd2b18d6015ded69bc4.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (168, 38, '1600085043405381', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-d6648c6a55a04bd2b18d6015ded69bc4.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (169, 38, '1600085043405380', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-d6648c6a55a04bd2b18d6015ded69bc4.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (200, 39, '1600152633570390', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (201, 39, '1600152633570390', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-5fbf2f8505ab45ea818ca99bb857f777.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (202, 39, '1600152633570390', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7de9bf1dd8bb40fdbc6f76cfbc03b022.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (203, 39, '1600152633570390', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7b1b7357bfd44f09852374f0286ed6a5.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (204, 39, '1600152633570390', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-75e864d358614a14aec8c789316e06c9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (205, 39, '1600152633570391', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (206, 39, '1600152633570391', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-5fbf2f8505ab45ea818ca99bb857f777.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (207, 39, '1600152633570391', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7de9bf1dd8bb40fdbc6f76cfbc03b022.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (208, 39, '1600152633570391', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7b1b7357bfd44f09852374f0286ed6a5.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (209, 39, '1600152633570391', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-75e864d358614a14aec8c789316e06c9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (210, 39, '1600152633570392', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (211, 39, '1600152633570392', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-5fbf2f8505ab45ea818ca99bb857f777.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (212, 39, '1600152633570392', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7de9bf1dd8bb40fdbc6f76cfbc03b022.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (213, 39, '1600152633570392', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7b1b7357bfd44f09852374f0286ed6a5.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (214, 39, '1600152633570392', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-75e864d358614a14aec8c789316e06c9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (215, 39, '1600152633570393', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (216, 39, '1600152633570393', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-5fbf2f8505ab45ea818ca99bb857f777.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (217, 39, '1600152633570393', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7de9bf1dd8bb40fdbc6f76cfbc03b022.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (218, 39, '1600152633570393', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7b1b7357bfd44f09852374f0286ed6a5.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (219, 39, '1600152633570393', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-75e864d358614a14aec8c789316e06c9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (220, 39, '1600152633570394', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (221, 39, '1600152633570394', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-5fbf2f8505ab45ea818ca99bb857f777.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (222, 39, '1600152633570394', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7de9bf1dd8bb40fdbc6f76cfbc03b022.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (223, 39, '1600152633570394', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7b1b7357bfd44f09852374f0286ed6a5.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (224, 39, '1600152633570394', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-75e864d358614a14aec8c789316e06c9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (225, 39, '1600152633570395', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-20c38e3aefe542d2a9bc2bd5c01fc85c.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (226, 39, '1600152633570395', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-5fbf2f8505ab45ea818ca99bb857f777.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (227, 39, '1600152633570395', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7de9bf1dd8bb40fdbc6f76cfbc03b022.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (228, 39, '1600152633570395', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-7b1b7357bfd44f09852374f0286ed6a5.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (229, 39, '1600152633570395', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-75e864d358614a14aec8c789316e06c9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (230, 40, '1600166517987401', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-bac133bb9512462ab860f10693688143.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (231, 40, '1600166517987402', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-bac133bb9512462ab860f10693688143.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (232, 40, '1600166517987400', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200915-bac133bb9512462ab860f10693688143.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (233, 41, '1600218309894410', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200916-b7c42f6dc8b344d8a656d83e8bb7d885.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (234, 41, '1600218309894410', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200916-81c5da56bcc14176bcc9f6e89224f20d.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (235, 41, '1600218309894411', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200916-b7c42f6dc8b344d8a656d83e8bb7d885.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (236, 41, '1600218309894411', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200916-81c5da56bcc14176bcc9f6e89224f20d.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (237, 41, '1600218309894412', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200916-b7c42f6dc8b344d8a656d83e8bb7d885.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (238, 41, '1600218309894412', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200916-81c5da56bcc14176bcc9f6e89224f20d.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (248, 36, '1600416529773362', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (249, 36, '1600416529773361', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (250, 36, '1600416529773360', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (251, 36, '1600416529773363', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200918-20fa39fa079b4d9b8d98b3cdae3666cf.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (252, 22, '1598079455498220', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (253, 22, '1598079455498221', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (254, 22, '1598079455498222', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (255, 22, '1598079455498223', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (256, 22, '1598079455498224', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (257, 22, '1598079455498225', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (258, 22, '1598079455498226', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (259, 22, '1598079455498227', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (260, 22, '1598079455498228', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-32685ab8abcd42b6928a2baf68b882f2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (261, 37, '16005203211953710', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (262, 37, '16005203211953710', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (263, 37, '1600520321195377', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (264, 37, '1600520321195377', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (265, 37, '1600520321195373', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (266, 37, '1600520321195373', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (267, 37, '1600520321195376', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (268, 37, '1600520321195376', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (269, 37, '1600520321195375', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (270, 37, '1600520321195375', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (271, 37, '16005203211953711', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (272, 37, '16005203211953711', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (273, 37, '1600520321195378', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (274, 37, '1600520321195378', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (275, 37, '1600520321195371', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (276, 37, '1600520321195371', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (277, 37, '1600520321195374', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (278, 37, '1600520321195374', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (279, 37, '1600520321195379', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (280, 37, '1600520321195379', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (281, 37, '1600520321195370', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (282, 37, '1600520321195370', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (283, 37, '1600520321195372', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-eac7299560ac48d58a1b98dd04cf8843.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (284, 37, '1600520321195372', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-1b0450e0e7b74e94bd357083640c62c2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (285, 38, '1600520416975385', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (286, 38, '1600520416975382', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (287, 38, '1600520416975386', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (288, 38, '1600520416975387', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (289, 38, '1600520416975383', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (290, 38, '1600520416975388', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (291, 38, '1600520416975381', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (292, 38, '1600520416975384', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (293, 38, '1600520416975380', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-780d209f6d11486f843c372a958f1aaa.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (294, 39, '1600520508108391', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-bd724755fdf44ab3bc7f23ba968ddef3.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (295, 39, '1600520508108390', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-bd724755fdf44ab3bc7f23ba968ddef3.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (296, 39, '1600520508108392', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-bd724755fdf44ab3bc7f23ba968ddef3.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (297, 40, '1600520579652400', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ed98d27f13be42f2b8d4950945ffaea2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (298, 40, '1600520579652401', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ed98d27f13be42f2b8d4950945ffaea2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (299, 40, '1600520579652402', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ed98d27f13be42f2b8d4950945ffaea2.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (300, 41, '1600520637271410', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-32790a8d138b4059b9d5fed76571707d.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (301, 41, '1600520637271411', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-32790a8d138b4059b9d5fed76571707d.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (302, 41, '1600520637271412', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-32790a8d138b4059b9d5fed76571707d.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (303, 42, '1600520752205420', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-928522e0946d45c38a6afe1fab078377.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (304, 42, '1600520752205421', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-928522e0946d45c38a6afe1fab078377.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (305, 42, '1600520752205422', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-928522e0946d45c38a6afe1fab078377.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (330, 44, '1600590248265440', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-faffce094c1f4961926a1344f5b17691.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (331, 44, '1600590248265441', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-faffce094c1f4961926a1344f5b17691.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (332, 44, '1600590248265442', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-faffce094c1f4961926a1344f5b17691.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (333, 45, '1600590342274451', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (334, 45, '1600590342274452', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (335, 45, '1600590342274453', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (336, 45, '1600590342274450', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (337, 46, '16005904501934610', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (338, 46, '1600590450193463', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (339, 46, '1600590450193461', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (340, 46, '1600590450193467', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (341, 46, '16005904501934611', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (342, 46, '1600590450193465', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (343, 46, '1600590450193462', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (344, 46, '1600590450193468', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (345, 46, '1600590450193469', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (346, 46, '1600590450193464', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (347, 46, '1600590450193460', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (348, 46, '1600590450193466', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (349, 47, '1600611848935471', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (350, 47, '1600611848935472', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (351, 47, '1600611848935473', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (352, 47, '1600611848935470', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-a29f68145b6144d3aa8cb3c0231c6ce9.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (365, 48, '1600649194611480', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (366, 48, '1600649194611481', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (367, 48, '16006491946114810', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (368, 48, '16006491946114811', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (369, 48, '1600649194611482', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (370, 48, '1600649194611483', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (371, 48, '1600649194611484', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (372, 48, '1600649194611485', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (373, 48, '1600649194611486', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (374, 48, '1600649194611487', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (375, 48, '1600649194611488', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (376, 48, '1600649194611489', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (377, 49, '1601343305035499', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (378, 49, '1601343305035494', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (379, 49, '1601343305035496', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (380, 49, '1601343305032491', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (381, 49, '1601343305035495', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (382, 49, '1601343305035493', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (383, 49, '1601343305035492', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (384, 49, '16013433050354910', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (385, 49, '1601343305032490', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (386, 49, '16013433050354913', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (387, 49, '1601343305035498', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (388, 49, '1601343305035497', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (389, 49, '16013433050354912', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (390, 49, '16013433050354914', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (391, 49, '16013433050354911', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-8f6e9ef6532c4b5092290f65a461c8ce.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (392, 50, '1601352260884503', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (393, 50, '1601352260884505', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (394, 50, '1601352260884501', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (395, 50, '1601352260884507', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (396, 50, '1601352260884504', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (397, 50, '1601352260884502', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (398, 50, '1601352260884500', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (399, 50, '1601352260884508', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (400, 50, '16013522608845010', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (401, 50, '1601352260884506', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (402, 50, '1601352260884509', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (403, 50, '16013522608845011', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (404, 51, '1603782056458517', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (405, 51, '1603782056458516', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (406, 51, '1603782056458512', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (407, 51, '1603782056458515', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (408, 51, '1603782056458514', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (409, 51, '1603782056458511', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (410, 51, '1603782056458513', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (411, 51, '1603782056458510', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603781767953.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (412, 52, '1603782988325521', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (413, 52, '1603782988325522', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (414, 52, '1603782988325520', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (415, 52, '1603782988325523', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603782936080.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (416, 53, '1603783193248532', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (417, 53, '1603783193248531', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (418, 53, '1603783193248530', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (419, 53, '1603783193248534', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (420, 53, '1603783193248533', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783129269.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (421, 54, '1603783339870541', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783298618.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (422, 54, '1603783339870542', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783298618.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (423, 54, '1603783339870540', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783298618.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (424, 55, '1603783654596550', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (425, 55, '1603783654596551', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (426, 55, '1603783654596553', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (427, 55, '1603783654596552', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603783634737.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (428, 56, '1603879705753560', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879591271.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (429, 56, '1603879705753560', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879592053.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (430, 56, '1603879705753561', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879577526.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (431, 56, '1603879705753561', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879580188.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (432, 57, '1603879892736571', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879829454.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (433, 57, '1603879892736571', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879857626.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (434, 57, '1603879892736570', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879829454.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (435, 57, '1603879892736570', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603879853255.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (448, 23, '1598079520317230', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-e3d6abfbbdb040fe9f745a48a1de0952.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (449, 23, '1598079520317230', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-12817197adc541bc88d2f2e584081dd5.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (450, 23, '1598079520317231', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-e3d6abfbbdb040fe9f745a48a1de0952.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (451, 23, '1598079520317231', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-12817197adc541bc88d2f2e584081dd5.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (452, 23, '1598079520317232', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-e3d6abfbbdb040fe9f745a48a1de0952.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (453, 23, '1598079520317232', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-12817197adc541bc88d2f2e584081dd5.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (454, 58, '1604457115654581', '1604456997123.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (455, 58, '1604457115654581', '1604457002280.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (456, 58, '1604457115654581', '1604457008825.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (457, 58, '1604457115654581', '1604457004213.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (458, 58, '1604457115654581', '1604457007723.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (459, 58, '1604457115654584', '1604456997123.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (460, 58, '1604457115654584', '1604457002280.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (461, 58, '1604457115654584', '1604457008825.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (462, 58, '1604457115654584', '1604457004213.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (463, 58, '1604457115654584', '1604457007723.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (464, 58, '1604457115654582', '1604456997123.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (465, 58, '1604457115654582', '1604457002280.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (466, 58, '1604457115654582', '1604457008825.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (467, 58, '1604457115654582', '1604457004213.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (468, 58, '1604457115654582', '1604457007723.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (469, 58, '1604457115654583', '1604456997123.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (470, 58, '1604457115654583', '1604457002280.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (471, 58, '1604457115654583', '1604457008825.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (472, 58, '1604457115654583', '1604457004213.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (473, 58, '1604457115654583', '1604457007723.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (474, 58, '1604457115654580', '1604456997123.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (475, 58, '1604457115654580', '1604457002280.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (476, 58, '1604457115654580', '1604457008825.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (477, 58, '1604457115654580', '1604457004213.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (478, 58, '1604457115654580', '1604457007723.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (481, 59, '1604626581053590', '1604626654468.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (482, 59, '1604626581053591', '1604626654468.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (485, 61, '1604738056157611', '1604738015905.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (486, 61, '1604738056157610', '1604738015905.jpg', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (487, 60, '1604737539693600', '1604737462264.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (488, 60, '1604737539693601', '1604737462264.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (489, 62, '1604763000250622', '1604762960926.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (490, 62, '1604763000250621', '1604762960926.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (491, 62, '1604763000250620', '1604762960926.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (492, 62, '1604763000250623', '1604762960926.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (493, 63, '1604763051021630', '1604762960926.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (494, 63, '1604763051021631', '1604762960926.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (495, 63, '1604763051021633', '1604762960926.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (496, 63, '1604763051021632', '1604762960926.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (525, 43, '1600590159237430', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (526, 43, '1600590159237430', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (527, 43, '1600590159237431', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (528, 43, '1600590159237431', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (529, 43, '16005901592374310', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (530, 43, '16005901592374310', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (531, 43, '16005901592374311', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (532, 43, '16005901592374311', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (533, 43, '1600590159237432', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (534, 43, '1600590159237432', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (535, 43, '1600590159237433', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (536, 43, '1600590159237433', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (537, 43, '1600590159237434', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (538, 43, '1600590159237434', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (539, 43, '1600590159237435', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (540, 43, '1600590159237435', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (541, 43, '1600590159237436', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (542, 43, '1600590159237436', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (543, 43, '1600590159237437', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (544, 43, '1600590159237437', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (545, 43, '1600590159237438', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (546, 43, '1600590159237438', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (547, 43, '1600590159237439', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (548, 43, '1600590159237439', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-0a1a9ca23352498a98e8a5335df51e3e.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (554, 64, '1605624533499640', '1605624498815.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (555, 64, '1605624533499641', '1605624498815.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (556, 64, '1605624533499642', '1605624498815.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (557, 64, '1605624533499643', '1605624498815.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (558, 64, '1605624533499644', '1605624498815.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (559, 65, '1605677272023650', '1605677196912.png', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (560, 24, '1598079584422240', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (561, 24, '1598079584422241', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (562, 24, '1598079584422242', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', NULL, '0');
INSERT INTO `pms_sku_image` VALUES (563, 24, '1605356770768243', 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200822-34f50ccb68b94b32af4ee63f283030a7.', NULL, '0');

-- ----------------------------
-- Table structure for pms_sku_marketing
-- ----------------------------
DROP TABLE IF EXISTS `pms_sku_marketing`;
CREATE TABLE `pms_sku_marketing`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `skuid` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品id',
  `marketing_id` bigint(20) NOT NULL COMMENT '营销id',
  `price` decimal(20, 2) DEFAULT NULL COMMENT '促销价格 （在众筹的时候使用，众筹价格）',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `skuid`(`skuid`) USING BTREE,
  INDEX `marketing_id`(`marketing_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 321 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '单品和营销的关联表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_sku_marketing
-- ----------------------------
INSERT INTO `pms_sku_marketing` VALUES (77, '1598079455498220', 28, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (78, '1598079455498221', 28, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (79, '1598230936517260', 28, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (80, '1598230936517261', 28, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (81, '1598230936517262', 28, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (82, '1598231272851280', 29, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (83, '1598231272851281', 29, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (84, '1598231272851282', 29, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (88, '1598251119774290', 30, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (89, '1598251119774291', 30, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (90, '1598251119774292', 30, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (91, '1598257978841300', 31, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (92, '1598257978841301', 31, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (93, '1598257978841302', 31, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (94, '1598270266233310', 32, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (95, '1598270266233311', 32, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (96, '1598270266233312', 32, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (109, '1598079520317230', 27, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (110, '1598079520317231', 27, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (111, '1598079520317232', 27, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (118, '1598445895165330', 33, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (119, '1598445895165331', 33, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (120, '1598445895165332', 33, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (121, '1598962953451350', 34, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (122, '1598962953451351', 34, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (123, '1598962953451352', 34, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (124, '1598079584422240', 35, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (125, '1598079584422241', 35, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (126, '1598079584422242', 36, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (127, '1598079455498220', 37, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (128, '1598079663976250', 37, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (129, '1601352260884500', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (130, '1601352260884501', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (131, '1601352260884502', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (132, '1601352260884503', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (133, '1601352260884504', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (134, '1601352260884505', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (135, '1601352260884506', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (136, '1601352260884507', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (137, '1601352260884508', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (138, '1601352260884509', 42, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (139, '1601352260884500', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (140, '1601352260884501', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (141, '1601352260884502', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (142, '1601352260884503', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (143, '1601352260884504', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (144, '1601352260884505', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (145, '1601352260884506', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (146, '1601352260884507', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (147, '1601352260884508', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (148, '1601352260884509', 43, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (149, '1601343305032490', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (150, '1601343305032491', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (151, '1601343305035492', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (152, '1601343305035493', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (153, '1601343305035494', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (154, '1601343305035495', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (155, '1601343305035496', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (156, '1601343305035497', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (157, '1601343305035498', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (158, '1601343305035499', 44, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (226, '1598231219999270', 49, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (227, '1598231219999271', 49, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (228, '1598231219999272', 49, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (230, '1598079663976250', 50, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (231, '1598442734166320', 51, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (232, '1598442734166321', 51, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (233, '1598442734166322', 51, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (234, '1600152633570390', 52, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (235, '1600152633570391', 52, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (236, '1600152633570392', 52, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (237, '1600152633570393', 52, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (238, '1600152633570394', 52, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (239, '1600152633570395', 52, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (240, '1598079455498220', 53, 10.00);
INSERT INTO `pms_sku_marketing` VALUES (241, '1598079455498221', 53, 10.00);
INSERT INTO `pms_sku_marketing` VALUES (242, '1598079455498222', 53, 10.00);
INSERT INTO `pms_sku_marketing` VALUES (243, '1598079455498223', 53, 10.00);
INSERT INTO `pms_sku_marketing` VALUES (244, '1598079455498224', 53, 10.00);
INSERT INTO `pms_sku_marketing` VALUES (245, '1598079455498225', 53, 10.00);
INSERT INTO `pms_sku_marketing` VALUES (246, '1598079455498226', 53, 10.00);
INSERT INTO `pms_sku_marketing` VALUES (247, '1598079455498227', 53, 10.00);
INSERT INTO `pms_sku_marketing` VALUES (248, '1598079455498228', 53, 10.00);
INSERT INTO `pms_sku_marketing` VALUES (259, '1601352260884500', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (260, '1601352260884501', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (261, '1601352260884502', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (262, '1601352260884503', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (263, '1601352260884504', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (264, '1601352260884505', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (265, '1601352260884506', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (266, '1601352260884507', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (267, '1601352260884508', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (268, '1601352260884509', 39, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (269, '16006491946114811', 54, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (270, '1601343305032490', 55, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (271, '1601343305032491', 55, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (276, '1600590159237439', 56, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (277, '1600590248265441', 56, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (278, '1598251119774290', 45, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (279, '1598251119774291', 45, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (280, '1598251119774292', 45, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (284, '1600590342274450', 47, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (285, '1600590342274451', 47, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (286, '1600590342274452', 47, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (287, '1600590342274453', 47, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (288, '1598231272851280', 47, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (289, '1598231272851281', 47, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (290, '1598231272851282', 47, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (291, '1598230936517260', 48, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (292, '1598230936517261', 48, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (293, '1598230936517262', 48, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (297, '1598257978841300', 46, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (298, '1598257978841301', 46, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (299, '1598257978841302', 46, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (300, '1601343305032490', 57, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (301, '1601343305032491', 57, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (302, '1600520752205420', 58, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (303, '1598270266233310', 59, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (304, '1598270266233311', 59, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (305, '1601343305032490', 60, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (306, '1601343305032491', 60, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (307, '1603879892736571', 61, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (308, '1603879705753560', 61, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (309, '1603879892736570', 62, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (310, '1603879892736570', 63, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (311, '1603879705753561', 64, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (312, '1600520752205420', 65, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (313, '1600520752205421', 66, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (314, '1604737539693600', 67, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (315, '1604737539693601', 67, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (318, '1604457115654583', 68, 0.00);
INSERT INTO `pms_sku_marketing` VALUES (319, '1604457115654584', 68, 0.00);

-- ----------------------------
-- Table structure for pms_sku_member_price
-- ----------------------------
DROP TABLE IF EXISTS `pms_sku_member_price`;
CREATE TABLE `pms_sku_member_price`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `spu_id` bigint(20) NOT NULL COMMENT '商品id',
  `sku_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品id',
  `member_level_id` bigint(20) NOT NULL COMMENT '会员等级id',
  `price` decimal(20, 2) NOT NULL COMMENT '会员价格',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记 0未删除1 删除 默认0 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sku_id`(`sku_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '单品的会员价' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_sku_member_price
-- ----------------------------
INSERT INTO `pms_sku_member_price` VALUES (4, 24, '1605356770768243', 9, 4004.00, '0');
INSERT INTO `pms_sku_member_price` VALUES (5, 24, '1605356770768243', 1, 9009.00, '0');
INSERT INTO `pms_sku_member_price` VALUES (6, 24, '1605356770768243', 2, 87087.00, '0');

-- ----------------------------
-- Table structure for pms_sku_spec_value
-- ----------------------------
DROP TABLE IF EXISTS `pms_sku_spec_value`;
CREATE TABLE `pms_sku_spec_value`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `spu_id` bigint(20) NOT NULL COMMENT '商品id',
  `sku_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '单品id   对应pms_sku表中的id',
  `spec_id` bigint(20) NOT NULL COMMENT '规格id 对应pms_spec表中的id',
  `spec_value_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '规格值id  对应pms_spec_value 表中的id',
  `value_remark` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '规格值',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记 0 未删除 1 删除  默认0 ',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `spec_id`(`spec_id`) USING BTREE,
  INDEX `sku_id`(`sku_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 657 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '单品的规格值表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_sku_spec_value
-- ----------------------------
INSERT INTO `pms_sku_spec_value` VALUES (144, 26, '1598230936517262', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (145, 26, '1598230936517260', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (146, 26, '1598230936517261', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (150, 28, '1598231272851280', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (151, 28, '1598231272851281', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (152, 28, '1598231272851282', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (153, 29, '1598251119774291', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (154, 29, '1598251119774292', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (155, 29, '1598251119774290', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (156, 30, '1598257978841301', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (157, 30, '1598257978841300', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (158, 30, '1598257978841302', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (165, 33, '1598445895165332', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (166, 33, '1598445895165331', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (167, 33, '1598445895165330', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (168, 34, '1598445933547340', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (169, 34, '1598445933547342', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (170, 34, '1598445933547341', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (180, 32, '1598442734166320', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (181, 32, '1598442734166321', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (182, 32, '1598442734166322', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (186, 35, '1598962953451350', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (187, 35, '1598962953451351', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (188, 35, '1598962953451352', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (189, 31, '1598270266233310', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (190, 31, '1598270266233311', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (191, 31, '1598270266233312', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (195, 25, '1598079663976250', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (196, 25, '1598079663976251', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (197, 25, '1598079663976252', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (210, 36, '1600064586682360', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (211, 36, '1600064586682360', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (212, 36, '1600064586682361', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (213, 36, '1600064586682361', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (214, 36, '1600064586682362', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (215, 36, '1600064586682362', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (216, 36, '1600064586682363', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (217, 36, '1600064586682363', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (218, 36, '1600064586682364', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (219, 36, '1600064586682364', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (220, 36, '1600064586682365', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (221, 36, '1600064586682365', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (222, 37, '1600066010217370', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (223, 27, '1598231219999270', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (224, 27, '1598231219999271', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (225, 27, '1598231219999272', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (226, 38, '1600085043405382', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (227, 38, '1600085043405380', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (228, 38, '1600085043405381', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (241, 39, '1600152633570390', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (242, 39, '1600152633570390', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (243, 39, '1600152633570391', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (244, 39, '1600152633570391', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (245, 39, '1600152633570392', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (246, 39, '1600152633570392', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (247, 39, '1600152633570393', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (248, 39, '1600152633570393', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (249, 39, '1600152633570394', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (250, 39, '1600152633570394', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (251, 39, '1600152633570395', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (252, 39, '1600152633570395', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (253, 40, '1600166517987402', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (254, 40, '1600166517987401', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (255, 40, '1600166517987400', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (256, 41, '1600218309894410', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (257, 41, '1600218309894412', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (258, 41, '1600218309894411', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (277, 36, '1600416529773362', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (278, 36, '1600416529773361', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (279, 36, '1600416529773360', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (280, 36, '1600416529773363', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (281, 22, '1598079455498220', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (282, 22, '1598079455498220', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (283, 22, '1598079455498221', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (284, 22, '1598079455498221', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (285, 22, '1598079455498222', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (286, 22, '1598079455498222', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (287, 22, '1598079455498223', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (288, 22, '1598079455498223', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (289, 22, '1598079455498224', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (290, 22, '1598079455498224', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (291, 22, '1598079455498225', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (292, 22, '1598079455498225', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (293, 22, '1598079455498226', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (294, 22, '1598079455498226', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (295, 22, '1598079455498227', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (296, 22, '1598079455498227', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (297, 22, '1598079455498228', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (298, 22, '1598079455498228', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (299, 37, '1600520321195373', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (300, 37, '1600520321195373', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (301, 37, '16005203211953710', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (302, 37, '16005203211953710', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (303, 37, '1600520321195377', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (304, 37, '1600520321195377', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (305, 37, '1600520321195376', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (306, 37, '1600520321195376', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (307, 37, '1600520321195375', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (308, 37, '1600520321195375', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (309, 37, '16005203211953711', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (310, 37, '16005203211953711', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (311, 37, '1600520321195378', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (312, 37, '1600520321195378', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (313, 37, '1600520321195371', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (314, 37, '1600520321195371', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (315, 37, '1600520321195374', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (316, 37, '1600520321195374', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (317, 37, '1600520321195379', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (318, 37, '1600520321195379', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (319, 37, '1600520321195370', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (320, 37, '1600520321195370', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (321, 37, '1600520321195372', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (322, 37, '1600520321195372', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (323, 38, '1600520416975382', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (324, 38, '1600520416975382', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (325, 38, '1600520416975385', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (326, 38, '1600520416975385', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (327, 38, '1600520416975386', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (328, 38, '1600520416975386', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (329, 38, '1600520416975387', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (330, 38, '1600520416975387', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (331, 38, '1600520416975383', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (332, 38, '1600520416975383', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (333, 38, '1600520416975388', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (334, 38, '1600520416975388', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (335, 38, '1600520416975381', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (336, 38, '1600520416975381', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (337, 38, '1600520416975384', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (338, 38, '1600520416975384', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (339, 38, '1600520416975380', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (340, 38, '1600520416975380', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (341, 39, '1600520508108390', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (342, 39, '1600520508108391', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (343, 39, '1600520508108392', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (344, 40, '1600520579652400', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (345, 40, '1600520579652402', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (346, 40, '1600520579652401', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (347, 41, '1600520637271410', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (348, 41, '1600520637271411', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (349, 41, '1600520637271412', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (350, 42, '1600520752205420', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (351, 42, '1600520752205422', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (352, 42, '1600520752205421', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (377, 44, '1600590248265440', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (378, 44, '1600590248265441', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (379, 44, '1600590248265442', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (380, 45, '1600590342274451', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (381, 45, '1600590342274452', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (382, 45, '1600590342274453', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (383, 45, '1600590342274450', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (384, 46, '16005904501934610', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (385, 46, '16005904501934610', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (386, 46, '1600590450193463', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (387, 46, '1600590450193463', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (388, 46, '1600590450193461', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (389, 46, '1600590450193461', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (390, 46, '1600590450193467', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (391, 46, '1600590450193467', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (392, 46, '16005904501934611', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (393, 46, '16005904501934611', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (394, 46, '1600590450193465', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (395, 46, '1600590450193465', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (396, 46, '1600590450193462', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (397, 46, '1600590450193462', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (398, 46, '1600590450193468', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (399, 46, '1600590450193468', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (400, 46, '1600590450193469', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (401, 46, '1600590450193469', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (402, 46, '1600590450193464', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (403, 46, '1600590450193464', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (404, 46, '1600590450193460', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (405, 46, '1600590450193460', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (406, 46, '1600590450193466', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (407, 46, '1600590450193466', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (408, 47, '1600611848935471', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (409, 47, '1600611848935472', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (410, 47, '1600611848935473', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (411, 47, '1600611848935470', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (436, 48, '1600649194611480', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (437, 48, '1600649194611480', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (438, 48, '1600649194611481', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (439, 48, '1600649194611481', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (440, 48, '16006491946114810', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (441, 48, '16006491946114810', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (442, 48, '16006491946114811', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (443, 48, '16006491946114811', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (444, 48, '1600649194611482', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (445, 48, '1600649194611482', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (446, 48, '1600649194611483', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (447, 48, '1600649194611483', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (448, 48, '1600649194611484', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (449, 48, '1600649194611484', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (450, 48, '1600649194611485', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (451, 48, '1600649194611485', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (452, 48, '1600649194611486', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (453, 48, '1600649194611486', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (454, 48, '1600649194611487', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (455, 48, '1600649194611487', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (456, 48, '1600649194611488', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (457, 48, '1600649194611488', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (458, 48, '1600649194611489', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (459, 48, '1600649194611489', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (460, 49, '1601343305035499', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (461, 49, '1601343305035499', 5, '160015227683250', '版型', '0');
INSERT INTO `pms_sku_spec_value` VALUES (462, 49, '1601343305035494', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (463, 49, '1601343305035494', 5, '160015227683250', '版型', '0');
INSERT INTO `pms_sku_spec_value` VALUES (464, 49, '1601343305035496', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (465, 49, '1601343305035496', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (466, 49, '1601343305032491', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (467, 49, '1601343305032491', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (468, 49, '1601343305035495', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (469, 49, '1601343305035495', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (470, 49, '1601343305035493', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (471, 49, '1601343305035493', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (472, 49, '1601343305035492', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (473, 49, '1601343305035492', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (474, 49, '16013433050354910', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (475, 49, '16013433050354910', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (476, 49, '1601343305032490', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (477, 49, '1601343305032490', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (478, 49, '16013433050354913', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (479, 49, '16013433050354913', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (480, 49, '1601343305035498', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (481, 49, '1601343305035498', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (482, 49, '1601343305035497', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (483, 49, '1601343305035497', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (484, 49, '16013433050354912', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (485, 49, '16013433050354912', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (486, 49, '16013433050354914', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (487, 49, '16013433050354914', 5, '160015227683250', '版型', '0');
INSERT INTO `pms_sku_spec_value` VALUES (488, 49, '16013433050354911', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (489, 49, '16013433050354911', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (490, 50, '1601352260884503', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (491, 50, '1601352260884503', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (492, 50, '1601352260884505', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (493, 50, '1601352260884505', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (494, 50, '1601352260884501', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (495, 50, '1601352260884501', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (496, 50, '1601352260884507', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (497, 50, '1601352260884507', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (498, 50, '1601352260884504', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (499, 50, '1601352260884504', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (500, 50, '1601352260884502', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (501, 50, '1601352260884502', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (502, 50, '1601352260884500', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (503, 50, '1601352260884500', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (504, 50, '16013522608845010', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (505, 50, '16013522608845010', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (506, 50, '1601352260884508', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (507, 50, '1601352260884508', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (508, 50, '1601352260884506', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (509, 50, '1601352260884506', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (510, 50, '1601352260884509', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (511, 50, '1601352260884509', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (512, 50, '16013522608845011', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (513, 50, '16013522608845011', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (514, 51, '1603782056458517', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (515, 51, '1603782056458517', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (516, 51, '1603782056458516', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (517, 51, '1603782056458516', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (518, 51, '1603782056458512', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (519, 51, '1603782056458512', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (520, 51, '1603782056458515', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (521, 51, '1603782056458515', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (522, 51, '1603782056458514', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (523, 51, '1603782056458514', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (524, 51, '1603782056458511', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (525, 51, '1603782056458511', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (526, 51, '1603782056458513', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (527, 51, '1603782056458513', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (528, 51, '1603782056458510', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (529, 51, '1603782056458510', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (530, 52, '1603782988325521', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (531, 52, '1603782988325520', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (532, 52, '1603782988325522', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (533, 52, '1603782988325523', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (534, 53, '1603783193248532', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (535, 53, '1603783193248530', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (536, 53, '1603783193248531', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (537, 53, '1603783193248534', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (538, 53, '1603783193248533', 5, '160015227683250', '版型', '0');
INSERT INTO `pms_sku_spec_value` VALUES (539, 54, '1603783339870541', 7, '160051955944071', '8GB+256GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (540, 54, '1603783339870542', 7, '160051955944072', '16GB+512GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (541, 54, '1603783339870540', 7, '160051955944070', '4GB+128GB', '0');
INSERT INTO `pms_sku_spec_value` VALUES (542, 55, '1603783654596550', 6, '160015342229460', '青春版', '0');
INSERT INTO `pms_sku_spec_value` VALUES (543, 55, '1603783654596551', 6, '160015342229461', '荣耀版', '0');
INSERT INTO `pms_sku_spec_value` VALUES (544, 55, '1603783654596553', 6, '160015342229463', '耀世巅峰版', '0');
INSERT INTO `pms_sku_spec_value` VALUES (545, 55, '1603783654596552', 6, '160015342229462', '畅享旗舰版', '0');
INSERT INTO `pms_sku_spec_value` VALUES (546, 56, '1603879705753560', 12, '1603877857140121', '白心柚', '0');
INSERT INTO `pms_sku_spec_value` VALUES (547, 56, '1603879705753561', 12, '1603877823837120', '红心柚', '0');
INSERT INTO `pms_sku_spec_value` VALUES (548, 57, '1603879892736571', 12, '1603877857140121', '白心柚', '0');
INSERT INTO `pms_sku_spec_value` VALUES (549, 57, '1603879892736570', 12, '1603877823837120', '红心柚', '0');
INSERT INTO `pms_sku_spec_value` VALUES (556, 23, '1598079520317230', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (557, 23, '1598079520317231', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (558, 23, '1598079520317232', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (559, 58, '1604457115654581', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (560, 58, '1604457115654584', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (561, 58, '1604457115654582', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (562, 58, '1604457115654583', 4, '160378339028740', '黑色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (563, 58, '1604457115654580', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (566, 59, '1604626581053590', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (567, 59, '1604626581053591', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (570, 61, '1604738056157611', 4, '160378339028740', '黑色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (571, 61, '1604738056157610', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (572, 60, '1604737539693600', 4, '160378339028740', '黑色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (573, 60, '1604737539693601', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (574, 62, '1604763000250622', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (575, 62, '1604763000250622', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (576, 62, '1604763000250621', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (577, 62, '1604763000250621', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (578, 62, '1604763000250620', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (579, 62, '1604763000250620', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (580, 62, '1604763000250623', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (581, 62, '1604763000250623', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (582, 63, '1604763051021630', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (583, 63, '1604763051021630', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (584, 63, '1604763051021631', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (585, 63, '1604763051021631', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (586, 63, '1604763051021633', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (587, 63, '1604763051021633', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (588, 63, '1604763051021632', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (589, 63, '1604763051021632', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (618, 43, '1600590159237430', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (619, 43, '1600590159237430', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (620, 43, '1600590159237431', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (621, 43, '1600590159237431', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (622, 43, '16005901592374310', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (623, 43, '16005901592374310', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (624, 43, '16005901592374311', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (625, 43, '16005901592374311', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (626, 43, '1600590159237432', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (627, 43, '1600590159237432', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (628, 43, '1600590159237433', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (629, 43, '1600590159237433', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (630, 43, '1600590159237434', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (631, 43, '1600590159237434', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (632, 43, '1600590159237435', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (633, 43, '1600590159237435', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (634, 43, '1600590159237436', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (635, 43, '1600590159237436', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (636, 43, '1600590159237437', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (637, 43, '1600590159237437', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (638, 43, '1600590159237438', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (639, 43, '1600590159237438', 5, '160024831359550', 'SSSS', '0');
INSERT INTO `pms_sku_spec_value` VALUES (640, 43, '1600590159237439', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (641, 43, '1600590159237439', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (647, 64, '1605624533499640', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (648, 64, '1605624533499641', 4, '159807754093041', '蓝色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (649, 64, '1605624533499642', 4, '159807754093042', '白色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (650, 64, '1605624533499643', 4, '160024832705840', 'S', '0');
INSERT INTO `pms_sku_spec_value` VALUES (651, 64, '1605624533499644', 4, '160378339028740', '黑色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (652, 65, '1605677272023650', 4, '159807754093040', '红色', '0');
INSERT INTO `pms_sku_spec_value` VALUES (653, 24, '1598079584422240', 5, '159807755904350', 'L', '0');
INSERT INTO `pms_sku_spec_value` VALUES (654, 24, '1598079584422241', 5, '159807755904351', 'M', '0');
INSERT INTO `pms_sku_spec_value` VALUES (655, 24, '1598079584422242', 5, '159807755904352', 'XXL', '0');
INSERT INTO `pms_sku_spec_value` VALUES (656, 24, '1605356770768243', 5, '160024831359550', 'SSSS', '0');

-- ----------------------------
-- Table structure for pms_spec
-- ----------------------------
DROP TABLE IF EXISTS `pms_spec`;
CREATE TABLE `pms_spec`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '规格名称',
  `nick_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '规格别名',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记 0 未删除  1 删除 默认0',
  `create_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者名称',
  `modify_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改人',
  `del_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除人名称',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 14 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '规格表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_spec
-- ----------------------------
INSERT INTO `pms_spec` VALUES (4, '颜色', '', '0', 'admin', 'admin2', NULL, NULL, NULL, '2020-11-03 12:37:14');
INSERT INTO `pms_spec` VALUES (5, '尺寸', '', '0', 'admin', 'admin', NULL, NULL, NULL, '2020-10-27 14:58:02');
INSERT INTO `pms_spec` VALUES (6, '版本', '', '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec` VALUES (7, '选择版本', '选择版本', '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec` VALUES (8, '形状', '形状', '0', 'admin2', 'admin', NULL, NULL, NULL, '2020-10-27 14:58:20');
INSERT INTO `pms_spec` VALUES (12, '品种', '品种', '0', 'admin1', 'admin1', NULL, NULL, NULL, '2020-10-28 17:53:23');
INSERT INTO `pms_spec` VALUES (13, '大小', '', '0', 'admin1', NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for pms_spec_value
-- ----------------------------
DROP TABLE IF EXISTS `pms_spec_value`;
CREATE TABLE `pms_spec_value`  (
  `id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键id',
  `spec_id` bigint(20) NOT NULL COMMENT '规格id 对应pms_goods_spec表中的id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '规格值的名称',
  `sort` int(11) DEFAULT NULL COMMENT '排序  数值越小排序越前',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记 0 未删除 1删除 默认0',
  `create_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者名称',
  `modify_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者名称',
  `del_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除者名称',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `spec_id`(`spec_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '规格值表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_spec_value
-- ----------------------------
INSERT INTO `pms_spec_value` VALUES ('159807754093040', 4, '红色', 1, '0', 'admin2', NULL, NULL, '2020-11-03 12:37:14', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('159807754093041', 4, '蓝色', 1, '0', 'admin2', NULL, NULL, '2020-11-03 12:37:14', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('159807754093042', 4, '白色', 1, '0', 'admin2', NULL, NULL, '2020-11-03 12:37:14', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('159807755904350', 5, 'L', 1, '0', 'admin', NULL, NULL, '2020-10-27 14:58:02', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('159807755904351', 5, 'M', 1, '0', 'admin', NULL, NULL, '2020-10-27 14:58:02', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('159807755904352', 5, 'XXL', 1, '0', 'admin', NULL, NULL, '2020-10-27 14:58:02', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160015227683250', 5, '版型', 1, '0', 'admin', NULL, NULL, '2020-10-27 14:58:02', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160015342229460', 6, '青春版', 1, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160015342229461', 6, '荣耀版', 1, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160015342229462', 6, '畅享旗舰版', 1, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160015342229463', 6, '耀世巅峰版', 1, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160024831359550', 5, 'SSSS', 1, '0', 'admin', NULL, NULL, '2020-10-27 14:58:02', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160024832705840', 4, 'S', 1, '0', 'admin2', NULL, NULL, '2020-11-03 12:37:14', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160051955944070', 7, '4GB+128GB', 1, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160051955944071', 7, '8GB+256GB', 2, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160051955944072', 7, '16GB+512GB', 2, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160094808617280', 8, '原型', 2, '0', 'admin', NULL, NULL, '2020-10-27 14:58:19', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160094808617281', 8, '正方形', 3, '0', 'admin', NULL, NULL, '2020-10-27 14:58:19', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160094866740282', 8, '长方形', 1, '0', 'admin', NULL, NULL, '2020-10-27 14:58:19', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160335344130380', 8, '线性', 1, '0', 'admin', NULL, NULL, '2020-10-27 14:58:19', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160378339028740', 4, '黑色', 1, '0', 'admin2', NULL, NULL, '2020-11-03 12:37:14', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('1603877823837120', 12, '红心柚', 1, '0', 'admin1', NULL, NULL, '2020-10-28 17:53:22', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('1603877857140121', 12, '白心柚', 2, '0', 'admin1', NULL, NULL, '2020-10-28 17:53:22', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('1603878778676130', 13, '大', 1, '0', 'admin1', NULL, NULL, '2020-10-28 17:52:58', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('1603878778676131', 13, '中', 2, '0', 'admin1', NULL, NULL, '2020-10-28 17:52:58', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('1603878778676132', 13, '小', 3, '0', 'admin1', NULL, NULL, '2020-10-28 17:52:58', NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160562477811340', 4, '', NULL, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_spec_value` VALUES ('160567722418440', 4, '紫色', NULL, '0', 'admin1', NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for pms_type
-- ----------------------------
DROP TABLE IF EXISTS `pms_type`;
CREATE TABLE `pms_type`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '类型名称',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '删除标记 0 未删除 1删除 默认0',
  `create_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '创建者名称',
  `modify_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '修改者名称',
  `del_name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '删除者名称',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `modify_time` timestamp(0) DEFAULT NULL COMMENT '修改时间',
  `del_time` timestamp(0) DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '商品类型表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of pms_type
-- ----------------------------
INSERT INTO `pms_type` VALUES (4, '年份', '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_type` VALUES (5, 'www', '0', 'admin2', 'admin2', NULL, NULL, '2020-09-24 19:47:21', NULL);
INSERT INTO `pms_type` VALUES (6, '', '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_type` VALUES (7, '颜色', '0', 'admin', NULL, NULL, NULL, NULL, NULL);
INSERT INTO `pms_type` VALUES (8, '产地', '0', 'admin1', 'admin', NULL, NULL, '2020-11-02 18:42:03', NULL);
INSERT INTO `pms_type` VALUES (9, 'nono', '0', 'admin', NULL, NULL, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for qrtz_blob_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_blob_triggers`;
CREATE TABLE `qrtz_blob_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `blob_data` blob,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_blob_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for qrtz_calendars
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_calendars`;
CREATE TABLE `qrtz_calendars`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `calendar_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `calendar` blob NOT NULL,
  PRIMARY KEY (`sched_name`, `calendar_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for qrtz_cron_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_cron_triggers`;
CREATE TABLE `qrtz_cron_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `cron_expression` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `time_zone_id` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_cron_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_cron_triggers
-- ----------------------------
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', '0/10 * * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME100', 'DEFAULT', '0 0 2 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME101', 'DEFAULT', '0 0 2 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME102', 'DEFAULT', '0 0 2 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME103', 'DEFAULT', '0 0 0/2 * * ? ', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME104', 'DEFAULT', '0 0 0 24 * ? ', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME105', 'DEFAULT', '0 0 0 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME106', 'DEFAULT', '0 0 0 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME107', 'DEFAULT', '0 0 0 * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', '0/15 * * * * ?', 'Asia/Shanghai');
INSERT INTO `qrtz_cron_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', '0/20 * * * * ?', 'Asia/Shanghai');

-- ----------------------------
-- Table structure for qrtz_fired_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_fired_triggers`;
CREATE TABLE `qrtz_fired_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `entry_id` varchar(95) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `instance_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `fired_time` bigint(13) NOT NULL,
  `sched_time` bigint(13) NOT NULL,
  `priority` int(11) NOT NULL,
  `state` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `job_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_nonconcurrent` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `requests_recovery` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `entry_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for qrtz_job_details
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_job_details`;
CREATE TABLE `qrtz_job_details`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `job_class_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `is_durable` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `is_nonconcurrent` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `is_update_data` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `requests_recovery` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `job_data` blob,
  PRIMARY KEY (`sched_name`, `job_name`, `job_group`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_job_details
-- ----------------------------
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E74697479000000000000000102000A4C0009626567696E54696D6571007E00094C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0008656E647354696D6571007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C000973746F72654E616D6571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001622CDE29E0787070740000707070707400013174000E302F3130202A202A202A202A203F74001172795461736B2E72794E6F506172616D7374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000001740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E697A0E58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME100', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 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
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME101', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E74697479000000000000000102000A4C0009626567696E54696D6571007E00094C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0008656E647354696D6571007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C000973746F72654E616D6571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001742E1E1AD8787070740000707070707400013174000B3020302032202A202A203F74001972795461736B2E6175746F436F6E6669726D5265636569707474000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000006574000CE7A1AEE8AEA4E694B6E8B4A774000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME102', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E74697479000000000000000102000A4C0009626567696E54696D6571007E00094C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0008656E647354696D6571007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C000973746F72654E616D6571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001742E1E1AD8787070740000707070707400013174000B3020302032202A202A203F74001672795461736B2E6175746F43616E63656C4F7264657274000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000006674000CE58F96E6B688E8AEA2E58D9574000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME103', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E74697479000000000000000102000A4C0009626567696E54696D6571007E00094C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0008656E647354696D6571007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C000973746F72654E616D6571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001742E1E1AD8787070740000707070707400013174000E30203020302F32202A202A203F2074001B72795461736B2E6175746F43616E63656C47726F75704F7264657274000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000067740023E5A484E79086E8B685E8BF873234E5B08FE697B6E79A84E68BBCE59BA2E8AEA2E58D9574000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME104', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E74697479000000000000000102000A4C0009626567696E54696D6571007E00094C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0008656E647354696D6571007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C000973746F72654E616D6571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001742E1E1AD8787070740000707070707400013174000D3020302030203234202A203F2074002472795461736B2E6175746F43616E63656C4465706F73697450726553616C654F7264657274000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000006874001EE887AAE58AA8E58F96E6B688E5AE9AE98791E9A284E594AEE8AEA2E58D9574000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME105', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E74697479000000000000000102000A4C0009626567696E54696D6571007E00094C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0008656E647354696D6571007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C000973746F72654E616D6571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001742E1E1AD8787070740000707070707400013174000B3020302030202A202A203F74001A72795461736B2E6175746F44656C657465456E6447726F75707374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000069740021E887AAE58AA8E588A0E999A4E7BB93E69D9FE79A84E68BBCE59BA2E6B4BBE58AA874000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME106', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E74697479000000000000000102000A4C0009626567696E54696D6571007E00094C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0008656E647354696D6571007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C000973746F72654E616D6571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001742E1E1AD8787070740000707070707400013174000B3020302030202A202A203F74001872795461736B2E6175746F44656C657465456E645472797374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000006A740021E887AAE58AA8E588A0E999A4E7BB93E69D9FE79A84E8AF95E794A8E6B4BBE58AA874000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME107', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E74697479000000000000000102000A4C0009626567696E54696D6571007E00094C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0008656E647354696D6571007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C000973746F72654E616D6571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001742E1E1AD8787070740000707070707400013174000B3020302030202A202A203F74001C72795461736B2E6175746F44656C657465456E6450726553616C657374000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B0200007870000000000000006B740021E887AAE58AA8E588A0E999A4E7BB93E69D9FE79A84E9A284E594AEE6B4BBE58AA874000131740001307800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 0xACED0005737200156F72672E71756172747A2E4A6F62446174614D61709FB083E8BFA9B0CB020000787200266F72672E71756172747A2E7574696C732E537472696E674B65794469727479466C61674D61708208E8C3FBC55D280200015A0013616C6C6F77735472616E7369656E74446174617872001D6F72672E71756172747A2E7574696C732E4469727479466C61674D617013E62EAD28760ACE0200025A000564697274794C00036D617074000F4C6A6176612F7574696C2F4D61703B787001737200116A6176612E7574696C2E486173684D61700507DAC1C31660D103000246000A6C6F6164466163746F724900097468726573686F6C6478703F4000000000000C7708000000100000000174000F5441534B5F50524F504552544945537372001E636F6D2E72756F79692E71756172747A2E646F6D61696E2E5379734A6F6200000000000000010200084C000A636F6E63757272656E747400124C6A6176612F6C616E672F537472696E673B4C000E63726F6E45787072657373696F6E71007E00094C000C696E766F6B6554617267657471007E00094C00086A6F6247726F757071007E00094C00056A6F6249647400104C6A6176612F6C616E672F4C6F6E673B4C00076A6F624E616D6571007E00094C000D6D697366697265506F6C69637971007E00094C000673746174757371007E000978720027636F6D2E72756F79692E636F6D6D6F6E2E636F72652E646F6D61696E2E42617365456E74697479000000000000000102000A4C0009626567696E54696D6571007E00094C0008637265617465427971007E00094C000A63726561746554696D657400104C6A6176612F7574696C2F446174653B4C0008656E647354696D6571007E00094C0006706172616D7371007E00034C000672656D61726B71007E00094C000B73656172636856616C756571007E00094C000973746F72654E616D6571007E00094C0008757064617465427971007E00094C000A75706461746554696D6571007E000C78707074000561646D696E7372000E6A6176612E7574696C2E44617465686A81014B59741903000078707708000001622CDE29E0787070740000707070707400013174000E302F3135202A202A202A202A203F74001572795461736B2E7279506172616D7328277279272974000744454641554C547372000E6A6176612E6C616E672E4C6F6E673B8BE490CC8F23DF0200014A000576616C7565787200106A6176612E6C616E672E4E756D62657286AC951D0B94E08B02000078700000000000000002740018E7B3BBE7BB9FE9BB98E8AEA4EFBC88E69C89E58F82EFBC8974000133740001317800);
INSERT INTO `qrtz_job_details` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 'com.ruoyi.quartz.util.QuartzDisallowConcurrentExecution', '0', '1', '0', '0', 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

-- ----------------------------
-- Table structure for qrtz_locks
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_locks`;
CREATE TABLE `qrtz_locks`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `lock_name` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`sched_name`, `lock_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_locks
-- ----------------------------
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'STATE_ACCESS');
INSERT INTO `qrtz_locks` VALUES ('RuoyiScheduler', 'TRIGGER_ACCESS');

-- ----------------------------
-- Table structure for qrtz_paused_trigger_grps
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_paused_trigger_grps`;
CREATE TABLE `qrtz_paused_trigger_grps`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  PRIMARY KEY (`sched_name`, `trigger_group`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for qrtz_scheduler_state
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_scheduler_state`;
CREATE TABLE `qrtz_scheduler_state`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `instance_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `last_checkin_time` bigint(13) NOT NULL,
  `checkin_interval` bigint(13) NOT NULL,
  PRIMARY KEY (`sched_name`, `instance_name`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_scheduler_state
-- ----------------------------
INSERT INTO `qrtz_scheduler_state` VALUES ('RuoyiScheduler', 'SKY-20200315IMD1605578746122', 1605627324824, 15000);

-- ----------------------------
-- Table structure for qrtz_simple_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simple_triggers`;
CREATE TABLE `qrtz_simple_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `repeat_count` bigint(7) NOT NULL,
  `repeat_interval` bigint(12) NOT NULL,
  `times_triggered` bigint(10) NOT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_simple_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for qrtz_simprop_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_simprop_triggers`;
CREATE TABLE `qrtz_simprop_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `str_prop_1` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `str_prop_2` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `str_prop_3` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `int_prop_1` int(11) DEFAULT NULL,
  `int_prop_2` int(11) DEFAULT NULL,
  `long_prop_1` bigint(20) DEFAULT NULL,
  `long_prop_2` bigint(20) DEFAULT NULL,
  `dec_prop_1` decimal(13, 4) DEFAULT NULL,
  `dec_prop_2` decimal(13, 4) DEFAULT NULL,
  `bool_prop_1` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bool_prop_2` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  CONSTRAINT `qrtz_simprop_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `trigger_name`, `trigger_group`) REFERENCES `qrtz_triggers` (`sched_name`, `trigger_name`, `trigger_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for qrtz_triggers
-- ----------------------------
DROP TABLE IF EXISTS `qrtz_triggers`;
CREATE TABLE `qrtz_triggers`  (
  `sched_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `job_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `job_group` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `description` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `next_fire_time` bigint(13) DEFAULT NULL,
  `prev_fire_time` bigint(13) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `trigger_state` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `trigger_type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `start_time` bigint(13) NOT NULL,
  `end_time` bigint(13) DEFAULT NULL,
  `calendar_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `misfire_instr` smallint(2) DEFAULT NULL,
  `job_data` blob,
  PRIMARY KEY (`sched_name`, `trigger_name`, `trigger_group`) USING BTREE,
  INDEX `sched_name`(`sched_name`, `job_name`, `job_group`) USING BTREE,
  CONSTRAINT `qrtz_triggers_ibfk_1` FOREIGN KEY (`sched_name`, `job_name`, `job_group`) REFERENCES `qrtz_job_details` (`sched_name`, `job_name`, `job_group`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of qrtz_triggers
-- ----------------------------
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME1', 'DEFAULT', 'TASK_CLASS_NAME1', 'DEFAULT', NULL, 1605578750000, -1, 5, 'PAUSED', 'CRON', 1605578746000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME100', 'DEFAULT', 'TASK_CLASS_NAME100', 'DEFAULT', NULL, 1605636000000, -1, 5, 'WAITING', 'CRON', 1605578748000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME101', 'DEFAULT', 'TASK_CLASS_NAME101', 'DEFAULT', NULL, 1605636000000, -1, 5, 'WAITING', 'CRON', 1605578749000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME102', 'DEFAULT', 'TASK_CLASS_NAME102', 'DEFAULT', NULL, 1605636000000, -1, 5, 'WAITING', 'CRON', 1605578749000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME103', 'DEFAULT', 'TASK_CLASS_NAME103', 'DEFAULT', NULL, 1605628800000, 1605621600000, 5, 'WAITING', 'CRON', 1605578749000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME104', 'DEFAULT', 'TASK_CLASS_NAME104', 'DEFAULT', NULL, 1606147200000, -1, 5, 'WAITING', 'CRON', 1605578750000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME105', 'DEFAULT', 'TASK_CLASS_NAME105', 'DEFAULT', NULL, 1605628800000, -1, 5, 'WAITING', 'CRON', 1605578750000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME106', 'DEFAULT', 'TASK_CLASS_NAME106', 'DEFAULT', NULL, 1605628800000, -1, 5, 'WAITING', 'CRON', 1605578751000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME107', 'DEFAULT', 'TASK_CLASS_NAME107', 'DEFAULT', NULL, 1605628800000, -1, 5, 'WAITING', 'CRON', 1605578751000, 0, NULL, -1, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME2', 'DEFAULT', 'TASK_CLASS_NAME2', 'DEFAULT', NULL, 1605578760000, -1, 5, 'PAUSED', 'CRON', 1605578747000, 0, NULL, 2, '');
INSERT INTO `qrtz_triggers` VALUES ('RuoyiScheduler', 'TASK_CLASS_NAME3', 'DEFAULT', 'TASK_CLASS_NAME3', 'DEFAULT', NULL, 1605578760000, -1, 5, 'PAUSED', 'CRON', 1605578747000, 0, NULL, 2, '');

-- ----------------------------
-- Table structure for s_community_buy
-- ----------------------------
DROP TABLE IF EXISTS `s_community_buy`;
CREATE TABLE `s_community_buy`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '团购名称',
  `announcement` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '团购公告',
  `start_time` timestamp(0) DEFAULT NULL COMMENT '开始时间',
  `end_time` timestamp(0) DEFAULT NULL COMMENT '结束时间',
  `delivery_time` timestamp(0) DEFAULT NULL COMMENT '送达时间',
  `cancel_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '撤销状态 0 未撤销 1 已撤销 默认0 未撤销',
  `cancel_time` timestamp(0) DEFAULT NULL COMMENT '撤销时间',
  `has_deal` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否已经处理 0 否1是  默认0 （被扫描结算社区团购的定时任务处理）',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '社区团购' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for s_community_buy_head
-- ----------------------------
DROP TABLE IF EXISTS `s_community_buy_head`;
CREATE TABLE `s_community_buy_head`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `customer_id` bigint(20) DEFAULT NULL COMMENT '会员id',
  `name` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '团长名称',
  `address` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '所在地区 省+市+区',
  `detail_address` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '详细信息',
  `pick_up_address` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '提货点',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '状态 0 待审核 1 审核拒绝 2 审核通过  3 已移除 默认0 ',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `audit_time` timestamp(0) DEFAULT NULL COMMENT '审核时间',
  `refuse_reason` varchar(1024) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '拒绝原因',
  `sale_money` decimal(20, 2) DEFAULT 0.00 COMMENT '销售额',
  `commission` decimal(20, 2) DEFAULT 0.00 COMMENT '累计佣金',
  `can_use_commission` decimal(20, 2) DEFAULT 0.00 COMMENT '可提现佣金',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `customer_id`(`customer_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '团长表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for s_community_buy_index
-- ----------------------------
DROP TABLE IF EXISTS `s_community_buy_index`;
CREATE TABLE `s_community_buy_index`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `title` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '标题',
  `content` longtext CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '推广内容',
  `origin_content` longtext CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '初始默认模版',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '社区团购推广页' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for s_community_buy_mapping
-- ----------------------------
DROP TABLE IF EXISTS `s_community_buy_mapping`;
CREATE TABLE `s_community_buy_mapping`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `community_buy_head_id` bigint(20) DEFAULT NULL COMMENT '团长id',
  `community_buy_id` bigint(20) DEFAULT NULL COMMENT '社区团购id',
  `delivery` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否提供送货上门 0 否 1 提供 默认0 ',
  `community_buy_sku_id` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '团购单品的id，多个用，隔开 里面有的说明团长是开启参团的',
  `community_buy_unchoose_sku_id` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '团购单品的id，多个用，隔开 里面有的说明团长是未开启参团的',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '团长和团购的映射关系表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for s_community_buy_setting
-- ----------------------------
DROP TABLE IF EXISTS `s_community_buy_setting`;
CREATE TABLE `s_community_buy_setting`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '团长名称',
  `audit` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '是否开启审核  0 开启 1 关闭 默认0',
  `sms_audit_notice` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '审核结果通知  0 通知 1 不通知 默认0 ',
  `sms_pay_notice` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '打款通知 0 通知 1 不通知默认0 ',
  `sms_commission_notice` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '佣金结算通知 0 通知 1 不通知默认0 ',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '社区团购设置' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for s_community_buy_sku
-- ----------------------------
DROP TABLE IF EXISTS `s_community_buy_sku`;
CREATE TABLE `s_community_buy_sku`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `community_buy_id` bigint(20) DEFAULT NULL COMMENT '社区团购id 对应s_community_buy表中的id',
  `name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品名称',
  `sku_desc` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品描述',
  `stock` int(11) DEFAULT NULL COMMENT '库存',
  `supply_price` decimal(20, 2) DEFAULT NULL COMMENT '供货价格',
  `group_price` decimal(20, 2) DEFAULT NULL COMMENT '团购价格',
  `price` decimal(20, 2) DEFAULT NULL COMMENT '单品原价',
  `mobile_desc` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '详情',
  `pics` text CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '图片 多个图片,隔开',
  `sku_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品id',
  `spec` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '规格',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '社区团购单品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for s_community_commission_records
-- ----------------------------
DROP TABLE IF EXISTS `s_community_commission_records`;
CREATE TABLE `s_community_commission_records`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `customer_id` bigint(20) DEFAULT NULL COMMENT '会员id',
  `money` decimal(20, 2) DEFAULT NULL COMMENT '金额',
  `type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '类型  0 收入 1 支出',
  `remark_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注类型  1 订单分佣  2 佣金提现 3 提现失败退回',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '社区团购佣金记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for s_community_invoice
-- ----------------------------
DROP TABLE IF EXISTS `s_community_invoice`;
CREATE TABLE `s_community_invoice`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `head_customer_id` bigint(20) DEFAULT NULL COMMENT '团长的会员id',
  `money` decimal(20, 2) DEFAULT NULL COMMENT '销售金额',
  `num` int(11) DEFAULT NULL COMMENT '数量',
  `community_buy_id` bigint(20) DEFAULT NULL COMMENT '团购id 对应s_community_buy表的id',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '社区团购发货单' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for s_community_invoice_detail
-- ----------------------------
DROP TABLE IF EXISTS `s_community_invoice_detail`;
CREATE TABLE `s_community_invoice_detail`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `community_invoice_id` bigint(20) DEFAULT NULL COMMENT '社区团购返货单id 对应s_community_invoice表中的id',
  `sku_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品名称',
  `sku_id` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品的id',
  `sku_specs` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '单品的规格',
  `num` int(11) DEFAULT NULL COMMENT '数量',
  `url` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '图片地址',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '社区团购发货单详情' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for s_community_withdraw
-- ----------------------------
DROP TABLE IF EXISTS `s_community_withdraw`;
CREATE TABLE `s_community_withdraw`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `customer_id` bigint(20) DEFAULT NULL COMMENT '会员id',
  `money` decimal(20, 2) DEFAULT NULL COMMENT '提现金额',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '状态 0 申请  1 审核通过 2 拒绝 3 已打款',
  `trade_no` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '流水号',
  `account` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '支付宝账号',
  `name` varchar(45) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '支付宝姓名',
  `create_time` timestamp(0) DEFAULT NULL COMMENT '创建时间',
  `paying_time` timestamp(0) DEFAULT NULL COMMENT '打款时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '社区团购提现记录表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sms_coupon
-- ----------------------------
DROP TABLE IF EXISTS `sms_coupon`;
CREATE TABLE `sms_coupon`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '优惠卷名称',
  `num` int(11) DEFAULT NULL COMMENT '生成张数',
  `limit_num` int(11) DEFAULT NULL COMMENT '每人可以领取的张数',
  `use_type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '1' COMMENT '使用方式 1 领取 2 发放',
  `type` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '类型 1满减 2直降',
  `desc` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '描述',
  `store_id` bigint(20) NOT NULL COMMENT '店铺id   平台的优惠卷为0',
  `starttime` timestamp(0) DEFAULT NULL COMMENT '开始时间',
  `endtime` timestamp(0) DEFAULT NULL COMMENT '结束时间',
  `del_flag` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '删除标记  0未删除 1删除 默认0',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '优惠卷是否已经领完 0 未领完 1 已领完',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 21 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '优惠卷主表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sms_coupon
-- ----------------------------
INSERT INTO `sms_coupon` VALUES (20, '123', 22, 2, '1', '1', '', 0, '2020-11-16 00:00:00', '2022-12-16 00:00:00', '0', '0');

-- ----------------------------
-- Table structure for sms_coupon_code
-- ----------------------------
DROP TABLE IF EXISTS `sms_coupon_code`;
CREATE TABLE `sms_coupon_code`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `coupon_id` bigint(20) NOT NULL COMMENT '优惠卷id',
  `code` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '优惠卷的卷码',
  `customer_id` bigint(20) DEFAULT NULL COMMENT '领取优惠卷的会员id',
  `status` char(1) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT '0' COMMENT '优惠卷状态  0 未领取 1已领取未使用 2 已使用 3已失效',
  `receive_time` timestamp(0) DEFAULT NULL COMMENT '领取时间',
  `order_id` bigint(20) DEFAULT NULL,
  `user_time` datetime(0) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `customer_id`(`customer_id`) USING BTREE,
  INDEX `coupon_id`(`coupon_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3725 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '优惠卷卷码表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sms_coupon_code
-- ----------------------------
INSERT INTO `sms_coupon_code` VALUES (3703, 20, '8WNC96LCK15CL7RGHA', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3704, 20, '50DVFJ0FNDVT2BVWO0', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3705, 20, '1VN0C6A52O45POFK1F', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3706, 20, 'DWRFWI6VSO3AD9K191', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3707, 20, 'GO9OKH4GJANPELE2BE', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3708, 20, 'ABFKVTDB9JF36POQ5O', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3709, 20, 'GNJHUCKOSEATN6O31K', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3710, 20, '0VN9UU470O4I0WUHKW', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3711, 20, 'DBW4PDEKAQCTE0EOHU', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3712, 20, '6JG0GHQS3LL2DDQTF8', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3713, 20, 'I7KWVR8KU4DN4RAFON', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3714, 20, '7M8UV0PQKULFC0HR7Q', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3715, 20, 'KFTQPPCS0D3KG5FFBS', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3716, 20, '3NBC9DDC4UP60OA69O', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3717, 20, 'T03KTKUF5BHBOK8VQ1', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3718, 20, '2OU8IAD5QUREOLIPQ7', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3719, 20, '8IHDCF4SGJFUDN2PMT', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3720, 20, '4KC385M2A8NIS53O3F', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3721, 20, '8V1952QOR5JO2CS271', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3722, 20, 'P1PLU933J4G1LVOOI2', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3723, 20, '728Q39KFMU38EMTONG', NULL, '0', NULL, NULL, NULL);
INSERT INTO `sms_coupon_code` VALUES (3724, 20, '0D14WAAEWAR22LT40D', NULL, '0', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for sms_coupon_fall
-- ----------------------------
DROP TABLE IF EXISTS `sms_coupon_fall`;
CREATE TABLE `sms_coupon_fall`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `coupon_id` bigint(20) NOT NULL COMMENT '优惠卷id',
  `price` decimal(20, 2) NOT NULL COMMENT '直降金额',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `coupon_id`(`coupon_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '优惠卷直降表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sms_coupon_full
-- ----------------------------
DROP TABLE IF EXISTS `sms_coupon_full`;
CREATE TABLE `sms_coupon_full`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `coupon_id` bigint(20) NOT NULL COMMENT '优惠卷id',
  `full_price` decimal(20, 2) NOT NULL COMMENT '满多少钱',
  `price` decimal(20, 2) NOT NULL COMMENT '减多少钱',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `coupon_id`(`coupon_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '优惠卷满减满折表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sms_coupon_full
-- ----------------------------
INSERT INTO `sms_coupon_full` VALUES (15, 20, 100.00, 5.00);

-- ----------------------------
-- Table structure for sms_crowdfunding_progress
-- ----------------------------
DROP TABLE IF EXISTS `sms_crowdfunding_progress`;
CREATE TABLE `sms_crowdfunding_progress`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
  `marketing_id` bigint(20) DEFAULT NULL COMMENT '众筹id  对应sms_marketing表中的id',
  `desc` varchar(2048) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '进度描述',
  `time` timestamp(0) DEFAULT NULL COMMENT '时间',
  `pic_url` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '图片地址',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '众筹进度表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Table structure for sms_home_advertise
-- ----------------------------
DROP TABLE IF EXISTS `sms_home_advertise`;
CREATE TABLE `sms_home_advertise`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `type` int(11) DEFAULT NULL COMMENT '轮播位置：0->PC首页轮播；1->app首页轮播',
  `pic` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `start_time` datetime(0) DEFAULT NULL,
  `end_time` datetime(0) DEFAULT NULL,
  `status` int(11) DEFAULT NULL COMMENT '上下线状态：0->下线；1->上线',
  `click_count` int(11) DEFAULT NULL COMMENT '点击数',
  `order_count` int(11) DEFAULT NULL COMMENT '下单数',
  `url` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '链接地址',
  `note` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT '备注',
  `sort` int(11) DEFAULT 0 COMMENT '排序',
  `store_id` int(11) NOT NULL DEFAULT 0 COMMENT '广告所属店铺',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 83 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '首页轮播广告表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sms_home_advertise
-- ----------------------------
INSERT INTO `sms_home_advertise` VALUES (13, '促销广告', 1, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200914-ae48ad36461e493db2628acb3fa30b94.', '2020-05-01 00:00:00', '2021-06-24 00:00:00', 0, 1, 1, '/pages/product/product?id=54', NULL, 99, 0);
INSERT INTO `sms_home_advertise` VALUES (24, '平台测试本地上传图片', 1, 'http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/images/20181113/car_ad.jpg', '2020-01-14 00:00:00', '2024-01-17 00:00:00', 0, 2, 2, '/pages/product/product?id=53', '1234', 1, 0);
INSERT INTO `sms_home_advertise` VALUES (26, '平台轮播阿里云测试', 2, 'http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/images/20181113/car_ad.jpg', '2020-01-14 00:00:00', '2024-01-18 00:00:00', 0, 3, 3, '/pages/product/product?id=44', '434', 54, 0);
INSERT INTO `sms_home_advertise` VALUES (30, '平台付费', 2, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-a55a087602064beea0b3e6c21b5e3a9b.', '2020-03-01 00:00:00', '2024-04-15 00:00:00', 0, 0, 4, '/pages/product/list?thirdCateId=38', NULL, 0, 0);
INSERT INTO `sms_home_advertise` VALUES (64, '商户罗伯特', 3, 'https://gdp.alicdn.com/imgextra/i4/1803112320/O1CN01intsjS1T0bTIwDIvZ_!!1803112320.jpg', '2020-08-24 00:00:00', '2022-08-19 00:00:00', 0, NULL, 1, '/pages/product/product?id=34', NULL, 0, 22);
INSERT INTO `sms_home_advertise` VALUES (65, '新品推荐', 2, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200831-e6feee6eb2d847e188d546c53525ba0b.', '2020-08-30 00:00:00', '2022-08-26 00:00:00', 0, NULL, 2, '/pages/user/coupon/list', NULL, 0, 22);
INSERT INTO `sms_home_advertise` VALUES (66, '32', 2, 'https://gdp.alicdn.com/imgextra/i3/1803112320/TB25C8MaTfN8KJjSZFjXXXGvpXa_!!1803112320.jpg', '2020-08-24 00:00:00', '2023-08-04 00:00:00', 0, NULL, 3, '/pages/product/list?thirdCateId=28', NULL, 0, 22);
INSERT INTO `sms_home_advertise` VALUES (67, '33', 2, 'https://gdp.alicdn.com/imgextra/i3/1803112320/TB2.OXLX7fb_uJkSnfoXXb_epXa_!!1803112320.jpg', '2020-08-24 00:00:00', '2022-08-12 00:00:00', 0, NULL, 4, '/pages/marketing/preMarking', NULL, 0, 22);
INSERT INTO `sms_home_advertise` VALUES (68, '33', 2, 'https://gdp.alicdn.com/imgextra/i4/1803112320/O1CN01HOriEF1T0bTExP0E3_!!1803112320.jpg', '2020-08-30 00:00:00', '2022-08-12 00:00:00', 0, NULL, 1, '/pages/set/article/detail?id=1', NULL, 0, 22);
INSERT INTO `sms_home_advertise` VALUES (70, '1', 3, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-7864c21bd7764c97909b438bbc3c38d0.', '2020-09-10 00:00:00', '2022-09-16 00:00:00', 0, NULL, 1, '/pages/product/product?id=42', NULL, 1, 25);
INSERT INTO `sms_home_advertise` VALUES (71, '2', 3, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-a55a087602064beea0b3e6c21b5e3a9b.', '2020-09-18 00:00:00', '2026-09-11 00:00:00', 0, NULL, 1, '/pages/product/list?thirdCateId=37', NULL, 2, 25);
INSERT INTO `sms_home_advertise` VALUES (72, '3', 3, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-6efe7fc59201459188888f9f71ed5769.', '2020-09-18 00:00:00', '2023-09-09 00:00:00', 0, NULL, 2, '/pages/product/list?firstCateId=21', '22', 2, 25);
INSERT INTO `sms_home_advertise` VALUES (75, '测试', 2, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1602294979774.jpg', '2020-10-10 00:00:00', '2020-10-11 00:00:00', 0, NULL, 1, '/pages/product/product?id=50', '测试', 23, 30);
INSERT INTO `sms_home_advertise` VALUES (77, 'uuuuuuuuuuuuu', 3, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/1603187026288.jpg', NULL, NULL, 0, NULL, 1, '/pages/product/product?id=50', NULL, 0, 30);
INSERT INTO `sms_home_advertise` VALUES (78, '伦伦', 1, '1604628298082.jpg', '2020-11-06 00:00:00', '2020-11-08 00:00:00', 0, NULL, 2, '/pages/product/product?id=42', NULL, 1, 25);
INSERT INTO `sms_home_advertise` VALUES (79, '平台测试本地上传图片', 1, 'http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/images/20181113/car_ad.jpg', '2020-01-14 00:00:00', '2024-01-17 00:00:00', 0, 2, 2, '/pages/product/product?id=55', '1234', 1, 30);
INSERT INTO `sms_home_advertise` VALUES (80, '平台轮播阿里云测试', 2, 'http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/images/20181113/car_ad.jpg', '2020-01-14 00:00:00', '2024-01-18 00:00:00', 0, 3, 3, '/pages/product/product?id=54', '434', 54, 30);
INSERT INTO `sms_home_advertise` VALUES (81, '平台付费', 2, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-a55a087602064beea0b3e6c21b5e3a9b.', '2020-03-01 00:00:00', '2024-04-15 00:00:00', 0, 0, 4, '/pages/list/list', NULL, 0, 30);
INSERT INTO `sms_home_advertise` VALUES (82, NULL, NULL, NULL, '2020-12-17 00:00:00', '2020-11-13 00:00:00', NULL, NULL, NULL, NULL, NULL, 0, 0);

-- ----------------------------
-- Table structure for sms_home_brand
-- ----------------------------
DROP TABLE IF EXISTS `sms_home_brand`;
CREATE TABLE `sms_home_brand`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `brand_id` bigint(20) DEFAULT NULL,
  `brand_name` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `recommend_status` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT 1 COMMENT '所属店铺',
  `logo` varchar(127) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 117 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '首页推荐品牌表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sms_home_brand
-- ----------------------------
INSERT INTO `sms_home_brand` VALUES (106, 3, '七匹狼', 1, 0, 0, NULL);
INSERT INTO `sms_home_brand` VALUES (107, 4, '西博会', 1, 0, 0, NULL);
INSERT INTO `sms_home_brand` VALUES (108, 6, '小米手机', 0, 0, 0, NULL);
INSERT INTO `sms_home_brand` VALUES (109, 7, '合雨', 1, 0, 0, NULL);
INSERT INTO `sms_home_brand` VALUES (110, 8, '耐克', 1, 0, 0, NULL);
INSERT INTO `sms_home_brand` VALUES (111, 3, '七匹狼', 0, 0, 25, NULL);
INSERT INTO `sms_home_brand` VALUES (112, 4, '西博会', 0, 0, 25, NULL);
INSERT INTO `sms_home_brand` VALUES (113, 6, '小米手机', 1, 0, 25, NULL);
INSERT INTO `sms_home_brand` VALUES (114, 8, '耐克', 1, 0, 25, NULL);
INSERT INTO `sms_home_brand` VALUES (115, 8, '耐克', 1, 0, 30, NULL);
INSERT INTO `sms_home_brand` VALUES (116, 3, '七匹狼', 1, 0, 30, NULL);

-- ----------------------------
-- Table structure for sms_home_new_product
-- ----------------------------
DROP TABLE IF EXISTS `sms_home_new_product`;
CREATE TABLE `sms_home_new_product`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) DEFAULT NULL,
  `product_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `recommend_status` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT 1 COMMENT '所属店铺',
  `price` decimal(10, 2) DEFAULT NULL,
  `pic` varchar(127) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 166 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '新鲜好物表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sms_home_new_product
-- ----------------------------
INSERT INTO `sms_home_new_product` VALUES (150, 41, '红米K30i 双模5G4800万旗舰拍照学生老年新品智能机30pro手机小米官方旗舰店10至尊', 0, 0, 25, 149.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-32790a8d138b4059b9d5fed76571707d.');
INSERT INTO `sms_home_new_product` VALUES (151, 40, '小米105g手机骁龙8651亿像素8K相机智能游戏小米官方旗舰店小米手机官网至尊', 1, 0, 25, 3999.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200919-ed98d27f13be42f2b8d4950945ffaea2.');
INSERT INTO `sms_home_new_product` VALUES (152, 46, '合雨珊瑚绒靠垫抱枕套办公室午睡靠枕汽车靠垫法莱绒法兰绒腰枕', 1, 0, 22, 155.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-3e8f6a0cee8748f99f40b134e890b286.');
INSERT INTO `sms_home_new_product` VALUES (153, 45, '珊瑚绒毯子加厚冬季学生宿舍铺床毛毯单人午睡夏空调毯法兰绒床单', 1, 0, 22, 80.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.');
INSERT INTO `sms_home_new_product` VALUES (157, 50, 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41', 1, 1, 30, 588.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.');
INSERT INTO `sms_home_new_product` VALUES (163, 43, '午睡空调毯斗篷珊瑚绒懒人毯子披肩披风单人办公室学生可穿小毛毯', 0, 0, 0, 59.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-f1f05eaa31a74247a3cbdfb259f4fbee.');
INSERT INTO `sms_home_new_product` VALUES (164, 44, '浴巾女可穿可裹巾吊带可爱比纯棉吸水速干不掉毛浴裙三件套ins 风', 0, 0, 0, 66.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-faffce094c1f4961926a1344f5b17691.');
INSERT INTO `sms_home_new_product` VALUES (165, 35, '平台秒杀商品', 1, 0, 0, 1010.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200901-236dc7279f154fb6b8334238d77490d1.');

-- ----------------------------
-- Table structure for sms_home_recommend_product
-- ----------------------------
DROP TABLE IF EXISTS `sms_home_recommend_product`;
CREATE TABLE `sms_home_recommend_product`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) DEFAULT NULL,
  `product_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `recommend_status` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT 1 COMMENT '所属店铺',
  `price` decimal(10, 2) DEFAULT NULL,
  `pic` varchar(127) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 140 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '人气推荐商品表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sms_home_recommend_product
-- ----------------------------
INSERT INTO `sms_home_recommend_product` VALUES (120, 45, '珊瑚绒毯子加厚冬季学生宿舍铺床毛毯单人午睡夏空调毯法兰绒床单', 0, 1, 0, 80.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200920-9a99ca2ac8a249a6a80b00ba12661ad0.');
INSERT INTO `sms_home_recommend_product` VALUES (124, 50, 'NIKE耐克男鞋 2020秋新款老爹鞋复古运动休闲耐磨减震跑步鞋AV4789-400 AV4789-101/M2K TEKNO 41', 1, 0, 30, 588.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200929-e64802b798c843aa87949a9478c0b957.');
INSERT INTO `sms_home_recommend_product` VALUES (125, 48, '耐克NIKE 男子 休闲鞋 气垫 AIR MAX 720 运动鞋 AO2924-008黑色41码', 1, 0, 30, 419.00, 'http://wskj-mallplus.oss-cn-beijing.aliyuncs.com/wskj-mallplus-20200921-adbc9ec4cfe244b3b4f7a08dc2ee607f.');
INSERT INTO `sms_home_recommen