/*
 Navicat Premium Data Transfer

 Source Server         : 51wangshi
 Source Server Type    : MySQL
 Source Server Version : 50719
 Source Host           : localhost:3306
 Source Schema         : mallplusbak

 Target Server Type    : MySQL
 Target Server Version : 50719
 File Encoding         : 65001

 Date: 27/07/2020 19:41:52
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table`  (
  `table_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '表名称',
  `table_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '表描述',
  `class_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '实体类名称',
  `tpl_category` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'crud' COMMENT '使用的模板（crud单表操作 tree树表操作）',
  `package_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成模块名',
  `business_name` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成业务名',
  `function_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成功能名',
  `function_author` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '生成功能作者',
  `options` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '其它生成选项',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  `remark` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`table_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 56 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '代码生成业务表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table
-- ----------------------------
INSERT INTO `gen_table` VALUES (2, 'pms_attention', '商品关注', 'PmsAttention', 'crud', 'com.ruoyi.goods', 'goods', 'attention', '商品关注', '魔金商城', '{}', 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34', NULL);
INSERT INTO `gen_table` VALUES (3, 'pms_attribute', '商品属性', 'PmsAttribute', 'crud', 'com.ruoyi.goods', 'goods', 'attribute', '商品属性', '魔金商城', '{}', 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03', NULL);
INSERT INTO `gen_table` VALUES (4, 'pms_attribute_value', '属性值表', 'PmsAttributeValue', 'crud', 'com.ruoyi.goods', 'goods', 'value', '属性值', '魔金商城', '{}', 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37', NULL);
INSERT INTO `gen_table` VALUES (5, 'pms_brand', '品牌表', 'PmsBrand', 'crud', 'com.ruoyi.goods', 'goods', 'brand', '品牌', '魔金商城', '{}', 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49', NULL);
INSERT INTO `gen_table` VALUES (6, 'pms_brand_apply', '品牌申请表', 'PmsBrandApply', 'crud', 'com.ruoyi.goods', 'goods', 'apply', '品牌申请', '魔金商城', '{}', 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12', NULL);
INSERT INTO `gen_table` VALUES (7, 'pms_category', '商品分类表', 'PmsCategory', 'crud', 'com.ruoyi.goods', 'goods', 'category', '商品分类', '魔金商城', NULL, 'admin', '2020-07-20 15:58:10', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (8, 'pms_category_spec', '分类和规格的关联表', 'PmsCategorySpec', 'crud', 'com.ruoyi.goods', 'goods', 'spec', '分类和规格的关联', '魔金商城', NULL, 'admin', '2020-07-20 15:58:11', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (9, 'pms_combination', '商品组合表', 'PmsCombination', 'crud', 'com.ruoyi.goods', 'goods', 'combination', '商品组合', '魔金商城', '{}', 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45', NULL);
INSERT INTO `gen_table` VALUES (10, 'pms_combination_sku', '商品组合下的单品表', 'PmsCombinationSku', 'crud', 'com.ruoyi.goods', 'goods', 'sku', '商品组合下的单品', '魔金商城', NULL, 'admin', '2020-07-20 15:58:11', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (11, 'pms_comment', '单品评论表', 'PmsComment', 'crud', 'com.ruoyi.goods', 'goods', 'comment', '单品评论', '魔金商城', '{}', 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51', NULL);
INSERT INTO `gen_table` VALUES (12, 'pms_comment_picture', '单品评论下的图片表', 'PmsCommentPicture', 'crud', 'com.ruoyi.goods', 'goods', 'picture', '单品评论下的图片', '魔金商城', NULL, 'admin', '2020-07-21 21:27:34', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (13, 'pms_comment_replay', '评论回复', 'PmsCommentReplay', 'crud', 'com.ruoyi.goods', 'goods', 'replay', '评论回复', '魔金商城', '{}', 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09', NULL);
INSERT INTO `gen_table` VALUES (14, 'pms_goods', '商品表', 'PmsGoods', 'crud', 'com.ruoyi.goods', 'goods', 'goods', '商品', '魔金商城', '{}', 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01', NULL);
INSERT INTO `gen_table` VALUES (15, 'pms_goods_attribute_value', '商品下面的属性值', 'PmsGoodsAttributeValue', 'crud', 'com.ruoyi.goods', 'goods', 'value', '商品下面的属性值', '魔金商城', '{}', 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59', NULL);
INSERT INTO `gen_table` VALUES (16, 'pms_goods_image', '商品的图片表', 'PmsGoodsImage', 'crud', 'com.ruoyi.goods', 'goods', 'image', '商品的图片', '魔金商城', NULL, 'admin', '2020-07-21 21:27:35', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (17, 'pms_goods_import', '商品导入表', 'PmsGoodsImport', 'crud', 'com.ruoyi.goods', 'goods', 'import', '商品导入', '魔金商城', NULL, 'admin', '2020-07-21 21:27:35', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (18, 'pms_goods_service_support', '商品和服务支持的关联表', 'PmsGoodsServiceSupport', 'crud', 'com.ruoyi.goods', 'goods', 'support', '商品和服务支持的关联', '魔金商城', '{}', 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:45:19', NULL);
INSERT INTO `gen_table` VALUES (19, 'pms_goods_spec_value', '商品和规格值的关联表', 'PmsGoodsSpecValue', 'crud', 'com.ruoyi.goods', 'goods', 'value', '商品和规格值的关联', '魔金商城', NULL, 'admin', '2020-07-21 21:27:35', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (20, 'pms_service_support', '服务支持表', 'PmsServiceSupport', 'crud', 'com.ruoyi.goods', 'goods', 'support', '服务支持', '魔金商城', '{}', 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00', NULL);
INSERT INTO `gen_table` VALUES (21, 'pms_shipping_method', '运费方式', 'PmsShippingMethod', 'crud', 'com.ruoyi.goods', 'goods', 'method', '运费方式', '魔金商城', '{}', 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27', NULL);
INSERT INTO `gen_table` VALUES (22, 'pms_shipping_method_area', '运费方式关联的区域', 'PmsShippingMethodArea', 'crud', 'com.ruoyi.goods', 'goods', 'area', '运费方式关联的区域', '魔金商城', NULL, 'admin', '2020-07-21 21:27:35', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (23, 'pms_shipping_method_freeship', '运费模版包邮', 'PmsShippingMethodFreeship', 'crud', 'com.ruoyi.goods', 'goods', 'freeship', '运费模版包邮', '魔金商城', NULL, 'admin', '2020-07-21 21:27:36', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (24, 'pms_shipping_method_freeship_area', '运费方式包邮关联的区域', 'PmsShippingMethodFreeshipArea', 'crud', 'com.ruoyi.goods', 'goods', 'area', '运费方式包邮关联的区域', '魔金商城', NULL, 'admin', '2020-07-21 21:27:36', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (25, 'pms_sku', '单品表', 'PmsSku', 'crud', 'com.ruoyi.goods', 'goods', 'sku', '单品', '魔金商城', '{}', 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00', NULL);
INSERT INTO `gen_table` VALUES (26, 'pms_sku_batch', '单品起批价格标', 'PmsSkuBatch', 'crud', 'com.ruoyi.goods', 'goods', 'batch', '单品起批价格标', '魔金商城', NULL, 'admin', '2020-07-21 21:27:36', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (27, 'pms_sku_image', '单品和图片的关联表', 'PmsSkuImage', 'crud', 'com.ruoyi.goods', 'goods', 'image', '单品和图片的关联', '魔金商城', NULL, 'admin', '2020-07-21 21:27:36', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (28, 'pms_sku_marketing', '单品和营销的关联表', 'PmsSkuMarketing', 'crud', 'com.ruoyi.goods', 'goods', 'marketing', '单品和营销的关联', '魔金商城', NULL, 'admin', '2020-07-21 21:27:36', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (29, 'pms_sku_member_price', '单品的会员价', 'PmsSkuMemberPrice', 'crud', 'com.ruoyi.goods', 'goods', 'price', '单品的会员价', '魔金商城', NULL, 'admin', '2020-07-21 21:27:37', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (30, 'pms_sku_spec_value', '单品的规格值表', 'PmsSkuSpecValue', 'crud', 'com.ruoyi.goods', 'goods', 'value', '单品的规格值', '魔金商城', NULL, 'admin', '2020-07-21 21:27:37', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (31, 'pms_spec', '规格表', 'PmsSpec', 'crud', 'com.ruoyi.goods', 'goods', 'spec', '规格', '魔金商城', NULL, 'admin', '2020-07-21 21:27:37', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (32, 'pms_spec_value', '规格值表', 'PmsSpecValue', 'crud', 'com.ruoyi.goods', 'goods', 'value', '规格值', '魔金商城', '{}', 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:08', NULL);
INSERT INTO `gen_table` VALUES (33, 'pms_type', '商品类型表', 'PmsType', 'crud', 'com.ruoyi.goods', 'goods', 'type', '商品类型', '魔金商城', '{}', 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35', NULL);
INSERT INTO `gen_table` VALUES (34, 'oms_back_order', '退单退款表', 'OmsBackOrder', 'crud', 'com.ruoyi.order', 'order', 'OmsBackOrder', '退单退款', '魔金商城', '{}', 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23', NULL);
INSERT INTO `gen_table` VALUES (35, 'oms_back_order_log', '退款退货操作日志', 'OmsBackOrderLog', 'crud', 'com.ruoyi.order', 'order', 'OmsBackOrderLog', '退款退货操作日志', '魔金商城', '{}', 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45', NULL);
INSERT INTO `gen_table` VALUES (36, 'oms_billing_records', '账单记录表', 'OmsBillingRecords', 'crud', 'com.ruoyi.order', 'order', 'OmsBillingRecords', '账单记录', '魔金商城', '{}', 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54', NULL);
INSERT INTO `gen_table` VALUES (37, 'oms_commission_records', '佣金记录表', 'OmsCommissionRecords', 'crud', 'com.ruoyi.order', 'order', 'OmsCommissionRecords', '佣金记录', '魔金商城', '{}', 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44', NULL);
INSERT INTO `gen_table` VALUES (38, 'oms_logistics_company', '物流公司表', 'OmsLogisticsCompany', 'crud', 'com.ruoyi.order', 'order', 'OmsLogisticsCompany', '物流公司', '魔金商城', '{}', 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29', NULL);
INSERT INTO `gen_table` VALUES (39, 'oms_logistics_company_use', '店铺使用的物流公司', 'OmsLogisticsCompanyUse', 'crud', 'com.ruoyi.order', 'order', 'OmsLogisticsCompanyUse', '店铺使用的物流公司', '魔金商城', NULL, 'admin', '2020-07-24 10:55:47', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (40, 'oms_logistics_template', '物流模版表', 'OmsLogisticsTemplate', 'crud', 'com.ruoyi.order', 'order', 'OmsLogisticsTemplate', '物流模版', '魔金商城', '{}', 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46', NULL);
INSERT INTO `gen_table` VALUES (41, 'oms_order', '订单表', 'OmsOrder', 'crud', 'com.ruoyi.order', 'order', 'OmsOrder', '订单', '魔金商城', '{}', 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15', NULL);
INSERT INTO `gen_table` VALUES (42, 'oms_order_attr', '订单属性表', 'OmsOrderAttr', 'crud', 'com.ruoyi.order', 'order', 'OmsOrderAttr', '订单属性', '魔金商城', '{}', 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10', NULL);
INSERT INTO `gen_table` VALUES (43, 'oms_order_operation_log', '订单操作日志', 'OmsOrderOperationLog', 'crud', 'com.ruoyi.order', 'order', 'OmsOrderOperationLog', '订单操作日志', '魔金商城', '{}', 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08', NULL);
INSERT INTO `gen_table` VALUES (44, 'oms_order_setting', '订单设置', 'OmsOrderSetting', 'crud', 'com.ruoyi.order', 'order', 'OmsOrderSetting', '订单设置', '魔金商城', NULL, 'admin', '2020-07-24 10:55:48', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (45, 'oms_order_sku', '订单单品表', 'OmsOrderSku', 'crud', 'com.ruoyi.order', 'order', 'OmsOrderSku', '订单单品', '魔金商城', NULL, 'admin', '2020-07-24 10:55:49', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (46, 'oms_shopping_cart', '购物车表', 'OmsShoppingCart', 'crud', 'com.ruoyi.order', 'order', 'OmsShoppingCart', '购物车', '魔金商城', NULL, 'admin', '2020-07-24 10:55:49', '', NULL, NULL);
INSERT INTO `gen_table` VALUES (47, 'oms_trans_records', '支付流水表', 'OmsTransRecords', 'crud', 'com.ruoyi.order', 'order', 'OmsTransRecords', '支付流水', '魔金商城', '{}', 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01', NULL);
INSERT INTO `gen_table` VALUES (48, 'ums_browse_record', '会员浏览记录', 'UmsBrowseRecord', 'crud', 'com.ruoyi.member', 'member', 'UmsBrowseRecord', '会员浏览记录', '魔金商城', '{}', 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10', NULL);
INSERT INTO `gen_table` VALUES (49, 'ums_member', '会员表', 'UmsMember', 'crud', 'com.ruoyi.member', 'member', 'UmsMember', '会员', '魔金商城', '{}', 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46', NULL);
INSERT INTO `gen_table` VALUES (50, 'ums_member_address', '用户收货地址', 'UmsMemberAddress', 'crud', 'com.ruoyi.member', 'member', 'UmsMemberAddress', '用户收货地址', '魔金商城', '{}', 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57', NULL);
INSERT INTO `gen_table` VALUES (51, 'ums_member_level', '会员等级表', 'UmsMemberLevel', 'crud', 'com.ruoyi.member', 'member', 'UmsMemberLevel', '会员等级', '魔金商城', '{}', 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36', NULL);
INSERT INTO `gen_table` VALUES (52, 'ums_member_panic_record', '用户抢购记录表', 'UmsMemberPanicRecord', 'crud', 'com.ruoyi.member', 'member', 'UmsMemberPanicRecord', '用户抢购记录', '魔金商城', '{}', 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04', NULL);
INSERT INTO `gen_table` VALUES (53, 'ums_member_point', '会员积分详情表', 'UmsMemberPoint', 'crud', 'com.ruoyi.member', 'member', 'UmsMemberPoint', '会员积分详情', '魔金商城', '{}', 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32', NULL);
INSERT INTO `gen_table` VALUES (54, 'ums_pre_deposit_record', '会员预存款记录表', 'UmsPreDepositRecord', 'crud', 'com.ruoyi.member', 'member', 'UmsPreDepositRecord', '会员预存款记录', '魔金商城', '{}', 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28', NULL);
INSERT INTO `gen_table` VALUES (55, 'ums_withdraw', '提现记录表', 'UmsWithdraw', 'crud', 'com.ruoyi.member', 'member', 'UmsWithdraw', '提现记录', '魔金商城', '{}', 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22', NULL);

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column`  (
  `column_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `table_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '归属表编号',
  `column_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列名称',
  `column_comment` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列描述',
  `column_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '列类型',
  `java_type` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否主键（1是）',
  `is_increment` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否自增（1是）',
  `is_required` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否必填（1是）',
  `is_insert` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否为插入字段（1是）',
  `is_edit` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否编辑字段（1是）',
  `is_list` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否列表字段（1是）',
  `is_query` char(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否查询字段（1是）',
  `query_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT 'EQ' COMMENT '查询方式（等于、不等于、大于、小于、范围）',
  `html_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '显示类型（文本框、文本域、下拉框、复选框、单选框、日期控件）',
  `dict_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '字典类型',
  `sort` int(11) NULL DEFAULT NULL COMMENT '排序',
  `create_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '创建者',
  `create_time` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  `update_by` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '更新者',
  `update_time` datetime(0) NULL DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`column_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 577 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '代码生成业务表字段' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------
INSERT INTO `gen_table_column` VALUES (16, '2', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (17, '2', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (18, '2', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (19, '2', 'sku_id', '单品id', 'varchar(20)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (20, '2', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (21, '2', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (22, '2', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 15:59:34');
INSERT INTO `gen_table_column` VALUES (23, '3', 'id', '主键id', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (24, '3', 'type_id', '商品属性关联的类型id 对应ls_type表中的id', 'bigint(20)', 'Long', 'typeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (25, '3', 'name', '属性名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (26, '3', 'sort', '排序 数值越小 排序越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (27, '3', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:03');
INSERT INTO `gen_table_column` VALUES (28, '4', 'id', '主键id', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (29, '4', 'attribute_id', '属性id', 'varchar(64)', 'String', 'attributeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (30, '4', 'type_id', '类型id', 'varchar(45)', 'String', 'typeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (31, '4', 'value', '属性值', 'varchar(45)', 'String', 'value', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (32, '4', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'bigint(20)', 'Long', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:00:37');
INSERT INTO `gen_table_column` VALUES (33, '5', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (34, '5', 'name', '品牌名称', 'varchar(128)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (35, '5', 'nick_name', '品牌别名', 'varchar(128)', 'String', 'nickName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (36, '5', 'url', '品牌的图片地址', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (37, '5', 'certificat_url', '证书图片', 'varchar(128)', 'String', 'certificatUrl', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (38, '5', 'store_id', '店铺id 平台的为0 ', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (39, '5', 'status', '状态  0 申请中  1通过 2 拒绝', 'varchar(45)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', 'audit_thress', 7, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (40, '5', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (41, '5', 'reason', '拒绝原因', 'varchar(45)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (42, '5', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 10, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (43, '5', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 11, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (44, '5', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 12, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (45, '5', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, '1', NULL, 'EQ', 'datetime', '', 13, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (46, '5', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 14, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (47, '5', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 15, 'admin', '2020-07-20 15:58:10', '', '2020-07-20 16:01:49');
INSERT INTO `gen_table_column` VALUES (48, '6', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (49, '6', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (50, '6', 'brand_id', '申请的品牌id', 'bigint(20)', 'Long', 'brandId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (51, '6', 'status', '申请状态 ', 'char(1)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'audit_thress', 4, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (52, '6', 'reason', '拒绝原因', 'varchar(1024)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 5, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (53, '6', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-20 15:58:10', '', '2020-07-21 21:29:12');
INSERT INTO `gen_table_column` VALUES (54, '7', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (55, '7', 'name', '分类名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (56, '7', 'parent_id', '父级分类id   没有父级 则为0', 'bigint(20)', 'Long', 'parentId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (57, '7', 'type_id', '类型id，只有分类是三级分类的时候才有 一级和二级分类没有', 'bigint(20)', 'Long', 'typeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (58, '7', 'grade', '分类的层级 1 一级 2 二级 3 三级', 'char(1)', 'String', 'grade', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (59, '7', 'rate', '分类扣率 三级分类的时候才有，主要是和店铺对账使用', 'decimal(3,2)', 'BigDecimal', 'rate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-20 15:58:10', '', NULL);
INSERT INTO `gen_table_column` VALUES (60, '7', 'sort', '排序  数值越低  排序越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (61, '7', 'del_flag', '删除标记  0未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (62, '7', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 9, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (63, '7', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 10, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (64, '7', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 11, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (65, '7', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 12, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (66, '7', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 13, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (67, '7', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 14, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (68, '8', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (69, '8', 'cate_id', '分类id  对应pms_category表中的id', 'bigint(20)', 'Long', 'cateId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (70, '8', 'spec_id', '规格id 对应pms_goods_spec 表中的id', 'bigint(20)', 'Long', 'specId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (71, '8', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (72, '9', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (73, '9', 'name', '商品组合名称', 'varchar(128)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (74, '9', 'store_id', '店铺id 平台的为0', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (75, '9', 'del_flag', '删除标记 0 未删除 1 已删除', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (76, '9', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (77, '9', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (78, '9', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:31:45');
INSERT INTO `gen_table_column` VALUES (79, '10', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (80, '10', 'combination_id', '商品组合id', 'bigint(20)', 'Long', 'combinationId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (81, '10', 'sku_id', '单品id', 'varchar(20)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:11', '', NULL);
INSERT INTO `gen_table_column` VALUES (82, '11', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (83, '11', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (84, '11', 'sku_id', '单品id', 'varchar(128)', 'String', 'skuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (85, '11', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (86, '11', 'order_id', '订单号', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (87, '11', 'is_anonymous', '是否匿名  0 否 1是  默认0 ', 'char(1)', 'String', 'isAnonymous', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', 'ye_no01', 6, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (88, '11', 'comment', '评论', 'varchar(2048)', 'String', 'comment', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 7, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (89, '11', 'score', '商品满意度评分1到5分', 'int(11)', 'Long', 'score', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (90, '11', 'has_pic', '是否有图片  0 没有 1 有 默认0 ', 'char(1)', 'String', 'hasPic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (91, '11', 'create_time', '评论创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (92, '11', 'is_show', '是否可见 0 可见 1 不可见 默认0 ', 'char(1)', 'String', 'isShow', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (93, '11', 'del_flag', '是否删除 0 未删除1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-20 15:58:11', '', '2020-07-24 08:36:51');
INSERT INTO `gen_table_column` VALUES (94, '12', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:34', '', NULL);
INSERT INTO `gen_table_column` VALUES (95, '12', 'comment_id', '评论id', 'bigint(20)', 'Long', 'commentId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:34', '', NULL);
INSERT INTO `gen_table_column` VALUES (96, '12', 'url', '图片地址', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:34', '', NULL);
INSERT INTO `gen_table_column` VALUES (97, '13', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (98, '13', 'comment_id', '评论id  对应pms_comment 表中的id', 'bigint(20)', 'Long', 'commentId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (99, '13', 'reply', '回复内容', 'varchar(2048)', 'String', 'reply', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 3, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (100, '13', 'is_show', '是否显示 0 显示 1 不显示 默认0 ', 'char(1)', 'String', 'isShow', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (101, '13', 'store_id', '店铺id 平台为0', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (102, '13', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:37:09');
INSERT INTO `gen_table_column` VALUES (103, '14', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (104, '14', 'name', '商品名称', 'varchar(256)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (105, '14', 'subtitle', '商品副标题', 'varchar(256)', 'String', 'subtitle', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (106, '14', 'price', '销售价', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (107, '14', 'pc_desc', 'PC版详情', 'text', 'String', 'pcDesc', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (108, '14', 'mobile_desc', '手机版详情', 'text', 'String', 'mobileDesc', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (109, '14', 'seo_title', 'seo标题', 'varchar(1024)', 'String', 'seoTitle', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 7, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (110, '14', 'seo_keywords', 'seo关键字', 'varchar(128)', 'String', 'seoKeywords', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (111, '14', 'seo_desc', 'see描述', 'varchar(1024)', 'String', 'seoDesc', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 9, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (112, '14', 'store_id', '商品的店铺id 如果是平台的则为0 ', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (113, '14', 'first_cate_id', '一级分类id', 'bigint(20)', 'Long', 'firstCateId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (114, '14', 'second_cate_id', '二级分类id', 'bigint(20)', 'Long', 'secondCateId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (115, '14', 'third_cate_id', '三级分类id', 'bigint(20)', 'Long', 'thirdCateId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 13, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (116, '14', 'type_id', '类型id', 'bigint(20)', 'Long', 'typeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (117, '14', 'brand_id', '品牌id', 'bigint(20)', 'Long', 'brandId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 15, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (118, '14', 'store_fcate_id', '店铺一级分类', 'bigint(20)', 'Long', 'storeFcateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (119, '14', 'store_scate_id', '店铺二级分类', 'bigint(20)', 'Long', 'storeScateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 17, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (120, '14', 'store_tcate_id', '店铺三级分类', 'bigint(20)', 'Long', 'storeTcateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 18, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (121, '14', 'url', '商品图片', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 19, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:01');
INSERT INTO `gen_table_column` VALUES (122, '14', 'del_flag', '删除标记   0未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 20, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (123, '14', 'create_name', '创建人的名称', 'varchar(64)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 21, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (124, '14', 'modify_name', '修改人的名称', 'varchar(64)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 22, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (125, '14', 'del_name', '删除人的名字', 'varchar(64)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 23, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (126, '14', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 24, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (127, '14', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 25, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (128, '14', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 26, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (129, '14', 'commission_rate', '佣金比例', 'decimal(3,2)', 'BigDecimal', 'commissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 27, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (130, '14', 's_commission_rate', '二级佣金比例', 'decimal(3,2)', 'BigDecimal', 'sCommissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 28, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (131, '14', 'status', '审核状态  0 审核通过 1 审核未通过 2 审核中', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'audit_thress', 29, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (132, '14', 'shelves_status', '商品上架状态 0 下架  1上架 2违规下架 默认0', 'char(1)', 'String', 'shelvesStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', 'goods_publish', 30, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (133, '14', 'is_virtual', '是否是虚拟商品 0 否 1 是默认0', 'char(1)', 'String', 'isVirtual', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'ye_no01', 31, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (134, '14', 'video', '商品视频地址', 'varchar(256)', 'String', 'video', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 32, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (135, '14', 'video_pic', '商品视频封面地址', 'varchar(256)', 'String', 'videoPic', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 33, 'admin', '2020-07-21 21:27:34', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (136, '14', 'logistics_template_id', '物流模版id 对应oms_logistics_template表的id', 'bigint(20)', 'Long', 'logisticsTemplateId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 34, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:51:02');
INSERT INTO `gen_table_column` VALUES (137, '15', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (138, '15', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (139, '15', 'attribute_id', '属性id', 'varchar(126)', 'String', 'attributeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (140, '15', 'attribute_name', '属性名称', 'varchar(126)', 'String', 'attributeName', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (141, '15', 'attribute_value_id', '属性值id', 'varchar(126)', 'String', 'attributeValueId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (142, '15', 'attribute_value', '属性值', 'varchar(126)', 'String', 'attributeValue', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (143, '15', 'del_flag', '删除标记 0 未删除 1删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:44:59');
INSERT INTO `gen_table_column` VALUES (144, '16', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (145, '16', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (146, '16', 'url', '图片地址', 'varchar(256)', 'String', 'url', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (147, '16', 'del_flag', '删除标记  0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (148, '17', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (149, '17', 'name', '商品名称', 'varchar(128)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (150, '17', 'sub_title', '商品副标题', 'varchar(128)', 'String', 'subTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (151, '17', 'price', '商品价格', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (152, '17', 'seo_title', 'see标题', 'varchar(1024)', 'String', 'seoTitle', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 5, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (153, '17', 'seo_keywords', 'seo关键字', 'varchar(512)', 'String', 'seoKeywords', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 6, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (154, '17', 'seo_desc', 'see描述', 'varchar(1024)', 'String', 'seoDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 7, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (155, '17', 'is_release', '是否发布 0 未发布 1 发布 默认0 ', 'char(1)', 'String', 'isRelease', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (156, '17', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (157, '18', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:45:19');
INSERT INTO `gen_table_column` VALUES (158, '18', 'spu_id', '商品id 对应pms_goods表中的id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:45:19');
INSERT INTO `gen_table_column` VALUES (159, '18', 'service_support_id', '服务支持id  对应ls_service_support中的id', 'bigint(20)', 'Long', 'serviceSupportId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:45:19');
INSERT INTO `gen_table_column` VALUES (160, '18', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:45:19');
INSERT INTO `gen_table_column` VALUES (161, '19', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (162, '19', 'spu_id', '商品id 对应pms_goods表中的id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (163, '19', 'spec_id', '规格id  对应pms_spec表中的id', 'bigint(20)', 'Long', 'specId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (164, '19', 'spec_value_id', '规格值id  对应pms_spec_value表中的id', 'varchar(64)', 'String', 'specValueId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (165, '19', 'url', '规格值的图片地址', 'varchar(256)', 'String', 'url', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (166, '19', 'value_remark', '规格值', 'varchar(128)', 'String', 'valueRemark', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (167, '19', 'del_flag', '删除标记  0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:35', '', NULL);
INSERT INTO `gen_table_column` VALUES (168, '20', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (169, '20', 'name', '服务支持的名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (170, '20', 'url', '服务支持的图片地址', 'varchar(128)', 'String', 'url', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (171, '20', 'del_flag', '删除标记  0 未删除 1删除  默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (172, '20', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 5, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (173, '20', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 6, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (174, '20', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 7, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (175, '20', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (176, '20', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (177, '20', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:00');
INSERT INTO `gen_table_column` VALUES (178, '21', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (179, '21', 'template_id', '运费模版id', 'bigint(20)', 'Long', 'templateId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (180, '21', 'first', '首件 或者 首重', 'int(11)', 'Long', 'first', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (181, '21', 'money', '首件或者首重的价格', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (182, '21', 'first_plu', '增加几件或者几克', 'int(11)', 'Long', 'firstPlu', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (183, '21', 'moeny_plu', '增加的钱', 'decimal(20,2)', 'BigDecimal', 'moenyPlu', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (184, '21', 'is_default', '是否默认  0 否 1 是 默认 0 ', 'char(1)', 'String', 'isDefault', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:35', '', '2020-07-24 08:46:27');
INSERT INTO `gen_table_column` VALUES (185, '22', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (186, '22', 'shipping_method_id', '运费方式id', 'bigint(20)', 'Long', 'shippingMethodId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (187, '22', 'template_id', '模版id', 'bigint(20)', 'Long', 'templateId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (188, '22', 'city_id', '市id', 'bigint(20)', 'Long', 'cityId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (189, '23', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (190, '23', 'template_id', '运费模版id', 'bigint(20)', 'Long', 'templateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (191, '23', 'type', '包邮类型 0 件数  1 金额', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (192, '23', 'num', '包邮件数', 'int(11)', 'Long', 'num', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (193, '23', 'money', '包邮的金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (194, '24', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (195, '24', 'shipping_method_freeship_id', '运费模版包邮id', 'bigint(20)', 'Long', 'shippingMethodFreeshipId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (196, '24', 'template_id', '运费模版id', 'bigint(20)', 'Long', 'templateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (197, '24', 'city_id', '市id', 'bigint(20)', 'Long', 'cityId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (198, '25', 'id', '主键id', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (199, '25', 'spu_id', '商品id ，对应pms_goods中的id', 'bigint(20)', 'Long', 'spuId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (200, '25', 'sku_no', '单品的编号', 'varchar(45)', 'String', 'skuNo', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (201, '25', 'name', '单品的名称', 'varchar(256)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (202, '25', 'subtitle', '单品的副标题', 'varchar(256)', 'String', 'subtitle', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (203, '25', 'stock', '单品库存', 'int(11)', 'Long', 'stock', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (204, '25', 'warning_stock', '预警库存', 'int(11)', 'Long', 'warningStock', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (205, '25', 'price', '单品价格', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (206, '25', 'weight', '单品的重量', 'decimal(20,2)', 'BigDecimal', 'weight', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (207, '25', 'store_id', '店铺id  如果是平台  则是0', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (208, '25', 'shelves_status', '单品上架状态 0 下架  1上架 2 违规下架 默认0', 'char(1)', 'String', 'shelvesStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', 'goods_publish', 11, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (209, '25', 'url', '默认图片的url', 'varchar(124)', 'String', 'url', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (210, '25', 'status', '审核状态  0 审核通过 1 审核未通过 2 审核中', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'audit_thress', 13, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (211, '25', 'reason', '拒绝原因', 'varchar(1024)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 14, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (212, '25', 'del_flag', '删除标记  0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'select', '', 15, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (213, '25', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 16, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (214, '25', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 17, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (215, '25', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 18, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (216, '25', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 19, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (217, '25', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 20, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (218, '25', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 21, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (219, '25', 'up_time', '单品上架时间', 'timestamp', 'Date', 'upTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 22, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (220, '25', 'commission_rate', '佣金比例  该字段是冗余字段，和商品表中的佣金比例是一个字断', 'decimal(3,2)', 'BigDecimal', 'commissionRate', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 23, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (221, '25', 's_commission_rate', '二级佣金比例  该字段是冗余字段，和商品表中的佣金比例是一个字断', 'decimal(3,2)', 'BigDecimal', 'sCommissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 24, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (222, '25', 'is_virtual', '是否是虚拟商品 0 否 1 是  默认0  该字段是商品冗余字段 和商品表保持一致', 'char(1)', 'String', 'isVirtual', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (223, '25', 'is_batch_sku', '是否批发商品 0否 1是 默认0', 'char(1)', 'String', 'isBatchSku', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 26, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (224, '25', 'logistics_template_id', '物流模版id  该字段是冗余字段和pms_goods表中的保持一致', 'bigint(20)', 'Long', 'logisticsTemplateId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 27, 'admin', '2020-07-21 21:27:36', '', '2020-07-24 08:49:00');
INSERT INTO `gen_table_column` VALUES (225, '26', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (226, '26', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (227, '26', 'sku_id', '单品id', 'bigint(20)', 'Long', 'skuId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (228, '26', 'batch_num', '起批量（前闭后开）', 'int(11)', 'Long', 'batchNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (229, '26', 'batch_price', '起批价格', 'decimal(20,2)', 'BigDecimal', 'batchPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (230, '26', 'del_flag', '删除标记 0未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (231, '27', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (232, '27', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (233, '27', 'sku_id', '单品id  对应pms_sku表中的id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (234, '27', 'url', '图片地址', 'varchar(256)', 'String', 'url', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (235, '27', 'default_flag', '默认图片标记  0 不是默认 1默认    默认为0', 'char(1)', 'String', 'defaultFlag', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (236, '27', 'del_flag', '删除标记  0未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:36', '', NULL);
INSERT INTO `gen_table_column` VALUES (237, '28', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (238, '28', 'skuid', '单品id', 'varchar(64)', 'String', 'skuid', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (239, '28', 'marketing_id', '营销id', 'bigint(20)', 'Long', 'marketingId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (240, '28', 'price', '促销价格 （在众筹的时候使用，众筹价格）', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (241, '29', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (242, '29', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (243, '29', 'sku_id', '单品id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (244, '29', 'member_level_id', '会员等级id', 'bigint(20)', 'Long', 'memberLevelId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (245, '29', 'price', '会员价格', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (246, '29', 'del_flag', '删除标记 0未删除1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (247, '30', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (248, '30', 'spu_id', '商品id', 'bigint(20)', 'Long', 'spuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (249, '30', 'sku_id', '单品id   对应pms_sku表中的id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (250, '30', 'spec_id', '规格id 对应pms_spec表中的id', 'bigint(20)', 'Long', 'specId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (251, '30', 'spec_value_id', '规格值id  对应pms_spec_value 表中的id', 'varchar(64)', 'String', 'specValueId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (252, '30', 'value_remark', '规格值', 'varchar(45)', 'String', 'valueRemark', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (253, '30', 'del_flag', '删除标记 0 未删除 1 删除  默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (254, '31', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (255, '31', 'name', '规格名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (256, '31', 'nick_name', '规格别名', 'varchar(45)', 'String', 'nickName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (257, '31', 'del_flag', '删除标记 0 未删除  1 删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (258, '31', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (259, '31', 'modify_name', '修改人', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (260, '31', 'del_name', '删除人名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (261, '31', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (262, '31', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (263, '31', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 10, 'admin', '2020-07-21 21:27:37', '', NULL);
INSERT INTO `gen_table_column` VALUES (264, '32', 'id', '主键id', 'varchar(64)', 'String', 'id', '1', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:08');
INSERT INTO `gen_table_column` VALUES (265, '32', 'spec_id', '规格id 对应pms_goods_spec表中的id', 'bigint(20)', 'Long', 'specId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (266, '32', 'name', '规格值的名称', 'varchar(128)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (267, '32', 'sort', '排序  数值越小排序越前', 'int(11)', 'Long', 'sort', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (268, '32', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (269, '32', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (270, '32', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 7, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (271, '32', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 8, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (272, '32', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (273, '32', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (274, '32', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 11, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:50:09');
INSERT INTO `gen_table_column` VALUES (275, '33', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (276, '33', 'name', '类型名称', 'varchar(128)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (277, '33', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', '1', '1', NULL, NULL, NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (278, '33', 'create_name', '创建者名称', 'varchar(45)', 'String', 'createName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 4, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (279, '33', 'modify_name', '修改者名称', 'varchar(45)', 'String', 'modifyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 5, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (280, '33', 'del_name', '删除者名称', 'varchar(45)', 'String', 'delName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 6, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (281, '33', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (282, '33', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (283, '33', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-21 21:27:37', '', '2020-07-24 08:49:35');
INSERT INTO `gen_table_column` VALUES (284, '34', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (285, '34', 'back_code', '退单号', 'varchar(128)', 'String', 'backCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (286, '34', 'order_id', '订单id 对应订单表 oms_order中的id', 'bigint(20)', 'Long', 'orderId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (287, '34', 'order_code', '订单号 对应oms_order 表中的order_code\n', 'varchar(128)', 'String', 'orderCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (288, '34', 'store_id', '店铺id 平台的为0 ', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (289, '34', 'customer_id', '用户id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (290, '34', 'skuId_nums', '退货的单品ID多个用,分开  退款的时候不需要，因为退款只能整单退\n1001-1,1002-3 表示单品id为1001 的单品退货1件 单品id为1002的单品退货3件 ', 'varchar(512)', 'String', 'skuidNums', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 7, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (291, '34', 'type', '1 退款 2 退货', 'char(1)', 'String', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'after_type', 8, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (292, '34', 'reason', '退款／退货原因\n1:不想买了\n2:收货人信息有误\n3:未按指定时间发货\n4:其他\n5:不想买了\n6:商品质量问题\n7:收到商品与描述不符\n8:其他\n9:系统自动申请\n', 'char(1)', 'String', 'reason', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (293, '34', 'desc', '问题说明', 'varchar(2048)', 'String', 'desc', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 10, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (294, '34', 'credential', '申请凭据 0 没有任何凭据 1 有发票 2有质检报告', 'char(1)', 'String', 'credential', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (295, '34', 'back_type', '返回方式 1 快递返回 目前只有快递返回 （退货的时候用户给商城寄送商品）', 'char(1)', 'String', 'backType', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 12, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (296, '34', 'back_price', '退款／退货金额', 'decimal(20,2)', 'BigDecimal', 'backPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 13, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (297, '34', 'real_back_price', '退货时候实际退款金额', 'decimal(20,2)', 'BigDecimal', 'realBackPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (298, '34', 'pics', '上传的退款凭证或者质检发票 多个图片 用, 隔开', 'varchar(2048)', 'String', 'pics', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 15, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (299, '34', 'status', '退款／退货状态  \n1:退款申请 （用户发送退款请求）\n2:退款成功（商家同意退款）\n3:退款拒绝 （商家拒绝退款）\n4:退货申请 （用户发起退货请求）\n5:退货拒绝   （商家拒绝退货）\n6:退货审核通过等待用户填写物流（商家审核通过，等待用户寄回商品）\n7: 待收货  （用户已经寄回商品，等待商家收货确认）\n8：退货完成（商家收货并且同意退款给用户）\n9:退货失败（商家不同意退款）', 'char(1)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'afterSaleStatus', 16, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (300, '34', 'predeposit_pay', '是否预存款支付  0 否 1 是  默认0', 'char(1)', 'String', 'predepositPay', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 17, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (301, '34', 'logis_company_name', '物流公司名称', 'varchar(45)', 'String', 'logisCompanyName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 18, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (302, '34', 'waybill_code', '物流单号', 'varchar(128)', 'String', 'waybillCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 19, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:23');
INSERT INTO `gen_table_column` VALUES (303, '34', 'create_time', '生成时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 20, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 15:31:24');
INSERT INTO `gen_table_column` VALUES (304, '35', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (305, '35', 'back_order_id', '退单id 对应oms_back_order表中的id', 'bigint(20)', 'Long', 'backOrderId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (306, '35', 'operation_type', '操作人类型 1 用户  2 商家\n', 'char(1)', 'String', 'operationType', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'operate_type', 3, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (307, '35', 'message', '留言', 'varchar(1024)', 'String', 'message', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 4, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (308, '35', 'status', '1:退款申请 （用户发送退款请求）\n2:退款成功（商家同意退款）\n3:退款拒绝 （商家拒绝退款）\n4:退货申请 （用户发起退货请求）\n5:退货拒绝   （商家拒绝退货）\n6:退货审核通过等待用户填写物流（商家审核通过，等待用户寄回商品）\n7: 待收货  （用户已经寄回商品，等待商家收货确认）\n8：退货完成（商家收货并且同意退款给用户）\n9:退货失败（商家不同意退款）', 'char(1)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'afterSaleStatus', 5, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (309, '35', 'create_time', '生成时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:02:45');
INSERT INTO `gen_table_column` VALUES (310, '36', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (311, '36', 'order_code', '订单或者退单的code', 'varchar(45)', 'String', 'orderCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (312, '36', 'type', '账单进出类型 0 进 1 出', 'char(1)', 'String', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'bill_type', 3, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (313, '36', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (314, '36', 'store_name', '店铺名称', 'varchar(45)', 'String', 'storeName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (315, '36', 'record_type', '账单记录类型 1 确认收货 2 退款订单 3 退货订单佣金  4 订单关闭（只支付定金） 5 推广订单提成 6 退货订单', 'char(1)', 'String', 'recordType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'bill_records_type', 6, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (316, '36', 'order_price', '订单实付金额', 'decimal(20,2)', 'BigDecimal', 'orderPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (317, '36', 'order_back_price', '订单实退金额', 'decimal(20,2)', 'BigDecimal', 'orderBackPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-24 10:55:46', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (318, '36', 'order_commission', '订单佣金', 'decimal(20,2)', 'BigDecimal', 'orderCommission', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (319, '36', 'order_actual_price', '订单实际进出金额', 'decimal(20,2)', 'BigDecimal', 'orderActualPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (320, '36', 'create_time', '记录生成时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 11, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (321, '36', 'status', '结算状态 0 未结算 1 已结算 默认0 ', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'jiesuan_type', 12, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:08:54');
INSERT INTO `gen_table_column` VALUES (322, '37', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (323, '37', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (324, '37', 'money', '金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (325, '37', 'type', '类型  0 收入 1 支出', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (326, '37', 'remark', '备注', 'varchar(256)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (327, '37', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:44');
INSERT INTO `gen_table_column` VALUES (328, '38', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (329, '38', 'name', '物流公司名称', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (330, '38', 'code', '物流公司代码', 'varchar(45)', 'String', 'code', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (331, '38', 'del_flag', '删除标记  0未删除 1 删除  默认0	', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (332, '38', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (333, '38', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 6, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (334, '38', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 7, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:29');
INSERT INTO `gen_table_column` VALUES (335, '39', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', NULL);
INSERT INTO `gen_table_column` VALUES (336, '39', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', NULL);
INSERT INTO `gen_table_column` VALUES (337, '39', 'company_id', '店铺使用的物流公司 id ', 'bigint(20)', 'Long', 'companyId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', NULL);
INSERT INTO `gen_table_column` VALUES (338, '40', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (339, '40', 'name', '物流模版名称', 'varchar(45)', 'String', 'name', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (340, '40', 'is_default', '是否默认模版 0 是 1 否 默认1 ', 'char(1)', 'String', 'isDefault', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (341, '40', 'freight_bear', '谁承担运费 0 买家 1 商家 默认 0 买家', 'char(1)', 'String', 'freightBear', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'fright_price', 4, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (342, '40', 'pricint_method', '计价方式 0 按件  1 按重量  默认0 ', 'char(1)', 'String', 'pricintMethod', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'fright_ways', 5, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (343, '40', 'store_id', '店铺id  平台的为 0 ', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (344, '40', 'del_flag', '删除标记 0 未删除 1 删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:46');
INSERT INTO `gen_table_column` VALUES (345, '40', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:47');
INSERT INTO `gen_table_column` VALUES (346, '40', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:47');
INSERT INTO `gen_table_column` VALUES (347, '40', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 10, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:12:47');
INSERT INTO `gen_table_column` VALUES (348, '41', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (349, '41', 'order_code', '订单code', 'varchar(45)', 'String', 'orderCode', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (350, '41', 'master_order_code', '主订单code  下单可能会同时下多个订单 ，一个master_order_code 可以对应多个order_code 即多个订单', 'varchar(45)', 'String', 'masterOrderCode', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (351, '41', 'customer_id', '订单所属的会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (352, '41', 'price', '订单的最终价格(订单的最终成交价格)', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (353, '41', 'presale_price', '预售需要支付的金额 （预售订单使用）', 'decimal(20,2)', 'BigDecimal', 'presalePrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (354, '41', 'original_price', '订单原始金额（每个单品详情页面的总价）', 'decimal(20,2)', 'BigDecimal', 'originalPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (355, '41', 'freight_price', '运费', 'decimal(20,2)', 'BigDecimal', 'freightPrice', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (356, '41', 'modify_price', '订单修改的金额（后端管理员修改）', 'decimal(20,2)', 'BigDecimal', 'modifyPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (357, '41', 'point_price', '积分抵消的金额', 'decimal(20,2)', 'BigDecimal', 'pointPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (358, '41', 'coupon_price', '优惠卷抵消的价格', 'decimal(20,2)', 'BigDecimal', 'couponPrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (359, '41', 'red_envelope_price', '使用红包减去的价格', 'decimal(20,2)', 'BigDecimal', 'redEnvelopePrice', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (360, '41', 'concessional_rate', '总的优惠价（包含订单使用的优惠卷 积分 红包 ,满减满折的价格）', 'decimal(20,2)', 'BigDecimal', 'concessionalRate', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 13, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (361, '41', 'status', '1:待付款  （用户刚下单）\r2:代发货  （用户付完款 等待商城发货）\r3:代收货  （商城已经发货 等待用户确认收货）\r4:已完成  （用户已经确认收货 订单结束）\r5:取消订单 （用户未付款前取消订单）\r6:退款通过  （用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款）\r7:退货通过   （用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品）\r\n', 'char(2)', 'String', 'status', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'order_status', 14, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (362, '41', 'presale_status', '预售订单状态   普通订单 该状态没作用\n0 第一阶段未支付\n1 第一阶段已支付第二阶段未支付\n2 第二阶段已支付   默认0 ', 'char(1)', 'String', 'presaleStatus', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'pre_sale_status', 15, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (363, '41', 'evaluation_status', '评价状态  0 未评价 1 已评价  默认为0 未评价', 'char(1)', 'String', 'evaluationStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', '', 16, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (364, '41', 'red_envelope_code', '使用红包的code', 'varchar(64)', 'String', 'redEnvelopeCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 17, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (365, '41', 'coupon_no', '使用的优惠卷的卷码', 'varchar(64)', 'String', 'couponNo', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 18, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (366, '41', 'use_point', '使用的积分数量', 'int(11)', 'Long', 'usePoint', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 19, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (367, '41', 'pay_type', '支付类型  0在线支付  1货到付款 ', 'char(1)', 'String', 'payType', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'select', 'pay_type', 20, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (368, '41', 'store_id', '订单店铺id  平台的订单id为0', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 21, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (369, '41', 'cancel_reson', '订单取消原因\n1:现在不想买\n2:商品价格较贵\n3:价格波动\n4:商品缺货\n5:重复下单\n6:收货人信息有误\n7:发票信息有误/发票未开\n8:送货时间过长\n9:其他原因\n0:系统取消', 'char(1)', 'String', 'cancelReson', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 22, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (370, '41', 'predeposit_pay', '是否预存款支付  0 否 1 是  默认0', 'char(1)', 'String', 'predepositPay', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 23, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (371, '41', 'source', '订单来源 1pc  2 h5   3 app', 'char(1)', 'String', 'source', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'order_source', 24, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (372, '41', 'waybill_code', '运单号', 'varchar(45)', 'String', 'waybillCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 25, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (373, '41', 'order_type', '订单类型 0 普通订单 1 定金预售订单 2全款预售订单 3 拼团订单 4 众筹全款 5 众筹1元 6 众筹无回报 7 虚拟商品订单 8 社区团购订单 默认0 普通订单', 'char(1)', 'String', 'orderType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'order_type', 26, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (374, '41', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 27, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (375, '41', 'pay_time', '支付时间', 'timestamp', 'Date', 'payTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 28, 'admin', '2020-07-24 10:55:47', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (376, '41', 'delivery_time', '发货时间', 'timestamp', 'Date', 'deliveryTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 29, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (377, '41', 'receiving_time', '确认收货时间', 'timestamp', 'Date', 'receivingTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 30, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (378, '41', 'cancel_time', '订单取消时间', 'timestamp', 'Date', 'cancelTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 31, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (379, '41', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 32, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (380, '41', 'evaluation_time', '订单评价时间', 'timestamp', 'Date', 'evaluationTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 33, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (381, '41', 'presale_time', '预售订单的时间\n对于定金预售 则是第二阶段付款时间 和发货时间 对于全款预售 则是发货时间', 'timestamp', 'Date', 'presaleTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 34, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (382, '41', 'group_head', '是否团长  0 是 1 否  当订单为拼团订单的时候有用', 'char(1)', 'String', 'groupHead', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 35, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (383, '41', 'group_id', '拼团订单的id  拼团订单的时候有用', 'varchar(45)', 'String', 'groupId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 36, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (384, '41', 'group_marketing_id', '拼团订单的促销id 拼团订单的时候有用', 'bigint(20)', 'Long', 'groupMarketingId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 37, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (385, '41', 'group_sku_id', '拼团的单品id （拼团订单时候有效）', 'varchar(64)', 'String', 'groupSkuId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 38, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (386, '41', 'group_status', '拼团状态 -1无状态 0未成团 1已成团 默认-1 ', 'char(2)', 'String', 'groupStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', '', 39, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (387, '41', 'group_num', '成团的数量', 'int(11)', 'Long', 'groupNum', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 40, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (388, '41', 'open_group_time', '开团时间', 'datetime', 'Date', 'openGroupTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 41, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (389, '41', 'auto_handle_status', '拼团订单定时任务处理状态 \'0\'未处理 \'1\'已处理 默认\'0\'', 'char(1)', 'String', 'autoHandleStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', '', 42, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (390, '41', 'recommended', '订单推广人的会员id(订单会员的推广人 ，也就是订单会员的上级的id) 如果为-1 则说明该订单会员没有推荐人或者不是推广订单', 'bigint(20)', 'Long', 'recommended', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 43, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (391, '41', 's_recommended', '订单二级推广人的会员id(订单会员的二级推广人 ，也就是订单会员的上级的上级会员id) 如果为-1 则说明该订单会员没有推荐人或者不是推广订单', 'bigint(20)', 'Long', 'sRecommended', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 44, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (392, '41', 'crowdfunding_id', '众筹id  对应ls_markeing 表中的id', 'bigint(20)', 'Long', 'crowdfundingId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 45, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (393, '41', 'lottery_status', '抽奖状态  0 待抽奖 1 抽中 默认0', 'char(1)', 'String', 'lotteryStatus', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'radio', '', 46, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (394, '41', 'write_off_code', '虚拟订单的核销码', 'varchar(10)', 'String', 'writeOffCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 47, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (395, '41', 'community_buy_customer_id', '社区团购的团长会员id  社区团购的时候使用 对应ums_member表中的id', 'int(11)', 'Long', 'communityBuyCustomerId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 48, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (396, '41', 'community_buy_id', '社区团购的团购id  对应s_community_buy 表中的id ', 'int(11)', 'Long', 'communityBuyId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 49, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (397, '41', 'profit', '社区团购的利润，社区团购的时候使用', 'decimal(20,2)', 'BigDecimal', 'profit', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 50, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:15');
INSERT INTO `gen_table_column` VALUES (398, '41', 'community_name', '小区名称 社区团购使用', 'varchar(64)', 'String', 'communityName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 51, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:16');
INSERT INTO `gen_table_column` VALUES (399, '41', 'community_buy_name', '社区团购名称', 'varchar(64)', 'String', 'communityBuyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 52, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:16');
INSERT INTO `gen_table_column` VALUES (400, '41', 'logistics_company', '物流公司名称', 'varchar(64)', 'String', 'logisticsCompany', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 53, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:16');
INSERT INTO `gen_table_column` VALUES (401, '41', 'logistics_code', '物流公司code', 'varchar(64)', 'String', 'logisticsCode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 54, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:07:16');
INSERT INTO `gen_table_column` VALUES (402, '42', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (403, '42', 'order_id', '订单id  对应oms_order 表中的order_code', 'bigint(20)', 'Long', 'orderId', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (404, '42', 'receipt_name', '收货人姓名', 'varchar(45)', 'String', 'receiptName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (405, '42', 'receipt_address', '收货人的地址 （省＋市＋区）', 'varchar(128)', 'String', 'receiptAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (406, '42', 'receipt_detail_address', '收货人的详细地址', 'varchar(128)', 'String', 'receiptDetailAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (407, '42', 'receipt_mobile', '收货人的手机号码', 'varchar(11)', 'String', 'receiptMobile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (408, '42', 'receipt_phone', '收货人的固定电话', 'varchar(20)', 'String', 'receiptPhone', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (409, '42', 'receipt_zip_code', '收货人的邮编', 'varchar(10)', 'String', 'receiptZipCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (410, '42', 'invoice_type', '发票类型  0 不需要发票 1增值税普票 2增值税专票 默认0', 'char(1)', 'String', 'invoiceType', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 9, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (411, '42', 'invoice_title', '发票抬头', 'varchar(45)', 'String', 'invoiceTitle', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (412, '42', 'invoice_content', '发票内容 \n1:非图书商品\n2:明细\n3:耗材\n4:办公用品', 'char(1)', 'String', 'invoiceContent', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (413, '42', 'invoice_taxid', '税号', 'varchar(45)', 'String', 'invoiceTaxid', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 12, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (414, '42', 'remark', '订单备注', 'varchar(2048)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 13, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (415, '42', 'gift_infos', '订单的赠品信息格式为\n[\n    {\n        \"num\": 1,\n        \"skuId\": \"15096899899251410\",\n        \"skuName\": \"平台商品(规格5)\",\n        \"skuNo\": \"201711031419380\",\n        \"specs\": \"版本:规格5|\",\n        \"url\": \"http://ruoyi.b0.upaiyun.com/1509689972311.jpg\"\n    }\n]', 'varchar(2048)', 'String', 'giftInfos', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 14, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (416, '42', 'donation_message', '捐赠寄语', 'varchar(2048)', 'String', 'donationMessage', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 15, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (417, '42', 'invoice_company_name', '单位名称', 'varchar(64)', 'String', 'invoiceCompanyName', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 16, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (418, '42', 'invoice_register_address', '注册地址', 'varchar(128)', 'String', 'invoiceRegisterAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 17, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (419, '42', 'invoice_register_mobile', '注册电话', 'varchar(15)', 'String', 'invoiceRegisterMobile', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 18, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (420, '42', 'invoice_open_bank', '开户银行', 'varchar(64)', 'String', 'invoiceOpenBank', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 19, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (421, '42', 'invoice_bank_account', '银行账户', 'varchar(64)', 'String', 'invoiceBankAccount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 20, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (422, '42', 'invoice_title_type', '抬头类型  1 企业  2 个人 ', 'char(1)', 'String', 'invoiceTitleType', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 21, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (423, '42', 'delivery_time', '送达时间 社区团购使用', 'timestamp', 'Date', 'deliveryTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 22, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (424, '42', 'address', '所在地区 省+市+区 社区团购使用', 'varchar(32)', 'String', 'address', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 23, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (425, '42', 'detail_address', '详细信息 取货小区 社区团购使用', 'varchar(32)', 'String', 'detailAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 24, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (426, '42', 'pick_up_address', '提货点 社区团购使用', 'varchar(32)', 'String', 'pickUpAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 25, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (427, '42', 'delivery_type', '提货方式 1 团长送货上门 2 自提', 'char(1)', 'String', 'deliveryType', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 26, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (428, '42', 'house_number', '门牌号 社区团购使用', 'varchar(16)', 'String', 'houseNumber', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 27, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 12:16:10');
INSERT INTO `gen_table_column` VALUES (429, '43', 'id', '主键id', 'int(11)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (430, '43', 'order_id', '订单id 对应oms_order 表中的id', 'bigint(20)', 'Long', 'orderId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (431, '43', 'type', '操作类型 1 确认付款 2 修改金额 3 发货  4取消订单 5修改物流单号 6 核销虚拟商品订单', 'char(1)', 'String', 'type', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'select', 'order_operate_type', 3, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (432, '43', 'remark', '说明', 'varchar(1024)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 4, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (433, '43', 'operation_name', '操作人', 'varchar(128)', 'String', 'operationName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 5, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (434, '43', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 6, 'admin', '2020-07-24 10:55:48', '', '2020-07-24 14:15:08');
INSERT INTO `gen_table_column` VALUES (435, '44', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (436, '44', 'allow_back', '是否可以退款和退货  0 可以 1 不可以 默认0 ', 'char(1)', 'String', 'allowBack', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (437, '44', 'aotu_confirm', '订单自定收货几天前的订单 默认1', 'int(11)', 'Long', 'aotuConfirm', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (438, '44', 'refunds_desc', '退款说明', 'text', 'String', 'refundsDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:48', '', NULL);
INSERT INTO `gen_table_column` VALUES (439, '44', 'return_desc', '退货说明', 'text', 'String', 'returnDesc', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (440, '44', 'cashon_delivery', '是否支持货到付款  0 支付 1 不支持 默认0 ', 'char(1)', 'String', 'cashonDelivery', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (441, '45', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (442, '45', 'order_id', '订单id  对应oms_order表中的order_code', 'bigint(20)', 'Long', 'orderId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (443, '45', 'sku_id', '单品id 对应pms_sku 表中的id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (444, '45', 'num', '购买的数量', 'int(11)', 'Long', 'num', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (445, '45', 'price', '单品的最终价格（原价－优惠价）', 'decimal(20,2)', 'BigDecimal', 'price', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (446, '45', 'sku_price', '单品的价格(详情页的价格)', 'decimal(20,2)', 'BigDecimal', 'skuPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (447, '45', 'sku_name', '单品的名称', 'varchar(128)', 'String', 'skuName', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (448, '45', 'sku_no', '单品的编号', 'varchar(45)', 'String', 'skuNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (449, '45', 'sku_image', '单品的图片', 'varchar(128)', 'String', 'skuImage', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 9, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (450, '45', 'sku_specs', '单品的规格', 'varchar(256)', 'String', 'skuSpecs', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 10, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (451, '45', 'price_detail', '使用各个优惠减去的价格（这个字段为了方便扩展使用的是json格式）', 'varchar(1024)', 'String', 'priceDetail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'textarea', '', 11, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (452, '45', 'commission_rate', '单品的分拥比例 0 表示不分佣金', 'decimal(3,2)', 'BigDecimal', 'commissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (453, '45', 's_commission_rate', '单品的分拥比例 0 表示不分佣金', 'decimal(3,2)', 'BigDecimal', 'sCommissionRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (454, '45', 'cate_rate', '分类扣率', 'decimal(3,2)', 'BigDecimal', 'cateRate', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 14, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (455, '45', 'old_price', '单品的原价格（社区团购的时候使用）', 'decimal(20,2)', 'BigDecimal', 'oldPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 15, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (456, '45', 'supply_price', '供货价格（社区团购使用）', 'decimal(20,2)', 'BigDecimal', 'supplyPrice', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 16, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (457, '46', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (458, '46', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (459, '46', 'sku_id', '单品id', 'varchar(64)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (460, '46', 'store_id', '店铺id', 'bigint(20)', 'Long', 'storeId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (461, '46', 'num', '单品数量', 'int(11)', 'Long', 'num', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (462, '46', 'marketing_id', '默认的营销id(满减或者满折)', 'bigint(20)', 'Long', 'marketingId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (463, '46', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (464, '46', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-24 10:55:49', '', NULL);
INSERT INTO `gen_table_column` VALUES (465, '47', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (466, '47', 'ls_trans_code', '系统内部订单id', 'varchar(64)', 'String', 'lsTransCode', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (467, '47', 'trans_code', '外部系统交易流水号', 'varchar(64)', 'String', 'transCode', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (468, '47', 'type', '类型 1 门店订单 2 订单 3 预存款', 'char(50)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'pay_trans_type', 4, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (469, '47', 'money', '交易金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (470, '47', 'order_id', '订单id', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (471, '47', 'channel', '支付方式', 'varchar(32)', 'String', 'channel', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (472, '47', 'create_time', '订单创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (473, '47', 'pay_time', '支付时间', 'timestamp', 'Date', 'payTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-24 10:55:49', '', '2020-07-24 14:14:01');
INSERT INTO `gen_table_column` VALUES (474, '48', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (475, '48', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (476, '48', 'sku_id', '单品id', 'varchar(20)', 'String', 'skuId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (477, '48', 'del_flag', '删除标记  0 未删除 1 删除', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 4, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (478, '48', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 5, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 08:40:10');
INSERT INTO `gen_table_column` VALUES (479, '49', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (480, '49', 'username', '用户名', 'varchar(45)', 'String', 'username', '0', '0', '1', '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (481, '49', 'password', '用户密码', 'varchar(256)', 'String', 'password', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (482, '49', 'nickname', '昵称', 'varchar(45)', 'String', 'nickname', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 4, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (483, '49', 'image', '头像地址', 'varchar(128)', 'String', 'image', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (484, '49', 'relename', '真实姓名', 'varchar(45)', 'String', 'relename', '0', '0', NULL, '1', '1', '1', NULL, 'LIKE', 'input', '', 6, 'admin', '2020-07-25 08:31:56', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (485, '49', 'cardid', '身份证', 'varchar(32)', 'String', 'cardid', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (486, '49', 'gender', '性别  0 保密 1男 2女 默认0', 'char(1)', 'String', 'gender', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (487, '49', 'birthday', '生日', 'date', 'Date', 'birthday', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (488, '49', 'monthly_income', '月收入  0 无收入 1 2000以下 2 2000-3999 3 4000-5999\n4 6000－7999  5 8000以上', 'char(1)', 'String', 'monthlyIncome', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (489, '49', 'marriage_status', '婚姻状况  0 保密 1未婚 2 已婚 默认0 保姆', 'char(1)', 'String', 'marriageStatus', '0', '0', '1', '1', '1', '1', NULL, 'EQ', 'radio', '', 11, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (490, '49', 'mobile', '手机号码', 'varchar(45)', 'String', 'mobile', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (491, '49', 'email', '邮箱地址', 'varchar(32)', 'String', 'email', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 13, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (492, '49', 'modified_email', '更改中的邮箱（绑定新邮箱使用）', 'varchar(255)', 'String', 'modifiedEmail', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 14, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (493, '49', 'check_code', '校验码（绑定新邮箱时使用）', 'varchar(255)', 'String', 'checkCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 15, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (494, '49', 'province', '省', 'bigint(20)', 'Long', 'province', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 16, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (495, '49', 'city', '市', 'bigint(20)', 'Long', 'city', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 17, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (496, '49', 'county', '区', 'bigint(20)', 'Long', 'county', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 18, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (497, '49', 'detailaddress', '详细地址', 'varchar(128)', 'String', 'detailaddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 19, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (498, '49', 'interest', '兴趣爱好', 'varchar(2048)', 'String', 'interest', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'textarea', '', 20, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (499, '49', 'store_id', '店铺id  平台的为0  默认为平台', 'bigint(20)', 'Long', 'storeId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 21, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (500, '49', 'type', '1 普通用户 2 商家店铺用户 3 店铺员工', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'select', '', 22, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (501, '49', 'consumption_amount', '总的消费金额', 'decimal(20,2)', 'BigDecimal', 'consumptionAmount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 23, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (502, '49', 'paypassword', '预存款支付密码', 'varchar(256)', 'String', 'paypassword', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 24, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (503, '49', 'source', '用户注册来源 1 pc  2app  3 手机h5 4 管理员后台新增\n', 'char(1)', 'String', 'source', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 25, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (504, '49', 'status', '用户状态 1 正常 2 冻结  3 未启用 默认1 ', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'radio', '', 26, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (505, '49', 'sign_num', '会员签到次数', 'int(11)', 'Long', 'signNum', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 27, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (506, '49', 'is_mobile_verification', '手机是否验证  0 否 1 验证 默认0 ', 'char(1)', 'String', 'isMobileVerification', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 28, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (507, '49', 'is_email_verification', '邮箱是否验证   0 否 1 验证  默认0  ', 'char(1)', 'String', 'isEmailVerification', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 29, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (508, '49', 'login_error_count', '错误登录的次数', 'int(11)', 'Long', 'loginErrorCount', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 30, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (509, '49', 'del_flag', '删除标记 0 未删除 1删除 默认0 ', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 31, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (510, '49', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 32, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (511, '49', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 33, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (512, '49', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 34, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (513, '49', 'lock_time', '锁定时间', 'timestamp', 'Date', 'lockTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 35, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (514, '49', 'last_login_time', '最近登陆时间', 'timestamp', 'Date', 'lastLoginTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 36, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (515, '49', 'recommended', '推荐人的会员id  如果没有 则为-1  默认为-1', 'bigint(20)', 'Long', 'recommended', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 37, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (516, '49', 's_recommended', '二级推荐人的会员id （上级的上级） 如果没有 则为-1  默认为-1', 'bigint(20)', 'Long', 'sRecommended', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 38, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (517, '49', 'self_recommend_code', '会员自己的推荐码', 'varchar(45)', 'String', 'selfRecommendCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 39, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (518, '49', 'commission', '会员的佣金', 'decimal(20,2)', 'BigDecimal', 'commission', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 40, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (519, '49', 'belone_store_id', '会员所属的店铺id', 'bigint(20)', 'Long', 'beloneStoreId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 41, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:46');
INSERT INTO `gen_table_column` VALUES (520, '50', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (521, '50', 'customer_id', '用户id  对应ums_member表中的id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (522, '50', 'name', '收货人姓名', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (523, '50', 'mobile', '手机号码', 'varchar(12)', 'String', 'mobile', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (524, '50', 'phone', '收货人固定电话', 'varchar(12)', 'String', 'phone', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (525, '50', 'zip_code', '邮编', 'varchar(45)', 'String', 'zipCode', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (526, '50', 'address', '收货人地址（省＋市＋区）', 'varchar(124)', 'String', 'address', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (527, '50', 'detail_address', '收货人详细地址', 'varchar(64)', 'String', 'detailAddress', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (528, '50', 'province_id', '省id', 'bigint(20)', 'Long', 'provinceId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 9, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (529, '50', 'city_id', '市id', 'bigint(20)', 'Long', 'cityId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 10, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (530, '50', 'country_id', '区id', 'bigint(20)', 'Long', 'countryId', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 11, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (531, '50', 'is_default', '是否默认收货地址  0 否 1 是  默认0 ', 'char(1)', 'String', 'isDefault', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 12, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (532, '50', 'del_flag', '删除标记  0 未删除 1 删除', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 13, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (533, '50', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 14, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (534, '50', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'datetime', '', 15, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (535, '50', 'update_time', '更新时间', 'timestamp', 'Date', 'updateTime', '0', '0', NULL, '1', '1', NULL, NULL, 'EQ', 'datetime', '', 16, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:39:57');
INSERT INTO `gen_table_column` VALUES (536, '51', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (537, '51', 'name', '会员等级名称', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (538, '51', 'min_money', '消费小值（包含该值）', 'int(11)', 'Long', 'minMoney', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (539, '51', 'max_money', '消费金额最大值 不包含该值', 'int(11)', 'Long', 'maxMoney', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (540, '51', 'discount', '会员折扣', 'decimal(10,2)', 'BigDecimal', 'discount', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (541, '51', 'del_flag', '删除标记 0 未删除 1删除 默认0', 'char(1)', 'String', 'delFlag', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (542, '51', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (543, '51', 'modify_time', '修改时间', 'timestamp', 'Date', 'modifyTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (544, '51', 'del_time', '删除时间', 'timestamp', 'Date', 'delTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:36');
INSERT INTO `gen_table_column` VALUES (545, '52', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (546, '52', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (547, '52', 'marketing_id', '抢购id 注意是对应sms_marketing_panicbuy表中的id', 'bigint(20)', 'Long', 'marketingId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (548, '52', 'use_num', '用户已经购买抢购的数量', 'int(11)', 'Long', 'useNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (549, '52', 'panic_num', '该抢购的会员限购数量', 'int(11)', 'Long', 'panicNum', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (550, '52', 'order_id', '订单id', 'bigint(20)', 'Long', 'orderId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 08:59:04');
INSERT INTO `gen_table_column` VALUES (551, '53', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (552, '53', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (553, '53', 'detail', '积分详细', 'varchar(45)', 'String', 'detail', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (554, '53', 'type', '积分类型 1 收入 2支出', 'char(1)', 'String', 'type', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (555, '53', 'source_type', '积分纪录来源类型\n1 订单使用\n2 订单取消\n3 操作员修改\n4 签到\n5 积分商城使用\n6 邮箱验证 \n7 评论\n', 'char(1)', 'String', 'sourceType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (556, '53', 'point', '积分数量 正数表示增加，负数表示减少', 'int(11)', 'Long', 'point', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (557, '53', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (558, '53', 'sign_data', '签到时间，用于防止重复签到', 'date', 'Date', 'signData', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:32');
INSERT INTO `gen_table_column` VALUES (559, '54', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (560, '54', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', '1', '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (561, '54', 'trans_type', '交易类型  1:在线充值  2:订单消费  3:订单退款 4:管理员增加 5:管理员减少', 'char(1)', 'String', 'transType', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (562, '54', 'money', '金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (563, '54', 'current_money', '当前总金额', 'decimal(20,2)', 'BigDecimal', 'currentMoney', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (564, '54', 'remark', '备注', 'varchar(256)', 'String', 'remark', '0', '0', NULL, '1', '1', '1', NULL, 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (565, '54', 'status', '充值支付状态 0 未支付 1 支付成功', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (566, '54', 'transcode', '交易号', 'varchar(45)', 'String', 'transcode', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (567, '54', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 9, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:28');
INSERT INTO `gen_table_column` VALUES (568, '55', 'id', '主键id', 'bigint(20)', 'Long', 'id', '1', '1', NULL, '1', NULL, NULL, NULL, 'EQ', 'input', '', 1, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (569, '55', 'customer_id', '会员id', 'bigint(20)', 'Long', 'customerId', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 2, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (570, '55', 'money', '提现金额', 'decimal(20,2)', 'BigDecimal', 'money', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 3, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (571, '55', 'status', '状态 0 申请  1 审核通过 2 拒绝 3 已打款', 'char(1)', 'String', 'status', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'select', 'withdraw_status', 4, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (572, '55', 'trade_no', '流水号', 'varchar(45)', 'String', 'tradeNo', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 5, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (573, '55', 'account', '支付宝账号', 'varchar(64)', 'String', 'account', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'input', '', 6, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (574, '55', 'name', '支付宝姓名', 'varchar(45)', 'String', 'name', '0', '0', NULL, '1', '1', '1', '1', 'LIKE', 'input', '', 7, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (575, '55', 'create_time', '创建时间', 'timestamp', 'Date', 'createTime', '0', '0', NULL, '1', NULL, NULL, NULL, 'EQ', 'datetime', '', 8, 'admin', '2020-07-25 08:31:57', '', '2020-07-25 09:01:22');
INSERT INTO `gen_table_column` VALUES (576, '55', 'paying_time', '打款时间', 'timestamp', 'Date', 'payingTime', '0', '0', NULL, '1', '1', '1', '1', 'EQ', 'datetime', '', 9, 'admin', '2020-07-25 08:31:58', '', '2020-07-25 09:01:22');

SET FOREIGN_KEY_CHECKS = 1;
