#ifndef RASTERIZED_H
#define RASTERIZED_H 1

#include <stddef.h>
#include <stdint.h>

static const uint8_t ascii[256][16] = {
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    }, // 0
    {
        0b00000000,
        0b00000000,
        0b01111110,
        0b10000001,
        0b10100101,
        0b10000001,
        0b10000001,
        0b10111101,
        0b10011001,
        0b10000001,
        0b10000001,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111110,
        0b11111111,
        0b11011011,
        0b11111111,
        0b11111111,
        0b11000011,
        0b11100111,
        0b11111111,
        0b11111111,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01101100,
        0b11111110,
        0b11111110,
        0b11111110,
        0b11111110,
        0b01111100,
        0b00111000,
        0b00010000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00010000,
        0b00111000,
        0b01111100,
        0b11111110,
        0b01111100,
        0b00111000,
        0b00010000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00111100,
        0b00111100,
        0b11100111,
        0b11100111,
        0b11100111,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00111100,
        0b01111110,
        0b11111111,
        0b11111111,
        0b01111110,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00111100,
        0b00111100,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11100111,
        0b11000011,
        0b11000011,
        0b11100111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00111100,
        0b01100110,
        0b01000010,
        0b01000010,
        0b01100110,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11000011,
        0b10011001,
        0b10111101,
        0b10111101,
        0b10011001,
        0b11000011,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
    },
    {
        0b00000000,
        0b00000000,
        0b00011110,
        0b00001110,
        0b00011010,
        0b00110010,
        0b01111000,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01111000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b00111100,
        0b00011000,
        0b01111110,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111111,
        0b00110011,
        0b00111111,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b01110000,
        0b11110000,
        0b11100000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111111,
        0b01100011,
        0b01111111,
        0b01100011,
        0b01100011,
        0b01100011,
        0b01100011,
        0b01100111,
        0b11100111,
        0b11100110,
        0b11000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b11011011,
        0b00111100,
        0b11100111,
        0b00111100,
        0b11011011,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b10000000,
        0b11000000,
        0b11100000,
        0b11110000,
        0b11111000,
        0b11111110,
        0b11111000,
        0b11110000,
        0b11100000,
        0b11000000,
        0b10000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000010,
        0b00000110,
        0b00001110,
        0b00011110,
        0b00111110,
        0b11111110,
        0b00111110,
        0b00011110,
        0b00001110,
        0b00000110,
        0b00000010,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011000,
        0b00111100,
        0b01111110,
        0b00011000,
        0b00011000,
        0b00011000,
        0b01111110,
        0b00111100,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b00000000,
        0b01100110,
        0b01100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111111,
        0b11011011,
        0b11011011,
        0b11011011,
        0b01111011,
        0b00011011,
        0b00011011,
        0b00011011,
        0b00011011,
        0b00011011,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b01111100,
        0b11000110,
        0b01100000,
        0b00111000,
        0b01101100,
        0b11000110,
        0b11000110,
        0b01101100,
        0b00111000,
        0b00001100,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b11111110,
        0b11111110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011000,
        0b00111100,
        0b01111110,
        0b00011000,
        0b00011000,
        0b00011000,
        0b01111110,
        0b00111100,
        0b00011000,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011000,
        0b00111100,
        0b01111110,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b01111110,
        0b00111100,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00001100,
        0b11111110,
        0b00001100,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00110000,
        0b01100000,
        0b11111110,
        0b01100000,
        0b00110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00100100,
        0b01100110,
        0b11111111,
        0b01100110,
        0b00100100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00010000,
        0b00111000,
        0b00111000,
        0b01111100,
        0b01111100,
        0b11111110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b11111110,
        0b01111100,
        0b01111100,
        0b00111000,
        0b00111000,
        0b00010000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011000,
        0b00111100,
        0b00111100,
        0b00111100,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b01100110,
        0b01100110,
        0b01100110,
        0b00100100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b01101100,
        0b01101100,
        0b11111110,
        0b01101100,
        0b01101100,
        0b01101100,
        0b11111110,
        0b01101100,
        0b01101100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00011000,
        0b00011000,
        0b01111100,
        0b11000110,
        0b11000010,
        0b11000000,
        0b01111100,
        0b00000110,
        0b00000110,
        0b10000110,
        0b11000110,
        0b01111100,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11000010,
        0b11000110,
        0b00001100,
        0b00011000,
        0b00110000,
        0b01100000,
        0b11000110,
        0b10000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111000,
        0b01101100,
        0b01101100,
        0b00111000,
        0b01110110,
        0b11011100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b01100000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00001100,
        0b00011000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00011000,
        0b00001100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00110000,
        0b00011000,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00011000,
        0b00110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01100110,
        0b00111100,
        0b11111111,
        0b00111100,
        0b01100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b01111110,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00110000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000010,
        0b00000110,
        0b00001100,
        0b00011000,
        0b00110000,
        0b01100000,
        0b11000000,
        0b10000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111100,
        0b01100110,
        0b11000011,
        0b11000011,
        0b11011011,
        0b11011011,
        0b11000011,
        0b11000011,
        0b01100110,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011000,
        0b00111000,
        0b01111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b00000110,
        0b00001100,
        0b00011000,
        0b00110000,
        0b01100000,
        0b11000000,
        0b11000110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b00000110,
        0b00000110,
        0b00111100,
        0b00000110,
        0b00000110,
        0b00000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00001100,
        0b00011100,
        0b00111100,
        0b01101100,
        0b11001100,
        0b11111110,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00011110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111110,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11111100,
        0b00000110,
        0b00000110,
        0b00000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111000,
        0b01100000,
        0b11000000,
        0b11000000,
        0b11111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111110,
        0b11000110,
        0b00000110,
        0b00000110,
        0b00001100,
        0b00011000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111110,
        0b00000110,
        0b00000110,
        0b00000110,
        0b00001100,
        0b01111000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000110,
        0b00001100,
        0b00011000,
        0b00110000,
        0b01100000,
        0b00110000,
        0b00011000,
        0b00001100,
        0b00000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111110,
        0b00000000,
        0b00000000,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b01100000,
        0b00110000,
        0b00011000,
        0b00001100,
        0b00000110,
        0b00001100,
        0b00011000,
        0b00110000,
        0b01100000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b00001100,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11011110,
        0b11011110,
        0b11011110,
        0b11011100,
        0b11000000,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00010000,
        0b00111000,
        0b01101100,
        0b11000110,
        0b11000110,
        0b11111110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01111100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b11111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111100,
        0b01100110,
        0b11000010,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000010,
        0b01100110,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111000,
        0b01101100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01101100,
        0b11111000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111110,
        0b01100110,
        0b01100010,
        0b01101000,
        0b01111000,
        0b01101000,
        0b01100000,
        0b01100010,
        0b01100110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111110,
        0b01100110,
        0b01100010,
        0b01101000,
        0b01111000,
        0b01101000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b11110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111100,
        0b01100110,
        0b11000010,
        0b11000000,
        0b11000000,
        0b11011110,
        0b11000110,
        0b11000110,
        0b01100110,
        0b00111010,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11111110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111100,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011110,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01111000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11100110,
        0b01100110,
        0b01100110,
        0b01101100,
        0b01111000,
        0b01111000,
        0b01101100,
        0b01100110,
        0b01100110,
        0b11100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11110000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b01100010,
        0b01100110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000011,
        0b11100111,
        0b11111111,
        0b11111111,
        0b11011011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000110,
        0b11100110,
        0b11110110,
        0b11111110,
        0b11011110,
        0b11001110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01111100,
        0b01100000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b11110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11010110,
        0b11011110,
        0b01111100,
        0b00001100,
        0b00001110,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01111100,
        0b01101100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b11100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b01100000,
        0b00111000,
        0b00001100,
        0b00000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111111,
        0b11011011,
        0b10011001,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b01100110,
        0b00111100,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11011011,
        0b11011011,
        0b11111111,
        0b01100110,
        0b01100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000011,
        0b11000011,
        0b01100110,
        0b00111100,
        0b00011000,
        0b00011000,
        0b00111100,
        0b01100110,
        0b11000011,
        0b11000011,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000011,
        0b11000011,
        0b11000011,
        0b01100110,
        0b00111100,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111111,
        0b11000011,
        0b10000110,
        0b00001100,
        0b00011000,
        0b00110000,
        0b01100000,
        0b11000001,
        0b11000011,
        0b11111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111100,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b10000000,
        0b11000000,
        0b11100000,
        0b01110000,
        0b00111000,
        0b00011100,
        0b00001110,
        0b00000110,
        0b00000010,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00010000,
        0b00111000,
        0b01101100,
        0b11000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111111,
        0b00000000,
        0b00000000,
    },
    {
        0b00110000,
        0b00110000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111000,
        0b00001100,
        0b01111100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11100000,
        0b01100000,
        0b01100000,
        0b01111000,
        0b01101100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011100,
        0b00001100,
        0b00001100,
        0b00111100,
        0b01101100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11111110,
        0b11000000,
        0b11000000,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111000,
        0b01101100,
        0b01100100,
        0b01100000,
        0b11110000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b11110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01110110,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01111100,
        0b00001100,
        0b11001100,
        0b01111000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11100000,
        0b01100000,
        0b01100000,
        0b01101100,
        0b01110110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b11100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000110,
        0b00000110,
        0b00000000,
        0b00001110,
        0b00000110,
        0b00000110,
        0b00000110,
        0b00000110,
        0b00000110,
        0b00000110,
        0b01100110,
        0b01100110,
        0b00111100,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11100000,
        0b01100000,
        0b01100000,
        0b01100110,
        0b01101100,
        0b01111000,
        0b01111000,
        0b01101100,
        0b01100110,
        0b11100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11100110,
        0b11111111,
        0b11011011,
        0b11011011,
        0b11011011,
        0b11011011,
        0b11011011,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11011100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11011100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01111100,
        0b01100000,
        0b01100000,
        0b11110000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01110110,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01111100,
        0b00001100,
        0b00001100,
        0b00011110,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11011100,
        0b01110110,
        0b01100110,
        0b01100000,
        0b01100000,
        0b01100000,
        0b11110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b01100000,
        0b00111000,
        0b00001100,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00010000,
        0b00110000,
        0b00110000,
        0b11111100,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110000,
        0b00110110,
        0b00011100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11000011,
        0b01100110,
        0b00111100,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11000011,
        0b11000011,
        0b11000011,
        0b11011011,
        0b11011011,
        0b11111111,
        0b01100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11000011,
        0b01100110,
        0b00111100,
        0b00011000,
        0b00111100,
        0b01100110,
        0b11000011,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111110,
        0b00000110,
        0b00001100,
        0b11111000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b11001100,
        0b00011000,
        0b00110000,
        0b01100000,
        0b11000110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00001110,
        0b00011000,
        0b00011000,
        0b00011000,
        0b01110000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00001110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01110000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00001110,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b01110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01110110,
        0b11011100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00010000,
        0b00111000,
        0b01101100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111100,
        0b01100110,
        0b11000010,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000010,
        0b01100110,
        0b00111100,
        0b00001100,
        0b00000110,
        0b01111100,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11001100,
        0b00000000,
        0b00000000,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00001100,
        0b00011000,
        0b00110000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11111110,
        0b11000000,
        0b11000000,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00010000,
        0b00111000,
        0b01101100,
        0b00000000,
        0b01111000,
        0b00001100,
        0b01111100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11001100,
        0b00000000,
        0b00000000,
        0b01111000,
        0b00001100,
        0b01111100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b01100000,
        0b00110000,
        0b00011000,
        0b00000000,
        0b01111000,
        0b00001100,
        0b01111100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00111000,
        0b01101100,
        0b00111000,
        0b00000000,
        0b01111000,
        0b00001100,
        0b01111100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00111100,
        0b01100110,
        0b01100000,
        0b01100000,
        0b01100110,
        0b00111100,
        0b00001100,
        0b00000110,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00010000,
        0b00111000,
        0b01101100,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11111110,
        0b11000000,
        0b11000000,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000110,
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11111110,
        0b11000000,
        0b11000000,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b01100000,
        0b00110000,
        0b00011000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11111110,
        0b11000000,
        0b11000000,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01100110,
        0b00000000,
        0b00000000,
        0b00111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00011000,
        0b00111100,
        0b01100110,
        0b00000000,
        0b00111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b01100000,
        0b00110000,
        0b00011000,
        0b00000000,
        0b00111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b11000110,
        0b00000000,
        0b00010000,
        0b00111000,
        0b01101100,
        0b11000110,
        0b11000110,
        0b11111110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00111000,
        0b01101100,
        0b00111000,
        0b00000000,
        0b00111000,
        0b01101100,
        0b11000110,
        0b11000110,
        0b11111110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00011000,
        0b00110000,
        0b01100000,
        0b00000000,
        0b11111110,
        0b01100110,
        0b01100000,
        0b01111100,
        0b01100000,
        0b01100000,
        0b01100110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01101110,
        0b00111011,
        0b00011011,
        0b01111110,
        0b11011000,
        0b11011100,
        0b01110111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111110,
        0b01101100,
        0b11001100,
        0b11001100,
        0b11111110,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00010000,
        0b00111000,
        0b01101100,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000110,
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b01100000,
        0b00110000,
        0b00011000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00110000,
        0b01111000,
        0b11001100,
        0b00000000,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b01100000,
        0b00110000,
        0b00011000,
        0b00000000,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000110,
        0b00000000,
        0b00000000,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111110,
        0b00000110,
        0b00001100,
        0b01111000,
        0b00000000,
    },
    {
        0b00000000,
        0b11000110,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b11000110,
        0b00000000,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00011000,
        0b00011000,
        0b01111110,
        0b11000011,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000011,
        0b01111110,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00111000,
        0b01101100,
        0b01100100,
        0b01100000,
        0b11110000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b01100000,
        0b11100110,
        0b11111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11000011,
        0b01100110,
        0b00111100,
        0b00011000,
        0b11111111,
        0b00011000,
        0b11111111,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b11111100,
        0b01100110,
        0b01100110,
        0b01111100,
        0b01100010,
        0b01100110,
        0b01101111,
        0b01100110,
        0b01100110,
        0b01100110,
        0b11110011,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00001110,
        0b00011011,
        0b00011000,
        0b00011000,
        0b00011000,
        0b01111110,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11011000,
        0b01110000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00011000,
        0b00110000,
        0b01100000,
        0b00000000,
        0b01111000,
        0b00001100,
        0b01111100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00001100,
        0b00011000,
        0b00110000,
        0b00000000,
        0b00111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00011000,
        0b00110000,
        0b01100000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00011000,
        0b00110000,
        0b01100000,
        0b00000000,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11001100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01110110,
        0b11011100,
        0b00000000,
        0b11011100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b01110110,
        0b11011100,
        0b00000000,
        0b11000110,
        0b11100110,
        0b11110110,
        0b11111110,
        0b11011110,
        0b11001110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00111100,
        0b01101100,
        0b01101100,
        0b00111110,
        0b00000000,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00111000,
        0b01101100,
        0b01101100,
        0b00111000,
        0b00000000,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00110000,
        0b00110000,
        0b00000000,
        0b00110000,
        0b00110000,
        0b01100000,
        0b11000000,
        0b11000110,
        0b11000110,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b00000110,
        0b00000110,
        0b00000110,
        0b00000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b11000000,
        0b11000000,
        0b11000010,
        0b11000110,
        0b11001100,
        0b00011000,
        0b00110000,
        0b01100000,
        0b11001110,
        0b10011011,
        0b00000110,
        0b00001100,
        0b00011111,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b11000000,
        0b11000000,
        0b11000010,
        0b11000110,
        0b11001100,
        0b00011000,
        0b00110000,
        0b01100110,
        0b11001110,
        0b10010110,
        0b00111110,
        0b00000110,
        0b00000110,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00111100,
        0b00111100,
        0b00111100,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00110110,
        0b01101100,
        0b11011000,
        0b01101100,
        0b00110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11011000,
        0b01101100,
        0b00110110,
        0b01101100,
        0b11011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00010001,
        0b01000100,
        0b00010001,
        0b01000100,
        0b00010001,
        0b01000100,
        0b00010001,
        0b01000100,
        0b00010001,
        0b01000100,
        0b00010001,
        0b01000100,
        0b00010001,
        0b01000100,
        0b00010001,
        0b01000100,
    },
    {
        0b01010101,
        0b10101010,
        0b01010101,
        0b10101010,
        0b01010101,
        0b10101010,
        0b01010101,
        0b10101010,
        0b01010101,
        0b10101010,
        0b01010101,
        0b10101010,
        0b01010101,
        0b10101010,
        0b01010101,
        0b10101010,
    },
    {
        0b11011101,
        0b01110111,
        0b11011101,
        0b01110111,
        0b11011101,
        0b01110111,
        0b11011101,
        0b01110111,
        0b11011101,
        0b01110111,
        0b11011101,
        0b01110111,
        0b11011101,
        0b01110111,
        0b11011101,
        0b01110111,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11111000,
        0b00011000,
        0b11111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b11110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111000,
        0b00011000,
        0b11111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b11110110,
        0b00000110,
        0b11110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b00000110,
        0b11110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b11110110,
        0b00000110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11111000,
        0b00011000,
        0b11111000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111111,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011111,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11111111,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011111,
        0b00011000,
        0b00011111,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110111,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110111,
        0b00110000,
        0b00111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00111111,
        0b00110000,
        0b00110111,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b11110111,
        0b00000000,
        0b11111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111111,
        0b00000000,
        0b11110111,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110111,
        0b00110000,
        0b00110111,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111111,
        0b00000000,
        0b11111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b11110111,
        0b00000000,
        0b11110111,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11111111,
        0b00000000,
        0b11111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b11111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111111,
        0b00000000,
        0b11111111,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111111,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011111,
        0b00011000,
        0b00011111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011111,
        0b00011000,
        0b00011111,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00111111,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b11111111,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
        0b00110110,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11111111,
        0b00011000,
        0b11111111,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11111000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011111,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
    },
    {
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
        0b11110000,
    },
    {
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
        0b00001111,
    },
    {
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b11111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01110110,
        0b11011100,
        0b11011000,
        0b11011000,
        0b11011000,
        0b11011100,
        0b01110110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b01111000,
        0b11001100,
        0b11001100,
        0b11001100,
        0b11011000,
        0b11001100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11001100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b11111110,
        0b11000110,
        0b11000110,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000000,
        0b11000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b01101100,
        0b01101100,
        0b01101100,
        0b01101100,
        0b01101100,
        0b01101100,
        0b01101100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b11000110,
        0b01100000,
        0b00110000,
        0b00011000,
        0b00110000,
        0b01100000,
        0b11000110,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111110,
        0b11011000,
        0b11011000,
        0b11011000,
        0b11011000,
        0b11011000,
        0b01110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01111100,
        0b01100000,
        0b01100000,
        0b11000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01110110,
        0b11011100,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111110,
        0b00011000,
        0b00111100,
        0b01100110,
        0b01100110,
        0b01100110,
        0b00111100,
        0b00011000,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00111000,
        0b01101100,
        0b11000110,
        0b11000110,
        0b11111110,
        0b11000110,
        0b11000110,
        0b01101100,
        0b00111000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00111000,
        0b01101100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b01101100,
        0b01101100,
        0b01101100,
        0b01101100,
        0b11101110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011110,
        0b00110000,
        0b00011000,
        0b00001100,
        0b00111110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b01100110,
        0b00111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111110,
        0b11011011,
        0b11011011,
        0b11011011,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000011,
        0b00000110,
        0b01111110,
        0b11011011,
        0b11011011,
        0b11110011,
        0b01111110,
        0b01100000,
        0b11000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00011100,
        0b00110000,
        0b01100000,
        0b01100000,
        0b01111100,
        0b01100000,
        0b01100000,
        0b01100000,
        0b00110000,
        0b00011100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111100,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b11000110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b11111110,
        0b00000000,
        0b00000000,
        0b11111110,
        0b00000000,
        0b00000000,
        0b11111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b01111110,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b11111111,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00110000,
        0b00011000,
        0b00001100,
        0b00000110,
        0b00001100,
        0b00011000,
        0b00110000,
        0b00000000,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00001100,
        0b00011000,
        0b00110000,
        0b01100000,
        0b00110000,
        0b00011000,
        0b00001100,
        0b00000000,
        0b01111110,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00001110,
        0b00011011,
        0b00011011,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
    },
    {
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b00011000,
        0b11011000,
        0b11011000,
        0b11011000,
        0b01110000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b01111110,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01110110,
        0b11011100,
        0b00000000,
        0b01110110,
        0b11011100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00111000,
        0b01101100,
        0b01101100,
        0b00111000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00011000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00001111,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b00001100,
        0b11101100,
        0b01101100,
        0b01101100,
        0b00111100,
        0b00011100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b11011000,
        0b01101100,
        0b01101100,
        0b01101100,
        0b01101100,
        0b01101100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b01110000,
        0b11011000,
        0b00110000,
        0b01100000,
        0b11001000,
        0b11111000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b01111100,
        0b01111100,
        0b01111100,
        0b01111100,
        0b01111100,
        0b01111100,
        0b01111100,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
    {
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
        0b00000000,
    },
};

#endif
