#ifndef SCSI_H
#define SCSI_H

enum SCSICommands {
    SCSI_TEST_UNIT_READY = 0x00,
    SCSI_REQUEST_SENSE = 0x03,
    SCSI_FORMAT_UNIT = 0x04,
    SCSI_INQUIRY = 0x12,
    SCSI_START_STOP_UNIT = 0x1B,
    SCSI_PREVENT_ALLOW_MEDIUM_REMOVAL = 0x1E,
    SCSI_READ_FORMAT_CAPACITIES = 0x23,
    SCSI_READ_CAPACITY = 0x25,
    SCSI_READ_10 = 0x28,
    SCSI_WRITE_10 = 0x2A,
    SCSI_SEEK_10 = 0x2B,
    SCSI_WRITE_AND_VERIFY_10 = 0x2E,
    SCSI_VERIFY_10 = 0x2F,
    SCSI_SYNCHRONIZE_CACHE = 0x35,
    SCSI_WRITE_BUFFER = 0x3B,
    SCSI_READ_BUFFER = 0x3C,
    SCSI_READ_TOC_PMA_ATIP = 0x43,
    SCSI_GET_CONFIGURATION = 0x46,
    SCSI_GET_EVENT_STATUS_NOTIFICATION = 0x4A,
    SCSI_READ_DISC_INFORMATION = 0x51,
    SCSI_READ_TRACK_INFORMATION = 0x52,
    SCSI_RESERVE_TRACK = 0x53,
    SCSI_SEND_OPC_INFORMATION = 0x54,
    SCSI_MODE_SELECT_10 = 0x55,
    SCSI_REPAIR_TRACK = 0x58,
    SCSI_MODE_SENSE_10 = 0x5A,
    SCSI_CLOSE_TRACK_SESSION = 0x5B,
    SCSI_READ_BUFFER_CAPACITY = 0x5C,
    SCSI_SEND_CUE_SHEET = 0x5D,
    SCSI_REPORT_LUNS = 0xA0,
    SCSI_BLANK = 0xA1,
    SCSI_SECURITY_PROTOCOL_IN = 0xA2,
    SCSI_SEND_KEY = 0xA3,
    SCSI_REPORT_KEY = 0xA4,
    SCSI_LOAD_UNLOAD_MEDIUM = 0xA6,
    SCSI_SET_READ_AHEAD = 0xA7,
    SCSI_READ_12 = 0xA8,
    SCSI_WRITE_12 = 0xAA,
    SCSI_READ_MEDIA_SERIAL_NUMBER_SERVICE_ACTION_IN_12 = 0xAB,
    SCSI_GET_PERFORMANCE = 0xAC,
    SCSI_READ_DISC_STRUCTURE = 0xAD,
    SCSI_SECURITY_PROTOCOL_OUT = 0xB5,
    SCSI_SET_STREAMING = 0xB6,
    SCSI_READ_CD_MSF = 0xB9,
    SCSI_SET_CD_SPEED = 0xBB,
    SCSI_MECHANISM_STATUS = 0xBD,
    SCSI_READ_CD = 0xBE,
    SCSI_SEND_DISC_STRUCTURE = 0xBF,
};

#endif // SCSI_H
