#ifndef KERNEL_CPUID_H
#define KERNEL_CPUID_H

#include <stdbool.h>
#include <stdint.h>

typedef struct cpu_info {
    char vendor_id[12];

    // ecx features
    uint32_t ecx;

    // edx features
    uint32_t edx;
} cpu_info;

extern cpu_info cpuinfo;

enum CPUIDFeatureECX {
    CPUID_FEAT_ECX_SSE3 = 1UL << 0UL,
    CPUID_FEAT_ECX_PCLMUL = 1UL << 1UL,
    CPUID_FEAT_ECX_DTES64 = 1UL << 2UL,
    CPUID_FEAT_ECX_MONITOR = 1UL << 3UL,
    CPUID_FEAT_ECX_DS_CPL = 1UL << 4UL,
    CPUID_FEAT_ECX_VMX = 1UL << 5UL,
    CPUID_FEAT_ECX_SMX = 1UL << 6UL,
    CPUID_FEAT_ECX_EST = 1UL << 7UL,
    CPUID_FEAT_ECX_TM2 = 1UL << 8UL,
    CPUID_FEAT_ECX_SSSE3 = 1UL << 9UL,
    CPUID_FEAT_ECX_CID = 1UL << 10UL,
    CPUID_FEAT_ECX_SDBG = 1UL << 11UL,
    CPUID_FEAT_ECX_FMA = 1UL << 12UL,
    CPUID_FEAT_ECX_CX16 = 1UL << 13UL,
    CPUID_FEAT_ECX_XTPR = 1UL << 14UL,
    CPUID_FEAT_ECX_PDCM = 1UL << 15UL,

    CPUID_FEAT_ECX_PCID = 1UL << 17UL,
    CPUID_FEAT_ECX_DCA = 1UL << 18UL,
    CPUID_FEAT_ECX_SSE4_1 = 1UL << 19UL,
    CPUID_FEAT_ECX_SSE4_2 = 1UL << 20UL,
    CPUID_FEAT_ECX_X2APIC = 1UL << 21UL,
    CPUID_FEAT_ECX_MOVBE = 1UL << 22UL,
    CPUID_FEAT_ECX_POPCNT = 1UL << 23UL,
    CPUID_FEAT_ECX_TSC = 1UL << 24UL,
    CPUID_FEAT_ECX_AES = 1UL << 25UL,
    CPUID_FEAT_ECX_XSAVE = 1UL << 26UL,
    CPUID_FEAT_ECX_OSXSAVE = 1UL << 27UL,
    CPUID_FEAT_ECX_AVX = 1UL << 28UL,
    CPUID_FEAT_ECX_F16C = 1UL << 29UL,
    CPUID_FEAT_ECX_RDRAND = 1UL << 30UL,
    CPUID_FEAT_ECX_HYPERVISOR = 1UL << 31UL,
};

enum CPUIDFeatureEDX {
    CPUID_FEAT_EDX_FPU = 1UL << 0UL,
    CPUID_FEAT_EDX_VME = 1UL << 1UL,
    CPUID_FEAT_EDX_DE = 1UL << 2UL,
    CPUID_FEAT_EDX_PSE = 1UL << 3UL,
    CPUID_FEAT_EDX_TSC = 1UL << 4UL,
    CPUID_FEAT_EDX_MSR = 1UL << 5UL,
    CPUID_FEAT_EDX_PAE = 1UL << 6UL,
    CPUID_FEAT_EDX_MCE = 1UL << 7UL,
    CPUID_FEAT_EDX_CX8 = 1UL << 8UL,
    CPUID_FEAT_EDX_APIC = 1UL << 9UL,

    CPUID_FEAT_EDX_SEP = 1UL << 11UL,
    CPUID_FEAT_EDX_MTRR = 1UL << 12UL,
    CPUID_FEAT_EDX_PGE = 1UL << 13UL,
    CPUID_FEAT_EDX_MCA = 1UL << 14UL,
    CPUID_FEAT_EDX_CMOV = 1UL << 15UL,
    CPUID_FEAT_EDX_PAT = 1UL << 16UL,
    CPUID_FEAT_EDX_PSE36 = 1UL << 17UL,
    CPUID_FEAT_EDX_PSN = 1UL << 18UL,
    CPUID_FEAT_EDX_CLFLUSH = 1UL << 19UL,

    CPUID_FEAT_EDX_DTS = 1UL << 21UL,
    CPUID_FEAT_EDX_ACPI = 1UL << 22UL,
    CPUID_FEAT_EDX_MMX = 1UL << 23UL,
    CPUID_FEAT_EDX_FXSR = 1UL << 24UL,
    CPUID_FEAT_EDX_SSE = 1UL << 25UL,
    CPUID_FEAT_EDX_SSE2 = 1UL << 26UL,
    CPUID_FEAT_EDX_SS = 1UL << 27UL,
    CPUID_FEAT_EDX_HTT = 1UL << 28UL,
    CPUID_FEAT_EDX_TM = 1UL << 29UL,
    CPUID_FEAT_EDX_IA64 = 1UL << 30UL,
    CPUID_FEAT_EDX_PBE = 1UL << 31UL,
};

extern bool cpuid_available(void);

bool get_cpuid_info(void);

#endif // KERNEL_CPUID_H
