# Competitive Programming Library

From OKNOTOK.

This repository contains templates, algorithms and data structures implemented and collected for programming contests. Most of them are at least used once to check correctness, still it is **strongly recommended to test for yourself**.

# Table of Contents
1. [Dynamic Programming](#dp)
2. [Data Structures](#ds)
3. [Game](#game)
4. [Geometry](#geo)
5. [Graph](#graph)
6. [Math](#math)
7. [Miscellaneous](#misc)
8. [Notes](#notes)
9. [String](#string)

## Dynamic Programming <a name="dp"></a>
- [Convex Hull Line Container.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Convex%20Hull%20Line%20Container.cpp)
- [Convex Hull Trick.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Convex%20Hull%20Trick.cpp)
- [Digit DP Sample 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Digit%20DP%20Sample%202.cpp)
- [Digit DP Sample.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Digit%20DP%20Sample.cpp)
- [Divide and Conquer DP.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Divide%20and%20Conquer%20DP.cpp)
- [Dynamic Convex Hull Trick.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Dynamic%20Convex%20Hull%20Trick.cpp)
- [Edit Distance Recursive.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Edit%20Distance%20Recursive.cpp)
- [IOI Aliens by koosaga.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/IOI%20Aliens%20by%20koosaga.cpp)
- [In-out DP.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/In-out%20DP.cpp)
- [Knuth Optimization.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Knuth%20Optimization.cpp)
- [LCS.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/LCS.cpp)
- [LIS nlogk.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/LIS%20nlogk.cpp)
- [Matrix Expo Class.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Matrix%20Expo%20Class.cpp)
- [Palindrome in a String.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/DP/Palindrome%20in%20a%20String.cpp)

## Data Structures <a name="ds"></a>

- [2D BIT.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/2D%20BIT.cpp)
- [2D Segment Tree.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/2D%20Segment%20Tree.cpp)
- [A DSU Problem.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/A%20DSU%20Problem.cpp)
- [BIT Range Update Range Query.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/BIT%20Range%20Update%20Range%20Query.cpp)
- [Best Partial Sum in a Range.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Best%20Partial%20Sum%20in%20a%20Range.cpp)
- [Binary Indexed Tree.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Binary%20Indexed%20Tree.cpp)
- [Centroid Decomposition Sample.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Centroid%20Decomposition%20Sample.cpp)
- [Centroid Decomposition.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Centroid%20Decomposition.cpp)
- [Counting Inversions with BIT.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Counting%20Inversions%20with%20BIT.cpp)
- [DSU on Tree Sample.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/DSU%20on%20Tree%20Sample.cpp)
- [Dynamic Segment Tree with Lazy Prop.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Dynamic%20Segment%20Tree%20with%20Lazy%20Prop.cpp)
- [Dynamic Segment Tree.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Dynamic%20Segment%20Tree.cpp)
- [Fenwick Tree 3D.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Fenwick%20Tree%203D.cpp)
- [GP Hash Table.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/GP%20Hash%20Table.cpp)
- [HLD Sample Problem.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/HLD%20Sample%20Problem.cpp)
- [HashMap.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/HashMap.cpp)
- [Heavy Light Decomposition.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Heavy%20Light%20Decomposition.cpp)
- [How Many Values Less than a Given Value.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/How%20Many%20Values%20Less%20than%20a%20Given%20Value.cpp)
- [Li Chao Tree Lines.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Li%20Chao%20Tree%20Lines.cpp)
- [Li Chao Tree Parabolic Sample.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Li%20Chao%20Tree%20Parabolic%20Sample.cpp)
- [Mo Algorithm Example.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Mo%20Algorithm%20Example.cpp)
- [Mo on Tree Path.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Mo%20on%20Tree%20Path.cpp)
- [Order Statistics Tree.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Order%20Statistics%20Tree.cpp)
- [Ordered Multiset.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Ordered%20Multiset.cpp)
- [Persistent Segment Tree 1.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Persistent%20Segment%20Tree%201.cpp)
- [Persistent Segment Tree 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Persistent%20Segment%20Tree%202.cpp)
- [Persistent Trie.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Persistent%20Trie.cpp)
- [RMQ Sparse Table.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/RMQ%20Sparse%20Table.cpp)
- [Range Sum Query by Lazy Propagation.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Range%20Sum%20Query%20by%20Lazy%20Propagation.cpp)
- [Rope.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Rope.cpp)
- [Segment Tree with Lazy Prop.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Segment%20Tree%20with%20Lazy%20Prop.cpp)
- [Splay Tree.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Splay%20Tree.cpp)
- [Venice Technique.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Data%20Structures/Venice%20Technique.cpp)

## Game <a name="game"></a>
- [Green Hacenbush.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Game/Green%20Hacenbush.cpp)
- [Green Hackenbush 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Game/Green%20Hackenbush%202.cpp)

## Geometry <a name="geo"></a>
- [Convex Hull.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Geometry/Convex%20Hull.cpp)
- [Counting Closest Pair of Points.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Geometry/Counting%20Closest%20Pair%20of%20Points.cpp)
- [Maximum Points to Enclose in a Circle of Given Radius with Angular Sweep.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Geometry/Maximum%20Points%20to%20Enclose%20in%20a%20Circle%20of%20Given%20Radius%20with%20Angular%20Sweep.cpp)
- [Point in Polygon Binary Search.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Geometry/Point%20in%20Polygon%20Binary%20Search.cpp)
- [Rectangle Union.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Geometry/Rectangle%20Union.cpp)

## Graph <a name="graph"></a>

- [0-1 BFS.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/0-1%20BFS.cpp)
- [2-SAT 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/2-SAT%202.cpp)
- [2-SAT.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/2-SAT.cpp)
- [Articulation Points and Bridges.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Articulation%20Points%20and%20Bridges.cpp)
- [BCC.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/BCC.cpp)
- [Bellman Ford.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Bellman%20Ford.cpp)
- [Cycle in a Directed Graph.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Cycle%20in%20a%20Directed%20Graph.cpp)
- [Dijkstra!.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Dijkstra!.cpp)
- [Dominator Tree.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Dominator%20Tree.cpp)
- [Edge Coloring.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Edge%20Coloring.cpp)
- [Edmonds Matching.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Edmonds%20Matching.cpp)
- [Faster Weighted Matching.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Faster%20Weighted%20Matching.cpp)
- [Global Minimum Cut.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Global%20Minimum%20Cut.cpp)
- [Hopcroft Karp.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Hopcroft%20Karp.cpp)
- [Hungarian Weighted Matching.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Hungarian%20Weighted%20Matching.cpp)
- [Johnson's Algorithm.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Johnson's%20Algorithm.cpp)
- [Kruskal.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Kruskal.cpp)
- [LCA 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/LCA%202.cpp)
- [LCA.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/LCA.cpp)
- [Manhattan MST.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Manhattan%20MST.cpp)
- [Max Flow Dinic 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Max%20Flow%20Dinic%202.cpp)
- [Max Flow Dinic.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Max%20Flow%20Dinic.cpp)
- [Max Flow Edmond Karp.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Max%20Flow%20Edmond%20Karp.cpp)
- [Max Flow Ford Fulkerson.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Max%20Flow%20Ford%20Fulkerson.cpp)
- [Max Flow Goldberg Tarjan.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Max%20Flow%20Goldberg%20Tarjan.cpp)
- [Maximum Bipartite Matching and Min Vertex Cover.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Maximum%20Bipartite%20Matching%20and%20Min%20Vertex%20Cover.cpp)
- [Maximum Matching in General Graphs (Randomized Algorithm).cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Maximum%20Matching%20in%20General%20Graphs%20(Randomized%20Algorithm).cpp)
- [Min Cost Arborescence.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Min%20Cost%20Arborescence.cpp)
- [Min Cost Max Flow 1.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Min%20Cost%20Max%20Flow%201.cpp)
- [Min Cost Max Flow 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Min%20Cost%20Max%20Flow%202.cpp)
- [Min Cost Max Flow 3.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Min%20Cost%20Max%20Flow%203.cpp)
- [Min Cost Max Flow with Bellman Ford.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Min%20Cost%20Max%20Flow%20with%20Bellman%20Ford.cpp)
- [Minimum Path Cover in DAG.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Minimum%20Path%20Cover%20in%20DAG.cpp)
- [Prim MST.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Prim%20MST.cpp)
- [Push Relabel 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Push%20Relabel%202.cpp)
- [Push Relabel.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Push%20Relabel.cpp)
- [SCC Kosaraju.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/SCC%20Kosaraju.cpp)
- [SCC Tarjan.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/SCC%20Tarjan.cpp)
- [SPFA.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/SPFA.cpp)
- [Tree Construction with Specific Vertices.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/Tree%20Construction%20with%20Specific%20Vertices.cpp)
- [kth Shortest Path Length.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Graph/kth%20Shortest%20Path%20Length.cpp)

## Math <a name="math"></a>

- [CRT Diophantine.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/CRT%20Diophantine.cpp)
- [Euler Phi.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Euler%20Phi.cpp)
- [FFT 1.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/FFT%201.cpp)
- [FFT 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/FFT%202.cpp)
- [FFT Extended.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/FFT%20Extended.cpp)
- [FFT Modulo.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/FFT%20Modulo.cpp)
- [FFT by XraY.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/FFT%20by%20XraY.cpp)
- [Fast Integer Cube and Square Root.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Fast%20Integer%20Cube%20and%20Square%20Root.cpp)
- [Fast Walsh-Hadamard Transform.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Fast%20Walsh-Hadamard%20Transform.cpp)
- [Faulhaber's Formula (Custom Algorithm).cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Faulhaber's%20Formula%20(Custom%20Algorithm).cpp)
- [Faulhaber's Formula.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Faulhaber's%20Formula.cpp)
- [Gauss Elimination Equations Mod Number Solutions.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Gauss%20Elimination%20Equations%20Mod%20Number%20Solutions.cpp)
- [Gauss Jordan Elimination.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Gauss%20Jordan%20Elimination.cpp)
- [Gauss Xor.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Gauss%20Xor.cpp)
- [Gaussian 1.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Gaussian%201.cpp)
- [Gaussian 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Gaussian%202.cpp)
- [Karatsuba.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Karatsuba.cpp)
- [Linear Diophantine.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Linear%20Diophantine.cpp)
- [Matrix Expo.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Matrix%20Expo.cpp)
- [Number Theoretic Transform.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Number%20Theoretic%20Transform.cpp)
- [Segmented Sieve.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Segmented%20Sieve.cpp)
- [Sieve (Bitmask).cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Sieve%20(Bitmask).cpp)
- [Sieve.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Sieve.cpp)
- [Simplex.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Simplex.cpp)
- [Sum of Kth Power.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Math/Sum%20of%20Kth%20Power.cpp)

## Miscellaneous <a name="misc"></a>

- [Divide and Conquer on Queries.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Divide%20and%20Conquer%20on%20Queries.cpp)
- [Gilbert Curve for Mo.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Gilbert%20Curve%20for%20Mo.cpp)
- [HakmemItem175.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/HakmemItem175.cpp)
- [Header.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Header.cpp)
- [Integral Determinant.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Integral%20Determinant.cpp)
- [Inverse Modulo 1 to N (Linear).cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Inverse%20Modulo%201%20to%20N%20(Linear).cpp)
- [Josephus Problem.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Josephus%20Problem.cpp)
- [MSB Position in O(1).cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/MSB%20Position%20in%20O(1).cpp)
- [Nearest Smaller Values on Left-Right.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Nearest%20Smaller%20Values%20on%20Left-Right.cpp)
- [Next Small.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Next%20Small.cpp)
- [Random Number Generation.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Random%20Number%20Generation.cpp)
- [Russian Peasant Multiplication.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Russian%20Peasant%20Multiplication.cpp)
- [Stable Marriage Problem.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Stable%20Marriage%20Problem.cpp)
- [Thomas Algorithm.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Thomas%20Algorithm.cpp)
- [U128.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/U128.cpp)
- [Useful Templates.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/Useful%20Templates.cpp)
- [int128.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/Miscellaneous/int128.cpp)

## Notes <a name="Notes"></a>

- [Advanced Modular Arithmetic.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Advanced%20Modular%20Arithmetic.pdf)
- [Counting Divisors in O(cubicroot(n)).pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Counting%20Divisors%20in%20O(cubicroot(n)).pdf)
- [Flow with Demand.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Flow%20with%20Demand.pdf)
- [General_Ideas.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/General_Ideas.pdf)
- [Graph_Concepts_that_I_Forget.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Graph_Concepts_that_I_Forget.pdf)
- [Hall Theorem.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Hall%20Theorem.pdf)
- [Let_s_Pull_Some_Strings.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Let_s_Pull_Some_Strings.pdf)
- [Minimum_vertex_disjoint_path_on_a_DAG.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Minimum_vertex_disjoint_path_on_a_DAG.pdf)
- [Notes_on_FFT_Problems.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Notes_on_FFT_Problems.pdf)
- [Notes_on_FFT_Problems_2.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Notes_on_FFT_Problems_2.pdf)
- [Posets.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Posets.pdf)
- [Sum_of_Subsets_DP_with_Bitmasks.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Sum_of_Subsets_DP_with_Bitmasks.pdf)
- [System of Difference Constraints.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/System%20of%20Difference%20Constraints.pdf)
- [Team Note (koosaga-hyea-alex).pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/Team%20Note%20(koosaga-hyea-alex).pdf)
- [XOR_Maximization_with_Gaussian_Elimination.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/XOR_Maximization_with_Gaussian_Elimination.pdf)
- [dp_optimizations.pdf](https://github.com/mochow13/competitive-programming-library/blob/master/Notes/dp_optimizations.pdf)

## String <a name="string"></a>

- [A KMP Application.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/A%20KMP%20Application.cpp)
- [Aho Corasick 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Aho%20Corasick%202.cpp)
- [Aho Corasick Occurrence Relation.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Aho%20Corasick%20Occurrence%20Relation.cpp)
- [Aho Corasick.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Aho%20Corasick.cpp)
- [Double Hash.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Double%20Hash.cpp)
- [Dynamic Aho Corasick Sample.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Dynamic%20Aho%20Corasick%20Sample.cpp)
- [Dynamic Aho Corasick.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Dynamic%20Aho%20Corasick.cpp)
- [KMP 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/KMP%202.cpp)
- [KMP 3.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/KMP%203.cpp)
- [Manacher-s Algorithm.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Manacher-s%20Algorithm.cpp)
- [Minimum Lexicographic Rotation.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Minimum%20Lexicographic%20Rotation.cpp)
- [Palindrome Factorization.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Palindrome%20Factorization.cpp)
- [Palindromic Tree.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Palindromic%20Tree.cpp)
- [String Split by Delimiter.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/String%20Split%20by%20Delimiter.cpp)
- [Suffix Array 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Suffix%20Array%202.cpp)
- [Suffix Array.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Suffix%20Array.cpp)
- [Suffix Automata 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Suffix%20Automata%202.cpp)
- [Suffix Automata.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Suffix%20Automata.cpp)
- [Trie 1.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Trie%201.cpp)
- [Trie 2.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Trie%202.cpp)
- [Z Algorithm.cpp](https://github.com/mochow13/competitive-programming-library/blob/master/String/Z%20Algorithm.cpp)
