[![License](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)
[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)

# CKS-Exercises

<p align="center">
  <img width="120" src="Cks-logo.png">
</p>

A curated collection of exercises to help prepare for the Certified Kubernetes Security Specialist. The exercises have been segregated into their respective domains as per the [CNCF curriculum](https://training.linuxfoundation.org/certification/certified-kubernetes-security-specialist/) for CKS. 
- Note: Regardless of you sitting the CKS exam or not, once you have completed most of the exercises, you will have a good understanding and implementation of security in the large Kubernetes eco-system. What matters is that you enjoy the learning process. Goodluck on your learning journey!

* [CNCF CKS Exam Curriculum repository ](https://github.com/cncf/curriculum/)
# Exam syllabus

- [Cluster setup (10%)](1-cluster-setup/)
- [Cluster Hardening (15%)](2-cluster-hardening/)
- [System Hardening (15%)](3-system-hardening/)
- [Minimise Microservice Vulnerabilities (20%)](4-minimise-microservice-vulnerabilities/)
- [Supply Chain Security (20%)](5-supply-chain-security/)
- [Monitoring, Logging and Runtime security (20%)](6-monitoring-logging-runtime-security/)

#### [For a more detailed syllabus](./syllabus/README.md)

#### [Exam style questions](7-mock-exam-questions)
#### [Are you preparing for the CKA/CKAD?](8-preparing-for-CKA-CKAD?)

- Here are a list of online resources to help you pass the CKA/CKAD exams so that you can go for the CKS (as the CKA is a prerequisite for the CKS)
- Feel free to make a PR in the folder if you find useful resources.

## More useful resources and materials

#### Further reading (articles & books)

1. [Where to begin with the CKS exam?](https://moabukar.medium.com/where-to-begin-with-the-cks-exam-5cf0dcc86f76)

#### Slack channels

1. [Kubernetes Community - #cks-exam-prep](https://kubernetes.slack.com)

#### K8s and Container Security resources

1. [Mumshad's KodeKloud "Certified Kubernetes Security Specialist" course](https://kodekloud.com/p/certified-kubernetes-security-specialist-cks)
1. [Killer.sh CKS practice exam](https://killer.sh/cks)

#### Other useful CKS repos

1. [Walid Shaari's CKS repo](https://github.com/walidshaari/Certified-Kubernetes-Security-Specialist)
1. [Abdennour's CKS repo](https://github.com/abdennour/certified-kubernetes-security-specialist)
1. [A simple and comorehensive CLI to prepare for the CKS exam by Abdennour](https://cks.kubernetes.tn/getting-started/installation/) 
1. [Kim's CKS Challenge series](https://github.com/killer-sh/cks-challenge-series)

### Want to Contribute?

  - Fork the repo and create your branch from your forked repo
  - Please try to stick to the layout we follow in terms of the README markdown
  - Issue that PR
  - This will be reviewed by the team and merged
