---
title: HTTP Gateway Description Format
abbrev:
docname: draft-nottingham-gateway-description-latest
date: {DATE}
category: std

ipr: trust200902
keyword: Internet-Draft

stand_alone: yes
smart_quotes: no
pi: [toc, tocindent, sortrefs, symrefs, strict, compact, comments, inline]

venue:
  home: "https://mnot.github.io/I-D/"
  repo: "https://github.com/mnot/I-D/labels/gateway-description"

github-issue-label: gateway-description

author:
 -
    ins: M. Nottingham
    name: Mark Nottingham
    organization:
    postal:
      - Prahran
    country: Australia
    email: mnot@mnot.net
    uri: https://www.mnot.net/

normative:
  HTTP: RFC9110
  INVALIDATION: I-D.nottingham-http-invalidation
  BEARER: RFC6750
  TARGETED: RFC9213
  JSON: RFC8259

--- abstract

This document specifies a format for describing the capabilities and configuration of a HTTP gateway (such as a content delivery network) to the origin server and any software on it (such as a content management system).

--- middle


# Introduction

To allow origin servers and tools that they use to be easily configured, this document defines a Gateway Description Format that describes the configuration of an HTTP gateway (commonly, a "reverse proxy" or content delivery network). It is intended to be generated by gateways and made available out-of-band to origin servers using them.


## Notational Conventions

{::boilerplate bcp14-tagged}


# Gateway Description Format {#desc-format}

The Gateway Description Format is a JSON {{JSON}} document. The root object SHOULD contain members with the following names and values:

* "generated": a string containing the date that the description was generated, in the Internet Date/Time Format described in {{Section 5 of !RFC3339}}
* "description": a string containing a human-readable description of the gateway

For example, a very simple (and not very helpful) description document:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z"
}
~~~

Processors SHOULD NOT fail if these members are not present.

Additionally, the root object MAY contain any number of gateway descriptors; see {{descriptors}}.

Unrecognised members of the root object MUST be ignored.


# Gateway Descriptors {#descriptors}

The following subsections list OPTIONAL information that may be included in the root object of a gateway description document.

New gateway descriptors may be introduced by updating this specification.

## Site {#site}

The "site" descriptor is a JSON object containing information about the HTTP server that the gateway exposes on behalf of the origin. It is a JSON object that contains zero or more of the following members:

- "exposed-origins": an array of strings containing Unicode serializations of origins ({{Section 6.1 of !RFC6454}}) that are exposed by the gateway
- "backend-origins": an array of strings containing Unicode serializations of origins that the gateway uses as origin server(s) for the exposed origin(s)

For example:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z",
  "site": {
    "exposed-origins": ["https://www.example.com", "https://www.example.com"],
    "backend-origins": ["https://backend1.example.com", "https://backend2.example.com"]
  }
}
~~~

Note that this descriptor allows but is not sufficient to describe more complex arrangements; for example, different backend-origins for different URL path locations, or when one exposed-origin redirects all requests to the other.

## Gateway Source Address Lists {#gateway-sourcelist}

The "gateway-sourcelists" descriptor is a JSON array of strings containing one or more URLs that can be used to fetch gateway source address lists.

Their URLs MUST have a scheme of "https". If multiple URLs are listed, their contents are combined to reconstruct the full list of source IP addresses for the gateway. Consumers SHOULD respect HTTP caching rules when fetching lists, refreshing their contents as necessary once they become stale.

For example:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z",
  "gateway-sourcelists": [
    "https://cdn.example.com/source-addresess/ipv4",
    "https://cdn.example.com/source-addresses/ipv6"
  ]
}
~~~

Gateway source address lists are textual documents (with a RECOMMENDED media type of "text/plain") whose format is one entry per line, with all whitespace being ignored and all content on a line after the "#" being ignored. Each entry contains an IPv4 or IPv6 address block, using "/" notation.

For example:

~~~
# My IP addresses
192.0.2.0/24
  198.51.100.0/24   # TEST-NET-2

2001:db8::/32
~~~

... contains three entries, "192.0.2.0/24", "198.51.100.0/24", and "2001:db8::/32".


## Gateway Header Authentication {#gateway-header-auth}

The "gateway-header-auth" descriptor is a JSON array of two strings representing a HTTP header field name and value that it will send in all HTTP requests to the origin, allowing the origin to discriminate them from other requests.

For example:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z",
  "gateway-header-auth": ["Secret", "my$ecret"]
}
~~~

would imply that the gateway would send this HTTP header field in all requests to the origin:

~~~ http-message
Secret: my$ecret
~~~

## Forwarded Host {#forwarded-host}

The "forwarded-host" descriptor is a boolean that indicates whether the Host request header field sent by the gateway is that which it received (one of the exposed origins) if true, or that of the backend origin selected if false.

For example:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z",
  "forwarded-host": false
}
~~~

would imply that the gateway has rewritten the Host request header field will be rewritten to be that of the backend origin.

## HTTP Methods Allowed {#methods-allow}
The "methods-allow" descriptor is a JSON array of case-sensitive strings that indicate the HTTP methods that the gateway will accept in requests, forwarding them to the backend origin or handling them locally as appropriate.

The value "*" indicates that unrecognised methods are forwarded to the backend origin server.

For example:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z",
  "methods-allow": ["GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS"]
}
~~~

## Targeted Cache Control {#targeted-cc}

The "targeted-cc" descriptor is a JSON array of strings indicating the targeted cache-control header field(s) {{TARGETED}} supported by the gateway, in order of precedence (i.e., first entry overrides later entries)

For example:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z",
  "targeted-cc": [
    "ExampleCDN-Cache-Control",
    "CDN-Cache-Control"
  ]
}
~~~

## Invalidation API {#invalidation-api}

The "invalidation-api" descriptor is a JSON object that contains information about the gateway's deployment of {{INVALIDATION}}.

These objects can contain the following members and values:

* "uri": a string conveying the URI of the Invalidation Resource ({{Section 2 of INVALIDATION}})
* "selectors": an array of strings indicating the selectors ({{Section 3.1 of INVALIDATION}}) that the Invalidation Resource supports
* "purge": a boolean indicating whether the Invalidation Resource supports the "purge" member in requests (see {{Section 3 of INVALIDATION}})
* "p95-latency": an integer indicating the number of milliseconds that 95% of invalidation requests should be fully applied to the scope indicated by the description.

For example:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z",
  "invalidation-api": {
    "uri": "https://api.cdn.example.com/invalidate",
    "selectors": ["uri", "uri-prefix", "group"],
    "purge": true,
    "p95-latency": 2000
  }
}
~~~

If the "api-auth" descriptor ({{api-auth}}) is present, the authentication details there SHOULD be sent on all requests to the invalidation API.

## API Authentication {#api-auth}

The "api-auth" descriptor is a string representing a Bearer HTTP authentication ({{Section 2.1 of BEARER}}) to be used to authenticate the backend origin in interaction with Gateway APIs.

For example:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z",
  "api-auth": "mF_9.B5f-4.1JqM"
}
~~~

## Vendor Extensions {#vendor}

The "vendor" descriptor is a JSON object that can be use for gateway- and vendor-specific extensions to the format. Its members' names MUST be in internet hostname format, associating a name associated with the gateway and/or its vendor. The contents of member values are under the control of that party.

For example:

~~~ json
{
  "description": "The Example CDN configuration for example.com",
  "generated": "2023-08-21T23:20:50.52Z",
  "vendor": {
    "cdn.example.com": {
      "foo": "bar",
      "1": 2
    }
  }
}
~~~


# IANA Considerations

TBD

# Security Considerations

TBD

--- back

