import { Index } from "@pipeline/Types";

// prettier-ignore
/** ISO 639-2/3 language codes */
export const LanguageCodes = ["", "af","als","am","an","ar","arz","as","ast","av","az","azb","ba","bar","bcl","be","bg","bh","bn","bo","bpy","br","bs","bxr","ca","cbk","ce","ceb","ckb","co","cs","cv","cy","da","de","diq","dsb","dty","dv","el","eml","en","eo","es","et","eu","fa","fi","fr","frr","fy","ga","gd","gl","gn","gom","gu","gv","he","hi","hif","hr","hsb","ht","hu","hy","ia","id","ie","ilo","io","is","it","ja","jbo","jv","ka","kk","km","kn","ko","krc","ku","kv","kw","ky","la","lb","lez","li","lmo","lo","lrc","lt","lv","mai","mg","mhr","min","mk","ml","mn","mr","mrj","ms","mt","mwl","my","myv","mzn","nah","nap","nds","ne","new","nl","nn","no","oc","or","os","pa","pam","pfl","pl","pms","pnb","ps","pt","qu","rm","ro","ru","rue","sa","sah","sc","scn","sco","sd","sh","si","sk","sl","so","sq","sr","su","sv","sw","ta","te","tg","th","tk","tl","tr","tt","tyv","ug","uk","ur","uz","vec","vep","vi","vls","vo","wa","war","wuu","xal","xmf","yi","yo","yue","zh"] as const;

/** ISO 639-2/3 language code */
export type Language = (typeof LanguageCodes)[number];

/** @returns the index that identifies a language. Can be used to index LanguageCodes and LanguageNames */
export const getLanguageIndexByCode = (lang: Language): Index => LanguageCodes.indexOf(lang);

/** Language names. Corresponds with LanguageCodes above */
export const LanguageNames = [
    "Unreliable to detect",
    "Afrikaans",
    "Alemannic", // als is incorrectly assigned in fastText See: https://github.com/facebookresearch/fastText/issues/482
    "Amharic",
    "Aragonese",
    "Arabic",
    "Egyptian Arabic",
    "Assamese",
    "Asturian",
    "Avaric",
    "Azerbaijani",
    "South Azerbaijani",
    "Bashkir",
    "Bavarian",
    "Central Bikol",
    "Belarusian",
    "Bulgarian",
    "Bihari",
    "Bengali",
    "Tibetan",
    "Bishnupriya",
    "Breton",
    "Bosnian",
    "Russia Buriat",
    "Catalan",
    "Chavacano",
    "Chechen",
    "Cebuano",
    "Central Kurdish",
    "Corsican",
    "Czech",
    "Chuvash",
    "Welsh",
    "Danish",
    "German",
    "Dimli (individual language)",
    "Lower Sorbian",
    "Dotyali",
    "Dhivehi",
    "Modern Greek (1453-)",
    "Emilian-Romagnol",
    "English",
    "Esperanto",
    "Spanish",
    "Estonian",
    "Basque",
    "Persian",
    "Finnish",
    "French",
    "Northern Frisian",
    "Western Frisian",
    "Irish",
    "Scottish Gaelic",
    "Galician",
    "Guarani",
    "Goan Konkani",
    "Gujarati",
    "Manx",
    "Hebrew",
    "Hindi",
    "Fiji Hindi",
    "Croatian",
    "Upper Sorbian",
    "Haitian",
    "Hungarian",
    "Armenian",
    "Interlingua (International Auxiliary Language Association)",
    "Indonesian",
    "Interlingue",
    "Iloko",
    "Ido",
    "Icelandic",
    "Italian",
    "Japanese",
    "Lojban",
    "Javanese",
    "Georgian",
    "Kazakh",
    "Khmer",
    "Kannada",
    "Korean",
    "Karachay-Balkar",
    "Kurdish",
    "Komi",
    "Cornish",
    "Kirghiz",
    "Latin",
    "Luxembourgish",
    "Lezghian",
    "Limburgan",
    "Lombard",
    "Lao",
    "Northern Luri",
    "Lithuanian",
    "Latvian",
    "Maithili",
    "Malagasy",
    "Eastern Mari",
    "Minangkabau",
    "Macedonian",
    "Malayalam",
    "Mongolian",
    "Marathi",
    "Western Mari",
    "Malay",
    "Maltese",
    "Mirandese",
    "Burmese",
    "Erzya",
    "Mazanderani",
    "Nahuatl",
    "Neapolitan",
    "Low German",
    "Nepali",
    "Newari",
    "Dutch",
    "Norwegian Nynorsk",
    "Norwegian",
    "Occitan (post 1500)",
    "Oriya",
    "Ossetian",
    "Panjabi",
    "Pampanga",
    "Pfaelzisch",
    "Polish",
    "Piemontese",
    "Western Panjabi",
    "Pushto",
    "Portuguese",
    "Quechua",
    "Romansh",
    "Romanian",
    "Russian",
    "Rusyn",
    "Sanskrit",
    "Yakut",
    "Sardinian",
    "Sicilian",
    "Scots",
    "Sindhi",
    "Serbo-Croatian",
    "Sinhala",
    "Slovak",
    "Slovenian",
    "Somali",
    "Albanian",
    "Serbian",
    "Sundanese",
    "Swedish",
    "Swahili",
    "Tamil",
    "Telugu",
    "Tajik",
    "Thai",
    "Turkmen",
    "Tagalog",
    "Turkish",
    "Tatar",
    "Tuvinian",
    "Uighur",
    "Ukrainian",
    "Urdu",
    "Uzbek",
    "Venetian",
    "Veps",
    "Vietnamese",
    "Vlaams",
    "Volapük",
    "Walloon",
    "Waray (Philippines)",
    "Wu Chinese",
    "Kalmyk",
    "Mingrelian",
    "Yiddish",
    "Yoruba",
    "Yue Chinese",
    "Chinese",
];
