<!-- DO NOT EDIT THIS FILE: It is auto-generated by `make update-man` -->

# voices(1) - OS X text-to-speech voices

## SYNOPSIS

Get or set or speak with the DEFAULT VOICE:

    voices [<options>] [-d [<newDefaultVoice>]]

LIST INFORMATION about / speak with voices:

    voices [<options>] <voice>...

List / speak with ALL VOICES, optionally FILTERED BY LANGUAGES:

    voices [<options>] -l [<lang>...]

LIST LANGUAGES among voices:

    voices -L [-a]

MANAGE VOICES in System Preferences:

    voices -m

Shared options (synopsis forms 1-3):

    -a          target all installed voices (default: only active ones)
    -k          speak demo text with all targeted voices
    -k"<text>"  speak specified text
    -k-         speak text provided via stdin
    -b          output format: print voice names only
    -i          output format: print voice internals
    -q          quiet mode: no printed output

Standard options: `--help`, `--man`, `--version`, `--home`

## DESCRIPTION

`voices` sets the default voice for OS X's TTS (text-to-speech) synthesis or  
returns information about the default, active and installed voices.  
Additionally, it can speak either the demo text or specified text with  
multiple voices.

Case doesn't matter when specifying voice or language names.

 * Specify voice names as they appear in System Preferences >  
   Dictation & Speeech and in the output from `say -v \?`.
 
 * Specify languages as two-character language IDs (e.g., `en`), optionally  
   followed by `_` and a region identifier (e.g., `en_US`).

Options `-l` and `-L` target all *active* voices by default, which are  
typically a a subset of all *installed* voices, and constitute the set of  
voices selected for active use in System Preferences > Dictation & Speech >  
Text to Speech.  
Adding `-a` targets all installed voices.

The `-k` option for speaking with all targeted voices as well as other  
shared options are discussed further below. Without `-k`, only printed output  
is produced; conversely, `-q` silences printed output.

* 1st synopsis form: `[-d [<newDefaultVoice>]]`, `[--default [<newDefaultVoice>]]`  
  Returns information about the default voice or sets a new default voice.  
  Note that any installed voice can be specified as the default voice, even  
  if it is not among the set of active voices.

* 2nd synopsis form: `<voice>...`  
  Lists information about the specified voices (whether active or not).

* 3rd synopsis form: `-l [<lang>...]`, `--list [<lang>...]`  
  Lists information about active, installed, or voices matching one or more  
  specified languages.  
  Lists all active voices by default; `-a` lists all installed ones.  
  If at least one `<lang>` operand is given, the list of active voices (by  
  default) / installed voices (with `-a`) is filtered to output only those  
  matching the specified language(s).
  `<lang>` values may be mere language IDs (e.g., `en`) or language + region  
  IDs (e.g., `en_US`); e.g., `en` matches all English voices irrespective of  
  region, whereas `en_US` matches only US English voices.

* 4th synopsis form: `-L`, `--list-langs`  
  Lists the distinct set of languages supported among all active (by default)  
  or all installed (`-a`) voices.  
  Languages are listed as language + region identifiers, e.g., `en_US`.

* 5th synopsis form:  `-m`, `--manage`  
  Opens System Preferences > Dictation & Speech, where you can manage the  
  set of active voices, install additional voices, and control other aspects  
  of text-to-speech synthesis.

## SHARED OPTIONS

These options complement the main options, which determine the synopsis form,  
discussed above.

### General Options

  * `-q`    
    Quiet mode: suppresses printed output, such as when only speech output  
    (`-k`) is desired or when the new default voice should be set quietly.  
    Cannot be combined with `-L`, whose sole purpose is to print  
    information.

### Speaking options (synopsis forms 1-3):

Note that if the command targets multiple voices, speaking happens
after each voice's information has been printed (unless printing is  
suppressed with `-q`).

  * `-k`, `--speak` (no argument)  
      Speaks each targeted voice's demo text.

  * `-k"<text>"`, `--speak="<text>"`  
      Speaks the specified text using each targeted voice.  
      Note that `"<text>"` must be directly attached to the option and should  
      generally be quoted to protect it from (unwanted) interpretation by the  
      shell.
    
  * `-k-`, `--speak=-`  
      Speaks text provided via stdin using each targeted voice.

### Printed-Output Options (synopsis forms 1-3)

By default, voice information printed is in the form provided by the standard  
`say` utility when invoked as `say -v \?`, which is:  
`<voice> <lang> # <demo text>`

The following, mutually exclusive options modify this behavior:

  * `-b`, `--bare`  
    Outputs mere voice names only.

  * `-i`, `--internals`  
    Outputs internal voice identifiers, as used by the system.

## STANDARD OPTIONS

All standard options must be provided as the only argument; all of them provide  
information only.

 * `-h, --help`  
   Prints the contents of the synopsis chapter to stdout for quick reference.

 * `--man`  
   Displays this manual page, which is a helpful alternative to using `man`,  
   if the manual page isn't installed.

 * `--version`  
   Prints version information.
  
 * `--home`  
   Opens this utility's home page in the system's default web browser.

## LICENSE

For license information, bug reports, and more, visit this utility's home page  
by running `voices --home`

## EXAMPLES

      # List all active voices; add -a to list all installed ones.
    voices -l         

      # Print information about the default voice and speak its demo text.
    voices -d -k

      # Print information about voice 'Alex'.
    voices alex

      # Make 'Alex' the new default voice, print information about it, and 
      # speak text that announces the change. 
    voices -k'The new default voice is Alex.' -d alex 

      # List languages for which at least one voice is active.
    voices -L

      # List active French voices.
    voices -l fr

      # Speak the respective demo text with all active voices.
    voices -l -k

      # Speak "hello" first with Alex, then with Jill, suppressing printed
      # output.
    voices -k"hello" -q alex jill

      # Print information about all active Spanish voices and speak their
      # respective demo text.
    voices -k -l es

