import {
    AllowedSortDefinitionElement,
    FilterableEnums,
    BuildQueryArgs,
} from "../definitions/args"
export const buildSortExpression = (sortDefinition: AllowedSortDefinitionElement[]) =>
    sortDefinition.map(sortRow => `${sortRow.column} ${sortRow.sortOrder}`).join(", ")

export const buildFilterExpression = (enums: FilterableEnums[], column: string): string =>
    Array.from(new Set(enums))
        .map(e => `${column} = '${e}'`)
        .join(" OR ")

const buildQueryExpression = (
    {
        skip,
        take,
        onlyLevels,
        onlyKingdoms,
        onlyTowerTypes,
        sortDefinition,
    }: BuildQueryArgs,
    tableExpr: string
): string => {
    const levels = buildFilterExpression(onlyLevels, `level`)
    const kingdoms = buildFilterExpression(onlyKingdoms, `kingdom`)
    const towerTypes = buildFilterExpression(onlyTowerTypes, `"towerType"`)
    // TODO: Add check to make sure all elements of the array sortDefinition have unique columns
    const sortColumns = buildSortExpression(sortDefinition)

    const filterExpr = `WHERE (${levels}) AND (${kingdoms}) AND (${towerTypes})`
    const sortExpr = `ORDER BY ${sortColumns}`
    const pageExpr = `LIMIT ${take} OFFSET ${skip}`
    const queryExpression = `SELECT * FROM ${tableExpr} ${filterExpr} ${sortExpr} ${pageExpr}`
    //console.log(queryExpression)
    return queryExpression
}

const nothingLeft = (args: BuildQueryArgs): boolean => {
    const { onlyLevels, onlyTowerTypes, onlyKingdoms } = args
    // we know the query won't result anything if one of the parameters don't have value
    return [onlyLevels, onlyTowerTypes, onlyKingdoms].some(list => list.length === 0)
}

export { nothingLeft, buildQueryExpression }
