using System;
using Cryptography.ECDSA.Internal.Secp256K1;

namespace Cryptography.ECDSA.Internal.Sha256
{
    internal class Hash
    {
        public static void Initialize(Sha256T hash)
        {
            hash.S[0] = 0x6a09e667;
            hash.S[1] = 0xbb67ae85;
            hash.S[2] = 0x3c6ef372;
            hash.S[3] = 0xa54ff53a;
            hash.S[4] = 0x510e527f;
            hash.S[5] = 0x9b05688c;
            hash.S[6] = 0x1f83d9ab;
            hash.S[7] = 0x5be0cd19;
            hash.Bytes = 0;
        }

        public static void Write(Sha256T hash, UInt32[] data, UInt32 len)
        {
            var byfdata = new byte[data.Length * sizeof(UInt32)];
            Util.Memcpy(data, 0, byfdata, 0, byfdata.Length);
            Write(hash, byfdata, len);
        }

        public static void Write(Sha256T hash, byte[] data, UInt32 len)
        {
            var bufsize = hash.Bytes & 0x3F;
            hash.Bytes += len;
            UInt32 index = 0;
            while (bufsize + len >= 64)
            {
                /* Fill the buffer, and process it. */
                Util.Memcpy(data, index, hash.Buf, bufsize, 64 - bufsize);//memcpy(((unsigned char*)hash->buf) + bufsize, data, 64 - bufsize);

                index += 64 - bufsize;
                len -= 64 - bufsize;
                Transform(hash.S, hash.Buf);
                bufsize = 0;
            }
            if (len > 0)
            {
                /* Fill the buffer with what remains. */
                Util.Memcpy(data, index, hash.Buf, bufsize, len);//memcpy(((byte[])hash->buf) + bufsize, data, len);
            }
        }

        /// <summary>
        ///Perform one SHA-256 transformation, processing 16 big endian 32-bit words.
        /// </summary>
        /// <param name="s"></param>
        /// <param name="chunk"></param>
        public static void Transform(UInt32[] s, UInt32[] chunk)
        {
            UInt32 a = s[0], b = s[1], c = s[2], d = s[3], e = s[4], f = s[5], g = s[6], h = s[7];
            UInt32 w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12, w13, w14, w15;
            UInt32 t1, t2;

#if BIGENDIAN
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x428a2f98) + (w0 = (chunk[0]));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x71374491) + (w1 = (chunk[1]));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0xb5c0fbcf) + (w2 = (chunk[2]));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0xe9b5dba5) + (w3 = (chunk[3]));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x3956c25b) + (w4 = (chunk[4]));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x59f111f1) + (w5 = (chunk[5]));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x923f82a4) + (w6 = (chunk[6]));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0xab1c5ed5) + (w7 = (chunk[7]));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0xd807aa98) + (w8 = (chunk[8]));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x12835b01) + (w9 = (chunk[9]));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x243185be) + (w10 = (chunk[10]));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x550c7dc3) + (w11 = (chunk[11]));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x72be5d74) + (w12 = (chunk[12]));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x80deb1fe) + (w13 = (chunk[13]));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x9bdc06a7) + (w14 = (chunk[14]));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0xc19bf174) + (w15 = (chunk[15]));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________

            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0xe49b69c1) + (w0 += (((w14) >> 17 | (w14) << 15) ^ ((w14) >> 19 | (w14) << 13) ^ ((w14) >> 10)) + w9 + (((w1) >> 7 | (w1) << 25) ^ ((w1) >> 18 | (w1) << 14) ^ ((w1) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0xefbe4786) + (w1 += (((w15) >> 17 | (w15) << 15) ^ ((w15) >> 19 | (w15) << 13) ^ ((w15) >> 10)) + w10 + (((w2) >> 7 | (w2) << 25) ^ ((w2) >> 18 | (w2) << 14) ^ ((w2) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x0fc19dc6) + (w2 += (((w0) >> 17 | (w0) << 15) ^ ((w0) >> 19 | (w0) << 13) ^ ((w0) >> 10)) + w11 + (((w3) >> 7 | (w3) << 25) ^ ((w3) >> 18 | (w3) << 14) ^ ((w3) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x240ca1cc) + (w3 += (((w1) >> 17 | (w1) << 15) ^ ((w1) >> 19 | (w1) << 13) ^ ((w1) >> 10)) + w12 + (((w4) >> 7 | (w4) << 25) ^ ((w4) >> 18 | (w4) << 14) ^ ((w4) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x2de92c6f) + (w4 += (((w2) >> 17 | (w2) << 15) ^ ((w2) >> 19 | (w2) << 13) ^ ((w2) >> 10)) + w13 + (((w5) >> 7 | (w5) << 25) ^ ((w5) >> 18 | (w5) << 14) ^ ((w5) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x4a7484aa) + (w5 += (((w3) >> 17 | (w3) << 15) ^ ((w3) >> 19 | (w3) << 13) ^ ((w3) >> 10)) + w14 + (((w6) >> 7 | (w6) << 25) ^ ((w6) >> 18 | (w6) << 14) ^ ((w6) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x5cb0a9dc) + (w6 += (((w4) >> 17 | (w4) << 15) ^ ((w4) >> 19 | (w4) << 13) ^ ((w4) >> 10)) + w15 + (((w7) >> 7 | (w7) << 25) ^ ((w7) >> 18 | (w7) << 14) ^ ((w7) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x76f988da) + (w7 += (((w5) >> 17 | (w5) << 15) ^ ((w5) >> 19 | (w5) << 13) ^ ((w5) >> 10)) + w0 + (((w8) >> 7 | (w8) << 25) ^ ((w8) >> 18 | (w8) << 14) ^ ((w8) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x983e5152) + (w8 += (((w6) >> 17 | (w6) << 15) ^ ((w6) >> 19 | (w6) << 13) ^ ((w6) >> 10)) + w1 + (((w9) >> 7 | (w9) << 25) ^ ((w9) >> 18 | (w9) << 14) ^ ((w9) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0xa831c66d) + (w9 += (((w7) >> 17 | (w7) << 15) ^ ((w7) >> 19 | (w7) << 13) ^ ((w7) >> 10)) + w2 + (((w10) >> 7 | (w10) << 25) ^ ((w10) >> 18 | (w10) << 14) ^ ((w10) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0xb00327c8) + (w10 += (((w8) >> 17 | (w8) << 15) ^ ((w8) >> 19 | (w8) << 13) ^ ((w8) >> 10)) + w3 + (((w11) >> 7 | (w11) << 25) ^ ((w11) >> 18 | (w11) << 14) ^ ((w11) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0xbf597fc7) + (w11 += (((w9) >> 17 | (w9) << 15) ^ ((w9) >> 19 | (w9) << 13) ^ ((w9) >> 10)) + w4 + (((w12) >> 7 | (w12) << 25) ^ ((w12) >> 18 | (w12) << 14) ^ ((w12) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0xc6e00bf3) + (w12 += (((w10) >> 17 | (w10) << 15) ^ ((w10) >> 19 | (w10) << 13) ^ ((w10) >> 10)) + w5 + (((w13) >> 7 | (w13) << 25) ^ ((w13) >> 18 | (w13) << 14) ^ ((w13) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0xd5a79147) + (w13 += (((w11) >> 17 | (w11) << 15) ^ ((w11) >> 19 | (w11) << 13) ^ ((w11) >> 10)) + w6 + (((w14) >> 7 | (w14) << 25) ^ ((w14) >> 18 | (w14) << 14) ^ ((w14) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x06ca6351) + (w14 += (((w12) >> 17 | (w12) << 15) ^ ((w12) >> 19 | (w12) << 13) ^ ((w12) >> 10)) + w7 + (((w15) >> 7 | (w15) << 25) ^ ((w15) >> 18 | (w15) << 14) ^ ((w15) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x14292967) + (w15 += (((w13) >> 17 | (w13) << 15) ^ ((w13) >> 19 | (w13) << 13) ^ ((w13) >> 10)) + w8 + (((w0) >> 7 | (w0) << 25) ^ ((w0) >> 18 | (w0) << 14) ^ ((w0) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________

            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x27b70a85) + (w0 += (((w14) >> 17 | (w14) << 15) ^ ((w14) >> 19 | (w14) << 13) ^ ((w14) >> 10)) + w9 + (((w1) >> 7 | (w1) << 25) ^ ((w1) >> 18 | (w1) << 14) ^ ((w1) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x2e1b2138) + (w1 += (((w15) >> 17 | (w15) << 15) ^ ((w15) >> 19 | (w15) << 13) ^ ((w15) >> 10)) + w10 + (((w2) >> 7 | (w2) << 25) ^ ((w2) >> 18 | (w2) << 14) ^ ((w2) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x4d2c6dfc) + (w2 += (((w0) >> 17 | (w0) << 15) ^ ((w0) >> 19 | (w0) << 13) ^ ((w0) >> 10)) + w11 + (((w3) >> 7 | (w3) << 25) ^ ((w3) >> 18 | (w3) << 14) ^ ((w3) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x53380d13) + (w3 += (((w1) >> 17 | (w1) << 15) ^ ((w1) >> 19 | (w1) << 13) ^ ((w1) >> 10)) + w12 + (((w4) >> 7 | (w4) << 25) ^ ((w4) >> 18 | (w4) << 14) ^ ((w4) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x650a7354) + (w4 += (((w2) >> 17 | (w2) << 15) ^ ((w2) >> 19 | (w2) << 13) ^ ((w2) >> 10)) + w13 + (((w5) >> 7 | (w5) << 25) ^ ((w5) >> 18 | (w5) << 14) ^ ((w5) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x766a0abb) + (w5 += (((w3) >> 17 | (w3) << 15) ^ ((w3) >> 19 | (w3) << 13) ^ ((w3) >> 10)) + w14 + (((w6) >> 7 | (w6) << 25) ^ ((w6) >> 18 | (w6) << 14) ^ ((w6) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x81c2c92e) + (w6 += (((w4) >> 17 | (w4) << 15) ^ ((w4) >> 19 | (w4) << 13) ^ ((w4) >> 10)) + w15 + (((w7) >> 7 | (w7) << 25) ^ ((w7) >> 18 | (w7) << 14) ^ ((w7) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x92722c85) + (w7 += (((w5) >> 17 | (w5) << 15) ^ ((w5) >> 19 | (w5) << 13) ^ ((w5) >> 10)) + w0 + (((w8) >> 7 | (w8) << 25) ^ ((w8) >> 18 | (w8) << 14) ^ ((w8) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0xa2bfe8a1) + (w8 += (((w6) >> 17 | (w6) << 15) ^ ((w6) >> 19 | (w6) << 13) ^ ((w6) >> 10)) + w1 + (((w9) >> 7 | (w9) << 25) ^ ((w9) >> 18 | (w9) << 14) ^ ((w9) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0xa81a664b) + (w9 += (((w7) >> 17 | (w7) << 15) ^ ((w7) >> 19 | (w7) << 13) ^ ((w7) >> 10)) + w2 + (((w10) >> 7 | (w10) << 25) ^ ((w10) >> 18 | (w10) << 14) ^ ((w10) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0xc24b8b70) + (w10 += (((w8) >> 17 | (w8) << 15) ^ ((w8) >> 19 | (w8) << 13) ^ ((w8) >> 10)) + w3 + (((w11) >> 7 | (w11) << 25) ^ ((w11) >> 18 | (w11) << 14) ^ ((w11) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0xc76c51a3) + (w11 += (((w9) >> 17 | (w9) << 15) ^ ((w9) >> 19 | (w9) << 13) ^ ((w9) >> 10)) + w4 + (((w12) >> 7 | (w12) << 25) ^ ((w12) >> 18 | (w12) << 14) ^ ((w12) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0xd192e819) + (w12 += (((w10) >> 17 | (w10) << 15) ^ ((w10) >> 19 | (w10) << 13) ^ ((w10) >> 10)) + w5 + (((w13) >> 7 | (w13) << 25) ^ ((w13) >> 18 | (w13) << 14) ^ ((w13) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0xd6990624) + (w13 += (((w11) >> 17 | (w11) << 15) ^ ((w11) >> 19 | (w11) << 13) ^ ((w11) >> 10)) + w6 + (((w14) >> 7 | (w14) << 25) ^ ((w14) >> 18 | (w14) << 14) ^ ((w14) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0xf40e3585) + (w14 += (((w12) >> 17 | (w12) << 15) ^ ((w12) >> 19 | (w12) << 13) ^ ((w12) >> 10)) + w7 + (((w15) >> 7 | (w15) << 25) ^ ((w15) >> 18 | (w15) << 14) ^ ((w15) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x106aa070) + (w15 += (((w13) >> 17 | (w13) << 15) ^ ((w13) >> 19 | (w13) << 13) ^ ((w13) >> 10)) + w8 + (((w0) >> 7 | (w0) << 25) ^ ((w0) >> 18 | (w0) << 14) ^ ((w0) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________

            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x19a4c116) + (w0 += (((w14) >> 17 | (w14) << 15) ^ ((w14) >> 19 | (w14) << 13) ^ ((w14) >> 10)) + w9 + (((w1) >> 7 | (w1) << 25) ^ ((w1) >> 18 | (w1) << 14) ^ ((w1) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x1e376c08) + (w1 += (((w15) >> 17 | (w15) << 15) ^ ((w15) >> 19 | (w15) << 13) ^ ((w15) >> 10)) + w10 + (((w2) >> 7 | (w2) << 25) ^ ((w2) >> 18 | (w2) << 14) ^ ((w2) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x2748774c) + (w2 += (((w0) >> 17 | (w0) << 15) ^ ((w0) >> 19 | (w0) << 13) ^ ((w0) >> 10)) + w11 + (((w3) >> 7 | (w3) << 25) ^ ((w3) >> 18 | (w3) << 14) ^ ((w3) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x34b0bcb5) + (w3 += (((w1) >> 17 | (w1) << 15) ^ ((w1) >> 19 | (w1) << 13) ^ ((w1) >> 10)) + w12 + (((w4) >> 7 | (w4) << 25) ^ ((w4) >> 18 | (w4) << 14) ^ ((w4) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x391c0cb3) + (w4 += (((w2) >> 17 | (w2) << 15) ^ ((w2) >> 19 | (w2) << 13) ^ ((w2) >> 10)) + w13 + (((w5) >> 7 | (w5) << 25) ^ ((w5) >> 18 | (w5) << 14) ^ ((w5) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x4ed8aa4a) + (w5 += (((w3) >> 17 | (w3) << 15) ^ ((w3) >> 19 | (w3) << 13) ^ ((w3) >> 10)) + w14 + (((w6) >> 7 | (w6) << 25) ^ ((w6) >> 18 | (w6) << 14) ^ ((w6) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x5b9cca4f) + (w6 += (((w4) >> 17 | (w4) << 15) ^ ((w4) >> 19 | (w4) << 13) ^ ((w4) >> 10)) + w15 + (((w7) >> 7 | (w7) << 25) ^ ((w7) >> 18 | (w7) << 14) ^ ((w7) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x682e6ff3) + (w7 += (((w5) >> 17 | (w5) << 15) ^ ((w5) >> 19 | (w5) << 13) ^ ((w5) >> 10)) + w0 + (((w8) >> 7 | (w8) << 25) ^ ((w8) >> 18 | (w8) << 14) ^ ((w8) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x748f82ee) + (w8 += (((w6) >> 17 | (w6) << 15) ^ ((w6) >> 19 | (w6) << 13) ^ ((w6) >> 10)) + w1 + (((w9) >> 7 | (w9) << 25) ^ ((w9) >> 18 | (w9) << 14) ^ ((w9) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x78a5636f) + (w9 += (((w7) >> 17 | (w7) << 15) ^ ((w7) >> 19 | (w7) << 13) ^ ((w7) >> 10)) + w2 + (((w10) >> 7 | (w10) << 25) ^ ((w10) >> 18 | (w10) << 14) ^ ((w10) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x84c87814) + (w10 += (((w8) >> 17 | (w8) << 15) ^ ((w8) >> 19 | (w8) << 13) ^ ((w8) >> 10)) + w3 + (((w11) >> 7 | (w11) << 25) ^ ((w11) >> 18 | (w11) << 14) ^ ((w11) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x8cc70208) + (w11 += (((w9) >> 17 | (w9) << 15) ^ ((w9) >> 19 | (w9) << 13) ^ ((w9) >> 10)) + w4 + (((w12) >> 7 | (w12) << 25) ^ ((w12) >> 18 | (w12) << 14) ^ ((w12) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x90befffa) + (w12 += (((w10) >> 17 | (w10) << 15) ^ ((w10) >> 19 | (w10) << 13) ^ ((w10) >> 10)) + w5 + (((w13) >> 7 | (w13) << 25) ^ ((w13) >> 18 | (w13) << 14) ^ ((w13) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0xa4506ceb) + (w13 += (((w11) >> 17 | (w11) << 15) ^ ((w11) >> 19 | (w11) << 13) ^ ((w11) >> 10)) + w6 + (((w14) >> 7 | (w14) << 25) ^ ((w14) >> 18 | (w14) << 14) ^ ((w14) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0xbef9a3f7) + (w14 + (((w12) >> 17 | (w12) << 15) ^ ((w12) >> 19 | (w12) << 13) ^ ((w12) >> 10)) + w7 + (((w15) >> 7 | (w15) << 25) ^ ((w15) >> 18 | (w15) << 14) ^ ((w15) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0xc67178f2) + (w15 + (((w13) >> 17 | (w13) << 15) ^ ((w13) >> 19 | (w13) << 13) ^ ((w13) >> 10)) + w8 + (((w0) >> 7 | (w0) << 25) ^ ((w0) >> 18 | (w0) << 14) ^ ((w0) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
#else
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x428a2f98) + (w0 = ((((chunk[0]) & 0xFF) << 24) | (((chunk[0]) & 0xFF00) << 8) | (((chunk[0]) & 0xFF0000) >> 8) | (((chunk[0]) & 0xFF000000) >> 24)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x71374491) + (w1 = ((((chunk[1]) & 0xFF) << 24) | (((chunk[1]) & 0xFF00) << 8) | (((chunk[1]) & 0xFF0000) >> 8) | (((chunk[1]) & 0xFF000000) >> 24)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0xb5c0fbcf) + (w2 = ((((chunk[2]) & 0xFF) << 24) | (((chunk[2]) & 0xFF00) << 8) | (((chunk[2]) & 0xFF0000) >> 8) | (((chunk[2]) & 0xFF000000) >> 24)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0xe9b5dba5) + (w3 = ((((chunk[3]) & 0xFF) << 24) | (((chunk[3]) & 0xFF00) << 8) | (((chunk[3]) & 0xFF0000) >> 8) | (((chunk[3]) & 0xFF000000) >> 24)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x3956c25b) + (w4 = ((((chunk[4]) & 0xFF) << 24) | (((chunk[4]) & 0xFF00) << 8) | (((chunk[4]) & 0xFF0000) >> 8) | (((chunk[4]) & 0xFF000000) >> 24)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x59f111f1) + (w5 = ((((chunk[5]) & 0xFF) << 24) | (((chunk[5]) & 0xFF00) << 8) | (((chunk[5]) & 0xFF0000) >> 8) | (((chunk[5]) & 0xFF000000) >> 24)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x923f82a4) + (w6 = ((((chunk[6]) & 0xFF) << 24) | (((chunk[6]) & 0xFF00) << 8) | (((chunk[6]) & 0xFF0000) >> 8) | (((chunk[6]) & 0xFF000000) >> 24)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0xab1c5ed5) + (w7 = ((((chunk[7]) & 0xFF) << 24) | (((chunk[7]) & 0xFF00) << 8) | (((chunk[7]) & 0xFF0000) >> 8) | (((chunk[7]) & 0xFF000000) >> 24)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0xd807aa98) + (w8 = ((((chunk[8]) & 0xFF) << 24) | (((chunk[8]) & 0xFF00) << 8) | (((chunk[8]) & 0xFF0000) >> 8) | (((chunk[8]) & 0xFF000000) >> 24)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x12835b01) + (w9 = ((((chunk[9]) & 0xFF) << 24) | (((chunk[9]) & 0xFF00) << 8) | (((chunk[9]) & 0xFF0000) >> 8) | (((chunk[9]) & 0xFF000000) >> 24)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x243185be) + (w10 = ((((chunk[10]) & 0xFF) << 24) | (((chunk[10]) & 0xFF00) << 8) | (((chunk[10]) & 0xFF0000) >> 8) | (((chunk[10]) & 0xFF000000) >> 24)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x550c7dc3) + (w11 = ((((chunk[11]) & 0xFF) << 24) | (((chunk[11]) & 0xFF00) << 8) | (((chunk[11]) & 0xFF0000) >> 8) | (((chunk[11]) & 0xFF000000) >> 24)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x72be5d74) + (w12 = ((((chunk[12]) & 0xFF) << 24) | (((chunk[12]) & 0xFF00) << 8) | (((chunk[12]) & 0xFF0000) >> 8) | (((chunk[12]) & 0xFF000000) >> 24)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x80deb1fe) + (w13 = ((((chunk[13]) & 0xFF) << 24) | (((chunk[13]) & 0xFF00) << 8) | (((chunk[13]) & 0xFF0000) >> 8) | (((chunk[13]) & 0xFF000000) >> 24)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x9bdc06a7) + (w14 = ((((chunk[14]) & 0xFF) << 24) | (((chunk[14]) & 0xFF00) << 8) | (((chunk[14]) & 0xFF0000) >> 8) | (((chunk[14]) & 0xFF000000) >> 24)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0xc19bf174) + (w15 = ((((chunk[15]) & 0xFF) << 24) | (((chunk[15]) & 0xFF00) << 8) | (((chunk[15]) & 0xFF0000) >> 8) | (((chunk[15]) & 0xFF000000) >> 24)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________

            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0xe49b69c1) + (w0 += (((w14) >> 17 | (w14) << 15) ^ ((w14) >> 19 | (w14) << 13) ^ ((w14) >> 10)) + w9 + (((w1) >> 7 | (w1) << 25) ^ ((w1) >> 18 | (w1) << 14) ^ ((w1) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0xefbe4786) + (w1 += (((w15) >> 17 | (w15) << 15) ^ ((w15) >> 19 | (w15) << 13) ^ ((w15) >> 10)) + w10 + (((w2) >> 7 | (w2) << 25) ^ ((w2) >> 18 | (w2) << 14) ^ ((w2) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x0fc19dc6) + (w2 += (((w0) >> 17 | (w0) << 15) ^ ((w0) >> 19 | (w0) << 13) ^ ((w0) >> 10)) + w11 + (((w3) >> 7 | (w3) << 25) ^ ((w3) >> 18 | (w3) << 14) ^ ((w3) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x240ca1cc) + (w3 += (((w1) >> 17 | (w1) << 15) ^ ((w1) >> 19 | (w1) << 13) ^ ((w1) >> 10)) + w12 + (((w4) >> 7 | (w4) << 25) ^ ((w4) >> 18 | (w4) << 14) ^ ((w4) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x2de92c6f) + (w4 += (((w2) >> 17 | (w2) << 15) ^ ((w2) >> 19 | (w2) << 13) ^ ((w2) >> 10)) + w13 + (((w5) >> 7 | (w5) << 25) ^ ((w5) >> 18 | (w5) << 14) ^ ((w5) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x4a7484aa) + (w5 += (((w3) >> 17 | (w3) << 15) ^ ((w3) >> 19 | (w3) << 13) ^ ((w3) >> 10)) + w14 + (((w6) >> 7 | (w6) << 25) ^ ((w6) >> 18 | (w6) << 14) ^ ((w6) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x5cb0a9dc) + (w6 += (((w4) >> 17 | (w4) << 15) ^ ((w4) >> 19 | (w4) << 13) ^ ((w4) >> 10)) + w15 + (((w7) >> 7 | (w7) << 25) ^ ((w7) >> 18 | (w7) << 14) ^ ((w7) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x76f988da) + (w7 += (((w5) >> 17 | (w5) << 15) ^ ((w5) >> 19 | (w5) << 13) ^ ((w5) >> 10)) + w0 + (((w8) >> 7 | (w8) << 25) ^ ((w8) >> 18 | (w8) << 14) ^ ((w8) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x983e5152) + (w8 += (((w6) >> 17 | (w6) << 15) ^ ((w6) >> 19 | (w6) << 13) ^ ((w6) >> 10)) + w1 + (((w9) >> 7 | (w9) << 25) ^ ((w9) >> 18 | (w9) << 14) ^ ((w9) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0xa831c66d) + (w9 += (((w7) >> 17 | (w7) << 15) ^ ((w7) >> 19 | (w7) << 13) ^ ((w7) >> 10)) + w2 + (((w10) >> 7 | (w10) << 25) ^ ((w10) >> 18 | (w10) << 14) ^ ((w10) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0xb00327c8) + (w10 += (((w8) >> 17 | (w8) << 15) ^ ((w8) >> 19 | (w8) << 13) ^ ((w8) >> 10)) + w3 + (((w11) >> 7 | (w11) << 25) ^ ((w11) >> 18 | (w11) << 14) ^ ((w11) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0xbf597fc7) + (w11 += (((w9) >> 17 | (w9) << 15) ^ ((w9) >> 19 | (w9) << 13) ^ ((w9) >> 10)) + w4 + (((w12) >> 7 | (w12) << 25) ^ ((w12) >> 18 | (w12) << 14) ^ ((w12) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0xc6e00bf3) + (w12 += (((w10) >> 17 | (w10) << 15) ^ ((w10) >> 19 | (w10) << 13) ^ ((w10) >> 10)) + w5 + (((w13) >> 7 | (w13) << 25) ^ ((w13) >> 18 | (w13) << 14) ^ ((w13) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0xd5a79147) + (w13 += (((w11) >> 17 | (w11) << 15) ^ ((w11) >> 19 | (w11) << 13) ^ ((w11) >> 10)) + w6 + (((w14) >> 7 | (w14) << 25) ^ ((w14) >> 18 | (w14) << 14) ^ ((w14) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x06ca6351) + (w14 += (((w12) >> 17 | (w12) << 15) ^ ((w12) >> 19 | (w12) << 13) ^ ((w12) >> 10)) + w7 + (((w15) >> 7 | (w15) << 25) ^ ((w15) >> 18 | (w15) << 14) ^ ((w15) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x14292967) + (w15 += (((w13) >> 17 | (w13) << 15) ^ ((w13) >> 19 | (w13) << 13) ^ ((w13) >> 10)) + w8 + (((w0) >> 7 | (w0) << 25) ^ ((w0) >> 18 | (w0) << 14) ^ ((w0) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________

            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x27b70a85) + (w0 += (((w14) >> 17 | (w14) << 15) ^ ((w14) >> 19 | (w14) << 13) ^ ((w14) >> 10)) + w9 + (((w1) >> 7 | (w1) << 25) ^ ((w1) >> 18 | (w1) << 14) ^ ((w1) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x2e1b2138) + (w1 += (((w15) >> 17 | (w15) << 15) ^ ((w15) >> 19 | (w15) << 13) ^ ((w15) >> 10)) + w10 + (((w2) >> 7 | (w2) << 25) ^ ((w2) >> 18 | (w2) << 14) ^ ((w2) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x4d2c6dfc) + (w2 += (((w0) >> 17 | (w0) << 15) ^ ((w0) >> 19 | (w0) << 13) ^ ((w0) >> 10)) + w11 + (((w3) >> 7 | (w3) << 25) ^ ((w3) >> 18 | (w3) << 14) ^ ((w3) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x53380d13) + (w3 += (((w1) >> 17 | (w1) << 15) ^ ((w1) >> 19 | (w1) << 13) ^ ((w1) >> 10)) + w12 + (((w4) >> 7 | (w4) << 25) ^ ((w4) >> 18 | (w4) << 14) ^ ((w4) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x650a7354) + (w4 += (((w2) >> 17 | (w2) << 15) ^ ((w2) >> 19 | (w2) << 13) ^ ((w2) >> 10)) + w13 + (((w5) >> 7 | (w5) << 25) ^ ((w5) >> 18 | (w5) << 14) ^ ((w5) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x766a0abb) + (w5 += (((w3) >> 17 | (w3) << 15) ^ ((w3) >> 19 | (w3) << 13) ^ ((w3) >> 10)) + w14 + (((w6) >> 7 | (w6) << 25) ^ ((w6) >> 18 | (w6) << 14) ^ ((w6) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x81c2c92e) + (w6 += (((w4) >> 17 | (w4) << 15) ^ ((w4) >> 19 | (w4) << 13) ^ ((w4) >> 10)) + w15 + (((w7) >> 7 | (w7) << 25) ^ ((w7) >> 18 | (w7) << 14) ^ ((w7) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x92722c85) + (w7 += (((w5) >> 17 | (w5) << 15) ^ ((w5) >> 19 | (w5) << 13) ^ ((w5) >> 10)) + w0 + (((w8) >> 7 | (w8) << 25) ^ ((w8) >> 18 | (w8) << 14) ^ ((w8) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0xa2bfe8a1) + (w8 += (((w6) >> 17 | (w6) << 15) ^ ((w6) >> 19 | (w6) << 13) ^ ((w6) >> 10)) + w1 + (((w9) >> 7 | (w9) << 25) ^ ((w9) >> 18 | (w9) << 14) ^ ((w9) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0xa81a664b) + (w9 += (((w7) >> 17 | (w7) << 15) ^ ((w7) >> 19 | (w7) << 13) ^ ((w7) >> 10)) + w2 + (((w10) >> 7 | (w10) << 25) ^ ((w10) >> 18 | (w10) << 14) ^ ((w10) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0xc24b8b70) + (w10 += (((w8) >> 17 | (w8) << 15) ^ ((w8) >> 19 | (w8) << 13) ^ ((w8) >> 10)) + w3 + (((w11) >> 7 | (w11) << 25) ^ ((w11) >> 18 | (w11) << 14) ^ ((w11) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0xc76c51a3) + (w11 += (((w9) >> 17 | (w9) << 15) ^ ((w9) >> 19 | (w9) << 13) ^ ((w9) >> 10)) + w4 + (((w12) >> 7 | (w12) << 25) ^ ((w12) >> 18 | (w12) << 14) ^ ((w12) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0xd192e819) + (w12 += (((w10) >> 17 | (w10) << 15) ^ ((w10) >> 19 | (w10) << 13) ^ ((w10) >> 10)) + w5 + (((w13) >> 7 | (w13) << 25) ^ ((w13) >> 18 | (w13) << 14) ^ ((w13) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0xd6990624) + (w13 += (((w11) >> 17 | (w11) << 15) ^ ((w11) >> 19 | (w11) << 13) ^ ((w11) >> 10)) + w6 + (((w14) >> 7 | (w14) << 25) ^ ((w14) >> 18 | (w14) << 14) ^ ((w14) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0xf40e3585) + (w14 += (((w12) >> 17 | (w12) << 15) ^ ((w12) >> 19 | (w12) << 13) ^ ((w12) >> 10)) + w7 + (((w15) >> 7 | (w15) << 25) ^ ((w15) >> 18 | (w15) << 14) ^ ((w15) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x106aa070) + (w15 += (((w13) >> 17 | (w13) << 15) ^ ((w13) >> 19 | (w13) << 13) ^ ((w13) >> 10)) + w8 + (((w0) >> 7 | (w0) << 25) ^ ((w0) >> 18 | (w0) << 14) ^ ((w0) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________

            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x19a4c116) + (w0 += (((w14) >> 17 | (w14) << 15) ^ ((w14) >> 19 | (w14) << 13) ^ ((w14) >> 10)) + w9 + (((w1) >> 7 | (w1) << 25) ^ ((w1) >> 18 | (w1) << 14) ^ ((w1) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x1e376c08) + (w1 += (((w15) >> 17 | (w15) << 15) ^ ((w15) >> 19 | (w15) << 13) ^ ((w15) >> 10)) + w10 + (((w2) >> 7 | (w2) << 25) ^ ((w2) >> 18 | (w2) << 14) ^ ((w2) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x2748774c) + (w2 += (((w0) >> 17 | (w0) << 15) ^ ((w0) >> 19 | (w0) << 13) ^ ((w0) >> 10)) + w11 + (((w3) >> 7 | (w3) << 25) ^ ((w3) >> 18 | (w3) << 14) ^ ((w3) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x34b0bcb5) + (w3 += (((w1) >> 17 | (w1) << 15) ^ ((w1) >> 19 | (w1) << 13) ^ ((w1) >> 10)) + w12 + (((w4) >> 7 | (w4) << 25) ^ ((w4) >> 18 | (w4) << 14) ^ ((w4) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x391c0cb3) + (w4 += (((w2) >> 17 | (w2) << 15) ^ ((w2) >> 19 | (w2) << 13) ^ ((w2) >> 10)) + w13 + (((w5) >> 7 | (w5) << 25) ^ ((w5) >> 18 | (w5) << 14) ^ ((w5) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0x4ed8aa4a) + (w5 += (((w3) >> 17 | (w3) << 15) ^ ((w3) >> 19 | (w3) << 13) ^ ((w3) >> 10)) + w14 + (((w6) >> 7 | (w6) << 25) ^ ((w6) >> 18 | (w6) << 14) ^ ((w6) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0x5b9cca4f) + (w6 += (((w4) >> 17 | (w4) << 15) ^ ((w4) >> 19 | (w4) << 13) ^ ((w4) >> 10)) + w15 + (((w7) >> 7 | (w7) << 25) ^ ((w7) >> 18 | (w7) << 14) ^ ((w7) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0x682e6ff3) + (w7 += (((w5) >> 17 | (w5) << 15) ^ ((w5) >> 19 | (w5) << 13) ^ ((w5) >> 10)) + w0 + (((w8) >> 7 | (w8) << 25) ^ ((w8) >> 18 | (w8) << 14) ^ ((w8) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (h) + (((e) >> 6 | (e) << 26) ^ ((e) >> 11 | (e) << 21) ^ ((e) >> 25 | (e) << 7)) + ((g) ^ ((e) & ((f) ^ (g)))) + (0x748f82ee) + (w8 += (((w6) >> 17 | (w6) << 15) ^ ((w6) >> 19 | (w6) << 13) ^ ((w6) >> 10)) + w1 + (((w9) >> 7 | (w9) << 25) ^ ((w9) >> 18 | (w9) << 14) ^ ((w9) >> 3)));
            t2 = (((a) >> 2 | (a) << 30) ^ ((a) >> 13 | (a) << 19) ^ ((a) >> 22 | (a) << 10)) + (((a) & (b)) | ((c) & ((a) | (b))));
            (d) += t1;
            (h) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (g) + (((d) >> 6 | (d) << 26) ^ ((d) >> 11 | (d) << 21) ^ ((d) >> 25 | (d) << 7)) + ((f) ^ ((d) & ((e) ^ (f)))) + (0x78a5636f) + (w9 += (((w7) >> 17 | (w7) << 15) ^ ((w7) >> 19 | (w7) << 13) ^ ((w7) >> 10)) + w2 + (((w10) >> 7 | (w10) << 25) ^ ((w10) >> 18 | (w10) << 14) ^ ((w10) >> 3)));
            t2 = (((h) >> 2 | (h) << 30) ^ ((h) >> 13 | (h) << 19) ^ ((h) >> 22 | (h) << 10)) + (((h) & (a)) | ((b) & ((h) | (a))));
            (c) += t1;
            (g) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (f) + (((c) >> 6 | (c) << 26) ^ ((c) >> 11 | (c) << 21) ^ ((c) >> 25 | (c) << 7)) + ((e) ^ ((c) & ((d) ^ (e)))) + (0x84c87814) + (w10 += (((w8) >> 17 | (w8) << 15) ^ ((w8) >> 19 | (w8) << 13) ^ ((w8) >> 10)) + w3 + (((w11) >> 7 | (w11) << 25) ^ ((w11) >> 18 | (w11) << 14) ^ ((w11) >> 3)));
            t2 = (((g) >> 2 | (g) << 30) ^ ((g) >> 13 | (g) << 19) ^ ((g) >> 22 | (g) << 10)) + (((g) & (h)) | ((a) & ((g) | (h))));
            (b) += t1;
            (f) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (e) + (((b) >> 6 | (b) << 26) ^ ((b) >> 11 | (b) << 21) ^ ((b) >> 25 | (b) << 7)) + ((d) ^ ((b) & ((c) ^ (d)))) + (0x8cc70208) + (w11 += (((w9) >> 17 | (w9) << 15) ^ ((w9) >> 19 | (w9) << 13) ^ ((w9) >> 10)) + w4 + (((w12) >> 7 | (w12) << 25) ^ ((w12) >> 18 | (w12) << 14) ^ ((w12) >> 3)));
            t2 = (((f) >> 2 | (f) << 30) ^ ((f) >> 13 | (f) << 19) ^ ((f) >> 22 | (f) << 10)) + (((f) & (g)) | ((h) & ((f) | (g))));
            (a) += t1;
            (e) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (d) + (((a) >> 6 | (a) << 26) ^ ((a) >> 11 | (a) << 21) ^ ((a) >> 25 | (a) << 7)) + ((c) ^ ((a) & ((b) ^ (c)))) + (0x90befffa) + (w12 += (((w10) >> 17 | (w10) << 15) ^ ((w10) >> 19 | (w10) << 13) ^ ((w10) >> 10)) + w5 + (((w13) >> 7 | (w13) << 25) ^ ((w13) >> 18 | (w13) << 14) ^ ((w13) >> 3)));
            t2 = (((e) >> 2 | (e) << 30) ^ ((e) >> 13 | (e) << 19) ^ ((e) >> 22 | (e) << 10)) + (((e) & (f)) | ((g) & ((e) | (f))));
            (h) += t1;
            (d) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (c) + (((h) >> 6 | (h) << 26) ^ ((h) >> 11 | (h) << 21) ^ ((h) >> 25 | (h) << 7)) + ((b) ^ ((h) & ((a) ^ (b)))) + (0xa4506ceb) + (w13 += (((w11) >> 17 | (w11) << 15) ^ ((w11) >> 19 | (w11) << 13) ^ ((w11) >> 10)) + w6 + (((w14) >> 7 | (w14) << 25) ^ ((w14) >> 18 | (w14) << 14) ^ ((w14) >> 3)));
            t2 = (((d) >> 2 | (d) << 30) ^ ((d) >> 13 | (d) << 19) ^ ((d) >> 22 | (d) << 10)) + (((d) & (e)) | ((f) & ((d) | (e))));
            (g) += t1;
            (c) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (b) + (((g) >> 6 | (g) << 26) ^ ((g) >> 11 | (g) << 21) ^ ((g) >> 25 | (g) << 7)) + ((a) ^ ((g) & ((h) ^ (a)))) + (0xbef9a3f7) + (w14 + (((w12) >> 17 | (w12) << 15) ^ ((w12) >> 19 | (w12) << 13) ^ ((w12) >> 10)) + w7 + (((w15) >> 7 | (w15) << 25) ^ ((w15) >> 18 | (w15) << 14) ^ ((w15) >> 3)));
            t2 = (((c) >> 2 | (c) << 30) ^ ((c) >> 13 | (c) << 19) ^ ((c) >> 22 | (c) << 10)) + (((c) & (d)) | ((e) & ((c) | (d))));
            (f) += t1;
            (b) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
            t1 = (a) + (((f) >> 6 | (f) << 26) ^ ((f) >> 11 | (f) << 21) ^ ((f) >> 25 | (f) << 7)) + ((h) ^ ((f) & ((g) ^ (h)))) + (0xc67178f2) + (w15 + (((w13) >> 17 | (w13) << 15) ^ ((w13) >> 19 | (w13) << 13) ^ ((w13) >> 10)) + w8 + (((w0) >> 7 | (w0) << 25) ^ ((w0) >> 18 | (w0) << 14) ^ ((w0) >> 3)));
            t2 = (((b) >> 2 | (b) << 30) ^ ((b) >> 13 | (b) << 19) ^ ((b) >> 22 | (b) << 10)) + (((b) & (c)) | ((d) & ((b) | (c))));
            (e) += t1;
            (a) = t1 + t2;
            //___________________________________________________________________________________________________________________________________
#endif

            s[0] += a;
            s[1] += b;
            s[2] += c;
            s[3] += d;
            s[4] += e;
            s[5] += f;
            s[6] += g;
            s[7] += h;
        }


        public static void Finalize(Sha256T hash, byte[] out32)
        {
            var pad = new byte[64] { 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
            var sizedesc = new UInt32[2];
            var byfOut = new UInt32[8];
            var i = 0;

#if BIGENDIAN
            sizedesc[0] = (UInt32)(hash.bytes >> 29);
            sizedesc[1] = (UInt32)(hash.bytes << 3);
            Write(hash, pad, 1 + ((119 - (hash.bytes % 64)) % 64));
            Write(hash, sizedesc, 8);
            for (i = 0; i < 8; i++)
            {
                byfOut[i] = hash.s[i];
                hash.s[i] = 0;
            }
#else
            sizedesc[0] = (UInt32)(((((hash.Bytes >> 29) & 0xFF) << 24) | (((hash.Bytes >> 29) & 0xFF00) << 8) | (((hash.Bytes >> 29) & 0xFF0000) >> 8) | (((hash.Bytes >> 29) & 0xFF000000) >> 24)));
            sizedesc[1] = (UInt32)(((((hash.Bytes << 3) & 0xFF) << 24) | (((hash.Bytes << 3) & 0xFF00) << 8) | (((hash.Bytes << 3) & 0xFF0000) >> 8) | (((hash.Bytes << 3) & 0xFF000000) >> 24)));
            Write(hash, pad, 1 + ((119 - (hash.Bytes % 64)) % 64));
            Write(hash, sizedesc, 8);
            for (i = 0; i < 8; i++)
            {
                byfOut[i] = ((((hash.S[i]) & 0xFF) << 24) | (((hash.S[i]) & 0xFF00) << 8) | (((hash.S[i]) & 0xFF0000) >> 8) | (((hash.S[i]) & 0xFF000000) >> 24));
                hash.S[i] = 0;
            }
#endif
            Util.Memcpy(byfOut, 0, out32, 0, 32);//memcpy(out32, (const byte[])byfOut, 32);
        }

        private static void HmacSha256Initialize(HmacSha256T hash, byte[] key, UInt32 keylen)
        {
            var rkey = new byte[64];
            if (keylen <= 64)
            {
                Util.Memcpy(key, 0, rkey, 0, keylen);//memcpy(rkey, key, keylen);
                Util.MemSet(rkey, keylen, 0, 64 - keylen);//memset(rkey + keylen, 0, 64 - keylen);
            }
            else
            {
                var sha256 = new Sha256T();
                Initialize(sha256);
                Write(sha256, key, keylen);
                Finalize(sha256, rkey);
                Util.MemSet(rkey, 32, 0, 32); //memset(rkey + 32, 0, 32);
            }

            int n;
            Initialize(hash.Outer);
            for (n = 0; n < 64; n++)
            {
                rkey[n] ^= 0x5c;
            }
            Write(hash.Outer, rkey, 64);

            Initialize(hash.Inner);
            for (n = 0; n < 64; n++)
            {
                rkey[n] ^= 0x5c ^ 0x36;
            }
            Write(hash.Inner, rkey, 64);
            Util.MemSet(rkey, 0, 64);//memset(rkey, 0, 64);
        }

        private static void HmacSha256Write(HmacSha256T hash, byte[] data, UInt32 size)
        {
            Write(hash.Inner, data, size);
        }

        static void HmacSha256Finalize(HmacSha256T hash, byte[] out32)
        {
            var temp = new byte[32];
            Finalize(hash.Inner, temp);
            Write(hash.Outer, temp, 32);
            Util.MemSet(temp, 0, 32);//memset(temp, 0, 32);
            Finalize(hash.Outer, out32);
        }

        public static void Rfc6979HmacSha256Initialize(Rfc6979HmacSha256T rng, byte[] key, UInt32 keylen)
        {
            var hmac = new HmacSha256T();
            var zero = new byte[] { 0x00 };
            var one = new byte[] { 0x01 };

            Util.MemSet(rng.V, 0x01, 32);//memset(rng->v, 0x01, 32); /* RFC6979 3.2.b. */
            Util.MemSet(rng.K, 0x00, 32);//memset(rng->k, 0x00, 32); /* RFC6979 3.2.c. */

            /* RFC6979 3.2.d. */
            HmacSha256Initialize(hmac, rng.K, 32);
            HmacSha256Write(hmac, rng.V, 32);
            HmacSha256Write(hmac, zero, 1);
            HmacSha256Write(hmac, key, keylen);
            HmacSha256Finalize(hmac, rng.K);
            HmacSha256Initialize(hmac, rng.K, 32);
            HmacSha256Write(hmac, rng.V, 32);
            HmacSha256Finalize(hmac, rng.V);

            /* RFC6979 3.2.f. */
            HmacSha256Initialize(hmac, rng.K, 32);
            HmacSha256Write(hmac, rng.V, 32);
            HmacSha256Write(hmac, one, 1);
            HmacSha256Write(hmac, key, keylen);
            HmacSha256Finalize(hmac, rng.K);
            HmacSha256Initialize(hmac, rng.K, 32);
            HmacSha256Write(hmac, rng.V, 32);
            HmacSha256Finalize(hmac, rng.V);
            rng.Retry = false;
        }

        public static void Rfc6979HmacSha256Generate(Rfc6979HmacSha256T rng, byte[] outdata, int outlen)
        {
            /* RFC6979 3.2.h. */
            var zero = new byte[1] { 0x00 };
            if (rng.Retry)
            {
                var hmac = new HmacSha256T();
                HmacSha256Initialize(hmac, rng.K, 32);
                HmacSha256Write(hmac, rng.V, 32);
                HmacSha256Write(hmac, zero, 1);
                HmacSha256Finalize(hmac, rng.K);
                HmacSha256Initialize(hmac, rng.K, 32);
                HmacSha256Write(hmac, rng.V, 32);
                HmacSha256Finalize(hmac, rng.V);
            }

            var index = 0;
            while (outlen > 0)
            {
                var hmac = new HmacSha256T();
                var now = outlen;
                HmacSha256Initialize(hmac, rng.K, 32);
                HmacSha256Write(hmac, rng.V, 32);
                HmacSha256Finalize(hmac, rng.V);
                if (now > 32)
                {
                    now = 32;
                }
                Util.Memcpy(rng.V, 0, outdata, index, now); //memcpy(outdata, rng.v, now);
                index += now;
                outlen -= now;
            }
            rng.Retry = true;
        }

        public static void Rfc6979HmacSha256Finalize(Rfc6979HmacSha256T rng)
        {
            Util.MemSet(rng.K, 0, 32); //memset(rng.k, 0, 32);
            Util.MemSet(rng.V, 0, 32); //memset(rng.v, 0, 32);
            rng.Retry = false;
        }
    }
}