#!/bin/bash
#
# This is a rather minimal example Argbash potential
# Example taken from http://argbash.readthedocs.io/en/stable/example.html
#
# ARG_OPTIONAL_INCREMENTAL([all-interfaces],[a],[Listen on all interfaces])
# ARG_VERSION([echo run.sh v$version])
# ARG_OPTIONAL_SINGLE([external-findings],[e],[External findings repository])
# ARG_HELP([The general script's help msg])
# ARGBASH_GO()
# needed because of Argbash --> m4_ignore([
### START OF CODE GENERATED BY Argbash v2.6.1 one line above ###
# Argbash is a bash code generator used to get arguments parsing right.
# Argbash is FREE SOFTWARE, see https://argbash.io for more info
# Generated online by https://argbash.io/generate

die()
{
	local _ret=$2
	test -n "$_ret" || _ret=1
	test "$_PRINT_HELP" = yes && print_help >&2
	echo "$1" >&2
	exit ${_ret}
}

begins_with_short_option()
{
	local first_option all_short_options
	all_short_options='aveh'
	first_option="${1:0:1}"
	test "$all_short_options" = "${all_short_options/$first_option/}" && return 1 || return 0
}

# THE DEFAULTS INITIALIZATION - OPTIONALS
_arg_all_interfaces=0
_arg_external_findings=

print_help ()
{
	printf '%s\n' "The general script's help msg"
	printf 'Usage: %s [-a|--all-interfaces] [-v|--version] [-e|--external-findings <arg>] [-h|--help]\n' "$0"
	printf '\t%s\n' "-a,--all-interfaces: Listen on all interfaces"
	printf '\t%s\n' "-v,--version: Prints version"
	printf '\t%s\n' "-e,--external-findings: External findings repository (no default)"
	printf '\t%s\n' "-h,--help: Prints help"
}

parse_commandline ()
{
	while test $# -gt 0
	do
		_key="$1"
		case "$_key" in
			-a|--all-interfaces)
				_arg_all_interfaces=$((_arg_all_interfaces + 1))
				;;
			-a*)
				_arg_all_interfaces=$((_arg_all_interfaces + 1))
				_next="${_key##-a}"
				if test -n "$_next" -a "$_next" != "$_key"
				then
					begins_with_short_option "$_next" && shift && set -- "-a" "-${_next}" "$@" || die "The short option '$_key' can't be decomposed to ${_key:0:2} and -${_key:2}, because ${_key:0:2} doesn't accept value and '-${_key:2:1}' doesn't correspond to a short option."
				fi
				;;
			-v|--version)
				echo run.sh v$version
				exit 0
				;;
			-v*)
				echo run.sh v$version
				exit 0
				;;
			-e|--external-findings)
				test $# -lt 2 && die "Missing value for the optional argument '$_key'." 1
				_arg_external_findings="$2"
				shift
				;;
			--external-findings=*)
				_arg_external_findings="${_key##--external-findings=}"
				;;
			-e*)
				_arg_external_findings="${_key##-e}"
				;;
			-h|--help)
				print_help
				exit 0
				;;
			-h*)
				print_help
				exit 0
				;;
			*)
				_PRINT_HELP=yes die "FATAL ERROR: Got an unexpected argument '$1'" 1
				;;
		esac
		shift
	done
}

parse_commandline "$@"

SQUASH_JSON_FILE='template_findings.json'
CURL_COOKIE_JAR='/tmp/curl_cookie_jar'
LISTEN_ADDRESS=127.0.0.1

EXTERNAL_FINDINGS=$_arg_external_findings

echo "'$_arg_external_findings'"

if [[ $_arg_all_interfaces != "" ]]; then
    LISTEN_ADDRESS=0.0.0.0
fi

# Check CWD
CURRENT_WORKING_DIR=`pwd | awk -F '/' '{ print $NF }'`
if [[ "$CURRENT_WORKING_DIR" != "serpico-templates" ]]; then
    echo "Current working directory should be serpico-template repo"
    exit 1
fi

# Update template repo
git pull

# Check if docker and screen is installed
hash openssl 2>/dev/null || { echo "openssl not found but required"; exit 1; }
hash docker 2>/dev/null || { echo "docker not found but required"; exit 1; }
hash python3 2>/dev/null || { echo "python3 not found but required"; exit 1; }

PASSWORD=`openssl rand -base64 22 | sed 's#[=\+/]##g'`

# Pull docker image
# Run instance
# Set CVSS reporting
# Set show_exceptions to True (report import bug otherwise)
# Enable nessusmap, burpmap and vulnmap
# Run Serpico
docker build . -t moj_serpico

docker run -d -p $LISTEN_ADDRESS:443:8443 -it moj_serpico /bin/bash -l -c \
    "/usr/bin/yes | ruby /Serpico/scripts/manage_users.rb -u administrator -p $PASSWORD;
     sed -i 's#\"cvss\": false,#\"cvss\": false,\n  \"cvssv3\": true,#' /Serpico/config.json;
     sed -i 's#\"show_exceptions\": false,#\"show_exceptions\": true,#' /Serpico/config.json;
     sed -i 's#\"nessusmap\": false,#\"nessusmap\": true,#' /Serpico/config.json;
     sed -i 's#\"burpmap\": false,#\"burpmap\": true,#' /Serpico/config.json;
     sed -i 's#\"vulnmap\": false,#\"vulnmap\": true,#' /Serpico/config.json;
     ruby /Serpico/serpico.rb" || { echo "Already have a container listening on 443?"; exit 1; }

sleep 2

# Replace default finding templates with external source
if [[ $_arg_external_findings != "" ]]; then
    rm -rf template_findings
    git clone $_arg_external_findings tmp
    mv tmp/template_findings template_findings
    rm -rf tmp
fi

echo -n "Importing templates..."

# Wait
sleep 2

###
### REPORT TEMPLATES
###

# Debug
#export HTTPS_PROXY=http://localhost:8080/

# Get cookie....
curl -s -k -c $CURL_COOKIE_JAR -X $'GET' \
    -H $'Host: localhost' \
    -H $'User-Agent: MoJ' \
    -H $'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8' \
    -H $'Accept-Language: en-GB,en;q=0.5' -H $'Accept-Encoding: gzip, deflate' -H $'DNT: 1' \
    -H $'Connection: close' -H $'Upgrade-Insecure-Requests: 1' $'https://localhost/reports/list' > /dev/null

# Login
curl -s -k -X $'POST' \
    -H $'Host: localhost' \
    -H $'User-Agent: MoJ' \
    -H $'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8' \
    -H $'Accept-Language: en-GB,en;q=0.5' -H $'Accept-Encoding: gzip, deflate' \
    -H $'Referer: https://localhost/reports/list' -H $'Content-Type: application/x-www-form-urlencoded' \
    -b $CURL_COOKIE_JAR -H $'DNT: 1' -H $'Connection: close' -H $'Upgrade-Insecure-Requests: 1' \
    --data "username=administrator&password=$PASSWORD" $'https://localhost/login' > /dev/null

# Perform redirect which curl doesn't get right in the above request
# (with -L curl tries to POST to /)
# This (probably) completes authentication
curl -L -i -s -k -X $'GET' \
    -H $'Host: localhost' \
    -H $'User-Agent: MoJ' \
    -H $'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8' \
    -H $'Accept-Language: en-GB,en;q=0.5' -H $'Accept-Encoding: gzip, deflate' \
    -H $'Referer: https://localhost/reports/list' -b $CURL_COOKIE_JAR -H $'DNT: 1' -H $'Connection: close' \
    -H $'Upgrade-Insecure-Requests: 1' $'https://localhost/' > /dev/null

# Add templates
function add_templates() {
    for template_report in template_reports/$1; do
        TEMPLATE_REPORT_FRIENDLY=`echo $template_report | sed 's#.*/##g' | sed 's#\..*##g'`
        curl -s -L -k -b $CURL_COOKIE_JAR \
            -H $'User-Agent: MoJ' \
            -H $'Accept-Language: en-GB,en;q=0.5' \
            -F "report_type=$TEMPLATE_REPORT_FRIENDLY" \
            -F "description=$TEMPLATE_REPORT_FRIENDLY" \
            -F "file=@$template_report" $'https://localhost/admin/templates/add' > /dev/null
    done
}

# docx
add_templates "*.docx"
# DOCX
add_templates "*.DOCX"

echo " done"

###
### ISSUE TEMPLATES
###

echo -n "Squashing issues..."

# Squashing the JSON objects into one file results in quicker import into Serpico than separate files
scripts/squash_findings.py --json-file $SQUASH_JSON_FILE --template-directory template_findings

echo " done"

echo -n "Importing issues..."

curl -s -i -k -b $CURL_COOKIE_JAR \
    -H $'User-Agent: MoJ' \
    -H $'Accept-Language: en-GB,en;q=0.5' \
    -F "file=@$SQUASH_JSON_FILE" \
    -F "approved=on" $'https://localhost/master/import' > /dev/null

rm $SQUASH_JSON_FILE

echo " done"
echo
echo "Blow this instance away after report for test is complete. The only way to update automatically is by running this script again."
echo "When you've completed report make sure you export / download the following:"
echo "1. Report DOCX"
echo "2. Report JSON"
echo "3. Report attachments"
echo "4. Any report templates you've worked on"
echo "5. Any finding templates you've worked on (JSON)"
echo
echo "Add report templates by sticking them in template_reports directory."
echo
echo "Add finding templates by:"
echo "1. Creating them in web application"
echo "2. Exporting all findings in JSON format"
echo "3. Running the scripts/new_findings.py script to isolate new finding templates and split them out appropriately"
echo "4. Committing code"
echo
echo "Username: administrator"
echo "Password: $PASSWORD"
echo "Serpico available at https://127.0.0.1/"
exit 0
