#!/bin/bash
# Copyright 2020 Huawei Technologies Co., Ltd.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set -e

SCRIPT_BASEDIR=$(realpath "$(dirname "$0")")

PROJECT_DIR=$(realpath "$SCRIPT_BASEDIR/../../../../../")
UT_PATH="$PROJECT_DIR/tests/ecosystem_tools/mindconverter/tests/ut"

run_test() {
    echo "Start to run test."
    cd "$PROJECT_DIR" || exit

    export PYTHONPATH=$PROJECT_DIR/ecosystem_tools/mindconverter:$PYTHONPATH
    pytest "$UT_PATH"

    rm -f mindconverter.log
}

run_test
