/**
 * Copyright 2021 Huawei Technologies Co., Ltd.All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Generates a hash value of a string.
 * @param {String} str
 * @return {Number}
 */
function genHash(str = '') {
  let hash = 5381;
  for (let i = 0, len = str.length; i < len; i++) {
    hash += (hash << 5) + str.charCodeAt(i);
  }
  return hash & 0x7fffffff;
}

/**
 * check whether the shard method is valid
 * @param {Array|undefined} value
 * @return {boolean}
 */
function _checkShardMethod(value) {
  if (typeof value === 'string') {
    value = JSON.parse(value);
  }
  return value !== undefined && value.length > 0;
}

export {genHash, _checkShardMethod};
