/**
 * Copyright 2019-2021 Huawei Technologies Co., Ltd.All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
export default {
  barColorArr: {
    0: ['#6c91fb', '#7cdc9f', '#fc8b5d', '#f1689b', '#ab74ff'],
    1: ['#6c91fb', '#7cdc9f', '#fc8b5d', '#f1689b', '#ab74ff'],
  },
  XAIColorArr: {
    0: [
      '#007DFF',
      '#74D49B',
      '#9482FD',
      '#5ED1E1',
      '#EC6F1A',
      '#F9ACBB',
      '#0F8E9C',
      '#EEBA18',
    ],
    1: [
      '#005BB9',
      '#1C8A49',
      '#4A37B5',
      '#1892A2',
      '#BE550D',
      '#B33E55',
      '#045A63',
      '#AB8100',
    ],
  },
  echartsTextStyle: {
    0: ['#333'],
    1: ['#DDD'],
  },
  pieColorArr: {
    0: [
      '#6C92FA',
      '#6CBFFF',
      '#4EDED2',
      '#7ADFA0',
      '#A6DD82',
      '#F6DF66',
      '#FDCA5A',
      '#FA8E5A',
      '#F45C5E',
      '#F3689A',
      '#A97AF8',
      '#3D58A6',
      '#3673A3',
      '#2C9990',
      '#469965',
      '#68994D',
      '#A89636',
      '#A8812C',
      '#A6542D',
      '#A34142',
      '#664EA3',
    ],
    1: [
      '#005BB9',
      '#1C8A49',
      '#4A37B5',
      '#1892A2',
      '#045A63',
      '#AB8100',
      '#FDCA5A',
      '#FA8E5A',
      '#F45C5E',
      '#F3689A',
      '#A97AF8',
      '#3D58A6',
      '#3673A3',
      '#2C9990',
      '#469965',
      '#68994D',
      '#A89636',
      '#A8812C',
      '#A6542D',
      '#A34142',
      '#664EA3',
    ],
  },
  commonColorArr: {
    0: [
      '#00A5A7',
      '#6C92FA',
      '#FA8E5A',
      '#A6DD82',
      '#6CBFFF',
      '#F45C5E',
      '#F6DF66',
      '#4EDED2',
      '#F3689A',
      '#FDCA5A',
      '#7ADFA0',
      '#4C6BC2',
      '#C2663A',
      '#7EB05D',
      '#468BC2',
      '#BF5254',
      '#C2AE44',
      '#33B0A6',
      '#BA456F',
      '#C49939',
      '#56B077',
      '#A1BAFF',
      '#FFBA99',
      '#C7EDAD',
      '#9ED5FF',
      '#FA9698',
      '#FAEB9D',
      '#8CEDE5',
      '#F79CBC',
      '#FFDE96',
      '#A8EDC2',
      '#25386E',
      '#8A4321',
      '#59823D',
      '#285C85',
      '#873233',
      '#8F7E29',
      '#1E827A',
      '#822849',
      '#8C6A20',
      '#388252',
      '#DCFCE8',
      '#FFE4D6',
      '#D2FCF9',
      '#FFF2D4',
      '#D1EBFF',
      '#FFF9D9',
      '#D4DFFF',
      '#FCD2E1',
      '#E9FCDC',
      '#FFD1D2',
    ],
    1: [
      '#045A63',
      '#6C92FA',
      '#FA8E5A',
      '#A6DD82',
      '#6CBFFF',
      '#F45C5E',
      '#F6DF66',
      '#4EDED2',
      '#F3689A',
      '#FDCA5A',
      '#7ADFA0',
      '#4C6BC2',
      '#C2663A',
      '#7EB05D',
      '#468BC2',
      '#BF5254',
      '#C2AE44',
      '#33B0A6',
      '#BA456F',
      '#C49939',
      '#56B077',
      '#A1BAFF',
      '#FFBA99',
      '#C7EDAD',
      '#9ED5FF',
      '#FA9698',
      '#FAEB9D',
      '#8CEDE5',
      '#F79CBC',
      '#FFDE96',
      '#A8EDC2',
      '#25386E',
      '#8A4321',
      '#59823D',
      '#285C85',
      '#873233',
      '#8F7E29',
      '#1E827A',
      '#822849',
      '#8C6A20',
      '#388252',
      '#DCFCE8',
      '#FFE4D6',
      '#D2FCF9',
      '#FFF2D4',
      '#D1EBFF',
      '#FFF9D9',
      '#D4DFFF',
      '#FCD2E1',
      '#E9FCDC',
      '#FFD1D2',
    ],
  },
  // define graph color array
  graphColorArr: {
    0: ['#F5FBFB', '#EDF9F9', '#DEF5F5', '#C9F5F5'],
    1: ['#393a3a', '#3d4242', '#495252', '#3a4848'],
  },
  // define fullscreen icon
  fullScreenIcon: {
    0:
      'path://M432.45,595.444c0,2.177-4.661,6.82-11.305,6.82c-6.475,' +
      '0-11.306-4.567-11.306-6.82s4.852-6.812,11.306-6.812C427.841,' +
      '588.632,432.452,593.191,432.45,595.444L432.45,595.444z M421.155,' +
      '589.876c-3.009,0-5.448,2.495-5.448,5.572s2.439,5.572,5.448,' +
      '5.572c3.01,0,5.449-2.495,5.449-5.572C426.604,592.371,424.165,' +
      '589.876,421.155,589.876L421.155,589.876z M421.146,591.891c-1.916,' +
      '0-3.47,1.589-3.47,3.549c0,1.959,1.554,3.548,3.47,3.548s3.469-1.589,' +
      '3.469-3.548C424.614,593.479,423.062,591.891,421.146,591.891L421.146,591.891zM421.146,591.891',
    1:
      'path://M432.45,595.444c0,2.177-4.661,6.82-11.305,6.82c-6.475,' +
      '0-11.306-4.567-11.306-6.82s4.852-6.812,11.306-6.812C427.841,' +
      '588.632,432.452,593.191,432.45,595.444L432.45,595.444z M421.155,' +
      '589.876c-3.009,0-5.448,2.495-5.448,5.572s2.439,5.572,5.448,' +
      '5.572c3.01,0,5.449-2.495,5.449-5.572C426.604,592.371,424.165,' +
      '589.876,421.155,589.876L421.155,589.876z M421.146,591.891c-1.916,' +
      '0-3.47,1.589-3.47,3.549c0,1.959,1.554,3.548,3.47,3.548s3.469-1.589,' +
      '3.469-3.548C424.614,593.479,423.062,591.891,421.146,591.891L421.146,591.891zM421.146,591.891',
  },
  // define restore icon
  restoreIcon: {
    0:
      'path://M971.64 699.44l-59.87-117.08a25 25 0 0 0-33.64-10.88L761 631.34a25 25 0 0 0 22.76 44.52l61.72-31.55c-63.77 141.46-204.11 233.6-362.61 233.6-174.55 0-327.09-111.74-379.57-278a25 25 0 1 0-47.68 15A448.77 448.77 0 0 0 215.6 839.44c77.71 57.88 170.15 88.47 267.31 88.47s189.59-30.59 267.3-88.47a449.14 449.14 0 0 0 144-181.68l33 64.45a25 25 0 0 0 44.52-22.77zM93.06 461.29a25 25 0 0 0 11.36-2.75L222.86 398a25 25 0 0 0-22.77-44.51L137 385.75c64.39-143.61 206.66-237.21 367.38-237.21C681 148.54 835.42 261.65 888.55 430a25 25 0 1 0 47.68-15 453.55 453.55 0 0 0-161.69-227c-78.55-58.5-172-89.43-270.21-89.43S312.67 129.47 234.12 188A454 454 0 0 0 88.35 372.19l-33.61-65.73a25 25 0 1 0-44.52 22.76l60.56 118.44a25 25 0 0 0 22.28 13.63z',
    1:
      'path://M971.64 699.44l-59.87-117.08a25 25 0 0 0-33.64-10.88L761 631.34a25 25 0 0 0 22.76 44.52l61.72-31.55c-63.77 141.46-204.11 233.6-362.61 233.6-174.55 0-327.09-111.74-379.57-278a25 25 0 1 0-47.68 15A448.77 448.77 0 0 0 215.6 839.44c77.71 57.88 170.15 88.47 267.31 88.47s189.59-30.59 267.3-88.47a449.14 449.14 0 0 0 144-181.68l33 64.45a25 25 0 0 0 44.52-22.77zM93.06 461.29a25 25 0 0 0 11.36-2.75L222.86 398a25 25 0 0 0-22.77-44.51L137 385.75c64.39-143.61 206.66-237.21 367.38-237.21C681 148.54 835.42 261.65 888.55 430a25 25 0 1 0 47.68-15 453.55 453.55 0 0 0-161.69-227c-78.55-58.5-172-89.43-270.21-89.43S312.67 129.47 234.12 188A454 454 0 0 0 88.35 372.19l-33.61-65.73a25 25 0 1 0-44.52 22.76l60.56 118.44a25 25 0 0 0 22.28 13.63z',
  },
  // define svg style for graph download
  graphDownloadStyle: {
    0:
      '<style>' +
      'svg > g > polygon {fill:#f7faff;}.edge path {stroke: #787878;}.edge polygon {fill: #787878;}' +
      '.node.aggregation > polygon {stroke: #e3aa00;fill: #ffe794;}' +
      '.node.cluster.aggregation > rect {stroke: #e3aa00;fill: #ffe794;stroke-dasharray: 3, 3;}' +
      '.node > polygon {stroke: #00a5a7;fill: #8df1f2;}' +
      '.node > ellipse {stroke: #4ea6e6;fill: #b8e0ff;}' +
      '.plain > path,.plain ellipse {stroke: #e37d29;fill: #ffd0a6;stroke-dasharray: 1.5, 1.5;}' +
      '.edge-point ellipse{stroke:#a7a7a7;fill:#a7a7a7;} text {fill: #333;}' +
      '</style>',
    1:
      '<style>' +
      'svg > g > polygon {fill:#2D2D2D;}.edge path {stroke: #787878;}.edge polygon {fill: #787878;}' +
      '.node.aggregation > polygon {stroke: #e3aa00;fill: #524926;}' +
      '.node.cluster.aggregation > rect {stroke: #e3aa00;fill: #ffe794;stroke-dasharray: 3, 3;}' +
      '.node > polygon {stroke: #1892A2;fill: #293f42;}' +
      '.node > ellipse {stroke: #4ea6e6;fill: #213e54;}' +
      '.plain > path,.plain ellipse {stroke: #e37d29;fill: #a0744d;stroke-dasharray: 1.5, 1.5;}' +
      '.edge-point ellipse{stroke:#a7a7a7;fill:#a7a7a7;} text {fill: #DDDDDD;}' +
      '</style>',
  },
  dataMapDownloadStyle: {
    0:
      '<style>' +
      'svg > g > polygon {fill:#f7faff;} text {fill: #333;}' +
      '.Create > polygon, .Operator > ellipse { stroke: #4ea6e6; fill: #b8e0ff; }' +
      '.cluster > polygon { fill: #8df1f2; stroke: #00a5a7; }' +
      '.Repeat > polygon { stroke: #fdca5a; fill: #fff2d4; }' +
      '.Shuffle > polygon { stroke: #e37d29; fill: #ffd0a6; }' +
      '.Batch > polygon { stroke: #de504e; fill: #ffbcba; }' +
      '.edge path { stroke: #a7a7a7; }' +
      '.edge polygon { fill: #a7a7a7; stroke: #a7a7a7; }' +
      '</style>',
    1:
      '<style>' +
      'svg > g > polygon {fill:#2D2D2D;} text {fill: #DDDDDD;}' +
      '.Create > polygon, .Operator > ellipse { stroke: #005bb9; fill: #293044; }' +
      '.cluster > polygon { fill: #293f42; stroke: #1892A2; }' +
      '.Repeat > polygon { stroke: #ab8100; fill: #544b29; }' +
      '.Shuffle > polygon { stroke: #be550d; fill: #4f3927; }' +
      '.Batch > polygon { stroke: #b33e55; fill: #412c35; }' +
      '.edge path { stroke: #a7a7a7; }' +
      '.edge polygon { fill: #707070; stroke: #707070; }' +
      '</style>',
  },
  clusterHeatmapDashboardColorArr: [
    '#fff2d0',
    '#fbeeb2',
    '#f8eb94',
    '#c1e891',
    '#8ae58f',
    '#64d4ab',
    '#3fc3c8',
    '#36afc2',
    '#2d9cbc',
    '#1e74a0',
  ],
  clusterHeatmapColorArr: [
    '#fff2d0',
    '#f8eb94',
    '#8ae58f',
    '#3fc3c8',
    '#2d9cbc',
    '#104d85',
  ],
  themes: {
    '0': [
      {
        key: '--conpoint-color',
        value: '#000',
      },
      {
        key: '--theme-color',
        value: '#00a5a7',
      },
      {
        key: '--bg-color',
        value: '#fff',
      },
      {
        key: '--item-bg-color',
        value: '#fff',
      },
      {
        key: '--font-color',
        value: '#333',
      },
      {
        key: '--module-bg-color',
        value: '#edf0f5',
      },
      {
        key: '--dashboard-bg-color',
        value: '#edf0f5',
      },
      {
        key: '--box-shadow-color',
        value: '0 1px 3px 0 #e5e5e5',
      },
      {
        key: '--icon-info-color',
        value: '#6c7280',
      },
      {
        key: '--border-color',
        value: '#d9d9d9',
      },
      {
        key: '--heatmap-content-color',
        value: '#e6ebf5',
      },
      {
        key: '--echarts-border-color',
        value: '#fff',
      },
      {
        key: '--echarts-border-change-color',
        value: '#F0F3FA',
      },
      {
        key: '--data-process-color',
        value: '#e3f8eb',
      },
      {
        key: '--data-process-title-color',
        value: '#00a5a7',
      },
      {
        key: '--device-queue-op-color',
        value: '#e1f2ff',
      },
      {
        key: '--device-queue-op-title-color',
        value: '#6cbfff',
      },
      {
        key: '--get-next-color',
        value: '#fef4dd',
      },
      {
        key: '--get-next-title-color',
        value: '#fdca5a',
      },
      {
        key: '--graph-bg-color',
        value: '#f7faff',
      },
      {
        key: '--button-disabled-font-color',
        value: '#c0c4cc',
      },
      {
        key: '--a-link-color',
        value: '#3399ff',
      },
      {
        key: '--data-process-queue-num-color',
        value: '#07a695',
      },
      {
        key: '--data-process-chart-data-color',
        value: '#999999',
      },
      {
        key: '--el-input-border-color',
        value: '#dcdfe6',
      },
      {
        key: '--el-input-font-color',
        value: '#606266',
      },
      {
        key: '--operator-bar-bg-color',
        value: '#cceded',
      },
      {
        key: '--el-tooltip-bg-color',
        value: '#fff',
      },
      {
        key: '--el-select-dropdown-item-hover-bg-color',
        value: '#f5f7fa',
      },
      {
        key: '--grid-table-content-color',
        value: '#222222',
      },
      {
        key: '--el-select-dropdown-border-color',
        value: '#e4e7ed',
      },
      {
        key: '--graph-polygon-color',
        value: '#8df1f2',
      },
      {
        key: '--graph-operator-color',
        value: '#b8e0ff',
      },
      {
        key: '--graph-aggregation-color',
        value: '#ffe794',
      },
      {
        key: '--graph-plain-color',
        value: '#ffd0a6',
      },
      {
        key: '--slot-bg-color',
        value: '#e9fcf9',
      },
      {
        key: '--data-process-operator-color',
        value: '#e6ebf5',
      },
      {
        key: '--repeat-dataset-polygon-stroke-color',
        value: '#fdca5a',
      },
      {
        key: '--repeat-dataset-polygon-fill-color',
        value: '#fff2d4',
      },
      {
        key: '--shuffle-dataset-polygon-stroke-color',
        value: '#e37d29',
      },
      {
        key: '--shuffle-dataset-polygon-fill-color',
        value: '#ffd0a6',
      },
      {
        key: '--batch-dataset-polygon-stroke-color',
        value: '#de504e',
      },
      {
        key: '--batch-dataset-polygon-fill-color',
        value: '#ffbcba',
      },
      {
        key: '--create-dataset-polygon-stroke-color',
        value: '#4ea6e6',
      },
      {
        key: '--create-dataset-polygon-fill-color',
        value: '#b8e0ff',
      },
      {
        key: '--edge-path-color',
        value: '#a7a7a7',
      },
      {
        key: '--header-bg-min-color',
        value: '#263d5f',
      },
      {
        key: '--header-bg-max-color',
        value: '#16233b',
      },
      {
        key: '--step-trace-chart-label-color',
        value: '#6c7280',
      },
      {
        key: '--step-trace-chart-text-color',
        value: '#464950',
      },
      {
        key: '--el-tabs-item-color',
        value: '#303133',
      },
      {
        key: '--expand-table-before-bg-color',
        value: '#f0fdfd',
      },
      {
        key: '--table-font-color',
        value: '#282B33',
      },
      {
        key: '--table-border-color',
        value: '#EBEEF5',
      },
      {
        key: '--table-hover-color',
        value: '#F5F7FA',
      },
      {
        key: '--pagination-btn-color',
        value: '#E6EBF5',
      },
      {
        key: '--el-dialog-title',
        value: '#303133',
      },
      {
        key: '--v-modal-bg-color',
        value: '#000000',
      },
      {
        key: '--el-table-head-isgroup-bg-color',
        value: '#f5f7fa',
      },
      {
        key: '--el-tree-iscurrent-bg-color',
        value: '#f0f7ff',
      },
      {
        key: '--scrollbar-thumb',
        value: '#dfe7f5',
      },
      {
        key: '--scrollbar-track',
        value: '#f5f5f5',
      },
      {
        key: '--graph-legend-bg-color',
        value: '#f7faff',
      },
      {
        key: '--graph-legend-scrollbar-thumb',
        value: '#bac5cc',
      },
      {
        key: '--graph-legend-node-info-color',
        value: '#fce8b2',
      },
      {
        key: '--graph-guide-content-bg-color',
        value: '#c6c8cc',
      },
      {
        key: '--el-tag-bg-color',
        value: '#f4f4f5',
      },
      {
        key: '--el-tag-font-color',
        value: '#909399',
      },
      {
        key: '--graph-right-module-border-color',
        value: '#EBEEF5',
      },
      {
        key: '--image-sample-bg-color',
        value: '#F0F3FA',
      },
      {
        key: '--table-fixed-box-shadow-color',
        value: 'rgba(0, 0, 0, 0.12)',
      },
      {
        key: '--select-scrollbar-thumb',
        value: '#dfe7f5',
      },
      {
        key: '--item-split-line-color',
        value: '#e6ebf5',
      },
      {
        key: '--button-hover-color',
        value: '#e9f7f7',
      },
      {
        key: '--table-success-row-bg-color',
        value: '#f0f9eb',
      },
      {
        key: '--button-disabled-bg-color',
        value: '#f5f6f6',
      },
      {
        key: '--chart-inactive-font-colo',
        value: '#ccc',
      },
      {
        key: '--el-message-border-color',
        value: '#ebeef5',
      },
      {
        key: '--el-select-disabled-bg-color',
        value: '#f5f7fa',
      },
      {
        key: '--echarts-tooltip-bg-color',
        value: 'rgba(50, 50, 50, 0.7)',
      },
      {
        key: '--echarts-tooltip-font-color',
        value: '#fff',
      },
      {
        key: '--attribute-panel-bg-color',
        value: '#fff',
      },
      {
        key: '--common-stroke',
        value: '#3f51b5',
      },
      {
        key: '--common-node-stroke',
        value: '#000000',
      },
      {
        key: '--highlight-node-stroke-color',
        value: '#fd9629',
      },
      {
        key: '--focused-node-color',
        value: '#f2453d',
      },
      {
        key: '--expanded-node-fill',
        value: '#fff5e6',
      },
      {
        key: '--unexpanded-node-fill',
        value: '#ffffff',
      },
      {
        key: '--pipeline-panel-title-bg-color',
        value: '#cccccc',
      },
      {
        key: '--pipeline-panel-content-bg-color',
        value: '#ffffff',
      },
      {
        key: '--debugger-execution-history-bg-color',
        value: '#f5dbb5',
      },
      {
        key: '--grid-preview-bg-color',
        value: 'rgb(0, 0, 0, 0.1)',
      },
      {
        key: '--normal-operator-color',
        value: '#cbcbcb',
      },
      {
        key: '--parameter-operator-color',
        value: '#211DF1',
      },
      {
        key: '--slice-operator-color',
        value: '#536eab',
      },
      {
        key: '--redistribution-operator-color',
        value: '#4ca59c',
      },
      {
        key: '--allreduce-operator-color',
        value: '#f49538',
      },
      {
        key: '--send-operator-color',
        value: '#bf73d6',
      },
      {
        key: '--receive-operator-color',
        value: '#4192d3',
      },
      {
        key: '--performance-flops',
        value: '#585393',
      },
      {
        key: '--performance-memory',
        value: '#7e93bf',
      },
      {
        key: '--performance-fb',
        value: '#74ba62',
      },
      {
        key: '--performance-collective',
        value: '#e6882e',
      },
      {
        key: '--performance-send',
        value: '#bf73d6',
      },
      {
        key: '--performance-receive',
        value: '#4192d3',
      },
      {
        key: '--performance-opacity',
        value: '50%',
      },
      {
        key: '--performance-interval',
        value: '#a9d1e5',
      },
      {
        key: '--comminication-min',
        value: '#fae7d7',
      },
      {
        key: '--comminication-max',
        value: '#e6882e',
      },
      {
        key: '--comminication-type1',
        value: '#cecfd1',
      },
      {
        key: '--comminication-type2',
        value: '#999999',
      },
      {
        key: '--comminication-matrix-time',
        value: '#f6b59a',
      },
      {
        key: '--comminication-matrix-traffic',
        value: '#a8d2e5',
      },
      {
        key: '--comminication-matrix-bandwidth',
        value: '#378dc0',
      },
      {
        key: '--hightlight-color',
        value: '#cb6056',
      },
      {
        key: '--execution-panel-tabitem',
        value: '#ececec',
      },
      {
        key: '--execution-panel-tabcontent',
        value: '#fafafa',
      },
    ],
    '1': [
      {
        key: '--conpoint-color',
        value: '#ddd',
      },
      {
        key: '--pipeline-panel-title-bg-color',
        value: '#6e7074',
      },
      {
        key: '--pipeline-panel-content-bg-color',
        value: '#cdcdcd',
      },
      {
        key: '--common-node-stroke',
        value: '#999999',
      },
      {
        key: '--unexpanded-node-fill',
        value: '#323232',
      },
      {
        key: '--expanded-node-fill',
        value: '#4d4b49',
      },
      {
        key: '--focused-node-color',
        value: '#ef9a9a',
      },
      {
        key: '--attribute-panel-bg-color',
        value: '#323232',
      },
      {
        key: '--common-stroke',
        value: '#9fa8da',
      },
      {
        key: '--highlight-node-stroke-color',
        value: '#ffcc80',
      },
      {
        key: '--theme-color',
        value: '#1892A2',
      },
      {
        key: '--bg-color',
        value: '#141414',
      },
      {
        key: '--item-bg-color',
        value: '#2D2D2D',
      },
      {
        key: '--font-color',
        value: '#DDDDDD',
      },
      {
        key: '--module-bg-color',
        value: '#2D2D2D',
      },
      {
        key: '--dashboard-bg-color',
        value: '#141414',
      },
      {
        key: '--box-shadow-color',
        value: '0 0 0 0 #e5e5e5',
      },
      {
        key: '--icon-info-color',
        value: '#D2C7C7',
      },
      {
        key: '--border-color',
        value: '#4A4A4A',
      },
      {
        key: '--heatmap-content-color',
        value: '#3D3D3D',
      },
      {
        key: '--echarts-border-color',
        value: '#4A4A4A',
      },
      {
        key: '--echarts-border-change-color',
        value: '#4A4A4A',
      },
      {
        key: '--data-process-color',
        value: '#2E3B25',
      },
      {
        key: '--data-process-title-color',
        value: '#1C8A49',
      },
      {
        key: '--device-queue-op-color',
        value: '#293044',
      },
      {
        key: '--device-queue-op-title-color',
        value: '#005BB9',
      },
      {
        key: '--get-next-color',
        value: '#4F3927',
      },
      {
        key: '--get-next-title-color',
        value: '#BE550D',
      },
      {
        key: '--graph-bg-color',
        value: '#2D2D2D',
      },
      {
        key: '--button-disabled-font-color',
        value: '#c0c4cc',
      },
      {
        key: '--a-link-color',
        value: '#2E94FF',
      },
      {
        key: '--data-process-queue-num-color',
        value: '#1892A2',
      },
      {
        key: '--data-process-chart-data-color',
        value: '#999999',
      },
      {
        key: '--el-input-border-color',
        value: '#707070',
      },
      {
        key: '--el-input-font-color',
        value: '#DDDDDD',
      },
      {
        key: '--operator-bar-bg-color',
        value: '#005BB9',
      },
      {
        key: '--el-tooltip-bg-color',
        value: '#727272',
      },
      {
        key: '--el-select-dropdown-item-hover-bg-color',
        value: '#2D2D2D',
      },
      {
        key: '--grid-table-content-color',
        value: '#DDDDDD',
      },
      {
        key: '--el-select-dropdown-border-color',
        value: '#4a4a4a',
      },
      {
        key: '--graph-polygon-color',
        value: '#293f42',
      },
      {
        key: '--graph-operator-color',
        value: '#213e54',
      },
      {
        key: '--graph-aggregation-color',
        value: '#524926',
      },
      {
        key: '--graph-plain-color',
        value: '#a0744d',
      },
      {
        key: '--slot-bg-color',
        value: '#3b4c49',
      },
      {
        key: '--data-process-operator-color',
        value: '#6c6d6f',
      },
      {
        key: '--repeat-dataset-polygon-stroke-color',
        value: '#ab8100',
      },
      {
        key: '--repeat-dataset-polygon-fill-color',
        value: '#544b29',
      },
      {
        key: '--shuffle-dataset-polygon-stroke-color',
        value: '#be550d',
      },
      {
        key: '--shuffle-dataset-polygon-fill-color',
        value: '#4f3927',
      },
      {
        key: '--batch-dataset-polygon-stroke-color',
        value: '#b33e55',
      },
      {
        key: '--batch-dataset-polygon-fill-color',
        value: '#412c35',
      },
      {
        key: '--create-dataset-polygon-stroke-color',
        value: '#005bb9',
      },
      {
        key: '--create-dataset-polygon-fill-color',
        value: '#293044',
      },
      {
        key: '--edge-path-color',
        value: '#707070',
      },
      {
        key: '--header-bg-min-color',
        value: '#084c56',
      },
      {
        key: '--header-bg-max-color',
        value: '#04272c',
      },
      {
        key: '--step-trace-chart-label-color',
        value: '#DDDDDD',
      },
      {
        key: '--step-trace-chart-text-color',
        value: '#DDDDDD',
      },
      {
        key: '--el-tabs-item-color',
        value: '#DDDDDD',
      },
      {
        key: '--expand-table-before-bg-color',
        value: '#2D2D2D',
      },
      {
        key: '--table-font-color',
        value: '#DDDDDD',
      },
      {
        key: '--table-border-color',
        value: '#7F7F7F',
      },
      {
        key: '--table-hover-color',
        value: '#727272',
      },
      {
        key: '--pagination-btn-color',
        value: '#2D2D2D',
      },
      {
        key: '--el-dialog-title',
        value: '#ffffff',
      },
      {
        key: '--v-modal-bg-color',
        value: '#4A4A4A',
      },
      {
        key: '--el-table-head-isgroup-bg-color',
        value: '#141414',
      },
      {
        key: '--el-tree-iscurrent-bg-color',
        value: '#2D2D2D',
      },
      {
        key: '--scrollbar-thumb',
        value: '#2D2D2D',
      },
      {
        key: '--scrollbar-track',
        value: '#141414',
      },
      {
        key: '--graph-legend-bg-color',
        value: '#141414',
      },
      {
        key: '--graph-legend-scrollbar-thumb',
        value: '#2D2D2D',
      },
      {
        key: '--graph-legend-node-info-color',
        value: '#727272',
      },
      {
        key: '--graph-guide-content-bg-color',
        value: '#141414',
      },
      {
        key: '--el-tag-bg-color',
        value: '#2D2D2D',
      },
      {
        key: '--el-tag-font-color',
        value: '#DDDDDD',
      },
      {
        key: '--graph-right-module-border-color',
        value: '#2D2D2D',
      },
      {
        key: '--image-sample-bg-color',
        value: '#2D2D2D',
      },
      {
        key: '--table-fixed-box-shadow-color',
        value: 'rgba(127, 127, 127, 0.8)',
      },
      {
        key: '--select-scrollbar-thumb',
        value: '#444444',
      },
      {
        key: '--item-split-line-color',
        value: '#707070',
      },
      {
        key: '--button-hover-color',
        value: '#152d30',
      },
      {
        key: '--table-success-row-bg-color',
        value: '#666666',
      },
      {
        key: '--button-disabled-bg-color',
        value: '#252525',
      },
      {
        key: '--chart-inactive-font-colo',
        value: '#5e646d',
      },
      {
        key: '--el-message-border-color',
        value: '#141414',
      },
      {
        key: '--el-select-disabled-bg-color',
        value: '#252525',
      },
      {
        key: '--echarts-tooltip-bg-color',
        value: 'rgba(74, 74, 74, 0.8)',
      },
      {
        key: '--echarts-tooltip-font-color',
        value: '#ddd',
      },
      {
        key: '--debugger-execution-history-bg-color',
        value: '#d69129',
      },
      {
        key: '--grid-preview-bg-color',
        value: 'rgb(255, 255, 255, 0.4)',
      },
      {
        key: '--normal-operator-color',
        value: '#cbcbcb',
      },
      {
        key: '--parameter-operator-color',
        value: '#211DF1',
      },
      {
        key: '--slice-operator-color',
        value: '#536eab',
      },
      {
        key: '--redistribution-operator-color',
        value: '#4ca59c',
      },
      {
        key: '--allreduce-operator-color',
        value: '#f49538',
      },
      {
        key: '--send-operator-color',
        value: '#bf73d6',
      },
      {
        key: '--receive-operator-color',
        value: '#4192d3',
      },
      {
        key: '--performance-flops',
        value: '#585393',
      },
      {
        key: '--performance-memory',
        value: '#7e93bf',
      },
      {
        key: '--performance-fb',
        value: '#74ba62',
      },
      {
        key: '--performance-collective',
        value: '#e6882e',
      },
      {
        key: '--performance-send',
        value: '#bf73d6',
      },
      {
        key: '--performance-receive',
        value: '#4192d3',
      },
      {
        key: '--performance-opacity',
        value: '50%',
      },
      {
        key: '--performance-interval',
        value: '#a9d1e5',
      },
      {
        key: '--comminication-min',
        value: '#fae7d7',
      },
      {
        key: '--comminication-max',
        value: '#e6882e',
      },
      {
        key: '--comminication-type1',
        value: '#cecfd1',
      },
      {
        key: '--comminication-type2',
        value: '#999999',
      },
      {
        key: '--comminication-matrix-time',
        value: '#f6b59a',
      },
      {
        key: '--comminication-matrix-traffic',
        value: '#a8d2e5',
      },
      {
        key: '--comminication-matrix-bandwidth',
        value: '#378dc0',
      },
      {
        key: '--hightlight-color',
        value: '#cb6056',
      },
      {
        key: '--execution-panel-tabitem',
        value: '#00353b',
      },
      {
        key: '--execution-panel-tabcontent',
        value: '#404040',
      },
    ],
  },
  commonThemes: {
    '0': {
      themeColor: '#00a5a7',
      fullScreenIconActive: '#6d7278',
      backgroundColor: '#fff',
      fontColor: '#333',
      backgroundColorOfOpacity: 'rgba(50, 50, 50, 0.7)',
      inactiveFontColor: '#ccc',
    },
    '1': {
      themeColor: '#1892a2',
      fullScreenIconActive: '#6d7278',
      backgroundColor: '#141414',
      fontColor: '#ddd',
      backgroundColorOfOpacity: 'rgba(205,205, 205, 0.7)',
      inactiveFontColor: '#5e646d',
    },
  },
  histogramThemes: {
    '0': {
      lineMinColor: '#346E69',
      lineMaxColor: '#EBFFFD',
      polylineBorderColor: '#BBB',
    },
    '1': {
      lineMinColor: '#B5D9DF',
      lineMaxColor: '#045A63',
      polylineBorderColor: '#044b52',
    },
  },
  tensorThemes: {
    '0': {
      positiveColor: '0, 165, 167',
      middleColor: '#fff',
      negativeColor: '227, 125, 41',
    },
    '1': {
      positiveColor: '0, 165, 167',
      middleColor: '#2d2d2d',
      negativeColor: '227, 125, 41',
    },
  },
  stepTraceThemes: {
    '0': {
      reactContainerFill: '#edf0f5',
      reactContainerStroke: '#E2E2E2',
      reactIterationIntervalFill: '#edf8e6',
      reactIterationIntervalStroke: '#A6DD82',
      reactFpAndBpFill: '#e2f2ff',
      reactFpAndBpstroke: '#6cBFFF',
      reactTailFill: '#fff4de',
      reactTailStroke: '#fa8e5b',
      reactFontColor: '#333',
    },
    '1': {
      reactContainerFill: '#2D2D2D',
      reactContainerStroke: '#2D2D2D',
      reactIterationIntervalFill: '#2E3B25',
      reactIterationIntervalStroke: '#1C8A49',
      reactFpAndBpFill: '#293044',
      reactFpAndBpstroke: '#005BB9',
      reactTailFill: '#4F3927',
      reactTailStroke: '#BE550D',
      reactFontColor: '#DDD',
    },
  },
  commonChartTheme: {
    '0': {
      axisLabelColor: '#9EA4B3',
      axisLineColor: '#DBDBDB',
      legendTextColor: '#333',
      splitLineColor: '#E6EBF5',
      tooltipBgColor: 'rgba(50, 50, 50, 0.7)',
      tooltipFontColor: '#FFF',
      tipFontColor: '#000',
      dataZoomFillerColor: '#dce2eb',
      dataZoomBorderColor: '#ddd',
      dataZoomBgColor: '#FFF',
      lineStyleColor: '#314656',
    },
    '1': {
      axisLabelColor: '#949494',
      axisLineColor: '#707070',
      legendTextColor: '#DDD',
      splitLineColor: '#4A4A4A',
      tooltipBgColor: 'rgba(74, 74, 74, 0.8)',
      tooltipFontColor: '#DDD',
      tipFontColor: '#FFF',
      dataZoomFillerColor: '#2f2f2f',
      dataZoomBorderColor: '#4a4a4a',
      dataZoomBgColor: '#141414',
      lineStyleColor: '#f1f1f1',
    },
  },
  modelTracebackChartTheme: {
    '0': {
      axisTextColor: '#6C7280',
      axisLineColor: '#6D7278',
      paralleAxisColor: '#000000',
      epochTextColor: '#cc5b58',
      batchSizeTextColor: '#000',
    },
    '1': {
      axisTextColor: '#949494',
      axisLineColor: '#707070',
      paralleAxisColor: '#DDDDDD',
      epochTextColor: '#be550d',
      batchSizeTextColor: '#fff',
    },
  },
  graphTheme: {
    '0': {
      aggregationOpenColor: '#fff2d4',
    },
    '1': {
      aggregationOpenColor: '#3c3831',
    },
  },
  compareTracePointColor: {
    '0': {
      pointColor: '#000000',
    },
    '1': {
      pointColor: '#dddddd',
    },
  },
  compareTraceColorScale: [
    [
      'rgb(75, 41, 145)',
      'rgb(135, 44, 162)',
      'rgb(192, 54, 157)',
      'rgb(234, 79, 136)',
      'rgb(250, 120, 118)',
      'rgb(246, 169, 122)',
      'rgb(237, 217, 163)',
    ],
    [
      'rgb(228, 241, 225)',
      'rgb(180, 217, 204)',
      'rgb(137, 192, 182)',
      'rgb(99, 166, 160)',
      'rgb(68, 140, 138)',
      'rgb(40, 114, 116)',
      'rgb(13, 88, 95)',
    ],
  ],
  lossCommonStyle: {
    camera: {
      alpha: 20,
      beta: -90,
      distance: 200,
      centerX: 0,
      centerY: 0,
      centerZ: 0,
    },
    light: {
      alpha: 20,
      beta: -90,
      intensity: 1,
    },
    line: {
      color: 'rgb(0, 0, 0)',
      width: 5,
    },
    opacity: 0.7,
  },
  emptySurfaceSeries: {
    type: 'surface',
    name: 'emptyDataSurface',
    wireframe: {
      show: false,
    },
    shading: 'lambert',
    itemStyle: {
      opacity: 0.7,
    },
    data: [],
  },
  colorOptions: [
    {
      label: 'Jet',
      value: 0,
    },
    {
      label: 'Viridis',
      value: 1,
    },
    {
      label: 'RdBu',
      value: 2,
    },
  ],
  convergencePointColor: {
    '0': '#000',
    '1': '#ddd',
  },  
  lossColorscale: [
    [
      'rgb(0,0,131)',
      'rgb(0,60,170)',
      'rgb(5,255,255)',
      'rgb(255,255,0)',
      'rgb(255,0,0)',
      'rgb(128,0,0)',
    ],
    [
      '#440154',
      '#3e4979',
      '#26838e',
      '#1f9e89',
      '#b5de2b',
      '#fde725',
    ],
    [
      'rgb(5,48,97)',
      'rgb(67,147,195)',
      'rgb(209,229,240)',
      'rgb(253,219,199)',
      'rgb(214,96,77)',
      'rgb(103,0,31)',
    ],
  ],
  dynamicLineColor: [
    '#c23531',
    '#2f4554',
    '#61a0a8',
    '#6C92FA',
    '#6CBFFF',
    '#4EDED2',
    '#7ADFA0',
    '#F45C5E',
    '#F3689A',
    '#A97AF8',
  ],
};
