# Tool Tutorial

[查看中文](./README_CN.md)

<!-- TOC -->

- [Tool Tutorial](#Tool-Tutorial)
    - [Fix CheckPoint file Tool](#Fix-CheckPoint-file-Tool)
        - [Overview](#Overview)
        - [Usage](#Usage)
        - [Example](#Example)
        - [Limitation](#Limitation)

<!-- /TOC -->

## Fix CheckPoint file Tool

### Overview

Requirements

```text
MindSpore>=1.2.0
```

User may need to change module name or variable name in order to improve the readability of converted MindSpore script. However, these changes will result in failing to load checkpoint because of unmatched weight name. The [Fix CheckPoint file Tool](./fix_checkpoint_file.py) is used to fix weight names in checkpoint file.

### Usage

```bash
usage: fix_checkpoint_file.py [-h] [--fixed_ckpt_file FIXED_CKPT_FILE]
                              source_py_file source_ckpt_file fixed_py_file

Fix weight name in CheckPoint file.

positional arguments:
  source_py_file        source model script file
  source_ckpt_file      source_checkpoint file
  fixed_py_file         fixed model script file

optional arguments:
  -h, --help            show this help message and exit
  --fixed_ckpt_file FIXED_CKPT_FILE
                        Optional, the output path of fixed checkpoint file.
                        Default output file is saved in the current working
                        directory, with the same name as `fixed_py_file`.
```

### Example

Assuming that the source model script file is `xxx/model.py`, the source checkpoint file is `xxx/model.ckpt`, the fixed model script file is `xxx/fixed_model.py` and the new checkpoint file is `xxx/fixed_model.ckpt`.

The command is that:

```bash
python -m mindconverter.tools.fix_checkpoint_file xxx/model.py xxx/model.ckpt xxx/fixed_model.py --fixed_ckpt_file xxx/fixed_model
```

If generation is successful, the result below would be shown:

```text
Saved new checkpoint file to xxx/fixed_model.ckpt.
```

### Limitation

1. Only MindSpore Script and CheckPoint file generated by MindConverter using graph-based conversion (using `--model_file`) are supported in the tool.
2. The situation that only variable name or class name in scripts has changed are supported, while the one that model structure or script structure (add or delete operator) has changed is unsupported.
3. MindSpore is required by the tool, so make sure MindSpore installed correctly.
