$('.drag').draggable({
    appendTo: 'body',
    helper: 'clone'
});


$('#network_scheme').droppable({
    activeClass: 'active',
    hoverClass: 'hover',
    accept: ":not(.ui-sortable-helper)", // Reject clones generated by sortable
    drop: function (e, ui) {

        type = ui.draggable.prop('id')

        // Don't drop if network is animated
        if (PacketPlayer.getInstance().getPlayerPlay()){
            return;
        }

        updateCounter(type, 1)
    }
});

$(document).on('keyup', function (e) {
    // DEL and Ctrl+Z
    if (e.keyCode == 46 && selecteed_node_id) {
        let n = nodes.find(n => n.data.id === selecteed_node_id);
        updateCounter(n.config.type, -1)
    }
    if (e.keyCode == 90 && e.ctrlKey) {
        let x = NetworkCache[NetworkCache.length - 1];

        if (!x) {
            return;
        }

        // Node removed
        if (nodes.length > x.nodes.length) {
            let element = nodes.filter(node => !x.nodes.some(item => item.data.id === node.data.id))
            updateCounter(element[0].config.type, -1)
        }

        // Node added
        if (nodes.length < x.nodes.length) {
            let element = x.nodes.filter(node => !nodes.some(item => item.data.id === node.data.id))
            updateCounter(element[0].config.type, 1)
        }

    }
});
