<h1 align="center">
 <img src="https://user-images.githubusercontent.com/45159366/93719686-0abbaa00-fb39-11ea-978d-91e55844dd7a.png">
  <br />
  Flutter Guide
</h1>

 <a href="https://github.com/mikeroyal?tab=followers">
         <img alt="followers" title="Follow me for Updates" src="https://custom-icon-badges.demolab.com/github/followers/mikeroyal?color=236ad3&labelColor=1155ba&style=for-the-badge&logo=person-add&label=Follow&logoColor=white"/></a> 	

![Maintenance](https://img.shields.io/maintenance/yes/2024?style=for-the-badge)
![Last-Commit](https://img.shields.io/github/last-commit/mikeroyal/flutter-guide?style=for-the-badge)

#### A guide covering the Flutter Framework including the applications and tools that will make you a better and more efficient Flutter developer.

**Note: You can easily convert this markdown file to a PDF in [VSCode](https://code.visualstudio.com/) using this handy extension [Markdown PDF](https://marketplace.visualstudio.com/items?itemName=yzane.markdown-pdf).**
 
 <p align="center">
 <img src="https://user-images.githubusercontent.com/45159366/120120794-87853600-c154-11eb-8f9b-ea97607c03c7.png">
  <br />
</p>

# Table of Contents

1. [Flutter Learning Resources](https://github.com/mikeroyal/Flutter-Guide#flutter-learning-resources)

2. [Flutter Tools & Frameworks](https://github.com/mikeroyal/Flutter-Guide#flutter-tools--frameworks)

3. [Fuchsia Development](https://github.com/mikeroyal/Flutter-Guide#fuchsia-development)
 
4. [Dart Development](https://github.com/mikeroyal/Flutter-Guide#dart-development)
 
5. [Firebase Development](https://github.com/mikeroyal/Flutter-Guide#firebase-development)
 

# Flutter Learning Resources

[Back to the Top](https://github.com/mikeroyal/Flutter-Guide#table-of-contents)

[Flutter](https://flutter.dev/) is Google's UI toolkit for crafting beautiful, natively compiled applications for mobile(Andorid and iOS), web, and desktop(Windows, MacOS, Linux, and Google Fuchsia) from a single codebase. Flutter works with existing code, is used by developers and organizations around the world, and is free and open source.

[Flutter Gems](https://fluttergems.dev) is a curated package guide for Flutter which functionally categorizes some of the most useful and popular flutter packages available on pub.dev Flutter Gems A Flutter package landscape guide comprising 1500+ neatly categorized useful and popular packages.

[Dart](https://dart.dev/) is an open-source, scalable programming language, with robust libraries and runtimes, for building web, server, and mobile apps using the Flutter framework.

[Fuchsia](https://fuchsia.dev/) is an open source effort to create a production-grade operating system that prioritizes security, updatability, and performance.

[Firebase](https://firebase.google.com/) is a Backend-as-a-Service (BaaS) app development platform that provides hosted backend services such as a realtime database, cloud storage, authentication, crash reporting, machine learning, remote configuration, and hosting for your static files.

### Flutter Developer Resources

 - [Flutter documentation](https://flutter.dev/docs)
 
 - [Installing and running DevTools from VS Code](https://docs.flutter.dev/development/tools/devtools/vscode)
 
 - [Installing and running DevTools from Android Studio and IntelliJ](https://docs.flutter.dev/development/tools/android-studio)

 - [Style Guide for Flutter](https://github.com/flutter/flutter/wiki/Style-guide-for-Flutter-repo)

 - [Creating your first Flutter app](https://flutter.dev/docs/get-started/codelab)

 - [Build and release an Android app using Flutter](https://flutter.dev/docs/deployment/android)

 - [Flutter Tools & techniques](https://flutter.dev/docs/development/tools)
 
 - [Adding Firebase to your Flutter app](https://firebase.google.com/docs/flutter/setup)

 - [Using Firebase and Firestore with Flutter](https://flutter.dev/docs/development/data-and-backend/firebase)

### Flutter Courses

 - [Dart and Flutter: The Complete Developer's Guide on Udemy](https://www.udemy.com/course/dart-and-flutter-the-complete-developers-guide/)

 - [Creating an Interactive Story with Flutter on Coursera](https://www.coursera.org/projects/story-creating-flutter)

 - [Flutter for Beginners course on Pluralsight](https://www.pluralsight.com/courses/flutter-getting-started)

 - [Flutter Online Training Courses on LinkedIn Learning](https://www.linkedin.com/learning/topics/flutter)

 - [The Complete Flutter App Development Bootcamp with Dart by App Brewery](https://www.appbrewery.co/p/flutter-development-bootcamp-with-dart)


# Flutter Tools & Frameworks

[Back to the Top](https://github.com/mikeroyal/Flutter-Guide#table-of-contents)

[Dart Code](https://marketplace.visualstudio.com/items?itemName=Dart-Code.dart-code) is a VS Code extension that provides support for the Dart programming language, and provides tools for effectively editing, refactoring, running, and reloading Flutter mobile apps.

[Flutter Dart Code](https://marketplace.visualstudio.com/items?itemName=Dart-Code.flutter) is a VS Code extension that adds support for effectively editing, refactoring, running, and reloading Flutter mobile apps. It depends on (and will automatically install) the Dart extension for support for the Dart programming language.

[Pubspec Assist](https://marketplace.visualstudio.com/items?itemName=jeroen-meijer.pubspec-assist) is a Visual Studio Code extension that allows you to easily add dependencies to your Dart and Flutter project's pubspec.yaml, all without leaving your editor.

[Flutter Stylizer](https://marketplace.visualstudio.com/items?itemName=gmlewis-vscode.flutter-stylizer) is a VSCode extension that organizes your Flutter classes in an opinionated and consistent manner.

[Flutter Tree](https://marketplace.visualstudio.com/items?itemName=marcelovelasquez.flutter-tree) is a VS Code extension for Flutter to build basic widget tree with nice syntax.

[Json to Dart Model](https://marketplace.visualstudio.com/items?itemName=hirantha.json-to-dart&ssr=false#overview) is a VS Code extension that converts Json to Dart Model class.

[Better Comments](https://marketplace.visualstudio.com/items?itemName=aaron-bond.better-comments) is a is a VS Code extension that helps your code commenting by annotating with alert, informational, TODOs, and more.

[ErrorLens](https://marketplace.visualstudio.com/items?itemName=usernamehw.errorlens) is a VS Code extension that turbo-charges language diagnostic features by making diagnostics stand out more prominently, highlighting the entire line wherever a diagnostic is generated by the language and also prints the message inline.

[Flutter-view VSCode](https://marketplace.visualstudio.com/items?itemName=blueneogeo.flutter-view-vscode) is a VS Code extension that allows you to inspect pug files and see the generated dart code behind it, as well as navigate to it. This makes navigating between Pug source and generated Dart code quicker and more pleasant.

[Flutter-view](https://flutter-view.io/) is a command line tool that allows you to lay out your Flutter apps faster, using Pug/HTML and Sass/CSS.

[FlutterFire](https://firebase.flutter.dev/) is a set of [Flutter plugins](https://flutter.io/platform-plugins/) that enable Flutter apps to use [Firebase](https://firebase.google.com/) services. You can follow an example that shows how to use these plugins in the [Firebase for Flutter](https://codelabs.developers.google.com/codelabs/flutter-firebase/index.html#0) codelab.

[FlutterBoost](https://github.com/alibaba/flutter_boost) is a Flutter plugin which enables hybrid integration of Flutter for your existing native apps with minimum efforts.

[Go-flutter](https://github.com/go-flutter-desktop/go-flutter) is a package that brings Flutter to the desktop. project implements the [Flutter's Embedding API](https://github.com/flutter/flutter/wiki/Custom-Flutter-Engine-Embedders) using a single code base that runs on Windows, macOS, and Linux. For rendering, [GLFW](https://github.com/go-gl/glfw) fits the job because it provides the right abstractions over the OpenGL's Buffer/Mouse/Keyboard for each platform.

[Firebase](https://firebase.google.com/) is a Backend-as-a-Service (BaaS) app development platform that provides hosted backend services such as a realtime database, cloud storage, authentication, crash reporting, machine learning, remote configuration, and hosting for your static files.

[Firebase iOS](https://github.com/firebase/firebase-ios-sdk) is all the Apple platform Firebase SDK source except FirebaseAnalytics, FirebasePerformance, and FirebaseML.

[Appwrite](https://appwrite.io/) is a secure end-to-end backend server for Web, Mobile, and Flutter developers that is packaged as a set of Docker containers for easy deployment.

[Fluro](https://github.com/theyakka/fluro) is a Flutter routing library that adds flexible routing options like wildcards, named parameters and clear route definitions.
 
# Fuchsia Development
 
[Back to the Top](https://github.com/mikeroyal/Flutter-Guide#table-of-contents)

 <p align="center">
 <img src="https://user-images.githubusercontent.com/45159366/120383684-09eb3280-c2da-11eb-9396-95b0f5696252.png">
  <br />
</p>

## Fuchsia Learning Resources

[Fuchsia](https://fuchsia.dev/) is an open source effort to create a production-grade operating system that prioritizes security, updatability, and performance.

### Fuchsia Developer Resources

 - [Getting Started with Fuchsia](https://fuchsia.dev/fuchsia-src/get-started)

 - [Getting started with Zircon Kernel](https://fuchsia.dev/fuchsia-src/development/kernel/getting_started)

 - [Fuchsia APIs](https://fuchsia.dev/fuchsia-src/development#api)

 - [Supported Harware for Fuchsia](https://fuchsia.dev/fuchsia-src/development#hardware)

 - [Supported Programming Languages for Fuchsia](https://fuchsia.dev/fuchsia-src/development#languages)

 - [Fuchsia Reference](https://fuchsia.dev/reference)

 - [Contributing to Fuchsia](https://fuchsia.dev/fuchsia-src/CONTRIBUTING)

 - [Google Developers Training](https://developers.google.com/training/)

 - [Google Developers Certification](https://developers.google.com/certification/)

## Fuchsia Tools and Frameworks

[Fuchsia Filesystem Architecture](https://fuchsia.dev/fuchsia-src/concepts/filesystems/filesystems)

[Fuchsia emulator (FEMU)](https://fuchsia.dev/fuchsia-src/concepts/emulator) is the default emulator for Fuchsia. FEMU allows you to test Fuchsia components and applications without a physical Fuchsia device.

[Fuchsia Interface Definition Language (FIDL)](https://fuchsia.dev/fuchsia-src/concepts/fidl/overview) is the language used to describe interprocess communication (IPC) protocols used by programs running on Fuchsia.

[Fuchsia System Interface](https://fuchsia.dev/fuchsia-src/concepts/system/abi/system) is the binary interface that the Fuchsia operating system presents to software it runs. The foundation of the interface is the vDSO, which provides access to the system calls. Programs are not allowed to issue system calls directly (e.g., by trapping into the kernel). Instead, programs use the vDSO to interface with the kernel. The bulk of the system interface is provided through inter-process communication protocols, typically defined using FIDL. These protocols are spoken over various kernel primitives, including channels and sockets.

[Fuchsia Integrator Development Kit (IDK)](https://fuchsia.dev/docs/development/idk/gn) is a Developer Kit that contains a small set of libraries and tools required to start building and running programs that target Fuchsia.

[Zircon](https://fuchsia.dev/fuchsia-src/concepts/kernel) is the core platform that powers Fuchsia. Zircon is composed of a kernel (source in /zircon/kernel) as well as a small set of userspace services, drivers, and libraries (source in /zircon/system/) necessary for the system to boot, talk to hardware, load userspace processes and run them, etc. Fuchsia builds a much larger OS on top of this foundation.

[ffx](https://fuchsia.dev/fuchsia-src/development/tools/ffx/overview) is a tool that provides a unified platform for Fuchsia CLI tools for host target interactions. It introduces a service oriented interface to many common development and integration workflow operations that users may wish to perform against one or more Fuchsia target devices.

[Escher](https://fuchsia.dev/fuchsia-src/concepts/graphics/escher) is a physically based renderer. It is a C++/Vulkan library that is used primarily by the Scenic implementation; it is not exposed by the Fuchsia SDK.

[Magma](https://fuchsia.dev/fuchsia-src/concepts/graphics/magma) is the gpu driver architecture for Fuchsia. There are two driver components: a gpu-specific library loaded into each application’s address space; and the magma system driver that manages the hardware.

[Sysmem](https://fuchsia.dev/fuchsia-src/concepts/graphics/sysmem/sysmem) is a FIDL service that allocates shared memory for use by multiple applications and hardware blocks. This document gives an overview of its major features and what it provides to the system.

[GN](https://gn.googlesource.com/gn/) is a meta-build system that generates build files for [Ninja](https://ninja-build.org/). GN is currently used as the build system for Chromium, Fuchsia, and related projects. 

[GN C++ Frontend SDK](https://fuchsia.dev/fuchsia-src/development/idk/gn) is development kit that currently only supports Linux hosts and the [GN build system](https://gn.googlesource.com/gn/).

# Dart Development
[Back to the Top](https://github.com/mikeroyal/Flutter-Guide#table-of-contents)

<p align="center">
 <img src="https://user-images.githubusercontent.com/45159366/95024324-3067a980-0637-11eb-82bd-1c0b180c3fb3.png">
  <br />
</p>

## Dart Learning Resources

[Dart](https://dart.dev/) is an open-source, scalable programming language, with robust libraries and runtimes, for building web, server, and mobile apps using the [Flutter](https://flutter.dev/) framework.

### Dart Developer Resources

 - [Dart API reference](https://api.dart.dev/stable/2.10.0/index.html)

 - [Dart core libraries](https://dart.dev/guides/libraries)

 - [Dart tutorials](https://dart.dev/tutorials)

 - [Getting Started with Dart SDK](https://dart.dev/get-dart)

 - [Creating a new Dart application with IntelliJ IDEA](https://www.jetbrains.com/help/idea/dart.html)

 - [Effective Dart Style Guide](https://dart.dev/guides/language/effective-dart/style#formatting)

 - [Learning Dart](https://reactdom.com/dart)
 
### Dart Courses

 - [Build Native Mobile Apps with Flutter on Udacity](https://www.udacity.com/course/build-native-mobile-apps-with-flutter--ud905)

 - [Dart for Beginners on Udemy](https://www.udemy.com/course/dartlang/)

- [Dart Classes on Skilshare](https://www.skillshare.com/browse/dart-1?via=class-details-about-page)

## Dart Tools & Frameworks

[Android Studio](https://developer.android.com/studio/) is the official integrated development environment for Google's Android operating system, built on JetBrains' IntelliJ IDEA software and designed specifically for Android development. Availble on Windows, macOS, Linux, Chrome OS.

[IntelliJ IDEA](https://www.jetbrains.com/idea/) is an IDE for Java, but it also understands and provides intelligent coding assistance for a large variety of other languages such as Kotlin, SQL, JPQL, HTML, JavaScript, etc., even if the language expression is injected into a String literal in your Java code.

[Dart DevTools](https://dart.dev/tools/dart-devtools) is a suite of debugging and performance tools for Dart and Flutter. These tools are distributed in IDEs, the flutter tool, the webdev tool, and the [devtools package](https://pub.dev/packages/devtools).

[DartPad](https://www.dartpad.dev) is an online editor for Dart.

[Flutter SDK](https://flutter.dev/) is Google's UI toolkit for crafting beautiful, natively compiled applications for mobile, web, and desktop from a single codebase using Dart.

[Pub](https://dart.dev/tools/pub/cmd) is a  tool that has commands for managing packages and for deploying packages and command-line apps. 

[Analysis server](https://github.com/dart-lang/sdk/tree/master/pkg/analysis_server) is designed to provide on-going analysis of one or more code bases as those code bases are changing.

[Dart VM](https://dart.dev/tools/dart-vm) is a tool to run Dart command-line apps such as server-side scripts, programs, and servers.

[dart2js](https://dart.dev/tools/dart2js) is a tool to compile Dart code to deployable JavaScript. Another Dart-to-JavaScript compiler, [dartdevc](https://dart.dev/tools/dartdevc), is for development use only. The [webdev](https://dart.dev/tools/webdev#build) build command uses dart2js by default.

[dartdevc](https://dart.dev/tools/dartdevc) is the Dart development compiler that lets you run and debug your Dart web app in the Chrome browser.

[AngularDart](https://webdev.dartlang.org/angular) is a productive web application framework that powers some of Google's most critical applications. It's built on Dart and used extensively by Google AdWords, AdSense, Fiber, and many more projects.

[RxDart](https://pub.dev/packages/rxdart) is a package with Reactive Extensions for Dart that adds additional capabilities to Dart [Streams](https://api.dart.dev/stable/dart-async/Stream-class.html) and [StreamControllers](https://api.dart.dev/stable/dart-async/StreamController-class.html).

# Firebase Development

[Back to the Top](https://github.com/mikeroyal/Flutter-Guide#table-of-contents)

 <p align="center">
 <img src="https://user-images.githubusercontent.com/45159366/102273497-40bdbf80-3ed7-11eb-90a3-2c0ca837620f.png">
  <br />
</p>

## Firebase Learning Resources

[Firebase](https://firebase.google.com/) is a Backend-as-a-Service (BaaS) app development platform that provides hosted backend services such as a realtime database, cloud storage, authentication, crash reporting, machine learning, remote configuration, and hosting for your static files.

### Firebase Developer Resources

 - [Firebase GitHub](https://github.com/firebase)

 - [Add Firebase to your Flutter app](https://firebase.google.com/docs/flutter/setup)

 - [Using Firebase and Firestore with Flutter](https://flutter.dev/docs/development/data-and-backend/firebase)

 - [Using Firebase with the Ionic Framework](https://ionicframework.com/docs/native/firebase/)

 - [Using Google Analytics with Firebase](https://firebase.google.com/docs/analytics/)

 - [Firebase Cloud Messaging (FCM)](https://docs.microsoft.com/en-us/xamarin/android/data-cloud/google-messaging/firebase-cloud-messaging)

### Firebase Courses & Training

 - [Firebase Courses on Udemy](https://www.udemy.com/topic/firebase/)

 - [Build a Google Firebase Web Application on Coursera](https://www.coursera.org/projects/build-a-google-firebase-webapp)

 - [Firebase in a Weekend: Android on Udacity](https://www.udacity.com/course/firebase-in-a-weekend-by-google-android--ud0352)

 - [Firebase Online Training Courses on LinkedIn Learning](https://www.linkedin.com/learning/topics/firebase)

 - [Learning Firebase Fundamentals on Pluralsight](https://www.pluralsight.com/courses/firebase-fundamentals)

 - [Google Developers Training](https://developers.google.com/training/)

 - [Google Developers Certification](https://developers.google.com/certification)

## Firebase Tools & Frameworks

[Android Studio](https://developer.android.com/studio/) is the official integrated development environment for Google's Android operating system, built on JetBrains' IntelliJ IDEA software and designed specifically for Android development. Availble on Windows, macOS, Linux, Chrome OS.

[Firebase Analytics](https://developers.google.com/analytics/devguides/collection/firebase/android/start) is a Google API that provides methods for logging events and setting user properties.

[Firebase ML](https://firebase.google.com/products/ml) is an Google API includes all of Firebase's cloud-based ML features. 

[ML Kit](https://firebase.google.com/docs/ml-kit/) is a standalone library for on-device ML, which you can use with or without Firebase. 

[Firebase iOS](https://github.com/firebase/firebase-ios-sdk) is all the Apple platform Firebase SDK source except FirebaseAnalytics, FirebasePerformance, and FirebaseML.

[FlutterFire](https://firebase.flutter.dev/) is a set of [Flutter plugins](https://flutter.io/platform-plugins/) that enable Flutter apps to use [Firebase](https://firebase.google.com/) services. You can follow an example that shows how to use these plugins in the [Firebase for Flutter](https://codelabs.developers.google.com/codelabs/flutter-firebase/index.html#0) codelab.

[AngularFire](https://firebaseopensource.com/projects/angular/angularfire2) is the official Angular library for [Firebase](https://firebase.google.com/).

[Vuefire](https://vuefire.vuejs.org/) is Firebase bindings for Vue.js & Vuex.

[Reactive Native Firebase](https://github.com/invertase/react-native-firebase) is a well-tested feature-rich modular Firebase implementation for React Native. Supports both iOS & Android platforms for all Firebase services.

[React Redux Firebase](https://github.com/prescottprue/react-redux-firebase) is Redux bindings for Firebase that includes React Hooks and Higher Order Components.

[FirebaseUI](https://github.com/firebase/FirebaseUI-Android) is an open-source library for Android that allows you to quickly connect common UI elements to Firebase APIs.

[Pyrebase](https://github.com/thisbejim/Pyrebase) is a  simple python wrapper for the Firebase API.

[EmberFire](https://github.com/firebase/emberfire) is the officially supported adapter for using Firebase with [Ember](https://emberjs.com/).

[ReactFire](https://github.com/FirebaseExtended/reactfire) is a project that provides Hooks, Context Providers, and Components that make it easy to interact with Firebase.

## Contribute

- [x] If would you like to contribute to this guide simply make a [Pull Request](https://github.com/mikeroyal/Flutter-Guide/pulls).


## License

[Back to the Top](https://github.com/mikeroyal/Flutter-Guide#table-of-contents)

Distributed under the [Creative Commons Attribution 4.0 International (CC BY 4.0) Public License](https://creativecommons.org/licenses/by/4.0/).
