desired_glyph_data = [
    {"name": "NULL", "unicode": 0, "contours": [0]},
    {"name": "uni2001", "unicode": 8193, "contours": [0]},
    {"name": "enspace", "unicode": 8194, "contours": [0]},
    {"name": "emspace", "unicode": 8195, "contours": [0]},
    {"name": "uni2004", "unicode": 8196, "contours": [0]},
    {"name": "uni2005", "unicode": 8197, "contours": [0]},
    {"name": "uni2006", "unicode": 8198, "contours": [0]},
    {"name": "uni2007", "unicode": 8199, "contours": [0]},
    {"name": "uni2008", "unicode": 8200, "contours": [0]},
    {"name": "uni2009", "unicode": 8201, "contours": [0]},
    {"name": "uni200A", "unicode": 8202, "contours": [0]},
    {"name": "uni200B", "unicode": 8203, "contours": [0]},
    # While ZWNJ and ZWJ display is suppressed in most text conditions, we follow
    # Microsoft’s recommendation that visible glyphs be provided for these and other
    # formatting characters, which can be displayed in text editing conditions
    # https://github.com/googlefonts/fontbakery/issues/3487
    # {
    #     "name": "uni200C", #ZWNJ: zero width non-joiner
    #     "unicode": 8204,
    #     "contours": [
    #         0
    #     ]
    # },
    {"name": "nonmarkingreturn", "unicode": 13, "contours": [0]},
    {"name": "uni2010", "unicode": 8208, "contours": [1]},
    {"name": "uni2011", "unicode": 8209, "contours": [1]},
    {"name": "figuredash", "unicode": 8210, "contours": [1]},
    {"name": "endash", "unicode": 8211, "contours": [1]},
    {"name": "emdash", "unicode": 8212, "contours": [1]},
    {"name": "uni2015", "unicode": 8213, "contours": [1]},
    {"name": "uni2016", "unicode": 8214, "contours": [2]},
    {"name": "underscoredbl", "unicode": 8215, "contours": [2]},
    {"name": "quoteleft", "unicode": 8216, "contours": [1]},
    {"name": "quoteright", "unicode": 8217, "contours": [1]},
    {"name": "quotesinglbase", "unicode": 8218, "contours": [1]},
    {"name": "quotereversed", "unicode": 8219, "contours": [1]},
    {"name": "quotedblleft", "unicode": 8220, "contours": [2]},
    {"name": "quotedblright", "unicode": 8221, "contours": [2]},
    {"name": "quotedblbase", "unicode": 8222, "contours": [2]},
    {"name": "uni201F", "unicode": 8223, "contours": [2]},
    {"name": "space", "unicode": 32, "contours": [0]},
    {"name": "daggerdbl", "unicode": 8225, "contours": [1, 3]},
    {"name": "bullet", "unicode": 8226, "contours": [1]},
    {"name": "numbersign", "unicode": 35, "contours": [2]},
    {"name": "dollar", "unicode": 36, "contours": [1, 3, 5]},
    {"name": "twodotenleader", "unicode": 8229, "contours": [2]},
    {"name": "ampersand", "unicode": 38, "contours": [1, 2, 3]},
    {"name": "quotesingle", "unicode": 39, "contours": [1]},
    {"name": "parenleft", "unicode": 40, "contours": [1]},
    {"name": "parenright", "unicode": 41, "contours": [1]},
    {"name": "asterisk", "unicode": 42, "contours": [1, 4]},
    {"name": "plus", "unicode": 43, "contours": [1]},
    {"name": "comma", "unicode": 44, "contours": [1]},
    {"name": "hyphen", "unicode": 45, "contours": [1]},
    {"name": "period", "unicode": 46, "contours": [1]},
    {"name": "slash", "unicode": 47, "contours": [1]},
    {"name": "zero", "unicode": 48, "contours": [2, 3]},
    {"name": "one", "unicode": 49, "contours": [1]},
    {"name": "two", "unicode": 50, "contours": [1]},
    {"name": "three", "unicode": 51, "contours": [1]},
    {"name": "four", "unicode": 52, "contours": [1, 2]},
    {"name": "five", "unicode": 53, "contours": [1]},
    {"name": "six", "unicode": 54, "contours": [1, 2]},
    {"name": "seven", "unicode": 55, "contours": [1]},
    {"name": "eight", "unicode": 56, "contours": [3]},
    {"name": "guilsinglleft", "unicode": 8249, "contours": [1]},
    {"name": "guilsinglright", "unicode": 8250, "contours": [1]},
    {"name": "semicolon", "unicode": 59, "contours": [2]},
    {"name": "exclamdbl", "unicode": 8252, "contours": [4]},
    {"name": "equal", "unicode": 61, "contours": [2]},
    {"name": "greater", "unicode": 62, "contours": [1]},
    {"name": "question", "unicode": 63, "contours": [2]},
    {"name": "at", "unicode": 64, "contours": [2]},
    {"name": "A", "unicode": 65, "contours": [2]},
    {"name": "B", "unicode": 66, "contours": [2, 3]},
    {"name": "C", "unicode": 67, "contours": [1]},
    {"name": "D", "unicode": 68, "contours": [2]},
    {"name": "E", "unicode": 69, "contours": [1]},
    {"name": "F", "unicode": 70, "contours": [1]},
    {"name": "G", "unicode": 71, "contours": [1]},
    {"name": "uni2048", "unicode": 8264, "contours": [4]},
    {"name": "uni2049", "unicode": 8265, "contours": [4]},
    {"name": "J", "unicode": 74, "contours": [1]},
    {"name": "K", "unicode": 75, "contours": [1, 2]},
    {"name": "L", "unicode": 76, "contours": [1]},
    {"name": "M", "unicode": 77, "contours": [1]},
    {"name": "N", "unicode": 78, "contours": [1]},
    {"name": "O", "unicode": 79, "contours": [2]},
    {"name": "P", "unicode": 80, "contours": [1, 2]},
    {"name": "Q", "unicode": 81, "contours": [2]},
    {"name": "R", "unicode": 82, "contours": [1, 2]},
    {"name": "S", "unicode": 83, "contours": [1]},
    {"name": "T", "unicode": 84, "contours": [1]},
    {"name": "U", "unicode": 85, "contours": [1]},
    {"name": "V", "unicode": 86, "contours": [1]},
    {"name": "W", "unicode": 87, "contours": [1, 2]},
    {"name": "X", "unicode": 88, "contours": [1]},
    {"name": "Y", "unicode": 89, "contours": [1]},
    {"name": "Z", "unicode": 90, "contours": [1]},
    {"name": "bracketleft", "unicode": 91, "contours": [1]},
    {"name": "backslash", "unicode": 92, "contours": [1]},
    {"name": "bracketright", "unicode": 93, "contours": [1]},
    {"name": "asciicircum", "unicode": 94, "contours": [1]},
    {"name": "underscore", "unicode": 95, "contours": [1]},
    {"name": "grave", "unicode": 96, "contours": [1]},
    {"name": "a", "unicode": 97, "contours": [2]},
    {"name": "b", "unicode": 98, "contours": [2]},
    {"name": "c", "unicode": 99, "contours": [1]},
    {"name": "d", "unicode": 100, "contours": [2]},
    {"name": "e", "unicode": 101, "contours": [2]},
    {"name": "f", "unicode": 102, "contours": [1]},
    {"name": "g", "unicode": 103, "contours": [2, 3]},
    {"name": "h", "unicode": 104, "contours": [1]},
    {"name": "i", "unicode": 105, "contours": [2]},
    {"name": "j", "unicode": 106, "contours": [2]},
    {"name": "k", "unicode": 107, "contours": [1, 2]},
    {"name": "l", "unicode": 108, "contours": [1]},
    {"name": "m", "unicode": 109, "contours": [1]},
    {"name": "n", "unicode": 110, "contours": [1]},
    {"name": "o", "unicode": 111, "contours": [2]},
    {"name": "zero.sups", "unicode": 8304, "contours": [2, 3]},
    {"name": "q", "unicode": 113, "contours": [2]},
    {"name": "r", "unicode": 114, "contours": [1]},
    {"name": "s", "unicode": 115, "contours": [1]},
    {"name": "t", "unicode": 116, "contours": [1]},
    {"name": "u", "unicode": 117, "contours": [1]},
    {"name": "v", "unicode": 118, "contours": [1]},
    {"name": "seven.sups", "unicode": 8311, "contours": [1]},
    {"name": "x", "unicode": 120, "contours": [1]},
    {"name": "nine.sups", "unicode": 8313, "contours": [2]},
    {"name": "z", "unicode": 122, "contours": [1]},
    {"name": "braceleft", "unicode": 123, "contours": [1]},
    {"name": "bar", "unicode": 124, "contours": [1]},
    {"name": "braceright", "unicode": 125, "contours": [1]},
    {"name": "asciitilde", "unicode": 126, "contours": [1]},
    {"name": "n.sups", "unicode": 8319, "contours": [1]},
    {"name": "zero.subs", "unicode": 8320, "contours": [2, 3]},
    {"name": "one.subs", "unicode": 8321, "contours": [1]},
    {"name": "two.subs", "unicode": 8322, "contours": [1]},
    {"name": "three.subs", "unicode": 8323, "contours": [1]},
    {"name": "four.subs", "unicode": 8324, "contours": [1, 2]},
    {"name": "five.subs", "unicode": 8325, "contours": [1]},
    {"name": "six.subs", "unicode": 8326, "contours": [2]},
    {"name": "seven.subs", "unicode": 8327, "contours": [1]},
    {"name": "eight.subs", "unicode": 8328, "contours": [3]},
    {"name": "nine.subs", "unicode": 8329, "contours": [2]},
    {"name": "uni208A", "unicode": 8330, "contours": [1]},
    {"name": "uni208B", "unicode": 8331, "contours": [1]},
    {"name": "uni208C", "unicode": 8332, "contours": [2]},
    {"name": "parenleft.subs", "unicode": 8333, "contours": [1]},
    {"name": "parenright.subs", "unicode": 8334, "contours": [1]},
    {"name": "uni00A0", "unicode": 160, "contours": [0]},
    {"name": "colonmonetary", "unicode": 8353, "contours": [1, 3]},
    {"name": "cent", "unicode": 162, "contours": [1, 2]},
    {"name": "sterling", "unicode": 163, "contours": [1, 2]},
    {"name": "currency", "unicode": 164, "contours": [2]},
    {"name": "yen", "unicode": 165, "contours": [1, 2]},
    {"name": "uni20A6", "unicode": 8358, "contours": [1, 3, 5]},
    {"name": "peseta", "unicode": 8359, "contours": [2, 3, 4]},
    {"name": "dieresis", "unicode": 168, "contours": [2]},
    {"name": "uni20A9", "unicode": 8361, "contours": [1, 3, 4, 7]},
    {"name": "ordfeminine", "unicode": 170, "contours": [2, 3]},
    {"name": "guillemotleft", "unicode": 171, "contours": [2]},
    {"name": "Euro", "unicode": 8364, "contours": [1, 2]},
    {
        # soft hyphen
        "name": "uni00AD",
        "unicode": 173,
        "contours": [0],
    },
    {"name": "uni20AE", "unicode": 8366, "contours": [1]},
    {"name": "macron", "unicode": 175, "contours": [1]},
    {"name": "degree", "unicode": 176, "contours": [2]},
    {"name": "plusminus", "unicode": 177, "contours": [1, 2]},
    {"name": "uni20B2", "unicode": 8370, "contours": [1, 2, 3]},
    {"name": "three.sups", "unicode": 179, "contours": [1]},
    {"name": "uni20B4", "unicode": 8372, "contours": [1, 2]},
    {"name": "uni20B5", "unicode": 8373, "contours": [1, 2]},
    {"name": "paragraph", "unicode": 182, "contours": [1, 2, 3]},
    {"name": "periodcentered", "unicode": 183, "contours": [1]},
    {"name": "uni20B8", "unicode": 8376, "contours": [2]},
    {"name": "one.sups", "unicode": 185, "contours": [1]},
    {"name": "uni20BA", "unicode": 8378, "contours": [1]},
    {"name": "guillemotright", "unicode": 187, "contours": [2]},
    {"name": "onequarter", "unicode": 188, "contours": [3, 4]},
    {"name": "uni20BD", "unicode": 8381, "contours": [2]},
    {"name": "threequarters", "unicode": 190, "contours": [3, 4]},
    {"name": "uni20BF", "unicode": 8383, "contours": [3]},
    {"name": "Agrave", "unicode": 192, "contours": [3]},
    {"name": "dagger", "unicode": 8224, "contours": [1, 2]},
    {"name": "Acircumflex", "unicode": 194, "contours": [3]},
    {"name": "Atilde", "unicode": 195, "contours": [3]},
    {"name": "Adieresis", "unicode": 196, "contours": [4]},
    {"name": "Aring", "unicode": 197, "contours": [3, 4]},
    {"name": "AE", "unicode": 198, "contours": [2]},
    {"name": "Ccedilla", "unicode": 199, "contours": [1, 2]},
    {"name": "Egrave", "unicode": 200, "contours": [2]},
    {"name": "Eacute", "unicode": 201, "contours": [2]},
    {"name": "Ecircumflex", "unicode": 202, "contours": [2]},
    {"name": "Edieresis", "unicode": 203, "contours": [3]},
    {"name": "Igrave", "unicode": 204, "contours": [2]},
    {"name": "Iacute", "unicode": 205, "contours": [2]},
    {"name": "Icircumflex", "unicode": 206, "contours": [2]},
    {"name": "Idieresis", "unicode": 207, "contours": [3]},
    {"name": "Eth", "unicode": 208, "contours": [2]},
    {"name": "Ntilde", "unicode": 209, "contours": [2]},
    {"name": "Ograve", "unicode": 210, "contours": [3]},
    {"name": "Oacute", "unicode": 211, "contours": [3]},
    {"name": "Ocircumflex", "unicode": 212, "contours": [3]},
    {"name": "Otilde", "unicode": 213, "contours": [3]},
    {"name": "Odieresis", "unicode": 214, "contours": [4]},
    {"name": "multiply", "unicode": 215, "contours": [1]},
    {"name": "Oslash", "unicode": 216, "contours": [2, 3]},
    {"name": "Ugrave", "unicode": 217, "contours": [2]},
    {"name": "Uacute", "unicode": 218, "contours": [2]},
    {"name": "Ucircumflex", "unicode": 219, "contours": [2]},
    {"name": "Udieresis", "unicode": 220, "contours": [3]},
    {"name": "Yacute", "unicode": 221, "contours": [2]},
    {"name": "Thorn", "unicode": 222, "contours": [1, 2]},
    {"name": "germandbls", "unicode": 223, "contours": [1]},
    {"name": "agrave", "unicode": 224, "contours": [3]},
    {"name": "aacute", "unicode": 225, "contours": [3]},
    {"name": "acircumflex", "unicode": 226, "contours": [3]},
    {"name": "atilde", "unicode": 227, "contours": [3]},
    {"name": "adieresis", "unicode": 228, "contours": [4]},
    {"name": "aring", "unicode": 229, "contours": [4]},
    {"name": "ae", "unicode": 230, "contours": [3]},
    {"name": "ccedilla", "unicode": 231, "contours": [1, 2]},
    {"name": "egrave", "unicode": 232, "contours": [3]},
    {"name": "eacute", "unicode": 233, "contours": [3]},
    {"name": "ecircumflex", "unicode": 234, "contours": [3]},
    {"name": "edieresis", "unicode": 235, "contours": [4]},
    {"name": "igrave", "unicode": 236, "contours": [2]},
    {"name": "iacute", "unicode": 237, "contours": [2]},
    {"name": "icircumflex", "unicode": 238, "contours": [2]},
    {"name": "idieresis", "unicode": 239, "contours": [3]},
    {"name": "eth", "unicode": 240, "contours": [2]},
    {"name": "ntilde", "unicode": 241, "contours": [2]},
    {"name": "ograve", "unicode": 242, "contours": [3]},
    {"name": "oacute", "unicode": 243, "contours": [3]},
    {"name": "ocircumflex", "unicode": 244, "contours": [3]},
    {"name": "otilde", "unicode": 245, "contours": [3]},
    {"name": "odieresis", "unicode": 246, "contours": [4]},
    {"name": "divide", "unicode": 247, "contours": [3]},
    {"name": "oslash", "unicode": 248, "contours": [3]},
    {"name": "ugrave", "unicode": 249, "contours": [2]},
    {"name": "uacute", "unicode": 250, "contours": [2]},
    {"name": "ucircumflex", "unicode": 251, "contours": [2]},
    {"name": "udieresis", "unicode": 252, "contours": [3]},
    {"name": "yacute", "unicode": 253, "contours": [2]},
    {"name": "thorn", "unicode": 254, "contours": [2]},
    {"name": "ydieresis", "unicode": 255, "contours": [3]},
    {"name": "Amacron", "unicode": 256, "contours": [3]},
    {"name": "amacron", "unicode": 257, "contours": [3]},
    {"name": "Abreve", "unicode": 258, "contours": [3]},
    {"name": "abreve", "unicode": 259, "contours": [3]},
    {"name": "Aogonek", "unicode": 260, "contours": [2, 3]},
    {"name": "aogonek", "unicode": 261, "contours": [2]},
    {"name": "Cacute", "unicode": 262, "contours": [2]},
    {"name": "cacute", "unicode": 263, "contours": [2]},
    {"name": "Ccircumflex", "unicode": 264, "contours": [2]},
    {"name": "ccircumflex", "unicode": 265, "contours": [2]},
    {"name": "Cdotaccent", "unicode": 266, "contours": [2]},
    {"name": "cdotaccent", "unicode": 267, "contours": [2]},
    {"name": "Ccaron", "unicode": 268, "contours": [2]},
    {"name": "ccaron", "unicode": 269, "contours": [2]},
    {"name": "Dcaron", "unicode": 270, "contours": [3]},
    {"name": "dcaron", "unicode": 271, "contours": [3]},
    {"name": "Dcroat", "unicode": 272, "contours": [2]},
    {"name": "dcroat", "unicode": 273, "contours": [2]},
    {"name": "Emacron", "unicode": 274, "contours": [2]},
    {"name": "uni2113", "unicode": 8467, "contours": [2]},
    {"name": "Ebreve", "unicode": 276, "contours": [2]},
    {"name": "ebreve", "unicode": 277, "contours": [3]},
    {"name": "uni2116", "unicode": 8470, "contours": [3, 4]},
    {"name": "edotaccent", "unicode": 279, "contours": [3]},
    {"name": "Eogonek", "unicode": 280, "contours": [1, 2]},
    {"name": "eogonek", "unicode": 281, "contours": [2]},
    {"name": "Ecaron", "unicode": 282, "contours": [2]},
    {"name": "ecaron", "unicode": 283, "contours": [3]},
    {"name": "Gcircumflex", "unicode": 284, "contours": [2]},
    {"name": "gcircumflex", "unicode": 285, "contours": [3, 4]},
    {"name": "Gbreve", "unicode": 286, "contours": [2]},
    {"name": "gbreve", "unicode": 287, "contours": [3, 4]},
    {"name": "uni2120", "unicode": 8480, "contours": [2]},
    {"name": "gdotaccent", "unicode": 289, "contours": [3, 4]},
    {"name": "uni0122", "unicode": 290, "contours": [2]},
    {"name": "uni0123", "unicode": 291, "contours": [3, 4]},
    {"name": "Hcircumflex", "unicode": 292, "contours": [2]},
    {"name": "hcircumflex", "unicode": 293, "contours": [2]},
    {"name": "uni2126", "unicode": 8486, "contours": [1]},
    {"name": "hbar", "unicode": 295, "contours": [1]},
    {"name": "Itilde", "unicode": 296, "contours": [2]},
    {"name": "itilde", "unicode": 297, "contours": [2]},
    {"name": "Imacron", "unicode": 298, "contours": [2]},
    {"name": "imacron", "unicode": 299, "contours": [2]},
    {"name": "Ibreve", "unicode": 300, "contours": [2]},
    {"name": "uni2032", "unicode": 8242, "contours": [1]},
    {"name": "estimated", "unicode": 8494, "contours": [2]},
    {"name": "iogonek", "unicode": 303, "contours": [2, 3]},
    {"name": "Idotaccent", "unicode": 304, "contours": [2]},
    {"name": "dotlessi", "unicode": 305, "contours": [1]},
    {"name": "IJ", "unicode": 306, "contours": [1, 2]},
    {"name": "uni2033", "unicode": 8243, "contours": [2]},
    {"name": "Jcircumflex", "unicode": 308, "contours": [2]},
    {"name": "jcircumflex", "unicode": 309, "contours": [2]},
    {"name": "uni0136", "unicode": 310, "contours": [2, 3]},
    {"name": "uni0137", "unicode": 311, "contours": [2, 3]},
    {"name": "kgreenlandic", "unicode": 312, "contours": [1, 2]},
    {"name": "Lacute", "unicode": 313, "contours": [2]},
    {"name": "lacute", "unicode": 314, "contours": [2]},
    {"name": "uni013B", "unicode": 315, "contours": [2]},
    {"name": "uni013C", "unicode": 316, "contours": [2]},
    {"name": "Lcaron", "unicode": 317, "contours": [2]},
    {"name": "lcaron", "unicode": 318, "contours": [2]},
    {"name": "Ldot", "unicode": 319, "contours": [2]},
    {"name": "ldot", "unicode": 320, "contours": [2]},
    {"name": "Lslash", "unicode": 321, "contours": [1]},
    {"name": "lslash", "unicode": 322, "contours": [1]},
    {"name": "Nacute", "unicode": 323, "contours": [2]},
    {"name": "nacute", "unicode": 324, "contours": [2]},
    {"name": "uni0145", "unicode": 325, "contours": [2]},
    {"name": "uni0146", "unicode": 326, "contours": [2]},
    {"name": "Ncaron", "unicode": 327, "contours": [2]},
    {"name": "ncaron", "unicode": 328, "contours": [2]},
    {"name": "napostrophe", "unicode": 329, "contours": [2]},
    {"name": "Eng", "unicode": 330, "contours": [1]},
    {"name": "eng", "unicode": 331, "contours": [1]},
    {"name": "Omacron", "unicode": 332, "contours": [3]},
    {"name": "omacron", "unicode": 333, "contours": [3]},
    {"name": "uni014E", "unicode": 334, "contours": [3]},
    {"name": "uni014F", "unicode": 335, "contours": [3]},
    {"name": "Ohungarumlaut", "unicode": 336, "contours": [4]},
    {"name": "ohungarumlaut", "unicode": 337, "contours": [4]},
    {"name": "OE", "unicode": 338, "contours": [2]},
    {"name": "onethird", "unicode": 8531, "contours": [3]},
    {"name": "twothirds", "unicode": 8532, "contours": [1, 3]},
    {"name": "racute", "unicode": 341, "contours": [2]},
    {"name": "uni0156", "unicode": 342, "contours": [3]},
    {"name": "uni0157", "unicode": 343, "contours": [2]},
    {"name": "Rcaron", "unicode": 344, "contours": [3]},
    {"name": "rcaron", "unicode": 345, "contours": [2]},
    {"name": "Sacute", "unicode": 346, "contours": [2]},
    {"name": "oneeighth", "unicode": 8539, "contours": [5]},
    {"name": "Scircumflex", "unicode": 348, "contours": [2]},
    {"name": "scircumflex", "unicode": 349, "contours": [2]},
    {"name": "uni015E", "unicode": 350, "contours": [1, 2]},
    {"name": "uni015F", "unicode": 351, "contours": [1, 2]},
    {"name": "Scaron", "unicode": 352, "contours": [2]},
    {"name": "scaron", "unicode": 353, "contours": [2]},
    {"name": "uni0162", "unicode": 354, "contours": [1, 2]},
    {"name": "uni0163", "unicode": 355, "contours": [1, 2]},
    {"name": "Tcaron", "unicode": 356, "contours": [2]},
    {"name": "tcaron", "unicode": 357, "contours": [2]},
    {"name": "Tbar", "unicode": 358, "contours": [1]},
    {"name": "tbar", "unicode": 359, "contours": [1]},
    {"name": "Utilde", "unicode": 360, "contours": [2]},
    {"name": "less", "unicode": 60, "contours": [1]},
    {"name": "Umacron", "unicode": 362, "contours": [2]},
    {"name": "umacron", "unicode": 363, "contours": [2]},
    {"name": "Ubreve", "unicode": 364, "contours": [2]},
    {"name": "ubreve", "unicode": 365, "contours": [2]},
    {"name": "Uring", "unicode": 366, "contours": [3]},
    {"name": "uring", "unicode": 367, "contours": [3]},
    {"name": "Uhungarumlaut", "unicode": 368, "contours": [3]},
    {"name": "uhungarumlaut", "unicode": 369, "contours": [3]},
    {"name": "Uogonek", "unicode": 370, "contours": [1]},
    {"name": "uogonek", "unicode": 371, "contours": [1]},
    {"name": "Wcircumflex", "unicode": 372, "contours": [2]},
    {"name": "wcircumflex", "unicode": 373, "contours": [2]},
    {"name": "Ycircumflex", "unicode": 374, "contours": [2]},
    {"name": "ycircumflex", "unicode": 375, "contours": [2]},
    {"name": "Ydieresis", "unicode": 376, "contours": [3]},
    {"name": "Zacute", "unicode": 377, "contours": [2]},
    {"name": "zacute", "unicode": 378, "contours": [2]},
    {"name": "Zdotaccent", "unicode": 379, "contours": [2]},
    {"name": "zdotaccent", "unicode": 380, "contours": [2]},
    {"name": "Zcaron", "unicode": 381, "contours": [2]},
    {"name": "zcaron", "unicode": 382, "contours": [2]},
    {"name": "longs", "unicode": 383, "contours": [1]},
    {"name": "uni0180", "unicode": 384, "contours": [2]},
    {"name": "uni0181", "unicode": 385, "contours": [3]},
    {"name": "uni0182", "unicode": 386, "contours": [2]},
    {"name": "uni0183", "unicode": 387, "contours": [2]},
    {"name": "uni0184", "unicode": 388, "contours": [2]},
    {"name": "uni0185", "unicode": 389, "contours": [2]},
    {"name": "uni0186", "unicode": 390, "contours": [1]},
    {"name": "uni0187", "unicode": 391, "contours": [1]},
    {"name": "uni0188", "unicode": 392, "contours": [1]},
    {"name": "uni0189", "unicode": 393, "contours": [2]},
    {"name": "uni018A", "unicode": 394, "contours": [2]},
    {"name": "uni018B", "unicode": 395, "contours": [2]},
    {"name": "uni018C", "unicode": 396, "contours": [2]},
    {"name": "uni018D", "unicode": 397, "contours": [2]},
    {"name": "uni018E", "unicode": 398, "contours": [1]},
    {"name": "uni018F", "unicode": 399, "contours": [2]},
    {"name": "uni2190", "unicode": 8592, "contours": [1]},
    {"name": "arrowup", "unicode": 8593, "contours": [1]},
    {"name": "uni2192", "unicode": 8594, "contours": [1]},
    {"name": "arrowdown", "unicode": 8595, "contours": [1]},
    {"name": "arrowboth", "unicode": 8596, "contours": [1]},
    {"name": "arrowupdn", "unicode": 8597, "contours": [1]},
    {"name": "uni2196", "unicode": 8598, "contours": [1]},
    {"name": "uni2197", "unicode": 8599, "contours": [1]},
    {"name": "uni2198", "unicode": 8600, "contours": [1]},
    {"name": "uni0199", "unicode": 409, "contours": [1]},
    {"name": "uni019A", "unicode": 410, "contours": [1]},
    {"name": "uni019B", "unicode": 411, "contours": [1]},
    {"name": "uni019C", "unicode": 412, "contours": [1]},
    {"name": "uni019D", "unicode": 413, "contours": [1]},
    {"name": "uni019E", "unicode": 414, "contours": [1]},
    {"name": "uni019F", "unicode": 415, "contours": [3]},
    {"name": "Ohorn", "unicode": 416, "contours": [2, 3]},
    {"name": "ohorn", "unicode": 417, "contours": [2]},
    {"name": "uni01A2", "unicode": 418, "contours": [2]},
    {"name": "uni01A3", "unicode": 419, "contours": [2]},
    {"name": "uni01A4", "unicode": 420, "contours": [2]},
    {"name": "uni01A5", "unicode": 421, "contours": [2]},
    {"name": "uni01A6", "unicode": 422, "contours": [2]},
    {"name": "uni01A7", "unicode": 423, "contours": [1]},
    {"name": "uni01A8", "unicode": 424, "contours": [1]},
    {"name": "uni01A9", "unicode": 425, "contours": [1]},
    {"name": "uni01AA", "unicode": 426, "contours": [2]},
    {"name": "uni2047", "unicode": 8263, "contours": [4]},
    {"name": "uni01AC", "unicode": 428, "contours": [1]},
    {"name": "uni01AD", "unicode": 429, "contours": [1]},
    {"name": "uni01AE", "unicode": 430, "contours": [1]},
    {"name": "Uhorn", "unicode": 431, "contours": [1]},
    {"name": "uhorn", "unicode": 432, "contours": [1]},
    {"name": "H", "unicode": 72, "contours": [1]},
    {"name": "uni01B2", "unicode": 434, "contours": [1]},
    {"name": "uni01B3", "unicode": 435, "contours": [1]},
    {"name": "uni01B4", "unicode": 436, "contours": [1]},
    {"name": "uni01B5", "unicode": 437, "contours": [1]},
    {"name": "uni01B6", "unicode": 438, "contours": [1]},
    {"name": "uni01B7", "unicode": 439, "contours": [1]},
    {"name": "uni01B8", "unicode": 440, "contours": [1]},
    {"name": "uni01B9", "unicode": 441, "contours": [1]},
    {"name": "uni01BA", "unicode": 442, "contours": [1]},
    {"name": "uni01BB", "unicode": 443, "contours": [1]},
    {"name": "uni01BC", "unicode": 444, "contours": [1]},
    {"name": "uni01BD", "unicode": 445, "contours": [1]},
    {"name": "uni01BE", "unicode": 446, "contours": [1]},
    {"name": "uni01BF", "unicode": 447, "contours": [2]},
    {"name": "uni01C0", "unicode": 448, "contours": [1]},
    {"name": "uni01C1", "unicode": 449, "contours": [2]},
    {"name": "uni01C2", "unicode": 450, "contours": [1]},
    {"name": "uni01C3", "unicode": 451, "contours": [2]},
    {"name": "uni01C4", "unicode": 452, "contours": [4]},
    {"name": "uni01C5", "unicode": 453, "contours": [4]},
    {"name": "uni01C6", "unicode": 454, "contours": [4]},
    {"name": "uni01C7", "unicode": 455, "contours": [2]},
    {"name": "uni01C8", "unicode": 456, "contours": [3]},
    {"name": "uni01C9", "unicode": 457, "contours": [3]},
    {"name": "uni01CA", "unicode": 458, "contours": [2]},
    {"name": "uni01CB", "unicode": 459, "contours": [3]},
    {"name": "uni01CC", "unicode": 460, "contours": [3]},
    {"name": "uni01CD", "unicode": 461, "contours": [3]},
    {"name": "uni01CE", "unicode": 462, "contours": [3]},
    {"name": "uni01CF", "unicode": 463, "contours": [2]},
    {"name": "uni01D0", "unicode": 464, "contours": [2]},
    {"name": "uni01D1", "unicode": 465, "contours": [3]},
    {"name": "uni01D2", "unicode": 466, "contours": [3]},
    {"name": "uni01D3", "unicode": 467, "contours": [2]},
    {"name": "uni01D4", "unicode": 468, "contours": [2]},
    {"name": "uni01D5", "unicode": 469, "contours": [4]},
    {"name": "uni01D6", "unicode": 470, "contours": [4]},
    {"name": "uni01D7", "unicode": 471, "contours": [4]},
    {"name": "uni01D8", "unicode": 472, "contours": [4]},
    {"name": "uni01D9", "unicode": 473, "contours": [4]},
    {"name": "uni01DA", "unicode": 474, "contours": [4]},
    {"name": "uni01DB", "unicode": 475, "contours": [4]},
    {"name": "uni01DC", "unicode": 476, "contours": [4]},
    {"name": "uni01DD", "unicode": 477, "contours": [2]},
    {"name": "uni01DE", "unicode": 478, "contours": [5]},
    {"name": "uni01DF", "unicode": 479, "contours": [5]},
    {"name": "uni01E0", "unicode": 480, "contours": [4]},
    {"name": "uni01E1", "unicode": 481, "contours": [4]},
    {"name": "uni01E2", "unicode": 482, "contours": [3]},
    {"name": "uni01E3", "unicode": 483, "contours": [4]},
    {"name": "uni01E4", "unicode": 484, "contours": [1]},
    {"name": "uni01E5", "unicode": 485, "contours": [2]},
    {"name": "Gcaron", "unicode": 486, "contours": [2]},
    {"name": "gcaron", "unicode": 487, "contours": [3, 4]},
    {"name": "uni01E8", "unicode": 488, "contours": [2]},
    {"name": "uni01E9", "unicode": 489, "contours": [2]},
    {"name": "Oogonek", "unicode": 490, "contours": [2]},
    {"name": "oogonek", "unicode": 491, "contours": [2]},
    {"name": "uni01EC", "unicode": 492, "contours": [3]},
    {"name": "uni01ED", "unicode": 493, "contours": [3]},
    {"name": "uni01EE", "unicode": 494, "contours": [2]},
    {"name": "uni01EF", "unicode": 495, "contours": [2]},
    {"name": "uni01F0", "unicode": 496, "contours": [2]},
    {"name": "uni01F1", "unicode": 497, "contours": [3]},
    {"name": "uni01F2", "unicode": 498, "contours": [3]},
    {"name": "uni01F3", "unicode": 499, "contours": [3]},
    {"name": "Gacute", "unicode": 500, "contours": [2]},
    {"name": "gacute", "unicode": 501, "contours": [3]},
    {"name": "uni01F6", "unicode": 502, "contours": [1]},
    {"name": "uni01F7", "unicode": 503, "contours": [2]},
    {"name": "uni01F8", "unicode": 504, "contours": [2]},
    {"name": "uni01F9", "unicode": 505, "contours": [2]},
    {"name": "Aringacute", "unicode": 506, "contours": [3, 4, 5]},
    {"name": "aringacute", "unicode": 507, "contours": [4, 5]},
    {"name": "AEacute", "unicode": 508, "contours": [3]},
    {"name": "aeacute", "unicode": 509, "contours": [4]},
    {"name": "Oslashacute", "unicode": 510, "contours": [4]},
    {"name": "oslashacute", "unicode": 511, "contours": [4]},
    {"name": "Adblgrave", "unicode": 512, "contours": [4]},
    {"name": "adblgrave", "unicode": 513, "contours": [4]},
    {"name": "partialdiff", "unicode": 8706, "contours": [2]},
    {"name": "ainvertedbreve", "unicode": 515, "contours": [3]},
    {"name": "Edblgrave", "unicode": 516, "contours": [3]},
    {"name": "edblgrave", "unicode": 517, "contours": [4]},
    {"name": "uni2206", "unicode": 8710, "contours": [2]},
    {"name": "einvertedbreve", "unicode": 519, "contours": [3]},
    {"name": "Idblgrave", "unicode": 520, "contours": [3]},
    {"name": "idblgrave", "unicode": 521, "contours": [3]},
    {"name": "Iinvertedbreve", "unicode": 522, "contours": [2]},
    {"name": "iinvertedbreve", "unicode": 523, "contours": [2]},
    {"name": "Odblgrave", "unicode": 524, "contours": [4]},
    {"name": "odblgrave", "unicode": 525, "contours": [4]},
    {"name": "Oinvertedbreve", "unicode": 526, "contours": [3]},
    {"name": "product", "unicode": 8719, "contours": [1]},
    {"name": "Rdblgrave", "unicode": 528, "contours": [4]},
    {"name": "summation", "unicode": 8721, "contours": [1]},
    {"name": "minus", "unicode": 8722, "contours": [1]},
    {"name": "rinvertedbreve", "unicode": 531, "contours": [2]},
    {"name": "Udblgrave", "unicode": 532, "contours": [3]},
    {"name": "uni2215", "unicode": 8725, "contours": [1]},
    {"name": "Uinvertedbreve", "unicode": 534, "contours": [2]},
    {"name": "uinvertedbreve", "unicode": 535, "contours": [2]},
    {"name": "uni0218", "unicode": 536, "contours": [2]},
    {"name": "uni2219", "unicode": 8729, "contours": [1]},
    {"name": "uni021A", "unicode": 538, "contours": [2]},
    {"name": "uni021B", "unicode": 539, "contours": [2]},
    {"name": "uni021C", "unicode": 540, "contours": [1]},
    {"name": "uni021D", "unicode": 541, "contours": [1]},
    {"name": "infinity", "unicode": 8734, "contours": [3]},
    {"name": "uni021F", "unicode": 543, "contours": [2]},
    {"name": "uni0220", "unicode": 544, "contours": [1]},
    {"name": "uni0221", "unicode": 545, "contours": [3]},
    {"name": "uni0222", "unicode": 546, "contours": [2]},
    {"name": "uni0223", "unicode": 547, "contours": [2]},
    {"name": "uni0224", "unicode": 548, "contours": [1]},
    {"name": "uni0225", "unicode": 549, "contours": [1]},
    {"name": "uni0226", "unicode": 550, "contours": [3]},
    {"name": "uni0227", "unicode": 551, "contours": [3]},
    {"name": "uni0228", "unicode": 552, "contours": [1]},
    {"name": "uni0229", "unicode": 553, "contours": [2]},
    {"name": "uni022A", "unicode": 554, "contours": [5]},
    {"name": "integral", "unicode": 8747, "contours": [1]},
    {"name": "uni022C", "unicode": 556, "contours": [4]},
    {"name": "uni022D", "unicode": 557, "contours": [4]},
    {"name": "uni022E", "unicode": 558, "contours": [3]},
    {"name": "uni022F", "unicode": 559, "contours": [3]},
    {"name": "uni0230", "unicode": 560, "contours": [4]},
    {"name": "uni0231", "unicode": 561, "contours": [4]},
    {"name": "uni0232", "unicode": 562, "contours": [2]},
    {"name": "uni0233", "unicode": 563, "contours": [2]},
    {"name": "uni0234", "unicode": 564, "contours": [2]},
    {"name": "uni0235", "unicode": 565, "contours": [2]},
    {"name": "uni0236", "unicode": 566, "contours": [2]},
    {"name": "uni0237", "unicode": 567, "contours": [1]},
    {"name": "uni0238", "unicode": 568, "contours": [3]},
    {"name": "uni0239", "unicode": 569, "contours": [3]},
    {"name": "uni023A", "unicode": 570, "contours": [3]},
    {"name": "uni023B", "unicode": 571, "contours": [2]},
    {"name": "uni023C", "unicode": 572, "contours": [2]},
    {"name": "uni023D", "unicode": 573, "contours": [1]},
    {"name": "uni023E", "unicode": 574, "contours": [2]},
    {"name": "uni023F", "unicode": 575, "contours": [1]},
    {"name": "uni0240", "unicode": 576, "contours": [1]},
    {"name": "uni0241", "unicode": 577, "contours": [1]},
    {"name": "uni0242", "unicode": 578, "contours": [1]},
    {"name": "uni0243", "unicode": 579, "contours": [3]},
    {"name": "uni0244", "unicode": 580, "contours": [2]},
    {"name": "uni0245", "unicode": 581, "contours": [1]},
    {"name": "uni0246", "unicode": 582, "contours": [3]},
    {"name": "uni0247", "unicode": 583, "contours": [4]},
    {"name": "approxequal", "unicode": 8776, "contours": [2]},
    {"name": "uni0249", "unicode": 585, "contours": [2]},
    {"name": "uni024A", "unicode": 586, "contours": [2]},
    {"name": "uni024B", "unicode": 587, "contours": [2]},
    {"name": "uni024C", "unicode": 588, "contours": [2]},
    {"name": "uni024D", "unicode": 589, "contours": [1]},
    {"name": "uni024E", "unicode": 590, "contours": [2]},
    {"name": "uni024F", "unicode": 591, "contours": [2]},
    {"name": "uni0251", "unicode": 593, "contours": [2]},
    {"name": "uni2254", "unicode": 8788, "contours": [4]},
    {"name": "uni0259", "unicode": 601, "contours": [2]},
    {"name": "uni225C", "unicode": 8796, "contours": [4]},
    {"name": "notequal", "unicode": 8800, "contours": [1]},
    {"name": "uni0261", "unicode": 609, "contours": [2]},
    {"name": "uni2262", "unicode": 8802, "contours": [1]},
    {"name": "uni2263", "unicode": 8803, "contours": [4]},
    {"name": "lessequal", "unicode": 8804, "contours": [2]},
    {"name": "greaterequal", "unicode": 8805, "contours": [2]},
    {"name": "uni226A", "unicode": 8810, "contours": [2]},
    {"name": "uni226B", "unicode": 8811, "contours": [2]},
    {"name": "uni2270", "unicode": 8816, "contours": [2]},
    {"name": "uni2271", "unicode": 8817, "contours": [2]},
    {"name": "uni0272", "unicode": 626, "contours": [1]},
    {"name": "uni211D", "unicode": 8477, "contours": [3]},
    {"name": "propersubset", "unicode": 8834, "contours": [1]},
    {"name": "propersuperset", "unicode": 8835, "contours": [1]},
    {"name": "notsubset", "unicode": 8836, "contours": [2]},
    {"name": "uni2285", "unicode": 8837, "contours": [2]},
    {"name": "reflexsubset", "unicode": 8838, "contours": [2]},
    {"name": "reflexsuperset", "unicode": 8839, "contours": [2]},
    {"name": "uni2288", "unicode": 8840, "contours": [2]},
    {"name": "uni2289", "unicode": 8841, "contours": [2]},
    # While ZWNJ and ZWJ display is suppressed in most text conditions, we follow
    # Microsoft’s recommendation that visible glyphs be provided for these and other
    # formatting characters, which can be displayed in text editing conditions
    # https://github.com/googlefonts/fontbakery/issues/3487
    # {
    #     "name": "uni200D", #ZWJ: zero width joiner
    #     "unicode": 8205,
    #     "contours": [
    #         0
    #     ]
    # },
    {"name": "uni0292", "unicode": 658, "contours": [1]},
    {"name": "circleplus", "unicode": 8853, "contours": [3]},
    {"name": "p", "unicode": 112, "contours": [2]},
    {"name": "i.sups", "unicode": 8305, "contours": [2]},
    {"name": "h.sups", "unicode": 688, "contours": [1]},
    {"name": "j.sups", "unicode": 690, "contours": [2]},
    {"name": "r.sups", "unicode": 691, "contours": [1]},
    {"name": "w.sups", "unicode": 695, "contours": [1]},
    {"name": "y.sups", "unicode": 696, "contours": [1]},
    {"name": "four.sups", "unicode": 8308, "contours": [1, 2]},
    {"name": "uni02BA", "unicode": 698, "contours": [2]},
    {"name": "uni02BB", "unicode": 699, "contours": [1]},
    {"name": "uni02BC", "unicode": 700, "contours": [1]},
    {"name": "uni02BE", "unicode": 702, "contours": [1]},
    {"name": "five.sups", "unicode": 8309, "contours": [1]},
    {"name": "six.sups", "unicode": 8310, "contours": [2]},
    {"name": "circumflex", "unicode": 710, "contours": [1]},
    {"name": "caron", "unicode": 711, "contours": [1]},
    {"name": "uni02C8", "unicode": 712, "contours": [1]},
    {"name": "uni02C9", "unicode": 713, "contours": [1]},
    {"name": "uni02CA", "unicode": 714, "contours": [1]},
    {"name": "uni02CB", "unicode": 715, "contours": [1]},
    {"name": "uni02CC", "unicode": 716, "contours": [1]},
    {"name": "eight.sups", "unicode": 8312, "contours": [3]},
    {"name": "y", "unicode": 121, "contours": [1]},
    {"name": "breve", "unicode": 728, "contours": [1]},
    {"name": "dotaccent", "unicode": 729, "contours": [1]},
    {"name": "ring", "unicode": 730, "contours": [2]},
    {"name": "ogonek", "unicode": 731, "contours": [1]},
    {"name": "tilde", "unicode": 732, "contours": [1]},
    {"name": "hungarumlaut", "unicode": 733, "contours": [2]},
    {"name": "l.sups", "unicode": 737, "contours": [1]},
    {"name": "s.sups", "unicode": 738, "contours": [1]},
    {"name": "x.sups", "unicode": 739, "contours": [1]},
    {"name": "uni207C", "unicode": 8316, "contours": [2]},
    {"name": "parenleft.sups", "unicode": 8317, "contours": [1]},
    {"name": "uni02F3", "unicode": 755, "contours": [2]},
    {"name": "parenright.sups", "unicode": 8318, "contours": [1]},
    {"name": "uni0300", "unicode": 768, "contours": [1]},
    {"name": "uni0301", "unicode": 769, "contours": [1]},
    {"name": "uni0302", "unicode": 770, "contours": [1]},
    {"name": "uni0303", "unicode": 771, "contours": [1]},
    {"name": "uni0304", "unicode": 772, "contours": [1]},
    {"name": "uni0306", "unicode": 774, "contours": [1]},
    {"name": "uni0307", "unicode": 775, "contours": [1]},
    {"name": "uni0308", "unicode": 776, "contours": [2]},
    {"name": "uni0309", "unicode": 777, "contours": [1]},
    {"name": "uni030A", "unicode": 778, "contours": [2]},
    {"name": "uni030B", "unicode": 779, "contours": [2]},
    {"name": "uni030C", "unicode": 780, "contours": [1]},
    {"name": "uni030F", "unicode": 783, "contours": [2]},
    {"name": "uni0311", "unicode": 785, "contours": [1]},
    {"name": "uni0312", "unicode": 786, "contours": [1]},
    {"name": "uni0313", "unicode": 787, "contours": [1]},
    {"name": "uni031B", "unicode": 795, "contours": [1]},
    {"name": "uni0323", "unicode": 803, "contours": [1]},
    {"name": "uni0324", "unicode": 804, "contours": [2]},
    {"name": "uni0325", "unicode": 805, "contours": [2]},
    {"name": "uni0326", "unicode": 806, "contours": [1]},
    {"name": "uni0327", "unicode": 807, "contours": [1]},
    {"name": "uni0328", "unicode": 808, "contours": [1]},
    {"name": "uni0329", "unicode": 809, "contours": [1]},
    {"name": "uni032E", "unicode": 814, "contours": [1]},
    {"name": "uni0331", "unicode": 817, "contours": [1]},
    {"name": "tildeoverlaycomb", "unicode": 820, "contours": [1]},
    {"name": "uni0335", "unicode": 821, "contours": [1]},
    {"name": "uni0336", "unicode": 822, "contours": [1]},
    {"name": "uni0337", "unicode": 823, "contours": [1]},
    {"name": "uni0338", "unicode": 824, "contours": [1]},
    {"name": "uni0342", "unicode": 834, "contours": [1]},
    {"name": "uni0343", "unicode": 835, "contours": [1]},
    {"name": "uni0344", "unicode": 836, "contours": [3]},
    {"name": "uni0345", "unicode": 837, "contours": [1]},
    {"name": ".null", "unicode": 29, "contours": [0]},
    {"name": "uni0374", "unicode": 884, "contours": [1]},
    {"name": "uni0375", "unicode": 885, "contours": [1]},
    {"name": "uni037A", "unicode": 890, "contours": [1]},
    {"name": "uni037E", "unicode": 894, "contours": [2]},
    {"name": "tonos", "unicode": 900, "contours": [1]},
    {"name": "dieresistonos", "unicode": 901, "contours": [3]},
    {"name": "Alphatonos", "unicode": 902, "contours": [3]},
    {"name": "anoteleia", "unicode": 903, "contours": [1]},
    {"name": "Epsilontonos", "unicode": 904, "contours": [2]},
    {"name": "Etatonos", "unicode": 905, "contours": [2]},
    {"name": "Iotatonos", "unicode": 906, "contours": [2]},
    {"name": "Omicrontonos", "unicode": 908, "contours": [3]},
    {"name": "Upsilontonos", "unicode": 910, "contours": [2]},
    {"name": "Omegatonos", "unicode": 911, "contours": [2]},
    {"name": "iotadieresistonos", "unicode": 912, "contours": [4]},
    {"name": "Alpha", "unicode": 913, "contours": [2]},
    {"name": "Beta", "unicode": 914, "contours": [3]},
    {"name": "Gamma", "unicode": 915, "contours": [1]},
    {"name": "uni0394", "unicode": 916, "contours": [2]},
    {"name": "Epsilon", "unicode": 917, "contours": [1]},
    {"name": "Zeta", "unicode": 918, "contours": [1]},
    {"name": "Eta", "unicode": 919, "contours": [1]},
    {"name": "Theta", "unicode": 920, "contours": [3]},
    {"name": "Iota", "unicode": 921, "contours": [1]},
    {"name": "Kappa", "unicode": 922, "contours": [1]},
    {"name": "Lambda", "unicode": 923, "contours": [1]},
    {"name": "Mu", "unicode": 924, "contours": [1]},
    {"name": "Nu", "unicode": 925, "contours": [1]},
    {"name": "Xi", "unicode": 926, "contours": [1, 3]},
    {"name": "Omicron", "unicode": 927, "contours": [2]},
    {"name": "Pi", "unicode": 928, "contours": [1]},
    {"name": "Rho", "unicode": 929, "contours": [1, 2]},
    {"name": "Sigma", "unicode": 931, "contours": [1]},
    {"name": "Tau", "unicode": 932, "contours": [1]},
    {"name": "Upsilon", "unicode": 933, "contours": [1]},
    {"name": "Phi", "unicode": 934, "contours": [3]},
    {"name": "Chi", "unicode": 935, "contours": [1]},
    {"name": "Psi", "unicode": 936, "contours": [1]},
    {"name": "uni03A9", "unicode": 937, "contours": [1]},
    {"name": "Iotadieresis", "unicode": 938, "contours": [3]},
    {"name": "Upsilondieresis", "unicode": 939, "contours": [3]},
    {"name": "alphatonos", "unicode": 940, "contours": [3]},
    {"name": "epsilontonos", "unicode": 941, "contours": [2]},
    {"name": "etatonos", "unicode": 942, "contours": [2]},
    {"name": "iotatonos", "unicode": 943, "contours": [2]},
    {"name": "upsilondieresistonos", "unicode": 944, "contours": [4]},
    {"name": "alpha", "unicode": 945, "contours": [2]},
    {"name": "beta", "unicode": 946, "contours": [2]},
    {"name": "gamma", "unicode": 947, "contours": [1, 2]},
    {"name": "delta", "unicode": 948, "contours": [2]},
    {"name": "epsilon", "unicode": 949, "contours": [1]},
    {"name": "zeta", "unicode": 950, "contours": [1]},
    {"name": "eta", "unicode": 951, "contours": [1]},
    {"name": "theta", "unicode": 952, "contours": [3]},
    {"name": "iota", "unicode": 953, "contours": [1]},
    {"name": "kappa", "unicode": 954, "contours": [1]},
    {"name": "lambda", "unicode": 955, "contours": [1]},
    {"name": "uni03BC", "unicode": 956, "contours": [1]},
    {"name": "nu", "unicode": 957, "contours": [1]},
    {"name": "xi", "unicode": 958, "contours": [1]},
    {"name": "omicron", "unicode": 959, "contours": [2]},
    {"name": "pi", "unicode": 960, "contours": [1]},
    {"name": "rho", "unicode": 961, "contours": [2]},
    {"name": "uni03C2", "unicode": 962, "contours": [1]},
    {"name": "sigma", "unicode": 963, "contours": [2]},
    {"name": "tau", "unicode": 964, "contours": [1]},
    {"name": "upsilon", "unicode": 965, "contours": [1]},
    {"name": "phi", "unicode": 966, "contours": [2, 3]},
    {"name": "exclamdown", "unicode": 161, "contours": [2]},
    {"name": "psi", "unicode": 968, "contours": [1]},
    {"name": "omega", "unicode": 969, "contours": [1]},
    {"name": "iotadieresis", "unicode": 970, "contours": [3]},
    {"name": "upsilondieresis", "unicode": 971, "contours": [3]},
    {"name": "omicrontonos", "unicode": 972, "contours": [3]},
    {"name": "upsilontonos", "unicode": 973, "contours": [2]},
    {"name": "omegatonos", "unicode": 974, "contours": [2]},
    {"name": "uni03CF", "unicode": 975, "contours": [1]},
    {"name": "theta1", "unicode": 977, "contours": [2]},
    {"name": "Upsilon1", "unicode": 978, "contours": [1]},
    {"name": "franc", "unicode": 8355, "contours": [1, 2]},
    {"name": "omega1", "unicode": 982, "contours": [2]},
    {"name": "uni03D7", "unicode": 983, "contours": [1]},
    {"name": "uni03D9", "unicode": 985, "contours": [2]},
    {"name": "uni03DB", "unicode": 987, "contours": [1]},
    {"name": "uni03DD", "unicode": 989, "contours": [1]},
    {"name": "uni23DE", "unicode": 9182, "contours": [1]},
    {"name": "uni23DF", "unicode": 9183, "contours": [1]},
    {"name": "uni03E1", "unicode": 993, "contours": [1]},
    {"name": "exclam", "unicode": 33, "contours": [2]},
    {"name": "section", "unicode": 167, "contours": [2]},
    {"name": "rupee", "unicode": 8360, "contours": [3]},
    {"name": "copyright", "unicode": 169, "contours": [3]},
    {"name": "uni20AA", "unicode": 8362, "contours": [2]},
    {"name": "uni0400", "unicode": 1024, "contours": [2]},
    {"name": "uni0401", "unicode": 1025, "contours": [3]},
    {"name": "uni0402", "unicode": 1026, "contours": [1]},
    {"name": "uni0403", "unicode": 1027, "contours": [2]},
    {"name": "uni0404", "unicode": 1028, "contours": [1]},
    {"name": "uni0405", "unicode": 1029, "contours": [1]},
    {"name": "uni0406", "unicode": 1030, "contours": [1]},
    {"name": "uni0407", "unicode": 1031, "contours": [3]},
    {"name": "uni0408", "unicode": 1032, "contours": [1]},
    {"name": "uni0409", "unicode": 1033, "contours": [2]},
    {"name": "uni040A", "unicode": 1034, "contours": [2]},
    {"name": "uni040B", "unicode": 1035, "contours": [1]},
    {"name": "uni040C", "unicode": 1036, "contours": [2]},
    {"name": "uni040D", "unicode": 1037, "contours": [2]},
    {"name": "uni040E", "unicode": 1038, "contours": [2]},
    {"name": "uni040F", "unicode": 1039, "contours": [1]},
    {"name": "uni0410", "unicode": 1040, "contours": [2]},
    {"name": "uni0411", "unicode": 1041, "contours": [2]},
    {"name": "uni0412", "unicode": 1042, "contours": [3]},
    {"name": "uni0413", "unicode": 1043, "contours": [1]},
    {"name": "uni0414", "unicode": 1044, "contours": [2]},
    {"name": "uni0415", "unicode": 1045, "contours": [1]},
    {"name": "uni0416", "unicode": 1046, "contours": [1]},
    {"name": "uni0417", "unicode": 1047, "contours": [1]},
    {"name": "uni0418", "unicode": 1048, "contours": [1]},
    {"name": "uni0419", "unicode": 1049, "contours": [2]},
    {"name": "uni041A", "unicode": 1050, "contours": [1]},
    {"name": "uni041B", "unicode": 1051, "contours": [1]},
    {"name": "uni041C", "unicode": 1052, "contours": [1]},
    {"name": "uni041D", "unicode": 1053, "contours": [1]},
    {"name": "uni041E", "unicode": 1054, "contours": [2]},
    {"name": "uni041F", "unicode": 1055, "contours": [1]},
    {"name": "uni0420", "unicode": 1056, "contours": [1, 2]},
    {"name": "uni0421", "unicode": 1057, "contours": [1]},
    {"name": "uni0422", "unicode": 1058, "contours": [1]},
    {"name": "uni0423", "unicode": 1059, "contours": [1]},
    {"name": "uni0424", "unicode": 1060, "contours": [3]},
    {"name": "uni0425", "unicode": 1061, "contours": [1]},
    {"name": "uni0426", "unicode": 1062, "contours": [1]},
    {"name": "uni20B1", "unicode": 8369, "contours": [1, 2, 4]},
    {"name": "uni0428", "unicode": 1064, "contours": [1]},
    {"name": "uni0429", "unicode": 1065, "contours": [1]},
    {"name": "uni042A", "unicode": 1066, "contours": [2]},
    {"name": "uni042B", "unicode": 1067, "contours": [3]},
    {"name": "uni042C", "unicode": 1068, "contours": [2]},
    {"name": "uni042D", "unicode": 1069, "contours": [1]},
    {"name": "uni042E", "unicode": 1070, "contours": [2]},
    {"name": "uni042F", "unicode": 1071, "contours": [2]},
    {"name": "uni0430", "unicode": 1072, "contours": [2]},
    {"name": "uni0431", "unicode": 1073, "contours": [2]},
    {"name": "uni0432", "unicode": 1074, "contours": [3]},
    {"name": "uni0433", "unicode": 1075, "contours": [1]},
    {"name": "uni0434", "unicode": 1076, "contours": [2]},
    {"name": "uni0435", "unicode": 1077, "contours": [2]},
    {"name": "uni0436", "unicode": 1078, "contours": [1]},
    {"name": "uni0437", "unicode": 1079, "contours": [1]},
    {"name": "uni0438", "unicode": 1080, "contours": [1]},
    {"name": "uni0439", "unicode": 1081, "contours": [2]},
    {"name": "uni043A", "unicode": 1082, "contours": [1]},
    {"name": "uni043B", "unicode": 1083, "contours": [1]},
    {"name": "uni043C", "unicode": 1084, "contours": [1]},
    {"name": "uni043D", "unicode": 1085, "contours": [1]},
    {"name": "uni043E", "unicode": 1086, "contours": [2]},
    {"name": "uni043F", "unicode": 1087, "contours": [1]},
    {"name": "uni0440", "unicode": 1088, "contours": [2]},
    {"name": "uni0441", "unicode": 1089, "contours": [1]},
    {"name": "uni0442", "unicode": 1090, "contours": [1]},
    {"name": "uni0443", "unicode": 1091, "contours": [1]},
    {"name": "uni0444", "unicode": 1092, "contours": [3]},
    {"name": "uni0445", "unicode": 1093, "contours": [1]},
    {"name": "uni0446", "unicode": 1094, "contours": [1]},
    {"name": "uni0447", "unicode": 1095, "contours": [1]},
    {"name": "uni0448", "unicode": 1096, "contours": [1]},
    {"name": "uni0449", "unicode": 1097, "contours": [1]},
    {"name": "uni044A", "unicode": 1098, "contours": [2]},
    {"name": "uni044B", "unicode": 1099, "contours": [3]},
    {"name": "uni044C", "unicode": 1100, "contours": [2]},
    {"name": "uni044D", "unicode": 1101, "contours": [1]},
    {"name": "uni044E", "unicode": 1102, "contours": [2]},
    {"name": "uni044F", "unicode": 1103, "contours": [2]},
    {"name": "uni0450", "unicode": 1104, "contours": [3]},
    {"name": "uni0451", "unicode": 1105, "contours": [4]},
    {"name": "uni0452", "unicode": 1106, "contours": [1]},
    {"name": "uni0453", "unicode": 1107, "contours": [2]},
    {"name": "uni0454", "unicode": 1108, "contours": [1]},
    {"name": "uni0455", "unicode": 1109, "contours": [1]},
    {"name": "uni0456", "unicode": 1110, "contours": [2]},
    {"name": "uni0457", "unicode": 1111, "contours": [3]},
    {"name": "uni0458", "unicode": 1112, "contours": [2]},
    {"name": "uni0459", "unicode": 1113, "contours": [2]},
    {"name": "uni045A", "unicode": 1114, "contours": [2]},
    {"name": "uni045B", "unicode": 1115, "contours": [1]},
    {"name": "uni045C", "unicode": 1116, "contours": [2]},
    {"name": "uni045D", "unicode": 1117, "contours": [2]},
    {"name": "uni045E", "unicode": 1118, "contours": [2]},
    {"name": "uni045F", "unicode": 1119, "contours": [1, 2]},
    {"name": "uni0460", "unicode": 1120, "contours": [1]},
    {"name": "uni0461", "unicode": 1121, "contours": [1]},
    {"name": "uni0462", "unicode": 1122, "contours": [2]},
    {"name": "uni0463", "unicode": 1123, "contours": [2]},
    {"name": "uni0464", "unicode": 1124, "contours": [1]},
    {"name": "uni0465", "unicode": 1125, "contours": [1]},
    {"name": "uni0466", "unicode": 1126, "contours": [2]},
    {"name": "uni0467", "unicode": 1127, "contours": [2]},
    {"name": "uni0468", "unicode": 1128, "contours": [2]},
    {"name": "uni20BC", "unicode": 8380, "contours": [1]},
    {"name": "uni046A", "unicode": 1130, "contours": [2]},
    {"name": "uni046B", "unicode": 1131, "contours": [2]},
    {"name": "uni046C", "unicode": 1132, "contours": [2]},
    {"name": "uni046D", "unicode": 1133, "contours": [2]},
    {"name": "uni046E", "unicode": 1134, "contours": [2]},
    {"name": "onehalf", "unicode": 189, "contours": [3]},
    {"name": "uni0470", "unicode": 1136, "contours": [1]},
    {"name": "uni0471", "unicode": 1137, "contours": [1]},
    {"name": "uni0472", "unicode": 1138, "contours": [3]},
    {"name": "uni0473", "unicode": 1139, "contours": [3]},
    {"name": "uni0474", "unicode": 1140, "contours": [1]},
    {"name": "uni0475", "unicode": 1141, "contours": [1]},
    {"name": "uni0476", "unicode": 1142, "contours": [3]},
    {"name": "uni0477", "unicode": 1143, "contours": [3]},
    {"name": "uni0478", "unicode": 1144, "contours": [3]},
    {"name": "uni0479", "unicode": 1145, "contours": [3]},
    {"name": "uni047A", "unicode": 1146, "contours": [2]},
    {"name": "questiondown", "unicode": 191, "contours": [2]},
    {"name": "uni047C", "unicode": 1148, "contours": [3]},
    {"name": "uni047D", "unicode": 1149, "contours": [3]},
    {"name": "uni047E", "unicode": 1150, "contours": [2]},
    {"name": "uni047F", "unicode": 1151, "contours": [2]},
    {"name": "uni0480", "unicode": 1152, "contours": [1]},
    {"name": "uni0481", "unicode": 1153, "contours": [1]},
    {"name": "uni0482", "unicode": 1154, "contours": [1]},
    {"name": "uni0483", "unicode": 1155, "contours": [1]},
    {"name": "uni0484", "unicode": 1156, "contours": [1]},
    {"name": "uni0485", "unicode": 1157, "contours": [1]},
    {"name": "uni0486", "unicode": 1158, "contours": [1]},
    {"name": "Aacute", "unicode": 193, "contours": [3]},
    {"name": "uni0488", "unicode": 1160, "contours": [8]},
    {"name": "uni0489", "unicode": 1161, "contours": [8]},
    {"name": "uni048A", "unicode": 1162, "contours": [2, 3]},
    {"name": "uni048B", "unicode": 1163, "contours": [2, 3]},
    {"name": "uni048C", "unicode": 1164, "contours": [2]},
    {"name": "uni048D", "unicode": 1165, "contours": [2]},
    {"name": "uni048E", "unicode": 1166, "contours": [1, 2]},
    {"name": "uni048F", "unicode": 1167, "contours": [2]},
    {"name": "uni0490", "unicode": 1168, "contours": [1]},
    {"name": "uni0491", "unicode": 1169, "contours": [1]},
    {"name": "uni0492", "unicode": 1170, "contours": [1]},
    {"name": "uni0493", "unicode": 1171, "contours": [1]},
    {"name": "uni0494", "unicode": 1172, "contours": [1]},
    {"name": "uni0495", "unicode": 1173, "contours": [1]},
    {"name": "uni0496", "unicode": 1174, "contours": [1, 2]},
    {"name": "uni0497", "unicode": 1175, "contours": [1, 2]},
    {"name": "uni0498", "unicode": 1176, "contours": [1, 2]},
    {"name": "uni0499", "unicode": 1177, "contours": [1, 2]},
    {"name": "uni049A", "unicode": 1178, "contours": [1, 2]},
    {"name": "uni049B", "unicode": 1179, "contours": [1, 2]},
    {"name": "uni049C", "unicode": 1180, "contours": [1]},
    {"name": "uni049D", "unicode": 1181, "contours": [1]},
    {"name": "uni049E", "unicode": 1182, "contours": [1]},
    {"name": "uni049F", "unicode": 1183, "contours": [1, 2]},
    {"name": "uni04A0", "unicode": 1184, "contours": [1]},
    {"name": "uni04A1", "unicode": 1185, "contours": [1]},
    {"name": "uni04A2", "unicode": 1186, "contours": [1, 2]},
    {"name": "uni04A3", "unicode": 1187, "contours": [1, 2]},
    {"name": "uni04A4", "unicode": 1188, "contours": [1]},
    {"name": "uni04A5", "unicode": 1189, "contours": [1]},
    {"name": "uni04A6", "unicode": 1190, "contours": [1]},
    {"name": "uni04A7", "unicode": 1191, "contours": [1]},
    {"name": "uni04A8", "unicode": 1192, "contours": [2]},
    {"name": "uni04A9", "unicode": 1193, "contours": [2]},
    {"name": "uni04AA", "unicode": 1194, "contours": [1, 2]},
    {"name": "uni04AB", "unicode": 1195, "contours": [1, 2]},
    {"name": "uni04AC", "unicode": 1196, "contours": [1, 2]},
    {"name": "uni04AD", "unicode": 1197, "contours": [1, 2]},
    {"name": "uni04AE", "unicode": 1198, "contours": [1]},
    {"name": "uni04AF", "unicode": 1199, "contours": [1]},
    {"name": "uni04B0", "unicode": 1200, "contours": [1]},
    {"name": "uni04B1", "unicode": 1201, "contours": [1]},
    {"name": "uni04B2", "unicode": 1202, "contours": [1, 2]},
    {"name": "uni04B3", "unicode": 1203, "contours": [1, 2]},
    {"name": "uni04B4", "unicode": 1204, "contours": [1]},
    {"name": "uni04B5", "unicode": 1205, "contours": [1]},
    {"name": "uni04B6", "unicode": 1206, "contours": [1, 2]},
    {"name": "uni04B7", "unicode": 1207, "contours": [1, 2]},
    {"name": "uni04B8", "unicode": 1208, "contours": [1]},
    {"name": "uni04B9", "unicode": 1209, "contours": [1]},
    {"name": "uni04BA", "unicode": 1210, "contours": [1]},
    {"name": "uni04BB", "unicode": 1211, "contours": [1]},
    {"name": "uni04BC", "unicode": 1212, "contours": [2]},
    {"name": "uni04BD", "unicode": 1213, "contours": [2]},
    {"name": "uni04BE", "unicode": 1214, "contours": [2, 3]},
    {"name": "uni04BF", "unicode": 1215, "contours": [2, 3]},
    {"name": "uni04C0", "unicode": 1216, "contours": [1]},
    {"name": "uni04C1", "unicode": 1217, "contours": [2]},
    {"name": "uni04C2", "unicode": 1218, "contours": [2]},
    {"name": "uni04C3", "unicode": 1219, "contours": [1]},
    {"name": "uni04C4", "unicode": 1220, "contours": [1]},
    {"name": "uni04C5", "unicode": 1221, "contours": [1, 2]},
    {"name": "uni04C6", "unicode": 1222, "contours": [1, 2]},
    {"name": "uni04C7", "unicode": 1223, "contours": [1]},
    {"name": "uni04C8", "unicode": 1224, "contours": [1]},
    {"name": "uni04C9", "unicode": 1225, "contours": [1, 2]},
    {"name": "uni04CA", "unicode": 1226, "contours": [1, 2]},
    {"name": "uni04CB", "unicode": 1227, "contours": [1, 2]},
    {"name": "uni04CC", "unicode": 1228, "contours": [1, 2]},
    {"name": "uni04CD", "unicode": 1229, "contours": [1, 2]},
    {"name": "uni04CE", "unicode": 1230, "contours": [1, 2]},
    {"name": "uni04CF", "unicode": 1231, "contours": [1]},
    {"name": "uni04D0", "unicode": 1232, "contours": [3]},
    {"name": "uni04D1", "unicode": 1233, "contours": [3]},
    {"name": "uni04D2", "unicode": 1234, "contours": [4]},
    {"name": "uni04D3", "unicode": 1235, "contours": [4]},
    {"name": "uni04D4", "unicode": 1236, "contours": [2]},
    {"name": "uni04D5", "unicode": 1237, "contours": [3]},
    {"name": "uni04D6", "unicode": 1238, "contours": [2]},
    {"name": "uni04D7", "unicode": 1239, "contours": [3]},
    {"name": "uni04D8", "unicode": 1240, "contours": [2]},
    {"name": "uni04D9", "unicode": 1241, "contours": [2]},
    {"name": "uni04DA", "unicode": 1242, "contours": [4]},
    {"name": "uni04DB", "unicode": 1243, "contours": [4]},
    {"name": "uni04DC", "unicode": 1244, "contours": [3]},
    {"name": "uni04DD", "unicode": 1245, "contours": [3]},
    {"name": "uni04DE", "unicode": 1246, "contours": [3]},
    {"name": "uni04DF", "unicode": 1247, "contours": [3]},
    {"name": "uni04E0", "unicode": 1248, "contours": [1]},
    {"name": "uni04E1", "unicode": 1249, "contours": [1]},
    {"name": "uni04E2", "unicode": 1250, "contours": [2]},
    {"name": "uni04E3", "unicode": 1251, "contours": [2]},
    {"name": "uni04E4", "unicode": 1252, "contours": [3]},
    {"name": "uni04E5", "unicode": 1253, "contours": [3]},
    {"name": "uni04E6", "unicode": 1254, "contours": [4]},
    {"name": "uni04E7", "unicode": 1255, "contours": [4]},
    {"name": "uni04E8", "unicode": 1256, "contours": [3]},
    {"name": "uni04E9", "unicode": 1257, "contours": [3]},
    {"name": "uni04EA", "unicode": 1258, "contours": [5]},
    {"name": "uni04EB", "unicode": 1259, "contours": [5]},
    {"name": "uni04EC", "unicode": 1260, "contours": [3]},
    {"name": "uni04ED", "unicode": 1261, "contours": [3]},
    {"name": "uni04EE", "unicode": 1262, "contours": [2]},
    {"name": "uni04EF", "unicode": 1263, "contours": [2]},
    {"name": "uni04F0", "unicode": 1264, "contours": [3]},
    {"name": "uni04F1", "unicode": 1265, "contours": [3]},
    {"name": "uni04F2", "unicode": 1266, "contours": [3]},
    {"name": "uni04F3", "unicode": 1267, "contours": [3]},
    {"name": "uni04F4", "unicode": 1268, "contours": [3]},
    {"name": "uni04F5", "unicode": 1269, "contours": [3]},
    {"name": "uni04F6", "unicode": 1270, "contours": [1, 2]},
    {"name": "uni04F7", "unicode": 1271, "contours": [1, 2]},
    {"name": "uni04F8", "unicode": 1272, "contours": [5]},
    {"name": "uni04F9", "unicode": 1273, "contours": [5]},
    {"name": "uni04FA", "unicode": 1274, "contours": [1, 3]},
    {"name": "uni04FB", "unicode": 1275, "contours": [1, 3]},
    {"name": "uni04FC", "unicode": 1276, "contours": [1, 2]},
    {"name": "uni04FD", "unicode": 1277, "contours": [1, 2]},
    {"name": "uni04FE", "unicode": 1278, "contours": [1]},
    {"name": "uni04FF", "unicode": 1279, "contours": [1]},
    {"name": "SF100000", "unicode": 9472, "contours": [1]},
    {"name": "uni0501", "unicode": 1281, "contours": [2]},
    {"name": "SF110000", "unicode": 9474, "contours": [1]},
    {"name": "uni0503", "unicode": 1283, "contours": [2]},
    {"name": "uni0504", "unicode": 1284, "contours": [1]},
    {"name": "uni0505", "unicode": 1285, "contours": [1]},
    {"name": "uni0506", "unicode": 1286, "contours": [1]},
    {"name": "uni0507", "unicode": 1287, "contours": [1]},
    {"name": "uni0508", "unicode": 1288, "contours": [1]},
    {"name": "uni0509", "unicode": 1289, "contours": [1]},
    {"name": "uni050A", "unicode": 1290, "contours": [1]},
    {"name": "uni050B", "unicode": 1291, "contours": [1]},
    {"name": "SF010000", "unicode": 9484, "contours": [1]},
    {"name": "uni050D", "unicode": 1293, "contours": [1]},
    {"name": "uni050E", "unicode": 1294, "contours": [1]},
    {"name": "uni050F", "unicode": 1295, "contours": [1]},
    {"name": "uni0510", "unicode": 1296, "contours": [1]},
    {"name": "uni0511", "unicode": 1297, "contours": [1]},
    {"name": "uni0512", "unicode": 1298, "contours": [1, 2]},
    {"name": "uni0513", "unicode": 1299, "contours": [1, 2]},
    {"name": "SF020000", "unicode": 9492, "contours": [1]},
    {"name": "SF040000", "unicode": 9496, "contours": [1]},
    {"name": "uni051A", "unicode": 1306, "contours": [2]},
    {"name": "uni051B", "unicode": 1307, "contours": [2]},
    {"name": "uni051C", "unicode": 1308, "contours": [1]},
    {"name": "uni051D", "unicode": 1309, "contours": [1]},
    {"name": "uni2023", "unicode": 8227, "contours": [1]},
    {"name": "uni0524", "unicode": 1316, "contours": [1]},
    {"name": "uni0525", "unicode": 1317, "contours": [1]},
    {"name": "uni0526", "unicode": 1318, "contours": [1]},
    {"name": "uni0527", "unicode": 1319, "contours": [1]},
    {"name": "uni0528", "unicode": 1320, "contours": [1]},
    {"name": "uni0529", "unicode": 1321, "contours": [1]},
    {"name": "SF060000", "unicode": 9516, "contours": [1]},
    {"name": "uni052E", "unicode": 1326, "contours": [1]},
    {"name": "uni052F", "unicode": 1327, "contours": [1]},
    {"name": "SF070000", "unicode": 9524, "contours": [1]},
    {"name": "SF050000", "unicode": 9532, "contours": [1]},
    {"name": "onedotenleader", "unicode": 8228, "contours": [1]},
    {"name": "SF430000", "unicode": 9552, "contours": [2]},
    {"name": "SF240000", "unicode": 9553, "contours": [2]},
    {"name": "SF510000", "unicode": 9554, "contours": [2]},
    {"name": "SF520000", "unicode": 9555, "contours": [2]},
    {"name": "SF390000", "unicode": 9556, "contours": [2]},
    {"name": "SF220000", "unicode": 9557, "contours": [2]},
    {"name": "SF210000", "unicode": 9558, "contours": [2]},
    {"name": "SF250000", "unicode": 9559, "contours": [2]},
    {"name": "SF500000", "unicode": 9560, "contours": [2]},
    {"name": "SF490000", "unicode": 9561, "contours": [2]},
    {"name": "SF380000", "unicode": 9562, "contours": [2]},
    {"name": "SF280000", "unicode": 9563, "contours": [2]},
    {"name": "SF270000", "unicode": 9564, "contours": [2]},
    {"name": "SF260000", "unicode": 9565, "contours": [2]},
    {"name": "SF360000", "unicode": 9566, "contours": [2]},
    {"name": "SF370000", "unicode": 9567, "contours": [2]},
    {"name": "SF420000", "unicode": 9568, "contours": [3]},
    {"name": "SF190000", "unicode": 9569, "contours": [2]},
    {"name": "SF200000", "unicode": 9570, "contours": [2]},
    {"name": "SF230000", "unicode": 9571, "contours": [3]},
    {"name": "SF470000", "unicode": 9572, "contours": [2]},
    {"name": "SF480000", "unicode": 9573, "contours": [1]},
    {"name": "SF410000", "unicode": 9574, "contours": [3]},
    {"name": "SF450000", "unicode": 9575, "contours": [2]},
    {"name": "SF460000", "unicode": 9576, "contours": [1]},
    {"name": "SF400000", "unicode": 9577, "contours": [3]},
    {"name": "SF540000", "unicode": 9578, "contours": [1]},
    {"name": "SF530000", "unicode": 9579, "contours": [1]},
    {"name": "SF440000", "unicode": 9580, "contours": [4]},
    {"name": "ellipsis", "unicode": 8230, "contours": [3]},
    {"name": "block", "unicode": 9608, "contours": [1]},
    {"name": "uni058F", "unicode": 1423, "contours": [1]},
    {"name": "ltshade", "unicode": 9617, "contours": [46]},
    {"name": "shade", "unicode": 9618, "contours": [85]},
    {"name": "dkshade", "unicode": 9619, "contours": [73]},
    {"name": "uni2027", "unicode": 8231, "contours": [1]},
    {"name": "uni25A0", "unicode": 9632, "contours": [1]},
    {"name": "uni25A1", "unicode": 9633, "contours": [2]},
    {"name": "uni25AA", "unicode": 9642, "contours": [1]},
    {"name": "uni25AB", "unicode": 9643, "contours": [2]},
    {"name": "triagup", "unicode": 9650, "contours": [1]},
    {"name": "uni25B3", "unicode": 9651, "contours": [2]},
    {"name": "uni25B6", "unicode": 9654, "contours": [1]},
    {"name": "uni25B7", "unicode": 9655, "contours": [2]},
    {"name": "triagdn", "unicode": 9660, "contours": [1]},
    {"name": "uni25BD", "unicode": 9661, "contours": [2]},
    {"name": "uni25C0", "unicode": 9664, "contours": [1]},
    {"name": "uni25C1", "unicode": 9665, "contours": [2]},
    {"name": "uni25C6", "unicode": 9670, "contours": [1]},
    {"name": "uni25C7", "unicode": 9671, "contours": [2]},
    {"name": "uni25C9", "unicode": 9673, "contours": [3]},
    {"name": "lozenge", "unicode": 9674, "contours": [2]},
    {"name": "circle", "unicode": 9675, "contours": [2]},
    {"name": "uni25CC", "unicode": 9676, "contours": [16, 12]},
    {"name": "uni25CF", "unicode": 9679, "contours": [1]},
    {"name": "uni2102", "unicode": 8450, "contours": [2]},
    {"name": "uni2610", "unicode": 9744, "contours": [2]},
    {"name": "uni2611", "unicode": 9745, "contours": [2]},
    {"name": "uni2105", "unicode": 8453, "contours": [4]},
    {"name": "uni210A", "unicode": 8458, "contours": [2]},
    {"name": "uni210D", "unicode": 8461, "contours": [2]},
    {"name": "musicalnote", "unicode": 9834, "contours": [1]},
    {"name": "emacron", "unicode": 275, "contours": [3]},
    {"name": "uni0002", "unicode": 2, "contours": [0]},
    {"name": "uni2115", "unicode": 8469, "contours": [2]},
    {"name": "Edotaccent", "unicode": 278, "contours": [2]},
    {"name": "uni202F", "unicode": 8239, "contours": [0]},
    {"name": "uni2117", "unicode": 8471, "contours": [3, 4]},
    {"name": "uni2119", "unicode": 8473, "contours": [2]},
    {"name": "uni211A", "unicode": 8474, "contours": [3]},
    {"name": "perthousand", "unicode": 8240, "contours": [6, 7]},
    {"name": "uni26AD", "unicode": 9901, "contours": [4]},
    {"name": "uni26AE", "unicode": 9902, "contours": [3]},
    {"name": "uni26AF", "unicode": 9903, "contours": [3]},
    {"name": "nine", "unicode": 57, "contours": [1, 2]},
    {"name": "Gdotaccent", "unicode": 288, "contours": [2]},
    {"name": "uni2031", "unicode": 8241, "contours": [9]},
    {"name": "trademark", "unicode": 8482, "contours": [2]},
    {"name": "colon", "unicode": 58, "contours": [2]},
    {"name": "uni2124", "unicode": 8484, "contours": [2]},
    {"name": "Hbar", "unicode": 294, "contours": [2]},
    {"name": "ibreve", "unicode": 301, "contours": [2]},
    {"name": "uni2713", "unicode": 10003, "contours": [1]},
    {"name": "Iogonek", "unicode": 302, "contours": [1, 2]},
    {"name": "uni2034", "unicode": 8244, "contours": [3]},
    {"name": "ij", "unicode": 307, "contours": [3, 4]},
    {"name": "uni2035", "unicode": 8245, "contours": [1]},
    {"name": "uni2752", "unicode": 10066, "contours": [2]},
    {"name": "uni275B", "unicode": 10075, "contours": [1]},
    {"name": "uni275C", "unicode": 10076, "contours": [1]},
    {"name": "uni275D", "unicode": 10077, "contours": [1]},
    {"name": "uni275E", "unicode": 10078, "contours": [1]},
    {"name": "uni2761", "unicode": 10081, "contours": [2]},
    {"name": "uni2037", "unicode": 8247, "contours": [3]},
    {"name": "uni2780", "unicode": 10112, "contours": [3]},
    {"name": "uni2781", "unicode": 10113, "contours": [3]},
    {"name": "uni2782", "unicode": 10114, "contours": [3]},
    {"name": "uni2783", "unicode": 10115, "contours": [4]},
    {"name": "uni2784", "unicode": 10116, "contours": [3]},
    {"name": "uni2785", "unicode": 10117, "contours": [4]},
    {"name": "uni2786", "unicode": 10118, "contours": [3]},
    {"name": "uni2787", "unicode": 10119, "contours": [5]},
    {"name": "uni2788", "unicode": 10120, "contours": [4]},
    {"name": "uniA78B", "unicode": 42891, "contours": [1]},
    {"name": "uniA78C", "unicode": 42892, "contours": [1]},
    {"name": "uniFFFC", "unicode": 65532, "contours": [22]},
    {"name": "uni2038", "unicode": 8248, "contours": [1]},
    {"name": "uniFFFD", "unicode": 65533, "contours": [3, 5]},
    {"name": "uni27C2", "unicode": 10178, "contours": [1]},
    {"name": "uni27E8", "unicode": 10216, "contours": [1]},
    {"name": "uni27E9", "unicode": 10217, "contours": [1]},
    {"name": "oe", "unicode": 339, "contours": [3]},
    {"name": "Racute", "unicode": 340, "contours": [3]},
    {"name": "onefifth", "unicode": 8533, "contours": [3]},
    {"name": "twofifths", "unicode": 8534, "contours": [3]},
    {"name": "threefifths", "unicode": 8535, "contours": [3]},
    {"name": "fourfifths", "unicode": 8536, "contours": [3, 4]},
    {"name": "onesixth", "unicode": 8537, "contours": [4]},
    {"name": "fivesixths", "unicode": 8538, "contours": [4]},
    {"name": "sacute", "unicode": 347, "contours": [2]},
    {"name": "threeeighths", "unicode": 8540, "contours": [5]},
    {"name": "uni203D", "unicode": 8253, "contours": [2]},
    {"name": "fiveeighths", "unicode": 8541, "contours": [5]},
    {"name": "seveneighths", "unicode": 8542, "contours": [5]},
    {"name": "uni203F", "unicode": 8255, "contours": [1]},
    {"name": "utilde", "unicode": 361, "contours": [2]},
    {"name": "uni2040", "unicode": 8256, "contours": [1]},
    {"name": "I", "unicode": 73, "contours": [1]},
    {"name": "uni2043", "unicode": 8259, "contours": [1]},
    {"name": "uniA8FB", "unicode": 43259, "contours": [1]},
    {"name": "fraction", "unicode": 8260, "contours": [1]},
    {"name": "uni0901", "unicode": 2305, "contours": [2]},
    {"name": "uni0902", "unicode": 2306, "contours": [1]},
    {"name": "uni0903", "unicode": 2307, "contours": [2]},
    {"name": "uni0904", "unicode": 2308, "contours": [1]},
    {"name": "uni0905", "unicode": 2309, "contours": [1]},
    {"name": "uni0906", "unicode": 2310, "contours": [1]},
    {"name": "uni0907", "unicode": 2311, "contours": [1]},
    {"name": "uni0908", "unicode": 2312, "contours": [1]},
    {"name": "uni0909", "unicode": 2313, "contours": [1]},
    {"name": "uni090A", "unicode": 2314, "contours": [1]},
    {"name": "uni090B", "unicode": 2315, "contours": [1]},
    {"name": "uni090C", "unicode": 2316, "contours": [1]},
    {"name": "uni090D", "unicode": 2317, "contours": [2]},
    {"name": "uni090E", "unicode": 2318, "contours": [1]},
    {"name": "uni090F", "unicode": 2319, "contours": [1]},
    {"name": "uni0910", "unicode": 2320, "contours": [1]},
    {"name": "uni0911", "unicode": 2321, "contours": [2]},
    {"name": "uni0912", "unicode": 2322, "contours": [1]},
    {"name": "uni0913", "unicode": 2323, "contours": [1]},
    {"name": "uni0914", "unicode": 2324, "contours": [1]},
    {"name": "uni0915", "unicode": 2325, "contours": [1, 2]},
    {"name": "uni0916", "unicode": 2326, "contours": [1, 3]},
    {"name": "uni0917", "unicode": 2327, "contours": [1]},
    {"name": "uni0918", "unicode": 2328, "contours": [2]},
    {"name": "uni0919", "unicode": 2329, "contours": [2]},
    {"name": "uni091A", "unicode": 2330, "contours": [1]},
    {"name": "uni091B", "unicode": 2331, "contours": [2]},
    {"name": "uni091C", "unicode": 2332, "contours": [1]},
    {"name": "uni091D", "unicode": 2333, "contours": [2]},
    {"name": "uni091E", "unicode": 2334, "contours": [1]},
    {"name": "uni091F", "unicode": 2335, "contours": [1]},
    {"name": "uni0920", "unicode": 2336, "contours": [2]},
    {"name": "uni0921", "unicode": 2337, "contours": [1]},
    {"name": "uni0922", "unicode": 2338, "contours": [1, 2]},
    {"name": "uni0923", "unicode": 2339, "contours": [2]},
    {"name": "uni0924", "unicode": 2340, "contours": [1]},
    {"name": "uni0925", "unicode": 2341, "contours": [1]},
    {"name": "uni0926", "unicode": 2342, "contours": [1]},
    {"name": "uni0927", "unicode": 2343, "contours": [1]},
    {"name": "uni0928", "unicode": 2344, "contours": [1]},
    {"name": "uni0929", "unicode": 2345, "contours": [2]},
    {"name": "uni092A", "unicode": 2346, "contours": [2]},
    {"name": "uni092B", "unicode": 2347, "contours": [2]},
    {"name": "uni092C", "unicode": 2348, "contours": [2, 3]},
    {"name": "uni092D", "unicode": 2349, "contours": [1]},
    {"name": "uni092E", "unicode": 2350, "contours": [2]},
    {"name": "uni092F", "unicode": 2351, "contours": [2]},
    {"name": "uni0930", "unicode": 2352, "contours": [1]},
    {"name": "uni0931", "unicode": 2353, "contours": [2]},
    {"name": "uni0932", "unicode": 2354, "contours": [1]},
    {"name": "uni0933", "unicode": 2355, "contours": [3]},
    {"name": "uni0934", "unicode": 2356, "contours": [4]},
    {"name": "uni0935", "unicode": 2357, "contours": [1, 2]},
    {"name": "uni0936", "unicode": 2358, "contours": [2]},
    {"name": "uni0937", "unicode": 2359, "contours": [3]},
    {"name": "uni0938", "unicode": 2360, "contours": [2]},
    {"name": "uni0939", "unicode": 2361, "contours": [1]},
    {"name": "uni093A", "unicode": 2362, "contours": [1]},
    {"name": "uni093B", "unicode": 2363, "contours": [1]},
    {"name": "uni093C", "unicode": 2364, "contours": [1]},
    {"name": "uni093D", "unicode": 2365, "contours": [1]},
    {"name": "uni093E", "unicode": 2366, "contours": [1]},
    {"name": "uni093F", "unicode": 2367, "contours": [1]},
    {"name": "uni0940", "unicode": 2368, "contours": [1]},
    {"name": "uni0941", "unicode": 2369, "contours": [1]},
    {"name": "uni0942", "unicode": 2370, "contours": [1]},
    {"name": "uni0943", "unicode": 2371, "contours": [1]},
    {"name": "uni0944", "unicode": 2372, "contours": [1]},
    {"name": "uni0945", "unicode": 2373, "contours": [1]},
    {"name": "uni0946", "unicode": 2374, "contours": [1]},
    {"name": "uni0947", "unicode": 2375, "contours": [1]},
    {"name": "uni0948", "unicode": 2376, "contours": [1]},
    {"name": "uni0949", "unicode": 2377, "contours": [2]},
    {"name": "uni094A", "unicode": 2378, "contours": [1]},
    {"name": "uni094B", "unicode": 2379, "contours": [1]},
    {"name": "uni094C", "unicode": 2380, "contours": [1]},
    {"name": "uni094D", "unicode": 2381, "contours": [1]},
    {"name": "uni094F", "unicode": 2383, "contours": [1]},
    {"name": "uni0950", "unicode": 2384, "contours": [3]},
    {"name": "uni0951", "unicode": 2385, "contours": [1]},
    {"name": "uni0952", "unicode": 2386, "contours": [1]},
    {"name": "uni0953", "unicode": 2387, "contours": [1]},
    {"name": "uni0954", "unicode": 2388, "contours": [1]},
    {"name": "uni0955", "unicode": 2389, "contours": [2]},
    {"name": "uni0956", "unicode": 2390, "contours": [1]},
    {"name": "uni0957", "unicode": 2391, "contours": [2]},
    {"name": "uni0958", "unicode": 2392, "contours": [2, 3]},
    {"name": "uni0959", "unicode": 2393, "contours": [2, 4]},
    {"name": "uni095A", "unicode": 2394, "contours": [2]},
    {"name": "uni095B", "unicode": 2395, "contours": [2]},
    {"name": "uni095C", "unicode": 2396, "contours": [2]},
    {"name": "uni095D", "unicode": 2397, "contours": [2, 3]},
    {"name": "uni095E", "unicode": 2398, "contours": [3]},
    {"name": "uni095F", "unicode": 2399, "contours": [3]},
    {"name": "uni0960", "unicode": 2400, "contours": [1]},
    {"name": "uni0190", "unicode": 400, "contours": [1]},
    {"name": "uni0962", "unicode": 2402, "contours": [1]},
    {"name": "uni0963", "unicode": 2403, "contours": [1]},
    {"name": "uni0964", "unicode": 2404, "contours": [1]},
    {"name": "uni0965", "unicode": 2405, "contours": [2]},
    {"name": "uni0966", "unicode": 2406, "contours": [2]},
    {"name": "uni0191", "unicode": 401, "contours": [1]},
    {"name": "uni0968", "unicode": 2408, "contours": [1]},
    {"name": "uni0969", "unicode": 2409, "contours": [1]},
    {"name": "uni096A", "unicode": 2410, "contours": [2]},
    {"name": "uni096B", "unicode": 2411, "contours": [1]},
    {"name": "uni096C", "unicode": 2412, "contours": [1, 2]},
    {"name": "uni0192", "unicode": 402, "contours": [1]},
    {"name": "uni096E", "unicode": 2414, "contours": [1, 3]},
    {"name": "uni096F", "unicode": 2415, "contours": [2]},
    {"name": "uni0970", "unicode": 2416, "contours": [2]},
    {"name": "uni0971", "unicode": 2417, "contours": [1]},
    {"name": "uni0972", "unicode": 2418, "contours": [2]},
    {"name": "uni0193", "unicode": 403, "contours": [1]},
    {"name": "uni0974", "unicode": 2420, "contours": [1]},
    {"name": "uni0975", "unicode": 2421, "contours": [1]},
    {"name": "uni0976", "unicode": 2422, "contours": [2]},
    {"name": "uni0977", "unicode": 2423, "contours": [3]},
    {"name": "uni0194", "unicode": 404, "contours": [2]},
    {"name": "uni097A", "unicode": 2426, "contours": [3]},
    {"name": "uni097B", "unicode": 2427, "contours": [1]},
    {"name": "uni097C", "unicode": 2428, "contours": [1]},
    {"name": "uni097D", "unicode": 2429, "contours": [1]},
    {"name": "uni097E", "unicode": 2430, "contours": [2]},
    {"name": "uni0195", "unicode": 405, "contours": [1]},
    {"name": "uni2983", "unicode": 10627, "contours": [2]},
    {"name": "uni2984", "unicode": 10628, "contours": [2]},
    {"name": "uni0196", "unicode": 406, "contours": [1]},
    {"name": "uni0197", "unicode": 407, "contours": [1]},
    {"name": "uni0198", "unicode": 408, "contours": [1]},
    {"name": "uni2199", "unicode": 8601, "contours": [1]},
    {"name": "uni299B", "unicode": 10651, "contours": [2]},
    {"name": "uni299D", "unicode": 10653, "contours": [3]},
    {"name": "uni204B", "unicode": 8267, "contours": [2]},
    {"name": "uni21A4", "unicode": 8612, "contours": [1]},
    {"name": "uni21A5", "unicode": 8613, "contours": [1]},
    {"name": "uni21A6", "unicode": 8614, "contours": [1]},
    {"name": "uni21A7", "unicode": 8615, "contours": [1]},
    {"name": "uni01AB", "unicode": 427, "contours": [1]},
    {"name": "uni21B0", "unicode": 8624, "contours": [1]},
    {"name": "uni01B1", "unicode": 433, "contours": [1]},
    {"name": "uni21B2", "unicode": 8626, "contours": [1]},
    {"name": "uni2A2F", "unicode": 10799, "contours": [1]},
    {"name": "uni21B3", "unicode": 8627, "contours": [1]},
    {"name": "uni21B4", "unicode": 8628, "contours": [1]},
    {"name": "uni21B5", "unicode": 8629, "contours": [1]},
    {"name": "uni21B6", "unicode": 8630, "contours": [1]},
    {"name": "uni21B7", "unicode": 8631, "contours": [1]},
    {"name": "uni21B8", "unicode": 8632, "contours": [2]},
    {"name": "uni21B9", "unicode": 8633, "contours": [4]},
    {"name": "uni21BA", "unicode": 8634, "contours": [1]},
    {"name": "uni21BC", "unicode": 8636, "contours": [1]},
    {"name": "uni21BD", "unicode": 8637, "contours": [1]},
    {"name": "uni21BE", "unicode": 8638, "contours": [1]},
    {"name": "uni21BF", "unicode": 8639, "contours": [1]},
    {"name": "uni21C0", "unicode": 8640, "contours": [1]},
    {"name": "uni21C1", "unicode": 8641, "contours": [1]},
    {"name": "uni21C2", "unicode": 8642, "contours": [1]},
    {"name": "uni21C3", "unicode": 8643, "contours": [1]},
    {"name": "uni21C4", "unicode": 8644, "contours": [2]},
    {"name": "uni21C5", "unicode": 8645, "contours": [2]},
    {"name": "uni21C6", "unicode": 8646, "contours": [2]},
    {"name": "uni21C7", "unicode": 8647, "contours": [1]},
    {"name": "uni21C8", "unicode": 8648, "contours": [1]},
    {"name": "uni21C9", "unicode": 8649, "contours": [1]},
    {"name": "uni21CA", "unicode": 8650, "contours": [1]},
    {"name": "uni21CB", "unicode": 8651, "contours": [2]},
    {"name": "uni21CC", "unicode": 8652, "contours": [2]},
    {"name": "arrowdblright", "unicode": 8658, "contours": [1]},
    {"name": "arrowdblboth", "unicode": 8660, "contours": [2]},
    {"name": "uni21DA", "unicode": 8666, "contours": [1]},
    {"name": "uni21DB", "unicode": 8667, "contours": [1]},
    {"name": "uni21DC", "unicode": 8668, "contours": [1]},
    {"name": "uni21DD", "unicode": 8669, "contours": [1]},
    {"name": "uni21DE", "unicode": 8670, "contours": [1]},
    {"name": "uni21DF", "unicode": 8671, "contours": [1]},
    {"name": "uni21E0", "unicode": 8672, "contours": [3]},
    {"name": "uni21E1", "unicode": 8673, "contours": [3]},
    {"name": "uni21E2", "unicode": 8674, "contours": [3]},
    {"name": "uni21E3", "unicode": 8675, "contours": [3]},
    {"name": "uni2B58", "unicode": 11096, "contours": [2]},
    {"name": "uni21E4", "unicode": 8676, "contours": [2]},
    {"name": "uni21E5", "unicode": 8677, "contours": [2]},
    {"name": "uni21F5", "unicode": 8693, "contours": [2]},
    {"name": "uni205D", "unicode": 8285, "contours": [3]},
    {"name": "universal", "unicode": 8704, "contours": [2]},
    {"name": "Ainvertedbreve", "unicode": 514, "contours": [3]},
    {"name": "existential", "unicode": 8707, "contours": [1]},
    {"name": "uni2204", "unicode": 8708, "contours": [3]},
    {"name": "emptyset", "unicode": 8709, "contours": [3]},
    {"name": "Einvertedbreve", "unicode": 518, "contours": [2]},
    {"name": "uni205F", "unicode": 8287, "contours": [0]},
    {"name": "gradient", "unicode": 8711, "contours": [2]},
    {"name": "element", "unicode": 8712, "contours": [1]},
    {"name": "notelement", "unicode": 8713, "contours": [3]},
    {"name": "suchthat", "unicode": 8715, "contours": [1]},
    {"name": "uni220C", "unicode": 8716, "contours": [3]},
    {"name": "uni220E", "unicode": 8718, "contours": [1]},
    {"name": "oinvertedbreve", "unicode": 527, "contours": [3]},
    {"name": "rdblgrave", "unicode": 529, "contours": [3]},
    {"name": "Rinvertedbreve", "unicode": 530, "contours": [3]},
    {"name": "uni2213", "unicode": 8723, "contours": [2]},
    {"name": "udblgrave", "unicode": 533, "contours": [3]},
    {"name": "uni2216", "unicode": 8726, "contours": [1]},
    {"name": "asteriskmath", "unicode": 8727, "contours": [1]},
    {"name": "uni2218", "unicode": 8728, "contours": [2]},
    {"name": "uni0219", "unicode": 537, "contours": [2]},
    {"name": "radical", "unicode": 8730, "contours": [1]},
    {"name": "proportional", "unicode": 8733, "contours": [2]},
    {"name": "uni021E", "unicode": 542, "contours": [2]},
    {"name": "orthogonal", "unicode": 8735, "contours": [1]},
    {"name": "angle", "unicode": 8736, "contours": [1]},
    {"name": "uni2221", "unicode": 8737, "contours": [2]},
    {"name": "uni2222", "unicode": 8738, "contours": [2]},
    {"name": "uni2223", "unicode": 8739, "contours": [1]},
    {"name": "uni2224", "unicode": 8740, "contours": [1]},
    {"name": "uni2225", "unicode": 8741, "contours": [2]},
    {"name": "uni2226", "unicode": 8742, "contours": [1]},
    {"name": "logicaland", "unicode": 8743, "contours": [1]},
    {"name": "logicalor", "unicode": 8744, "contours": [1]},
    {"name": "intersection", "unicode": 8745, "contours": [1]},
    {"name": "union", "unicode": 8746, "contours": [1]},
    {"name": "uni022B", "unicode": 555, "contours": [5]},
    {"name": "uni222C", "unicode": 8748, "contours": [2]},
    {"name": "uni222D", "unicode": 8749, "contours": [3]},
    {"name": "uni222E", "unicode": 8750, "contours": [3]},
    {"name": "uni222F", "unicode": 8751, "contours": [4]},
    {"name": "uni2230", "unicode": 8752, "contours": [5]},
    {"name": "therefore", "unicode": 8756, "contours": [3]},
    {"name": "uni2235", "unicode": 8757, "contours": [3]},
    {"name": "uni2236", "unicode": 8758, "contours": [2]},
    {"name": "similar", "unicode": 8764, "contours": [1]},
    {"name": "uni223D", "unicode": 8765, "contours": [1]},
    {"name": "uni2241", "unicode": 8769, "contours": [1]},
    {"name": "uni2243", "unicode": 8771, "contours": [2]},
    {"name": "congruent", "unicode": 8773, "contours": [3]},
    {"name": "uni0248", "unicode": 584, "contours": [1]},
    {"name": "uni2249", "unicode": 8777, "contours": [1]},
    {"name": "w", "unicode": 119, "contours": [1]},
    {"name": "uni0E01", "unicode": 3585, "contours": [1]},
    {"name": "uni0E02", "unicode": 3586, "contours": [1, 2]},
    {"name": "uni0E03", "unicode": 3587, "contours": [1, 2]},
    {"name": "uni0E04", "unicode": 3588, "contours": [1, 2]},
    {"name": "uni0E05", "unicode": 3589, "contours": [1, 2]},
    {"name": "uni0E06", "unicode": 3590, "contours": [1, 3]},
    {"name": "uni0E07", "unicode": 3591, "contours": [1, 2]},
    {"name": "uni0E08", "unicode": 3592, "contours": [1, 2]},
    {"name": "uni0E09", "unicode": 3593, "contours": [1, 3]},
    {"name": "uni0E0A", "unicode": 3594, "contours": [1, 2]},
    {"name": "uni0E0B", "unicode": 3595, "contours": [1, 2]},
    {"name": "uni0E0C", "unicode": 3596, "contours": [1, 3]},
    {"name": "uni0E0D", "unicode": 3597, "contours": [1, 4]},
    {"name": "uni0E0E", "unicode": 3598, "contours": [1, 3]},
    {"name": "uni0E0F", "unicode": 3599, "contours": [1, 3]},
    {"name": "uni0E10", "unicode": 3600, "contours": [1, 5]},
    {"name": "uni0E11", "unicode": 3601, "contours": [1, 2]},
    {"name": "uni0E12", "unicode": 3602, "contours": [1, 3]},
    {"name": "uni0E13", "unicode": 3603, "contours": [1, 3]},
    {"name": "uni0E14", "unicode": 3604, "contours": [1, 2]},
    {"name": "uni0E15", "unicode": 3605, "contours": [1, 2]},
    {"name": "uni0E16", "unicode": 3606, "contours": [1, 2]},
    {"name": "uni2259", "unicode": 8793, "contours": [3]},
    {"name": "uni2E18", "unicode": 11800, "contours": [2]},
    {"name": "uni0E19", "unicode": 3609, "contours": [1, 3]},
    {"name": "uni0E1A", "unicode": 3610, "contours": [1, 2]},
    {"name": "uni0E1B", "unicode": 3611, "contours": [1, 2]},
    {"name": "uni0E1C", "unicode": 3612, "contours": [1, 2]},
    {"name": "uni0E1D", "unicode": 3613, "contours": [1, 2]},
    {"name": "uni0E1E", "unicode": 3614, "contours": [1, 2]},
    {"name": "uni0E1F", "unicode": 3615, "contours": [1, 2]},
    {"name": "uni0E20", "unicode": 3616, "contours": [1, 2]},
    {"name": "uni0E21", "unicode": 3617, "contours": [1, 3]},
    {"name": "uni0E22", "unicode": 3618, "contours": [1, 2]},
    {"name": "uni0E23", "unicode": 3619, "contours": [1, 2]},
    {"name": "uni0E24", "unicode": 3620, "contours": [1, 2]},
    {"name": "uni0E25", "unicode": 3621, "contours": [1, 2]},
    {"name": "uni0E26", "unicode": 3622, "contours": [1, 2]},
    {"name": "uni0E27", "unicode": 3623, "contours": [1, 2]},
    {"name": "uni0E28", "unicode": 3624, "contours": [1, 2]},
    {"name": "uni0E29", "unicode": 3625, "contours": [1, 3]},
    {"name": "uni0E2A", "unicode": 3626, "contours": [1, 2]},
    {"name": "uni0E2B", "unicode": 3627, "contours": [1, 3]},
    {"name": "uni0E2C", "unicode": 3628, "contours": [1, 3]},
    {"name": "uni0E2D", "unicode": 3629, "contours": [1, 2]},
    {"name": "uni0E2E", "unicode": 3630, "contours": [1, 3]},
    {"name": "uni0E2F", "unicode": 3631, "contours": [1, 2]},
    {"name": "uni0E30", "unicode": 3632, "contours": [2, 4]},
    {"name": "uni0E31", "unicode": 3633, "contours": [1, 2]},
    {"name": "uni0E32", "unicode": 3634, "contours": [1]},
    {"name": "uni0E33", "unicode": 3635, "contours": [3]},
    {"name": "uni0E34", "unicode": 3636, "contours": [1, 2]},
    {"name": "uni0E35", "unicode": 3637, "contours": [1, 2]},
    {"name": "uni0E36", "unicode": 3638, "contours": [2, 3]},
    {"name": "uni0E37", "unicode": 3639, "contours": [1, 2]},
    {"name": "uni0E38", "unicode": 3640, "contours": [1, 2]},
    {"name": "uni0E39", "unicode": 3641, "contours": [1, 2]},
    {"name": "uni2E3A", "unicode": 11834, "contours": [1]},
    {"name": "uni2E3B", "unicode": 11835, "contours": [1]},
    {"name": "uni0E3F", "unicode": 3647, "contours": [3, 5]},
    {"name": "uni0E40", "unicode": 3648, "contours": [1, 2]},
    {"name": "uni0E41", "unicode": 3649, "contours": [2, 4]},
    {"name": "uni0E42", "unicode": 3650, "contours": [1, 2]},
    {"name": "uni0E43", "unicode": 3651, "contours": [1, 3]},
    {"name": "uni0E44", "unicode": 3652, "contours": [1, 2]},
    {"name": "uni0E45", "unicode": 3653, "contours": [1]},
    {"name": "uni0E46", "unicode": 3654, "contours": [1, 2]},
    {"name": "equivalence", "unicode": 8801, "contours": [3]},
    {"name": "uni0E48", "unicode": 3656, "contours": [1]},
    {"name": "uni0E49", "unicode": 3657, "contours": [1, 2]},
    {"name": "uni0E4A", "unicode": 3658, "contours": [1, 2]},
    {"name": "uni0E4B", "unicode": 3659, "contours": [1]},
    {"name": "uni0E4C", "unicode": 3660, "contours": [1, 2]},
    {"name": "uni0E4D", "unicode": 3661, "contours": [2]},
    {"name": "uni0E4E", "unicode": 3662, "contours": [1]},
    {"name": "uni0E4F", "unicode": 3663, "contours": [4]},
    {"name": "uni0E50", "unicode": 3664, "contours": [2]},
    {"name": "uni0E51", "unicode": 3665, "contours": [1, 2]},
    {"name": "uni0E52", "unicode": 3666, "contours": [1, 2]},
    {"name": "uni0E53", "unicode": 3667, "contours": [1, 2]},
    {"name": "uni0E54", "unicode": 3668, "contours": [1, 2]},
    {"name": "uni0E55", "unicode": 3669, "contours": [1, 3]},
    {"name": "uni0E56", "unicode": 3670, "contours": [1, 2]},
    {"name": "uni0E57", "unicode": 3671, "contours": [1, 2]},
    {"name": "uni0E58", "unicode": 3672, "contours": [1, 2]},
    {"name": "uni0E59", "unicode": 3673, "contours": [1, 2]},
    {"name": "uni0E5A", "unicode": 3674, "contours": [1, 2]},
    {"name": "uni0E5B", "unicode": 3675, "contours": [1, 2]},
    {"name": "uni207A", "unicode": 8314, "contours": [1]},
    {"name": "uni207B", "unicode": 8315, "contours": [1]},
    {"name": "uni0FD5", "unicode": 4053, "contours": [1]},
    {"name": "fi", "unicode": 61441, "contours": [3]},
    {"name": "fl", "unicode": 61442, "contours": [2]},
    {"name": "uni02B9", "unicode": 697, "contours": [1]},
    {"name": "uni02BF", "unicode": 703, "contours": [1]},
    {"name": "dotmath", "unicode": 8901, "contours": [1]},
    {"name": "uni2308", "unicode": 8968, "contours": [1]},
    {"name": "uni2309", "unicode": 8969, "contours": [1]},
    {"name": "uni230A", "unicode": 8970, "contours": [1]},
    {"name": "uni230B", "unicode": 8971, "contours": [1]},
    {"name": "uniA900", "unicode": 43264, "contours": [2]},
    {"name": "brokenbar", "unicode": 166, "contours": [2]},
    {"name": "uni21B1", "unicode": 8625, "contours": [1]},
    {"name": "uni1E01", "unicode": 7681, "contours": [4]},
    {"name": "quotedbl", "unicode": 34, "contours": [2]},
    {"name": "logicalnot", "unicode": 172, "contours": [1]},
    {"name": "lira", "unicode": 8356, "contours": [1]},
    {"name": "registered", "unicode": 174, "contours": [3, 4]},
    {"name": "uni0E17", "unicode": 3607, "contours": [1, 2]},
    {"name": "uni0E18", "unicode": 3608, "contours": [1]},
    {"name": "two.sups", "unicode": 178, "contours": [1]},
    {"name": "oneseventh", "unicode": 62726, "contours": [3]},
    {"name": "twosevenths", "unicode": 62727, "contours": [3]},
    {"name": "threesevenths", "unicode": 62728, "contours": [3]},
    {"name": "foursevenths", "unicode": 62729, "contours": [4]},
    {"name": "fivesevenths", "unicode": 62730, "contours": [3]},
    {"name": "sixsevenths", "unicode": 62731, "contours": [4]},
    {"name": "oneninth", "unicode": 62732, "contours": [4]},
    {"name": "twoninths", "unicode": 62733, "contours": [4]},
    {"name": "fourninths", "unicode": 62734, "contours": [5]},
    {"name": "fiveninths", "unicode": 62735, "contours": [4]},
    {"name": "sevenninths", "unicode": 62736, "contours": [4]},
    {"name": "eightninths", "unicode": 62737, "contours": [6]},
    {"name": "dong", "unicode": 8363, "contours": [3, 4]},
    {"name": "acute", "unicode": 180, "contours": [1]},
    {"name": "uni00B5", "unicode": 181, "contours": [1]},
    {"name": "uni20AD", "unicode": 8365, "contours": [1]},
    {"name": "uni0E3A", "unicode": 3642, "contours": [1]},
    {"name": "cedilla", "unicode": 184, "contours": [1]},
    {"name": "uni0E47", "unicode": 3655, "contours": [1, 2]},
    {"name": "percent", "unicode": 37, "contours": [5]},
    {"name": "ordmasculine", "unicode": 186, "contours": [2, 3]},
    {"name": "uni0900", "unicode": 2304, "contours": [2]},
    {"name": "uniA901", "unicode": 43265, "contours": [2]},
    {"name": "uniA902", "unicode": 43266, "contours": [1]},
    {"name": "uniA903", "unicode": 43267, "contours": [2]},
    {"name": "uniA904", "unicode": 43268, "contours": [1]},
    {"name": "uniA905", "unicode": 43269, "contours": [1]},
    {"name": "uniA906", "unicode": 43270, "contours": [2]},
    {"name": "uniA907", "unicode": 43271, "contours": [1]},
    {"name": "uniA908", "unicode": 43272, "contours": [1]},
    {"name": "uniA909", "unicode": 43273, "contours": [1]},
    {"name": "uniA90A", "unicode": 43274, "contours": [2]},
    {"name": "uniA90B", "unicode": 43275, "contours": [2]},
    {"name": "uniA90C", "unicode": 43276, "contours": [2]},
    {"name": "uniA90D", "unicode": 43277, "contours": [1]},
    {"name": "uniA90E", "unicode": 43278, "contours": [2]},
    {"name": "uniA90F", "unicode": 43279, "contours": [1]},
    {"name": "uniA910", "unicode": 43280, "contours": [1]},
    {"name": "uniA911", "unicode": 43281, "contours": [1]},
    {"name": "uni0502", "unicode": 1282, "contours": [2]},
    {"name": "uniA912", "unicode": 43282, "contours": [2]},
    {"name": "uniA913", "unicode": 43283, "contours": [1]},
    {"name": "uniA914", "unicode": 43284, "contours": [1]},
    {"name": "uniA915", "unicode": 43285, "contours": [2]},
    {"name": "uniA916", "unicode": 43286, "contours": [1]},
    {"name": "uniA917", "unicode": 43287, "contours": [2]},
    {"name": "uniA918", "unicode": 43288, "contours": [2]},
    {"name": "uniA919", "unicode": 43289, "contours": [2]},
    {"name": "uniA91A", "unicode": 43290, "contours": [1]},
    {"name": "uniA91B", "unicode": 43291, "contours": [1]},
    {"name": "uniA91C", "unicode": 43292, "contours": [1]},
    {"name": "chi", "unicode": 967, "contours": [1]},
    {"name": "uniA91D", "unicode": 43293, "contours": [1]},
    {"name": "uniA91E", "unicode": 43294, "contours": [1]},
    {"name": "uni20B9", "unicode": 8377, "contours": [1]},
    {"name": "uniA91F", "unicode": 43295, "contours": [2]},
    {"name": "uniA920", "unicode": 43296, "contours": [1]},
    {"name": "commaaccent", "unicode": 63171, "contours": [1]},
    {"name": "uniA921", "unicode": 43297, "contours": [1]},
    {"name": "uniA922", "unicode": 43298, "contours": [1]},
    {"name": "uniA923", "unicode": 43299, "contours": [1]},
    {"name": "uniA924", "unicode": 43300, "contours": [2]},
    {"name": "uniA925", "unicode": 43301, "contours": [3]},
    {"name": "ueMark-kayahli", "unicode": 43302, "contours": [1]},
    {"name": "eMark-kayahli", "unicode": 43303, "contours": [1]},
    {"name": "uMark-kayahli", "unicode": 43304, "contours": [1]},
    {"name": "eeMark-kayahli", "unicode": 43305, "contours": [1]},
    {"name": "oMark-kayahli", "unicode": 43306, "contours": [2]},
    {"name": "toneplophu-kayahli", "unicode": 43307, "contours": [1]},
    {"name": "tonecalya-kayahli", "unicode": 43308, "contours": [1]},
    {"name": "tonecalyaplophu-kayahli", "unicode": 43309, "contours": [2]},
    {"name": "cwi-kayahli", "unicode": 43310, "contours": [1]},
    {"name": "shya-kayahli", "unicode": 43311, "contours": [1]},
    {"name": "uni050C", "unicode": 1292, "contours": [1]},
    {"name": "zero.alt", "unicode": 63488, "contours": [2]},
    {"name": "one.alt", "unicode": 63489, "contours": [1]},
    {"name": "two.alt", "unicode": 63490, "contours": [1]},
    {"name": "three.alt", "unicode": 63491, "contours": [1]},
    {"name": "four.alt", "unicode": 63492, "contours": [2]},
    {"name": "five.alt", "unicode": 63493, "contours": [1]},
    {"name": "six.alt", "unicode": 63494, "contours": [2]},
    {"name": "seven.alt", "unicode": 63495, "contours": [1]},
    {"name": "eight.alt", "unicode": 63496, "contours": [3]},
    {"name": "nine.alt", "unicode": 63497, "contours": [2]},
    {"name": "zero.sups", "unicode": 63498, "contours": [2, 3]},
    {"name": "one.sups", "unicode": 63499, "contours": [1]},
    {"name": "two.sups", "unicode": 63500, "contours": [1]},
    {"name": "three.sups", "unicode": 63501, "contours": [1]},
    {"name": "four.sups", "unicode": 63502, "contours": [2]},
    {"name": "five.sups", "unicode": 63503, "contours": [1]},
    {"name": "six.sups", "unicode": 63504, "contours": [2]},
    {"name": "seven.sups", "unicode": 63505, "contours": [1]},
    {"name": "eight.sups", "unicode": 63506, "contours": [3]},
    {"name": "nine.sups", "unicode": 63507, "contours": [2]},
    {"name": "zero.sinf", "unicode": 63508, "contours": [2, 3]},
    {"name": "one.sinf", "unicode": 63509, "contours": [1]},
    {"name": "two.sinf", "unicode": 63510, "contours": [1]},
    {"name": "three.sinf", "unicode": 63511, "contours": [1]},
    {"name": "four.sinf", "unicode": 63512, "contours": [2]},
    {"name": "five.sinf", "unicode": 63513, "contours": [1]},
    {"name": "six.sinf", "unicode": 63514, "contours": [2]},
    {"name": "seven.sinf", "unicode": 63515, "contours": [1]},
    {"name": "eight.sinf", "unicode": 63516, "contours": [3]},
    {"name": "nine.sinf", "unicode": 63517, "contours": [2]},
    {"name": "uni0961", "unicode": 2401, "contours": [1]},
    {"name": "uni2036", "unicode": 8246, "contours": [2]},
    {"name": "uni0967", "unicode": 2407, "contours": [1]},
    {"name": "uni096D", "unicode": 2413, "contours": [1, 2]},
    {"name": "uni0973", "unicode": 2419, "contours": [1]},
    {"name": "uni0979", "unicode": 2425, "contours": [4]},
    {"name": "uni0427", "unicode": 1063, "contours": [1]},
    {"name": "uni097F", "unicode": 2431, "contours": [3]},
    {"name": "SF030000", "unicode": 9488, "contours": [1]},
    {"name": "uni2000", "unicode": 8192, "contours": [0]},
    {"name": "SF080000", "unicode": 9500, "contours": [1]},
    {"name": "uni0469", "unicode": 1129, "contours": [2]},
    {"name": "uni046F", "unicode": 1135, "contours": [2]},
    {"name": "uni047B", "unicode": 1147, "contours": [2]},
    {"name": "f_f", "unicode": 64256, "contours": [1, 2]},
    {"name": "f_i", "unicode": 64257, "contours": [1, 2, 3]},
    {"name": "f_l", "unicode": 64258, "contours": [1, 2]},
    {"name": "f_f_i", "unicode": 64259, "contours": [1, 2, 3, 4]},
    {"name": "f_f_l", "unicode": 64260, "contours": [1, 2, 3]},
    {"name": "s_t", "unicode": 64262, "contours": [1]},
    {"name": "SF090000", "unicode": 9508, "contours": [1]},
    {"name": "a.sups", "unicode": 7491, "contours": [2]},
    {"name": "b.sups", "unicode": 7495, "contours": [2]},
    {"name": "d.sups", "unicode": 7496, "contours": [2]},
    {"name": "e.sups", "unicode": 7497, "contours": [2]},
    {"name": "g.sups", "unicode": 7501, "contours": [3]},
    {"name": "k.sups", "unicode": 7503, "contours": [1]},
    {"name": "m.sups", "unicode": 7504, "contours": [1]},
    {"name": "o.sups", "unicode": 7506, "contours": [2]},
    {"name": "p.sups", "unicode": 7510, "contours": [2]},
    {"name": "t.sups", "unicode": 7511, "contours": [1]},
    {"name": "u.sups", "unicode": 7512, "contours": [1]},
    {"name": "v.sups", "unicode": 7515, "contours": [1]},
    {"name": "c.sups", "unicode": 7580, "contours": [1]},
    {"name": "f.sups", "unicode": 7584, "contours": [1]},
    {"name": "z.sups", "unicode": 7611, "contours": [1]},
    {"name": "uni1E00", "unicode": 7680, "contours": [4]},
    {"name": "uni0500", "unicode": 1280, "contours": [2]},
    {"name": "uni1E02", "unicode": 7682, "contours": [4]},
    {"name": "uni1E03", "unicode": 7683, "contours": [3]},
    {"name": "uni1E08", "unicode": 7688, "contours": [2]},
    {"name": "uni1E09", "unicode": 7689, "contours": [2]},
    {"name": "uni1E0A", "unicode": 7690, "contours": [3]},
    {"name": "uni1E0B", "unicode": 7691, "contours": [3]},
    {"name": "uni1E0C", "unicode": 7692, "contours": [3]},
    {"name": "uni1E0D", "unicode": 7693, "contours": [3]},
    {"name": "uni1E0E", "unicode": 7694, "contours": [3]},
    {"name": "uni1E0F", "unicode": 7695, "contours": [3]},
    {"name": "uni1E14", "unicode": 7700, "contours": [3]},
    {"name": "uni1E15", "unicode": 7701, "contours": [4]},
    {"name": "uni1E16", "unicode": 7702, "contours": [3]},
    {"name": "uni1E17", "unicode": 7703, "contours": [4]},
    {"name": "uni1E1C", "unicode": 7708, "contours": [2]},
    {"name": "uni1E1D", "unicode": 7709, "contours": [3]},
    {"name": "uni1E1E", "unicode": 7710, "contours": [2]},
    {"name": "fdotaccent", "unicode": 7711, "contours": [2]},
    {"name": "uni1E20", "unicode": 7712, "contours": [2]},
    {"name": "uni1E21", "unicode": 7713, "contours": [3, 4]},
    {"name": "uni1E24", "unicode": 7716, "contours": [2]},
    {"name": "uni1E25", "unicode": 7717, "contours": [2]},
    {"name": "uni1E2A", "unicode": 7722, "contours": [2]},
    {"name": "uni1E2B", "unicode": 7723, "contours": [2]},
    {"name": "uni1E2E", "unicode": 7726, "contours": [4]},
    {"name": "uni1E2F", "unicode": 7727, "contours": [4]},
    {"name": "uni1E36", "unicode": 7734, "contours": [2]},
    {"name": "uni1E37", "unicode": 7735, "contours": [2]},
    {"name": "uni1E38", "unicode": 7736, "contours": [3]},
    {"name": "uni1E39", "unicode": 7737, "contours": [3]},
    {"name": "uni1E3A", "unicode": 7738, "contours": [2]},
    {"name": "uni1E3B", "unicode": 7739, "contours": [2]},
    {"name": "uni1E3E", "unicode": 7742, "contours": [2]},
    {"name": "uni1E3F", "unicode": 7743, "contours": [2]},
    {"name": "uni1E40", "unicode": 7744, "contours": [2]},
    {"name": "uni1E41", "unicode": 7745, "contours": [2]},
    {"name": "uni1E42", "unicode": 7746, "contours": [2]},
    {"name": "uni1E43", "unicode": 7747, "contours": [2]},
    {"name": "uni1E44", "unicode": 7748, "contours": [2]},
    {"name": "uni1E45", "unicode": 7749, "contours": [2]},
    {"name": "uni1E46", "unicode": 7750, "contours": [2]},
    {"name": "uni1E47", "unicode": 7751, "contours": [2]},
    {"name": "uni1E48", "unicode": 7752, "contours": [2]},
    {"name": "uni1E49", "unicode": 7753, "contours": [2]},
    {"name": "uni1E4C", "unicode": 7756, "contours": [4]},
    {"name": "uni1E4D", "unicode": 7757, "contours": [4]},
    {"name": "uni1E4E", "unicode": 7758, "contours": [5]},
    {"name": "uni1E4F", "unicode": 7759, "contours": [5]},
    {"name": "uni1E50", "unicode": 7760, "contours": [4]},
    {"name": "uni1E51", "unicode": 7761, "contours": [4]},
    {"name": "uni1E52", "unicode": 7762, "contours": [4]},
    {"name": "uni1E53", "unicode": 7763, "contours": [4]},
    {"name": "uni1E56", "unicode": 7766, "contours": [3]},
    {"name": "uni1E57", "unicode": 7767, "contours": [3]},
    {"name": "uni1E5A", "unicode": 7770, "contours": [3]},
    {"name": "uni1E5B", "unicode": 7771, "contours": [2]},
    {"name": "uni1E5C", "unicode": 7772, "contours": [4]},
    {"name": "uni1E5D", "unicode": 7773, "contours": [3]},
    {"name": "uni1E5E", "unicode": 7774, "contours": [3]},
    {"name": "uni1E5F", "unicode": 7775, "contours": [2]},
    {"name": "uni1E60", "unicode": 7776, "contours": [2]},
    {"name": "uni1E61", "unicode": 7777, "contours": [2]},
    {"name": "uni1E62", "unicode": 7778, "contours": [2]},
    {"name": "uni1E63", "unicode": 7779, "contours": [2]},
    {"name": "uni1E64", "unicode": 7780, "contours": [3]},
    {"name": "uni1E65", "unicode": 7781, "contours": [3]},
    {"name": "uni1E66", "unicode": 7782, "contours": [3]},
    {"name": "uni1E67", "unicode": 7783, "contours": [3]},
    {"name": "uni1E68", "unicode": 7784, "contours": [3]},
    {"name": "uni1E69", "unicode": 7785, "contours": [3]},
    {"name": "uni1E6A", "unicode": 7786, "contours": [2]},
    {"name": "uni1E6B", "unicode": 7787, "contours": [2]},
    {"name": "uni1E6C", "unicode": 7788, "contours": [2]},
    {"name": "uni1E6D", "unicode": 7789, "contours": [2]},
    {"name": "uni1E6E", "unicode": 7790, "contours": [2]},
    {"name": "uni1E6F", "unicode": 7791, "contours": [2]},
    {"name": "uni1E78", "unicode": 7800, "contours": [3]},
    {"name": "uni1E79", "unicode": 7801, "contours": [3]},
    {"name": "uni1E7A", "unicode": 7802, "contours": [4]},
    {"name": "uni1E7B", "unicode": 7803, "contours": [4]},
    {"name": "Wgrave", "unicode": 7808, "contours": [2]},
    {"name": "wgrave", "unicode": 7809, "contours": [2]},
    {"name": "Wacute", "unicode": 7810, "contours": [2]},
    {"name": "wacute", "unicode": 7811, "contours": [2]},
    {"name": "Wdieresis", "unicode": 7812, "contours": [3]},
    {"name": "wdieresis", "unicode": 7813, "contours": [3]},
    {"name": "uni1E8E", "unicode": 7822, "contours": [2]},
    {"name": "uni1E8F", "unicode": 7823, "contours": [2]},
    {"name": "uni1E92", "unicode": 7826, "contours": [2]},
    {"name": "uni1E93", "unicode": 7827, "contours": [2]},
    {"name": "uni1E97", "unicode": 7831, "contours": [3]},
    {"name": "uni1E9E", "unicode": 7838, "contours": [1]},
    {"name": "uni1EA0", "unicode": 7840, "contours": [3]},
    {"name": "uni1EA1", "unicode": 7841, "contours": [3]},
    {"name": "uni1EA2", "unicode": 7842, "contours": [3]},
    {"name": "uni1EA3", "unicode": 7843, "contours": [3]},
    {"name": "uni1EA4", "unicode": 7844, "contours": [4]},
    {"name": "uni1EA5", "unicode": 7845, "contours": [4]},
    {"name": "uni1EA6", "unicode": 7846, "contours": [4]},
    {"name": "uni1EA7", "unicode": 7847, "contours": [4]},
    {"name": "uni1EA8", "unicode": 7848, "contours": [4]},
    {"name": "uni1EA9", "unicode": 7849, "contours": [4]},
    {"name": "uni1EAA", "unicode": 7850, "contours": [4]},
    {"name": "uni1EAB", "unicode": 7851, "contours": [4]},
    {"name": "uni1EAC", "unicode": 7852, "contours": [4]},
    {"name": "uni1EAD", "unicode": 7853, "contours": [4]},
    {"name": "uni1EAE", "unicode": 7854, "contours": [4]},
    {"name": "uni1EAF", "unicode": 7855, "contours": [4]},
    {"name": "uni1EB0", "unicode": 7856, "contours": [4]},
    {"name": "uni1EB1", "unicode": 7857, "contours": [4]},
    {"name": "uni1EB2", "unicode": 7858, "contours": [4]},
    {"name": "uni1EB3", "unicode": 7859, "contours": [4]},
    {"name": "uni1EB4", "unicode": 7860, "contours": [4]},
    {"name": "uni1EB5", "unicode": 7861, "contours": [4]},
    {"name": "uni1EB6", "unicode": 7862, "contours": [4]},
    {"name": "uni1EB7", "unicode": 7863, "contours": [4]},
    {"name": "uni1EB8", "unicode": 7864, "contours": [2]},
    {"name": "uni1EB9", "unicode": 7865, "contours": [3]},
    {"name": "uni1EBA", "unicode": 7866, "contours": [2]},
    {"name": "uni1EBB", "unicode": 7867, "contours": [3]},
    {"name": "uni1EBC", "unicode": 7868, "contours": [2]},
    {"name": "uni1EBD", "unicode": 7869, "contours": [3]},
    {"name": "uni1EBE", "unicode": 7870, "contours": [3]},
    {"name": "uni1EBF", "unicode": 7871, "contours": [4]},
    {"name": "uni1EC0", "unicode": 7872, "contours": [3]},
    {"name": "uni1EC1", "unicode": 7873, "contours": [4]},
    {"name": "uni1EC2", "unicode": 7874, "contours": [3]},
    {"name": "uni1EC3", "unicode": 7875, "contours": [4]},
    {"name": "uni1EC4", "unicode": 7876, "contours": [3]},
    {"name": "uni1EC5", "unicode": 7877, "contours": [4]},
    {"name": "uni1EC6", "unicode": 7878, "contours": [3]},
    {"name": "uni1EC7", "unicode": 7879, "contours": [4]},
    {"name": "uni1EC8", "unicode": 7880, "contours": [2]},
    {"name": "uni1EC9", "unicode": 7881, "contours": [2]},
    {"name": "uni1ECA", "unicode": 7882, "contours": [2]},
    {"name": "uni1ECB", "unicode": 7883, "contours": [3]},
    {"name": "uni1ECC", "unicode": 7884, "contours": [3]},
    {"name": "uni1ECD", "unicode": 7885, "contours": [3]},
    {"name": "uni1ECE", "unicode": 7886, "contours": [3]},
    {"name": "uni1ECF", "unicode": 7887, "contours": [3]},
    {"name": "uni1ED0", "unicode": 7888, "contours": [4]},
    {"name": "uni1ED1", "unicode": 7889, "contours": [4]},
    {"name": "uni1ED2", "unicode": 7890, "contours": [4]},
    {"name": "uni1ED3", "unicode": 7891, "contours": [4]},
    {"name": "uni1ED4", "unicode": 7892, "contours": [4]},
    {"name": "uni1ED5", "unicode": 7893, "contours": [4]},
    {"name": "uni1ED6", "unicode": 7894, "contours": [4]},
    {"name": "uni1ED7", "unicode": 7895, "contours": [4]},
    {"name": "uni1ED8", "unicode": 7896, "contours": [4]},
    {"name": "uni1ED9", "unicode": 7897, "contours": [4]},
    {"name": "uni1EDA", "unicode": 7898, "contours": [3, 4]},
    {"name": "uni1EDB", "unicode": 7899, "contours": [3]},
    {"name": "uni1EDC", "unicode": 7900, "contours": [3, 4]},
    {"name": "uni1EDD", "unicode": 7901, "contours": [3]},
    {"name": "uni1EDE", "unicode": 7902, "contours": [3, 4]},
    {"name": "uni1EDF", "unicode": 7903, "contours": [3]},
    {"name": "uni1EE0", "unicode": 7904, "contours": [3, 4]},
    {"name": "uni1EE1", "unicode": 7905, "contours": [3]},
    {"name": "uni1EE2", "unicode": 7906, "contours": [3, 4]},
    {"name": "uni1EE3", "unicode": 7907, "contours": [3]},
    {"name": "uni1EE4", "unicode": 7908, "contours": [2]},
    {"name": "uni1EE5", "unicode": 7909, "contours": [2]},
    {"name": "uni1EE6", "unicode": 7910, "contours": [2]},
    {"name": "uni1EE7", "unicode": 7911, "contours": [2]},
    {"name": "uni1EE8", "unicode": 7912, "contours": [2]},
    {"name": "uni1EE9", "unicode": 7913, "contours": [2]},
    {"name": "uni1EEA", "unicode": 7914, "contours": [2]},
    {"name": "uni1EEB", "unicode": 7915, "contours": [2]},
    {"name": "uni1EEC", "unicode": 7916, "contours": [2]},
    {"name": "uni1EED", "unicode": 7917, "contours": [2]},
    {"name": "uni1EEE", "unicode": 7918, "contours": [2]},
    {"name": "uni1EEF", "unicode": 7919, "contours": [2]},
    {"name": "uni1EF0", "unicode": 7920, "contours": [2]},
    {"name": "uni1EF1", "unicode": 7921, "contours": [2]},
    {"name": "Ygrave", "unicode": 7922, "contours": [2]},
    {"name": "ygrave", "unicode": 7923, "contours": [2]},
    {"name": "uni1EF4", "unicode": 7924, "contours": [2]},
    {"name": "uni1EF5", "unicode": 7925, "contours": [2]},
    {"name": "uni1EF6", "unicode": 7926, "contours": [2]},
    {"name": "uni1EF7", "unicode": 7927, "contours": [2]},
    {"name": "uni1EF8", "unicode": 7928, "contours": [2]},
    {"name": "uni1EF9", "unicode": 7929, "contours": [2]},
    {"name": "uniFEFF", "unicode": 65279, "contours": [0]},
    {"name": "uni1F00", "unicode": 7936, "contours": [3]},
    {"name": "uni1F01", "unicode": 7937, "contours": [3]},
    {"name": "uni1F02", "unicode": 7938, "contours": [4]},
    {"name": "uni1F03", "unicode": 7939, "contours": [4]},
    {"name": "uni1F04", "unicode": 7940, "contours": [4]},
    {"name": "uni1F05", "unicode": 7941, "contours": [4]},
    {"name": "uni1F06", "unicode": 7942, "contours": [4]},
    {"name": "uni1F07", "unicode": 7943, "contours": [4]},
    {"name": "uni1F08", "unicode": 7944, "contours": [3]},
    {"name": "uni1F09", "unicode": 7945, "contours": [3]},
    {"name": "uni1F0A", "unicode": 7946, "contours": [4]},
    {"name": "uni1F0B", "unicode": 7947, "contours": [4]},
    {"name": "uni1F0C", "unicode": 7948, "contours": [4]},
    {"name": "uni1F0D", "unicode": 7949, "contours": [4]},
    {"name": "uni1F0E", "unicode": 7950, "contours": [4]},
    {"name": "uni1F0F", "unicode": 7951, "contours": [4]},
    {"name": "uni1F10", "unicode": 7952, "contours": [2]},
    {"name": "uni1F11", "unicode": 7953, "contours": [2]},
    {"name": "uni1F12", "unicode": 7954, "contours": [3]},
    {"name": "uni1F13", "unicode": 7955, "contours": [3]},
    {"name": "uni1F14", "unicode": 7956, "contours": [3]},
    {"name": "uni1F15", "unicode": 7957, "contours": [3]},
    {"name": "uni1F18", "unicode": 7960, "contours": [2]},
    {"name": "uni1F19", "unicode": 7961, "contours": [2]},
    {"name": "uni1F1A", "unicode": 7962, "contours": [3]},
    {"name": "uni1F1B", "unicode": 7963, "contours": [3]},
    {"name": "uni1F1C", "unicode": 7964, "contours": [3]},
    {"name": "uni1F1D", "unicode": 7965, "contours": [3]},
    {"name": "uni1F20", "unicode": 7968, "contours": [2]},
    {"name": "uni1F21", "unicode": 7969, "contours": [2]},
    {"name": "uni1F22", "unicode": 7970, "contours": [3]},
    {"name": "uni1F23", "unicode": 7971, "contours": [3]},
    {"name": "uni1F24", "unicode": 7972, "contours": [3]},
    {"name": "uni1F25", "unicode": 7973, "contours": [3]},
    {"name": "uni1F26", "unicode": 7974, "contours": [3]},
    {"name": "uni1F27", "unicode": 7975, "contours": [3]},
    {"name": "uni1F28", "unicode": 7976, "contours": [2]},
    {"name": "uni1F29", "unicode": 7977, "contours": [2]},
    {"name": "uni1F2A", "unicode": 7978, "contours": [3]},
    {"name": "uni1F2B", "unicode": 7979, "contours": [3]},
    {"name": "uni1F2C", "unicode": 7980, "contours": [3]},
    {"name": "uni1F2D", "unicode": 7981, "contours": [3]},
    {"name": "uni1F2E", "unicode": 7982, "contours": [3]},
    {"name": "uni1F2F", "unicode": 7983, "contours": [3]},
    {"name": "uni1F30", "unicode": 7984, "contours": [2]},
    {"name": "uni1F31", "unicode": 7985, "contours": [2]},
    {"name": "uni1F32", "unicode": 7986, "contours": [3]},
    {"name": "uni1F33", "unicode": 7987, "contours": [3]},
    {"name": "uni1F34", "unicode": 7988, "contours": [3]},
    {"name": "uni1F35", "unicode": 7989, "contours": [3]},
    {"name": "uni1F36", "unicode": 7990, "contours": [3]},
    {"name": "uni1F37", "unicode": 7991, "contours": [3]},
    {"name": "uni1F38", "unicode": 7992, "contours": [2]},
    {"name": "uni1F39", "unicode": 7993, "contours": [2]},
    {"name": "uni1F3A", "unicode": 7994, "contours": [3]},
    {"name": "uni1F3B", "unicode": 7995, "contours": [3]},
    {"name": "uni1F3C", "unicode": 7996, "contours": [3]},
    {"name": "uni1F3D", "unicode": 7997, "contours": [3]},
    {"name": "uni1F3E", "unicode": 7998, "contours": [3]},
    {"name": "uni1F3F", "unicode": 7999, "contours": [3]},
    {"name": "uni1F40", "unicode": 8000, "contours": [3]},
    {"name": "uni1F41", "unicode": 8001, "contours": [3]},
    {"name": "uni1F42", "unicode": 8002, "contours": [4]},
    {"name": "uni1F43", "unicode": 8003, "contours": [4]},
    {"name": "uni1F44", "unicode": 8004, "contours": [4]},
    {"name": "uni1F45", "unicode": 8005, "contours": [4]},
    {"name": "uni1F48", "unicode": 8008, "contours": [3]},
    {"name": "uni1F49", "unicode": 8009, "contours": [3]},
    {"name": "uni1F4A", "unicode": 8010, "contours": [4]},
    {"name": "uni1F4B", "unicode": 8011, "contours": [4]},
    {"name": "uni1F4C", "unicode": 8012, "contours": [4]},
    {"name": "uni1F4D", "unicode": 8013, "contours": [4]},
    {"name": "uni1F50", "unicode": 8016, "contours": [2]},
    {"name": "uni1F51", "unicode": 8017, "contours": [2]},
    {"name": "uni1F52", "unicode": 8018, "contours": [3]},
    {"name": "uni1F53", "unicode": 8019, "contours": [3]},
    {"name": "uni1F54", "unicode": 8020, "contours": [3]},
    {"name": "uni1F55", "unicode": 8021, "contours": [3]},
    {"name": "uni1F56", "unicode": 8022, "contours": [3]},
    {"name": "uni1F57", "unicode": 8023, "contours": [3]},
    {"name": "uni1F59", "unicode": 8025, "contours": [2]},
    {"name": "uni1F5B", "unicode": 8027, "contours": [3]},
    {"name": "uni1F5D", "unicode": 8029, "contours": [3]},
    {"name": "uni1F5F", "unicode": 8031, "contours": [3]},
    {"name": "uni1F60", "unicode": 8032, "contours": [2]},
    {"name": "uni1F61", "unicode": 8033, "contours": [2]},
    {"name": "uni1F62", "unicode": 8034, "contours": [3]},
    {"name": "uni1F63", "unicode": 8035, "contours": [3]},
    {"name": "uni1F64", "unicode": 8036, "contours": [3]},
    {"name": "uni1F65", "unicode": 8037, "contours": [3]},
    {"name": "uni1F66", "unicode": 8038, "contours": [3]},
    {"name": "uni1F67", "unicode": 8039, "contours": [3]},
    {"name": "uni1F68", "unicode": 8040, "contours": [2]},
    {"name": "uni1F69", "unicode": 8041, "contours": [2]},
    {"name": "uni1F6A", "unicode": 8042, "contours": [3]},
    {"name": "uni1F6B", "unicode": 8043, "contours": [3]},
    {"name": "uni1F6C", "unicode": 8044, "contours": [3]},
    {"name": "uni1F6D", "unicode": 8045, "contours": [3]},
    {"name": "uni1F6E", "unicode": 8046, "contours": [3]},
    {"name": "uni1F6F", "unicode": 8047, "contours": [3]},
    {"name": "uni1F70", "unicode": 8048, "contours": [3]},
    {"name": "uni1F71", "unicode": 8049, "contours": [3]},
    {"name": "uni1F72", "unicode": 8050, "contours": [2]},
    {"name": "uni1F73", "unicode": 8051, "contours": [2]},
    {"name": "uni1F74", "unicode": 8052, "contours": [2]},
    {"name": "uni1F75", "unicode": 8053, "contours": [2]},
    {"name": "uni1F76", "unicode": 8054, "contours": [2]},
    {"name": "uni1F77", "unicode": 8055, "contours": [2]},
    {"name": "uni1F78", "unicode": 8056, "contours": [3]},
    {"name": "uni1F79", "unicode": 8057, "contours": [3]},
    {"name": "uni1F7A", "unicode": 8058, "contours": [2]},
    {"name": "uni1F7B", "unicode": 8059, "contours": [2]},
    {"name": "uni1F7C", "unicode": 8060, "contours": [2]},
    {"name": "uni1F7D", "unicode": 8061, "contours": [2]},
    {"name": "uni1F80", "unicode": 8064, "contours": [4]},
    {"name": "uni1F81", "unicode": 8065, "contours": [4]},
    {"name": "uni1F82", "unicode": 8066, "contours": [5]},
    {"name": "uni1F83", "unicode": 8067, "contours": [5]},
    {"name": "uni1F84", "unicode": 8068, "contours": [5]},
    {"name": "uni1F85", "unicode": 8069, "contours": [5]},
    {"name": "uni1F86", "unicode": 8070, "contours": [5]},
    {"name": "uni1F87", "unicode": 8071, "contours": [5]},
    {"name": "uni1F88", "unicode": 8072, "contours": [4]},
    {"name": "uni1F89", "unicode": 8073, "contours": [4]},
    {"name": "uni1F8A", "unicode": 8074, "contours": [5]},
    {"name": "uni1F8B", "unicode": 8075, "contours": [5]},
    {"name": "uni1F8C", "unicode": 8076, "contours": [5]},
    {"name": "uni1F8D", "unicode": 8077, "contours": [5]},
    {"name": "uni1F8E", "unicode": 8078, "contours": [5]},
    {"name": "uni1F8F", "unicode": 8079, "contours": [5]},
    {"name": "uni1F90", "unicode": 8080, "contours": [3]},
    {"name": "uni1F91", "unicode": 8081, "contours": [3]},
    {"name": "uni1F92", "unicode": 8082, "contours": [4]},
    {"name": "uni1F93", "unicode": 8083, "contours": [4]},
    {"name": "uni1F94", "unicode": 8084, "contours": [4]},
    {"name": "uni1F95", "unicode": 8085, "contours": [4]},
    {"name": "uni1F96", "unicode": 8086, "contours": [4]},
    {"name": "uni1F97", "unicode": 8087, "contours": [4]},
    {"name": "uni1F98", "unicode": 8088, "contours": [3]},
    {"name": "uni1F99", "unicode": 8089, "contours": [3]},
    {"name": "uni1F9A", "unicode": 8090, "contours": [4]},
    {"name": "uni1F9B", "unicode": 8091, "contours": [4]},
    {"name": "uni1F9C", "unicode": 8092, "contours": [4]},
    {"name": "uni1F9D", "unicode": 8093, "contours": [4]},
    {"name": "uni1F9E", "unicode": 8094, "contours": [4]},
    {"name": "uni1F9F", "unicode": 8095, "contours": [4]},
    {"name": "uni1FA0", "unicode": 8096, "contours": [3]},
    {"name": "uni1FA1", "unicode": 8097, "contours": [3]},
    {"name": "uni1FA2", "unicode": 8098, "contours": [4]},
    {"name": "uni1FA3", "unicode": 8099, "contours": [4]},
    {"name": "uni1FA4", "unicode": 8100, "contours": [4]},
    {"name": "uni1FA5", "unicode": 8101, "contours": [4]},
    {"name": "uni1FA6", "unicode": 8102, "contours": [4]},
    {"name": "uni1FA7", "unicode": 8103, "contours": [4]},
    {"name": "uni1FA8", "unicode": 8104, "contours": [3]},
    {"name": "uni1FA9", "unicode": 8105, "contours": [3]},
    {"name": "uni1FAA", "unicode": 8106, "contours": [4]},
    {"name": "uni1FAB", "unicode": 8107, "contours": [4]},
    {"name": "uni1FAC", "unicode": 8108, "contours": [4]},
    {"name": "uni1FAD", "unicode": 8109, "contours": [4]},
    {"name": "uni1FAE", "unicode": 8110, "contours": [4]},
    {"name": "uni1FAF", "unicode": 8111, "contours": [4]},
    {"name": "uni1FB0", "unicode": 8112, "contours": [3]},
    {"name": "uni1FB1", "unicode": 8113, "contours": [3]},
    {"name": "uni1FB2", "unicode": 8114, "contours": [4]},
    {"name": "uni1FB3", "unicode": 8115, "contours": [3]},
    {"name": "uni1FB4", "unicode": 8116, "contours": [4]},
    {"name": "uni1FB6", "unicode": 8118, "contours": [3]},
    {"name": "uni1FB7", "unicode": 8119, "contours": [4]},
    {"name": "uni1FB8", "unicode": 8120, "contours": [3]},
    {"name": "uni1FB9", "unicode": 8121, "contours": [3]},
    {"name": "uni1FBA", "unicode": 8122, "contours": [3]},
    {"name": "uni1FBB", "unicode": 8123, "contours": [3]},
    {"name": "uni1FBC", "unicode": 8124, "contours": [3]},
    {"name": "uni1FBD", "unicode": 8125, "contours": [1]},
    {"name": "uni1FBE", "unicode": 8126, "contours": [1]},
    {"name": "uni1FBF", "unicode": 8127, "contours": [1]},
    {"name": "uni1FC0", "unicode": 8128, "contours": [1]},
    {"name": "uni1FC1", "unicode": 8129, "contours": [3]},
    {"name": "uni1FC2", "unicode": 8130, "contours": [3]},
    {"name": "uni1FC3", "unicode": 8131, "contours": [2]},
    {"name": "uni1FC4", "unicode": 8132, "contours": [3]},
    {"name": "uni1FC6", "unicode": 8134, "contours": [2]},
    {"name": "uni1FC7", "unicode": 8135, "contours": [3]},
    {"name": "uni1FC8", "unicode": 8136, "contours": [2]},
    {"name": "uni1FC9", "unicode": 8137, "contours": [2]},
    {"name": "uni1FCA", "unicode": 8138, "contours": [2]},
    {"name": "uni1FCB", "unicode": 8139, "contours": [2]},
    {"name": "uni1FCC", "unicode": 8140, "contours": [2]},
    {"name": "uni1FCD", "unicode": 8141, "contours": [2]},
    {"name": "uni1FCE", "unicode": 8142, "contours": [2]},
    {"name": "uni1FCF", "unicode": 8143, "contours": [2]},
    {"name": "uni1FD0", "unicode": 8144, "contours": [2]},
    {"name": "uni1FD1", "unicode": 8145, "contours": [2]},
    {"name": "uni1FD2", "unicode": 8146, "contours": [4]},
    {"name": "uni1FD3", "unicode": 8147, "contours": [4]},
    {"name": "uni1FD6", "unicode": 8150, "contours": [2]},
    {"name": "uni1FD7", "unicode": 8151, "contours": [4]},
    {"name": "uni1FD8", "unicode": 8152, "contours": [2]},
    {"name": "uni1FD9", "unicode": 8153, "contours": [2]},
    {"name": "uni1FDA", "unicode": 8154, "contours": [2]},
    {"name": "uni1FDB", "unicode": 8155, "contours": [2]},
    {"name": "uni1FDD", "unicode": 8157, "contours": [2]},
    {"name": "uni1FDE", "unicode": 8158, "contours": [2]},
    {"name": "uni1FDF", "unicode": 8159, "contours": [2]},
    {"name": "uni1FE0", "unicode": 8160, "contours": [2]},
    {"name": "uni1FE1", "unicode": 8161, "contours": [2]},
    {"name": "uni1FE2", "unicode": 8162, "contours": [4]},
    {"name": "uni1FE3", "unicode": 8163, "contours": [4]},
    {"name": "uni1FE4", "unicode": 8164, "contours": [3]},
    {"name": "uni1FE5", "unicode": 8165, "contours": [3]},
    {"name": "uni1FE6", "unicode": 8166, "contours": [2]},
    {"name": "uni1FE7", "unicode": 8167, "contours": [4]},
    {"name": "uni1FE8", "unicode": 8168, "contours": [2]},
    {"name": "uni1FE9", "unicode": 8169, "contours": [2]},
    {"name": "uni1FEA", "unicode": 8170, "contours": [2]},
    {"name": "uni1FEB", "unicode": 8171, "contours": [2]},
    {"name": "uni1FEC", "unicode": 8172, "contours": [3]},
    {"name": "uni1FED", "unicode": 8173, "contours": [3]},
    {"name": "uni1FEE", "unicode": 8174, "contours": [3]},
    {"name": "uni1FEF", "unicode": 8175, "contours": [1]},
    {"name": "uni1FF2", "unicode": 8178, "contours": [3]},
    {"name": "uni1FF3", "unicode": 8179, "contours": [2]},
    {"name": "uni1FF4", "unicode": 8180, "contours": [3]},
    {"name": "uni1FF6", "unicode": 8182, "contours": [2]},
    {"name": "uni1FF7", "unicode": 8183, "contours": [3]},
    {"name": "uni1FF8", "unicode": 8184, "contours": [3]},
    {"name": "uni1FF9", "unicode": 8185, "contours": [3]},
    {"name": "uni1FFA", "unicode": 8186, "contours": [2]},
    {"name": "uni1FFB", "unicode": 8187, "contours": [2]},
    {"name": "uni1FFC", "unicode": 8188, "contours": [2]},
    {"name": "uni1FFD", "unicode": 8189, "contours": [1]},
    {"name": "uni1FFE", "unicode": 8190, "contours": [1]},
]
