// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.

/**
 * An object-oriented command-line parser for TypeScript projects.
 *
 * @packageDocumentation
 */

export { CommandLineAction, type ICommandLineActionOptions } from './providers/CommandLineAction';
export { DynamicCommandLineAction } from './providers/DynamicCommandLineAction';
export { ScopedCommandLineAction } from './providers/ScopedCommandLineAction';
export {
  AliasCommandLineAction,
  type IAliasCommandLineActionOptions
} from './providers/AliasCommandLineAction';

export type {
  IBaseCommandLineDefinition,
  IBaseCommandLineDefinitionWithArgument,
  ICommandLineFlagDefinition,
  ICommandLineStringDefinition,
  ICommandLineStringListDefinition,
  ICommandLineIntegerDefinition,
  ICommandLineIntegerListDefinition,
  ICommandLineChoiceDefinition,
  ICommandLineChoiceListDefinition,
  ICommandLineRemainderDefinition
} from './parameters/CommandLineDefinition';

export {
  CommandLineParameterKind,
  // TODO: Export both `CommandLineParameter` and `CommandLineParameterBase` in the next major bump
  CommandLineParameterBase as CommandLineParameter,
  CommandLineParameterWithArgument
} from './parameters/BaseClasses';

export { CommandLineFlagParameter } from './parameters/CommandLineFlagParameter';
export {
  CommandLineStringParameter,
  type IRequiredCommandLineStringParameter
} from './parameters/CommandLineStringParameter';
export { CommandLineStringListParameter } from './parameters/CommandLineStringListParameter';
export {
  CommandLineIntegerParameter,
  type IRequiredCommandLineIntegerParameter
} from './parameters/CommandLineIntegerParameter';
export { CommandLineIntegerListParameter } from './parameters/CommandLineIntegerListParameter';
export {
  CommandLineChoiceParameter,
  type IRequiredCommandLineChoiceParameter
} from './parameters/CommandLineChoiceParameter';
export { CommandLineChoiceListParameter } from './parameters/CommandLineChoiceListParameter';
export { CommandLineRemainder } from './parameters/CommandLineRemainder';

export {
  CommandLineParameterProvider,
  type IScopedLongNameParseResult,
  type ICommandLineParserData as _ICommandLineParserData,
  type IRegisterDefinedParametersState as _IRegisterDefinedParametersState
} from './providers/CommandLineParameterProvider';

export { CommandLineParser, type ICommandLineParserOptions } from './providers/CommandLineParser';
export { DynamicCommandLineParser } from './providers/DynamicCommandLineParser';

export { CommandLineConstants } from './Constants';

export { CommandLineHelper } from './CommandLineHelper';
