## @rushstack/stream-collator

This library enables a tool to display live console output from multiple concurrent processes,
while ensuring that their output does not get jumbled together.

## How does it work?

The **stream-collator** manages the output of these streams, ensuring that no two streams are writing to the console
at the same time. At any given time, one stream registered with the collator is the **active stream**, which means
that particular stream will be live streaming, while the others will wait for that stream to finish before their
output is displayed.

For example, if you have 3 streams (e.g. from using `child_process.spawn()`).

Stream A will write: `AAAAA`

Stream B will write: `BBBBBBBBBBBBBBBBBBBB`

Stream C will write: `CCCCCCCCCC`

If these streams are all being piped directly to stdout (without `@rushstack/stream-collator`), you could end up
with jumbled output:

`ABACCCBCCCCBBABBCBBABBBBBBCCAB`

Something like the following would be much more useful to users of your application:

`AAAAABBBBBBBBBBBBBBBCCCCCCCCCC`

This is where the `@rushstack/stream-collator` comes in!

## The active stream

At any given time, a single stream is designated as the **active stream**. The output of the active stream will always be
live-streamed. This is particularly useful for long-running streams. When the active stream finishes, a new stream
is selected as the active stream and all of its contents up to that point will be emitted. Whenever an active stream finishes,
all background streams which have been completed will be emitted.

## Usage

> 🚨 _This is an early preview release. Please report issues!_ 🚨
>
> WITH VERSION 4.X, THIS PACKAGE HAS BEEN REDESIGNED TO USE THE NEW
> [@rushstack/terminal](https://www.npmjs.com/package/@rushstack/terminal) SYSTEM.
> IN THE NEXT RELEASE, THE `CollatedTerminal` API WILL BE REPLACED WITH
> THE `Terminal` API.
>
> The usage instructions will be updated once that refactoring is complete.

## Links

- [CHANGELOG.md](
  https://github.com/microsoft/rushstack/blob/main/libraries/stream-collator/CHANGELOG.md) - Find
  out what's new in the latest version
- [API Reference](https://api.rushstack.io/pages/stream-collator/)

`@rushstack/stream-collator` is part of the [Rush Stack](https://rushstack.io/) family of projects.
