## API Report File for "@rushstack/webpack5-module-minifier-plugin"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import type { AsyncSeriesWaterfallHook } from 'tapable';
import type { Chunk } from 'webpack';
import type { Comment } from 'estree';
import type { Compilation } from 'webpack';
import type { Compiler } from 'webpack';
import type { IModuleMinifier } from '@rushstack/module-minifier';
import type { Module } from 'webpack';
import type { sources } from 'webpack';
import type { SyncWaterfallHook } from 'tapable';
import type { WebpackPluginInstance } from 'webpack';

// @public
export const CHUNK_MODULE_REGEX: RegExp;

// @public
export const CHUNK_MODULE_TOKEN: '__WEBPACK_CHUNK_MODULE__';

// @public
export function generateLicenseFileForAsset(compilation: Compilation, asset: IAssetInfo): string;

// @public
export interface IAssetInfo {
    chunk: Chunk;
    fileName: string;
    renderInfo: Map<string | number, IRenderedModulePosition>;
    source: sources.Source;
    type: string;
}

// @public
export type IAssetMap = Map<string, IAssetInfo>;

// @public
export interface IAssetStats {
    // (undocumented)
    positionByModuleId: Map<string | number, IRenderedModulePosition>;
}

// @public
export interface IDehydratedAssets {
    assets: IAssetMap;
    modules: IModuleMap;
}

// @public
export interface IFactoryMeta {
    // (undocumented)
    comments?: Comment[];
    // (undocumented)
    skipMinification?: boolean;
}

// @public
export interface IModuleInfo {
    id: string | number;
    module: Module;
    source: sources.Source;
}

// @public
export type IModuleMap = Map<string | number, IModuleInfo>;

// @public
export interface IModuleMinifierPluginHooks {
    postProcessCodeFragment: SyncWaterfallHook<[sources.ReplaceSource, IPostProcessFragmentContext]>;
    rehydrateAssets: AsyncSeriesWaterfallHook<[IDehydratedAssets, Compilation]>;
}

// @public
export interface IModuleMinifierPluginOptions {
    minifier: IModuleMinifier;
    sourceMap?: boolean;
}

// @public
export interface IModuleMinifierPluginStats {
    // (undocumented)
    metadataByAssetFileName: Map<string, IAssetStats>;
    // (undocumented)
    metadataByModule: WeakMap<Module, IModuleStats>;
}

// @public
export interface IModuleStats {
    // (undocumented)
    hashByChunk: Map<Chunk, string>;
    // (undocumented)
    sizeByHash: Map<string, number>;
}

// @public
export interface IPostProcessFragmentContext {
    compilation: Compilation;
    loggingName: string;
    module: Module | undefined;
}

// @public
export interface IRenderedModulePosition {
    charLength: number;
    charOffset: number;
}

// @public
export const MODULE_WRAPPER_PREFIX: '__MINIFY_MODULE__(';

// @public
export const MODULE_WRAPPER_SUFFIX: ');';

// @public
export class ModuleMinifierPlugin implements WebpackPluginInstance {
    constructor(options: IModuleMinifierPluginOptions);
    // (undocumented)
    apply(compiler: Compiler): void;
    // (undocumented)
    static getCompilationStatistics(compilation: Compilation): IModuleMinifierPluginStats | undefined;
    // (undocumented)
    readonly hooks: IModuleMinifierPluginHooks;
    // (undocumented)
    minifier: IModuleMinifier;
}

// @public
export const STAGE_AFTER: 100;

// @public
export const STAGE_BEFORE: -10000;

// (No @packageDocumentation comment for this package)

```
