## API Report File for "@rushstack/webpack4-module-minifier-plugin"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import type { AsyncSeriesWaterfallHook } from 'tapable';
import type { Compiler } from 'webpack';
import { getIdentifier } from '@rushstack/module-minifier';
import { ILocalMinifierOptions } from '@rushstack/module-minifier';
import { IMinifierConnection } from '@rushstack/module-minifier';
import { IModuleMinificationCallback } from '@rushstack/module-minifier';
import { IModuleMinificationErrorResult } from '@rushstack/module-minifier';
import { IModuleMinificationRequest } from '@rushstack/module-minifier';
import { IModuleMinificationResult } from '@rushstack/module-minifier';
import { IModuleMinificationSuccessResult } from '@rushstack/module-minifier';
import { IModuleMinifier } from '@rushstack/module-minifier';
import { IModuleMinifierFunction } from '@rushstack/module-minifier';
import { IWorkerPoolMinifierOptions } from '@rushstack/module-minifier';
import { LocalMinifier } from '@rushstack/module-minifier';
import { MessagePortMinifier } from '@rushstack/module-minifier';
import { NoopMinifier } from '@rushstack/module-minifier';
import type { Plugin } from 'webpack';
import type { ReplaceSource } from 'webpack-sources';
import { Source } from 'webpack-sources';
import type { SyncWaterfallHook } from 'tapable';
import * as webpack from 'webpack';
import { WorkerPoolMinifier } from '@rushstack/module-minifier';

// @public
export const CHUNK_MODULES_TOKEN: '__WEBPACK_CHUNK_MODULES__';

// @public
export function generateLicenseFileForAsset(compilation: webpack.compilation.Compilation, asset: IAssetInfo, minifiedModules: IModuleMap): string;

export { getIdentifier }

// @internal
export interface _IAcornComment {
    // (undocumented)
    end: number;
    // (undocumented)
    start: number;
    // (undocumented)
    type: 'Line' | 'Block';
    // (undocumented)
    value: string;
}

// @public
export interface IAssetInfo {
    chunk: webpack.compilation.Chunk;
    externalNames: Map<string, string>;
    fileName: string;
    modules: (string | number)[];
    renderInfo: Map<string | number, IRenderedModulePosition>;
    source: Source;
}

// @public
export type IAssetMap = Map<string, IAssetInfo>;

// @public
export interface IAssetStats {
    // (undocumented)
    positionByModuleId: Map<string | number, IRenderedModulePosition>;
}

// @public
export interface IDehydratedAssets {
    assets: IAssetMap;
    modules: IModuleMap;
}

// @public
export interface IExtendedModule extends webpack.compilation.Module {
    external?: boolean;
    hasDependencies(callback: (dep: webpack.compilation.Dependency) => boolean | void): boolean;
    id: string | number | null;
    identifier(): string;
    modules?: IExtendedModule[];
    readableIdentifier(requestShortener: unknown): string;
    resource?: string;
}

export { ILocalMinifierOptions }

export { IMinifierConnection }

// @public
export interface IModuleInfo {
    module: IExtendedModule;
    source: Source;
}

// @public
export type IModuleMap = Map<string | number, IModuleInfo>;

export { IModuleMinificationCallback }

export { IModuleMinificationErrorResult }

export { IModuleMinificationRequest }

export { IModuleMinificationResult }

export { IModuleMinificationSuccessResult }

export { IModuleMinifier }

export { IModuleMinifierFunction }

// @public
export interface IModuleMinifierPluginHooks {
    finalModuleId: SyncWaterfallHook<string | number | undefined, webpack.compilation.Compilation>;
    postProcessCodeFragment: SyncWaterfallHook<ReplaceSource, IPostProcessFragmentContext>;
    rehydrateAssets: AsyncSeriesWaterfallHook<IDehydratedAssets, webpack.compilation.Compilation>;
}

// @public
export interface IModuleMinifierPluginOptions {
    compressAsyncImports?: boolean;
    minifier: IModuleMinifier;
    sourceMap?: boolean;
    usePortableModules?: boolean;
}

// @public
export interface IModuleMinifierPluginStats {
    // (undocumented)
    metadataByAssetFileName: Map<string, IAssetStats>;
}

// @internal
export interface _INormalModuleFactoryModuleData {
    // (undocumented)
    resourceResolveData?: {
        descriptionFileData?: {
            name: string;
        };
        descriptionFilePath?: string;
        descriptionFileRoot?: string;
        relativePath?: string;
    };
}

// @public
export interface IPostProcessFragmentContext {
    compilation: webpack.compilation.Compilation;
    loggingName: string;
    module: webpack.compilation.Module | undefined;
}

// @public
export interface IRenderedModulePosition {
    charLength: number;
    charOffset: number;
}

// @internal
export interface _IWebpackCompilationData {
    // (undocumented)
    normalModuleFactory: webpack.compilation.NormalModuleFactory;
}

export { IWorkerPoolMinifierOptions }

export { LocalMinifier }

export { MessagePortMinifier }

// @public
export const MODULE_WRAPPER_PREFIX: '__MINIFY_MODULE__(';

// @public
export const MODULE_WRAPPER_SUFFIX: ');';

// @public
export class ModuleMinifierPlugin implements webpack.Plugin {
    constructor(options: IModuleMinifierPluginOptions);
    // (undocumented)
    apply(compiler: webpack.Compiler): void;
    // (undocumented)
    static getCompilationStatistics(compilation: webpack.compilation.Compilation): IModuleMinifierPluginStats | undefined;
    // (undocumented)
    readonly hooks: IModuleMinifierPluginHooks;
    // (undocumented)
    minifier: IModuleMinifier;
}

export { NoopMinifier }

// @public
export class PortableMinifierModuleIdsPlugin implements Plugin {
    constructor(minifierHooks: IModuleMinifierPluginHooks);
    // (undocumented)
    apply(compiler: Compiler): void;
}

// @public
export function rehydrateAsset(asset: IAssetInfo, moduleMap: IModuleMap, banner: string, emitRenderInfo?: boolean): Source;

// @public
export const STAGE_AFTER: 100;

// @public
export const STAGE_BEFORE: -100;

export { WorkerPoolMinifier }

// (No @packageDocumentation comment for this package)

```
