## API Report File for "@rushstack/ts-command-line"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import * as argparse from 'argparse';

// @public
export class AliasCommandLineAction extends CommandLineAction {
    constructor(options: IAliasCommandLineActionOptions);
    readonly defaultParameters: ReadonlyArray<string>;
    protected onExecute(): Promise<void>;
    // @internal
    _processParsedData(parserOptions: ICommandLineParserOptions, data: _ICommandLineParserData): void;
    // @internal (undocumented)
    _registerDefinedParameters(state: _IRegisterDefinedParametersState): void;
    readonly targetAction: CommandLineAction;
}

// @public
export abstract class CommandLineAction extends CommandLineParameterProvider {
    constructor(options: ICommandLineActionOptions);
    readonly actionName: string;
    // @internal
    _buildParser(actionsSubParser: argparse.SubParser): void;
    readonly documentation: string;
    // @internal
    _executeAsync(): Promise<void>;
    // @internal
    _getArgumentParser(): argparse.ArgumentParser;
    protected abstract onExecute(): Promise<void>;
    readonly summary: string;
}

// @public
export class CommandLineChoiceListParameter<TChoice extends string = string> extends CommandLineParameter {
    // @internal
    constructor(definition: ICommandLineChoiceListDefinition<TChoice>);
    readonly alternatives: ReadonlySet<TChoice>;
    // @override
    appendToArgList(argList: string[]): void;
    readonly completions: (() => Promise<ReadonlyArray<TChoice> | ReadonlySet<TChoice>>) | undefined;
    readonly kind: CommandLineParameterKind.ChoiceList;
    // @internal
    _setValue(data: unknown): void;
    get values(): ReadonlyArray<TChoice>;
}

// @public
export class CommandLineChoiceParameter<TChoice extends string = string> extends CommandLineParameter {
    // @internal
    constructor(definition: ICommandLineChoiceDefinition<TChoice>);
    readonly alternatives: ReadonlySet<TChoice>;
    // @override
    appendToArgList(argList: string[]): void;
    readonly completions: (() => Promise<ReadonlyArray<TChoice> | ReadonlySet<TChoice>>) | undefined;
    readonly defaultValue: TChoice | undefined;
    // @internal
    _getSupplementaryNotes(supplementaryNotes: string[]): void;
    readonly kind: CommandLineParameterKind.Choice;
    // @internal
    _setValue(data: unknown): void;
    get value(): TChoice | undefined;
}

// @public
export enum CommandLineConstants {
    TabCompletionActionName = "tab-complete"
}

// @public
export class CommandLineFlagParameter extends CommandLineParameter {
    // @internal
    constructor(definition: ICommandLineFlagDefinition);
    // @override
    appendToArgList(argList: string[]): void;
    readonly kind: CommandLineParameterKind.Flag;
    // @internal
    _setValue(data: unknown): void;
    get value(): boolean;
}

// @public
export class CommandLineHelper {
    static isTabCompletionActionRequest(argv: string[]): boolean;
}

// @public
export class CommandLineIntegerListParameter extends CommandLineParameterWithArgument {
    // @internal
    constructor(definition: ICommandLineIntegerListDefinition);
    // @override
    appendToArgList(argList: string[]): void;
    readonly kind: CommandLineParameterKind.IntegerList;
    // @internal
    _setValue(data: unknown): void;
    get values(): ReadonlyArray<number>;
}

// @public
export class CommandLineIntegerParameter extends CommandLineParameterWithArgument {
    // @internal
    constructor(definition: ICommandLineIntegerDefinition);
    // @override
    appendToArgList(argList: string[]): void;
    readonly defaultValue: number | undefined;
    // @internal
    _getSupplementaryNotes(supplementaryNotes: string[]): void;
    readonly kind: CommandLineParameterKind.Integer;
    // @internal
    _setValue(data: unknown): void;
    get value(): number | undefined;
}

// @public
export abstract class CommandLineParameter {
    // @internal
    constructor(definition: IBaseCommandLineDefinition);
    readonly allowNonStandardEnvironmentVariableNames: boolean | undefined;
    abstract appendToArgList(argList: string[]): void;
    readonly description: string;
    readonly environmentVariable: string | undefined;
    // @internal
    _getSupplementaryNotes(supplementaryNotes: string[]): void;
    abstract get kind(): CommandLineParameterKind;
    readonly longName: string;
    readonly parameterGroup: string | typeof SCOPING_PARAMETER_GROUP | undefined;
    readonly parameterScope: string | undefined;
    // @internal
    _parserKey: string | undefined;
    // @internal (undocumented)
    _postParse?: () => void;
    // @internal (undocumented)
    _preParse?: () => void;
    protected reportInvalidData(data: unknown): never;
    readonly required: boolean;
    readonly scopedLongName: string | undefined;
    // @internal
    abstract _setValue(data: unknown): void;
    get shortName(): string | undefined;
    readonly undocumentedSynonyms: string[] | undefined;
    // (undocumented)
    protected validateDefaultValue(hasDefaultValue: boolean): void;
    // @internal (undocumented)
    _validateValue?: () => void;
}

// @public
export enum CommandLineParameterKind {
    Choice = 0,
    ChoiceList = 5,
    Flag = 1,
    Integer = 2,
    IntegerList = 6,
    String = 3,
    StringList = 4
}

// @public
export abstract class CommandLineParameterProvider {
    // @internal
    constructor();
    // @internal (undocumented)
    readonly _ambiguousParameterParserKeysByName: Map<string, string>;
    // @internal (undocumented)
    protected _defineAmbiguousParameter(name: string): string;
    defineChoiceListParameter<TChoice extends string = string>(definition: ICommandLineChoiceListDefinition<TChoice>): CommandLineChoiceListParameter<TChoice>;
    defineChoiceParameter<TChoice extends string = string>(definition: ICommandLineChoiceDefinition<TChoice> & {
        required: false | undefined;
        defaultValue: undefined;
    }): CommandLineChoiceParameter<TChoice>;
    defineChoiceParameter<TChoice extends string = string>(definition: ICommandLineChoiceDefinition<TChoice> & {
        required: true;
    }): IRequiredCommandLineChoiceParameter<TChoice>;
    defineChoiceParameter<TChoice extends string = string>(definition: ICommandLineChoiceDefinition<TChoice> & {
        defaultValue: TChoice;
    }): IRequiredCommandLineChoiceParameter<TChoice>;
    defineChoiceParameter<TChoice extends string = string>(definition: ICommandLineChoiceDefinition<TChoice>): CommandLineChoiceParameter<TChoice>;
    defineCommandLineRemainder(definition: ICommandLineRemainderDefinition): CommandLineRemainder;
    defineFlagParameter(definition: ICommandLineFlagDefinition): CommandLineFlagParameter;
    defineIntegerListParameter(definition: ICommandLineIntegerListDefinition): CommandLineIntegerListParameter;
    defineIntegerParameter(definition: ICommandLineIntegerDefinition & {
        required: false | undefined;
        defaultValue: undefined;
    }): CommandLineIntegerParameter;
    defineIntegerParameter(definition: ICommandLineIntegerDefinition & {
        required: true;
    }): IRequiredCommandLineIntegerParameter;
    defineIntegerParameter(definition: ICommandLineIntegerDefinition & {
        defaultValue: number;
    }): IRequiredCommandLineIntegerParameter;
    defineIntegerParameter(definition: ICommandLineIntegerDefinition): CommandLineIntegerParameter;
    // Warning: (ae-forgotten-export) The symbol "CommandLineParameter_2" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    protected _defineParameter(parameter: CommandLineParameter_2): void;
    defineStringListParameter(definition: ICommandLineStringListDefinition): CommandLineStringListParameter;
    defineStringParameter(definition: ICommandLineStringDefinition & {
        required: false | undefined;
        defaultValue: undefined;
    }): CommandLineStringParameter;
    defineStringParameter(definition: ICommandLineStringDefinition & {
        required: true;
    }): IRequiredCommandLineStringParameter;
    defineStringParameter(definition: ICommandLineStringDefinition & {
        defaultValue: string;
    }): IRequiredCommandLineStringParameter;
    defineStringParameter(definition: ICommandLineStringDefinition): CommandLineStringParameter;
    // @internal
    protected abstract _getArgumentParser(): argparse.ArgumentParser;
    getChoiceListParameter(parameterLongName: string, parameterScope?: string): CommandLineChoiceListParameter;
    getChoiceParameter(parameterLongName: string, parameterScope?: string): CommandLineChoiceParameter;
    getFlagParameter(parameterLongName: string, parameterScope?: string): CommandLineFlagParameter;
    getIntegerListParameter(parameterLongName: string, parameterScope?: string): CommandLineIntegerListParameter;
    getIntegerParameter(parameterLongName: string, parameterScope?: string): CommandLineIntegerParameter;
    getParameterStringMap(): Record<string, string>;
    getStringListParameter(parameterLongName: string, parameterScope?: string): CommandLineStringListParameter;
    getStringParameter(parameterLongName: string, parameterScope?: string): CommandLineStringParameter;
    // @deprecated (undocumented)
    protected onDefineParameters?(): void;
    get parameters(): ReadonlyArray<CommandLineParameter>;
    get parametersProcessed(): boolean;
    parseScopedLongName(scopedLongName: string): IScopedLongNameParseResult;
    // @internal
    _postParse(): void;
    // @internal
    _preParse(): void;
    // @internal
    _processParsedData(parserOptions: ICommandLineParserOptions, data: _ICommandLineParserData): void;
    // (undocumented)
    protected _registerAmbiguousParameter(name: string, parserKey: string): void;
    // @internal (undocumented)
    _registerDefinedParameters(state: _IRegisterDefinedParametersState): void;
    // @internal (undocumented)
    protected readonly _registeredParameterParserKeysByName: Map<string, string>;
    // @internal (undocumented)
    protected _registerParameter(parameter: CommandLineParameter_2, useScopedLongName: boolean, ignoreShortName: boolean): void;
    get remainder(): CommandLineRemainder | undefined;
    renderHelpText(): string;
    renderUsageText(): string;
}

// @public
export abstract class CommandLineParameterWithArgument extends CommandLineParameter {
    // @internal
    constructor(definition: IBaseCommandLineDefinitionWithArgument);
    readonly argumentName: string;
    readonly completions: (() => Promise<ReadonlyArray<string> | ReadonlySet<string>>) | undefined;
}

// @public
export abstract class CommandLineParser extends CommandLineParameterProvider {
    constructor(options: ICommandLineParserOptions);
    get actions(): ReadonlyArray<CommandLineAction>;
    addAction(action: CommandLineAction): void;
    // @deprecated (undocumented)
    execute(args?: string[]): Promise<boolean>;
    executeAsync(args?: string[]): Promise<boolean>;
    // @deprecated (undocumented)
    executeWithoutErrorHandling(args?: string[]): Promise<void>;
    executeWithoutErrorHandlingAsync(args?: string[]): Promise<void>;
    getAction(actionName: string): CommandLineAction;
    // @internal
    protected _getArgumentParser(): argparse.ArgumentParser;
    protected onExecute(): Promise<void>;
    // @internal (undocumented)
    _registerDefinedParameters(state: _IRegisterDefinedParametersState): void;
    selectedAction: CommandLineAction | undefined;
    tryGetAction(actionName: string): CommandLineAction | undefined;
}

// @public
export class CommandLineRemainder {
    // @internal
    constructor(definition: ICommandLineRemainderDefinition);
    // @override
    appendToArgList(argList: string[]): void;
    readonly description: string;
    // @internal
    _setValue(data: unknown): void;
    get values(): ReadonlyArray<string>;
}

// @public
export class CommandLineStringListParameter extends CommandLineParameterWithArgument {
    // @internal
    constructor(definition: ICommandLineStringListDefinition);
    // @override
    appendToArgList(argList: string[]): void;
    readonly kind: CommandLineParameterKind.StringList;
    // @internal
    _setValue(data: unknown): void;
    get values(): ReadonlyArray<string>;
}

// @public
export class CommandLineStringParameter extends CommandLineParameterWithArgument {
    // @internal
    constructor(definition: ICommandLineStringDefinition);
    // @override
    appendToArgList(argList: string[]): void;
    readonly defaultValue: string | undefined;
    // @internal
    _getSupplementaryNotes(supplementaryNotes: string[]): void;
    readonly kind: CommandLineParameterKind.String;
    // @internal
    _setValue(data: unknown): void;
    get value(): string | undefined;
}

// @public (undocumented)
export class DynamicCommandLineAction extends CommandLineAction {
    // (undocumented)
    protected onExecute(): Promise<void>;
}

// @public (undocumented)
export class DynamicCommandLineParser extends CommandLineParser {
}

// @public
export interface IAliasCommandLineActionOptions {
    aliasName: string;
    defaultParameters?: string[];
    targetAction: CommandLineAction;
    toolFilename: string;
}

// @public
export interface IBaseCommandLineDefinition {
    allowNonStandardEnvironmentVariableNames?: boolean;
    description: string;
    environmentVariable?: string;
    parameterGroup?: string | typeof SCOPING_PARAMETER_GROUP;
    parameterLongName: string;
    parameterScope?: string;
    parameterShortName?: string;
    required?: boolean;
    undocumentedSynonyms?: string[];
}

// @public
export interface IBaseCommandLineDefinitionWithArgument extends IBaseCommandLineDefinition {
    argumentName: string;
    completions?: () => Promise<ReadonlyArray<string> | ReadonlySet<string>>;
}

// @public
export interface ICommandLineActionOptions {
    actionName: string;
    documentation: string;
    summary: string;
}

// @public
export interface ICommandLineChoiceDefinition<TChoice extends string = string> extends IBaseCommandLineDefinition {
    alternatives: ReadonlyArray<TChoice> | ReadonlySet<TChoice>;
    completions?: () => Promise<ReadonlyArray<TChoice> | ReadonlySet<TChoice>>;
    defaultValue?: TChoice;
}

// @public
export interface ICommandLineChoiceListDefinition<TChoice extends string = string> extends IBaseCommandLineDefinition {
    alternatives: ReadonlyArray<TChoice> | ReadonlySet<TChoice>;
    completions?: () => Promise<ReadonlyArray<TChoice> | ReadonlySet<TChoice>>;
}

// @public
export interface ICommandLineFlagDefinition extends IBaseCommandLineDefinition {
}

// @public
export interface ICommandLineIntegerDefinition extends IBaseCommandLineDefinitionWithArgument {
    defaultValue?: number;
}

// @public
export interface ICommandLineIntegerListDefinition extends IBaseCommandLineDefinitionWithArgument {
}

// @internal
export interface _ICommandLineParserData {
    // (undocumented)
    [key: string]: any;
    // (undocumented)
    action: string;
    // (undocumented)
    aliasAction?: string;
    // (undocumented)
    aliasDocumentation?: string;
}

// @public
export interface ICommandLineParserOptions {
    enableTabCompletionAction?: boolean;
    toolDescription: string;
    toolEpilog?: string;
    toolFilename: string;
}

// @public
export interface ICommandLineRemainderDefinition {
    description: string;
}

// @public
export interface ICommandLineStringDefinition extends IBaseCommandLineDefinitionWithArgument {
    defaultValue?: string;
}

// @public
export interface ICommandLineStringListDefinition extends IBaseCommandLineDefinitionWithArgument {
}

// @internal
export interface _IRegisterDefinedParametersState {
    parentParameterNames: Set<string>;
}

// @public
export interface IRequiredCommandLineChoiceParameter<TChoice extends string = string> extends CommandLineChoiceParameter<TChoice> {
    // (undocumented)
    readonly value: TChoice;
}

// @public
export interface IRequiredCommandLineIntegerParameter extends CommandLineIntegerParameter {
    // (undocumented)
    readonly value: number;
}

// @public
export interface IRequiredCommandLineStringParameter extends CommandLineStringParameter {
    // (undocumented)
    readonly value: string;
}

// @public
export interface IScopedLongNameParseResult {
    longName: string;
    scope: string | undefined;
}

// @public
export abstract class ScopedCommandLineAction extends CommandLineAction {
    constructor(options: ICommandLineActionOptions);
    // @internal (undocumented)
    protected _defineParameter(parameter: CommandLineParameter_2): void;
    // @internal
    _executeAsync(): Promise<void>;
    // @internal
    protected _getScopedCommandLineParser(): CommandLineParser;
    protected abstract onDefineScopedParameters(scopedParameterProvider: CommandLineParameterProvider): void;
    // @deprecated (undocumented)
    protected onDefineUnscopedParameters?(): void;
    protected abstract onExecute(): Promise<void>;
    get parameters(): ReadonlyArray<CommandLineParameter>;
    // @internal
    _processParsedData(parserOptions: ICommandLineParserOptions, data: _ICommandLineParserData): void;
    // @internal (undocumented)
    _registerDefinedParameters(state: _IRegisterDefinedParametersState): void;
    static readonly ScopingParameterGroup: typeof SCOPING_PARAMETER_GROUP;
}

```
