## API Report File for "@rushstack/terminal"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import type { Brand } from '@rushstack/node-core-library';
import { NewlineKind } from '@rushstack/node-core-library';
import { Writable } from 'stream';
import { WritableOptions } from 'stream';

// @public
export class AnsiEscape {
    static formatForTests(text: string, options?: IAnsiEscapeConvertForTestsOptions): string;
    // (undocumented)
    static getEscapeSequenceForAnsiCode(code: number): string;
    static removeCodes(text: string): string;
}

// @public
export class CallbackWritable extends TerminalWritable {
    constructor(options: ICallbackWritableOptions);
    // (undocumented)
    protected onWriteChunk(chunk: ITerminalChunk): void;
}

// @public
export class Colorize {
    // (undocumented)
    static black(text: string): string;
    // (undocumented)
    static blackBackground(text: string): string;
    // (undocumented)
    static blink(text: string): string;
    // (undocumented)
    static blue(text: string): string;
    // (undocumented)
    static blueBackground(text: string): string;
    // (undocumented)
    static bold(text: string): string;
    // (undocumented)
    static cyan(text: string): string;
    // (undocumented)
    static cyanBackground(text: string): string;
    // (undocumented)
    static dim(text: string): string;
    // (undocumented)
    static gray(text: string): string;
    // (undocumented)
    static grayBackground(text: string): string;
    // (undocumented)
    static green(text: string): string;
    // (undocumented)
    static greenBackground(text: string): string;
    // (undocumented)
    static hidden(text: string): string;
    // (undocumented)
    static invertColor(text: string): string;
    // (undocumented)
    static magenta(text: string): string;
    // (undocumented)
    static magentaBackground(text: string): string;
    // (undocumented)
    static rainbow(text: string): string;
    // (undocumented)
    static red(text: string): string;
    // (undocumented)
    static redBackground(text: string): string;
    // (undocumented)
    static underline(text: string): string;
    // (undocumented)
    static white(text: string): string;
    // (undocumented)
    static whiteBackground(text: string): string;
    // (undocumented)
    static yellow(text: string): string;
    // (undocumented)
    static yellowBackground(text: string): string;
}

// @beta
export class ConsoleTerminalProvider implements ITerminalProvider {
    constructor(options?: Partial<IConsoleTerminalProviderOptions>);
    debugEnabled: boolean;
    get eolCharacter(): string;
    // (undocumented)
    static readonly supportsColor: boolean;
    readonly supportsColor: boolean;
    verboseEnabled: boolean;
    write(data: string, severity: TerminalProviderSeverity): void;
}

// @public
export const DEFAULT_CONSOLE_WIDTH: number;

// @beta
export class DiscardStdoutTransform extends TerminalTransform {
    constructor(options: IDiscardStdoutTransformOptions);
    // (undocumented)
    protected onWriteChunk(chunk: ITerminalChunk): void;
}

// @public
export interface IAnsiEscapeConvertForTestsOptions {
    encodeNewlines?: boolean;
}

// @public
export interface ICallbackWritableOptions {
    // (undocumented)
    onWriteChunk: (chunk: ITerminalChunk) => void;
}

// @beta
export interface IConsoleTerminalProviderOptions {
    debugEnabled: boolean;
    verboseEnabled: boolean;
}

// @beta
export interface IDiscardStdoutTransformOptions extends ITerminalTransformOptions {
}

// @beta
export interface IDynamicPrefixProxyTerminalProviderOptions extends IPrefixProxyTerminalProviderOptionsBase {
    getPrefix: () => string;
}

// @public
export interface INormalizeNewlinesTextRewriterOptions {
    ensureNewlineAtEnd?: boolean;
    newlineKind: NewlineKind;
}

// @beta (undocumented)
export type IPrefixProxyTerminalProviderOptions = IStaticPrefixProxyTerminalProviderOptions | IDynamicPrefixProxyTerminalProviderOptions;

// @beta (undocumented)
export interface IPrefixProxyTerminalProviderOptionsBase {
    terminalProvider: ITerminalProvider;
}

// @public
export interface ISplitterTransformOptions extends ITerminalWritableOptions {
    destinations: TerminalWritable[];
}

// @beta
export interface IStaticPrefixProxyTerminalProviderOptions extends IPrefixProxyTerminalProviderOptionsBase {
    prefix: string;
}

// @beta
export interface IStdioLineTransformOptions extends ITerminalTransformOptions {
    newlineKind?: NewlineKind;
}

// @beta
export interface IStdioSummarizerOptions extends ITerminalWritableOptions {
    leadingLines?: number;
    trailingLines?: number;
}

// @beta (undocumented)
export interface IStringBufferOutputOptions {
    normalizeSpecialCharacters: boolean;
}

// @beta (undocumented)
export interface ITerminal {
    registerProvider(provider: ITerminalProvider): void;
    unregisterProvider(provider: ITerminalProvider): void;
    write(...messageParts: TerminalWriteParameters): void;
    writeDebug(...messageParts: TerminalWriteParameters): void;
    writeDebugLine(...messageParts: TerminalWriteParameters): void;
    writeError(...messageParts: TerminalWriteParameters): void;
    writeErrorLine(...messageParts: TerminalWriteParameters): void;
    writeLine(...messageParts: TerminalWriteParameters): void;
    writeVerbose(...messageParts: TerminalWriteParameters): void;
    writeVerboseLine(...messageParts: TerminalWriteParameters): void;
    writeWarning(...messageParts: TerminalWriteParameters): void;
    writeWarningLine(...messageParts: TerminalWriteParameters): void;
}

// @public
export interface ITerminalChunk {
    kind: TerminalChunkKind;
    text: string;
}

// @beta
export interface ITerminalProvider {
    eolCharacter: string;
    supportsColor: boolean;
    write(data: string, severity: TerminalProviderSeverity): void;
}

// @beta
export interface ITerminalStreamWritableOptions {
    severity: TerminalProviderSeverity;
    terminal: ITerminal;
    writableOptions?: WritableOptions;
}

// @public
export interface ITerminalTransformOptions extends ITerminalWritableOptions {
    destination: TerminalWritable;
    preventDestinationAutoclose?: boolean;
}

// @public
export interface ITerminalWritableOptions {
    preventAutoclose?: boolean;
}

// @beta (undocumented)
export interface ITerminalWriteOptions {
    doNotOverrideSgrCodes?: boolean;
}

// @public
export interface ITextRewriterTransformOptions extends ITerminalTransformOptions {
    ensureNewlineAtEnd?: boolean;
    normalizeNewlines?: NewlineKind;
    removeColors?: boolean;
    textRewriters?: TextRewriter[];
}

// @beta
export class MockWritable extends TerminalWritable {
    // (undocumented)
    readonly chunks: ITerminalChunk[];
    // (undocumented)
    getAllOutput(): string;
    // (undocumented)
    getFormattedChunks(): ITerminalChunk[];
    // (undocumented)
    protected onWriteChunk(chunk: ITerminalChunk): void;
    // (undocumented)
    reset(): void;
}

// @public
export class NormalizeNewlinesTextRewriter extends TextRewriter {
    constructor(options: INormalizeNewlinesTextRewriterOptions);
    // (undocumented)
    close(unknownState: TextRewriterState): string;
    readonly ensureNewlineAtEnd: boolean;
    // (undocumented)
    initialize(): TextRewriterState;
    readonly newline: string;
    readonly newlineKind: NewlineKind;
    // (undocumented)
    process(unknownState: TextRewriterState, text: string): string;
}

// @beta
export class PrefixProxyTerminalProvider implements ITerminalProvider {
    constructor(options: IPrefixProxyTerminalProviderOptions);
    // @override (undocumented)
    get eolCharacter(): string;
    // @override (undocumented)
    get supportsColor(): boolean;
    // @override (undocumented)
    write(data: string, severity: TerminalProviderSeverity): void;
}

// @public
export class PrintUtilities {
    static getConsoleWidth(): number | undefined;
    // Warning: (ae-incompatible-release-tags) The symbol "printMessageInBox" is marked as @public, but its signature references "ITerminal" which is marked as @beta
    static printMessageInBox(message: string, terminal: ITerminal, boxWidth?: number): void;
    static wrapWords(text: string, maxLineLength?: number, indent?: number): string;
    static wrapWords(text: string, maxLineLength?: number, linePrefix?: string): string;
    static wrapWords(text: string, maxLineLength?: number, indentOrLinePrefix?: number | string): string;
    static wrapWordsToLines(text: string, maxLineLength?: number, indent?: number): string[];
    static wrapWordsToLines(text: string, maxLineLength?: number, linePrefix?: string): string[];
    static wrapWordsToLines(text: string, maxLineLength?: number, indentOrLinePrefix?: number | string): string[];
}

// @public
export class RemoveColorsTextRewriter extends TextRewriter {
    // (undocumented)
    close(unknownState: TextRewriterState): string;
    // (undocumented)
    initialize(): TextRewriterState;
    // (undocumented)
    process(unknownState: TextRewriterState, text: string): string;
}

// @public
export class SplitterTransform extends TerminalWritable {
    constructor(options: ISplitterTransformOptions);
    // (undocumented)
    readonly destinations: ReadonlyArray<TerminalWritable>;
    // (undocumented)
    protected onClose(): void;
    // (undocumented)
    protected onWriteChunk(chunk: ITerminalChunk): void;
}

// @beta
export class StderrLineTransform extends TerminalTransform {
    constructor(options: IStdioLineTransformOptions);
    // (undocumented)
    readonly newline: string;
    // (undocumented)
    protected onClose(): void;
    // (undocumented)
    protected onWriteChunk(chunk: ITerminalChunk): void;
}

// @beta
export class StdioSummarizer extends TerminalWritable {
    constructor(options?: IStdioSummarizerOptions);
    getReport(): string;
    // (undocumented)
    onWriteChunk(chunk: ITerminalChunk): void;
}

// @public
export class StdioWritable extends TerminalWritable {
    // (undocumented)
    static instance: StdioWritable;
    // (undocumented)
    protected onWriteChunk(chunk: ITerminalChunk): void;
}

// @beta
export class StringBufferTerminalProvider implements ITerminalProvider {
    constructor(supportsColor?: boolean);
    get eolCharacter(): string;
    getDebugOutput(options?: IStringBufferOutputOptions): string;
    getErrorOutput(options?: IStringBufferOutputOptions): string;
    getOutput(options?: IStringBufferOutputOptions): string;
    // @deprecated (undocumented)
    getVerbose(options?: IStringBufferOutputOptions): string;
    getVerboseOutput(options?: IStringBufferOutputOptions): string;
    getWarningOutput(options?: IStringBufferOutputOptions): string;
    get supportsColor(): boolean;
    write(data: string, severity: TerminalProviderSeverity): void;
}

// @beta
export class Terminal implements ITerminal {
    constructor(provider: ITerminalProvider);
    registerProvider(provider: ITerminalProvider): void;
    unregisterProvider(provider: ITerminalProvider): void;
    write(...messageParts: TerminalWriteParameters): void;
    writeDebug(...messageParts: TerminalWriteParameters): void;
    writeDebugLine(...messageParts: TerminalWriteParameters): void;
    writeError(...messageParts: TerminalWriteParameters): void;
    writeErrorLine(...messageParts: TerminalWriteParameters): void;
    writeLine(...messageParts: TerminalWriteParameters): void;
    writeVerbose(...messageParts: TerminalWriteParameters): void;
    writeVerboseLine(...messageParts: TerminalWriteParameters): void;
    writeWarning(...messageParts: TerminalWriteParameters): void;
    writeWarningLine(...messageParts: TerminalWriteParameters): void;
}

// @public
export enum TerminalChunkKind {
    Stderr = "E",
    Stdout = "O"
}

// @beta
export enum TerminalProviderSeverity {
    // (undocumented)
    debug = 4,
    // (undocumented)
    error = 2,
    // (undocumented)
    log = 0,
    // (undocumented)
    verbose = 3,
    // (undocumented)
    warning = 1
}

// @beta
export class TerminalStreamWritable extends Writable {
    constructor(options: ITerminalStreamWritableOptions);
    // (undocumented)
    _write(chunk: string | Buffer | Uint8Array, encoding: string, callback: (error?: Error | null) => void): void;
}

// @public
export abstract class TerminalTransform extends TerminalWritable {
    constructor(options: ITerminalTransformOptions);
    // @sealed
    protected autocloseDestination(): void;
    readonly destination: TerminalWritable;
    // @override (undocumented)
    protected onClose(): void;
    readonly preventDestinationAutoclose: boolean;
}

// @public
export abstract class TerminalWritable {
    constructor(options?: ITerminalWritableOptions);
    // @sealed
    close(): void;
    // @sealed
    get isOpen(): boolean;
    // @virtual
    protected onClose(): void;
    protected abstract onWriteChunk(chunk: ITerminalChunk): void;
    // (undocumented)
    readonly preventAutoclose: boolean;
    // @sealed
    writeChunk(chunk: ITerminalChunk): void;
}

// @beta (undocumented)
export type TerminalWriteParameters = string[] | [...string[], ITerminalWriteOptions];

// @public
export abstract class TextRewriter {
    abstract close(state: TextRewriterState): string;
    abstract initialize(): TextRewriterState;
    abstract process(state: TextRewriterState, input: string): string;
}

// @public
export type TextRewriterState = Brand<unknown, 'TextRewriterState'>;

// @public
export class TextRewriterTransform extends TerminalTransform {
    constructor(options: ITextRewriterTransformOptions);
    // (undocumented)
    protected onClose(): void;
    // (undocumented)
    protected onWriteChunk(chunk: ITerminalChunk): void;
    // (undocumented)
    readonly textRewriters: ReadonlyArray<TextRewriter>;
}

```
