## API Report File for "@microsoft/rush-lib"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import { AsyncParallelHook } from 'tapable';
import { AsyncSeriesBailHook } from 'tapable';
import { AsyncSeriesHook } from 'tapable';
import { AsyncSeriesWaterfallHook } from 'tapable';
import type { CollatedWriter } from '@rushstack/stream-collator';
import type { CommandLineParameter } from '@rushstack/ts-command-line';
import { CommandLineParameterKind } from '@rushstack/ts-command-line';
import { HookMap } from 'tapable';
import { IFileDiffStatus } from '@rushstack/package-deps-hash';
import { IPackageJson } from '@rushstack/node-core-library';
import { IPrefixMatch } from '@rushstack/lookup-by-path';
import { ITerminal } from '@rushstack/terminal';
import { ITerminalProvider } from '@rushstack/terminal';
import { JsonNull } from '@rushstack/node-core-library';
import { JsonObject } from '@rushstack/node-core-library';
import { LookupByPath } from '@rushstack/lookup-by-path';
import { PackageNameParser } from '@rushstack/node-core-library';
import type { StdioSummarizer } from '@rushstack/terminal';
import { SyncHook } from 'tapable';
import { Terminal } from '@rushstack/terminal';

// @public
export class ApprovedPackagesConfiguration {
    constructor(jsonFilename: string);
    // (undocumented)
    addOrUpdatePackage(packageName: string, reviewCategory: string): boolean;
    clear(): void;
    // (undocumented)
    getItemByName(packageName: string): ApprovedPackagesItem | undefined;
    // (undocumented)
    items: ApprovedPackagesItem[];
    loadFromFile(): void;
    saveToFile(): void;
    tryLoadFromFile(approvedPackagesPolicyEnabled: boolean): boolean;
}

// @public
export class ApprovedPackagesItem {
    // @internal
    constructor(packageName: string);
    allowedCategories: Set<string>;
    packageName: string;
}

// @public
export class ApprovedPackagesPolicy {
    // Warning: (ae-forgotten-export) The symbol "IRushConfigurationJson" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(rushConfiguration: RushConfiguration, rushConfigurationJson: IRushConfigurationJson);
    readonly browserApprovedPackages: ApprovedPackagesConfiguration;
    readonly enabled: boolean;
    readonly ignoredNpmScopes: ReadonlySet<string>;
    readonly nonbrowserApprovedPackages: ApprovedPackagesConfiguration;
    readonly reviewCategories: ReadonlySet<string>;
}

// @beta
export class BuildCacheConfiguration {
    readonly buildCacheEnabled: boolean;
    readonly cacheHashSalt: string | undefined;
    cacheWriteEnabled: boolean;
    readonly cloudCacheProvider: ICloudBuildCacheProvider | undefined;
    static getBuildCacheConfigFilePath(rushConfiguration: RushConfiguration): string;
    readonly getCacheEntryId: GetCacheEntryIdFunction;
    static loadAndRequireEnabledAsync(terminal: ITerminal, rushConfiguration: RushConfiguration, rushSession: RushSession): Promise<BuildCacheConfiguration>;
    readonly localCacheProvider: FileSystemBuildCacheProvider;
    static tryLoadAsync(terminal: ITerminal, rushConfiguration: RushConfiguration, rushSession: RushSession): Promise<BuildCacheConfiguration | undefined>;
}

// @public
export enum BumpType {
    // (undocumented)
    'major' = 5,
    // (undocumented)
    'minor' = 4,
    // (undocumented)
    'none' = 0,
    // (undocumented)
    'patch' = 2,
    // (undocumented)
    'preminor' = 3,
    // (undocumented)
    'prerelease' = 1
}

// @public
export class ChangeManager {
    static createEmptyChangeFiles(rushConfiguration: RushConfiguration, projectName: string, emailAddress: string): string | undefined;
}

// Warning: (ae-forgotten-export) The symbol "IBuildCacheJson" needs to be exported by the entry point index.d.ts
//
// @beta (undocumented)
export type CloudBuildCacheProviderFactory = (buildCacheJson: IBuildCacheJson) => ICloudBuildCacheProvider | Promise<ICloudBuildCacheProvider>;

// @beta
export class CobuildConfiguration {
    readonly cobuildContextId: string | undefined;
    readonly cobuildFeatureEnabled: boolean;
    readonly cobuildLeafProjectLogOnlyAllowed: boolean;
    readonly cobuildRunnerId: string;
    readonly cobuildWithoutCacheAllowed: boolean;
    // (undocumented)
    createLockProviderAsync(terminal: ITerminal): Promise<void>;
    // (undocumented)
    destroyLockProviderAsync(): Promise<void>;
    // (undocumented)
    static getCobuildConfigFilePath(rushConfiguration: RushConfiguration): string;
    // (undocumented)
    getCobuildLockProvider(): ICobuildLockProvider;
    static tryLoadAsync(terminal: ITerminal, rushConfiguration: RushConfiguration, rushSession: RushSession): Promise<CobuildConfiguration | undefined>;
}

// @beta (undocumented)
export type CobuildLockProviderFactory = (cobuildJson: ICobuildJson) => ICobuildLockProvider | Promise<ICobuildLockProvider>;

// @public
export class CommonVersionsConfiguration {
    readonly allowedAlternativeVersions: Map<string, ReadonlyArray<string>>;
    readonly ensureConsistentVersions: boolean;
    readonly filePath: string;
    getAllPreferredVersions(): Map<string, string>;
    getPreferredVersionsHash(): string;
    readonly implicitlyPreferredVersions: boolean | undefined;
    static loadFromFile(jsonFilePath: string, rushConfiguration?: RushConfiguration): CommonVersionsConfiguration;
    readonly preferredVersions: Map<string, string>;
    save(): boolean;
}

// @beta (undocumented)
export class CredentialCache {
    // (undocumented)
    deleteCacheEntry(cacheId: string): void;
    // (undocumented)
    dispose(): void;
    // (undocumented)
    static initializeAsync(options: ICredentialCacheOptions): Promise<CredentialCache>;
    // (undocumented)
    saveIfModifiedAsync(): Promise<void>;
    // (undocumented)
    setCacheEntry(cacheId: string, entry: ICredentialCacheEntry): void;
    // (undocumented)
    trimExpiredEntries(): void;
    // (undocumented)
    tryGetCacheEntry(cacheId: string): ICredentialCacheEntry | undefined;
    // (undocumented)
    static usingAsync(options: ICredentialCacheOptions, doActionAsync: (credentialCache: CredentialCache) => Promise<void> | void): Promise<void>;
}

// @beta
export enum CustomTipId {
    // (undocumented)
    TIP_PNPM_INVALID_NODE_VERSION = "TIP_PNPM_INVALID_NODE_VERSION",
    // (undocumented)
    TIP_PNPM_MISMATCHED_RELEASE_CHANNEL = "TIP_PNPM_MISMATCHED_RELEASE_CHANNEL",
    // (undocumented)
    TIP_PNPM_NO_MATCHING_VERSION = "TIP_PNPM_NO_MATCHING_VERSION",
    // (undocumented)
    TIP_PNPM_NO_MATCHING_VERSION_INSIDE_WORKSPACE = "TIP_PNPM_NO_MATCHING_VERSION_INSIDE_WORKSPACE",
    // (undocumented)
    TIP_PNPM_OUTDATED_LOCKFILE = "TIP_PNPM_OUTDATED_LOCKFILE",
    // (undocumented)
    TIP_PNPM_PEER_DEP_ISSUES = "TIP_PNPM_PEER_DEP_ISSUES",
    // (undocumented)
    TIP_PNPM_TARBALL_INTEGRITY = "TIP_PNPM_TARBALL_INTEGRITY",
    // (undocumented)
    TIP_PNPM_UNEXPECTED_STORE = "TIP_PNPM_UNEXPECTED_STORE",
    // (undocumented)
    TIP_RUSH_DISALLOW_INSECURE_SHA1 = "TIP_RUSH_DISALLOW_INSECURE_SHA1",
    // (undocumented)
    TIP_RUSH_INCONSISTENT_VERSIONS = "TIP_RUSH_INCONSISTENT_VERSIONS"
}

// @beta
export class CustomTipsConfiguration {
    constructor(configFilePath: string);
    static customTipRegistry: Readonly<Record<CustomTipId, ICustomTipInfo>>;
    // (undocumented)
    readonly providedCustomTipsByTipId: ReadonlyMap<CustomTipId, ICustomTipItemJson>;
    // @internal
    _showErrorTip(terminal: ITerminal, tipId: CustomTipId): void;
    // @internal
    _showInfoTip(terminal: ITerminal, tipId: CustomTipId): void;
    // @internal
    _showTip(terminal: ITerminal, tipId: CustomTipId): void;
    // @internal
    _showWarningTip(terminal: ITerminal, tipId: CustomTipId): void;
}

// @beta
export enum CustomTipSeverity {
    // (undocumented)
    Error = "Error",
    // (undocumented)
    Info = "Info",
    // (undocumented)
    Warning = "Warning"
}

// @beta
export enum CustomTipType {
    // (undocumented)
    pnpm = "pnpm",
    // (undocumented)
    rush = "rush"
}

// @public (undocumented)
export enum DependencyType {
    // (undocumented)
    Dev = "devDependencies",
    // (undocumented)
    Optional = "optionalDependencies",
    // (undocumented)
    Peer = "peerDependencies",
    // (undocumented)
    Regular = "dependencies",
    // (undocumented)
    YarnResolutions = "resolutions"
}

// @beta
export class EnvironmentConfiguration {
    static get absoluteSymlinks(): boolean;
    static get allowUnsupportedNodeVersion(): boolean;
    static get allowWarningsInSuccessfulBuild(): boolean;
    static get buildCacheCredential(): string | undefined;
    static get buildCacheEnabled(): boolean | undefined;
    static get buildCacheWriteAllowed(): boolean | undefined;
    static get cobuildContextId(): string | undefined;
    static get cobuildLeafProjectLogOnlyAllowed(): boolean | undefined;
    static get cobuildRunnerId(): string | undefined;
    // Warning: (ae-forgotten-export) The symbol "IEnvironment" needs to be exported by the entry point index.d.ts
    //
    // @internal
    static _getRushGlobalFolderOverride(processEnv: IEnvironment): string | undefined;
    static get gitBinaryPath(): string | undefined;
    // (undocumented)
    static parseBooleanEnvironmentVariable(name: string, value: string | undefined): boolean | undefined;
    static get pnpmStorePathOverride(): string | undefined;
    static get pnpmVerifyStoreIntegrity(): boolean | undefined;
    static reset(): void;
    static get rushGlobalFolderOverride(): string | undefined;
    static get rushTempFolderOverride(): string | undefined;
    static get tarBinaryPath(): string | undefined;
    static validate(options?: IEnvironmentConfigurationInitializeOptions): void;
}

// @beta
export const EnvironmentVariableNames: {
    readonly RUSH_TEMP_FOLDER: "RUSH_TEMP_FOLDER";
    readonly RUSH_PREVIEW_VERSION: "RUSH_PREVIEW_VERSION";
    readonly RUSH_ALLOW_UNSUPPORTED_NODEJS: "RUSH_ALLOW_UNSUPPORTED_NODEJS";
    readonly RUSH_ALLOW_WARNINGS_IN_SUCCESSFUL_BUILD: "RUSH_ALLOW_WARNINGS_IN_SUCCESSFUL_BUILD";
    readonly RUSH_VARIANT: "RUSH_VARIANT";
    readonly RUSH_PARALLELISM: "RUSH_PARALLELISM";
    readonly RUSH_ABSOLUTE_SYMLINKS: "RUSH_ABSOLUTE_SYMLINKS";
    readonly RUSH_PNPM_STORE_PATH: "RUSH_PNPM_STORE_PATH";
    readonly RUSH_PNPM_VERIFY_STORE_INTEGRITY: "RUSH_PNPM_VERIFY_STORE_INTEGRITY";
    readonly RUSH_DEPLOY_TARGET_FOLDER: "RUSH_DEPLOY_TARGET_FOLDER";
    readonly RUSH_GLOBAL_FOLDER: "RUSH_GLOBAL_FOLDER";
    readonly RUSH_BUILD_CACHE_CREDENTIAL: "RUSH_BUILD_CACHE_CREDENTIAL";
    readonly RUSH_BUILD_CACHE_ENABLED: "RUSH_BUILD_CACHE_ENABLED";
    readonly RUSH_BUILD_CACHE_WRITE_ALLOWED: "RUSH_BUILD_CACHE_WRITE_ALLOWED";
    readonly RUSH_COBUILD_CONTEXT_ID: "RUSH_COBUILD_CONTEXT_ID";
    readonly RUSH_COBUILD_RUNNER_ID: "RUSH_COBUILD_RUNNER_ID";
    readonly RUSH_COBUILD_LEAF_PROJECT_LOG_ONLY_ALLOWED: "RUSH_COBUILD_LEAF_PROJECT_LOG_ONLY_ALLOWED";
    readonly RUSH_GIT_BINARY_PATH: "RUSH_GIT_BINARY_PATH";
    readonly RUSH_TAR_BINARY_PATH: "RUSH_TAR_BINARY_PATH";
    readonly _RUSH_RECURSIVE_RUSHX_CALL: "_RUSH_RECURSIVE_RUSHX_CALL";
    readonly _RUSH_LIB_PATH: "_RUSH_LIB_PATH";
    readonly RUSH_INVOKED_FOLDER: "RUSH_INVOKED_FOLDER";
    readonly RUSH_INVOKED_ARGS: "RUSH_INVOKED_ARGS";
};

// @beta
enum Event_2 {
    postRushBuild = 4,
    postRushInstall = 2,
    postRushx = 6,
    preRushBuild = 3,
    preRushInstall = 1,
    preRushx = 5
}
export { Event_2 as Event }

// @beta
export class EventHooks {
    // Warning: (ae-forgotten-export) The symbol "IEventHooksJson" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(eventHooksJson: IEventHooksJson);
    get(event: Event_2): string[];
}

// @public
export class ExperimentsConfiguration {
    // @internal
    constructor(jsonFilePath: string);
    // @beta
    readonly configuration: Readonly<IExperimentsJson>;
}

// @beta
export class FileSystemBuildCacheProvider {
    constructor(options: IFileSystemBuildCacheProviderOptions);
    getCacheEntryPath(cacheId: string): string;
    tryGetCacheEntryPathByIdAsync(terminal: ITerminal, cacheId: string): Promise<string | undefined>;
    trySetCacheEntryBufferAsync(terminal: ITerminal, cacheId: string, entryBuffer: Buffer): Promise<string>;
}

// @internal
export class _FlagFile<TState extends JsonObject = JsonObject> {
    constructor(folderPath: string, flagName: string, initialState: TState);
    clearAsync(): Promise<void>;
    createAsync(): Promise<void>;
    isValidAsync(): Promise<boolean>;
    readonly path: string;
    protected _state: TState;
}

// @beta
export type GetCacheEntryIdFunction = (options: IGenerateCacheEntryIdOptions) => string;

// @beta
export type GetInputsSnapshotAsyncFn = () => Promise<IInputsSnapshot | undefined>;

// @internal (undocumented)
export interface _IBuiltInPluginConfiguration extends _IRushPluginConfigurationBase {
    // (undocumented)
    pluginPackageFolder: string;
}

// @beta (undocumented)
export interface ICloudBuildCacheProvider {
    // (undocumented)
    deleteCachedCredentialsAsync(terminal: ITerminal): Promise<void>;
    // (undocumented)
    readonly isCacheWriteAllowed: boolean;
    // (undocumented)
    tryGetCacheEntryBufferByIdAsync(terminal: ITerminal, cacheId: string): Promise<Buffer | undefined>;
    // (undocumented)
    trySetCacheEntryBufferAsync(terminal: ITerminal, cacheId: string, entryBuffer: Buffer): Promise<boolean>;
    // (undocumented)
    updateCachedCredentialAsync(terminal: ITerminal, credential: string): Promise<void>;
    // (undocumented)
    updateCachedCredentialInteractiveAsync(terminal: ITerminal): Promise<void>;
}

// @beta (undocumented)
export interface ICobuildCompletedState {
    cacheId: string;
    // (undocumented)
    status: OperationStatus.Success | OperationStatus.SuccessWithWarning | OperationStatus.Failure;
}

// @beta (undocumented)
export interface ICobuildContext {
    cacheId: string;
    clusterId: string;
    completedStateKey: string;
    contextId: string;
    lockExpireTimeInSeconds: number;
    lockKey: string;
    packageName: string;
    phaseName: string;
    runnerId: string;
}

// @beta (undocumented)
export interface ICobuildJson {
    // (undocumented)
    cobuildFeatureEnabled: boolean;
    // (undocumented)
    cobuildLockProvider: string;
}

// @beta (undocumented)
export interface ICobuildLockProvider {
    acquireLockAsync(context: Readonly<ICobuildContext>): Promise<boolean>;
    connectAsync(): Promise<void>;
    disconnectAsync(): Promise<void>;
    getCompletedStateAsync(context: Readonly<ICobuildContext>): Promise<ICobuildCompletedState | undefined>;
    renewLockAsync(context: Readonly<ICobuildContext>): Promise<void>;
    setCompletedStateAsync(context: Readonly<ICobuildContext>, state: ICobuildCompletedState): Promise<void>;
}

// @public
export interface IConfigurationEnvironment {
    [environmentVariableName: string]: IConfigurationEnvironmentVariable;
}

// @public
export interface IConfigurationEnvironmentVariable {
    override?: boolean;
    value: string;
}

// @alpha
export interface ICreateOperationsContext {
    readonly buildCacheConfiguration: BuildCacheConfiguration | undefined;
    readonly cobuildConfiguration: CobuildConfiguration | undefined;
    readonly customParameters: ReadonlyMap<string, CommandLineParameter>;
    readonly invalidateOperation?: ((operation: Operation, reason: string) => void) | undefined;
    readonly isIncrementalBuildAllowed: boolean;
    readonly isInitial: boolean;
    readonly isWatch: boolean;
    readonly phaseOriginal: ReadonlySet<IPhase>;
    readonly phaseSelection: ReadonlySet<IPhase>;
    readonly projectConfigurations: ReadonlyMap<RushConfigurationProject, RushProjectConfiguration>;
    readonly projectSelection: ReadonlySet<RushConfigurationProject>;
    readonly projectsInUnknownState: ReadonlySet<RushConfigurationProject>;
    readonly rushConfiguration: RushConfiguration;
}

// @beta (undocumented)
export interface ICredentialCacheEntry {
    // (undocumented)
    credential: string;
    // (undocumented)
    credentialMetadata?: object;
    // (undocumented)
    expires?: Date;
}

// @beta (undocumented)
export interface ICredentialCacheOptions {
    // (undocumented)
    supportEditing: boolean;
}

// @beta
export interface ICustomTipInfo {
    isMatch?: (str: string) => boolean;
    severity: CustomTipSeverity;
    // (undocumented)
    tipId: CustomTipId;
    type: CustomTipType;
}

// @beta
export interface ICustomTipItemJson {
    message: string;
    tipId: CustomTipId;
}

// @beta
export interface ICustomTipsJson {
    customTips?: ICustomTipItemJson[];
}

// @beta (undocumented)
export interface IEnvironmentConfigurationInitializeOptions {
    // (undocumented)
    doNotNormalizePaths?: boolean;
}

// @alpha
export interface IExecuteOperationsContext extends ICreateOperationsContext {
    readonly inputsSnapshot?: IInputsSnapshot;
}

// @alpha
export interface IExecutionResult {
    readonly operationResults: ReadonlyMap<Operation, IOperationExecutionResult>;
    readonly status: OperationStatus;
}

// @beta
export interface IExperimentsJson {
    allowCobuildWithoutCache?: boolean;
    buildCacheWithAllowWarningsInSuccessfulBuild?: boolean;
    buildSkipWithAllowWarningsInSuccessfulBuild?: boolean;
    cleanInstallAfterNpmrcChanges?: boolean;
    enableSubpathScan?: boolean;
    forbidPhantomResolvableNodeModulesFolders?: boolean;
    generateProjectImpactGraphDuringRushUpdate?: boolean;
    noChmodFieldInTarHeaderNormalization?: boolean;
    omitImportersFromPreventManualShrinkwrapChanges?: boolean;
    printEventHooksOutputToConsole?: boolean;
    rushAlerts?: boolean;
    useIPCScriptsInWatchMode?: boolean;
    usePnpmFrozenLockfileForRushInstall?: boolean;
    usePnpmLockfileOnlyThenFrozenLockfileForRushUpdate?: boolean;
    usePnpmPreferFrozenLockfileForRushUpdate?: boolean;
    usePnpmSyncForInjectedDependencies?: boolean;
}

// @beta
export interface IFileSystemBuildCacheProviderOptions {
    rushConfiguration: RushConfiguration;
    rushUserConfiguration: RushUserConfiguration;
}

// @beta
export interface IGenerateCacheEntryIdOptions {
    phaseName: string;
    projectName: string;
    projectStateHash: string;
}

// @beta (undocumented)
export interface IGetChangedProjectsOptions {
    enableFiltering: boolean;
    includeExternalDependencies: boolean;
    // (undocumented)
    shouldFetch?: boolean;
    // (undocumented)
    targetBranchName: string;
    // (undocumented)
    terminal: ITerminal;
    // (undocumented)
    variant?: string;
}

// @beta
export interface IGlobalCommand extends IRushCommand {
}

// @beta
export interface IInputsSnapshot {
    getOperationOwnStateHash(project: IRushConfigurationProjectForSnapshot, operationName?: string): string;
    getTrackedFileHashesForOperation(project: IRushConfigurationProjectForSnapshot, operationName?: string): ReadonlyMap<string, string>;
    readonly hashes: ReadonlyMap<string, string>;
    readonly rootDirectory: string;
}

// @public
export interface ILaunchOptions {
    alreadyReportedNodeTooNewError?: boolean;
    // @internal
    builtInPluginConfigurations?: _IBuiltInPluginConfiguration[];
    isManaged: boolean;
    terminalProvider?: ITerminalProvider;
}

// @alpha
export interface ILogFilePaths {
    error: string;
    jsonl: string;
    jsonlFolder: string;
    text: string;
    textFolder: string;
}

// @beta (undocumented)
export interface ILogger {
    emitError(error: Error): void;
    emitWarning(warning: Error): void;
    // (undocumented)
    readonly terminal: Terminal;
}

// @public
export class IndividualVersionPolicy extends VersionPolicy {
    // Warning: (ae-forgotten-export) The symbol "IIndividualVersionJson" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(versionPolicyJson: IIndividualVersionJson);
    bump(bumpType?: BumpType, identifier?: string): void;
    ensure(project: IPackageJson, force?: boolean): IPackageJson | undefined;
    // @internal
    get _json(): IIndividualVersionJson;
    readonly lockedMajor: number | undefined;
    validate(versionString: string, packageName: string): void;
}

// @internal
export interface _INpmOptionsJson extends IPackageManagerOptionsJsonBase {
}

// @alpha
export interface IOperationExecutionResult {
    readonly cobuildRunnerId: string | undefined;
    readonly error: Error | undefined;
    readonly logFilePaths: ILogFilePaths | undefined;
    readonly metadataFolderPath: string | undefined;
    readonly nonCachedDurationMs: number | undefined;
    readonly operation: Operation;
    readonly silent: boolean;
    readonly status: OperationStatus;
    readonly stdioSummarizer: StdioSummarizer;
    readonly stopwatch: IStopwatchResult;
}

// @internal (undocumented)
export interface _IOperationMetadata {
    // (undocumented)
    cobuildContextId: string | undefined;
    // (undocumented)
    cobuildRunnerId: string | undefined;
    // (undocumented)
    durationInSeconds: number;
    // (undocumented)
    errorLogPath: string;
    // (undocumented)
    logChunksPath: string;
    // (undocumented)
    logPath: string;
}

// @internal (undocumented)
export interface _IOperationMetadataManagerOptions {
    // (undocumented)
    operation: Operation;
    // (undocumented)
    phase: IPhase;
    // (undocumented)
    rushProject: RushConfigurationProject;
}

// @alpha
export interface IOperationOptions {
    logFilenameIdentifier: string;
    phase?: IPhase | undefined;
    project?: RushConfigurationProject | undefined;
    runner?: IOperationRunner | undefined;
    settings?: IOperationSettings | undefined;
}

// @beta
export interface IOperationRunner {
    cacheable: boolean;
    executeAsync(context: IOperationRunnerContext): Promise<OperationStatus>;
    getConfigHash(): string;
    readonly isNoOp?: boolean;
    readonly name: string;
    reportTiming: boolean;
    silent: boolean;
    warningsAreAllowed: boolean;
}

// @beta
export interface IOperationRunnerContext {
    collatedWriter: CollatedWriter;
    debugMode: boolean;
    error?: Error;
    // @internal
    _operationMetadataManager?: _OperationMetadataManager;
    quietMode: boolean;
    runWithTerminalAsync<T>(callback: (terminal: ITerminal, terminalProvider: ITerminalProvider) => Promise<T>, options: {
        createLogFile: boolean;
        logFileSuffix?: string;
    }): Promise<T>;
    status: OperationStatus;
    stopwatch: IStopwatchResult;
}

// @alpha (undocumented)
export interface IOperationSettings {
    allowCobuildWithoutCache?: boolean;
    dependsOnAdditionalFiles?: string[];
    dependsOnEnvVars?: string[];
    disableBuildCacheForOperation?: boolean;
    operationName: string;
    outputFolderNames?: string[];
    sharding?: IRushPhaseSharding;
    weight?: number;
}

// @internal (undocumented)
export interface _IOperationStateFileOptions {
    // (undocumented)
    metadataFolder: string;
    // (undocumented)
    projectFolder: string;
}

// @internal (undocumented)
export interface _IOperationStateJson {
    // (undocumented)
    cobuildContextId: string | undefined;
    // (undocumented)
    cobuildRunnerId: string | undefined;
    // (undocumented)
    nonCachedDurationMs: number;
}

// @public
export interface IPackageManagerOptionsJsonBase {
    environmentVariables?: IConfigurationEnvironment;
}

// @alpha
export interface IPhase {
    allowWarningsOnSuccess: boolean;
    associatedParameters: Set<CommandLineParameter>;
    dependencies: {
        self: Set<IPhase>;
        upstream: Set<IPhase>;
    };
    isSynthetic: boolean;
    logFilenameIdentifier: string;
    missingScriptBehavior: IPhaseBehaviorForMissingScript;
    name: string;
    shellCommand?: string;
}

// @alpha
export type IPhaseBehaviorForMissingScript = 'silent' | 'log' | 'error';

// @beta
export interface IPhasedCommand extends IRushCommand {
    // @alpha
    readonly hooks: PhasedCommandHooks;
}

// @public
export interface IPnpmLockfilePolicies {
    disallowInsecureSha1?: {
        enabled: boolean;
        exemptPackageVersions: Record<string, string[]>;
    };
}

// @internal
export interface _IPnpmOptionsJson extends IPackageManagerOptionsJsonBase {
    alwaysFullInstall?: boolean;
    alwaysInjectDependenciesFromOtherSubspaces?: boolean;
    autoInstallPeers?: boolean;
    globalAllowedDeprecatedVersions?: Record<string, string>;
    globalIgnoredOptionalDependencies?: string[];
    globalNeverBuiltDependencies?: string[];
    globalOverrides?: Record<string, string>;
    globalPackageExtensions?: Record<string, IPnpmPackageExtension>;
    globalPatchedDependencies?: Record<string, string>;
    globalPeerDependencyRules?: IPnpmPeerDependencyRules;
    pnpmLockfilePolicies?: IPnpmLockfilePolicies;
    pnpmStore?: PnpmStoreLocation;
    preventManualShrinkwrapChanges?: boolean;
    resolutionMode?: PnpmResolutionMode;
    strictPeerDependencies?: boolean;
    unsupportedPackageJsonSettings?: unknown;
    useWorkspaces?: boolean;
}

// @public (undocumented)
export interface IPnpmPackageExtension {
    // (undocumented)
    dependencies?: Record<string, string>;
    // (undocumented)
    optionalDependencies?: Record<string, string>;
    // (undocumented)
    peerDependencies?: Record<string, string>;
    // (undocumented)
    peerDependenciesMeta?: IPnpmPeerDependenciesMeta;
}

// @public (undocumented)
export interface IPnpmPeerDependenciesMeta {
    // (undocumented)
    [packageName: string]: {
        optional?: boolean;
    };
}

// @public (undocumented)
export interface IPnpmPeerDependencyRules {
    // (undocumented)
    allowAny?: string[];
    // (undocumented)
    allowedVersions?: Record<string, string>;
    // (undocumented)
    ignoreMissing?: string[];
}

export { IPrefixMatch }

// @beta
export interface IRushCommand {
    readonly actionName: string;
}

// @beta
export interface IRushCommandLineAction {
    // (undocumented)
    actionName: string;
    // (undocumented)
    parameters: IRushCommandLineParameter[];
}

// @beta
export interface IRushCommandLineParameter {
    readonly description: string;
    readonly environmentVariable?: string;
    readonly kind: keyof typeof CommandLineParameterKind;
    readonly longName: string;
    readonly required?: boolean;
    readonly shortName?: string;
}

// @beta
export interface IRushCommandLineSpec {
    // (undocumented)
    actions: IRushCommandLineAction[];
}

// @beta (undocumented)
export type IRushConfigurationProjectForSnapshot = Pick<RushConfigurationProject, 'projectFolder' | 'projectRelativeFolder'>;

// @alpha (undocumented)
export interface IRushPhaseSharding {
    count: number;
    outputFolderArgumentFormat?: string;
    shardArgumentFormat?: string;
    // @deprecated (undocumented)
    shardOperationSettings?: unknown;
}

// @beta (undocumented)
export interface IRushPlugin {
    // (undocumented)
    apply(rushSession: RushSession, rushConfiguration: RushConfiguration): void;
}

// @internal (undocumented)
export interface _IRushPluginConfigurationBase {
    // (undocumented)
    packageName: string;
    // (undocumented)
    pluginName: string;
}

// @internal
export interface _IRushProjectJson {
    disableBuildCacheForProject?: boolean;
    incrementalBuildIgnoredGlobs?: string[];
    // (undocumented)
    operationSettings?: IOperationSettings[];
}

// @beta (undocumented)
export interface IRushSessionOptions {
    // (undocumented)
    getIsDebugMode: () => boolean;
    // (undocumented)
    terminalProvider: ITerminalProvider;
}

// @beta
export interface IStopwatchResult {
    get duration(): number;
    get endTime(): number | undefined;
    get startTime(): number | undefined;
    toString(): string;
}

// @beta (undocumented)
export interface ITelemetryData {
    readonly durationInSeconds: number;
    // (undocumented)
    readonly extraData?: {
        [key: string]: string | number | boolean;
    };
    readonly machineInfo?: ITelemetryMachineInfo;
    readonly name: string;
    readonly operationResults?: Record<string, ITelemetryOperationResult>;
    readonly platform?: string;
    readonly result: 'Succeeded' | 'Failed';
    readonly rushVersion?: string;
    readonly timestampMs?: number;
}

// @beta (undocumented)
export interface ITelemetryMachineInfo {
    machineArchitecture: string;
    machineCores: number;
    machineCpu: string;
    machineFreeMemoryMiB: number;
    machineTotalMemoryMiB: number;
}

// @beta (undocumented)
export interface ITelemetryOperationResult {
    dependencies: string[];
    endTimestampMs?: number;
    nonCachedDurationMs?: number;
    result: string;
    startTimestampMs?: number;
    wasExecutedOnThisMachine?: boolean;
}

// @public
export interface ITryFindRushJsonLocationOptions {
    showVerbose?: boolean;
    startingFolder?: string;
}

// @internal
export interface _IYarnOptionsJson extends IPackageManagerOptionsJsonBase {
    ignoreEngines?: boolean;
}

// @public
export class LockStepVersionPolicy extends VersionPolicy {
    // Warning: (ae-forgotten-export) The symbol "ILockStepVersionJson" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(versionPolicyJson: ILockStepVersionJson);
    bump(bumpType?: BumpType, identifier?: string): void;
    ensure(project: IPackageJson, force?: boolean): IPackageJson | undefined;
    // @internal
    get _json(): ILockStepVersionJson;
    readonly mainProject: string | undefined;
    readonly nextBump: BumpType | undefined;
    update(newVersionString: string): boolean;
    validate(versionString: string, packageName: string): void;
    get version(): string;
}

export { LookupByPath }

// @public
export class NpmOptionsConfiguration extends PackageManagerOptionsConfigurationBase {
    // @internal
    constructor(json: _INpmOptionsJson);
}

// @alpha
export class Operation {
    constructor(options: IOperationOptions);
    addDependency(dependency: Operation): void;
    readonly associatedPhase: IPhase | undefined;
    readonly associatedProject: RushConfigurationProject | undefined;
    readonly consumers: ReadonlySet<Operation>;
    deleteDependency(dependency: Operation): void;
    readonly dependencies: ReadonlySet<Operation>;
    enabled: boolean;
    get isNoOp(): boolean;
    logFilenameIdentifier: string;
    get name(): string | undefined;
    runner: IOperationRunner | undefined;
    settings: IOperationSettings | undefined;
    weight: number;
}

// @internal
export class _OperationMetadataManager {
    constructor(options: _IOperationMetadataManagerOptions);
    // (undocumented)
    readonly logFilenameIdentifier: string;
    get metadataFolderPath(): string;
    // (undocumented)
    saveAsync({ durationInSeconds, cobuildContextId, cobuildRunnerId, logPath, errorLogPath, logChunksPath }: _IOperationMetadata): Promise<void>;
    // (undocumented)
    readonly stateFile: _OperationStateFile;
    // (undocumented)
    tryRestoreAsync({ terminal, terminalProvider, errorLogPath }: {
        terminalProvider: ITerminalProvider;
        terminal: ITerminal;
        errorLogPath: string;
    }): Promise<void>;
}

// @internal
export class _OperationStateFile {
    constructor(options: _IOperationStateFileOptions);
    // (undocumented)
    static filename: string;
    readonly filepath: string;
    readonly relativeFilepath: string;
    // (undocumented)
    get state(): _IOperationStateJson | undefined;
    // (undocumented)
    tryRestoreAsync(): Promise<_IOperationStateJson | undefined>;
    // (undocumented)
    writeAsync(json: _IOperationStateJson): Promise<void>;
}

// @beta
export enum OperationStatus {
    Blocked = "BLOCKED",
    Executing = "EXECUTING",
    Failure = "FAILURE",
    FromCache = "FROM CACHE",
    NoOp = "NO OP",
    Queued = "QUEUED",
    Ready = "READY",
    Skipped = "SKIPPED",
    Success = "SUCCESS",
    SuccessWithWarning = "SUCCESS WITH WARNINGS",
    Waiting = "WAITING"
}

// @public (undocumented)
export class PackageJsonDependency {
    constructor(name: string, version: string, type: DependencyType, onChange: () => void);
    // (undocumented)
    readonly dependencyType: DependencyType;
    // (undocumented)
    readonly name: string;
    // (undocumented)
    setVersion(newVersion: string): void;
    // (undocumented)
    get version(): string;
}

// @public (undocumented)
export class PackageJsonDependencyMeta {
    constructor(name: string, injected: boolean, onChange: () => void);
    // (undocumented)
    get injected(): boolean;
    // (undocumented)
    readonly name: string;
}

// @public (undocumented)
export class PackageJsonEditor {
    // @internal
    protected constructor(filepath: string, data: IPackageJson);
    // (undocumented)
    addOrUpdateDependency(packageName: string, newVersion: string, dependencyType: DependencyType): void;
    get dependencyList(): ReadonlyArray<PackageJsonDependency>;
    get dependencyMetaList(): ReadonlyArray<PackageJsonDependencyMeta>;
    get devDependencyList(): ReadonlyArray<PackageJsonDependency>;
    // (undocumented)
    readonly filePath: string;
    // (undocumented)
    static fromObject(object: IPackageJson, filename: string): PackageJsonEditor;
    // (undocumented)
    static load(filePath: string): PackageJsonEditor;
    // (undocumented)
    get name(): string;
    // (undocumented)
    removeDependency(packageName: string, dependencyType: DependencyType): void;
    get resolutionsList(): ReadonlyArray<PackageJsonDependency>;
    // (undocumented)
    saveIfModified(): boolean;
    saveToObject(): IPackageJson;
    // (undocumented)
    tryGetDependency(packageName: string): PackageJsonDependency | undefined;
    // (undocumented)
    tryGetDevDependency(packageName: string): PackageJsonDependency | undefined;
    // (undocumented)
    get version(): string;
}

// @public
export abstract class PackageManager {
    // @internal
    protected constructor(version: string, packageManager: PackageManagerName, shrinkwrapFilename: string);
    readonly packageManager: PackageManagerName;
    readonly shrinkwrapFilename: string;
    readonly version: string;
}

// @public
export type PackageManagerName = 'pnpm' | 'npm' | 'yarn';

// @public
export abstract class PackageManagerOptionsConfigurationBase implements IPackageManagerOptionsJsonBase {
    // @internal
    protected constructor(json: IPackageManagerOptionsJsonBase);
    readonly environmentVariables?: IConfigurationEnvironment;
}

// @alpha
export class PhasedCommandHooks {
    readonly afterExecuteOperation: AsyncSeriesHook<[
    IOperationRunnerContext & IOperationExecutionResult
    ]>;
    readonly afterExecuteOperations: AsyncSeriesHook<[IExecutionResult, IExecuteOperationsContext]>;
    readonly beforeExecuteOperation: AsyncSeriesBailHook<[
    IOperationRunnerContext & IOperationExecutionResult
    ], OperationStatus | undefined>;
    readonly beforeExecuteOperations: AsyncSeriesHook<[
    Map<Operation, IOperationExecutionResult>,
    IExecuteOperationsContext
    ]>;
    readonly beforeLog: SyncHook<ITelemetryData, void>;
    readonly createOperations: AsyncSeriesWaterfallHook<[Set<Operation>, ICreateOperationsContext]>;
    readonly onOperationStatusChanged: SyncHook<[IOperationExecutionResult]>;
    readonly shutdownAsync: AsyncParallelHook<void>;
    readonly waitingForChanges: SyncHook<void>;
}

// @public
export class PnpmOptionsConfiguration extends PackageManagerOptionsConfigurationBase {
    readonly alwaysFullInstall: boolean | undefined;
    readonly alwaysInjectDependenciesFromOtherSubspaces: boolean | undefined;
    readonly autoInstallPeers: boolean | undefined;
    readonly globalAllowedDeprecatedVersions: Record<string, string> | undefined;
    readonly globalIgnoredOptionalDependencies: string[] | undefined;
    readonly globalNeverBuiltDependencies: string[] | undefined;
    readonly globalOverrides: Record<string, string> | undefined;
    readonly globalPackageExtensions: Record<string, IPnpmPackageExtension> | undefined;
    get globalPatchedDependencies(): Record<string, string> | undefined;
    readonly globalPeerDependencyRules: IPnpmPeerDependencyRules | undefined;
    // (undocumented)
    readonly jsonFilename: string | undefined;
    // @internal (undocumented)
    static loadFromJsonFileOrThrow(jsonFilename: string, commonTempFolder: string): PnpmOptionsConfiguration;
    // @internal (undocumented)
    static loadFromJsonObject(json: _IPnpmOptionsJson, commonTempFolder: string): PnpmOptionsConfiguration;
    readonly pnpmLockfilePolicies: IPnpmLockfilePolicies | undefined;
    readonly pnpmStore: PnpmStoreLocation;
    readonly pnpmStorePath: string;
    readonly preventManualShrinkwrapChanges: boolean;
    readonly resolutionMode: PnpmResolutionMode | undefined;
    readonly strictPeerDependencies: boolean;
    readonly unsupportedPackageJsonSettings: unknown | undefined;
    updateGlobalPatchedDependencies(patchedDependencies: Record<string, string> | undefined): void;
    readonly useWorkspaces: boolean;
}

// @public
export type PnpmResolutionMode = 'highest' | 'time-based' | 'lowest-direct';

// @public
export type PnpmStoreLocation = 'local' | 'global';

// @public @deprecated (undocumented)
export type PnpmStoreOptions = PnpmStoreLocation;

// @beta (undocumented)
export class ProjectChangeAnalyzer {
    constructor(rushConfiguration: RushConfiguration);
    // @internal (undocumented)
    _filterProjectDataAsync<T>(project: RushConfigurationProject, unfilteredProjectData: Map<string, T>, rootDir: string, terminal: ITerminal): Promise<Map<string, T>>;
    getChangedProjectsAsync(options: IGetChangedProjectsOptions): Promise<Set<RushConfigurationProject>>;
    // (undocumented)
    protected getChangesByProject(lookup: LookupByPath<RushConfigurationProject>, changedFiles: Map<string, IFileDiffStatus>): Map<RushConfigurationProject, Map<string, IFileDiffStatus>>;
    // @internal
    _tryGetSnapshotProviderAsync(projectConfigurations: ReadonlyMap<RushConfigurationProject, RushProjectConfiguration>, terminal: ITerminal, projectSelection?: ReadonlySet<RushConfigurationProject>): Promise<GetInputsSnapshotAsyncFn | undefined>;
}

// @public
export class RepoStateFile {
    readonly filePath: string;
    get isValid(): boolean;
    static loadFromFile(jsonFilename: string): RepoStateFile;
    get packageJsonInjectedDependenciesHash(): string | undefined;
    get pnpmShrinkwrapHash(): string | undefined;
    get preferredVersionsHash(): string | undefined;
    refreshState(rushConfiguration: RushConfiguration, subspace: Subspace | undefined, variant?: string): boolean;
}

// @public
export class Rush {
    static launch(launcherVersion: string, options: ILaunchOptions): void;
    static launchRushPnpm(launcherVersion: string, options: ILaunchOptions): void;
    static launchRushX(launcherVersion: string, options: ILaunchOptions): void;
    // (undocumented)
    static get _rushLibPackageFolder(): string;
    // @internal (undocumented)
    static get _rushLibPackageJson(): IPackageJson;
    static get version(): string;
}

// @beta
export class RushCommandLine {
    // (undocumented)
    static getCliSpec(rushJsonFolder: string): IRushCommandLineSpec;
}

// @public
export class RushConfiguration {
    readonly allowMostlyStandardPackageNames: boolean;
    readonly approvedPackagesPolicy: ApprovedPackagesPolicy;
    readonly changesFolder: string;
    get commonAutoinstallersFolder(): string;
    readonly commonFolder: string;
    readonly commonRushConfigFolder: string;
    readonly commonScriptsFolder: string;
    readonly commonTempFolder: string;
    // @deprecated
    get commonVersions(): CommonVersionsConfiguration;
    readonly currentVariantJsonFilePath: string;
    // Warning: (ae-forgotten-export) The symbol "ICurrentVariantJson" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    _currentVariantJsonLoadingPromise: Promise<ICurrentVariantJson | undefined> | undefined;
    // @beta
    readonly customTipsConfiguration: CustomTipsConfiguration;
    // @beta
    readonly customTipsConfigurationFilePath: string;
    // @beta (undocumented)
    get defaultSubspace(): Subspace;
    // @deprecated
    readonly ensureConsistentVersions: boolean;
    // @internal
    readonly _ensureConsistentVersionsJsonValue: boolean | undefined;
    // @beta
    readonly eventHooks: EventHooks;
    // @beta
    readonly experimentsConfiguration: ExperimentsConfiguration;
    findProjectByShorthandName(shorthandProjectName: string): RushConfigurationProject | undefined;
    findProjectByTempName(tempProjectName: string): RushConfigurationProject | undefined;
    // @deprecated (undocumented)
    getCommittedShrinkwrapFilename(subspace?: Subspace, variant?: string): string;
    // @deprecated (undocumented)
    getCommonVersions(subspace?: Subspace, variant?: string): CommonVersionsConfiguration;
    // @deprecated (undocumented)
    getCommonVersionsFilePath(subspace?: Subspace, variant?: string): string;
    getCurrentlyInstalledVariantAsync(): Promise<string | undefined>;
    getImplicitlyPreferredVersions(subspace?: Subspace, variant?: string): Map<string, string>;
    // @deprecated (undocumented)
    getPnpmfilePath(subspace?: Subspace, variant?: string): string;
    getProjectByName(projectName: string): RushConfigurationProject | undefined;
    // @beta (undocumented)
    getProjectLookupForRoot(rootPath: string): LookupByPath<RushConfigurationProject>;
    // @deprecated (undocumented)
    getRepoState(subspace?: Subspace): RepoStateFile;
    // @deprecated (undocumented)
    getRepoStateFilePath(subspace?: Subspace): string;
    // @beta (undocumented)
    getSubspace(subspaceName: string): Subspace;
    // @beta
    getSubspacesForProjects(projects: Iterable<RushConfigurationProject>): ReadonlySet<Subspace>;
    readonly gitAllowedEmailRegExps: string[];
    readonly gitChangefilesCommitMessage: string | undefined;
    readonly gitChangeLogUpdateCommitMessage: string | undefined;
    readonly gitSampleEmail: string;
    readonly gitTagSeparator: string | undefined;
    readonly gitVersionBumpCommitMessage: string | undefined;
    readonly hotfixChangeEnabled: boolean;
    readonly isPnpm: boolean;
    static loadFromConfigurationFile(rushJsonFilename: string): RushConfiguration;
    // (undocumented)
    static loadFromDefaultLocation(options?: ITryFindRushJsonLocationOptions): RushConfiguration;
    readonly npmCacheFolder: string;
    readonly npmOptions: NpmOptionsConfiguration;
    readonly npmTmpFolder: string;
    readonly packageManager: PackageManagerName;
    readonly packageManagerOptions: PackageManagerOptionsConfigurationBase;
    readonly packageManagerToolFilename: string;
    readonly packageManagerToolVersion: string;
    // @beta
    readonly packageManagerWrapper: PackageManager;
    readonly packageNameParser: PackageNameParser;
    readonly pnpmOptions: PnpmOptionsConfiguration;
    readonly projectFolderMaxDepth: number;
    readonly projectFolderMinDepth: number;
    // (undocumented)
    get projects(): RushConfigurationProject[];
    // @beta (undocumented)
    get projectsByName(): ReadonlyMap<string, RushConfigurationProject>;
    // @beta
    get projectsByTag(): ReadonlyMap<string, ReadonlySet<RushConfigurationProject>>;
    readonly repositoryDefaultBranch: string;
    get repositoryDefaultFullyQualifiedRemoteBranch(): string;
    readonly repositoryDefaultRemote: string;
    readonly repositoryUrls: string[];
    // @internal
    readonly rushConfigurationJson: IRushConfigurationJson;
    readonly rushJsonFile: string;
    readonly rushJsonFolder: string;
    // @deprecated
    get rushLinkJsonFilename(): string;
    get rushPluginOptionsFolder(): string;
    // Warning: (ae-forgotten-export) The symbol "RushPluginsConfiguration" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    readonly _rushPluginsConfiguration: RushPluginsConfiguration;
    readonly shrinkwrapFilename: string;
    get shrinkwrapFilePhrase(): string;
    // @beta
    get subspaces(): readonly Subspace[];
    // @beta
    readonly subspacesConfiguration: SubspacesConfiguration | undefined;
    readonly subspacesFeatureEnabled: boolean;
    readonly suppressNodeLtsWarning: boolean;
    // @beta
    readonly telemetryEnabled: boolean;
    // @deprecated
    get tempShrinkwrapFilename(): string;
    // @deprecated
    get tempShrinkwrapPreinstallFilename(): string;
    static tryFindRushJsonLocation(options?: ITryFindRushJsonLocationOptions): string | undefined;
    tryGetProjectForPath(currentFolderPath: string): RushConfigurationProject | undefined;
    // @beta (undocumented)
    tryGetSubspace(subspaceName: string): Subspace | undefined;
    // (undocumented)
    static tryLoadFromDefaultLocation(options?: ITryFindRushJsonLocationOptions): RushConfiguration | undefined;
    // @beta
    readonly variants: ReadonlySet<string>;
    // @beta (undocumented)
    readonly versionPolicyConfiguration: VersionPolicyConfiguration;
    // @beta (undocumented)
    readonly versionPolicyConfigurationFilePath: string;
    readonly yarnCacheFolder: string;
    readonly yarnOptions: YarnOptionsConfiguration;
}

// @public
export class RushConfigurationProject {
    // Warning: (ae-forgotten-export) The symbol "IRushConfigurationProjectOptions" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(options: IRushConfigurationProjectOptions);
    // @beta
    readonly configuredSubspaceName: string | undefined;
    get consumingProjects(): ReadonlySet<RushConfigurationProject>;
    // @deprecated
    get cyclicDependencyProjects(): Set<string>;
    readonly decoupledLocalDependencies: Set<string>;
    get dependencyProjects(): ReadonlySet<RushConfigurationProject>;
    // @deprecated
    get downstreamDependencyProjects(): string[];
    // @beta
    get isMainProject(): boolean;
    // @deprecated
    get localDependencyProjects(): ReadonlyArray<RushConfigurationProject>;
    get packageJson(): IPackageJson;
    // @beta
    readonly packageJsonEditor: PackageJsonEditor;
    readonly packageName: string;
    readonly projectFolder: string;
    readonly projectRelativeFolder: string;
    readonly projectRushConfigFolder: string;
    readonly projectRushTempFolder: string;
    readonly publishFolder: string;
    readonly reviewCategory: string | undefined;
    readonly rushConfiguration: RushConfiguration;
    get shouldPublish(): boolean;
    readonly skipRushCheck: boolean;
    readonly subspace: Subspace;
    // @beta
    readonly tags: ReadonlySet<string>;
    readonly tempProjectName: string;
    readonly unscopedTempProjectName: string;
    // @beta
    get versionPolicy(): VersionPolicy | undefined;
    // @beta
    readonly versionPolicyName: string | undefined;
}

// @beta
export class RushConstants {
    static readonly artifactoryFilename: 'artifactory.json';
    static readonly browserApprovedPackagesFilename: 'browser-approved-packages.json';
    static readonly buildCacheFilename: 'build-cache.json';
    static readonly buildCacheVersion: 1;
    static readonly buildCommandName: 'build';
    static readonly bulkCommandKind: 'bulk';
    static readonly bypassPolicyFlagLongName: '--bypass-policy';
    static readonly changeFilesFolderName: 'changes';
    static readonly cobuildFilename: 'cobuild.json';
    static readonly commandLineFilename: 'command-line.json';
    static readonly commonFolderName: 'common';
    static readonly commonVersionsFilename: 'common-versions.json';
    static readonly currentVariantsFilename: 'current-variants.json';
    static readonly customTipsFilename: 'custom-tips.json';
    static readonly defaultMaxInstallAttempts: 1;
    static readonly defaultSubspaceName: 'default';
    static readonly defaultWatchDebounceMs: 1000;
    static readonly experimentsFilename: 'experiments.json';
    static readonly globalCommandKind: 'global';
    static readonly hashDelimiter: '|';
    static readonly lastLinkFlagFilename: 'last-link';
    static readonly mergeQueueIgnoreFileName: '.mergequeueignore';
    static readonly nodeModulesFolderName: 'node_modules';
    static readonly nonbrowserApprovedPackagesFilename: 'nonbrowser-approved-packages.json';
    static readonly npmShrinkwrapFilename: 'npm-shrinkwrap.json';
    static readonly phasedCommandKind: 'phased';
    static readonly phaseNamePrefix: '_phase:';
    // @deprecated
    static readonly pinnedVersionsFilename: 'pinned-versions.json';
    static readonly pnpmConfigFilename: 'pnpm-config.json';
    static readonly pnpmfileGlobalFilename: 'global-pnpmfile.cjs';
    static readonly pnpmfileV1Filename: 'pnpmfile.js';
    static readonly pnpmfileV6Filename: '.pnpmfile.cjs';
    static readonly pnpmModulesFilename: '.modules.yaml';
    static readonly pnpmPatchesCommonFolderName: `pnpm-patches`;
    static readonly pnpmPatchesFolderName: 'patches';
    static readonly pnpmV3ShrinkwrapFilename: 'pnpm-lock.yaml';
    static readonly projectImpactGraphFilename: 'project-impact-graph.yaml';
    static readonly projectRushFolderName: '.rush';
    static readonly projectShrinkwrapFilename: 'shrinkwrap-deps.json';
    static readonly rebuildCommandName: 'rebuild';
    static readonly repoStateFilename: 'repo-state.json';
    static readonly rushAlertsConfigFilename: 'rush-alerts.json';
    static readonly rushAlertsStateFilename: 'rush-alerts-state.json';
    static readonly rushJsonFilename: 'rush.json';
    static readonly rushLogsFolderName: 'rush-logs';
    static readonly rushPackageName: '@microsoft/rush';
    static readonly rushPluginManifestFilename: 'rush-plugin-manifest.json';
    static readonly rushPluginsConfigFilename: 'rush-plugins.json';
    static readonly rushProjectConfigFilename: 'rush-project.json';
    static readonly rushRecyclerFolderName: 'rush-recycler';
    static readonly rushTempFolderName: 'temp';
    static readonly rushTempNpmScope: '@rush-temp';
    static readonly rushTempProjectsFolderName: 'projects';
    static readonly rushUserConfigurationFolderName: '.rush-user';
    static readonly rushVariantsFolderName: 'variants';
    static readonly rushWebSiteUrl: 'https://rushjs.io';
    static readonly subspacesConfigFilename: 'subspaces.json';
    // (undocumented)
    static readonly updateCloudCredentialsCommandName: 'update-cloud-credentials';
    // (undocumented)
    static readonly versionPoliciesFilename: 'version-policies.json';
    static readonly yarnShrinkwrapFilename: 'yarn.lock';
}

// @internal
export class _RushGlobalFolder {
    constructor();
    readonly nodeSpecificPath: string;
    readonly path: string;
}

// @internal
export class _RushInternals {
    static loadModule(srcImportPath: string): unknown;
}

// @beta
export class RushLifecycleHooks {
    readonly afterInstall: AsyncSeriesHook<[
    command: IRushCommand,
    subspace: Subspace,
    variant: string | undefined
    ]>;
    readonly beforeInstall: AsyncSeriesHook<[
    command: IGlobalCommand,
    subspace: Subspace,
    variant: string | undefined
    ]>;
    readonly flushTelemetry: AsyncParallelHook<[ReadonlyArray<ITelemetryData>]>;
    readonly initialize: AsyncSeriesHook<IRushCommand>;
    readonly runAnyGlobalCustomCommand: AsyncSeriesHook<IGlobalCommand>;
    readonly runAnyPhasedCommand: AsyncSeriesHook<IPhasedCommand>;
    readonly runGlobalCustomCommand: HookMap<AsyncSeriesHook<IGlobalCommand>>;
    readonly runPhasedCommand: HookMap<AsyncSeriesHook<IPhasedCommand>>;
}

// @alpha
export class RushProjectConfiguration {
    readonly disableBuildCacheForProject: boolean;
    getCacheDisabledReason(trackedFileNames: Iterable<string>, phaseName: string, isNoOp: boolean): string | undefined;
    static getCacheDisabledReasonForProject(options: {
        projectConfiguration: RushProjectConfiguration | undefined;
        trackedFileNames: Iterable<string>;
        phaseName: string;
        isNoOp: boolean;
    }): string | undefined;
    readonly incrementalBuildIgnoredGlobs: ReadonlyArray<string>;
    // (undocumented)
    readonly operationSettingsByOperationName: ReadonlyMap<string, Readonly<IOperationSettings>>;
    // (undocumented)
    readonly project: RushConfigurationProject;
    static tryLoadForProjectAsync(project: RushConfigurationProject, terminal: ITerminal): Promise<RushProjectConfiguration | undefined>;
    static tryLoadForProjectsAsync(projects: Iterable<RushConfigurationProject>, terminal: ITerminal): Promise<ReadonlyMap<RushConfigurationProject, RushProjectConfiguration>>;
    static tryLoadIgnoreGlobsForProjectAsync(project: RushConfigurationProject, terminal: ITerminal): Promise<ReadonlyArray<string> | undefined>;
    validatePhaseConfiguration(phases: Iterable<IPhase>, terminal: ITerminal): void;
}

// @beta (undocumented)
export class RushSession {
    constructor(options: IRushSessionOptions);
    // (undocumented)
    getCloudBuildCacheProviderFactory(cacheProviderName: string): CloudBuildCacheProviderFactory | undefined;
    // (undocumented)
    getCobuildLockProviderFactory(cobuildLockProviderName: string): CobuildLockProviderFactory | undefined;
    // (undocumented)
    getLogger(name: string): ILogger;
    // (undocumented)
    readonly hooks: RushLifecycleHooks;
    // (undocumented)
    registerCloudBuildCacheProviderFactory(cacheProviderName: string, factory: CloudBuildCacheProviderFactory): void;
    // (undocumented)
    registerCobuildLockProviderFactory(cobuildLockProviderName: string, factory: CobuildLockProviderFactory): void;
    // (undocumented)
    get terminalProvider(): ITerminalProvider;
}

// @beta
export class RushUserConfiguration {
    readonly buildCacheFolder: string | undefined;
    // (undocumented)
    static getRushUserFolderPath(): string;
    // (undocumented)
    static initializeAsync(): Promise<RushUserConfiguration>;
}

// @public
export class Subspace {
    // Warning: (ae-forgotten-export) The symbol "ISubspaceOptions" needs to be exported by the entry point index.d.ts
    constructor(options: ISubspaceOptions);
    // @internal (undocumented)
    _addProject(project: RushConfigurationProject): void;
    // @beta
    contains(project: RushConfigurationProject): boolean;
    // @deprecated (undocumented)
    getCommittedShrinkwrapFilename(): string;
    // @beta
    getCommittedShrinkwrapFilePath(variant?: string): string;
    // @beta
    getCommonVersions(variant?: string): CommonVersionsConfiguration;
    // @beta
    getCommonVersionsFilePath(variant?: string): string;
    // @beta
    getPackageJsonInjectedDependenciesHash(variant?: string): string | undefined;
    // @beta
    getPnpmConfigFilePath(): string;
    // @beta
    getPnpmfilePath(variant?: string): string;
    // @beta
    getPnpmOptions(): PnpmOptionsConfiguration | undefined;
    // @beta
    getProjects(): RushConfigurationProject[];
    // @beta
    getRepoState(): RepoStateFile;
    // @beta
    getRepoStateFilePath(): string;
    // @beta
    getSubspaceConfigFolderPath(): string;
    // @beta
    getSubspacePnpmPatchesFolderPath(): string;
    // @beta
    getSubspaceTempFolderPath(): string;
    // @beta
    getTempShrinkwrapFilename(): string;
    // @deprecated (undocumented)
    getTempShrinkwrapPreinstallFilename(subspaceName?: string | undefined): string;
    // @beta
    getTempShrinkwrapPreinstallFilePath(): string;
    // @beta
    getVariantDependentSubspaceConfigFolderPath(variant: string | undefined): string;
    // @beta
    shouldEnsureConsistentVersions(variant?: string): boolean;
    // (undocumented)
    readonly subspaceName: string;
}

// @beta
export class SubspacesConfiguration {
    static explainIfInvalidSubspaceName(subspaceName: string, splitWorkspaceCompatibility?: boolean): string | undefined;
    readonly preventSelectingAllSubspaces: boolean;
    static requireValidSubspaceName(subspaceName: string, splitWorkspaceCompatibility?: boolean): void;
    readonly splitWorkspaceCompatibility: boolean;
    readonly subspaceJsonFilePath: string;
    readonly subspaceNames: ReadonlySet<string>;
    // (undocumented)
    readonly subspacesEnabled: boolean;
    // (undocumented)
    static tryLoadFromConfigurationFile(subspaceJsonFilePath: string): SubspacesConfiguration | undefined;
    // (undocumented)
    static tryLoadFromDefaultLocation(rushConfiguration: RushConfiguration): SubspacesConfiguration | undefined;
}

// @public
export abstract class VersionPolicy {
    // Warning: (ae-forgotten-export) The symbol "IVersionPolicyJson" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(versionPolicyJson: IVersionPolicyJson);
    abstract bump(bumpType?: BumpType, identifier?: string): void;
    readonly definitionName: VersionPolicyDefinitionName;
    abstract ensure(project: IPackageJson, force?: boolean): IPackageJson | undefined;
    readonly exemptFromRushChange: boolean;
    readonly includeEmailInChangeFile: boolean;
    get isLockstepped(): boolean;
    // @internal
    abstract get _json(): IVersionPolicyJson;
    // @internal
    static load(versionPolicyJson: IVersionPolicyJson): VersionPolicy | undefined;
    readonly policyName: string;
    setDependenciesBeforeCommit(packageName: string, configuration: RushConfiguration): void;
    setDependenciesBeforePublish(packageName: string, configuration: RushConfiguration): void;
    abstract validate(versionString: string, packageName: string): void;
}

// @public
export class VersionPolicyConfiguration {
    // @internal
    constructor(jsonFileName: string);
    bump(versionPolicyName?: string, bumpType?: BumpType, identifier?: string, shouldCommit?: boolean): void;
    getVersionPolicy(policyName: string): VersionPolicy;
    update(versionPolicyName: string, newVersion: string, shouldCommit?: boolean): void;
    validate(projectsByName: ReadonlyMap<string, RushConfigurationProject>): void;
    readonly versionPolicies: Map<string, VersionPolicy>;
}

// @public
export enum VersionPolicyDefinitionName {
    // (undocumented)
    'individualVersion' = 1,
    // (undocumented)
    'lockStepVersion' = 0
}

// @public
export class YarnOptionsConfiguration extends PackageManagerOptionsConfigurationBase {
    // @internal
    constructor(json: _IYarnOptionsJson);
    readonly ignoreEngines: boolean;
}

```
