## API Report File for "@rushstack/rush-azure-storage-build-cache-plugin"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { AzureAuthorityHosts } from '@azure/identity';
import { CredentialCache } from '@rushstack/rush-sdk';
import { DeviceCodeCredentialOptions } from '@azure/identity';
import type { ICredentialCacheEntry } from '@rushstack/rush-sdk';
import { InteractiveBrowserCredentialNodeOptions } from '@azure/identity';
import type { IRushPlugin } from '@rushstack/rush-sdk';
import type { ITerminal } from '@rushstack/terminal';
import type { RushConfiguration } from '@rushstack/rush-sdk';
import type { RushSession } from '@rushstack/rush-sdk';
import { TokenCredential } from '@azure/identity';

// @public (undocumented)
export abstract class AzureAuthenticationBase {
    constructor(options: IAzureAuthenticationBaseOptions);
    // (undocumented)
    protected readonly _additionalDeviceCodeCredentialOptions: DeviceCodeCredentialOptions | undefined;
    // (undocumented)
    protected readonly _additionalInteractiveCredentialOptions: InteractiveBrowserCredentialNodeOptions | undefined;
    // (undocumented)
    protected readonly _azureEnvironment: AzureEnvironmentName;
    // (undocumented)
    protected get _credentialCacheId(): string;
    // (undocumented)
    protected abstract readonly _credentialKindForLogging: string;
    // (undocumented)
    protected abstract readonly _credentialNameForCache: string;
    // (undocumented)
    protected readonly _credentialUpdateCommandForLogging: string | undefined;
    // (undocumented)
    deleteCachedCredentialsAsync(terminal: ITerminal): Promise<void>;
    // (undocumented)
    protected readonly _failoverOrder: Record<LoginFlowType, LoginFlowType | undefined>;
    protected abstract _getCacheIdParts(): string[];
    // (undocumented)
    protected abstract _getCredentialFromTokenAsync(terminal: ITerminal, tokenCredential: TokenCredential, credentialsCache: CredentialCache): Promise<ICredentialResult>;
    // (undocumented)
    protected readonly _loginFlow: LoginFlowType;
    // (undocumented)
    tryGetCachedCredentialAsync(options?: ITryGetCachedCredentialOptionsThrow | ITryGetCachedCredentialOptionsIgnore): Promise<ICredentialCacheEntry | undefined>;
    // (undocumented)
    tryGetCachedCredentialAsync(options: ITryGetCachedCredentialOptionsLogWarning): Promise<ICredentialCacheEntry | undefined>;
    // (undocumented)
    updateCachedCredentialAsync(terminal: ITerminal, credential: string): Promise<void>;
    updateCachedCredentialInteractiveAsync(terminal: ITerminal, onlyIfExistingCredentialExpiresBefore?: Date): Promise<void>;
}

// @public (undocumented)
export type AzureEnvironmentName = keyof typeof AzureAuthorityHosts;

// @public (undocumented)
export class AzureStorageAuthentication extends AzureAuthenticationBase {
    constructor(options: IAzureStorageAuthenticationOptions);
    // (undocumented)
    protected readonly _credentialKindForLogging: string;
    // (undocumented)
    protected readonly _credentialNameForCache: string;
    // (undocumented)
    protected _getCacheIdParts(): string[];
    // (undocumented)
    protected _getCredentialFromTokenAsync(terminal: ITerminal, tokenCredential: TokenCredential): Promise<ICredentialResult>;
    // (undocumented)
    protected readonly _isCacheWriteAllowedByConfiguration: boolean;
    // (undocumented)
    protected readonly _storageAccountName: string;
    // (undocumented)
    protected readonly _storageAccountUrl: string;
    // (undocumented)
    protected readonly _storageContainerName: string;
}

// @public (undocumented)
export type ExpiredCredentialBehavior = 'logWarning' | 'throwError' | 'ignore';

// @public (undocumented)
export interface IAzureAuthenticationBaseOptions {
    // (undocumented)
    azureEnvironment?: AzureEnvironmentName;
    // (undocumented)
    credentialUpdateCommandForLogging?: string | undefined;
    // (undocumented)
    loginFlow?: LoginFlowType;
    loginFlowFailover?: Record<LoginFlowType, LoginFlowType | undefined>;
}

// @public (undocumented)
export interface IAzureStorageAuthenticationOptions extends IAzureAuthenticationBaseOptions {
    // (undocumented)
    isCacheWriteAllowed: boolean;
    // (undocumented)
    storageAccountName: string;
    // (undocumented)
    storageContainerName: string;
}

// @public (undocumented)
export interface ICredentialResult {
    // (undocumented)
    credentialMetadata?: object;
    // (undocumented)
    credentialString: string;
    // (undocumented)
    expiresOn?: Date;
}

// @public (undocumented)
export interface ITryGetCachedCredentialOptionsBase {
    expiredCredentialBehavior?: ExpiredCredentialBehavior;
    // (undocumented)
    terminal?: ITerminal;
}

// @public (undocumented)
export interface ITryGetCachedCredentialOptionsIgnore extends ITryGetCachedCredentialOptionsBase {
    expiredCredentialBehavior: 'ignore';
}

// @public (undocumented)
export interface ITryGetCachedCredentialOptionsLogWarning extends ITryGetCachedCredentialOptionsBase {
    expiredCredentialBehavior: 'logWarning';
    // (undocumented)
    terminal: ITerminal;
}

// @public (undocumented)
export interface ITryGetCachedCredentialOptionsThrow extends ITryGetCachedCredentialOptionsBase {
    expiredCredentialBehavior: 'throwError';
}

// @public (undocumented)
export type LoginFlowType = 'DeviceCode' | 'InteractiveBrowser' | 'AdoCodespacesAuth';

// @public (undocumented)
class RushAzureStorageBuildCachePlugin implements IRushPlugin {
    // (undocumented)
    apply(rushSession: RushSession, rushConfig: RushConfiguration): void;
    // (undocumented)
    pluginName: string;
}
export default RushAzureStorageBuildCachePlugin;

// (No @packageDocumentation comment for this package)

```
