## API Report File for "@rushstack/operation-graph"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import type { ITerminal } from '@rushstack/terminal';

// @beta
export type CommandMessageFromHost = ICancelCommandMessage | IExitCommandMessage | IRunCommandMessage | ISyncCommandMessage;

// @beta
export type EventMessageFromClient = IRequestRunEventMessage | IAfterExecuteEventMessage | ISyncEventMessage;

// @beta
export interface IAfterExecuteEventMessage {
    // (undocumented)
    event: 'after-execute';
    // (undocumented)
    status: OperationStatus;
}

// @beta
export interface ICancelCommandMessage {
    // (undocumented)
    command: 'cancel';
}

// @beta
export interface IExecuteOperationContext extends Omit<IOperationRunnerContext, 'isFirstRun' | 'requestRun'> {
    afterExecute(operation: Operation, state: IOperationState): void;
    beforeExecute(operation: Operation, state: IOperationState): void;
    queueWork(workFn: () => Promise<OperationStatus>, priority: number): Promise<OperationStatus>;
    requestRun?: (requestor?: string) => void;
    terminal: ITerminal;
}

// @beta
export interface IExitCommandMessage {
    // (undocumented)
    command: 'exit';
}

// @beta
export interface IOperationExecutionOptions {
    // (undocumented)
    abortSignal: AbortSignal;
    // (undocumented)
    parallelism: number;
    // (undocumented)
    requestRun?: (requestor?: string) => void;
    // (undocumented)
    terminal: ITerminal;
}

// @beta
export interface IOperationOptions {
    groupName?: string | undefined;
    name?: string | undefined;
    runner?: IOperationRunner | undefined;
    weight?: number | undefined;
}

// @beta
export interface IOperationRunner {
    executeAsync(context: IOperationRunnerContext): Promise<OperationStatus>;
    readonly name: string;
    silent: boolean;
}

// @beta
export interface IOperationRunnerContext {
    abortSignal: AbortSignal;
    isFirstRun: boolean;
    requestRun?: () => void;
}

// @beta
export interface IOperationState {
    error: OperationError | undefined;
    hasBeenRun: boolean;
    status: OperationStatus;
    stopwatch: Stopwatch;
}

// @beta
export interface IOperationStates {
    readonly lastState: Readonly<IOperationState> | undefined;
    readonly state: Readonly<IOperationState> | undefined;
}

// @beta
export type IPCHost = Pick<typeof process, 'on' | 'send'>;

// @beta
export interface IRequestRunEventMessage {
    // (undocumented)
    event: 'requestRun';
    // (undocumented)
    requestor?: string;
}

// @beta
export interface IRunCommandMessage {
    // (undocumented)
    command: 'run';
}

// @beta
export interface ISyncCommandMessage {
    // (undocumented)
    command: 'sync';
}

// @beta
export interface ISyncEventMessage {
    // (undocumented)
    event: 'sync';
    // (undocumented)
    status: OperationStatus;
}

// @beta
export interface IWatchLoopOptions {
    executeAsync: (state: IWatchLoopState) => Promise<OperationStatus>;
    onAbort: () => void;
    onBeforeExecute: () => void;
    onRequestRun: (requestor?: string) => void;
}

// @beta
export interface IWatchLoopState {
    // (undocumented)
    get abortSignal(): AbortSignal;
    // (undocumented)
    requestRun: (requestor?: string) => void;
}

// @beta
export class Operation implements IOperationStates {
    constructor(options?: IOperationOptions);
    // (undocumented)
    addDependency(dependency: Operation): void;
    readonly consumers: Set<Operation>;
    criticalPathLength: number | undefined;
    // (undocumented)
    deleteDependency(dependency: Operation): void;
    readonly dependencies: Set<Operation>;
    // @internal (undocumented)
    _executeAsync(context: IExecuteOperationContext): Promise<OperationStatus>;
    readonly groupName: string | undefined;
    lastState: IOperationState | undefined;
    readonly name: string | undefined;
    // (undocumented)
    reset(): void;
    runner: IOperationRunner | undefined;
    state: IOperationState | undefined;
    weight: number;
}

// @beta
export class OperationError extends Error {
    constructor(type: string, message: string);
    // (undocumented)
    get message(): string;
    // (undocumented)
    toString(): string;
    // (undocumented)
    protected _type: string;
}

// @beta
export class OperationExecutionManager {
    constructor(operations: ReadonlySet<Operation>);
    executeAsync(executionOptions: IOperationExecutionOptions): Promise<OperationStatus>;
}

// @beta
export class OperationGroupRecord {
    constructor(name: string);
    // (undocumented)
    addOperation(operation: Operation): void;
    // (undocumented)
    get duration(): number;
    // (undocumented)
    get finished(): boolean;
    // (undocumented)
    get hasCancellations(): boolean;
    // (undocumented)
    get hasFailures(): boolean;
    // (undocumented)
    readonly name: string;
    // (undocumented)
    reset(): void;
    // (undocumented)
    setOperationAsComplete(operation: Operation, state: IOperationState): void;
    // (undocumented)
    startTimer(): void;
}

// @beta
export enum OperationStatus {
    Aborted = "ABORTED",
    Blocked = "BLOCKED",
    Executing = "EXECUTING",
    Failure = "FAILURE",
    NoOp = "NO OP",
    Ready = "READY",
    Success = "SUCCESS",
    Waiting = "WAITING"
}

// @public
export class Stopwatch {
    constructor();
    get duration(): number;
    get endTime(): number | undefined;
    // (undocumented)
    get isRunning(): boolean;
    reset(): Stopwatch;
    static start(): Stopwatch;
    start(): Stopwatch;
    get startTime(): number | undefined;
    stop(): Stopwatch;
    toString(): string;
}

// @beta
export class WatchLoop implements IWatchLoopState {
    constructor(options: IWatchLoopOptions);
    get abortSignal(): AbortSignal;
    requestRun: (requestor?: string) => void;
    runIPCAsync(host?: IPCHost): Promise<void>;
    runUntilAbortedAsync(abortSignal: AbortSignal, onWaiting: () => void): Promise<void>;
    runUntilStableAsync(abortSignal: AbortSignal): Promise<OperationStatus>;
}

// (No @packageDocumentation comment for this package)

```
