## API Report File for "@rushstack/node-core-library"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import * as child_process from 'child_process';
import * as nodeFs from 'fs';
import * as nodePath from 'path';

// @public
export enum AlreadyExistsBehavior {
    Error = "error",
    Ignore = "ignore",
    Overwrite = "overwrite"
}

// @public
export class AlreadyReportedError extends Error {
    // (undocumented)
    static [Symbol.hasInstance](instance: object): boolean;
    constructor();
}

// @public
export class Async {
    static forEachAsync<TEntry>(iterable: Iterable<TEntry> | AsyncIterable<TEntry>, callback: (entry: TEntry, arrayIndex: number) => Promise<void>, options?: (IAsyncParallelismOptions & {
        weighted?: false;
    }) | undefined): Promise<void>;
    static forEachAsync<TEntry extends IWeighted>(iterable: Iterable<TEntry> | AsyncIterable<TEntry>, callback: (entry: TEntry, arrayIndex: number) => Promise<void>, options: IAsyncParallelismOptions & {
        weighted: true;
    }): Promise<void>;
    static getSignal(): [Promise<void>, () => void, (err: Error) => void];
    static mapAsync<TEntry, TRetVal>(iterable: Iterable<TEntry> | AsyncIterable<TEntry>, callback: (entry: TEntry, arrayIndex: number) => Promise<TRetVal>, options?: (IAsyncParallelismOptions & {
        weighted?: false;
    }) | undefined): Promise<TRetVal[]>;
    static mapAsync<TEntry extends IWeighted, TRetVal>(iterable: Iterable<TEntry> | AsyncIterable<TEntry>, callback: (entry: TEntry, arrayIndex: number) => Promise<TRetVal>, options: IAsyncParallelismOptions & {
        weighted: true;
    }): Promise<TRetVal[]>;
    static runWithRetriesAsync<TResult>({ action, maxRetries, retryDelayMs }: IRunWithRetriesOptions<TResult>): Promise<TResult>;
    static sleepAsync(ms: number): Promise<void>;
    static validateWeightedIterable(operation: IWeighted): void;
}

// @public
export class AsyncQueue<T> implements AsyncIterable<[T, () => void]> {
    // (undocumented)
    [Symbol.asyncIterator](): AsyncIterableIterator<[T, () => void]>;
    constructor(iterable?: Iterable<T>);
    push(item: T): void;
}

// @public
export type Brand<T, BrandTag extends string> = T & {
    __brand: BrandTag;
};

// @public
export enum Encoding {
    // (undocumented)
    Utf8 = "utf8"
}

// @public
export class Enum {
    static getKeyByNumber<TEnumValue, TEnumObject extends {
        [key: string]: TEnumValue;
    }>(enumObject: TEnumObject, value: number): keyof typeof enumObject;
    static getValueByKey<TEnumValue>(enumObject: {
        [key: string]: TEnumValue | string;
        [key: number]: TEnumValue | string;
    }, key: string): TEnumValue;
    static tryGetKeyByNumber<TEnumValue, TEnumObject extends {
        [key: string]: TEnumValue;
    }>(enumObject: TEnumObject, value: number): keyof typeof enumObject | undefined;
    static tryGetValueByKey<TEnumValue>(enumObject: {
        [key: string]: TEnumValue | string;
        [key: number]: TEnumValue | string;
    }, key: string): TEnumValue | undefined;
}

// @public
export class EnvironmentMap {
    constructor(environmentObject?: Record<string, string | undefined>);
    readonly caseSensitive: boolean;
    clear(): void;
    entries(): IterableIterator<IEnvironmentEntry>;
    get(name: string): string | undefined;
    mergeFrom(environmentMap: EnvironmentMap): void;
    mergeFromObject(environmentObject?: Record<string, string | undefined>): void;
    names(): IterableIterator<string>;
    set(name: string, value: string): void;
    toObject(): Record<string, string>;
    unset(name: string): void;
}

// @public
export class Executable {
    static getProcessInfoById(): Map<number, IProcessInfo>;
    static getProcessInfoByIdAsync(): Promise<Map<number, IProcessInfo>>;
    static getProcessInfoByName(): Map<string, IProcessInfo[]>;
    static getProcessInfoByNameAsync(): Promise<Map<string, IProcessInfo[]>>;
    static spawn(filename: string, args: string[], options?: IExecutableSpawnOptions): child_process.ChildProcess;
    static spawnSync(filename: string, args: string[], options?: IExecutableSpawnSyncOptions): child_process.SpawnSyncReturns<string>;
    static tryResolve(filename: string, options?: IExecutableResolveOptions): string | undefined;
    static waitForExitAsync(childProcess: child_process.ChildProcess, options: IWaitForExitWithStringOptions): Promise<IWaitForExitResult<string>>;
    static waitForExitAsync(childProcess: child_process.ChildProcess, options: IWaitForExitWithBufferOptions): Promise<IWaitForExitResult<Buffer>>;
    static waitForExitAsync(childProcess: child_process.ChildProcess, options?: IWaitForExitOptions): Promise<IWaitForExitResult<never>>;
}

// @public
export type ExecutableStdioMapping = 'pipe' | 'ignore' | 'inherit' | ExecutableStdioStreamMapping[];

// @public
export type ExecutableStdioStreamMapping = 'pipe' | 'ignore' | 'inherit' | NodeJS.WritableStream | NodeJS.ReadableStream | number | undefined;

// @public
export const FileConstants: {
    readonly PackageJson: "package.json";
};

// @public
export class FileError extends Error {
    // (undocumented)
    static [Symbol.hasInstance](instance: object): boolean;
    constructor(message: string, options: IFileErrorOptions);
    readonly absolutePath: string;
    readonly column: number | undefined;
    // @internal (undocumented)
    static _environmentVariableIsAbsolutePath: boolean;
    getFormattedErrorMessage(options?: IFileErrorFormattingOptions): string;
    readonly line: number | undefined;
    readonly projectFolder: string;
    // @internal (undocumented)
    static _sanitizedEnvironmentVariable: string | undefined;
    // @override
    toString(): string;
}

// @public
export type FileLocationStyle = 'Unix' | 'VisualStudio';

// @public
export class FileSystem {
    static appendToFile(filePath: string, contents: string | Buffer, options?: IFileSystemWriteFileOptions): void;
    static appendToFileAsync(filePath: string, contents: string | Buffer, options?: IFileSystemWriteFileOptions): Promise<void>;
    static changePosixModeBits(path: string, modeBits: PosixModeBits): void;
    static changePosixModeBitsAsync(path: string, mode: PosixModeBits): Promise<void>;
    static copyFile(options: IFileSystemCopyFileOptions): void;
    static copyFileAsync(options: IFileSystemCopyFileOptions): Promise<void>;
    static copyFiles(options: IFileSystemCopyFilesOptions): void;
    static copyFilesAsync(options: IFileSystemCopyFilesAsyncOptions): Promise<void>;
    static createHardLink(options: IFileSystemCreateLinkOptions): void;
    static createHardLinkAsync(options: IFileSystemCreateLinkOptions): Promise<void>;
    static createSymbolicLinkFile(options: IFileSystemCreateLinkOptions): void;
    static createSymbolicLinkFileAsync(options: IFileSystemCreateLinkOptions): Promise<void>;
    static createSymbolicLinkFolder(options: IFileSystemCreateLinkOptions): void;
    static createSymbolicLinkFolderAsync(options: IFileSystemCreateLinkOptions): Promise<void>;
    static createSymbolicLinkJunction(options: IFileSystemCreateLinkOptions): void;
    static createSymbolicLinkJunctionAsync(options: IFileSystemCreateLinkOptions): Promise<void>;
    static deleteFile(filePath: string, options?: IFileSystemDeleteFileOptions): void;
    static deleteFileAsync(filePath: string, options?: IFileSystemDeleteFileOptions): Promise<void>;
    static deleteFolder(folderPath: string): void;
    static deleteFolderAsync(folderPath: string): Promise<void>;
    static ensureEmptyFolder(folderPath: string): void;
    static ensureEmptyFolderAsync(folderPath: string): Promise<void>;
    static ensureFolder(folderPath: string): void;
    static ensureFolderAsync(folderPath: string): Promise<void>;
    static exists(path: string): boolean;
    static existsAsync(path: string): Promise<boolean>;
    static formatPosixModeBits(modeBits: PosixModeBits): string;
    static getLinkStatistics(path: string): FileSystemStats;
    static getLinkStatisticsAsync(path: string): Promise<FileSystemStats>;
    static getPosixModeBits(path: string): PosixModeBits;
    static getPosixModeBitsAsync(path: string): Promise<PosixModeBits>;
    static getRealPath(linkPath: string): string;
    static getRealPathAsync(linkPath: string): Promise<string>;
    static getStatistics(path: string): FileSystemStats;
    static getStatisticsAsync(path: string): Promise<FileSystemStats>;
    static isDirectoryError(error: Error): boolean;
    static isErrnoException(error: Error): error is NodeJS.ErrnoException;
    static isExistError(error: Error): boolean;
    static isFileDoesNotExistError(error: Error): boolean;
    static isFolderDoesNotExistError(error: Error): boolean;
    static isNotDirectoryError(error: Error): boolean;
    static isNotExistError(error: Error): boolean;
    static isUnlinkNotPermittedError(error: Error): boolean;
    static move(options: IFileSystemMoveOptions): void;
    static moveAsync(options: IFileSystemMoveOptions): Promise<void>;
    static readFile(filePath: string, options?: IFileSystemReadFileOptions): string;
    static readFileAsync(filePath: string, options?: IFileSystemReadFileOptions): Promise<string>;
    static readFileToBuffer(filePath: string): Buffer;
    static readFileToBufferAsync(filePath: string): Promise<Buffer>;
    static readFolderItemNames(folderPath: string, options?: IFileSystemReadFolderOptions): string[];
    static readFolderItemNamesAsync(folderPath: string, options?: IFileSystemReadFolderOptions): Promise<string[]>;
    static readFolderItems(folderPath: string, options?: IFileSystemReadFolderOptions): FolderItem[];
    static readFolderItemsAsync(folderPath: string, options?: IFileSystemReadFolderOptions): Promise<FolderItem[]>;
    static readLink(path: string): string;
    static readLinkAsync(path: string): Promise<string>;
    static updateTimes(path: string, times: IFileSystemUpdateTimeParameters): void;
    static updateTimesAsync(path: string, times: IFileSystemUpdateTimeParameters): Promise<void>;
    static writeBuffersToFile(filePath: string, contents: ReadonlyArray<Uint8Array>, options?: IFileSystemWriteBinaryFileOptions): void;
    static writeBuffersToFileAsync(filePath: string, contents: ReadonlyArray<Uint8Array>, options?: IFileSystemWriteBinaryFileOptions): Promise<void>;
    static writeFile(filePath: string, contents: string | Buffer, options?: IFileSystemWriteFileOptions): void;
    static writeFileAsync(filePath: string, contents: string | Buffer, options?: IFileSystemWriteFileOptions): Promise<void>;
}

// @public
export type FileSystemCopyFilesAsyncFilter = (sourcePath: string, destinationPath: string) => Promise<boolean>;

// @public
export type FileSystemCopyFilesFilter = (sourcePath: string, destinationPath: string) => boolean;

// @public
export type FileSystemStats = nodeFs.Stats;

// @public
export class FileWriter {
    close(): void;
    readonly filePath: string;
    getStatistics(): FileSystemStats;
    static open(filePath: string, flags?: IFileWriterFlags): FileWriter;
    write(text: string): void;
}

// @public
export const FolderConstants: {
    readonly Git: ".git";
    readonly NodeModules: "node_modules";
};

// @public
export type FolderItem = nodeFs.Dirent;

// @public
export interface IAsyncParallelismOptions {
    concurrency?: number;
    weighted?: boolean;
}

// @public
export interface IDependenciesMetaTable {
    // (undocumented)
    [dependencyName: string]: {
        injected?: boolean;
    };
}

// @public
export interface IEnvironmentEntry {
    name: string;
    value: string;
}

// @public
export interface IExecutableResolveOptions {
    currentWorkingDirectory?: string;
    environment?: NodeJS.ProcessEnv;
    environmentMap?: EnvironmentMap;
}

// @public
export interface IExecutableSpawnOptions extends IExecutableResolveOptions {
    stdio?: ExecutableStdioMapping;
}

// @public
export interface IExecutableSpawnSyncOptions extends IExecutableResolveOptions {
    input?: string;
    maxBuffer?: number;
    stdio?: ExecutableStdioMapping;
    timeoutMs?: number;
}

// @public
export interface IFileErrorFormattingOptions {
    format?: FileLocationStyle;
}

// @public
export interface IFileErrorOptions {
    absolutePath: string;
    column?: number;
    line?: number;
    projectFolder: string;
}

// @public (undocumented)
export interface IFileSystemCopyFileBaseOptions {
    alreadyExistsBehavior?: AlreadyExistsBehavior;
    sourcePath: string;
}

// @public
export interface IFileSystemCopyFileOptions extends IFileSystemCopyFileBaseOptions {
    destinationPath: string;
}

// @public
export interface IFileSystemCopyFilesAsyncOptions {
    alreadyExistsBehavior?: AlreadyExistsBehavior;
    dereferenceSymlinks?: boolean;
    destinationPath: string;
    filter?: FileSystemCopyFilesAsyncFilter | FileSystemCopyFilesFilter;
    preserveTimestamps?: boolean;
    sourcePath: string;
}

// @public
export interface IFileSystemCopyFilesOptions extends IFileSystemCopyFilesAsyncOptions {
    filter?: FileSystemCopyFilesFilter;
}

// @public
export interface IFileSystemCreateLinkOptions {
    alreadyExistsBehavior?: AlreadyExistsBehavior;
    linkTargetPath: string;
    newLinkPath: string;
}

// @public
export interface IFileSystemDeleteFileOptions {
    throwIfNotExists?: boolean;
}

// @public
export interface IFileSystemMoveOptions {
    destinationPath: string;
    ensureFolderExists?: boolean;
    overwrite?: boolean;
    sourcePath: string;
}

// @public
export interface IFileSystemReadFileOptions {
    convertLineEndings?: NewlineKind;
    encoding?: Encoding;
}

// @public
export interface IFileSystemReadFolderOptions {
    absolutePaths?: boolean;
}

// @public
export interface IFileSystemUpdateTimeParameters {
    accessedTime: number | Date;
    modifiedTime: number | Date;
}

// @public
export interface IFileSystemWriteBinaryFileOptions {
    ensureFolderExists?: boolean;
}

// @public
export interface IFileSystemWriteFileOptions extends IFileSystemWriteBinaryFileOptions {
    convertLineEndings?: NewlineKind;
    encoding?: Encoding;
}

// @public
export interface IFileWriterFlags {
    append?: boolean;
    exclusive?: boolean;
}

// @public
export interface IImportResolveAsyncOptions extends IImportResolveOptions {
    getRealPathAsync?: (filePath: string) => Promise<string>;
}

// @public
export interface IImportResolveModuleAsyncOptions extends IImportResolveAsyncOptions {
    modulePath: string;
}

// @public
export interface IImportResolveModuleOptions extends IImportResolveOptions {
    modulePath: string;
}

// @public
export interface IImportResolveOptions {
    allowSelfReference?: boolean;
    baseFolderPath: string;
    getRealPath?: (filePath: string) => string;
    includeSystemModules?: boolean;
}

// @public
export interface IImportResolvePackageAsyncOptions extends IImportResolveAsyncOptions {
    packageName: string;
}

// @public
export interface IImportResolvePackageOptions extends IImportResolveOptions {
    packageName: string;
}

// @public
export interface IJsonFileLoadAndValidateOptions extends IJsonFileParseOptions, IJsonSchemaValidateOptions {
}

// @public
export interface IJsonFileParseOptions {
    jsonSyntax?: JsonSyntax;
}

// @public
export interface IJsonFileSaveOptions extends IJsonFileStringifyOptions {
    ensureFolderExists?: boolean;
    onlyIfChanged?: boolean;
    updateExistingFile?: boolean;
}

// @public
export interface IJsonFileStringifyOptions extends IJsonFileParseOptions {
    headerComment?: string;
    ignoreUndefinedValues?: boolean;
    newlineConversion?: NewlineKind;
    prettyFormatting?: boolean;
}

// @public
export interface IJsonSchemaCustomFormat<T extends string | number> {
    type: T extends string ? 'string' : T extends number ? 'number' : never;
    validate: (data: T) => boolean;
}

// @public
export interface IJsonSchemaErrorInfo {
    details: string;
}

// @public
export type IJsonSchemaFromFileOptions = IJsonSchemaLoadOptions;

// @public
export type IJsonSchemaFromObjectOptions = IJsonSchemaLoadOptions;

// @public
export interface IJsonSchemaLoadOptions {
    customFormats?: Record<string, IJsonSchemaCustomFormat<string> | IJsonSchemaCustomFormat<number>>;
    dependentSchemas?: JsonSchema[];
    schemaVersion?: JsonSchemaVersion;
}

// @public
export interface IJsonSchemaValidateObjectWithOptions {
    ignoreSchemaField?: boolean;
}

// @public
export interface IJsonSchemaValidateOptions extends IJsonSchemaValidateObjectWithOptions {
    customErrorHeader?: string;
}

// @public
export class Import {
    static lazy(moduleName: string, require: (id: string) => unknown): any;
    static resolveModule(options: IImportResolveModuleOptions): string;
    static resolveModuleAsync(options: IImportResolveModuleAsyncOptions): Promise<string>;
    static resolvePackage(options: IImportResolvePackageOptions): string;
    static resolvePackageAsync(options: IImportResolvePackageAsyncOptions): Promise<string>;
}

// @public
export interface INodePackageJson {
    bin?: string | Record<string, string>;
    dependencies?: IPackageJsonDependencyTable;
    dependenciesMeta?: IDependenciesMetaTable;
    description?: string;
    devDependencies?: IPackageJsonDependencyTable;
    exports?: string | string[] | Record<string, null | string | IPackageJsonExports>;
    files?: string[];
    homepage?: string;
    license?: string;
    main?: string;
    name: string;
    optionalDependencies?: IPackageJsonDependencyTable;
    peerDependencies?: IPackageJsonDependencyTable;
    peerDependenciesMeta?: IPeerDependenciesMetaTable;
    private?: boolean;
    repository?: string | IPackageJsonRepository;
    resolutions?: Record<string, string>;
    scripts?: IPackageJsonScriptTable;
    // @beta
    tsdocMetadata?: string;
    types?: string;
    typesVersions?: Record<string, Record<string, [string, ...string[]]>>;
    typings?: string;
    version?: string;
}

// @public
export class InternalError extends Error {
    constructor(message: string);
    static breakInDebugger: boolean;
    // @override (undocumented)
    toString(): string;
    readonly unformattedMessage: string;
}

// @public
export interface IPackageJson extends INodePackageJson {
    version: string;
}

// @public
export interface IPackageJsonDependencyTable {
    [dependencyName: string]: string;
}

// @public
export interface IPackageJsonExports {
    'node-addons'?: string | IPackageJsonExports;
    browser?: string | IPackageJsonExports;
    default?: string | IPackageJsonExports;
    development?: string | IPackageJsonExports;
    import?: string | IPackageJsonExports;
    node?: string | IPackageJsonExports;
    production?: string | IPackageJsonExports;
    require?: string | IPackageJsonExports;
    types?: string | IPackageJsonExports;
}

// @public
export interface IPackageJsonLookupParameters {
    loadExtraFields?: boolean;
}

// @public
export interface IPackageJsonRepository {
    directory?: string;
    type: string;
    url: string;
}

// @public
export interface IPackageJsonScriptTable {
    [scriptName: string]: string;
}

// @public
export interface IPackageNameParserOptions {
    allowUpperCase?: boolean;
}

// @public
export interface IParsedPackageName {
    scope: string;
    unscopedName: string;
}

// @public
export interface IParsedPackageNameOrError extends IParsedPackageName {
    error: string;
}

// @public
export interface IPathFormatConciselyOptions {
    baseFolder: string;
    pathToConvert: string;
    trimLeadingDotSlash?: boolean;
}

// @public
export interface IPathFormatFileLocationOptions {
    baseFolder?: string;
    column?: number;
    format: FileLocationStyle;
    line?: number;
    message: string;
    pathToFormat: string;
}

// @public
export interface IPeerDependenciesMetaTable {
    // (undocumented)
    [dependencyName: string]: {
        optional?: boolean;
    };
}

// @public
export interface IProcessInfo {
    childProcessInfos: IProcessInfo[];
    parentProcessInfo: IProcessInfo | undefined;
    processId: number;
    processName: string;
}

// @public
export interface IProtectableMapParameters<K, V> {
    onClear?: (source: ProtectableMap<K, V>) => void;
    onDelete?: (source: ProtectableMap<K, V>, key: K) => void;
    onSet?: (source: ProtectableMap<K, V>, key: K, value: V) => V;
}

// @public
export interface IReadLinesFromIterableOptions {
    encoding?: Encoding;
    ignoreEmptyLines?: boolean;
}

// @public
export interface IRealNodeModulePathResolverOptions {
    // (undocumented)
    fs?: Partial<Pick<typeof nodeFs, 'lstatSync' | 'readlinkSync'>>;
    // (undocumented)
    path?: Partial<Pick<typeof nodePath, 'isAbsolute' | 'join' | 'resolve' | 'sep'>>;
}

// @public (undocumented)
export interface IRunWithRetriesOptions<TResult> {
    // (undocumented)
    action: () => Promise<TResult> | TResult;
    // (undocumented)
    maxRetries: number;
    // (undocumented)
    retryDelayMs?: number;
}

// @public
export interface IStringBuilder {
    append(text: string): void;
    toString(): string;
}

// @beta
export interface ISubprocessOptions {
    detached: boolean;
}

// @public
export interface IWaitForExitOptions {
    encoding?: BufferEncoding | 'buffer';
    throwOnNonZeroExitCode?: boolean;
    throwOnSignal?: boolean;
}

// @public
export interface IWaitForExitResult<T extends Buffer | string | never = never> {
    exitCode: number | null;
    signal: string | null;
    stderr: T;
    stdout: T;
}

// @public
export interface IWaitForExitWithBufferOptions extends IWaitForExitOptions {
    encoding: 'buffer';
}

// @public
export interface IWaitForExitWithStringOptions extends IWaitForExitOptions {
    encoding: BufferEncoding;
}

// @public (undocumented)
export interface IWeighted {
    weight: number;
}

// @public
export class JsonFile {
    // @internal (undocumented)
    static _formatPathForError: (path: string) => string;
    static load(jsonFilename: string, options?: IJsonFileParseOptions): JsonObject;
    static loadAndValidate(jsonFilename: string, jsonSchema: JsonSchema, options?: IJsonFileLoadAndValidateOptions): JsonObject;
    static loadAndValidateAsync(jsonFilename: string, jsonSchema: JsonSchema, options?: IJsonFileLoadAndValidateOptions): Promise<JsonObject>;
    static loadAndValidateWithCallback(jsonFilename: string, jsonSchema: JsonSchema, errorCallback: (errorInfo: IJsonSchemaErrorInfo) => void, options?: IJsonFileLoadAndValidateOptions): JsonObject;
    static loadAndValidateWithCallbackAsync(jsonFilename: string, jsonSchema: JsonSchema, errorCallback: (errorInfo: IJsonSchemaErrorInfo) => void, options?: IJsonFileLoadAndValidateOptions): Promise<JsonObject>;
    static loadAsync(jsonFilename: string, options?: IJsonFileParseOptions): Promise<JsonObject>;
    static parseString(jsonContents: string, options?: IJsonFileParseOptions): JsonObject;
    static save(jsonObject: JsonObject, jsonFilename: string, options?: IJsonFileSaveOptions): boolean;
    static saveAsync(jsonObject: JsonObject, jsonFilename: string, options?: IJsonFileSaveOptions): Promise<boolean>;
    static stringify(jsonObject: JsonObject, options?: IJsonFileStringifyOptions): string;
    static updateString(previousJson: string, newJsonObject: JsonObject, options?: IJsonFileStringifyOptions): string;
    static validateNoUndefinedMembers(jsonObject: JsonObject): void;
}

// @public
export type JsonNull = null;

// @public
export type JsonObject = any;

// @public
export class JsonSchema {
    ensureCompiled(): void;
    static fromFile(filename: string, options?: IJsonSchemaFromFileOptions): JsonSchema;
    static fromLoadedObject(schemaObject: JsonObject, options?: IJsonSchemaFromObjectOptions): JsonSchema;
    get shortName(): string;
    validateObject(jsonObject: JsonObject, filenameForErrors: string, options?: IJsonSchemaValidateOptions): void;
    validateObjectWithCallback(jsonObject: JsonObject, errorCallback: (errorInfo: IJsonSchemaErrorInfo) => void, options?: IJsonSchemaValidateObjectWithOptions): void;
}

// @public
export type JsonSchemaVersion = 'draft-04' | 'draft-07';

// @public
export enum JsonSyntax {
    Json5 = "json5",
    JsonWithComments = "jsonWithComments",
    Strict = "strict"
}

// @public
export class LegacyAdapters {
    static convertCallbackToPromise<TResult, TError>(fn: (cb: LegacyCallback<TResult, TError>) => void): Promise<TResult>;
    // (undocumented)
    static convertCallbackToPromise<TResult, TError, TArg1>(fn: (arg1: TArg1, cb: LegacyCallback<TResult, TError>) => void, arg1: TArg1): Promise<TResult>;
    // (undocumented)
    static convertCallbackToPromise<TResult, TError, TArg1, TArg2>(fn: (arg1: TArg1, arg2: TArg2, cb: LegacyCallback<TResult, TError>) => void, arg1: TArg1, arg2: TArg2): Promise<TResult>;
    // (undocumented)
    static convertCallbackToPromise<TResult, TError, TArg1, TArg2, TArg3>(fn: (arg1: TArg1, arg2: TArg2, arg3: TArg3, cb: LegacyCallback<TResult, TError>) => void, arg1: TArg1, arg2: TArg2, arg3: TArg3): Promise<TResult>;
    // (undocumented)
    static convertCallbackToPromise<TResult, TError, TArg1, TArg2, TArg3, TArg4>(fn: (arg1: TArg1, arg2: TArg2, arg3: TArg3, arg4: TArg4, cb: LegacyCallback<TResult, TError>) => void, arg1: TArg1, arg2: TArg2, arg3: TArg3, arg4: TArg4): Promise<TResult>;
    static scrubError(error: Error | string | any): Error;
}

// @public
export type LegacyCallback<TResult, TError> = (error: TError | null | undefined, result: TResult) => void;

// @public
export class LockFile {
    // @deprecated (undocumented)
    static acquire(resourceFolder: string, resourceName: string, maxWaitMs?: number): Promise<LockFile>;
    static acquireAsync(resourceFolder: string, resourceName: string, maxWaitMs?: number): Promise<LockFile>;
    get dirtyWhenAcquired(): boolean;
    get filePath(): string;
    static getLockFilePath(resourceFolder: string, resourceName: string, pid?: number): string;
    get isReleased(): boolean;
    release(deleteFile?: boolean): void;
    static tryAcquire(resourceFolder: string, resourceName: string): LockFile | undefined;
}

// @public
export class MapExtensions {
    static mergeFromMap<K, V>(targetMap: Map<K, V>, sourceMap: ReadonlyMap<K, V>): void;
    static toObject<TValue>(map: Map<string, TValue>): {
        [key: string]: TValue;
    };
}

// @public
export class MinimumHeap<T> {
    constructor(comparator: (a: T, b: T) => number);
    peek(): T | undefined;
    poll(): T | undefined;
    push(item: T): void;
    get size(): number;
}

// @public
export enum NewlineKind {
    CrLf = "\r\n",
    Lf = "\n",
    OsDefault = "os"
}

// @public
export class PackageJsonLookup {
    constructor(parameters?: IPackageJsonLookupParameters);
    clearCache(): void;
    static get instance(): PackageJsonLookup;
    loadNodePackageJson(jsonFilename: string): INodePackageJson;
    static loadOwnPackageJson(dirnameOfCaller: string): IPackageJson;
    loadPackageJson(jsonFilename: string): IPackageJson;
    tryGetPackageFolderFor(fileOrFolderPath: string): string | undefined;
    tryGetPackageJsonFilePathFor(fileOrFolderPath: string): string | undefined;
    tryLoadNodePackageJsonFor(fileOrFolderPath: string): INodePackageJson | undefined;
    tryLoadPackageJsonFor(fileOrFolderPath: string): IPackageJson | undefined;
}

// @public
export class PackageName {
    static combineParts(scope: string, unscopedName: string): string;
    static getScope(packageName: string): string;
    static getUnscopedName(packageName: string): string;
    static isValidName(packageName: string): boolean;
    static parse(packageName: string): IParsedPackageName;
    static tryParse(packageName: string): IParsedPackageNameOrError;
    static validate(packageName: string): void;
}

// @public
export class PackageNameParser {
    constructor(options?: IPackageNameParserOptions);
    combineParts(scope: string, unscopedName: string): string;
    getScope(packageName: string): string;
    getUnscopedName(packageName: string): string;
    isValidName(packageName: string): boolean;
    parse(packageName: string): IParsedPackageName;
    tryParse(packageName: string): IParsedPackageNameOrError;
    validate(packageName: string): void;
}

// @public
export class Path {
    static convertToBackslashes(inputPath: string): string;
    static convertToPlatformDefault(inputPath: string): string;
    static convertToSlashes(inputPath: string): string;
    static formatConcisely(options: IPathFormatConciselyOptions): string;
    static formatFileLocation(options: IPathFormatFileLocationOptions): string;
    static isDownwardRelative(inputPath: string): boolean;
    static isEqual(path1: string, path2: string): boolean;
    static isUnder(childPath: string, parentFolderPath: string): boolean;
    static isUnderOrEqual(childPath: string, parentFolderPath: string): boolean;
}

// @public
export enum PosixModeBits {
    AllExecute = 73,
    AllRead = 292,
    AllWrite = 146,
    GroupExecute = 8,
    GroupRead = 32,
    GroupWrite = 16,
    None = 0,
    OthersExecute = 1,
    OthersRead = 4,
    OthersWrite = 2,
    UserExecute = 64,
    UserRead = 256,
    UserWrite = 128
}

// @public
export class ProtectableMap<K, V> {
    constructor(parameters: IProtectableMapParameters<K, V>);
    clear(): void;
    delete(key: K): boolean;
    forEach(callbackfn: (value: V, key: K, map: Map<K, V>) => void, thisArg?: any): void;
    get(key: K): V | undefined;
    has(key: K): boolean;
    get protectedView(): Map<K, V>;
    set(key: K, value: V): this;
    get size(): number;
}

// @public
export class RealNodeModulePathResolver {
    constructor(options?: IRealNodeModulePathResolverOptions);
    clearCache(): void;
    readonly realNodeModulePath: (input: string) => string;
}

// @public
export class Sort {
    static compareByValue(x: any, y: any): number;
    static isSorted<T>(collection: Iterable<T>, comparer?: (x: any, y: any) => number): boolean;
    static isSortedBy<T>(collection: Iterable<T>, keySelector: (element: T) => any, comparer?: (x: any, y: any) => number): boolean;
    static sortBy<T>(array: T[], keySelector: (element: T) => any, comparer?: (x: any, y: any) => number): void;
    static sortKeys<T extends Partial<Record<string, unknown>> | unknown[]>(object: T): T;
    static sortMapKeys<K, V>(map: Map<K, V>, keyComparer?: (x: K, y: K) => number): void;
    static sortSet<T>(set: Set<T>, comparer?: (x: T, y: T) => number): void;
    static sortSetBy<T>(set: Set<T>, keySelector: (element: T) => any, keyComparer?: (x: T, y: T) => number): void;
}

// @public
export class StringBuilder implements IStringBuilder {
    constructor();
    append(text: string): void;
    toString(): string;
}

// @beta
export class SubprocessTerminator {
    static killProcessTree(subprocess: child_process.ChildProcess, subprocessOptions: ISubprocessOptions): void;
    static killProcessTreeOnExit(subprocess: child_process.ChildProcess, subprocessOptions: ISubprocessOptions): void;
    static readonly RECOMMENDED_OPTIONS: ISubprocessOptions;
}

// @public
export class Text {
    static convertTo(input: string, newlineKind: NewlineKind): string;
    static convertToCrLf(input: string): string;
    static convertToLf(input: string): string;
    static ensureTrailingNewline(s: string, newlineKind?: NewlineKind): string;
    static escapeRegExp(literal: string): string;
    static getNewline(newlineKind: NewlineKind): string;
    static padEnd(s: string, minimumLength: number, paddingCharacter?: string): string;
    static padStart(s: string, minimumLength: number, paddingCharacter?: string): string;
    static readLinesFromIterable(iterable: Iterable<string | Buffer | null>, options?: IReadLinesFromIterableOptions): Generator<string>;
    static readLinesFromIterableAsync(iterable: AsyncIterable<string | Buffer>, options?: IReadLinesFromIterableOptions): AsyncGenerator<string>;
    static replaceAll(input: string, searchValue: string, replaceValue: string): string;
    static reverse(s: string): string;
    static splitByNewLines(s: undefined): undefined;
    // (undocumented)
    static splitByNewLines(s: string): string[];
    // (undocumented)
    static splitByNewLines(s: string | undefined): string[] | undefined;
    static truncateWithEllipsis(s: string, maximumLength: number): string;
}

// @public
export class TypeUuid {
    static isInstanceOf(targetObject: unknown, typeUuid: string): boolean;
    static registerClass(targetClass: any, typeUuid: string): void;
}

```
