## API Report File for "@rushstack/module-minifier"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import { MinifyOptions } from 'terser';
import type { RawSourceMap } from 'source-map';
import type * as WorkerThreads from 'worker_threads';

// @public
export function getIdentifier(ordinal: number): string;

// @public
export interface ILocalMinifierOptions {
    // (undocumented)
    terserOptions?: MinifyOptions;
}

// @public
export interface IMinifierConnection {
    configHash: string;
    // @deprecated (undocumented)
    disconnect(): Promise<void>;
    disconnectAsync(): Promise<void>;
}

// @public
export interface IModuleMinificationCallback {
    // (undocumented)
    (result: IModuleMinificationResult): void;
}

// @public
export interface IModuleMinificationErrorResult {
    code?: undefined;
    error: Error;
    hash: string;
    map?: undefined;
}

// @public
export interface IModuleMinificationRequest {
    code: string;
    externals: string[] | undefined;
    hash: string;
    nameForMap: string | undefined;
}

// @public
export type IModuleMinificationResult = IModuleMinificationErrorResult | IModuleMinificationSuccessResult;

// @public
export interface IModuleMinificationSuccessResult {
    code: string;
    error: undefined;
    hash: string;
    map?: RawSourceMap;
}

// @public
export interface IModuleMinifier {
    // @deprecated (undocumented)
    connect(): Promise<IMinifierConnection>;
    connectAsync(): Promise<IMinifierConnection>;
    minify: IModuleMinifierFunction;
}

// @public
export interface IModuleMinifierFunction {
    // (undocumented)
    (request: IModuleMinificationRequest, callback: IModuleMinificationCallback): void;
}

// @public
export interface IWorkerPoolMinifierOptions {
    maxThreads?: number;
    terserOptions?: MinifyOptions;
    verbose?: boolean;
}

// @public
export class LocalMinifier implements IModuleMinifier {
    constructor(options: ILocalMinifierOptions);
    // @deprecated (undocumented)
    connect(): Promise<IMinifierConnection>;
    connectAsync(): Promise<IMinifierConnection>;
    minify(request: IModuleMinificationRequest, callback: IModuleMinificationCallback): void;
}

// @public
export class MessagePortMinifier implements IModuleMinifier {
    constructor(port: WorkerThreads.MessagePort);
    // @deprecated (undocumented)
    connect(): Promise<IMinifierConnection>;
    connectAsync(): Promise<IMinifierConnection>;
    minify(request: IModuleMinificationRequest, callback: IModuleMinificationCallback): void;
    // (undocumented)
    readonly port: WorkerThreads.MessagePort;
}

export { MinifyOptions }

// @internal
export function _minifySingleFileAsync(request: IModuleMinificationRequest, terserOptions: MinifyOptions): Promise<IModuleMinificationResult>;

// @public
export class NoopMinifier implements IModuleMinifier {
    // @deprecated (undocumented)
    connect(): Promise<IMinifierConnection>;
    connectAsync(): Promise<IMinifierConnection>;
    minify(request: IModuleMinificationRequest, callback: IModuleMinificationCallback): void;
}

// @public
export class WorkerPoolMinifier implements IModuleMinifier {
    constructor(options: IWorkerPoolMinifierOptions);
    // @deprecated (undocumented)
    connect(): Promise<IMinifierConnection>;
    connectAsync(): Promise<IMinifierConnection>;
    // (undocumented)
    get maxThreads(): number;
    set maxThreads(threads: number);
    minify(request: IModuleMinificationRequest, callback: IModuleMinificationCallback): void;
}

```
