## API Report File for "@rushstack/heft"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

/// <reference types="node" />

import { AsyncParallelHook } from 'tapable';
import { AsyncSeriesWaterfallHook } from 'tapable';
import { CommandLineChoiceListParameter } from '@rushstack/ts-command-line';
import { CommandLineChoiceParameter } from '@rushstack/ts-command-line';
import { CommandLineFlagParameter } from '@rushstack/ts-command-line';
import { CommandLineIntegerListParameter } from '@rushstack/ts-command-line';
import { CommandLineIntegerParameter } from '@rushstack/ts-command-line';
import { CommandLineParameter } from '@rushstack/ts-command-line';
import { CommandLineStringListParameter } from '@rushstack/ts-command-line';
import { CommandLineStringParameter } from '@rushstack/ts-command-line';
import { IPackageJson } from '@rushstack/node-core-library';
import { IRigConfig } from '@rushstack/rig-package';
import { ITerminal } from '@rushstack/terminal';
import { ITerminalProvider } from '@rushstack/terminal';

export { CommandLineChoiceListParameter }

export { CommandLineChoiceParameter }

export { CommandLineFlagParameter }

export { CommandLineIntegerListParameter }

export { CommandLineIntegerParameter }

export { CommandLineParameter }

export { CommandLineStringListParameter }

export { CommandLineStringParameter }

// @public
export type GlobFn = (pattern: string | string[], options?: IGlobOptions | undefined) => Promise<string[]>;

// @public (undocumented)
export class HeftConfiguration {
    get buildFolderPath(): string;
    // @internal
    _checkForRigAsync(): Promise<void>;
    get globalTerminal(): ITerminal;
    get heftPackageJson(): IPackageJson;
    // @internal (undocumented)
    static initialize(options: _IHeftConfigurationInitializationOptions): HeftConfiguration;
    get projectConfigFolderPath(): string;
    get projectPackageJson(): IPackageJson;
    get rigConfig(): IRigConfig;
    get rigPackageResolver(): IRigPackageResolver;
    get slashNormalizedBuildFolderPath(): string;
    get tempFolderPath(): string;
    get terminalProvider(): ITerminalProvider;
}

// @public
export interface ICopyOperation extends IFileSelectionSpecifier {
    destinationFolders: string[];
    flatten?: boolean;
    hardlink?: boolean;
}

// @public
export interface IDeleteOperation extends IFileSelectionSpecifier {
}

// @public
export interface IFileSelectionSpecifier {
    excludeGlobs?: string[];
    fileExtensions?: string[];
    includeGlobs?: string[];
    sourcePath?: string;
}

// @public
export interface IGlobOptions {
    absolute?: boolean;
    cwd?: string;
    dot?: boolean;
    ignore?: string[];
}

// @internal (undocumented)
export interface _IHeftConfigurationInitializationOptions {
    cwd: string;
    terminalProvider: ITerminalProvider;
}

// @public
export interface IHeftDefaultParameters {
    readonly clean: boolean;
    readonly debug: boolean;
    readonly locales: Iterable<string>;
    readonly production: boolean;
    readonly verbose: boolean;
    readonly watch: boolean;
}

// @public
export interface IHeftLifecycleCleanHookOptions {
    addDeleteOperations: (...deleteOperations: IDeleteOperation[]) => void;
}

// @public
export interface IHeftLifecycleHooks {
    clean: AsyncParallelHook<IHeftLifecycleCleanHookOptions>;
    recordMetrics: AsyncParallelHook<IHeftRecordMetricsHookOptions>;
    toolFinish: AsyncParallelHook<IHeftLifecycleToolFinishHookOptions>;
    toolStart: AsyncParallelHook<IHeftLifecycleToolStartHookOptions>;
}

// @public
export interface IHeftLifecyclePlugin<TOptions = void> extends IHeftPlugin<IHeftLifecycleSession, TOptions> {
}

// @public
export interface IHeftLifecycleSession {
    readonly hooks: IHeftLifecycleHooks;
    readonly logger: IScopedLogger;
    readonly parameters: IHeftParameters;
    requestAccessToPluginByName<T extends object>(pluginToAccessPackage: string, pluginToAccessName: string, pluginApply: (pluginAccessor: T) => void): void;
    readonly tempFolderPath: string;
}

// @public
export interface IHeftLifecycleToolFinishHookOptions {
}

// @public
export interface IHeftLifecycleToolStartHookOptions {
}

// @public
export interface IHeftParameters extends IHeftDefaultParameters {
    getChoiceListParameter(parameterLongName: string): CommandLineChoiceListParameter;
    getChoiceParameter(parameterLongName: string): CommandLineChoiceParameter;
    getFlagParameter(parameterLongName: string): CommandLineFlagParameter;
    getIntegerListParameter(parameterLongName: string): CommandLineIntegerListParameter;
    getIntegerParameter(parameterLongName: string): CommandLineIntegerParameter;
    getStringListParameter(parameterLongName: string): CommandLineStringListParameter;
    getStringParameter(parameterLongName: string): CommandLineStringParameter;
}

// @public
export interface IHeftParsedCommandLine {
    readonly commandName: string;
    readonly unaliasedCommandName: string;
}

// @public
export interface IHeftPlugin<TSession extends IHeftLifecycleSession | IHeftTaskSession = IHeftLifecycleSession | IHeftTaskSession, TOptions = void> {
    readonly accessor?: object;
    apply(session: TSession, heftConfiguration: HeftConfiguration, pluginOptions?: TOptions): void;
}

// @public (undocumented)
export interface IHeftRecordMetricsHookOptions {
    // (undocumented)
    metricData: IMetricsData;
    // (undocumented)
    metricName: string;
}

// @public
export interface IHeftTaskFileOperations {
    copyOperations: Set<ICopyOperation>;
    deleteOperations: Set<IDeleteOperation>;
}

// @public
export interface IHeftTaskHooks {
    readonly registerFileOperations: AsyncSeriesWaterfallHook<IHeftTaskFileOperations>;
    readonly run: AsyncParallelHook<IHeftTaskRunHookOptions>;
    readonly runIncremental: AsyncParallelHook<IHeftTaskRunIncrementalHookOptions>;
}

// @public
export interface IHeftTaskPlugin<TOptions = void> extends IHeftPlugin<IHeftTaskSession, TOptions> {
}

// @public
export interface IHeftTaskRunHookOptions {
    // @beta
    readonly abortSignal: AbortSignal;
}

// @public
export interface IHeftTaskRunIncrementalHookOptions extends IHeftTaskRunHookOptions {
    readonly requestRun: () => void;
    readonly watchGlobAsync: WatchGlobFn;
}

// @public
export interface IHeftTaskSession {
    readonly hooks: IHeftTaskHooks;
    readonly logger: IScopedLogger;
    readonly parameters: IHeftParameters;
    readonly parsedCommandLine: IHeftParsedCommandLine;
    requestAccessToPluginByName<T extends object>(pluginToAccessPackage: string, pluginToAccessName: string, pluginApply: (pluginAccessor: T) => void): void;
    readonly taskName: string;
    readonly tempFolderPath: string;
}

// @public
export interface IIncrementalCopyOperation extends ICopyOperation {
    onlyIfChanged?: boolean;
}

// @public (undocumented)
export interface IMetricsData {
    bootDurationMs: number;
    command: string;
    commandParameters: Record<string, string>;
    encounteredError?: boolean;
    machineArch: string;
    machineCores: number;
    machineOs: string;
    machineProcessor: string;
    machineTotalMemoryMB: number;
    taskTotalExecutionMs: number;
    totalUptimeMs: number;
}

// @internal (undocumented)
export interface _IPerformanceData {
    // (undocumented)
    encounteredError?: boolean;
    // (undocumented)
    taskTotalExecutionMs: number;
}

// @public
export interface IRigPackageResolver {
    // (undocumented)
    resolvePackageAsync(packageName: string, terminal: ITerminal): Promise<string>;
}

// @beta
export interface IRunScript {
    runAsync: (options: IRunScriptOptions) => Promise<void>;
}

// @beta
export interface IRunScriptOptions {
    // (undocumented)
    heftConfiguration: HeftConfiguration;
    // (undocumented)
    heftTaskSession: IHeftTaskSession;
    // (undocumented)
    runOptions: IHeftTaskRunHookOptions;
    // (undocumented)
    scriptOptions: Record<string, unknown>;
}

// @public
export interface IScopedLogger {
    emitError(error: Error): void;
    emitWarning(warning: Error): void;
    readonly hasErrors: boolean;
    readonly loggerName: string;
    resetErrorsAndWarnings(): void;
    readonly terminal: ITerminal;
}

// @public
export interface IWatchedFileState {
    changed: boolean;
}

// @internal
export class _MetricsCollector {
    recordAsync(command: string, performanceData?: Partial<_IPerformanceData>, parameters?: Record<string, string>): Promise<void>;
    // (undocumented)
    readonly recordMetricsHook: AsyncParallelHook<IHeftRecordMetricsHookOptions>;
    setStartTime(): void;
}

// @public
export type WatchGlobFn = (pattern: string | string[], options?: IGlobOptions | undefined) => Promise<Map<string, IWatchedFileState>>;

```
