## API Report File for "@rushstack/debug-certificate-manager"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import type { ITerminal } from '@rushstack/terminal';

// @public
export class CertificateManager {
    constructor();
    ensureCertificateAsync(canGenerateNewCertificate: boolean, terminal: ITerminal, options?: ICertificateGenerationOptions): Promise<ICertificate>;
    untrustCertificateAsync(terminal: ITerminal): Promise<boolean>;
}

// @public
export class CertificateStore {
    constructor();
    get caCertificateData(): string | undefined;
    set caCertificateData(certificate: string | undefined);
    get caCertificatePath(): string;
    get certificateData(): string | undefined;
    set certificateData(certificate: string | undefined);
    get certificatePath(): string;
    get keyData(): string | undefined;
    set keyData(key: string | undefined);
}

// @public
export const DEFAULT_CERTIFICATE_SUBJECT_NAMES: ReadonlyArray<string>;

// @public
export interface ICertificate {
    pemCaCertificate: string | undefined;
    pemCertificate: string | undefined;
    pemKey: string | undefined;
    subjectAltNames: readonly string[] | undefined;
}

// @public
export interface ICertificateGenerationOptions {
    skipCertificateTrust?: boolean;
    subjectAltNames?: ReadonlyArray<string>;
    subjectIPAddresses?: ReadonlyArray<string>;
    validityInDays?: number;
}

```
