## API Report File for "@microsoft/api-extractor"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { EnumMemberOrder } from '@microsoft/api-extractor-model';
import { INodePackageJson } from '@rushstack/node-core-library';
import { IRigConfig } from '@rushstack/rig-package';
import { JsonSchema } from '@rushstack/node-core-library';
import { NewlineKind } from '@rushstack/node-core-library';
import { PackageJsonLookup } from '@rushstack/node-core-library';
import type * as tsdoc from '@microsoft/tsdoc';
import { TSDocConfigFile } from '@microsoft/tsdoc-config';
import { TSDocConfiguration } from '@microsoft/tsdoc';

// @public
export type ApiReportVariant = 'public' | 'beta' | 'alpha' | 'complete';

// @public
export class CompilerState {
    static create(extractorConfig: ExtractorConfig, options?: ICompilerStateCreateOptions): CompilerState;
    readonly program: unknown;
}

// @public
export enum ConsoleMessageId {
    ApiReportCopied = "console-api-report-copied",
    ApiReportCreated = "console-api-report-created",
    ApiReportFolderMissing = "console-api-report-folder-missing",
    ApiReportNotCopied = "console-api-report-not-copied",
    ApiReportUnchanged = "console-api-report-unchanged",
    CompilerVersionNotice = "console-compiler-version-notice",
    Diagnostics = "console-diagnostics",
    FoundTSDocMetadata = "console-found-tsdoc-metadata",
    Preamble = "console-preamble",
    UsingCustomTSDocConfig = "console-using-custom-tsdoc-config",
    WritingApiReport = "console-writing-api-report",
    WritingDocModelFile = "console-writing-doc-model-file",
    WritingDtsRollup = "console-writing-dts-rollup"
}

// @public
export class Extractor {
    static invoke(extractorConfig: ExtractorConfig, options?: IExtractorInvokeOptions): ExtractorResult;
    static loadConfigAndInvoke(configFilePath: string, options?: IExtractorInvokeOptions): ExtractorResult;
    static get packageName(): string;
    static get version(): string;
}

// @public @sealed
export class ExtractorConfig {
    readonly alphaTrimmedFilePath: string;
    readonly apiJsonFilePath: string;
    readonly apiReportEnabled: boolean;
    readonly apiReportIncludeForgottenExports: boolean;
    readonly betaTrimmedFilePath: string;
    readonly bundledPackages: string[];
    readonly docModelEnabled: boolean;
    readonly docModelIncludeForgottenExports: boolean;
    readonly enumMemberOrder: EnumMemberOrder;
    static readonly FILENAME: 'api-extractor.json';
    getDiagnosticDump(): string;
    // @internal
    _getShortFilePath(absolutePath: string): string;
    static hasDtsFileExtension(filePath: string): boolean;
    static readonly jsonSchema: JsonSchema;
    static loadFile(jsonFilePath: string): IConfigFile;
    static loadFileAndPrepare(configJsonFilePath: string): ExtractorConfig;
    readonly mainEntryPointFilePath: string;
    readonly messages: IExtractorMessagesConfig;
    readonly newlineKind: NewlineKind;
    readonly omitTrimmingComments: boolean;
    readonly overrideTsconfig: {} | undefined;
    readonly packageFolder: string | undefined;
    readonly packageJson: INodePackageJson | undefined;
    static prepare(options: IExtractorConfigPrepareOptions): ExtractorConfig;
    readonly projectFolder: string;
    readonly projectFolderUrl: string | undefined;
    readonly publicTrimmedFilePath: string;
    readonly reportConfigs: readonly IExtractorConfigApiReport[];
    // @deprecated
    get reportFilePath(): string;
    readonly reportFolder: string;
    // @deprecated
    get reportTempFilePath(): string;
    readonly reportTempFolder: string;
    readonly rollupEnabled: boolean;
    readonly skipLibCheck: boolean;
    readonly testMode: boolean;
    static tryLoadForFolder(options: IExtractorConfigLoadForFolderOptions): IExtractorConfigPrepareOptions | undefined;
    readonly tsconfigFilePath: string;
    // @internal
    static readonly _tsdocBaseFilePath: string;
    readonly tsdocConfigFile: TSDocConfigFile;
    readonly tsdocConfiguration: TSDocConfiguration;
    readonly tsdocMetadataEnabled: boolean;
    readonly tsdocMetadataFilePath: string;
    readonly untrimmedFilePath: string;
}

// @public
export enum ExtractorLogLevel {
    Error = "error",
    Info = "info",
    None = "none",
    Verbose = "verbose",
    Warning = "warning"
}

// @public
export class ExtractorMessage {
    // Warning: (ae-forgotten-export) The symbol "IExtractorMessageOptions" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(options: IExtractorMessageOptions);
    readonly category: ExtractorMessageCategory;
    formatMessageWithLocation(workingPackageFolderPath: string | undefined): string;
    // (undocumented)
    formatMessageWithoutLocation(): string;
    get handled(): boolean;
    set handled(value: boolean);
    get logLevel(): ExtractorLogLevel;
    set logLevel(value: ExtractorLogLevel);
    readonly messageId: tsdoc.TSDocMessageId | ExtractorMessageId | ConsoleMessageId | string;
    readonly properties: IExtractorMessageProperties;
    readonly sourceFileColumn: number | undefined;
    readonly sourceFileLine: number | undefined;
    readonly sourceFilePath: string | undefined;
    readonly text: string;
}

// @public
export enum ExtractorMessageCategory {
    Compiler = "Compiler",
    Console = "console",
    Extractor = "Extractor",
    TSDoc = "TSDoc"
}

// @public
export enum ExtractorMessageId {
    CyclicInheritDoc = "ae-cyclic-inherit-doc",
    DifferentReleaseTags = "ae-different-release-tags",
    ExtraReleaseTag = "ae-extra-release-tag",
    ForgottenExport = "ae-forgotten-export",
    IncompatibleReleaseTags = "ae-incompatible-release-tags",
    InternalMissingUnderscore = "ae-internal-missing-underscore",
    InternalMixedReleaseTag = "ae-internal-mixed-release-tag",
    MisplacedPackageTag = "ae-misplaced-package-tag",
    MissingGetter = "ae-missing-getter",
    MissingReleaseTag = "ae-missing-release-tag",
    PreapprovedBadReleaseTag = "ae-preapproved-bad-release-tag",
    PreapprovedUnsupportedType = "ae-preapproved-unsupported-type",
    SetterWithDocs = "ae-setter-with-docs",
    Undocumented = "ae-undocumented",
    UnresolvedInheritDocBase = "ae-unresolved-inheritdoc-base",
    UnresolvedInheritDocReference = "ae-unresolved-inheritdoc-reference",
    UnresolvedLink = "ae-unresolved-link",
    WrongInputFileType = "ae-wrong-input-file-type"
}

// @public
export class ExtractorResult {
    // @internal
    constructor(properties: ExtractorResult);
    readonly apiReportChanged: boolean;
    readonly compilerState: CompilerState;
    readonly errorCount: number;
    readonly extractorConfig: ExtractorConfig;
    readonly succeeded: boolean;
    readonly warningCount: number;
}

// @public
export interface ICompilerStateCreateOptions {
    additionalEntryPoints?: string[];
    typescriptCompilerFolder?: string;
}

// @public
export interface IConfigApiReport {
    enabled: boolean;
    includeForgottenExports?: boolean;
    reportFileName?: string;
    reportFolder?: string;
    reportTempFolder?: string;
    reportVariants?: ApiReportVariant[];
}

// @public
export interface IConfigCompiler {
    overrideTsconfig?: {};
    skipLibCheck?: boolean;
    tsconfigFilePath?: string;
}

// @public
export interface IConfigDocModel {
    apiJsonFilePath?: string;
    enabled: boolean;
    includeForgottenExports?: boolean;
    projectFolderUrl?: string;
}

// @public
export interface IConfigDtsRollup {
    alphaTrimmedFilePath?: string;
    betaTrimmedFilePath?: string;
    enabled: boolean;
    omitTrimmingComments?: boolean;
    publicTrimmedFilePath?: string;
    untrimmedFilePath?: string;
}

// @public
export interface IConfigFile {
    apiReport?: IConfigApiReport;
    bundledPackages?: string[];
    compiler?: IConfigCompiler;
    docModel?: IConfigDocModel;
    // @beta
    dtsRollup?: IConfigDtsRollup;
    enumMemberOrder?: EnumMemberOrder;
    extends?: string;
    mainEntryPointFilePath: string;
    messages?: IExtractorMessagesConfig;
    newlineKind?: 'crlf' | 'lf' | 'os';
    projectFolder?: string;
    testMode?: boolean;
    // @beta
    tsdocMetadata?: IConfigTsdocMetadata;
}

// @public
export interface IConfigMessageReportingRule {
    addToApiReportFile?: boolean;
    logLevel: ExtractorLogLevel;
}

// @public
export interface IConfigMessageReportingTable {
    [messageId: string]: IConfigMessageReportingRule;
}

// @public
export interface IConfigTsdocMetadata {
    enabled: boolean;
    tsdocMetadataFilePath?: string;
}

// @public
export interface IExtractorConfigApiReport {
    fileName: string;
    variant: ApiReportVariant;
}

// @public
export interface IExtractorConfigLoadForFolderOptions {
    packageJsonLookup?: PackageJsonLookup;
    rigConfig?: IRigConfig;
    startingFolder: string;
}

// @public
export interface IExtractorConfigPrepareOptions {
    configObject: IConfigFile;
    configObjectFullPath: string | undefined;
    ignoreMissingEntryPoint?: boolean;
    packageJson?: INodePackageJson | undefined;
    packageJsonFullPath: string | undefined;
    projectFolderLookupToken?: string;
    tsdocConfigFile?: TSDocConfigFile;
}

// @public
export interface IExtractorInvokeOptions {
    compilerState?: CompilerState;
    localBuild?: boolean;
    messageCallback?: (message: ExtractorMessage) => void;
    showDiagnostics?: boolean;
    showVerboseMessages?: boolean;
    typescriptCompilerFolder?: string;
}

// @public
export interface IExtractorMessageProperties {
    readonly exportName?: string;
}

// @public
export interface IExtractorMessagesConfig {
    compilerMessageReporting?: IConfigMessageReportingTable;
    extractorMessageReporting?: IConfigMessageReportingTable;
    tsdocMessageReporting?: IConfigMessageReportingTable;
}

```
