// Copyright (c) Microsoft Corporation. All rights reserved. Licensed under the MIT license.
// See LICENSE in the project root for license information.

/**
 * Describes the `window.appContext` object that the Node.js service uses
 * to communicate runtime configuration to the web app.
 *
 * @remarks
 * The `dist/index.html` page loads a script `initappcontext.js` to initialize
 * this object before the web app starts.
 *
 * When the app is hosted by Webpack dev server, this is implemented by
 * `lockfile-explorer-web/src/stub/initappcontext.ts`.
 *
 * When the app is hosted by the CLI front end, the `initappcontext.js` content
 * is generated by an Express route.
 */
export interface IAppContext {
  /**
   * The service URL, without the trailing slash.
   *
   * @example
   * Example: `http://localhost:8091`
   */
  serviceUrl: string;

  /**
   * The `package.json` version for the app.
   */
  appVersion: string;

  /**
   * Whether the CLI was invoked with the `--debug` parameter.
   */
  debugMode: boolean;
}

declare global {
  // eslint-disable-next-line @typescript-eslint/naming-convention
  interface Window {
    appContext: IAppContext;
  }
}
