---
name: 'API Extractor'
about: Report an issue related to the '@microsoft/api-extractor' project and associated packages
title: '[api-extractor] '
labels: ''
assignees: ''
---

<!-- Have a question?  Before creating an issue, ask in the chat room: https://rushstack.zulipchat.com/ -->

<!-- Invoke API Extractor with the "--diagnostics" parameter.  It often prints information that is helpful for diagnosing problems. -->

<!--------------------------------------------------------------------------
👉 STEP 1: Write a concise but specific issue title in the box above.
     Example: "[api-extractor] Using --example switch causes TypeError"
--------------------------------------------------------------------------->

## Summary

<!--------------------------------------------------------------------------
👉 STEP 2: In a few sentences, please explain:

     What were you trying to accomplish?
     What action did you perform that ran into trouble?
     What went wrong?
--------------------------------------------------------------------------->

## Repro steps

<!--------------------------------------------------------------------------
👉 STEP 3: If your issue is a feature request and not a bug, delete this
     "Repro steps" section and skip to STEP 6.

👉 STEP 4: In many cases we can investigate bugs much faster if you include:
     The URL for a simplified Git branch that reproduces the problem.
     Step by step instructions for how to build the branch and see the error.

👉 STEP 5: It's also helpful to include an "expected" and "actual" result.
     But if that's not relevant, feel free to delete those fields.
--------------------------------------------------------------------------->

  **Expected result:** <!-- What you expected these steps to accomplish -->

  **Actual result:** <!-- If an error occurred, include the full error message text and any call stack. -->

## Details

<!--------------------------------------------------------------------------
👉 STEP 6: Provide any additional information you think might be helpful:

     What do you think is the cause of this problem?
     How do you think we should fix this?
--------------------------------------------------------------------------->

## Standard questions

Please answer these questions to help us investigate your issue more quickly:

| Question | Answer |
| -------- | -------- |
| `@microsoft/api-extractor` version? | <!-- X.Y.Z --> |
| Operating system? | <!-- Windows / Mac / Linux --> |
| API Extractor scenario? | <!-- reporting (.api.md) / rollups (.d.ts) / docs (.api.json) --> |
| Would you consider contributing a PR? | <!-- Yes / No --> |
| TypeScript compiler version? | <!-- X.Y.Z --> |
| Node.js version (`node -v`)? | <!-- X.Y.Z --> |
