using System;
using System.Diagnostics;
using System.Text;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    using Microsoft.Diagnostics.Tracing.Parsers.Tpl;

    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "2.0")]
    public sealed class TplEtwProviderTraceEventParser : TraceEventParser
    {
        public static readonly string ProviderName = "System.Threading.Tasks.TplEventSource";
        public static readonly Guid ProviderGuid = new Guid(unchecked((int)0x2e5dba47), unchecked((short)0xa3d2), unchecked((short)0x4d16), 0x8e, 0xe0, 0x66, 0x71, 0xff, 0xdc, 0xd7, 0xb5);
        public enum Keywords : long
        {
            None = 0,
            Tasktransfer = 0x1,
            Tasks = 0x2,
            Parallel = 0x4,
            Asynccausalityoperation = 0x8,
            Asynccausalityrelation = 0x10,
            Asynccausalitysynchronouswork = 0x20,
            Taskstops = 0x40,
            TasksFlowActivityIds = 0x80,
            AsyncMethod = 0x100,
            Default = Tasktransfer | Tasks | Parallel | Asynccausalityoperation | Asynccausalityrelation | Asynccausalitysynchronouswork | Taskstops | TasksFlowActivityIds | AsyncMethod, 
        };

        public TplEtwProviderTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<AwaitTaskContinuationScheduledArgs> AwaitTaskContinuationScheduledSend
        {
            add
            {
                source.RegisterEventTemplate(AwaitTaskContinuationScheduledSendTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 12, ProviderGuid);
            }
        }
        public event Action<ParallelForkArgs> ForkJoinStart
        {
            add
            {
                source.RegisterEventTemplate(ForkJoinStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 5, ProviderGuid);
            }
        }
        public event Action<ParallelJoinArgs> ForkJoinStop
        {
            add
            {
                source.RegisterEventTemplate(ForkJoinStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 6, ProviderGuid);
            }
        }
        public event Action<ParallelInvokeBeginArgs> InvokeStart
        {
            add
            {
                source.RegisterEventTemplate(InvokeStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 3, ProviderGuid);
            }
        }
        public event Action<ParallelInvokeEndArgs> InvokeStop
        {
            add
            {
                source.RegisterEventTemplate(InvokeStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 4, ProviderGuid);
            }
        }
        public event Action<ParallelLoopBeginArgs> LoopStart
        {
            add
            {
                source.RegisterEventTemplate(LoopStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1, ProviderGuid);
            }
        }
        public event Action<ParallelLoopEndArgs> LoopStop
        {
            add
            {
                source.RegisterEventTemplate(LoopStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 2, ProviderGuid);
            }
        }
        public event Action<TaskStartedArgs> TaskExecuteStart
        {
            add
            {
                source.RegisterEventTemplate(TaskExecuteStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 8, ProviderGuid);
            }
        }
        public event Action<TaskCompletedArgs> TaskExecuteStop
        {
            add
            {
                source.RegisterEventTemplate(TaskExecuteStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 9, ProviderGuid);
            }
        }
        public event Action<TaskScheduledArgs> TaskScheduledSend
        {
            add
            {
                source.RegisterEventTemplate(TaskScheduledSendTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 7, ProviderGuid);
            }
        }
        public event Action<TaskWaitContinuationCompleteArgs> TaskWaitContinuationComplete
        {
            add
            {
                source.RegisterEventTemplate(TaskWaitContinuationCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 13, ProviderGuid);
            }
        }
        public event Action<TaskWaitSendArgs> TaskWaitSend
        {
            add
            {
                source.RegisterEventTemplate(TaskWaitSendTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 10, ProviderGuid);
            }
        }
        public event Action<TaskWaitStopArgs> TaskWaitStop
        {
            add
            {
                source.RegisterEventTemplate(TaskWaitStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 11, ProviderGuid);
            }
        }
        public event Action<TraceOperationRelationArgs> TraceOperationRelation
        {
            add
            {
                source.RegisterEventTemplate(TraceOperationRelationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 16, ProviderGuid);
            }
        }
        public event Action<TraceOperationStartArgs> TraceOperationStart
        {
            add
            {
                source.RegisterEventTemplate(TraceOperationStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 14, ProviderGuid);
            }
        }
        public event Action<TraceOperationStopArgs> TraceOperationStop
        {
            add
            {
                source.RegisterEventTemplate(TraceOperationStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 15, ProviderGuid);
            }
        }
        public event Action<TraceSynchronousWorkStartArgs> TraceSynchronousWorkStart
        {
            add
            {
                source.RegisterEventTemplate(TraceSynchronousWorkStartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 17, ProviderGuid);
            }
        }
        public event Action<TraceSynchronousWorkStopArgs> TraceSynchronousWorkStop
        {
            add
            {
                source.RegisterEventTemplate(TraceSynchronousWorkStopTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 18, ProviderGuid);
            }
        }
        public event Action<IncompleteAsyncMethodArgs> IncompleteAsyncMethod
        {
            add
            {
                source.RegisterEventTemplate(IncompleteAsyncMethodTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 27, ProviderGuid);
            }
        }

        #region private
        protected override string GetProviderName() { return ProviderName; }

        static private AwaitTaskContinuationScheduledArgs AwaitTaskContinuationScheduledSendTemplate(Action<AwaitTaskContinuationScheduledArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new AwaitTaskContinuationScheduledArgs(action, 12, 7, "AwaitTaskContinuationScheduled", Guid.Empty, 9, "Send", ProviderGuid, ProviderName);
        }
        static private ParallelForkArgs ForkJoinStartTemplate(Action<ParallelForkArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ParallelForkArgs(action, 5, 5, "ForkJoin", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private ParallelJoinArgs ForkJoinStopTemplate(Action<ParallelJoinArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ParallelJoinArgs(action, 6, 5, "ForkJoin", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private ParallelInvokeBeginArgs InvokeStartTemplate(Action<ParallelInvokeBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ParallelInvokeBeginArgs(action, 3, 2, "Invoke", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private ParallelInvokeEndArgs InvokeStopTemplate(Action<ParallelInvokeEndArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ParallelInvokeEndArgs(action, 4, 2, "Invoke", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private ParallelLoopBeginArgs LoopStartTemplate(Action<ParallelLoopBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ParallelLoopBeginArgs(action, 1, 1, "Loop", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private ParallelLoopEndArgs LoopStopTemplate(Action<ParallelLoopEndArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new ParallelLoopEndArgs(action, 2, 1, "Loop", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private TaskStartedArgs TaskExecuteStartTemplate(Action<TaskStartedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskStartedArgs(action, 8, 3, "TaskExecute", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private TaskCompletedArgs TaskExecuteStopTemplate(Action<TaskCompletedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskCompletedArgs(action, 9, 3, "TaskExecute", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private TaskScheduledArgs TaskScheduledSendTemplate(Action<TaskScheduledArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskScheduledArgs(action, 7, 6, "TaskScheduled", Guid.Empty, 9, "Send", ProviderGuid, ProviderName);
        }
        static private TaskWaitContinuationCompleteArgs TaskWaitContinuationCompleteTemplate(Action<TaskWaitContinuationCompleteArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskWaitContinuationCompleteArgs(action, 13, 65521, "TaskWaitContinuationComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TaskWaitSendArgs TaskWaitSendTemplate(Action<TaskWaitSendArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskWaitSendArgs(action, 10, 4, "TaskWait", Guid.Empty, 9, "Send", ProviderGuid, ProviderName);
        }
        static private TaskWaitStopArgs TaskWaitStopTemplate(Action<TaskWaitStopArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TaskWaitStopArgs(action, 11, 4, "TaskWait", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private TraceOperationRelationArgs TraceOperationRelationTemplate(Action<TraceOperationRelationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TraceOperationRelationArgs(action, 16, 65518, "TraceOperationRelation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TraceOperationStartArgs TraceOperationStartTemplate(Action<TraceOperationStartArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TraceOperationStartArgs(action, 14, 8, "TraceOperation", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private TraceOperationStopArgs TraceOperationStopTemplate(Action<TraceOperationStopArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TraceOperationStopArgs(action, 15, 8, "TraceOperation", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private TraceSynchronousWorkStartArgs TraceSynchronousWorkStartTemplate(Action<TraceSynchronousWorkStartArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TraceSynchronousWorkStartArgs(action, 17, 9, "TraceSynchronousWork", Guid.Empty, 1, "Start", ProviderGuid, ProviderName);
        }
        static private TraceSynchronousWorkStopArgs TraceSynchronousWorkStopTemplate(Action<TraceSynchronousWorkStopArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TraceSynchronousWorkStopArgs(action, 18, 9, "TraceSynchronousWork", Guid.Empty, 2, "Stop", ProviderGuid, ProviderName);
        }
        static private IncompleteAsyncMethodArgs IncompleteAsyncMethodTemplate(Action<IncompleteAsyncMethodArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IncompleteAsyncMethodArgs(action, 27, 65507, "IncompleteAsyncMethod", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        
        static private volatile TraceEvent[] s_templates;
        protected internal override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[19];
                templates[0] = LoopStartTemplate(null);
                templates[1] = LoopStopTemplate(null);
                templates[2] = InvokeStartTemplate(null);
                templates[3] = InvokeStopTemplate(null);
                templates[4] = ForkJoinStartTemplate(null);
                templates[5] = ForkJoinStopTemplate(null);
                templates[6] = TaskScheduledSendTemplate(null);
                templates[7] = TaskExecuteStartTemplate(null);
                templates[8] = TaskExecuteStopTemplate(null);
                templates[9] = TaskWaitSendTemplate(null);
                templates[10] = TaskWaitStopTemplate(null);
                templates[11] = TaskWaitContinuationCompleteTemplate(null);
                templates[12] = AwaitTaskContinuationScheduledSendTemplate(null);
                templates[13] = TraceOperationStartTemplate(null);
                templates[14] = TraceOperationRelationTemplate(null);
                templates[15] = TraceOperationStopTemplate(null);
                templates[16] = TraceSynchronousWorkStartTemplate(null);
                templates[17] = TraceSynchronousWorkStopTemplate(null);
                templates[18] = IncompleteAsyncMethodTemplate(null);

                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.Tpl
{
    public sealed class AwaitTaskContinuationScheduledArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int ContinuationId { get { return GetInt32At(8); } }

        #region Private
        internal AwaitTaskContinuationScheduledArgs(Action<AwaitTaskContinuationScheduledArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<AwaitTaskContinuationScheduledArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "ContinuationId", ContinuationId);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "ContinuationId" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return ContinuationId;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<AwaitTaskContinuationScheduledArgs> m_target;
        #endregion
    }
    public sealed class ParallelForkArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int ForkJoinContextID { get { return GetInt32At(8); } }

        #region Private
        internal ParallelForkArgs(Action<ParallelForkArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ParallelForkArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "ForkJoinContextID", ForkJoinContextID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "ForkJoinContextID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return ForkJoinContextID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ParallelForkArgs> m_target;
        #endregion
    }
    public sealed class ParallelJoinArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int ForkJoinContextID { get { return GetInt32At(8); } }

        #region Private
        internal ParallelJoinArgs(Action<ParallelJoinArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ParallelJoinArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "ForkJoinContextID", ForkJoinContextID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "ForkJoinContextID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return ForkJoinContextID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ParallelJoinArgs> m_target;
        #endregion
    }
    public sealed class ParallelInvokeBeginArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int ForkJoinContextID { get { return GetInt32At(8); } }
        public ForkJoinOperationType OperationType { get { return (ForkJoinOperationType)GetInt32At(12); } }
        public int ActionCount { get { return GetInt32At(16); } }

        #region Private
        internal ParallelInvokeBeginArgs(Action<ParallelInvokeBeginArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 20));
            Debug.Assert(!(Version > 0 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ParallelInvokeBeginArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "ForkJoinContextID", ForkJoinContextID);
            XmlAttrib(sb, "OperationType", OperationType);
            XmlAttrib(sb, "ActionCount", ActionCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "ForkJoinContextID", "OperationType", "ActionCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return ForkJoinContextID;
                case 3:
                    return OperationType;
                case 4:
                    return ActionCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ParallelInvokeBeginArgs> m_target;
        #endregion
    }
    public sealed class ParallelInvokeEndArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int ForkJoinContextID { get { return GetInt32At(8); } }

        #region Private
        internal ParallelInvokeEndArgs(Action<ParallelInvokeEndArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ParallelInvokeEndArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "ForkJoinContextID", ForkJoinContextID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "ForkJoinContextID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return ForkJoinContextID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ParallelInvokeEndArgs> m_target;
        #endregion
    }
    public sealed class ParallelLoopBeginArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int ForkJoinContextID { get { return GetInt32At(8); } }
        public ForkJoinOperationType OperationType { get { return (ForkJoinOperationType)GetInt32At(12); } }
        public long InclusiveFrom { get { return GetInt64At(16); } }
        public long ExclusiveTo { get { return GetInt64At(24); } }

        #region Private
        internal ParallelLoopBeginArgs(Action<ParallelLoopBeginArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 32));
            Debug.Assert(!(Version > 0 && EventDataLength < 32));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ParallelLoopBeginArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "ForkJoinContextID", ForkJoinContextID);
            XmlAttrib(sb, "OperationType", OperationType);
            XmlAttrib(sb, "InclusiveFrom", InclusiveFrom);
            XmlAttrib(sb, "ExclusiveTo", ExclusiveTo);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "ForkJoinContextID", "OperationType", "InclusiveFrom", "ExclusiveTo" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return ForkJoinContextID;
                case 3:
                    return OperationType;
                case 4:
                    return InclusiveFrom;
                case 5:
                    return ExclusiveTo;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ParallelLoopBeginArgs> m_target;
        #endregion
    }
    public sealed class ParallelLoopEndArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int ForkJoinContextID { get { return GetInt32At(8); } }
        public long TotalIterations { get { return GetInt64At(12); } }

        #region Private
        internal ParallelLoopEndArgs(Action<ParallelLoopEndArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 20));
            Debug.Assert(!(Version > 0 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<ParallelLoopEndArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "ForkJoinContextID", ForkJoinContextID);
            XmlAttrib(sb, "TotalIterations", TotalIterations);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "ForkJoinContextID", "TotalIterations" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return ForkJoinContextID;
                case 3:
                    return TotalIterations;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<ParallelLoopEndArgs> m_target;
        #endregion
    }
    public sealed class TaskStartedArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int TaskID { get { return GetInt32At(8); } }

        #region Private
        internal TaskStartedArgs(Action<TaskStartedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskStartedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "TaskID", TaskID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "TaskID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return TaskID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskStartedArgs> m_target;
        #endregion
    }
    public sealed class TaskCompletedArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int TaskID { get { return GetInt32At(8); } }
        public bool IsExceptional { get { return GetInt32At(12) != 0; } }

        #region Private
        internal TaskCompletedArgs(Action<TaskCompletedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 16));
            Debug.Assert(!(Version > 1 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskCompletedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "TaskID", TaskID);
            XmlAttrib(sb, "IsExceptional", IsExceptional);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "TaskID", "IsExceptional" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return TaskID;
                case 3:
                    return IsExceptional;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskCompletedArgs> m_target;
        #endregion
    }
    public sealed class TaskScheduledArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int TaskID { get { return GetInt32At(8); } }
        public int CreatingTaskID { get { return GetInt32At(12); } }
        public int TaskCreationOptions { get { return GetInt32At(16); } }

        #region Private
        internal TaskScheduledArgs(Action<TaskScheduledArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 20));
            Debug.Assert(!(Version > 0 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskScheduledArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "TaskID", TaskID);
            XmlAttrib(sb, "CreatingTaskID", CreatingTaskID);
            XmlAttrib(sb, "TaskCreationOptions", TaskCreationOptions);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "TaskID", "CreatingTaskID", "TaskCreationOptions" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return TaskID;
                case 3:
                    return CreatingTaskID;
                case 4:
                    return TaskCreationOptions;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskScheduledArgs> m_target;
        #endregion
    }
    public sealed class TaskWaitContinuationCompleteArgs : TraceEvent
    {
        public int TaskID { get { return GetInt32At(0); } }

        #region Private
        internal TaskWaitContinuationCompleteArgs(Action<TaskWaitContinuationCompleteArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 4));
            Debug.Assert(!(Version > 0 && EventDataLength < 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskWaitContinuationCompleteArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TaskID", TaskID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TaskID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TaskID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskWaitContinuationCompleteArgs> m_target;
        #endregion
    }
    public sealed class TaskWaitSendArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int TaskID { get { return GetInt32At(8); } }
        public TaskWaitBehavior Behavior { get { if (EventDataLength < 16) { return 0; } return (TaskWaitBehavior)GetInt32At(12); } }
        public int ContinueWithTaskID { get { if (EventDataLength < 20) { return 0; } return GetInt32At(16); } }

        #region Private
        internal TaskWaitSendArgs(Action<TaskWaitSendArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 2 && EventDataLength != 20));
            Debug.Assert(!(Version > 2 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskWaitSendArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "TaskID", TaskID);
            XmlAttrib(sb, "Behavior", Behavior);
            XmlAttrib(sb, "ContinueWithTaskID", ContinueWithTaskID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "TaskID", "Behavior", "ContinueWithTaskID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return TaskID;
                case 3:
                    return Behavior;
                case 4:
                    return ContinueWithTaskID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskWaitSendArgs> m_target;
        #endregion
    }
    public sealed class TaskWaitStopArgs : TraceEvent
    {
        public int OriginatingTaskSchedulerID { get { return GetInt32At(0); } }
        public int OriginatingTaskID { get { return GetInt32At(4); } }
        public int TaskID { get { return GetInt32At(8); } }

        #region Private
        internal TaskWaitStopArgs(Action<TaskWaitStopArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TaskWaitStopArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OriginatingTaskSchedulerID", OriginatingTaskSchedulerID);
            XmlAttrib(sb, "OriginatingTaskID", OriginatingTaskID);
            XmlAttrib(sb, "TaskID", TaskID);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OriginatingTaskSchedulerID", "OriginatingTaskID", "TaskID" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OriginatingTaskSchedulerID;
                case 1:
                    return OriginatingTaskID;
                case 2:
                    return TaskID;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TaskWaitStopArgs> m_target;
        #endregion
    }
    public sealed class TraceOperationRelationArgs : TraceEvent
    {
        public int TaskID { get { return GetInt32At(0); } }
        public CausalityRelation Relation { get { return (CausalityRelation)GetInt32At(4); } }

        #region Private
        internal TraceOperationRelationArgs(Action<TraceOperationRelationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 8));
            Debug.Assert(!(Version > 1 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TraceOperationRelationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TaskID", TaskID);
            XmlAttrib(sb, "Relation", Relation);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TaskID", "Relation" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TaskID;
                case 1:
                    return Relation;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TraceOperationRelationArgs> m_target;
        #endregion
    }
    public sealed class TraceOperationStartArgs : TraceEvent
    {
        public int TaskID { get { return GetInt32At(0); } }
        public string OperationName { get { return GetUnicodeStringAt(4); } }
        public long RelatedContext { get { return GetInt64At(SkipUnicodeString(4)); } }

        #region Private
        internal TraceOperationStartArgs(Action<TraceOperationStartArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != SkipUnicodeString(4) + 8));
            Debug.Assert(!(Version > 1 && EventDataLength < SkipUnicodeString(4) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TraceOperationStartArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TaskID", TaskID);
            XmlAttrib(sb, "OperationName", OperationName);
            XmlAttrib(sb, "RelatedContext", RelatedContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TaskID", "OperationName", "RelatedContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TaskID;
                case 1:
                    return OperationName;
                case 2:
                    return RelatedContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TraceOperationStartArgs> m_target;
        #endregion
    }
    public sealed class TraceOperationStopArgs : TraceEvent
    {
        public int TaskID { get { return GetInt32At(0); } }
        public AsyncCausalityStatus Status { get { return (AsyncCausalityStatus)GetInt32At(4); } }

        #region Private
        internal TraceOperationStopArgs(Action<TraceOperationStopArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 8));
            Debug.Assert(!(Version > 1 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TraceOperationStopArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TaskID", TaskID);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TaskID", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TaskID;
                case 1:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TraceOperationStopArgs> m_target;
        #endregion
    }
    public sealed class TraceSynchronousWorkStartArgs : TraceEvent
    {
        public int TaskID { get { return GetInt32At(0); } }
        public CausalitySynchronousWork Work { get { return (CausalitySynchronousWork)GetInt32At(4); } }

        #region Private
        internal TraceSynchronousWorkStartArgs(Action<TraceSynchronousWorkStartArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 8));
            Debug.Assert(!(Version > 1 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TraceSynchronousWorkStartArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TaskID", TaskID);
            XmlAttrib(sb, "Work", Work);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TaskID", "Work" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TaskID;
                case 1:
                    return Work;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TraceSynchronousWorkStartArgs> m_target;
        #endregion
    }
    public sealed class TraceSynchronousWorkStopArgs : TraceEvent
    {
        public CausalitySynchronousWork Work { get { return (CausalitySynchronousWork)GetInt32At(0); } }

        #region Private
        internal TraceSynchronousWorkStopArgs(Action<TraceSynchronousWorkStopArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 1 && EventDataLength != 4));
            Debug.Assert(!(Version > 1 && EventDataLength < 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TraceSynchronousWorkStopArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Work", Work);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Work" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Work;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TraceSynchronousWorkStopArgs> m_target;
        #endregion
    }
    public sealed class IncompleteAsyncMethodArgs : TraceEvent
    {
        public string stateMachineDescription { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal IncompleteAsyncMethodArgs(Action<IncompleteAsyncMethodArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            this.m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IncompleteAsyncMethodArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "stateMachineDescription", stateMachineDescription);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                    payloadNames = new string[] { "stateMachineDescription" };
                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return stateMachineDescription;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        public static ulong GetKeywords() { return 256; }
        public static string GetProviderName() { return "System.Threading.Tasks.TplEventSource"; }
        public static Guid GetProviderGuid() { return new Guid("2e5dba47-a3d2-4d16-8ee0-6671ffdcd7b5"); }
        private event Action<IncompleteAsyncMethodArgs> m_target;
        #endregion
    }

    public enum AsyncCausalityStatus
    {
        Started = 0x0,
        Completed = 0x1,
        Canceled = 0x2,
        Error = 0x3,
    }
    public enum CausalityRelation
    {
        AssignDelegate = 0x0,
        Join = 0x1,
        Choice = 0x2,
        Cancel = 0x3,
        Error = 0x4,
    }
    public enum CausalitySynchronousWork
    {
        CompletionNotification = 0x0,
        ProgressNotification = 0x1,
        Execution = 0x2,
    }
    public enum ForkJoinOperationType
    {
        ParallelInvoke = 0x1,
        ParallelFor = 0x2,
        ParallelForEach = 0x3,
    }
    public enum TaskWaitBehavior
    {
        Synchronous = 0x1,
        Asynchronous = 0x2,
    }
}
