using System;
using System.Diagnostics;
using System.Text;
using Address = System.UInt64;

// This code was automatically generated by the TraceParserGen tool, which converts
// an ETW event manifest into strongly typed C# classes.
namespace Microsoft.Diagnostics.Tracing.Parsers
{
    using Microsoft.Diagnostics.Tracing.Parsers.MicrosoftWindowsTCPIP;

    [System.CodeDom.Compiler.GeneratedCode("traceparsergen", "2.0")]
    public sealed class MicrosoftWindowsTCPIPTraceEventParser : TraceEventParser
    {
        public static readonly string ProviderName = "Microsoft-Windows-TCPIP";
        public static readonly Guid ProviderGuid = new Guid(unchecked((int)0x2f07e2ee), unchecked((short)0x15db), unchecked((short)0x40f1), 0x90, 0xef, 0x9d, 0x7b, 0xa2, 0x82, 0x18, 0x8a);
        public enum Keywords : long
        {
            Uttcpipendpoint = 0x1,
            Uttcpiplistener = 0x2,
            Uttcpiptcb = 0x4,
            Uttcpipbind = 0x8,
            Uttcpipinterface = 0x10,
            Uttcpiproute = 0x20,
            Uttcpipctcp = 0x40,
            Uttcpipdiagnosis = 0x80,
            Uttransfer = 0x100,
            Utprocessidhint = 0x200,
            Utendpoint = 0x400,
            Utrss = 0x800,
            Uttcpipndkpi = 0x1000,
            Uttcpipcsdiag = 0x2000,
            Utsendpath = 0x100000000,
            Utreceivepath = 0x200000000,
            Utconnectpath = 0x400000000,
            Utclosepath = 0x1000000000,
            Utauthentication = 0x2000000000,
            Utconfiguration = 0x4000000000,
            Utglobal = 0x8000000000,
            Keyword10000000000 = 0x10000000000,
            Keyword80000000000 = 0x80000000000,
            Keyword200000000000 = 0x200000000000,
        };

        public MicrosoftWindowsTCPIPTraceEventParser(TraceEventSource source) : base(source) { }

        public event Action<FramingIfOperStatusArgs> FramingIfOperStatus
        {
            add
            {
                source.RegisterEventTemplate(FramingIfOperStatusTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1130, ProviderGuid);
            }
        }
        public event Action<TcpMediaDisconnectArgs> FramingNdisPause
        {
            add
            {
                source.RegisterEventTemplate(FramingNdisPauseTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1136, ProviderGuid);
            }
        }
        public event Action<TcpMediaDisconnectArgs> FramingNdisRestart
        {
            add
            {
                source.RegisterEventTemplate(FramingNdisRestartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1137, ProviderGuid);
            }
        }
        public event Action<IpDadFailedArgs> IpAddressAdded
        {
            add
            {
                source.RegisterEventTemplate(IpAddressAddedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1127, ProviderGuid);
            }
        }
        public event Action<IpDadFailedArgs> IpAddressDeleted
        {
            add
            {
                source.RegisterEventTemplate(IpAddressDeletedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1128, ProviderGuid);
            }
        }
        public event Action<IpDadFailedArgs> IpAddressStateNonPreferred
        {
            add
            {
                source.RegisterEventTemplate(IpAddressStateNonPreferredTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1139, ProviderGuid);
            }
        }
        public event Action<IpDadFailedArgs> IpAddressStatePreferred
        {
            add
            {
                source.RegisterEventTemplate(IpAddressStatePreferredTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1138, ProviderGuid);
            }
        }
        public event Action<IpDadFailedArgs> IpDadFailed
        {
            add
            {
                source.RegisterEventTemplate(IpDadFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1115, ProviderGuid);
            }
        }
        public event Action<IpDadFailedArgs> IpDadStarted
        {
            add
            {
                source.RegisterEventTemplate(IpDadStartedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1116, ProviderGuid);
            }
        }
        public event Action<IpDadSuccessfulArgs> IpDadSuccessful
        {
            add
            {
                source.RegisterEventTemplate(IpDadSuccessfulTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1114, ProviderGuid);
            }
        }
        public event Action<IpInterfacePropertyChangeArgs> IpInterfacePropertyChange
        {
            add
            {
                source.RegisterEventTemplate(IpInterfacePropertyChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1144, ProviderGuid);
            }
        }
        public event Action<IpInterfaceRundownArgs> IpInterfaceRundown
        {
            add
            {
                source.RegisterEventTemplate(IpInterfaceRundownTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1202, ProviderGuid);
            }
        }
        public event Action<IpInterfaceSpeedChangeArgs> IpInterfaceSpeedChange
        {
            add
            {
                source.RegisterEventTemplate(IpInterfaceSpeedChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1203, ProviderGuid);
            }
        }
        public event Action<IpNeighborDiscoveryArgs> IpNeighborDiscovery
        {
            add
            {
                source.RegisterEventTemplate(IpNeighborDiscoveryTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1325, ProviderGuid);
            }
        }
        public event Action<IpNeighborUnreachableArgs> IpNeighborReachable
        {
            add
            {
                source.RegisterEventTemplate(IpNeighborReachableTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1149, ProviderGuid);
            }
        }
        public event Action<IpNeighborStateArgs> IpNeighborState
        {
            add
            {
                source.RegisterEventTemplate(IpNeighborStateTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1324, ProviderGuid);
            }
        }
        public event Action<IpNeighborUnreachableArgs> IpNeighborUnreachable
        {
            add
            {
                source.RegisterEventTemplate(IpNeighborUnreachableTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1148, ProviderGuid);
            }
        }
        public event Action<IpRouteCreatedArgs> IpRouteCreated
        {
            add
            {
                source.RegisterEventTemplate(IpRouteCreatedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1145, ProviderGuid);
            }
        }
        public event Action<IpRouteCreatedArgs> IpRouteDeleted
        {
            add
            {
                source.RegisterEventTemplate(IpRouteDeletedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1146, ProviderGuid);
            }
        }
        public event Action<IpRouteCreatedArgs> IpRoutePropertyChange
        {
            add
            {
                source.RegisterEventTemplate(IpRoutePropertyChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1147, ProviderGuid);
            }
        }
        public event Action<IpSortedAddressPairsArgs> IpSortedAddressPairs
        {
            add
            {
                source.RegisterEventTemplate(IpSortedAddressPairsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1327, ProviderGuid);
            }
        }
        public event Action<IpSourceAddressSelectionArgs> IpSourceAddressSelection
        {
            add
            {
                source.RegisterEventTemplate(IpSourceAddressSelectionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1326, ProviderGuid);
            }
        }
        public event Action<Ndkpi_AcceptArgs> Ndkpi_Accept
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_AcceptTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1267, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Arm_CqArgs> Ndkpi_Arm_Cq
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Arm_CqTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1254, ProviderGuid);
            }
        }
        public event Action<Ndkpi_BindArgs> Ndkpi_Bind
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_BindTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1290, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Build_LamArgs> Ndkpi_Build_Lam
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Build_LamTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1278, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Close_Adapter_EnterArgs> Ndkpi_Close_Adapter_Enter
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Close_Adapter_EnterTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1298, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Close_Adapter_EnterArgs> Ndkpi_Close_Adapter_Exit
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Close_Adapter_ExitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1299, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Close_CompletionArgs> Ndkpi_Close_Completion
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Close_CompletionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1251, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Close_ObjArgs> Ndkpi_Close_Obj
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Close_ObjTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1250, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Complete_ConnectArgs> Ndkpi_Complete_Connect
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Complete_ConnectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1266, ProviderGuid);
            }
        }
        public event Action<Ndkpi_ConnectArgs> Ndkpi_Connect
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_ConnectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1264, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Connect_Event_CallbackArgs> Ndkpi_Connect_Event_Callback
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Connect_Event_CallbackTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1283, ProviderGuid);
            }
        }
        public event Action<Ndkpi_ConnectArgs> Ndkpi_Connect_Shared_Endpoint
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Connect_Shared_EndpointTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1265, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Control_Cq_ImArgs> Ndkpi_Control_Cq_Im
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Control_Cq_ImTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1314, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Cq_Notification_CallbackArgs> Ndkpi_Cq_Notification_Callback
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Cq_Notification_CallbackTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1280, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Cq_ResultArgs> Ndkpi_Cq_Result
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Cq_ResultTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1255, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Cq_Result_ExArgs> Ndkpi_Cq_Result_Ex
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Cq_Result_ExTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1328, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Create_CompletionArgs> Ndkpi_Create_Completion
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_CompletionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1249, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Deregister_MrArgs> Ndkpi_Create_Connector
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_ConnectorTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1276, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Create_CqArgs> Ndkpi_Create_Cq
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_CqTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1248, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Create_ListenerArgs> Ndkpi_Create_Listener
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_ListenerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1277, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Create_MrArgs> Ndkpi_Create_Mr
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_MrTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1256, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Deregister_MrArgs> Ndkpi_Create_Mw
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_MwTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1270, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Deregister_MrArgs> Ndkpi_Create_Pd
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_PdTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1274, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Create_QpArgs> Ndkpi_Create_Qp
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_QpTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1272, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Create_QpArgs> Ndkpi_Create_Qp_Srq
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_Qp_SrqTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1273, ProviderGuid);
            }
        }
        public event Action<Ndkpi_ListenArgs> Ndkpi_Create_Shared_Endpoint
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_Shared_EndpointTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1275, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Create_SrqArgs> Ndkpi_Create_Srq
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Create_SrqTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1271, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Deregister_MrArgs> Ndkpi_Deregister_Mr
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Deregister_MrTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1261, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Deregister_MrArgs> Ndkpi_Disconnect
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_DisconnectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1268, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Disconnect_Event_CallbackArgs> Ndkpi_Disconnect_Event_Callback
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Disconnect_Event_CallbackTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1282, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Fast_RegisterArgs> Ndkpi_Fast_Register
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Fast_RegisterTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1291, ProviderGuid);
            }
        }
        public event Action<Ndkpi_FlushArgs> Ndkpi_Flush
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_FlushTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1257, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Get_Connect_DataArgs> Ndkpi_Get_Connect_Data
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Get_Connect_DataTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1288, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Get_SockaddrArgs> Ndkpi_Get_Sockaddr
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Get_SockaddrTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1285, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Get_Sockaddr_FailureArgs> Ndkpi_Get_Sockaddr_Failure
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Get_Sockaddr_FailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1286, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Get_TokenArgs> Ndkpi_Get_Token
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Get_TokenTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1284, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Initialize_Fast_Register_MrArgs> Ndkpi_Initialize_Fast_Register_Mr
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Initialize_Fast_Register_MrTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1262, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Interface_EventArgs> Ndkpi_Interface_Event
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Interface_EventTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1301, ProviderGuid);
            }
        }
        public event Action<Ndkpi_InvalidateArgs> Ndkpi_Invalidate
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_InvalidateTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1292, ProviderGuid);
            }
        }
        public event Action<Ndkpi_ListenArgs> Ndkpi_Listen
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_ListenTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1269, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Modify_SrqArgs> Ndkpi_Modify_Srq
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Modify_SrqTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1263, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Open_AdapterArgs> Ndkpi_Open_Adapter
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Open_AdapterTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1297, ProviderGuid);
            }
        }
        public event Action<Ndkpi_ReadArgs> Ndkpi_Read
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_ReadTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1293, ProviderGuid);
            }
        }
        public event Action<Ndkpi_SendArgs> Ndkpi_Receive
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_ReceiveTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1259, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Register_MrArgs> Ndkpi_Register_Mr
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Register_MrTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1260, ProviderGuid);
            }
        }
        public event Action<Ndkpi_RejectArgs> Ndkpi_Reject
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_RejectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1287, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Release_LamArgs> Ndkpi_Release_Lam
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Release_LamTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1279, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Request_CompletionArgs> Ndkpi_Request_Completion
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Request_CompletionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1253, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Resize_CqArgs> Ndkpi_Resize_Cq
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Resize_CqTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1252, ProviderGuid);
            }
        }
        public event Action<Ndkpi_SendArgs> Ndkpi_Send
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_SendTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1258, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Send_InvalidateArgs> Ndkpi_Send_Invalidate
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Send_InvalidateTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1329, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Srq_Notification_CallbackArgs> Ndkpi_Srq_Notification_Callback
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Srq_Notification_CallbackTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1281, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Srq_Work_Request_Inline_FailureArgs> Ndkpi_Srq_Work_Request_Inline_Failure
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Srq_Work_Request_Inline_FailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1296, ProviderGuid);
            }
        }
        public event Action<Ndkpi_SrqReceiveArgs> Ndkpi_SrqReceive
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_SrqReceiveTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1295, ProviderGuid);
            }
        }
        public event Action<Ndkpi_Work_Request_Inline_FailureArgs> Ndkpi_Work_Request_Inline_Failure
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_Work_Request_Inline_FailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1289, ProviderGuid);
            }
        }
        public event Action<Ndkpi_ReadArgs> Ndkpi_Write
        {
            add
            {
                source.RegisterEventTemplate(Ndkpi_WriteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1294, ProviderGuid);
            }
        }
        public event Action<RssBindingBindCompleteArgs> RssBindingBindComplete
        {
            add
            {
                source.RegisterEventTemplate(RssBindingBindCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1241, ProviderGuid);
            }
        }
        public event Action<RssBindingCapabilityArgs> RssBindingCapability
        {
            add
            {
                source.RegisterEventTemplate(RssBindingCapabilityTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1247, ProviderGuid);
            }
        }
        public event Action<RssBindingChangeArgs> RssBindingChange
        {
            add
            {
                source.RegisterEventTemplate(RssBindingChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1230, ProviderGuid);
            }
        }
        public event Action<RssBindingRundownArgs> RssBindingRundown
        {
            add
            {
                source.RegisterEventTemplate(RssBindingRundownTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1245, ProviderGuid);
            }
        }
        public event Action<RssConfigurationChangeArgs> RssConfigurationChange
        {
            add
            {
                source.RegisterEventTemplate(RssConfigurationChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1239, ProviderGuid);
            }
        }
        public event Action<RssFailureArgs> RssFailure
        {
            add
            {
                source.RegisterEventTemplate(RssFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1240, ProviderGuid);
            }
        }
        public event Action<RssIndirectionChangeArgs> RssIndirectionChange
        {
            add
            {
                source.RegisterEventTemplate(RssIndirectionChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1237, ProviderGuid);
            }
        }
        public event Action<RssInitializeIndirectionTableArgs> RssInitializeIndirectionTable
        {
            add
            {
                source.RegisterEventTemplate(RssInitializeIndirectionTableTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1244, ProviderGuid);
            }
        }
        public event Action<RssPortBindCompleteArgs> RssPortBindComplete
        {
            add
            {
                source.RegisterEventTemplate(RssPortBindCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1242, ProviderGuid);
            }
        }
        public event Action<RssPortCapabilitiesArgs> RssPortCapabilities
        {
            add
            {
                source.RegisterEventTemplate(RssPortCapabilitiesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1233, ProviderGuid);
            }
        }
        public event Action<RssPortChangeArgs> RssPortChange
        {
            add
            {
                source.RegisterEventTemplate(RssPortChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1231, ProviderGuid);
            }
        }
        public event Action<RssPortBindCompleteArgs> RssPortNotSupported
        {
            add
            {
                source.RegisterEventTemplate(RssPortNotSupportedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1243, ProviderGuid);
            }
        }
        public event Action<RssPortProcessorsArgs> RssPortProcessors
        {
            add
            {
                source.RegisterEventTemplate(RssPortProcessorsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1234, ProviderGuid);
            }
        }
        public event Action<RssPortReferenceArgs> RssPortReference
        {
            add
            {
                source.RegisterEventTemplate(RssPortReferenceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1232, ProviderGuid);
            }
        }
        public event Action<RssPortRundownArgs> RssPortRundown
        {
            add
            {
                source.RegisterEventTemplate(RssPortRundownTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1246, ProviderGuid);
            }
        }
        public event Action<RssProcessorAssignmentArgs> RssProcessorAssignment
        {
            add
            {
                source.RegisterEventTemplate(RssProcessorAssignmentTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1235, ProviderGuid);
            }
        }
        public event Action<RssProcessorConsolidationArgs> RssProcessorConsolidation
        {
            add
            {
                source.RegisterEventTemplate(RssProcessorConsolidationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1238, ProviderGuid);
            }
        }
        public event Action<RssProcessorUnassignmentArgs> RssProcessorUnassignment
        {
            add
            {
                source.RegisterEventTemplate(RssProcessorUnassignmentTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1236, ProviderGuid);
            }
        }
        public event Action<task_0Args> task_0
        {
            add
            {
                source.RegisterEventTemplate(task_0Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1316, ProviderGuid);
            }
        }
        public event Action<task_01317Args> task_01317
        {
            add
            {
                source.RegisterEventTemplate(task_01317Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1317, ProviderGuid);
            }
        }
        public event Action<task_01318Args> task_01318
        {
            add
            {
                source.RegisterEventTemplate(task_01318Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1318, ProviderGuid);
            }
        }
        public event Action<task_01319Args> task_01319
        {
            add
            {
                source.RegisterEventTemplate(task_01319Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1319, ProviderGuid);
            }
        }
        public event Action<task_01320Args> task_01320
        {
            add
            {
                source.RegisterEventTemplate(task_01320Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1320, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpAbortTcbComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpAbortTcbCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1040, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpAbortTcbRequest
        {
            add
            {
                source.RegisterEventTemplate(TcpAbortTcbRequestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1039, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpAcceptListenerComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpAcceptListenerCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1017, ProviderGuid);
            }
        }
        public event Action<TcpAcceptListenerInsertionFailureArgs> TcpAcceptListenerInsertionFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpAcceptListenerInsertionFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1015, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpAcceptListenerRejected
        {
            add
            {
                source.RegisterEventTemplate(TcpAcceptListenerRejectedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1016, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpAccpetListenerRouteLookupFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpAccpetListenerRouteLookupFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1014, ProviderGuid);
            }
        }
        public event Action<TcpAcquirePortArgs> TcpAcquirePort
        {
            add
            {
                source.RegisterEventTemplate(TcpAcquirePortTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1191, ProviderGuid);
            }
        }
        public event Action<TcpAcquirePortArgs> TcpAcquireWeakRefPort
        {
            add
            {
                source.RegisterEventTemplate(TcpAcquireWeakRefPortTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1192, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpAppSendBufferSize
        {
            add
            {
                source.RegisterEventTemplate(TcpAppSendBufferSizeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1091, ProviderGuid);
            }
        }
        public event Action<TcpAcquirePortArgs> TcpAssignedWeakReferencePort
        {
            add
            {
                source.RegisterEventTemplate(TcpAssignedWeakReferencePortTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1195, ProviderGuid);
            }
        }
        public event Action<TcpAutoTuningBeginArgs> TcpAutoTuningBegin
        {
            add
            {
                source.RegisterEventTemplate(TcpAutoTuningBeginTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1092, ProviderGuid);
            }
        }
        public event Action<TcpAutoTuningBeginArgs> TcpAutoTuningChangeRcvBufferSize
        {
            add
            {
                source.RegisterEventTemplate(TcpAutoTuningChangeRcvBufferSizeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1097, ProviderGuid);
            }
        }
        public event Action<TcpAutoTuningBeginArgs> TcpAutoTuningEnd
        {
            add
            {
                source.RegisterEventTemplate(TcpAutoTuningEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1093, ProviderGuid);
            }
        }
        public event Action<TcpAutoTuningBeginArgs> TcpAutoTuningFailedAllocationFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpAutoTuningFailedAllocationFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1096, ProviderGuid);
            }
        }
        public event Action<TcpAutoTuningBeginArgs> TcpAutoTuningFailedBandwidthEstimation
        {
            add
            {
                source.RegisterEventTemplate(TcpAutoTuningFailedBandwidthEstimationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1095, ProviderGuid);
            }
        }
        public event Action<TcpAutoTuningBeginArgs> TcpAutoTuningFailedRttEstimation
        {
            add
            {
                source.RegisterEventTemplate(TcpAutoTuningFailedRttEstimationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1094, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoverySackExitArgs> TcpBhDetectFullSizeAck
        {
            add
            {
                source.RegisterEventTemplate(TcpBhDetectFullSizeAckTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1196, ProviderGuid);
            }
        }
        public event Action<TcpBindEndpointResolutionFailureArgs> TcpBindEndpointComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpBindEndpointCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1008, ProviderGuid);
            }
        }
        public event Action<TcpBindEndpointResolutionFailureArgs> TcpBindEndpointInspectionFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpBindEndpointInspectionFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1007, ProviderGuid);
            }
        }
        public event Action<TcpBindEndpointResolutionFailureArgs> TcpBindEndpointPortFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpBindEndpointPortFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1006, ProviderGuid);
            }
        }
        public event Action<TcpBindEndpointResolutionFailureArgs> TcpBindEndpointResolutionFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpBindEndpointResolutionFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1005, ProviderGuid);
            }
        }
        public event Action<TcpBlackHoleDetectionEntryArgs> TcpBlackHoleDetectionEntry
        {
            add
            {
                source.RegisterEventTemplate(TcpBlackHoleDetectionEntryTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1084, ProviderGuid);
            }
        }
        public event Action<TcpBlackHoleDetectionEntryArgs> TcpBlackHoleDetectionExit
        {
            add
            {
                source.RegisterEventTemplate(TcpBlackHoleDetectionExitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1085, ProviderGuid);
            }
        }
        public event Action<TcpBlackHoleDetectionEntryArgs> TcpBlackHoleDetectionFailed
        {
            add
            {
                source.RegisterEventTemplate(TcpBlackHoleDetectionFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1086, ProviderGuid);
            }
        }
        public event Action<TcpBindEndpointResolutionFailureArgs> TcpCloseEndpoint
        {
            add
            {
                source.RegisterEventTemplate(TcpCloseEndpointTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1009, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpCloseTcbRequest
        {
            add
            {
                source.RegisterEventTemplate(TcpCloseTcbRequestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1038, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectFailedPortAcquire
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectFailedPortAcquireTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1050, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoveryEntryArgs> TcpConnectionKeepAlive
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectionKeepAliveTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1188, ProviderGuid);
            }
        }
        public event Action<TcpConnectionOffloadStatusArgs> TcpConnectionOffloadPmax
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectionOffloadPmaxTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1113, ProviderGuid);
            }
        }
        public event Action<TcpConnectionOffloadStateChangeArgs> TcpConnectionOffloadStateChange
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectionOffloadStateChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1099, ProviderGuid);
            }
        }
        public event Action<TcpConnectionOffloadStatusArgs> TcpConnectionOffloadStatus
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectionOffloadStatusTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1112, ProviderGuid);
            }
        }
        public event Action<TcpConnectionRundownArgs> TcpConnectionRundown
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectionRundownTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1300, ProviderGuid);
            }
        }
        public event Action<TcpConnectionSummaryArgs> TcpConnectionSummary
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectionSummaryTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1352, ProviderGuid);
            }
        }
        public event Action<TcpRequestConnectArgs> TcpConnectionTerminatedRcvdRst
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectionTerminatedRcvdRstTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1184, ProviderGuid);
            }
        }
        public event Action<TcpRequestConnectArgs> TcpConnectionTerminatedRcvdSyn
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectionTerminatedRcvdSynTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1185, ProviderGuid);
            }
        }
        public event Action<TcpRequestConnectArgs> TcpConnectRestransmit
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectRestransmitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1186, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbCancel
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbCancelTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1029, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbCheckRateLimit
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbCheckRateLimitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1024, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1033, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbEstatsFailed
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbEstatsFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1049, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbFailDontFragment
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailDontFragmentTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1037, ProviderGuid);
            }
        }
        public event Action<TcpInspectConnectCompleteArgs> TcpConnectTcbFailedActiveConnect
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailedActiveConnectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1089, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbFailedAf
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailedAfTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1018, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbFailedCompartment
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailedCompartmentTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1019, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbFailedInspect
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailedInspectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1020, ProviderGuid);
            }
        }
        public event Action<TcpRequestConnectArgs> TcpConnectTcbFailedRcvdRst
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailedRcvdRstTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1183, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbFailedRoute
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailedRouteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1021, ProviderGuid);
            }
        }
        public event Action<TcpRequestConnectArgs> TcpConnectTcbFailInsertion
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailInsertionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1030, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbFailInspectConnectComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailInspectConnectCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1035, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbFailSessionState
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailSessionStateTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1036, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1034, ProviderGuid);
            }
        }
        public event Action<TcpConnectTcbSkipRateLimitArgs> TcpConnectTcbPassRateLimit
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbPassRateLimitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1023, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbProceeding
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbProceedingTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1031, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbRateLimitCancel
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbRateLimitCancelTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1032, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbRateLimitRelease
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbRateLimitReleaseTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1027, ProviderGuid);
            }
        }
        public event Action<TcpConnectTcbSkipRateLimitArgs> TcpConnectTcbSkipRateLimit
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbSkipRateLimitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1022, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpConnectTcbTimeout
        {
            add
            {
                source.RegisterEventTemplate(TcpConnectTcbTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1045, ProviderGuid);
            }
        }
        public event Action<TcpCreateEndpointAfFailureArgs> TcpCreateEndpointAfFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpCreateEndpointAfFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1010, ProviderGuid);
            }
        }
        public event Action<TcpCreateEndpointAfFailureArgs> TcpCreateEndpointCompartmentFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpCreateEndpointCompartmentFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1011, ProviderGuid);
            }
        }
        public event Action<TcpCreateEndpointAfFailureArgs> TcpCreateEndpointComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpCreateEndpointCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1013, ProviderGuid);
            }
        }
        public event Action<TcpCreateEndpointAfFailureArgs> TcpCreateEndpointInspectionFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpCreateEndpointInspectionFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1012, ProviderGuid);
            }
        }
        public event Action<TcpCreateNotificationChannelRequestArgs> TcpCreateNotificationChannelRequest
        {
            add
            {
                source.RegisterEventTemplate(TcpCreateNotificationChannelRequestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1305, ProviderGuid);
            }
        }
        public event Action<TcpCreateNotificationChannelRequestProcessedArgs> TcpCreateNotificationChannelRequestProcessed
        {
            add
            {
                source.RegisterEventTemplate(TcpCreateNotificationChannelRequestProcessedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1307, ProviderGuid);
            }
        }
        public event Action<TcpCreateNotificationChannelRequestProcessingArgs> TcpCreateNotificationChannelRequestProcessing
        {
            add
            {
                source.RegisterEventTemplate(TcpCreateNotificationChannelRequestProcessingTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1315, ProviderGuid);
            }
        }
        public event Action<TcpCTcpAssignedBlocksArgs> TcpCTcpAssignedBlocks
        {
            add
            {
                source.RegisterEventTemplate(TcpCTcpAssignedBlocksTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1163, ProviderGuid);
            }
        }
        public event Action<TcpCTcpCongestionWndwArgs> TcpCTcpCongestionWndw
        {
            add
            {
                source.RegisterEventTemplate(TcpCTcpCongestionWndwTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1164, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpCtcpDataTransferCumAck
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferCumAckTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1151, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferCumAck1330Args> TcpCtcpDataTransferCumAck1331
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferCumAck1331Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1331, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpCtcpDataTransferDupAck
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferDupAckTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1152, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferDupAck1343Args> TcpCtcpDataTransferDupAck1344
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferDupAck1344Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1344, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferEcnArgs> TcpCtcpDataTransferEcn
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferEcnTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1154, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpCtcpDataTransferSend
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferSendTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1153, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferSend1332Args> TcpCtcpDataTransferSend1333
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferSend1333Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1333, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpCtcpDataTransferSpuriousTimeout
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferSpuriousTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1155, ProviderGuid);
            }
        }
        public event Action<TcpCtcpDataTransferTimeout1348Args> TcpCtcpDataTransferSpuriousTimeout1349
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferSpuriousTimeout1349Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1349, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpCtcpDataTransferTimeout
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1150, ProviderGuid);
            }
        }
        public event Action<TcpCtcpDataTransferTimeout1348Args> TcpCtcpDataTransferTimeout1348
        {
            add
            {
                source.RegisterEventTemplate(TcpCtcpDataTransferTimeout1348Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1348, ProviderGuid);
            }
        }
        public event Action<TcpInspectConnectCompleteArgs> TcpCTcpDelayWndwInactive
        {
            add
            {
                source.RegisterEventTemplate(TcpCTcpDelayWndwInactiveTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1162, ProviderGuid);
            }
        }
        public event Action<TcpCTcpGammaArgs> TcpCTcpGamma
        {
            add
            {
                source.RegisterEventTemplate(TcpCTcpGammaTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1165, ProviderGuid);
            }
        }
        public event Action<TcpCwndRestartArgs> TcpCwndRestart
        {
            add
            {
                source.RegisterEventTemplate(TcpCwndRestartTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1221, ProviderGuid);
            }
        }
        public event Action<TcpCwndRestartArgs> TcpCwndRestart1229
        {
            add
            {
                source.RegisterEventTemplate(TcpCwndRestart1229Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1229, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpDataTransferCumAck
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferCumAckTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1071, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferCumAck1330Args> TcpDataTransferCumAck1330
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferCumAck1330Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1330, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpDataTransferDupAck
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferDupAckTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1072, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferDupAck1343Args> TcpDataTransferDupAck1343
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferDupAck1343Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1343, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferEcnArgs> TcpDataTransferEcn
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferEcnTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1075, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferEcnAlphaArgs> TcpDataTransferEcnAlpha
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferEcnAlphaTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1225, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferReceiveArgs> TcpDataTransferReceive
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferReceiveTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1074, ProviderGuid);
            }
        }
        public event Action<TcpRequestConnectArgs> TcpDataTransferRestransmit
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferRestransmitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1187, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpDataTransferRetransmitRound
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferRetransmitRoundTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1077, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferRetransmitRound1351Args> TcpDataTransferRetransmitRound1351
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferRetransmitRound1351Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1351, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpDataTransferRttSample
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferRttSampleTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1070, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferRttSample1341Args> TcpDataTransferRttSample1341
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferRttSample1341Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1341, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpDataTransferSend
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferSendTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1073, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferSend1332Args> TcpDataTransferSend1332
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferSend1332Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1332, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpDataTransferSpuriousTimeout
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferSpuriousTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1076, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferSpuriousTimeout1345Args> TcpDataTransferSpuriousTimeout1345
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferSpuriousTimeout1345Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1345, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpDataTransferTimeout
        {
            add
            {
                source.RegisterEventTemplate(TcpDataTransferTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1069, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDeliveryAccept
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliveryAcceptTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1175, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDeliveryCompleting
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliveryCompletingTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1181, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDeliveryDataDropped
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliveryDataDroppedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1190, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDeliveryFin
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliveryFinTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1176, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDeliveryFlush
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliveryFlushTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1171, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDeliveryIndicated
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliveryIndicatedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1157, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDeliveryInjectingData
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliveryInjectingDataTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1173, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDeliveryPush
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliveryPushTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1178, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDeliverySatisfied
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliverySatisfiedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1158, ProviderGuid);
            }
        }
        public event Action<TcpDeliveryStateChangeArgs> TcpDeliveryStateChange
        {
            add
            {
                source.RegisterEventTemplate(TcpDeliveryStateChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1189, ProviderGuid);
            }
        }
        public event Action<TcpPlumbWakePatternArgs> TcpDeplumbWakePattern
        {
            add
            {
                source.RegisterEventTemplate(TcpDeplumbWakePatternTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1312, ProviderGuid);
            }
        }
        public event Action<TcpCreateNotificationChannelRequestArgs> TcpDetachNotificationChannel
        {
            add
            {
                source.RegisterEventTemplate(TcpDetachNotificationChannelTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1309, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpDisconnectTcbComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpDisconnectTcbCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1043, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpDisconnectTcbFinWait2Timeout
        {
            add
            {
                source.RegisterEventTemplate(TcpDisconnectTcbFinWait2TimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1201, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpDisconnectTcbInjectFailed
        {
            add
            {
                source.RegisterEventTemplate(TcpDisconnectTcbInjectFailedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1041, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpDisconnectTcbKeepaliveTimeout
        {
            add
            {
                source.RegisterEventTemplate(TcpDisconnectTcbKeepaliveTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1047, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbRequestArgs> TcpDisconnectTcbRequest
        {
            add
            {
                source.RegisterEventTemplate(TcpDisconnectTcbRequestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1042, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpDisconnectTcbRtoTimeout
        {
            add
            {
                source.RegisterEventTemplate(TcpDisconnectTcbRtoTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1046, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpDisconnectTcbTimeout
        {
            add
            {
                source.RegisterEventTemplate(TcpDisconnectTcbTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1048, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpDisconnectTcbZeroWindowTimeout
        {
            add
            {
                source.RegisterEventTemplate(TcpDisconnectTcbZeroWindowTimeoutTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1200, ProviderGuid);
            }
        }
        public event Action<TcpEndpointAcquirePortReservationArgs> TcpEndpointAcquirePortReservation
        {
            add
            {
                source.RegisterEventTemplate(TcpEndpointAcquirePortReservationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1052, ProviderGuid);
            }
        }
        public event Action<TcpEndpointCreationArgs> TcpEndpointCreation
        {
            add
            {
                source.RegisterEventTemplate(TcpEndpointCreationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1001, ProviderGuid);
            }
        }
        public event Action<TcpEndpointAcquirePortReservationArgs> TcpEndpointFailedPortReservation
        {
            add
            {
                source.RegisterEventTemplate(TcpEndpointFailedPortReservationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1053, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoverySackExitArgs> TcpFlushSack
        {
            add
            {
                source.RegisterEventTemplate(TcpFlushSackTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1197, ProviderGuid);
            }
        }
        public event Action<TcpGlobalAddInterfaceArgs> TcpGlobalAddInterface
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalAddInterfaceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1061, ProviderGuid);
            }
        }
        public event Action<TcpSecurityRateLimitArgs> TcpGlobalConnectionRateLimitViolation
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalConnectionRateLimitViolationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1057, ProviderGuid);
            }
        }
        public event Action<TcpGlobalAddInterfaceArgs> TcpGlobalDeleteInterface
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalDeleteInterfaceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1062, ProviderGuid);
            }
        }
        public event Action<TcpGlobalIsbBeginThrottleArgs> TcpGlobalIsbBeginThrottle
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalIsbBeginThrottleTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1059, ProviderGuid);
            }
        }
        public event Action<TcpGlobalIsbBeginThrottleArgs> TcpGlobalIsbEndThrottle
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalIsbEndThrottleTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1060, ProviderGuid);
            }
        }
        public event Action<TcpSecurityRateLimitArgs> TcpGlobalLandAttackSegmentDrop
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalLandAttackSegmentDropTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1058, ProviderGuid);
            }
        }
        public event Action<TcpGlobalParametersArgs> TcpGlobalParameters
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalParametersTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1110, ProviderGuid);
            }
        }
        public event Action<TcpEndpointAcquirePortReservationArgs> TcpGlobalPortReservation
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalPortReservationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1054, ProviderGuid);
            }
        }
        public event Action<TcpSecurityRateLimitArgs> TcpGlobalReassemblyLimitViolation
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalReassemblyLimitViolationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1056, ProviderGuid);
            }
        }
        public event Action<TcpSecurityRateLimitArgs> TcpGlobalSynAttackEntry
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalSynAttackEntryTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1055, ProviderGuid);
            }
        }
        public event Action<TcpSecurityRateLimitArgs> TcpGlobalSynAttackExit
        {
            add
            {
                source.RegisterEventTemplate(TcpGlobalSynAttackExitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1063, ProviderGuid);
            }
        }
        public event Action<TcpCwndRestartArgs> TcpInitialCwndAdjusted
        {
            add
            {
                source.RegisterEventTemplate(TcpInitialCwndAdjustedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1222, ProviderGuid);
            }
        }
        public event Action<TcpRequestConnectArgs> TcpInitiateSynRstValidation
        {
            add
            {
                source.RegisterEventTemplate(TcpInitiateSynRstValidationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1182, ProviderGuid);
            }
        }
        public event Action<TcpInspectConnectCompleteArgs> TcpInspectConnectComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpInspectConnectCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1003, ProviderGuid);
            }
        }
        public event Action<TcpInterfaceRscStateChangeArgs> TcpInterfaceRscStateChange
        {
            add
            {
                source.RegisterEventTemplate(TcpInterfaceRscStateChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1226, ProviderGuid);
            }
        }
        public event Action<TcpipAoacFailFastArgs> TcpipAoacFailFast
        {
            add
            {
                source.RegisterEventTemplate(TcpipAoacFailFastTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1357, ProviderGuid);
            }
        }
        public event Action<TcpipGenericArgs> TcpipGeneric
        {
            add
            {
                source.RegisterEventTemplate(TcpipGenericTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1353, ProviderGuid);
            }
        }
        public event Action<TcpMediaDisconnectArgs> TcpipLimitedLinkConnectivity
        {
            add
            {
                source.RegisterEventTemplate(TcpipLimitedLinkConnectivityTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1322, ProviderGuid);
            }
        }
        public event Action<TcpMediaDisconnectArgs> TcpipLimitedLinkConnectivity1323
        {
            add
            {
                source.RegisterEventTemplate(TcpipLimitedLinkConnectivity1323Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1323, ProviderGuid);
            }
        }
        public event Action<TcpMediaDisconnectArgs> TcpipMediaConnect
        {
            add
            {
                source.RegisterEventTemplate(TcpipMediaConnectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1321, ProviderGuid);
            }
        }
        public event Action<TcpipNetworkPacketDropsArgs> TcpipNetworkPacketDrops
        {
            add
            {
                source.RegisterEventTemplate(TcpipNetworkPacketDropsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1215, ProviderGuid);
            }
        }
        public event Action<TcpipPlumbWakePatternOnInterfaceArgs> TcpipPlumbWakePatternOnInterface
        {
            add
            {
                source.RegisterEventTemplate(TcpipPlumbWakePatternOnInterfaceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1313, ProviderGuid);
            }
        }
        public event Action<TcpipReceiveSlowPathArgs> TcpipReceiveSlowPath
        {
            add
            {
                source.RegisterEventTemplate(TcpipReceiveSlowPathTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1205, ProviderGuid);
            }
        }
        public event Action<TcpipSendSlowPathArgs> TcpipSendSlowPath
        {
            add
            {
                source.RegisterEventTemplate(TcpipSendSlowPathTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1206, ProviderGuid);
            }
        }
        public event Action<TcpipSilentModeArgs> TcpipSilentMode
        {
            add
            {
                source.RegisterEventTemplate(TcpipSilentModeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1304, ProviderGuid);
            }
        }
        public event Action<TcpipTransportPacketDropsArgs> TcpipTransportPacketDrops
        {
            add
            {
                source.RegisterEventTemplate(TcpipTransportPacketDropsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1214, ProviderGuid);
            }
        }
        public event Action<TcpipUpdateInterfaceConfigFlagsArgs> TcpipUpdateInterfaceConfigFlags
        {
            add
            {
                source.RegisterEventTemplate(TcpipUpdateInterfaceConfigFlagsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1358, ProviderGuid);
            }
        }
        public event Action<TcpipWakePacketIndicatedArgs> TcpipWakePacketIndicated
        {
            add
            {
                source.RegisterEventTemplate(TcpipWakePacketIndicatedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1302, ProviderGuid);
            }
        }
        public event Action<TcpipWakePacketIndicated1303Args> TcpipWakePacketIndicated1303
        {
            add
            {
                source.RegisterEventTemplate(TcpipWakePacketIndicated1303Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1303, ProviderGuid);
            }
        }
        public event Action<TcpIsPatternCoalescingRequiredArgs> TcpIsPatternCoalescingRequired
        {
            add
            {
                source.RegisterEventTemplate(TcpIsPatternCoalescingRequiredTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1355, ProviderGuid);
            }
        }
        public event Action<TcpListenerActivationFailedAfArgs> TcpListenerActivated
        {
            add
            {
                source.RegisterEventTemplate(TcpListenerActivatedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1123, ProviderGuid);
            }
        }
        public event Action<TcpListenerActivationFailedAfArgs> TcpListenerActivationFailedAf
        {
            add
            {
                source.RegisterEventTemplate(TcpListenerActivationFailedAfTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1117, ProviderGuid);
            }
        }
        public event Action<TcpListenerActivationFailedAfArgs> TcpListenerActivationFailedCompartment
        {
            add
            {
                source.RegisterEventTemplate(TcpListenerActivationFailedCompartmentTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1118, ProviderGuid);
            }
        }
        public event Action<TcpListenerActivationFailedAfArgs> TcpListenerActivationFailedInspection1
        {
            add
            {
                source.RegisterEventTemplate(TcpListenerActivationFailedInspection1Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1119, ProviderGuid);
            }
        }
        public event Action<TcpListenerActivationFailedAfArgs> TcpListenerActivationFailedInspection2
        {
            add
            {
                source.RegisterEventTemplate(TcpListenerActivationFailedInspection2Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1120, ProviderGuid);
            }
        }
        public event Action<TcpListenerActivationFailedAfArgs> TcpListenerBindFailedPort
        {
            add
            {
                source.RegisterEventTemplate(TcpListenerBindFailedPortTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1122, ProviderGuid);
            }
        }
        public event Action<TcpListenerActivationFailedAfArgs> TcpListenerBindFailedResolution
        {
            add
            {
                source.RegisterEventTemplate(TcpListenerBindFailedResolutionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1121, ProviderGuid);
            }
        }
        public event Action<TcpListenerActivationFailedAfArgs> TcpListenerUnbound
        {
            add
            {
                source.RegisterEventTemplate(TcpListenerUnboundTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1124, ProviderGuid);
            }
        }
        public event Action<TcpLoopbackFastPathFailReasonArgs> TcpLoopbackFastPathFailReason
        {
            add
            {
                source.RegisterEventTemplate(TcpLoopbackFastPathFailReasonTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1228, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoveryEntryArgs> TcpLossRecoveryEntry
        {
            add
            {
                source.RegisterEventTemplate(TcpLossRecoveryEntryTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1078, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoveryEntryArgs> TcpLossRecoveryExit
        {
            add
            {
                source.RegisterEventTemplate(TcpLossRecoveryExitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1079, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoverySackEntryArgs> TcpLossRecoverySackEntry
        {
            add
            {
                source.RegisterEventTemplate(TcpLossRecoverySackEntryTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1080, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoverySackExitArgs> TcpLossRecoverySackExit
        {
            add
            {
                source.RegisterEventTemplate(TcpLossRecoverySackExitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1081, ProviderGuid);
            }
        }
        public event Action<TcpLsoArgs> TcpLso
        {
            add
            {
                source.RegisterEventTemplate(TcpLsoTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1111, ProviderGuid);
            }
        }
        public event Action<TcpMediaDisconnectArgs> TcpMediaDisconnect
        {
            add
            {
                source.RegisterEventTemplate(TcpMediaDisconnectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1106, ProviderGuid);
            }
        }
        public event Action<TcpMemoryFailuresArgs> TcpMemoryFailures
        {
            add
            {
                source.RegisterEventTemplate(TcpMemoryFailuresTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1109, ProviderGuid);
            }
        }
        public event Action<TcpModuleStartedArgs> TcpModuleStarted
        {
            add
            {
                source.RegisterEventTemplate(TcpModuleStartedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1107, ProviderGuid);
            }
        }
        public event Action<TcpModuleStartedArgs> TcpModuleStopped
        {
            add
            {
                source.RegisterEventTemplate(TcpModuleStoppedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1108, ProviderGuid);
            }
        }
        public event Action<TcpMppNppEvaluationArgs> TcpMppNppEvaluation
        {
            add
            {
                source.RegisterEventTemplate(TcpMppNppEvaluationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1216, ProviderGuid);
            }
        }
        public event Action<TcpMppStartEpisodeArgs> TcpMppStartEpisode
        {
            add
            {
                source.RegisterEventTemplate(TcpMppStartEpisodeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1217, ProviderGuid);
            }
        }
        public event Action<TcpMppStartEpochArgs> TcpMppStartEpoch
        {
            add
            {
                source.RegisterEventTemplate(TcpMppStartEpochTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1219, ProviderGuid);
            }
        }
        public event Action<TcpMppStopEpisodeArgs> TcpMppStopEpisode
        {
            add
            {
                source.RegisterEventTemplate(TcpMppStopEpisodeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1218, ProviderGuid);
            }
        }
        public event Action<TcpMppStopEpochArgs> TcpMppStopEpoch
        {
            add
            {
                source.RegisterEventTemplate(TcpMppStopEpochTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1220, ProviderGuid);
            }
        }
        public event Action<TcpPlumbWakePatternArgs> TcpPlumbWakePattern
        {
            add
            {
                source.RegisterEventTemplate(TcpPlumbWakePatternTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1311, ProviderGuid);
            }
        }
        public event Action<TcpQueryNotificationChannelStatusRequestArgs> TcpQueryNotificationChannelStatusRequest
        {
            add
            {
                source.RegisterEventTemplate(TcpQueryNotificationChannelStatusRequestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1306, ProviderGuid);
            }
        }
        public event Action<TcpConnectTcbSkipRateLimitArgs> TcpRateLimitPathCancel
        {
            add
            {
                source.RegisterEventTemplate(TcpRateLimitPathCancelTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1028, ProviderGuid);
            }
        }
        public event Action<TcpConnectTcbSkipRateLimitArgs> TcpRateLimitPathRelease
        {
            add
            {
                source.RegisterEventTemplate(TcpRateLimitPathReleaseTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1026, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoveryEntryArgs> TcpReassemblyEntry
        {
            add
            {
                source.RegisterEventTemplate(TcpReassemblyEntryTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1198, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoveryEntryArgs> TcpReassemblyExit
        {
            add
            {
                source.RegisterEventTemplate(TcpReassemblyExitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1199, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoverySackExitArgs> TcpReassemblyFlush
        {
            add
            {
                source.RegisterEventTemplate(TcpReassemblyFlushTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1204, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpReceiveRequest
        {
            add
            {
                source.RegisterEventTemplate(TcpReceiveRequestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1156, ProviderGuid);
            }
        }
        public event Action<TcpReleaseIndicationArgs> TcpReleaseIndication
        {
            add
            {
                source.RegisterEventTemplate(TcpReleaseIndicationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1090, ProviderGuid);
            }
        }
        public event Action<TcpAcquirePortArgs> TcpReleasePort
        {
            add
            {
                source.RegisterEventTemplate(TcpReleasePortTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1193, ProviderGuid);
            }
        }
        public event Action<TcpAcquirePortArgs> TcpReplacePort
        {
            add
            {
                source.RegisterEventTemplate(TcpReplacePortTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1194, ProviderGuid);
            }
        }
        public event Action<TcpRequestConnectArgs> TcpRequestConnect
        {
            add
            {
                source.RegisterEventTemplate(TcpRequestConnectTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1002, ProviderGuid);
            }
        }
        public event Action<TcpRscNblOobInfoArgs> TcpRscNblOobInfo
        {
            add
            {
                source.RegisterEventTemplate(TcpRscNblOobInfoTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1227, ProviderGuid);
            }
        }
        public event Action<TcpRssTableChangeArgs> TcpRssTableChange
        {
            add
            {
                source.RegisterEventTemplate(TcpRssTableChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1068, ProviderGuid);
            }
        }
        public event Action<TcpRtcPortRangeAssignmentArgs> TcpRtcPortRangeAssignment
        {
            add
            {
                source.RegisterEventTemplate(TcpRtcPortRangeAssignmentTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1356, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpRttResiliencyDetection
        {
            add
            {
                source.RegisterEventTemplate(TcpRttResiliencyDetectionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1098, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferRttSample1341Args> TcpRttResiliencyDetection1342
        {
            add
            {
                source.RegisterEventTemplate(TcpRttResiliencyDetection1342Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1342, ProviderGuid);
            }
        }
        public event Action<TcpSackUpdateArgs> TcpSackUpdate
        {
            add
            {
                source.RegisterEventTemplate(TcpSackUpdateTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1354, ProviderGuid);
            }
        }
        public event Action<TcpSecurityRateLimitArgs> TcpSecurityRateLimit
        {
            add
            {
                source.RegisterEventTemplate(TcpSecurityRateLimitTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1025, ProviderGuid);
            }
        }
        public event Action<TcpSendPostedArgs> TcpSendAdvance
        {
            add
            {
                source.RegisterEventTemplate(TcpSendAdvanceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1161, ProviderGuid);
            }
        }
        public event Action<TcpSendPostedArgs> TcpSendPosted
        {
            add
            {
                source.RegisterEventTemplate(TcpSendPostedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1159, ProviderGuid);
            }
        }
        public event Action<TcpSendPostedArgs> TcpSendTransmitted
        {
            add
            {
                source.RegisterEventTemplate(TcpSendTransmittedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1160, ProviderGuid);
            }
        }
        public event Action<TcpSetTcpOptionArgs> TcpSetTcpOption
        {
            add
            {
                source.RegisterEventTemplate(TcpSetTcpOptionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1104, ProviderGuid);
            }
        }
        public event Action<TcpSetTcpSoOptionArgs> TcpSetTcpSoOption
        {
            add
            {
                source.RegisterEventTemplate(TcpSetTcpSoOptionTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1105, ProviderGuid);
            }
        }
        public event Action<TcpAccpetListenerRouteLookupFailureArgs> TcpShutdownTcb
        {
            add
            {
                source.RegisterEventTemplate(TcpShutdownTcbTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1044, ProviderGuid);
            }
        }
        public event Action<TcpSignalNotificationChannelEventArgs> TcpSignalNotificationChannelEvent
        {
            add
            {
                source.RegisterEventTemplate(TcpSignalNotificationChannelEventTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1308, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpSlowStartToCongestionAvoidance
        {
            add
            {
                source.RegisterEventTemplate(TcpSlowStartToCongestionAvoidanceTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1082, ProviderGuid);
            }
        }
        public event Action<TcpCtcpDataTransferTimeout1348Args> TcpSlowStartToCongestionAvoidance1350
        {
            add
            {
                source.RegisterEventTemplate(TcpSlowStartToCongestionAvoidance1350Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1350, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpSpuriousRtoDetectionBegin
        {
            add
            {
                source.RegisterEventTemplate(TcpSpuriousRtoDetectionBeginTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1087, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferSpuriousTimeout1345Args> TcpSpuriousRtoDetectionBegin1346
        {
            add
            {
                source.RegisterEventTemplate(TcpSpuriousRtoDetectionBegin1346Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1346, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferTimeoutArgs> TcpSpuriousRtoDetectionEnd
        {
            add
            {
                source.RegisterEventTemplate(TcpSpuriousRtoDetectionEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1088, ProviderGuid);
            }
        }
        public event Action<TcpDataTransferSpuriousTimeout1345Args> TcpSpuriousRtoDetectionEnd1347
        {
            add
            {
                source.RegisterEventTemplate(TcpSpuriousRtoDetectionEnd1347Template(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1347, ProviderGuid);
            }
        }
        public event Action<TcpSrttMeasurementStartedArgs> TcpSrttMeasurementCancelled
        {
            add
            {
                source.RegisterEventTemplate(TcpSrttMeasurementCancelledTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1168, ProviderGuid);
            }
        }
        public event Action<TcpSrttMeasurementStartedArgs> TcpSrttMeasurementComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpSrttMeasurementCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1167, ProviderGuid);
            }
        }
        public event Action<TcpSrttMeasurementStartedArgs> TcpSrttMeasurementStarted
        {
            add
            {
                source.RegisterEventTemplate(TcpSrttMeasurementStartedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1166, ProviderGuid);
            }
        }
        public event Action<TcpSwsAvoidanceBeginArgs> TcpSwsAvoidanceBegin
        {
            add
            {
                source.RegisterEventTemplate(TcpSwsAvoidanceBeginTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1100, ProviderGuid);
            }
        }
        public event Action<TcpSwsAvoidanceBeginArgs> TcpSwsAvoidanceEnd
        {
            add
            {
                source.RegisterEventTemplate(TcpSwsAvoidanceEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1101, ProviderGuid);
            }
        }
        public event Action<TcpTcbChangeIsbArgs> TcpTcbChangeIsb
        {
            add
            {
                source.RegisterEventTemplate(TcpTcbChangeIsbTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1067, ProviderGuid);
            }
        }
        public event Action<TcpTcbStopTimerArgs> TcpTcbExpireTimer
        {
            add
            {
                source.RegisterEventTemplate(TcpTcbExpireTimerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1066, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpTcbInjectFinComplete
        {
            add
            {
                source.RegisterEventTemplate(TcpTcbInjectFinCompleteTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1180, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpTcbInjectFinFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpTcbInjectFinFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1174, ProviderGuid);
            }
        }
        public event Action<TcpDisconnectTcbInjectFailedArgs> TcpTcbInjectRcvFailure
        {
            add
            {
                source.RegisterEventTemplate(TcpTcbInjectRcvFailureTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1172, ProviderGuid);
            }
        }
        public event Action<TcpTcbStartTimerArgs> TcpTcbStartTimer
        {
            add
            {
                source.RegisterEventTemplate(TcpTcbStartTimerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1064, ProviderGuid);
            }
        }
        public event Action<TcpTcbStateChangeArgs> TcpTcbStateChange
        {
            add
            {
                source.RegisterEventTemplate(TcpTcbStateChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1051, ProviderGuid);
            }
        }
        public event Action<TcpTcbStopTimerArgs> TcpTcbStopTimer
        {
            add
            {
                source.RegisterEventTemplate(TcpTcbStopTimerTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1065, ProviderGuid);
            }
        }
        public event Action<TcpTcbSynSendArgs> TcpTcbSynSend
        {
            add
            {
                source.RegisterEventTemplate(TcpTcbSynSendTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1004, ProviderGuid);
            }
        }
        public event Action<TcpTemplateChangedArgs> TcpTemplateChanged
        {
            add
            {
                source.RegisterEventTemplate(TcpTemplateChangedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1224, ProviderGuid);
            }
        }
        public event Action<TcpTemplateParametersArgs> TcpTemplateParameters
        {
            add
            {
                source.RegisterEventTemplate(TcpTemplateParametersTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1223, ProviderGuid);
            }
        }
        public event Action<TcpCreateNotificationChannelRequestArgs> TcpUnlinkNotificationChannel
        {
            add
            {
                source.RegisterEventTemplate(TcpUnlinkNotificationChannelTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1310, ProviderGuid);
            }
        }
        public event Action<TcpWsdCacheEntryStateChangeArgs> TcpWsdCacheEntryStateChange
        {
            add
            {
                source.RegisterEventTemplate(TcpWsdCacheEntryStateChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1211, ProviderGuid);
            }
        }
        public event Action<TcpWsdInitializationErrorsArgs> TcpWsdInitializationErrors
        {
            add
            {
                source.RegisterEventTemplate(TcpWsdInitializationErrorsTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1207, ProviderGuid);
            }
        }
        public event Action<TcpWsdInitializationInformationArgs> TcpWsdInitializationInformation
        {
            add
            {
                source.RegisterEventTemplate(TcpWsdInitializationInformationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1208, ProviderGuid);
            }
        }
        public event Action<TcpWsdProfileStateChangeArgs> TcpWsdProfileStateChange
        {
            add
            {
                source.RegisterEventTemplate(TcpWsdProfileStateChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1212, ProviderGuid);
            }
        }
        public event Action<TcpWsdStateChangeArgs> TcpWsdStateChange
        {
            add
            {
                source.RegisterEventTemplate(TcpWsdStateChangeTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1213, ProviderGuid);
            }
        }
        public event Action<TcpWsdWsRestrictedProfileArgs> TcpWsdWsRestrictedDestination
        {
            add
            {
                source.RegisterEventTemplate(TcpWsdWsRestrictedDestinationTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1210, ProviderGuid);
            }
        }
        public event Action<TcpWsdWsRestrictedProfileArgs> TcpWsdWsRestrictedProfile
        {
            add
            {
                source.RegisterEventTemplate(TcpWsdWsRestrictedProfileTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1209, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoveryEntryArgs> TcpZeroWindowProbingBegin
        {
            add
            {
                source.RegisterEventTemplate(TcpZeroWindowProbingBeginTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1102, ProviderGuid);
            }
        }
        public event Action<TcpLossRecoveryEntryArgs> TcpZeroWindowProbingEnd
        {
            add
            {
                source.RegisterEventTemplate(TcpZeroWindowProbingEndTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1103, ProviderGuid);
            }
        }
        public event Action<UdpCreateNotificationChannelRequestArgs> UdpCreateNotificationChannelRequest
        {
            add
            {
                source.RegisterEventTemplate(UdpCreateNotificationChannelRequestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1334, ProviderGuid);
            }
        }
        public event Action<UdpCreateNotificationChannelRequestProcessedArgs> UdpCreateNotificationChannelRequestProcessed
        {
            add
            {
                source.RegisterEventTemplate(UdpCreateNotificationChannelRequestProcessedTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1336, ProviderGuid);
            }
        }
        public event Action<UdpCreateNotificationChannelRequestProcessingArgs> UdpCreateNotificationChannelRequestProcessing
        {
            add
            {
                source.RegisterEventTemplate(UdpCreateNotificationChannelRequestProcessingTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1340, ProviderGuid);
            }
        }
        public event Action<UdpQueryNotificationChannelStatusRequestArgs> UdpDetachNotificationChannel
        {
            add
            {
                source.RegisterEventTemplate(UdpDetachNotificationChannelTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1338, ProviderGuid);
            }
        }
        public event Action<UdpEndpointSendMessagesArgs> UdpEndpointReceiveMessages
        {
            add
            {
                source.RegisterEventTemplate(UdpEndpointReceiveMessagesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1170, ProviderGuid);
            }
        }
        public event Action<UdpEndpointSendMessagesArgs> UdpEndpointSendMessages
        {
            add
            {
                source.RegisterEventTemplate(UdpEndpointSendMessagesTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1169, ProviderGuid);
            }
        }
        public event Action<UdpQueryNotificationChannelStatusRequestArgs> UdpQueryNotificationChannelStatusRequest
        {
            add
            {
                source.RegisterEventTemplate(UdpQueryNotificationChannelStatusRequestTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1335, ProviderGuid);
            }
        }
        public event Action<UdpSignalNotificationChannelEventArgs> UdpSignalNotificationChannelEvent
        {
            add
            {
                source.RegisterEventTemplate(UdpSignalNotificationChannelEventTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1337, ProviderGuid);
            }
        }
        public event Action<UdpQueryNotificationChannelStatusRequestArgs> UdpUnlinkNotificationChannel
        {
            add
            {
                source.RegisterEventTemplate(UdpUnlinkNotificationChannelTemplate(value));
            }
            remove
            {
                source.UnregisterEventTemplate(value, 1339, ProviderGuid);
            }
        }

        #region private
        protected override string GetProviderName() { return ProviderName; }

        static private FramingIfOperStatusArgs FramingIfOperStatusTemplate(Action<FramingIfOperStatusArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new FramingIfOperStatusArgs(action, 1130, 1130, "FramingIfOperStatus", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMediaDisconnectArgs FramingNdisPauseTemplate(Action<TcpMediaDisconnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMediaDisconnectArgs(action, 1136, 1136, "FramingNdisPause", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMediaDisconnectArgs FramingNdisRestartTemplate(Action<TcpMediaDisconnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMediaDisconnectArgs(action, 1137, 1137, "FramingNdisRestart", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpDadFailedArgs IpAddressAddedTemplate(Action<IpDadFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpDadFailedArgs(action, 1127, 1127, "IpAddressAdded", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpDadFailedArgs IpAddressDeletedTemplate(Action<IpDadFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpDadFailedArgs(action, 1128, 1128, "IpAddressDeleted", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpDadFailedArgs IpAddressStateNonPreferredTemplate(Action<IpDadFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpDadFailedArgs(action, 1139, 1139, "IpAddressStateNonPreferred", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpDadFailedArgs IpAddressStatePreferredTemplate(Action<IpDadFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpDadFailedArgs(action, 1138, 1138, "IpAddressStatePreferred", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpDadFailedArgs IpDadFailedTemplate(Action<IpDadFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpDadFailedArgs(action, 1115, 1115, "IpDadFailed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpDadFailedArgs IpDadStartedTemplate(Action<IpDadFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpDadFailedArgs(action, 1116, 1116, "IpDadStarted", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpDadSuccessfulArgs IpDadSuccessfulTemplate(Action<IpDadSuccessfulArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpDadSuccessfulArgs(action, 1114, 1114, "IpDadSuccessful", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpInterfacePropertyChangeArgs IpInterfacePropertyChangeTemplate(Action<IpInterfacePropertyChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpInterfacePropertyChangeArgs(action, 1144, 1144, "IpInterfacePropertyChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpInterfaceRundownArgs IpInterfaceRundownTemplate(Action<IpInterfaceRundownArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpInterfaceRundownArgs(action, 1202, 1202, "IpInterfaceRundown", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpInterfaceSpeedChangeArgs IpInterfaceSpeedChangeTemplate(Action<IpInterfaceSpeedChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpInterfaceSpeedChangeArgs(action, 1203, 1203, "IpInterfaceSpeedChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpNeighborDiscoveryArgs IpNeighborDiscoveryTemplate(Action<IpNeighborDiscoveryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpNeighborDiscoveryArgs(action, 1325, 1325, "IpNeighborDiscovery", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpNeighborUnreachableArgs IpNeighborReachableTemplate(Action<IpNeighborUnreachableArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpNeighborUnreachableArgs(action, 1149, 1149, "IpNeighborReachable", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpNeighborStateArgs IpNeighborStateTemplate(Action<IpNeighborStateArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpNeighborStateArgs(action, 1324, 1324, "IpNeighborState", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpNeighborUnreachableArgs IpNeighborUnreachableTemplate(Action<IpNeighborUnreachableArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpNeighborUnreachableArgs(action, 1148, 1148, "IpNeighborUnreachable", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpRouteCreatedArgs IpRouteCreatedTemplate(Action<IpRouteCreatedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpRouteCreatedArgs(action, 1145, 1145, "IpRouteCreated", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpRouteCreatedArgs IpRouteDeletedTemplate(Action<IpRouteCreatedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpRouteCreatedArgs(action, 1146, 1146, "IpRouteDeleted", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpRouteCreatedArgs IpRoutePropertyChangeTemplate(Action<IpRouteCreatedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpRouteCreatedArgs(action, 1147, 1147, "IpRoutePropertyChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpSortedAddressPairsArgs IpSortedAddressPairsTemplate(Action<IpSortedAddressPairsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpSortedAddressPairsArgs(action, 1327, 1327, "IpSortedAddressPairs", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private IpSourceAddressSelectionArgs IpSourceAddressSelectionTemplate(Action<IpSourceAddressSelectionArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new IpSourceAddressSelectionArgs(action, 1326, 1326, "IpSourceAddressSelection", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_AcceptArgs Ndkpi_AcceptTemplate(Action<Ndkpi_AcceptArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_AcceptArgs(action, 1267, 1267, "Ndkpi_Accept", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Arm_CqArgs Ndkpi_Arm_CqTemplate(Action<Ndkpi_Arm_CqArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Arm_CqArgs(action, 1254, 1254, "Ndkpi_Arm_Cq", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_BindArgs Ndkpi_BindTemplate(Action<Ndkpi_BindArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_BindArgs(action, 1290, 1290, "Ndkpi_Bind", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Build_LamArgs Ndkpi_Build_LamTemplate(Action<Ndkpi_Build_LamArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Build_LamArgs(action, 1278, 1278, "Ndkpi_Build_Lam", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Close_Adapter_EnterArgs Ndkpi_Close_Adapter_EnterTemplate(Action<Ndkpi_Close_Adapter_EnterArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Close_Adapter_EnterArgs(action, 1298, 1298, "Ndkpi_Close_Adapter_Enter", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Close_Adapter_EnterArgs Ndkpi_Close_Adapter_ExitTemplate(Action<Ndkpi_Close_Adapter_EnterArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Close_Adapter_EnterArgs(action, 1299, 1299, "Ndkpi_Close_Adapter_Exit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Close_CompletionArgs Ndkpi_Close_CompletionTemplate(Action<Ndkpi_Close_CompletionArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Close_CompletionArgs(action, 1251, 1251, "Ndkpi_Close_Completion", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Close_ObjArgs Ndkpi_Close_ObjTemplate(Action<Ndkpi_Close_ObjArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Close_ObjArgs(action, 1250, 1250, "Ndkpi_Close_Obj", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Complete_ConnectArgs Ndkpi_Complete_ConnectTemplate(Action<Ndkpi_Complete_ConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Complete_ConnectArgs(action, 1266, 1266, "Ndkpi_Complete_Connect", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_ConnectArgs Ndkpi_ConnectTemplate(Action<Ndkpi_ConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_ConnectArgs(action, 1264, 1264, "Ndkpi_Connect", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Connect_Event_CallbackArgs Ndkpi_Connect_Event_CallbackTemplate(Action<Ndkpi_Connect_Event_CallbackArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Connect_Event_CallbackArgs(action, 1283, 1283, "Ndkpi_Connect_Event_Callback", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_ConnectArgs Ndkpi_Connect_Shared_EndpointTemplate(Action<Ndkpi_ConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_ConnectArgs(action, 1265, 1265, "Ndkpi_Connect_Shared_Endpoint", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Control_Cq_ImArgs Ndkpi_Control_Cq_ImTemplate(Action<Ndkpi_Control_Cq_ImArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Control_Cq_ImArgs(action, 1314, 1314, "Ndkpi_Control_Cq_Im", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Cq_Notification_CallbackArgs Ndkpi_Cq_Notification_CallbackTemplate(Action<Ndkpi_Cq_Notification_CallbackArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Cq_Notification_CallbackArgs(action, 1280, 1280, "Ndkpi_Cq_Notification_Callback", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Cq_ResultArgs Ndkpi_Cq_ResultTemplate(Action<Ndkpi_Cq_ResultArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Cq_ResultArgs(action, 1255, 1255, "Ndkpi_Cq_Result", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Cq_Result_ExArgs Ndkpi_Cq_Result_ExTemplate(Action<Ndkpi_Cq_Result_ExArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Cq_Result_ExArgs(action, 1328, 1328, "Ndkpi_Cq_Result_Ex", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Create_CompletionArgs Ndkpi_Create_CompletionTemplate(Action<Ndkpi_Create_CompletionArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Create_CompletionArgs(action, 1249, 1249, "Ndkpi_Create_Completion", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Deregister_MrArgs Ndkpi_Create_ConnectorTemplate(Action<Ndkpi_Deregister_MrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Deregister_MrArgs(action, 1276, 1276, "Ndkpi_Create_Connector", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Create_CqArgs Ndkpi_Create_CqTemplate(Action<Ndkpi_Create_CqArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Create_CqArgs(action, 1248, 1248, "Ndkpi_Create_Cq", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Create_ListenerArgs Ndkpi_Create_ListenerTemplate(Action<Ndkpi_Create_ListenerArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Create_ListenerArgs(action, 1277, 1277, "Ndkpi_Create_Listener", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Create_MrArgs Ndkpi_Create_MrTemplate(Action<Ndkpi_Create_MrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Create_MrArgs(action, 1256, 1256, "Ndkpi_Create_Mr", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Deregister_MrArgs Ndkpi_Create_MwTemplate(Action<Ndkpi_Deregister_MrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Deregister_MrArgs(action, 1270, 1270, "Ndkpi_Create_Mw", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Deregister_MrArgs Ndkpi_Create_PdTemplate(Action<Ndkpi_Deregister_MrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Deregister_MrArgs(action, 1274, 1274, "Ndkpi_Create_Pd", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Create_QpArgs Ndkpi_Create_QpTemplate(Action<Ndkpi_Create_QpArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Create_QpArgs(action, 1272, 1272, "Ndkpi_Create_Qp", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Create_QpArgs Ndkpi_Create_Qp_SrqTemplate(Action<Ndkpi_Create_QpArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Create_QpArgs(action, 1273, 1273, "Ndkpi_Create_Qp_Srq", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_ListenArgs Ndkpi_Create_Shared_EndpointTemplate(Action<Ndkpi_ListenArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_ListenArgs(action, 1275, 1275, "Ndkpi_Create_Shared_Endpoint", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Create_SrqArgs Ndkpi_Create_SrqTemplate(Action<Ndkpi_Create_SrqArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Create_SrqArgs(action, 1271, 1271, "Ndkpi_Create_Srq", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Deregister_MrArgs Ndkpi_Deregister_MrTemplate(Action<Ndkpi_Deregister_MrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Deregister_MrArgs(action, 1261, 1261, "Ndkpi_Deregister_Mr", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Deregister_MrArgs Ndkpi_DisconnectTemplate(Action<Ndkpi_Deregister_MrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Deregister_MrArgs(action, 1268, 1268, "Ndkpi_Disconnect", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Disconnect_Event_CallbackArgs Ndkpi_Disconnect_Event_CallbackTemplate(Action<Ndkpi_Disconnect_Event_CallbackArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Disconnect_Event_CallbackArgs(action, 1282, 1282, "Ndkpi_Disconnect_Event_Callback", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Fast_RegisterArgs Ndkpi_Fast_RegisterTemplate(Action<Ndkpi_Fast_RegisterArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Fast_RegisterArgs(action, 1291, 1291, "Ndkpi_Fast_Register", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_FlushArgs Ndkpi_FlushTemplate(Action<Ndkpi_FlushArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_FlushArgs(action, 1257, 1257, "Ndkpi_Flush", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Get_Connect_DataArgs Ndkpi_Get_Connect_DataTemplate(Action<Ndkpi_Get_Connect_DataArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Get_Connect_DataArgs(action, 1288, 1288, "Ndkpi_Get_Connect_Data", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Get_SockaddrArgs Ndkpi_Get_SockaddrTemplate(Action<Ndkpi_Get_SockaddrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Get_SockaddrArgs(action, 1285, 1285, "Ndkpi_Get_Sockaddr", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Get_Sockaddr_FailureArgs Ndkpi_Get_Sockaddr_FailureTemplate(Action<Ndkpi_Get_Sockaddr_FailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Get_Sockaddr_FailureArgs(action, 1286, 1286, "Ndkpi_Get_Sockaddr_Failure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Get_TokenArgs Ndkpi_Get_TokenTemplate(Action<Ndkpi_Get_TokenArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Get_TokenArgs(action, 1284, 1284, "Ndkpi_Get_Token", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Initialize_Fast_Register_MrArgs Ndkpi_Initialize_Fast_Register_MrTemplate(Action<Ndkpi_Initialize_Fast_Register_MrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Initialize_Fast_Register_MrArgs(action, 1262, 1262, "Ndkpi_Initialize_Fast_Register_Mr", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Interface_EventArgs Ndkpi_Interface_EventTemplate(Action<Ndkpi_Interface_EventArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Interface_EventArgs(action, 1301, 1301, "Ndkpi_Interface_Event", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_InvalidateArgs Ndkpi_InvalidateTemplate(Action<Ndkpi_InvalidateArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_InvalidateArgs(action, 1292, 1292, "Ndkpi_Invalidate", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_ListenArgs Ndkpi_ListenTemplate(Action<Ndkpi_ListenArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_ListenArgs(action, 1269, 1269, "Ndkpi_Listen", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Modify_SrqArgs Ndkpi_Modify_SrqTemplate(Action<Ndkpi_Modify_SrqArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Modify_SrqArgs(action, 1263, 1263, "Ndkpi_Modify_Srq", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Open_AdapterArgs Ndkpi_Open_AdapterTemplate(Action<Ndkpi_Open_AdapterArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Open_AdapterArgs(action, 1297, 1297, "Ndkpi_Open_Adapter", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_ReadArgs Ndkpi_ReadTemplate(Action<Ndkpi_ReadArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_ReadArgs(action, 1293, 1293, "Ndkpi_Read", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_SendArgs Ndkpi_ReceiveTemplate(Action<Ndkpi_SendArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_SendArgs(action, 1259, 1259, "Ndkpi_Receive", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Register_MrArgs Ndkpi_Register_MrTemplate(Action<Ndkpi_Register_MrArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Register_MrArgs(action, 1260, 1260, "Ndkpi_Register_Mr", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_RejectArgs Ndkpi_RejectTemplate(Action<Ndkpi_RejectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_RejectArgs(action, 1287, 1287, "Ndkpi_Reject", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Release_LamArgs Ndkpi_Release_LamTemplate(Action<Ndkpi_Release_LamArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Release_LamArgs(action, 1279, 1279, "Ndkpi_Release_Lam", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Request_CompletionArgs Ndkpi_Request_CompletionTemplate(Action<Ndkpi_Request_CompletionArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Request_CompletionArgs(action, 1253, 1253, "Ndkpi_Request_Completion", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Resize_CqArgs Ndkpi_Resize_CqTemplate(Action<Ndkpi_Resize_CqArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Resize_CqArgs(action, 1252, 1252, "Ndkpi_Resize_Cq", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_SendArgs Ndkpi_SendTemplate(Action<Ndkpi_SendArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_SendArgs(action, 1258, 1258, "Ndkpi_Send", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Send_InvalidateArgs Ndkpi_Send_InvalidateTemplate(Action<Ndkpi_Send_InvalidateArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Send_InvalidateArgs(action, 1329, 1329, "Ndkpi_Send_Invalidate", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Srq_Notification_CallbackArgs Ndkpi_Srq_Notification_CallbackTemplate(Action<Ndkpi_Srq_Notification_CallbackArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Srq_Notification_CallbackArgs(action, 1281, 1281, "Ndkpi_Srq_Notification_Callback", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Srq_Work_Request_Inline_FailureArgs Ndkpi_Srq_Work_Request_Inline_FailureTemplate(Action<Ndkpi_Srq_Work_Request_Inline_FailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Srq_Work_Request_Inline_FailureArgs(action, 1296, 1296, "Ndkpi_Srq_Work_Request_Inline_Failure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_SrqReceiveArgs Ndkpi_SrqReceiveTemplate(Action<Ndkpi_SrqReceiveArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_SrqReceiveArgs(action, 1295, 1295, "Ndkpi_SrqReceive", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_Work_Request_Inline_FailureArgs Ndkpi_Work_Request_Inline_FailureTemplate(Action<Ndkpi_Work_Request_Inline_FailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_Work_Request_Inline_FailureArgs(action, 1289, 1289, "Ndkpi_Work_Request_Inline_Failure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private Ndkpi_ReadArgs Ndkpi_WriteTemplate(Action<Ndkpi_ReadArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new Ndkpi_ReadArgs(action, 1294, 1294, "Ndkpi_Write", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssBindingBindCompleteArgs RssBindingBindCompleteTemplate(Action<RssBindingBindCompleteArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssBindingBindCompleteArgs(action, 1241, 1241, "RssBindingBindComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssBindingCapabilityArgs RssBindingCapabilityTemplate(Action<RssBindingCapabilityArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssBindingCapabilityArgs(action, 1247, 1247, "RssBindingCapability", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssBindingChangeArgs RssBindingChangeTemplate(Action<RssBindingChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssBindingChangeArgs(action, 1230, 1230, "RssBindingChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssBindingRundownArgs RssBindingRundownTemplate(Action<RssBindingRundownArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssBindingRundownArgs(action, 1245, 1245, "RssBindingRundown", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssConfigurationChangeArgs RssConfigurationChangeTemplate(Action<RssConfigurationChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssConfigurationChangeArgs(action, 1239, 1239, "RssConfigurationChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssFailureArgs RssFailureTemplate(Action<RssFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssFailureArgs(action, 1240, 1240, "RssFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssIndirectionChangeArgs RssIndirectionChangeTemplate(Action<RssIndirectionChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssIndirectionChangeArgs(action, 1237, 1237, "RssIndirectionChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssInitializeIndirectionTableArgs RssInitializeIndirectionTableTemplate(Action<RssInitializeIndirectionTableArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssInitializeIndirectionTableArgs(action, 1244, 1244, "RssInitializeIndirectionTable", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssPortBindCompleteArgs RssPortBindCompleteTemplate(Action<RssPortBindCompleteArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssPortBindCompleteArgs(action, 1242, 1242, "RssPortBindComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssPortCapabilitiesArgs RssPortCapabilitiesTemplate(Action<RssPortCapabilitiesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssPortCapabilitiesArgs(action, 1233, 1233, "RssPortCapabilities", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssPortChangeArgs RssPortChangeTemplate(Action<RssPortChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssPortChangeArgs(action, 1231, 1231, "RssPortChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssPortBindCompleteArgs RssPortNotSupportedTemplate(Action<RssPortBindCompleteArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssPortBindCompleteArgs(action, 1243, 1243, "RssPortNotSupported", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssPortProcessorsArgs RssPortProcessorsTemplate(Action<RssPortProcessorsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssPortProcessorsArgs(action, 1234, 1234, "RssPortProcessors", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssPortReferenceArgs RssPortReferenceTemplate(Action<RssPortReferenceArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssPortReferenceArgs(action, 1232, 1232, "RssPortReference", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssPortRundownArgs RssPortRundownTemplate(Action<RssPortRundownArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssPortRundownArgs(action, 1246, 1246, "RssPortRundown", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssProcessorAssignmentArgs RssProcessorAssignmentTemplate(Action<RssProcessorAssignmentArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssProcessorAssignmentArgs(action, 1235, 1235, "RssProcessorAssignment", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssProcessorConsolidationArgs RssProcessorConsolidationTemplate(Action<RssProcessorConsolidationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssProcessorConsolidationArgs(action, 1238, 1238, "RssProcessorConsolidation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private RssProcessorUnassignmentArgs RssProcessorUnassignmentTemplate(Action<RssProcessorUnassignmentArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new RssProcessorUnassignmentArgs(action, 1236, 1236, "RssProcessorUnassignment", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private task_0Args task_0Template(Action<task_0Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new task_0Args(action, 1316, 0, "task_0", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private task_01317Args task_01317Template(Action<task_01317Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new task_01317Args(action, 1317, 0, "task_0", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private task_01318Args task_01318Template(Action<task_01318Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new task_01318Args(action, 1318, 0, "task_0", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private task_01319Args task_01319Template(Action<task_01319Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new task_01319Args(action, 1319, 0, "task_0", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private task_01320Args task_01320Template(Action<task_01320Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new task_01320Args(action, 1320, 0, "task_0", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpAbortTcbCompleteTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1040, 1040, "TcpAbortTcbComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpAbortTcbRequestTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1039, 1039, "TcpAbortTcbRequest", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpAcceptListenerCompleteTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1017, 1017, "TcpAcceptListenerComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAcceptListenerInsertionFailureArgs TcpAcceptListenerInsertionFailureTemplate(Action<TcpAcceptListenerInsertionFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAcceptListenerInsertionFailureArgs(action, 1015, 1015, "TcpAcceptListenerInsertionFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpAcceptListenerRejectedTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1016, 1016, "TcpAcceptListenerRejected", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpAccpetListenerRouteLookupFailureTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1014, 1014, "TcpAccpetListenerRouteLookupFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAcquirePortArgs TcpAcquirePortTemplate(Action<TcpAcquirePortArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAcquirePortArgs(action, 1191, 1191, "TcpAcquirePort", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAcquirePortArgs TcpAcquireWeakRefPortTemplate(Action<TcpAcquirePortArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAcquirePortArgs(action, 1192, 1192, "TcpAcquireWeakRefPort", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpAppSendBufferSizeTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1091, 1091, "TcpAppSendBufferSize", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAcquirePortArgs TcpAssignedWeakReferencePortTemplate(Action<TcpAcquirePortArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAcquirePortArgs(action, 1195, 1195, "TcpAssignedWeakReferencePort", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAutoTuningBeginArgs TcpAutoTuningBeginTemplate(Action<TcpAutoTuningBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAutoTuningBeginArgs(action, 1092, 1092, "TcpAutoTuningBegin", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAutoTuningBeginArgs TcpAutoTuningChangeRcvBufferSizeTemplate(Action<TcpAutoTuningBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAutoTuningBeginArgs(action, 1097, 1097, "TcpAutoTuningChangeRcvBufferSize", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAutoTuningBeginArgs TcpAutoTuningEndTemplate(Action<TcpAutoTuningBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAutoTuningBeginArgs(action, 1093, 1093, "TcpAutoTuningEnd", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAutoTuningBeginArgs TcpAutoTuningFailedAllocationFailureTemplate(Action<TcpAutoTuningBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAutoTuningBeginArgs(action, 1096, 1096, "TcpAutoTuningFailedAllocationFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAutoTuningBeginArgs TcpAutoTuningFailedBandwidthEstimationTemplate(Action<TcpAutoTuningBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAutoTuningBeginArgs(action, 1095, 1095, "TcpAutoTuningFailedBandwidthEstimation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAutoTuningBeginArgs TcpAutoTuningFailedRttEstimationTemplate(Action<TcpAutoTuningBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAutoTuningBeginArgs(action, 1094, 1094, "TcpAutoTuningFailedRttEstimation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoverySackExitArgs TcpBhDetectFullSizeAckTemplate(Action<TcpLossRecoverySackExitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoverySackExitArgs(action, 1196, 1196, "TcpBhDetectFullSizeAck", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpBindEndpointResolutionFailureArgs TcpBindEndpointCompleteTemplate(Action<TcpBindEndpointResolutionFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpBindEndpointResolutionFailureArgs(action, 1008, 1008, "TcpBindEndpointComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpBindEndpointResolutionFailureArgs TcpBindEndpointInspectionFailureTemplate(Action<TcpBindEndpointResolutionFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpBindEndpointResolutionFailureArgs(action, 1007, 1007, "TcpBindEndpointInspectionFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpBindEndpointResolutionFailureArgs TcpBindEndpointPortFailureTemplate(Action<TcpBindEndpointResolutionFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpBindEndpointResolutionFailureArgs(action, 1006, 1006, "TcpBindEndpointPortFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpBindEndpointResolutionFailureArgs TcpBindEndpointResolutionFailureTemplate(Action<TcpBindEndpointResolutionFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpBindEndpointResolutionFailureArgs(action, 1005, 1005, "TcpBindEndpointResolutionFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpBlackHoleDetectionEntryArgs TcpBlackHoleDetectionEntryTemplate(Action<TcpBlackHoleDetectionEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpBlackHoleDetectionEntryArgs(action, 1084, 1084, "TcpBlackHoleDetectionEntry", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpBlackHoleDetectionEntryArgs TcpBlackHoleDetectionExitTemplate(Action<TcpBlackHoleDetectionEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpBlackHoleDetectionEntryArgs(action, 1085, 1085, "TcpBlackHoleDetectionExit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpBlackHoleDetectionEntryArgs TcpBlackHoleDetectionFailedTemplate(Action<TcpBlackHoleDetectionEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpBlackHoleDetectionEntryArgs(action, 1086, 1086, "TcpBlackHoleDetectionFailed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpBindEndpointResolutionFailureArgs TcpCloseEndpointTemplate(Action<TcpBindEndpointResolutionFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpBindEndpointResolutionFailureArgs(action, 1009, 1009, "TcpCloseEndpoint", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpCloseTcbRequestTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1038, 1038, "TcpCloseTcbRequest", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectFailedPortAcquireTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1050, 1050, "TcpConnectFailedPortAcquire", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoveryEntryArgs TcpConnectionKeepAliveTemplate(Action<TcpLossRecoveryEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoveryEntryArgs(action, 1188, 1188, "TcpConnectionKeepAlive", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpConnectionOffloadStatusArgs TcpConnectionOffloadPmaxTemplate(Action<TcpConnectionOffloadStatusArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpConnectionOffloadStatusArgs(action, 1113, 1113, "TcpConnectionOffloadPmax", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpConnectionOffloadStateChangeArgs TcpConnectionOffloadStateChangeTemplate(Action<TcpConnectionOffloadStateChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpConnectionOffloadStateChangeArgs(action, 1099, 1099, "TcpConnectionOffloadStateChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpConnectionOffloadStatusArgs TcpConnectionOffloadStatusTemplate(Action<TcpConnectionOffloadStatusArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpConnectionOffloadStatusArgs(action, 1112, 1112, "TcpConnectionOffloadStatus", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpConnectionRundownArgs TcpConnectionRundownTemplate(Action<TcpConnectionRundownArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpConnectionRundownArgs(action, 1300, 1300, "TcpConnectionRundown", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpConnectionSummaryArgs TcpConnectionSummaryTemplate(Action<TcpConnectionSummaryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpConnectionSummaryArgs(action, 1352, 1341, "TcpConnectionSummary", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRequestConnectArgs TcpConnectionTerminatedRcvdRstTemplate(Action<TcpRequestConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRequestConnectArgs(action, 1184, 1184, "TcpConnectionTerminatedRcvdRst", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRequestConnectArgs TcpConnectionTerminatedRcvdSynTemplate(Action<TcpRequestConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRequestConnectArgs(action, 1185, 1185, "TcpConnectionTerminatedRcvdSyn", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRequestConnectArgs TcpConnectRestransmitTemplate(Action<TcpRequestConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRequestConnectArgs(action, 1186, 1186, "TcpConnectRestransmit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbCancelTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1029, 1029, "TcpConnectTcbCancel", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbCheckRateLimitTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1024, 1024, "TcpConnectTcbCheckRateLimit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbCompleteTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1033, 1033, "TcpConnectTcbComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbEstatsFailedTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1049, 1049, "TcpConnectTcbEstatsFailed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbFailDontFragmentTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1037, 1037, "TcpConnectTcbFailDontFragment", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpInspectConnectCompleteArgs TcpConnectTcbFailedActiveConnectTemplate(Action<TcpInspectConnectCompleteArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpInspectConnectCompleteArgs(action, 1089, 1089, "TcpConnectTcbFailedActiveConnect", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbFailedAfTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1018, 1018, "TcpConnectTcbFailedAf", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbFailedCompartmentTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1019, 1019, "TcpConnectTcbFailedCompartment", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbFailedInspectTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1020, 1020, "TcpConnectTcbFailedInspect", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRequestConnectArgs TcpConnectTcbFailedRcvdRstTemplate(Action<TcpRequestConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRequestConnectArgs(action, 1183, 1183, "TcpConnectTcbFailedRcvdRst", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbFailedRouteTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1021, 1021, "TcpConnectTcbFailedRoute", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRequestConnectArgs TcpConnectTcbFailInsertionTemplate(Action<TcpRequestConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRequestConnectArgs(action, 1030, 1030, "TcpConnectTcbFailInsertion", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbFailInspectConnectCompleteTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1035, 1035, "TcpConnectTcbFailInspectConnectComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbFailSessionStateTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1036, 1036, "TcpConnectTcbFailSessionState", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbFailureTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1034, 1034, "TcpConnectTcbFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpConnectTcbSkipRateLimitArgs TcpConnectTcbPassRateLimitTemplate(Action<TcpConnectTcbSkipRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpConnectTcbSkipRateLimitArgs(action, 1023, 1023, "TcpConnectTcbPassRateLimit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbProceedingTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1031, 1031, "TcpConnectTcbProceeding", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbRateLimitCancelTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1032, 1032, "TcpConnectTcbRateLimitCancel", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbRateLimitReleaseTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1027, 1027, "TcpConnectTcbRateLimitRelease", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpConnectTcbSkipRateLimitArgs TcpConnectTcbSkipRateLimitTemplate(Action<TcpConnectTcbSkipRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpConnectTcbSkipRateLimitArgs(action, 1022, 1022, "TcpConnectTcbSkipRateLimit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpConnectTcbTimeoutTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1045, 1045, "TcpConnectTcbTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCreateEndpointAfFailureArgs TcpCreateEndpointAfFailureTemplate(Action<TcpCreateEndpointAfFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCreateEndpointAfFailureArgs(action, 1010, 1010, "TcpCreateEndpointAfFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCreateEndpointAfFailureArgs TcpCreateEndpointCompartmentFailureTemplate(Action<TcpCreateEndpointAfFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCreateEndpointAfFailureArgs(action, 1011, 1011, "TcpCreateEndpointCompartmentFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCreateEndpointAfFailureArgs TcpCreateEndpointCompleteTemplate(Action<TcpCreateEndpointAfFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCreateEndpointAfFailureArgs(action, 1013, 1013, "TcpCreateEndpointComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCreateEndpointAfFailureArgs TcpCreateEndpointInspectionFailureTemplate(Action<TcpCreateEndpointAfFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCreateEndpointAfFailureArgs(action, 1012, 1012, "TcpCreateEndpointInspectionFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCreateNotificationChannelRequestArgs TcpCreateNotificationChannelRequestTemplate(Action<TcpCreateNotificationChannelRequestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCreateNotificationChannelRequestArgs(action, 1305, 1305, "TcpCreateNotificationChannelRequest", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCreateNotificationChannelRequestProcessedArgs TcpCreateNotificationChannelRequestProcessedTemplate(Action<TcpCreateNotificationChannelRequestProcessedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCreateNotificationChannelRequestProcessedArgs(action, 1307, 1307, "TcpCreateNotificationChannelRequestProcessed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCreateNotificationChannelRequestProcessingArgs TcpCreateNotificationChannelRequestProcessingTemplate(Action<TcpCreateNotificationChannelRequestProcessingArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCreateNotificationChannelRequestProcessingArgs(action, 1315, 1315, "TcpCreateNotificationChannelRequestProcessing", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCTcpAssignedBlocksArgs TcpCTcpAssignedBlocksTemplate(Action<TcpCTcpAssignedBlocksArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCTcpAssignedBlocksArgs(action, 1163, 1163, "TcpCTcpAssignedBlocks", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCTcpCongestionWndwArgs TcpCTcpCongestionWndwTemplate(Action<TcpCTcpCongestionWndwArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCTcpCongestionWndwArgs(action, 1164, 1164, "TcpCTcpCongestionWndw", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpCtcpDataTransferCumAckTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1151, 1151, "TcpCtcpDataTransferCumAck", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferCumAck1330Args TcpCtcpDataTransferCumAck1331Template(Action<TcpDataTransferCumAck1330Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferCumAck1330Args(action, 1331, 1151, "TcpCtcpDataTransferCumAck", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpCtcpDataTransferDupAckTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1152, 1152, "TcpCtcpDataTransferDupAck", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferDupAck1343Args TcpCtcpDataTransferDupAck1344Template(Action<TcpDataTransferDupAck1343Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferDupAck1343Args(action, 1344, 1152, "TcpCtcpDataTransferDupAck", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferEcnArgs TcpCtcpDataTransferEcnTemplate(Action<TcpDataTransferEcnArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferEcnArgs(action, 1154, 1154, "TcpCtcpDataTransferEcn", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpCtcpDataTransferSendTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1153, 1153, "TcpCtcpDataTransferSend", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferSend1332Args TcpCtcpDataTransferSend1333Template(Action<TcpDataTransferSend1332Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferSend1332Args(action, 1333, 1153, "TcpCtcpDataTransferSend", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpCtcpDataTransferSpuriousTimeoutTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1155, 1155, "TcpCtcpDataTransferSpuriousTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCtcpDataTransferTimeout1348Args TcpCtcpDataTransferSpuriousTimeout1349Template(Action<TcpCtcpDataTransferTimeout1348Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCtcpDataTransferTimeout1348Args(action, 1349, 1155, "TcpCtcpDataTransferSpuriousTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpCtcpDataTransferTimeoutTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1150, 1150, "TcpCtcpDataTransferTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCtcpDataTransferTimeout1348Args TcpCtcpDataTransferTimeout1348Template(Action<TcpCtcpDataTransferTimeout1348Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCtcpDataTransferTimeout1348Args(action, 1348, 1150, "TcpCtcpDataTransferTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpInspectConnectCompleteArgs TcpCTcpDelayWndwInactiveTemplate(Action<TcpInspectConnectCompleteArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpInspectConnectCompleteArgs(action, 1162, 1162, "TcpCTcpDelayWndwInactive", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCTcpGammaArgs TcpCTcpGammaTemplate(Action<TcpCTcpGammaArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCTcpGammaArgs(action, 1165, 1165, "TcpCTcpGamma", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCwndRestartArgs TcpCwndRestartTemplate(Action<TcpCwndRestartArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCwndRestartArgs(action, 1221, 1221, "TcpCwndRestart", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCwndRestartArgs TcpCwndRestart1229Template(Action<TcpCwndRestartArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCwndRestartArgs(action, 1229, 1221, "TcpCwndRestart", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpDataTransferCumAckTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1071, 1071, "TcpDataTransferCumAck", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferCumAck1330Args TcpDataTransferCumAck1330Template(Action<TcpDataTransferCumAck1330Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferCumAck1330Args(action, 1330, 1071, "TcpDataTransferCumAck", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpDataTransferDupAckTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1072, 1072, "TcpDataTransferDupAck", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferDupAck1343Args TcpDataTransferDupAck1343Template(Action<TcpDataTransferDupAck1343Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferDupAck1343Args(action, 1343, 1072, "TcpDataTransferDupAck", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferEcnArgs TcpDataTransferEcnTemplate(Action<TcpDataTransferEcnArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferEcnArgs(action, 1075, 1075, "TcpDataTransferEcn", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferEcnAlphaArgs TcpDataTransferEcnAlphaTemplate(Action<TcpDataTransferEcnAlphaArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferEcnAlphaArgs(action, 1225, 1225, "TcpDataTransferEcnAlpha", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferReceiveArgs TcpDataTransferReceiveTemplate(Action<TcpDataTransferReceiveArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferReceiveArgs(action, 1074, 1074, "TcpDataTransferReceive", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRequestConnectArgs TcpDataTransferRestransmitTemplate(Action<TcpRequestConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRequestConnectArgs(action, 1187, 1187, "TcpDataTransferRestransmit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpDataTransferRetransmitRoundTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1077, 1077, "TcpDataTransferRetransmitRound", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferRetransmitRound1351Args TcpDataTransferRetransmitRound1351Template(Action<TcpDataTransferRetransmitRound1351Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferRetransmitRound1351Args(action, 1351, 1077, "TcpDataTransferRetransmitRound", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpDataTransferRttSampleTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1070, 1070, "TcpDataTransferRttSample", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferRttSample1341Args TcpDataTransferRttSample1341Template(Action<TcpDataTransferRttSample1341Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferRttSample1341Args(action, 1341, 1070, "TcpDataTransferRttSample", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpDataTransferSendTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1073, 1073, "TcpDataTransferSend", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferSend1332Args TcpDataTransferSend1332Template(Action<TcpDataTransferSend1332Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferSend1332Args(action, 1332, 1073, "TcpDataTransferSend", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpDataTransferSpuriousTimeoutTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1076, 1076, "TcpDataTransferSpuriousTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferSpuriousTimeout1345Args TcpDataTransferSpuriousTimeout1345Template(Action<TcpDataTransferSpuriousTimeout1345Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferSpuriousTimeout1345Args(action, 1345, 1076, "TcpDataTransferSpuriousTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpDataTransferTimeoutTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1069, 1069, "TcpDataTransferTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDeliveryAcceptTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1175, 1175, "TcpDeliveryAccept", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDeliveryCompletingTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1181, 1181, "TcpDeliveryCompleting", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDeliveryDataDroppedTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1190, 1190, "TcpDeliveryDataDropped", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDeliveryFinTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1176, 1176, "TcpDeliveryFin", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDeliveryFlushTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1171, 1171, "TcpDeliveryFlush", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDeliveryIndicatedTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1157, 1157, "TcpDeliveryIndicated", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDeliveryInjectingDataTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1173, 1173, "TcpDeliveryInjectingData", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDeliveryPushTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1178, 1178, "TcpDeliveryPush", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDeliverySatisfiedTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1158, 1158, "TcpDeliverySatisfied", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDeliveryStateChangeArgs TcpDeliveryStateChangeTemplate(Action<TcpDeliveryStateChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDeliveryStateChangeArgs(action, 1189, 1189, "TcpDeliveryStateChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpPlumbWakePatternArgs TcpDeplumbWakePatternTemplate(Action<TcpPlumbWakePatternArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpPlumbWakePatternArgs(action, 1312, 1312, "TcpDeplumbWakePattern", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCreateNotificationChannelRequestArgs TcpDetachNotificationChannelTemplate(Action<TcpCreateNotificationChannelRequestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCreateNotificationChannelRequestArgs(action, 1309, 1309, "TcpDetachNotificationChannel", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpDisconnectTcbCompleteTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1043, 1043, "TcpDisconnectTcbComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpDisconnectTcbFinWait2TimeoutTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1201, 1201, "TcpDisconnectTcbFinWait2Timeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpDisconnectTcbInjectFailedTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1041, 1041, "TcpDisconnectTcbInjectFailed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpDisconnectTcbKeepaliveTimeoutTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1047, 1047, "TcpDisconnectTcbKeepaliveTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbRequestArgs TcpDisconnectTcbRequestTemplate(Action<TcpDisconnectTcbRequestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbRequestArgs(action, 1042, 1042, "TcpDisconnectTcbRequest", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpDisconnectTcbRtoTimeoutTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1046, 1046, "TcpDisconnectTcbRtoTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpDisconnectTcbTimeoutTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1048, 1048, "TcpDisconnectTcbTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpDisconnectTcbZeroWindowTimeoutTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1200, 1200, "TcpDisconnectTcbZeroWindowTimeout", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpEndpointAcquirePortReservationArgs TcpEndpointAcquirePortReservationTemplate(Action<TcpEndpointAcquirePortReservationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpEndpointAcquirePortReservationArgs(action, 1052, 1052, "TcpEndpointAcquirePortReservation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpEndpointCreationArgs TcpEndpointCreationTemplate(Action<TcpEndpointCreationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpEndpointCreationArgs(action, 1001, 1001, "TcpEndpointCreation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpEndpointAcquirePortReservationArgs TcpEndpointFailedPortReservationTemplate(Action<TcpEndpointAcquirePortReservationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpEndpointAcquirePortReservationArgs(action, 1053, 1053, "TcpEndpointFailedPortReservation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoverySackExitArgs TcpFlushSackTemplate(Action<TcpLossRecoverySackExitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoverySackExitArgs(action, 1197, 1197, "TcpFlushSack", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpGlobalAddInterfaceArgs TcpGlobalAddInterfaceTemplate(Action<TcpGlobalAddInterfaceArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpGlobalAddInterfaceArgs(action, 1061, 1061, "TcpGlobalAddInterface", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSecurityRateLimitArgs TcpGlobalConnectionRateLimitViolationTemplate(Action<TcpSecurityRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSecurityRateLimitArgs(action, 1057, 1057, "TcpGlobalConnectionRateLimitViolation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpGlobalAddInterfaceArgs TcpGlobalDeleteInterfaceTemplate(Action<TcpGlobalAddInterfaceArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpGlobalAddInterfaceArgs(action, 1062, 1062, "TcpGlobalDeleteInterface", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpGlobalIsbBeginThrottleArgs TcpGlobalIsbBeginThrottleTemplate(Action<TcpGlobalIsbBeginThrottleArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpGlobalIsbBeginThrottleArgs(action, 1059, 1059, "TcpGlobalIsbBeginThrottle", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpGlobalIsbBeginThrottleArgs TcpGlobalIsbEndThrottleTemplate(Action<TcpGlobalIsbBeginThrottleArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpGlobalIsbBeginThrottleArgs(action, 1060, 1060, "TcpGlobalIsbEndThrottle", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSecurityRateLimitArgs TcpGlobalLandAttackSegmentDropTemplate(Action<TcpSecurityRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSecurityRateLimitArgs(action, 1058, 1058, "TcpGlobalLandAttackSegmentDrop", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpGlobalParametersArgs TcpGlobalParametersTemplate(Action<TcpGlobalParametersArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpGlobalParametersArgs(action, 1110, 1110, "TcpGlobalParameters", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpEndpointAcquirePortReservationArgs TcpGlobalPortReservationTemplate(Action<TcpEndpointAcquirePortReservationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpEndpointAcquirePortReservationArgs(action, 1054, 1054, "TcpGlobalPortReservation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSecurityRateLimitArgs TcpGlobalReassemblyLimitViolationTemplate(Action<TcpSecurityRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSecurityRateLimitArgs(action, 1056, 1056, "TcpGlobalReassemblyLimitViolation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSecurityRateLimitArgs TcpGlobalSynAttackEntryTemplate(Action<TcpSecurityRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSecurityRateLimitArgs(action, 1055, 1055, "TcpGlobalSynAttackEntry", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSecurityRateLimitArgs TcpGlobalSynAttackExitTemplate(Action<TcpSecurityRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSecurityRateLimitArgs(action, 1063, 1063, "TcpGlobalSynAttackExit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCwndRestartArgs TcpInitialCwndAdjustedTemplate(Action<TcpCwndRestartArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCwndRestartArgs(action, 1222, 1222, "TcpInitialCwndAdjusted", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRequestConnectArgs TcpInitiateSynRstValidationTemplate(Action<TcpRequestConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRequestConnectArgs(action, 1182, 1182, "TcpInitiateSynRstValidation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpInspectConnectCompleteArgs TcpInspectConnectCompleteTemplate(Action<TcpInspectConnectCompleteArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpInspectConnectCompleteArgs(action, 1003, 1003, "TcpInspectConnectComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpInterfaceRscStateChangeArgs TcpInterfaceRscStateChangeTemplate(Action<TcpInterfaceRscStateChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpInterfaceRscStateChangeArgs(action, 1226, 1226, "TcpInterfaceRscStateChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipAoacFailFastArgs TcpipAoacFailFastTemplate(Action<TcpipAoacFailFastArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipAoacFailFastArgs(action, 1357, 1357, "TcpipAoacFailFast", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipGenericArgs TcpipGenericTemplate(Action<TcpipGenericArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipGenericArgs(action, 1353, 1342, "TcpipGeneric", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMediaDisconnectArgs TcpipLimitedLinkConnectivityTemplate(Action<TcpMediaDisconnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMediaDisconnectArgs(action, 1322, 1323, "TcpipLimitedLinkConnectivity", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMediaDisconnectArgs TcpipLimitedLinkConnectivity1323Template(Action<TcpMediaDisconnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMediaDisconnectArgs(action, 1323, 1323, "TcpipLimitedLinkConnectivity", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMediaDisconnectArgs TcpipMediaConnectTemplate(Action<TcpMediaDisconnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMediaDisconnectArgs(action, 1321, 1321, "TcpipMediaConnect", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipNetworkPacketDropsArgs TcpipNetworkPacketDropsTemplate(Action<TcpipNetworkPacketDropsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipNetworkPacketDropsArgs(action, 1215, 1215, "TcpipNetworkPacketDrops", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipPlumbWakePatternOnInterfaceArgs TcpipPlumbWakePatternOnInterfaceTemplate(Action<TcpipPlumbWakePatternOnInterfaceArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipPlumbWakePatternOnInterfaceArgs(action, 1313, 1313, "TcpipPlumbWakePatternOnInterface", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipReceiveSlowPathArgs TcpipReceiveSlowPathTemplate(Action<TcpipReceiveSlowPathArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipReceiveSlowPathArgs(action, 1205, 1205, "TcpipReceiveSlowPath", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipSendSlowPathArgs TcpipSendSlowPathTemplate(Action<TcpipSendSlowPathArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipSendSlowPathArgs(action, 1206, 1206, "TcpipSendSlowPath", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipSilentModeArgs TcpipSilentModeTemplate(Action<TcpipSilentModeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipSilentModeArgs(action, 1304, 1304, "TcpipSilentMode", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipTransportPacketDropsArgs TcpipTransportPacketDropsTemplate(Action<TcpipTransportPacketDropsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipTransportPacketDropsArgs(action, 1214, 1214, "TcpipTransportPacketDrops", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipUpdateInterfaceConfigFlagsArgs TcpipUpdateInterfaceConfigFlagsTemplate(Action<TcpipUpdateInterfaceConfigFlagsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipUpdateInterfaceConfigFlagsArgs(action, 1358, 1346, "TcpipUpdateInterfaceConfigFlags", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipWakePacketIndicatedArgs TcpipWakePacketIndicatedTemplate(Action<TcpipWakePacketIndicatedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipWakePacketIndicatedArgs(action, 1302, 1302, "TcpipWakePacketIndicated", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpipWakePacketIndicated1303Args TcpipWakePacketIndicated1303Template(Action<TcpipWakePacketIndicated1303Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpipWakePacketIndicated1303Args(action, 1303, 1302, "TcpipWakePacketIndicated", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpIsPatternCoalescingRequiredArgs TcpIsPatternCoalescingRequiredTemplate(Action<TcpIsPatternCoalescingRequiredArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpIsPatternCoalescingRequiredArgs(action, 1355, 1344, "TcpIsPatternCoalescingRequired", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpListenerActivationFailedAfArgs TcpListenerActivatedTemplate(Action<TcpListenerActivationFailedAfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpListenerActivationFailedAfArgs(action, 1123, 1123, "TcpListenerActivated", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpListenerActivationFailedAfArgs TcpListenerActivationFailedAfTemplate(Action<TcpListenerActivationFailedAfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpListenerActivationFailedAfArgs(action, 1117, 1117, "TcpListenerActivationFailedAf", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpListenerActivationFailedAfArgs TcpListenerActivationFailedCompartmentTemplate(Action<TcpListenerActivationFailedAfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpListenerActivationFailedAfArgs(action, 1118, 1118, "TcpListenerActivationFailedCompartment", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpListenerActivationFailedAfArgs TcpListenerActivationFailedInspection1Template(Action<TcpListenerActivationFailedAfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpListenerActivationFailedAfArgs(action, 1119, 1119, "TcpListenerActivationFailedInspection1", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpListenerActivationFailedAfArgs TcpListenerActivationFailedInspection2Template(Action<TcpListenerActivationFailedAfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpListenerActivationFailedAfArgs(action, 1120, 1120, "TcpListenerActivationFailedInspection2", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpListenerActivationFailedAfArgs TcpListenerBindFailedPortTemplate(Action<TcpListenerActivationFailedAfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpListenerActivationFailedAfArgs(action, 1122, 1122, "TcpListenerBindFailedPort", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpListenerActivationFailedAfArgs TcpListenerBindFailedResolutionTemplate(Action<TcpListenerActivationFailedAfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpListenerActivationFailedAfArgs(action, 1121, 1121, "TcpListenerBindFailedResolution", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpListenerActivationFailedAfArgs TcpListenerUnboundTemplate(Action<TcpListenerActivationFailedAfArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpListenerActivationFailedAfArgs(action, 1124, 1124, "TcpListenerUnbound", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLoopbackFastPathFailReasonArgs TcpLoopbackFastPathFailReasonTemplate(Action<TcpLoopbackFastPathFailReasonArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLoopbackFastPathFailReasonArgs(action, 1228, 1228, "TcpLoopbackFastPathFailReason", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoveryEntryArgs TcpLossRecoveryEntryTemplate(Action<TcpLossRecoveryEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoveryEntryArgs(action, 1078, 1078, "TcpLossRecoveryEntry", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoveryEntryArgs TcpLossRecoveryExitTemplate(Action<TcpLossRecoveryEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoveryEntryArgs(action, 1079, 1079, "TcpLossRecoveryExit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoverySackEntryArgs TcpLossRecoverySackEntryTemplate(Action<TcpLossRecoverySackEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoverySackEntryArgs(action, 1080, 1080, "TcpLossRecoverySackEntry", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoverySackExitArgs TcpLossRecoverySackExitTemplate(Action<TcpLossRecoverySackExitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoverySackExitArgs(action, 1081, 1081, "TcpLossRecoverySackExit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLsoArgs TcpLsoTemplate(Action<TcpLsoArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLsoArgs(action, 1111, 1111, "TcpLso", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMediaDisconnectArgs TcpMediaDisconnectTemplate(Action<TcpMediaDisconnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMediaDisconnectArgs(action, 1106, 1106, "TcpMediaDisconnect", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMemoryFailuresArgs TcpMemoryFailuresTemplate(Action<TcpMemoryFailuresArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMemoryFailuresArgs(action, 1109, 1109, "TcpMemoryFailures", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpModuleStartedArgs TcpModuleStartedTemplate(Action<TcpModuleStartedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpModuleStartedArgs(action, 1107, 1107, "TcpModuleStarted", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpModuleStartedArgs TcpModuleStoppedTemplate(Action<TcpModuleStartedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpModuleStartedArgs(action, 1108, 1108, "TcpModuleStopped", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMppNppEvaluationArgs TcpMppNppEvaluationTemplate(Action<TcpMppNppEvaluationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMppNppEvaluationArgs(action, 1216, 1216, "TcpMppNppEvaluation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMppStartEpisodeArgs TcpMppStartEpisodeTemplate(Action<TcpMppStartEpisodeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMppStartEpisodeArgs(action, 1217, 1217, "TcpMppStartEpisode", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMppStartEpochArgs TcpMppStartEpochTemplate(Action<TcpMppStartEpochArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMppStartEpochArgs(action, 1219, 1219, "TcpMppStartEpoch", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMppStopEpisodeArgs TcpMppStopEpisodeTemplate(Action<TcpMppStopEpisodeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMppStopEpisodeArgs(action, 1218, 1218, "TcpMppStopEpisode", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpMppStopEpochArgs TcpMppStopEpochTemplate(Action<TcpMppStopEpochArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpMppStopEpochArgs(action, 1220, 1220, "TcpMppStopEpoch", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpPlumbWakePatternArgs TcpPlumbWakePatternTemplate(Action<TcpPlumbWakePatternArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpPlumbWakePatternArgs(action, 1311, 1311, "TcpPlumbWakePattern", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpQueryNotificationChannelStatusRequestArgs TcpQueryNotificationChannelStatusRequestTemplate(Action<TcpQueryNotificationChannelStatusRequestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpQueryNotificationChannelStatusRequestArgs(action, 1306, 1306, "TcpQueryNotificationChannelStatusRequest", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpConnectTcbSkipRateLimitArgs TcpRateLimitPathCancelTemplate(Action<TcpConnectTcbSkipRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpConnectTcbSkipRateLimitArgs(action, 1028, 1028, "TcpRateLimitPathCancel", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpConnectTcbSkipRateLimitArgs TcpRateLimitPathReleaseTemplate(Action<TcpConnectTcbSkipRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpConnectTcbSkipRateLimitArgs(action, 1026, 1026, "TcpRateLimitPathRelease", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoveryEntryArgs TcpReassemblyEntryTemplate(Action<TcpLossRecoveryEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoveryEntryArgs(action, 1198, 1198, "TcpReassemblyEntry", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoveryEntryArgs TcpReassemblyExitTemplate(Action<TcpLossRecoveryEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoveryEntryArgs(action, 1199, 1199, "TcpReassemblyExit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoverySackExitArgs TcpReassemblyFlushTemplate(Action<TcpLossRecoverySackExitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoverySackExitArgs(action, 1204, 1204, "TcpReassemblyFlush", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpReceiveRequestTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1156, 1156, "TcpReceiveRequest", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpReleaseIndicationArgs TcpReleaseIndicationTemplate(Action<TcpReleaseIndicationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpReleaseIndicationArgs(action, 1090, 1090, "TcpReleaseIndication", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAcquirePortArgs TcpReleasePortTemplate(Action<TcpAcquirePortArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAcquirePortArgs(action, 1193, 1193, "TcpReleasePort", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAcquirePortArgs TcpReplacePortTemplate(Action<TcpAcquirePortArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAcquirePortArgs(action, 1194, 1194, "TcpReplacePort", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRequestConnectArgs TcpRequestConnectTemplate(Action<TcpRequestConnectArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRequestConnectArgs(action, 1002, 1002, "TcpRequestConnect", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRscNblOobInfoArgs TcpRscNblOobInfoTemplate(Action<TcpRscNblOobInfoArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRscNblOobInfoArgs(action, 1227, 1227, "TcpRscNblOobInfo", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRssTableChangeArgs TcpRssTableChangeTemplate(Action<TcpRssTableChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRssTableChangeArgs(action, 1068, 1068, "TcpRssTableChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpRtcPortRangeAssignmentArgs TcpRtcPortRangeAssignmentTemplate(Action<TcpRtcPortRangeAssignmentArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpRtcPortRangeAssignmentArgs(action, 1356, 1345, "TcpRtcPortRangeAssignment", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpRttResiliencyDetectionTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1098, 1098, "TcpRttResiliencyDetection", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferRttSample1341Args TcpRttResiliencyDetection1342Template(Action<TcpDataTransferRttSample1341Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferRttSample1341Args(action, 1342, 1098, "TcpRttResiliencyDetection", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSackUpdateArgs TcpSackUpdateTemplate(Action<TcpSackUpdateArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSackUpdateArgs(action, 1354, 1343, "TcpSackUpdate", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSecurityRateLimitArgs TcpSecurityRateLimitTemplate(Action<TcpSecurityRateLimitArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSecurityRateLimitArgs(action, 1025, 1025, "TcpSecurityRateLimit", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSendPostedArgs TcpSendAdvanceTemplate(Action<TcpSendPostedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSendPostedArgs(action, 1161, 1161, "TcpSendAdvance", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSendPostedArgs TcpSendPostedTemplate(Action<TcpSendPostedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSendPostedArgs(action, 1159, 1159, "TcpSendPosted", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSendPostedArgs TcpSendTransmittedTemplate(Action<TcpSendPostedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSendPostedArgs(action, 1160, 1160, "TcpSendTransmitted", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSetTcpOptionArgs TcpSetTcpOptionTemplate(Action<TcpSetTcpOptionArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSetTcpOptionArgs(action, 1104, 1104, "TcpSetTcpOption", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSetTcpSoOptionArgs TcpSetTcpSoOptionTemplate(Action<TcpSetTcpSoOptionArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSetTcpSoOptionArgs(action, 1105, 1105, "TcpSetTcpSoOption", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpAccpetListenerRouteLookupFailureArgs TcpShutdownTcbTemplate(Action<TcpAccpetListenerRouteLookupFailureArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpAccpetListenerRouteLookupFailureArgs(action, 1044, 1044, "TcpShutdownTcb", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSignalNotificationChannelEventArgs TcpSignalNotificationChannelEventTemplate(Action<TcpSignalNotificationChannelEventArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSignalNotificationChannelEventArgs(action, 1308, 1308, "TcpSignalNotificationChannelEvent", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpSlowStartToCongestionAvoidanceTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1082, 1082, "TcpSlowStartToCongestionAvoidance", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCtcpDataTransferTimeout1348Args TcpSlowStartToCongestionAvoidance1350Template(Action<TcpCtcpDataTransferTimeout1348Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCtcpDataTransferTimeout1348Args(action, 1350, 1082, "TcpSlowStartToCongestionAvoidance", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpSpuriousRtoDetectionBeginTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1087, 1087, "TcpSpuriousRtoDetectionBegin", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferSpuriousTimeout1345Args TcpSpuriousRtoDetectionBegin1346Template(Action<TcpDataTransferSpuriousTimeout1345Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferSpuriousTimeout1345Args(action, 1346, 1087, "TcpSpuriousRtoDetectionBegin", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferTimeoutArgs TcpSpuriousRtoDetectionEndTemplate(Action<TcpDataTransferTimeoutArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferTimeoutArgs(action, 1088, 1088, "TcpSpuriousRtoDetectionEnd", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDataTransferSpuriousTimeout1345Args TcpSpuriousRtoDetectionEnd1347Template(Action<TcpDataTransferSpuriousTimeout1345Args> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDataTransferSpuriousTimeout1345Args(action, 1347, 1088, "TcpSpuriousRtoDetectionEnd", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSrttMeasurementStartedArgs TcpSrttMeasurementCancelledTemplate(Action<TcpSrttMeasurementStartedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSrttMeasurementStartedArgs(action, 1168, 1168, "TcpSrttMeasurementCancelled", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSrttMeasurementStartedArgs TcpSrttMeasurementCompleteTemplate(Action<TcpSrttMeasurementStartedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSrttMeasurementStartedArgs(action, 1167, 1167, "TcpSrttMeasurementComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSrttMeasurementStartedArgs TcpSrttMeasurementStartedTemplate(Action<TcpSrttMeasurementStartedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSrttMeasurementStartedArgs(action, 1166, 1166, "TcpSrttMeasurementStarted", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSwsAvoidanceBeginArgs TcpSwsAvoidanceBeginTemplate(Action<TcpSwsAvoidanceBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSwsAvoidanceBeginArgs(action, 1100, 1100, "TcpSwsAvoidanceBegin", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpSwsAvoidanceBeginArgs TcpSwsAvoidanceEndTemplate(Action<TcpSwsAvoidanceBeginArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpSwsAvoidanceBeginArgs(action, 1101, 1101, "TcpSwsAvoidanceEnd", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpTcbChangeIsbArgs TcpTcbChangeIsbTemplate(Action<TcpTcbChangeIsbArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpTcbChangeIsbArgs(action, 1067, 1067, "TcpTcbChangeIsb", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpTcbStopTimerArgs TcpTcbExpireTimerTemplate(Action<TcpTcbStopTimerArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpTcbStopTimerArgs(action, 1066, 1066, "TcpTcbExpireTimer", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpTcbInjectFinCompleteTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1180, 1180, "TcpTcbInjectFinComplete", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpTcbInjectFinFailureTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1174, 1174, "TcpTcbInjectFinFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpDisconnectTcbInjectFailedArgs TcpTcbInjectRcvFailureTemplate(Action<TcpDisconnectTcbInjectFailedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpDisconnectTcbInjectFailedArgs(action, 1172, 1172, "TcpTcbInjectRcvFailure", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpTcbStartTimerArgs TcpTcbStartTimerTemplate(Action<TcpTcbStartTimerArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpTcbStartTimerArgs(action, 1064, 1064, "TcpTcbStartTimer", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpTcbStateChangeArgs TcpTcbStateChangeTemplate(Action<TcpTcbStateChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpTcbStateChangeArgs(action, 1051, 1051, "TcpTcbStateChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpTcbStopTimerArgs TcpTcbStopTimerTemplate(Action<TcpTcbStopTimerArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpTcbStopTimerArgs(action, 1065, 1065, "TcpTcbStopTimer", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpTcbSynSendArgs TcpTcbSynSendTemplate(Action<TcpTcbSynSendArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpTcbSynSendArgs(action, 1004, 1004, "TcpTcbSynSend", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpTemplateChangedArgs TcpTemplateChangedTemplate(Action<TcpTemplateChangedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpTemplateChangedArgs(action, 1224, 1224, "TcpTemplateChanged", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpTemplateParametersArgs TcpTemplateParametersTemplate(Action<TcpTemplateParametersArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpTemplateParametersArgs(action, 1223, 1223, "TcpTemplateParameters", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpCreateNotificationChannelRequestArgs TcpUnlinkNotificationChannelTemplate(Action<TcpCreateNotificationChannelRequestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpCreateNotificationChannelRequestArgs(action, 1310, 1310, "TcpUnlinkNotificationChannel", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpWsdCacheEntryStateChangeArgs TcpWsdCacheEntryStateChangeTemplate(Action<TcpWsdCacheEntryStateChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpWsdCacheEntryStateChangeArgs(action, 1211, 1211, "TcpWsdCacheEntryStateChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpWsdInitializationErrorsArgs TcpWsdInitializationErrorsTemplate(Action<TcpWsdInitializationErrorsArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpWsdInitializationErrorsArgs(action, 1207, 1207, "TcpWsdInitializationErrors", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpWsdInitializationInformationArgs TcpWsdInitializationInformationTemplate(Action<TcpWsdInitializationInformationArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpWsdInitializationInformationArgs(action, 1208, 1208, "TcpWsdInitializationInformation", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpWsdProfileStateChangeArgs TcpWsdProfileStateChangeTemplate(Action<TcpWsdProfileStateChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpWsdProfileStateChangeArgs(action, 1212, 1212, "TcpWsdProfileStateChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpWsdStateChangeArgs TcpWsdStateChangeTemplate(Action<TcpWsdStateChangeArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpWsdStateChangeArgs(action, 1213, 1213, "TcpWsdStateChange", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpWsdWsRestrictedProfileArgs TcpWsdWsRestrictedDestinationTemplate(Action<TcpWsdWsRestrictedProfileArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpWsdWsRestrictedProfileArgs(action, 1210, 1210, "TcpWsdWsRestrictedDestination", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpWsdWsRestrictedProfileArgs TcpWsdWsRestrictedProfileTemplate(Action<TcpWsdWsRestrictedProfileArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpWsdWsRestrictedProfileArgs(action, 1209, 1209, "TcpWsdWsRestrictedProfile", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoveryEntryArgs TcpZeroWindowProbingBeginTemplate(Action<TcpLossRecoveryEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoveryEntryArgs(action, 1102, 1102, "TcpZeroWindowProbingBegin", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private TcpLossRecoveryEntryArgs TcpZeroWindowProbingEndTemplate(Action<TcpLossRecoveryEntryArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new TcpLossRecoveryEntryArgs(action, 1103, 1103, "TcpZeroWindowProbingEnd", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private UdpCreateNotificationChannelRequestArgs UdpCreateNotificationChannelRequestTemplate(Action<UdpCreateNotificationChannelRequestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new UdpCreateNotificationChannelRequestArgs(action, 1334, 1334, "UdpCreateNotificationChannelRequest", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private UdpCreateNotificationChannelRequestProcessedArgs UdpCreateNotificationChannelRequestProcessedTemplate(Action<UdpCreateNotificationChannelRequestProcessedArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new UdpCreateNotificationChannelRequestProcessedArgs(action, 1336, 1336, "UdpCreateNotificationChannelRequestProcessed", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private UdpCreateNotificationChannelRequestProcessingArgs UdpCreateNotificationChannelRequestProcessingTemplate(Action<UdpCreateNotificationChannelRequestProcessingArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new UdpCreateNotificationChannelRequestProcessingArgs(action, 1340, 1340, "UdpCreateNotificationChannelRequestProcessing", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private UdpQueryNotificationChannelStatusRequestArgs UdpDetachNotificationChannelTemplate(Action<UdpQueryNotificationChannelStatusRequestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new UdpQueryNotificationChannelStatusRequestArgs(action, 1338, 1338, "UdpDetachNotificationChannel", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private UdpEndpointSendMessagesArgs UdpEndpointReceiveMessagesTemplate(Action<UdpEndpointSendMessagesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new UdpEndpointSendMessagesArgs(action, 1170, 1170, "UdpEndpointReceiveMessages", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private UdpEndpointSendMessagesArgs UdpEndpointSendMessagesTemplate(Action<UdpEndpointSendMessagesArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new UdpEndpointSendMessagesArgs(action, 1169, 1169, "UdpEndpointSendMessages", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private UdpQueryNotificationChannelStatusRequestArgs UdpQueryNotificationChannelStatusRequestTemplate(Action<UdpQueryNotificationChannelStatusRequestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new UdpQueryNotificationChannelStatusRequestArgs(action, 1335, 1335, "UdpQueryNotificationChannelStatusRequest", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private UdpSignalNotificationChannelEventArgs UdpSignalNotificationChannelEventTemplate(Action<UdpSignalNotificationChannelEventArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new UdpSignalNotificationChannelEventArgs(action, 1337, 1337, "UdpSignalNotificationChannelEvent", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }
        static private UdpQueryNotificationChannelStatusRequestArgs UdpUnlinkNotificationChannelTemplate(Action<UdpQueryNotificationChannelStatusRequestArgs> action)
        {                  // action, eventid, taskid, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName
            return new UdpQueryNotificationChannelStatusRequestArgs(action, 1339, 1339, "UdpUnlinkNotificationChannel", Guid.Empty, 0, "", ProviderGuid, ProviderName);
        }

        static private volatile TraceEvent[] s_templates;
        protected internal override void EnumerateTemplates(Func<string, string, EventFilterResponse> eventsToObserve, Action<TraceEvent> callback)
        {
            if (s_templates == null)
            {
                var templates = new TraceEvent[344];
                templates[0] = TcpEndpointCreationTemplate(null);
                templates[1] = TcpRequestConnectTemplate(null);
                templates[2] = TcpInspectConnectCompleteTemplate(null);
                templates[3] = TcpTcbSynSendTemplate(null);
                templates[4] = TcpBindEndpointResolutionFailureTemplate(null);
                templates[5] = TcpBindEndpointPortFailureTemplate(null);
                templates[6] = TcpBindEndpointInspectionFailureTemplate(null);
                templates[7] = TcpBindEndpointCompleteTemplate(null);
                templates[8] = TcpCloseEndpointTemplate(null);
                templates[9] = TcpCreateEndpointAfFailureTemplate(null);
                templates[10] = TcpCreateEndpointCompartmentFailureTemplate(null);
                templates[11] = TcpCreateEndpointInspectionFailureTemplate(null);
                templates[12] = TcpCreateEndpointCompleteTemplate(null);
                templates[13] = TcpAccpetListenerRouteLookupFailureTemplate(null);
                templates[14] = TcpAcceptListenerInsertionFailureTemplate(null);
                templates[15] = TcpAcceptListenerRejectedTemplate(null);
                templates[16] = TcpAcceptListenerCompleteTemplate(null);
                templates[17] = TcpConnectTcbFailedAfTemplate(null);
                templates[18] = TcpConnectTcbFailedCompartmentTemplate(null);
                templates[19] = TcpConnectTcbFailedInspectTemplate(null);
                templates[20] = TcpConnectTcbFailedRouteTemplate(null);
                templates[21] = TcpConnectTcbSkipRateLimitTemplate(null);
                templates[22] = TcpConnectTcbPassRateLimitTemplate(null);
                templates[23] = TcpConnectTcbCheckRateLimitTemplate(null);
                templates[24] = TcpSecurityRateLimitTemplate(null);
                templates[25] = TcpRateLimitPathReleaseTemplate(null);
                templates[26] = TcpConnectTcbRateLimitReleaseTemplate(null);
                templates[27] = TcpRateLimitPathCancelTemplate(null);
                templates[28] = TcpConnectTcbCancelTemplate(null);
                templates[29] = TcpConnectTcbFailInsertionTemplate(null);
                templates[30] = TcpConnectTcbProceedingTemplate(null);
                templates[31] = TcpConnectTcbRateLimitCancelTemplate(null);
                templates[32] = TcpConnectTcbCompleteTemplate(null);
                templates[33] = TcpConnectTcbFailureTemplate(null);
                templates[34] = TcpConnectTcbFailInspectConnectCompleteTemplate(null);
                templates[35] = TcpConnectTcbFailSessionStateTemplate(null);
                templates[36] = TcpConnectTcbFailDontFragmentTemplate(null);
                templates[37] = TcpCloseTcbRequestTemplate(null);
                templates[38] = TcpAbortTcbRequestTemplate(null);
                templates[39] = TcpAbortTcbCompleteTemplate(null);
                templates[40] = TcpDisconnectTcbInjectFailedTemplate(null);
                templates[41] = TcpDisconnectTcbRequestTemplate(null);
                templates[42] = TcpDisconnectTcbCompleteTemplate(null);
                templates[43] = TcpShutdownTcbTemplate(null);
                templates[44] = TcpConnectTcbTimeoutTemplate(null);
                templates[45] = TcpDisconnectTcbRtoTimeoutTemplate(null);
                templates[46] = TcpDisconnectTcbKeepaliveTimeoutTemplate(null);
                templates[47] = TcpDisconnectTcbTimeoutTemplate(null);
                templates[48] = TcpConnectTcbEstatsFailedTemplate(null);
                templates[49] = TcpConnectFailedPortAcquireTemplate(null);
                templates[50] = TcpTcbStateChangeTemplate(null);
                templates[51] = TcpEndpointAcquirePortReservationTemplate(null);
                templates[52] = TcpEndpointFailedPortReservationTemplate(null);
                templates[53] = TcpGlobalPortReservationTemplate(null);
                templates[54] = TcpGlobalSynAttackEntryTemplate(null);
                templates[55] = TcpGlobalReassemblyLimitViolationTemplate(null);
                templates[56] = TcpGlobalConnectionRateLimitViolationTemplate(null);
                templates[57] = TcpGlobalLandAttackSegmentDropTemplate(null);
                templates[58] = TcpGlobalIsbBeginThrottleTemplate(null);
                templates[59] = TcpGlobalIsbEndThrottleTemplate(null);
                templates[60] = TcpGlobalAddInterfaceTemplate(null);
                templates[61] = TcpGlobalDeleteInterfaceTemplate(null);
                templates[62] = TcpGlobalSynAttackExitTemplate(null);
                templates[63] = TcpTcbStartTimerTemplate(null);
                templates[64] = TcpTcbStartTimerTemplate(null);
                templates[65] = TcpTcbStopTimerTemplate(null);
                templates[66] = TcpTcbExpireTimerTemplate(null);
                templates[67] = TcpTcbChangeIsbTemplate(null);
                templates[68] = TcpRssTableChangeTemplate(null);
                templates[69] = TcpDataTransferTimeoutTemplate(null);
                templates[70] = TcpDataTransferRttSampleTemplate(null);
                templates[71] = TcpDataTransferCumAckTemplate(null);
                templates[72] = TcpDataTransferDupAckTemplate(null);
                templates[73] = TcpDataTransferSendTemplate(null);
                templates[74] = TcpDataTransferReceiveTemplate(null);
                templates[75] = TcpDataTransferEcnTemplate(null);
                templates[76] = TcpDataTransferSpuriousTimeoutTemplate(null);
                templates[77] = TcpDataTransferRetransmitRoundTemplate(null);
                templates[78] = TcpLossRecoveryEntryTemplate(null);
                templates[79] = TcpLossRecoveryExitTemplate(null);
                templates[80] = TcpLossRecoverySackEntryTemplate(null);
                templates[81] = TcpLossRecoverySackExitTemplate(null);
                templates[82] = TcpSlowStartToCongestionAvoidanceTemplate(null);
                templates[83] = TcpBlackHoleDetectionEntryTemplate(null);
                templates[84] = TcpBlackHoleDetectionExitTemplate(null);
                templates[85] = TcpBlackHoleDetectionFailedTemplate(null);
                templates[86] = TcpSpuriousRtoDetectionBeginTemplate(null);
                templates[87] = TcpSpuriousRtoDetectionEndTemplate(null);
                templates[88] = TcpConnectTcbFailedActiveConnectTemplate(null);
                templates[89] = TcpReleaseIndicationTemplate(null);
                templates[90] = TcpAppSendBufferSizeTemplate(null);
                templates[91] = TcpAutoTuningBeginTemplate(null);
                templates[92] = TcpAutoTuningEndTemplate(null);
                templates[93] = TcpAutoTuningFailedRttEstimationTemplate(null);
                templates[94] = TcpAutoTuningFailedBandwidthEstimationTemplate(null);
                templates[95] = TcpAutoTuningFailedAllocationFailureTemplate(null);
                templates[96] = TcpAutoTuningChangeRcvBufferSizeTemplate(null);
                templates[97] = TcpRttResiliencyDetectionTemplate(null);
                templates[98] = TcpConnectionOffloadStateChangeTemplate(null);
                templates[99] = TcpSwsAvoidanceBeginTemplate(null);
                templates[100] = TcpSwsAvoidanceEndTemplate(null);
                templates[101] = TcpZeroWindowProbingBeginTemplate(null);
                templates[102] = TcpZeroWindowProbingEndTemplate(null);
                templates[103] = TcpSetTcpOptionTemplate(null);
                templates[104] = TcpSetTcpSoOptionTemplate(null);
                templates[105] = TcpMediaDisconnectTemplate(null);
                templates[106] = TcpModuleStartedTemplate(null);
                templates[107] = TcpModuleStoppedTemplate(null);
                templates[108] = TcpMemoryFailuresTemplate(null);
                templates[109] = TcpGlobalParametersTemplate(null);
                templates[110] = TcpLsoTemplate(null);
                templates[111] = TcpConnectionOffloadStatusTemplate(null);
                templates[112] = TcpConnectionOffloadPmaxTemplate(null);
                templates[113] = IpDadSuccessfulTemplate(null);
                templates[114] = IpDadFailedTemplate(null);
                templates[115] = IpDadStartedTemplate(null);
                templates[116] = TcpListenerActivationFailedAfTemplate(null);
                templates[117] = TcpListenerActivationFailedCompartmentTemplate(null);
                templates[118] = TcpListenerActivationFailedInspection1Template(null);
                templates[119] = TcpListenerActivationFailedInspection2Template(null);
                templates[120] = TcpListenerBindFailedResolutionTemplate(null);
                templates[121] = TcpListenerBindFailedPortTemplate(null);
                templates[122] = TcpListenerActivatedTemplate(null);
                templates[123] = TcpListenerUnboundTemplate(null);
                templates[124] = IpAddressAddedTemplate(null);
                templates[125] = IpAddressDeletedTemplate(null);
                templates[126] = FramingIfOperStatusTemplate(null);
                templates[127] = FramingNdisPauseTemplate(null);
                templates[128] = FramingNdisRestartTemplate(null);
                templates[129] = IpAddressStatePreferredTemplate(null);
                templates[130] = IpAddressStateNonPreferredTemplate(null);
                templates[131] = IpInterfacePropertyChangeTemplate(null);
                templates[132] = IpRouteCreatedTemplate(null);
                templates[133] = IpRouteDeletedTemplate(null);
                templates[134] = IpRoutePropertyChangeTemplate(null);
                templates[135] = IpNeighborUnreachableTemplate(null);
                templates[136] = IpNeighborReachableTemplate(null);
                templates[137] = TcpCtcpDataTransferTimeoutTemplate(null);
                templates[138] = TcpCtcpDataTransferCumAckTemplate(null);
                templates[139] = TcpCtcpDataTransferDupAckTemplate(null);
                templates[140] = TcpCtcpDataTransferSendTemplate(null);
                templates[141] = TcpCtcpDataTransferEcnTemplate(null);
                templates[142] = TcpCtcpDataTransferSpuriousTimeoutTemplate(null);
                templates[143] = TcpReceiveRequestTemplate(null);
                templates[144] = TcpDeliveryIndicatedTemplate(null);
                templates[145] = TcpDeliverySatisfiedTemplate(null);
                templates[146] = TcpSendPostedTemplate(null);
                templates[147] = TcpSendTransmittedTemplate(null);
                templates[148] = TcpSendAdvanceTemplate(null);
                templates[149] = TcpCTcpDelayWndwInactiveTemplate(null);
                templates[150] = TcpCTcpAssignedBlocksTemplate(null);
                templates[151] = TcpCTcpCongestionWndwTemplate(null);
                templates[152] = TcpCTcpGammaTemplate(null);
                templates[153] = TcpSrttMeasurementStartedTemplate(null);
                templates[154] = TcpSrttMeasurementCompleteTemplate(null);
                templates[155] = TcpSrttMeasurementCancelledTemplate(null);
                templates[156] = UdpEndpointSendMessagesTemplate(null);
                templates[157] = UdpEndpointReceiveMessagesTemplate(null);
                templates[158] = TcpDeliveryFlushTemplate(null);
                templates[159] = TcpTcbInjectRcvFailureTemplate(null);
                templates[160] = TcpDeliveryInjectingDataTemplate(null);
                templates[161] = TcpTcbInjectFinFailureTemplate(null);
                templates[162] = TcpDeliveryAcceptTemplate(null);
                templates[163] = TcpDeliveryFinTemplate(null);
                templates[164] = TcpDeliveryPushTemplate(null);
                templates[165] = TcpTcbInjectFinCompleteTemplate(null);
                templates[166] = TcpDeliveryCompletingTemplate(null);
                templates[167] = TcpInitiateSynRstValidationTemplate(null);
                templates[168] = TcpConnectTcbFailedRcvdRstTemplate(null);
                templates[169] = TcpConnectionTerminatedRcvdRstTemplate(null);
                templates[170] = TcpConnectionTerminatedRcvdSynTemplate(null);
                templates[171] = TcpConnectRestransmitTemplate(null);
                templates[172] = TcpDataTransferRestransmitTemplate(null);
                templates[173] = TcpConnectionKeepAliveTemplate(null);
                templates[174] = TcpDeliveryStateChangeTemplate(null);
                templates[175] = TcpDeliveryDataDroppedTemplate(null);
                templates[176] = TcpAcquirePortTemplate(null);
                templates[177] = TcpAcquireWeakRefPortTemplate(null);
                templates[178] = TcpReleasePortTemplate(null);
                templates[179] = TcpReplacePortTemplate(null);
                templates[180] = TcpAssignedWeakReferencePortTemplate(null);
                templates[181] = TcpBhDetectFullSizeAckTemplate(null);
                templates[182] = TcpFlushSackTemplate(null);
                templates[183] = TcpReassemblyEntryTemplate(null);
                templates[184] = TcpReassemblyExitTemplate(null);
                templates[185] = TcpDisconnectTcbZeroWindowTimeoutTemplate(null);
                templates[186] = TcpDisconnectTcbFinWait2TimeoutTemplate(null);
                templates[187] = IpInterfaceRundownTemplate(null);
                templates[188] = IpInterfaceSpeedChangeTemplate(null);
                templates[189] = TcpReassemblyFlushTemplate(null);
                templates[190] = TcpipReceiveSlowPathTemplate(null);
                templates[191] = TcpipSendSlowPathTemplate(null);
                templates[192] = TcpWsdInitializationErrorsTemplate(null);
                templates[193] = TcpWsdInitializationInformationTemplate(null);
                templates[194] = TcpWsdWsRestrictedProfileTemplate(null);
                templates[195] = TcpWsdWsRestrictedDestinationTemplate(null);
                templates[196] = TcpWsdCacheEntryStateChangeTemplate(null);
                templates[197] = TcpWsdProfileStateChangeTemplate(null);
                templates[198] = TcpWsdStateChangeTemplate(null);
                templates[199] = TcpipTransportPacketDropsTemplate(null);
                templates[200] = TcpipNetworkPacketDropsTemplate(null);
                templates[201] = TcpMppNppEvaluationTemplate(null);
                templates[202] = TcpMppStartEpisodeTemplate(null);
                templates[203] = TcpMppStopEpisodeTemplate(null);
                templates[204] = TcpMppStartEpochTemplate(null);
                templates[205] = TcpMppStopEpochTemplate(null);
                templates[206] = TcpCwndRestartTemplate(null);
                templates[207] = TcpInitialCwndAdjustedTemplate(null);
                templates[208] = TcpTemplateParametersTemplate(null);
                templates[209] = TcpTemplateChangedTemplate(null);
                templates[210] = TcpDataTransferEcnAlphaTemplate(null);
                templates[211] = TcpInterfaceRscStateChangeTemplate(null);
                templates[212] = TcpRscNblOobInfoTemplate(null);
                templates[213] = TcpLoopbackFastPathFailReasonTemplate(null);
                templates[214] = TcpCwndRestartTemplate(null);
                templates[215] = RssBindingChangeTemplate(null);
                templates[216] = RssPortChangeTemplate(null);
                templates[217] = RssPortReferenceTemplate(null);
                templates[218] = RssPortCapabilitiesTemplate(null);
                templates[219] = RssPortProcessorsTemplate(null);
                templates[220] = RssProcessorAssignmentTemplate(null);
                templates[221] = RssProcessorUnassignmentTemplate(null);
                templates[222] = RssIndirectionChangeTemplate(null);
                templates[223] = RssProcessorConsolidationTemplate(null);
                templates[224] = RssConfigurationChangeTemplate(null);
                templates[225] = RssFailureTemplate(null);
                templates[226] = RssBindingBindCompleteTemplate(null);
                templates[227] = RssPortBindCompleteTemplate(null);
                templates[228] = RssPortNotSupportedTemplate(null);
                templates[229] = RssInitializeIndirectionTableTemplate(null);
                templates[230] = RssBindingRundownTemplate(null);
                templates[231] = RssPortRundownTemplate(null);
                templates[232] = RssBindingCapabilityTemplate(null);
                templates[233] = Ndkpi_Create_CqTemplate(null);
                templates[234] = Ndkpi_Create_CompletionTemplate(null);
                templates[235] = Ndkpi_Close_ObjTemplate(null);
                templates[236] = Ndkpi_Close_CompletionTemplate(null);
                templates[237] = Ndkpi_Resize_CqTemplate(null);
                templates[238] = Ndkpi_Request_CompletionTemplate(null);
                templates[239] = Ndkpi_Arm_CqTemplate(null);
                templates[240] = Ndkpi_Cq_ResultTemplate(null);
                templates[241] = Ndkpi_Create_MrTemplate(null);
                templates[242] = Ndkpi_FlushTemplate(null);
                templates[243] = Ndkpi_SendTemplate(null);
                templates[244] = Ndkpi_ReceiveTemplate(null);
                templates[245] = Ndkpi_Register_MrTemplate(null);
                templates[246] = Ndkpi_Deregister_MrTemplate(null);
                templates[247] = Ndkpi_Initialize_Fast_Register_MrTemplate(null);
                templates[248] = Ndkpi_Modify_SrqTemplate(null);
                templates[249] = Ndkpi_ConnectTemplate(null);
                templates[250] = Ndkpi_Connect_Shared_EndpointTemplate(null);
                templates[251] = Ndkpi_Complete_ConnectTemplate(null);
                templates[252] = Ndkpi_AcceptTemplate(null);
                templates[253] = Ndkpi_DisconnectTemplate(null);
                templates[254] = Ndkpi_ListenTemplate(null);
                templates[255] = Ndkpi_Create_MwTemplate(null);
                templates[256] = Ndkpi_Create_SrqTemplate(null);
                templates[257] = Ndkpi_Create_QpTemplate(null);
                templates[258] = Ndkpi_Create_Qp_SrqTemplate(null);
                templates[259] = Ndkpi_Create_PdTemplate(null);
                templates[260] = Ndkpi_Create_Shared_EndpointTemplate(null);
                templates[261] = Ndkpi_Create_ConnectorTemplate(null);
                templates[262] = Ndkpi_Create_ListenerTemplate(null);
                templates[263] = Ndkpi_Build_LamTemplate(null);
                templates[264] = Ndkpi_Release_LamTemplate(null);
                templates[265] = Ndkpi_Cq_Notification_CallbackTemplate(null);
                templates[266] = Ndkpi_Srq_Notification_CallbackTemplate(null);
                templates[267] = Ndkpi_Disconnect_Event_CallbackTemplate(null);
                templates[268] = Ndkpi_Connect_Event_CallbackTemplate(null);
                templates[269] = Ndkpi_Get_TokenTemplate(null);
                templates[270] = Ndkpi_Get_SockaddrTemplate(null);
                templates[271] = Ndkpi_Get_Sockaddr_FailureTemplate(null);
                templates[272] = Ndkpi_RejectTemplate(null);
                templates[273] = Ndkpi_Get_Connect_DataTemplate(null);
                templates[274] = Ndkpi_Work_Request_Inline_FailureTemplate(null);
                templates[275] = Ndkpi_BindTemplate(null);
                templates[276] = Ndkpi_Fast_RegisterTemplate(null);
                templates[277] = Ndkpi_InvalidateTemplate(null);
                templates[278] = Ndkpi_ReadTemplate(null);
                templates[279] = Ndkpi_WriteTemplate(null);
                templates[280] = Ndkpi_SrqReceiveTemplate(null);
                templates[281] = Ndkpi_Srq_Work_Request_Inline_FailureTemplate(null);
                templates[282] = Ndkpi_Open_AdapterTemplate(null);
                templates[283] = Ndkpi_Close_Adapter_EnterTemplate(null);
                templates[284] = Ndkpi_Close_Adapter_ExitTemplate(null);
                templates[285] = TcpConnectionRundownTemplate(null);
                templates[286] = Ndkpi_Interface_EventTemplate(null);
                templates[287] = TcpipWakePacketIndicatedTemplate(null);
                templates[288] = TcpipWakePacketIndicatedTemplate(null);
                templates[289] = TcpipSilentModeTemplate(null);
                templates[290] = TcpCreateNotificationChannelRequestTemplate(null);
                templates[291] = TcpQueryNotificationChannelStatusRequestTemplate(null);
                templates[292] = TcpCreateNotificationChannelRequestProcessedTemplate(null);
                templates[293] = TcpSignalNotificationChannelEventTemplate(null);
                templates[294] = TcpDetachNotificationChannelTemplate(null);
                templates[295] = TcpUnlinkNotificationChannelTemplate(null);
                templates[296] = TcpPlumbWakePatternTemplate(null);
                templates[297] = TcpDeplumbWakePatternTemplate(null);
                templates[298] = TcpipPlumbWakePatternOnInterfaceTemplate(null);
                templates[299] = Ndkpi_Control_Cq_ImTemplate(null);
                templates[300] = TcpCreateNotificationChannelRequestProcessingTemplate(null);
                templates[301] = task_0Template(null);
                templates[302] = task_0Template(null);
                templates[303] = task_0Template(null);
                templates[304] = task_0Template(null);
                templates[305] = task_0Template(null);
                templates[306] = TcpipMediaConnectTemplate(null);
                templates[307] = TcpipLimitedLinkConnectivityTemplate(null);
                templates[308] = TcpipLimitedLinkConnectivityTemplate(null);
                templates[309] = IpNeighborStateTemplate(null);
                templates[310] = IpNeighborDiscoveryTemplate(null);
                templates[311] = IpSourceAddressSelectionTemplate(null);
                templates[312] = IpSortedAddressPairsTemplate(null);
                templates[313] = Ndkpi_Cq_Result_ExTemplate(null);
                templates[314] = Ndkpi_Send_InvalidateTemplate(null);
                templates[315] = TcpDataTransferCumAckTemplate(null);
                templates[316] = TcpCtcpDataTransferCumAckTemplate(null);
                templates[317] = TcpDataTransferSendTemplate(null);
                templates[318] = TcpCtcpDataTransferSendTemplate(null);
                templates[319] = UdpCreateNotificationChannelRequestTemplate(null);
                templates[320] = UdpQueryNotificationChannelStatusRequestTemplate(null);
                templates[321] = UdpCreateNotificationChannelRequestProcessedTemplate(null);
                templates[322] = UdpSignalNotificationChannelEventTemplate(null);
                templates[323] = UdpDetachNotificationChannelTemplate(null);
                templates[324] = UdpUnlinkNotificationChannelTemplate(null);
                templates[325] = UdpCreateNotificationChannelRequestProcessingTemplate(null);
                templates[326] = TcpDataTransferRttSampleTemplate(null);
                templates[327] = TcpRttResiliencyDetectionTemplate(null);
                templates[328] = TcpDataTransferDupAckTemplate(null);
                templates[329] = TcpCtcpDataTransferDupAckTemplate(null);
                templates[330] = TcpDataTransferSpuriousTimeoutTemplate(null);
                templates[331] = TcpSpuriousRtoDetectionBeginTemplate(null);
                templates[332] = TcpSpuriousRtoDetectionEndTemplate(null);
                templates[333] = TcpCtcpDataTransferTimeoutTemplate(null);
                templates[334] = TcpCtcpDataTransferSpuriousTimeoutTemplate(null);
                templates[335] = TcpSlowStartToCongestionAvoidanceTemplate(null);
                templates[336] = TcpDataTransferRetransmitRoundTemplate(null);
                templates[337] = TcpConnectionSummaryTemplate(null);
                templates[338] = TcpipGenericTemplate(null);
                templates[339] = TcpSackUpdateTemplate(null);
                templates[340] = TcpIsPatternCoalescingRequiredTemplate(null);
                templates[341] = TcpRtcPortRangeAssignmentTemplate(null);
                templates[342] = TcpipAoacFailFastTemplate(null);
                templates[343] = TcpipUpdateInterfaceConfigFlagsTemplate(null);
                s_templates = templates;
            }
            foreach (var template in s_templates)
                if (eventsToObserve == null || eventsToObserve(template.ProviderName, template.EventName) == EventFilterResponse.AcceptEvent)
                    callback(template);
        }

        #endregion
    }
}

namespace Microsoft.Diagnostics.Tracing.Parsers.MicrosoftWindowsTCPIP
{
    public sealed class FramingIfOperStatusArgs : TraceEvent
    {
        public int Interface { get { return GetInt32At(0); } }
        public int OperationalStatus { get { return GetInt32At(4); } }
        public long Status { get { return GetInt64At(8); } }

        #region Private
        internal FramingIfOperStatusArgs(Action<FramingIfOperStatusArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<FramingIfOperStatusArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "OperationalStatus", OperationalStatus);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Interface", "OperationalStatus", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Interface;
                case 1:
                    return OperationalStatus;
                case 2:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<FramingIfOperStatusArgs> m_target;
        #endregion
    }
    public sealed class TcpMediaDisconnectArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public string TraceString { get { return GetUTF8StringAt(4); } }

        #region Private
        internal TcpMediaDisconnectArgs(Action<TcpMediaDisconnectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUTF8String(4)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUTF8String(4)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpMediaDisconnectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "TraceString", TraceString);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "TraceString" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return TraceString;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpMediaDisconnectArgs> m_target;
        #endregion
    }
    public sealed class IpDadFailedArgs : TraceEvent
    {
        public int Interface { get { return GetInt32At(0); } }
        public string Protocol { get { return GetUTF8StringAt(4); } }
        public int DadState { get { return GetInt32At(SkipUTF8String(4)); } }
        public int DlAddrLength { get { return GetInt32At(SkipUTF8String(4) + 4); } }
        public byte[] DLAddress { get { return GetByteArrayAt(SkipUTF8String(4) + 8, DlAddrLength); } }
        public int IpAddrLength { get { return GetInt32At(SkipUTF8String(4) + 8); } }
        public int IPv4Address { get { return GetInt32At(SkipUTF8String(4) + 12); } }
        public byte[] IPv6Address { get { return GetByteArrayAt(SkipUTF8String(4) + 16, IpAddrLength); } }
        public int IPProtocol { get { return GetInt32At(SkipUTF8String(4) + 16); } }

        #region Private
        internal IpDadFailedArgs(Action<IpDadFailedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUTF8String(4) + 20));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUTF8String(4) + 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpDadFailedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "Protocol", Protocol);
            XmlAttrib(sb, "DadState", DadState);
            XmlAttrib(sb, "DlAddrLength", DlAddrLength);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "IPv4Address", IPv4Address);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Interface", "Protocol", "DadState", "DlAddrLength", "DLAddress", "IpAddrLength", "IPv4Address", "IPv6Address", "IPProtocol" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Interface;
                case 1:
                    return Protocol;
                case 2:
                    return DadState;
                case 3:
                    return DlAddrLength;
                case 4:
                    return IpAddrLength;
                case 5:
                    return IPv4Address;
                case 6:
                    return IPProtocol;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpDadFailedArgs> m_target;
        #endregion
    }
    public sealed class IpDadSuccessfulArgs : TraceEvent
    {
        public int Interface { get { return GetInt32At(0); } }
        public string Protocol { get { return GetUTF8StringAt(4); } }
        public TCPIP_IP_DAD_STATE DadState { get { return (TCPIP_IP_DAD_STATE)GetInt32At(SkipUTF8String(4)); } }
        public int DlAddrLength { get { return GetInt32At(SkipUTF8String(4) + 4); } }
        public byte[] DLAddress { get { return GetByteArrayAt(SkipUTF8String(4) + 8, DlAddrLength); } }
        public int IpAddrLength { get { return GetInt32At(SkipUTF8String(4) + 8); } }
        public int IPv4Address { get { return GetInt32At(SkipUTF8String(4) + 12); } }
        public byte[] IPv6Address { get { return GetByteArrayAt(SkipUTF8String(4) + 16, IpAddrLength); } }
        public TCPIP_Protocol IPProtocol { get { return (TCPIP_Protocol)GetInt32At(SkipUTF8String(4) + 16); } }

        #region Private
        internal IpDadSuccessfulArgs(Action<IpDadSuccessfulArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUTF8String(4) + 20));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUTF8String(4) + 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpDadSuccessfulArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "Protocol", Protocol);
            XmlAttrib(sb, "DadState", DadState);
            XmlAttrib(sb, "DlAddrLength", DlAddrLength);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "IPv4Address", IPv4Address);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Interface", "Protocol", "DadState", "DlAddrLength", "DLAddress", "IpAddrLength", "IPv4Address", "IPv6Address", "IPProtocol" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Interface;
                case 1:
                    return Protocol;
                case 2:
                    return DadState;
                case 3:
                    return DlAddrLength;
                case 4:
                    return IpAddrLength;
                case 5:
                    return IPv4Address;
                case 6:
                    return IPProtocol;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpDadSuccessfulArgs> m_target;
        #endregion
    }
    public sealed class IpInterfacePropertyChangeArgs : TraceEvent
    {
        public int Interface { get { return GetInt32At(0); } }
        public int Advertise { get { return GetInt32At(4); } }
        public int AdvertiseDefaultRoute { get { return GetInt32At(8); } }
        public int Forward { get { return GetInt32At(12); } }
        public int ForwardMulticast { get { return GetInt32At(16); } }
        public int UseNud { get { return GetInt32At(20); } }
        public int AdvertisingEnabled { get { return GetInt32At(24); } }

        #region Private
        internal IpInterfacePropertyChangeArgs(Action<IpInterfacePropertyChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 28));
            Debug.Assert(!(Version > 0 && EventDataLength < 28));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpInterfacePropertyChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "Advertise", Advertise);
            XmlAttrib(sb, "AdvertiseDefaultRoute", AdvertiseDefaultRoute);
            XmlAttrib(sb, "Forward", Forward);
            XmlAttrib(sb, "ForwardMulticast", ForwardMulticast);
            XmlAttrib(sb, "UseNud", UseNud);
            XmlAttrib(sb, "AdvertisingEnabled", AdvertisingEnabled);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Interface", "Advertise", "AdvertiseDefaultRoute", "Forward", "ForwardMulticast", "UseNud", "AdvertisingEnabled" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Interface;
                case 1:
                    return Advertise;
                case 2:
                    return AdvertiseDefaultRoute;
                case 3:
                    return Forward;
                case 4:
                    return ForwardMulticast;
                case 5:
                    return UseNud;
                case 6:
                    return AdvertisingEnabled;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpInterfacePropertyChangeArgs> m_target;
        #endregion
    }
    public sealed class IpInterfaceRundownArgs : TraceEvent
    {
        public int IfIndex { get { return GetInt32At(0); } }
        public long LinkSpeed { get { return GetInt64At(4); } }
        public int IPProtocol { get { return GetInt32At(12); } }
        public int IPv4Address { get { return GetInt32At(16); } }
        public int IpAddrLength { get { return GetInt32At(20); } }
        public byte[] IPv6Address { get { return GetByteArrayAt(24, IpAddrLength); } }
        public int PhysicalMediumType { get { return GetInt32At(0 + (IpAddrLength * 1) + 24); } }

        #region Private
        internal IpInterfaceRundownArgs(Action<IpInterfaceRundownArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (IpAddrLength * 1) + 28));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (IpAddrLength * 1) + 28));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpInterfaceRundownArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IfIndex", IfIndex);
            XmlAttrib(sb, "LinkSpeed", LinkSpeed);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            XmlAttrib(sb, "IPv4Address", IPv4Address);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "PhysicalMediumType", PhysicalMediumType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IfIndex", "LinkSpeed", "IPProtocol", "IPv4Address", "IpAddrLength", "IPv6Address", "PhysicalMediumType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IfIndex;
                case 1:
                    return LinkSpeed;
                case 2:
                    return IPProtocol;
                case 3:
                    return IPv4Address;
                case 4:
                    return IpAddrLength;
                case 5:
                    return PhysicalMediumType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpInterfaceRundownArgs> m_target;
        #endregion
    }
    public sealed class IpInterfaceSpeedChangeArgs : TraceEvent
    {
        public int IfIndex { get { return GetInt32At(0); } }
        public long LinkSpeed { get { return GetInt64At(4); } }
        public int IPProtocol { get { return GetInt32At(12); } }
        public int IPv4Address { get { return GetInt32At(16); } }
        public int IpAddrLength { get { return GetInt32At(20); } }
        public byte[] IPv6Address { get { return GetByteArrayAt(24, IpAddrLength); } }
        public TCPIP_IP_PHYSICALMEDIUM_TYPE PhysicalMediumType { get { return (TCPIP_IP_PHYSICALMEDIUM_TYPE)GetInt32At(0 + (IpAddrLength * 1) + 24); } }

        #region Private
        internal IpInterfaceSpeedChangeArgs(Action<IpInterfaceSpeedChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (IpAddrLength * 1) + 28));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (IpAddrLength * 1) + 28));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpInterfaceSpeedChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IfIndex", IfIndex);
            XmlAttrib(sb, "LinkSpeed", LinkSpeed);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            XmlAttrib(sb, "IPv4Address", IPv4Address);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "PhysicalMediumType", PhysicalMediumType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IfIndex", "LinkSpeed", "IPProtocol", "IPv4Address", "IpAddrLength", "IPv6Address", "PhysicalMediumType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IfIndex;
                case 1:
                    return LinkSpeed;
                case 2:
                    return IPProtocol;
                case 3:
                    return IPv4Address;
                case 4:
                    return IpAddrLength;
                case 5:
                    return PhysicalMediumType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpInterfaceSpeedChangeArgs> m_target;
        #endregion
    }
    public sealed class IpNeighborDiscoveryArgs : TraceEvent
    {
        public int Interface { get { return GetInt32At(0); } }
        public int IpAddrLength { get { return GetInt32At(4); } }
        public byte[] SourceIPAddress { get { return GetByteArrayAt(8, IpAddrLength); } }
        public byte[] TargetIPAddress { get { return GetByteArrayAt(0 + (IpAddrLength * 1) + 8, IpAddrLength); } }
        public TCPIP_NEIGHBOR_EVENT NeighborEvent { get { return (TCPIP_NEIGHBOR_EVENT)GetInt32At(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + 8); } }

        #region Private
        internal IpNeighborDiscoveryArgs(Action<IpNeighborDiscoveryArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (IpAddrLength * 1) + (IpAddrLength * 1) + 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (IpAddrLength * 1) + (IpAddrLength * 1) + 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpNeighborDiscoveryArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "NeighborEvent", NeighborEvent);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Interface", "IpAddrLength", "SourceIPAddress", "TargetIPAddress", "NeighborEvent" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Interface;
                case 1:
                    return IpAddrLength;
                case 2:
                    return NeighborEvent;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpNeighborDiscoveryArgs> m_target;
        #endregion
    }
    public sealed class IpNeighborUnreachableArgs : TraceEvent
    {
        public int Interface { get { return GetInt32At(0); } }
        public int DlAddrLength { get { return GetInt32At(4); } }
        public byte[] DlAddress { get { return GetByteArrayAt(8, DlAddrLength); } }
        public int IpAddrLength { get { return GetInt32At(0 + (DlAddrLength * 1) + 8); } }
        public int IPv4Address { get { return GetInt32At(0 + (DlAddrLength * 1) + 12); } }
        public byte[] IPv6Address { get { return GetByteArrayAt(0 + (DlAddrLength * 1) + 16, IpAddrLength); } }
        public int IPProtocol { get { return GetInt32At(0 + (IpAddrLength * 1) + (DlAddrLength * 1) + 16); } }

        #region Private
        internal IpNeighborUnreachableArgs(Action<IpNeighborUnreachableArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (IpAddrLength * 1) + (DlAddrLength * 1) + 20));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (IpAddrLength * 1) + (DlAddrLength * 1) + 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpNeighborUnreachableArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "DlAddrLength", DlAddrLength);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "IPv4Address", IPv4Address);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Interface", "DlAddrLength", "DlAddress", "IpAddrLength", "IPv4Address", "IPv6Address", "IPProtocol" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Interface;
                case 1:
                    return DlAddrLength;
                case 2:
                    return IpAddrLength;
                case 3:
                    return IPv4Address;
                case 4:
                    return IPProtocol;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpNeighborUnreachableArgs> m_target;
        #endregion
    }
    public sealed class IpNeighborStateArgs : TraceEvent
    {
        public int Interface { get { return GetInt32At(0); } }
        public int IpAddrLength { get { return GetInt32At(4); } }
        public byte[] IPAddress { get { return GetByteArrayAt(8, IpAddrLength); } }
        public int DlAddrLength { get { return GetInt32At(0 + (IpAddrLength * 1) + 8); } }
        public byte[] DLAddress { get { return GetByteArrayAt(0 + (IpAddrLength * 1) + 12, DlAddrLength); } }
        public int OldNeighborState { get { return GetInt32At(0 + (DlAddrLength * 1) + (IpAddrLength * 1) + 12); } }
        public TCPIP_NEIGHBOR_STATE NewNeighborState { get { return (TCPIP_NEIGHBOR_STATE)GetInt32At(0 + (DlAddrLength * 1) + (IpAddrLength * 1) + 16); } }
        public int NeighborEvent { get { return GetInt32At(0 + (DlAddrLength * 1) + (IpAddrLength * 1) + 20); } }

        #region Private
        internal IpNeighborStateArgs(Action<IpNeighborStateArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (DlAddrLength * 1) + (IpAddrLength * 1) + 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (DlAddrLength * 1) + (IpAddrLength * 1) + 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpNeighborStateArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "DlAddrLength", DlAddrLength);
            XmlAttrib(sb, "OldNeighborState", OldNeighborState);
            XmlAttrib(sb, "NewNeighborState", NewNeighborState);
            XmlAttrib(sb, "NeighborEvent", NeighborEvent);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Interface", "IpAddrLength", "IPAddress", "DlAddrLength", "DLAddress", "OldNeighborState", "NewNeighborState", "NeighborEvent" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Interface;
                case 1:
                    return IpAddrLength;
                case 2:
                    return DlAddrLength;
                case 3:
                    return OldNeighborState;
                case 4:
                    return NewNeighborState;
                case 5:
                    return NeighborEvent;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpNeighborStateArgs> m_target;
        #endregion
    }
    public sealed class IpRouteCreatedArgs : TraceEvent
    {
        public Address Route { get { return GetAddressAt(0); } }
        public int Interface { get { return GetInt32At(HostOffset(4, 1)); } }
        public int DestinationPrefixAddressLength { get { return GetInt32At(HostOffset(8, 1)); } }
        public int NextHopAddressLength { get { return GetInt32At(HostOffset(12, 1)); } }
        public string Protocol { get { return GetUTF8StringAt(HostOffset(16, 1)); } }
        public int DestinationPrefixLength { get { return GetInt32At(SkipUTF8String(HostOffset(16, 1))); } }
        public byte[] DestinationPrefix { get { return GetByteArrayAt(SkipUTF8String(HostOffset(16, 1)) + 4, DestinationPrefixAddressLength); } }
        public byte[] NextHopAddress { get { return GetByteArrayAt(SkipUTF8String(HostOffset(16, 1)) + 4, NextHopAddressLength); } }
        public long ValidLifetime { get { return GetInt64At(SkipUTF8String(HostOffset(16, 1)) + 4); } }
        public long PreferredLifetime { get { return GetInt64At(SkipUTF8String(HostOffset(16, 1)) + 12); } }
        public int Metric { get { return GetInt32At(SkipUTF8String(HostOffset(16, 1)) + 20); } }
        public int Loopback { get { return GetInt32At(SkipUTF8String(HostOffset(16, 1)) + 24); } }
        public int AutoconfigureAddress { get { return GetInt32At(SkipUTF8String(HostOffset(16, 1)) + 28); } }
        public int Publish { get { return GetInt32At(SkipUTF8String(HostOffset(16, 1)) + 32); } }
        public int Immortal { get { return GetInt32At(SkipUTF8String(HostOffset(16, 1)) + 36); } }
        public int IPv4DestinationPrefix { get { return GetInt32At(SkipUTF8String(HostOffset(16, 1)) + 40); } }
        public int IPv4NextHopAddress { get { return GetInt32At(SkipUTF8String(HostOffset(16, 1)) + 44); } }
        public int IPProtocol { get { return GetInt32At(SkipUTF8String(HostOffset(16, 1)) + 48); } }

        #region Private
        internal IpRouteCreatedArgs(Action<IpRouteCreatedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUTF8String(HostOffset(16, 1)) + 52));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUTF8String(HostOffset(16, 1)) + 52));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpRouteCreatedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Route", Route);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "DestinationPrefixAddressLength", DestinationPrefixAddressLength);
            XmlAttrib(sb, "NextHopAddressLength", NextHopAddressLength);
            XmlAttrib(sb, "Protocol", Protocol);
            XmlAttrib(sb, "DestinationPrefixLength", DestinationPrefixLength);
            XmlAttrib(sb, "ValidLifetime", ValidLifetime);
            XmlAttrib(sb, "PreferredLifetime", PreferredLifetime);
            XmlAttrib(sb, "Metric", Metric);
            XmlAttrib(sb, "Loopback", Loopback);
            XmlAttrib(sb, "AutoconfigureAddress", AutoconfigureAddress);
            XmlAttrib(sb, "Publish", Publish);
            XmlAttrib(sb, "Immortal", Immortal);
            XmlAttrib(sb, "IPv4DestinationPrefix", IPv4DestinationPrefix);
            XmlAttrib(sb, "IPv4NextHopAddress", IPv4NextHopAddress);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Route", "Interface", "DestinationPrefixAddressLength", "NextHopAddressLength", "Protocol", "DestinationPrefixLength", "DestinationPrefix", "NextHopAddress", "ValidLifetime", "PreferredLifetime", "Metric", "Loopback", "AutoconfigureAddress", "Publish", "Immortal", "IPv4DestinationPrefix", "IPv4NextHopAddress", "IPProtocol" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Route;
                case 1:
                    return Interface;
                case 2:
                    return DestinationPrefixAddressLength;
                case 3:
                    return NextHopAddressLength;
                case 4:
                    return Protocol;
                case 5:
                    return DestinationPrefixLength;
                case 6:
                    return ValidLifetime;
                case 7:
                    return PreferredLifetime;
                case 8:
                    return Metric;
                case 9:
                    return Loopback;
                case 10:
                    return AutoconfigureAddress;
                case 11:
                    return Publish;
                case 12:
                    return Immortal;
                case 13:
                    return IPv4DestinationPrefix;
                case 14:
                    return IPv4NextHopAddress;
                case 15:
                    return IPProtocol;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpRouteCreatedArgs> m_target;
        #endregion
    }
    public sealed class IpSortedAddressPairsArgs : TraceEvent
    {
        public int IpAddrLength { get { return GetInt32At(0); } }
        public byte[] PreferredSourceIPAddress { get { return GetByteArrayAt(4, IpAddrLength); } }
        public byte[] PreferredDestinationIPAddress { get { return GetByteArrayAt(0 + (IpAddrLength * 1) + 4, IpAddrLength); } }
        public byte[] NonPreferredSourceIPAddress { get { return GetByteArrayAt(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + 4, IpAddrLength); } }
        public byte[] NonPreferredDestinationIPAddress { get { return GetByteArrayAt(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 4, IpAddrLength); } }
        public int SortOption { get { return GetInt32At(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 4); } }
        public string RuleType { get { return GetUTF8StringAt(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 8); } }
        public int RuleMajor { get { return GetInt32At(SkipUTF8String(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 8)); } }
        public int RuleMinor { get { return GetInt32At(SkipUTF8String(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 8) + 4); } }

        #region Private
        internal IpSortedAddressPairsArgs(Action<IpSortedAddressPairsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUTF8String(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 8) + 8));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUTF8String(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 8) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpSortedAddressPairsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "SortOption", SortOption);
            XmlAttrib(sb, "RuleType", RuleType);
            XmlAttrib(sb, "RuleMajor", RuleMajor);
            XmlAttrib(sb, "RuleMinor", RuleMinor);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IpAddrLength", "PreferredSourceIPAddress", "PreferredDestinationIPAddress", "NonPreferredSourceIPAddress", "NonPreferredDestinationIPAddress", "SortOption", "RuleType", "RuleMajor", "RuleMinor" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IpAddrLength;
                case 1:
                    return SortOption;
                case 2:
                    return RuleType;
                case 3:
                    return RuleMajor;
                case 4:
                    return RuleMinor;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpSortedAddressPairsArgs> m_target;
        #endregion
    }
    public sealed class IpSourceAddressSelectionArgs : TraceEvent
    {
        public int IpAddrLength { get { return GetInt32At(0); } }
        public byte[] PreferredSourceIPAddress { get { return GetByteArrayAt(4, IpAddrLength); } }
        public byte[] NonPreferredSourceIPAddress { get { return GetByteArrayAt(0 + (IpAddrLength * 1) + 4, IpAddrLength); } }
        public byte[] DestinationIPAddress { get { return GetByteArrayAt(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + 4, IpAddrLength); } }
        public int Rule { get { return GetInt32At(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 4); } }
        public int RuleExtension { get { return GetInt32At(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 8); } }

        #region Private
        internal IpSourceAddressSelectionArgs(Action<IpSourceAddressSelectionArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (IpAddrLength * 1) + (IpAddrLength * 1) + (IpAddrLength * 1) + 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<IpSourceAddressSelectionArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "Rule", Rule);
            XmlAttrib(sb, "RuleExtension", RuleExtension);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IpAddrLength", "PreferredSourceIPAddress", "NonPreferredSourceIPAddress", "DestinationIPAddress", "Rule", "RuleExtension" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IpAddrLength;
                case 1:
                    return Rule;
                case 2:
                    return RuleExtension;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<IpSourceAddressSelectionArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_AcceptArgs : TraceEvent
    {
        public Address NdkConnector { get { return GetAddressAt(0); } }
        public Address NdkQp { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int IRD { get { return GetInt32At(HostOffset(8, 2)); } }
        public int ORD { get { return GetInt32At(HostOffset(12, 2)); } }
        public Address DisconnectEventContext { get { return GetAddressAt(HostOffset(16, 2)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(20, 3)); } }
        public int PrivateDataLength { get { return GetInt32At(HostOffset(24, 4)); } }

        #region Private
        internal Ndkpi_AcceptArgs(Action<Ndkpi_AcceptArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 4)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 4)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_AcceptArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkConnector", NdkConnector);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            XmlAttrib(sb, "IRD", IRD);
            XmlAttrib(sb, "ORD", ORD);
            XmlAttribHex(sb, "DisconnectEventContext", DisconnectEventContext);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttrib(sb, "PrivateDataLength", PrivateDataLength);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkConnector", "NdkQp", "IRD", "ORD", "DisconnectEventContext", "RequestContext", "PrivateDataLength" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkConnector;
                case 1:
                    return NdkQp;
                case 2:
                    return IRD;
                case 3:
                    return ORD;
                case 4:
                    return DisconnectEventContext;
                case 5:
                    return RequestContext;
                case 6:
                    return PrivateDataLength;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_AcceptArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Arm_CqArgs : TraceEvent
    {
        public Address NdkCq { get { return GetAddressAt(0); } }
        public TCPIP_NDKPI_CQ_ARM_TYPE ArmType { get { return (TCPIP_NDKPI_CQ_ARM_TYPE)GetInt32At(HostOffset(4, 1)); } }

        #region Private
        internal Ndkpi_Arm_CqArgs(Action<Ndkpi_Arm_CqArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Arm_CqArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkCq", NdkCq);
            XmlAttrib(sb, "ArmType", ArmType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkCq", "ArmType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkCq;
                case 1:
                    return ArmType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Arm_CqArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_BindArgs : TraceEvent
    {
        public Address NdkQp { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address NdkMr { get { return GetAddressAt(HostOffset(8, 2)); } }
        public Address NdkMw { get { return GetAddressAt(HostOffset(12, 3)); } }
        public Address VirtualAddress { get { return GetAddressAt(HostOffset(16, 4)); } }
        public long Length { get { return GetInt64At(HostOffset(20, 5)); } }
        public int Flags { get { return GetInt32At(HostOffset(28, 5)); } }

        #region Private
        internal Ndkpi_BindArgs(Action<Ndkpi_BindArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(32, 5)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(32, 5)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_BindArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "NdkMr", NdkMr);
            XmlAttribHex(sb, "NdkMw", NdkMw);
            XmlAttribHex(sb, "VirtualAddress", VirtualAddress);
            XmlAttrib(sb, "Length", Length);
            XmlAttrib(sb, "Flags", Flags);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkQp", "RequestContext", "NdkMr", "NdkMw", "VirtualAddress", "Length", "Flags" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkQp;
                case 1:
                    return RequestContext;
                case 2:
                    return NdkMr;
                case 3:
                    return NdkMw;
                case 4:
                    return VirtualAddress;
                case 5:
                    return Length;
                case 6:
                    return Flags;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_BindArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Build_LamArgs : TraceEvent
    {
        public Address NdkAdapter { get { return GetAddressAt(0); } }
        public Address Mdl { get { return GetAddressAt(HostOffset(4, 1)); } }
        public long Length { get { return GetInt64At(HostOffset(8, 2)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(16, 2)); } }
        public Address LAMBuffer { get { return GetAddressAt(HostOffset(20, 3)); } }
        public int LAMBufferSize { get { return GetInt32At(HostOffset(24, 4)); } }

        #region Private
        internal Ndkpi_Build_LamArgs(Action<Ndkpi_Build_LamArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 4)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 4)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Build_LamArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkAdapter", NdkAdapter);
            XmlAttribHex(sb, "Mdl", Mdl);
            XmlAttrib(sb, "Length", Length);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "LAMBuffer", LAMBuffer);
            XmlAttrib(sb, "LAMBufferSize", LAMBufferSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkAdapter", "Mdl", "Length", "RequestContext", "LAMBuffer", "LAMBufferSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkAdapter;
                case 1:
                    return Mdl;
                case 2:
                    return Length;
                case 3:
                    return RequestContext;
                case 4:
                    return LAMBuffer;
                case 5:
                    return LAMBufferSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Build_LamArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Close_Adapter_EnterArgs : TraceEvent
    {
        public Address NdkAdapter { get { return GetAddressAt(0); } }

        #region Private
        internal Ndkpi_Close_Adapter_EnterArgs(Action<Ndkpi_Close_Adapter_EnterArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(4, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(4, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Close_Adapter_EnterArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkAdapter", NdkAdapter);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkAdapter" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkAdapter;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Close_Adapter_EnterArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Close_CompletionArgs : TraceEvent
    {
        public Address RequestContext { get { return GetAddressAt(0); } }
        public int CompletionType { get { return GetInt32At(HostOffset(4, 1)); } }

        #region Private
        internal Ndkpi_Close_CompletionArgs(Action<Ndkpi_Close_CompletionArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Close_CompletionArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttrib(sb, "CompletionType", CompletionType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "RequestContext", "CompletionType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return RequestContext;
                case 1:
                    return CompletionType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Close_CompletionArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Close_ObjArgs : TraceEvent
    {
        public Address NdkObject { get { return GetAddressAt(0); } }
        public TCPIP_NDKPI_OBJECT_TYPE NdkObjectType { get { return (TCPIP_NDKPI_OBJECT_TYPE)GetInt32At(HostOffset(4, 1)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(8, 1)); } }

        #region Private
        internal Ndkpi_Close_ObjArgs(Action<Ndkpi_Close_ObjArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Close_ObjArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkObject", NdkObject);
            XmlAttrib(sb, "NdkObjectType", NdkObjectType);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkObject", "NdkObjectType", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkObject;
                case 1:
                    return NdkObjectType;
                case 2:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Close_ObjArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Complete_ConnectArgs : TraceEvent
    {
        public Address NdkConnector { get { return GetAddressAt(0); } }
        public Address DisconnectEventContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(8, 2)); } }

        #region Private
        internal Ndkpi_Complete_ConnectArgs(Action<Ndkpi_Complete_ConnectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Complete_ConnectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkConnector", NdkConnector);
            XmlAttribHex(sb, "DisconnectEventContext", DisconnectEventContext);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkConnector", "DisconnectEventContext", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkConnector;
                case 1:
                    return DisconnectEventContext;
                case 2:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Complete_ConnectArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_ConnectArgs : TraceEvent
    {
        public Address NdkConnector { get { return GetAddressAt(0); } }
        public Address NdkQp { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int SrcSockAddrLength { get { return GetInt32At(HostOffset(8, 2)); } }
        public byte[] SrcSockAddr { get { return GetByteArrayAt(HostOffset(12, 2), SrcSockAddrLength); } }
        public int DestSockAddrLength { get { return GetInt32At(HostOffset(0 + (SrcSockAddrLength * 1) + 12, 2)); } }
        public byte[] DestSockAddr { get { return GetByteArrayAt(HostOffset(0 + (SrcSockAddrLength * 1) + 16, 2), DestSockAddrLength); } }
        public int IRD { get { return GetInt32At(HostOffset(0 + (DestSockAddrLength * 1) + (SrcSockAddrLength * 1) + 16, 2)); } }
        public int ORD { get { return GetInt32At(HostOffset(0 + (DestSockAddrLength * 1) + (SrcSockAddrLength * 1) + 20, 2)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(0 + (DestSockAddrLength * 1) + (SrcSockAddrLength * 1) + 24, 2)); } }
        public Address NdkSharedEndpoint { get { return GetAddressAt(HostOffset(0 + (DestSockAddrLength * 1) + (SrcSockAddrLength * 1) + 28, 3)); } }
        public int PrivateDataLength { get { return GetInt32At(HostOffset(0 + (DestSockAddrLength * 1) + (SrcSockAddrLength * 1) + 32, 4)); } }

        #region Private
        internal Ndkpi_ConnectArgs(Action<Ndkpi_ConnectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (DestSockAddrLength * 1) + (SrcSockAddrLength * 1) + 36, 4)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (DestSockAddrLength * 1) + (SrcSockAddrLength * 1) + 36, 4)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_ConnectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkConnector", NdkConnector);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            XmlAttrib(sb, "SrcSockAddrLength", SrcSockAddrLength);
            XmlAttrib(sb, "DestSockAddrLength", DestSockAddrLength);
            XmlAttrib(sb, "IRD", IRD);
            XmlAttrib(sb, "ORD", ORD);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "NdkSharedEndpoint", NdkSharedEndpoint);
            XmlAttrib(sb, "PrivateDataLength", PrivateDataLength);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkConnector", "NdkQp", "SrcSockAddrLength", "SrcSockAddr", "DestSockAddrLength", "DestSockAddr", "IRD", "ORD", "RequestContext", "NdkSharedEndpoint", "PrivateDataLength" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkConnector;
                case 1:
                    return NdkQp;
                case 2:
                    return SrcSockAddrLength;
                case 3:
                    return DestSockAddrLength;
                case 4:
                    return IRD;
                case 5:
                    return ORD;
                case 6:
                    return RequestContext;
                case 7:
                    return NdkSharedEndpoint;
                case 8:
                    return PrivateDataLength;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_ConnectArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Connect_Event_CallbackArgs : TraceEvent
    {
        public Address ConnectEventContext { get { return GetAddressAt(0); } }
        public Address NdkConnector { get { return GetAddressAt(HostOffset(4, 1)); } }

        #region Private
        internal Ndkpi_Connect_Event_CallbackArgs(Action<Ndkpi_Connect_Event_CallbackArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Connect_Event_CallbackArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "ConnectEventContext", ConnectEventContext);
            XmlAttribHex(sb, "NdkConnector", NdkConnector);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ConnectEventContext", "NdkConnector" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ConnectEventContext;
                case 1:
                    return NdkConnector;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Connect_Event_CallbackArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Control_Cq_ImArgs : TraceEvent
    {
        public Address NdkCq { get { return GetAddressAt(0); } }
        public int ModerationInterval { get { return GetInt32At(HostOffset(4, 1)); } }
        public int ModerationCount { get { return GetInt32At(HostOffset(8, 1)); } }
        public int Status { get { return GetInt32At(HostOffset(12, 1)); } }

        #region Private
        internal Ndkpi_Control_Cq_ImArgs(Action<Ndkpi_Control_Cq_ImArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Control_Cq_ImArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkCq", NdkCq);
            XmlAttrib(sb, "ModerationInterval", ModerationInterval);
            XmlAttrib(sb, "ModerationCount", ModerationCount);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkCq", "ModerationInterval", "ModerationCount", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkCq;
                case 1:
                    return ModerationInterval;
                case 2:
                    return ModerationCount;
                case 3:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Control_Cq_ImArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Cq_Notification_CallbackArgs : TraceEvent
    {
        public Address CqNotificationContext { get { return GetAddressAt(0); } }
        public int CqStatus { get { return GetInt32At(HostOffset(4, 1)); } }

        #region Private
        internal Ndkpi_Cq_Notification_CallbackArgs(Action<Ndkpi_Cq_Notification_CallbackArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Cq_Notification_CallbackArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "CqNotificationContext", CqNotificationContext);
            XmlAttrib(sb, "CqStatus", CqStatus);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "CqNotificationContext", "CqStatus" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return CqNotificationContext;
                case 1:
                    return CqStatus;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Cq_Notification_CallbackArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Cq_ResultArgs : TraceEvent
    {
        public Address NdkCq { get { return GetAddressAt(0); } }
        public int Status { get { return GetInt32At(HostOffset(4, 1)); } }
        public int BytesTransferred { get { return GetInt32At(HostOffset(8, 1)); } }
        public Address QpContext { get { return GetAddressAt(HostOffset(12, 1)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(16, 2)); } }
        public int ResultIndex { get { return GetInt32At(HostOffset(20, 3)); } }
        public int ResultCount { get { return GetInt32At(HostOffset(24, 3)); } }

        #region Private
        internal Ndkpi_Cq_ResultArgs(Action<Ndkpi_Cq_ResultArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Cq_ResultArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkCq", NdkCq);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "BytesTransferred", BytesTransferred);
            XmlAttribHex(sb, "QpContext", QpContext);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttrib(sb, "ResultIndex", ResultIndex);
            XmlAttrib(sb, "ResultCount", ResultCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkCq", "Status", "BytesTransferred", "QpContext", "RequestContext", "ResultIndex", "ResultCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkCq;
                case 1:
                    return Status;
                case 2:
                    return BytesTransferred;
                case 3:
                    return QpContext;
                case 4:
                    return RequestContext;
                case 5:
                    return ResultIndex;
                case 6:
                    return ResultCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Cq_ResultArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Cq_Result_ExArgs : TraceEvent
    {
        public Address NdkCq { get { return GetAddressAt(0); } }
        public int Status { get { return GetInt32At(HostOffset(4, 1)); } }
        public int BytesTransferred { get { return GetInt32At(HostOffset(8, 1)); } }
        public Address QpContext { get { return GetAddressAt(HostOffset(12, 1)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(16, 2)); } }
        public int ResultIndex { get { return GetInt32At(HostOffset(20, 3)); } }
        public int ResultCount { get { return GetInt32At(HostOffset(24, 3)); } }
        public TCPIP_NDKPI_OPERATION_TYPE Type { get { return (TCPIP_NDKPI_OPERATION_TYPE)GetInt32At(HostOffset(28, 3)); } }
        public long TypeSpecificCompletionOutput { get { return GetInt64At(HostOffset(32, 3)); } }

        #region Private
        internal Ndkpi_Cq_Result_ExArgs(Action<Ndkpi_Cq_Result_ExArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(40, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(40, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Cq_Result_ExArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkCq", NdkCq);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "BytesTransferred", BytesTransferred);
            XmlAttribHex(sb, "QpContext", QpContext);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttrib(sb, "ResultIndex", ResultIndex);
            XmlAttrib(sb, "ResultCount", ResultCount);
            XmlAttrib(sb, "Type", Type);
            XmlAttrib(sb, "TypeSpecificCompletionOutput", TypeSpecificCompletionOutput);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkCq", "Status", "BytesTransferred", "QpContext", "RequestContext", "ResultIndex", "ResultCount", "Type", "TypeSpecificCompletionOutput" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkCq;
                case 1:
                    return Status;
                case 2:
                    return BytesTransferred;
                case 3:
                    return QpContext;
                case 4:
                    return RequestContext;
                case 5:
                    return ResultIndex;
                case 6:
                    return ResultCount;
                case 7:
                    return Type;
                case 8:
                    return TypeSpecificCompletionOutput;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Cq_Result_ExArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Create_CompletionArgs : TraceEvent
    {
        public Address RequestContext { get { return GetAddressAt(0); } }
        public int Status { get { return GetInt32At(HostOffset(4, 1)); } }
        public Address NdkObject { get { return GetAddressAt(HostOffset(8, 1)); } }
        public TCPIP_NDKPI_COMPLETION_TYPE CompletionType { get { return (TCPIP_NDKPI_COMPLETION_TYPE)GetInt32At(HostOffset(12, 2)); } }
        public int NdkObjectType { get { return GetInt32At(HostOffset(16, 2)); } }

        #region Private
        internal Ndkpi_Create_CompletionArgs(Action<Ndkpi_Create_CompletionArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(20, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(20, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Create_CompletionArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttrib(sb, "Status", Status);
            XmlAttribHex(sb, "NdkObject", NdkObject);
            XmlAttrib(sb, "CompletionType", CompletionType);
            XmlAttrib(sb, "NdkObjectType", NdkObjectType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "RequestContext", "Status", "NdkObject", "CompletionType", "NdkObjectType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return RequestContext;
                case 1:
                    return Status;
                case 2:
                    return NdkObject;
                case 3:
                    return CompletionType;
                case 4:
                    return NdkObjectType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Create_CompletionArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Deregister_MrArgs : TraceEvent
    {
        public Address NdkObject { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }

        #region Private
        internal Ndkpi_Deregister_MrArgs(Action<Ndkpi_Deregister_MrArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Deregister_MrArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkObject", NdkObject);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkObject", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkObject;
                case 1:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Deregister_MrArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Create_CqArgs : TraceEvent
    {
        public Address NdkAdapter { get { return GetAddressAt(0); } }
        public int CqDepth { get { return GetInt32At(HostOffset(4, 1)); } }
        public Address CqNotificationContext { get { return GetAddressAt(HostOffset(8, 1)); } }
        public long AffinityMask { get { return GetInt64At(HostOffset(12, 2)); } }
        public int AffinityGroup { get { return GetInt16At(HostOffset(20, 2)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(22, 2)); } }

        #region Private
        internal Ndkpi_Create_CqArgs(Action<Ndkpi_Create_CqArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(26, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(26, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Create_CqArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkAdapter", NdkAdapter);
            XmlAttrib(sb, "CqDepth", CqDepth);
            XmlAttribHex(sb, "CqNotificationContext", CqNotificationContext);
            XmlAttrib(sb, "AffinityMask", AffinityMask);
            XmlAttrib(sb, "AffinityGroup", AffinityGroup);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkAdapter", "CqDepth", "CqNotificationContext", "AffinityMask", "AffinityGroup", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkAdapter;
                case 1:
                    return CqDepth;
                case 2:
                    return CqNotificationContext;
                case 3:
                    return AffinityMask;
                case 4:
                    return AffinityGroup;
                case 5:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Create_CqArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Create_ListenerArgs : TraceEvent
    {
        public Address NdkAdapter { get { return GetAddressAt(0); } }
        public Address ConnectEventContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(8, 2)); } }

        #region Private
        internal Ndkpi_Create_ListenerArgs(Action<Ndkpi_Create_ListenerArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Create_ListenerArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkAdapter", NdkAdapter);
            XmlAttribHex(sb, "ConnectEventContext", ConnectEventContext);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkAdapter", "ConnectEventContext", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkAdapter;
                case 1:
                    return ConnectEventContext;
                case 2:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Create_ListenerArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Create_MrArgs : TraceEvent
    {
        public Address NdkPd { get { return GetAddressAt(0); } }
        public int FastRegister { get { return GetInt32At(HostOffset(4, 1)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(8, 1)); } }

        #region Private
        internal Ndkpi_Create_MrArgs(Action<Ndkpi_Create_MrArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Create_MrArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkPd", NdkPd);
            XmlAttrib(sb, "FastRegister", FastRegister);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkPd", "FastRegister", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkPd;
                case 1:
                    return FastRegister;
                case 2:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Create_MrArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Create_QpArgs : TraceEvent
    {
        public Address NdkPd { get { return GetAddressAt(0); } }
        public Address ReceiveCq { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address InitiatorCq { get { return GetAddressAt(HostOffset(8, 2)); } }
        public Address QPContext { get { return GetAddressAt(HostOffset(12, 3)); } }
        public int ReceiveQueueDepth { get { return GetInt32At(HostOffset(16, 4)); } }
        public int InitiatorQueueDepth { get { return GetInt32At(HostOffset(20, 4)); } }
        public int MaxReceiveRequestSge { get { return GetInt32At(HostOffset(24, 4)); } }
        public int MaxInitiatorRequestSge { get { return GetInt32At(HostOffset(28, 4)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(32, 4)); } }
        public Address NdkSrq { get { return GetAddressAt(HostOffset(36, 5)); } }

        #region Private
        internal Ndkpi_Create_QpArgs(Action<Ndkpi_Create_QpArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(40, 6)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(40, 6)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Create_QpArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkPd", NdkPd);
            XmlAttribHex(sb, "ReceiveCq", ReceiveCq);
            XmlAttribHex(sb, "InitiatorCq", InitiatorCq);
            XmlAttribHex(sb, "QPContext", QPContext);
            XmlAttrib(sb, "ReceiveQueueDepth", ReceiveQueueDepth);
            XmlAttrib(sb, "InitiatorQueueDepth", InitiatorQueueDepth);
            XmlAttrib(sb, "MaxReceiveRequestSge", MaxReceiveRequestSge);
            XmlAttrib(sb, "MaxInitiatorRequestSge", MaxInitiatorRequestSge);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "NdkSrq", NdkSrq);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkPd", "ReceiveCq", "InitiatorCq", "QPContext", "ReceiveQueueDepth", "InitiatorQueueDepth", "MaxReceiveRequestSge", "MaxInitiatorRequestSge", "RequestContext", "NdkSrq" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkPd;
                case 1:
                    return ReceiveCq;
                case 2:
                    return InitiatorCq;
                case 3:
                    return QPContext;
                case 4:
                    return ReceiveQueueDepth;
                case 5:
                    return InitiatorQueueDepth;
                case 6:
                    return MaxReceiveRequestSge;
                case 7:
                    return MaxInitiatorRequestSge;
                case 8:
                    return RequestContext;
                case 9:
                    return NdkSrq;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Create_QpArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_ListenArgs : TraceEvent
    {
        public Address NdkListener { get { return GetAddressAt(0); } }
        public int SockAddrLength { get { return GetInt32At(HostOffset(4, 1)); } }
        public byte[] SockAddr { get { return GetByteArrayAt(HostOffset(8, 1), SockAddrLength); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(0 + (SockAddrLength * 1) + 8, 1)); } }

        #region Private
        internal Ndkpi_ListenArgs(Action<Ndkpi_ListenArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (SockAddrLength * 1) + 12, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (SockAddrLength * 1) + 12, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_ListenArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkListener", NdkListener);
            XmlAttrib(sb, "SockAddrLength", SockAddrLength);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkListener", "SockAddrLength", "SockAddr", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkListener;
                case 1:
                    return SockAddrLength;
                case 2:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_ListenArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Create_SrqArgs : TraceEvent
    {
        public Address NdkPd { get { return GetAddressAt(0); } }
        public int SrqDepth { get { return GetInt32At(HostOffset(4, 1)); } }
        public int MaxReceiveRequestSge { get { return GetInt32At(HostOffset(8, 1)); } }
        public int NotifyThreshold { get { return GetInt32At(HostOffset(12, 1)); } }
        public Address SrqNotificationContext { get { return GetAddressAt(HostOffset(16, 1)); } }
        public long AffinityMask { get { return GetInt64At(HostOffset(20, 2)); } }
        public int AffinityGroup { get { return GetInt16At(HostOffset(28, 2)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(30, 2)); } }

        #region Private
        internal Ndkpi_Create_SrqArgs(Action<Ndkpi_Create_SrqArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(34, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(34, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Create_SrqArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkPd", NdkPd);
            XmlAttrib(sb, "SrqDepth", SrqDepth);
            XmlAttrib(sb, "MaxReceiveRequestSge", MaxReceiveRequestSge);
            XmlAttrib(sb, "NotifyThreshold", NotifyThreshold);
            XmlAttribHex(sb, "SrqNotificationContext", SrqNotificationContext);
            XmlAttrib(sb, "AffinityMask", AffinityMask);
            XmlAttrib(sb, "AffinityGroup", AffinityGroup);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkPd", "SrqDepth", "MaxReceiveRequestSge", "NotifyThreshold", "SrqNotificationContext", "AffinityMask", "AffinityGroup", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkPd;
                case 1:
                    return SrqDepth;
                case 2:
                    return MaxReceiveRequestSge;
                case 3:
                    return NotifyThreshold;
                case 4:
                    return SrqNotificationContext;
                case 5:
                    return AffinityMask;
                case 6:
                    return AffinityGroup;
                case 7:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Create_SrqArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Disconnect_Event_CallbackArgs : TraceEvent
    {
        public Address DisconnectEventContext { get { return GetAddressAt(0); } }

        #region Private
        internal Ndkpi_Disconnect_Event_CallbackArgs(Action<Ndkpi_Disconnect_Event_CallbackArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(4, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(4, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Disconnect_Event_CallbackArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "DisconnectEventContext", DisconnectEventContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "DisconnectEventContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return DisconnectEventContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Disconnect_Event_CallbackArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Fast_RegisterArgs : TraceEvent
    {
        public Address NdkQp { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address NdkMr { get { return GetAddressAt(HostOffset(8, 2)); } }
        public int AdapterPageCount { get { return GetInt32At(HostOffset(12, 3)); } }
        public Address AdapterPageArray { get { return GetAddressAt(HostOffset(16, 3)); } }
        public int FBO { get { return GetInt32At(HostOffset(20, 4)); } }
        public long Length { get { return GetInt64At(HostOffset(24, 4)); } }
        public Address BaseVirtualAddress { get { return GetAddressAt(HostOffset(32, 4)); } }
        public int Flags { get { return GetInt32At(HostOffset(36, 5)); } }

        #region Private
        internal Ndkpi_Fast_RegisterArgs(Action<Ndkpi_Fast_RegisterArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(40, 5)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(40, 5)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Fast_RegisterArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "NdkMr", NdkMr);
            XmlAttrib(sb, "AdapterPageCount", AdapterPageCount);
            XmlAttribHex(sb, "AdapterPageArray", AdapterPageArray);
            XmlAttrib(sb, "FBO", FBO);
            XmlAttrib(sb, "Length", Length);
            XmlAttribHex(sb, "BaseVirtualAddress", BaseVirtualAddress);
            XmlAttrib(sb, "Flags", Flags);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkQp", "RequestContext", "NdkMr", "AdapterPageCount", "AdapterPageArray", "FBO", "Length", "BaseVirtualAddress", "Flags" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkQp;
                case 1:
                    return RequestContext;
                case 2:
                    return NdkMr;
                case 3:
                    return AdapterPageCount;
                case 4:
                    return AdapterPageArray;
                case 5:
                    return FBO;
                case 6:
                    return Length;
                case 7:
                    return BaseVirtualAddress;
                case 8:
                    return Flags;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Fast_RegisterArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_FlushArgs : TraceEvent
    {
        public Address NdkQp { get { return GetAddressAt(0); } }

        #region Private
        internal Ndkpi_FlushArgs(Action<Ndkpi_FlushArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(4, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(4, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_FlushArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkQp" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkQp;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_FlushArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Get_Connect_DataArgs : TraceEvent
    {
        public Address NdkConnector { get { return GetAddressAt(0); } }
        public int IRD { get { return GetInt32At(HostOffset(4, 1)); } }
        public int ORD { get { return GetInt32At(HostOffset(8, 1)); } }
        public int PrivateDataLength { get { return GetInt32At(HostOffset(12, 1)); } }
        public int Status { get { return GetInt32At(HostOffset(16, 1)); } }

        #region Private
        internal Ndkpi_Get_Connect_DataArgs(Action<Ndkpi_Get_Connect_DataArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(20, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Get_Connect_DataArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkConnector", NdkConnector);
            XmlAttrib(sb, "IRD", IRD);
            XmlAttrib(sb, "ORD", ORD);
            XmlAttrib(sb, "PrivateDataLength", PrivateDataLength);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkConnector", "IRD", "ORD", "PrivateDataLength", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkConnector;
                case 1:
                    return IRD;
                case 2:
                    return ORD;
                case 3:
                    return PrivateDataLength;
                case 4:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Get_Connect_DataArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Get_SockaddrArgs : TraceEvent
    {
        public Address NdkObject { get { return GetAddressAt(0); } }
        public int NdkObjectType { get { return GetInt32At(HostOffset(4, 1)); } }
        public TCPIP_NDKPI_SOCKADDR_TYPE SockAddrType { get { return (TCPIP_NDKPI_SOCKADDR_TYPE)GetInt32At(HostOffset(8, 1)); } }
        public int SockAddrLength { get { return GetInt32At(HostOffset(12, 1)); } }
        public byte[] SockAddr { get { return GetByteArrayAt(HostOffset(16, 1), SockAddrLength); } }

        #region Private
        internal Ndkpi_Get_SockaddrArgs(Action<Ndkpi_Get_SockaddrArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (SockAddrLength * 1) + 16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (SockAddrLength * 1) + 16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Get_SockaddrArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkObject", NdkObject);
            XmlAttrib(sb, "NdkObjectType", NdkObjectType);
            XmlAttrib(sb, "SockAddrType", SockAddrType);
            XmlAttrib(sb, "SockAddrLength", SockAddrLength);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkObject", "NdkObjectType", "SockAddrType", "SockAddrLength", "SockAddr" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkObject;
                case 1:
                    return NdkObjectType;
                case 2:
                    return SockAddrType;
                case 3:
                    return SockAddrLength;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Get_SockaddrArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Get_Sockaddr_FailureArgs : TraceEvent
    {
        public Address NdkObject { get { return GetAddressAt(0); } }
        public int NdkObjectType { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SockAddrType { get { return GetInt32At(HostOffset(8, 1)); } }
        public int Status { get { return GetInt32At(HostOffset(12, 1)); } }

        #region Private
        internal Ndkpi_Get_Sockaddr_FailureArgs(Action<Ndkpi_Get_Sockaddr_FailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Get_Sockaddr_FailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkObject", NdkObject);
            XmlAttrib(sb, "NdkObjectType", NdkObjectType);
            XmlAttrib(sb, "SockAddrType", SockAddrType);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkObject", "NdkObjectType", "SockAddrType", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkObject;
                case 1:
                    return NdkObjectType;
                case 2:
                    return SockAddrType;
                case 3:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Get_Sockaddr_FailureArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Get_TokenArgs : TraceEvent
    {
        public Address NdkObject { get { return GetAddressAt(0); } }
        public int NdkObjectType { get { return GetInt32At(HostOffset(4, 1)); } }
        public TCPIP_NDKPI_TOKEN_TYPE TokenType { get { return (TCPIP_NDKPI_TOKEN_TYPE)GetInt32At(HostOffset(8, 1)); } }
        public int Token { get { return GetInt32At(HostOffset(12, 1)); } }

        #region Private
        internal Ndkpi_Get_TokenArgs(Action<Ndkpi_Get_TokenArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Get_TokenArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkObject", NdkObject);
            XmlAttrib(sb, "NdkObjectType", NdkObjectType);
            XmlAttrib(sb, "TokenType", TokenType);
            XmlAttrib(sb, "Token", Token);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkObject", "NdkObjectType", "TokenType", "Token" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkObject;
                case 1:
                    return NdkObjectType;
                case 2:
                    return TokenType;
                case 3:
                    return Token;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Get_TokenArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Initialize_Fast_Register_MrArgs : TraceEvent
    {
        public Address NdkMr { get { return GetAddressAt(0); } }
        public int AdapterPageCount { get { return GetInt32At(HostOffset(4, 1)); } }
        public int RemoteAccess { get { return GetInt32At(HostOffset(8, 1)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(12, 1)); } }

        #region Private
        internal Ndkpi_Initialize_Fast_Register_MrArgs(Action<Ndkpi_Initialize_Fast_Register_MrArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Initialize_Fast_Register_MrArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkMr", NdkMr);
            XmlAttrib(sb, "AdapterPageCount", AdapterPageCount);
            XmlAttrib(sb, "RemoteAccess", RemoteAccess);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkMr", "AdapterPageCount", "RemoteAccess", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkMr;
                case 1:
                    return AdapterPageCount;
                case 2:
                    return RemoteAccess;
                case 3:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Initialize_Fast_Register_MrArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Interface_EventArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public int EventDescription { get { return GetInt32At(4); } }
        public int NDKOperational { get { return GetInt32At(8); } }
        public int StatusCode { get { return GetInt32At(12); } }

        #region Private
        internal Ndkpi_Interface_EventArgs(Action<Ndkpi_Interface_EventArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Interface_EventArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "EventDescription", EventDescription);
            XmlAttrib(sb, "NDKOperational", NDKOperational);
            XmlAttrib(sb, "StatusCode", StatusCode);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "EventDescription", "NDKOperational", "StatusCode" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return EventDescription;
                case 2:
                    return NDKOperational;
                case 3:
                    return StatusCode;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Interface_EventArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_InvalidateArgs : TraceEvent
    {
        public Address NdkQp { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address NdkObject { get { return GetAddressAt(HostOffset(8, 2)); } }
        public int NdkObjectType { get { return GetInt32At(HostOffset(12, 3)); } }
        public int Flags { get { return GetInt32At(HostOffset(16, 3)); } }

        #region Private
        internal Ndkpi_InvalidateArgs(Action<Ndkpi_InvalidateArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(20, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(20, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_InvalidateArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "NdkObject", NdkObject);
            XmlAttrib(sb, "NdkObjectType", NdkObjectType);
            XmlAttrib(sb, "Flags", Flags);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkQp", "RequestContext", "NdkObject", "NdkObjectType", "Flags" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkQp;
                case 1:
                    return RequestContext;
                case 2:
                    return NdkObject;
                case 3:
                    return NdkObjectType;
                case 4:
                    return Flags;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_InvalidateArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Modify_SrqArgs : TraceEvent
    {
        public Address NdkSrq { get { return GetAddressAt(0); } }
        public int SrqDepth { get { return GetInt32At(HostOffset(4, 1)); } }
        public int NotifyThreshold { get { return GetInt32At(HostOffset(8, 1)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(12, 1)); } }

        #region Private
        internal Ndkpi_Modify_SrqArgs(Action<Ndkpi_Modify_SrqArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Modify_SrqArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkSrq", NdkSrq);
            XmlAttrib(sb, "SrqDepth", SrqDepth);
            XmlAttrib(sb, "NotifyThreshold", NotifyThreshold);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkSrq", "SrqDepth", "NotifyThreshold", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkSrq;
                case 1:
                    return SrqDepth;
                case 2:
                    return NotifyThreshold;
                case 3:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Modify_SrqArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Open_AdapterArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public Address NdkAdapter { get { return GetAddressAt(4); } }
        public int Status { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal Ndkpi_Open_AdapterArgs(Action<Ndkpi_Open_AdapterArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Open_AdapterArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttribHex(sb, "NdkAdapter", NdkAdapter);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "NdkAdapter", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return NdkAdapter;
                case 2:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Open_AdapterArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_ReadArgs : TraceEvent
    {
        public Address NdkQp { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address SgeAddress { get { return GetAddressAt(HostOffset(8, 2)); } }
        public int SgeLength { get { return GetInt32At(HostOffset(12, 3)); } }
        public int SgeMemoryRegionToken { get { return GetInt32At(HostOffset(16, 3)); } }
        public int NumSge { get { return GetInt32At(HostOffset(20, 3)); } }
        public int Flags { get { return GetInt32At(HostOffset(24, 3)); } }
        public int SgeIndex { get { return GetInt32At(HostOffset(28, 3)); } }
        public long RemoteAddress { get { return GetInt64At(HostOffset(32, 3)); } }
        public int RemoteToken { get { return GetInt32At(HostOffset(40, 3)); } }

        #region Private
        internal Ndkpi_ReadArgs(Action<Ndkpi_ReadArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(44, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(44, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_ReadArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "SgeAddress", SgeAddress);
            XmlAttrib(sb, "SgeLength", SgeLength);
            XmlAttrib(sb, "SgeMemoryRegionToken", SgeMemoryRegionToken);
            XmlAttrib(sb, "NumSge", NumSge);
            XmlAttrib(sb, "Flags", Flags);
            XmlAttrib(sb, "SgeIndex", SgeIndex);
            XmlAttrib(sb, "RemoteAddress", RemoteAddress);
            XmlAttrib(sb, "RemoteToken", RemoteToken);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkQp", "RequestContext", "SgeAddress", "SgeLength", "SgeMemoryRegionToken", "NumSge", "Flags", "SgeIndex", "RemoteAddress", "RemoteToken" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkQp;
                case 1:
                    return RequestContext;
                case 2:
                    return SgeAddress;
                case 3:
                    return SgeLength;
                case 4:
                    return SgeMemoryRegionToken;
                case 5:
                    return NumSge;
                case 6:
                    return Flags;
                case 7:
                    return SgeIndex;
                case 8:
                    return RemoteAddress;
                case 9:
                    return RemoteToken;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_ReadArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_SendArgs : TraceEvent
    {
        public Address NdkQp { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address SgeAddress { get { return GetAddressAt(HostOffset(8, 2)); } }
        public int SgeLength { get { return GetInt32At(HostOffset(12, 3)); } }
        public int SgeMemoryRegionToken { get { return GetInt32At(HostOffset(16, 3)); } }
        public int NumSge { get { return GetInt32At(HostOffset(20, 3)); } }
        public int Flags { get { return GetInt32At(HostOffset(24, 3)); } }
        public int SgeIndex { get { return GetInt32At(HostOffset(28, 3)); } }

        #region Private
        internal Ndkpi_SendArgs(Action<Ndkpi_SendArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(32, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(32, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_SendArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "SgeAddress", SgeAddress);
            XmlAttrib(sb, "SgeLength", SgeLength);
            XmlAttrib(sb, "SgeMemoryRegionToken", SgeMemoryRegionToken);
            XmlAttrib(sb, "NumSge", NumSge);
            XmlAttrib(sb, "Flags", Flags);
            XmlAttrib(sb, "SgeIndex", SgeIndex);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkQp", "RequestContext", "SgeAddress", "SgeLength", "SgeMemoryRegionToken", "NumSge", "Flags", "SgeIndex" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkQp;
                case 1:
                    return RequestContext;
                case 2:
                    return SgeAddress;
                case 3:
                    return SgeLength;
                case 4:
                    return SgeMemoryRegionToken;
                case 5:
                    return NumSge;
                case 6:
                    return Flags;
                case 7:
                    return SgeIndex;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_SendArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Register_MrArgs : TraceEvent
    {
        public Address NdkMr { get { return GetAddressAt(0); } }
        public Address Mdl { get { return GetAddressAt(HostOffset(4, 1)); } }
        public long Length { get { return GetInt64At(HostOffset(8, 2)); } }
        public int Flags { get { return GetInt32At(HostOffset(16, 2)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(20, 2)); } }

        #region Private
        internal Ndkpi_Register_MrArgs(Action<Ndkpi_Register_MrArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(24, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(24, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Register_MrArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkMr", NdkMr);
            XmlAttribHex(sb, "Mdl", Mdl);
            XmlAttrib(sb, "Length", Length);
            XmlAttrib(sb, "Flags", Flags);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkMr", "Mdl", "Length", "Flags", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkMr;
                case 1:
                    return Mdl;
                case 2:
                    return Length;
                case 3:
                    return Flags;
                case 4:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Register_MrArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_RejectArgs : TraceEvent
    {
        public Address NdkConnector { get { return GetAddressAt(0); } }
        public int PrivateDataLength { get { return GetInt32At(HostOffset(4, 1)); } }
        public int Status { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal Ndkpi_RejectArgs(Action<Ndkpi_RejectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_RejectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkConnector", NdkConnector);
            XmlAttrib(sb, "PrivateDataLength", PrivateDataLength);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkConnector", "PrivateDataLength", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkConnector;
                case 1:
                    return PrivateDataLength;
                case 2:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_RejectArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Release_LamArgs : TraceEvent
    {
        public Address NdkAdapter { get { return GetAddressAt(0); } }
        public Address LAMBuffer { get { return GetAddressAt(HostOffset(4, 1)); } }

        #region Private
        internal Ndkpi_Release_LamArgs(Action<Ndkpi_Release_LamArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Release_LamArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkAdapter", NdkAdapter);
            XmlAttribHex(sb, "LAMBuffer", LAMBuffer);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkAdapter", "LAMBuffer" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkAdapter;
                case 1:
                    return LAMBuffer;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Release_LamArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Request_CompletionArgs : TraceEvent
    {
        public Address RequestContext { get { return GetAddressAt(0); } }
        public int Status { get { return GetInt32At(HostOffset(4, 1)); } }
        public int CompletionType { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal Ndkpi_Request_CompletionArgs(Action<Ndkpi_Request_CompletionArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Request_CompletionArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "CompletionType", CompletionType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "RequestContext", "Status", "CompletionType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return RequestContext;
                case 1:
                    return Status;
                case 2:
                    return CompletionType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Request_CompletionArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Resize_CqArgs : TraceEvent
    {
        public Address NdkCq { get { return GetAddressAt(0); } }
        public int CqDepth { get { return GetInt32At(HostOffset(4, 1)); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(8, 1)); } }

        #region Private
        internal Ndkpi_Resize_CqArgs(Action<Ndkpi_Resize_CqArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Resize_CqArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkCq", NdkCq);
            XmlAttrib(sb, "CqDepth", CqDepth);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkCq", "CqDepth", "RequestContext" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkCq;
                case 1:
                    return CqDepth;
                case 2:
                    return RequestContext;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Resize_CqArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Send_InvalidateArgs : TraceEvent
    {
        public Address NdkQp { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address SgeAddress { get { return GetAddressAt(HostOffset(8, 2)); } }
        public int SgeLength { get { return GetInt32At(HostOffset(12, 3)); } }
        public int SgeMemoryRegionToken { get { return GetInt32At(HostOffset(16, 3)); } }
        public int NumSge { get { return GetInt32At(HostOffset(20, 3)); } }
        public int Flags { get { return GetInt32At(HostOffset(24, 3)); } }
        public int SgeIndex { get { return GetInt32At(HostOffset(28, 3)); } }
        public int RemoteToken { get { return GetInt32At(HostOffset(32, 3)); } }

        #region Private
        internal Ndkpi_Send_InvalidateArgs(Action<Ndkpi_Send_InvalidateArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(36, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(36, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Send_InvalidateArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "SgeAddress", SgeAddress);
            XmlAttrib(sb, "SgeLength", SgeLength);
            XmlAttrib(sb, "SgeMemoryRegionToken", SgeMemoryRegionToken);
            XmlAttrib(sb, "NumSge", NumSge);
            XmlAttrib(sb, "Flags", Flags);
            XmlAttrib(sb, "SgeIndex", SgeIndex);
            XmlAttrib(sb, "RemoteToken", RemoteToken);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkQp", "RequestContext", "SgeAddress", "SgeLength", "SgeMemoryRegionToken", "NumSge", "Flags", "SgeIndex", "RemoteToken" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkQp;
                case 1:
                    return RequestContext;
                case 2:
                    return SgeAddress;
                case 3:
                    return SgeLength;
                case 4:
                    return SgeMemoryRegionToken;
                case 5:
                    return NumSge;
                case 6:
                    return Flags;
                case 7:
                    return SgeIndex;
                case 8:
                    return RemoteToken;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Send_InvalidateArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Srq_Notification_CallbackArgs : TraceEvent
    {
        public Address SrqNotificationContext { get { return GetAddressAt(0); } }
        public int SrqStatus { get { return GetInt32At(HostOffset(4, 1)); } }

        #region Private
        internal Ndkpi_Srq_Notification_CallbackArgs(Action<Ndkpi_Srq_Notification_CallbackArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Srq_Notification_CallbackArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "SrqNotificationContext", SrqNotificationContext);
            XmlAttrib(sb, "SrqStatus", SrqStatus);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SrqNotificationContext", "SrqStatus" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SrqNotificationContext;
                case 1:
                    return SrqStatus;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Srq_Notification_CallbackArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Srq_Work_Request_Inline_FailureArgs : TraceEvent
    {
        public Address NdkSrq { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int Status { get { return GetInt32At(HostOffset(8, 2)); } }

        #region Private
        internal Ndkpi_Srq_Work_Request_Inline_FailureArgs(Action<Ndkpi_Srq_Work_Request_Inline_FailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Srq_Work_Request_Inline_FailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkSrq", NdkSrq);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkSrq", "RequestContext", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkSrq;
                case 1:
                    return RequestContext;
                case 2:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Srq_Work_Request_Inline_FailureArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_SrqReceiveArgs : TraceEvent
    {
        public Address NdkSrq { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address SgeAddress { get { return GetAddressAt(HostOffset(8, 2)); } }
        public int SgeLength { get { return GetInt32At(HostOffset(12, 3)); } }
        public int SgeMemoryRegionToken { get { return GetInt32At(HostOffset(16, 3)); } }
        public int NumSge { get { return GetInt32At(HostOffset(20, 3)); } }
        public int Flags { get { return GetInt32At(HostOffset(24, 3)); } }
        public int SgeIndex { get { return GetInt32At(HostOffset(28, 3)); } }

        #region Private
        internal Ndkpi_SrqReceiveArgs(Action<Ndkpi_SrqReceiveArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(32, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(32, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_SrqReceiveArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkSrq", NdkSrq);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttribHex(sb, "SgeAddress", SgeAddress);
            XmlAttrib(sb, "SgeLength", SgeLength);
            XmlAttrib(sb, "SgeMemoryRegionToken", SgeMemoryRegionToken);
            XmlAttrib(sb, "NumSge", NumSge);
            XmlAttrib(sb, "Flags", Flags);
            XmlAttrib(sb, "SgeIndex", SgeIndex);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkSrq", "RequestContext", "SgeAddress", "SgeLength", "SgeMemoryRegionToken", "NumSge", "Flags", "SgeIndex" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkSrq;
                case 1:
                    return RequestContext;
                case 2:
                    return SgeAddress;
                case 3:
                    return SgeLength;
                case 4:
                    return SgeMemoryRegionToken;
                case 5:
                    return NumSge;
                case 6:
                    return Flags;
                case 7:
                    return SgeIndex;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_SrqReceiveArgs> m_target;
        #endregion
    }
    public sealed class Ndkpi_Work_Request_Inline_FailureArgs : TraceEvent
    {
        public Address NdkQp { get { return GetAddressAt(0); } }
        public Address RequestContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int Status { get { return GetInt32At(HostOffset(8, 2)); } }

        #region Private
        internal Ndkpi_Work_Request_Inline_FailureArgs(Action<Ndkpi_Work_Request_Inline_FailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<Ndkpi_Work_Request_Inline_FailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NdkQp", NdkQp);
            XmlAttribHex(sb, "RequestContext", RequestContext);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NdkQp", "RequestContext", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NdkQp;
                case 1:
                    return RequestContext;
                case 2:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<Ndkpi_Work_Request_Inline_FailureArgs> m_target;
        #endregion
    }
    public sealed class RssBindingBindCompleteArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public int AddressFamily { get { return GetInt16At(4); } }

        #region Private
        internal RssBindingBindCompleteArgs(Action<RssBindingBindCompleteArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 6));
            Debug.Assert(!(Version > 0 && EventDataLength < 6));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssBindingBindCompleteArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "AddressFamily" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return AddressFamily;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssBindingBindCompleteArgs> m_target;
        #endregion
    }
    public sealed class RssBindingCapabilityArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public TCPIP_RSS_BINDING_CAPABILITY Capability { get { return (TCPIP_RSS_BINDING_CAPABILITY)GetInt32At(4); } }

        #region Private
        internal RssBindingCapabilityArgs(Action<RssBindingCapabilityArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssBindingCapabilityArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "Capability", Capability);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "Capability" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return Capability;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssBindingCapabilityArgs> m_target;
        #endregion
    }
    public sealed class RssBindingChangeArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public TCPIP_AF AddressFamily { get { return (TCPIP_AF)GetInt16At(4); } }
        public int Bind { get { return GetInt32At(6); } }

        #region Private
        internal RssBindingChangeArgs(Action<RssBindingChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 10));
            Debug.Assert(!(Version > 0 && EventDataLength < 10));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssBindingChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            XmlAttrib(sb, "Bind", Bind);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "AddressFamily", "Bind" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return AddressFamily;
                case 2:
                    return Bind;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssBindingChangeArgs> m_target;
        #endregion
    }
    public sealed class RssBindingRundownArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public int AdapterIndex { get { return GetInt32At(4); } }
        public int PortNumber { get { return GetInt32At(8); } }

        #region Private
        internal RssBindingRundownArgs(Action<RssBindingRundownArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssBindingRundownArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "PortNumber", PortNumber);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "AdapterIndex", "PortNumber" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return AdapterIndex;
                case 2:
                    return PortNumber;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssBindingRundownArgs> m_target;
        #endregion
    }
    public sealed class RssConfigurationChangeArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }
        public int Setting { get { return GetInt32At(4); } }
        public int Value { get { return GetInt32At(8); } }

        #region Private
        internal RssConfigurationChangeArgs(Action<RssConfigurationChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssConfigurationChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "Setting", Setting);
            XmlAttrib(sb, "Value", Value);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex", "Setting", "Value" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                case 1:
                    return Setting;
                case 2:
                    return Value;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssConfigurationChangeArgs> m_target;
        #endregion
    }
    public sealed class RssFailureArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public int FailureDescription { get { return GetInt32At(4); } }
        public int Status { get { return GetInt32At(8); } }

        #region Private
        internal RssFailureArgs(Action<RssFailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssFailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "FailureDescription", FailureDescription);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "FailureDescription", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return FailureDescription;
                case 2:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssFailureArgs> m_target;
        #endregion
    }
    public sealed class RssIndirectionChangeArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }
        public int IndirectionIndex { get { return GetInt16At(4); } }
        public int OldProcessorIndex { get { return GetInt32At(6); } }
        public int NewProcessorIndex { get { return GetInt32At(10); } }

        #region Private
        internal RssIndirectionChangeArgs(Action<RssIndirectionChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 14));
            Debug.Assert(!(Version > 0 && EventDataLength < 14));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssIndirectionChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "IndirectionIndex", IndirectionIndex);
            XmlAttrib(sb, "OldProcessorIndex", OldProcessorIndex);
            XmlAttrib(sb, "NewProcessorIndex", NewProcessorIndex);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex", "IndirectionIndex", "OldProcessorIndex", "NewProcessorIndex" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                case 1:
                    return IndirectionIndex;
                case 2:
                    return OldProcessorIndex;
                case 3:
                    return NewProcessorIndex;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssIndirectionChangeArgs> m_target;
        #endregion
    }
    public sealed class RssInitializeIndirectionTableArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }
        public int IndirectionTableSize { get { return GetInt32At(4); } }
        public byte[] IndirectionTable { get { return GetByteArrayAt(8, IndirectionTableSize); } }
        public int GroupNumber { get { return GetInt16At(0 + (IndirectionTableSize * 1) + 8); } }
        public long ActiveAffinity { get { return GetInt64At(0 + (IndirectionTableSize * 1) + 10); } }

        #region Private
        internal RssInitializeIndirectionTableArgs(Action<RssInitializeIndirectionTableArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (IndirectionTableSize * 1) + 18));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (IndirectionTableSize * 1) + 18));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssInitializeIndirectionTableArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "IndirectionTableSize", IndirectionTableSize);
            XmlAttrib(sb, "GroupNumber", GroupNumber);
            XmlAttrib(sb, "ActiveAffinity", ActiveAffinity);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex", "IndirectionTableSize", "IndirectionTable", "GroupNumber", "ActiveAffinity" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                case 1:
                    return IndirectionTableSize;
                case 2:
                    return GroupNumber;
                case 3:
                    return ActiveAffinity;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssInitializeIndirectionTableArgs> m_target;
        #endregion
    }
    public sealed class RssPortBindCompleteArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }

        #region Private
        internal RssPortBindCompleteArgs(Action<RssPortBindCompleteArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 4));
            Debug.Assert(!(Version > 0 && EventDataLength < 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssPortBindCompleteArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssPortBindCompleteArgs> m_target;
        #endregion
    }
    public sealed class RssPortCapabilitiesArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }
        public int CapabilitiesFlags { get { return GetInt32At(4); } }
        public int NumberOfInterruptMessages { get { return GetInt32At(8); } }
        public int NumberOfReceiveQueues { get { return GetInt32At(12); } }

        #region Private
        internal RssPortCapabilitiesArgs(Action<RssPortCapabilitiesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssPortCapabilitiesArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "CapabilitiesFlags", CapabilitiesFlags);
            XmlAttrib(sb, "NumberOfInterruptMessages", NumberOfInterruptMessages);
            XmlAttrib(sb, "NumberOfReceiveQueues", NumberOfReceiveQueues);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex", "CapabilitiesFlags", "NumberOfInterruptMessages", "NumberOfReceiveQueues" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                case 1:
                    return CapabilitiesFlags;
                case 2:
                    return NumberOfInterruptMessages;
                case 3:
                    return NumberOfReceiveQueues;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssPortCapabilitiesArgs> m_target;
        #endregion
    }
    public sealed class RssPortChangeArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }
        public int InterfaceIndex { get { return GetInt32At(4); } }
        public int PortNumber { get { return GetInt32At(8); } }
        public TCPIP_RSS_BINDING_NOTIFICATION Bind { get { return (TCPIP_RSS_BINDING_NOTIFICATION)GetInt32At(12); } }

        #region Private
        internal RssPortChangeArgs(Action<RssPortChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssPortChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "PortNumber", PortNumber);
            XmlAttrib(sb, "Bind", Bind);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex", "InterfaceIndex", "PortNumber", "Bind" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                case 1:
                    return InterfaceIndex;
                case 2:
                    return PortNumber;
                case 3:
                    return Bind;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssPortChangeArgs> m_target;
        #endregion
    }
    public sealed class RssPortProcessorsArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }
        public int GroupNumber { get { return GetInt16At(4); } }
        public int MaximumProcessors { get { return GetInt32At(6); } }
        public long GroupAffinity { get { return GetInt64At(10); } }

        #region Private
        internal RssPortProcessorsArgs(Action<RssPortProcessorsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 18));
            Debug.Assert(!(Version > 0 && EventDataLength < 18));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssPortProcessorsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "GroupNumber", GroupNumber);
            XmlAttrib(sb, "MaximumProcessors", MaximumProcessors);
            XmlAttrib(sb, "GroupAffinity", GroupAffinity);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex", "GroupNumber", "MaximumProcessors", "GroupAffinity" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                case 1:
                    return GroupNumber;
                case 2:
                    return MaximumProcessors;
                case 3:
                    return GroupAffinity;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssPortProcessorsArgs> m_target;
        #endregion
    }
    public sealed class RssPortReferenceArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }
        public int ExistingInterfaceIndex { get { return GetInt32At(4); } }
        public int ExistingPortNumber { get { return GetInt32At(8); } }
        public TCPIP_RSS_ADDING ReferenceAdded { get { return (TCPIP_RSS_ADDING)GetByteAt(12); } }

        #region Private
        internal RssPortReferenceArgs(Action<RssPortReferenceArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 13));
            Debug.Assert(!(Version > 0 && EventDataLength < 13));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssPortReferenceArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "ExistingInterfaceIndex", ExistingInterfaceIndex);
            XmlAttrib(sb, "ExistingPortNumber", ExistingPortNumber);
            XmlAttrib(sb, "ReferenceAdded", ReferenceAdded);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex", "ExistingInterfaceIndex", "ExistingPortNumber", "ReferenceAdded" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                case 1:
                    return ExistingInterfaceIndex;
                case 2:
                    return ExistingPortNumber;
                case 3:
                    return ReferenceAdded;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssPortReferenceArgs> m_target;
        #endregion
    }
    public sealed class RssPortRundownArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }
        public int HashInfo { get { return GetInt32At(4); } }
        public int MaximumProcessors { get { return GetInt32At(8); } }
        public int GroupNumber { get { return GetInt16At(12); } }
        public long GroupAffinity { get { return GetInt64At(14); } }
        public long ActiveAffinity { get { return GetInt64At(22); } }
        public TCPIP_RSS_SETTING_VALUE ActiveMode { get { return (TCPIP_RSS_SETTING_VALUE)GetInt32At(30); } }
        public int IndirectionTableSize { get { return GetInt32At(34); } }
        public byte[] IndirectionTable { get { return GetByteArrayAt(38, IndirectionTableSize); } }

        #region Private
        internal RssPortRundownArgs(Action<RssPortRundownArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (IndirectionTableSize * 1) + 38));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (IndirectionTableSize * 1) + 38));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssPortRundownArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "HashInfo", HashInfo);
            XmlAttrib(sb, "MaximumProcessors", MaximumProcessors);
            XmlAttrib(sb, "GroupNumber", GroupNumber);
            XmlAttrib(sb, "GroupAffinity", GroupAffinity);
            XmlAttrib(sb, "ActiveAffinity", ActiveAffinity);
            XmlAttrib(sb, "ActiveMode", ActiveMode);
            XmlAttrib(sb, "IndirectionTableSize", IndirectionTableSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex", "HashInfo", "MaximumProcessors", "GroupNumber", "GroupAffinity", "ActiveAffinity", "ActiveMode", "IndirectionTableSize", "IndirectionTable" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                case 1:
                    return HashInfo;
                case 2:
                    return MaximumProcessors;
                case 3:
                    return GroupNumber;
                case 4:
                    return GroupAffinity;
                case 5:
                    return ActiveAffinity;
                case 6:
                    return ActiveMode;
                case 7:
                    return IndirectionTableSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssPortRundownArgs> m_target;
        #endregion
    }
    public sealed class RssProcessorAssignmentArgs : TraceEvent
    {
        public int NewAdapterIndex { get { return GetInt32At(0); } }
        public int ProcessorIndex { get { return GetInt32At(4); } }
        public int PreviousAdapterIndex { get { return GetInt32At(8); } }
        public int TriggeringProcessorIndex { get { return GetInt32At(12); } }

        #region Private
        internal RssProcessorAssignmentArgs(Action<RssProcessorAssignmentArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssProcessorAssignmentArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "NewAdapterIndex", NewAdapterIndex);
            XmlAttrib(sb, "ProcessorIndex", ProcessorIndex);
            XmlAttrib(sb, "PreviousAdapterIndex", PreviousAdapterIndex);
            XmlAttrib(sb, "TriggeringProcessorIndex", TriggeringProcessorIndex);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NewAdapterIndex", "ProcessorIndex", "PreviousAdapterIndex", "TriggeringProcessorIndex" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NewAdapterIndex;
                case 1:
                    return ProcessorIndex;
                case 2:
                    return PreviousAdapterIndex;
                case 3:
                    return TriggeringProcessorIndex;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssProcessorAssignmentArgs> m_target;
        #endregion
    }
    public sealed class RssProcessorConsolidationArgs : TraceEvent
    {
        public int AdapterIndex { get { return GetInt32At(0); } }
        public int ProcessorIndex { get { return GetByteAt(4); } }

        #region Private
        internal RssProcessorConsolidationArgs(Action<RssProcessorConsolidationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 5));
            Debug.Assert(!(Version > 0 && EventDataLength < 5));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssProcessorConsolidationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterIndex", AdapterIndex);
            XmlAttrib(sb, "ProcessorIndex", ProcessorIndex);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterIndex", "ProcessorIndex" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterIndex;
                case 1:
                    return ProcessorIndex;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssProcessorConsolidationArgs> m_target;
        #endregion
    }
    public sealed class RssProcessorUnassignmentArgs : TraceEvent
    {
        public int PreviousAdapterIndex { get { return GetInt32At(0); } }
        public int ProcessorIndex { get { return GetInt32At(4); } }

        #region Private
        internal RssProcessorUnassignmentArgs(Action<RssProcessorUnassignmentArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<RssProcessorUnassignmentArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "PreviousAdapterIndex", PreviousAdapterIndex);
            XmlAttrib(sb, "ProcessorIndex", ProcessorIndex);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "PreviousAdapterIndex", "ProcessorIndex" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return PreviousAdapterIndex;
                case 1:
                    return ProcessorIndex;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<RssProcessorUnassignmentArgs> m_target;
        #endregion
    }
    public sealed class task_0Args : TraceEvent
    {
        public int Interface { get { return GetInt32At(0); } }
        public string Protocol { get { return GetUTF8StringAt(4); } }
        public int IpAddrLength { get { return GetInt32At(SkipUTF8String(4)); } }
        public int IPv4Address { get { return GetInt32At(SkipUTF8String(4) + 4); } }
        public byte[] IPv6Address { get { return GetByteArrayAt(SkipUTF8String(4) + 8, IpAddrLength); } }
        public int IPProtocol { get { return GetInt32At(SkipUTF8String(4) + 8); } }
        public int CurrentTime { get { return GetInt32At(SkipUTF8String(4) + 12); } }
        public int OldBaseTime { get { return GetInt32At(SkipUTF8String(4) + 16); } }
        public int OldValidTime { get { return GetInt32At(SkipUTF8String(4) + 20); } }
        public int OldPreferredTime { get { return GetInt32At(SkipUTF8String(4) + 24); } }
        public int NewBaseTime { get { return GetInt32At(SkipUTF8String(4) + 28); } }
        public int NewValidTime { get { return GetInt32At(SkipUTF8String(4) + 32); } }
        public int NewPreferredTime { get { return GetInt32At(SkipUTF8String(4) + 36); } }

        #region Private
        internal task_0Args(Action<task_0Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUTF8String(4) + 40));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUTF8String(4) + 40));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<task_0Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "Protocol", Protocol);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "IPv4Address", IPv4Address);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            XmlAttrib(sb, "CurrentTime", CurrentTime);
            XmlAttrib(sb, "OldBaseTime", OldBaseTime);
            XmlAttrib(sb, "OldValidTime", OldValidTime);
            XmlAttrib(sb, "OldPreferredTime", OldPreferredTime);
            XmlAttrib(sb, "NewBaseTime", NewBaseTime);
            XmlAttrib(sb, "NewValidTime", NewValidTime);
            XmlAttrib(sb, "NewPreferredTime", NewPreferredTime);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Interface", "Protocol", "IpAddrLength", "IPv4Address", "IPv6Address", "IPProtocol", "CurrentTime", "OldBaseTime", "OldValidTime", "OldPreferredTime", "NewBaseTime", "NewValidTime", "NewPreferredTime" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Interface;
                case 1:
                    return Protocol;
                case 2:
                    return IpAddrLength;
                case 3:
                    return IPv4Address;
                case 4:
                    return IPProtocol;
                case 5:
                    return CurrentTime;
                case 6:
                    return OldBaseTime;
                case 7:
                    return OldValidTime;
                case 8:
                    return OldPreferredTime;
                case 9:
                    return NewBaseTime;
                case 10:
                    return NewValidTime;
                case 11:
                    return NewPreferredTime;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<task_0Args> m_target;
        #endregion
    }
    public sealed class task_01317Args : TraceEvent
    {
        public Address Event { get { return GetAddressAt(0); } }
        public TCP_REPARTITION_EVENT_TYPE Type { get { return (TCP_REPARTITION_EVENT_TYPE)GetInt32At(HostOffset(4, 1)); } }
        public int Processor { get { return GetInt32At(HostOffset(8, 1)); } }
        public int PowerSource { get { return GetInt32At(HostOffset(12, 1)); } }
        public int OldPartitionCount { get { return GetInt32At(HostOffset(16, 1)); } }
        public int NewPartitionCount { get { return GetInt32At(HostOffset(20, 1)); } }
        public int Progress { get { return GetInt32At(HostOffset(24, 1)); } }

        #region Private
        internal task_01317Args(Action<task_01317Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<task_01317Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Event", Event);
            XmlAttrib(sb, "Type", Type);
            XmlAttrib(sb, "Processor", Processor);
            XmlAttrib(sb, "PowerSource", PowerSource);
            XmlAttrib(sb, "OldPartitionCount", OldPartitionCount);
            XmlAttrib(sb, "NewPartitionCount", NewPartitionCount);
            XmlAttrib(sb, "Progress", Progress);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Event", "Type", "Processor", "PowerSource", "OldPartitionCount", "NewPartitionCount", "Progress" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Event;
                case 1:
                    return Type;
                case 2:
                    return Processor;
                case 3:
                    return PowerSource;
                case 4:
                    return OldPartitionCount;
                case 5:
                    return NewPartitionCount;
                case 6:
                    return Progress;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<task_01317Args> m_target;
        #endregion
    }
    public sealed class task_01318Args : TraceEvent
    {
        public TCPIP_COMPONENT Component { get { return (TCPIP_COMPONENT)GetInt32At(0); } }
        public int PowerStateTransition { get { return GetInt32At(4); } }
        public int IndicatingProcessor { get { return GetInt32At(8); } }
        public int CurrentTick { get { return GetInt32At(12); } }
        public long CurrentTime { get { return GetInt64At(16); } }

        #region Private
        internal task_01318Args(Action<task_01318Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<task_01318Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Component", Component);
            XmlAttrib(sb, "PowerStateTransition", PowerStateTransition);
            XmlAttrib(sb, "IndicatingProcessor", IndicatingProcessor);
            XmlAttrib(sb, "CurrentTick", CurrentTick);
            XmlAttrib(sb, "CurrentTime", CurrentTime);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Component", "PowerStateTransition", "IndicatingProcessor", "CurrentTick", "CurrentTime" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Component;
                case 1:
                    return PowerStateTransition;
                case 2:
                    return IndicatingProcessor;
                case 3:
                    return CurrentTick;
                case 4:
                    return CurrentTime;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<task_01318Args> m_target;
        #endregion
    }
    public sealed class task_01319Args : TraceEvent
    {
        public int Component { get { return GetInt32At(0); } }
        public int IndicatingProcessor { get { return GetInt32At(4); } }
        public int TargetProcessor { get { return GetInt32At(8); } }
        public int CurrentTick { get { return GetInt32At(12); } }
        public int NextExpirationTick { get { return GetInt32At(16); } }
        public long OldScheduledExpiration { get { return GetInt64At(20); } }
        public long NewScheduledExpiration { get { return GetInt64At(28); } }
        public long DueTime { get { return GetInt64At(36); } }
        public int Aperiodic { get { return GetInt32At(44); } }

        #region Private
        internal task_01319Args(Action<task_01319Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 48));
            Debug.Assert(!(Version > 0 && EventDataLength < 48));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<task_01319Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Component", Component);
            XmlAttrib(sb, "IndicatingProcessor", IndicatingProcessor);
            XmlAttrib(sb, "TargetProcessor", TargetProcessor);
            XmlAttrib(sb, "CurrentTick", CurrentTick);
            XmlAttrib(sb, "NextExpirationTick", NextExpirationTick);
            XmlAttrib(sb, "OldScheduledExpiration", OldScheduledExpiration);
            XmlAttrib(sb, "NewScheduledExpiration", NewScheduledExpiration);
            XmlAttrib(sb, "DueTime", DueTime);
            XmlAttrib(sb, "Aperiodic", Aperiodic);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Component", "IndicatingProcessor", "TargetProcessor", "CurrentTick", "NextExpirationTick", "OldScheduledExpiration", "NewScheduledExpiration", "DueTime", "Aperiodic" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Component;
                case 1:
                    return IndicatingProcessor;
                case 2:
                    return TargetProcessor;
                case 3:
                    return CurrentTick;
                case 4:
                    return NextExpirationTick;
                case 5:
                    return OldScheduledExpiration;
                case 6:
                    return NewScheduledExpiration;
                case 7:
                    return DueTime;
                case 8:
                    return Aperiodic;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<task_01319Args> m_target;
        #endregion
    }
    public sealed class task_01320Args : TraceEvent
    {
        public int Component { get { return GetInt32At(0); } }
        public int TargetProcessor { get { return GetInt32At(4); } }
        public int CurrentTick { get { return GetInt32At(8); } }
        public int NextExpiration { get { return GetInt32At(12); } }
        public long CurrentInterruptTime { get { return GetInt64At(16); } }
        public long ScheduledExpirationTime { get { return GetInt64At(24); } }
        public int ExternalTrigger { get { return GetInt32At(32); } }

        #region Private
        internal task_01320Args(Action<task_01320Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 36));
            Debug.Assert(!(Version > 0 && EventDataLength < 36));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<task_01320Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Component", Component);
            XmlAttrib(sb, "TargetProcessor", TargetProcessor);
            XmlAttrib(sb, "CurrentTick", CurrentTick);
            XmlAttrib(sb, "NextExpiration", NextExpiration);
            XmlAttrib(sb, "CurrentInterruptTime", CurrentInterruptTime);
            XmlAttrib(sb, "ScheduledExpirationTime", ScheduledExpirationTime);
            XmlAttrib(sb, "ExternalTrigger", ExternalTrigger);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Component", "TargetProcessor", "CurrentTick", "NextExpiration", "CurrentInterruptTime", "ScheduledExpirationTime", "ExternalTrigger" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Component;
                case 1:
                    return TargetProcessor;
                case 2:
                    return CurrentTick;
                case 3:
                    return NextExpiration;
                case 4:
                    return CurrentInterruptTime;
                case 5:
                    return ScheduledExpirationTime;
                case 6:
                    return ExternalTrigger;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<task_01320Args> m_target;
        #endregion
    }
    public sealed class TcpAccpetListenerRouteLookupFailureArgs : TraceEvent
    {
        public int LocalAddressLength { get { return GetInt32At(0); } }
        public byte[] LocalAddress { get { return GetByteArrayAt(4, LocalAddressLength); } }
        public int RemoteAddressLength { get { return GetInt32At(0 + (LocalAddressLength * 1) + 4); } }
        public byte[] RemoteAddress { get { return GetByteArrayAt(0 + (LocalAddressLength * 1) + 8, RemoteAddressLength); } }
        public int Status { get { return GetInt32At(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 8); } }
        public int ProcessId { get { return GetInt32At(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 12); } }
        public int Compartment { get { return GetInt32At(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 16); } }
        public Address Tcb { get { return GetAddressAt(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 20); } }

        #region Private
        internal TcpAccpetListenerRouteLookupFailureArgs(Action<TcpAccpetListenerRouteLookupFailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 24, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 24, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpAccpetListenerRouteLookupFailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "LocalAddressLength", LocalAddressLength);
            XmlAttrib(sb, "RemoteAddressLength", RemoteAddressLength);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "ProcessId", ProcessId);
            XmlAttrib(sb, "Compartment", Compartment);
            XmlAttribHex(sb, "Tcb", Tcb);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "Status", "ProcessId", "Compartment", "Tcb" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return LocalAddressLength;
                case 1:
                    return RemoteAddressLength;
                case 2:
                    return Status;
                case 3:
                    return ProcessId;
                case 4:
                    return Compartment;
                case 5:
                    return Tcb;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpAccpetListenerRouteLookupFailureArgs> m_target;
        #endregion
    }
    public sealed class TcpAcceptListenerInsertionFailureArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int LocalAddressLength { get { return GetInt32At(HostOffset(4, 1)); } }
        public byte[] LocalAddress { get { return GetByteArrayAt(HostOffset(8, 1), LocalAddressLength); } }
        public int RemoteAddressLength { get { return GetInt32At(HostOffset(0 + (LocalAddressLength * 1) + 8, 1)); } }
        public byte[] RemoteAddress { get { return GetByteArrayAt(HostOffset(0 + (LocalAddressLength * 1) + 12, 1), RemoteAddressLength); } }
        public TCP_CONNECTION_STATE NewState { get { return (TCP_CONNECTION_STATE)GetInt32At(HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 12, 1)); } }
        public int RexmitCount { get { return GetInt32At(HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 16, 1)); } }

        #region Private
        internal TcpAcceptListenerInsertionFailureArgs(Action<TcpAcceptListenerInsertionFailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 20, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpAcceptListenerInsertionFailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "LocalAddressLength", LocalAddressLength);
            XmlAttrib(sb, "RemoteAddressLength", RemoteAddressLength);
            XmlAttrib(sb, "NewState", NewState);
            XmlAttrib(sb, "RexmitCount", RexmitCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "NewState", "RexmitCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return LocalAddressLength;
                case 2:
                    return RemoteAddressLength;
                case 3:
                    return NewState;
                case 4:
                    return RexmitCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpAcceptListenerInsertionFailureArgs> m_target;
        #endregion
    }
    public sealed class TcpAcquirePortArgs : TraceEvent
    {
        public Address PortAcquirer { get { return GetAddressAt(0); } }
        public int PortNumber { get { return GetInt16At(HostOffset(4, 1)); } }
        public int WeakReference { get { return GetInt32At(HostOffset(6, 1)); } }
        public Address OriginalAcquirer { get { return GetAddressAt(HostOffset(10, 1)); } }

        #region Private
        internal TcpAcquirePortArgs(Action<TcpAcquirePortArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(14, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(14, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpAcquirePortArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "PortAcquirer", PortAcquirer);
            XmlAttrib(sb, "PortNumber", PortNumber);
            XmlAttrib(sb, "WeakReference", WeakReference);
            XmlAttribHex(sb, "OriginalAcquirer", OriginalAcquirer);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "PortAcquirer", "PortNumber", "WeakReference", "OriginalAcquirer" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return PortAcquirer;
                case 1:
                    return PortNumber;
                case 2:
                    return WeakReference;
                case 3:
                    return OriginalAcquirer;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpAcquirePortArgs> m_target;
        #endregion
    }
    public sealed class TcpDataTransferTimeoutArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int Cwnd { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SSThresh { get { return GetInt32At(HostOffset(8, 1)); } }
        public int RttSample { get { return GetInt32At(HostOffset(12, 1)); } }
        public int NumBytes { get { return GetInt32At(HostOffset(16, 1)); } }
        public int SeqNo { get { return GetInt32At(HostOffset(20, 1)); } }
        public int SndUna { get { return GetInt32At(HostOffset(24, 1)); } }
        public int Round { get { return GetInt32At(HostOffset(28, 1)); } }
        public int SRTT { get { return GetInt32At(HostOffset(32, 1)); } }
        public int RTO { get { return GetInt32At(HostOffset(36, 1)); } }
        public int DWnd { get { return GetInt32At(HostOffset(40, 1)); } }
        public int BaseRtt { get { return GetInt32At(HostOffset(44, 1)); } }
        public int DupAckCount { get { return GetInt32At(HostOffset(48, 1)); } }

        #region Private
        internal TcpDataTransferTimeoutArgs(Action<TcpDataTransferTimeoutArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(52, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(52, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferTimeoutArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Cwnd", Cwnd);
            XmlAttrib(sb, "SSThresh", SSThresh);
            XmlAttrib(sb, "RttSample", RttSample);
            XmlAttrib(sb, "NumBytes", NumBytes);
            XmlAttrib(sb, "SeqNo", SeqNo);
            XmlAttrib(sb, "SndUna", SndUna);
            XmlAttrib(sb, "Round", Round);
            XmlAttrib(sb, "SRTT", SRTT);
            XmlAttrib(sb, "RTO", RTO);
            XmlAttrib(sb, "DWnd", DWnd);
            XmlAttrib(sb, "BaseRtt", BaseRtt);
            XmlAttrib(sb, "DupAckCount", DupAckCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Cwnd", "SSThresh", "RttSample", "NumBytes", "SeqNo", "SndUna", "Round", "SRTT", "RTO", "DWnd", "BaseRtt", "DupAckCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Cwnd;
                case 2:
                    return SSThresh;
                case 3:
                    return RttSample;
                case 4:
                    return NumBytes;
                case 5:
                    return SeqNo;
                case 6:
                    return SndUna;
                case 7:
                    return Round;
                case 8:
                    return SRTT;
                case 9:
                    return RTO;
                case 10:
                    return DWnd;
                case 11:
                    return BaseRtt;
                case 12:
                    return DupAckCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferTimeoutArgs> m_target;
        #endregion
    }
    public sealed class TcpAutoTuningBeginArgs : TraceEvent
    {
        public int LocalAddressLength { get { return GetInt32At(0); } }
        public byte[] LocalAddress { get { return GetByteArrayAt(4, LocalAddressLength); } }
        public int RemoteAddressLength { get { return GetInt32At(0 + (LocalAddressLength * 1) + 4); } }
        public byte[] RemoteAddress { get { return GetByteArrayAt(0 + (LocalAddressLength * 1) + 8, RemoteAddressLength); } }
        public int BufferSize { get { return GetInt32At(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 8); } }

        #region Private
        internal TcpAutoTuningBeginArgs(Action<TcpAutoTuningBeginArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpAutoTuningBeginArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "LocalAddressLength", LocalAddressLength);
            XmlAttrib(sb, "RemoteAddressLength", RemoteAddressLength);
            XmlAttrib(sb, "BufferSize", BufferSize);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "BufferSize" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return LocalAddressLength;
                case 1:
                    return RemoteAddressLength;
                case 2:
                    return BufferSize;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpAutoTuningBeginArgs> m_target;
        #endregion
    }
    public sealed class TcpLossRecoverySackExitArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int SndUna { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SndMax { get { return GetInt32At(HostOffset(8, 1)); } }
        public string Reason { get { return GetUnicodeStringAt(HostOffset(12, 1)); } }
        public int IsSack { get { return GetInt32At(SkipUnicodeString(HostOffset(12, 1))); } }

        #region Private
        internal TcpLossRecoverySackExitArgs(Action<TcpLossRecoverySackExitArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(12, 1)) + 4));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(12, 1)) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpLossRecoverySackExitArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SndUna", SndUna);
            XmlAttrib(sb, "SndMax", SndMax);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "IsSack", IsSack);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SndUna", "SndMax", "Reason", "IsSack" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SndUna;
                case 2:
                    return SndMax;
                case 3:
                    return Reason;
                case 4:
                    return IsSack;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpLossRecoverySackExitArgs> m_target;
        #endregion
    }
    public sealed class TcpBindEndpointResolutionFailureArgs : TraceEvent
    {
        public int LocalAddressLength { get { return GetInt32At(0); } }
        public byte[] LocalAddress { get { return GetByteArrayAt(4, LocalAddressLength); } }
        public int Status { get { return GetInt32At(0 + (LocalAddressLength * 1) + 4); } }

        #region Private
        internal TcpBindEndpointResolutionFailureArgs(Action<TcpBindEndpointResolutionFailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (LocalAddressLength * 1) + 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (LocalAddressLength * 1) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpBindEndpointResolutionFailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "LocalAddressLength", LocalAddressLength);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "LocalAddressLength", "LocalAddress", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return LocalAddressLength;
                case 1:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpBindEndpointResolutionFailureArgs> m_target;
        #endregion
    }
    public sealed class TcpBlackHoleDetectionEntryArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int BHMSS { get { return GetInt32At(HostOffset(4, 1)); } }
        public int OriginalMSS { get { return GetInt32At(HostOffset(8, 1)); } }
        public string TraceString { get { return GetUnicodeStringAt(HostOffset(12, 1)); } }

        #region Private
        internal TcpBlackHoleDetectionEntryArgs(Action<TcpBlackHoleDetectionEntryArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(12, 1))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(12, 1))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpBlackHoleDetectionEntryArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "BHMSS", BHMSS);
            XmlAttrib(sb, "OriginalMSS", OriginalMSS);
            XmlAttrib(sb, "TraceString", TraceString);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "BHMSS", "OriginalMSS", "TraceString" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return BHMSS;
                case 2:
                    return OriginalMSS;
                case 3:
                    return TraceString;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpBlackHoleDetectionEntryArgs> m_target;
        #endregion
    }
    public sealed class TcpLossRecoveryEntryArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int SndUna { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SndMax { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal TcpLossRecoveryEntryArgs(Action<TcpLossRecoveryEntryArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpLossRecoveryEntryArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SndUna", SndUna);
            XmlAttrib(sb, "SndMax", SndMax);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SndUna", "SndMax" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SndUna;
                case 2:
                    return SndMax;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpLossRecoveryEntryArgs> m_target;
        #endregion
    }
    public sealed class TcpConnectionOffloadStatusArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int Status { get { return GetInt32At(HostOffset(4, 1)); } }
        public int Interface { get { return GetInt32At(HostOffset(8, 1)); } }
        public int PMax { get { return GetInt32At(HostOffset(12, 1)); } }

        #region Private
        internal TcpConnectionOffloadStatusArgs(Action<TcpConnectionOffloadStatusArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpConnectionOffloadStatusArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "Interface", Interface);
            XmlAttrib(sb, "PMax", PMax);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Status", "Interface", "PMax" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Status;
                case 2:
                    return Interface;
                case 3:
                    return PMax;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpConnectionOffloadStatusArgs> m_target;
        #endregion
    }
    public sealed class TcpConnectionOffloadStateChangeArgs : TraceEvent
    {
        public int TcbState { get { return GetInt32At(0); } }
        public int OcbState { get { return GetInt32At(4); } }
        public int SndNxt { get { return GetInt32At(8); } }
        public int RcvNxt { get { return GetInt32At(12); } }
        public Address Tcb { get { return GetAddressAt(16); } }
        public int Status { get { return GetInt32At(HostOffset(20, 1)); } }

        #region Private
        internal TcpConnectionOffloadStateChangeArgs(Action<TcpConnectionOffloadStateChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(24, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(24, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpConnectionOffloadStateChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TcbState", TcbState);
            XmlAttrib(sb, "OcbState", OcbState);
            XmlAttrib(sb, "SndNxt", SndNxt);
            XmlAttrib(sb, "RcvNxt", RcvNxt);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TcbState", "OcbState", "SndNxt", "RcvNxt", "Tcb", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TcbState;
                case 1:
                    return OcbState;
                case 2:
                    return SndNxt;
                case 3:
                    return RcvNxt;
                case 4:
                    return Tcb;
                case 5:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpConnectionOffloadStateChangeArgs> m_target;
        #endregion
    }
    public sealed class TcpConnectionRundownArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int LocalAddressLength { get { return GetInt32At(HostOffset(4, 1)); } }
        public byte[] LocalAddress { get { return GetByteArrayAt(HostOffset(8, 1), LocalAddressLength); } }
        public int RemoteAddressLength { get { return GetInt32At(HostOffset(0 + (LocalAddressLength * 1) + 8, 1)); } }
        public byte[] RemoteAddress { get { return GetByteArrayAt(HostOffset(0 + (LocalAddressLength * 1) + 12, 1), RemoteAddressLength); } }
        public int State { get { return GetInt32At(HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 12, 1)); } }
        public int Pid { get { return GetInt32At(HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 16, 1)); } }

        #region Private
        internal TcpConnectionRundownArgs(Action<TcpConnectionRundownArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 20, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpConnectionRundownArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "LocalAddressLength", LocalAddressLength);
            XmlAttrib(sb, "RemoteAddressLength", RemoteAddressLength);
            XmlAttrib(sb, "State", State);
            XmlAttrib(sb, "Pid", Pid);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "State", "Pid" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return LocalAddressLength;
                case 2:
                    return RemoteAddressLength;
                case 3:
                    return State;
                case 4:
                    return Pid;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpConnectionRundownArgs> m_target;
        #endregion
    }
    public sealed class TcpConnectionSummaryArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public long DataBytesOut { get { return GetInt64At(HostOffset(4, 1)); } }
        public long DataBytesIn { get { return GetInt64At(HostOffset(12, 1)); } }
        public long DataSegmentsOut { get { return GetInt64At(HostOffset(20, 1)); } }
        public long DataSegmentsIn { get { return GetInt64At(HostOffset(28, 1)); } }
        public long SegmentsOut { get { return GetInt64At(HostOffset(36, 1)); } }
        public long SegmentsIn { get { return GetInt64At(HostOffset(44, 1)); } }
        public int NonRecovDa { get { return GetInt32At(HostOffset(52, 1)); } }
        public int NonRecovDaEpisodes { get { return GetInt32At(HostOffset(56, 1)); } }
        public int DupAcksIn { get { return GetInt32At(HostOffset(60, 1)); } }
        public int BytesRetrans { get { return GetInt32At(HostOffset(64, 1)); } }
        public int Timeouts { get { return GetInt32At(HostOffset(68, 1)); } }
        public int SpuriousRtoDetections { get { return GetInt32At(HostOffset(72, 1)); } }
        public int FastRetran { get { return GetInt32At(HostOffset(76, 1)); } }
        public int MaxSsthresh { get { return GetInt32At(HostOffset(80, 1)); } }
        public int MaxSsCwnd { get { return GetInt32At(HostOffset(84, 1)); } }
        public int MaxCaCwnd { get { return GetInt32At(HostOffset(88, 1)); } }
        public int SndLimTransRwin { get { return GetInt32At(HostOffset(92, 1)); } }
        public int SndLimTimeRwin { get { return GetInt32At(HostOffset(96, 1)); } }
        public long SndLimBytesRwin { get { return GetInt64At(HostOffset(100, 1)); } }
        public int SndLimTransCwnd { get { return GetInt32At(HostOffset(108, 1)); } }
        public int SndLimTimeCwnd { get { return GetInt32At(HostOffset(112, 1)); } }
        public long SndLimBytesCwnd { get { return GetInt64At(HostOffset(116, 1)); } }
        public int SndLimTransSnd { get { return GetInt32At(HostOffset(124, 1)); } }
        public int SndLimTimeRSnd { get { return GetInt32At(HostOffset(128, 1)); } }
        public long SndLimBytesRSnd { get { return GetInt64At(HostOffset(132, 1)); } }

        #region Private
        internal TcpConnectionSummaryArgs(Action<TcpConnectionSummaryArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(140, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(140, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpConnectionSummaryArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "DataBytesOut", DataBytesOut);
            XmlAttrib(sb, "DataBytesIn", DataBytesIn);
            XmlAttrib(sb, "DataSegmentsOut", DataSegmentsOut);
            XmlAttrib(sb, "DataSegmentsIn", DataSegmentsIn);
            XmlAttrib(sb, "SegmentsOut", SegmentsOut);
            XmlAttrib(sb, "SegmentsIn", SegmentsIn);
            XmlAttrib(sb, "NonRecovDa", NonRecovDa);
            XmlAttrib(sb, "NonRecovDaEpisodes", NonRecovDaEpisodes);
            XmlAttrib(sb, "DupAcksIn", DupAcksIn);
            XmlAttrib(sb, "BytesRetrans", BytesRetrans);
            XmlAttrib(sb, "Timeouts", Timeouts);
            XmlAttrib(sb, "SpuriousRtoDetections", SpuriousRtoDetections);
            XmlAttrib(sb, "FastRetran", FastRetran);
            XmlAttrib(sb, "MaxSsthresh", MaxSsthresh);
            XmlAttrib(sb, "MaxSsCwnd", MaxSsCwnd);
            XmlAttrib(sb, "MaxCaCwnd", MaxCaCwnd);
            XmlAttrib(sb, "SndLimTransRwin", SndLimTransRwin);
            XmlAttrib(sb, "SndLimTimeRwin", SndLimTimeRwin);
            XmlAttrib(sb, "SndLimBytesRwin", SndLimBytesRwin);
            XmlAttrib(sb, "SndLimTransCwnd", SndLimTransCwnd);
            XmlAttrib(sb, "SndLimTimeCwnd", SndLimTimeCwnd);
            XmlAttrib(sb, "SndLimBytesCwnd", SndLimBytesCwnd);
            XmlAttrib(sb, "SndLimTransSnd", SndLimTransSnd);
            XmlAttrib(sb, "SndLimTimeRSnd", SndLimTimeRSnd);
            XmlAttrib(sb, "SndLimBytesRSnd", SndLimBytesRSnd);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "DataBytesOut", "DataBytesIn", "DataSegmentsOut", "DataSegmentsIn", "SegmentsOut", "SegmentsIn", "NonRecovDa", "NonRecovDaEpisodes", "DupAcksIn", "BytesRetrans", "Timeouts", "SpuriousRtoDetections", "FastRetran", "MaxSsthresh", "MaxSsCwnd", "MaxCaCwnd", "SndLimTransRwin", "SndLimTimeRwin", "SndLimBytesRwin", "SndLimTransCwnd", "SndLimTimeCwnd", "SndLimBytesCwnd", "SndLimTransSnd", "SndLimTimeRSnd", "SndLimBytesRSnd" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return DataBytesOut;
                case 2:
                    return DataBytesIn;
                case 3:
                    return DataSegmentsOut;
                case 4:
                    return DataSegmentsIn;
                case 5:
                    return SegmentsOut;
                case 6:
                    return SegmentsIn;
                case 7:
                    return NonRecovDa;
                case 8:
                    return NonRecovDaEpisodes;
                case 9:
                    return DupAcksIn;
                case 10:
                    return BytesRetrans;
                case 11:
                    return Timeouts;
                case 12:
                    return SpuriousRtoDetections;
                case 13:
                    return FastRetran;
                case 14:
                    return MaxSsthresh;
                case 15:
                    return MaxSsCwnd;
                case 16:
                    return MaxCaCwnd;
                case 17:
                    return SndLimTransRwin;
                case 18:
                    return SndLimTimeRwin;
                case 19:
                    return SndLimBytesRwin;
                case 20:
                    return SndLimTransCwnd;
                case 21:
                    return SndLimTimeCwnd;
                case 22:
                    return SndLimBytesCwnd;
                case 23:
                    return SndLimTransSnd;
                case 24:
                    return SndLimTimeRSnd;
                case 25:
                    return SndLimBytesRSnd;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpConnectionSummaryArgs> m_target;
        #endregion
    }
    public sealed class TcpRequestConnectArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int LocalAddressLength { get { return GetInt32At(HostOffset(4, 1)); } }
        public byte[] LocalAddress { get { return GetByteArrayAt(HostOffset(8, 1), LocalAddressLength); } }
        public int RemoteAddressLength { get { return GetInt32At(HostOffset(0 + (LocalAddressLength * 1) + 8, 1)); } }
        public byte[] RemoteAddress { get { return GetByteArrayAt(HostOffset(0 + (LocalAddressLength * 1) + 12, 1), RemoteAddressLength); } }
        public int NewState { get { return GetInt32At(HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 12, 1)); } }
        public int RexmitCount { get { return GetInt32At(HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 16, 1)); } }

        #region Private
        internal TcpRequestConnectArgs(Action<TcpRequestConnectArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 20, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpRequestConnectArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "LocalAddressLength", LocalAddressLength);
            XmlAttrib(sb, "RemoteAddressLength", RemoteAddressLength);
            XmlAttrib(sb, "NewState", NewState);
            XmlAttrib(sb, "RexmitCount", RexmitCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "NewState", "RexmitCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return LocalAddressLength;
                case 2:
                    return RemoteAddressLength;
                case 3:
                    return NewState;
                case 4:
                    return RexmitCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpRequestConnectArgs> m_target;
        #endregion
    }
    public sealed class TcpInspectConnectCompleteArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int Status { get { return GetInt32At(HostOffset(4, 1)); } }
        public int AddressFamily { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal TcpInspectConnectCompleteArgs(Action<TcpInspectConnectCompleteArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpInspectConnectCompleteArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Status", "AddressFamily" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Status;
                case 2:
                    return AddressFamily;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpInspectConnectCompleteArgs> m_target;
        #endregion
    }
    public sealed class TcpConnectTcbSkipRateLimitArgs : TraceEvent
    {
        public int LocalAddressLength { get { return GetInt32At(0); } }
        public byte[] LocalAddress { get { return GetByteArrayAt(4, LocalAddressLength); } }
        public int RemoteAddressLength { get { return GetInt32At(0 + (LocalAddressLength * 1) + 4); } }
        public byte[] RemoteAddress { get { return GetByteArrayAt(0 + (LocalAddressLength * 1) + 8, RemoteAddressLength); } }
        public Address Path { get { return GetAddressAt(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 8); } }

        #region Private
        internal TcpConnectTcbSkipRateLimitArgs(Action<TcpConnectTcbSkipRateLimitArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpConnectTcbSkipRateLimitArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "LocalAddressLength", LocalAddressLength);
            XmlAttrib(sb, "RemoteAddressLength", RemoteAddressLength);
            XmlAttribHex(sb, "Path", Path);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "Path" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return LocalAddressLength;
                case 1:
                    return RemoteAddressLength;
                case 2:
                    return Path;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpConnectTcbSkipRateLimitArgs> m_target;
        #endregion
    }
    public sealed class TcpCreateEndpointAfFailureArgs : TraceEvent
    {
        public int LocalAddressLength { get { return GetInt32At(0); } }
        public byte[] LocalAddress { get { return GetByteArrayAt(4, LocalAddressLength); } }
        public int Status { get { return GetInt32At(0 + (LocalAddressLength * 1) + 4); } }
        public int ProcessId { get { return GetInt32At(0 + (LocalAddressLength * 1) + 8); } }
        public int CompartmentId { get { return GetInt32At(0 + (LocalAddressLength * 1) + 12); } }
        public int AddressFamily { get { return GetInt32At(0 + (LocalAddressLength * 1) + 16); } }

        #region Private
        internal TcpCreateEndpointAfFailureArgs(Action<TcpCreateEndpointAfFailureArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (LocalAddressLength * 1) + 20));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (LocalAddressLength * 1) + 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpCreateEndpointAfFailureArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "LocalAddressLength", LocalAddressLength);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "ProcessId", ProcessId);
            XmlAttrib(sb, "CompartmentId", CompartmentId);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "LocalAddressLength", "LocalAddress", "Status", "ProcessId", "CompartmentId", "AddressFamily" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return LocalAddressLength;
                case 1:
                    return Status;
                case 2:
                    return ProcessId;
                case 3:
                    return CompartmentId;
                case 4:
                    return AddressFamily;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpCreateEndpointAfFailureArgs> m_target;
        #endregion
    }
    public sealed class TcpCreateNotificationChannelRequestArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public Address NcmContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int State { get { return GetInt32At(HostOffset(8, 2)); } }
        public int Pid { get { return GetInt32At(HostOffset(12, 2)); } }
        public int IsLoopback { get { return GetInt32At(HostOffset(16, 2)); } }
        public int ChannelStatus { get { return GetInt32At(HostOffset(20, 2)); } }
        public int Status { get { return GetInt32At(HostOffset(24, 2)); } }

        #region Private
        internal TcpCreateNotificationChannelRequestArgs(Action<TcpCreateNotificationChannelRequestArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpCreateNotificationChannelRequestArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttribHex(sb, "NcmContext", NcmContext);
            XmlAttrib(sb, "State", State);
            XmlAttrib(sb, "Pid", Pid);
            XmlAttrib(sb, "IsLoopback", IsLoopback);
            XmlAttrib(sb, "ChannelStatus", ChannelStatus);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "NcmContext", "State", "Pid", "IsLoopback", "ChannelStatus", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return NcmContext;
                case 2:
                    return State;
                case 3:
                    return Pid;
                case 4:
                    return IsLoopback;
                case 5:
                    return ChannelStatus;
                case 6:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpCreateNotificationChannelRequestArgs> m_target;
        #endregion
    }
    public sealed class TcpCreateNotificationChannelRequestProcessedArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public Address NcmContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int Pid { get { return GetInt32At(HostOffset(8, 2)); } }
        public int Status { get { return GetInt32At(HostOffset(12, 2)); } }
        public Guid PushNotificationGuid { get { return GetGuidAt(HostOffset(16, 2)); } }

        #region Private
        internal TcpCreateNotificationChannelRequestProcessedArgs(Action<TcpCreateNotificationChannelRequestProcessedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(32, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(32, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpCreateNotificationChannelRequestProcessedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttribHex(sb, "NcmContext", NcmContext);
            XmlAttrib(sb, "Pid", Pid);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "PushNotificationGuid", PushNotificationGuid);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "NcmContext", "Pid", "Status", "PushNotificationGuid" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return NcmContext;
                case 2:
                    return Pid;
                case 3:
                    return Status;
                case 4:
                    return PushNotificationGuid;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpCreateNotificationChannelRequestProcessedArgs> m_target;
        #endregion
    }
    public sealed class TcpCreateNotificationChannelRequestProcessingArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int IsRedirected { get { return GetInt32At(HostOffset(4, 1)); } }
        public int WfpFailure { get { return GetInt32At(HostOffset(8, 1)); } }
        public int Status { get { return GetInt32At(HostOffset(12, 1)); } }
        public int WaitStatus { get { return GetInt32At(HostOffset(16, 1)); } }
        public int IpAddrLength { get { return GetInt32At(HostOffset(20, 1)); } }
        public int LocalIPv4Address { get { return GetInt32At(HostOffset(24, 1)); } }
        public byte[] LocalIPv6Address { get { return GetByteArrayAt(HostOffset(28, 1), IpAddrLength); } }
        public int IPProtocol { get { return GetInt32At(HostOffset(0 + (IpAddrLength * 1) + 28, 1)); } }
        public int RemoteIPv4Address { get { return GetInt32At(HostOffset(0 + (IpAddrLength * 1) + 32, 1)); } }
        public byte[] RemoteIPv6Address { get { return GetByteArrayAt(HostOffset(0 + (IpAddrLength * 1) + 36, 1), IpAddrLength); } }
        public int SrcPort { get { return GetInt16At(HostOffset(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + 36, 1)); } }
        public int DestPort { get { return GetInt16At(HostOffset(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + 38, 1)); } }

        #region Private
        internal TcpCreateNotificationChannelRequestProcessingArgs(Action<TcpCreateNotificationChannelRequestProcessingArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + 40, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (IpAddrLength * 1) + (IpAddrLength * 1) + 40, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpCreateNotificationChannelRequestProcessingArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "IsRedirected", IsRedirected);
            XmlAttrib(sb, "WfpFailure", WfpFailure);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "WaitStatus", WaitStatus);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "LocalIPv4Address", LocalIPv4Address);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            XmlAttrib(sb, "RemoteIPv4Address", RemoteIPv4Address);
            XmlAttrib(sb, "SrcPort", SrcPort);
            XmlAttrib(sb, "DestPort", DestPort);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "IsRedirected", "WfpFailure", "Status", "WaitStatus", "IpAddrLength", "LocalIPv4Address", "LocalIPv6Address", "IPProtocol", "RemoteIPv4Address", "RemoteIPv6Address", "SrcPort", "DestPort" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return IsRedirected;
                case 2:
                    return WfpFailure;
                case 3:
                    return Status;
                case 4:
                    return WaitStatus;
                case 5:
                    return IpAddrLength;
                case 6:
                    return LocalIPv4Address;
                case 7:
                    return IPProtocol;
                case 8:
                    return RemoteIPv4Address;
                case 9:
                    return SrcPort;
                case 10:
                    return DestPort;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpCreateNotificationChannelRequestProcessingArgs> m_target;
        #endregion
    }
    public sealed class TcpCTcpAssignedBlocksArgs : TraceEvent
    {
        public int AssignedBlocks { get { return GetInt32At(0); } }
        public int AllocatedBlocks { get { return GetInt32At(4); } }

        #region Private
        internal TcpCTcpAssignedBlocksArgs(Action<TcpCTcpAssignedBlocksArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpCTcpAssignedBlocksArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AssignedBlocks", AssignedBlocks);
            XmlAttrib(sb, "AllocatedBlocks", AllocatedBlocks);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AssignedBlocks", "AllocatedBlocks" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AssignedBlocks;
                case 1:
                    return AllocatedBlocks;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpCTcpAssignedBlocksArgs> m_target;
        #endregion
    }
    public sealed class TcpCTcpCongestionWndwArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int DWnd { get { return GetInt32At(HostOffset(4, 1)); } }
        public int PrevDWnd { get { return GetInt32At(HostOffset(8, 1)); } }
        public int BaseRtt { get { return GetInt32At(HostOffset(12, 1)); } }
        public int AvgRtt { get { return GetInt32At(HostOffset(16, 1)); } }
        public int Cwnd { get { return GetInt32At(HostOffset(20, 1)); } }
        public int DiffWnd { get { return GetInt32At(HostOffset(24, 1)); } }
        public int DwndIncrement { get { return GetInt32At(HostOffset(28, 1)); } }

        #region Private
        internal TcpCTcpCongestionWndwArgs(Action<TcpCTcpCongestionWndwArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(32, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(32, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpCTcpCongestionWndwArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "DWnd", DWnd);
            XmlAttrib(sb, "PrevDWnd", PrevDWnd);
            XmlAttrib(sb, "BaseRtt", BaseRtt);
            XmlAttrib(sb, "AvgRtt", AvgRtt);
            XmlAttrib(sb, "Cwnd", Cwnd);
            XmlAttrib(sb, "DiffWnd", DiffWnd);
            XmlAttrib(sb, "DwndIncrement", DwndIncrement);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "DWnd", "PrevDWnd", "BaseRtt", "AvgRtt", "Cwnd", "DiffWnd", "DwndIncrement" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return DWnd;
                case 2:
                    return PrevDWnd;
                case 3:
                    return BaseRtt;
                case 4:
                    return AvgRtt;
                case 5:
                    return Cwnd;
                case 6:
                    return DiffWnd;
                case 7:
                    return DwndIncrement;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpCTcpCongestionWndwArgs> m_target;
        #endregion
    }
    public sealed class TcpDataTransferCumAck1330Args : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int Cwnd { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SndWnd { get { return GetInt32At(HostOffset(8, 1)); } }
        public int BytesAcked { get { return GetInt32At(HostOffset(12, 1)); } }
        public int SeqNo { get { return GetInt32At(HostOffset(16, 1)); } }

        #region Private
        internal TcpDataTransferCumAck1330Args(Action<TcpDataTransferCumAck1330Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(20, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferCumAck1330Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Cwnd", Cwnd);
            XmlAttrib(sb, "SndWnd", SndWnd);
            XmlAttrib(sb, "BytesAcked", BytesAcked);
            XmlAttrib(sb, "SeqNo", SeqNo);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Cwnd", "SndWnd", "BytesAcked", "SeqNo" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Cwnd;
                case 2:
                    return SndWnd;
                case 3:
                    return BytesAcked;
                case 4:
                    return SeqNo;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferCumAck1330Args> m_target;
        #endregion
    }
    public sealed class TcpDataTransferDupAck1343Args : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int Cwnd { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SSThresh { get { return GetInt32At(HostOffset(8, 1)); } }
        public int DupAckCount { get { return GetInt32At(HostOffset(12, 1)); } }
        public int SeqNo { get { return GetInt32At(HostOffset(16, 1)); } }

        #region Private
        internal TcpDataTransferDupAck1343Args(Action<TcpDataTransferDupAck1343Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(20, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferDupAck1343Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Cwnd", Cwnd);
            XmlAttrib(sb, "SSThresh", SSThresh);
            XmlAttrib(sb, "DupAckCount", DupAckCount);
            XmlAttrib(sb, "SeqNo", SeqNo);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Cwnd", "SSThresh", "DupAckCount", "SeqNo" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Cwnd;
                case 2:
                    return SSThresh;
                case 3:
                    return DupAckCount;
                case 4:
                    return SeqNo;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferDupAck1343Args> m_target;
        #endregion
    }
    public sealed class TcpDataTransferEcnArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int Cwnd { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SSThresh { get { return GetInt32At(HostOffset(8, 1)); } }
        public int SndUna { get { return GetInt32At(HostOffset(12, 1)); } }
        public int Mss { get { return GetInt32At(HostOffset(16, 1)); } }
        public int ThAck { get { return GetInt32At(HostOffset(20, 1)); } }
        public int DWnd { get { return GetInt32At(HostOffset(24, 1)); } }
        public int BaseRtt { get { return GetInt32At(HostOffset(28, 1)); } }

        #region Private
        internal TcpDataTransferEcnArgs(Action<TcpDataTransferEcnArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(32, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(32, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferEcnArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Cwnd", Cwnd);
            XmlAttrib(sb, "SSThresh", SSThresh);
            XmlAttrib(sb, "SndUna", SndUna);
            XmlAttrib(sb, "Mss", Mss);
            XmlAttrib(sb, "ThAck", ThAck);
            XmlAttrib(sb, "DWnd", DWnd);
            XmlAttrib(sb, "BaseRtt", BaseRtt);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Cwnd", "SSThresh", "SndUna", "Mss", "ThAck", "DWnd", "BaseRtt" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Cwnd;
                case 2:
                    return SSThresh;
                case 3:
                    return SndUna;
                case 4:
                    return Mss;
                case 5:
                    return ThAck;
                case 6:
                    return DWnd;
                case 7:
                    return BaseRtt;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferEcnArgs> m_target;
        #endregion
    }
    public sealed class TcpDataTransferSend1332Args : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int Cwnd { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SndWnd { get { return GetInt32At(HostOffset(8, 1)); } }
        public int BytesSent { get { return GetInt32At(HostOffset(12, 1)); } }
        public int SeqNo { get { return GetInt32At(HostOffset(16, 1)); } }
        public int SRtt { get { return GetInt32At(HostOffset(20, 1)); } }
        public int RttVar { get { return GetInt32At(HostOffset(24, 1)); } }
        public int RTO { get { return GetInt32At(HostOffset(28, 1)); } }

        #region Private
        internal TcpDataTransferSend1332Args(Action<TcpDataTransferSend1332Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(32, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(32, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferSend1332Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Cwnd", Cwnd);
            XmlAttrib(sb, "SndWnd", SndWnd);
            XmlAttrib(sb, "BytesSent", BytesSent);
            XmlAttrib(sb, "SeqNo", SeqNo);
            XmlAttrib(sb, "SRtt", SRtt);
            XmlAttrib(sb, "RttVar", RttVar);
            XmlAttrib(sb, "RTO", RTO);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Cwnd", "SndWnd", "BytesSent", "SeqNo", "SRtt", "RttVar", "RTO" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Cwnd;
                case 2:
                    return SndWnd;
                case 3:
                    return BytesSent;
                case 4:
                    return SeqNo;
                case 5:
                    return SRtt;
                case 6:
                    return RttVar;
                case 7:
                    return RTO;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferSend1332Args> m_target;
        #endregion
    }
    public sealed class TcpCtcpDataTransferTimeout1348Args : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int Cwnd { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SSThresh { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal TcpCtcpDataTransferTimeout1348Args(Action<TcpCtcpDataTransferTimeout1348Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpCtcpDataTransferTimeout1348Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Cwnd", Cwnd);
            XmlAttrib(sb, "SSThresh", SSThresh);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Cwnd", "SSThresh" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Cwnd;
                case 2:
                    return SSThresh;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpCtcpDataTransferTimeout1348Args> m_target;
        #endregion
    }
    public sealed class TcpCTcpGammaArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int Gamma { get { return GetInt32At(HostOffset(4, 1)); } }
        public int AverageBacklog { get { return GetInt32At(HostOffset(8, 1)); } }
        public int AverageBacklogAcrossLFP { get { return GetInt32At(HostOffset(12, 1)); } }

        #region Private
        internal TcpCTcpGammaArgs(Action<TcpCTcpGammaArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpCTcpGammaArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Gamma", Gamma);
            XmlAttrib(sb, "AverageBacklog", AverageBacklog);
            XmlAttrib(sb, "AverageBacklogAcrossLFP", AverageBacklogAcrossLFP);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Gamma", "AverageBacklog", "AverageBacklogAcrossLFP" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Gamma;
                case 2:
                    return AverageBacklog;
                case 3:
                    return AverageBacklogAcrossLFP;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpCTcpGammaArgs> m_target;
        #endregion
    }
    public sealed class TcpCwndRestartArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int OldCwnd { get { return GetInt32At(HostOffset(4, 1)); } }
        public int NewCwnd { get { return GetInt32At(HostOffset(8, 1)); } }
        public int Processor { get { return GetInt32At(HostOffset(12, 1)); } }
        public int CurrentTick { get { return GetInt32At(HostOffset(16, 1)); } }
        public int IdleTick { get { return GetInt32At(HostOffset(20, 1)); } }
        public int Rto { get { return GetInt32At(HostOffset(24, 1)); } }

        #region Private
        internal TcpCwndRestartArgs(Action<TcpCwndRestartArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpCwndRestartArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "OldCwnd", OldCwnd);
            XmlAttrib(sb, "NewCwnd", NewCwnd);
            XmlAttrib(sb, "Processor", Processor);
            XmlAttrib(sb, "CurrentTick", CurrentTick);
            XmlAttrib(sb, "IdleTick", IdleTick);
            XmlAttrib(sb, "Rto", Rto);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "OldCwnd", "NewCwnd", "Processor", "CurrentTick", "IdleTick", "Rto" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return OldCwnd;
                case 2:
                    return NewCwnd;
                case 3:
                    return Processor;
                case 4:
                    return CurrentTick;
                case 5:
                    return IdleTick;
                case 6:
                    return Rto;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpCwndRestartArgs> m_target;
        #endregion
    }
    public sealed class TcpDataTransferEcnAlphaArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int SndRound { get { return GetInt32At(HostOffset(4, 1)); } }
        public int EcnTotalByteCount { get { return GetInt32At(HostOffset(8, 1)); } }
        public int EcnTotalMarkedCount { get { return GetInt32At(HostOffset(12, 1)); } }
        public int ThAck { get { return GetInt32At(HostOffset(16, 1)); } }
        public int EcnAlpha { get { return GetInt32At(HostOffset(20, 1)); } }

        #region Private
        internal TcpDataTransferEcnAlphaArgs(Action<TcpDataTransferEcnAlphaArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(24, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(24, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferEcnAlphaArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SndRound", SndRound);
            XmlAttrib(sb, "EcnTotalByteCount", EcnTotalByteCount);
            XmlAttrib(sb, "EcnTotalMarkedCount", EcnTotalMarkedCount);
            XmlAttrib(sb, "ThAck", ThAck);
            XmlAttrib(sb, "EcnAlpha", EcnAlpha);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SndRound", "EcnTotalByteCount", "EcnTotalMarkedCount", "ThAck", "EcnAlpha" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SndRound;
                case 2:
                    return EcnTotalByteCount;
                case 3:
                    return EcnTotalMarkedCount;
                case 4:
                    return ThAck;
                case 5:
                    return EcnAlpha;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferEcnAlphaArgs> m_target;
        #endregion
    }
    public sealed class TcpDataTransferReceiveArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int NumBytes { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SeqNo { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal TcpDataTransferReceiveArgs(Action<TcpDataTransferReceiveArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferReceiveArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "NumBytes", NumBytes);
            XmlAttrib(sb, "SeqNo", SeqNo);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "NumBytes", "SeqNo" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return NumBytes;
                case 2:
                    return SeqNo;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferReceiveArgs> m_target;
        #endregion
    }
    public sealed class TcpDataTransferRetransmitRound1351Args : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int SndUna { get { return GetInt32At(HostOffset(4, 1)); } }
        public int RexmitCount { get { return GetInt32At(HostOffset(8, 1)); } }
        public int SRTT { get { return GetInt32At(HostOffset(12, 1)); } }
        public int RTO { get { return GetInt32At(HostOffset(16, 1)); } }

        #region Private
        internal TcpDataTransferRetransmitRound1351Args(Action<TcpDataTransferRetransmitRound1351Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(20, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferRetransmitRound1351Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SndUna", SndUna);
            XmlAttrib(sb, "RexmitCount", RexmitCount);
            XmlAttrib(sb, "SRTT", SRTT);
            XmlAttrib(sb, "RTO", RTO);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SndUna", "RexmitCount", "SRTT", "RTO" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SndUna;
                case 2:
                    return RexmitCount;
                case 3:
                    return SRTT;
                case 4:
                    return RTO;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferRetransmitRound1351Args> m_target;
        #endregion
    }
    public sealed class TcpDataTransferRttSample1341Args : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int RttSample { get { return GetInt32At(HostOffset(4, 1)); } }
        public int RttVar { get { return GetInt32At(HostOffset(8, 1)); } }
        public int SRTT { get { return GetInt32At(HostOffset(12, 1)); } }

        #region Private
        internal TcpDataTransferRttSample1341Args(Action<TcpDataTransferRttSample1341Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferRttSample1341Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "RttSample", RttSample);
            XmlAttrib(sb, "RttVar", RttVar);
            XmlAttrib(sb, "SRTT", SRTT);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "RttSample", "RttVar", "SRTT" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return RttSample;
                case 2:
                    return RttVar;
                case 3:
                    return SRTT;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferRttSample1341Args> m_target;
        #endregion
    }
    public sealed class TcpDataTransferSpuriousTimeout1345Args : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int SeqNo { get { return GetInt32At(HostOffset(4, 1)); } }

        #region Private
        internal TcpDataTransferSpuriousTimeout1345Args(Action<TcpDataTransferSpuriousTimeout1345Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDataTransferSpuriousTimeout1345Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SeqNo", SeqNo);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SeqNo" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SeqNo;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDataTransferSpuriousTimeout1345Args> m_target;
        #endregion
    }
    public sealed class TcpDisconnectTcbInjectFailedArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public Address Delivery { get { return GetAddressAt(HostOffset(4, 1)); } }
        public Address Request { get { return GetAddressAt(HostOffset(8, 2)); } }
        public Address NumBytes { get { return GetAddressAt(HostOffset(12, 3)); } }
        public int RequestFlags { get { return GetInt32At(HostOffset(16, 4)); } }
        public Address Length { get { return GetAddressAt(HostOffset(20, 4)); } }
        public int RequestStatus { get { return GetInt32At(HostOffset(24, 5)); } }
        public int IsUrgentDelivery { get { return GetInt32At(HostOffset(28, 5)); } }
        public int FullySatisfiedORDelayedPush { get { return GetInt32At(HostOffset(32, 5)); } }
        public int RcvNxt { get { return GetInt32At(HostOffset(36, 5)); } }

        #region Private
        internal TcpDisconnectTcbInjectFailedArgs(Action<TcpDisconnectTcbInjectFailedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(40, 5)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(40, 5)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDisconnectTcbInjectFailedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttribHex(sb, "Delivery", Delivery);
            XmlAttribHex(sb, "Request", Request);
            XmlAttribHex(sb, "NumBytes", NumBytes);
            XmlAttrib(sb, "RequestFlags", RequestFlags);
            XmlAttribHex(sb, "Length", Length);
            XmlAttrib(sb, "RequestStatus", RequestStatus);
            XmlAttrib(sb, "IsUrgentDelivery", IsUrgentDelivery);
            XmlAttrib(sb, "FullySatisfiedORDelayedPush", FullySatisfiedORDelayedPush);
            XmlAttrib(sb, "RcvNxt", RcvNxt);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Delivery", "Request", "NumBytes", "RequestFlags", "Length", "RequestStatus", "IsUrgentDelivery", "FullySatisfiedORDelayedPush", "RcvNxt" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Delivery;
                case 2:
                    return Request;
                case 3:
                    return NumBytes;
                case 4:
                    return RequestFlags;
                case 5:
                    return Length;
                case 6:
                    return RequestStatus;
                case 7:
                    return IsUrgentDelivery;
                case 8:
                    return FullySatisfiedORDelayedPush;
                case 9:
                    return RcvNxt;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDisconnectTcbInjectFailedArgs> m_target;
        #endregion
    }
    public sealed class TcpDeliveryStateChangeArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public Address Delivery { get { return GetAddressAt(HostOffset(4, 1)); } }
        public TCPIP_TCP_DELIVERY_STATE OldDeliveryState { get { return (TCPIP_TCP_DELIVERY_STATE)GetInt32At(HostOffset(8, 2)); } }
        public int NewDeliveryState { get { return GetInt32At(HostOffset(12, 2)); } }

        #region Private
        internal TcpDeliveryStateChangeArgs(Action<TcpDeliveryStateChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDeliveryStateChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttribHex(sb, "Delivery", Delivery);
            XmlAttrib(sb, "OldDeliveryState", OldDeliveryState);
            XmlAttrib(sb, "NewDeliveryState", NewDeliveryState);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Delivery", "OldDeliveryState", "NewDeliveryState" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Delivery;
                case 2:
                    return OldDeliveryState;
                case 3:
                    return NewDeliveryState;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDeliveryStateChangeArgs> m_target;
        #endregion
    }
    public sealed class TcpPlumbWakePatternArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int SystemReserved { get { return GetInt32At(HostOffset(4, 1)); } }
        public int WolHandle { get { return GetInt32At(HostOffset(8, 1)); } }
        public int Status { get { return GetInt32At(HostOffset(12, 1)); } }

        #region Private
        internal TcpPlumbWakePatternArgs(Action<TcpPlumbWakePatternArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpPlumbWakePatternArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SystemReserved", SystemReserved);
            XmlAttrib(sb, "WolHandle", WolHandle);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SystemReserved", "WolHandle", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SystemReserved;
                case 2:
                    return WolHandle;
                case 3:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpPlumbWakePatternArgs> m_target;
        #endregion
    }
    public sealed class TcpDisconnectTcbRequestArgs : TraceEvent
    {
        public Address Length { get { return GetAddressAt(0); } }
        public long Timeout { get { return GetInt64At(HostOffset(4, 1)); } }
        public string Injected { get { return GetUnicodeStringAt(HostOffset(12, 1)); } }

        #region Private
        internal TcpDisconnectTcbRequestArgs(Action<TcpDisconnectTcbRequestArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(12, 1))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(12, 1))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpDisconnectTcbRequestArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Length", Length);
            XmlAttrib(sb, "Timeout", Timeout);
            XmlAttrib(sb, "Injected", Injected);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Length", "Timeout", "Injected" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Length;
                case 1:
                    return Timeout;
                case 2:
                    return Injected;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpDisconnectTcbRequestArgs> m_target;
        #endregion
    }
    public sealed class TcpEndpointAcquirePortReservationArgs : TraceEvent
    {
        public int ProcessId { get { return GetInt32At(0); } }
        public int Status { get { return GetInt32At(4); } }
        public int StartPort { get { return GetInt16At(8); } }
        public int NumberOfPorts { get { return GetInt16At(10); } }

        #region Private
        internal TcpEndpointAcquirePortReservationArgs(Action<TcpEndpointAcquirePortReservationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 12));
            Debug.Assert(!(Version > 0 && EventDataLength < 12));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpEndpointAcquirePortReservationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ProcessId", ProcessId);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "StartPort", StartPort);
            XmlAttrib(sb, "NumberOfPorts", NumberOfPorts);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ProcessId", "Status", "StartPort", "NumberOfPorts" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ProcessId;
                case 1:
                    return Status;
                case 2:
                    return StartPort;
                case 3:
                    return NumberOfPorts;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpEndpointAcquirePortReservationArgs> m_target;
        #endregion
    }
    public sealed class TcpEndpointCreationArgs : TraceEvent
    {
        public int Status { get { return GetInt32At(0); } }
        public Address Endpoint { get { return GetAddressAt(4); } }
        public TCPIP_ADDRESS_FAMILY_TYPE AddressFamily { get { return (TCPIP_ADDRESS_FAMILY_TYPE)GetInt32At(HostOffset(8, 1)); } }
        public int Pid { get { return GetInt32At(HostOffset(12, 1)); } }

        #region Private
        internal TcpEndpointCreationArgs(Action<TcpEndpointCreationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpEndpointCreationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Status", Status);
            XmlAttribHex(sb, "Endpoint", Endpoint);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            XmlAttrib(sb, "Pid", Pid);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Status", "Endpoint", "AddressFamily", "Pid" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Status;
                case 1:
                    return Endpoint;
                case 2:
                    return AddressFamily;
                case 3:
                    return Pid;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpEndpointCreationArgs> m_target;
        #endregion
    }
    public sealed class TcpGlobalAddInterfaceArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public int AddressFamily { get { return GetInt32At(4); } }

        #region Private
        internal TcpGlobalAddInterfaceArgs(Action<TcpGlobalAddInterfaceArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpGlobalAddInterfaceArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "AddressFamily" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return AddressFamily;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpGlobalAddInterfaceArgs> m_target;
        #endregion
    }
    public sealed class TcpSecurityRateLimitArgs : TraceEvent
    {
        public int SynAttacksDetected { get { return GetInt32At(0); } }
        public int ReassemblyLimitViolations { get { return GetInt32At(4); } }
        public int ConnectionRateLimitBacklog { get { return GetInt32At(8); } }
        public int ConnectionRateLimitViolations { get { return GetInt32At(12); } }
        public int LandAttackSegmentsDropped { get { return GetInt32At(16); } }
        public int ConnectionRateLimitDepth { get { return GetInt32At(20); } }

        #region Private
        internal TcpSecurityRateLimitArgs(Action<TcpSecurityRateLimitArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpSecurityRateLimitArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SynAttacksDetected", SynAttacksDetected);
            XmlAttrib(sb, "ReassemblyLimitViolations", ReassemblyLimitViolations);
            XmlAttrib(sb, "ConnectionRateLimitBacklog", ConnectionRateLimitBacklog);
            XmlAttrib(sb, "ConnectionRateLimitViolations", ConnectionRateLimitViolations);
            XmlAttrib(sb, "LandAttackSegmentsDropped", LandAttackSegmentsDropped);
            XmlAttrib(sb, "ConnectionRateLimitDepth", ConnectionRateLimitDepth);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SynAttacksDetected", "ReassemblyLimitViolations", "ConnectionRateLimitBacklog", "ConnectionRateLimitViolations", "LandAttackSegmentsDropped", "ConnectionRateLimitDepth" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SynAttacksDetected;
                case 1:
                    return ReassemblyLimitViolations;
                case 2:
                    return ConnectionRateLimitBacklog;
                case 3:
                    return ConnectionRateLimitViolations;
                case 4:
                    return LandAttackSegmentsDropped;
                case 5:
                    return ConnectionRateLimitDepth;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpSecurityRateLimitArgs> m_target;
        #endregion
    }
    public sealed class TcpGlobalIsbBeginThrottleArgs : TraceEvent
    {
        public int HighMemoryEvent { get { return GetInt32At(0); } }
        public int HighPagedPoolEvent { get { return GetInt32At(4); } }
        public int LowMemoryEvent { get { return GetInt32At(8); } }
        public int LowPagedPoolEvent { get { return GetInt32At(12); } }

        #region Private
        internal TcpGlobalIsbBeginThrottleArgs(Action<TcpGlobalIsbBeginThrottleArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpGlobalIsbBeginThrottleArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "HighMemoryEvent", HighMemoryEvent);
            XmlAttrib(sb, "HighPagedPoolEvent", HighPagedPoolEvent);
            XmlAttrib(sb, "LowMemoryEvent", LowMemoryEvent);
            XmlAttrib(sb, "LowPagedPoolEvent", LowPagedPoolEvent);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "HighMemoryEvent", "HighPagedPoolEvent", "LowMemoryEvent", "LowPagedPoolEvent" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return HighMemoryEvent;
                case 1:
                    return HighPagedPoolEvent;
                case 2:
                    return LowMemoryEvent;
                case 3:
                    return LowPagedPoolEvent;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpGlobalIsbBeginThrottleArgs> m_target;
        #endregion
    }
    public sealed class TcpGlobalParametersArgs : TraceEvent
    {
        public int AddressFamily { get { return GetInt32At(0); } }
        public int EnablePMTUDiscovery { get { return GetByteAt(4); } }
        public int TcpUseRFC1122UrgentPointer { get { return GetByteAt(5); } }
        public int DisableTaskOffload { get { return GetByteAt(6); } }
        public int EnablePMTUBHDetect { get { return GetByteAt(7); } }
        public int DisableTcpChimneyOffload { get { return GetByteAt(8); } }
        public int DisableRss { get { return GetByteAt(9); } }
        public int EcnCapability { get { return GetByteAt(10); } }
        public int TcpMaxDataRetransmissions { get { return GetByteAt(11); } }
        public int KeepAliveTime { get { return GetInt32At(12); } }
        public int KeepAliveInterval { get { return GetInt32At(16); } }
        public int TcpTimedWaitDelay { get { return GetInt32At(20); } }
        public int SillyWindowTimeout { get { return GetInt32At(24); } }
        public int TcpFinWait2Delay { get { return GetInt32At(28); } }
        public int CongestionAlgorithm { get { return GetByteAt(32); } }
        public int Tcp1323Opts { get { return GetByteAt(33); } }
        public int AutoTuningLevelLocal { get { return GetInt32At(34); } }
        public int AutoTuningLevelGroupPolicy { get { return GetInt32At(38); } }

        #region Private
        internal TcpGlobalParametersArgs(Action<TcpGlobalParametersArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 42));
            Debug.Assert(!(Version > 0 && EventDataLength < 42));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpGlobalParametersArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            XmlAttrib(sb, "EnablePMTUDiscovery", EnablePMTUDiscovery);
            XmlAttrib(sb, "TcpUseRFC1122UrgentPointer", TcpUseRFC1122UrgentPointer);
            XmlAttrib(sb, "DisableTaskOffload", DisableTaskOffload);
            XmlAttrib(sb, "EnablePMTUBHDetect", EnablePMTUBHDetect);
            XmlAttrib(sb, "DisableTcpChimneyOffload", DisableTcpChimneyOffload);
            XmlAttrib(sb, "DisableRss", DisableRss);
            XmlAttrib(sb, "EcnCapability", EcnCapability);
            XmlAttrib(sb, "TcpMaxDataRetransmissions", TcpMaxDataRetransmissions);
            XmlAttrib(sb, "KeepAliveTime", KeepAliveTime);
            XmlAttrib(sb, "KeepAliveInterval", KeepAliveInterval);
            XmlAttrib(sb, "TcpTimedWaitDelay", TcpTimedWaitDelay);
            XmlAttrib(sb, "SillyWindowTimeout", SillyWindowTimeout);
            XmlAttrib(sb, "TcpFinWait2Delay", TcpFinWait2Delay);
            XmlAttrib(sb, "CongestionAlgorithm", CongestionAlgorithm);
            XmlAttrib(sb, "Tcp1323Opts", Tcp1323Opts);
            XmlAttrib(sb, "AutoTuningLevelLocal", AutoTuningLevelLocal);
            XmlAttrib(sb, "AutoTuningLevelGroupPolicy", AutoTuningLevelGroupPolicy);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AddressFamily", "EnablePMTUDiscovery", "TcpUseRFC1122UrgentPointer", "DisableTaskOffload", "EnablePMTUBHDetect", "DisableTcpChimneyOffload", "DisableRss", "EcnCapability", "TcpMaxDataRetransmissions", "KeepAliveTime", "KeepAliveInterval", "TcpTimedWaitDelay", "SillyWindowTimeout", "TcpFinWait2Delay", "CongestionAlgorithm", "Tcp1323Opts", "AutoTuningLevelLocal", "AutoTuningLevelGroupPolicy" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AddressFamily;
                case 1:
                    return EnablePMTUDiscovery;
                case 2:
                    return TcpUseRFC1122UrgentPointer;
                case 3:
                    return DisableTaskOffload;
                case 4:
                    return EnablePMTUBHDetect;
                case 5:
                    return DisableTcpChimneyOffload;
                case 6:
                    return DisableRss;
                case 7:
                    return EcnCapability;
                case 8:
                    return TcpMaxDataRetransmissions;
                case 9:
                    return KeepAliveTime;
                case 10:
                    return KeepAliveInterval;
                case 11:
                    return TcpTimedWaitDelay;
                case 12:
                    return SillyWindowTimeout;
                case 13:
                    return TcpFinWait2Delay;
                case 14:
                    return CongestionAlgorithm;
                case 15:
                    return Tcp1323Opts;
                case 16:
                    return AutoTuningLevelLocal;
                case 17:
                    return AutoTuningLevelGroupPolicy;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpGlobalParametersArgs> m_target;
        #endregion
    }
    public sealed class TcpInterfaceRscStateChangeArgs : TraceEvent
    {
        public int IfIndex { get { return GetInt32At(0); } }
        public TCPIP_PROPERTY StateV4 { get { return (TCPIP_PROPERTY)GetInt32At(4); } }
        public int FailureReasonV4 { get { return GetInt32At(8); } }
        public int StateV6 { get { return GetInt32At(12); } }
        public TCPIP_OFFLOAD_FAILURE_REASON FailureReasonV6 { get { return (TCPIP_OFFLOAD_FAILURE_REASON)GetInt32At(16); } }

        #region Private
        internal TcpInterfaceRscStateChangeArgs(Action<TcpInterfaceRscStateChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 20));
            Debug.Assert(!(Version > 0 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpInterfaceRscStateChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IfIndex", IfIndex);
            XmlAttrib(sb, "StateV4", StateV4);
            XmlAttrib(sb, "FailureReasonV4", FailureReasonV4);
            XmlAttrib(sb, "StateV6", StateV6);
            XmlAttrib(sb, "FailureReasonV6", FailureReasonV6);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IfIndex", "StateV4", "FailureReasonV4", "StateV6", "FailureReasonV6" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IfIndex;
                case 1:
                    return StateV4;
                case 2:
                    return FailureReasonV4;
                case 3:
                    return StateV6;
                case 4:
                    return FailureReasonV6;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpInterfaceRscStateChangeArgs> m_target;
        #endregion
    }
    public sealed class TcpipAoacFailFastArgs : TraceEvent
    {
        public int RequestType { get { return GetInt32At(0); } }
        public Address TcbOrEndpoint { get { return GetAddressAt(4); } }
        public int LocalAddressLength { get { return GetInt32At(HostOffset(8, 1)); } }
        public byte[] LocalAddress { get { return GetByteArrayAt(HostOffset(12, 1), LocalAddressLength); } }
        public int RemoteAddressLength { get { return GetInt32At(HostOffset(0 + (LocalAddressLength * 1) + 12, 1)); } }
        public byte[] RemoteAddress { get { return GetByteArrayAt(HostOffset(0 + (LocalAddressLength * 1) + 16, 1), RemoteAddressLength); } }
        public int Status { get { return GetInt32At(HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 16, 1)); } }
        public int ProcessId { get { return GetInt32At(HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 20, 1)); } }
        public int InterfaceIndex { get { return GetInt32At(HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 24, 1)); } }

        #region Private
        internal TcpipAoacFailFastArgs(Action<TcpipAoacFailFastArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 28, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (RemoteAddressLength * 1) + (LocalAddressLength * 1) + 28, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipAoacFailFastArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "RequestType", RequestType);
            XmlAttribHex(sb, "TcbOrEndpoint", TcbOrEndpoint);
            XmlAttrib(sb, "LocalAddressLength", LocalAddressLength);
            XmlAttrib(sb, "RemoteAddressLength", RemoteAddressLength);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "ProcessId", ProcessId);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "RequestType", "TcbOrEndpoint", "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "Status", "ProcessId", "InterfaceIndex" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return RequestType;
                case 1:
                    return TcbOrEndpoint;
                case 2:
                    return LocalAddressLength;
                case 3:
                    return RemoteAddressLength;
                case 4:
                    return Status;
                case 5:
                    return ProcessId;
                case 6:
                    return InterfaceIndex;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipAoacFailFastArgs> m_target;
        #endregion
    }
    public sealed class TcpipGenericArgs : TraceEvent
    {
        public string AllocationObjectString { get { return GetUnicodeStringAt(0); } }
        public Address Param1 { get { return GetAddressAt(SkipUnicodeString(0)); } }
        public Address Param2 { get { return GetAddressAt(HostOffset(SkipUnicodeString(0) + 4, 1)); } }
        public int Param3 { get { return GetInt32At(HostOffset(SkipUnicodeString(0) + 8, 2)); } }
        public int Param4 { get { return GetInt32At(HostOffset(SkipUnicodeString(0) + 12, 2)); } }

        #region Private
        internal TcpipGenericArgs(Action<TcpipGenericArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(SkipUnicodeString(0) + 16, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(SkipUnicodeString(0) + 16, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipGenericArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AllocationObjectString", AllocationObjectString);
            XmlAttribHex(sb, "Param1", Param1);
            XmlAttribHex(sb, "Param2", Param2);
            XmlAttrib(sb, "Param3", Param3);
            XmlAttrib(sb, "Param4", Param4);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AllocationObjectString", "Param1", "Param2", "Param3", "Param4" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AllocationObjectString;
                case 1:
                    return Param1;
                case 2:
                    return Param2;
                case 3:
                    return Param3;
                case 4:
                    return Param4;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipGenericArgs> m_target;
        #endregion
    }
    public sealed class TcpipNetworkPacketDropsArgs : TraceEvent
    {
        public int IPTransportProtocol { get { return GetInt32At(0); } }
        public int AddressFamily { get { return GetInt32At(4); } }
        public int SourceIPv4Address { get { return GetInt32At(8); } }
        public int DestIPv4Address { get { return GetInt32At(12); } }
        public int IPv6SourceIpAddrLength { get { return GetInt32At(16); } }
        public byte[] IPv6SourceAddress { get { return GetByteArrayAt(20, IPv6SourceIpAddrLength); } }
        public int IPv6DestIpAddrLength { get { return GetInt32At(0 + (IPv6SourceIpAddrLength * 1) + 20); } }
        public byte[] IPv6DestAddress { get { return GetByteArrayAt(0 + (IPv6SourceIpAddrLength * 1) + 24, IPv6DestIpAddrLength); } }
        public int Reason { get { return GetInt32At(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 24); } }
        public int PacketCount { get { return GetInt32At(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 28); } }
        public int IPProtocol { get { return GetInt32At(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 32); } }

        #region Private
        internal TcpipNetworkPacketDropsArgs(Action<TcpipNetworkPacketDropsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 36));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 36));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipNetworkPacketDropsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IPTransportProtocol", IPTransportProtocol);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            XmlAttrib(sb, "SourceIPv4Address", SourceIPv4Address);
            XmlAttrib(sb, "DestIPv4Address", DestIPv4Address);
            XmlAttrib(sb, "IPv6SourceIpAddrLength", IPv6SourceIpAddrLength);
            XmlAttrib(sb, "IPv6DestIpAddrLength", IPv6DestIpAddrLength);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "PacketCount", PacketCount);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IPTransportProtocol", "AddressFamily", "SourceIPv4Address", "DestIPv4Address", "IPv6SourceIpAddrLength", "IPv6SourceAddress", "IPv6DestIpAddrLength", "IPv6DestAddress", "Reason", "PacketCount", "IPProtocol" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IPTransportProtocol;
                case 1:
                    return AddressFamily;
                case 2:
                    return SourceIPv4Address;
                case 3:
                    return DestIPv4Address;
                case 4:
                    return IPv6SourceIpAddrLength;
                case 5:
                    return IPv6DestIpAddrLength;
                case 6:
                    return Reason;
                case 7:
                    return PacketCount;
                case 8:
                    return IPProtocol;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipNetworkPacketDropsArgs> m_target;
        #endregion
    }
    public sealed class TcpipPlumbWakePatternOnInterfaceArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public int AoAcCapable { get { return GetInt32At(4); } }
        public int BitmapPatternSupported { get { return GetInt32At(8); } }
        public int ARPNDOffloadSupported { get { return GetInt32At(12); } }
        public int IPAddressWakeReady { get { return GetInt32At(16); } }
        public int PatternPriority { get { return GetInt32At(20); } }
        public int PhysicalMediumType { get { return GetInt32At(24); } }
        public int IpAddrLength { get { return GetInt32At(28); } }
        public int IPv4Address { get { return GetInt32At(32); } }
        public byte[] IPv6Address { get { return GetByteArrayAt(36, IpAddrLength); } }
        public int IPProtocol { get { return GetInt32At(0 + (IpAddrLength * 1) + 36); } }
        public int Status { get { return GetInt32At(0 + (IpAddrLength * 1) + 40); } }

        #region Private
        internal TcpipPlumbWakePatternOnInterfaceArgs(Action<TcpipPlumbWakePatternOnInterfaceArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (IpAddrLength * 1) + 44));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (IpAddrLength * 1) + 44));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipPlumbWakePatternOnInterfaceArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "AoAcCapable", AoAcCapable);
            XmlAttrib(sb, "BitmapPatternSupported", BitmapPatternSupported);
            XmlAttrib(sb, "ARPNDOffloadSupported", ARPNDOffloadSupported);
            XmlAttrib(sb, "IPAddressWakeReady", IPAddressWakeReady);
            XmlAttrib(sb, "PatternPriority", PatternPriority);
            XmlAttrib(sb, "PhysicalMediumType", PhysicalMediumType);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "IPv4Address", IPv4Address);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "AoAcCapable", "BitmapPatternSupported", "ARPNDOffloadSupported", "IPAddressWakeReady", "PatternPriority", "PhysicalMediumType", "IpAddrLength", "IPv4Address", "IPv6Address", "IPProtocol", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return AoAcCapable;
                case 2:
                    return BitmapPatternSupported;
                case 3:
                    return ARPNDOffloadSupported;
                case 4:
                    return IPAddressWakeReady;
                case 5:
                    return PatternPriority;
                case 6:
                    return PhysicalMediumType;
                case 7:
                    return IpAddrLength;
                case 8:
                    return IPv4Address;
                case 9:
                    return IPProtocol;
                case 10:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipPlumbWakePatternOnInterfaceArgs> m_target;
        #endregion
    }
    public sealed class TcpipReceiveSlowPathArgs : TraceEvent
    {
        public Address Nbl { get { return GetAddressAt(0); } }
        public TCPIP_Transport_Protocol IPTransportProtocol { get { return (TCPIP_Transport_Protocol)GetInt32At(HostOffset(4, 1)); } }
        public int AddressFamily { get { return GetInt32At(HostOffset(8, 1)); } }
        public int SourceIPv4Address { get { return GetInt32At(HostOffset(12, 1)); } }
        public int DestIPv4Address { get { return GetInt32At(HostOffset(16, 1)); } }
        public int IPv6SourceIpAddrLength { get { return GetInt32At(HostOffset(20, 1)); } }
        public byte[] IPv6SourceAddress { get { return GetByteArrayAt(HostOffset(24, 1), IPv6SourceIpAddrLength); } }
        public int IPv6DestIpAddrLength { get { return GetInt32At(HostOffset(0 + (IPv6SourceIpAddrLength * 1) + 24, 1)); } }
        public byte[] IPv6DestAddress { get { return GetByteArrayAt(HostOffset(0 + (IPv6SourceIpAddrLength * 1) + 28, 1), IPv6DestIpAddrLength); } }
        public int Reason { get { return GetInt32At(HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 28, 1)); } }
        public int NblCount { get { return GetInt32At(HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 32, 1)); } }
        public int IPProtocol { get { return GetInt32At(HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 36, 1)); } }

        #region Private
        internal TcpipReceiveSlowPathArgs(Action<TcpipReceiveSlowPathArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 40, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 40, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipReceiveSlowPathArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Nbl", Nbl);
            XmlAttrib(sb, "IPTransportProtocol", IPTransportProtocol);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            XmlAttrib(sb, "SourceIPv4Address", SourceIPv4Address);
            XmlAttrib(sb, "DestIPv4Address", DestIPv4Address);
            XmlAttrib(sb, "IPv6SourceIpAddrLength", IPv6SourceIpAddrLength);
            XmlAttrib(sb, "IPv6DestIpAddrLength", IPv6DestIpAddrLength);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "NblCount", NblCount);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Nbl", "IPTransportProtocol", "AddressFamily", "SourceIPv4Address", "DestIPv4Address", "IPv6SourceIpAddrLength", "IPv6SourceAddress", "IPv6DestIpAddrLength", "IPv6DestAddress", "Reason", "NblCount", "IPProtocol" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Nbl;
                case 1:
                    return IPTransportProtocol;
                case 2:
                    return AddressFamily;
                case 3:
                    return SourceIPv4Address;
                case 4:
                    return DestIPv4Address;
                case 5:
                    return IPv6SourceIpAddrLength;
                case 6:
                    return IPv6DestIpAddrLength;
                case 7:
                    return Reason;
                case 8:
                    return NblCount;
                case 9:
                    return IPProtocol;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipReceiveSlowPathArgs> m_target;
        #endregion
    }
    public sealed class TcpipSendSlowPathArgs : TraceEvent
    {
        public Address Nbl { get { return GetAddressAt(0); } }
        public int IPTransportProtocol { get { return GetInt32At(HostOffset(4, 1)); } }
        public int AddressFamily { get { return GetInt32At(HostOffset(8, 1)); } }
        public int SourceIPv4Address { get { return GetInt32At(HostOffset(12, 1)); } }
        public int DestIPv4Address { get { return GetInt32At(HostOffset(16, 1)); } }
        public int IPv6SourceIpAddrLength { get { return GetInt32At(HostOffset(20, 1)); } }
        public byte[] IPv6SourceAddress { get { return GetByteArrayAt(HostOffset(24, 1), IPv6SourceIpAddrLength); } }
        public int IPv6DestIpAddrLength { get { return GetInt32At(HostOffset(0 + (IPv6SourceIpAddrLength * 1) + 24, 1)); } }
        public byte[] IPv6DestAddress { get { return GetByteArrayAt(HostOffset(0 + (IPv6SourceIpAddrLength * 1) + 28, 1), IPv6DestIpAddrLength); } }
        public TCPIP_SLOW_PATH_REASON Reason { get { return (TCPIP_SLOW_PATH_REASON)GetInt32At(HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 28, 1)); } }
        public int NblCount { get { return GetInt32At(HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 32, 1)); } }
        public int IPProtocol { get { return GetInt32At(HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 36, 1)); } }

        #region Private
        internal TcpipSendSlowPathArgs(Action<TcpipSendSlowPathArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 40, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (IPv6DestIpAddrLength * 1) + (IPv6SourceIpAddrLength * 1) + 40, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipSendSlowPathArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Nbl", Nbl);
            XmlAttrib(sb, "IPTransportProtocol", IPTransportProtocol);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            XmlAttrib(sb, "SourceIPv4Address", SourceIPv4Address);
            XmlAttrib(sb, "DestIPv4Address", DestIPv4Address);
            XmlAttrib(sb, "IPv6SourceIpAddrLength", IPv6SourceIpAddrLength);
            XmlAttrib(sb, "IPv6DestIpAddrLength", IPv6DestIpAddrLength);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "NblCount", NblCount);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Nbl", "IPTransportProtocol", "AddressFamily", "SourceIPv4Address", "DestIPv4Address", "IPv6SourceIpAddrLength", "IPv6SourceAddress", "IPv6DestIpAddrLength", "IPv6DestAddress", "Reason", "NblCount", "IPProtocol" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Nbl;
                case 1:
                    return IPTransportProtocol;
                case 2:
                    return AddressFamily;
                case 3:
                    return SourceIPv4Address;
                case 4:
                    return DestIPv4Address;
                case 5:
                    return IPv6SourceIpAddrLength;
                case 6:
                    return IPv6DestIpAddrLength;
                case 7:
                    return Reason;
                case 8:
                    return NblCount;
                case 9:
                    return IPProtocol;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipSendSlowPathArgs> m_target;
        #endregion
    }
    public sealed class TcpipSilentModeArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public TCPIP_SILENT_MODE_EVENT SilentModeEvent { get { return (TCPIP_SILENT_MODE_EVENT)GetInt32At(HostOffset(4, 1)); } }
        public Address Context { get { return GetAddressAt(HostOffset(8, 1)); } }

        #region Private
        internal TcpipSilentModeArgs(Action<TcpipSilentModeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipSilentModeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SilentModeEvent", SilentModeEvent);
            XmlAttribHex(sb, "Context", Context);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SilentModeEvent", "Context" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SilentModeEvent;
                case 2:
                    return Context;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipSilentModeArgs> m_target;
        #endregion
    }
    public sealed class TcpipTransportPacketDropsArgs : TraceEvent
    {
        public int IPTransportProtocol { get { return GetInt32At(0); } }
        public int AddressFamily { get { return GetInt32At(4); } }
        public int LocalSockAddrLength { get { return GetInt32At(8); } }
        public byte[] LocalSockAddr { get { return GetByteArrayAt(12, LocalSockAddrLength); } }
        public int RemoteSockAddrLength { get { return GetInt32At(0 + (LocalSockAddrLength * 1) + 12); } }
        public byte[] RemoteSockAddr { get { return GetByteArrayAt(0 + (LocalSockAddrLength * 1) + 16, RemoteSockAddrLength); } }
        public int Reason { get { return GetInt32At(0 + (RemoteSockAddrLength * 1) + (LocalSockAddrLength * 1) + 16); } }
        public int PacketCount { get { return GetInt32At(0 + (RemoteSockAddrLength * 1) + (LocalSockAddrLength * 1) + 20); } }

        #region Private
        internal TcpipTransportPacketDropsArgs(Action<TcpipTransportPacketDropsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 0 + (RemoteSockAddrLength * 1) + (LocalSockAddrLength * 1) + 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 0 + (RemoteSockAddrLength * 1) + (LocalSockAddrLength * 1) + 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipTransportPacketDropsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IPTransportProtocol", IPTransportProtocol);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            XmlAttrib(sb, "LocalSockAddrLength", LocalSockAddrLength);
            XmlAttrib(sb, "RemoteSockAddrLength", RemoteSockAddrLength);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "PacketCount", PacketCount);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IPTransportProtocol", "AddressFamily", "LocalSockAddrLength", "LocalSockAddr", "RemoteSockAddrLength", "RemoteSockAddr", "Reason", "PacketCount" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IPTransportProtocol;
                case 1:
                    return AddressFamily;
                case 2:
                    return LocalSockAddrLength;
                case 3:
                    return RemoteSockAddrLength;
                case 4:
                    return Reason;
                case 5:
                    return PacketCount;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipTransportPacketDropsArgs> m_target;
        #endregion
    }
    public sealed class TcpipUpdateInterfaceConfigFlagsArgs : TraceEvent
    {
        public int InterfaceIndex { get { return GetInt32At(0); } }
        public string Property { get { return GetUTF8StringAt(4); } }
        public int Value { get { return GetInt32At(SkipUTF8String(4)); } }
        public int InterfaceUpdateEvent { get { return GetInt32At(SkipUTF8String(4) + 4); } }

        #region Private
        internal TcpipUpdateInterfaceConfigFlagsArgs(Action<TcpipUpdateInterfaceConfigFlagsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUTF8String(4) + 8));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUTF8String(4) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipUpdateInterfaceConfigFlagsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "InterfaceIndex", InterfaceIndex);
            XmlAttrib(sb, "Property", Property);
            XmlAttrib(sb, "Value", Value);
            XmlAttrib(sb, "InterfaceUpdateEvent", InterfaceUpdateEvent);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "InterfaceIndex", "Property", "Value", "InterfaceUpdateEvent" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return InterfaceIndex;
                case 1:
                    return Property;
                case 2:
                    return Value;
                case 3:
                    return InterfaceUpdateEvent;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipUpdateInterfaceConfigFlagsArgs> m_target;
        #endregion
    }
    public sealed class TcpipWakePacketIndicatedArgs : TraceEvent
    {
        public long AdapterLuid { get { return GetInt64At(0); } }
        public string PatternFriendlyName { get { return GetUnicodeStringAt(8); } }
        public int DlAddrLength { get { return GetInt32At(SkipUnicodeString(8)); } }
        public byte[] SrcDLAddress { get { return GetByteArrayAt(SkipUnicodeString(8) + 4, DlAddrLength); } }
        public byte[] DestDLAddress { get { return GetByteArrayAt(SkipUnicodeString(8) + 4, DlAddrLength); } }
        public int SrcAddress { get { return GetInt32At(SkipUnicodeString(8) + 4); } }
        public int DestAddress { get { return GetInt32At(SkipUnicodeString(8) + 8); } }
        public int Protocol { get { return GetInt32At(SkipUnicodeString(8) + 12); } }
        public int SrcPort { get { return GetInt16At(SkipUnicodeString(8) + 16); } }
        public int DestPort { get { return GetInt16At(SkipUnicodeString(8) + 18); } }

        #region Private
        internal TcpipWakePacketIndicatedArgs(Action<TcpipWakePacketIndicatedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8) + 20));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8) + 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipWakePacketIndicatedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterLuid", AdapterLuid);
            XmlAttrib(sb, "PatternFriendlyName", PatternFriendlyName);
            XmlAttrib(sb, "DlAddrLength", DlAddrLength);
            XmlAttrib(sb, "SrcAddress", SrcAddress);
            XmlAttrib(sb, "DestAddress", DestAddress);
            XmlAttrib(sb, "Protocol", Protocol);
            XmlAttrib(sb, "SrcPort", SrcPort);
            XmlAttrib(sb, "DestPort", DestPort);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterLuid", "PatternFriendlyName", "DlAddrLength", "SrcDLAddress", "DestDLAddress", "SrcAddress", "DestAddress", "Protocol", "SrcPort", "DestPort" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterLuid;
                case 1:
                    return PatternFriendlyName;
                case 2:
                    return DlAddrLength;
                case 3:
                    return SrcAddress;
                case 4:
                    return DestAddress;
                case 5:
                    return Protocol;
                case 6:
                    return SrcPort;
                case 7:
                    return DestPort;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipWakePacketIndicatedArgs> m_target;
        #endregion
    }
    public sealed class TcpipWakePacketIndicated1303Args : TraceEvent
    {
        public long AdapterLuid { get { return GetInt64At(0); } }
        public string PatternFriendlyName { get { return GetUnicodeStringAt(8); } }
        public int DlAddrLength { get { return GetInt32At(SkipUnicodeString(8)); } }
        public byte[] SrcDLAddress { get { return GetByteArrayAt(SkipUnicodeString(8) + 4, DlAddrLength); } }
        public byte[] DestDLAddress { get { return GetByteArrayAt(SkipUnicodeString(8) + 4, DlAddrLength); } }
        public int IpAddrLength { get { return GetInt32At(SkipUnicodeString(8) + 4); } }
        public byte[] SrcAddress { get { return GetByteArrayAt(SkipUnicodeString(8) + 8, IpAddrLength); } }
        public byte[] DestAddress { get { return GetByteArrayAt(SkipUnicodeString(8) + 8, IpAddrLength); } }
        public int Protocol { get { return GetInt32At(SkipUnicodeString(8) + 8); } }
        public int SrcPort { get { return GetInt16At(SkipUnicodeString(8) + 12); } }
        public int DestPort { get { return GetInt16At(SkipUnicodeString(8) + 14); } }

        #region Private
        internal TcpipWakePacketIndicated1303Args(Action<TcpipWakePacketIndicated1303Args> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(8) + 16));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(8) + 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpipWakePacketIndicated1303Args>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AdapterLuid", AdapterLuid);
            XmlAttrib(sb, "PatternFriendlyName", PatternFriendlyName);
            XmlAttrib(sb, "DlAddrLength", DlAddrLength);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "Protocol", Protocol);
            XmlAttrib(sb, "SrcPort", SrcPort);
            XmlAttrib(sb, "DestPort", DestPort);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AdapterLuid", "PatternFriendlyName", "DlAddrLength", "SrcDLAddress", "DestDLAddress", "IpAddrLength", "SrcAddress", "DestAddress", "Protocol", "SrcPort", "DestPort" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AdapterLuid;
                case 1:
                    return PatternFriendlyName;
                case 2:
                    return DlAddrLength;
                case 3:
                    return IpAddrLength;
                case 4:
                    return Protocol;
                case 5:
                    return SrcPort;
                case 6:
                    return DestPort;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpipWakePacketIndicated1303Args> m_target;
        #endregion
    }
    public sealed class TcpIsPatternCoalescingRequiredArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int RequireAddressCoalescing { get { return GetInt32At(HostOffset(4, 1)); } }
        public int LocalPort { get { return GetInt16At(HostOffset(8, 1)); } }
        public int RtcStartPort { get { return GetInt16At(HostOffset(10, 1)); } }
        public int RtcEndPort { get { return GetInt16At(HostOffset(12, 1)); } }
        public int Status { get { return GetInt32At(HostOffset(14, 1)); } }

        #region Private
        internal TcpIsPatternCoalescingRequiredArgs(Action<TcpIsPatternCoalescingRequiredArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(18, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(18, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpIsPatternCoalescingRequiredArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "RequireAddressCoalescing", RequireAddressCoalescing);
            XmlAttrib(sb, "LocalPort", LocalPort);
            XmlAttrib(sb, "RtcStartPort", RtcStartPort);
            XmlAttrib(sb, "RtcEndPort", RtcEndPort);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "RequireAddressCoalescing", "LocalPort", "RtcStartPort", "RtcEndPort", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return RequireAddressCoalescing;
                case 2:
                    return LocalPort;
                case 3:
                    return RtcStartPort;
                case 4:
                    return RtcEndPort;
                case 5:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpIsPatternCoalescingRequiredArgs> m_target;
        #endregion
    }
    public sealed class TcpListenerActivationFailedAfArgs : TraceEvent
    {
        public Address Listener { get { return GetAddressAt(0); } }
        public int AddressLength { get { return GetInt32At(HostOffset(4, 1)); } }
        public byte[] SocketAddress { get { return GetByteArrayAt(HostOffset(8, 1), AddressLength); } }
        public int Status { get { return GetInt32At(HostOffset(0 + (AddressLength * 1) + 8, 1)); } }
        public int ProcessId { get { return GetInt32At(HostOffset(0 + (AddressLength * 1) + 12, 1)); } }
        public int CompartmentId { get { return GetInt32At(HostOffset(0 + (AddressLength * 1) + 16, 1)); } }
        public int AddressFamily { get { return GetInt32At(HostOffset(0 + (AddressLength * 1) + 20, 1)); } }

        #region Private
        internal TcpListenerActivationFailedAfArgs(Action<TcpListenerActivationFailedAfArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (AddressLength * 1) + 24, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (AddressLength * 1) + 24, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpListenerActivationFailedAfArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Listener", Listener);
            XmlAttrib(sb, "AddressLength", AddressLength);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "ProcessId", ProcessId);
            XmlAttrib(sb, "CompartmentId", CompartmentId);
            XmlAttrib(sb, "AddressFamily", AddressFamily);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Listener", "AddressLength", "SocketAddress", "Status", "ProcessId", "CompartmentId", "AddressFamily" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Listener;
                case 1:
                    return AddressLength;
                case 2:
                    return Status;
                case 3:
                    return ProcessId;
                case 4:
                    return CompartmentId;
                case 5:
                    return AddressFamily;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpListenerActivationFailedAfArgs> m_target;
        #endregion
    }
    public sealed class TcpLoopbackFastPathFailReasonArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public TCPIP_LOOPBACK_FASTPATH_FAIL_REASON Cause { get { return (TCPIP_LOOPBACK_FASTPATH_FAIL_REASON)GetInt32At(HostOffset(4, 1)); } }

        #region Private
        internal TcpLoopbackFastPathFailReasonArgs(Action<TcpLoopbackFastPathFailReasonArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpLoopbackFastPathFailReasonArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Cause", Cause);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Cause" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Cause;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpLoopbackFastPathFailReasonArgs> m_target;
        #endregion
    }
    public sealed class TcpLossRecoverySackEntryArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int SndUna { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SndMax { get { return GetInt32At(HostOffset(8, 1)); } }
        public string Reason { get { return GetUnicodeStringAt(HostOffset(12, 1)); } }
        public TCPIP_BOOLEAN IsSack { get { return (TCPIP_BOOLEAN)GetInt32At(SkipUnicodeString(HostOffset(12, 1))); } }

        #region Private
        internal TcpLossRecoverySackEntryArgs(Action<TcpLossRecoverySackEntryArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(12, 1)) + 4));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(12, 1)) + 4));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpLossRecoverySackEntryArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SndUna", SndUna);
            XmlAttrib(sb, "SndMax", SndMax);
            XmlAttrib(sb, "Reason", Reason);
            XmlAttrib(sb, "IsSack", IsSack);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SndUna", "SndMax", "Reason", "IsSack" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SndUna;
                case 2:
                    return SndMax;
                case 3:
                    return Reason;
                case 4:
                    return IsSack;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpLossRecoverySackEntryArgs> m_target;
        #endregion
    }
    public sealed class TcpLsoArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int BytesInSegment { get { return GetInt32At(HostOffset(4, 1)); } }
        public int BytesRemaining { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal TcpLsoArgs(Action<TcpLsoArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpLsoArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "BytesInSegment", BytesInSegment);
            XmlAttrib(sb, "BytesRemaining", BytesRemaining);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "BytesInSegment", "BytesRemaining" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return BytesInSegment;
                case 2:
                    return BytesRemaining;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpLsoArgs> m_target;
        #endregion
    }
    public sealed class TcpMemoryFailuresArgs : TraceEvent
    {
        public string AllocationObjectString { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal TcpMemoryFailuresArgs(Action<TcpMemoryFailuresArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpMemoryFailuresArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AllocationObjectString", AllocationObjectString);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AllocationObjectString" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AllocationObjectString;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpMemoryFailuresArgs> m_target;
        #endregion
    }
    public sealed class TcpModuleStartedArgs : TraceEvent
    {
        public string ModuleNameString { get { return GetUnicodeStringAt(0); } }

        #region Private
        internal TcpModuleStartedArgs(Action<TcpModuleStartedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(0)));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(0)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpModuleStartedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "ModuleNameString", ModuleNameString);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "ModuleNameString" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return ModuleNameString;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpModuleStartedArgs> m_target;
        #endregion
    }
    public sealed class TcpMppNppEvaluationArgs : TraceEvent
    {
        public int PhysicalPages { get { return GetInt32At(0); } }
        public int NonPagedPoolPages { get { return GetInt32At(4); } }
        public int CurrentWatermark { get { return GetInt32At(8); } }
        public int PeakWatermark { get { return GetInt32At(12); } }
        public int HighWatermark { get { return GetInt32At(16); } }
        public int LowWatermark { get { return GetInt32At(20); } }

        #region Private
        internal TcpMppNppEvaluationArgs(Action<TcpMppNppEvaluationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 24));
            Debug.Assert(!(Version > 0 && EventDataLength < 24));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpMppNppEvaluationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "PhysicalPages", PhysicalPages);
            XmlAttrib(sb, "NonPagedPoolPages", NonPagedPoolPages);
            XmlAttrib(sb, "CurrentWatermark", CurrentWatermark);
            XmlAttrib(sb, "PeakWatermark", PeakWatermark);
            XmlAttrib(sb, "HighWatermark", HighWatermark);
            XmlAttrib(sb, "LowWatermark", LowWatermark);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "PhysicalPages", "NonPagedPoolPages", "CurrentWatermark", "PeakWatermark", "HighWatermark", "LowWatermark" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return PhysicalPages;
                case 1:
                    return NonPagedPoolPages;
                case 2:
                    return CurrentWatermark;
                case 3:
                    return PeakWatermark;
                case 4:
                    return HighWatermark;
                case 5:
                    return LowWatermark;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpMppNppEvaluationArgs> m_target;
        #endregion
    }
    public sealed class TcpMppStartEpisodeArgs : TraceEvent
    {
        public int LowNppEventState { get { return GetInt32At(0); } }
        public int HighNppEventState { get { return GetInt32At(4); } }
        public long EpisodeStartTick { get { return GetInt64At(8); } }
        public long EpisodeStopTick { get { return GetInt64At(16); } }
        public int CurrentWatermark { get { return GetInt32At(24); } }
        public int LowWatermark { get { return GetInt32At(28); } }
        public int ReentryWatermark { get { return GetInt32At(32); } }

        #region Private
        internal TcpMppStartEpisodeArgs(Action<TcpMppStartEpisodeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 36));
            Debug.Assert(!(Version > 0 && EventDataLength < 36));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpMppStartEpisodeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "LowNppEventState", LowNppEventState);
            XmlAttrib(sb, "HighNppEventState", HighNppEventState);
            XmlAttrib(sb, "EpisodeStartTick", EpisodeStartTick);
            XmlAttrib(sb, "EpisodeStopTick", EpisodeStopTick);
            XmlAttrib(sb, "CurrentWatermark", CurrentWatermark);
            XmlAttrib(sb, "LowWatermark", LowWatermark);
            XmlAttrib(sb, "ReentryWatermark", ReentryWatermark);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "LowNppEventState", "HighNppEventState", "EpisodeStartTick", "EpisodeStopTick", "CurrentWatermark", "LowWatermark", "ReentryWatermark" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return LowNppEventState;
                case 1:
                    return HighNppEventState;
                case 2:
                    return EpisodeStartTick;
                case 3:
                    return EpisodeStopTick;
                case 4:
                    return CurrentWatermark;
                case 5:
                    return LowWatermark;
                case 6:
                    return ReentryWatermark;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpMppStartEpisodeArgs> m_target;
        #endregion
    }
    public sealed class TcpMppStartEpochArgs : TraceEvent
    {
        public int Epoch { get { return GetInt32At(0); } }
        public int LowNppEventState { get { return GetInt32At(4); } }
        public int HighNppEventState { get { return GetInt32At(8); } }
        public long EpochStartTick { get { return GetInt64At(12); } }
        public long EpochStopTick { get { return GetInt64At(20); } }
        public int OldSynDropRate { get { return GetInt32At(28); } }
        public int NewSynDropRate { get { return GetInt32At(32); } }
        public int OldTcbAbortionRate { get { return GetInt32At(36); } }
        public int NewTcbAbortionRate { get { return GetInt32At(40); } }
        public int CurrentWatermark { get { return GetInt32At(44); } }

        #region Private
        internal TcpMppStartEpochArgs(Action<TcpMppStartEpochArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 48));
            Debug.Assert(!(Version > 0 && EventDataLength < 48));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpMppStartEpochArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Epoch", Epoch);
            XmlAttrib(sb, "LowNppEventState", LowNppEventState);
            XmlAttrib(sb, "HighNppEventState", HighNppEventState);
            XmlAttrib(sb, "EpochStartTick", EpochStartTick);
            XmlAttrib(sb, "EpochStopTick", EpochStopTick);
            XmlAttrib(sb, "OldSynDropRate", OldSynDropRate);
            XmlAttrib(sb, "NewSynDropRate", NewSynDropRate);
            XmlAttrib(sb, "OldTcbAbortionRate", OldTcbAbortionRate);
            XmlAttrib(sb, "NewTcbAbortionRate", NewTcbAbortionRate);
            XmlAttrib(sb, "CurrentWatermark", CurrentWatermark);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Epoch", "LowNppEventState", "HighNppEventState", "EpochStartTick", "EpochStopTick", "OldSynDropRate", "NewSynDropRate", "OldTcbAbortionRate", "NewTcbAbortionRate", "CurrentWatermark" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Epoch;
                case 1:
                    return LowNppEventState;
                case 2:
                    return HighNppEventState;
                case 3:
                    return EpochStartTick;
                case 4:
                    return EpochStopTick;
                case 5:
                    return OldSynDropRate;
                case 6:
                    return NewSynDropRate;
                case 7:
                    return OldTcbAbortionRate;
                case 8:
                    return NewTcbAbortionRate;
                case 9:
                    return CurrentWatermark;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpMppStartEpochArgs> m_target;
        #endregion
    }
    public sealed class TcpMppStopEpisodeArgs : TraceEvent
    {
        public int LowNppEventState { get { return GetInt32At(0); } }
        public int HighNppEventState { get { return GetInt32At(4); } }
        public long EpisodeStartTick { get { return GetInt64At(8); } }
        public long EpisodeStopTick { get { return GetInt64At(16); } }
        public int ReentryWatermark { get { return GetInt32At(24); } }

        #region Private
        internal TcpMppStopEpisodeArgs(Action<TcpMppStopEpisodeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 28));
            Debug.Assert(!(Version > 0 && EventDataLength < 28));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpMppStopEpisodeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "LowNppEventState", LowNppEventState);
            XmlAttrib(sb, "HighNppEventState", HighNppEventState);
            XmlAttrib(sb, "EpisodeStartTick", EpisodeStartTick);
            XmlAttrib(sb, "EpisodeStopTick", EpisodeStopTick);
            XmlAttrib(sb, "ReentryWatermark", ReentryWatermark);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "LowNppEventState", "HighNppEventState", "EpisodeStartTick", "EpisodeStopTick", "ReentryWatermark" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return LowNppEventState;
                case 1:
                    return HighNppEventState;
                case 2:
                    return EpisodeStartTick;
                case 3:
                    return EpisodeStopTick;
                case 4:
                    return ReentryWatermark;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpMppStopEpisodeArgs> m_target;
        #endregion
    }
    public sealed class TcpMppStopEpochArgs : TraceEvent
    {
        public int Epoch { get { return GetInt32At(0); } }
        public int LowNppEventState { get { return GetInt32At(4); } }
        public int HighNppEventState { get { return GetInt32At(8); } }
        public long EpochStartTick { get { return GetInt64At(12); } }
        public long EpochStopTick { get { return GetInt64At(20); } }
        public int SynDropRate { get { return GetInt32At(28); } }
        public int TcbAbortionRate { get { return GetInt32At(32); } }
        public int CurrentWatermark { get { return GetInt32At(36); } }

        #region Private
        internal TcpMppStopEpochArgs(Action<TcpMppStopEpochArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 40));
            Debug.Assert(!(Version > 0 && EventDataLength < 40));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpMppStopEpochArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Epoch", Epoch);
            XmlAttrib(sb, "LowNppEventState", LowNppEventState);
            XmlAttrib(sb, "HighNppEventState", HighNppEventState);
            XmlAttrib(sb, "EpochStartTick", EpochStartTick);
            XmlAttrib(sb, "EpochStopTick", EpochStopTick);
            XmlAttrib(sb, "SynDropRate", SynDropRate);
            XmlAttrib(sb, "TcbAbortionRate", TcbAbortionRate);
            XmlAttrib(sb, "CurrentWatermark", CurrentWatermark);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Epoch", "LowNppEventState", "HighNppEventState", "EpochStartTick", "EpochStopTick", "SynDropRate", "TcbAbortionRate", "CurrentWatermark" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Epoch;
                case 1:
                    return LowNppEventState;
                case 2:
                    return HighNppEventState;
                case 3:
                    return EpochStartTick;
                case 4:
                    return EpochStopTick;
                case 5:
                    return SynDropRate;
                case 6:
                    return TcbAbortionRate;
                case 7:
                    return CurrentWatermark;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpMppStopEpochArgs> m_target;
        #endregion
    }
    public sealed class TcpQueryNotificationChannelStatusRequestArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public Address NcmContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int State { get { return GetInt32At(HostOffset(8, 2)); } }
        public int Pid { get { return GetInt32At(HostOffset(12, 2)); } }
        public int IsLoopback { get { return GetInt32At(HostOffset(16, 2)); } }
        public TCP_NOTIFICATION_CHANNEL_STATUS ChannelStatus { get { return (TCP_NOTIFICATION_CHANNEL_STATUS)GetInt32At(HostOffset(20, 2)); } }
        public int Status { get { return GetInt32At(HostOffset(24, 2)); } }

        #region Private
        internal TcpQueryNotificationChannelStatusRequestArgs(Action<TcpQueryNotificationChannelStatusRequestArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpQueryNotificationChannelStatusRequestArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttribHex(sb, "NcmContext", NcmContext);
            XmlAttrib(sb, "State", State);
            XmlAttrib(sb, "Pid", Pid);
            XmlAttrib(sb, "IsLoopback", IsLoopback);
            XmlAttrib(sb, "ChannelStatus", ChannelStatus);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "NcmContext", "State", "Pid", "IsLoopback", "ChannelStatus", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return NcmContext;
                case 2:
                    return State;
                case 3:
                    return Pid;
                case 4:
                    return IsLoopback;
                case 5:
                    return ChannelStatus;
                case 6:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpQueryNotificationChannelStatusRequestArgs> m_target;
        #endregion
    }
    public sealed class TcpReleaseIndicationArgs : TraceEvent
    {
        public Address NBL { get { return GetAddressAt(0); } }

        #region Private
        internal TcpReleaseIndicationArgs(Action<TcpReleaseIndicationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(4, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(4, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpReleaseIndicationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "NBL", NBL);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "NBL" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return NBL;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpReleaseIndicationArgs> m_target;
        #endregion
    }
    public sealed class TcpRscNblOobInfoArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int CoalescedSegCount { get { return GetInt16At(HostOffset(4, 1)); } }
        public int DupAckCount { get { return GetInt16At(HostOffset(6, 1)); } }
        public int RscTcpTimestampDelta { get { return GetInt32At(HostOffset(8, 1)); } }
        public int HeaderFlags { get { return GetInt16At(HostOffset(12, 1)); } }
        public int EcnCePresent { get { return GetInt32At(HostOffset(14, 1)); } }

        #region Private
        internal TcpRscNblOobInfoArgs(Action<TcpRscNblOobInfoArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(18, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(18, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpRscNblOobInfoArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "CoalescedSegCount", CoalescedSegCount);
            XmlAttrib(sb, "DupAckCount", DupAckCount);
            XmlAttrib(sb, "RscTcpTimestampDelta", RscTcpTimestampDelta);
            XmlAttrib(sb, "HeaderFlags", HeaderFlags);
            XmlAttrib(sb, "EcnCePresent", EcnCePresent);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "CoalescedSegCount", "DupAckCount", "RscTcpTimestampDelta", "HeaderFlags", "EcnCePresent" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return CoalescedSegCount;
                case 2:
                    return DupAckCount;
                case 3:
                    return RscTcpTimestampDelta;
                case 4:
                    return HeaderFlags;
                case 5:
                    return EcnCePresent;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpRscNblOobInfoArgs> m_target;
        #endregion
    }
    public sealed class TcpRssTableChangeArgs : TraceEvent
    {
        public int SourceProcessor { get { return GetInt32At(0); } }
        public int SourceActivity { get { return GetInt32At(4); } }
        public int DestinationProcessor { get { return GetInt32At(8); } }
        public int DestinationActivity { get { return GetInt32At(12); } }
        public int PartitionMovesRemaining { get { return GetInt32At(16); } }
        public int TableEntry { get { return GetByteAt(20); } }

        #region Private
        internal TcpRssTableChangeArgs(Action<TcpRssTableChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 21));
            Debug.Assert(!(Version > 0 && EventDataLength < 21));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpRssTableChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "SourceProcessor", SourceProcessor);
            XmlAttrib(sb, "SourceActivity", SourceActivity);
            XmlAttrib(sb, "DestinationProcessor", DestinationProcessor);
            XmlAttrib(sb, "DestinationActivity", DestinationActivity);
            XmlAttrib(sb, "PartitionMovesRemaining", PartitionMovesRemaining);
            XmlAttrib(sb, "TableEntry", TableEntry);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "SourceProcessor", "SourceActivity", "DestinationProcessor", "DestinationActivity", "PartitionMovesRemaining", "TableEntry" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return SourceProcessor;
                case 1:
                    return SourceActivity;
                case 2:
                    return DestinationProcessor;
                case 3:
                    return DestinationActivity;
                case 4:
                    return PartitionMovesRemaining;
                case 5:
                    return TableEntry;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpRssTableChangeArgs> m_target;
        #endregion
    }
    public sealed class TcpRtcPortRangeAssignmentArgs : TraceEvent
    {
        public int AssignedFromRtcRange { get { return GetInt32At(0); } }
        public int Port { get { return GetInt16At(4); } }

        #region Private
        internal TcpRtcPortRangeAssignmentArgs(Action<TcpRtcPortRangeAssignmentArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 6));
            Debug.Assert(!(Version > 0 && EventDataLength < 6));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpRtcPortRangeAssignmentArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "AssignedFromRtcRange", AssignedFromRtcRange);
            XmlAttrib(sb, "Port", Port);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "AssignedFromRtcRange", "Port" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return AssignedFromRtcRange;
                case 1:
                    return Port;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpRtcPortRangeAssignmentArgs> m_target;
        #endregion
    }
    public sealed class TcpSackUpdateArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int SndUna { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SndMax { get { return GetInt32At(HostOffset(8, 1)); } }
        public int SackCount { get { return GetInt32At(HostOffset(12, 1)); } }
        public int SackBytes { get { return GetInt32At(HostOffset(16, 1)); } }
        public int SackInFlight { get { return GetInt32At(HostOffset(20, 1)); } }
        public int SackIsLost { get { return GetInt32At(HostOffset(24, 1)); } }

        #region Private
        internal TcpSackUpdateArgs(Action<TcpSackUpdateArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpSackUpdateArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SndUna", SndUna);
            XmlAttrib(sb, "SndMax", SndMax);
            XmlAttrib(sb, "SackCount", SackCount);
            XmlAttrib(sb, "SackBytes", SackBytes);
            XmlAttrib(sb, "SackInFlight", SackInFlight);
            XmlAttrib(sb, "SackIsLost", SackIsLost);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SndUna", "SndMax", "SackCount", "SackBytes", "SackInFlight", "SackIsLost" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SndUna;
                case 2:
                    return SndMax;
                case 3:
                    return SackCount;
                case 4:
                    return SackBytes;
                case 5:
                    return SackInFlight;
                case 6:
                    return SackIsLost;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpSackUpdateArgs> m_target;
        #endregion
    }
    public sealed class TcpSendPostedArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public string Injected { get { return GetUnicodeStringAt(HostOffset(4, 1)); } }
        public int NumBytes { get { return GetInt32At(SkipUnicodeString(HostOffset(4, 1))); } }
        public int SndNxt { get { return GetInt32At(SkipUnicodeString(HostOffset(4, 1)) + 4); } }

        #region Private
        internal TcpSendPostedArgs(Action<TcpSendPostedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(4, 1)) + 8));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(4, 1)) + 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpSendPostedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "Injected", Injected);
            XmlAttrib(sb, "NumBytes", NumBytes);
            XmlAttrib(sb, "SndNxt", SndNxt);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "Injected", "NumBytes", "SndNxt" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return Injected;
                case 2:
                    return NumBytes;
                case 3:
                    return SndNxt;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpSendPostedArgs> m_target;
        #endregion
    }
    public sealed class TcpSetTcpOptionArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int OptionType { get { return GetInt32At(HostOffset(4, 1)); } }
        public int SoOptionType { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal TcpSetTcpOptionArgs(Action<TcpSetTcpOptionArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpSetTcpOptionArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "OptionType", OptionType);
            XmlAttrib(sb, "SoOptionType", SoOptionType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "OptionType", "SoOptionType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return OptionType;
                case 2:
                    return SoOptionType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpSetTcpOptionArgs> m_target;
        #endregion
    }
    public sealed class TcpSetTcpSoOptionArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public TCP_OPTION_TYPE OptionType { get { return (TCP_OPTION_TYPE)GetInt32At(HostOffset(4, 1)); } }
        public int SoOptionType { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal TcpSetTcpSoOptionArgs(Action<TcpSetTcpSoOptionArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpSetTcpSoOptionArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "OptionType", OptionType);
            XmlAttrib(sb, "SoOptionType", SoOptionType);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "OptionType", "SoOptionType" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return OptionType;
                case 2:
                    return SoOptionType;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpSetTcpSoOptionArgs> m_target;
        #endregion
    }
    public sealed class TcpSignalNotificationChannelEventArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public Address NcmContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int Pid { get { return GetInt32At(HostOffset(8, 2)); } }
        public int RcvNxt { get { return GetInt32At(HostOffset(12, 2)); } }
        public int Delivered { get { return GetInt32At(HostOffset(16, 2)); } }
        public int Indicated { get { return GetInt32At(HostOffset(20, 2)); } }
        public int FinalEvent { get { return GetInt32At(HostOffset(24, 2)); } }

        #region Private
        internal TcpSignalNotificationChannelEventArgs(Action<TcpSignalNotificationChannelEventArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpSignalNotificationChannelEventArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttribHex(sb, "NcmContext", NcmContext);
            XmlAttrib(sb, "Pid", Pid);
            XmlAttrib(sb, "RcvNxt", RcvNxt);
            XmlAttrib(sb, "Delivered", Delivered);
            XmlAttrib(sb, "Indicated", Indicated);
            XmlAttrib(sb, "FinalEvent", FinalEvent);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "NcmContext", "Pid", "RcvNxt", "Delivered", "Indicated", "FinalEvent" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return NcmContext;
                case 2:
                    return Pid;
                case 3:
                    return RcvNxt;
                case 4:
                    return Delivered;
                case 5:
                    return Indicated;
                case 6:
                    return FinalEvent;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpSignalNotificationChannelEventArgs> m_target;
        #endregion
    }
    public sealed class TcpSrttMeasurementStartedArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int SeqNum { get { return GetInt32At(HostOffset(4, 1)); } }
        public int Tick { get { return GetInt32At(HostOffset(8, 1)); } }
        public int RttSample { get { return GetInt32At(HostOffset(12, 1)); } }
        public int NewSrtt { get { return GetInt32At(HostOffset(16, 1)); } }

        #region Private
        internal TcpSrttMeasurementStartedArgs(Action<TcpSrttMeasurementStartedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(20, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(20, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpSrttMeasurementStartedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "SeqNum", SeqNum);
            XmlAttrib(sb, "Tick", Tick);
            XmlAttrib(sb, "RttSample", RttSample);
            XmlAttrib(sb, "NewSrtt", NewSrtt);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "SeqNum", "Tick", "RttSample", "NewSrtt" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return SeqNum;
                case 2:
                    return Tick;
                case 3:
                    return RttSample;
                case 4:
                    return NewSrtt;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpSrttMeasurementStartedArgs> m_target;
        #endregion
    }
    public sealed class TcpSwsAvoidanceBeginArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int TimerValue { get { return GetInt32At(HostOffset(4, 1)); } }
        public Address BytesToSend { get { return GetAddressAt(HostOffset(8, 1)); } }
        public int SendAvailable { get { return GetInt32At(HostOffset(12, 2)); } }
        public int Cwnd { get { return GetInt32At(HostOffset(16, 2)); } }
        public Address MaxSndWnd { get { return GetAddressAt(HostOffset(20, 2)); } }

        #region Private
        internal TcpSwsAvoidanceBeginArgs(Action<TcpSwsAvoidanceBeginArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(24, 3)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(24, 3)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpSwsAvoidanceBeginArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "TimerValue", TimerValue);
            XmlAttribHex(sb, "BytesToSend", BytesToSend);
            XmlAttrib(sb, "SendAvailable", SendAvailable);
            XmlAttrib(sb, "Cwnd", Cwnd);
            XmlAttribHex(sb, "MaxSndWnd", MaxSndWnd);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "TimerValue", "BytesToSend", "SendAvailable", "Cwnd", "MaxSndWnd" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return TimerValue;
                case 2:
                    return BytesToSend;
                case 3:
                    return SendAvailable;
                case 4:
                    return Cwnd;
                case 5:
                    return MaxSndWnd;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpSwsAvoidanceBeginArgs> m_target;
        #endregion
    }
    public sealed class TcpTcbChangeIsbArgs : TraceEvent
    {
        public int IsbSize { get { return GetInt32At(0); } }
        public int Cwnd { get { return GetInt32At(4); } }
        public int SndWnd { get { return GetInt32At(8); } }
        public int SendAvailable { get { return GetInt32At(12); } }
        public int SSThresh { get { return GetInt32At(16); } }

        #region Private
        internal TcpTcbChangeIsbArgs(Action<TcpTcbChangeIsbArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 20));
            Debug.Assert(!(Version > 0 && EventDataLength < 20));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpTcbChangeIsbArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "IsbSize", IsbSize);
            XmlAttrib(sb, "Cwnd", Cwnd);
            XmlAttrib(sb, "SndWnd", SndWnd);
            XmlAttrib(sb, "SendAvailable", SendAvailable);
            XmlAttrib(sb, "SSThresh", SSThresh);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "IsbSize", "Cwnd", "SndWnd", "SendAvailable", "SSThresh" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return IsbSize;
                case 1:
                    return Cwnd;
                case 2:
                    return SndWnd;
                case 3:
                    return SendAvailable;
                case 4:
                    return SSThresh;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpTcbChangeIsbArgs> m_target;
        #endregion
    }
    public sealed class TcpTcbStopTimerArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int TimerType { get { return GetInt32At(HostOffset(4, 1)); } }
        public int WaitTimeMilliseconds { get { return GetInt32At(HostOffset(8, 1)); } }

        #region Private
        internal TcpTcbStopTimerArgs(Action<TcpTcbStopTimerArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(12, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpTcbStopTimerArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "TimerType", TimerType);
            XmlAttrib(sb, "WaitTimeMilliseconds", WaitTimeMilliseconds);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "TimerType", "WaitTimeMilliseconds" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return TimerType;
                case 2:
                    return WaitTimeMilliseconds;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpTcbStopTimerArgs> m_target;
        #endregion
    }
    public sealed class TcpTcbStartTimerArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public TCP_TIMER_TYPE TimerType { get { if (Version >= 1) { return (TCP_TIMER_TYPE)GetInt32At(HostOffset(4, 1)); } return (TCP_TIMER_TYPE)GetInt32At(HostOffset(4, 1)); } }
        public int WaitTimeMilliseconds { get { return GetInt32At(HostOffset(8, 1)); } }
        public int Processor { get { if (Version >= 1) { return GetInt32At(HostOffset(12, 1)); } return 0; } }
        public long LastInterruptTime { get { if (Version >= 1) { return GetInt64At(HostOffset(16, 1)); } return 0; } }
        public long LastMicroseconds { get { if (Version >= 1) { return GetInt64At(HostOffset(24, 1)); } return 0; } }
        public long CachedKQPCValues { get { if (Version >= 1) { return GetInt64At(HostOffset(32, 1)); } return 0; } }
        public long CachedFrequencyValues { get { if (Version >= 1) { return GetInt64At(HostOffset(40, 1)); } return 0; } }

        #region Private
        internal TcpTcbStartTimerArgs(Action<TcpTcbStartTimerArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(12, 1)));
            Debug.Assert(!(Version == 1 && EventDataLength != HostOffset(48, 1)));
            Debug.Assert(!(Version > 1 && EventDataLength < HostOffset(48, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpTcbStartTimerArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "TimerType", TimerType);
            XmlAttrib(sb, "WaitTimeMilliseconds", WaitTimeMilliseconds);
            XmlAttrib(sb, "Processor", Processor);
            XmlAttrib(sb, "LastInterruptTime", LastInterruptTime);
            XmlAttrib(sb, "LastMicroseconds", LastMicroseconds);
            XmlAttrib(sb, "CachedKQPCValues", CachedKQPCValues);
            XmlAttrib(sb, "CachedFrequencyValues", CachedFrequencyValues);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "TimerType", "WaitTimeMilliseconds", "Processor", "LastInterruptTime", "LastMicroseconds", "CachedKQPCValues", "CachedFrequencyValues" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return TimerType;
                case 2:
                    return WaitTimeMilliseconds;
                case 3:
                    return Processor;
                case 4:
                    return LastInterruptTime;
                case 5:
                    return LastMicroseconds;
                case 6:
                    return CachedKQPCValues;
                case 7:
                    return CachedFrequencyValues;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpTcbStartTimerArgs> m_target;
        #endregion
    }
    public sealed class TcpTcbStateChangeArgs : TraceEvent
    {
        public int OldState { get { return GetInt32At(0); } }
        public int NewState { get { return GetInt32At(4); } }
        public int SndNxt { get { return GetInt32At(8); } }
        public Address Tcb { get { return GetAddressAt(12); } }

        #region Private
        internal TcpTcbStateChangeArgs(Action<TcpTcbStateChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(16, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(16, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpTcbStateChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OldState", OldState);
            XmlAttrib(sb, "NewState", NewState);
            XmlAttrib(sb, "SndNxt", SndNxt);
            XmlAttribHex(sb, "Tcb", Tcb);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OldState", "NewState", "SndNxt", "Tcb" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OldState;
                case 1:
                    return NewState;
                case 2:
                    return SndNxt;
                case 3:
                    return Tcb;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpTcbStateChangeArgs> m_target;
        #endregion
    }
    public sealed class TcpTcbSynSendArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int ISN { get { return GetInt32At(HostOffset(4, 1)); } }
        public int RcvWnd { get { return GetInt32At(HostOffset(8, 1)); } }
        public int RcvWndScale { get { return GetByteAt(HostOffset(12, 1)); } }

        #region Private
        internal TcpTcbSynSendArgs(Action<TcpTcbSynSendArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(13, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(13, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpTcbSynSendArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "ISN", ISN);
            XmlAttrib(sb, "RcvWnd", RcvWnd);
            XmlAttrib(sb, "RcvWndScale", RcvWndScale);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "ISN", "RcvWnd", "RcvWndScale" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return ISN;
                case 2:
                    return RcvWnd;
                case 3:
                    return RcvWndScale;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpTcbSynSendArgs> m_target;
        #endregion
    }
    public sealed class TcpTemplateChangedArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public int TemplateType { get { return GetInt32At(HostOffset(4, 1)); } }
        public string Context { get { return GetUnicodeStringAt(HostOffset(8, 1)); } }

        #region Private
        internal TcpTemplateChangedArgs(Action<TcpTemplateChangedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != SkipUnicodeString(HostOffset(8, 1))));
            Debug.Assert(!(Version > 0 && EventDataLength < SkipUnicodeString(HostOffset(8, 1))));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpTemplateChangedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "TemplateType", TemplateType);
            XmlAttrib(sb, "Context", Context);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "TemplateType", "Context" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return TemplateType;
                case 2:
                    return Context;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpTemplateChangedArgs> m_target;
        #endregion
    }
    public sealed class TcpTemplateParametersArgs : TraceEvent
    {
        public Address Tcb { get { return GetAddressAt(0); } }
        public TCPIP_TEMPLATE_TYPE TemplateType { get { return (TCPIP_TEMPLATE_TYPE)GetInt32At(HostOffset(4, 1)); } }
        public int MinRto { get { return GetInt32At(HostOffset(8, 1)); } }
        public int EnableCwndRestart { get { return GetInt32At(HostOffset(12, 1)); } }
        public int InitialCwnd { get { return GetInt32At(HostOffset(16, 1)); } }
        public TCP_CONGESTION_ALGORITHM CongestionAlgorithm { get { return (TCP_CONGESTION_ALGORITHM)GetInt32At(HostOffset(20, 1)); } }
        public int MaxDataRetransmissions { get { return GetInt32At(HostOffset(24, 1)); } }
        public int DelayedAckTicks { get { return GetInt32At(HostOffset(28, 1)); } }
        public int DelayedAckFrequency { get { return GetInt32At(HostOffset(32, 1)); } }

        #region Private
        internal TcpTemplateParametersArgs(Action<TcpTemplateParametersArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(36, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(36, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpTemplateParametersArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Tcb", Tcb);
            XmlAttrib(sb, "TemplateType", TemplateType);
            XmlAttrib(sb, "MinRto", MinRto);
            XmlAttrib(sb, "EnableCwndRestart", EnableCwndRestart);
            XmlAttrib(sb, "InitialCwnd", InitialCwnd);
            XmlAttrib(sb, "CongestionAlgorithm", CongestionAlgorithm);
            XmlAttrib(sb, "MaxDataRetransmissions", MaxDataRetransmissions);
            XmlAttrib(sb, "DelayedAckTicks", DelayedAckTicks);
            XmlAttrib(sb, "DelayedAckFrequency", DelayedAckFrequency);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Tcb", "TemplateType", "MinRto", "EnableCwndRestart", "InitialCwnd", "CongestionAlgorithm", "MaxDataRetransmissions", "DelayedAckTicks", "DelayedAckFrequency" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Tcb;
                case 1:
                    return TemplateType;
                case 2:
                    return MinRto;
                case 3:
                    return EnableCwndRestart;
                case 4:
                    return InitialCwnd;
                case 5:
                    return CongestionAlgorithm;
                case 6:
                    return MaxDataRetransmissions;
                case 7:
                    return DelayedAckTicks;
                case 8:
                    return DelayedAckFrequency;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpTemplateParametersArgs> m_target;
        #endregion
    }
    public sealed class TcpWsdCacheEntryStateChangeArgs : TraceEvent
    {
        public int TcpWsdEtwPoint { get { return GetInt32At(0); } }
        public int Processor { get { return GetInt32At(4); } }
        public int Entry { get { return GetInt32At(8); } }
        public TCP_WSD_CACHE_ENTRY_STATE OldState { get { return (TCP_WSD_CACHE_ENTRY_STATE)GetInt32At(12); } }
        public int NewState { get { return GetInt32At(16); } }
        public int ProbeCount { get { return GetInt32At(20); } }
        public int ProbeCountWs { get { return GetInt32At(24); } }

        #region Private
        internal TcpWsdCacheEntryStateChangeArgs(Action<TcpWsdCacheEntryStateChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 28));
            Debug.Assert(!(Version > 0 && EventDataLength < 28));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpWsdCacheEntryStateChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TcpWsdEtwPoint", TcpWsdEtwPoint);
            XmlAttrib(sb, "Processor", Processor);
            XmlAttrib(sb, "Entry", Entry);
            XmlAttrib(sb, "OldState", OldState);
            XmlAttrib(sb, "NewState", NewState);
            XmlAttrib(sb, "ProbeCount", ProbeCount);
            XmlAttrib(sb, "ProbeCountWs", ProbeCountWs);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TcpWsdEtwPoint", "Processor", "Entry", "OldState", "NewState", "ProbeCount", "ProbeCountWs" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TcpWsdEtwPoint;
                case 1:
                    return Processor;
                case 2:
                    return Entry;
                case 3:
                    return OldState;
                case 4:
                    return NewState;
                case 5:
                    return ProbeCount;
                case 6:
                    return ProbeCountWs;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpWsdCacheEntryStateChangeArgs> m_target;
        #endregion
    }
    public sealed class TcpWsdInitializationErrorsArgs : TraceEvent
    {
        public TCP_WSD TcpWsdEtwPoint { get { return (TCP_WSD)GetInt32At(0); } }
        public int Status { get { return GetInt32At(4); } }

        #region Private
        internal TcpWsdInitializationErrorsArgs(Action<TcpWsdInitializationErrorsArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpWsdInitializationErrorsArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TcpWsdEtwPoint", TcpWsdEtwPoint);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TcpWsdEtwPoint", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TcpWsdEtwPoint;
                case 1:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpWsdInitializationErrorsArgs> m_target;
        #endregion
    }
    public sealed class TcpWsdInitializationInformationArgs : TraceEvent
    {
        public int TcpWsdEtwPoint { get { return GetInt32At(0); } }
        public int Status { get { return GetInt32At(4); } }

        #region Private
        internal TcpWsdInitializationInformationArgs(Action<TcpWsdInitializationInformationArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 8));
            Debug.Assert(!(Version > 0 && EventDataLength < 8));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpWsdInitializationInformationArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TcpWsdEtwPoint", TcpWsdEtwPoint);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TcpWsdEtwPoint", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TcpWsdEtwPoint;
                case 1:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpWsdInitializationInformationArgs> m_target;
        #endregion
    }
    public sealed class TcpWsdProfileStateChangeArgs : TraceEvent
    {
        public int Profile { get { return GetInt32At(0); } }
        public int State { get { return GetInt32At(4); } }
        public int Qualified { get { return GetInt32At(8); } }
        public int EreQualified { get { return GetInt32At(12); } }

        #region Private
        internal TcpWsdProfileStateChangeArgs(Action<TcpWsdProfileStateChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpWsdProfileStateChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "Profile", Profile);
            XmlAttrib(sb, "State", State);
            XmlAttrib(sb, "Qualified", Qualified);
            XmlAttrib(sb, "EreQualified", EreQualified);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Profile", "State", "Qualified", "EreQualified" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Profile;
                case 1:
                    return State;
                case 2:
                    return Qualified;
                case 3:
                    return EreQualified;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpWsdProfileStateChangeArgs> m_target;
        #endregion
    }
    public sealed class TcpWsdStateChangeArgs : TraceEvent
    {
        public int OldEnabledState { get { return GetInt32At(0); } }
        public int NewEnabledState { get { return GetInt32At(4); } }
        public int OldThreshold { get { return GetInt32At(8); } }
        public int NewThreshold { get { return GetInt32At(12); } }

        #region Private
        internal TcpWsdStateChangeArgs(Action<TcpWsdStateChangeArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != 16));
            Debug.Assert(!(Version > 0 && EventDataLength < 16));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpWsdStateChangeArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "OldEnabledState", OldEnabledState);
            XmlAttrib(sb, "NewEnabledState", NewEnabledState);
            XmlAttrib(sb, "OldThreshold", OldThreshold);
            XmlAttrib(sb, "NewThreshold", NewThreshold);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "OldEnabledState", "NewEnabledState", "OldThreshold", "NewThreshold" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return OldEnabledState;
                case 1:
                    return NewEnabledState;
                case 2:
                    return OldThreshold;
                case 3:
                    return NewThreshold;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpWsdStateChangeArgs> m_target;
        #endregion
    }
    public sealed class TcpWsdWsRestrictedProfileArgs : TraceEvent
    {
        public int TcpWsdEtwPoint { get { return GetInt32At(0); } }
        public Address Tcb { get { return GetAddressAt(4); } }

        #region Private
        internal TcpWsdWsRestrictedProfileArgs(Action<TcpWsdWsRestrictedProfileArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(8, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(8, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<TcpWsdWsRestrictedProfileArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttrib(sb, "TcpWsdEtwPoint", TcpWsdEtwPoint);
            XmlAttribHex(sb, "Tcb", Tcb);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "TcpWsdEtwPoint", "Tcb" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return TcpWsdEtwPoint;
                case 1:
                    return Tcb;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<TcpWsdWsRestrictedProfileArgs> m_target;
        #endregion
    }
    public sealed class UdpCreateNotificationChannelRequestArgs : TraceEvent
    {
        public Address UdpEndpoint { get { return GetAddressAt(0); } }
        public Address NcmContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public UDP_ENDPOINT_STATE Activated { get { return (UDP_ENDPOINT_STATE)GetInt32At(HostOffset(8, 2)); } }
        public int Pid { get { return GetInt32At(HostOffset(12, 2)); } }
        public int IsLoopback { get { return GetInt32At(HostOffset(16, 2)); } }
        public int ChannelStatus { get { return GetInt32At(HostOffset(20, 2)); } }
        public int Status { get { return GetInt32At(HostOffset(24, 2)); } }

        #region Private
        internal UdpCreateNotificationChannelRequestArgs(Action<UdpCreateNotificationChannelRequestArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<UdpCreateNotificationChannelRequestArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "UdpEndpoint", UdpEndpoint);
            XmlAttribHex(sb, "NcmContext", NcmContext);
            XmlAttrib(sb, "Activated", Activated);
            XmlAttrib(sb, "Pid", Pid);
            XmlAttrib(sb, "IsLoopback", IsLoopback);
            XmlAttrib(sb, "ChannelStatus", ChannelStatus);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "UdpEndpoint", "NcmContext", "Activated", "Pid", "IsLoopback", "ChannelStatus", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return UdpEndpoint;
                case 1:
                    return NcmContext;
                case 2:
                    return Activated;
                case 3:
                    return Pid;
                case 4:
                    return IsLoopback;
                case 5:
                    return ChannelStatus;
                case 6:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<UdpCreateNotificationChannelRequestArgs> m_target;
        #endregion
    }
    public sealed class UdpCreateNotificationChannelRequestProcessedArgs : TraceEvent
    {
        public Address UdpEndpoint { get { return GetAddressAt(0); } }
        public Address NcmContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int Pid { get { return GetInt32At(HostOffset(8, 2)); } }
        public int Status { get { return GetInt32At(HostOffset(12, 2)); } }
        public Guid PushNotificationGuid { get { return GetGuidAt(HostOffset(16, 2)); } }

        #region Private
        internal UdpCreateNotificationChannelRequestProcessedArgs(Action<UdpCreateNotificationChannelRequestProcessedArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(32, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(32, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<UdpCreateNotificationChannelRequestProcessedArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "UdpEndpoint", UdpEndpoint);
            XmlAttribHex(sb, "NcmContext", NcmContext);
            XmlAttrib(sb, "Pid", Pid);
            XmlAttrib(sb, "Status", Status);
            XmlAttrib(sb, "PushNotificationGuid", PushNotificationGuid);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "UdpEndpoint", "NcmContext", "Pid", "Status", "PushNotificationGuid" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return UdpEndpoint;
                case 1:
                    return NcmContext;
                case 2:
                    return Pid;
                case 3:
                    return Status;
                case 4:
                    return PushNotificationGuid;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<UdpCreateNotificationChannelRequestProcessedArgs> m_target;
        #endregion
    }
    public sealed class UdpCreateNotificationChannelRequestProcessingArgs : TraceEvent
    {
        public Address UdpEndpoint { get { return GetAddressAt(0); } }
        public int IpAddrLength { get { return GetInt32At(HostOffset(4, 1)); } }
        public int LocalIPv4Address { get { return GetInt32At(HostOffset(8, 1)); } }
        public byte[] LocalIPv6Address { get { return GetByteArrayAt(HostOffset(12, 1), IpAddrLength); } }
        public int IPProtocol { get { return GetInt32At(HostOffset(0 + (IpAddrLength * 1) + 12, 1)); } }
        public int SrcPort { get { return GetInt16At(HostOffset(0 + (IpAddrLength * 1) + 16, 1)); } }

        #region Private
        internal UdpCreateNotificationChannelRequestProcessingArgs(Action<UdpCreateNotificationChannelRequestProcessingArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (IpAddrLength * 1) + 18, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (IpAddrLength * 1) + 18, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<UdpCreateNotificationChannelRequestProcessingArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "UdpEndpoint", UdpEndpoint);
            XmlAttrib(sb, "IpAddrLength", IpAddrLength);
            XmlAttrib(sb, "LocalIPv4Address", LocalIPv4Address);
            XmlAttrib(sb, "IPProtocol", IPProtocol);
            XmlAttrib(sb, "SrcPort", SrcPort);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "UdpEndpoint", "IpAddrLength", "LocalIPv4Address", "LocalIPv6Address", "IPProtocol", "SrcPort" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return UdpEndpoint;
                case 1:
                    return IpAddrLength;
                case 2:
                    return LocalIPv4Address;
                case 3:
                    return IPProtocol;
                case 4:
                    return SrcPort;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<UdpCreateNotificationChannelRequestProcessingArgs> m_target;
        #endregion
    }
    public sealed class UdpQueryNotificationChannelStatusRequestArgs : TraceEvent
    {
        public Address UdpEndpoint { get { return GetAddressAt(0); } }
        public Address NcmContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int Activated { get { return GetInt32At(HostOffset(8, 2)); } }
        public int Pid { get { return GetInt32At(HostOffset(12, 2)); } }
        public int IsLoopback { get { return GetInt32At(HostOffset(16, 2)); } }
        public int ChannelStatus { get { return GetInt32At(HostOffset(20, 2)); } }
        public int Status { get { return GetInt32At(HostOffset(24, 2)); } }

        #region Private
        internal UdpQueryNotificationChannelStatusRequestArgs(Action<UdpQueryNotificationChannelStatusRequestArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(28, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(28, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<UdpQueryNotificationChannelStatusRequestArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "UdpEndpoint", UdpEndpoint);
            XmlAttribHex(sb, "NcmContext", NcmContext);
            XmlAttrib(sb, "Activated", Activated);
            XmlAttrib(sb, "Pid", Pid);
            XmlAttrib(sb, "IsLoopback", IsLoopback);
            XmlAttrib(sb, "ChannelStatus", ChannelStatus);
            XmlAttrib(sb, "Status", Status);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "UdpEndpoint", "NcmContext", "Activated", "Pid", "IsLoopback", "ChannelStatus", "Status" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return UdpEndpoint;
                case 1:
                    return NcmContext;
                case 2:
                    return Activated;
                case 3:
                    return Pid;
                case 4:
                    return IsLoopback;
                case 5:
                    return ChannelStatus;
                case 6:
                    return Status;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<UdpQueryNotificationChannelStatusRequestArgs> m_target;
        #endregion
    }
    public sealed class UdpEndpointSendMessagesArgs : TraceEvent
    {
        public Address Endpoint { get { return GetAddressAt(0); } }
        public int NumMessages { get { return GetInt32At(HostOffset(4, 1)); } }
        public int NumBytes { get { return GetInt32At(HostOffset(8, 1)); } }
        public int LocalSockAddrLength { get { return GetInt32At(HostOffset(12, 1)); } }
        public byte[] LocalSockAddr { get { return GetByteArrayAt(HostOffset(16, 1), LocalSockAddrLength); } }
        public int RemoteSockAddrLength { get { return GetInt32At(HostOffset(0 + (LocalSockAddrLength * 1) + 16, 1)); } }
        public byte[] RemoteSockAddr { get { return GetByteArrayAt(HostOffset(0 + (LocalSockAddrLength * 1) + 20, 1), RemoteSockAddrLength); } }
        public int Pid { get { return GetInt32At(HostOffset(0 + (RemoteSockAddrLength * 1) + (LocalSockAddrLength * 1) + 20, 1)); } }

        #region Private
        internal UdpEndpointSendMessagesArgs(Action<UdpEndpointSendMessagesArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(0 + (RemoteSockAddrLength * 1) + (LocalSockAddrLength * 1) + 24, 1)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(0 + (RemoteSockAddrLength * 1) + (LocalSockAddrLength * 1) + 24, 1)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<UdpEndpointSendMessagesArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "Endpoint", Endpoint);
            XmlAttrib(sb, "NumMessages", NumMessages);
            XmlAttrib(sb, "NumBytes", NumBytes);
            XmlAttrib(sb, "LocalSockAddrLength", LocalSockAddrLength);
            XmlAttrib(sb, "RemoteSockAddrLength", RemoteSockAddrLength);
            XmlAttrib(sb, "Pid", Pid);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "Endpoint", "NumMessages", "NumBytes", "LocalSockAddrLength", "LocalSockAddr", "RemoteSockAddrLength", "RemoteSockAddr", "Pid" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return Endpoint;
                case 1:
                    return NumMessages;
                case 2:
                    return NumBytes;
                case 3:
                    return LocalSockAddrLength;
                case 4:
                    return RemoteSockAddrLength;
                case 5:
                    return Pid;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<UdpEndpointSendMessagesArgs> m_target;
        #endregion
    }
    public sealed class UdpSignalNotificationChannelEventArgs : TraceEvent
    {
        public Address UdpEndpoint { get { return GetAddressAt(0); } }
        public Address NcmContext { get { return GetAddressAt(HostOffset(4, 1)); } }
        public int Pid { get { return GetInt32At(HostOffset(8, 2)); } }
        public int Delivered { get { return GetInt32At(HostOffset(12, 2)); } }
        public int FinalEvent { get { return GetInt32At(HostOffset(16, 2)); } }

        #region Private
        internal UdpSignalNotificationChannelEventArgs(Action<UdpSignalNotificationChannelEventArgs> target, int eventID, int task, string taskName, Guid taskGuid, int opcode, string opcodeName, Guid providerGuid, string providerName)
            : base(eventID, task, taskName, taskGuid, opcode, opcodeName, providerGuid, providerName)
        {
            m_target = target;
        }
        protected internal override void Dispatch()
        {
            m_target(this);
        }
        protected internal override void Validate()
        {
            Debug.Assert(!(Version == 0 && EventDataLength != HostOffset(20, 2)));
            Debug.Assert(!(Version > 0 && EventDataLength < HostOffset(20, 2)));
        }
        protected internal override Delegate Target
        {
            get { return m_target; }
            set { m_target = (Action<UdpSignalNotificationChannelEventArgs>)value; }
        }
        public override StringBuilder ToXml(StringBuilder sb)
        {
            Prefix(sb);
            XmlAttribHex(sb, "UdpEndpoint", UdpEndpoint);
            XmlAttribHex(sb, "NcmContext", NcmContext);
            XmlAttrib(sb, "Pid", Pid);
            XmlAttrib(sb, "Delivered", Delivered);
            XmlAttrib(sb, "FinalEvent", FinalEvent);
            sb.Append("/>");
            return sb;
        }

        public override string[] PayloadNames
        {
            get
            {
                if (payloadNames == null)
                {
                    payloadNames = new string[] { "UdpEndpoint", "NcmContext", "Pid", "Delivered", "FinalEvent" };
                }

                return payloadNames;
            }
        }

        public override object PayloadValue(int index)
        {
            switch (index)
            {
                case 0:
                    return UdpEndpoint;
                case 1:
                    return NcmContext;
                case 2:
                    return Pid;
                case 3:
                    return Delivered;
                case 4:
                    return FinalEvent;
                default:
                    Debug.Assert(false, "Bad field index");
                    return null;
            }
        }

        private event Action<UdpSignalNotificationChannelEventArgs> m_target;
        #endregion
    }
    public enum TCP_CONGESTION_ALGORITHM
    {
        Default = 0x0,
        NewReno = 0x1,
        CcmCtcp = 0x2,
        CcmDctcp = 0x6,
    }
    public enum TCP_CONNECTION_STATE
    {
        ClosedState = 0x0,
        ListenState = 0x1,
        SynSentState = 0x2,
        SynRcvdState = 0x3,
        EstablishedState = 0x4,
        FinWait1State = 0x5,
        FinWait2State = 0x6,
        CloseWaitState = 0x7,
        ClosingState = 0x8,
        LastAckState = 0x9,
        TimeWaitState = 0xa,
    }
    public enum TCP_NOTIFICATION_CHANNEL_STATUS
    {
        Invalid = 0x0,
        SoftwareSlotAllocated = 0x1,
        HardwareSlotAllocated = 0x2,
        PolicyError = 0x3,
        systemError = 0x4,
    }
    public enum TCP_OPTION_TYPE
    {
        TCP_OFFLOAD_NO_PREFERENCE = 0x0,
        TCP_OFFLOAD_NOT_PREFERRED = 0x1,
        TCP_OFFLOAD_PREFERRED = 0x2,
        TCP_KEEPALIVE = 0x3,
        TCP_MAXSEG = 0x4,
        TCP_MAXRT = 0x5,
        TCP_STDURG = 0x6,
        TCP_NOURG = 0x7,
        TCP_ATMARK = 0x8,
        TCP_NOSYNRETRIES = 0x9,
        TCP_TIMESTAMPS = 0xa,
        TCP_OFFLOAD_PREFERENCE = 0xb,
        TCP_CONGESTION_ALGORITHM = 0xc,
        TCP_DELAY_FIN_ACK = 0xd,
    }
    public enum TCP_REPARTITION_EVENT_TYPE
    {
        ProcessorAdd = 0x0,
        PowerSourceChange = 0x1,
    }
    public enum TCP_TIMER_TYPE
    {
        RetransmitTimer = 0x0,
        ConnectTimer = 0x1,
        DelAckTimer = 0x2,
        PushTimer = 0x3,
        KeepAliveTimer = 0x4,
        DisconnectTimer = 0x5,
        SwsTimer = 0x6,
        ReassemblyRateTimer = 0x7,
        SynOrRstValidationTimer = 0x8,
    }
    public enum TCP_WSD_CACHE_ENTRY_STATE
    {
        Idle = 0x0,
        ProbingWs = 0x1,
        ProbeWait = 0x2,
        ProbingWithoutWs = 0x3,
        RecordWait = 0x4,
        EreQualified = 0x5,
        Qualified = 0x6,
    }
    public enum TCP_WSD
    {
        FailedToAllocateTheWSDCache = 0x0,
        FailureInitializingPnPWorkQueue = 0x1,
        FailedToGetPersistentParameters = 0x2,
        RejectedPersistentParameters = 0x3,
        qualifiedProfile = 0x4,
        qualifiedDestination = 0x5,
        sampleCollectionCompletion = 0x6,
        idleTimeExpiration = 0x7,
        allocation = 0x8,
        newSampleRequest = 0x9,
        configurationChange = 0xa,
    }
    public enum TCPIP_ADDRESS_FAMILY_TYPE
    {
        IPV4 = 0x2,
        IPV6 = 0x17,
    }
    public enum TCPIP_AF
    {
        IPv4 = 0x2,
        IPv6 = 0x17,
    }
    public enum TCPIP_BOOLEAN
    {
        FALSE = 0x0,
        TRUE = 0x1,
    }
    public enum TCPIP_COMPONENT
    {
        IP = 0x0,
        TCP = 0x1,
    }
    public enum TCPIP_IP_DAD_STATE
    {
        NldsInvalid = 0x0,
        NldsTentative = 0x1,
        NldsDuplicate = 0x2,
        NldsDeprecated = 0x3,
    }
    public enum TCPIP_IP_PHYSICALMEDIUM_TYPE
    {
        NdisPhysicalMediumUnspecified = 0x0,
        NdisPhysicalMediumWirelessLan = 0x1,
        NdisPhysicalMediumCableModem = 0x2,
        NdisPhysicalMediumPhoneLine = 0x3,
        NdisPhysicalMediumDSL = 0x5,
        NdisPhysicalMedium1394 = 0x7,
        NdisPhysicalMediumWirelessWan = 0x8,
        NdisPhysicalMediumNative802_11 = 0x9,
        NdisPhysicalMediumBluetooth = 0xa,
        NdisPhysicalMediumInfiniband = 0xb,
        NdisPhysicalMediumWiMax = 0xc,
        NdisPhysicalMedium802_3 = 0xe,
        NdisPhysicalMedium802_5 = 0xf,
        NdisPhysicalMediumIrda = 0x10,
        NdisPhysicalMediumWiredWAN = 0x11,
    }
    public enum TCPIP_LOOPBACK_FASTPATH_FAIL_REASON
    {
        LoopbackFastPathSocketOptionNotSetOnBothEnds = 0x0,
        FilterPolicyExistedForTheLoopbackConnection = 0x1,
    }
    public enum TCPIP_NDKPI_COMPLETION_TYPE
    {
        Async = 0x0,
        Inline = 0x1,
    }
    public enum TCPIP_NDKPI_CQ_ARM_TYPE
    {
        NotifyErrors = 0x0,
        NotifyAny = 0x1,
        NotifySolicited = 0x2,
    }
    public enum TCPIP_NDKPI_OBJECT_TYPE
    {
        Undefined = 0x0,
        Adapter = 0x1,
        QP = 0x2,
        CQ = 0x3,
        MR = 0x4,
        MW = 0x5,
        PD = 0x6,
        SharedEndpoint = 0x7,
        Connector = 0x8,
        Listener = 0x9,
        SRQ = 0xa,
        Max = 0xb,
    }
    public enum TCPIP_NDKPI_OPERATION_TYPE
    {
        Receive = 0x1,
        Send = 0x2,
        FastRegister = 0x4,
        Bind = 0x8,
        Invalidate = 0x10,
        Read = 0x20,
        Write = 0x40,
        ReceiveAndInvalidate = 0x8001,
    }
    public enum TCPIP_NDKPI_SOCKADDR_TYPE
    {
        Local = 0x0,
        Remote = 0x1,
    }
    public enum TCPIP_NDKPI_TOKEN_TYPE
    {
        Local = 0x0,
        Remote = 0x1,
        Privileged = 0x2,
    }
    public enum TCPIP_NEIGHBOR_EVENT
    {
        Map = 0x0,
        Configure = 0x1,
        TlSuspectsReachability = 0x2,
        TlConfirmsReachability = 0x3,
        NaConfirmsReachability = 0x4,
        ProbeReachability = 0x5,
        DadSolicitation = 0x6,
        NewDlAddress = 0x7,
        TriggerNud = 0x8,
        Resolve = 0x9,
        Timeout = 0xa,
        SendingNeighborSolicitation = 0xb,
        ReceivedNeighborSolicitation = 0xc,
        SendingNeighborAdvertisement = 0xd,
        ReceivedNeighborAdvertisement = 0xe,
        SendingRouterSolicitation = 0xf,
        ReceivedRouterSolicitation = 0x10,
        SendingRouterAdvertisement = 0x11,
        ReceivedRouterAdvertisement = 0x12,
    }
    public enum TCPIP_NEIGHBOR_STATE
    {
        Unreachable = 0x0,
        Incomplete = 0x1,
        Probe = 0x2,
        Delay = 0x3,
        Stale = 0x4,
        Reachable = 0x5,
        Permanent = 0x6,
        Maximum = 0x7,
    }
    public enum TCPIP_OFFLOAD_FAILURE_REASON
    {
        NoFailure = 0x0,
        Unknown = 0x1,
        SystemPolicy = 0x2,
        NICCapacityReached = 0x3,
        SystemLowOnMemory = 0x4,
        WFPDriverStreamInspection = 0x5,
        WeakHostModelEnabled = 0x6,
        ForwardingEnabled = 0x7,
        HardwareCapability = 0x8,
        NDISFilterNICProperty = 0x9,
    }
    public enum TCPIP_PROPERTY
    {
        Disabled = 0x0,
        Enabled = 0x1,
    }
    public enum TCPIP_Protocol
    {
        IPv4 = 0x4,
        IPv6 = 0x6,
    }
    public enum TCPIP_RSS_ADDING
    {
        removing = 0x0,
        adding = 0x1,
    }
    public enum TCPIP_RSS_BINDING_CAPABILITY
    {
        notAvailable = 0x0,
        available = 0x1,
        availableOnPorts = 0x2,
    }
    public enum TCPIP_RSS_BINDING_NOTIFICATION
    {
        unbind = 0x0,
        bind = 0x1,
        portChange = 0x2,
    }
    public enum TCPIP_RSS_SETTING_VALUE
    {
        none = 0x3e8,
        receiveHash = 0x3e9,
        receiveScale = 0x3ea,
        enabled = 0x3eb,
        disabled = 0x3ec,
    }
    public enum TCPIP_SILENT_MODE_EVENT
    {
        Enabled = 0x0,
        SendRequestDropped = 0x1,
        ReceiveDropped = 0x2,
        DisconnectRequestDropped = 0x3,
        ResetDropped = 0x4,
    }
    public enum TCPIP_SLOW_PATH_REASON
    {
        IPChecksumOffloadNotComputed = 0x0,
        TCPChecksumOffloadNotComputed = 0x1,
        UDPChecksumOffloadNotComputed = 0x2,
        HeaderNotAlignedOn4byteBoundary = 0x3,
        IPFragmentation = 0x4,
        SourceAddressIsNotUnicast = 0x5,
        DestinationAddressIsNotUnicast = 0x6,
        EthernetAndIPHeaderNotContiguous = 0x7,
        IPOptionsPresent = 0x8,
        ESPOverUDP = 0x9,
        LackContiguousSpaceForUpperLayerHeaders = 0xa,
        WFPFiltersPresent = 0xb,
        NexthopIsUnavailable = 0xc,
        PathHasBeenInvalidatedDueToPolicyChange = 0xd,
        DHCPAssignedIPAddressPromiscuousCountIsNonzero = 0xe,
        ECNCodepointHasNotBeenNegotiatedForThisTraffic = 0xf,
        SessionStateIsNotCompatible = 0x10,
        TCPOptionsPresent = 0x11,
        UDPIPv6ChecksumAbsentInPacket = 0x12,
        PacketIsForALoopbackInterface = 0x13,
    }
    public enum TCPIP_TCP_DELIVERY_STATE
    {
        Indicate = 0x0,
        Pend = 0x1,
        Satisfy = 0x2,
    }
    public enum TCPIP_TEMPLATE_TYPE
    {
        TcpTemplateTypeInternet = 0x0,
        TcpTemplateTypeDatacenter = 0x1,
        TcpTemplateTypeCompat = 0x2,
        TcpTemplateTypeDatacenterCustom = 0x3,
        TcpTemplateTypeInternetCustom = 0x4,
        TcpTemplateTypeDefault = 0x6,
        TcpTemplateTypeAutomatic = 0x7,
    }
    public enum TCPIP_Transport_Protocol
    {
        UnknownHeaderCorruptNotParsed = 0x0,
        ICMP = 0x1,
        IGMP = 0x2,
        TCP = 0x6,
        UDP = 0x11,
        ROUTING = 0x2b,
        FRAGMENT = 0x2c,
        GRE = 0x2f,
        ESP = 0x32,
        AH = 0x33,
        ICMPV6 = 0x3a,
        Unknown = 0x100,
    }
    public enum UDP_ENDPOINT_STATE
    {
        NotActivated = 0x0,
        Activated = 0x1,
    }
}
